import{s as St,o as Bt,n as ce}from"../chunks/scheduler.9bc65507.js";import{S as qt,i as Dt,g as r,s as l,r as m,A as Kt,h as u,f as o,c as i,j as Yt,u as h,x as p,k as Zt,y as Et,a as n,v as f,d as c,t as g,w as y}from"../chunks/index.707bf1b6.js";import{T as fe}from"../chunks/Tip.c2ecdbf4.js";import{C as dt}from"../chunks/CodeBlock.54a9f38d.js";import{H as $}from"../chunks/Heading.342b1fa6.js";function Qt(w){let a,d='If you don’t need long explanations and just want TPU code samples to get started with, check out <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">our TPU example notebook!</a>';return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-tduf4j"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function Ot(w){let a,d="If you can fit all your data in memory as <code>np.ndarray</code> or <code>tf.Tensor</code>, then you can <code>fit()</code> on that data even when using Colab or a TPU Node, without needing to upload it to Google Cloud Storage.";return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1d1yaza"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function eo(w){let a,d="<strong>🤗Specific Hugging Face Tip🤗:</strong> The methods <code>Dataset.to_tf_dataset()</code> and its higher-level wrapper <code>model.prepare_tf_dataset()</code> , which you will see throughout our TF code examples, will both fail on a TPU Node. The reason for this is that even though they create a <code>tf.data.Dataset</code> it is not a “pure” <code>tf.data</code> pipeline and uses <code>tf.numpy_function</code> or <code>Dataset.from_generator()</code> to stream data from the underlying HuggingFace <code>Dataset</code>. This HuggingFace <code>Dataset</code> is backed by data that is on a local disc and which the remote TPU Node will not be able to read.";return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1bprqrc"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function to(w){let a,d="XLA compiled code is usually faster - so even if you’re not planning to run on TPU, adding <code>jit_compile=True</code> can improve your performance. Be sure to note the caveats below about XLA compatibility, though!";return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-kloc09"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function oo(w){let a,d="<strong>Tip born of painful experience:</strong> Although using <code>jit_compile=True</code> is a good way to get a speed boost and test if your CPU/GPU code is XLA-compatible, it can actually cause a lot of problems if you leave it in when actually training on TPU. XLA compilation will happen implicitly on TPU, so remember to remove that line before actually running your code on a TPU!";return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1br5bpw"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function no(w){let a,d="<strong>🤗Specific HuggingFace Tip🤗:</strong> We’ve put a lot of effort into rewriting our TensorFlow models and loss functions to be XLA-compatible. Our models and loss functions generally obey rule #1 and #2 by default, so you can skip over them if you’re using <code>transformers</code> models. Don’t forget about these rules when writing your own models and loss functions, though!";return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1nwr8e5"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function ao(w){let a,d="<strong>🤗Specific HuggingFace Tip🤗:</strong> Our tokenizers and data collators have methods that can help you here. You can use <code>padding=&quot;max_length&quot;</code> or <code>padding=&quot;longest&quot;</code> when calling tokenizers to get them to output padded data. Our tokenizers and data collators also have a <code>pad_to_multiple_of</code> argument that you can use to reduce the number of unique input shapes you see!";return{c(){a=r("p"),a.innerHTML=d},l(s){a=u(s,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1sygm4v"&&(a.innerHTML=d)},m(s,b){n(s,a,b)},p:ce,d(s){s&&o(a)}}}function lo(w){let a,d,s,b,x,ye,T,be,L,we,C,mt="A TPU is a <strong>Tensor Processing Unit.</strong> They are hardware designed by Google, which are used to greatly speed up the tensor computations within neural networks, much like GPUs. They can be used for both network training and inference. They are generally accessed through Google’s cloud services, but small TPUs can also be accessed directly for free through Google Colab and Kaggle Kernels.",$e,H,ht='Because <a href="https://huggingface.co/blog/tensorflow-philosophy" rel="nofollow">all TensorFlow models in 🤗 Transformers are Keras models</a>, most of the methods in this document are generally applicable to TPU training for any Keras model! However, there are a few points that are specific to the HuggingFace ecosystem (hug-o-system?) of Transformers and Datasets, and we’ll make sure to flag them up when we get to them.',Te,A,ve,X,ft="New users are often very confused by the range of TPUs, and the different ways to access them. The first key distinction to understand is the difference between <strong>TPU Nodes</strong> and <strong>TPU VMs.</strong>",Me,z,ct="When you use a <strong>TPU Node</strong>, you are effectively indirectly accessing a remote TPU. You will need a separate VM, which will initialize your network and data pipeline and then forward them to the remote node. When you use a TPU on Google Colab, you are accessing it in the <strong>TPU Node</strong> style.",Ue,j,gt="Using TPU Nodes can have some quite unexpected behaviour for people who aren’t used to them! In particular, because the TPU is located on a physically different system to the machine you’re running your Python code on, your data cannot be local to your machine - any data pipeline that loads from your machine’s internal storage will totally fail! Instead, data must be stored in Google Cloud Storage where your data pipeline can still access it, even when the pipeline is running on the remote TPU node.",Pe,v,_e,M,ke,W,yt="The second way to access a TPU is via a <strong>TPU VM.</strong> When using a TPU VM, you connect directly to the machine that the TPU is attached to, much like training on a GPU VM. TPU VMs are generally easier to work with, particularly when it comes to your data pipeline. All of the above warnings do not apply to TPU VMs!",xe,J,bt='This is an opinionated document, so here’s our opinion: <strong>Avoid using TPU Node if possible.</strong> It is more confusing and more difficult to debug than TPU VMs. It is also likely to be unsupported in future - Google’s latest TPU, TPUv4, can only be accessed as a TPU VM, which suggests that TPU Nodes are increasingly going to become a “legacy” access method. However, we understand that the only free TPU access is on Colab and Kaggle Kernels, which uses TPU Node - so we’ll try to explain how to handle it if you have to! Check the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">TPU example notebook</a> for code samples that explain this in more detail.',Le,F,Ce,N,wt="A single TPU (a v2-8/v3-8/v4-8) runs 8 replicas. TPUs exist in <strong>pods</strong> that can run hundreds or thousands of replicas simultaneously. When you use more than a single TPU but less than a whole pod (for example, a v3-32), your TPU fleet is referred to as a <strong>pod slice.</strong>",He,G,$t="When you access a free TPU via Colab, you generally get a single v2-8 TPU.",Ae,I,Xe,V,Tt="XLA is an optimizing compiler, used by both TensorFlow and JAX. In JAX it is the only compiler, whereas in TensorFlow it is optional (but mandatory on TPU!). The easiest way to enable it when training a Keras model is to pass the argument <code>jit_compile=True</code> to <code>model.compile()</code>. If you don’t get any errors and performance is good, that’s a great sign that you’re ready to move to TPU!",ze,R,vt="Debugging on TPU is generally a bit harder than on CPU/GPU, so we recommend getting your code running on CPU/GPU with XLA first before trying it on TPU. You don’t have to train for long, of course - just for a few steps to make sure that your model and data pipeline are working like you expect them to.",je,U,We,P,Je,Y,Fe,Z,Mt="In many cases, your code is probably XLA-compatible already! However, there are a few things that work in normal TensorFlow that don’t work in XLA. We’ve distilled them into three core rules below:",Ne,_,Ge,S,Ie,B,Ut="What that means is that any <code>if</code> statement cannot depend on values inside a <code>tf.Tensor</code>. For example, this code block cannot be compiled with XLA!",Ve,q,Re,D,Pt='This might seem very restrictive at first, but most neural net code doesn’t need to do this. You can often get around this restriction by using <code>tf.cond</code> (see the documentation <a href="https://www.tensorflow.org/api_docs/python/tf/cond" rel="nofollow">here</a>) or by removing the conditional and finding a clever math trick with indicator variables instead, like so:',Ye,K,Ze,E,_t="This code has exactly the same effect as the code above, but by avoiding a conditional, we ensure it will compile with XLA without problems!",Se,Q,Be,O,kt="What this means is that the shape of all of the <code>tf.Tensor</code> objects in your code cannot depend on their values. For example, the function <code>tf.unique</code> cannot be compiled with XLA, because it returns a <code>tensor</code> containing one instance of each unique value in the input. The shape of this output will obviously be different depending on how repetitive the input <code>Tensor</code> was, and so XLA refuses to handle it!",qe,ee,xt='In general, most neural network code obeys rule #2 by default. However, there are a few common cases where it becomes a problem. One very common one is when you use <strong>label masking</strong>, setting your labels to a negative value to indicate that those positions should be ignored when computing the loss. If you look at NumPy or PyTorch loss functions that support label masking, you will often see code like this that uses <a href="https://numpy.org/doc/stable/user/basics.indexing.html#boolean-array-indexing" rel="nofollow">boolean indexing</a>:',De,te,Ke,oe,Lt="This code is totally fine in NumPy or PyTorch, but it breaks in XLA! Why? Because the shape of <code>masked_outputs</code> and <code>masked_labels</code> depends on how many positions are masked - that makes it a <strong>data-dependent shape.</strong> However, just like for rule #1, we can often rewrite this code to yield exactly the same output without any data-dependent shapes.",Ee,ne,Qe,ae,Ct="Here, we avoid data-dependent shapes by computing the loss for every position, but zeroing out the masked positions in both the numerator and denominator when we calculate the mean, which yields exactly the same result as the first block while maintaining XLA compatibility. Note that we use the same trick as in rule #1 - converting a <code>tf.bool</code> to <code>tf.float32</code> and using it as an indicator variable. This is a really useful trick, so remember it if you need to convert your own code to XLA!",Oe,le,et,ie,Ht="This is the big one. What this means is that if your input shapes are very variable, XLA will have to recompile your model over and over, which will create huge performance problems. This commonly arises in NLP models, where input texts have variable lengths after tokenization. In other modalities, static shapes are more common and this rule is much less of a problem.",tt,se,At="How can you get around rule #3? The key is <strong>padding</strong> - if you pad all your inputs to the same length, and then use an <code>attention_mask</code>, you can get the same results as you’d get from variable shapes, but without any XLA issues. However, excessive padding can cause severe slowdown too - if you pad all your samples to the maximum length in the whole dataset, you might end up with batches consisting endless padding tokens, which will waste a lot of compute and memory!",ot,re,Xt="There isn’t a perfect solution to this problem. However, you can try some tricks. One very useful trick is to <strong>pad batches of samples up to a multiple of a number like 32 or 64 tokens.</strong> This often only increases the number of tokens by a small amount, but it hugely reduces the number of unique input shapes, because every input shape now has to be a multiple of 32 or 64. Fewer unique input shapes means fewer XLA compilations!",nt,k,at,ue,lt,pe,zt='Once your training is XLA-compatible and (if you’re using TPU Node / Colab) your dataset has been prepared appropriately, running on TPU is surprisingly easy! All you really need to change in your code is to add a few lines to initialize your TPU, and to ensure that your model and dataset are created inside a <code>TPUStrategy</code> scope. Take a look at <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">our TPU example notebook</a> to see this in action!',it,de,st,me,jt="There was a lot in here, so let’s summarize with a quick checklist you can follow when you want to get your model ready for TPU training:",rt,he,Wt='<li>Make sure your code follows the three rules of XLA</li> <li>Compile your model with <code>jit_compile=True</code> on CPU/GPU and confirm that you can train it with XLA</li> <li>Either load your dataset into memory or use a TPU-compatible dataset loading approach (see <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">notebook</a>)</li> <li>Migrate your code either to Colab (with accelerator set to “TPU”) or a TPU VM on Google Cloud</li> <li>Add TPU initializer code (see <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">notebook</a>)</li> <li>Create your <code>TPUStrategy</code> and make sure dataset loading and model creation are inside the <code>strategy.scope()</code> (see <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">notebook</a>)</li> <li>Don’t forget to take <code>jit_compile=True</code> out again when you move to TPU!</li> <li>🙏🙏🙏🥺🥺🥺</li> <li>Call model.fit()</li> <li>You did it!</li>',ut,ge,pt;return x=new $({props:{title:"Training on TPU with TensorFlow",local:"training-on-tpu-with-tensorflow",headingTag:"h1"}}),T=new fe({props:{$$slots:{default:[Qt]},$$scope:{ctx:w}}}),L=new $({props:{title:"What is a TPU?",local:"what-is-a-tpu",headingTag:"h3"}}),A=new $({props:{title:"What kinds of TPU are available?",local:"what-kinds-of-tpu-are-available",headingTag:"h3"}}),v=new fe({props:{$$slots:{default:[Ot]},$$scope:{ctx:w}}}),M=new fe({props:{$$slots:{default:[eo]},$$scope:{ctx:w}}}),F=new $({props:{title:"What sizes of TPU are available?",local:"what-sizes-of-tpu-are-available",headingTag:"h3"}}),I=new $({props:{title:"I keep hearing about this XLA thing. What’s XLA, and how does it relate to TPUs?",local:"i-keep-hearing-about-this-xla-thing-whats-xla-and-how-does-it-relate-to-tpus",headingTag:"h3"}}),U=new fe({props:{$$slots:{default:[to]},$$scope:{ctx:w}}}),P=new fe({props:{warning:!0,$$slots:{default:[oo]},$$scope:{ctx:w}}}),Y=new $({props:{title:"How do I make my model XLA compatible?",local:"how-do-i-make-my-model-xla-compatible",headingTag:"h3"}}),_=new fe({props:{$$slots:{default:[no]},$$scope:{ctx:w}}}),S=new $({props:{title:"XLA Rule #1: Your code cannot have “data-dependent conditionals”",local:"xla-rule-1-your-code-cannot-have-data-dependent-conditionals",headingTag:"h4"}}),q=new dt({props:{code:"aWYlMjB0Zi5yZWR1Y2Vfc3VtKHRlbnNvciklMjAlM0UlMjAxMCUzQSUwQSUyMCUyMCUyMCUyMHRlbnNvciUyMCUzRCUyMHRlbnNvciUyMCUyRiUyMDIuMA==",highlighted:`<span class="hljs-keyword">if</span> tf.reduce_sum(tensor) &gt; <span class="hljs-number">10</span>:
    tensor = tensor / <span class="hljs-number">2.0</span>`,wrap:!1}}),K=new dt({props:{code:"c3VtX292ZXJfMTAlMjAlM0QlMjB0Zi5jYXN0KHRmLnJlZHVjZV9zdW0odGVuc29yKSUyMCUzRSUyMDEwJTJDJTIwdGYuZmxvYXQzMiklMEF0ZW5zb3IlMjAlM0QlMjB0ZW5zb3IlMjAlMkYlMjAoMS4wJTIwJTJCJTIwc3VtX292ZXJfMTAp",highlighted:`sum_over_10 = tf.cast(tf.reduce_sum(tensor) &gt; <span class="hljs-number">10</span>, tf.float32)
tensor = tensor / (<span class="hljs-number">1.0</span> + sum_over_10)`,wrap:!1}}),Q=new $({props:{title:"XLA Rule #2: Your code cannot have “data-dependent shapes”",local:"xla-rule-2-your-code-cannot-have-data-dependent-shapes",headingTag:"h4"}}),te=new dt({props:{code:"bGFiZWxfbWFzayUyMCUzRCUyMGxhYmVscyUyMCUzRSUzRCUyMDAlMEFtYXNrZWRfb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMlNUJsYWJlbF9tYXNrJTVEJTBBbWFza2VkX2xhYmVscyUyMCUzRCUyMGxhYmVscyU1QmxhYmVsX21hc2slNUQlMEFsb3NzJTIwJTNEJTIwY29tcHV0ZV9sb3NzKG1hc2tlZF9vdXRwdXRzJTJDJTIwbWFza2VkX2xhYmVscyklMEFtZWFuX2xvc3MlMjAlM0QlMjB0b3JjaC5tZWFuKGxvc3Mp",highlighted:`label_mask = labels &gt;= <span class="hljs-number">0</span>
masked_outputs = outputs[label_mask]
masked_labels = labels[label_mask]
loss = compute_loss(masked_outputs, masked_labels)
mean_loss = torch.mean(loss)`,wrap:!1}}),ne=new dt({props:{code:"bGFiZWxfbWFzayUyMCUzRCUyMHRmLmNhc3QobGFiZWxzJTIwJTNFJTNEJTIwMCUyQyUyMHRmLmZsb2F0MzIpJTBBbG9zcyUyMCUzRCUyMGNvbXB1dGVfbG9zcyhvdXRwdXRzJTJDJTIwbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBsb3NzJTIwKiUyMGxhYmVsX21hc2slMjAlMjAlMjMlMjBTZXQlMjBuZWdhdGl2ZSUyMGxhYmVsJTIwcG9zaXRpb25zJTIwdG8lMjAwJTBBbWVhbl9sb3NzJTIwJTNEJTIwdGYucmVkdWNlX3N1bShsb3NzKSUyMCUyRiUyMHRmLnJlZHVjZV9zdW0obGFiZWxfbWFzayk=",highlighted:`label_mask = tf.cast(labels &gt;= <span class="hljs-number">0</span>, tf.float32)
loss = compute_loss(outputs, labels)
loss = loss * label_mask  <span class="hljs-comment"># Set negative label positions to 0</span>
mean_loss = tf.reduce_sum(loss) / tf.reduce_sum(label_mask)`,wrap:!1}}),le=new $({props:{title:"XLA Rule #3: XLA will need to recompile your model for every different input shape it sees",local:"xla-rule-3-xla-will-need-to-recompile-your-model-for-every-different-input-shape-it-sees",headingTag:"h4"}}),k=new fe({props:{$$slots:{default:[ao]},$$scope:{ctx:w}}}),ue=new $({props:{title:"How do I actually train my model on TPU?",local:"how-do-i-actually-train-my-model-on-tpu",headingTag:"h3"}}),de=new $({props:{title:"Summary",local:"summary",headingTag:"h3"}}),{c(){a=r("meta"),d=l(),s=r("p"),b=l(),m(x.$$.fragment),ye=l(),m(T.$$.fragment),be=l(),m(L.$$.fragment),we=l(),C=r("p"),C.innerHTML=mt,$e=l(),H=r("p"),H.innerHTML=ht,Te=l(),m(A.$$.fragment),ve=l(),X=r("p"),X.innerHTML=ft,Me=l(),z=r("p"),z.innerHTML=ct,Ue=l(),j=r("p"),j.textContent=gt,Pe=l(),m(v.$$.fragment),_e=l(),m(M.$$.fragment),ke=l(),W=r("p"),W.innerHTML=yt,xe=l(),J=r("p"),J.innerHTML=bt,Le=l(),m(F.$$.fragment),Ce=l(),N=r("p"),N.innerHTML=wt,He=l(),G=r("p"),G.textContent=$t,Ae=l(),m(I.$$.fragment),Xe=l(),V=r("p"),V.innerHTML=Tt,ze=l(),R=r("p"),R.textContent=vt,je=l(),m(U.$$.fragment),We=l(),m(P.$$.fragment),Je=l(),m(Y.$$.fragment),Fe=l(),Z=r("p"),Z.textContent=Mt,Ne=l(),m(_.$$.fragment),Ge=l(),m(S.$$.fragment),Ie=l(),B=r("p"),B.innerHTML=Ut,Ve=l(),m(q.$$.fragment),Re=l(),D=r("p"),D.innerHTML=Pt,Ye=l(),m(K.$$.fragment),Ze=l(),E=r("p"),E.textContent=_t,Se=l(),m(Q.$$.fragment),Be=l(),O=r("p"),O.innerHTML=kt,qe=l(),ee=r("p"),ee.innerHTML=xt,De=l(),m(te.$$.fragment),Ke=l(),oe=r("p"),oe.innerHTML=Lt,Ee=l(),m(ne.$$.fragment),Qe=l(),ae=r("p"),ae.innerHTML=Ct,Oe=l(),m(le.$$.fragment),et=l(),ie=r("p"),ie.textContent=Ht,tt=l(),se=r("p"),se.innerHTML=At,ot=l(),re=r("p"),re.innerHTML=Xt,nt=l(),m(k.$$.fragment),at=l(),m(ue.$$.fragment),lt=l(),pe=r("p"),pe.innerHTML=zt,it=l(),m(de.$$.fragment),st=l(),me=r("p"),me.textContent=jt,rt=l(),he=r("ul"),he.innerHTML=Wt,ut=l(),ge=r("p"),this.h()},l(e){const t=Kt("svelte-u9bgzb",document.head);a=u(t,"META",{name:!0,content:!0}),t.forEach(o),d=i(e),s=u(e,"P",{}),Yt(s).forEach(o),b=i(e),h(x.$$.fragment,e),ye=i(e),h(T.$$.fragment,e),be=i(e),h(L.$$.fragment,e),we=i(e),C=u(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-djnvv2"&&(C.innerHTML=mt),$e=i(e),H=u(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1unj2fz"&&(H.innerHTML=ht),Te=i(e),h(A.$$.fragment,e),ve=i(e),X=u(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-6p7mr8"&&(X.innerHTML=ft),Me=i(e),z=u(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1phfib"&&(z.innerHTML=ct),Ue=i(e),j=u(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-soktmv"&&(j.textContent=gt),Pe=i(e),h(v.$$.fragment,e),_e=i(e),h(M.$$.fragment,e),ke=i(e),W=u(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1phs7bc"&&(W.innerHTML=yt),xe=i(e),J=u(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1pt1vxc"&&(J.innerHTML=bt),Le=i(e),h(F.$$.fragment,e),Ce=i(e),N=u(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-16dbnw4"&&(N.innerHTML=wt),He=i(e),G=u(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-f2jblb"&&(G.textContent=$t),Ae=i(e),h(I.$$.fragment,e),Xe=i(e),V=u(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1q4pey4"&&(V.innerHTML=Tt),ze=i(e),R=u(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-h81hqx"&&(R.textContent=vt),je=i(e),h(U.$$.fragment,e),We=i(e),h(P.$$.fragment,e),Je=i(e),h(Y.$$.fragment,e),Fe=i(e),Z=u(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-rvk8af"&&(Z.textContent=Mt),Ne=i(e),h(_.$$.fragment,e),Ge=i(e),h(S.$$.fragment,e),Ie=i(e),B=u(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-xcqbse"&&(B.innerHTML=Ut),Ve=i(e),h(q.$$.fragment,e),Re=i(e),D=u(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1t3ikym"&&(D.innerHTML=Pt),Ye=i(e),h(K.$$.fragment,e),Ze=i(e),E=u(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1iv8hko"&&(E.textContent=_t),Se=i(e),h(Q.$$.fragment,e),Be=i(e),O=u(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-630pck"&&(O.innerHTML=kt),qe=i(e),ee=u(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-johghx"&&(ee.innerHTML=xt),De=i(e),h(te.$$.fragment,e),Ke=i(e),oe=u(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-pihfmb"&&(oe.innerHTML=Lt),Ee=i(e),h(ne.$$.fragment,e),Qe=i(e),ae=u(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-p1xarp"&&(ae.innerHTML=Ct),Oe=i(e),h(le.$$.fragment,e),et=i(e),ie=u(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-feimws"&&(ie.textContent=Ht),tt=i(e),se=u(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1lvuw7u"&&(se.innerHTML=At),ot=i(e),re=u(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-11hm17e"&&(re.innerHTML=Xt),nt=i(e),h(k.$$.fragment,e),at=i(e),h(ue.$$.fragment,e),lt=i(e),pe=u(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1snadym"&&(pe.innerHTML=zt),it=i(e),h(de.$$.fragment,e),st=i(e),me=u(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-d1lrdp"&&(me.textContent=jt),rt=i(e),he=u(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-1qs7tfb"&&(he.innerHTML=Wt),ut=i(e),ge=u(e,"P",{}),Yt(ge).forEach(o),this.h()},h(){Zt(a,"name","hf:doc:metadata"),Zt(a,"content",io)},m(e,t){Et(document.head,a),n(e,d,t),n(e,s,t),n(e,b,t),f(x,e,t),n(e,ye,t),f(T,e,t),n(e,be,t),f(L,e,t),n(e,we,t),n(e,C,t),n(e,$e,t),n(e,H,t),n(e,Te,t),f(A,e,t),n(e,ve,t),n(e,X,t),n(e,Me,t),n(e,z,t),n(e,Ue,t),n(e,j,t),n(e,Pe,t),f(v,e,t),n(e,_e,t),f(M,e,t),n(e,ke,t),n(e,W,t),n(e,xe,t),n(e,J,t),n(e,Le,t),f(F,e,t),n(e,Ce,t),n(e,N,t),n(e,He,t),n(e,G,t),n(e,Ae,t),f(I,e,t),n(e,Xe,t),n(e,V,t),n(e,ze,t),n(e,R,t),n(e,je,t),f(U,e,t),n(e,We,t),f(P,e,t),n(e,Je,t),f(Y,e,t),n(e,Fe,t),n(e,Z,t),n(e,Ne,t),f(_,e,t),n(e,Ge,t),f(S,e,t),n(e,Ie,t),n(e,B,t),n(e,Ve,t),f(q,e,t),n(e,Re,t),n(e,D,t),n(e,Ye,t),f(K,e,t),n(e,Ze,t),n(e,E,t),n(e,Se,t),f(Q,e,t),n(e,Be,t),n(e,O,t),n(e,qe,t),n(e,ee,t),n(e,De,t),f(te,e,t),n(e,Ke,t),n(e,oe,t),n(e,Ee,t),f(ne,e,t),n(e,Qe,t),n(e,ae,t),n(e,Oe,t),f(le,e,t),n(e,et,t),n(e,ie,t),n(e,tt,t),n(e,se,t),n(e,ot,t),n(e,re,t),n(e,nt,t),f(k,e,t),n(e,at,t),f(ue,e,t),n(e,lt,t),n(e,pe,t),n(e,it,t),f(de,e,t),n(e,st,t),n(e,me,t),n(e,rt,t),n(e,he,t),n(e,ut,t),n(e,ge,t),pt=!0},p(e,[t]){const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),T.$set(Jt);const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),v.$set(Ft);const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),M.$set(Nt);const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),U.$set(Gt);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),P.$set(It);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),_.$set(Vt);const Rt={};t&2&&(Rt.$$scope={dirty:t,ctx:e}),k.$set(Rt)},i(e){pt||(c(x.$$.fragment,e),c(T.$$.fragment,e),c(L.$$.fragment,e),c(A.$$.fragment,e),c(v.$$.fragment,e),c(M.$$.fragment,e),c(F.$$.fragment,e),c(I.$$.fragment,e),c(U.$$.fragment,e),c(P.$$.fragment,e),c(Y.$$.fragment,e),c(_.$$.fragment,e),c(S.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(le.$$.fragment,e),c(k.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),pt=!0)},o(e){g(x.$$.fragment,e),g(T.$$.fragment,e),g(L.$$.fragment,e),g(A.$$.fragment,e),g(v.$$.fragment,e),g(M.$$.fragment,e),g(F.$$.fragment,e),g(I.$$.fragment,e),g(U.$$.fragment,e),g(P.$$.fragment,e),g(Y.$$.fragment,e),g(_.$$.fragment,e),g(S.$$.fragment,e),g(q.$$.fragment,e),g(K.$$.fragment,e),g(Q.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(le.$$.fragment,e),g(k.$$.fragment,e),g(ue.$$.fragment,e),g(de.$$.fragment,e),pt=!1},d(e){e&&(o(d),o(s),o(b),o(ye),o(be),o(we),o(C),o($e),o(H),o(Te),o(ve),o(X),o(Me),o(z),o(Ue),o(j),o(Pe),o(_e),o(ke),o(W),o(xe),o(J),o(Le),o(Ce),o(N),o(He),o(G),o(Ae),o(Xe),o(V),o(ze),o(R),o(je),o(We),o(Je),o(Fe),o(Z),o(Ne),o(Ge),o(Ie),o(B),o(Ve),o(Re),o(D),o(Ye),o(Ze),o(E),o(Se),o(Be),o(O),o(qe),o(ee),o(De),o(Ke),o(oe),o(Ee),o(Qe),o(ae),o(Oe),o(et),o(ie),o(tt),o(se),o(ot),o(re),o(nt),o(at),o(lt),o(pe),o(it),o(st),o(me),o(rt),o(he),o(ut),o(ge)),o(a),y(x,e),y(T,e),y(L,e),y(A,e),y(v,e),y(M,e),y(F,e),y(I,e),y(U,e),y(P,e),y(Y,e),y(_,e),y(S,e),y(q,e),y(K,e),y(Q,e),y(te,e),y(ne,e),y(le,e),y(k,e),y(ue,e),y(de,e)}}}const io='{"title":"Training on TPU with TensorFlow","local":"training-on-tpu-with-tensorflow","sections":[{"title":"What is a TPU?","local":"what-is-a-tpu","sections":[],"depth":3},{"title":"What kinds of TPU are available?","local":"what-kinds-of-tpu-are-available","sections":[],"depth":3},{"title":"What sizes of TPU are available?","local":"what-sizes-of-tpu-are-available","sections":[],"depth":3},{"title":"I keep hearing about this XLA thing. What’s XLA, and how does it relate to TPUs?","local":"i-keep-hearing-about-this-xla-thing-whats-xla-and-how-does-it-relate-to-tpus","sections":[],"depth":3},{"title":"How do I make my model XLA compatible?","local":"how-do-i-make-my-model-xla-compatible","sections":[{"title":"XLA Rule #1: Your code cannot have “data-dependent conditionals”","local":"xla-rule-1-your-code-cannot-have-data-dependent-conditionals","sections":[],"depth":4},{"title":"XLA Rule #2: Your code cannot have “data-dependent shapes”","local":"xla-rule-2-your-code-cannot-have-data-dependent-shapes","sections":[],"depth":4},{"title":"XLA Rule #3: XLA will need to recompile your model for every different input shape it sees","local":"xla-rule-3-xla-will-need-to-recompile-your-model-for-every-different-input-shape-it-sees","sections":[],"depth":4}],"depth":3},{"title":"How do I actually train my model on TPU?","local":"how-do-i-actually-train-my-model-on-tpu","sections":[],"depth":3},{"title":"Summary","local":"summary","sections":[],"depth":3}],"depth":1}';function so(w){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fo extends qt{constructor(a){super(),Dt(this,a,so,lo,St,{})}}export{fo as component};
