import{s as Ct,n as It,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as vt,i as Wt,g as p,s as a,r as i,A as Gt,h as m,f as l,c as n,j as $t,u as o,x as c,k as xt,y as kt,a as e,v as r,d as h,t as M,w as g}from"../chunks/index.c9837788.js";import{C as E}from"../chunks/CodeBlock.52fa569e.js";import{H as X}from"../chunks/Heading.3097d2ed.js";function Bt(Mt){let j,A,V,Y,d,H,w,gt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',S,y,jt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',z,J,F,u,dt="To load a pretrained model:",L,f,D,T,wt="To load and preprocess the image:",P,b,q,U,yt="To get the model predictions:",K,$,O,x,Jt="To get the top-5 predictions class names:",tt,C,st,I,ut="Replace the model name with the variant you want to use, e.g. <code>tf_mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",lt,Z,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,v,at,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,G,pt,k,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,B,it,N,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,Q,ct,_,rt,R,ht;return d=new X({props:{title:"(Tensorflow) MixNet",local:"tensorflow-mixnet",headingTag:"h1"}}),J=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new E({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new E({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new E({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new E({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new E({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){j=p("meta"),A=a(),V=p("p"),Y=a(),i(d.$$.fragment),H=a(),w=p("p"),w.innerHTML=gt,S=a(),y=p("p"),y.innerHTML=jt,z=a(),i(J.$$.fragment),F=a(),u=p("p"),u.textContent=dt,L=a(),i(f.$$.fragment),D=a(),T=p("p"),T.textContent=wt,P=a(),i(b.$$.fragment),q=a(),U=p("p"),U.textContent=yt,K=a(),i($.$$.fragment),O=a(),x=p("p"),x.textContent=Jt,tt=a(),i(C.$$.fragment),st=a(),I=p("p"),I.innerHTML=ut,lt=a(),Z=p("p"),Z.innerHTML=ft,et=a(),i(v.$$.fragment),at=a(),W=p("p"),W.textContent=Tt,nt=a(),i(G.$$.fragment),pt=a(),k=p("p"),k.innerHTML=bt,mt=a(),i(B.$$.fragment),it=a(),N=p("p"),N.innerHTML=Ut,ot=a(),i(Q.$$.fragment),ct=a(),i(_.$$.fragment),rt=a(),R=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),A=n(t),V=m(t,"P",{}),$t(V).forEach(l),Y=n(t),o(d.$$.fragment,t),H=n(t),w=m(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-ipcg9j"&&(w.innerHTML=gt),S=n(t),y=m(t,"P",{"data-svelte-h":!0}),c(y)!=="svelte-k8hpf1"&&(y.innerHTML=jt),z=n(t),o(J.$$.fragment,t),F=n(t),u=m(t,"P",{"data-svelte-h":!0}),c(u)!=="svelte-18ywhxh"&&(u.textContent=dt),L=n(t),o(f.$$.fragment,t),D=n(t),T=m(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1c2ipa8"&&(T.textContent=wt),P=n(t),o(b.$$.fragment,t),q=n(t),U=m(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1n9qsq1"&&(U.textContent=yt),K=n(t),o($.$$.fragment,t),O=n(t),x=m(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-19cnvx1"&&(x.textContent=Jt),tt=n(t),o(C.$$.fragment,t),st=n(t),I=m(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-148p09n"&&(I.innerHTML=ut),lt=n(t),Z=m(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=ft),et=n(t),o(v.$$.fragment,t),at=n(t),W=m(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),nt=n(t),o(G.$$.fragment,t),pt=n(t),k=m(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1kguc51"&&(k.innerHTML=bt),mt=n(t),o(B.$$.fragment,t),it=n(t),N=m(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1n0coha"&&(N.innerHTML=Ut),ot=n(t),o(Q.$$.fragment,t),ct=n(t),o(_.$$.fragment,t),rt=n(t),R=m(t,"P",{}),$t(R).forEach(l),this.h()},h(){xt(j,"name","hf:doc:metadata"),xt(j,"content",Nt)},m(t,s){kt(document.head,j),e(t,A,s),e(t,V,s),e(t,Y,s),r(d,t,s),e(t,H,s),e(t,w,s),e(t,S,s),e(t,y,s),e(t,z,s),r(J,t,s),e(t,F,s),e(t,u,s),e(t,L,s),r(f,t,s),e(t,D,s),e(t,T,s),e(t,P,s),r(b,t,s),e(t,q,s),e(t,U,s),e(t,K,s),r($,t,s),e(t,O,s),e(t,x,s),e(t,tt,s),r(C,t,s),e(t,st,s),e(t,I,s),e(t,lt,s),e(t,Z,s),e(t,et,s),r(v,t,s),e(t,at,s),e(t,W,s),e(t,nt,s),r(G,t,s),e(t,pt,s),e(t,k,s),e(t,mt,s),r(B,t,s),e(t,it,s),e(t,N,s),e(t,ot,s),r(Q,t,s),e(t,ct,s),r(_,t,s),e(t,rt,s),e(t,R,s),ht=!0},p:It,i(t){ht||(h(d.$$.fragment,t),h(J.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(v.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(_.$$.fragment,t),ht=!0)},o(t){M(d.$$.fragment,t),M(J.$$.fragment,t),M(f.$$.fragment,t),M(b.$$.fragment,t),M($.$$.fragment,t),M(C.$$.fragment,t),M(v.$$.fragment,t),M(G.$$.fragment,t),M(B.$$.fragment,t),M(Q.$$.fragment,t),M(_.$$.fragment,t),ht=!1},d(t){t&&(l(A),l(V),l(Y),l(H),l(w),l(S),l(y),l(z),l(F),l(u),l(L),l(D),l(T),l(P),l(q),l(U),l(K),l(O),l(x),l(tt),l(st),l(I),l(lt),l(Z),l(et),l(at),l(W),l(nt),l(pt),l(k),l(mt),l(it),l(N),l(ot),l(ct),l(rt),l(R)),l(j),g(d,t),g(J,t),g(f,t),g(b,t),g($,t),g(C,t),g(v,t),g(G,t),g(B,t),g(Q,t),g(_,t)}}}const Nt='{"title":"(Tensorflow) MixNet","local":"tensorflow-mixnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends vt{constructor(j){super(),Wt(this,j,Qt,Bt,Ct,{})}}export{Xt as component};
