import{s as yt,n as wt,o as _t}from"../chunks/scheduler.01eeda35.js";import{S as $t,i as Tt,g as r,s as l,r as o,A as Mt,h as i,f as a,c as n,j as ut,u as c,x as p,k as gt,y as bt,a as s,v as d,d as f,t as h,w as m}from"../chunks/index.6dd51b66.js";import{C as y}from"../chunks/CodeBlock.19ec9b8c.js";import{H as g,E as Ut}from"../chunks/index.58fe8f9d.js";function jt(Ae){let u,ne,se,re,w,ie,_,Ee='<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel (FSDP)</a> is a <a href="./perf_train_gpu_many">parallelism</a> method that combines the advantages of data and model parallelism for distributed training.',pe,$,Ve='Unlike <a href="./perf_train_gpu_many#distributeddataparallel">DistributedDataParallel (DDP)</a>, FSDP saves more memory because it doesn’t replicate a model on each GPU. It shards the models parameters, gradients and optimizer states across GPUs. Each model shard processes a portion of the data and the results are synchronized to speed up training.',oe,T,Qe='This guide covers how to set up training a model with FSDP and <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a>, a library for managing distributed training.',ce,M,de,b,fe,U,qe='Always start by running the <a href="https://hf.co/docs/accelerate/package_reference/cli#accelerate-config" rel="nofollow">accelerate config</a> command to help Accelerate set up the correct distributed training environment.',he,j,me,F,Oe='The section below discusses some of the more important FSDP configuration options. Learn more about other available options in the <a href="https://hf.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments.fsdp_config" rel="nofollow">fsdp_config</a> parameter.',ue,Z,ge,J,Ke="FSDP offers several sharding strategies to distribute a model. Refer to the table below to help you choose the best strategy for your setup. Specify a strategy with the <code>fsdp_sharding_strategy</code> parameter in the configuration file.",ye,v,et="<thead><tr><th>sharding strategy</th> <th>description</th> <th>parameter value</th></tr></thead> <tbody><tr><td><code>FULL_SHARD</code></td> <td>shards model parameters, gradients, and optimizer states</td> <td><code>1</code></td></tr> <tr><td><code>SHARD_GRAD_OP</code></td> <td>shards gradients and optimizer states</td> <td><code>2</code></td></tr> <tr><td><code>NO_SHARD</code></td> <td>don’t shard the model</td> <td><code>3</code></td></tr> <tr><td><code>HYBRID_SHARD</code></td> <td>shards model parameters, gradients, and optimizer states within each GPU</td> <td><code>4</code></td></tr> <tr><td><code>HYBRID_SHARD_ZERO2</code></td> <td>shards gradients and optimizer states within each GPU</td> <td><code>5</code></td></tr></tbody>",we,S,_e,H,tt="Offload model parameters and gradients when they aren’t being used to the CPU to save additional GPU memory. This is useful for scenarios where a model is too large even with FSDP.",$e,C,at="Specify <code>fsdp_offload_params: true</code> in the configuration file to enable offloading.",Te,B,Me,P,st="FSDP is applied by wrapping each layer in the network. The wrapping is usually applied in a nested way where the full weights are discarded after each forward pass to save memory for the next layer.",be,R,lt="There are several wrapping policies available, but the <em>auto wrapping</em> policy is the simplest and doesn’t require any changes to your code. Specify <code>fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP</code> to wrap a Transformer layer and <code>fsdp_transformer_layer_cls_to_wrap</code> to determine which layer to wrap (for example, <code>BertLayer</code>).",Ue,x,nt="Size-based wrapping is also available. If a layer exceeds a certain number of parameters, it is wrapped. Specify <code>fsdp_wrap_policy: SIZED_BASED_WRAP</code> and <code>min_num_param</code> to set the minimum number of parameters for a layer to be wrapped.",je,W,Fe,k,rt="Intermediate checkpoints should be saved as a sharded state dict because saving the full state dict - even with CPU offloading - is time consuming and can cause <code>NCCL Timeout</code> errors due to indefinite hanging during broadcasting.",Ze,N,it='Specify <code>fsdp_state_dict_type: SHARDED_STATE_DICT</code> in the configuration file to save the sharded state dict. Now you can resume training from the sharded state dict with <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state" rel="nofollow">load_state</a>.',Je,L,ve,G,pt="Once training is complete though, you should save the full state dict because the sharded state dict is only compatible with FSDP.",Se,X,He,D,Ce,I,ot='<a href="https://pytorch.org/xla/release/2.1/index.html" rel="nofollow">PyTorch XLA</a>, a package for running PyTorch on XLA devices, enables FSDP on TPUs. Modify the configuration file to include the parameters below. Refer to the <a href="https://github.com/pytorch/xla/blob/2e6e183e0724818f137c8135b34ef273dea33318/torch_xla/distributed/fsdp/xla_fully_sharded_data_parallel.py#L128" rel="nofollow">xla_fsdp_settings</a> parameter for additional XLA-specific parameters you can configure for FSDP.',Be,z,Pe,Y,Re,A,ct='After running <a href="https://hf.co/docs/accelerate/package_reference/cli#accelerate-config" rel="nofollow">accelerate config</a>, your configuration file should be ready. An example configuration file is shown below that fully shards the parameter, gradient and optimizer states on two GPUs. Your file may look different depending on how you set up your configuration.',xe,E,We,V,dt='Run the <a href="https://hf.co/docs/accelerate/package_reference/cli#accelerate-launch" rel="nofollow">accelerate launch</a> command to launch a training script with the FSDP configurations you chose in the configuration file.',ke,Q,Ne,q,ft="It is also possible to directly specify some of the FSDP arguments in the command line.",Le,O,Ge,K,Xe,ee,ht="FSDP is a powerful tool for training large models with fewer GPUs compared to other parallelism strategies. Refer to the following resources below to learn even more about FSDP.",De,te,mt='<li>Follow along with the more in-depth Accelerate guide for <a href="https://hf.co/docs/accelerate/usage_guides/fsdp" rel="nofollow">FSDP</a>.</li> <li>Read the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Introducing PyTorch Fully Sharded Data Parallel (FSDP) API</a> blog post.</li> <li>Read the <a href="https://pytorch.org/blog/scaling-pytorch-models-on-cloud-tpus-with-fsdp/" rel="nofollow">Scaling PyTorch models on Cloud TPUs with FSDP</a> blog post.</li>',Ie,ae,ze,le,Ye;return w=new g({props:{title:"FullyShardedDataParallel",local:"fullyshardeddataparallel",headingTag:"h1"}}),M=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),b=new g({props:{title:"Configuration options",local:"configuration-options",headingTag:"h2"}}),j=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Z=new g({props:{title:"Sharding strategy",local:"sharding-strategy",headingTag:"h3"}}),S=new g({props:{title:"CPU offload",local:"cpu-offload",headingTag:"h3"}}),B=new g({props:{title:"Wrapping policy",local:"wrapping-policy",headingTag:"h3"}}),W=new g({props:{title:"Checkpoints",local:"checkpoints",headingTag:"h3"}}),L=new y({props:{code:"YWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJkaXJlY3RvcnklMkZjb250YWluaW5nJTJGY2hlY2twb2ludHMlMjIp",highlighted:'accelerator.load_state(<span class="hljs-string">&quot;directory/containing/checkpoints&quot;</span>)',wrap:!1}}),X=new y({props:{code:"aWYlMjB0cmFpbmVyLmlzX2ZzZHBfZW5hYmxlZCUzQSUwQSUyMCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4uc2V0X3N0YXRlX2RpY3RfdHlwZSglMjJGVUxMX1NUQVRFX0RJQ1QlMjIpJTBBJTBBdHJhaW5lci5zYXZlX21vZGVsKHNjcmlwdF9hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
  trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)

trainer.save_model(script_args.output_dir)`,wrap:!1}}),D=new g({props:{title:"TPU",local:"tpu",headingTag:"h3"}}),z=new y({props:{code:"eGxhJTNBJTIwVHJ1ZSUyMCUyMyUyMG11c3QlMjBiZSUyMHNldCUyMHRvJTIwVHJ1ZSUyMHRvJTIwZW5hYmxlJTIwUHlUb3JjaCUyRlhMQSUwQXhsYV9mc2RwX3NldHRpbmdzJTNBJTIwJTIzJTIwWExBJTIwc3BlY2lmaWMlMjBGU0RQJTIwcGFyYW1ldGVycyUwQXhsYV9mc2RwX2dyYWRfY2twdCUzQSUyMFRydWUlMjAlMjMlMjBlbmFibGUlMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmc=",highlighted:`<span class="hljs-attr">xla:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># must be set to True to enable PyTorch/XLA</span>
<span class="hljs-attr">xla_fsdp_settings:</span> <span class="hljs-comment"># XLA specific FSDP parameters</span>
<span class="hljs-attr">xla_fsdp_grad_ckpt:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># enable gradient checkpointing</span>`,wrap:!1}}),Y=new g({props:{title:"Training",local:"training",headingTag:"h2"}}),E=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9jcHVfcmFtX2VmZmljaWVudF9sb2FkaW5nJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfZm9yd2FyZF9wcmVmZXRjaCUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMHRydWUlMEElMjAlMjBmc2RwX3NoYXJkaW5nX3N0cmF0ZWd5JTNBJTIwMSUwQSUyMCUyMGZzZHBfc3RhdGVfZGljdF90eXBlJTNBJTIwU0hBUkRFRF9TVEFURV9ESUNUJTBBJTIwJTIwZnNkcF9zeW5jX21vZHVsZV9zdGF0ZXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF90cmFuc2Zvcm1lcl9sYXllcl9jbHNfdG9fd3JhcCUzQSUyMEJlcnRMYXllciUwQSUyMCUyMGZzZHBfdXNlX29yaWdfcGFyYW1zJTNBJTIwdHJ1ZSUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Q=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15LXRyYWluaW5nLXNjcmlwdC5weQ==",highlighted:"accelerate launch my-training-script.py",wrap:!1}}),O=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZnNkcCUzRCUyMmZ1bGwlMjBzaGFyZCUyMiUyMC0tZnNkcF9jb25maWclM0QlMjJwYXRoJTJGdG8lMkZmc2RwX2NvbmZpZyUyRiUyMiUyMG15LXRyYWluaW5nLXNjcmlwdC5weQ==",highlighted:'accelerate launch --fsdp=<span class="hljs-string">&quot;full shard&quot;</span> --fsdp_config=<span class="hljs-string">&quot;path/to/fsdp_config/&quot;</span> my-training-script.py',wrap:!1}}),K=new g({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ae=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/fsdp.md"}}),{c(){u=r("meta"),ne=l(),se=r("p"),re=l(),o(w.$$.fragment),ie=l(),_=r("p"),_.innerHTML=Ee,pe=l(),$=r("p"),$.innerHTML=Ve,oe=l(),T=r("p"),T.innerHTML=Qe,ce=l(),o(M.$$.fragment),de=l(),o(b.$$.fragment),fe=l(),U=r("p"),U.innerHTML=qe,he=l(),o(j.$$.fragment),me=l(),F=r("p"),F.innerHTML=Oe,ue=l(),o(Z.$$.fragment),ge=l(),J=r("p"),J.innerHTML=Ke,ye=l(),v=r("table"),v.innerHTML=et,we=l(),o(S.$$.fragment),_e=l(),H=r("p"),H.textContent=tt,$e=l(),C=r("p"),C.innerHTML=at,Te=l(),o(B.$$.fragment),Me=l(),P=r("p"),P.textContent=st,be=l(),R=r("p"),R.innerHTML=lt,Ue=l(),x=r("p"),x.innerHTML=nt,je=l(),o(W.$$.fragment),Fe=l(),k=r("p"),k.innerHTML=rt,Ze=l(),N=r("p"),N.innerHTML=it,Je=l(),o(L.$$.fragment),ve=l(),G=r("p"),G.textContent=pt,Se=l(),o(X.$$.fragment),He=l(),o(D.$$.fragment),Ce=l(),I=r("p"),I.innerHTML=ot,Be=l(),o(z.$$.fragment),Pe=l(),o(Y.$$.fragment),Re=l(),A=r("p"),A.innerHTML=ct,xe=l(),o(E.$$.fragment),We=l(),V=r("p"),V.innerHTML=dt,ke=l(),o(Q.$$.fragment),Ne=l(),q=r("p"),q.textContent=ft,Le=l(),o(O.$$.fragment),Ge=l(),o(K.$$.fragment),Xe=l(),ee=r("p"),ee.textContent=ht,De=l(),te=r("ul"),te.innerHTML=mt,Ie=l(),o(ae.$$.fragment),ze=l(),le=r("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(a),ne=n(e),se=i(e,"P",{}),ut(se).forEach(a),re=n(e),c(w.$$.fragment,e),ie=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-6pbpg3"&&(_.innerHTML=Ee),pe=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-b4wlre"&&($.innerHTML=Ve),oe=n(e),T=i(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1g27sg0"&&(T.innerHTML=Qe),ce=n(e),c(M.$$.fragment,e),de=n(e),c(b.$$.fragment,e),fe=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1j6aobg"&&(U.innerHTML=qe),he=n(e),c(j.$$.fragment,e),me=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1xrf1ae"&&(F.innerHTML=Oe),ue=n(e),c(Z.$$.fragment,e),ge=n(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-c6ccgj"&&(J.innerHTML=Ke),ye=n(e),v=i(e,"TABLE",{"data-svelte-h":!0}),p(v)!=="svelte-esk3ce"&&(v.innerHTML=et),we=n(e),c(S.$$.fragment,e),_e=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1e6pmac"&&(H.textContent=tt),$e=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-165pau1"&&(C.innerHTML=at),Te=n(e),c(B.$$.fragment,e),Me=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-3xyi4d"&&(P.textContent=st),be=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1tfi551"&&(R.innerHTML=lt),Ue=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1yx7wlo"&&(x.innerHTML=nt),je=n(e),c(W.$$.fragment,e),Fe=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-ad846p"&&(k.innerHTML=rt),Ze=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1d2wd31"&&(N.innerHTML=it),Je=n(e),c(L.$$.fragment,e),ve=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-aww6n1"&&(G.textContent=pt),Se=n(e),c(X.$$.fragment,e),He=n(e),c(D.$$.fragment,e),Ce=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1q24dye"&&(I.innerHTML=ot),Be=n(e),c(z.$$.fragment,e),Pe=n(e),c(Y.$$.fragment,e),Re=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-z3oim4"&&(A.innerHTML=ct),xe=n(e),c(E.$$.fragment,e),We=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-24jdjp"&&(V.innerHTML=dt),ke=n(e),c(Q.$$.fragment,e),Ne=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-kqctpd"&&(q.textContent=ft),Le=n(e),c(O.$$.fragment,e),Ge=n(e),c(K.$$.fragment,e),Xe=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1o03k98"&&(ee.textContent=ht),De=n(e),te=i(e,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-nb2y58"&&(te.innerHTML=mt),Ie=n(e),c(ae.$$.fragment,e),ze=n(e),le=i(e,"P",{}),ut(le).forEach(a),this.h()},h(){gt(u,"name","hf:doc:metadata"),gt(u,"content",Ft)},m(e,t){bt(document.head,u),s(e,ne,t),s(e,se,t),s(e,re,t),d(w,e,t),s(e,ie,t),s(e,_,t),s(e,pe,t),s(e,$,t),s(e,oe,t),s(e,T,t),s(e,ce,t),d(M,e,t),s(e,de,t),d(b,e,t),s(e,fe,t),s(e,U,t),s(e,he,t),d(j,e,t),s(e,me,t),s(e,F,t),s(e,ue,t),d(Z,e,t),s(e,ge,t),s(e,J,t),s(e,ye,t),s(e,v,t),s(e,we,t),d(S,e,t),s(e,_e,t),s(e,H,t),s(e,$e,t),s(e,C,t),s(e,Te,t),d(B,e,t),s(e,Me,t),s(e,P,t),s(e,be,t),s(e,R,t),s(e,Ue,t),s(e,x,t),s(e,je,t),d(W,e,t),s(e,Fe,t),s(e,k,t),s(e,Ze,t),s(e,N,t),s(e,Je,t),d(L,e,t),s(e,ve,t),s(e,G,t),s(e,Se,t),d(X,e,t),s(e,He,t),d(D,e,t),s(e,Ce,t),s(e,I,t),s(e,Be,t),d(z,e,t),s(e,Pe,t),d(Y,e,t),s(e,Re,t),s(e,A,t),s(e,xe,t),d(E,e,t),s(e,We,t),s(e,V,t),s(e,ke,t),d(Q,e,t),s(e,Ne,t),s(e,q,t),s(e,Le,t),d(O,e,t),s(e,Ge,t),d(K,e,t),s(e,Xe,t),s(e,ee,t),s(e,De,t),s(e,te,t),s(e,Ie,t),d(ae,e,t),s(e,ze,t),s(e,le,t),Ye=!0},p:wt,i(e){Ye||(f(w.$$.fragment,e),f(M.$$.fragment,e),f(b.$$.fragment,e),f(j.$$.fragment,e),f(Z.$$.fragment,e),f(S.$$.fragment,e),f(B.$$.fragment,e),f(W.$$.fragment,e),f(L.$$.fragment,e),f(X.$$.fragment,e),f(D.$$.fragment,e),f(z.$$.fragment,e),f(Y.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(ae.$$.fragment,e),Ye=!0)},o(e){h(w.$$.fragment,e),h(M.$$.fragment,e),h(b.$$.fragment,e),h(j.$$.fragment,e),h(Z.$$.fragment,e),h(S.$$.fragment,e),h(B.$$.fragment,e),h(W.$$.fragment,e),h(L.$$.fragment,e),h(X.$$.fragment,e),h(D.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(ae.$$.fragment,e),Ye=!1},d(e){e&&(a(ne),a(se),a(re),a(ie),a(_),a(pe),a($),a(oe),a(T),a(ce),a(de),a(fe),a(U),a(he),a(me),a(F),a(ue),a(ge),a(J),a(ye),a(v),a(we),a(_e),a(H),a($e),a(C),a(Te),a(Me),a(P),a(be),a(R),a(Ue),a(x),a(je),a(Fe),a(k),a(Ze),a(N),a(Je),a(ve),a(G),a(Se),a(He),a(Ce),a(I),a(Be),a(Pe),a(Re),a(A),a(xe),a(We),a(V),a(ke),a(Ne),a(q),a(Le),a(Ge),a(Xe),a(ee),a(De),a(te),a(Ie),a(ze),a(le)),a(u),m(w,e),m(M,e),m(b,e),m(j,e),m(Z,e),m(S,e),m(B,e),m(W,e),m(L,e),m(X,e),m(D,e),m(z,e),m(Y,e),m(E,e),m(Q,e),m(O,e),m(K,e),m(ae,e)}}}const Ft='{"title":"FullyShardedDataParallel","local":"fullyshardeddataparallel","sections":[{"title":"Configuration options","local":"configuration-options","sections":[{"title":"Sharding strategy","local":"sharding-strategy","sections":[],"depth":3},{"title":"CPU offload","local":"cpu-offload","sections":[],"depth":3},{"title":"Wrapping policy","local":"wrapping-policy","sections":[],"depth":3},{"title":"Checkpoints","local":"checkpoints","sections":[],"depth":3},{"title":"TPU","local":"tpu","sections":[],"depth":3}],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Zt(Ae){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends $t{constructor(u){super(),Tt(this,u,Zt,jt,yt,{})}}export{Ct as component};
