import{s as Kt,o as eo,n as an}from"../chunks/scheduler.01eeda35.js";import{S as no,i as to,g as a,s as o,r as h,A as oo,h as r,f as i,c as s,j as C,u,x as m,k as U,y as n,a as p,v as f,d as _,t as b,w as y}from"../chunks/index.6dd51b66.js";import{T as _t}from"../chunks/Tip.de9bae2b.js";import{D as B}from"../chunks/Docstring.cb556860.js";import{C as yt}from"../chunks/CodeBlock.19ec9b8c.js";import{E as bt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as ln,E as so}from"../chunks/index.58fe8f9d.js";function ao(Z){let l,j=`A large number of these flags control the logits or the stopping criteria of the generation. Make sure you check
the <a href="https://huggingface.co/docs/transformers/internal/generation_utils" rel="nofollow">generate-related classes</a> for a full
description of the possible manipulations, as well as examples of their usage.`;return{c(){l=a("p"),l.innerHTML=j},l(g){l=r(g,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1lhagsi"&&(l.innerHTML=j)},m(g,d){p(g,l,d)},p:an,d(g){g&&i(l)}}}function ro(Z){let l,j="Examples:",g,d,M;return d=new yt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQSUyMyUyMEUuZy4lMjBjb25maWclMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiklMEElMEElMjMlMjBZb3UlMjBjYW4lMjBhbHNvJTIwc3BlY2lmeSUyMGNvbmZpZ3VyYXRpb24lMjBuYW1lcyUyMHRvJTIweW91ciUyMGdlbmVyYXRpb24lMjBjb25maWd1cmF0aW9uJTIwZmlsZSUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyJTJDJTIwY29uZmlnX2ZpbGVfbmFtZSUzRCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjAlMjJteV9jb25maWd1cmF0aW9uLmpzb24lMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UnZCUyMGxpa2UlMjB0byUyMHRyeSUyMGElMjBtaW5vciUyMHZhcmlhdGlvbiUyMHRvJTIwYW4lMjBleGlzdGluZyUyMGNvbmZpZ3VyYXRpb24lMkMlMjB5b3UlMjBjYW4lMjBhbHNvJTIwcGFzcyUyMGdlbmVyYXRpb24lMEElMjMlMjBhcmd1bWVudHMlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoKSU2MC4lMjBCZSUyMG1pbmRmdWwlMjB0aGF0JTIwdHlwb3MlMjBhbmQlMjB1bnVzZWQlMjBhcmd1bWVudHMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTBBZ2VuZXJhdGlvbl9jb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjB0b3BfayUzRDElMkMlMjBmb28lM0RGYWxzZSUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBZ2VuZXJhdGlvbl9jb25maWcudG9wX2slMEElMEF1bnVzZWRfa3dhcmdz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){l=a("p"),l.textContent=j,g=o(),h(d.$$.fragment)},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=j),g=s(t),u(d.$$.fragment,t)},m(t,w){p(t,l,w),p(t,g,w),f(d,t,w),M=!0},p:an,i(t){M||(_(d.$$.fragment,t),M=!0)},o(t){b(d.$$.fragment,t),M=!1},d(t){t&&(i(l),i(g)),y(d,t)}}}function io(Z){let l,j=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,d,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=a("p"),l.innerHTML=j,g=o(),d=a("p"),d.innerHTML=M},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1c5u34l"&&(l.innerHTML=j),g=s(t),d=r(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=M)},m(t,w){p(t,l,w),p(t,g,w),p(t,d,w)},p:an,d(t){t&&(i(l),i(g),i(d))}}}function lo(Z){let l,j="Examples:",g,d,M;return d=new yt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | log probability | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 1: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 2: the output length does NOT include the input length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=a("p"),l.textContent=j,g=o(),h(d.$$.fragment)},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=j),g=s(t),u(d.$$.fragment,t)},m(t,w){p(t,l,w),p(t,g,w),f(d,t,w),M=!0},p:an,i(t){M||(_(d.$$.fragment,t),M=!0)},o(t){b(d.$$.fragment,t),M=!1},d(t){t&&(i(l),i(g)),y(d,t)}}}function co(Z){let l,j=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate, e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,d,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=a("p"),l.innerHTML=j,g=o(),d=a("p"),d.innerHTML=M},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1pahvb2"&&(l.innerHTML=j),g=s(t),d=r(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=M)},m(t,w){p(t,l,w),p(t,g,w),p(t,d,w)},p:an,d(t){t&&(i(l),i(g),i(d))}}}function mo(Z){let l,j="Examples:",g,d,M;return d=new yt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=a("p"),l.textContent=j,g=o(),h(d.$$.fragment)},l(t){l=r(t,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=j),g=s(t),u(d.$$.fragment,t)},m(t,w){p(t,l,w),p(t,g,w),f(d,t,w),M=!0},p:an,i(t){M||(_(d.$$.fragment,t),M=!0)},o(t){b(d.$$.fragment,t),M=!1},d(t){t&&(i(l),i(g)),y(d,t)}}}function po(Z){let l,j,g,d,M,t,w,Mt="Each framework has a generate method for text generation implemented in their respective <code>GenerationMixin</code> class:",cn,ee,wt='<li>PyTorch <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin">GenerationMixin</a>.</li> <li>TensorFlow <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.TFGenerationMixin">TFGenerationMixin</a>.</li> <li>Flax/JAX <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.FlaxGenerationMixin">FlaxGenerationMixin</a>.</li>',dn,ne,Tt=`Regardless of your framework of choice, you can parameterize the generate method with a <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`,mn,te,xt=`To learn how to inspect a model’s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
<a href="../generation_strategies">text generation strategies guide</a>. The guide also explains how to use related features,
like token streaming.`,pn,oe,gn,T,se,jn,ke,vt=`Class that holds a configuration for a generation task. A <code>generate</code> call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`,kn,Ge,jt="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0.</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li> <li><em>dola decoding</em> if <code>dola_layers</code> is passed to <code>.generate()</code></li>",Gn,Je,kt='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',Jn,L,Cn,W,ae,Un,Ce,Gt='Instantiate a <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a generation configuration file.',Bn,S,Zn,E,re,In,Ue,Jt=`Instantiates a <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This function is useful to convert legacy
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> objects, which may contain generation parameters, into a stand-alone <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.`,$n,q,ie,Wn,Be,Ct=`Save a generation configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">from_pretrained()</a> class method.`,zn,D,le,Vn,Ze,Ut=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,Hn,z,ce,Xn,Ie,Bt=`Validates the values of the attributes of the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance. Raises exceptions in the presence
of parameterization that can be detected as incorrect from the configuration instance alone.`,Fn,$e,Zt=`Note that some parameters not validated here are best validated at generate runtime, as they may depend on
other inputs and/or the model, such as parameters related to the generation length.`,Rn,Y,de,Nn,We,It='Returns the generation mode triggered by the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance.',hn,me,un,v,pe,Ln,ze,$t=`A class containing all functions for auto-regressive text generation, to be used as a mixin in model classes.
Inheriting from this class causes the model to have special generation-related behavior, such as loading a
<code>GenerationConfig</code> at initialization time or ensuring <code>generate</code>-related tests are run in <code>transformers</code> CI.`,Sn,Ve,Wt=`A model class should inherit from <code>GenerationMixin</code> to enable calling methods like <code>generate</code>, or when it
has defined a custom <code>generate</code> method that relies on <code>GenerationMixin</code>, directly or indirectly, which
approximately shares the same interface to public methods like <code>generate</code>. Three examples:`,En,He,zt=`<li><code>LlamaForCausalLM</code> should inherit from <code>GenerationMixin</code> to enable calling <code>generate</code> and other public
methods in the mixin;</li> <li><code>BlipForQuestionAnswering</code> has a custom <code>generate</code> method that approximately shares the same interface as
<code>GenerationMixin.generate</code> (it has a few extra arguments, and the same output). That function also calls
<code>GenerationMixin.generate</code> indirectly, through an inner model. As such, <code>BlipForQuestionAnswering</code> should
inherit from <code>GenerationMixin</code> to benefit from all generation-related automation in our codebase;</li> <li><code>BarkModel</code> has a custom <code>generate</code> method and one of its inner models calls <code>GenerationMixin.generate</code>.
However, its <code>generate</code> does not share the same interface as <code>GenerationMixin.generate</code>. In this case,
<code>BarkModel</code> shoud NOT inherit from <code>GenerationMixin</code>, as it breaks the <code>generate</code> interface.</li>`,qn,Xe,Vt='The class exposes <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, which can be used for:',Dn,Fe,Ht="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li>",Yn,Re,Xt='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',Qn,V,ge,Pn,Ne,Ft="Generates sequences of token ids for models with a language modeling head.",An,Q,On,H,he,Kn,Le,Rt=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quickly obtain the scores of the selected tokens at generation time.`,et,P,fn,ue,_n,k,fe,nt,Se,Nt='A class containing all of the functions supporting generation, to be used as a mixin in <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>.',tt,Ee,Lt='The class exposes <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>, which can be used for:',ot,qe,St=`<li><em>greedy decoding</em> by calling <code>greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <code>contrastive_search()</code> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <code>sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>beam_search()</code> if <code>num_beams&gt;1</code></li>`,st,De,Et=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,at,X,_e,rt,Ye,qt="Generates sequences of token ids for models with a language modeling head.",it,A,lt,F,be,ct,Qe,Dt=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quickly obtain the scores of the selected tokens at generation time.`,dt,O,bn,ye,yn,J,Me,mt,Pe,Yt=`A class containing all functions for auto-regressive text generation, to be used as a mixin in
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>.`,pt,Ae,Qt='The class exposes <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>, which can be used for:',gt,Oe,Pt=`<li><em>greedy decoding</em> by calling <code>_greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>multinomial sampling</em> by calling <code>_sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>_beam_search()</code> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li>`,ht,Ke,At=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,ut,K,we,ft,en,Ot="Generates sequences of token ids for models with a language modeling head.",Mn,Te,wn,rn,Tn;return M=new ln({props:{title:"Generation",local:"generation",headingTag:"h1"}}),oe=new ln({props:{title:"GenerationConfig",local:"transformers.GenerationConfig",headingTag:"h2"}}),se=new B({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L100",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time",description:`<strong>max_time</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time"},{anchor:"transformers.GenerationConfig.stop_strings",description:`<strong>stop_strings</strong> (<code>str or List[str]</code>, <em>optional</em>) &#x2014;
A string or a list of strings that should terminate generation if the model outputs them.`,name:"stop_strings"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.dola_layers",description:`<strong>dola_layers</strong> (<code>str</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The layers to use for DoLa decoding. If <code>None</code>, DoLa decoding is not used. If a string, it must
be one of &#x201C;low&#x201D; or &#x201C;high&#x201D;, which means using the lower part or higher part of the model layers, respectively.
&#x201C;low&#x201D; means the first half of the layers up to the first 20 layers, and &#x201C;high&#x201D; means the last half of the
layers up to the last 20 layers.
If a list of integers, it must contain the indices of the layers to use for candidate premature layers in DoLa.
The 0-th layer is the word embedding layer of the model. Set to <code>&apos;low&apos;</code> to improve long-answer reasoning tasks,
<code>&apos;high&apos;</code> to improve short-answer tasks. Check the <a href="https://github.com/huggingface/transformers/blob/main/docs/source/en/generation_strategies.md" rel="nofollow">documentation</a>
or <a href="https://arxiv.org/abs/2309.03883" rel="nofollow">the paper</a> for more details.`,name:"dola_layers"}]},{title:"Parameters that control the cache",parametersDescription:[{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"},{anchor:"transformers.GenerationConfig.cache_implementation",description:`<strong>cache_implementation</strong> (<code>str</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Name of the cache class that will be instantiated in <code>generate</code>, for faster decoding. Possible values are:</p>
<ul>
<li><code>&quot;dynamic&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a></li>
<li><code>&quot;static&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a></li>
<li><code>&quot;offloaded_static&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.OffloadedStaticCache">OffloadedStaticCache</a></li>
<li><code>&quot;sliding_window&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.SlidingWindowCache">SlidingWindowCache</a></li>
<li><code>&quot;hybrid&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.HybridCache">HybridCache</a></li>
<li><code>&quot;mamba&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.MambaCache">MambaCache</a></li>
<li><code>&quot;quantized&quot;</code>: <a href="/docs/transformers/main/en/internal/generation_utils#transformers.QuantizedCache">QuantizedCache</a></li>
</ul>
<p>If none is specified, we will use the default cache for the model (which is often <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>). See
our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">cache documentation</a> for further information.`,name:"cache_implementation"},{anchor:"transformers.GenerationConfig.cache_config",description:`<strong>cache_config</strong> (<code>CacheConfig</code> or <code>dict</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Arguments used in the key-value cache class can be passed in <code>cache_config</code>. Can be passed as a <code>Dict</code> and
it will be converted to its repsective <code>CacheConfig</code> internally.
Otherwise can be passed as a <code>CacheConfig</code> class matching the indicated <code>cache_implementation</code>.`,name:"cache_config"},{anchor:"transformers.GenerationConfig.return_legacy_cache",description:`<strong>return_legacy_cache</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to return the legacy or new format of the cache when <code>DynamicCache</code> is used by default.`,name:"return_legacy_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities. This value is set in a model&#x2019;s <code>generation_config.json</code> file. If it isn&#x2019;t set, the default value is 1.0`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering. This value is set in a model&#x2019;s <code>generation_config.json</code> file. If it isn&#x2019;t set, the default value is 50.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation. This value is set in a model&#x2019;s <code>generation_config.json</code> file. If it isn&#x2019;t set, the default value is 1.0`,name:"top_p"},{anchor:"transformers.GenerationConfig.min_p",description:`<strong>min_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
List of list of token ids that are not allowed to be generated. Check
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.NoBadWordsLogitsProcessor">NoBadWordsLogitsProcessor</a> for further documentation and examples.`,name:"bad_words_ids"},{anchor:"transformers.GenerationConfig.force_words_ids",description:`<strong>force_words_ids</strong> (<code>List[List[int]]</code> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:"<strong>forced_eos_token_id</strong> (<code>int</code> or List[int]<code>, *optional*, defaults to </code>model.config.forced_eos_token_id<code>) -- The id of the token to force as the last generated token when </code>max_length` is reached. Optionally, use a\nlist to set multiple <em>end-of-sequence</em> tokens.",name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"},{anchor:"transformers.GenerationConfig.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>, <em>optional</em>)) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. Check
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.SequenceBiasLogitsProcessor">SequenceBiasLogitsProcessor</a> for further documentation and examples.`,name:"sequence_bias"},{anchor:"transformers.GenerationConfig.token_healing",description:`<strong>token_healing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Heal tail tokens of prompts by replacing them with their appropriate extensions.
This enhances the quality of completions for prompts affected by greedy tokenization bias.`,name:"token_healing"},{anchor:"transformers.GenerationConfig.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"},{anchor:"transformers.GenerationConfig.low_memory",description:`<strong>low_memory</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switch to sequential beam search and sequential topk for contrastive search to reduce peak memory.
Used with beam search and contrastive search.`,name:"low_memory"},{anchor:"transformers.GenerationConfig.watermarking_config",description:`<strong>watermarking_config</strong> (<code>BaseWatermarkingConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
Arguments used to watermark the model outputs by adding a small bias to randomly selected set of &#x201C;green&#x201D;
tokens. See the docs of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.SynthIDTextWatermarkingConfig">SynthIDTextWatermarkingConfig</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.WatermarkingConfig">WatermarkingConfig</a> for more
details. If passed as <code>Dict</code>, it will be converted to a <code>WatermarkingConfig</code> internally.`,name:"watermarking_config"}]},{title:"Parameters that define the output variables of generate",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences",description:`<strong>num_return_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.output_logits",description:`<strong>output_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the unprocessed prediction logit scores. See <code>logits</code> under returned tensors for
more details.`,name:"output_logits"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>, as opposed to returning exclusively the generated
sequence. This flag must be set to <code>True</code> to return the generation cache (when <code>use_cache</code> is <code>True</code>)
or optional outputs (see flags starting with <code>output_</code>)`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token or a list of length
<code>batch_size</code>. Indicating a list enables different start ids for each element in the batch
(e.g. multilingual models with different target languages in one batch)`,name:"decoder_start_token_id"}]},{title:"Generation parameters exclusive to assistant generation",parametersDescription:[{anchor:"transformers.GenerationConfig.is_assistant",description:`<strong>is_assistant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is an assistant (draft) model.`,name:"is_assistant"},{anchor:"transformers.GenerationConfig.num_assistant_tokens",description:`<strong>num_assistant_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Defines the number of <em>speculative tokens</em> that shall be generated by the assistant model before being
checked by the target model at each iteration. Higher values for <code>num_assistant_tokens</code> make the generation
more <em>speculative</em> : If the assistant model is performant larger speed-ups can be reached, if the assistant
model requires lots of corrections, lower speed-ups are reached.`,name:"num_assistant_tokens"},{anchor:"transformers.GenerationConfig.num_assistant_tokens_schedule",description:`<strong>num_assistant_tokens_schedule</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;constant&quot;</code>) &#x2014;
Defines the schedule at which max assistant tokens shall be changed during inference.<ul>
<li><code>&quot;heuristic&quot;</code>: When all speculative tokens are correct, increase <code>num_assistant_tokens</code> by 2 else
reduce by 1. <code>num_assistant_tokens</code> value is persistent over multiple generation calls with the same assistant model.</li>
<li><code>&quot;heuristic_transient&quot;</code>: Same as <code>&quot;heuristic&quot;</code> but <code>num_assistant_tokens</code> is reset to its initial value after each generation call.</li>
<li><code>&quot;constant&quot;</code>: <code>num_assistant_tokens</code> stays unchanged during generation</li>
</ul>`,name:"num_assistant_tokens_schedule"},{anchor:"transformers.GenerationConfig.assistant_confidence_threshold",description:`<strong>assistant_confidence_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
The confidence threshold for the assistant model. If the assistant model&#x2019;s confidence in its prediction for the current token is lower
than this threshold, the assistant model stops the current token generation iteration, even if the number of <em>speculative tokens</em>
(defined by <code>num_assistant_tokens</code>) is not yet reached. The assistant&#x2019;s confidence threshold is adjusted throughout the speculative iterations to reduce the number of unnecessary draft and target forward passes, biased towards avoiding false negatives.
<code>assistant_confidence_threshold</code> value is persistent over multiple generation calls with the same assistant model.
It is an unsupervised version of the dynamic speculation lookahead
from Dynamic Speculation Lookahead Accelerates Speculative Decoding of Large Language Models <a href="https://arxiv.org/abs/2405.04304" rel="nofollow">https://arxiv.org/abs/2405.04304</a>.`,name:"assistant_confidence_threshold"},{anchor:"transformers.GenerationConfig.prompt_lookup_num_tokens",description:`<strong>prompt_lookup_num_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of tokens to be output as candidate tokens.`,name:"prompt_lookup_num_tokens"},{anchor:"transformers.GenerationConfig.max_matching_ngram_size",description:`<strong>max_matching_ngram_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum ngram size to be considered for matching in the prompt. Default to 2 if not provided.`,name:"max_matching_ngram_size"},{anchor:"transformers.GenerationConfig.assistant_early_exit(int,",description:`<strong>assistant_early_exit(<code>int</code>,</strong> <em>optional</em>) &#x2014;
If set to a positive integer, early exit of the model will be used as an assistant. Can only be used with
models that support early exit (i.e. models where logits from intermediate layers can be interpreted by the LM head).`,name:"assistant_early_exit(int,"},{anchor:"transformers.GenerationConfig.assistant_lookbehind(int,",description:`<strong>assistant_lookbehind(<code>int</code>,</strong> <em>optional</em>, defaults to 10) &#x2014;
If set to a positive integer, the re-encodeing process will additionally consider the last <code>assistant_lookbehind</code> assistant tokens
to correctly align tokens. Can only be used with different tokenizers in speculative decoding.
See this <a href="https://huggingface.co/blog/universal_assisted_generation" rel="nofollow">blog</a> for more details.`,name:"assistant_lookbehind(int,"},{anchor:"transformers.GenerationConfig.target_lookbehind(int,",description:`<strong>target_lookbehind(<code>int</code>,</strong> <em>optional</em>, defaults to 10) &#x2014;
If set to a positive integer, the re-encodeing process will additionally consider the last <code>target_lookbehind</code> target tokens
to correctly align tokens. Can only be used with different tokenizers in speculative decoding.
See this <a href="https://huggingface.co/blog/universal_assisted_generation" rel="nofollow">blog</a> for more details.`,name:"target_lookbehind(int,"}]},{title:"Parameters related to performances and compilation",parametersDescription:[{anchor:"transformers.GenerationConfig.compile_config",description:`<strong>compile_config</strong> (CompileConfig, <em>optional</em>) &#x2014;
If using a static cache, this controls how <code>generate</code> will <code>compile</code> the forward pass for performance
gains.`,name:"compile_config"},{anchor:"transformers.GenerationConfig.disable_compile",description:"<strong>disable_compile</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether to disable the automatic compilation of the forward pass. Automatic compilation happens when specific criteria are met, including using a compileable cache. Please open an issue if you find the need to use this flag.",name:"disable_compile"}]},{title:"Wild card",parametersDescription:[{anchor:"transformers.GenerationConfig.generation_kwargs",description:`<strong>generation_kwargs</strong> &#x2014;
Additional generation kwargs will be forwarded to the <code>generate</code> function of the model. Kwargs that are not
present in <code>generate</code>&#x2019;s signature will be used in the model forward pass.`,name:"generation_kwargs"}]}]}}),L=new _t({props:{$$slots:{default:[ao]},$$scope:{ctx:Z}}}),ae=new B({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible.
Will be removed in v5 of Transformers.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass <code>revision=&quot;refs/pr/&lt;pr_number&gt;&quot;</code>.</p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L922",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),S=new bt({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[ro]},$$scope:{ctx:Z}}}),re=new B({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),ie=new B({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L844"}}),le=new B({props:{name:"update",anchor:"transformers.GenerationConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1308",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),ce=new B({props:{name:"validate",anchor:"transformers.GenerationConfig.validate",parameters:[{name:"is_init",val:" = False"}],parametersDescription:[{anchor:"transformers.GenerationConfig.validate.is_init",description:`<strong>is_init</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the validation is performed during the initialization of the instance.`,name:"is_init"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L590"}}),de=new B({props:{name:"get_generation_mode",anchor:"transformers.GenerationConfig.get_generation_mode",parameters:[{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"}],parametersDescription:[{anchor:"transformers.GenerationConfig.get_generation_mode.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
The assistant model to be used for assisted generation. If set, the generation mode will be
assisted generation.`,name:"assistant_model"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generation mode triggered by the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>GenerationMode</code></p>
`}}),me=new ln({props:{title:"GenerationMixin",local:"transformers.GenerationMixin",headingTag:"h2"}}),pe=new B({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L346"}}),ge=new B({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Optional[typing.Callable[[int, torch.Tensor], typing.List[int]]] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_model_defaults",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistant model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.use_model_defaults",description:`<strong>use_model_defaults</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
When it is <code>True</code>, unset parameters in <code>generation_config</code> will be set to the model-specific default
generation configuration (<code>model.generation_config</code>), as opposed to the global defaults
(<code>GenerationConfig()</code>). If unset, models saved starting from <code>v4.50</code> will consider this flag to be
<code>True</code>.`,name:"use_model_defaults"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L2107",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),Q=new _t({props:{warning:!0,$$slots:{default:[io]},$$scope:{ctx:Z}}}),he=new B({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[torch.Tensor]"},{name:"beam_indices",val:": typing.Optional[torch.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1311",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),P=new bt({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[lo]},$$scope:{ctx:Z}}}),ue=new ln({props:{title:"TFGenerationMixin",local:"transformers.TFGenerationMixin",headingTag:"h2"}}),fe=new B({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L444"}}),_e=new B({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.tf_logits_process.TFLogitsProcessorList] = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),A=new _t({props:{warning:!0,$$slots:{default:[co]},$$scope:{ctx:Z}}}),be=new B({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[tensorflow.python.framework.tensor.Tensor]"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code></p>
`}}),O=new bt({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[mo]},$$scope:{ctx:Z}}}),ye=new ln({props:{title:"FlaxGenerationMixin",local:"transformers.FlaxGenerationMixin",headingTag:"h2"}}),Me=new B({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L130"}}),we=new B({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"prng_key",val:": typing.Optional[jax.Array] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Optional[typing.Dict[str, jax.Array]] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.flax_logits_process.FlaxLogitsProcessorList] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),Te=new so({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/text_generation.md"}}),{c(){l=a("meta"),j=o(),g=a("p"),d=o(),h(M.$$.fragment),t=o(),w=a("p"),w.innerHTML=Mt,cn=o(),ee=a("ul"),ee.innerHTML=wt,dn=o(),ne=a("p"),ne.innerHTML=Tt,mn=o(),te=a("p"),te.innerHTML=xt,pn=o(),h(oe.$$.fragment),gn=o(),T=a("div"),h(se.$$.fragment),jn=o(),ke=a("p"),ke.innerHTML=vt,kn=o(),Ge=a("ul"),Ge.innerHTML=jt,Gn=o(),Je=a("p"),Je.innerHTML=kt,Jn=o(),h(L.$$.fragment),Cn=o(),W=a("div"),h(ae.$$.fragment),Un=o(),Ce=a("p"),Ce.innerHTML=Gt,Bn=o(),h(S.$$.fragment),Zn=o(),E=a("div"),h(re.$$.fragment),In=o(),Ue=a("p"),Ue.innerHTML=Jt,$n=o(),q=a("div"),h(ie.$$.fragment),Wn=o(),Be=a("p"),Be.innerHTML=Ct,zn=o(),D=a("div"),h(le.$$.fragment),Vn=o(),Ze=a("p"),Ze.innerHTML=Ut,Hn=o(),z=a("div"),h(ce.$$.fragment),Xn=o(),Ie=a("p"),Ie.innerHTML=Bt,Fn=o(),$e=a("p"),$e.textContent=Zt,Rn=o(),Y=a("div"),h(de.$$.fragment),Nn=o(),We=a("p"),We.innerHTML=It,hn=o(),h(me.$$.fragment),un=o(),v=a("div"),h(pe.$$.fragment),Ln=o(),ze=a("p"),ze.innerHTML=$t,Sn=o(),Ve=a("p"),Ve.innerHTML=Wt,En=o(),He=a("ul"),He.innerHTML=zt,qn=o(),Xe=a("p"),Xe.innerHTML=Vt,Dn=o(),Fe=a("ul"),Fe.innerHTML=Ht,Yn=o(),Re=a("p"),Re.innerHTML=Xt,Qn=o(),V=a("div"),h(ge.$$.fragment),Pn=o(),Ne=a("p"),Ne.textContent=Ft,An=o(),h(Q.$$.fragment),On=o(),H=a("div"),h(he.$$.fragment),Kn=o(),Le=a("p"),Le.textContent=Rt,et=o(),h(P.$$.fragment),fn=o(),h(ue.$$.fragment),_n=o(),k=a("div"),h(fe.$$.fragment),nt=o(),Se=a("p"),Se.innerHTML=Nt,tt=o(),Ee=a("p"),Ee.innerHTML=Lt,ot=o(),qe=a("ul"),qe.innerHTML=St,st=o(),De=a("p"),De.innerHTML=Et,at=o(),X=a("div"),h(_e.$$.fragment),rt=o(),Ye=a("p"),Ye.textContent=qt,it=o(),h(A.$$.fragment),lt=o(),F=a("div"),h(be.$$.fragment),ct=o(),Qe=a("p"),Qe.textContent=Dt,dt=o(),h(O.$$.fragment),bn=o(),h(ye.$$.fragment),yn=o(),J=a("div"),h(Me.$$.fragment),mt=o(),Pe=a("p"),Pe.innerHTML=Yt,pt=o(),Ae=a("p"),Ae.innerHTML=Qt,gt=o(),Oe=a("ul"),Oe.innerHTML=Pt,ht=o(),Ke=a("p"),Ke.innerHTML=At,ut=o(),K=a("div"),h(we.$$.fragment),ft=o(),en=a("p"),en.textContent=Ot,Mn=o(),h(Te.$$.fragment),wn=o(),rn=a("p"),this.h()},l(e){const c=oo("svelte-u9bgzb",document.head);l=r(c,"META",{name:!0,content:!0}),c.forEach(i),j=s(e),g=r(e,"P",{}),C(g).forEach(i),d=s(e),u(M.$$.fragment,e),t=s(e),w=r(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1lm9ezt"&&(w.innerHTML=Mt),cn=s(e),ee=r(e,"UL",{"data-svelte-h":!0}),m(ee)!=="svelte-1fyx4vu"&&(ee.innerHTML=wt),dn=s(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-18trtrh"&&(ne.innerHTML=Tt),mn=s(e),te=r(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1wifwwe"&&(te.innerHTML=xt),pn=s(e),u(oe.$$.fragment,e),gn=s(e),T=r(e,"DIV",{class:!0});var x=C(T);u(se.$$.fragment,x),jn=s(x),ke=r(x,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-14531m7"&&(ke.innerHTML=vt),kn=s(x),Ge=r(x,"UL",{"data-svelte-h":!0}),m(Ge)!=="svelte-1p8wjok"&&(Ge.innerHTML=jt),Gn=s(x),Je=r(x,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1gtazd5"&&(Je.innerHTML=kt),Jn=s(x),u(L.$$.fragment,x),Cn=s(x),W=r(x,"DIV",{class:!0});var R=C(W);u(ae.$$.fragment,R),Un=s(R),Ce=r(R,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-dy0lxz"&&(Ce.innerHTML=Gt),Bn=s(R),u(S.$$.fragment,R),R.forEach(i),Zn=s(x),E=r(x,"DIV",{class:!0});var xe=C(E);u(re.$$.fragment,xe),In=s(xe),Ue=r(xe,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-hihar7"&&(Ue.innerHTML=Jt),xe.forEach(i),$n=s(x),q=r(x,"DIV",{class:!0});var ve=C(q);u(ie.$$.fragment,ve),Wn=s(ve),Be=r(ve,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-uhy25y"&&(Be.innerHTML=Ct),ve.forEach(i),zn=s(x),D=r(x,"DIV",{class:!0});var je=C(D);u(le.$$.fragment,je),Vn=s(je),Ze=r(je,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-n0rwld"&&(Ze.innerHTML=Ut),je.forEach(i),Hn=s(x),z=r(x,"DIV",{class:!0});var N=C(z);u(ce.$$.fragment,N),Xn=s(N),Ie=r(N,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1l81mwj"&&(Ie.innerHTML=Bt),Fn=s(N),$e=r(N,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1rsok5m"&&($e.textContent=Zt),N.forEach(i),Rn=s(x),Y=r(x,"DIV",{class:!0});var xn=C(Y);u(de.$$.fragment,xn),Nn=s(xn),We=r(xn,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1njhi80"&&(We.innerHTML=It),xn.forEach(i),x.forEach(i),hn=s(e),u(me.$$.fragment,e),un=s(e),v=r(e,"DIV",{class:!0});var G=C(v);u(pe.$$.fragment,G),Ln=s(G),ze=r(G,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-7qdtel"&&(ze.innerHTML=$t),Sn=s(G),Ve=r(G,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-41m5xz"&&(Ve.innerHTML=Wt),En=s(G),He=r(G,"UL",{"data-svelte-h":!0}),m(He)!=="svelte-io4c8z"&&(He.innerHTML=zt),qn=s(G),Xe=r(G,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1w3p7mb"&&(Xe.innerHTML=Vt),Dn=s(G),Fe=r(G,"UL",{"data-svelte-h":!0}),m(Fe)!=="svelte-1655ho"&&(Fe.innerHTML=Ht),Yn=s(G),Re=r(G,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1gtazd5"&&(Re.innerHTML=Xt),Qn=s(G),V=r(G,"DIV",{class:!0});var nn=C(V);u(ge.$$.fragment,nn),Pn=s(nn),Ne=r(nn,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-s5ko3x"&&(Ne.textContent=Ft),An=s(nn),u(Q.$$.fragment,nn),nn.forEach(i),On=s(G),H=r(G,"DIV",{class:!0});var tn=C(H);u(he.$$.fragment,tn),Kn=s(tn),Le=r(tn,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-jevtkl"&&(Le.textContent=Rt),et=s(tn),u(P.$$.fragment,tn),tn.forEach(i),G.forEach(i),fn=s(e),u(ue.$$.fragment,e),_n=s(e),k=r(e,"DIV",{class:!0});var I=C(k);u(fe.$$.fragment,I),nt=s(I),Se=r(I,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-npdy1s"&&(Se.innerHTML=Nt),tt=s(I),Ee=r(I,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-llzcxd"&&(Ee.innerHTML=Lt),ot=s(I),qe=r(I,"UL",{"data-svelte-h":!0}),m(qe)!=="svelte-fx738d"&&(qe.innerHTML=St),st=s(I),De=r(I,"P",{"data-svelte-h":!0}),m(De)!=="svelte-13kczdy"&&(De.innerHTML=Et),at=s(I),X=r(I,"DIV",{class:!0});var on=C(X);u(_e.$$.fragment,on),rt=s(on),Ye=r(on,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-s5ko3x"&&(Ye.textContent=qt),it=s(on),u(A.$$.fragment,on),on.forEach(i),lt=s(I),F=r(I,"DIV",{class:!0});var sn=C(F);u(be.$$.fragment,sn),ct=s(sn),Qe=r(sn,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-jevtkl"&&(Qe.textContent=Dt),dt=s(sn),u(O.$$.fragment,sn),sn.forEach(i),I.forEach(i),bn=s(e),u(ye.$$.fragment,e),yn=s(e),J=r(e,"DIV",{class:!0});var $=C(J);u(Me.$$.fragment,$),mt=s($),Pe=r($,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-1eu4sgu"&&(Pe.innerHTML=Yt),pt=s($),Ae=r($,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-gsdqya"&&(Ae.innerHTML=Qt),gt=s($),Oe=r($,"UL",{"data-svelte-h":!0}),m(Oe)!=="svelte-ffjx8e"&&(Oe.innerHTML=Pt),ht=s($),Ke=r($,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-13kczdy"&&(Ke.innerHTML=At),ut=s($),K=r($,"DIV",{class:!0});var vn=C(K);u(we.$$.fragment,vn),ft=s(vn),en=r(vn,"P",{"data-svelte-h":!0}),m(en)!=="svelte-s5ko3x"&&(en.textContent=Ot),vn.forEach(i),$.forEach(i),Mn=s(e),u(Te.$$.fragment,e),wn=s(e),rn=r(e,"P",{}),C(rn).forEach(i),this.h()},h(){U(l,"name","hf:doc:metadata"),U(l,"content",go),U(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,l),p(e,j,c),p(e,g,c),p(e,d,c),f(M,e,c),p(e,t,c),p(e,w,c),p(e,cn,c),p(e,ee,c),p(e,dn,c),p(e,ne,c),p(e,mn,c),p(e,te,c),p(e,pn,c),f(oe,e,c),p(e,gn,c),p(e,T,c),f(se,T,null),n(T,jn),n(T,ke),n(T,kn),n(T,Ge),n(T,Gn),n(T,Je),n(T,Jn),f(L,T,null),n(T,Cn),n(T,W),f(ae,W,null),n(W,Un),n(W,Ce),n(W,Bn),f(S,W,null),n(T,Zn),n(T,E),f(re,E,null),n(E,In),n(E,Ue),n(T,$n),n(T,q),f(ie,q,null),n(q,Wn),n(q,Be),n(T,zn),n(T,D),f(le,D,null),n(D,Vn),n(D,Ze),n(T,Hn),n(T,z),f(ce,z,null),n(z,Xn),n(z,Ie),n(z,Fn),n(z,$e),n(T,Rn),n(T,Y),f(de,Y,null),n(Y,Nn),n(Y,We),p(e,hn,c),f(me,e,c),p(e,un,c),p(e,v,c),f(pe,v,null),n(v,Ln),n(v,ze),n(v,Sn),n(v,Ve),n(v,En),n(v,He),n(v,qn),n(v,Xe),n(v,Dn),n(v,Fe),n(v,Yn),n(v,Re),n(v,Qn),n(v,V),f(ge,V,null),n(V,Pn),n(V,Ne),n(V,An),f(Q,V,null),n(v,On),n(v,H),f(he,H,null),n(H,Kn),n(H,Le),n(H,et),f(P,H,null),p(e,fn,c),f(ue,e,c),p(e,_n,c),p(e,k,c),f(fe,k,null),n(k,nt),n(k,Se),n(k,tt),n(k,Ee),n(k,ot),n(k,qe),n(k,st),n(k,De),n(k,at),n(k,X),f(_e,X,null),n(X,rt),n(X,Ye),n(X,it),f(A,X,null),n(k,lt),n(k,F),f(be,F,null),n(F,ct),n(F,Qe),n(F,dt),f(O,F,null),p(e,bn,c),f(ye,e,c),p(e,yn,c),p(e,J,c),f(Me,J,null),n(J,mt),n(J,Pe),n(J,pt),n(J,Ae),n(J,gt),n(J,Oe),n(J,ht),n(J,Ke),n(J,ut),n(J,K),f(we,K,null),n(K,ft),n(K,en),p(e,Mn,c),f(Te,e,c),p(e,wn,c),p(e,rn,c),Tn=!0},p(e,[c]){const x={};c&2&&(x.$$scope={dirty:c,ctx:e}),L.$set(x);const R={};c&2&&(R.$$scope={dirty:c,ctx:e}),S.$set(R);const xe={};c&2&&(xe.$$scope={dirty:c,ctx:e}),Q.$set(xe);const ve={};c&2&&(ve.$$scope={dirty:c,ctx:e}),P.$set(ve);const je={};c&2&&(je.$$scope={dirty:c,ctx:e}),A.$set(je);const N={};c&2&&(N.$$scope={dirty:c,ctx:e}),O.$set(N)},i(e){Tn||(_(M.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(L.$$.fragment,e),_(ae.$$.fragment,e),_(S.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(Q.$$.fragment,e),_(he.$$.fragment,e),_(P.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(A.$$.fragment,e),_(be.$$.fragment,e),_(O.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(we.$$.fragment,e),_(Te.$$.fragment,e),Tn=!0)},o(e){b(M.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(L.$$.fragment,e),b(ae.$$.fragment,e),b(S.$$.fragment,e),b(re.$$.fragment,e),b(ie.$$.fragment,e),b(le.$$.fragment,e),b(ce.$$.fragment,e),b(de.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(ge.$$.fragment,e),b(Q.$$.fragment,e),b(he.$$.fragment,e),b(P.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(_e.$$.fragment,e),b(A.$$.fragment,e),b(be.$$.fragment,e),b(O.$$.fragment,e),b(ye.$$.fragment,e),b(Me.$$.fragment,e),b(we.$$.fragment,e),b(Te.$$.fragment,e),Tn=!1},d(e){e&&(i(j),i(g),i(d),i(t),i(w),i(cn),i(ee),i(dn),i(ne),i(mn),i(te),i(pn),i(gn),i(T),i(hn),i(un),i(v),i(fn),i(_n),i(k),i(bn),i(yn),i(J),i(Mn),i(wn),i(rn)),i(l),y(M,e),y(oe,e),y(se),y(L),y(ae),y(S),y(re),y(ie),y(le),y(ce),y(de),y(me,e),y(pe),y(ge),y(Q),y(he),y(P),y(ue,e),y(fe),y(_e),y(A),y(be),y(O),y(ye,e),y(Me),y(we),y(Te,e)}}}const go='{"title":"Generation","local":"generation","sections":[{"title":"GenerationConfig","local":"transformers.GenerationConfig","sections":[],"depth":2},{"title":"GenerationMixin","local":"transformers.GenerationMixin","sections":[],"depth":2},{"title":"TFGenerationMixin","local":"transformers.TFGenerationMixin","sections":[],"depth":2},{"title":"FlaxGenerationMixin","local":"transformers.FlaxGenerationMixin","sections":[],"depth":2}],"depth":1}';function ho(Z){return eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class To extends no{constructor(l){super(),to(this,l,ho,po,Kt,{})}}export{To as component};
