import{s as Ds,f as Ys,o as Ks,n as Ms}from"../chunks/scheduler.25b97de1.js";import{S as en,i as tn,g as l,s as n,r as c,A as sn,h as i,f as s,c as a,j as C,u as m,x as f,k as _,y as r,a as o,v as p,d,t as g,w as h}from"../chunks/index.d9030fc9.js";import{T as nn}from"../chunks/Tip.baa67368.js";import{D as x}from"../chunks/Docstring.ffac8efa.js";import{C as $}from"../chunks/CodeBlock.e6cd0d95.js";import{E as As}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as j,E as an}from"../chunks/EditOnGithub.91d95064.js";function on(N){let u,b;return u=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdvdE9jcjJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHb3RPY3IyQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEdvdE9jcjIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR290T2NyMkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMFF3ZW4yLVZMLTdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBHb3RPY3IyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GotOcr2ForConditionalGeneration, GotOcr2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GotOcr2 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GotOcr2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Qwen2-VL-7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GotOcr2ForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c(u.$$.fragment)},l(y){m(u.$$.fragment,y)},m(y,M){p(u,y,M),b=!0},p:Ms,i(y){b||(d(u.$$.fragment,y),b=!0)},o(y){g(u.$$.fragment,y),b=!1},d(y){h(u,y)}}}function rn(N){let u,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){u=l("p"),u.innerHTML=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),f(u)!=="svelte-fincs2"&&(u.innerHTML=b)},m(y,M){o(y,u,M)},p:Ms,d(y){y&&s(u)}}}function ln(N){let u,b="Example:",y,M,Z;return M=new $({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEdvdE9jcjJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBUZXh0U3RyZWFtZXIlMEElMEFtb2RlbCUyMCUzRCUyMEdvdE9jcjJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMikudG8oJTIyY3VkYSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRm11bHRpX2JveC5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwY29sb3IlM0QlMjJncmVlbiUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBza2lwX3Byb21wdCUzRFRydWUlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHN0b3Bfc3RyaW5ncyUzRCclM0MlN0NpbV9lbmQlN0MlM0UnJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDA5NiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, GotOcr2ForConditionalGeneration, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = GotOcr2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/multi_box.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, color=<span class="hljs-string">&quot;green&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(processor.tokenizer, skip_prompt=<span class="hljs-literal">True</span>, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer = processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span>,
<span class="hljs-meta">... </span>    streamer=streamer,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;You should keep in mind what features from the module should be used, especially
when you&#x27;re planning to sell a template.&quot;</span>`,wrap:!1}}),{c(){u=l("p"),u.textContent=b,y=n(),c(M.$$.fragment)},l(T){u=i(T,"P",{"data-svelte-h":!0}),f(u)!=="svelte-11lpom8"&&(u.textContent=b),y=a(T),m(M.$$.fragment,T)},m(T,z){o(T,u,z),o(T,y,z),p(M,T,z),Z=!0},p:Ms,i(T){Z||(d(M.$$.fragment,T),Z=!0)},o(T){g(M.$$.fragment,T),Z=!1},d(T){T&&(s(u),s(y)),h(M,T)}}}function cn(N){let u,b,y,M,Z,T,z,nt,A,bs='The GOT-OCR2 model was proposed in <a href="https://arxiv.org/abs/2409.01704" rel="nofollow">General OCR Theory: Towards OCR-2.0 via a Unified End-to-end Model</a> by Haoran Wei, Chenglong Liu, Jinyue Chen, Jia Wang, Lingyu Kong, Yanming Xu, Zheng Ge, Liang Zhao, Jianjian Sun, Yuang Peng, Chunrui Han, Xiangyu Zhang.',at,D,Js="The abstract from the paper is the following:",ot,K,ws="<em>Traditional OCR systems (OCR-1.0) are increasingly unable to meet people’snusage due to the growing demand for intelligent processing of man-made opticalncharacters. In this paper, we collectively refer to all artificial optical signals (e.g., plain texts, math/molecular formulas, tables, charts, sheet music, and even geometric shapes) as “characters” and propose the General OCR Theory along with an excellent model, namely GOT, to promote the arrival of OCR-2.0. The GOT, with 580M parameters, is a unified, elegant, and end-to-end model, consisting of a high-compression encoder and a long-contexts decoder. As an OCR-2.0 model, GOT can handle all the above “characters” under various OCR tasks. On the input side, the model supports commonly used scene- and document-style images in slice and whole-page styles. On the output side, GOT can generate plain or formatted results (markdown/tikz/smiles/kern) via an easy prompt. Besides, the model enjoys interactive OCR features, i.e., region-level recognition guided by coordinates or colors. Furthermore, we also adapt dynamic resolution and multipage OCR technologies to GOT for better practicality. In experiments, we provide sufficient results to prove the superiority of our model.</em>",rt,V,js,lt,ee,Us='GOT-OCR2 training stages. Taken from the <a href="https://arxiv.org/abs/2409.01704">original paper.</a>',it,te,vs="Tips:",ct,se,Gs=`GOT-OCR2 works on a wide range of tasks, including plain document OCR, scene text OCR, formatted document OCR, and even OCR for tables, charts, mathematical formulas, geometric shapes, molecular formulas and sheet music. While this implementation of the model will only output plain text, the outputs can be further processed to render the desired format, with packages like <code>pdftex</code>, <code>mathpix</code>, <code>matplotlib</code>, <code>tikz</code>, <code>verovio</code> or <code>pyecharts</code>.
The model can also be used for interactive OCR, where the user can specify the region to be recognized by providing the coordinates or the color of the region’s bounding box.`,mt,ne,Is=`This model was contributed by <a href="https://huggingface.co/yonigozlan" rel="nofollow">yonigozlan</a>.
The original code can be found <a href="https://github.com/Ucas-HaoranWei/GOT-OCR2.0" rel="nofollow">here</a>.`,pt,ae,dt,oe,gt,re,ht,le,ut,ie,ft,ce,yt,me,Cs="GOT-OCR2 can also generate formatted text, such as markdown or LaTeX. Here is an example of how to generate formatted text:",Tt,pe,_t,de,Mt,ge,Zs=`Although it might be reasonable in most cases to use a “for loop” for multi-page processing, some text data with formatting across several pages make it necessary to process all pages at once. GOT introduces a multi-page OCR (without “for loop”) feature, where multiple pages can be processed by the model at once, whith the output being one continuous text.
Here is an example of how to process multiple pages at once:`,bt,he,Jt,ue,wt,fe,ks=`GOT supports a 1024×1024 input resolution, which is sufficient for most OCR tasks, such as scene OCR or processing A4-sized PDF pages. However, certain scenarios, like horizontally stitched two-page PDFs commonly found in academic papers or images with unusual aspect ratios, can lead to accuracy issues when processed as a single image. To address this, GOT can dynamically crop an image into patches, process them all at once, and merge the results for better accuracy with such inputs.
Here is an example of how to process cropped patches:`,jt,ye,Ut,Te,vt,_e,zs="GOT supports interactive OCR, where the user can specify the region to be recognized by providing the coordinates or the color of the region’s bounding box. Here is an example of how to process a specific region:",Gt,Me,It,be,Ct,Je,Rs=`Although this implementation of the model will only output plain text, the outputs can be further processed to render the desired format, with packages like <code>pdftex</code>, <code>mathpix</code>, <code>matplotlib</code>, <code>tikz</code>, <code>verovio</code> or <code>pyecharts</code>.
Here is an example of how to process sheet music:`,Zt,we,kt,q,xs,zt,je,Rt,J,Ue,Yt,Be,Ws=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ForConditionalGeneration">GotOcr2ForConditionalGeneration</a>. It is used to instantiate a
GotOcr2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of GOT-OCR-2.0.`,At,Oe,$s='e.g <a href="https://huggingface.co/stepfun-ai/GOT-OCR-2.0-hf" rel="nofollow">stepfun-ai/GOT-OCR-2.0-hf</a>',Dt,Xe,Ns=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Kt,F,xt,ve,Wt,R,Ge,es,Ee,Vs=`This is the configuration class to store the configuration of a <code>GotOcr2VisionModel</code>. It is used to instantiate a GOT_OCR2
vision encoder according to the specified arguments, defining the model architecture. Instantiating a configuration
defaults will yield a similar configuration to that of the SAM ViT-h
<a href="https://huggingface.co/facebook/sam-vit-huge" rel="nofollow">facebook/sam-vit-huge</a> architecture.`,ts,He,qs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,$t,Ie,Nt,w,Ce,ss,Qe,Fs="Constructs a GOT_OCR2 image processor.",ns,B,Ze,as,Le,Bs=`Crop the image to patches and return a list of cropped images.
The number of patches and their grid arrangement are determined by the original image size,
the target patch size and the minimum and maximum number of patches.
The aspect ratio of the patches grid is chosen to be the closest to the original image aspect ratio.`,os,O,ke,rs,Pe,Os="Preprocess an image or batch of images.",ls,X,ze,is,Se,Xs="Resize an image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>.",Vt,Re,qt,U,xe,cs,Ye,Es=`Constructs a GotOcr2 processor which wraps a <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ImageProcessor">GotOcr2ImageProcessor</a> and
<code>PretrainedTokenizerFast</code> tokenizer into a single processor that inherits both the image processor and
tokenizer functionalities. See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Processor.decode">decode()</a> for more information.`,ms,E,We,ps,Ae,Hs=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,ds,H,$e,gs,De,Qs=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Ft,Ne,Bt,v,Ve,hs,Ke,Ls=`The GOT_OCR2 model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,us,et,Ps=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,fs,k,qe,ys,tt,Ss='The <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ForConditionalGeneration">GotOcr2ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Ts,Q,_s,L,Ot,Fe,Xt,st,Et;return Z=new j({props:{title:"GOT-OCR2",local:"got-ocr2",headingTag:"h1"}}),z=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new j({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),oe=new j({props:{title:"Plain text inference",local:"plain-text-inference",headingTag:"h3"}}),re=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZpbWFnZV9vY3IuanBnJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwc3RvcF9zdHJpbmdzJTNEJTIyJTNDJTdDaW1fZW5kJTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q0MDk2JTJDJTBBKSUwQSUwQXByb2Nlc3Nvci5kZWNvZGUoZ2VuZXJhdGVfaWRzJTVCMCUyQyUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1QjElNUQlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/image_ocr.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;R&amp;D QUALITY IMPROVEMENT\\nSUGGESTION/SOLUTION FORM\\nName/Phone Ext. : (...)&quot;</span>`,wrap:!1}}),le=new j({props:{title:"Plain text inference batched",local:"plain-text-inference-batched",headingTag:"h3"}}),ie=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiklMEElMEFpbWFnZTElMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfZ290X29jciUyRnJlc29sdmUlMkZtYWluJTJGbXVsdGlfYm94LnBuZyUyMiUwQWltYWdlMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZpbWFnZV9vY3IuanBnJTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCU1QmltYWdlMSUyQyUyMGltYWdlMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHN0b3Bfc3RyaW5ncyUzRCUyMiUzQyU3Q2ltX2VuZCU3QyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENCUyQyUwQSklMEElMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyU1QiUzQSUyQyUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1QjElNUQlMjAlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/multi_box.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/image_ocr.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor([image1, image2], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>] :], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Reducing the number&quot;</span>, <span class="hljs-string">&quot;R&amp;D QUALITY&quot;</span>]`,wrap:!1}}),ce=new j({props:{title:"Formatted text inference",local:"formatted-text-inference",headingTag:"h3"}}),pe=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZsYXRleC5wbmclMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwZm9ybWF0JTNEVHJ1ZSkudG8oZGV2aWNlKSUwQSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwc3RvcF9zdHJpbmdzJTNEJTIyJTNDJTdDaW1fZW5kJTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q0MDk2JTJDJTBBKSUwQSUwQXByb2Nlc3Nvci5kZWNvZGUoZ2VuZXJhdGVfaWRzJTVCMCUyQyUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1QjElNUQlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/latex.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;\\\\author{\\nHanwen Jiang*{@html "<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mspace linebreak="newline"></mspace><mi>q</mi><mi>u</mi><mi>a</mi><mi>d</mi></mrow><annotation encoding="application/x-tex">\\\\quad</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="mspace newline"></span><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mord mathnormal">u</span><span class="mord mathnormal">a</span><span class="mord mathnormal">d</span></span></span></span>"} Arjun Karpur{@html "<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow></mrow><mrow><mspace linebreak="newline"></mspace><mi>d</mi><mi>a</mi><mi>g</mi><mi>g</mi><mi>e</mi><mi>r</mi></mrow></msup><mspace linebreak="newline"></mspace><mi>q</mi><mi>u</mi><mi>a</mi><mi>d</mi></mrow><annotation encoding="application/x-tex">{ }^{\\\\dagger} \\\\quad</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8491em;"></span><span class="mord"><span class="mord"></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mspace mtight newline"></span><span class="mord mathnormal mtight">d</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">gg</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">er</span></span></span></span></span></span></span></span></span></span><span class="mspace newline"></span><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mord mathnormal">u</span><span class="mord mathnormal">a</span><span class="mord mathnormal">d</span></span></span></span>"} Bingyi Cao{@html "<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow></mrow><mrow><mspace linebreak="newline"></mspace><mi>d</mi><mi>a</mi><mi>g</mi><mi>g</mi><mi>e</mi><mi>r</mi></mrow></msup><mspace linebreak="newline"></mspace><mi>q</mi><mi>u</mi><mi>a</mi><mi>d</mi></mrow><annotation encoding="application/x-tex">{ }^{\\\\dagger} \\\\quad</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8491em;"></span><span class="mord"><span class="mord"></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mspace mtight newline"></span><span class="mord mathnormal mtight">d</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">gg</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">er</span></span></span></span></span></span></span></span></span></span><span class="mspace newline"></span><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mord mathnormal">u</span><span class="mord mathnormal">a</span><span class="mord mathnormal">d</span></span></span></span>"} (...)&quot;</span>`,wrap:!1}}),de=new j({props:{title:"Inference on multiple pages",local:"inference-on-multiple-pages",headingTag:"h3"}}),he=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiklMEElMEFpbWFnZTElMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfZ290X29jciUyRnJlc29sdmUlMkZtYWluJTJGcGFnZTEucG5nJTIyJTBBaW1hZ2UyJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRnBhZ2UyLnBuZyUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglNUJpbWFnZTElMkMlMjBpbWFnZTIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwbXVsdGlfcGFnZSUzRFRydWUlMkMlMjBmb3JtYXQlM0RUcnVlKS50byhkZXZpY2UpJTBBJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzdG9wX3N0cmluZ3MlM0QlMjIlM0MlN0NpbV9lbmQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDQwOTYlMkMlMEEpJTBBJTBBcHJvY2Vzc29yLmRlY29kZShnZW5lcmF0ZV9pZHMlNUIwJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/page1.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/page2.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor([image1, image2], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, multi_page=<span class="hljs-literal">True</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;\\\\title{\\nGeneral OCR Theory: Towards OCR-2.0 via a Unified End-to-end Model\\n}\\n\\\\author{\\nHaoran Wei (...)&quot;</span>`,wrap:!1}}),ue=new j({props:{title:"Inference on cropped patches",local:"inference-on-cropped-patches",headingTag:"h3"}}),ye=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZvbmVfY29sdW1uLnBuZyUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBmb3JtYXQlM0RUcnVlJTJDJTIwY3JvcF90b19wYXRjaGVzJTNEVHJ1ZSUyQyUyMG1heF9wYXRjaGVzJTNEMykudG8oZGV2aWNlKSUwQSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwc3RvcF9zdHJpbmdzJTNEJTIyJTNDJTdDaW1fZW5kJTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q0MDk2JTJDJTBBKSUwQSUwQXByb2Nlc3Nvci5kZWNvZGUoZ2VuZXJhdGVfaWRzJTVCMCUyQyUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1QjElNUQlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, torch_dtype=torch.bfloat16, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/one_column.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>, crop_to_patches=<span class="hljs-literal">True</span>, max_patches=<span class="hljs-number">3</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;on developing architectural improvements to make learnable matching methods generalize.\\nMotivated by the above observations, (...)&quot;</span>`,wrap:!1}}),Te=new j({props:{title:"Inference on a specific region",local:"inference-on-a-specific-region",headingTag:"h3"}}),Me=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZtdWx0aV9ib3gucG5nJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMGNvbG9yJTNEJTIyZ3JlZW4lMjIpLnRvKGRldmljZSklMjAlMjMlMjBvciUyMGJveCUzRCU1QngxJTJDJTIweTElMkMlMjB4MiUyQyUyMHkyJTVEJTIwZm9yJTIwY29vcmRpbmF0ZXMlMjAoaW1hZ2UlMjBwaXhlbHMpJTBBJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzdG9wX3N0cmluZ3MlM0QlMjIlM0MlN0NpbV9lbmQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDQwOTYlMkMlMEEpJTBBJTBBcHJvY2Vzc29yLmRlY29kZShnZW5lcmF0ZV9pZHMlNUIwJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/multi_box.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, color=<span class="hljs-string">&quot;green&quot;</span>).to(device) <span class="hljs-comment"># or box=[x1, y1, x2, y2] for coordinates (image pixels)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;You should keep in mind what features from the module should be used, especially \\nwhen you’re planning to sell a template.&quot;</span>`,wrap:!1}}),be=new j({props:{title:"Inference on general OCR data example: sheet music",local:"inference-on-general-ocr-data-example-sheet-music",headingTag:"h3"}}),we=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB2ZXJvdmlvJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwZGV2aWNlX21hcCUzRGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfZ290X29jciUyRnJlc29sdmUlMkZtYWluJTJGc2hlZXRfbXVzaWMucG5nJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMGZvcm1hdCUzRFRydWUpLnRvKGRldmljZSklMEElMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHN0b3Bfc3RyaW5ncyUzRCUyMiUzQyU3Q2ltX2VuZCU3QyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDA5NiUyQyUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmRlY29kZShnZW5lcmF0ZV9pZHMlNUIwJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXRrJTIwJTNEJTIwdmVyb3Zpby50b29sa2l0KCklMEF0ay5sb2FkRGF0YShvdXRwdXRzKSUwQXRrLnNldE9wdGlvbnMoJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFnZVdpZHRoJTIyJTNBJTIwMjEwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhZ2VIZWlnaHQlMjIlM0ElMjA4MDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmb290ZXIlMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmFyTGluZVdpZHRoJTIyJTNBJTIwMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmVhbU1heFNsb3BlJTIyJTNBJTIwMTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFmZkxpbmVXaWR0aCUyMiUzQSUyMDAuMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwYWNpbmdTdGFmZiUyMiUzQSUyMDYlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBdGsuZ2V0UGFnZUNvdW50KCklMEFzdmclMjAlM0QlMjB0ay5yZW5kZXJUb1NWRygpJTBBc3ZnJTIwJTNEJTIwc3ZnLnJlcGxhY2UoJ292ZXJmbG93JTNEJTIyaW5oZXJpdCUyMiclMkMlMjAnb3ZlcmZsb3clM0QlMjJ2aXNpYmxlJTIyJyklMEF3aXRoJTIwb3BlbiglMjJvdXRwdXQuc3ZnJTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKHN2Zyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> verovio

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/sheet_music.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tk = verovio.toolkit()
<span class="hljs-meta">&gt;&gt;&gt; </span>tk.loadData(outputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tk.setOptions(
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pageWidth&quot;</span>: <span class="hljs-number">2100</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pageHeight&quot;</span>: <span class="hljs-number">800</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;footer&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;barLineWidth&quot;</span>: <span class="hljs-number">0.5</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;beamMaxSlope&quot;</span>: <span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;staffLineWidth&quot;</span>: <span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;spacingStaff&quot;</span>: <span class="hljs-number">6</span>,
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tk.getPageCount()
<span class="hljs-meta">&gt;&gt;&gt; </span>svg = tk.renderToSVG()
<span class="hljs-meta">&gt;&gt;&gt; </span>svg = svg.replace(<span class="hljs-string">&#x27;overflow=&quot;inherit&quot;&#x27;</span>, <span class="hljs-string">&#x27;overflow=&quot;visible&quot;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;output.svg&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">&gt;&gt;&gt; </span>    f.write(svg)`,wrap:!1}}),je=new j({props:{title:"GotOcr2Config",local:"transformers.GotOcr2Config",headingTag:"h2"}}),Ue=new x({props:{name:"class transformers.GotOcr2Config",anchor:"transformers.GotOcr2Config",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 151859"},{name:"image_seq_length",val:" = 576"},{name:"pad_token_id",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2Config.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.GotOcr2Config.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.GotOcr2Config.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151859) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.GotOcr2Config.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.GotOcr2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Padding token id.`,name:"pad_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/configuration_got_ocr2.py#L118"}}),F=new As({props:{anchor:"transformers.GotOcr2Config.example",$$slots:{default:[on]},$$scope:{ctx:N}}}),ve=new j({props:{title:"GotOcr2VisionConfig",local:"transformers.GotOcr2VisionConfig",headingTag:"h2"}}),Ge=new x({props:{name:"class transformers.GotOcr2VisionConfig",anchor:"transformers.GotOcr2VisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"output_channels",val:" = 256"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 1e-10"},{name:"qkv_bias",val:" = True"},{name:"use_abs_pos",val:" = True"},{name:"use_rel_pos",val:" = True"},{name:"window_size",val:" = 14"},{name:"global_attn_indexes",val:" = [2, 5, 8, 11]"},{name:"mlp_dim",val:" = 3072"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.GotOcr2VisionConfig.output_channels",description:`<strong>output_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the output channels in the Patch Encoder.`,name:"output_channels"},{anchor:"transformers.GotOcr2VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.GotOcr2VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GotOcr2VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input image.`,name:"num_channels"},{anchor:"transformers.GotOcr2VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Expected resolution. Target size of the resized input image.`,name:"image_size"},{anchor:"transformers.GotOcr2VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Size of the patches to be extracted from the input image.`,name:"patch_size"},{anchor:"transformers.GotOcr2VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string)`,name:"hidden_act"},{anchor:"transformers.GotOcr2VisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GotOcr2VisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.GotOcr2VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-10) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GotOcr2VisionConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to query, key, value projections.`,name:"qkv_bias"},{anchor:"transformers.GotOcr2VisionConfig.use_abs_pos",description:`<strong>use_abs_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use absolute position embedding.`,name:"use_abs_pos"},{anchor:"transformers.GotOcr2VisionConfig.use_rel_pos",description:`<strong>use_rel_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use relative position embedding.`,name:"use_rel_pos"},{anchor:"transformers.GotOcr2VisionConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
Window size for relative position.`,name:"window_size"},{anchor:"transformers.GotOcr2VisionConfig.global_attn_indexes",description:`<strong>global_attn_indexes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
The indexes of the global attention layers.`,name:"global_attn_indexes"},{anchor:"transformers.GotOcr2VisionConfig.mlp_dim",description:`<strong>mlp_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
The dimensionality of the MLP layer in the Transformer encoder.`,name:"mlp_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/configuration_got_ocr2.py#L27"}}),Ie=new j({props:{title:"GotOcr2ImageProcessor",local:"transformers.GotOcr2ImageProcessor",headingTag:"h2"}}),Ce=new x({props:{name:"class transformers.GotOcr2ImageProcessor",anchor:"transformers.GotOcr2ImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.GotOcr2ImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 384}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.GotOcr2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.GotOcr2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.GotOcr2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.GotOcr2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.GotOcr2ImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L134"}}),Ze=new x({props:{name:"crop_image_to_patches",anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches",parameters:[{name:"image",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"min_patches",val:": int"},{name:"max_patches",val:": int"},{name:"use_thumbnail",val:": bool = True"},{name:"patch_size",val:": typing.Union[typing.Tuple, int, dict] = None"},{name:"return_numpy",val:": bool = False"},{name:"data_format",val:": ChannelDimension = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
The image to be cropped. The image can be a PIL image, NumPy array or PyTorch tensor.`,name:"image"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.min_patches",description:`<strong>min_patches</strong> (<code>int</code>) &#x2014;
The minimum number of patches to be extracted from the image.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.max_patches",description:`<strong>max_patches</strong> (<code>int</code>) &#x2014;
The maximum number of patches to be extracted from the image.`,name:"max_patches"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.use_thumbnail",description:`<strong>use_thumbnail</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a thumbnail image to the list of cropped patches.`,name:"use_thumbnail"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <code>Tuple[int, int]</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The size of the output patches.`,name:"patch_size"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.return_numpy",description:`<strong>return_numpy</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return the cropped images as NumPy arrays.`,name:"return_numpy"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The format of the image data. If <code>None</code>, the format is inferred from the input image.`,name:"data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L382",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of cropped images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>PIL.Image.Image</code> or List[np.ndarray]</p>
`}}),ke=new x({props:{name:"preprocess",anchor:"transformers.GotOcr2ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Controls the size of the image after <code>resize</code>. The shortest edge of the image is resized to
<code>size[&quot;shortest_edge&quot;]</code> whilst preserving the aspect ratio. If the longest edge of this resized image
is &gt; <code>int(size[&quot;shortest_edge&quot;] * (1333 / 800))</code>, then the image is resized again to make the longest
edge equal to <code>int(size[&quot;shortest_edge&quot;] * (1333 / 800))</code>.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L246"}}),ze=new x({props:{name:"resize",anchor:"transformers.GotOcr2ImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.GotOcr2ImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the output image.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BICUBIC</code>.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. If unset, the channel dimension format of the input
image is used. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GotOcr2ImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L198",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Re=new j({props:{title:"GotOcr2Processor",local:"transformers.GotOcr2Processor",headingTag:"h2"}}),xe=new x({props:{name:"class transformers.GotOcr2Processor",anchor:"transformers.GotOcr2Processor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ImageProcessor">GotOcr2ImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.GotOcr2Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>PreTrainedTokenizer</code>, <code>PreTrainedTokenizerFast</code>], <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.GotOcr2Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/processing_got_ocr2.py#L87"}}),We=new x({props:{name:"batch_decode",anchor:"transformers.GotOcr2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/processing_got_ocr2.py#L273"}}),$e=new x({props:{name:"decode",anchor:"transformers.GotOcr2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/processing_got_ocr2.py#L280"}}),Ne=new j({props:{title:"GotOcr2ForConditionalGeneration",local:"transformers.GotOcr2ForConditionalGeneration",headingTag:"h2"}}),Ve=new x({props:{name:"class transformers.GotOcr2ForConditionalGeneration",anchor:"transformers.GotOcr2ForConditionalGeneration",parameters:[{name:"config",val:": GotOcr2Config"}],parametersDescription:[{anchor:"transformers.GotOcr2ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Config">GotOcr2Config</a> or <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2VisionConfig">GotOcr2VisionConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L700"}}),qe=new x({props:{name:"forward",anchor:"transformers.GotOcr2ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"}],parametersDescription:[{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.pixel_values",description:'<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [CLIPImageProcessor.__call__()](/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__) for details ([]</code>GotOcr2Processor`] uses\n<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> for processing images).',name:"pixel_values"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>logits_to_keep (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>):
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L753",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.got_ocr2.modeling_got_ocr2.GotOcr2CausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Config"
>GotOcr2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.got_ocr2.modeling_got_ocr2.GotOcr2CausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new nn({props:{$$slots:{default:[rn]},$$scope:{ctx:N}}}),L=new As({props:{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.example",$$slots:{default:[ln]},$$scope:{ctx:N}}}),Fe=new an({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/got_ocr2.md"}}),{c(){u=l("meta"),b=n(),y=l("p"),M=n(),c(Z.$$.fragment),T=n(),c(z.$$.fragment),nt=n(),A=l("p"),A.innerHTML=bs,at=n(),D=l("p"),D.textContent=Js,ot=n(),K=l("p"),K.innerHTML=ws,rt=n(),V=l("img"),lt=n(),ee=l("small"),ee.innerHTML=Us,it=n(),te=l("p"),te.textContent=vs,ct=n(),se=l("p"),se.innerHTML=Gs,mt=n(),ne=l("p"),ne.innerHTML=Is,pt=n(),c(ae.$$.fragment),dt=n(),c(oe.$$.fragment),gt=n(),c(re.$$.fragment),ht=n(),c(le.$$.fragment),ut=n(),c(ie.$$.fragment),ft=n(),c(ce.$$.fragment),yt=n(),me=l("p"),me.textContent=Cs,Tt=n(),c(pe.$$.fragment),_t=n(),c(de.$$.fragment),Mt=n(),ge=l("p"),ge.textContent=Zs,bt=n(),c(he.$$.fragment),Jt=n(),c(ue.$$.fragment),wt=n(),fe=l("p"),fe.textContent=ks,jt=n(),c(ye.$$.fragment),Ut=n(),c(Te.$$.fragment),vt=n(),_e=l("p"),_e.textContent=zs,Gt=n(),c(Me.$$.fragment),It=n(),c(be.$$.fragment),Ct=n(),Je=l("p"),Je.innerHTML=Rs,Zt=n(),c(we.$$.fragment),kt=n(),q=l("img"),zt=n(),c(je.$$.fragment),Rt=n(),J=l("div"),c(Ue.$$.fragment),Yt=n(),Be=l("p"),Be.innerHTML=Ws,At=n(),Oe=l("p"),Oe.innerHTML=$s,Dt=n(),Xe=l("p"),Xe.innerHTML=Ns,Kt=n(),c(F.$$.fragment),xt=n(),c(ve.$$.fragment),Wt=n(),R=l("div"),c(Ge.$$.fragment),es=n(),Ee=l("p"),Ee.innerHTML=Vs,ts=n(),He=l("p"),He.innerHTML=qs,$t=n(),c(Ie.$$.fragment),Nt=n(),w=l("div"),c(Ce.$$.fragment),ss=n(),Qe=l("p"),Qe.textContent=Fs,ns=n(),B=l("div"),c(Ze.$$.fragment),as=n(),Le=l("p"),Le.textContent=Bs,os=n(),O=l("div"),c(ke.$$.fragment),rs=n(),Pe=l("p"),Pe.textContent=Os,ls=n(),X=l("div"),c(ze.$$.fragment),is=n(),Se=l("p"),Se.innerHTML=Xs,Vt=n(),c(Re.$$.fragment),qt=n(),U=l("div"),c(xe.$$.fragment),cs=n(),Ye=l("p"),Ye.innerHTML=Es,ms=n(),E=l("div"),c(We.$$.fragment),ps=n(),Ae=l("p"),Ae.innerHTML=Hs,ds=n(),H=l("div"),c($e.$$.fragment),gs=n(),De=l("p"),De.innerHTML=Qs,Ft=n(),c(Ne.$$.fragment),Bt=n(),v=l("div"),c(Ve.$$.fragment),hs=n(),Ke=l("p"),Ke.innerHTML=Ls,us=n(),et=l("p"),et.innerHTML=Ps,fs=n(),k=l("div"),c(qe.$$.fragment),ys=n(),tt=l("p"),tt.innerHTML=Ss,Ts=n(),c(Q.$$.fragment),_s=n(),c(L.$$.fragment),Ot=n(),c(Fe.$$.fragment),Xt=n(),st=l("p"),this.h()},l(e){const t=sn("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(s),b=a(e),y=i(e,"P",{}),C(y).forEach(s),M=a(e),m(Z.$$.fragment,e),T=a(e),m(z.$$.fragment,e),nt=a(e),A=i(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-g5p5bk"&&(A.innerHTML=bs),at=a(e),D=i(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-vfdo9a"&&(D.textContent=Js),ot=a(e),K=i(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1gg8rmy"&&(K.innerHTML=ws),rt=a(e),V=i(e,"IMG",{src:!0,alt:!0,width:!0}),lt=a(e),ee=i(e,"SMALL",{"data-svelte-h":!0}),f(ee)!=="svelte-a6x3c0"&&(ee.innerHTML=Us),it=a(e),te=i(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-axv494"&&(te.textContent=vs),ct=a(e),se=i(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-16ypbp5"&&(se.innerHTML=Gs),mt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1m1qiop"&&(ne.innerHTML=Is),pt=a(e),m(ae.$$.fragment,e),dt=a(e),m(oe.$$.fragment,e),gt=a(e),m(re.$$.fragment,e),ht=a(e),m(le.$$.fragment,e),ut=a(e),m(ie.$$.fragment,e),ft=a(e),m(ce.$$.fragment,e),yt=a(e),me=i(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-148y0f4"&&(me.textContent=Cs),Tt=a(e),m(pe.$$.fragment,e),_t=a(e),m(de.$$.fragment,e),Mt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-14wxjuz"&&(ge.textContent=Zs),bt=a(e),m(he.$$.fragment,e),Jt=a(e),m(ue.$$.fragment,e),wt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-17mhybv"&&(fe.textContent=ks),jt=a(e),m(ye.$$.fragment,e),Ut=a(e),m(Te.$$.fragment,e),vt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-2al3wt"&&(_e.textContent=zs),Gt=a(e),m(Me.$$.fragment,e),It=a(e),m(be.$$.fragment,e),Ct=a(e),Je=i(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-ebj6ng"&&(Je.innerHTML=Rs),Zt=a(e),m(we.$$.fragment,e),kt=a(e),q=i(e,"IMG",{src:!0,alt:!0,width:!0}),zt=a(e),m(je.$$.fragment,e),Rt=a(e),J=i(e,"DIV",{class:!0});var G=C(J);m(Ue.$$.fragment,G),Yt=a(G),Be=i(G,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-nodo4f"&&(Be.innerHTML=Ws),At=a(G),Oe=i(G,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-t42ckt"&&(Oe.innerHTML=$s),Dt=a(G),Xe=i(G,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-o55m63"&&(Xe.innerHTML=Ns),Kt=a(G),m(F.$$.fragment,G),G.forEach(s),xt=a(e),m(ve.$$.fragment,e),Wt=a(e),R=i(e,"DIV",{class:!0});var W=C(R);m(Ge.$$.fragment,W),es=a(W),Ee=i(W,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-1dcilvq"&&(Ee.innerHTML=Vs),ts=a(W),He=i(W,"P",{"data-svelte-h":!0}),f(He)!=="svelte-o55m63"&&(He.innerHTML=qs),W.forEach(s),$t=a(e),m(Ie.$$.fragment,e),Nt=a(e),w=i(e,"DIV",{class:!0});var I=C(w);m(Ce.$$.fragment,I),ss=a(I),Qe=i(I,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-youup"&&(Qe.textContent=Fs),ns=a(I),B=i(I,"DIV",{class:!0});var Ht=C(B);m(Ze.$$.fragment,Ht),as=a(Ht),Le=i(Ht,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-j3z5fq"&&(Le.textContent=Bs),Ht.forEach(s),os=a(I),O=i(I,"DIV",{class:!0});var Qt=C(O);m(ke.$$.fragment,Qt),rs=a(Qt),Pe=i(Qt,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1x3yxsa"&&(Pe.textContent=Os),Qt.forEach(s),ls=a(I),X=i(I,"DIV",{class:!0});var Lt=C(X);m(ze.$$.fragment,Lt),is=a(Lt),Se=i(Lt,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-1oee9wu"&&(Se.innerHTML=Xs),Lt.forEach(s),I.forEach(s),Vt=a(e),m(Re.$$.fragment,e),qt=a(e),U=i(e,"DIV",{class:!0});var P=C(U);m(xe.$$.fragment,P),cs=a(P),Ye=i(P,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1v291js"&&(Ye.innerHTML=Es),ms=a(P),E=i(P,"DIV",{class:!0});var Pt=C(E);m(We.$$.fragment,Pt),ps=a(Pt),Ae=i(Pt,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-1yrf9bj"&&(Ae.innerHTML=Hs),Pt.forEach(s),ds=a(P),H=i(P,"DIV",{class:!0});var St=C(H);m($e.$$.fragment,St),gs=a(St),De=i(St,"P",{"data-svelte-h":!0}),f(De)!=="svelte-1jl7gd5"&&(De.innerHTML=Qs),St.forEach(s),P.forEach(s),Ft=a(e),m(Ne.$$.fragment,e),Bt=a(e),v=i(e,"DIV",{class:!0});var S=C(v);m(Ve.$$.fragment,S),hs=a(S),Ke=i(S,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-1abibdw"&&(Ke.innerHTML=Ls),us=a(S),et=i(S,"P",{"data-svelte-h":!0}),f(et)!=="svelte-hswkmf"&&(et.innerHTML=Ps),fs=a(S),k=i(S,"DIV",{class:!0});var Y=C(k);m(qe.$$.fragment,Y),ys=a(Y),tt=i(Y,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-17arr04"&&(tt.innerHTML=Ss),Ts=a(Y),m(Q.$$.fragment,Y),_s=a(Y),m(L.$$.fragment,Y),Y.forEach(s),S.forEach(s),Ot=a(e),m(Fe.$$.fragment,e),Xt=a(e),st=i(e,"P",{}),C(st).forEach(s),this.h()},h(){_(u,"name","hf:doc:metadata"),_(u,"content",mn),Ys(V.src,js="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/got_ocr_overview.png")||_(V,"src",js),_(V,"alt","drawing"),_(V,"width","600"),Ys(q.src,xs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sheet_music.svg")||_(q,"src",xs),_(q,"alt","drawing"),_(q,"width","600"),_(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,u),o(e,b,t),o(e,y,t),o(e,M,t),p(Z,e,t),o(e,T,t),p(z,e,t),o(e,nt,t),o(e,A,t),o(e,at,t),o(e,D,t),o(e,ot,t),o(e,K,t),o(e,rt,t),o(e,V,t),o(e,lt,t),o(e,ee,t),o(e,it,t),o(e,te,t),o(e,ct,t),o(e,se,t),o(e,mt,t),o(e,ne,t),o(e,pt,t),p(ae,e,t),o(e,dt,t),p(oe,e,t),o(e,gt,t),p(re,e,t),o(e,ht,t),p(le,e,t),o(e,ut,t),p(ie,e,t),o(e,ft,t),p(ce,e,t),o(e,yt,t),o(e,me,t),o(e,Tt,t),p(pe,e,t),o(e,_t,t),p(de,e,t),o(e,Mt,t),o(e,ge,t),o(e,bt,t),p(he,e,t),o(e,Jt,t),p(ue,e,t),o(e,wt,t),o(e,fe,t),o(e,jt,t),p(ye,e,t),o(e,Ut,t),p(Te,e,t),o(e,vt,t),o(e,_e,t),o(e,Gt,t),p(Me,e,t),o(e,It,t),p(be,e,t),o(e,Ct,t),o(e,Je,t),o(e,Zt,t),p(we,e,t),o(e,kt,t),o(e,q,t),o(e,zt,t),p(je,e,t),o(e,Rt,t),o(e,J,t),p(Ue,J,null),r(J,Yt),r(J,Be),r(J,At),r(J,Oe),r(J,Dt),r(J,Xe),r(J,Kt),p(F,J,null),o(e,xt,t),p(ve,e,t),o(e,Wt,t),o(e,R,t),p(Ge,R,null),r(R,es),r(R,Ee),r(R,ts),r(R,He),o(e,$t,t),p(Ie,e,t),o(e,Nt,t),o(e,w,t),p(Ce,w,null),r(w,ss),r(w,Qe),r(w,ns),r(w,B),p(Ze,B,null),r(B,as),r(B,Le),r(w,os),r(w,O),p(ke,O,null),r(O,rs),r(O,Pe),r(w,ls),r(w,X),p(ze,X,null),r(X,is),r(X,Se),o(e,Vt,t),p(Re,e,t),o(e,qt,t),o(e,U,t),p(xe,U,null),r(U,cs),r(U,Ye),r(U,ms),r(U,E),p(We,E,null),r(E,ps),r(E,Ae),r(U,ds),r(U,H),p($e,H,null),r(H,gs),r(H,De),o(e,Ft,t),p(Ne,e,t),o(e,Bt,t),o(e,v,t),p(Ve,v,null),r(v,hs),r(v,Ke),r(v,us),r(v,et),r(v,fs),r(v,k),p(qe,k,null),r(k,ys),r(k,tt),r(k,Ts),p(Q,k,null),r(k,_s),p(L,k,null),o(e,Ot,t),p(Fe,e,t),o(e,Xt,t),o(e,st,t),Et=!0},p(e,[t]){const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),F.$set(G);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),Q.$set(W);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),L.$set(I)},i(e){Et||(d(Z.$$.fragment,e),d(z.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(ce.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(F.$$.fragment,e),d(ve.$$.fragment,e),d(Ge.$$.fragment,e),d(Ie.$$.fragment,e),d(Ce.$$.fragment,e),d(Ze.$$.fragment,e),d(ke.$$.fragment,e),d(ze.$$.fragment,e),d(Re.$$.fragment,e),d(xe.$$.fragment,e),d(We.$$.fragment,e),d($e.$$.fragment,e),d(Ne.$$.fragment,e),d(Ve.$$.fragment,e),d(qe.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(Fe.$$.fragment,e),Et=!0)},o(e){g(Z.$$.fragment,e),g(z.$$.fragment,e),g(ae.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(Ue.$$.fragment,e),g(F.$$.fragment,e),g(ve.$$.fragment,e),g(Ge.$$.fragment,e),g(Ie.$$.fragment,e),g(Ce.$$.fragment,e),g(Ze.$$.fragment,e),g(ke.$$.fragment,e),g(ze.$$.fragment,e),g(Re.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g($e.$$.fragment,e),g(Ne.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Q.$$.fragment,e),g(L.$$.fragment,e),g(Fe.$$.fragment,e),Et=!1},d(e){e&&(s(b),s(y),s(M),s(T),s(nt),s(A),s(at),s(D),s(ot),s(K),s(rt),s(V),s(lt),s(ee),s(it),s(te),s(ct),s(se),s(mt),s(ne),s(pt),s(dt),s(gt),s(ht),s(ut),s(ft),s(yt),s(me),s(Tt),s(_t),s(Mt),s(ge),s(bt),s(Jt),s(wt),s(fe),s(jt),s(Ut),s(vt),s(_e),s(Gt),s(It),s(Ct),s(Je),s(Zt),s(kt),s(q),s(zt),s(Rt),s(J),s(xt),s(Wt),s(R),s($t),s(Nt),s(w),s(Vt),s(qt),s(U),s(Ft),s(Bt),s(v),s(Ot),s(Xt),s(st)),s(u),h(Z,e),h(z,e),h(ae,e),h(oe,e),h(re,e),h(le,e),h(ie,e),h(ce,e),h(pe,e),h(de,e),h(he,e),h(ue,e),h(ye,e),h(Te,e),h(Me,e),h(be,e),h(we,e),h(je,e),h(Ue),h(F),h(ve,e),h(Ge),h(Ie,e),h(Ce),h(Ze),h(ke),h(ze),h(Re,e),h(xe),h(We),h($e),h(Ne,e),h(Ve),h(qe),h(Q),h(L),h(Fe,e)}}}const mn='{"title":"GOT-OCR2","local":"got-ocr2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Plain text inference","local":"plain-text-inference","sections":[],"depth":3},{"title":"Plain text inference batched","local":"plain-text-inference-batched","sections":[],"depth":3},{"title":"Formatted text inference","local":"formatted-text-inference","sections":[],"depth":3},{"title":"Inference on multiple pages","local":"inference-on-multiple-pages","sections":[],"depth":3},{"title":"Inference on cropped patches","local":"inference-on-cropped-patches","sections":[],"depth":3},{"title":"Inference on a specific region","local":"inference-on-a-specific-region","sections":[],"depth":3},{"title":"Inference on general OCR data example: sheet music","local":"inference-on-general-ocr-data-example-sheet-music","sections":[],"depth":3}],"depth":2},{"title":"GotOcr2Config","local":"transformers.GotOcr2Config","sections":[],"depth":2},{"title":"GotOcr2VisionConfig","local":"transformers.GotOcr2VisionConfig","sections":[],"depth":2},{"title":"GotOcr2ImageProcessor","local":"transformers.GotOcr2ImageProcessor","sections":[],"depth":2},{"title":"GotOcr2Processor","local":"transformers.GotOcr2Processor","sections":[],"depth":2},{"title":"GotOcr2ForConditionalGeneration","local":"transformers.GotOcr2ForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function pn(N){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _n extends en{constructor(u){super(),tn(this,u,pn,cn,Ds,{})}}export{_n as component};
