import{s as jn,n as Cn,o as In}from"../chunks/scheduler.25b97de1.js";import{S as kn,i as Jn,g as r,s as l,r as g,A as Un,h as d,f as n,c as a,j as $n,u as o,x as c,k as Ee,y as Zn,a as i,v as s,d as m,t as h,w as p}from"../chunks/index.d9030fc9.js";import{C as De}from"../chunks/CodeBlock.e6cd0d95.js";import{H as f,E as Rn}from"../chunks/EditOnGithub.91d95064.js";function Bn(Le){let b,kt,Ct,Jt,u,Ut,y,ze='This guide aims to provide a benchmark on the inference speed-ups introduced with <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile()</code></a> for <a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers&amp;sort=trending" rel="nofollow">computer vision models in 🤗 Transformers</a>.',Zt,v,Rt,w,Ge="Depending on the model and the GPU, <code>torch.compile()</code> yields up to 30% speed-up during inference. To use <code>torch.compile()</code>, simply install any version of <code>torch</code> above 2.0.",Bt,$,He=`Compiling a model takes time, so it’s useful if you are compiling the model only once instead of every time you infer.
To compile any computer vision model of your choice, call <code>torch.compile()</code> on the model as shown below:`,_t,j,St,C,Xe='<code>compile()</code> comes with multiple modes for compiling, which essentially differ in compilation time and inference overhead. <code>max-autotune</code> takes longer than <code>reduce-overhead</code> but results in faster inference. Default mode is fastest for compilation but is not as efficient compared to <code>reduce-overhead</code> for inference time. In this guide, we used the default mode. You can learn more about it <a href="https://pytorch.org/get-started/pytorch-2.0/#user-experience" rel="nofollow">here</a>.',Nt,I,xe="We benchmarked <code>torch.compile</code> with different computer vision models, tasks, types of hardware, and batch sizes on <code>torch</code> version 2.0.1.",Vt,k,Wt,J,Oe="Below you can find the benchmarking code for each task. We warm up the GPU before inference and take the mean time of 300 inferences, using the same image each time.",Et,U,Dt,Z,Lt,R,zt,B,Gt,_,Ht,S,Xt,N,Ye="Below you can find the list of the models we benchmarked.",xt,V,Qe="<strong>Image Classification</strong>",Ot,W,Ae='<li><a href="https://huggingface.co/google/vit-base-patch16-224" rel="nofollow">google/vit-base-patch16-224</a></li> <li><a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k-ft22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k-ft22k</a></li> <li><a href="https://huggingface.co/facebook/convnext-large-224" rel="nofollow">facebook/convnext-large-224</a></li> <li><a href="https://huggingface.co/microsoft/resnet-50" rel="nofollow">microsoft/resnet-50</a></li>',Yt,E,Fe="<strong>Image Segmentation</strong>",Qt,D,Pe='<li><a href="https://huggingface.co/nvidia/segformer-b0-finetuned-ade-512-512" rel="nofollow">nvidia/segformer-b0-finetuned-ade-512-512</a></li> <li><a href="https://huggingface.co/facebook/mask2former-swin-tiny-coco-panoptic" rel="nofollow">facebook/mask2former-swin-tiny-coco-panoptic</a></li> <li><a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a></li> <li><a href="https://huggingface.co/google/deeplabv3_mobilenet_v2_1.0_513" rel="nofollow">google/deeplabv3_mobilenet_v2_1.0_513</a></li>',At,L,qe="<strong>Object Detection</strong>",Ft,z,Ke='<li><a href="https://huggingface.co/google/owlvit-base-patch32" rel="nofollow">google/owlvit-base-patch32</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-101" rel="nofollow">facebook/detr-resnet-101</a></li> <li><a href="https://huggingface.co/microsoft/conditional-detr-resnet-50" rel="nofollow">microsoft/conditional-detr-resnet-50</a></li>',Pt,G,tn="Below you can find visualization of inference durations with and without <code>torch.compile()</code> and percentage improvements for each model in different hardware and batch sizes.",qt,T,en='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/a100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/t4_batch_comp.png"/></div>',Kt,M,nn='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_duration.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_percentage.png"/></div>',te,H,ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_1_duration.png" alt="Duration Comparison on V100 with Batch Size of 1"/>',ee,X,an='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/T4_4_percentage.png" alt="Percentage Improvement on T4 with Batch Size of 4"/>',ne,x,rn="Below you can find inference durations in milliseconds for each model with and without <code>compile()</code>. Note that OwlViT results in OOM in larger batch sizes.",ie,O,le,Y,dn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">9.325</td> <td align="center">7.584</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">11.759</td> <td align="center">10.500</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">24.978</td> <td align="center">18.420</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.282</td> <td align="center">8.448</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">34.619</td> <td align="center">19.040</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">10.410</td> <td align="center">10.208</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.531</td> <td align="center">4.124</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">60.188</td> <td align="center">49.117</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">75.764</td> <td align="center">59.487</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">8.583</td> <td align="center">3.974</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">36.276</td> <td align="center">18.197</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">31.219</td> <td align="center">17.993</td></tr></tbody>',ae,Q,re,A,cn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">14.832</td> <td align="center">14.499</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">18.838</td> <td align="center">16.476</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">13.205</td> <td align="center">13.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">48.657</td> <td align="center">32.418</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">22.940</td> <td align="center">21.631</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.657</td> <td align="center">4.268</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">74.277</td> <td align="center">61.781</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">180.700</td> <td align="center">159.116</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">14.174</td> <td align="center">8.515</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">68.101</td> <td align="center">44.998</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">56.470</td> <td align="center">35.552</td></tr></tbody>',de,F,ce,P,gn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">40.944</td> <td align="center">40.010</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">37.005</td> <td align="center">31.144</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">41.854</td> <td align="center">41.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">164.382</td> <td align="center">161.902</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">82.258</td> <td align="center">75.561</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">7.018</td> <td align="center">5.024</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">178.945</td> <td align="center">154.814</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">638.570</td> <td align="center">579.826</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">51.693</td> <td align="center">30.310</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">232.887</td> <td align="center">155.021</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">180.491</td> <td align="center">124.032</td></tr></tbody>',ge,q,oe,K,on='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">10.495</td> <td align="center">6.00</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">13.321</td> <td align="center">5.862</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">25.769</td> <td align="center">22.395</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.347</td> <td align="center">7.234</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">33.951</td> <td align="center">19.388</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">11.623</td> <td align="center">10.412</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.484</td> <td align="center">3.820</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">64.640</td> <td align="center">49.873</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">95.532</td> <td align="center">72.207</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">9.217</td> <td align="center">4.753</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">52.818</td> <td align="center">28.367</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">39.512</td> <td align="center">20.816</td></tr></tbody>',se,tt,me,et,sn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">15.181</td> <td align="center">14.501</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.787</td> <td align="center">16.188</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">15.171</td> <td align="center">14.753</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">88.529</td> <td align="center">64.195</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">29.574</td> <td align="center">27.085</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.109</td> <td align="center">4.731</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">90.402</td> <td align="center">76.926</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">234.261</td> <td align="center">205.456</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">24.623</td> <td align="center">14.816</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">134.672</td> <td align="center">101.304</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">97.464</td> <td align="center">69.739</td></tr></tbody>',he,nt,pe,it,mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">52.209</td> <td align="center">51.633</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">61.013</td> <td align="center">55.499</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">53.938</td> <td align="center">53.581</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">109.682</td> <td align="center">100.771</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">14.857</td> <td align="center">12.089</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">249.605</td> <td align="center">222.801</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">831.142</td> <td align="center">743.645</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">93.129</td> <td align="center">55.365</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">482.425</td> <td align="center">361.843</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">344.661</td> <td align="center">255.298</td></tr></tbody>',fe,lt,be,at,hn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">16.520</td> <td align="center">15.786</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.116</td> <td align="center">14.205</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">53.634</td> <td align="center">51.105</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16.464</td> <td align="center">15.710</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">73.100</td> <td align="center">53.99</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">32.932</td> <td align="center">30.845</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.031</td> <td align="center">4.321</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">79.192</td> <td align="center">66.815</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">200.026</td> <td align="center">188.268</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">18.908</td> <td align="center">11.997</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">106.622</td> <td align="center">82.566</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">77.594</td> <td align="center">56.984</td></tr></tbody>',Te,rt,Me,dt,pn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">43.653</td> <td align="center">43.626</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">45.327</td> <td align="center">42.445</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">52.007</td> <td align="center">51.354</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">277.850</td> <td align="center">268.003</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">119.259</td> <td align="center">105.580</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">13.039</td> <td align="center">11.388</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">201.540</td> <td align="center">184.670</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">764.052</td> <td align="center">711.280</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">74.289</td> <td align="center">48.677</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">421.859</td> <td align="center">357.614</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">289.002</td> <td align="center">226.945</td></tr></tbody>',ue,ct,ye,gt,fn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">163.914</td> <td align="center">160.907</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">192.412</td> <td align="center">163.620</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">188.978</td> <td align="center">187.976</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">422.886</td> <td align="center">388.078</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">44.114</td> <td align="center">37.604</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">756.337</td> <td align="center">695.291</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">2842.940</td> <td align="center">2656.88</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">299.003</td> <td align="center">201.942</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">1619.505</td> <td align="center">1262.758</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">1137.513</td> <td align="center">897.390</td></tr></tbody>',ve,ot,we,st,bn='We also benchmarked on PyTorch nightly (2.1.0dev, find the wheel <a href="https://download.pytorch.org/whl/nightly/cu118" rel="nofollow">here</a>) and observed improvement in latency both for uncompiled and compiled models.',$e,mt,je,ht,Tn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - no compile</strong></th> <th align="center"><strong>torch 2.0 -<br/> compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">12.462</td> <td align="center">6.954</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">14.109</td> <td align="center">12.851</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">30.484</td> <td align="center">15.221</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">46.816</td> <td align="center">30.942</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">163.749</td> <td align="center">163.706</td></tr></tbody>',Ce,pt,Ie,ft,Mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">14.408</td> <td align="center">14.052</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">47.381</td> <td align="center">46.604</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">68.382</td> <td align="center">53.481</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">269.615</td> <td align="center">204.785</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',ke,bt,Je,Tt,un='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">13.477</td> <td align="center">7.926</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">15.103</td> <td align="center">14.378</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">52.517</td> <td align="center">51.691</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">28.706</td> <td align="center">19.077</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">88.402</td> <td align="center">62.949</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',Ue,Mt,Ze,ut,yn="We benchmarked <code>reduce-overhead</code> compilation mode for A100 and T4 in Nightly.",Re,yt,Be,vt,vn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">11.758</td> <td align="center">7.335</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">23.171</td> <td align="center">21.490</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">7.435</td> <td align="center">3.801</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">7.261</td> <td align="center">2.187</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">32.823</td> <td align="center">11.627</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">50.622</td> <td align="center">33.831</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">9.869</td> <td align="center">4.244</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">14.385</td> <td align="center">7.946</td></tr></tbody>',_e,wt,Se,$t,wn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">32.137</td> <td align="center">31.84</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">120.944</td> <td align="center">110.209</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">9.761</td> <td align="center">7.698</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">15.215</td> <td align="center">13.871</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">72.150</td> <td align="center">57.660</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">301.494</td> <td align="center">247.543</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">22.266</td> <td align="center">19.339</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">78.311</td> <td align="center">50.983</td></tr></tbody>',Ne,jt,Ve,It,We;return u=new f({props:{title:"Optimize inference using torch.compile()",local:"optimize-inference-using-torchcompile",headingTag:"h1"}}),v=new f({props:{title:"Benefits of torch.compile",local:"benefits-of-torchcompile",headingTag:"h2"}}),j=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKE1PREVMX0lEKS50byhERVZJQ0UpJTBBJTJCJTIwbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKQ==",highlighted:`from transformers import AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(MODEL_ID).to(DEVICE)
<span class="hljs-addition">+ model = torch.compile(model)</span>`,wrap:!1}}),k=new f({props:{title:"Benchmarking code",local:"benchmarking-code",headingTag:"h2"}}),U=new f({props:{title:"Image Classification with ViT",local:"image-classification-with-vit",headingTag:"h3"}}),Z=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQXVybCUyMCUzRCUyMCdodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJyUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMikudG8oZGV2aWNlKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEElMEFwcm9jZXNzZWRfaW5wdXQlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpLnRvKGRldmljZSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwXyUyMCUzRCUyMG1vZGVsKCoqcHJvY2Vzc2VkX2lucHV0KSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(device)
model = torch.<span class="hljs-built_in">compile</span>(model)

processed_input = processor(image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**processed_input)
`,wrap:!1}}),R=new f({props:{title:"Object Detection with DETR",local:"object-detection-with-detr",headingTag:"h4"}}),B=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjBhY2NlbGVyYXRlLnRlc3RfdXRpbHMudGVzdGluZyUyMGltcG9ydCUyMGdldF9iYWNrZW5kJTBBJTBBZGV2aWNlJTJDJTIwXyUyQyUyMF8lMjAlM0QlMjBnZXRfYmFja2VuZCgpJTIwJTIzJTIwYXV0b21hdGljYWxseSUyMGRldGVjdHMlMjB0aGUlMjB1bmRlcmx5aW5nJTIwZGV2aWNlJTIwdHlwZSUyMChDVURBJTJDJTIwQ1BVJTJDJTIwWFBVJTJDJTIwTVBTJTJDJTIwZXRjLiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIpLnRvKGRldmljZSklMEFtb2RlbCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUobW9kZWwpJTBBJTBBdGV4dHMlMjAlM0QlMjAlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>).to(device)
model = torch.<span class="hljs-built_in">compile</span>(model)

texts = [<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**inputs)`,wrap:!1}}),_=new f({props:{title:"Image Segmentation with Segformer",local:"image-segmentation-with-segformer",headingTag:"h4"}}),S=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlZ2Zvcm1lckltYWdlUHJvY2Vzc29yJTJDJTIwU2VnZm9ybWVyRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwYWNjZWxlcmF0ZS50ZXN0X3V0aWxzLnRlc3RpbmclMjBpbXBvcnQlMjBnZXRfYmFja2VuZCUwQSUwQWRldmljZSUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwZ2V0X2JhY2tlbmQoKSUyMCUyMyUyMGF1dG9tYXRpY2FsbHklMjBkZXRlY3RzJTIwdGhlJTIwdW5kZXJseWluZyUyMGRldmljZSUyMHR5cGUlMjAoQ1VEQSUyQyUyMENQVSUyQyUyMFhQVSUyQyUyME1QUyUyQyUyMGV0Yy4pJTBBcHJvY2Vzc29yJTIwJTNEJTIwU2VnZm9ybWVySW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm52aWRpYSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBbW9kZWwlMjAlM0QlMjBTZWdmb3JtZXJGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybnZpZGlhJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMikudG8oZGV2aWNlKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEFzZWdfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwbW9kZWwoKipzZWdfaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SegformerImageProcessor, SegformerForSemanticSegmentation
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
processor = SegformerImageProcessor.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>)
model = SegformerForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>).to(device)
model = torch.<span class="hljs-built_in">compile</span>(model)
seg_inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**seg_inputs)`,wrap:!1}}),O=new f({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),Q=new f({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),F=new f({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),q=new f({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),tt=new f({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),nt=new f({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),lt=new f({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),rt=new f({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),ct=new f({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),ot=new f({props:{title:"PyTorch Nightly",local:"pytorch-nightly",headingTag:"h2"}}),mt=new f({props:{title:"A100",local:"a100",headingTag:"h3"}}),pt=new f({props:{title:"T4",local:"t4",headingTag:"h3"}}),bt=new f({props:{title:"V100",local:"v100",headingTag:"h3"}}),Mt=new f({props:{title:"Reduce Overhead",local:"reduce-overhead",headingTag:"h2"}}),yt=new f({props:{title:"A100",local:"a100",headingTag:"h3"}}),wt=new f({props:{title:"T4",local:"t4",headingTag:"h3"}}),jt=new Rn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_torch_compile.md"}}),{c(){b=r("meta"),kt=l(),Ct=r("p"),Jt=l(),g(u.$$.fragment),Ut=l(),y=r("p"),y.innerHTML=ze,Zt=l(),g(v.$$.fragment),Rt=l(),w=r("p"),w.innerHTML=Ge,Bt=l(),$=r("p"),$.innerHTML=He,_t=l(),g(j.$$.fragment),St=l(),C=r("p"),C.innerHTML=Xe,Nt=l(),I=r("p"),I.innerHTML=xe,Vt=l(),g(k.$$.fragment),Wt=l(),J=r("p"),J.textContent=Oe,Et=l(),g(U.$$.fragment),Dt=l(),g(Z.$$.fragment),Lt=l(),g(R.$$.fragment),zt=l(),g(B.$$.fragment),Gt=l(),g(_.$$.fragment),Ht=l(),g(S.$$.fragment),Xt=l(),N=r("p"),N.textContent=Ye,xt=l(),V=r("p"),V.innerHTML=Qe,Ot=l(),W=r("ul"),W.innerHTML=Ae,Yt=l(),E=r("p"),E.innerHTML=Fe,Qt=l(),D=r("ul"),D.innerHTML=Pe,At=l(),L=r("p"),L.innerHTML=qe,Ft=l(),z=r("ul"),z.innerHTML=Ke,Pt=l(),G=r("p"),G.innerHTML=tn,qt=l(),T=r("div"),T.innerHTML=en,Kt=l(),M=r("div"),M.innerHTML=nn,te=l(),H=r("p"),H.innerHTML=ln,ee=l(),X=r("p"),X.innerHTML=an,ne=l(),x=r("p"),x.innerHTML=rn,ie=l(),g(O.$$.fragment),le=l(),Y=r("table"),Y.innerHTML=dn,ae=l(),g(Q.$$.fragment),re=l(),A=r("table"),A.innerHTML=cn,de=l(),g(F.$$.fragment),ce=l(),P=r("table"),P.innerHTML=gn,ge=l(),g(q.$$.fragment),oe=l(),K=r("table"),K.innerHTML=on,se=l(),g(tt.$$.fragment),me=l(),et=r("table"),et.innerHTML=sn,he=l(),g(nt.$$.fragment),pe=l(),it=r("table"),it.innerHTML=mn,fe=l(),g(lt.$$.fragment),be=l(),at=r("table"),at.innerHTML=hn,Te=l(),g(rt.$$.fragment),Me=l(),dt=r("table"),dt.innerHTML=pn,ue=l(),g(ct.$$.fragment),ye=l(),gt=r("table"),gt.innerHTML=fn,ve=l(),g(ot.$$.fragment),we=l(),st=r("p"),st.innerHTML=bn,$e=l(),g(mt.$$.fragment),je=l(),ht=r("table"),ht.innerHTML=Tn,Ce=l(),g(pt.$$.fragment),Ie=l(),ft=r("table"),ft.innerHTML=Mn,ke=l(),g(bt.$$.fragment),Je=l(),Tt=r("table"),Tt.innerHTML=un,Ue=l(),g(Mt.$$.fragment),Ze=l(),ut=r("p"),ut.innerHTML=yn,Re=l(),g(yt.$$.fragment),Be=l(),vt=r("table"),vt.innerHTML=vn,_e=l(),g(wt.$$.fragment),Se=l(),$t=r("table"),$t.innerHTML=wn,Ne=l(),g(jt.$$.fragment),Ve=l(),It=r("p"),this.h()},l(t){const e=Un("svelte-u9bgzb",document.head);b=d(e,"META",{name:!0,content:!0}),e.forEach(n),kt=a(t),Ct=d(t,"P",{}),$n(Ct).forEach(n),Jt=a(t),o(u.$$.fragment,t),Ut=a(t),y=d(t,"P",{"data-svelte-h":!0}),c(y)!=="svelte-a1xmpp"&&(y.innerHTML=ze),Zt=a(t),o(v.$$.fragment,t),Rt=a(t),w=d(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-108lixw"&&(w.innerHTML=Ge),Bt=a(t),$=d(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-1b66kne"&&($.innerHTML=He),_t=a(t),o(j.$$.fragment,t),St=a(t),C=d(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-13c27qn"&&(C.innerHTML=Xe),Nt=a(t),I=d(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-116qe4s"&&(I.innerHTML=xe),Vt=a(t),o(k.$$.fragment,t),Wt=a(t),J=d(t,"P",{"data-svelte-h":!0}),c(J)!=="svelte-2dld2n"&&(J.textContent=Oe),Et=a(t),o(U.$$.fragment,t),Dt=a(t),o(Z.$$.fragment,t),Lt=a(t),o(R.$$.fragment,t),zt=a(t),o(B.$$.fragment,t),Gt=a(t),o(_.$$.fragment,t),Ht=a(t),o(S.$$.fragment,t),Xt=a(t),N=d(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-fbvml8"&&(N.textContent=Ye),xt=a(t),V=d(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1pzh5ag"&&(V.innerHTML=Qe),Ot=a(t),W=d(t,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-s6kdqe"&&(W.innerHTML=Ae),Yt=a(t),E=d(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-vq25eq"&&(E.innerHTML=Fe),Qt=a(t),D=d(t,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-1vcuz7e"&&(D.innerHTML=Pe),At=a(t),L=d(t,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1e8jpwt"&&(L.innerHTML=qe),Ft=a(t),z=d(t,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-yhf9tm"&&(z.innerHTML=Ke),Pt=a(t),G=d(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-7yg5eu"&&(G.innerHTML=tn),qt=a(t),T=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-1jw9wmi"&&(T.innerHTML=en),Kt=a(t),M=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-nlzsqo"&&(M.innerHTML=nn),te=a(t),H=d(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-gdeipd"&&(H.innerHTML=ln),ee=a(t),X=d(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1cusdpa"&&(X.innerHTML=an),ne=a(t),x=d(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-16crmf3"&&(x.innerHTML=rn),ie=a(t),o(O.$$.fragment,t),le=a(t),Y=d(t,"TABLE",{"data-svelte-h":!0}),c(Y)!=="svelte-6uvhqg"&&(Y.innerHTML=dn),ae=a(t),o(Q.$$.fragment,t),re=a(t),A=d(t,"TABLE",{"data-svelte-h":!0}),c(A)!=="svelte-f4zjoc"&&(A.innerHTML=cn),de=a(t),o(F.$$.fragment,t),ce=a(t),P=d(t,"TABLE",{"data-svelte-h":!0}),c(P)!=="svelte-9ju0ii"&&(P.innerHTML=gn),ge=a(t),o(q.$$.fragment,t),oe=a(t),K=d(t,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-18ncoxq"&&(K.innerHTML=on),se=a(t),o(tt.$$.fragment,t),me=a(t),et=d(t,"TABLE",{"data-svelte-h":!0}),c(et)!=="svelte-15udyd3"&&(et.innerHTML=sn),he=a(t),o(nt.$$.fragment,t),pe=a(t),it=d(t,"TABLE",{"data-svelte-h":!0}),c(it)!=="svelte-rw07j7"&&(it.innerHTML=mn),fe=a(t),o(lt.$$.fragment,t),be=a(t),at=d(t,"TABLE",{"data-svelte-h":!0}),c(at)!=="svelte-37x5jw"&&(at.innerHTML=hn),Te=a(t),o(rt.$$.fragment,t),Me=a(t),dt=d(t,"TABLE",{"data-svelte-h":!0}),c(dt)!=="svelte-1mc5027"&&(dt.innerHTML=pn),ue=a(t),o(ct.$$.fragment,t),ye=a(t),gt=d(t,"TABLE",{"data-svelte-h":!0}),c(gt)!=="svelte-10eiin7"&&(gt.innerHTML=fn),ve=a(t),o(ot.$$.fragment,t),we=a(t),st=d(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-ov5yx8"&&(st.innerHTML=bn),$e=a(t),o(mt.$$.fragment,t),je=a(t),ht=d(t,"TABLE",{"data-svelte-h":!0}),c(ht)!=="svelte-1cg5nyy"&&(ht.innerHTML=Tn),Ce=a(t),o(pt.$$.fragment,t),Ie=a(t),ft=d(t,"TABLE",{"data-svelte-h":!0}),c(ft)!=="svelte-1nlzppe"&&(ft.innerHTML=Mn),ke=a(t),o(bt.$$.fragment,t),Je=a(t),Tt=d(t,"TABLE",{"data-svelte-h":!0}),c(Tt)!=="svelte-ok1p6e"&&(Tt.innerHTML=un),Ue=a(t),o(Mt.$$.fragment,t),Ze=a(t),ut=d(t,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1axz5ve"&&(ut.innerHTML=yn),Re=a(t),o(yt.$$.fragment,t),Be=a(t),vt=d(t,"TABLE",{"data-svelte-h":!0}),c(vt)!=="svelte-13rnx0"&&(vt.innerHTML=vn),_e=a(t),o(wt.$$.fragment,t),Se=a(t),$t=d(t,"TABLE",{"data-svelte-h":!0}),c($t)!=="svelte-oh2zql"&&($t.innerHTML=wn),Ne=a(t),o(jt.$$.fragment,t),Ve=a(t),It=d(t,"P",{}),$n(It).forEach(n),this.h()},h(){Ee(b,"name","hf:doc:metadata"),Ee(b,"content",_n),Ee(T,"class","flex"),Ee(M,"class","flex")},m(t,e){Zn(document.head,b),i(t,kt,e),i(t,Ct,e),i(t,Jt,e),s(u,t,e),i(t,Ut,e),i(t,y,e),i(t,Zt,e),s(v,t,e),i(t,Rt,e),i(t,w,e),i(t,Bt,e),i(t,$,e),i(t,_t,e),s(j,t,e),i(t,St,e),i(t,C,e),i(t,Nt,e),i(t,I,e),i(t,Vt,e),s(k,t,e),i(t,Wt,e),i(t,J,e),i(t,Et,e),s(U,t,e),i(t,Dt,e),s(Z,t,e),i(t,Lt,e),s(R,t,e),i(t,zt,e),s(B,t,e),i(t,Gt,e),s(_,t,e),i(t,Ht,e),s(S,t,e),i(t,Xt,e),i(t,N,e),i(t,xt,e),i(t,V,e),i(t,Ot,e),i(t,W,e),i(t,Yt,e),i(t,E,e),i(t,Qt,e),i(t,D,e),i(t,At,e),i(t,L,e),i(t,Ft,e),i(t,z,e),i(t,Pt,e),i(t,G,e),i(t,qt,e),i(t,T,e),i(t,Kt,e),i(t,M,e),i(t,te,e),i(t,H,e),i(t,ee,e),i(t,X,e),i(t,ne,e),i(t,x,e),i(t,ie,e),s(O,t,e),i(t,le,e),i(t,Y,e),i(t,ae,e),s(Q,t,e),i(t,re,e),i(t,A,e),i(t,de,e),s(F,t,e),i(t,ce,e),i(t,P,e),i(t,ge,e),s(q,t,e),i(t,oe,e),i(t,K,e),i(t,se,e),s(tt,t,e),i(t,me,e),i(t,et,e),i(t,he,e),s(nt,t,e),i(t,pe,e),i(t,it,e),i(t,fe,e),s(lt,t,e),i(t,be,e),i(t,at,e),i(t,Te,e),s(rt,t,e),i(t,Me,e),i(t,dt,e),i(t,ue,e),s(ct,t,e),i(t,ye,e),i(t,gt,e),i(t,ve,e),s(ot,t,e),i(t,we,e),i(t,st,e),i(t,$e,e),s(mt,t,e),i(t,je,e),i(t,ht,e),i(t,Ce,e),s(pt,t,e),i(t,Ie,e),i(t,ft,e),i(t,ke,e),s(bt,t,e),i(t,Je,e),i(t,Tt,e),i(t,Ue,e),s(Mt,t,e),i(t,Ze,e),i(t,ut,e),i(t,Re,e),s(yt,t,e),i(t,Be,e),i(t,vt,e),i(t,_e,e),s(wt,t,e),i(t,Se,e),i(t,$t,e),i(t,Ne,e),s(jt,t,e),i(t,Ve,e),i(t,It,e),We=!0},p:Cn,i(t){We||(m(u.$$.fragment,t),m(v.$$.fragment,t),m(j.$$.fragment,t),m(k.$$.fragment,t),m(U.$$.fragment,t),m(Z.$$.fragment,t),m(R.$$.fragment,t),m(B.$$.fragment,t),m(_.$$.fragment,t),m(S.$$.fragment,t),m(O.$$.fragment,t),m(Q.$$.fragment,t),m(F.$$.fragment,t),m(q.$$.fragment,t),m(tt.$$.fragment,t),m(nt.$$.fragment,t),m(lt.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),m(ot.$$.fragment,t),m(mt.$$.fragment,t),m(pt.$$.fragment,t),m(bt.$$.fragment,t),m(Mt.$$.fragment,t),m(yt.$$.fragment,t),m(wt.$$.fragment,t),m(jt.$$.fragment,t),We=!0)},o(t){h(u.$$.fragment,t),h(v.$$.fragment,t),h(j.$$.fragment,t),h(k.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(R.$$.fragment,t),h(B.$$.fragment,t),h(_.$$.fragment,t),h(S.$$.fragment,t),h(O.$$.fragment,t),h(Q.$$.fragment,t),h(F.$$.fragment,t),h(q.$$.fragment,t),h(tt.$$.fragment,t),h(nt.$$.fragment,t),h(lt.$$.fragment,t),h(rt.$$.fragment,t),h(ct.$$.fragment,t),h(ot.$$.fragment,t),h(mt.$$.fragment,t),h(pt.$$.fragment,t),h(bt.$$.fragment,t),h(Mt.$$.fragment,t),h(yt.$$.fragment,t),h(wt.$$.fragment,t),h(jt.$$.fragment,t),We=!1},d(t){t&&(n(kt),n(Ct),n(Jt),n(Ut),n(y),n(Zt),n(Rt),n(w),n(Bt),n($),n(_t),n(St),n(C),n(Nt),n(I),n(Vt),n(Wt),n(J),n(Et),n(Dt),n(Lt),n(zt),n(Gt),n(Ht),n(Xt),n(N),n(xt),n(V),n(Ot),n(W),n(Yt),n(E),n(Qt),n(D),n(At),n(L),n(Ft),n(z),n(Pt),n(G),n(qt),n(T),n(Kt),n(M),n(te),n(H),n(ee),n(X),n(ne),n(x),n(ie),n(le),n(Y),n(ae),n(re),n(A),n(de),n(ce),n(P),n(ge),n(oe),n(K),n(se),n(me),n(et),n(he),n(pe),n(it),n(fe),n(be),n(at),n(Te),n(Me),n(dt),n(ue),n(ye),n(gt),n(ve),n(we),n(st),n($e),n(je),n(ht),n(Ce),n(Ie),n(ft),n(ke),n(Je),n(Tt),n(Ue),n(Ze),n(ut),n(Re),n(Be),n(vt),n(_e),n(Se),n($t),n(Ne),n(Ve),n(It)),n(b),p(u,t),p(v,t),p(j,t),p(k,t),p(U,t),p(Z,t),p(R,t),p(B,t),p(_,t),p(S,t),p(O,t),p(Q,t),p(F,t),p(q,t),p(tt,t),p(nt,t),p(lt,t),p(rt,t),p(ct,t),p(ot,t),p(mt,t),p(pt,t),p(bt,t),p(Mt,t),p(yt,t),p(wt,t),p(jt,t)}}}const _n='{"title":"Optimize inference using torch.compile()","local":"optimize-inference-using-torchcompile","sections":[{"title":"Benefits of torch.compile","local":"benefits-of-torchcompile","sections":[],"depth":2},{"title":"Benchmarking code","local":"benchmarking-code","sections":[{"title":"Image Classification with ViT","local":"image-classification-with-vit","sections":[{"title":"Object Detection with DETR","local":"object-detection-with-detr","sections":[],"depth":4},{"title":"Image Segmentation with Segformer","local":"image-segmentation-with-segformer","sections":[],"depth":4}],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Nightly","local":"pytorch-nightly","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3},{"title":"V100","local":"v100","sections":[],"depth":3}],"depth":2},{"title":"Reduce Overhead","local":"reduce-overhead","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sn(Le){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends kn{constructor(b){super(),Jn(this,b,Sn,Bn,jn,{})}}export{Dn as component};
