import{s as Es,f as Zn,n as zs,o as Rs}from"../chunks/scheduler.37c15a92.js";import{S as Ns,i as Ps,g as i,s,r,A as As,h as o,f as l,c as a,j as Xs,u as m,x as p,k as y,y as qs,a as n,v as u,d as h,t as M,w as f}from"../chunks/index.7cb9c9b8.js";import{C as d}from"../chunks/CodeBlock.a6d3f852.js";import{C as Ds}from"../chunks/CourseFloatingBanner.2c4a7381.js";import{H as c,E as Ks}from"../chunks/EditOnGithub.858acfec.js";function Os(In){let b,Ut,Tt,Jt,w,$t,g,jt,T,Wn="Now that you’ve studied the theory behind Advantage Actor Critic (A2C), <strong>you’re ready to train your A2C agent</strong> using Stable-Baselines3 in a robotic environment. And train a:",Ct,v,Bn="<li>A robotic arm 🦾 to move to the correct position.</li>",_t,U,kn="We’re going to use",Zt,J,Gn='<li><a href="https://github.com/qgallouedec/panda-gym" rel="nofollow">panda-gym</a></li>',It,$,Vn="To validate this hands-on for the certification process, you need to push your two trained models to the Hub and get the following results:",Wt,j,Hn="<li><code>PandaReachDense-v3</code> get a result of &gt;= -3.5.</li>",Bt,C,xn='To find your result, <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">go to the leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',kt,_,Qn='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',Gt,Z,Ln="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",Vt,I,Yn='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit6/unit6.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',Ht,W,xt,B,Qt,k,Fn='<li><a href="https://github.com/qgallouedec/panda-gym" rel="nofollow">Panda-Gym</a></li>',Lt,G,Yt,V,Sn='<li><a href="https://stable-baselines3.readthedocs.io/" rel="nofollow">Stable-Baselines3</a></li>',Ft,H,Xn='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',St,x,Xt,Q,En="At the end of the notebook, you will:",Et,L,zn="<li>Be able to use <strong>Panda-Gym</strong>, the environment library.</li> <li>Be able to <strong>train robots using A2C</strong>.</li> <li>Understand why <strong>we need to normalize the input</strong>.</li> <li>Be able to <strong>push your trained agent and the code to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",zt,Y,Rt,F,Rn="Before diving into the notebook, you need to:",Nt,S,Nn='🔲 📚 Study <a href="https://huggingface.co/deep-rl-course/unit6/introduction" rel="nofollow">Actor-Critic methods by reading Unit 6</a> 🤗',Pt,X,At,E,qt,z,Pn="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",Dt,R,An,Kt,N,qn="<li><code>Hardware Accelerator &gt; GPU</code></li>",Ot,P,Dn,el,A,tl,q,Kn="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",ll,D,On="The following cell will install the librairies and create and run a virtual screen 🖥",nl,K,sl,O,al,ee,il,te,es="We’ll install multiple ones:",ol,le,ts="<li><code>gymnasium</code></li> <li><code>panda-gym</code>: Contains the robotics arm environments.</li> <li><code>stable-baselines3</code>: The SB3 deep reinforcement learning library.</li> <li><code>huggingface_sb3</code>: Additional code for Stable-baselines3 to load and upload models from the Hugging Face 🤗 Hub.</li> <li><code>huggingface_hub</code>: Library allowing anyone to work with the Hub repositories.</li>",pl,ne,rl,se,ml,ae,ul,ie,hl,oe,ls="The agent we’re going to train is a robotic arm that needs to do controls (moving the arm and using the end-effector).",Ml,pe,ns="In robotics, the <em>end-effector</em> is the device at the end of a robotic arm designed to interact with the environment.",fl,re,ss="In <code>PandaReach</code>, the robot must place its end-effector at a target position (green ball).",cl,me,as="We’re going to use the dense version of this environment. It means we’ll get a <em>dense reward function</em> that <strong>will provide a reward at each timestep</strong> (the closer the agent is to completing the task, the higher the reward). Contrary to a <em>sparse reward function</em> where the environment <strong>return a reward if and only if the task is completed</strong>.",dl,ue,is="Also, we’re going to use the <em>End-effector displacement control</em>, it means the <strong>action corresponds to the displacement of the end-effector</strong>. We don’t control the individual motion of each joint (joint control).",yl,he,os,bl,Me,ps="This way <strong>the training will be easier</strong>.",wl,fe,gl,ce,Tl,de,rs="In <code>PandaReachDense-v3</code> the robotic arm must place its end-effector at a target position (green ball).",vl,ye,Ul,be,Jl,we,ms="The observation space <strong>is a dictionary with 3 different elements</strong>:",$l,ge,us="<li><code>achieved_goal</code>: (x,y,z) position of the goal.</li> <li><code>desired_goal</code>: (x,y,z) distance between the goal position and the current object position.</li> <li><code>observation</code>: position (x,y,z) and velocity of the end-effector (vx, vy, vz).</li>",jl,Te,hs="Given it’s a dictionary as observation, <strong>we will need to use a MultiInputPolicy policy instead of MlpPolicy</strong>.",Cl,ve,_l,Ue,Ms="The action space is a vector with 3 values:",Zl,Je,fs="<li>Control x, y, z movement</li>",Il,$e,Wl,je,cs='A good practice in reinforcement learning is to <a href="https://stable-baselines3.readthedocs.io/en/master/guide/rl_tips.html" rel="nofollow">normalize input features</a>.',Bl,Ce,ds="For that purpose, there is a wrapper that will compute a running average and standard deviation of input features.",kl,_e,ys="We also normalize rewards with this same wrapper by adding <code>norm_reward = True</code>",Gl,Ze,bs='<a href="https://stable-baselines3.readthedocs.io/en/master/guide/vec_envs.html#vecnormalize" rel="nofollow">You should check the documentation to fill this cell</a>',Vl,Ie,Hl,We,xl,Be,Ql,ke,Ll,Ge,ws='For more information about A2C implementation with StableBaselines3 check: <a href="https://stable-baselines3.readthedocs.io/en/master/modules/a2c.html#notes" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/modules/a2c.html#notes</a>',Yl,Ve,gs='To find the best parameters I checked the <a href="https://huggingface.co/sb3" rel="nofollow">official trained agents by Stable-Baselines3 team</a>.',Fl,He,Sl,xe,Xl,Qe,El,Le,zl,Ye,Ts="<li>Let’s train our agent for 1,000,000 timesteps, don’t forget to use GPU on Colab. It will take approximately ~25-40min</li>",Rl,Fe,Nl,Se,Pl,Xe,Al,Ee,vs="<li>Now that’s our  agent is trained, we need to <strong>check its performance</strong>.</li> <li>Stable-Baselines3 provides a method to do that: <code>evaluate_policy</code></li>",ql,ze,Dl,Re,Kl,Ne,Us="Now that we saw we got good results after the training, we can publish our trained model on the Hub with one line of code.",Ol,Pe,Js='📚 The libraries documentation 👉 <a href="https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face--x-stable-baselines3-v20" rel="nofollow">https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face—x-stable-baselines3-v20</a>',en,Ae,$s="By using <code>package_to_hub</code>, as we already mentionned in the former units, <strong>you evaluate, record a replay, generate a model card of your agent and push it to the hub</strong>.",tn,qe,js="This way:",ln,De,Cs='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share with the community an agent that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',nn,Ke,_s="To be able to share your model with the community there are three more steps to follow:",sn,Oe,Zs='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',an,et,Is="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",on,tt,Ws='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',pn,lt,Bs,rn,nt,ks="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",mn,st,un,at,Gs="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",hn,it,Vs=`3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function.
For this environment, <strong>running this cell can take approximately 10min</strong>`,Mn,ot,fn,pt,cn,rt,Hs="The best way to learn <strong>is to try things by your own</strong>! Why not trying  <code>PandaPickAndPlace-v3</code>?",dn,mt,xs="If you want to try more advanced tasks for panda-gym, you need to check what was done using <strong>TQC or SAC</strong> (a more sample-efficient algorithm suited for robotics tasks). In real robotics, you’ll use a more sample-efficient algorithm for a simple reason: contrary to a simulation <strong>if you move your robotic arm too much, you have a risk of breaking it</strong>.",yn,ut,Qs='PandaPickAndPlace-v1 (this model uses the v1 version of the environment): <a href="https://huggingface.co/sb3/tqc-PandaPickAndPlace-v1" rel="nofollow">https://huggingface.co/sb3/tqc-PandaPickAndPlace-v1</a>',bn,ht,Ls='And don’t hesitate to check panda-gym documentation here: <a href="https://panda-gym.readthedocs.io/en/latest/usage/train_with_sb3.html" rel="nofollow">https://panda-gym.readthedocs.io/en/latest/usage/train_with_sb3.html</a>',wn,Mt,Ys="We provide you the steps to train another agent (optional):",gn,ft,Fs='<li>Define the environment called “PandaPickAndPlace-v3”</li> <li>Make a vectorized environment</li> <li>Add a wrapper to normalize the observations and rewards. <a href="https://stable-baselines3.readthedocs.io/en/master/guide/vec_envs.html#vecnormalize" rel="nofollow">Check the documentation</a></li> <li>Create the A2C Model (don’t forget verbose=1 to print the training logs).</li> <li>Train it for 1M Timesteps</li> <li>Save the model and  VecNormalize statistics when saving the agent</li> <li>Evaluate your agent</li> <li>Publish your trained model on the Hub 🔥 with <code>package_to_hub</code></li>',Tn,ct,vn,dt,Un,yt,Jn,bt,Ss="See you on Unit 7! 🔥",$n,wt,jn,gt,Cn,vt,_n;return w=new c({props:{title:"Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖",local:"hands-on",headingTag:"h1"}}),g=new Ds({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit6/unit6.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),W=new c({props:{title:"Unit 6: Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖",local:"unit-6-advantage-actor-critic-a2c-using-robotics-simulations-with-panda-gym-",headingTag:"h1"}}),B=new c({props:{title:"🎮 Environments:",local:"-environments",headingTag:"h3"}}),G=new c({props:{title:"📚 RL-Library:",local:"-rl-library",headingTag:"h3"}}),x=new c({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),Y=new c({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),X=new c({props:{title:"Let’s train our first robots 🤖",local:"lets-train-our-first-robots-",headingTag:"h1"}}),E=new c({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),A=new c({props:{title:"Create a virtual display 🔽",local:"create-a-virtual-display-",headingTag:"h2"}}),K=new d({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQSFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBIWFwdCUyMGluc3RhbGwlMjB4dmZiJTBBIXBpcDMlMjBpbnN0YWxsJTIwcHl2aXJ0dWFsZGlzcGxheQ==",highlighted:`%%capture
!apt install python-opengl
!apt install ffmpeg
!apt install xvfb
!pip3 install pyvirtualdisplay`,wrap:!1}}),O=new d({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),ee=new c({props:{title:"Install dependencies 🔽",local:"install-dependencies-",headingTag:"h3"}}),ne=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzdGFibGUtYmFzZWxpbmVzMyU1QmV4dHJhJTVEJTBBIXBpcCUyMGluc3RhbGwlMjBneW1uYXNpdW0lMEEhcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX3NiMyUwQSFwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBIXBpcCUyMGluc3RhbGwlMjBwYW5kYV9neW0=",highlighted:`!pip install stable-baselines3[extra]
!pip install gymnasium
!pip install huggingface_sb3
!pip install huggingface_hub
!pip install panda_gym`,wrap:!1}}),se=new c({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),ae=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBneW1uYXNpdW0lMjBhcyUyMGd5bSUwQWltcG9ydCUyMHBhbmRhX2d5bSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9zYjMlMjBpbXBvcnQlMjBsb2FkX2Zyb21faHViJTJDJTIwcGFja2FnZV90b19odWIlMEElMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBBMkMlMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLmV2YWx1YXRpb24lMjBpbXBvcnQlMjBldmFsdWF0ZV9wb2xpY3klMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLnZlY19lbnYlMjBpbXBvcnQlMjBEdW1teVZlY0VudiUyQyUyMFZlY05vcm1hbGl6ZSUwQWZyb20lMjBzdGFibGVfYmFzZWxpbmVzMy5jb21tb24uZW52X3V0aWwlMjBpbXBvcnQlMjBtYWtlX3ZlY19lbnYlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbm90ZWJvb2tfbG9naW4=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">import</span> panda_gym

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub, package_to_hub

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> A2C
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login`,wrap:!1}}),ie=new c({props:{title:"PandaReachDense-v3 🦾",local:"pandareachdense-v3-",headingTag:"h2"}}),fe=new c({props:{title:"Create the environment",local:"create-the-environment",headingTag:"h3"}}),ce=new c({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h4"}}),ye=new d({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyUGFuZGFSZWFjaERlbnNlLXYzJTIyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwZW52JTBBZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMHN0YXRlJTIwc3BhY2UlMjBhbmQlMjBhY3Rpb24lMjBzcGFjZSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSUwQWFfc2l6ZSUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2U=",highlighted:`env_id = <span class="hljs-string">&quot;PandaReachDense-v3&quot;</span>

<span class="hljs-comment"># Create the env</span>
env = gym.make(env_id)

<span class="hljs-comment"># Get the state space and action space</span>
s_size = env.observation_space.shape
a_size = env.action_space`,wrap:!1}}),be=new d({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample()) <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),ve=new d({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample()) <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),$e=new c({props:{title:"Normalize observation and rewards",local:"normalize-observation-and-rewards",headingTag:"h3"}}),Ie=new d({props:{code:"ZW52JTIwJTNEJTIwbWFrZV92ZWNfZW52KGVudl9pZCUyQyUyMG5fZW52cyUzRDQpJTBBJTBBJTIzJTIwQWRkaW5nJTIwdGhpcyUyMHdyYXBwZXIlMjB0byUyMG5vcm1hbGl6ZSUyMHRoZSUyMG9ic2VydmF0aW9uJTIwYW5kJTIwdGhlJTIwcmV3YXJkJTBBZW52JTIwJTNEJTIwJTIzJTIwVE9ETyUzQSUyMEFkZCUyMHRoZSUyMHdyYXBwZXI=",highlighted:`env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

<span class="hljs-comment"># Adding this wrapper to normalize the observation and the reward</span>
env = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Add the wrapper</span>`,wrap:!1}}),We=new c({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Be=new d({props:{code:"ZW52JTIwJTNEJTIwbWFrZV92ZWNfZW52KGVudl9pZCUyQyUyMG5fZW52cyUzRDQpJTBBJTBBZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplKGVudiUyQyUyMG5vcm1fb2JzJTNEVHJ1ZSUyQyUyMG5vcm1fcmV3YXJkJTNEVHJ1ZSUyQyUyMGNsaXBfb2JzJTNEMTAuKQ==",highlighted:`env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

env = VecNormalize(env, norm_obs=<span class="hljs-literal">True</span>, norm_reward=<span class="hljs-literal">True</span>, clip_obs=<span class="hljs-number">10.</span>)`,wrap:!1}}),ke=new c({props:{title:"Create the A2C Model 🤖",local:"create-the-a2c-model-",headingTag:"h3"}}),He=new d({props:{code:"bW9kZWwlMjAlM0QlMjAlMjMlMjBDcmVhdGUlMjB0aGUlMjBBMkMlMjBtb2RlbCUyMGFuZCUyMHRyeSUyMHRvJTIwZmluZCUyMHRoZSUyMGJlc3QlMjBwYXJhbWV0ZXJz",highlighted:'model = <span class="hljs-comment"># Create the A2C model and try to find the best parameters</span>',wrap:!1}}),xe=new c({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Qe=new d({props:{code:"bW9kZWwlMjAlM0QlMjBBMkMocG9saWN5JTIwJTNEJTIwJTIyTXVsdGlJbnB1dFBvbGljeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudiUyMCUzRCUyMGVudiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZlcmJvc2UlM0QxKQ==",highlighted:`model = A2C(policy = <span class="hljs-string">&quot;MultiInputPolicy&quot;</span>,
            env = env,
            verbose=<span class="hljs-number">1</span>)`,wrap:!1}}),Le=new c({props:{title:"Train the A2C agent 🏃",local:"train-the-a2c-agent-",headingTag:"h3"}}),Fe=new d({props:{code:"bW9kZWwubGVhcm4oMV8wMDBfMDAwKQ==",highlighted:'model.learn(<span class="hljs-number">1_000_000</span>)',wrap:!1}}),Se=new d({props:{code:"JTIzJTIwU2F2ZSUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwJTIwVmVjTm9ybWFsaXplJTIwc3RhdGlzdGljcyUyMHdoZW4lMjBzYXZpbmclMjB0aGUlMjBhZ2VudCUwQW1vZGVsLnNhdmUoJTIyYTJjLVBhbmRhUmVhY2hEZW5zZS12MyUyMiklMEFlbnYuc2F2ZSglMjJ2ZWNfbm9ybWFsaXplLnBrbCUyMik=",highlighted:`<span class="hljs-comment"># Save the model and  VecNormalize statistics when saving the agent</span>
model.save(<span class="hljs-string">&quot;a2c-PandaReachDense-v3&quot;</span>)
env.save(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>)`,wrap:!1}}),Xe=new c({props:{title:"Evaluate the agent 📈",local:"evaluate-the-agent-",headingTag:"h3"}}),ze=new d({props:{code:"ZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi52ZWNfZW52JTIwaW1wb3J0JTIwRHVtbXlWZWNFbnYlMkMlMjBWZWNOb3JtYWxpemUlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwc2F2ZWQlMjBzdGF0aXN0aWNzJTBBZXZhbF9lbnYlMjAlM0QlMjBEdW1teVZlY0VudiglNUJsYW1iZGElM0ElMjBneW0ubWFrZSglMjJQYW5kYVJlYWNoRGVuc2UtdjMlMjIpJTVEKSUwQWV2YWxfZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplLmxvYWQoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIlMkMlMjBldmFsX2VudiklMEElMEElMjMlMjBXZSUyMG5lZWQlMjB0byUyMG92ZXJyaWRlJTIwdGhlJTIwcmVuZGVyX21vZGUlMEFldmFsX2Vudi5yZW5kZXJfbW9kZSUyMCUzRCUyMCUyMnJnYl9hcnJheSUyMiUwQSUwQSUyMyUyMCUyMGRvJTIwbm90JTIwdXBkYXRlJTIwdGhlbSUyMGF0JTIwdGVzdCUyMHRpbWUlMEFldmFsX2Vudi50cmFpbmluZyUyMCUzRCUyMEZhbHNlJTBBJTIzJTIwcmV3YXJkJTIwbm9ybWFsaXphdGlvbiUyMGlzJTIwbm90JTIwbmVlZGVkJTIwYXQlMjB0ZXN0JTIwdGltZSUwQWV2YWxfZW52Lm5vcm1fcmV3YXJkJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWdlbnQlMEFtb2RlbCUyMCUzRCUyMEEyQy5sb2FkKCUyMmEyYy1QYW5kYVJlYWNoRGVuc2UtdjMlMjIpJTBBJTBBbWVhbl9yZXdhcmQlMkMlMjBzdGRfcmV3YXJkJTIwJTNEJTIwZXZhbHVhdGVfcG9saWN5KG1vZGVsJTJDJTIwZXZhbF9lbnYpJTBBJTBBcHJpbnQoZiUyMk1lYW4lMjByZXdhcmQlMjAlM0QlMjAlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTNBLjJmJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize

<span class="hljs-comment"># Load the saved statistics</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(<span class="hljs-string">&quot;PandaReachDense-v3&quot;</span>)])
eval_env = VecNormalize.load(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>, eval_env)

<span class="hljs-comment"># We need to override the render_mode</span>
eval_env.render_mode = <span class="hljs-string">&quot;rgb_array&quot;</span>

<span class="hljs-comment">#  do not update them at test time</span>
eval_env.training = <span class="hljs-literal">False</span>
<span class="hljs-comment"># reward normalization is not needed at test time</span>
eval_env.norm_reward = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the agent</span>
model = A2C.load(<span class="hljs-string">&quot;a2c-PandaReachDense-v3&quot;</span>)

mean_reward, std_reward = evaluate_policy(model, eval_env)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean reward = <span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Re=new c({props:{title:"Publish your trained model on the Hub 🔥",local:"publish-your-trained-model-on-the-hub-",headingTag:"h3"}}),st=new d({props:{code:"bm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),ot=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMHBhY2thZ2VfdG9faHViJTBBJTBBcGFja2FnZV90b19odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RmJTIyYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyY2hpdGVjdHVyZSUzRCUyMkEyQyUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudl9pZCUzRGVudl9pZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEZiUyMlRob21hc1NpbW9uaW5pJTJGYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUyMCUyMyUyMENoYW5nZSUyMHRoZSUyMHVzZXJuYW1lJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJJbml0aWFsJTIwY29tbWl0JTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

package_to_hub(
    model=model,
    model_name=<span class="hljs-string">f&quot;a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>,
    model_architecture=<span class="hljs-string">&quot;A2C&quot;</span>,
    env_id=env_id,
    eval_env=eval_env,
    repo_id=<span class="hljs-string">f&quot;ThomasSimonini/a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>, <span class="hljs-comment"># Change the username</span>
    commit_message=<span class="hljs-string">&quot;Initial commit&quot;</span>,
)`,wrap:!1}}),pt=new c({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),ct=new c({props:{title:"Solution (optional)",local:"solution-optional",headingTag:"h3"}}),dt=new d({props:{code:"JTIzJTIwMSUyMC0lMjAyJTBBZW52X2lkJTIwJTNEJTIwJTIyUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIlMEFlbnYlMjAlM0QlMjBtYWtlX3ZlY19lbnYoZW52X2lkJTJDJTIwbl9lbnZzJTNENCklMEElMEElMjMlMjAzJTBBZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplKGVudiUyQyUyMG5vcm1fb2JzJTNEVHJ1ZSUyQyUyMG5vcm1fcmV3YXJkJTNEVHJ1ZSUyQyUyMGNsaXBfb2JzJTNEMTAuKSUwQSUwQSUyMyUyMDQlMEFtb2RlbCUyMCUzRCUyMEEyQyhwb2xpY3klMjAlM0QlMjAlMjJNdWx0aUlucHV0UG9saWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52JTIwJTNEJTIwZW52JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVyYm9zZSUzRDEpJTBBJTIzJTIwNSUwQW1vZGVsLmxlYXJuKDFfMDAwXzAwMCk=",highlighted:`<span class="hljs-comment"># 1 - 2</span>
env_id = <span class="hljs-string">&quot;PandaPickAndPlace-v3&quot;</span>
env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

<span class="hljs-comment"># 3</span>
env = VecNormalize(env, norm_obs=<span class="hljs-literal">True</span>, norm_reward=<span class="hljs-literal">True</span>, clip_obs=<span class="hljs-number">10.</span>)

<span class="hljs-comment"># 4</span>
model = A2C(policy = <span class="hljs-string">&quot;MultiInputPolicy&quot;</span>,
            env = env,
            verbose=<span class="hljs-number">1</span>)
<span class="hljs-comment"># 5</span>
model.learn(<span class="hljs-number">1_000_000</span>)`,wrap:!1}}),yt=new d({props:{code:"JTIzJTIwNiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJhMmMtUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIlM0IlMEFtb2RlbC5zYXZlKG1vZGVsX25hbWUpJTBBZW52LnNhdmUoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIpJTBBJTBBJTIzJTIwNyUwQWZyb20lMjBzdGFibGVfYmFzZWxpbmVzMy5jb21tb24udmVjX2VudiUyMGltcG9ydCUyMER1bW15VmVjRW52JTJDJTIwVmVjTm9ybWFsaXplJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHNhdmVkJTIwc3RhdGlzdGljcyUwQWV2YWxfZW52JTIwJTNEJTIwRHVtbXlWZWNFbnYoJTVCbGFtYmRhJTNBJTIwZ3ltLm1ha2UoJTIyUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIpJTVEKSUwQWV2YWxfZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplLmxvYWQoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIlMkMlMjBldmFsX2VudiklMEElMEElMjMlMjAlMjBkbyUyMG5vdCUyMHVwZGF0ZSUyMHRoZW0lMjBhdCUyMHRlc3QlMjB0aW1lJTBBZXZhbF9lbnYudHJhaW5pbmclMjAlM0QlMjBGYWxzZSUwQSUyMyUyMHJld2FyZCUyMG5vcm1hbGl6YXRpb24lMjBpcyUyMG5vdCUyMG5lZWRlZCUyMGF0JTIwdGVzdCUyMHRpbWUlMEFldmFsX2Vudi5ub3JtX3Jld2FyZCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGFnZW50JTBBbW9kZWwlMjAlM0QlMjBBMkMubG9hZChtb2RlbF9uYW1lKSUwQSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52KSUwQSUwQXByaW50KGYlMjJNZWFuJTIwcmV3YXJkJTIwJTNEJTIwJTdCbWVhbl9yZXdhcmQlM0EuMmYlN0QlMjAlMkIlMkYtJTIwJTdCc3RkX3Jld2FyZCUzQS4yZiU3RCUyMiklMEElMEElMjMlMjA4JTBBcGFja2FnZV90b19odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RmJTIyYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyY2hpdGVjdHVyZSUzRCUyMkEyQyUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudl9pZCUzRGVudl9pZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEZiUyMlRob21hc1NpbW9uaW5pJTJGYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUyMCUyMyUyMFRPRE8lM0ElMjBDaGFuZ2UlMjB0aGUlMjB1c2VybmFtZSUwQSUyMCUyMCUyMCUyMGNvbW1pdF9tZXNzYWdlJTNEJTIySW5pdGlhbCUyMGNvbW1pdCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># 6</span>
model_name = <span class="hljs-string">&quot;a2c-PandaPickAndPlace-v3&quot;</span>;
model.save(model_name)
env.save(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>)

<span class="hljs-comment"># 7</span>
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize

<span class="hljs-comment"># Load the saved statistics</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(<span class="hljs-string">&quot;PandaPickAndPlace-v3&quot;</span>)])
eval_env = VecNormalize.load(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>, eval_env)

<span class="hljs-comment">#  do not update them at test time</span>
eval_env.training = <span class="hljs-literal">False</span>
<span class="hljs-comment"># reward normalization is not needed at test time</span>
eval_env.norm_reward = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the agent</span>
model = A2C.load(model_name)

mean_reward, std_reward = evaluate_policy(model, eval_env)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean reward = <span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># 8</span>
package_to_hub(
    model=model,
    model_name=<span class="hljs-string">f&quot;a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>,
    model_architecture=<span class="hljs-string">&quot;A2C&quot;</span>,
    env_id=env_id,
    eval_env=eval_env,
    repo_id=<span class="hljs-string">f&quot;ThomasSimonini/a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>, <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Change the username</span>
    commit_message=<span class="hljs-string">&quot;Initial commit&quot;</span>,
)`,wrap:!1}}),wt=new c({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),gt=new Ks({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unit6/hands-on.mdx"}}),{c(){b=i("meta"),Ut=s(),Tt=i("p"),Jt=s(),r(w.$$.fragment),$t=s(),r(g.$$.fragment),jt=s(),T=i("p"),T.innerHTML=Wn,Ct=s(),v=i("ul"),v.innerHTML=Bn,_t=s(),U=i("p"),U.textContent=kn,Zt=s(),J=i("ul"),J.innerHTML=Gn,It=s(),$=i("p"),$.textContent=Vn,Wt=s(),j=i("ul"),j.innerHTML=Hn,Bt=s(),C=i("p"),C.innerHTML=xn,kt=s(),_=i("p"),_.innerHTML=Qn,Gt=s(),Z=i("p"),Z.innerHTML=Ln,Vt=s(),I=i("p"),I.innerHTML=Yn,Ht=s(),r(W.$$.fragment),xt=s(),r(B.$$.fragment),Qt=s(),k=i("ul"),k.innerHTML=Fn,Lt=s(),r(G.$$.fragment),Yt=s(),V=i("ul"),V.innerHTML=Sn,Ft=s(),H=i("p"),H.innerHTML=Xn,St=s(),r(x.$$.fragment),Xt=s(),Q=i("p"),Q.textContent=En,Et=s(),L=i("ul"),L.innerHTML=zn,zt=s(),r(Y.$$.fragment),Rt=s(),F=i("p"),F.textContent=Rn,Nt=s(),S=i("p"),S.innerHTML=Nn,Pt=s(),r(X.$$.fragment),At=s(),r(E.$$.fragment),qt=s(),z=i("ul"),z.innerHTML=Pn,Dt=s(),R=i("img"),Kt=s(),N=i("ul"),N.innerHTML=qn,Ot=s(),P=i("img"),el=s(),r(A.$$.fragment),tl=s(),q=i("p"),q.innerHTML=Kn,ll=s(),D=i("p"),D.textContent=On,nl=s(),r(K.$$.fragment),sl=s(),r(O.$$.fragment),al=s(),r(ee.$$.fragment),il=s(),te=i("p"),te.textContent=es,ol=s(),le=i("ul"),le.innerHTML=ts,pl=s(),r(ne.$$.fragment),rl=s(),r(se.$$.fragment),ml=s(),r(ae.$$.fragment),ul=s(),r(ie.$$.fragment),hl=s(),oe=i("p"),oe.textContent=ls,Ml=s(),pe=i("p"),pe.innerHTML=ns,fl=s(),re=i("p"),re.innerHTML=ss,cl=s(),me=i("p"),me.innerHTML=as,dl=s(),ue=i("p"),ue.innerHTML=is,yl=s(),he=i("img"),bl=s(),Me=i("p"),Me.innerHTML=ps,wl=s(),r(fe.$$.fragment),gl=s(),r(ce.$$.fragment),Tl=s(),de=i("p"),de.innerHTML=rs,vl=s(),r(ye.$$.fragment),Ul=s(),r(be.$$.fragment),Jl=s(),we=i("p"),we.innerHTML=ms,$l=s(),ge=i("ul"),ge.innerHTML=us,jl=s(),Te=i("p"),Te.innerHTML=hs,Cl=s(),r(ve.$$.fragment),_l=s(),Ue=i("p"),Ue.textContent=Ms,Zl=s(),Je=i("ul"),Je.innerHTML=fs,Il=s(),r($e.$$.fragment),Wl=s(),je=i("p"),je.innerHTML=cs,Bl=s(),Ce=i("p"),Ce.textContent=ds,kl=s(),_e=i("p"),_e.innerHTML=ys,Gl=s(),Ze=i("p"),Ze.innerHTML=bs,Vl=s(),r(Ie.$$.fragment),Hl=s(),r(We.$$.fragment),xl=s(),r(Be.$$.fragment),Ql=s(),r(ke.$$.fragment),Ll=s(),Ge=i("p"),Ge.innerHTML=ws,Yl=s(),Ve=i("p"),Ve.innerHTML=gs,Fl=s(),r(He.$$.fragment),Sl=s(),r(xe.$$.fragment),Xl=s(),r(Qe.$$.fragment),El=s(),r(Le.$$.fragment),zl=s(),Ye=i("ul"),Ye.innerHTML=Ts,Rl=s(),r(Fe.$$.fragment),Nl=s(),r(Se.$$.fragment),Pl=s(),r(Xe.$$.fragment),Al=s(),Ee=i("ul"),Ee.innerHTML=vs,ql=s(),r(ze.$$.fragment),Dl=s(),r(Re.$$.fragment),Kl=s(),Ne=i("p"),Ne.textContent=Us,Ol=s(),Pe=i("p"),Pe.innerHTML=Js,en=s(),Ae=i("p"),Ae.innerHTML=$s,tn=s(),qe=i("p"),qe.textContent=js,ln=s(),De=i("ul"),De.innerHTML=Cs,nn=s(),Ke=i("p"),Ke.textContent=_s,sn=s(),Oe=i("p"),Oe.innerHTML=Zs,an=s(),et=i("p"),et.textContent=Is,on=s(),tt=i("ul"),tt.innerHTML=Ws,pn=s(),lt=i("img"),rn=s(),nt=i("ul"),nt.innerHTML=ks,mn=s(),r(st.$$.fragment),un=s(),at=i("p"),at.innerHTML=Gs,hn=s(),it=i("p"),it.innerHTML=Vs,Mn=s(),r(ot.$$.fragment),fn=s(),r(pt.$$.fragment),cn=s(),rt=i("p"),rt.innerHTML=Hs,dn=s(),mt=i("p"),mt.innerHTML=xs,yn=s(),ut=i("p"),ut.innerHTML=Qs,bn=s(),ht=i("p"),ht.innerHTML=Ls,wn=s(),Mt=i("p"),Mt.textContent=Ys,gn=s(),ft=i("ol"),ft.innerHTML=Fs,Tn=s(),r(ct.$$.fragment),vn=s(),r(dt.$$.fragment),Un=s(),r(yt.$$.fragment),Jn=s(),bt=i("p"),bt.textContent=Ss,$n=s(),r(wt.$$.fragment),jn=s(),r(gt.$$.fragment),Cn=s(),vt=i("p"),this.h()},l(e){const t=As("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ut=a(e),Tt=o(e,"P",{}),Xs(Tt).forEach(l),Jt=a(e),m(w.$$.fragment,e),$t=a(e),m(g.$$.fragment,e),jt=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1v5g4pl"&&(T.innerHTML=Wn),Ct=a(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-10o7xql"&&(v.innerHTML=Bn),_t=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-f6gxjq"&&(U.textContent=kn),Zt=a(e),J=o(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-1sbq1c5"&&(J.innerHTML=Gn),It=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-30j4nk"&&($.textContent=Vn),Wt=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-1f7nbkh"&&(j.innerHTML=Hn),Bt=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-13r3vs2"&&(C.innerHTML=xn),kt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1qkxyrx"&&(_.innerHTML=Qn),Gt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-10pdw2g"&&(Z.innerHTML=Ln),Vt=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-t0f4sr"&&(I.innerHTML=Yn),Ht=a(e),m(W.$$.fragment,e),xt=a(e),m(B.$$.fragment,e),Qt=a(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-w3db45"&&(k.innerHTML=Fn),Lt=a(e),m(G.$$.fragment,e),Yt=a(e),V=o(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-11wwfn0"&&(V.innerHTML=Sn),Ft=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-qqj2y4"&&(H.innerHTML=Xn),St=a(e),m(x.$$.fragment,e),Xt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-nsjs09"&&(Q.textContent=En),Et=a(e),L=o(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-1eap3pb"&&(L.innerHTML=zn),zt=a(e),m(Y.$$.fragment,e),Rt=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1v25wk6"&&(F.textContent=Rn),Nt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-rlt93v"&&(S.innerHTML=Nn),Pt=a(e),m(X.$$.fragment,e),At=a(e),m(E.$$.fragment,e),qt=a(e),z=o(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1funvfi"&&(z.innerHTML=Pn),Dt=a(e),R=o(e,"IMG",{src:!0,alt:!0}),Kt=a(e),N=o(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1cge6gn"&&(N.innerHTML=qn),Ot=a(e),P=o(e,"IMG",{src:!0,alt:!0}),el=a(e),m(A.$$.fragment,e),tl=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-pdx5k3"&&(q.innerHTML=Kn),ll=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-tsd2zd"&&(D.textContent=On),nl=a(e),m(K.$$.fragment,e),sl=a(e),m(O.$$.fragment,e),al=a(e),m(ee.$$.fragment,e),il=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-p5tnmj"&&(te.textContent=es),ol=a(e),le=o(e,"UL",{"data-svelte-h":!0}),p(le)!=="svelte-homj1k"&&(le.innerHTML=ts),pl=a(e),m(ne.$$.fragment,e),rl=a(e),m(se.$$.fragment,e),ml=a(e),m(ae.$$.fragment,e),ul=a(e),m(ie.$$.fragment,e),hl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-e8xztq"&&(oe.textContent=ls),Ml=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1ahmo9k"&&(pe.innerHTML=ns),fl=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1xkj275"&&(re.innerHTML=ss),cl=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1lvp1mx"&&(me.innerHTML=as),dl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1eh1xh8"&&(ue.innerHTML=is),yl=a(e),he=o(e,"IMG",{src:!0,alt:!0}),bl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1wf8xm5"&&(Me.innerHTML=ps),wl=a(e),m(fe.$$.fragment,e),gl=a(e),m(ce.$$.fragment,e),Tl=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-xvsrum"&&(de.innerHTML=rs),vl=a(e),m(ye.$$.fragment,e),Ul=a(e),m(be.$$.fragment,e),Jl=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-33hohs"&&(we.innerHTML=ms),$l=a(e),ge=o(e,"UL",{"data-svelte-h":!0}),p(ge)!=="svelte-1lszzw1"&&(ge.innerHTML=us),jl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-27bxb4"&&(Te.innerHTML=hs),Cl=a(e),m(ve.$$.fragment,e),_l=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1o9n9bc"&&(Ue.textContent=Ms),Zl=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),p(Je)!=="svelte-pf09j6"&&(Je.innerHTML=fs),Il=a(e),m($e.$$.fragment,e),Wl=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-to6bf0"&&(je.innerHTML=cs),Bl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1tj0ynw"&&(Ce.textContent=ds),kl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1a42rkj"&&(_e.innerHTML=ys),Gl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-e6bsr5"&&(Ze.innerHTML=bs),Vl=a(e),m(Ie.$$.fragment,e),Hl=a(e),m(We.$$.fragment,e),xl=a(e),m(Be.$$.fragment,e),Ql=a(e),m(ke.$$.fragment,e),Ll=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-15t97zk"&&(Ge.innerHTML=ws),Yl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1n4jzw0"&&(Ve.innerHTML=gs),Fl=a(e),m(He.$$.fragment,e),Sl=a(e),m(xe.$$.fragment,e),Xl=a(e),m(Qe.$$.fragment,e),El=a(e),m(Le.$$.fragment,e),zl=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-f47qdr"&&(Ye.innerHTML=Ts),Rl=a(e),m(Fe.$$.fragment,e),Nl=a(e),m(Se.$$.fragment,e),Pl=a(e),m(Xe.$$.fragment,e),Al=a(e),Ee=o(e,"UL",{"data-svelte-h":!0}),p(Ee)!=="svelte-bfd0w6"&&(Ee.innerHTML=vs),ql=a(e),m(ze.$$.fragment,e),Dl=a(e),m(Re.$$.fragment,e),Kl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1hqv8cs"&&(Ne.textContent=Us),Ol=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1vcevn6"&&(Pe.innerHTML=Js),en=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1j3gce8"&&(Ae.innerHTML=$s),tn=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-vgzxi7"&&(qe.textContent=js),ln=a(e),De=o(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-19ddql5"&&(De.innerHTML=Cs),nn=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-6k9qpu"&&(Ke.textContent=_s),sn=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-932u9c"&&(Oe.innerHTML=Zs),an=a(e),et=o(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1cn3tld"&&(et.textContent=Is),on=a(e),tt=o(e,"UL",{"data-svelte-h":!0}),p(tt)!=="svelte-19b5tev"&&(tt.innerHTML=Ws),pn=a(e),lt=o(e,"IMG",{src:!0,alt:!0}),rn=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),p(nt)!=="svelte-mbo7r4"&&(nt.innerHTML=ks),mn=a(e),m(st.$$.fragment,e),un=a(e),at=o(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1g9v6di"&&(at.innerHTML=Gs),hn=a(e),it=o(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-13wg35g"&&(it.innerHTML=Vs),Mn=a(e),m(ot.$$.fragment,e),fn=a(e),m(pt.$$.fragment,e),cn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-o2mw87"&&(rt.innerHTML=Hs),dn=a(e),mt=o(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-10ft4lt"&&(mt.innerHTML=xs),yn=a(e),ut=o(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-11q3awl"&&(ut.innerHTML=Qs),bn=a(e),ht=o(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-orosy6"&&(ht.innerHTML=Ls),wn=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-75fqx0"&&(Mt.textContent=Ys),gn=a(e),ft=o(e,"OL",{"data-svelte-h":!0}),p(ft)!=="svelte-k2am8z"&&(ft.innerHTML=Fs),Tn=a(e),m(ct.$$.fragment,e),vn=a(e),m(dt.$$.fragment,e),Un=a(e),m(yt.$$.fragment,e),Jn=a(e),bt=o(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-1szhxef"&&(bt.textContent=Ss),$n=a(e),m(wt.$$.fragment,e),jn=a(e),m(gt.$$.fragment,e),Cn=a(e),vt=o(e,"P",{}),Xs(vt).forEach(l),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",ea),Zn(R.src,An="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||y(R,"src",An),y(R,"alt","GPU Step 1"),Zn(P.src,Dn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||y(P,"src",Dn),y(P,"alt","GPU Step 2"),Zn(he.src,os="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit8/robotics.jpg")||y(he,"src",os),y(he,"alt","Robotics"),Zn(lt.src,Bs="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||y(lt,"src",Bs),y(lt,"alt","Create HF Token")},m(e,t){qs(document.head,b),n(e,Ut,t),n(e,Tt,t),n(e,Jt,t),u(w,e,t),n(e,$t,t),u(g,e,t),n(e,jt,t),n(e,T,t),n(e,Ct,t),n(e,v,t),n(e,_t,t),n(e,U,t),n(e,Zt,t),n(e,J,t),n(e,It,t),n(e,$,t),n(e,Wt,t),n(e,j,t),n(e,Bt,t),n(e,C,t),n(e,kt,t),n(e,_,t),n(e,Gt,t),n(e,Z,t),n(e,Vt,t),n(e,I,t),n(e,Ht,t),u(W,e,t),n(e,xt,t),u(B,e,t),n(e,Qt,t),n(e,k,t),n(e,Lt,t),u(G,e,t),n(e,Yt,t),n(e,V,t),n(e,Ft,t),n(e,H,t),n(e,St,t),u(x,e,t),n(e,Xt,t),n(e,Q,t),n(e,Et,t),n(e,L,t),n(e,zt,t),u(Y,e,t),n(e,Rt,t),n(e,F,t),n(e,Nt,t),n(e,S,t),n(e,Pt,t),u(X,e,t),n(e,At,t),u(E,e,t),n(e,qt,t),n(e,z,t),n(e,Dt,t),n(e,R,t),n(e,Kt,t),n(e,N,t),n(e,Ot,t),n(e,P,t),n(e,el,t),u(A,e,t),n(e,tl,t),n(e,q,t),n(e,ll,t),n(e,D,t),n(e,nl,t),u(K,e,t),n(e,sl,t),u(O,e,t),n(e,al,t),u(ee,e,t),n(e,il,t),n(e,te,t),n(e,ol,t),n(e,le,t),n(e,pl,t),u(ne,e,t),n(e,rl,t),u(se,e,t),n(e,ml,t),u(ae,e,t),n(e,ul,t),u(ie,e,t),n(e,hl,t),n(e,oe,t),n(e,Ml,t),n(e,pe,t),n(e,fl,t),n(e,re,t),n(e,cl,t),n(e,me,t),n(e,dl,t),n(e,ue,t),n(e,yl,t),n(e,he,t),n(e,bl,t),n(e,Me,t),n(e,wl,t),u(fe,e,t),n(e,gl,t),u(ce,e,t),n(e,Tl,t),n(e,de,t),n(e,vl,t),u(ye,e,t),n(e,Ul,t),u(be,e,t),n(e,Jl,t),n(e,we,t),n(e,$l,t),n(e,ge,t),n(e,jl,t),n(e,Te,t),n(e,Cl,t),u(ve,e,t),n(e,_l,t),n(e,Ue,t),n(e,Zl,t),n(e,Je,t),n(e,Il,t),u($e,e,t),n(e,Wl,t),n(e,je,t),n(e,Bl,t),n(e,Ce,t),n(e,kl,t),n(e,_e,t),n(e,Gl,t),n(e,Ze,t),n(e,Vl,t),u(Ie,e,t),n(e,Hl,t),u(We,e,t),n(e,xl,t),u(Be,e,t),n(e,Ql,t),u(ke,e,t),n(e,Ll,t),n(e,Ge,t),n(e,Yl,t),n(e,Ve,t),n(e,Fl,t),u(He,e,t),n(e,Sl,t),u(xe,e,t),n(e,Xl,t),u(Qe,e,t),n(e,El,t),u(Le,e,t),n(e,zl,t),n(e,Ye,t),n(e,Rl,t),u(Fe,e,t),n(e,Nl,t),u(Se,e,t),n(e,Pl,t),u(Xe,e,t),n(e,Al,t),n(e,Ee,t),n(e,ql,t),u(ze,e,t),n(e,Dl,t),u(Re,e,t),n(e,Kl,t),n(e,Ne,t),n(e,Ol,t),n(e,Pe,t),n(e,en,t),n(e,Ae,t),n(e,tn,t),n(e,qe,t),n(e,ln,t),n(e,De,t),n(e,nn,t),n(e,Ke,t),n(e,sn,t),n(e,Oe,t),n(e,an,t),n(e,et,t),n(e,on,t),n(e,tt,t),n(e,pn,t),n(e,lt,t),n(e,rn,t),n(e,nt,t),n(e,mn,t),u(st,e,t),n(e,un,t),n(e,at,t),n(e,hn,t),n(e,it,t),n(e,Mn,t),u(ot,e,t),n(e,fn,t),u(pt,e,t),n(e,cn,t),n(e,rt,t),n(e,dn,t),n(e,mt,t),n(e,yn,t),n(e,ut,t),n(e,bn,t),n(e,ht,t),n(e,wn,t),n(e,Mt,t),n(e,gn,t),n(e,ft,t),n(e,Tn,t),u(ct,e,t),n(e,vn,t),u(dt,e,t),n(e,Un,t),u(yt,e,t),n(e,Jn,t),n(e,bt,t),n(e,$n,t),u(wt,e,t),n(e,jn,t),u(gt,e,t),n(e,Cn,t),n(e,vt,t),_n=!0},p:zs,i(e){_n||(h(w.$$.fragment,e),h(g.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(x.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(ke.$$.fragment,e),h(He.$$.fragment,e),h(xe.$$.fragment,e),h(Qe.$$.fragment,e),h(Le.$$.fragment,e),h(Fe.$$.fragment,e),h(Se.$$.fragment,e),h(Xe.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(st.$$.fragment,e),h(ot.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(dt.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),h(gt.$$.fragment,e),_n=!0)},o(e){M(w.$$.fragment,e),M(g.$$.fragment,e),M(W.$$.fragment,e),M(B.$$.fragment,e),M(G.$$.fragment,e),M(x.$$.fragment,e),M(Y.$$.fragment,e),M(X.$$.fragment,e),M(E.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(fe.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),M(be.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(Ie.$$.fragment,e),M(We.$$.fragment,e),M(Be.$$.fragment,e),M(ke.$$.fragment,e),M(He.$$.fragment,e),M(xe.$$.fragment,e),M(Qe.$$.fragment,e),M(Le.$$.fragment,e),M(Fe.$$.fragment,e),M(Se.$$.fragment,e),M(Xe.$$.fragment,e),M(ze.$$.fragment,e),M(Re.$$.fragment,e),M(st.$$.fragment,e),M(ot.$$.fragment,e),M(pt.$$.fragment,e),M(ct.$$.fragment,e),M(dt.$$.fragment,e),M(yt.$$.fragment,e),M(wt.$$.fragment,e),M(gt.$$.fragment,e),_n=!1},d(e){e&&(l(Ut),l(Tt),l(Jt),l($t),l(jt),l(T),l(Ct),l(v),l(_t),l(U),l(Zt),l(J),l(It),l($),l(Wt),l(j),l(Bt),l(C),l(kt),l(_),l(Gt),l(Z),l(Vt),l(I),l(Ht),l(xt),l(Qt),l(k),l(Lt),l(Yt),l(V),l(Ft),l(H),l(St),l(Xt),l(Q),l(Et),l(L),l(zt),l(Rt),l(F),l(Nt),l(S),l(Pt),l(At),l(qt),l(z),l(Dt),l(R),l(Kt),l(N),l(Ot),l(P),l(el),l(tl),l(q),l(ll),l(D),l(nl),l(sl),l(al),l(il),l(te),l(ol),l(le),l(pl),l(rl),l(ml),l(ul),l(hl),l(oe),l(Ml),l(pe),l(fl),l(re),l(cl),l(me),l(dl),l(ue),l(yl),l(he),l(bl),l(Me),l(wl),l(gl),l(Tl),l(de),l(vl),l(Ul),l(Jl),l(we),l($l),l(ge),l(jl),l(Te),l(Cl),l(_l),l(Ue),l(Zl),l(Je),l(Il),l(Wl),l(je),l(Bl),l(Ce),l(kl),l(_e),l(Gl),l(Ze),l(Vl),l(Hl),l(xl),l(Ql),l(Ll),l(Ge),l(Yl),l(Ve),l(Fl),l(Sl),l(Xl),l(El),l(zl),l(Ye),l(Rl),l(Nl),l(Pl),l(Al),l(Ee),l(ql),l(Dl),l(Kl),l(Ne),l(Ol),l(Pe),l(en),l(Ae),l(tn),l(qe),l(ln),l(De),l(nn),l(Ke),l(sn),l(Oe),l(an),l(et),l(on),l(tt),l(pn),l(lt),l(rn),l(nt),l(mn),l(un),l(at),l(hn),l(it),l(Mn),l(fn),l(cn),l(rt),l(dn),l(mt),l(yn),l(ut),l(bn),l(ht),l(wn),l(Mt),l(gn),l(ft),l(Tn),l(vn),l(Un),l(Jn),l(bt),l($n),l(jn),l(Cn),l(vt)),l(b),f(w,e),f(g,e),f(W,e),f(B,e),f(G,e),f(x,e),f(Y,e),f(X,e),f(E,e),f(A,e),f(K,e),f(O,e),f(ee,e),f(ne,e),f(se,e),f(ae,e),f(ie,e),f(fe,e),f(ce,e),f(ye,e),f(be,e),f(ve,e),f($e,e),f(Ie,e),f(We,e),f(Be,e),f(ke,e),f(He,e),f(xe,e),f(Qe,e),f(Le,e),f(Fe,e),f(Se,e),f(Xe,e),f(ze,e),f(Re,e),f(st,e),f(ot,e),f(pt,e),f(ct,e),f(dt,e),f(yt,e),f(wt,e),f(gt,e)}}}const ea='{"title":"Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖","local":"hands-on","sections":[],"depth":1}';function ta(In){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Ns{constructor(b){super(),Ps(this,b,ta,Os,Es,{})}}export{oa as component};
