import{s as He,o as We,n as zl}from"../chunks/scheduler.bdbef820.js";import{S as Le,i as De,g as i,s as a,r as T,A as Pe,h as o,f as e,c as M,j as Qe,u as p,x as J,k as ql,y as Oe,a as s,v as d,d as w,t as r,w as j}from"../chunks/index.c0aea24a.js";import{T as Nl}from"../chunks/Tip.31005f7d.js";import{C as u}from"../chunks/CodeBlock.6ccca92e.js";import{H as h,E as Ke}from"../chunks/EditOnGithub.725ee0c1.js";function ls(c){let n,U=`The dataset loading script is likely not needed if your dataset is in one of the following formats: CSV, JSON, JSON lines, text, images, audio or Parquet.
With those formats, you should be able to load your dataset automatically with <a href="/docs/datasets/v2.21.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>,
as long as your dataset repository has a <a href="./repository_structure">required structure</a>.`;return{c(){n=i("p"),n.innerHTML=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-auaxad"&&(n.innerHTML=U)},m(y,I){s(y,n,I)},p:zl,d(y){y&&e(n)}}}function ts(c){let n,U="For security reasons, 🤗 Datasets do not allow running dataset loading scripts by default, and you have to pass <code>trust_remote_code=True</code> to load datasets that require running a dataset script.";return{c(){n=i("p"),n.innerHTML=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1adalis"&&(n.innerHTML=U)},m(y,I){s(y,n,I)},p:zl,d(y){y&&e(n)}}}function es(c){let n,U='To help you get started, try beginning with the dataset loading script <a href="https://github.com/huggingface/datasets/blob/main/templates/new_dataset_script.py" rel="nofollow">template</a>!';return{c(){n=i("p"),n.innerHTML=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1ews9ox"&&(n.innerHTML=U)},m(y,I){s(y,n,I)},p:zl,d(y){y&&e(n)}}}function ss(c){let n,U="Only use a default configuration when it makes sense. Don’t set one because it may be more convenient for the user to not specify a configuration when they load your dataset. For example, multi-lingual datasets often have a separate configuration for each language. An appropriate default may be an aggregated configuration that loads all the languages of the dataset if the user doesn’t request a particular one.";return{c(){n=i("p"),n.textContent=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1h3crem"&&(n.textContent=U)},m(y,I){s(y,n,I)},p:zl,d(y){y&&e(n)}}}function as(c){let n,U="If the data files live in the same folder or repository of the dataset script, you can just pass the relative paths to the files instead of URLs.";return{c(){n=i("p"),n.textContent=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1xoorbu"&&(n.textContent=U)},m(y,I){s(y,n,I)},p:zl,d(y){y&&e(n)}}}function Ms(c){let n,U,y,I,$,xl,m,Fl,f,Sl,R,Me=`Write a dataset script to load and share datasets that consist of data files in unsupported formats or require more complex data preparation.
This is a more advanced way to define a dataset than using <a href="./repository_structure#define-your-splits-in-yaml">YAML metadata in the dataset card</a>.
A dataset script is a Python file that defines the different configurations and splits of your dataset, as well as how to download and process the data.`,Yl,V,ne="The script can download data files from any website, or from the same dataset repository.",Ql,k,ie="A dataset loading script should have the same name as a dataset repository or directory. For example, a repository named <code>my_dataset</code> should contain <code>my_dataset.py</code> script. This way it can be loaded with:",Hl,X,Wl,_,Ll,E,oe="The following guide includes instructions for dataset scripts for how to:",Dl,q,Je="<li>Add dataset metadata.</li> <li>Download data files.</li> <li>Generate samples.</li> <li>Generate dataset metadata.</li> <li>Upload a dataset to the Hub.</li>",Pl,v,ye='Open the <a href="https://huggingface.co/datasets/squad/blob/main/squad.py" rel="nofollow">SQuAD dataset loading script</a> template to follow along on how to share a dataset.',Ol,C,Kl,N,lt,z,Te="The first step is to add some information, or attributes, about your dataset in <code>DatasetBuilder._info()</code>. The most important attributes you should specify are:",tt,x,pe='<li><p><code>DatasetInfo.description</code> provides a concise description of your dataset. The description informs the user what’s in the dataset, how it was collected, and how it can be used for a NLP task.</p></li> <li><p><code>DatasetInfo.features</code> defines the name and type of each column in your dataset. This will also provide the structure for each example, so it is possible to create nested subfields in a column if you want. Take a look at <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Features">Features</a> for a full list of feature types you can use.</p></li>',et,F,st,A,de="<li><p><code>DatasetInfo.homepage</code> contains the URL to the dataset homepage so users can find more details about the dataset.</p></li> <li><p><code>DatasetInfo.citation</code> contains a BibTeX citation for the dataset.</p></li>",at,S,we="After you’ve filled out all these fields in the template, it should look like the following example from the SQuAD loading script:",Mt,Y,nt,Q,it,H,re='In some cases, your dataset may have multiple configurations. For example, the <a href="https://huggingface.co/datasets/super_glue" rel="nofollow">SuperGLUE</a> dataset is a collection of 5 datasets designed to evaluate language understanding tasks. 🤗 Datasets provides <a href="/docs/datasets/v2.21.0/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> which allows you to create different configurations for the user to select from.',ot,W,je='Let’s study the <a href="https://huggingface.co/datasets/super_glue/blob/main/super_glue.py" rel="nofollow">SuperGLUE loading script</a> to see how you can define several configurations.',Jt,L,Ue='<li>Create a <a href="/docs/datasets/v2.21.0/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass with attributes about your dataset. These attributes can be the features of your dataset, label classes, and a URL to the data files.</li>',yt,D,Tt,g,ue="<li>Create instances of your config to specify the values of the attributes of each configuration. This gives you the flexibility to specify all the name and description of each configuration. These sub-class instances should be listed under <code>DatasetBuilder.BUILDER_CONFIGS</code>:</li>",pt,P,dt,b,Ie="<li>Now, users can load a specific configuration of the dataset with the configuration <code>name</code>:</li>",wt,O,rt,K,ce='Additionally, users can instantiate a custom builder configuration by passing the builder configuration arguments to <a href="/docs/datasets/v2.21.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',jt,ll,Ut,tl,ut,el,he="Users must specify a configuration name when they load a dataset with multiple configurations. Otherwise, 🤗 Datasets will raise a <code>ValueError</code>, and prompt the user to select a configuration name. You can avoid this by setting a default dataset configuration with the <code>DEFAULT_CONFIG_NAME</code> attribute:",It,sl,ct,G,ht,al,mt,Ml,me="After you’ve defined the attributes of your dataset, the next step is to download the data files and organize them according to their splits.",ft,nl,fe="<li>Create a dictionary of URLs in the loading script that point to the original SQuAD data files:</li>",Ct,il,At,Z,gt,B,Ce='<li><p><a href="/docs/datasets/v2.21.0/en/package_reference/builder_classes#datasets.DownloadManager.download_and_extract">DownloadManager.download_and_extract()</a> takes this dictionary and downloads the data files. Once the files are downloaded, use <a href="/docs/datasets/v2.21.0/en/package_reference/builder_classes#datasets.SplitGenerator">SplitGenerator</a> to organize each split in the dataset. This is a simple class that contains:</p> <ul><li><p>The <code>name</code> of each split. You should use the standard split names: <code>Split.TRAIN</code>, <code>Split.TEST</code>, and <code>Split.VALIDATION</code>.</p></li> <li><p><code>gen_kwargs</code> provides the file paths to the data files to load for each split.</p></li></ul></li>',bt,ol,Ae="Your <code>DatasetBuilder._split_generator()</code> should look like this now:",Gt,Jl,Zt,yl,Bt,Tl,ge="At this point, you have:",$t,pl,be="<li>Added the dataset attributes.</li> <li>Provided instructions for how to download the data files.</li> <li>Organized the splits.</li>",Rt,dl,Ge="The next step is to actually generate the samples in each split.",Vt,wl,Ze="<li><p><code>DatasetBuilder._generate_examples</code> takes the file path provided by <code>gen_kwargs</code> to read and parse the data files. You need to write a function that loads the data files and extracts the columns.</p></li> <li><p>Your function should yield a tuple of an <code>id_</code>, and an example from the dataset.</p></li>",kt,rl,Xt,jl,_t,Ul,Be="Adding dataset metadata is a great way to include information about your dataset. The metadata is stored in the dataset card <code>README.md</code> in YAML. It includes information like the number of examples required to confirm the dataset was correctly generated, and information about the dataset like its <code>features</code>.",Et,ul,$e="Run the following command to generate your dataset metadata in <code>README.md</code> and make sure your new dataset loading script works correctly:",qt,Il,vt,cl,Re="If your dataset loading script passed the test, you should now have a <code>README.md</code> file in your dataset folder containing a <code>dataset_info</code> field with some metadata.",Nt,hl,zt,ml,Ve='Once your script is ready, <a href="dataset_card">create a dataset card</a> and <a href="share">upload it to the Hub</a>.',xt,fl,ke="Congratulations, you can now load your dataset from the Hub! 🥳",Ft,Cl,St,Al,Yt,gl,Qt,bl,Xe=`If your dataset is made of many big files, 🤗 Datasets automatically runs your script in parallel to make it super fast!
It can help if you have hundreds or thousands of TAR archives, or JSONL files like <a href="https://huggingface.co/datasets/oscar/blob/main/oscar.py" rel="nofollow">oscar</a> for example.`,Ht,Gl,_e=`To make it work, we consider lists of files in <code>gen_kwargs</code> to be shards.
Therefore 🤗 Datasets can automatically spawn several workers to run <code>_generate_examples</code> in parallel, and each worker is given a subset of shards to process.`,Wt,Zl,Lt,Bl,Ee="Users can also specify <code>num_proc=</code> in <code>load_dataset()</code> to specify the number of processes to use as workers.",Dt,$l,Pt,Rl,qe=`For some datasets it can be much faster to yield batches of data rather than examples one by one.
You can speed up the dataset generation by yielding Arrow tables directly, instead of examples.
This is especially useful if your data comes from Pandas DataFrames for example, since the conversion from Pandas to Arrow is as simple as:`,Ot,Vl,Kt,kl,ve='To yield Arrow tables instead of single examples, make your dataset builder inherit from <a href="/docs/datasets/v2.21.0/en/package_reference/builder_classes#datasets.ArrowBasedBuilder">ArrowBasedBuilder</a> instead of <a href="/docs/datasets/v2.21.0/en/package_reference/builder_classes#datasets.GeneratorBasedBuilder">GeneratorBasedBuilder</a>, and use <code>_generate_tables</code> instead of <code>_generate_examples</code>:',le,Xl,te,_l,Ne="Don’t forget to keep your script memory efficient, in case users run them on machines with a low amount of RAM.",ee,El,se,vl,ae;return $=new h({props:{title:"Create a dataset loading script",local:"create-a-dataset-loading-script",headingTag:"h1"}}),m=new Nl({props:{$$slots:{default:[ls]},$$scope:{ctx:c}}}),f=new Nl({props:{warning:"true",$$slots:{default:[ts]},$$scope:{ctx:c}}}),X=new u({props:{code:"bXlfZGF0YXNldCUyRiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG15X2RhdGFzZXQucHk=",highlighted:`my<span class="hljs-emphasis">_dataset/
├── README.md
└── my_</span>dataset.py`,wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBbG9hZF9kYXRhc2V0KCUyMnBhdGglMkZ0byUyRm15X2RhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dataset(<span class="hljs-string">&quot;path/to/my_dataset&quot;</span>)`,wrap:!1}}),C=new Nl({props:{$$slots:{default:[es]},$$scope:{ctx:c}}}),N=new h({props:{title:"Add dataset attributes",local:"add-dataset-attributes",headingTag:"h2"}}),F=new u({props:{code:"ZGF0YXNldHMuRmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwZGF0YXNldHMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJfc3RhcnQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJpbnQzMiUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`datasets.Features(
    {
        <span class="hljs-string">&quot;id&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;title&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;context&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;question&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;answers&quot;</span>: datasets.<span class="hljs-type">Sequence</span>(
            {
                <span class="hljs-string">&quot;text&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;answer_start&quot;</span>: datasets.Value(<span class="hljs-string">&quot;int32&quot;</span>),
            }
        ),
    }
)`,wrap:!1}}),Y=new u({props:{code:"ZGVmJTIwX2luZm8oc2VsZiklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhc2V0cy5EYXRhc2V0SW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRF9ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEZGF0YXNldHMuRmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwZGF0YXNldHMuZmVhdHVyZXMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMjAlMjJhbnN3ZXJfc3RhcnQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJpbnQzMiUyMiklMkMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vJTIwZGVmYXVsdCUyMHN1cGVydmlzZWRfa2V5cyUyMChhcyUyMHdlJTIwaGF2ZSUyMHRvJTIwcGFzcyUyMGJvdGglMjBxdWVzdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGFuZCUyMGNvbnRleHQlMjBhcyUyMGlucHV0KS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcnZpc2VkX2tleXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaG9tZXBhZ2UlM0QlMjJodHRwcyUzQSUyRiUyRnJhanB1cmthci5naXRodWIuaW8lMkZTUXVBRC1leHBsb3JlciUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNpdGF0aW9uJTNEX0NJVEFUSU9OJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_info</span>(<span class="hljs-params">self</span>):
    <span class="hljs-keyword">return</span> datasets.DatasetInfo(
        description=_DESCRIPTION,
        features=datasets.Features(
            {
                <span class="hljs-string">&quot;id&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;title&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;context&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;question&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;answers&quot;</span>: datasets.features.<span class="hljs-type">Sequence</span>(
                    {<span class="hljs-string">&quot;text&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>), <span class="hljs-string">&quot;answer_start&quot;</span>: datasets.Value(<span class="hljs-string">&quot;int32&quot;</span>),}
                ),
            }
        ),
        <span class="hljs-comment"># No default supervised_keys (as we have to pass both question</span>
        <span class="hljs-comment"># and context as input).</span>
        supervised_keys=<span class="hljs-literal">None</span>,
        homepage=<span class="hljs-string">&quot;https://rajpurkar.github.io/SQuAD-explorer/&quot;</span>,
        citation=_CITATION,
    )`,wrap:!1}}),Q=new h({props:{title:"Multiple configurations",local:"multiple-configurations",headingTag:"h3"}}),D=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperGlueConfig</span>(datasets.BuilderConfig):
    <span class="hljs-string">&quot;&quot;&quot;BuilderConfig for SuperGLUE.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, features, data_url, citation, url, label_classes=(<span class="hljs-params"><span class="hljs-string">&quot;False&quot;</span>, <span class="hljs-string">&quot;True&quot;</span></span>), **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;BuilderConfig for SuperGLUE.

        Args:
        features: *list[string]*, list of the features that will appear in the
            feature dict. Should not include &quot;label&quot;.
        data_url: *string*, url to download the zip file from.
        citation: *string*, citation for the data set.
        url: *string*, url for information about the data set.
        label_classes: *list[string]*, the list of classes for the label if the
            label is present as a string. Non-string labels will be cast to either
            &#x27;False&#x27; or &#x27;True&#x27;.
        **kwargs: keyword arguments forwarded to super.
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># Version history:</span>
        <span class="hljs-comment"># 1.0.2: Fixed non-nondeterminism in ReCoRD.</span>
        <span class="hljs-comment"># 1.0.1: Change from the pre-release trial version of SuperGLUE (v1.9) to</span>
        <span class="hljs-comment">#        the full release (v2.0).</span>
        <span class="hljs-comment"># 1.0.0: S3 (new shuffling, sharding and slicing mechanism).</span>
        <span class="hljs-comment"># 0.0.2: Initial version.</span>
        <span class="hljs-built_in">super</span>().__init__(version=datasets.Version(<span class="hljs-string">&quot;1.0.2&quot;</span>), **kwargs)
        self.features = features
        self.label_classes = label_classes
        self.data_url = data_url
        self.citation = citation
        self.url = url`,wrap:!1}}),P=new u({props:{code:"Y2xhc3MlMjBTdXBlckdsdWUoZGF0YXNldHMuR2VuZXJhdG9yQmFzZWRCdWlsZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoZSUyMFN1cGVyR0xVRSUyMGJlbmNobWFyay4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBCVUlMREVSX0NPTkZJR19DTEFTUyUyMCUzRCUyMFN1cGVyR2x1ZUNvbmZpZyUwQSUwQSUyMCUyMCUyMCUyMEJVSUxERVJfQ09ORklHUyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFN1cGVyR2x1ZUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyYm9vbHElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRF9CT09MUV9ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEJTVCJTIycXVlc3Rpb24lMjIlMkMlMjAlMjJwYXNzYWdlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmRsLmZiYWlwdWJsaWNmaWxlcy5jb20lMkZnbHVlJTJGc3VwZXJnbHVlJTJGZGF0YSUyRnYyJTJGQm9vbFEuemlwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2l0YXRpb24lM0RfQk9PTFFfQ0lUQVRJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZnb29nbGUtcmVzZWFyY2gtZGF0YXNldHMlMkZib29sZWFuLXF1ZXN0aW9ucyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTdXBlckdsdWVDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmF4ZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEX0FYR19ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEJTVCJTIycHJlbWlzZSUyMiUyQyUyMCUyMmh5cG90aGVzaXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbF9jbGFzc2VzJTNEJTVCJTIyZW50YWlsbWVudCUyMiUyQyUyMCUyMm5vdF9lbnRhaWxtZW50JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmRsLmZiYWlwdWJsaWNmaWxlcy5jb20lMkZnbHVlJTJGc3VwZXJnbHVlJTJGZGF0YSUyRnYyJTJGQVgtZy56aXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaXRhdGlvbiUzRF9BWEdfQ0lUQVRJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZydWRpbmdlciUyRndpbm9nZW5kZXItc2NoZW1hcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperGlue</span>(datasets.GeneratorBasedBuilder):
    <span class="hljs-string">&quot;&quot;&quot;The SuperGLUE benchmark.&quot;&quot;&quot;</span>

    BUILDER_CONFIG_CLASS = SuperGlueConfig

    BUILDER_CONFIGS = [
        SuperGlueConfig(
            name=<span class="hljs-string">&quot;boolq&quot;</span>,
            description=_BOOLQ_DESCRIPTION,
            features=[<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;passage&quot;</span>],
            data_url=<span class="hljs-string">&quot;https://dl.fbaipublicfiles.com/glue/superglue/data/v2/BoolQ.zip&quot;</span>,
            citation=_BOOLQ_CITATION,
            url=<span class="hljs-string">&quot;https://github.com/google-research-datasets/boolean-questions&quot;</span>,
        ),
        ...
        ...
        SuperGlueConfig(
            name=<span class="hljs-string">&quot;axg&quot;</span>,
            description=_AXG_DESCRIPTION,
            features=[<span class="hljs-string">&quot;premise&quot;</span>, <span class="hljs-string">&quot;hypothesis&quot;</span>],
            label_classes=[<span class="hljs-string">&quot;entailment&quot;</span>, <span class="hljs-string">&quot;not_entailment&quot;</span>],
            data_url=<span class="hljs-string">&quot;https://dl.fbaipublicfiles.com/glue/superglue/data/v2/AX-g.zip&quot;</span>,
            citation=_AXG_CITATION,
            url=<span class="hljs-string">&quot;https://github.com/rudinger/winogender-schemas&quot;</span>,
        ),`,wrap:!1}}),O=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnc3VwZXJfZ2x1ZSclMkMlMjAnYm9vbHEnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;super_glue&#x27;</span>, <span class="hljs-string">&#x27;boolq&#x27;</span>)`,wrap:!1}}),ll=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnc3VwZXJfZ2x1ZSclMkMlMjBkYXRhX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGY3VzdG9tX3VybCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;super_glue&#x27;</span>, data_url=<span class="hljs-string">&quot;https://custom_url&quot;</span>)`,wrap:!1}}),tl=new h({props:{title:"Default configurations",local:"default-configurations",headingTag:"h3"}}),sl=new u({props:{code:"Y2xhc3MlMjBOZXdEYXRhc2V0KGRhdGFzZXRzLkdlbmVyYXRvckJhc2VkQnVpbGRlciklM0ElMEElMEFWRVJTSU9OJTIwJTNEJTIwZGF0YXNldHMuVmVyc2lvbiglMjIxLjEuMCUyMiklMEElMEFCVUlMREVSX0NPTkZJR1MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBkYXRhc2V0cy5CdWlsZGVyQ29uZmlnKG5hbWUlM0QlMjJmaXJzdF9kb21haW4lMjIlMkMlMjB2ZXJzaW9uJTNEVkVSU0lPTiUyQyUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMHBhcnQlMjBvZiUyMG15JTIwZGF0YXNldCUyMGNvdmVycyUyMGElMjBmaXJzdCUyMGRvbWFpbiUyMiklMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0cy5CdWlsZGVyQ29uZmlnKG5hbWUlM0QlMjJzZWNvbmRfZG9tYWluJTIyJTJDJTIwdmVyc2lvbiUzRFZFUlNJT04lMkMlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBwYXJ0JTIwb2YlMjBteSUyMGRhdGFzZXQlMjBjb3ZlcnMlMjBhJTIwc2Vjb25kJTIwZG9tYWluJTIyKSUyQyUwQSU1RCUwQSUwQURFRkFVTFRfQ09ORklHX05BTUUlMjAlM0QlMjAlMjJmaXJzdF9kb21haW4lMjI=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewDataset</span>(datasets.GeneratorBasedBuilder):

VERSION = datasets.Version(<span class="hljs-string">&quot;1.1.0&quot;</span>)

BUILDER_CONFIGS = [
    datasets.BuilderConfig(name=<span class="hljs-string">&quot;first_domain&quot;</span>, version=VERSION, description=<span class="hljs-string">&quot;This part of my dataset covers a first domain&quot;</span>),
    datasets.BuilderConfig(name=<span class="hljs-string">&quot;second_domain&quot;</span>, version=VERSION, description=<span class="hljs-string">&quot;This part of my dataset covers a second domain&quot;</span>),
]

DEFAULT_CONFIG_NAME = <span class="hljs-string">&quot;first_domain&quot;</span>`,wrap:!1}}),G=new Nl({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:c}}}),al=new h({props:{title:"Download data files and organize splits",local:"download-data-files-and-organize-splits",headingTag:"h2"}}),il=new u({props:{code:"X1VSTCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmFqcHVya2FyLmdpdGh1Yi5pbyUyRlNRdUFELWV4cGxvcmVyJTJGZGF0YXNldCUyRiUyMiUwQV9VUkxTJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjBfVVJMJTIwJTJCJTIwJTIydHJhaW4tdjEuMS5qc29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGV2JTIyJTNBJTIwX1VSTCUyMCUyQiUyMCUyMmRldi12MS4xLmpzb24lMjIlMkMlMEElN0Q=",highlighted:`_URL = <span class="hljs-string">&quot;https://rajpurkar.github.io/SQuAD-explorer/dataset/&quot;</span>
_URLS = {
    <span class="hljs-string">&quot;train&quot;</span>: _URL + <span class="hljs-string">&quot;train-v1.1.json&quot;</span>,
    <span class="hljs-string">&quot;dev&quot;</span>: _URL + <span class="hljs-string">&quot;dev-v1.1.json&quot;</span>,
}`,wrap:!1}}),Z=new Nl({props:{$$slots:{default:[as]},$$scope:{ctx:c}}}),Jl=new u({props:{code:"ZGVmJTIwX3NwbGl0X2dlbmVyYXRvcnMoc2VsZiUyQyUyMGRsX21hbmFnZXIlM0ElMjBkYXRhc2V0cy5Eb3dubG9hZE1hbmFnZXIpJTIwLSUzRSUyMExpc3QlNUJkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciU1RCUzQSUwQSUyMCUyMCUyMCUyMHVybHNfdG9fZG93bmxvYWQlMjAlM0QlMjBzZWxmLl9VUkxTJTBBJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWRfYW5kX2V4dHJhY3QodXJsc190b19kb3dubG9hZCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0cy5TcGxpdEdlbmVyYXRvcihuYW1lJTNEZGF0YXNldHMuU3BsaXQuVFJBSU4lMkMlMjBnZW5fa3dhcmdzJTNEJTdCJTIyZmlsZXBhdGglMjIlM0ElMjBkb3dubG9hZGVkX2ZpbGVzJTVCJTIydHJhaW4lMjIlNUQlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IobmFtZSUzRGRhdGFzZXRzLlNwbGl0LlZBTElEQVRJT04lMkMlMjBnZW5fa3dhcmdzJTNEJTdCJTIyZmlsZXBhdGglMjIlM0ElMjBkb3dubG9hZGVkX2ZpbGVzJTVCJTIyZGV2JTIyJTVEJTdEKSUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_split_generators</span>(<span class="hljs-params">self, dl_manager: datasets.DownloadManager</span>) -&gt; <span class="hljs-type">List</span>[datasets.SplitGenerator]:
    urls_to_download = self._URLS
    downloaded_files = dl_manager.download_and_extract(urls_to_download)

    <span class="hljs-keyword">return</span> [
        datasets.SplitGenerator(name=datasets.Split.TRAIN, gen_kwargs={<span class="hljs-string">&quot;filepath&quot;</span>: downloaded_files[<span class="hljs-string">&quot;train&quot;</span>]}),
        datasets.SplitGenerator(name=datasets.Split.VALIDATION, gen_kwargs={<span class="hljs-string">&quot;filepath&quot;</span>: downloaded_files[<span class="hljs-string">&quot;dev&quot;</span>]}),
    ]`,wrap:!1}}),yl=new h({props:{title:"Generate samples",local:"generate-samples",headingTag:"h2"}}),rl=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_examples</span>(<span class="hljs-params">self, filepath</span>):
    <span class="hljs-string">&quot;&quot;&quot;This function returns the examples in the raw (text) form.&quot;&quot;&quot;</span>
    logger.info(<span class="hljs-string">&quot;generating examples from = %s&quot;</span>, filepath)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(filepath) <span class="hljs-keyword">as</span> f:
        squad = json.load(f)
        <span class="hljs-keyword">for</span> article <span class="hljs-keyword">in</span> squad[<span class="hljs-string">&quot;data&quot;</span>]:
            title = article.get(<span class="hljs-string">&quot;title&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
            <span class="hljs-keyword">for</span> paragraph <span class="hljs-keyword">in</span> article[<span class="hljs-string">&quot;paragraphs&quot;</span>]:
                context = paragraph[<span class="hljs-string">&quot;context&quot;</span>].strip()
                <span class="hljs-keyword">for</span> qa <span class="hljs-keyword">in</span> paragraph[<span class="hljs-string">&quot;qas&quot;</span>]:
                    question = qa[<span class="hljs-string">&quot;question&quot;</span>].strip()
                    id_ = qa[<span class="hljs-string">&quot;id&quot;</span>]

                    answer_starts = [answer[<span class="hljs-string">&quot;answer_start&quot;</span>] <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> qa[<span class="hljs-string">&quot;answers&quot;</span>]]
                    answers = [answer[<span class="hljs-string">&quot;text&quot;</span>].strip() <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> qa[<span class="hljs-string">&quot;answers&quot;</span>]]

                    <span class="hljs-comment"># Features currently used are &quot;context&quot;, &quot;question&quot;, and &quot;answers&quot;.</span>
                    <span class="hljs-comment"># Others are extracted here for the ease of future expansions.</span>
                    <span class="hljs-keyword">yield</span> id_, {
                        <span class="hljs-string">&quot;title&quot;</span>: title,
                        <span class="hljs-string">&quot;context&quot;</span>: context,
                        <span class="hljs-string">&quot;question&quot;</span>: question,
                        <span class="hljs-string">&quot;id&quot;</span>: id_,
                        <span class="hljs-string">&quot;answers&quot;</span>: {<span class="hljs-string">&quot;answer_start&quot;</span>: answer_starts, <span class="hljs-string">&quot;text&quot;</span>: answers,},
                    }`,wrap:!1}}),jl=new h({props:{title:"(Optional) Generate dataset metadata",local:"optional-generate-dataset-metadata",headingTag:"h2"}}),Il=new u({props:{code:"ZGF0YXNldHMtY2xpJTIwdGVzdCUyMHBhdGglMkZ0byUyRiUzQ3lvdXItZGF0YXNldC1sb2FkaW5nLXNjcmlwdCUzRSUyMC0tc2F2ZV9pbmZvJTIwLS1hbGxfY29uZmlncw==",highlighted:'datasets-cli test path/<span class="hljs-keyword">to</span>/&lt;your-dataset-loading-<span class="hljs-keyword">script</span>&gt; <span class="hljs-comment">--save_info --all_configs</span>',wrap:!1}}),hl=new h({props:{title:"Upload to the Hub",local:"upload-to-the-hub",headingTag:"h2"}}),Cl=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBbG9hZF9kYXRhc2V0KCUyMiUzQ3VzZXJuYW1lJTNFJTJGbXlfZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dataset(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>)`,wrap:!1}}),Al=new h({props:{title:"Advanced features",local:"advanced-features",headingTag:"h2"}}),gl=new h({props:{title:"Sharding",local:"sharding",headingTag:"h3"}}),Zl=new u({props:{code:"JTBBY2xhc3MlMjBNeVNoYXJkZWREYXRhc2V0KGRhdGFzZXRzLkdlbmVyYXRvckJhc2VkQnVpbGRlciklM0ElMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc3BsaXRfZ2VuZXJhdG9ycyhzZWxmJTJDJTIwZGxfbWFuYWdlciUzQSUyMGRhdGFzZXRzLkRvd25sb2FkTWFuYWdlciklMjAtJTNFJTIwTGlzdCU1QmRhdGFzZXRzLlNwbGl0R2VuZXJhdG9yJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJTVCZiUyMmRhdGElMkZzaGFyZF8lN0JpJTdELmpzb25sJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAyNCklNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IobmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTIwZ2VuX2t3YXJncyUzRCU3QiUyMmZpbGVwYXRocyUyMiUzQSUyMGRvd25sb2FkZWRfZmlsZXMlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2dlbmVyYXRlX2V4YW1wbGVzKHNlbGYlMkMlMjBmaWxlcGF0aHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRWFjaCUyMHdvcmtlciUyMGNhbiUyMGJlJTIwZ2l2ZW4lMjBhJTIwc2xpY2UlMjBvZiUyMHRoZSUyMG9yaWdpbmFsJTIwJTYwZmlsZXBhdGhzJTYwJTIwbGlzdCUyMGRlZmluZWQlMjBpbiUyMHRoZSUyMCU2MGdlbl9rd2FyZ3MlNjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzbyUyMHRoYXQlMjB0aGlzJTIwY29kZSUyMGNhbiUyMHJ1biUyMGluJTIwcGFyYWxsZWwlMjBvbiUyMHNldmVyYWwlMjBzaGFyZHMlMjBhdCUyMHRoZSUyMHNhbWUlMjB0aW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwZmlsZXBhdGglMjBpbiUyMGZpbGVwYXRocyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyShardedDataset</span>(datasets.GeneratorBasedBuilder):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_split_generators</span>(<span class="hljs-params">self, dl_manager: datasets.DownloadManager</span>) -&gt; <span class="hljs-type">List</span>[datasets.SplitGenerator]:
        downloaded_files = dl_manager.download([<span class="hljs-string">f&quot;data/shard_<span class="hljs-subst">{i}</span>.jsonl&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)])
        <span class="hljs-keyword">return</span> [
            datasets.SplitGenerator(name=datasets.Split.TRAIN, gen_kwargs={<span class="hljs-string">&quot;filepaths&quot;</span>: downloaded_files}),
        ]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_examples</span>(<span class="hljs-params">self, filepaths</span>):
        <span class="hljs-comment"># Each worker can be given a slice of the original \`filepaths\` list defined in the \`gen_kwargs\`</span>
        <span class="hljs-comment"># so that this code can run in parallel on several shards at the same time</span>
        <span class="hljs-keyword">for</span> filepath <span class="hljs-keyword">in</span> filepaths:
            ...`,wrap:!1}}),$l=new h({props:{title:"ArrowBasedBuilder",local:"arrowbasedbuilder",headingTag:"h3"}}),Vl=new u({props:{code:"aW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcGElMEFwYV90YWJsZSUyMCUzRCUyMHBhLlRhYmxlLmZyb21fcGFuZGFzKGRmKQ==",highlighted:`<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
pa_table = pa.Table.from_pandas(df)`,wrap:!1}}),Xl=new u({props:{code:"Y2xhc3MlMjBNeVN1cGVyRmFzdERhdGFzZXQoZGF0YXNldHMuQXJyb3dCYXNlZEJ1aWxkZXIpJTNBJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2dlbmVyYXRlX3RhYmxlcyhzZWxmJTJDJTIwZmlsZXBhdGhzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkeCUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBmaWxlcGF0aCUyMGluJTIwZmlsZXBhdGhzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBpZHglMkMlMjBwYV90YWJsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkeCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MySuperFastDataset</span>(datasets.ArrowBasedBuilder):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_tables</span>(<span class="hljs-params">self, filepaths</span>):
        idx = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> filepath <span class="hljs-keyword">in</span> filepaths:
            ...
            <span class="hljs-keyword">yield</span> idx, pa_table
            idx += <span class="hljs-number">1</span>`,wrap:!1}}),El=new Ke({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/dataset_script.mdx"}}),{c(){n=i("meta"),U=a(),y=i("p"),I=a(),T($.$$.fragment),xl=a(),T(m.$$.fragment),Fl=a(),T(f.$$.fragment),Sl=a(),R=i("p"),R.innerHTML=Me,Yl=a(),V=i("p"),V.textContent=ne,Ql=a(),k=i("p"),k.innerHTML=ie,Hl=a(),T(X.$$.fragment),Wl=a(),T(_.$$.fragment),Ll=a(),E=i("p"),E.textContent=oe,Dl=a(),q=i("ul"),q.innerHTML=Je,Pl=a(),v=i("p"),v.innerHTML=ye,Ol=a(),T(C.$$.fragment),Kl=a(),T(N.$$.fragment),lt=a(),z=i("p"),z.innerHTML=Te,tt=a(),x=i("ol"),x.innerHTML=pe,et=a(),T(F.$$.fragment),st=a(),A=i("ol"),A.innerHTML=de,at=a(),S=i("p"),S.textContent=we,Mt=a(),T(Y.$$.fragment),nt=a(),T(Q.$$.fragment),it=a(),H=i("p"),H.innerHTML=re,ot=a(),W=i("p"),W.innerHTML=je,Jt=a(),L=i("ol"),L.innerHTML=Ue,yt=a(),T(D.$$.fragment),Tt=a(),g=i("ol"),g.innerHTML=ue,pt=a(),T(P.$$.fragment),dt=a(),b=i("ol"),b.innerHTML=Ie,wt=a(),T(O.$$.fragment),rt=a(),K=i("p"),K.innerHTML=ce,jt=a(),T(ll.$$.fragment),Ut=a(),T(tl.$$.fragment),ut=a(),el=i("p"),el.innerHTML=he,It=a(),T(sl.$$.fragment),ct=a(),T(G.$$.fragment),ht=a(),T(al.$$.fragment),mt=a(),Ml=i("p"),Ml.textContent=me,ft=a(),nl=i("ol"),nl.innerHTML=fe,Ct=a(),T(il.$$.fragment),At=a(),T(Z.$$.fragment),gt=a(),B=i("ol"),B.innerHTML=Ce,bt=a(),ol=i("p"),ol.innerHTML=Ae,Gt=a(),T(Jl.$$.fragment),Zt=a(),T(yl.$$.fragment),Bt=a(),Tl=i("p"),Tl.textContent=ge,$t=a(),pl=i("ul"),pl.innerHTML=be,Rt=a(),dl=i("p"),dl.textContent=Ge,Vt=a(),wl=i("ol"),wl.innerHTML=Ze,kt=a(),T(rl.$$.fragment),Xt=a(),T(jl.$$.fragment),_t=a(),Ul=i("p"),Ul.innerHTML=Be,Et=a(),ul=i("p"),ul.innerHTML=$e,qt=a(),T(Il.$$.fragment),vt=a(),cl=i("p"),cl.innerHTML=Re,Nt=a(),T(hl.$$.fragment),zt=a(),ml=i("p"),ml.innerHTML=Ve,xt=a(),fl=i("p"),fl.textContent=ke,Ft=a(),T(Cl.$$.fragment),St=a(),T(Al.$$.fragment),Yt=a(),T(gl.$$.fragment),Qt=a(),bl=i("p"),bl.innerHTML=Xe,Ht=a(),Gl=i("p"),Gl.innerHTML=_e,Wt=a(),T(Zl.$$.fragment),Lt=a(),Bl=i("p"),Bl.innerHTML=Ee,Dt=a(),T($l.$$.fragment),Pt=a(),Rl=i("p"),Rl.textContent=qe,Ot=a(),T(Vl.$$.fragment),Kt=a(),kl=i("p"),kl.innerHTML=ve,le=a(),T(Xl.$$.fragment),te=a(),_l=i("p"),_l.textContent=Ne,ee=a(),T(El.$$.fragment),se=a(),vl=i("p"),this.h()},l(l){const t=Pe("svelte-u9bgzb",document.head);n=o(t,"META",{name:!0,content:!0}),t.forEach(e),U=M(l),y=o(l,"P",{}),Qe(y).forEach(e),I=M(l),p($.$$.fragment,l),xl=M(l),p(m.$$.fragment,l),Fl=M(l),p(f.$$.fragment,l),Sl=M(l),R=o(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1k7fcoj"&&(R.innerHTML=Me),Yl=M(l),V=o(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-gltuje"&&(V.textContent=ne),Ql=M(l),k=o(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1qit7w"&&(k.innerHTML=ie),Hl=M(l),p(X.$$.fragment,l),Wl=M(l),p(_.$$.fragment,l),Ll=M(l),E=o(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-mekosh"&&(E.textContent=oe),Dl=M(l),q=o(l,"UL",{"data-svelte-h":!0}),J(q)!=="svelte-v28gob"&&(q.innerHTML=Je),Pl=M(l),v=o(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-3izox6"&&(v.innerHTML=ye),Ol=M(l),p(C.$$.fragment,l),Kl=M(l),p(N.$$.fragment,l),lt=M(l),z=o(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1yjv3de"&&(z.innerHTML=Te),tt=M(l),x=o(l,"OL",{"data-svelte-h":!0}),J(x)!=="svelte-1j7q359"&&(x.innerHTML=pe),et=M(l),p(F.$$.fragment,l),st=M(l),A=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(A)!=="svelte-1gzz03n"&&(A.innerHTML=de),at=M(l),S=o(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-j8hcd0"&&(S.textContent=we),Mt=M(l),p(Y.$$.fragment,l),nt=M(l),p(Q.$$.fragment,l),it=M(l),H=o(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-cp9ts4"&&(H.innerHTML=re),ot=M(l),W=o(l,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1wah8i0"&&(W.innerHTML=je),Jt=M(l),L=o(l,"OL",{"data-svelte-h":!0}),J(L)!=="svelte-jtgcnr"&&(L.innerHTML=Ue),yt=M(l),p(D.$$.fragment,l),Tt=M(l),g=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(g)!=="svelte-1hlknx7"&&(g.innerHTML=ue),pt=M(l),p(P.$$.fragment,l),dt=M(l),b=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(b)!=="svelte-odp277"&&(b.innerHTML=Ie),wt=M(l),p(O.$$.fragment,l),rt=M(l),K=o(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-92ouwf"&&(K.innerHTML=ce),jt=M(l),p(ll.$$.fragment,l),Ut=M(l),p(tl.$$.fragment,l),ut=M(l),el=o(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-19zng3q"&&(el.innerHTML=he),It=M(l),p(sl.$$.fragment,l),ct=M(l),p(G.$$.fragment,l),ht=M(l),p(al.$$.fragment,l),mt=M(l),Ml=o(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-jmz9cn"&&(Ml.textContent=me),ft=M(l),nl=o(l,"OL",{"data-svelte-h":!0}),J(nl)!=="svelte-1o1li8d"&&(nl.innerHTML=fe),Ct=M(l),p(il.$$.fragment,l),At=M(l),p(Z.$$.fragment,l),gt=M(l),B=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(B)!=="svelte-gndywb"&&(B.innerHTML=Ce),bt=M(l),ol=o(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-leta0s"&&(ol.innerHTML=Ae),Gt=M(l),p(Jl.$$.fragment,l),Zt=M(l),p(yl.$$.fragment,l),Bt=M(l),Tl=o(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1edtbpg"&&(Tl.textContent=ge),$t=M(l),pl=o(l,"UL",{"data-svelte-h":!0}),J(pl)!=="svelte-1dze5ec"&&(pl.innerHTML=be),Rt=M(l),dl=o(l,"P",{"data-svelte-h":!0}),J(dl)!=="svelte-atwoq9"&&(dl.textContent=Ge),Vt=M(l),wl=o(l,"OL",{"data-svelte-h":!0}),J(wl)!=="svelte-1euwcht"&&(wl.innerHTML=Ze),kt=M(l),p(rl.$$.fragment,l),Xt=M(l),p(jl.$$.fragment,l),_t=M(l),Ul=o(l,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-pxkn08"&&(Ul.innerHTML=Be),Et=M(l),ul=o(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-10rffde"&&(ul.innerHTML=$e),qt=M(l),p(Il.$$.fragment,l),vt=M(l),cl=o(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-1p203tz"&&(cl.innerHTML=Re),Nt=M(l),p(hl.$$.fragment,l),zt=M(l),ml=o(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-1oe26y1"&&(ml.innerHTML=Ve),xt=M(l),fl=o(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-1539djf"&&(fl.textContent=ke),Ft=M(l),p(Cl.$$.fragment,l),St=M(l),p(Al.$$.fragment,l),Yt=M(l),p(gl.$$.fragment,l),Qt=M(l),bl=o(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-1sxj7ge"&&(bl.innerHTML=Xe),Ht=M(l),Gl=o(l,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-1abrkus"&&(Gl.innerHTML=_e),Wt=M(l),p(Zl.$$.fragment,l),Lt=M(l),Bl=o(l,"P",{"data-svelte-h":!0}),J(Bl)!=="svelte-r6j4wy"&&(Bl.innerHTML=Ee),Dt=M(l),p($l.$$.fragment,l),Pt=M(l),Rl=o(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-1s4bc00"&&(Rl.textContent=qe),Ot=M(l),p(Vl.$$.fragment,l),Kt=M(l),kl=o(l,"P",{"data-svelte-h":!0}),J(kl)!=="svelte-1vlley1"&&(kl.innerHTML=ve),le=M(l),p(Xl.$$.fragment,l),te=M(l),_l=o(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-15xk2c2"&&(_l.textContent=Ne),ee=M(l),p(El.$$.fragment,l),se=M(l),vl=o(l,"P",{}),Qe(vl).forEach(e),this.h()},h(){ql(n,"name","hf:doc:metadata"),ql(n,"content",ns),ql(A,"start","3"),ql(g,"start","2"),ql(b,"start","3"),ql(B,"start","2")},m(l,t){Oe(document.head,n),s(l,U,t),s(l,y,t),s(l,I,t),d($,l,t),s(l,xl,t),d(m,l,t),s(l,Fl,t),d(f,l,t),s(l,Sl,t),s(l,R,t),s(l,Yl,t),s(l,V,t),s(l,Ql,t),s(l,k,t),s(l,Hl,t),d(X,l,t),s(l,Wl,t),d(_,l,t),s(l,Ll,t),s(l,E,t),s(l,Dl,t),s(l,q,t),s(l,Pl,t),s(l,v,t),s(l,Ol,t),d(C,l,t),s(l,Kl,t),d(N,l,t),s(l,lt,t),s(l,z,t),s(l,tt,t),s(l,x,t),s(l,et,t),d(F,l,t),s(l,st,t),s(l,A,t),s(l,at,t),s(l,S,t),s(l,Mt,t),d(Y,l,t),s(l,nt,t),d(Q,l,t),s(l,it,t),s(l,H,t),s(l,ot,t),s(l,W,t),s(l,Jt,t),s(l,L,t),s(l,yt,t),d(D,l,t),s(l,Tt,t),s(l,g,t),s(l,pt,t),d(P,l,t),s(l,dt,t),s(l,b,t),s(l,wt,t),d(O,l,t),s(l,rt,t),s(l,K,t),s(l,jt,t),d(ll,l,t),s(l,Ut,t),d(tl,l,t),s(l,ut,t),s(l,el,t),s(l,It,t),d(sl,l,t),s(l,ct,t),d(G,l,t),s(l,ht,t),d(al,l,t),s(l,mt,t),s(l,Ml,t),s(l,ft,t),s(l,nl,t),s(l,Ct,t),d(il,l,t),s(l,At,t),d(Z,l,t),s(l,gt,t),s(l,B,t),s(l,bt,t),s(l,ol,t),s(l,Gt,t),d(Jl,l,t),s(l,Zt,t),d(yl,l,t),s(l,Bt,t),s(l,Tl,t),s(l,$t,t),s(l,pl,t),s(l,Rt,t),s(l,dl,t),s(l,Vt,t),s(l,wl,t),s(l,kt,t),d(rl,l,t),s(l,Xt,t),d(jl,l,t),s(l,_t,t),s(l,Ul,t),s(l,Et,t),s(l,ul,t),s(l,qt,t),d(Il,l,t),s(l,vt,t),s(l,cl,t),s(l,Nt,t),d(hl,l,t),s(l,zt,t),s(l,ml,t),s(l,xt,t),s(l,fl,t),s(l,Ft,t),d(Cl,l,t),s(l,St,t),d(Al,l,t),s(l,Yt,t),d(gl,l,t),s(l,Qt,t),s(l,bl,t),s(l,Ht,t),s(l,Gl,t),s(l,Wt,t),d(Zl,l,t),s(l,Lt,t),s(l,Bl,t),s(l,Dt,t),d($l,l,t),s(l,Pt,t),s(l,Rl,t),s(l,Ot,t),d(Vl,l,t),s(l,Kt,t),s(l,kl,t),s(l,le,t),d(Xl,l,t),s(l,te,t),s(l,_l,t),s(l,ee,t),d(El,l,t),s(l,se,t),s(l,vl,t),ae=!0},p(l,[t]){const ze={};t&2&&(ze.$$scope={dirty:t,ctx:l}),m.$set(ze);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:l}),f.$set(xe);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:l}),C.$set(Fe);const Se={};t&2&&(Se.$$scope={dirty:t,ctx:l}),G.$set(Se);const Ye={};t&2&&(Ye.$$scope={dirty:t,ctx:l}),Z.$set(Ye)},i(l){ae||(w($.$$.fragment,l),w(m.$$.fragment,l),w(f.$$.fragment,l),w(X.$$.fragment,l),w(_.$$.fragment,l),w(C.$$.fragment,l),w(N.$$.fragment,l),w(F.$$.fragment,l),w(Y.$$.fragment,l),w(Q.$$.fragment,l),w(D.$$.fragment,l),w(P.$$.fragment,l),w(O.$$.fragment,l),w(ll.$$.fragment,l),w(tl.$$.fragment,l),w(sl.$$.fragment,l),w(G.$$.fragment,l),w(al.$$.fragment,l),w(il.$$.fragment,l),w(Z.$$.fragment,l),w(Jl.$$.fragment,l),w(yl.$$.fragment,l),w(rl.$$.fragment,l),w(jl.$$.fragment,l),w(Il.$$.fragment,l),w(hl.$$.fragment,l),w(Cl.$$.fragment,l),w(Al.$$.fragment,l),w(gl.$$.fragment,l),w(Zl.$$.fragment,l),w($l.$$.fragment,l),w(Vl.$$.fragment,l),w(Xl.$$.fragment,l),w(El.$$.fragment,l),ae=!0)},o(l){r($.$$.fragment,l),r(m.$$.fragment,l),r(f.$$.fragment,l),r(X.$$.fragment,l),r(_.$$.fragment,l),r(C.$$.fragment,l),r(N.$$.fragment,l),r(F.$$.fragment,l),r(Y.$$.fragment,l),r(Q.$$.fragment,l),r(D.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(tl.$$.fragment,l),r(sl.$$.fragment,l),r(G.$$.fragment,l),r(al.$$.fragment,l),r(il.$$.fragment,l),r(Z.$$.fragment,l),r(Jl.$$.fragment,l),r(yl.$$.fragment,l),r(rl.$$.fragment,l),r(jl.$$.fragment,l),r(Il.$$.fragment,l),r(hl.$$.fragment,l),r(Cl.$$.fragment,l),r(Al.$$.fragment,l),r(gl.$$.fragment,l),r(Zl.$$.fragment,l),r($l.$$.fragment,l),r(Vl.$$.fragment,l),r(Xl.$$.fragment,l),r(El.$$.fragment,l),ae=!1},d(l){l&&(e(U),e(y),e(I),e(xl),e(Fl),e(Sl),e(R),e(Yl),e(V),e(Ql),e(k),e(Hl),e(Wl),e(Ll),e(E),e(Dl),e(q),e(Pl),e(v),e(Ol),e(Kl),e(lt),e(z),e(tt),e(x),e(et),e(st),e(A),e(at),e(S),e(Mt),e(nt),e(it),e(H),e(ot),e(W),e(Jt),e(L),e(yt),e(Tt),e(g),e(pt),e(dt),e(b),e(wt),e(rt),e(K),e(jt),e(Ut),e(ut),e(el),e(It),e(ct),e(ht),e(mt),e(Ml),e(ft),e(nl),e(Ct),e(At),e(gt),e(B),e(bt),e(ol),e(Gt),e(Zt),e(Bt),e(Tl),e($t),e(pl),e(Rt),e(dl),e(Vt),e(wl),e(kt),e(Xt),e(_t),e(Ul),e(Et),e(ul),e(qt),e(vt),e(cl),e(Nt),e(zt),e(ml),e(xt),e(fl),e(Ft),e(St),e(Yt),e(Qt),e(bl),e(Ht),e(Gl),e(Wt),e(Lt),e(Bl),e(Dt),e(Pt),e(Rl),e(Ot),e(Kt),e(kl),e(le),e(te),e(_l),e(ee),e(se),e(vl)),e(n),j($,l),j(m,l),j(f,l),j(X,l),j(_,l),j(C,l),j(N,l),j(F,l),j(Y,l),j(Q,l),j(D,l),j(P,l),j(O,l),j(ll,l),j(tl,l),j(sl,l),j(G,l),j(al,l),j(il,l),j(Z,l),j(Jl,l),j(yl,l),j(rl,l),j(jl,l),j(Il,l),j(hl,l),j(Cl,l),j(Al,l),j(gl,l),j(Zl,l),j($l,l),j(Vl,l),j(Xl,l),j(El,l)}}}const ns='{"title":"Create a dataset loading script","local":"create-a-dataset-loading-script","sections":[{"title":"Add dataset attributes","local":"add-dataset-attributes","sections":[{"title":"Multiple configurations","local":"multiple-configurations","sections":[],"depth":3},{"title":"Default configurations","local":"default-configurations","sections":[],"depth":3}],"depth":2},{"title":"Download data files and organize splits","local":"download-data-files-and-organize-splits","sections":[],"depth":2},{"title":"Generate samples","local":"generate-samples","sections":[],"depth":2},{"title":"(Optional) Generate dataset metadata","local":"optional-generate-dataset-metadata","sections":[],"depth":2},{"title":"Upload to the Hub","local":"upload-to-the-hub","sections":[],"depth":2},{"title":"Advanced features","local":"advanced-features","sections":[{"title":"Sharding","local":"sharding","sections":[],"depth":3},{"title":"ArrowBasedBuilder","local":"arrowbasedbuilder","sections":[],"depth":3}],"depth":2}],"depth":1}';function is(c){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends Le{constructor(n){super(),De(this,n,is,Ms,He,{})}}export{ds as component};
