import{s as ia,o as ma,n as ca}from"../chunks/scheduler.bdbef820.js";import{S as oa,i as ra,g as p,s as l,r as o,A as Ma,h as i,f as t,c as n,j as pa,u as r,x as m,k as O,y as ha,a as e,v as M,d as h,t as g,w as j}from"../chunks/index.c0aea24a.js";import{T as ga}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as ja,E as ua}from"../chunks/EditOnGithub.725ee0c1.js";function ya(ts){let c,w=`Now that you know how to process a dataset for semantic segmentation, learn
<a href="https://huggingface.co/docs/transformers/tasks/semantic_segmentation" rel="nofollow">how to train a semantic segmentation model</a>
and use it for inference.`;return{c(){c=p("p"),c.innerHTML=w},l(u){c=i(u,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1tl2bt5"&&(c.innerHTML=w)},m(u,ss){e(u,c,ss)},p:ca,d(u){u&&t(c)}}}function da(ts){let c,w,u,ss,C,es,v,Ys=`Semantic segmentation datasets are used to train a model to classify every pixel in an image. There are
a wide variety of applications enabled by these datasets such as background removal from images, stylizing
images, or scene understanding for autonomous driving. This guide will show you how to apply transformations
to an image segmentation dataset.`,ls,I,zs="Before you start, make sure you have up-to-date versions of <code>albumentations</code> and <code>cv2</code> installed:",ns,x,ps,Z,Vs=`<a href="https://albumentations.ai/" rel="nofollow">Albumentations</a> is a Python library for performing data augmentation
for computer vision. It supports various computer vision tasks such as image classification, object
detection, segmentation, and keypoint estimation.`,is,k,Rs=`This guide uses the <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">Scene Parsing</a> dataset for segmenting
and parsing an image into different image regions associated with semantic categories, such as sky, road, person, and bed.`,ms,B,Fs="Load the <code>train</code> split of the dataset and take a look at an example:",cs,$,os,_,Ns="The dataset has three fields:",rs,W,Ss="<li><code>image</code>: a PIL image object.</li> <li><code>annotation</code>: segmentation mask of the image.</li> <li><code>scene_category</code>: the label or scene category of the image (like “kitchen” or “office”).</li>",Ms,X,Es="Next, check out an image with:",hs,G,gs,d,Hs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/image_seg.png"/>',js,Q,As="Similarly, you can check out the respective segmentation mask:",us,Y,ys,f,Ls='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/seg_mask.png"/>',ds,z,qs=`We can also add a <a href="https://github.com/tensorflow/models/blob/3f1ca33afe3c1631b733ea7e40c294273b9e406d/research/deeplab/utils/get_dataset_colormap.py#L51" rel="nofollow">color palette</a> on the
segmentation mask and overlay it on top of the original image to visualize the dataset:`,fs,V,Ps="After defining the color palette, you should be ready to visualize some overlays.",Js,R,Us,J,Ks='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/seg_overlay.png"/>',bs,F,Ds="Now apply some augmentations with <code>albumentations</code>. You’ll first resize the image and adjust its brightness.",Ts,N,ws,S,Os="Create a function to apply the transformation to the images:",Cs,E,vs,H,sa='Use the <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transformation on-the-fly to batches of the dataset to consume less disk space:',Is,A,xs,L,aa="You can verify the transformation worked by indexing into the <code>pixel_values</code> and <code>label</code> of an example:",Zs,q,ks,U,ta='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/albumentations_seg.png"/>',Bs,P,ea="In this guide, you have used <code>albumentations</code> for augmenting the dataset. It’s also possible to use <code>torchvision</code> to apply some similar transforms.",$s,K,_s,b,la='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/torchvision_seg.png"/>',Ws,T,Xs,D,Gs,as,Qs;return C=new ja({props:{title:"Semantic segmentation",local:"semantic-segmentation",headingTag:"h1"}}),x=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWxidW1lbnRhdGlvbnMlMjBvcGVuY3YtcHl0aG9u",highlighted:"pip install -U albumentations opencv-python",wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzY2VuZV9wYXJzZV8xNTAlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWluZGV4JTIwJTNEJTIwMTAlMEFkYXRhc2V0JTVCaW5kZXglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>index = <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[index]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=683x512 at <span class="hljs-number">0x7FB37B0EC810</span>&gt;,
 <span class="hljs-string">&#x27;annotation&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=L size=683x512 at <span class="hljs-number">0x7FB37B0EC9D0</span>&gt;,
 <span class="hljs-string">&#x27;scene_category&#x27;</span>: <span class="hljs-number">927</span>}`,wrap:!1}}),G=new y({props:{code:"ZGF0YXNldCU1QmluZGV4JTVEJTVCJTIyaW1hZ2UlMjIlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[index][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),Y=new y({props:{code:"ZGF0YXNldCU1QmluZGV4JTVEJTVCJTIyYW5ub3RhdGlvbiUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[index][<span class="hljs-string">&quot;annotation&quot;</span>]',wrap:!1}}),R=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWRlZiUyMHZpc3VhbGl6ZV9zZWdfbWFzayhpbWFnZSUzQSUyMG5wLm5kYXJyYXklMkMlMjBtYXNrJTNBJTIwbnAubmRhcnJheSklM0ElMEElMjAlMjAlMjBjb2xvcl9zZWclMjAlM0QlMjBucC56ZXJvcygobWFzay5zaGFwZSU1QjAlNUQlMkMlMjBtYXNrLnNoYXBlJTVCMSU1RCUyQyUyMDMpJTJDJTIwZHR5cGUlM0RucC51aW50OCklMEElMjAlMjAlMjBwYWxldHRlJTIwJTNEJTIwbnAuYXJyYXkoY3JlYXRlX2FkZTIwa19sYWJlbF9jb2xvcm1hcCgpKSUwQSUyMCUyMCUyMGZvciUyMGxhYmVsJTJDJTIwY29sb3IlMjBpbiUyMGVudW1lcmF0ZShwYWxldHRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbG9yX3NlZyU1Qm1hc2slMjAlM0QlM0QlMjBsYWJlbCUyQyUyMCUzQSU1RCUyMCUzRCUyMGNvbG9yJTBBJTIwJTIwJTIwY29sb3Jfc2VnJTIwJTNEJTIwY29sb3Jfc2VnJTVCLi4uJTJDJTIwJTNBJTNBLTElNUQlMjAlMjAlMjMlMjBjb252ZXJ0JTIwdG8lMjBCR1IlMEElMEElMjAlMjAlMjBpbWclMjAlM0QlMjBucC5hcnJheShpbWFnZSklMjAqJTIwMC41JTIwJTJCJTIwY29sb3Jfc2VnJTIwKiUyMDAuNSUyMCUyMCUyMyUyMHBsb3QlMjB0aGUlMjBpbWFnZSUyMHdpdGglMjB0aGUlMjBzZWdtZW50YXRpb24lMjBtYXAlMEElMjAlMjAlMjBpbWclMjAlM0QlMjBpbWcuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMHBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDEwKSklMEElMjAlMjAlMjBwbHQuaW1zaG93KGltZyklMEElMjAlMjAlMjBwbHQuYXhpcyglMjJvZmYlMjIpJTBBJTIwJTIwJTIwcGx0LnNob3coKSUwQSUwQSUwQXZpc3VhbGl6ZV9zZWdfbWFzayglMEElMjAlMjAlMjAlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJpbWFnZSUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJhbm5vdGF0aW9uJTIyJTVEKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">visualize_seg_mask</span>(<span class="hljs-params">image: np.ndarray, mask: np.ndarray</span>):
<span class="hljs-meta">... </span>   color_seg = np.zeros((mask.shape[<span class="hljs-number">0</span>], mask.shape[<span class="hljs-number">1</span>], <span class="hljs-number">3</span>), dtype=np.uint8)
<span class="hljs-meta">... </span>   palette = np.array(create_ade20k_label_colormap())
<span class="hljs-meta">... </span>   <span class="hljs-keyword">for</span> label, color <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(palette):
<span class="hljs-meta">... </span>       color_seg[mask == label, :] = color
<span class="hljs-meta">... </span>   color_seg = color_seg[..., ::-<span class="hljs-number">1</span>]  <span class="hljs-comment"># convert to BGR</span>

<span class="hljs-meta">... </span>   img = np.array(image) * <span class="hljs-number">0.5</span> + color_seg * <span class="hljs-number">0.5</span>  <span class="hljs-comment"># plot the image with the segmentation map</span>
<span class="hljs-meta">... </span>   img = img.astype(np.uint8)

<span class="hljs-meta">... </span>   plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))
<span class="hljs-meta">... </span>   plt.imshow(img)
<span class="hljs-meta">... </span>   plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>   plt.show()


<span class="hljs-meta">&gt;&gt;&gt; </span>visualize_seg_mask(
<span class="hljs-meta">... </span>    np.array(dataset[index][<span class="hljs-string">&quot;image&quot;</span>]),
<span class="hljs-meta">... </span>    np.array(dataset[index][<span class="hljs-string">&quot;annotation&quot;</span>])
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new y({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEElMEF0cmFuc2Zvcm0lMjAlM0QlMjBhbGJ1bWVudGF0aW9ucy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJlc2l6ZSgyNTYlMkMlMjAyNTYpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmFuZG9tQnJpZ2h0bmVzc0NvbnRyYXN0KGJyaWdodG5lc3NfbGltaXQlM0QwLjMlMkMlMjBjb250cmFzdF9saW1pdCUzRDAuMyUyQyUyMHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        albumentations.Resize(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>),
<span class="hljs-meta">... </span>        albumentations.RandomBrightnessContrast(brightness_limit=<span class="hljs-number">0.3</span>, contrast_limit=<span class="hljs-number">0.3</span>, p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new y({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9pbWFnZXMlMkMlMjB0cmFuc2Zvcm1lZF9tYXNrcyUyMCUzRCUyMCU1QiU1RCUyQyUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGltYWdlJTJDJTIwc2VnX21hc2slMjBpbiUyMHppcChleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTJDJTIwZXhhbXBsZXMlNUIlMjJhbm5vdGF0aW9uJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTJDJTIwc2VnX21hc2slMjAlM0QlMjBucC5hcnJheShpbWFnZSklMkMlMjBucC5hcnJheShzZWdfbWFzayklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwbWFzayUzRHNlZ19tYXNrKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVkX2ltYWdlcy5hcHBlbmQodHJhbnNmb3JtZWQlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9tYXNrcy5hcHBlbmQodHJhbnNmb3JtZWQlNUIlMjJtYXNrJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwdHJhbnNmb3JtZWRfaW1hZ2VzJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJsYWJlbCUyMiU1RCUyMCUzRCUyMHRyYW5zZm9ybWVkX21hc2tzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    transformed_images, transformed_masks = [], []
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, seg_mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;annotation&quot;</span>]):
<span class="hljs-meta">... </span>        image, seg_mask = np.array(image), np.array(seg_mask)
<span class="hljs-meta">... </span>        transformed = transform(image=image, mask=seg_mask)
<span class="hljs-meta">... </span>        transformed_images.append(transformed[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        transformed_masks.append(transformed[<span class="hljs-string">&quot;mask&quot;</span>])
...
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = transformed_images
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;label&quot;</span>] = transformed_masks
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),A=new y({props:{code:"ZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transforms)',wrap:!1}}),q=new y({props:{code:"aW1hZ2UlMjAlM0QlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQpJTBBbWFzayUyMCUzRCUyMG5wLmFycmF5KGRhdGFzZXQlNUJpbmRleCU1RCU1QiUyMmxhYmVsJTIyJTVEKSUwQSUwQXZpc3VhbGl6ZV9zZWdfbWFzayhpbWFnZSUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(dataset[index][<span class="hljs-string">&quot;pixel_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.array(dataset[index][<span class="hljs-string">&quot;label&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>visualize_seg_mask(image, mask)`,wrap:!1}}),K=new y({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBSZXNpemUlMkMlMjBDb2xvckppdHRlciUyQyUyMENvbXBvc2UlMEElMEF0cmFuc2Zvcm1hdGlvbl9jaGFpbiUyMCUzRCUyMENvbXBvc2UoJTVCJTBBJTIwJTIwJTIwJTIwUmVzaXplKCgyNTYlMkMlMjAyNTYpKSUyQyUwQSUyMCUyMCUyMCUyMENvbG9ySml0dGVyKGJyaWdodG5lc3MlM0QwLjI1JTJDJTIwY29udHJhc3QlM0QwLjI1JTJDJTIwc2F0dXJhdGlvbiUzRDAuMjUlMkMlMjBodWUlM0QwLjEpJTBBJTVEKSUwQXJlc2l6ZSUyMCUzRCUyMFJlc2l6ZSgoMjU2JTJDJTIwMjU2KSklMEElMEFkZWYlMjB0cmFpbl90cmFuc2Zvcm1zKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnRyYW5zZm9ybWF0aW9uX2NoYWluKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwJTVCcmVzaXplKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmFubm90YXRpb24lMjIlNUQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlX2JhdGNoJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYWluX3RyYW5zZm9ybXMpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShkYXRhc2V0JTVCaW5kZXglNUQlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQpJTBBbWFzayUyMCUzRCUyMG5wLmFycmF5KGRhdGFzZXQlNUJpbmRleCU1RCU1QiUyMmxhYmVsJTIyJTVEKSUwQSUwQXZpc3VhbGl6ZV9zZWdfbWFzayhpbWFnZSUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Resize, ColorJitter, Compose

<span class="hljs-meta">&gt;&gt;&gt; </span>transformation_chain = Compose([
<span class="hljs-meta">... </span>    Resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>)),
<span class="hljs-meta">... </span>    ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">... </span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>resize = Resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [transformation_chain(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    example_batch[<span class="hljs-string">&quot;label&quot;</span>] = [resize(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(train_transforms)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(dataset[index][<span class="hljs-string">&quot;pixel_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.array(dataset[index][<span class="hljs-string">&quot;label&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>visualize_seg_mask(image, mask)`,wrap:!1}}),T=new ga({props:{$$slots:{default:[ya]},$$scope:{ctx:ts}}}),D=new ua({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/semantic_segmentation.mdx"}}),{c(){c=p("meta"),w=l(),u=p("p"),ss=l(),o(C.$$.fragment),es=l(),v=p("p"),v.textContent=Ys,ls=l(),I=p("p"),I.innerHTML=zs,ns=l(),o(x.$$.fragment),ps=l(),Z=p("p"),Z.innerHTML=Vs,is=l(),k=p("p"),k.innerHTML=Rs,ms=l(),B=p("p"),B.innerHTML=Fs,cs=l(),o($.$$.fragment),os=l(),_=p("p"),_.textContent=Ns,rs=l(),W=p("ul"),W.innerHTML=Ss,Ms=l(),X=p("p"),X.textContent=Es,hs=l(),o(G.$$.fragment),gs=l(),d=p("div"),d.innerHTML=Hs,js=l(),Q=p("p"),Q.textContent=As,us=l(),o(Y.$$.fragment),ys=l(),f=p("div"),f.innerHTML=Ls,ds=l(),z=p("p"),z.innerHTML=qs,fs=l(),V=p("p"),V.textContent=Ps,Js=l(),o(R.$$.fragment),Us=l(),J=p("div"),J.innerHTML=Ks,bs=l(),F=p("p"),F.innerHTML=Ds,Ts=l(),o(N.$$.fragment),ws=l(),S=p("p"),S.textContent=Os,Cs=l(),o(E.$$.fragment),vs=l(),H=p("p"),H.innerHTML=sa,Is=l(),o(A.$$.fragment),xs=l(),L=p("p"),L.innerHTML=aa,Zs=l(),o(q.$$.fragment),ks=l(),U=p("div"),U.innerHTML=ta,Bs=l(),P=p("p"),P.innerHTML=ea,$s=l(),o(K.$$.fragment),_s=l(),b=p("div"),b.innerHTML=la,Ws=l(),o(T.$$.fragment),Xs=l(),o(D.$$.fragment),Gs=l(),as=p("p"),this.h()},l(s){const a=Ma("svelte-u9bgzb",document.head);c=i(a,"META",{name:!0,content:!0}),a.forEach(t),w=n(s),u=i(s,"P",{}),pa(u).forEach(t),ss=n(s),r(C.$$.fragment,s),es=n(s),v=i(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-fw4ret"&&(v.textContent=Ys),ls=n(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1qtuikq"&&(I.innerHTML=zs),ns=n(s),r(x.$$.fragment,s),ps=n(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-180f5nb"&&(Z.innerHTML=Vs),is=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1jjf6cy"&&(k.innerHTML=Rs),ms=n(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-pju1x0"&&(B.innerHTML=Fs),cs=n(s),r($.$$.fragment,s),os=n(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-jjwn46"&&(_.textContent=Ns),rs=n(s),W=i(s,"UL",{"data-svelte-h":!0}),m(W)!=="svelte-1r68wni"&&(W.innerHTML=Ss),Ms=n(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-15dthpv"&&(X.textContent=Es),hs=n(s),r(G.$$.fragment,s),gs=n(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(d)!=="svelte-1337354"&&(d.innerHTML=Hs),js=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-qlholw"&&(Q.textContent=As),us=n(s),r(Y.$$.fragment,s),ys=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-ru2vd9"&&(f.innerHTML=Ls),ds=n(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-vzaie7"&&(z.innerHTML=qs),fs=n(s),V=i(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-vvbf2j"&&(V.textContent=Ps),Js=n(s),r(R.$$.fragment,s),Us=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-1unth95"&&(J.innerHTML=Ks),bs=n(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-c3rxqx"&&(F.innerHTML=Ds),Ts=n(s),r(N.$$.fragment,s),ws=n(s),S=i(s,"P",{"data-svelte-h":!0}),m(S)!=="svelte-50733g"&&(S.textContent=Os),Cs=n(s),r(E.$$.fragment,s),vs=n(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-nlotmq"&&(H.innerHTML=sa),Is=n(s),r(A.$$.fragment,s),xs=n(s),L=i(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-11iow8s"&&(L.innerHTML=aa),Zs=n(s),r(q.$$.fragment,s),ks=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-rz0i83"&&(U.innerHTML=ta),Bs=n(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-o9kxh2"&&(P.innerHTML=ea),$s=n(s),r(K.$$.fragment,s),_s=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-jb5bqb"&&(b.innerHTML=la),Ws=n(s),r(T.$$.fragment,s),Xs=n(s),r(D.$$.fragment,s),Gs=n(s),as=i(s,"P",{}),pa(as).forEach(t),this.h()},h(){O(c,"name","hf:doc:metadata"),O(c,"content",fa),O(d,"class","flex justify-center"),O(f,"class","flex justify-center"),O(J,"class","flex justify-center"),O(U,"class","flex justify-center"),O(b,"class","flex justify-center")},m(s,a){ha(document.head,c),e(s,w,a),e(s,u,a),e(s,ss,a),M(C,s,a),e(s,es,a),e(s,v,a),e(s,ls,a),e(s,I,a),e(s,ns,a),M(x,s,a),e(s,ps,a),e(s,Z,a),e(s,is,a),e(s,k,a),e(s,ms,a),e(s,B,a),e(s,cs,a),M($,s,a),e(s,os,a),e(s,_,a),e(s,rs,a),e(s,W,a),e(s,Ms,a),e(s,X,a),e(s,hs,a),M(G,s,a),e(s,gs,a),e(s,d,a),e(s,js,a),e(s,Q,a),e(s,us,a),M(Y,s,a),e(s,ys,a),e(s,f,a),e(s,ds,a),e(s,z,a),e(s,fs,a),e(s,V,a),e(s,Js,a),M(R,s,a),e(s,Us,a),e(s,J,a),e(s,bs,a),e(s,F,a),e(s,Ts,a),M(N,s,a),e(s,ws,a),e(s,S,a),e(s,Cs,a),M(E,s,a),e(s,vs,a),e(s,H,a),e(s,Is,a),M(A,s,a),e(s,xs,a),e(s,L,a),e(s,Zs,a),M(q,s,a),e(s,ks,a),e(s,U,a),e(s,Bs,a),e(s,P,a),e(s,$s,a),M(K,s,a),e(s,_s,a),e(s,b,a),e(s,Ws,a),M(T,s,a),e(s,Xs,a),M(D,s,a),e(s,Gs,a),e(s,as,a),Qs=!0},p(s,[a]){const na={};a&2&&(na.$$scope={dirty:a,ctx:s}),T.$set(na)},i(s){Qs||(h(C.$$.fragment,s),h(x.$$.fragment,s),h($.$$.fragment,s),h(G.$$.fragment,s),h(Y.$$.fragment,s),h(R.$$.fragment,s),h(N.$$.fragment,s),h(E.$$.fragment,s),h(A.$$.fragment,s),h(q.$$.fragment,s),h(K.$$.fragment,s),h(T.$$.fragment,s),h(D.$$.fragment,s),Qs=!0)},o(s){g(C.$$.fragment,s),g(x.$$.fragment,s),g($.$$.fragment,s),g(G.$$.fragment,s),g(Y.$$.fragment,s),g(R.$$.fragment,s),g(N.$$.fragment,s),g(E.$$.fragment,s),g(A.$$.fragment,s),g(q.$$.fragment,s),g(K.$$.fragment,s),g(T.$$.fragment,s),g(D.$$.fragment,s),Qs=!1},d(s){s&&(t(w),t(u),t(ss),t(es),t(v),t(ls),t(I),t(ns),t(ps),t(Z),t(is),t(k),t(ms),t(B),t(cs),t(os),t(_),t(rs),t(W),t(Ms),t(X),t(hs),t(gs),t(d),t(js),t(Q),t(us),t(ys),t(f),t(ds),t(z),t(fs),t(V),t(Js),t(Us),t(J),t(bs),t(F),t(Ts),t(ws),t(S),t(Cs),t(vs),t(H),t(Is),t(xs),t(L),t(Zs),t(ks),t(U),t(Bs),t(P),t($s),t(_s),t(b),t(Ws),t(Xs),t(Gs),t(as)),t(c),j(C,s),j(x,s),j($,s),j(G,s),j(Y,s),j(R,s),j(N,s),j(E,s),j(A,s),j(q,s),j(K,s),j(T,s),j(D,s)}}}const fa='{"title":"Semantic segmentation","local":"semantic-segmentation","sections":[],"depth":1}';function Ja(ts){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends oa{constructor(c){super(),ra(this,c,Ja,da,ia,{})}}export{va as component};
