import{s as fl,o as ul,n as Y}from"../chunks/scheduler.bdbef820.js";import{S as gl,i as jl,g as r,s as l,r as h,A as Ml,h as c,f as e,c as n,j as mt,u as m,x as d,k as ht,y as bl,a as t,v as o,d as f,t as u,w as g}from"../chunks/index.c0aea24a.js";import{T as ja}from"../chunks/Tip.31005f7d.js";import{C as M}from"../chunks/CodeBlock.6ccca92e.js";import{F as yl,M as wl}from"../chunks/Markdown.1f17db59.js";import{H as T,E as Tl}from"../chunks/EditOnGithub.725ee0c1.js";function Jl(w){let p,j=`An <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is useful for iterative jobs like training a model.
You shouldn’t use a <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> for jobs that require random access to examples because you have to iterate all over it using a for loop. Getting the last example in an iterable dataset would require you to iterate over all the previous examples.
You can find more details in the <a href="./about_mapstyle_vs_iterable">Dataset vs. IterableDataset guide</a>.`;return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-jiqeyu"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function xl(w){let p,j='<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will also shuffle the order of the shards if the dataset is sharded into multiple files.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-9zx9sc"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function $l(w){let p,j="<code>take</code> and <code>skip</code> prevent future calls to <code>shuffle</code> because they lock in the order of the shards. You should <code>shuffle</code> your dataset before splitting it.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kg825l"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function _l(w){let p,j="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&#39;int32&#39;)</code> to <code>Value(&#39;bool&#39;)</code> if the original column only contains ones and zeros.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-19jja92"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function kl(w){let p,j='See other examples of batch processing in the <a href="./process#batch-processing">batched map processing</a> documentation. They work the same for iterable datasets.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-csithm"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function Zl(w){let p,j='There is also a “Batch Processing” option when using the <code>map</code> function to apply a function to batches of data, which is discussed in the <a href="#map">Map section</a> above. The <code>batch</code> method described here is different and provides a more direct way to create batches from your dataset.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-f0d9pr"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function Ul(w){let p,j,i,b="Lastly, create a simple training loop and start training:",J,x,$;return p=new M({props:{code:"c2VlZCUyQyUyMGJ1ZmZlcl9zaXplJTIwJTNEJTIwNDIlMkMlMjAxMF8wMDAlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zaHVmZmxlKHNlZWQlMkMlMjBidWZmZXJfc2l6ZSUzRGJ1ZmZlcl9zaXplKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>seed, buffer_size = <span class="hljs-number">42</span>, <span class="hljs-number">10_000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.shuffle(seed, buffer_size=buffer_size)`,wrap:!1}}),x=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yTWFza2VkTE0lMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZGF0YXNldCUyQyUyMGNvbGxhdGVfZm4lM0REYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nKHRva2VuaXplcikpJTBBZGV2aWNlJTIwJTNEJTIwJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnJTIwJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwudHJhaW4oKS50byhkZXZpY2UpJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcocGFyYW1zJTNEbW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QxZS01KSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRxZG0oZGF0YWxvYWRlciUyQyUyMHRvdGFsJTNENSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwNSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cyU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTI1JTIwMTAlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMmxvc3MlM0ElMjAlN0Jsb3NzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMaskedLM, DataCollatorForLanguageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(dataset, collate_fn=DataCollatorForLanguageModeling(tokenizer))
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span> 
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.train().to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(params=model.parameters(), lr=<span class="hljs-number">1e-5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(dataloader, total=<span class="hljs-number">5</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i == <span class="hljs-number">5</span>:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;loss: <span class="hljs-subst">{loss}</span>&quot;</span>)`,wrap:!1}}),{c(){h(p.$$.fragment),j=l(),i=r("p"),i.textContent=b,J=l(),h(x.$$.fragment)},l(y){m(p.$$.fragment,y),j=n(y),i=c(y,"P",{"data-svelte-h":!0}),d(i)!=="svelte-uyzjf"&&(i.textContent=b),J=n(y),m(x.$$.fragment,y)},m(y,_){o(p,y,_),t(y,j,_),t(y,i,_),t(y,J,_),o(x,y,_),$=!0},p:Y,i(y){$||(f(p.$$.fragment,y),f(x.$$.fragment,y),$=!0)},o(y){u(p.$$.fragment,y),u(x.$$.fragment,y),$=!1},d(y){y&&(e(j),e(i),e(J)),g(p,y),g(x,y)}}}function Gl(w){let p,j;return p=new wl({props:{$$slots:{default:[Ul]},$$scope:{ctx:w}}}),{c(){h(p.$$.fragment)},l(i){m(p.$$.fragment,i)},m(i,b){o(p,i,b),j=!0},p(i,b){const J={};b&2&&(J.$$scope={dirty:b,ctx:i}),p.$set(J)},i(i){j||(f(p.$$.fragment,i),j=!0)},o(i){u(p.$$.fragment,i),j=!1},d(i){g(p,i)}}}function Xl(w){let p,j="Resuming returns exactly where the checkpoint was saved except if <code>.shuffle()</code> is used: examples from shuffle buffers are lost when resuming and the buffers are refilled with new data.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1aaqobe"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Y,d(i){i&&e(p)}}}function vl(w){let p,j,i,b,J,x,$,y=`Dataset streaming lets you work with a dataset without downloading it.
The data is streamed as you iterate over the dataset.
This is especially helpful when:`,_,F,ot="<li>You don’t want to wait for an extremely large dataset to download.</li> <li>The dataset size exceeds the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",ya,k,ft='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming-dark.gif"/>',wa,V,ut='For example, the English split of the <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> dataset is 1.2 terabytes, but you can use it instantly with streaming. Stream a dataset by setting <code>streaming=True</code> in <a href="/docs/datasets/v2.21.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> as shown below:',Ta,W,Ja,z,gt=`Dataset streaming also lets you work with a dataset made of local files without doing any conversion.
In this case, the data is streamed from the local files as you iterate over the dataset.
This is especially helpful when:`,xa,B,jt="<li>You don’t want to wait for an extremely large local dataset to be converted to Arrow.</li> <li>The converted files size would exceed the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",$a,N,Mt='For example, you can stream a local dataset of hundreds of compressed JSONL files like <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> to use it instantly:',_a,Q,ka,H,bt=`Loading a dataset in streaming mode creates a new dataset type instance (instead of the classic <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object), known as an <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
This special type of dataset has its own set of processing methods shown below.`,Za,Z,Ua,S,Ga,L,yt='If you have an existing <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can convert it to an <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with the <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function. This is actually faster than setting the <code>streaming=True</code> argument in <a href="/docs/datasets/v2.21.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> because the data is streamed from local files.',Xa,D,va,E,wt='The <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function supports sharding when the <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is instantiated. This is useful when working with big datasets, and you’d like to shuffle the dataset or to enable fast parallel loading with a PyTorch DataLoader.',Ra,A,Ca,q,Ia,K,Tt='Like a regular <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can also shuffle a <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.',Ya,P,Jt='The <code>buffer_size</code> argument controls the size of the buffer to randomly sample examples from. Let’s say your dataset has one million examples, and you set the <code>buffer_size</code> to ten thousand. <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will randomly select examples from the first ten thousand examples in the buffer. Selected examples in the buffer are replaced with new examples. By default, the buffer size is 1,000.',Fa,O,Va,U,Wa,ss,za,as,xt="Sometimes you may want to reshuffle the dataset after each epoch. This will require you to set a different seed for each epoch. Use <code>IterableDataset.set_epoch()</code> in between epochs to tell the dataset what epoch you’re on.",Ba,es,$t="Your seed effectively becomes: <code>initial seed + current epoch</code>.",Na,ts,Qa,ls,Ha,ns,_t="You can split your dataset one of two ways:",Sa,ps,kt='<li><a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> returns the first <code>n</code> examples in a dataset:</li>',La,is,Da,rs,Zt='<li><a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.skip">IterableDataset.skip()</a> omits the first <code>n</code> examples in a dataset and returns the remaining examples:</li>',Ea,cs,Aa,G,qa,Ma,Ka,ds,Pa,hs,Ut='<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> can combine an <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with other datasets. The combined dataset returns alternating examples from each of the original datasets.',Oa,ms,se,os,Gt="Define sampling probabilities from each of the original datasets for more control over how each of them are sampled and combined. Set the <code>probabilities</code> argument with your desired sampling probabilities:",ae,fs,ee,us,Xt="Around 80% of the final dataset is made of the <code>en_dataset</code>, and 20% of the <code>fr_dataset</code>.",te,gs,vt=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,le,js,ne,Ms,Rt="The following methods allow you to modify the columns of a dataset. These methods are useful for renaming or removing columns and changing columns to a new set of features.",pe,bs,ie,ys,Ct='Use <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',re,ws,It='Provide <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> with the name of the original column, and the new column name:',ce,Ts,de,Js,he,xs,Yt='When you need to remove one or more columns, give <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.remove_columns">IterableDataset.remove_columns()</a> the name of the column to remove. Remove more than one column by providing a list of column names:',me,$s,oe,_s,fe,ks,Ft='<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.cast">IterableDataset.cast()</a> changes the feature type of one or more columns. This method takes your new <code>Features</code> as its argument. The following sample code shows how to change the feature types of <code>ClassLabel</code> and <code>Value</code>:',ue,Zs,ge,X,je,Us,Vt='Use <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.cast_column">IterableDataset.cast_column()</a> to change the feature type of just one column. Pass the column name and its new feature type as arguments:',Me,Gs,be,Xs,ye,vs,Wt=`Similar to the <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a> function for a regular <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, 🤗  Datasets features <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> for processing an <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> applies processing on-the-fly when examples are streamed.`,we,Rs,zt="It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.",Te,Cs,Bt='The following example demonstrates how to tokenize a <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. The function needs to accept and output a <code>dict</code>:',Je,Is,xe,Ys,Nt='Next, apply this function to the dataset with <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',$e,Fs,_e,Vs,Qt='Let’s take a look at another example, except this time, you will remove a column with <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',ke,Ws,Ht='Specify the column to remove with the <code>remove_columns</code> argument in <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',Ze,zs,Ue,Bs,Ge,Ns,St='<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> also supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> argument. This opens the door to many interesting applications such as tokenization, splitting long sentences into shorter chunks, and data augmentation.',Xe,Qs,ve,Hs,Re,v,Ce,Ss,Ie,Ls,Lt='You can filter rows in the dataset based on a predicate function using <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a>. It returns rows that match a specified condition:',Ye,Ds,Fe,Es,Dt='<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',Ve,As,We,qs,ze,Ks,Et="The <code>batch</code> method transforms your <code>IterableDataset</code> into an iterable of batches. This is particularly useful when you want to work with batches in your training loop or when using frameworks that expect batched inputs.",Be,R,Ne,Ps,At="You can use the <code>batch</code> method like this:",Qe,Os,He,sa,qt=`In this example, batched_dataset is still an IterableDataset, but each item yielded is now a batch of 32 samples instead of a single sample.
This batching is done on-the-fly as you iterate over the dataset, preserving the memory-efficient nature of IterableDataset.`,Se,aa,Kt=`The batch method also provides a drop_last_batch parameter.
When set to True, it will discard the last batch if it’s smaller than the specified batch_size.
This can be useful in scenarios where your downstream processing requires all batches to be of the same size:`,Le,ea,De,ta,Ee,la,Pt='<a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> can be integrated into a training loop. First, shuffle the dataset:',Ae,C,qe,na,Ke,pa,Ot="If your training loop stops, you may want to restart the training from where it was. To do so you can save a checkpoint of your model and optimizers, as well as your data loader.",Pe,ia,sl='Iterable datasets don’t provide random access to a specific example index to resume from, but you can use <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.state_dict">IterableDataset.state_dict()</a> and <a href="/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.IterableDataset.load_state_dict">IterableDataset.load_state_dict()</a> to resume from a checkpoint instead, similarly to what you can do for models and optimizers:',Oe,ra,st,ca,al="Returns:",at,da,et,ha,el="Under the hood, the iterable dataset keeps track of the current shard being read and the example index in the current shard and it stores this info in the <code>state_dict</code>.",tt,ma,tl=`To resume from a checkpoint, the dataset skips all the shards that were previously read to restart from the current shard.
Then it reads the shard and skips examples until it reaches the exact example from the checkpoint.`,lt,oa,ll="Therefore restarting a dataset is quite fast, since it will not re-read the shards that have already been iterated on. Still, resuming a dataset is generally not instantaneous since it has to restart reading from the beginning of the current shard and skip examples until it reaches the checkpoint location.",nt,fa,nl="This can be used with the <code>StatefulDataLoader</code> from <code>torchdata</code>:",pt,ua,it,I,rt,ga,ct,ba,dt;return J=new T({props:{title:"Stream",local:"stream",headingTag:"h1"}}),W=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXItY29ycHVzJTJGT1NDQVItMjIwMSclMkMlMjAnZW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar-corpus/OSCAR-2201&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),Q=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3Qid0cmFpbiclM0ElMjAncGF0aCUyRnRvJTJGT1NDQVItMjIwMSUyRmNvbXByZXNzZWQlMkZlbl9tZXRhJTJGKi5qc29ubC5neiclN0QlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdqc29uJyUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;path/to/OSCAR-2201/compressed/en_meta/*.jsonl.gz&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;json&#x27;</span>, data_files=data_files, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),Z=new ja({props:{$$slots:{default:[Jl]},$$scope:{ctx:w}}}),S=new T({props:{title:"Convert from a Dataset",local:"convert-from-a-dataset",headingTag:"h2"}}),D=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKSUwQSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># faster 🐇</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()

<span class="hljs-comment"># slower 🐢</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, streaming=<span class="hljs-literal">True</span>)`,wrap:!1}}),A=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZvb2QxMDElMjIpJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNENjQpJTIwJTIzJTIwc2hhcmQlMjB0aGUlMjBkYXRhc2V0JTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGl0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShidWZmZXJfc2l6ZSUzRDEwXzAwMCklMjAlMjAlMjMlMjBzaHVmZmxlcyUyMHRoZSUyMHNoYXJkcyUyMG9yZGVyJTIwYW5kJTIwdXNlJTIwYSUyMHNodWZmbGUlMjBidWZmZXIlMjB3aGVuJTIweW91JTIwc3RhcnQlMjBpdGVyYXRpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">64</span>) <span class="hljs-comment"># shard the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = iterable_dataset.shuffle(buffer_size=<span class="hljs-number">10_000</span>)  <span class="hljs-comment"># shuffles the shards order and use a shuffle buffer when you start iterating</span>
dataloader = torch.utils.data.DataLoader(iterable_dataset, num_workers=<span class="hljs-number">4</span>)  <span class="hljs-comment"># assigns 64 / 4 = 16 shards from the shuffled list of shards to each worker when you start iterating</span>`,wrap:!1}}),q=new T({props:{title:"Shuffle",local:"shuffle",headingTag:"h2"}}),O=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQXNodWZmbGVkX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMF8wMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">10_000</span>)`,wrap:!1}}),U=new ja({props:{$$slots:{default:[xl]},$$scope:{ctx:w}}}),ss=new T({props:{title:"Reshuffle",local:"reshuffle",headingTag:"h2"}}),ts=new M({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGVwb2NocyklM0ElMEElMjAlMjAlMjAlMjBzaHVmZmxlZF9kYXRhc2V0LnNldF9lcG9jaChlcG9jaCklMEElMjAlMjAlMjAlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBzaHVmZmxlZF9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
<span class="hljs-meta">... </span>    shuffled_dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> shuffled_dataset:
<span class="hljs-meta">... </span>        ...`,wrap:!1}}),ls=new T({props:{title:"Split dataset",local:"split-dataset",headingTag:"h2"}}),is=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXRfaGVhZCUyMCUzRCUyMGRhdGFzZXQudGFrZSgyKSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_head = dataset.take(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(dataset_head)
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was...&#x27;</span>}, {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),cs=new M({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHNodWZmbGVkX2RhdGFzZXQuc2tpcCgxMDAwKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)',wrap:!1}}),G=new ja({props:{warning:!0,$$slots:{default:[$l]},$$scope:{ctx:w}}}),ds=new T({props:{title:"Interleave",local:"interleave",headingTag:"h2"}}),ms=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyUwQWVuX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ29zY2FyJyUyQyUyMCUyMnVuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJTIyJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFmcl9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdvc2NhciclMkMlMjAlMjJ1bnNodWZmbGVkX2RlZHVwbGljYXRlZF9mciUyMiUyQyUyMHNwbGl0JTNEJ3RyYWluJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBbXVsdGlsaW5ndWFsX2RhdGFzZXQlMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEKSUwQWxpc3QobXVsdGlsaW5ndWFsX2RhdGFzZXQudGFrZSgyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>en_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fr_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_fr&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset = interleave_datasets([en_dataset, fr_dataset])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Média de débat d&#x27;idées, de culture et de littérature...&quot;</span>}]`,wrap:!1}}),fs=new M({props:{code:"bXVsdGlsaW5ndWFsX2RhdGFzZXRfd2l0aF9vdmVyc2FtcGxpbmclMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEJTJDJTIwcHJvYmFiaWxpdGllcyUzRCU1QjAuOCUyQyUyMDAuMiU1RCUyQyUyMHNlZWQlM0Q0MiklMEFsaXN0KG11bHRpbGluZ3VhbF9kYXRhc2V0X3dpdGhfb3ZlcnNhbXBsaW5nLnRha2UoMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset_with_oversampling = interleave_datasets([en_dataset, fr_dataset], probabilities=[<span class="hljs-number">0.8</span>, <span class="hljs-number">0.2</span>], seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset_with_oversampling.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),js=new T({props:{title:"Rename, remove, and cast",local:"rename-remove-and-cast",headingTag:"h2"}}),bs=new T({props:{title:"Rename",local:"rename",headingTag:"h3"}}),Ts=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIydGV4dCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>)`,wrap:!1}}),Js=new T({props:{title:"Remove",local:"remove",headingTag:"h3"}}),$s=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCd0aW1lc3RhbXAnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&#x27;timestamp&#x27;</span>)`,wrap:!1}}),_s=new T({props:{title:"Cast",local:"cast",headingTag:"h3"}}),Zs=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYyclMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXQuZmVhdHVyZXMlMEElMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBDbGFzc0xhYmVsJTJDJTIwVmFsdWUlMEFuZXdfZmVhdHVyZXMlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzLmNvcHkoKSUwQW5ld19mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwQ2xhc3NMYWJlbChuYW1lcyUzRCU1QiduZWdhdGl2ZSclMkMlMjAncG9zaXRpdmUnJTVEKSUwQW5ld19mZWF0dXJlcyU1QiUyMmlkeCUyMiU1RCUyMCUzRCUyMFZhbHVlKCdpbnQ2NCcpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdChuZXdfZmVhdHVyZXMpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&#x27;int64&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),X=new ja({props:{$$slots:{default:[_l]},$$scope:{ctx:w}}}),Gs=new M({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Xs=new T({props:{title:"Map",local:"map",headingTag:"h2"}}),Is=new M({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIndGV4dCclNUQlMjAlM0QlMjAnTXklMjB0ZXh0JTNBJTIwJyUyMCUyQiUyMGV4YW1wbGUlNUIndGV4dCclNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&#x27;text&#x27;</span>] = <span class="hljs-string">&#x27;My text: &#x27;</span> + example[<span class="hljs-string">&#x27;text&#x27;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Fs=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEFsaXN0KHVwZGF0ZWRfZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),zs=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyaWQlMjIlNUQpJTBBbGlzdCh1cGRhdGVkX2RhdGFzZXQudGFrZSgzKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix, remove_columns=[<span class="hljs-string">&quot;id&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Bs=new T({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),Qs=new T({props:{title:"Tokenization",local:"tokenization",headingTag:"h4"}}),Hs=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm1jNCUyMiUyQyUyMCUyMmVuJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyklMEFkZWYlMjBlbmNvZGUoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJ3RleHQnJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChlbmNvZGUlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUyQyUyMCUyMnVybCUyMiU1RCklMEFuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mc4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&#x27;text&#x27;</span>], truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&#x27;max_length&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(encode, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;timestamp&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">8466</span>, <span class="hljs-number">1018</span>, <span class="hljs-number">1010</span>, <span class="hljs-number">4029</span>, <span class="hljs-number">2475</span>, <span class="hljs-number">2062</span>, <span class="hljs-number">18558</span>, <span class="hljs-number">3100</span>, <span class="hljs-number">2061</span>, ...,<span class="hljs-number">1106</span>, <span class="hljs-number">3739</span>, <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),v=new ja({props:{$$slots:{default:[kl]},$$scope:{ctx:w}}}),Ss=new T({props:{title:"Filter",local:"filter",headingTag:"h3"}}),Ds=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBc3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJ3RleHQnJTVELnN0YXJ0c3dpdGgoJ0FyJykpJTBBbmV4dChpdGVyKHN0YXJ0X3dpdGhfYXIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&#x27;text&#x27;</span>].startswith(<span class="hljs-string">&#x27;Ar&#x27;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(start_with_ar))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)?...&#x27;</span>}`,wrap:!1}}),As=new M({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsaXN0KGV2ZW5fZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(even_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision of Chief Napoleon Dzombe, ...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;&quot;I\\&#x27;d love to help kickstart continued development! And 0 EUR/month...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)? Normally, ...&#x27;</span>}]`,wrap:!1}}),qs=new T({props:{title:"Batch",local:"batch",headingTag:"h2"}}),R=new ja({props:{$$slots:{default:[Zl]},$$scope:{ctx:w}}}),Os=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwTG9hZCUyMGElMjBkYXRhc2V0JTIwaW4lMjBzdHJlYW1pbmclMjBtb2RlJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzb21lX2RhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEElMEElMjMlMjBDcmVhdGUlMjBiYXRjaGVzJTIwb2YlMjAzMiUyMHNhbXBsZXMlMEFiYXRjaGVkX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmJhdGNoKGJhdGNoX3NpemUlM0QzMiklMEElMEElMjMlMjBJdGVyYXRlJTIwb3ZlciUyMHRoZSUyMGJhdGNoZWQlMjBkYXRhc2V0JTBBZm9yJTIwYmF0Y2glMjBpbiUyMGJhdGNoZWRfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGJhdGNoKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load a dataset in streaming mode</span>
dataset = load_dataset(<span class="hljs-string">&quot;some_dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Create batches of 32 samples</span>
batched_dataset = dataset.batch(batch_size=<span class="hljs-number">32</span>)

<span class="hljs-comment"># Iterate over the batched dataset</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> batched_dataset:
    <span class="hljs-built_in">print</span>(batch)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),ea=new M({props:{code:"YmF0Y2hlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5iYXRjaChiYXRjaF9zaXplJTNEMzIlMkMlMjBkcm9wX2xhc3RfYmF0Y2glM0RUcnVlKQ==",highlighted:'batched_dataset = dataset.batch(batch_size=<span class="hljs-number">32</span>, drop_last_batch=<span class="hljs-literal">True</span>)',wrap:!1}}),ta=new T({props:{title:"Stream in a training loop",local:"stream-in-a-training-loop",headingTag:"h2"}}),C=new yl({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Gl]},$$scope:{ctx:w}}}),na=new T({props:{title:"Save a dataset checkpoint and resume iteration",local:"save-a-dataset-checkpoint-and-resume-iteration",headingTag:"h3"}}),ra=new M({props:{code:"aXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmElMjIlM0ElMjByYW5nZSg2KSU3RCkudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMyklMEFmb3IlMjBpZHglMkMlMjBleGFtcGxlJTIwaW4lMjBlbnVtZXJhdGUoaXRlcmFibGVfZGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGlmJTIwaWR4JTIwJTNEJTNEJTIwMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjBpdGVyYWJsZV9kYXRhc2V0LnN0YXRlX2RpY3QoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMmNoZWNrcG9pbnQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEFpdGVyYWJsZV9kYXRhc2V0LmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0KSUwQXByaW50KGYlMjJyZXN0YXJ0JTIwZnJvbSUyMGNoZWNrcG9pbnQlMjIpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: <span class="hljs-built_in">range</span>(<span class="hljs-number">6</span>)}).to_iterable_dataset(num_shards=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> idx, example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(iterable_dataset):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> idx == <span class="hljs-number">2</span>:
<span class="hljs-meta">... </span>        state_dict = iterable_dataset.state_dict()
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;checkpoint&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">break</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset.load_state_dict(state_dict)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;restart from checkpoint&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)`,wrap:!1}}),da=new M({props:{code:"JTdCJ2EnJTNBJTIwMCU3RCUwQSU3QidhJyUzQSUyMDElN0QlMEElN0InYSclM0ElMjAyJTdEJTBBY2hlY2twb2ludCUwQXJlc3RhcnQlMjBmcm9tJTIwY2hlY2twb2ludCUwQSU3QidhJyUzQSUyMDMlN0QlMEElN0InYSclM0ElMjA0JTdEJTBBJTdCJ2EnJTNBJTIwNSU3RA==",highlighted:`{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">0</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">1</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">2</span>}
<span class="hljs-keyword">checkpoint</span>
<span class="hljs-keyword">restart</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">checkpoint</span>
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">3</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">4</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">5</span>}`,wrap:!1}}),ua=new M({props:{code:"ZnJvbSUyMHRvcmNoZGF0YS5zdGF0ZWZ1bF9kYXRhbG9hZGVyJTIwaW1wb3J0JTIwU3RhdGVmdWxEYXRhTG9hZGVyJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwU3RhdGVmdWxEYXRhTG9hZGVyKGl0ZXJhYmxlX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIzJTIwY2hlY2twb2ludCUwQXN0YXRlX2RpY3QlMjAlM0QlMjBkYXRhbG9hZGVyLnN0YXRlX2RpY3QoKSUyMCUyMCUyMyUyMHVzZXMlMjBpdGVyYWJsZV9kYXRhc2V0LnN0YXRlX2RpY3QoKSUyMHVuZGVyJTIwdGhlJTIwaG9vZCUwQSUyMyUyMHJlc3VtZSUyMGZyb20lMjBjaGVja3BvaW50JTBBZGF0YWxvYWRlci5sb2FkX3N0YXRlX2RpY3Qoc3RhdGVfZGljdCklMjAlMjAlMjMlMjB1c2VzJTIwaXRlcmFibGVfZGF0YXNldC5sb2FkX3N0YXRlX2RpY3QoKSUyMHVuZGVyJTIwdGhlJTIwaG9vZA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchdata.stateful_dataloader <span class="hljs-keyword">import</span> StatefulDataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = StatefulDataLoader(iterable_dataset, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># checkpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = dataloader.state_dict()  <span class="hljs-comment"># uses iterable_dataset.state_dict() under the hood</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># resume from checkpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader.load_state_dict(state_dict)  <span class="hljs-comment"># uses iterable_dataset.load_state_dict() under the hood</span>`,wrap:!1}}),I=new ja({props:{$$slots:{default:[Xl]},$$scope:{ctx:w}}}),ga=new Tl({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/stream.mdx"}}),{c(){p=r("meta"),j=l(),i=r("p"),b=l(),h(J.$$.fragment),x=l(),$=r("p"),$.textContent=y,_=l(),F=r("ul"),F.innerHTML=ot,ya=l(),k=r("div"),k.innerHTML=ft,wa=l(),V=r("p"),V.innerHTML=ut,Ta=l(),h(W.$$.fragment),Ja=l(),z=r("p"),z.textContent=gt,xa=l(),B=r("ul"),B.innerHTML=jt,$a=l(),N=r("p"),N.innerHTML=Mt,_a=l(),h(Q.$$.fragment),ka=l(),H=r("p"),H.innerHTML=bt,Za=l(),h(Z.$$.fragment),Ua=l(),h(S.$$.fragment),Ga=l(),L=r("p"),L.innerHTML=yt,Xa=l(),h(D.$$.fragment),va=l(),E=r("p"),E.innerHTML=wt,Ra=l(),h(A.$$.fragment),Ca=l(),h(q.$$.fragment),Ia=l(),K=r("p"),K.innerHTML=Tt,Ya=l(),P=r("p"),P.innerHTML=Jt,Fa=l(),h(O.$$.fragment),Va=l(),h(U.$$.fragment),Wa=l(),h(ss.$$.fragment),za=l(),as=r("p"),as.innerHTML=xt,Ba=l(),es=r("p"),es.innerHTML=$t,Na=l(),h(ts.$$.fragment),Qa=l(),h(ls.$$.fragment),Ha=l(),ns=r("p"),ns.textContent=_t,Sa=l(),ps=r("ul"),ps.innerHTML=kt,La=l(),h(is.$$.fragment),Da=l(),rs=r("ul"),rs.innerHTML=Zt,Ea=l(),h(cs.$$.fragment),Aa=l(),h(G.$$.fragment),qa=l(),Ma=r("a"),Ka=l(),h(ds.$$.fragment),Pa=l(),hs=r("p"),hs.innerHTML=Ut,Oa=l(),h(ms.$$.fragment),se=l(),os=r("p"),os.innerHTML=Gt,ae=l(),h(fs.$$.fragment),ee=l(),us=r("p"),us.innerHTML=Xt,te=l(),gs=r("p"),gs.innerHTML=vt,le=l(),h(js.$$.fragment),ne=l(),Ms=r("p"),Ms.textContent=Rt,pe=l(),h(bs.$$.fragment),ie=l(),ys=r("p"),ys.innerHTML=Ct,re=l(),ws=r("p"),ws.innerHTML=It,ce=l(),h(Ts.$$.fragment),de=l(),h(Js.$$.fragment),he=l(),xs=r("p"),xs.innerHTML=Yt,me=l(),h($s.$$.fragment),oe=l(),h(_s.$$.fragment),fe=l(),ks=r("p"),ks.innerHTML=Ft,ue=l(),h(Zs.$$.fragment),ge=l(),h(X.$$.fragment),je=l(),Us=r("p"),Us.innerHTML=Vt,Me=l(),h(Gs.$$.fragment),be=l(),h(Xs.$$.fragment),ye=l(),vs=r("p"),vs.innerHTML=Wt,we=l(),Rs=r("p"),Rs.textContent=zt,Te=l(),Cs=r("p"),Cs.innerHTML=Bt,Je=l(),h(Is.$$.fragment),xe=l(),Ys=r("p"),Ys.innerHTML=Nt,$e=l(),h(Fs.$$.fragment),_e=l(),Vs=r("p"),Vs.innerHTML=Qt,ke=l(),Ws=r("p"),Ws.innerHTML=Ht,Ze=l(),h(zs.$$.fragment),Ue=l(),h(Bs.$$.fragment),Ge=l(),Ns=r("p"),Ns.innerHTML=St,Xe=l(),h(Qs.$$.fragment),ve=l(),h(Hs.$$.fragment),Re=l(),h(v.$$.fragment),Ce=l(),h(Ss.$$.fragment),Ie=l(),Ls=r("p"),Ls.innerHTML=Lt,Ye=l(),h(Ds.$$.fragment),Fe=l(),Es=r("p"),Es.innerHTML=Dt,Ve=l(),h(As.$$.fragment),We=l(),h(qs.$$.fragment),ze=l(),Ks=r("p"),Ks.innerHTML=Et,Be=l(),h(R.$$.fragment),Ne=l(),Ps=r("p"),Ps.innerHTML=At,Qe=l(),h(Os.$$.fragment),He=l(),sa=r("p"),sa.textContent=qt,Se=l(),aa=r("p"),aa.textContent=Kt,Le=l(),h(ea.$$.fragment),De=l(),h(ta.$$.fragment),Ee=l(),la=r("p"),la.innerHTML=Pt,Ae=l(),h(C.$$.fragment),qe=l(),h(na.$$.fragment),Ke=l(),pa=r("p"),pa.textContent=Ot,Pe=l(),ia=r("p"),ia.innerHTML=sl,Oe=l(),h(ra.$$.fragment),st=l(),ca=r("p"),ca.textContent=al,at=l(),h(da.$$.fragment),et=l(),ha=r("p"),ha.innerHTML=el,tt=l(),ma=r("p"),ma.textContent=tl,lt=l(),oa=r("p"),oa.textContent=ll,nt=l(),fa=r("p"),fa.innerHTML=nl,pt=l(),h(ua.$$.fragment),it=l(),h(I.$$.fragment),rt=l(),h(ga.$$.fragment),ct=l(),ba=r("p"),this.h()},l(s){const a=Ml("svelte-u9bgzb",document.head);p=c(a,"META",{name:!0,content:!0}),a.forEach(e),j=n(s),i=c(s,"P",{}),mt(i).forEach(e),b=n(s),m(J.$$.fragment,s),x=n(s),$=c(s,"P",{"data-svelte-h":!0}),d($)!=="svelte-1sf84jt"&&($.textContent=y),_=n(s),F=c(s,"UL",{"data-svelte-h":!0}),d(F)!=="svelte-1y6qvic"&&(F.innerHTML=ot),ya=n(s),k=c(s,"DIV",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-p91s8d"&&(k.innerHTML=ft),wa=n(s),V=c(s,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1xaz61x"&&(V.innerHTML=ut),Ta=n(s),m(W.$$.fragment,s),Ja=n(s),z=c(s,"P",{"data-svelte-h":!0}),d(z)!=="svelte-xdwdpa"&&(z.textContent=gt),xa=n(s),B=c(s,"UL",{"data-svelte-h":!0}),d(B)!=="svelte-lffs3"&&(B.innerHTML=jt),$a=n(s),N=c(s,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1newt0m"&&(N.innerHTML=Mt),_a=n(s),m(Q.$$.fragment,s),ka=n(s),H=c(s,"P",{"data-svelte-h":!0}),d(H)!=="svelte-nwctdo"&&(H.innerHTML=bt),Za=n(s),m(Z.$$.fragment,s),Ua=n(s),m(S.$$.fragment,s),Ga=n(s),L=c(s,"P",{"data-svelte-h":!0}),d(L)!=="svelte-18xk8q"&&(L.innerHTML=yt),Xa=n(s),m(D.$$.fragment,s),va=n(s),E=c(s,"P",{"data-svelte-h":!0}),d(E)!=="svelte-18pls9l"&&(E.innerHTML=wt),Ra=n(s),m(A.$$.fragment,s),Ca=n(s),m(q.$$.fragment,s),Ia=n(s),K=c(s,"P",{"data-svelte-h":!0}),d(K)!=="svelte-4nv251"&&(K.innerHTML=Tt),Ya=n(s),P=c(s,"P",{"data-svelte-h":!0}),d(P)!=="svelte-ml1ghl"&&(P.innerHTML=Jt),Fa=n(s),m(O.$$.fragment,s),Va=n(s),m(U.$$.fragment,s),Wa=n(s),m(ss.$$.fragment,s),za=n(s),as=c(s,"P",{"data-svelte-h":!0}),d(as)!=="svelte-l7znh1"&&(as.innerHTML=xt),Ba=n(s),es=c(s,"P",{"data-svelte-h":!0}),d(es)!=="svelte-flznjz"&&(es.innerHTML=$t),Na=n(s),m(ts.$$.fragment,s),Qa=n(s),m(ls.$$.fragment,s),Ha=n(s),ns=c(s,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1y9p9l9"&&(ns.textContent=_t),Sa=n(s),ps=c(s,"UL",{"data-svelte-h":!0}),d(ps)!=="svelte-d900x5"&&(ps.innerHTML=kt),La=n(s),m(is.$$.fragment,s),Da=n(s),rs=c(s,"UL",{"data-svelte-h":!0}),d(rs)!=="svelte-1sxczqw"&&(rs.innerHTML=Zt),Ea=n(s),m(cs.$$.fragment,s),Aa=n(s),m(G.$$.fragment,s),qa=n(s),Ma=c(s,"A",{id:!0}),mt(Ma).forEach(e),Ka=n(s),m(ds.$$.fragment,s),Pa=n(s),hs=c(s,"P",{"data-svelte-h":!0}),d(hs)!=="svelte-1f9wnva"&&(hs.innerHTML=Ut),Oa=n(s),m(ms.$$.fragment,s),se=n(s),os=c(s,"P",{"data-svelte-h":!0}),d(os)!=="svelte-1t5oa18"&&(os.innerHTML=Gt),ae=n(s),m(fs.$$.fragment,s),ee=n(s),us=c(s,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1oi4bk"&&(us.innerHTML=Xt),te=n(s),gs=c(s,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-13euv56"&&(gs.innerHTML=vt),le=n(s),m(js.$$.fragment,s),ne=n(s),Ms=c(s,"P",{"data-svelte-h":!0}),d(Ms)!=="svelte-mlzv10"&&(Ms.textContent=Rt),pe=n(s),m(bs.$$.fragment,s),ie=n(s),ys=c(s,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-apqd8m"&&(ys.innerHTML=Ct),re=n(s),ws=c(s,"P",{"data-svelte-h":!0}),d(ws)!=="svelte-12sa2gb"&&(ws.innerHTML=It),ce=n(s),m(Ts.$$.fragment,s),de=n(s),m(Js.$$.fragment,s),he=n(s),xs=c(s,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-1nqcgte"&&(xs.innerHTML=Yt),me=n(s),m($s.$$.fragment,s),oe=n(s),m(_s.$$.fragment,s),fe=n(s),ks=c(s,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-g7f5zo"&&(ks.innerHTML=Ft),ue=n(s),m(Zs.$$.fragment,s),ge=n(s),m(X.$$.fragment,s),je=n(s),Us=c(s,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-1ikwjoa"&&(Us.innerHTML=Vt),Me=n(s),m(Gs.$$.fragment,s),be=n(s),m(Xs.$$.fragment,s),ye=n(s),vs=c(s,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-xzuzph"&&(vs.innerHTML=Wt),we=n(s),Rs=c(s,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-1rfoeeh"&&(Rs.textContent=zt),Te=n(s),Cs=c(s,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-13e56n2"&&(Cs.innerHTML=Bt),Je=n(s),m(Is.$$.fragment,s),xe=n(s),Ys=c(s,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1h8nxyz"&&(Ys.innerHTML=Nt),$e=n(s),m(Fs.$$.fragment,s),_e=n(s),Vs=c(s,"P",{"data-svelte-h":!0}),d(Vs)!=="svelte-1j6lzje"&&(Vs.innerHTML=Qt),ke=n(s),Ws=c(s,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-f3wuel"&&(Ws.innerHTML=Ht),Ze=n(s),m(zs.$$.fragment,s),Ue=n(s),m(Bs.$$.fragment,s),Ge=n(s),Ns=c(s,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-1nskuw5"&&(Ns.innerHTML=St),Xe=n(s),m(Qs.$$.fragment,s),ve=n(s),m(Hs.$$.fragment,s),Re=n(s),m(v.$$.fragment,s),Ce=n(s),m(Ss.$$.fragment,s),Ie=n(s),Ls=c(s,"P",{"data-svelte-h":!0}),d(Ls)!=="svelte-47obbx"&&(Ls.innerHTML=Lt),Ye=n(s),m(Ds.$$.fragment,s),Fe=n(s),Es=c(s,"P",{"data-svelte-h":!0}),d(Es)!=="svelte-y759sd"&&(Es.innerHTML=Dt),Ve=n(s),m(As.$$.fragment,s),We=n(s),m(qs.$$.fragment,s),ze=n(s),Ks=c(s,"P",{"data-svelte-h":!0}),d(Ks)!=="svelte-144pwpf"&&(Ks.innerHTML=Et),Be=n(s),m(R.$$.fragment,s),Ne=n(s),Ps=c(s,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-la94za"&&(Ps.innerHTML=At),Qe=n(s),m(Os.$$.fragment,s),He=n(s),sa=c(s,"P",{"data-svelte-h":!0}),d(sa)!=="svelte-z19uc5"&&(sa.textContent=qt),Se=n(s),aa=c(s,"P",{"data-svelte-h":!0}),d(aa)!=="svelte-1srxqyd"&&(aa.textContent=Kt),Le=n(s),m(ea.$$.fragment,s),De=n(s),m(ta.$$.fragment,s),Ee=n(s),la=c(s,"P",{"data-svelte-h":!0}),d(la)!=="svelte-1jvdw4w"&&(la.innerHTML=Pt),Ae=n(s),m(C.$$.fragment,s),qe=n(s),m(na.$$.fragment,s),Ke=n(s),pa=c(s,"P",{"data-svelte-h":!0}),d(pa)!=="svelte-qoizba"&&(pa.textContent=Ot),Pe=n(s),ia=c(s,"P",{"data-svelte-h":!0}),d(ia)!=="svelte-33vm3p"&&(ia.innerHTML=sl),Oe=n(s),m(ra.$$.fragment,s),st=n(s),ca=c(s,"P",{"data-svelte-h":!0}),d(ca)!=="svelte-f816x"&&(ca.textContent=al),at=n(s),m(da.$$.fragment,s),et=n(s),ha=c(s,"P",{"data-svelte-h":!0}),d(ha)!=="svelte-ul64r3"&&(ha.innerHTML=el),tt=n(s),ma=c(s,"P",{"data-svelte-h":!0}),d(ma)!=="svelte-fghrva"&&(ma.textContent=tl),lt=n(s),oa=c(s,"P",{"data-svelte-h":!0}),d(oa)!=="svelte-1i92o70"&&(oa.textContent=ll),nt=n(s),fa=c(s,"P",{"data-svelte-h":!0}),d(fa)!=="svelte-10pdp7c"&&(fa.innerHTML=nl),pt=n(s),m(ua.$$.fragment,s),it=n(s),m(I.$$.fragment,s),rt=n(s),m(ga.$$.fragment,s),ct=n(s),ba=c(s,"P",{}),mt(ba).forEach(e),this.h()},h(){ht(p,"name","hf:doc:metadata"),ht(p,"content",Rl),ht(k,"class","flex justify-center"),ht(Ma,"id","interleave_datasets")},m(s,a){bl(document.head,p),t(s,j,a),t(s,i,a),t(s,b,a),o(J,s,a),t(s,x,a),t(s,$,a),t(s,_,a),t(s,F,a),t(s,ya,a),t(s,k,a),t(s,wa,a),t(s,V,a),t(s,Ta,a),o(W,s,a),t(s,Ja,a),t(s,z,a),t(s,xa,a),t(s,B,a),t(s,$a,a),t(s,N,a),t(s,_a,a),o(Q,s,a),t(s,ka,a),t(s,H,a),t(s,Za,a),o(Z,s,a),t(s,Ua,a),o(S,s,a),t(s,Ga,a),t(s,L,a),t(s,Xa,a),o(D,s,a),t(s,va,a),t(s,E,a),t(s,Ra,a),o(A,s,a),t(s,Ca,a),o(q,s,a),t(s,Ia,a),t(s,K,a),t(s,Ya,a),t(s,P,a),t(s,Fa,a),o(O,s,a),t(s,Va,a),o(U,s,a),t(s,Wa,a),o(ss,s,a),t(s,za,a),t(s,as,a),t(s,Ba,a),t(s,es,a),t(s,Na,a),o(ts,s,a),t(s,Qa,a),o(ls,s,a),t(s,Ha,a),t(s,ns,a),t(s,Sa,a),t(s,ps,a),t(s,La,a),o(is,s,a),t(s,Da,a),t(s,rs,a),t(s,Ea,a),o(cs,s,a),t(s,Aa,a),o(G,s,a),t(s,qa,a),t(s,Ma,a),t(s,Ka,a),o(ds,s,a),t(s,Pa,a),t(s,hs,a),t(s,Oa,a),o(ms,s,a),t(s,se,a),t(s,os,a),t(s,ae,a),o(fs,s,a),t(s,ee,a),t(s,us,a),t(s,te,a),t(s,gs,a),t(s,le,a),o(js,s,a),t(s,ne,a),t(s,Ms,a),t(s,pe,a),o(bs,s,a),t(s,ie,a),t(s,ys,a),t(s,re,a),t(s,ws,a),t(s,ce,a),o(Ts,s,a),t(s,de,a),o(Js,s,a),t(s,he,a),t(s,xs,a),t(s,me,a),o($s,s,a),t(s,oe,a),o(_s,s,a),t(s,fe,a),t(s,ks,a),t(s,ue,a),o(Zs,s,a),t(s,ge,a),o(X,s,a),t(s,je,a),t(s,Us,a),t(s,Me,a),o(Gs,s,a),t(s,be,a),o(Xs,s,a),t(s,ye,a),t(s,vs,a),t(s,we,a),t(s,Rs,a),t(s,Te,a),t(s,Cs,a),t(s,Je,a),o(Is,s,a),t(s,xe,a),t(s,Ys,a),t(s,$e,a),o(Fs,s,a),t(s,_e,a),t(s,Vs,a),t(s,ke,a),t(s,Ws,a),t(s,Ze,a),o(zs,s,a),t(s,Ue,a),o(Bs,s,a),t(s,Ge,a),t(s,Ns,a),t(s,Xe,a),o(Qs,s,a),t(s,ve,a),o(Hs,s,a),t(s,Re,a),o(v,s,a),t(s,Ce,a),o(Ss,s,a),t(s,Ie,a),t(s,Ls,a),t(s,Ye,a),o(Ds,s,a),t(s,Fe,a),t(s,Es,a),t(s,Ve,a),o(As,s,a),t(s,We,a),o(qs,s,a),t(s,ze,a),t(s,Ks,a),t(s,Be,a),o(R,s,a),t(s,Ne,a),t(s,Ps,a),t(s,Qe,a),o(Os,s,a),t(s,He,a),t(s,sa,a),t(s,Se,a),t(s,aa,a),t(s,Le,a),o(ea,s,a),t(s,De,a),o(ta,s,a),t(s,Ee,a),t(s,la,a),t(s,Ae,a),o(C,s,a),t(s,qe,a),o(na,s,a),t(s,Ke,a),t(s,pa,a),t(s,Pe,a),t(s,ia,a),t(s,Oe,a),o(ra,s,a),t(s,st,a),t(s,ca,a),t(s,at,a),o(da,s,a),t(s,et,a),t(s,ha,a),t(s,tt,a),t(s,ma,a),t(s,lt,a),t(s,oa,a),t(s,nt,a),t(s,fa,a),t(s,pt,a),o(ua,s,a),t(s,it,a),o(I,s,a),t(s,rt,a),o(ga,s,a),t(s,ct,a),t(s,ba,a),dt=!0},p(s,[a]){const pl={};a&2&&(pl.$$scope={dirty:a,ctx:s}),Z.$set(pl);const il={};a&2&&(il.$$scope={dirty:a,ctx:s}),U.$set(il);const rl={};a&2&&(rl.$$scope={dirty:a,ctx:s}),G.$set(rl);const cl={};a&2&&(cl.$$scope={dirty:a,ctx:s}),X.$set(cl);const dl={};a&2&&(dl.$$scope={dirty:a,ctx:s}),v.$set(dl);const hl={};a&2&&(hl.$$scope={dirty:a,ctx:s}),R.$set(hl);const ml={};a&2&&(ml.$$scope={dirty:a,ctx:s}),C.$set(ml);const ol={};a&2&&(ol.$$scope={dirty:a,ctx:s}),I.$set(ol)},i(s){dt||(f(J.$$.fragment,s),f(W.$$.fragment,s),f(Q.$$.fragment,s),f(Z.$$.fragment,s),f(S.$$.fragment,s),f(D.$$.fragment,s),f(A.$$.fragment,s),f(q.$$.fragment,s),f(O.$$.fragment,s),f(U.$$.fragment,s),f(ss.$$.fragment,s),f(ts.$$.fragment,s),f(ls.$$.fragment,s),f(is.$$.fragment,s),f(cs.$$.fragment,s),f(G.$$.fragment,s),f(ds.$$.fragment,s),f(ms.$$.fragment,s),f(fs.$$.fragment,s),f(js.$$.fragment,s),f(bs.$$.fragment,s),f(Ts.$$.fragment,s),f(Js.$$.fragment,s),f($s.$$.fragment,s),f(_s.$$.fragment,s),f(Zs.$$.fragment,s),f(X.$$.fragment,s),f(Gs.$$.fragment,s),f(Xs.$$.fragment,s),f(Is.$$.fragment,s),f(Fs.$$.fragment,s),f(zs.$$.fragment,s),f(Bs.$$.fragment,s),f(Qs.$$.fragment,s),f(Hs.$$.fragment,s),f(v.$$.fragment,s),f(Ss.$$.fragment,s),f(Ds.$$.fragment,s),f(As.$$.fragment,s),f(qs.$$.fragment,s),f(R.$$.fragment,s),f(Os.$$.fragment,s),f(ea.$$.fragment,s),f(ta.$$.fragment,s),f(C.$$.fragment,s),f(na.$$.fragment,s),f(ra.$$.fragment,s),f(da.$$.fragment,s),f(ua.$$.fragment,s),f(I.$$.fragment,s),f(ga.$$.fragment,s),dt=!0)},o(s){u(J.$$.fragment,s),u(W.$$.fragment,s),u(Q.$$.fragment,s),u(Z.$$.fragment,s),u(S.$$.fragment,s),u(D.$$.fragment,s),u(A.$$.fragment,s),u(q.$$.fragment,s),u(O.$$.fragment,s),u(U.$$.fragment,s),u(ss.$$.fragment,s),u(ts.$$.fragment,s),u(ls.$$.fragment,s),u(is.$$.fragment,s),u(cs.$$.fragment,s),u(G.$$.fragment,s),u(ds.$$.fragment,s),u(ms.$$.fragment,s),u(fs.$$.fragment,s),u(js.$$.fragment,s),u(bs.$$.fragment,s),u(Ts.$$.fragment,s),u(Js.$$.fragment,s),u($s.$$.fragment,s),u(_s.$$.fragment,s),u(Zs.$$.fragment,s),u(X.$$.fragment,s),u(Gs.$$.fragment,s),u(Xs.$$.fragment,s),u(Is.$$.fragment,s),u(Fs.$$.fragment,s),u(zs.$$.fragment,s),u(Bs.$$.fragment,s),u(Qs.$$.fragment,s),u(Hs.$$.fragment,s),u(v.$$.fragment,s),u(Ss.$$.fragment,s),u(Ds.$$.fragment,s),u(As.$$.fragment,s),u(qs.$$.fragment,s),u(R.$$.fragment,s),u(Os.$$.fragment,s),u(ea.$$.fragment,s),u(ta.$$.fragment,s),u(C.$$.fragment,s),u(na.$$.fragment,s),u(ra.$$.fragment,s),u(da.$$.fragment,s),u(ua.$$.fragment,s),u(I.$$.fragment,s),u(ga.$$.fragment,s),dt=!1},d(s){s&&(e(j),e(i),e(b),e(x),e($),e(_),e(F),e(ya),e(k),e(wa),e(V),e(Ta),e(Ja),e(z),e(xa),e(B),e($a),e(N),e(_a),e(ka),e(H),e(Za),e(Ua),e(Ga),e(L),e(Xa),e(va),e(E),e(Ra),e(Ca),e(Ia),e(K),e(Ya),e(P),e(Fa),e(Va),e(Wa),e(za),e(as),e(Ba),e(es),e(Na),e(Qa),e(Ha),e(ns),e(Sa),e(ps),e(La),e(Da),e(rs),e(Ea),e(Aa),e(qa),e(Ma),e(Ka),e(Pa),e(hs),e(Oa),e(se),e(os),e(ae),e(ee),e(us),e(te),e(gs),e(le),e(ne),e(Ms),e(pe),e(ie),e(ys),e(re),e(ws),e(ce),e(de),e(he),e(xs),e(me),e(oe),e(fe),e(ks),e(ue),e(ge),e(je),e(Us),e(Me),e(be),e(ye),e(vs),e(we),e(Rs),e(Te),e(Cs),e(Je),e(xe),e(Ys),e($e),e(_e),e(Vs),e(ke),e(Ws),e(Ze),e(Ue),e(Ge),e(Ns),e(Xe),e(ve),e(Re),e(Ce),e(Ie),e(Ls),e(Ye),e(Fe),e(Es),e(Ve),e(We),e(ze),e(Ks),e(Be),e(Ne),e(Ps),e(Qe),e(He),e(sa),e(Se),e(aa),e(Le),e(De),e(Ee),e(la),e(Ae),e(qe),e(Ke),e(pa),e(Pe),e(ia),e(Oe),e(st),e(ca),e(at),e(et),e(ha),e(tt),e(ma),e(lt),e(oa),e(nt),e(fa),e(pt),e(it),e(rt),e(ct),e(ba)),e(p),g(J,s),g(W,s),g(Q,s),g(Z,s),g(S,s),g(D,s),g(A,s),g(q,s),g(O,s),g(U,s),g(ss,s),g(ts,s),g(ls,s),g(is,s),g(cs,s),g(G,s),g(ds,s),g(ms,s),g(fs,s),g(js,s),g(bs,s),g(Ts,s),g(Js,s),g($s,s),g(_s,s),g(Zs,s),g(X,s),g(Gs,s),g(Xs,s),g(Is,s),g(Fs,s),g(zs,s),g(Bs,s),g(Qs,s),g(Hs,s),g(v,s),g(Ss,s),g(Ds,s),g(As,s),g(qs,s),g(R,s),g(Os,s),g(ea,s),g(ta,s),g(C,s),g(na,s),g(ra,s),g(da,s),g(ua,s),g(I,s),g(ga,s)}}}const Rl='{"title":"Stream","local":"stream","sections":[{"title":"Convert from a Dataset","local":"convert-from-a-dataset","sections":[],"depth":2},{"title":"Shuffle","local":"shuffle","sections":[],"depth":2},{"title":"Reshuffle","local":"reshuffle","sections":[],"depth":2},{"title":"Split dataset","local":"split-dataset","sections":[],"depth":2},{"title":"Interleave","local":"interleave","sections":[],"depth":2},{"title":"Rename, remove, and cast","local":"rename-remove-and-cast","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Tokenization","local":"tokenization","sections":[],"depth":4}],"depth":3},{"title":"Filter","local":"filter","sections":[],"depth":3}],"depth":2},{"title":"Batch","local":"batch","sections":[],"depth":2},{"title":"Stream in a training loop","local":"stream-in-a-training-loop","sections":[{"title":"Save a dataset checkpoint and resume iteration","local":"save-a-dataset-checkpoint-and-resume-iteration","sections":[],"depth":3}],"depth":2}],"depth":1}';function Cl(w){return ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends gl{constructor(p){super(),jl(this,p,Cl,vl,fl,{})}}export{Bl as component};
