import{s as Pt,n as Kt,o as Ot}from"../chunks/scheduler.182ea377.js";import{S as el,i as tl,g as n,s,r,A as ll,h as o,f as l,c as a,j as Dt,u as d,x as p,k as M,l as ft,y as il,a as i,v as c,d as m,t as h,w as u}from"../chunks/index.abf12888.js";import{C as U}from"../chunks/CodeBlock.57fe6e13.js";import{H as T,E as sl}from"../chunks/EditOnGithub.9b8e78e4.js";function al(Mt){let J,Me,ge,Je,I,Te,B,Jt='<a href="marigold">Marigold</a> is a novel diffusion-based dense prediction approach, and a set of pipelines for various computer vision tasks, such as monocular depth estimation.',we,W,Tt="This guide will show you how to use Marigold to obtain fast and high-quality predictions for images and videos.",ye,k,wt=`Each pipeline supports one Computer Vision task, which takes an input RGB image as input and produces a <em>prediction</em> of the modality of interest, such as a depth map of the input image.
Currently, the following tasks are implemented:`,be,x,yt='<thead><tr><th>Pipeline</th> <th>Predicted Modalities</th> <th align="center">Demos</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py" rel="nofollow">MarigoldDepthPipeline</a></td> <td><a href="https://en.wikipedia.org/wiki/Depth_map" rel="nofollow">Depth</a>, <a href="https://en.wikipedia.org/wiki/Binocular_disparity" rel="nofollow">Disparity</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-lcm" rel="nofollow">Fast Demo (LCM)</a>, <a href="https://huggingface.co/spaces/prs-eth/marigold" rel="nofollow">Slow Original Demo (DDIM)</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py" rel="nofollow">MarigoldNormalsPipeline</a></td> <td><a href="https://en.wikipedia.org/wiki/Normal_mapping" rel="nofollow">Surface normals</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-normals-lcm" rel="nofollow">Fast Demo (LCM)</a></td></tr></tbody>',Ze,G,bt=`The original checkpoints can be found under the <a href="https://huggingface.co/prs-eth/" rel="nofollow">PRS-ETH</a> Hugging Face organization.
These checkpoints are meant to work with diffusers pipelines and the <a href="https://github.com/prs-eth/marigold" rel="nofollow">original codebase</a>.
The original code can also be used to train new checkpoints.`,ve,_,Zt='<thead><tr><th>Checkpoint</th> <th>Modality</th> <th>Comment</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/prs-eth/marigold-v1-0" rel="nofollow">prs-eth/marigold-v1-0</a></td> <td>Depth</td> <td>The first Marigold Depth checkpoint, which predicts <em>affine-invariant depth</em> maps. The performance of this checkpoint in benchmarks was studied in the original <a href="https://huggingface.co/papers/2312.02145" rel="nofollow">paper</a>. Designed to be used with the <code>DDIMScheduler</code> at inference, it requires at least 10 steps to get reliable predictions. Affine-invariant depth prediction has a range of values in each pixel between 0 (near plane) and 1 (far plane); both planes are chosen by the model as part of the inference process. See the <code>MarigoldImageProcessor</code> reference for visualization utilities.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-lcm-v1-0" rel="nofollow">prs-eth/marigold-lcm-v1-0</a></td> <td>Depth</td> <td>The fast Marigold Depth checkpoint, fine-tuned from <code>prs-eth/marigold-v1-0</code>. Designed to be used with the <code>LCMScheduler</code> at inference, it requires as little as 1 step to get reliable predictions. The prediction reliability saturates at 4 steps and declines after that.</td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-normals-v0-1" rel="nofollow">prs-eth/marigold-normals-v0-1</a></td> <td>Normals</td> <td>A preview checkpoint for the Marigold Normals pipeline. Designed to be used with the <code>DDIMScheduler</code> at inference, it requires at least 10 steps to get reliable predictions. The surface normals predictions are unit-length 3D vectors with values in the range from -1 to 1. <em>This checkpoint will be phased out after the release of <code>v1-0</code> version.</em></td></tr> <tr><td><a href="https://huggingface.co/prs-eth/marigold-normals-lcm-v0-1" rel="nofollow">prs-eth/marigold-normals-lcm-v0-1</a></td> <td>Normals</td> <td>The fast Marigold Normals checkpoint, fine-tuned from <code>prs-eth/marigold-normals-v0-1</code>. Designed to be used with the <code>LCMScheduler</code> at inference, it requires as little as 1 step to get reliable predictions. The prediction reliability saturates at 4 steps and declines after that. <em>This checkpoint will be phased out after the release of <code>v1-0</code> version.</em></td></tr></tbody>',je,R,vt=`The examples below are mostly given for depth prediction, but they can be universally applied with other supported modalities.
We showcase the predictions using the same input image of Albert Einstein generated by Midjourney.
This makes it easier to compare visualizations of the predictions across various modalities and checkpoints.`,Ue,g,jt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://marigoldmonodepth.github.io/images/einstein.jpg"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Example input image for all Marigold pipelines</figcaption></div>',Ie,X,Be,C,Ut="To get the first depth prediction, load <code>prs-eth/marigold-depth-lcm-v1-0</code> checkpoint into <code>MarigoldDepthPipeline</code> pipeline, put the image through the pipeline, and save the predictions:",We,z,ke,V,It=`The visualization function for depth <code>visualize_depth()</code> applies one of <a href="https://matplotlib.org/stable/users/explain/colors/colormaps.html" rel="nofollow">matplotlib’s colormaps</a> (<code>Spectral</code> by default) to map the predicted pixel values from a single-channel <code>[0, 1]</code> depth range into an RGB image.
With the <code>Spectral</code> colormap, pixels with near depth are painted red, and far pixels are assigned blue color.
The 16-bit PNG file stores the single channel values mapped linearly from the <code>[0, 1]</code> range into <code>[0, 65535]</code>.
Below are the raw and the visualized predictions; as can be seen, dark areas (mustache) are easier to distinguish in the visualization:`,xe,w,Bt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_lcm_depth_16bit.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted depth (16-bit PNG)</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_lcm_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted depth visualization (Spectral)</figcaption></div>',Ge,E,_e,H,Wt="Load <code>prs-eth/marigold-normals-lcm-v0-1</code> checkpoint into <code>MarigoldNormalsPipeline</code> pipeline, put the image through the pipeline, and save the predictions:",Re,N,Xe,$,kt=`The visualization function for normals <code>visualize_normals()</code> maps the three-dimensional prediction with pixel values in the range <code>[-1, 1]</code> into an RGB image.
The visualization function supports flipping surface normals axes to make the visualization compatible with other choices of the frame of reference.
Conceptually, each pixel is painted according to the surface normal vector in the frame of reference, where <code>X</code> axis points right, <code>Y</code> axis points up, and <code>Z</code> axis points at the viewer.
Below is the visualized prediction:`,Ce,f,xt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_lcm_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted surface normals visualization</figcaption></div>',ze,S,Gt=`In this example, the nose tip almost certainly has a point on the surface, in which the surface normal vector points straight at the viewer, meaning that its coordinates are <code>[0, 0, 1]</code>.
This vector maps to the RGB <code>[128, 128, 255]</code>, which corresponds to the violet-blue color.
Similarly, a surface normal on the cheek in the right part of the image has a large <code>X</code> component, which increases the red hue.
Points on the shoulders pointing up with a large <code>Y</code> promote green color.`,Ve,L,Ee,Y,_t=`The above quick start snippets are already optimized for speed: they load the LCM checkpoint, use the <code>fp16</code> variant of weights and computation, and perform just one denoising diffusion step.
The <code>pipe(image)</code> call completes in 280ms on RTX 3090 GPU.
Internally, the input image is encoded with the Stable Diffusion VAE encoder, then the U-Net performs one denoising step, and finally, the prediction latent is decoded with the VAE decoder into pixel space.
In this case, two out of three module calls are dedicated to converting between pixel and latent space of LDM.
Because Marigold’s latent space is compatible with the base Stable Diffusion, it is possible to speed up the pipeline call by more than 3x (85ms on RTX 3090) by using a <a href="autoencoder_tiny">lightweight replacement of the SD VAE</a>:`,He,q,Ne,A,Rt='As suggested in <a href="torch2.0">Optimizations</a>, adding <code>torch.compile</code> may squeeze extra performance depending on the target hardware:',$e,F,Se,Q,Le,D,Xt='With the above speed optimizations, Marigold delivers predictions with more details and faster than <a href="https://huggingface.co/docs/transformers/main/en/model_doc/depth_anything" rel="nofollow">Depth Anything</a> with the largest checkpoint <a href="https://huggingface.co/LiheYoung/depth-anything-large-hf" rel="nofollow">LiheYoung/depth-anything-large-hf</a>:',Ye,y,Ct='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_lcm_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold LCM fp16 with Tiny AutoEncoder</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/bfe7cb56ca1cc0811b328212472350879dfa7f8b/marigold/einstein_depthanything_large.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth Anything Large</figcaption></div>',qe,P,Ae,K,zt=`Marigold pipelines have a built-in ensembling mechanism combining multiple predictions from different random latents.
This is a brute-force way of improving the precision of predictions, capitalizing on the generative nature of diffusion.
The ensembling path is activated automatically when the <code>ensemble_size</code> argument is set greater than <code>1</code>.
When aiming for maximum precision, it makes sense to adjust <code>num_inference_steps</code> simultaneously with <code>ensemble_size</code>.
The recommended values vary across checkpoints but primarily depend on the scheduler type.
The effect of ensembling is particularly well-seen with surface normals:`,Fe,O,Qe,b,Vt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_lcm_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals, no ensembling</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals, with ensembling</figcaption></div>',De,ee,Et=`As can be seen, all areas with fine-grained structurers, such as hair, got more conservative and on average more correct predictions.
Such a result is more suitable for precision-sensitive downstream tasks, such as 3D reconstruction.`,Pe,te,Ke,le,Ht=`To evaluate Marigold quantitatively in standard leaderboards and benchmarks (such as NYU, KITTI, and other datasets), follow the evaluation protocol outlined in the paper: load the full precision fp32 model and use appropriate values for <code>num_inference_steps</code> and <code>ensemble_size</code>.
Optionally seed randomness to ensure reproducibility. Maximizing <code>batch_size</code> will deliver maximum device utilization.`,Oe,ie,et,se,tt,ae,Nt=`The ensembling mechanism built into Marigold pipelines combines multiple predictions obtained from different random latents.
As a side effect, it can be used to quantify epistemic (model) uncertainty; simply specify <code>ensemble_size</code> greater than 1 and set <code>output_uncertainty=True</code>.
The resulting uncertainty will be available in the <code>uncertainty</code> field of the output.
It can be visualized as follows:`,lt,ne,it,Z,$t='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_depth_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth uncertainty</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/6838ae9b9148cfe22ce9bb4c0ab0907c757c4010/marigold/marigold_einstein_normals_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals uncertainty</figcaption></div>',st,oe,St=`The interpretation of uncertainty is easy: higher values (white) correspond to pixels, where the model struggles to make consistent predictions.
Evidently, the depth model is the least confident around edges with discontinuity, where the object depth changes drastically.
The surface normals model is the least confident in fine-grained structures, such as hair, and dark areas, such as the collar.`,at,pe,nt,re,Lt=`Due to Marigold’s generative nature, each prediction is unique and defined by the random noise sampled for the latent initialization.
This becomes an obvious drawback compared to traditional end-to-end dense regression networks, as exemplified in the following videos:`,ot,v,Yt='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/25024b5443a6c1357492751fd09355bd3f967845/marigold/marigold_obama.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Input video</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/25024b5443a6c1357492751fd09355bd3f967845/marigold/marigold_obama_depth_independent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth applied to input video frames independently</figcaption></div>',pt,de,qt=`To address this issue, it is possible to pass <code>latents</code> argument to the pipelines, which defines the starting point of diffusion.
Empirically, we found that a convex combination of the very same starting point noise latent and the latent corresponding to the previous frame prediction give sufficiently smooth results, as implemented in the snippet below:`,rt,ce,dt,me,At=`Here, the diffusion process starts from the given computed latent.
The pipeline sets <code>output_latent=True</code> to access <code>out.latent</code> and computes its contribution to the next frame’s latent initialization.
The result is much more stable now:`,ct,j,Ft='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/25024b5443a6c1357492751fd09355bd3f967845/marigold/marigold_obama_depth_independent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth applied to input video frames independently</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/25024b5443a6c1357492751fd09355bd3f967845/marigold/marigold_obama_depth_consistent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth with forced latents initialization</figcaption></div>',mt,he,Qt="Hopefully, you will find Marigold useful for solving your downstream tasks, be it a part of a more broad generative workflow, or a broader perception task, such as 3D reconstruction.",ht,ue,ut,fe,gt;return I=new T({props:{title:"Marigold Pipelines for Computer Vision Tasks",local:"marigold-pipelines-for-computer-vision-tasks",headingTag:"h1"}}),X=new T({props:{title:"Depth Prediction Quick Start",local:"depth-prediction-quick-start",headingTag:"h3"}}),z=new U({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEFkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX2RlcHRoKGRlcHRoLnByZWRpY3Rpb24pJTBBdmlzJTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX2RlcHRoLnBuZyUyMiklMEElMEFkZXB0aF8xNmJpdCUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLmV4cG9ydF9kZXB0aF90b18xNmJpdF9wbmcoZGVwdGgucHJlZGljdGlvbiklMEFkZXB0aF8xNmJpdCU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9kZXB0aF8xNmJpdC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
depth = pipe(image)

vis = pipe.image_processor.visualize_depth(depth.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth.png&quot;</span>)

depth_16bit = pipe.image_processor.export_depth_to_16bit_png(depth.prediction)
depth_16bit[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_16bit.png&quot;</span>)`,wrap:!1}}),E=new T({props:{title:"Surface Normals Prediction Quick Start",local:"surface-normals-prediction-quick-start",headingTag:"h3"}}),N=new U({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkTm9ybWFsc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtbm9ybWFscy1sY20tdjAtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBbm9ybWFscyUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX25vcm1hbHMobm9ybWFscy5wcmVkaWN0aW9uKSUwQXZpcyU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9ub3JtYWxzLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-normals-lcm-v0-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
normals = pipe(image)

vis = pipe.image_processor.visualize_normals(normals.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),L=new T({props:{title:"Speeding up inference",local:"speeding-up-inference",headingTag:"h3"}}),q=new U({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjAlMEElMjAlMjBwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjApLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTBBJTJCJTIwcGlwZS52YWUlMjAlM0QlMjBkaWZmdXNlcnMuQXV0b2VuY29kZXJUaW55LmZyb21fcHJldHJhaW5lZCglMEElMkIlMjAlMDklMjJtYWRlYnlvbGxpbiUyRnRhZXNkJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBJTJCJTIwKS5jdWRhKCklMEElMjAlMjAlMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUyMCUyMGRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSk=",highlighted:`  import diffusers
  import torch
  
  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-lcm-v1-0&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)
  
<span class="hljs-addition">+ pipe.vae = diffusers.AutoencoderTiny.from_pretrained(</span>
<span class="hljs-addition">+ 	&quot;madebyollin/taesd&quot;, torch_dtype=torch.float16</span>
<span class="hljs-addition">+ ).cuda()</span>
  
  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)
  depth = pipe(image)`,wrap:!1}}),F=new U({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjAlMEElMjAlMjBwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjApLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMjAlMjAlMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUyMCUyMGRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSk=",highlighted:`  import diffusers
  import torch
  
  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-lcm-v1-0&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)
  
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>
  
  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)
  depth = pipe(image)`,wrap:!1}}),Q=new T({props:{title:"Qualitative Comparison with Depth Anything",local:"qualitative-comparison-with-depth-anything",headingTag:"h2"}}),P=new T({props:{title:"Maximizing Precision and Ensembling",local:"maximizing-precision-and-ensembling",headingTag:"h2"}}),O=new U({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBycy1ldGglMkZtYXJpZ29sZC1ub3JtYWxzLXYxLTAlMjIlMEElMEFtb2RlbF9wYXBlcl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMDlkaWZmdXNlcnMuc2NoZWR1bGVycy5ERElNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDEwJTJDJTBBJTA5JTA5JTIyZW5zZW1ibGVfc2l6ZSUyMiUzQSUyMDEwJTJDJTBBJTA5JTdEJTJDJTBBJTA5ZGlmZnVzZXJzLnNjaGVkdWxlcnMuTENNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDQlMkMlMEElMDklMDklMjJlbnNlbWJsZV9zaXplJTIyJTNBJTIwNSUyQyUwQSUwOSU3RCUyQyUwOSUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBJTBBcGlwZSUyMCUzRCUyMGRpZmZ1c2Vycy5NYXJpZ29sZE5vcm1hbHNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfcGF0aCkudG8oJTIyY3VkYSUyMiklMEFwaXBlX2t3YXJncyUyMCUzRCUyMG1vZGVsX3BhcGVyX2t3YXJncyU1QnR5cGUocGlwZS5zY2hlZHVsZXIpJTVEJTBBJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwKipwaXBlX2t3YXJncyklMEElMEF2aXMlMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfbm9ybWFscyhkZXB0aC5wcmVkaWN0aW9uKSUwQXZpcyU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9ub3JtYWxzLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> diffusers

model_path = <span class="hljs-string">&quot;prs-eth/marigold-normals-v1-0&quot;</span>

model_paper_kwargs = {
	diffusers.schedulers.DDIMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">10</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">10</span>,
	},
	diffusers.schedulers.LCMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">4</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">5</span>,
	},	
}

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(model_path).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_kwargs = model_paper_kwargs[<span class="hljs-built_in">type</span>(pipe.scheduler)]

depth = pipe(image, **pipe_kwargs)

vis = pipe.image_processor.visualize_normals(depth.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),te=new T({props:{title:"Quantitative Evaluation",local:"quantitative-evaluation",headingTag:"h2"}}),ie=new U({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBc2VlZCUyMCUzRCUyMDIwMjQlMEFtb2RlbF9wYXRoJTIwJTNEJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLXYxLTAlMjIlMEElMEFtb2RlbF9wYXBlcl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMDlkaWZmdXNlcnMuc2NoZWR1bGVycy5ERElNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTA5JTA5JTIyZW5zZW1ibGVfc2l6ZSUyMiUzQSUyMDEwJTJDJTBBJTA5JTdEJTJDJTBBJTA5ZGlmZnVzZXJzLnNjaGVkdWxlcnMuTENNU2NoZWR1bGVyJTNBJTIwJTdCJTBBJTA5JTA5JTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDQlMkMlMEElMDklMDklMjJlbnNlbWJsZV9zaXplJTIyJTNBJTIwMTAlMkMlMEElMDklN0QlMkMlMDklMEElN0QlMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0RkZXZpY2UpLm1hbnVhbF9zZWVkKHNlZWQpJTBBcGlwZSUyMCUzRCUyMGRpZmZ1c2Vycy5NYXJpZ29sZERlcHRoUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX3BhdGgpLnRvKGRldmljZSklMEFwaXBlX2t3YXJncyUyMCUzRCUyMG1vZGVsX3BhcGVyX2t3YXJncyU1QnR5cGUocGlwZS5zY2hlZHVsZXIpJTVEJTBBJTBBZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwKipwaXBlX2t3YXJncyklMEElMEElMjMlMjBldmFsdWF0ZSUyMG1ldHJpY3M=",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span>
seed = <span class="hljs-number">2024</span>
model_path = <span class="hljs-string">&quot;prs-eth/marigold-v1-0&quot;</span>

model_paper_kwargs = {
	diffusers.schedulers.DDIMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">10</span>,
	},
	diffusers.schedulers.LCMScheduler: {
		<span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">4</span>,
		<span class="hljs-string">&quot;ensemble_size&quot;</span>: <span class="hljs-number">10</span>,
	},	
}

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

generator = torch.Generator(device=device).manual_seed(seed)
pipe = diffusers.MarigoldDepthPipeline.from_pretrained(model_path).to(device)
pipe_kwargs = model_paper_kwargs[<span class="hljs-built_in">type</span>(pipe.scheduler)]

depth = pipe(image, generator=generator, **pipe_kwargs)

<span class="hljs-comment"># evaluate metrics</span>`,wrap:!1}}),se=new T({props:{title:"Using Predictive Uncertainty",local:"using-predictive-uncertainty",headingTag:"h2"}}),ne=new U({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEFkZXB0aCUyMCUzRCUyMHBpcGUoJTBBJTA5aW1hZ2UlMkMlMEElMDllbnNlbWJsZV9zaXplJTNEMTAlMkMlMjAlMjAlMjMlMjBhbnklMjBudW1iZXIlMjBncmVhdGVyJTIwdGhhbiUyMDElM0IlMjBoaWdoZXIlMjB2YWx1ZXMlMjB5aWVsZCUyMGhpZ2hlciUyMHByZWNpc2lvbiUwQSUwOW91dHB1dF91bmNlcnRhaW50eSUzRFRydWUlMkMlMEEpJTBBJTBBdW5jZXJ0YWludHklMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfdW5jZXJ0YWludHkoZGVwdGgudW5jZXJ0YWludHkpJTBBdW5jZXJ0YWludHklNUIwJTVELnNhdmUoJTIyZWluc3RlaW5fZGVwdGhfdW5jZXJ0YWludHkucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
depth = pipe(
	image,
	ensemble_size=<span class="hljs-number">10</span>,  <span class="hljs-comment"># any number greater than 1; higher values yield higher precision</span>
	output_uncertainty=<span class="hljs-literal">True</span>,
)

uncertainty = pipe.image_processor.visualize_uncertainty(depth.uncertainty)
uncertainty[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_uncertainty.png&quot;</span>)`,wrap:!1}}),pe=new T({props:{title:"Frame-by-frame Video Processing with Temporal Consistency",local:"frame-by-frame-video-processing-with-temporal-consistency",headingTag:"h2"}}),ce=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span>
path_in = <span class="hljs-string">&quot;obama.mp4&quot;</span>
path_out = <span class="hljs-string">&quot;obama_depth.gif&quot;</span>

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(device)
pipe.vae = diffusers.AutoencoderTiny.from_pretrained(
    <span class="hljs-string">&quot;madebyollin/taesd&quot;</span>, torch_dtype=torch.float16
).to(device)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> imageio.get_reader(path_in) <span class="hljs-keyword">as</span> reader:
    size = reader.get_meta_data()[<span class="hljs-string">&#x27;size&#x27;</span>]
    last_frame_latent = <span class="hljs-literal">None</span>
    latent_common = torch.randn(
        (<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">768</span> * size[<span class="hljs-number">1</span>] // (<span class="hljs-number">8</span> * <span class="hljs-built_in">max</span>(size)), <span class="hljs-number">768</span> * size[<span class="hljs-number">0</span>] // (<span class="hljs-number">8</span> * <span class="hljs-built_in">max</span>(size)))
    ).to(device=device, dtype=torch.float16)

    out = []
    <span class="hljs-keyword">for</span> frame_id, frame <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(reader), desc=<span class="hljs-string">&quot;Processing Video&quot;</span>):
        frame = Image.fromarray(frame)
        latents = latent_common
        <span class="hljs-keyword">if</span> last_frame_latent <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            latents = <span class="hljs-number">0.9</span> * latents + <span class="hljs-number">0.1</span> * last_frame_latent

        depth = pipe(
			frame, match_input_resolution=<span class="hljs-literal">False</span>, latents=latents, output_latent=<span class="hljs-literal">True</span>,
        )
        last_frame_latent = depth.latent
        out.append(pipe.image_processor.visualize_depth(depth.prediction)[<span class="hljs-number">0</span>])

    diffusers.utils.export_to_gif(out, path_out, fps=reader.get_meta_data()[<span class="hljs-string">&#x27;fps&#x27;</span>])`,wrap:!1}}),ue=new sl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/marigold_usage.md"}}),{c(){J=n("meta"),Me=s(),ge=n("p"),Je=s(),r(I.$$.fragment),Te=s(),B=n("p"),B.innerHTML=Jt,we=s(),W=n("p"),W.textContent=Tt,ye=s(),k=n("p"),k.innerHTML=wt,be=s(),x=n("table"),x.innerHTML=yt,Ze=s(),G=n("p"),G.innerHTML=bt,ve=s(),_=n("table"),_.innerHTML=Zt,je=s(),R=n("p"),R.textContent=vt,Ue=s(),g=n("div"),g.innerHTML=jt,Ie=s(),r(X.$$.fragment),Be=s(),C=n("p"),C.innerHTML=Ut,We=s(),r(z.$$.fragment),ke=s(),V=n("p"),V.innerHTML=It,xe=s(),w=n("div"),w.innerHTML=Bt,Ge=s(),r(E.$$.fragment),_e=s(),H=n("p"),H.innerHTML=Wt,Re=s(),r(N.$$.fragment),Xe=s(),$=n("p"),$.innerHTML=kt,Ce=s(),f=n("div"),f.innerHTML=xt,ze=s(),S=n("p"),S.innerHTML=Gt,Ve=s(),r(L.$$.fragment),Ee=s(),Y=n("p"),Y.innerHTML=_t,He=s(),r(q.$$.fragment),Ne=s(),A=n("p"),A.innerHTML=Rt,$e=s(),r(F.$$.fragment),Se=s(),r(Q.$$.fragment),Le=s(),D=n("p"),D.innerHTML=Xt,Ye=s(),y=n("div"),y.innerHTML=Ct,qe=s(),r(P.$$.fragment),Ae=s(),K=n("p"),K.innerHTML=zt,Fe=s(),r(O.$$.fragment),Qe=s(),b=n("div"),b.innerHTML=Vt,De=s(),ee=n("p"),ee.textContent=Et,Pe=s(),r(te.$$.fragment),Ke=s(),le=n("p"),le.innerHTML=Ht,Oe=s(),r(ie.$$.fragment),et=s(),r(se.$$.fragment),tt=s(),ae=n("p"),ae.innerHTML=Nt,lt=s(),r(ne.$$.fragment),it=s(),Z=n("div"),Z.innerHTML=$t,st=s(),oe=n("p"),oe.textContent=St,at=s(),r(pe.$$.fragment),nt=s(),re=n("p"),re.textContent=Lt,ot=s(),v=n("div"),v.innerHTML=Yt,pt=s(),de=n("p"),de.innerHTML=qt,rt=s(),r(ce.$$.fragment),dt=s(),me=n("p"),me.innerHTML=At,ct=s(),j=n("div"),j.innerHTML=Ft,mt=s(),he=n("p"),he.textContent=Qt,ht=s(),r(ue.$$.fragment),ut=s(),fe=n("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(l),Me=a(e),ge=o(e,"P",{}),Dt(ge).forEach(l),Je=a(e),d(I.$$.fragment,e),Te=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-dfgy31"&&(B.innerHTML=Jt),we=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-15jx45a"&&(W.textContent=Tt),ye=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-mg9rv6"&&(k.innerHTML=wt),be=a(e),x=o(e,"TABLE",{"data-svelte-h":!0}),p(x)!=="svelte-1v9cy9r"&&(x.innerHTML=yt),Ze=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-7crc58"&&(G.innerHTML=bt),ve=a(e),_=o(e,"TABLE",{"data-svelte-h":!0}),p(_)!=="svelte-r9i3ak"&&(_.innerHTML=Zt),je=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-14z37t0"&&(R.textContent=vt),Ue=a(e),g=o(e,"DIV",{class:!0,style:!0,"data-svelte-h":!0}),p(g)!=="svelte-crkwmk"&&(g.innerHTML=jt),Ie=a(e),d(X.$$.fragment,e),Be=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-deersj"&&(C.innerHTML=Ut),We=a(e),d(z.$$.fragment,e),ke=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-vmtetj"&&(V.innerHTML=It),xe=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-5dwdl0"&&(w.innerHTML=Bt),Ge=a(e),d(E.$$.fragment,e),_e=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1jm3j6v"&&(H.innerHTML=Wt),Re=a(e),d(N.$$.fragment,e),Xe=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1cxkzwq"&&($.innerHTML=kt),Ce=a(e),f=o(e,"DIV",{class:!0,style:!0,"data-svelte-h":!0}),p(f)!=="svelte-1xqxs61"&&(f.innerHTML=xt),ze=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1livx5j"&&(S.innerHTML=Gt),Ve=a(e),d(L.$$.fragment,e),Ee=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1py99qj"&&(Y.innerHTML=_t),He=a(e),d(q.$$.fragment,e),Ne=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-ddp2j2"&&(A.innerHTML=Rt),$e=a(e),d(F.$$.fragment,e),Se=a(e),d(Q.$$.fragment,e),Le=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-kc22hk"&&(D.innerHTML=Xt),Ye=a(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-sxrks6"&&(y.innerHTML=Ct),qe=a(e),d(P.$$.fragment,e),Ae=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-4qrnje"&&(K.innerHTML=zt),Fe=a(e),d(O.$$.fragment,e),Qe=a(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-jwdqh"&&(b.innerHTML=Vt),De=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1001b16"&&(ee.textContent=Et),Pe=a(e),d(te.$$.fragment,e),Ke=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-e52fx"&&(le.innerHTML=Ht),Oe=a(e),d(ie.$$.fragment,e),et=a(e),d(se.$$.fragment,e),tt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-b3srj5"&&(ae.innerHTML=Nt),lt=a(e),d(ne.$$.fragment,e),it=a(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-1ar1116"&&(Z.innerHTML=$t),st=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-83stc5"&&(oe.textContent=St),at=a(e),d(pe.$$.fragment,e),nt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-nc59re"&&(re.textContent=Lt),ot=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-sw3p83"&&(v.innerHTML=Yt),pt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1cegfq5"&&(de.innerHTML=qt),rt=a(e),d(ce.$$.fragment,e),dt=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-tlyfc9"&&(me.innerHTML=At),ct=a(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-18iikwt"&&(j.innerHTML=Ft),mt=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-139qjie"&&(he.textContent=Qt),ht=a(e),d(ue.$$.fragment,e),ut=a(e),fe=o(e,"P",{}),Dt(fe).forEach(l),this.h()},h(){M(J,"name","hf:doc:metadata"),M(J,"content",nl),M(g,"class","flex gap-4"),ft(g,"justify-content","center"),ft(g,"width","100%"),M(w,"class","flex gap-4"),M(f,"class","flex gap-4"),ft(f,"justify-content","center"),ft(f,"width","100%"),M(y,"class","flex gap-4"),M(b,"class","flex gap-4"),M(Z,"class","flex gap-4"),M(v,"class","flex gap-4"),M(j,"class","flex gap-4")},m(e,t){il(document.head,J),i(e,Me,t),i(e,ge,t),i(e,Je,t),c(I,e,t),i(e,Te,t),i(e,B,t),i(e,we,t),i(e,W,t),i(e,ye,t),i(e,k,t),i(e,be,t),i(e,x,t),i(e,Ze,t),i(e,G,t),i(e,ve,t),i(e,_,t),i(e,je,t),i(e,R,t),i(e,Ue,t),i(e,g,t),i(e,Ie,t),c(X,e,t),i(e,Be,t),i(e,C,t),i(e,We,t),c(z,e,t),i(e,ke,t),i(e,V,t),i(e,xe,t),i(e,w,t),i(e,Ge,t),c(E,e,t),i(e,_e,t),i(e,H,t),i(e,Re,t),c(N,e,t),i(e,Xe,t),i(e,$,t),i(e,Ce,t),i(e,f,t),i(e,ze,t),i(e,S,t),i(e,Ve,t),c(L,e,t),i(e,Ee,t),i(e,Y,t),i(e,He,t),c(q,e,t),i(e,Ne,t),i(e,A,t),i(e,$e,t),c(F,e,t),i(e,Se,t),c(Q,e,t),i(e,Le,t),i(e,D,t),i(e,Ye,t),i(e,y,t),i(e,qe,t),c(P,e,t),i(e,Ae,t),i(e,K,t),i(e,Fe,t),c(O,e,t),i(e,Qe,t),i(e,b,t),i(e,De,t),i(e,ee,t),i(e,Pe,t),c(te,e,t),i(e,Ke,t),i(e,le,t),i(e,Oe,t),c(ie,e,t),i(e,et,t),c(se,e,t),i(e,tt,t),i(e,ae,t),i(e,lt,t),c(ne,e,t),i(e,it,t),i(e,Z,t),i(e,st,t),i(e,oe,t),i(e,at,t),c(pe,e,t),i(e,nt,t),i(e,re,t),i(e,ot,t),i(e,v,t),i(e,pt,t),i(e,de,t),i(e,rt,t),c(ce,e,t),i(e,dt,t),i(e,me,t),i(e,ct,t),i(e,j,t),i(e,mt,t),i(e,he,t),i(e,ht,t),c(ue,e,t),i(e,ut,t),i(e,fe,t),gt=!0},p:Kt,i(e){gt||(m(I.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(ue.$$.fragment,e),gt=!0)},o(e){h(I.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),gt=!1},d(e){e&&(l(Me),l(ge),l(Je),l(Te),l(B),l(we),l(W),l(ye),l(k),l(be),l(x),l(Ze),l(G),l(ve),l(_),l(je),l(R),l(Ue),l(g),l(Ie),l(Be),l(C),l(We),l(ke),l(V),l(xe),l(w),l(Ge),l(_e),l(H),l(Re),l(Xe),l($),l(Ce),l(f),l(ze),l(S),l(Ve),l(Ee),l(Y),l(He),l(Ne),l(A),l($e),l(Se),l(Le),l(D),l(Ye),l(y),l(qe),l(Ae),l(K),l(Fe),l(Qe),l(b),l(De),l(ee),l(Pe),l(Ke),l(le),l(Oe),l(et),l(tt),l(ae),l(lt),l(it),l(Z),l(st),l(oe),l(at),l(nt),l(re),l(ot),l(v),l(pt),l(de),l(rt),l(dt),l(me),l(ct),l(j),l(mt),l(he),l(ht),l(ut),l(fe)),l(J),u(I,e),u(X,e),u(z,e),u(E,e),u(N,e),u(L,e),u(q,e),u(F,e),u(Q,e),u(P,e),u(O,e),u(te,e),u(ie,e),u(se,e),u(ne,e),u(pe,e),u(ce,e),u(ue,e)}}}const nl='{"title":"Marigold Pipelines for Computer Vision Tasks","local":"marigold-pipelines-for-computer-vision-tasks","sections":[{"title":"Depth Prediction Quick Start","local":"depth-prediction-quick-start","sections":[],"depth":3},{"title":"Surface Normals Prediction Quick Start","local":"surface-normals-prediction-quick-start","sections":[],"depth":3},{"title":"Speeding up inference","local":"speeding-up-inference","sections":[],"depth":3},{"title":"Qualitative Comparison with Depth Anything","local":"qualitative-comparison-with-depth-anything","sections":[],"depth":2},{"title":"Maximizing Precision and Ensembling","local":"maximizing-precision-and-ensembling","sections":[],"depth":2},{"title":"Quantitative Evaluation","local":"quantitative-evaluation","sections":[],"depth":2},{"title":"Using Predictive Uncertainty","local":"using-predictive-uncertainty","sections":[],"depth":2},{"title":"Frame-by-frame Video Processing with Temporal Consistency","local":"frame-by-frame-video-processing-with-temporal-consistency","sections":[],"depth":2}],"depth":1}';function ol(Mt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends el{constructor(J){super(),tl(this,J,ol,al,Pt,{})}}export{ml as component};
