import{s as Ts,o as Js,n as R}from"../chunks/scheduler.182ea377.js";import{S as Ps,i as Cs,g as s,s as r,p as h,A as xs,h as o,f as a,c as l,j as v,q as _,m as u,k as g,v as t,a as m,r as y,d as b,t as k,u as w}from"../chunks/index.008d68e4.js";import{T as Is}from"../chunks/Tip.4f096367.js";import{D as J}from"../chunks/Docstring.7aec8b85.js";import{C as Pe}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as Te}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Je}from"../chunks/ExampleCodeBlock.23e54afe.js";function Us(T){let i,I='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){i=s("p"),i.innerHTML=I},l(p){i=o(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1nfky5i"&&(i.innerHTML=I)},m(p,d){m(p,i,d)},p:R,d(p){p&&a(i)}}}function js(T){let i,I='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){i=s("p"),i.innerHTML=I},l(p){i=o(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1wmc0l4"&&(i.innerHTML=I)},m(p,d){m(p,i,d)},p:R,d(p){p&&a(i)}}}function $s(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVBpcGVsaW5lJTJDJTIwS2FuZGluc2t5UHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQW5lZ2F0aXZlX2ltYWdlX2VtYiUyMCUzRCUyMG91dC5uZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_image_emb = out.negative_image_embeds

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Zs(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEElMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQWltYWdlX2VtYiUyQyUyMHplcm9faW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvci5pbnRlcnBvbGF0ZShpbWFnZXNfdGV4dHMlMkMlMjB3ZWlnaHRzKSUwQSUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPriorPipeline, KandinskyPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;</span>,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Ws(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVBpcGVsaW5lJTJDJTIwS2FuZGluc2t5UHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZLYW5kaW5za3ktMi0xLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQW5lZ2F0aXZlX2ltYWdlX2VtYiUyMCUzRCUyMG91dC5uZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/Kandinsky-2-1-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_image_emb = out.negative_image_embeds

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Gs(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGxpb24lMjBpbiUyMGdhbGF4aWVzJTJDJTIwc3BpcmFscyUyQyUyMG5lYnVsYWUlMkMlMjBzdGFycyUyQyUyMHNtb2tlJTJDJTIwaXJpZGVzY2VudCUyQyUyMGludHJpY2F0ZSUyMGRldGFpbCUyQyUyMG9jdGFuZSUyMHJlbmRlciUyQyUyMDhrJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Ks(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreUltZzJJbWdQaXBlbGluZSUyQyUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcmVkJTIwY2FydG9vbiUyMGZyb2clMkMlMjA0ayUyMiUwQWltYWdlX2VtYiUyQyUyMHplcm9faW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSUwQSUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGZnJvZy5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjIlMkMlMEEpLmltYWdlcyUwQSUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMnJlZF9mcm9nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyImg2ImgPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A red cartoon frog, 4k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior(prompt, return_dict=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/frog.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;red_frog.png&quot;</span>)`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Bs(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwQ2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbWFnZS50aHVtYm5haWwoKDc2OCUyQyUyMDc2OCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Vs(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreUlucGFpbnRQaXBlbGluZSUyQyUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwaGF0JTIyJTBBaW1hZ2VfZW1iJTJDJTIwemVyb19pbWFnZV9lbWIlMjAlM0QlMjBwaXBlX3ByaW9yKHByb21wdCUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreUlucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTEtaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBbWFzayUyMCUzRCUyMG5wLnplcm9zKCg3NjglMkMlMjA3NjgpJTJDJTIwZHR5cGUlM0RucC5mbG9hdDMyKSUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQW91dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwb3V0LmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdF93aXRoX2hhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyInpaintPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior(prompt, return_dict=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = out.images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;cat_with_hat.png&quot;</span>)`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function qs(T){let i,I="Examples:",p,d,f;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwQ2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUwQSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEElMEFtYXNrJTIwJTNEJTIwbnAuemVyb3MoKDc2OCUyQyUyMDc2OCklMkMlMjBkdHlwZSUzRG5wLmZsb2F0MzIpJTBBJTIzJTIwTGV0J3MlMjBtYXNrJTIwb3V0JTIwYW4lMjBhcmVhJTIwYWJvdmUlMjB0aGUlMjBjYXQncyUyMGhlYWQlMEFtYXNrJTVCJTNBMjUwJTJDJTIwMjUwJTNBLTI1MCU1RCUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`}}),{c(){i=s("p"),i.textContent=I,p=r(),h(d.$$.fragment)},l(n){i=o(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=I),p=l(n),_(d.$$.fragment,n)},m(n,M){m(n,i,M),m(n,p,M),y(d,n,M),f=!0},p:R,i(n){f||(b(d.$$.fragment,n),f=!0)},o(n){k(d.$$.fragment,n),f=!1},d(n){n&&(a(i),a(p)),w(d,n)}}}function Ls(T){let i,I,p,d,f,n,M,rn,xa="Kandinsky 2.1",at,Ce,Ua='Kandinsky 2.1 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',st,xe,ja="The description from it’s GitHub page is:",ot,Ue,$a="<em>Kandinsky 2.1 inherits best practicies from Dall-E 2 and Latent diffusion, while introducing some new ideas. As text and image encoder it uses CLIP model and diffusion image prior (mapping) between latent spaces of CLIP modalities. This approach increases the visual performance of the model and unveils new horizons in blending images and text-guided image manipulation.</em>",it,je,Za='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',rt,te,lt,ae,dt,S,se,Rn,$e,$t,ln,Wa="KandinskyPriorPipeline",ct,P,Ze,Zt,dn,Ga="Pipeline for generating image prior for Kandinsky",Wt,cn,Ka=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Gt,G,We,Kt,pn,Ba="Function invoked when calling the pipeline for generation.",Bt,oe,Vt,K,Ge,qt,mn,Va="Function invoked when using the prior pipeline for interpolation.",Lt,ie,pt,X,re,Sn,Ke,Ft,gn,qa="KandinskyPipeline",mt,j,Be,Et,un,La="Pipeline for text-to-image generation using Kandinsky",Nt,fn,Fa=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,zt,B,Ve,Qt,hn,Ea="Function invoked when calling the pipeline for generation.",Rt,le,gt,H,de,Xn,qe,St,_n,Na="KandinskyCombinedPipeline",ut,C,Le,Xt,yn,za="Combined Pipeline for text-to-image generation using Kandinsky",Ht,bn,Qa=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Dt,V,Fe,Yt,kn,Ra="Function invoked when calling the pipeline for generation.",At,ce,Ot,pe,Ee,ea,wn,Sa=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,ft,D,me,Hn,Ne,na,vn,Xa="KandinskyImg2ImgPipeline",ht,$,ze,ta,Mn,Ha="Pipeline for image-to-image generation using Kandinsky",aa,In,Da=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,sa,q,Qe,oa,Tn,Ya="Function invoked when calling the pipeline for generation.",ia,ge,_t,Y,ue,Dn,Re,ra,Jn,Aa="KandinskyImg2ImgCombinedPipeline",yt,x,Se,la,Pn,Oa="Combined Pipeline for image-to-image generation using Kandinsky",da,Cn,es=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ca,L,Xe,pa,xn,ns="Function invoked when calling the pipeline for generation.",ma,fe,ga,he,He,ua,Un,ts=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,bt,A,_e,Yn,De,fa,jn,as="KandinskyInpaintPipeline",kt,Z,Ye,ha,$n,ss="Pipeline for text-guided image inpainting using Kandinsky2.1",_a,Zn,os=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ya,F,Ae,ba,Wn,is="Function invoked when calling the pipeline for generation.",ka,ye,wt,O,be,An,Oe,wa,Gn,rs="KandinskyInpaintCombinedPipeline",vt,U,en,va,Kn,ls="Combined Pipeline for generation using Kandinsky",Ma,Bn,ds=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ia,E,nn,Ta,Vn,cs="Function invoked when calling the pipeline for generation.",Ja,ke,Pa,we,tn,Ca,qn,ps=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Mt;return n=new Te({}),te=new Is({props:{$$slots:{default:[Us]},$$scope:{ctx:T}}}),ae=new Is({props:{$$slots:{default:[js]},$$scope:{ctx:T}}}),$e=new Te({}),Ze=new J({props:{name:"class diffusers.KandinskyPriorPipeline",anchor:"diffusers.KandinskyPriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyPriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyPriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyPriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyPriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L128"}}),We=new J({props:{name:"__call__",anchor:"diffusers.KandinskyPriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L397",returnType:`
<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),oe=new Je({props:{anchor:"diffusers.KandinskyPriorPipeline.__call__.example",$$slots:{default:[$s]},$$scope:{ctx:T}}}),Ge=new J({props:{name:"interpolate",anchor:"diffusers.KandinskyPriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L172",returnType:`
<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),ie=new Je({props:{anchor:"diffusers.KandinskyPriorPipeline.interpolate.example",$$slots:{default:[Zs]},$$scope:{ctx:T}}}),Ke=new Te({}),Be=new J({props:{name:"class diffusers.KandinskyPipeline",anchor:"diffusers.KandinskyPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky.py#L76"}}),Ve=new J({props:{name:"__call__",anchor:"diffusers.KandinskyPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky.py#L231",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),le=new Je({props:{anchor:"diffusers.KandinskyPipeline.__call__.example",$$slots:{default:[Ws]},$$scope:{ctx:T}}}),qe=new Te({}),Le=new J({props:{name:"class diffusers.KandinskyCombinedPipeline",anchor:"diffusers.KandinskyCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L113"}}),Fe=new J({props:{name:"__call__",anchor:"diffusers.KandinskyCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L214",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ce=new Je({props:{anchor:"diffusers.KandinskyCombinedPipeline.__call__.example",$$slots:{default:[Gs]},$$scope:{ctx:T}}}),Ee=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L195"}}),Ne=new Te({}),ze=new J({props:{name:"class diffusers.KandinskyImg2ImgPipeline",anchor:"diffusers.KandinskyImg2ImgPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"movq",val:": VQModel"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ image encoder and decoder`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_img2img.py#L98"}}),Qe=new J({props:{name:"__call__",anchor:"diffusers.KandinskyImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"image_embeds",val:": FloatTensor"},{name:"negative_image_embeds",val:": FloatTensor"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"strength",val:": float = 0.3"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process.`,name:"image"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_img2img.py#L293",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new Je({props:{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.example",$$slots:{default:[Ks]},$$scope:{ctx:T}}}),Re=new Te({}),Se=new J({props:{name:"class diffusers.KandinskyImg2ImgCombinedPipeline",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L330"}}),Xe=new J({props:{name:"__call__",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"strength",val:": float = 0.3"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L432",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),fe=new Je({props:{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.example",$$slots:{default:[Bs]},$$scope:{ctx:T}}}),He=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L412"}}),De=new Te({}),Ye=new J({props:{name:"class diffusers.KandinskyInpaintPipeline",anchor:"diffusers.KandinskyInpaintPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"movq",val:": VQModel"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyInpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ image encoder and decoder`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_inpaint.py#L240"}}),Ae=new J({props:{name:"__call__",anchor:"diffusers.KandinskyInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"image_embeds",val:": FloatTensor"},{name:"negative_image_embeds",val:": FloatTensor"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code> or <code>np.ndarray</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process.`,name:"image"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>,<code>torch.FloatTensor</code> or <code>np.ndarray</code>) &#x2014;
<code>Image</code>, or a tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. You can pass a pytorch tensor as mask only if the
image you passed is a pytorch tensor, and it should contain one color channel (L) instead of 3, so the
expected shape would be either <code>(B, 1, H, W,)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code> or <code>(H, W)</code> If image is an PIL
image or numpy array, mask should also be a either PIL image or numpy array. If it is a PIL image, it
will be converted to a single channel (luminance) before use. If it is a nummpy array, the expected
shape is <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_inpaint.py#L396",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ye=new Je({props:{anchor:"diffusers.KandinskyInpaintPipeline.__call__.example",$$slots:{default:[Vs]},$$scope:{ctx:T}}}),Oe=new Te({}),en=new J({props:{name:"class diffusers.KandinskyInpaintCombinedPipeline",anchor:"diffusers.KandinskyInpaintCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L570"}}),nn=new J({props:{name:"__call__",anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L672",returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ke=new Je({props:{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.example",$$slots:{default:[qs]},$$scope:{ctx:T}}}),tn=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyInpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L652"}}),{c(){i=s("meta"),I=r(),p=s("h1"),d=s("a"),f=s("span"),h(n.$$.fragment),M=r(),rn=s("span"),rn.textContent=xa,at=r(),Ce=s("p"),Ce.innerHTML=Ua,st=r(),xe=s("p"),xe.textContent=ja,ot=r(),Ue=s("p"),Ue.innerHTML=$a,it=r(),je=s("p"),je.innerHTML=Za,rt=r(),h(te.$$.fragment),lt=r(),h(ae.$$.fragment),dt=r(),S=s("h2"),se=s("a"),Rn=s("span"),h($e.$$.fragment),$t=r(),ln=s("span"),ln.textContent=Wa,ct=r(),P=s("div"),h(Ze.$$.fragment),Zt=r(),dn=s("p"),dn.textContent=Ga,Wt=r(),cn=s("p"),cn.innerHTML=Ka,Gt=r(),G=s("div"),h(We.$$.fragment),Kt=r(),pn=s("p"),pn.textContent=Ba,Bt=r(),h(oe.$$.fragment),Vt=r(),K=s("div"),h(Ge.$$.fragment),qt=r(),mn=s("p"),mn.textContent=Va,Lt=r(),h(ie.$$.fragment),pt=r(),X=s("h2"),re=s("a"),Sn=s("span"),h(Ke.$$.fragment),Ft=r(),gn=s("span"),gn.textContent=qa,mt=r(),j=s("div"),h(Be.$$.fragment),Et=r(),un=s("p"),un.textContent=La,Nt=r(),fn=s("p"),fn.innerHTML=Fa,zt=r(),B=s("div"),h(Ve.$$.fragment),Qt=r(),hn=s("p"),hn.textContent=Ea,Rt=r(),h(le.$$.fragment),gt=r(),H=s("h2"),de=s("a"),Xn=s("span"),h(qe.$$.fragment),St=r(),_n=s("span"),_n.textContent=Na,ut=r(),C=s("div"),h(Le.$$.fragment),Xt=r(),yn=s("p"),yn.textContent=za,Ht=r(),bn=s("p"),bn.innerHTML=Qa,Dt=r(),V=s("div"),h(Fe.$$.fragment),Yt=r(),kn=s("p"),kn.textContent=Ra,At=r(),h(ce.$$.fragment),Ot=r(),pe=s("div"),h(Ee.$$.fragment),ea=r(),wn=s("p"),wn.innerHTML=Sa,ft=r(),D=s("h2"),me=s("a"),Hn=s("span"),h(Ne.$$.fragment),na=r(),vn=s("span"),vn.textContent=Xa,ht=r(),$=s("div"),h(ze.$$.fragment),ta=r(),Mn=s("p"),Mn.textContent=Ha,aa=r(),In=s("p"),In.innerHTML=Da,sa=r(),q=s("div"),h(Qe.$$.fragment),oa=r(),Tn=s("p"),Tn.textContent=Ya,ia=r(),h(ge.$$.fragment),_t=r(),Y=s("h2"),ue=s("a"),Dn=s("span"),h(Re.$$.fragment),ra=r(),Jn=s("span"),Jn.textContent=Aa,yt=r(),x=s("div"),h(Se.$$.fragment),la=r(),Pn=s("p"),Pn.textContent=Oa,da=r(),Cn=s("p"),Cn.innerHTML=es,ca=r(),L=s("div"),h(Xe.$$.fragment),pa=r(),xn=s("p"),xn.textContent=ns,ma=r(),h(fe.$$.fragment),ga=r(),he=s("div"),h(He.$$.fragment),ua=r(),Un=s("p"),Un.innerHTML=ts,bt=r(),A=s("h2"),_e=s("a"),Yn=s("span"),h(De.$$.fragment),fa=r(),jn=s("span"),jn.textContent=as,kt=r(),Z=s("div"),h(Ye.$$.fragment),ha=r(),$n=s("p"),$n.textContent=ss,_a=r(),Zn=s("p"),Zn.innerHTML=os,ya=r(),F=s("div"),h(Ae.$$.fragment),ba=r(),Wn=s("p"),Wn.textContent=is,ka=r(),h(ye.$$.fragment),wt=r(),O=s("h2"),be=s("a"),An=s("span"),h(Oe.$$.fragment),wa=r(),Gn=s("span"),Gn.textContent=rs,vt=r(),U=s("div"),h(en.$$.fragment),va=r(),Kn=s("p"),Kn.textContent=ls,Ma=r(),Bn=s("p"),Bn.innerHTML=ds,Ia=r(),E=s("div"),h(nn.$$.fragment),Ta=r(),Vn=s("p"),Vn.textContent=cs,Ja=r(),h(ke.$$.fragment),Pa=r(),we=s("div"),h(tn.$$.fragment),Ca=r(),qn=s("p"),qn.innerHTML=ps,this.h()},l(e){const c=xs("svelte-1phssyn",document.head);i=o(c,"META",{name:!0,content:!0}),c.forEach(a),I=l(e),p=o(e,"H1",{class:!0});var an=v(p);d=o(an,"A",{id:!0,class:!0,href:!0});var On=v(d);f=o(On,"SPAN",{});var et=v(f);_(n.$$.fragment,et),et.forEach(a),On.forEach(a),M=l(an),rn=o(an,"SPAN",{"data-svelte-h":!0}),u(rn)!=="svelte-lboq62"&&(rn.textContent=xa),an.forEach(a),at=l(e),Ce=o(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-z239mp"&&(Ce.innerHTML=Ua),st=l(e),xe=o(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1og8lwg"&&(xe.textContent=ja),ot=l(e),Ue=o(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1ax7cek"&&(Ue.innerHTML=$a),it=l(e),je=o(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-14rg3yz"&&(je.innerHTML=Za),rt=l(e),_(te.$$.fragment,e),lt=l(e),_(ae.$$.fragment,e),dt=l(e),S=o(e,"H2",{class:!0});var sn=v(S);se=o(sn,"A",{id:!0,class:!0,href:!0});var nt=v(se);Rn=o(nt,"SPAN",{});var tt=v(Rn);_($e.$$.fragment,tt),tt.forEach(a),nt.forEach(a),$t=l(sn),ln=o(sn,"SPAN",{"data-svelte-h":!0}),u(ln)!=="svelte-oap509"&&(ln.textContent=Wa),sn.forEach(a),ct=l(e),P=o(e,"DIV",{class:!0});var W=v(P);_(Ze.$$.fragment,W),Zt=l(W),dn=o(W,"P",{"data-svelte-h":!0}),u(dn)!=="svelte-gfz7tn"&&(dn.textContent=Ga),Wt=l(W),cn=o(W,"P",{"data-svelte-h":!0}),u(cn)!=="svelte-wu1jmh"&&(cn.innerHTML=Ka),Gt=l(W),G=o(W,"DIV",{class:!0});var ee=v(G);_(We.$$.fragment,ee),Kt=l(ee),pn=o(ee,"P",{"data-svelte-h":!0}),u(pn)!=="svelte-v78lg8"&&(pn.textContent=Ba),Bt=l(ee),_(oe.$$.fragment,ee),ee.forEach(a),Vt=l(W),K=o(W,"DIV",{class:!0});var ne=v(K);_(Ge.$$.fragment,ne),qt=l(ne),mn=o(ne,"P",{"data-svelte-h":!0}),u(mn)!=="svelte-1k7d7q8"&&(mn.textContent=Va),Lt=l(ne),_(ie.$$.fragment,ne),ne.forEach(a),W.forEach(a),pt=l(e),X=o(e,"H2",{class:!0});var on=v(X);re=o(on,"A",{id:!0,class:!0,href:!0});var ms=v(re);Sn=o(ms,"SPAN",{});var gs=v(Sn);_(Ke.$$.fragment,gs),gs.forEach(a),ms.forEach(a),Ft=l(on),gn=o(on,"SPAN",{"data-svelte-h":!0}),u(gn)!=="svelte-1ru151b"&&(gn.textContent=qa),on.forEach(a),mt=l(e),j=o(e,"DIV",{class:!0});var ve=v(j);_(Be.$$.fragment,ve),Et=l(ve),un=o(ve,"P",{"data-svelte-h":!0}),u(un)!=="svelte-jhhofy"&&(un.textContent=La),Nt=l(ve),fn=o(ve,"P",{"data-svelte-h":!0}),u(fn)!=="svelte-wu1jmh"&&(fn.innerHTML=Fa),zt=l(ve),B=o(ve,"DIV",{class:!0});var Ln=v(B);_(Ve.$$.fragment,Ln),Qt=l(Ln),hn=o(Ln,"P",{"data-svelte-h":!0}),u(hn)!=="svelte-v78lg8"&&(hn.textContent=Ea),Rt=l(Ln),_(le.$$.fragment,Ln),Ln.forEach(a),ve.forEach(a),gt=l(e),H=o(e,"H2",{class:!0});var It=v(H);de=o(It,"A",{id:!0,class:!0,href:!0});var us=v(de);Xn=o(us,"SPAN",{});var fs=v(Xn);_(qe.$$.fragment,fs),fs.forEach(a),us.forEach(a),St=l(It),_n=o(It,"SPAN",{"data-svelte-h":!0}),u(_n)!=="svelte-122e9k8"&&(_n.textContent=Na),It.forEach(a),ut=l(e),C=o(e,"DIV",{class:!0});var N=v(C);_(Le.$$.fragment,N),Xt=l(N),yn=o(N,"P",{"data-svelte-h":!0}),u(yn)!=="svelte-1spbql3"&&(yn.textContent=za),Ht=l(N),bn=o(N,"P",{"data-svelte-h":!0}),u(bn)!=="svelte-wu1jmh"&&(bn.innerHTML=Qa),Dt=l(N),V=o(N,"DIV",{class:!0});var Fn=v(V);_(Fe.$$.fragment,Fn),Yt=l(Fn),kn=o(Fn,"P",{"data-svelte-h":!0}),u(kn)!=="svelte-v78lg8"&&(kn.textContent=Ra),At=l(Fn),_(ce.$$.fragment,Fn),Fn.forEach(a),Ot=l(N),pe=o(N,"DIV",{class:!0});var Tt=v(pe);_(Ee.$$.fragment,Tt),ea=l(Tt),wn=o(Tt,"P",{"data-svelte-h":!0}),u(wn)!=="svelte-a2a0wt"&&(wn.innerHTML=Sa),Tt.forEach(a),N.forEach(a),ft=l(e),D=o(e,"H2",{class:!0});var Jt=v(D);me=o(Jt,"A",{id:!0,class:!0,href:!0});var hs=v(me);Hn=o(hs,"SPAN",{});var _s=v(Hn);_(Ne.$$.fragment,_s),_s.forEach(a),hs.forEach(a),na=l(Jt),vn=o(Jt,"SPAN",{"data-svelte-h":!0}),u(vn)!=="svelte-1c174bz"&&(vn.textContent=Xa),Jt.forEach(a),ht=l(e),$=o(e,"DIV",{class:!0});var Me=v($);_(ze.$$.fragment,Me),ta=l(Me),Mn=o(Me,"P",{"data-svelte-h":!0}),u(Mn)!=="svelte-1nm2rj2"&&(Mn.textContent=Ha),aa=l(Me),In=o(Me,"P",{"data-svelte-h":!0}),u(In)!=="svelte-wu1jmh"&&(In.innerHTML=Da),sa=l(Me),q=o(Me,"DIV",{class:!0});var En=v(q);_(Qe.$$.fragment,En),oa=l(En),Tn=o(En,"P",{"data-svelte-h":!0}),u(Tn)!=="svelte-v78lg8"&&(Tn.textContent=Ya),ia=l(En),_(ge.$$.fragment,En),En.forEach(a),Me.forEach(a),_t=l(e),Y=o(e,"H2",{class:!0});var Pt=v(Y);ue=o(Pt,"A",{id:!0,class:!0,href:!0});var ys=v(ue);Dn=o(ys,"SPAN",{});var bs=v(Dn);_(Re.$$.fragment,bs),bs.forEach(a),ys.forEach(a),ra=l(Pt),Jn=o(Pt,"SPAN",{"data-svelte-h":!0}),u(Jn)!=="svelte-16ar8se"&&(Jn.textContent=Aa),Pt.forEach(a),yt=l(e),x=o(e,"DIV",{class:!0});var z=v(x);_(Se.$$.fragment,z),la=l(z),Pn=o(z,"P",{"data-svelte-h":!0}),u(Pn)!=="svelte-1ql3mrb"&&(Pn.textContent=Oa),da=l(z),Cn=o(z,"P",{"data-svelte-h":!0}),u(Cn)!=="svelte-wu1jmh"&&(Cn.innerHTML=es),ca=l(z),L=o(z,"DIV",{class:!0});var Nn=v(L);_(Xe.$$.fragment,Nn),pa=l(Nn),xn=o(Nn,"P",{"data-svelte-h":!0}),u(xn)!=="svelte-v78lg8"&&(xn.textContent=ns),ma=l(Nn),_(fe.$$.fragment,Nn),Nn.forEach(a),ga=l(z),he=o(z,"DIV",{class:!0});var Ct=v(he);_(He.$$.fragment,Ct),ua=l(Ct),Un=o(Ct,"P",{"data-svelte-h":!0}),u(Un)!=="svelte-1ff7ilh"&&(Un.innerHTML=ts),Ct.forEach(a),z.forEach(a),bt=l(e),A=o(e,"H2",{class:!0});var xt=v(A);_e=o(xt,"A",{id:!0,class:!0,href:!0});var ks=v(_e);Yn=o(ks,"SPAN",{});var ws=v(Yn);_(De.$$.fragment,ws),ws.forEach(a),ks.forEach(a),fa=l(xt),jn=o(xt,"SPAN",{"data-svelte-h":!0}),u(jn)!=="svelte-el2l4m"&&(jn.textContent=as),xt.forEach(a),kt=l(e),Z=o(e,"DIV",{class:!0});var Ie=v(Z);_(Ye.$$.fragment,Ie),ha=l(Ie),$n=o(Ie,"P",{"data-svelte-h":!0}),u($n)!=="svelte-2p9m8a"&&($n.textContent=ss),_a=l(Ie),Zn=o(Ie,"P",{"data-svelte-h":!0}),u(Zn)!=="svelte-wu1jmh"&&(Zn.innerHTML=os),ya=l(Ie),F=o(Ie,"DIV",{class:!0});var zn=v(F);_(Ae.$$.fragment,zn),ba=l(zn),Wn=o(zn,"P",{"data-svelte-h":!0}),u(Wn)!=="svelte-v78lg8"&&(Wn.textContent=is),ka=l(zn),_(ye.$$.fragment,zn),zn.forEach(a),Ie.forEach(a),wt=l(e),O=o(e,"H2",{class:!0});var Ut=v(O);be=o(Ut,"A",{id:!0,class:!0,href:!0});var vs=v(be);An=o(vs,"SPAN",{});var Ms=v(An);_(Oe.$$.fragment,Ms),Ms.forEach(a),vs.forEach(a),wa=l(Ut),Gn=o(Ut,"SPAN",{"data-svelte-h":!0}),u(Gn)!=="svelte-6htnpb"&&(Gn.textContent=rs),Ut.forEach(a),vt=l(e),U=o(e,"DIV",{class:!0});var Q=v(U);_(en.$$.fragment,Q),va=l(Q),Kn=o(Q,"P",{"data-svelte-h":!0}),u(Kn)!=="svelte-18rw6ko"&&(Kn.textContent=ls),Ma=l(Q),Bn=o(Q,"P",{"data-svelte-h":!0}),u(Bn)!=="svelte-wu1jmh"&&(Bn.innerHTML=ds),Ia=l(Q),E=o(Q,"DIV",{class:!0});var Qn=v(E);_(nn.$$.fragment,Qn),Ta=l(Qn),Vn=o(Qn,"P",{"data-svelte-h":!0}),u(Vn)!=="svelte-v78lg8"&&(Vn.textContent=cs),Ja=l(Qn),_(ke.$$.fragment,Qn),Qn.forEach(a),Pa=l(Q),we=o(Q,"DIV",{class:!0});var jt=v(we);_(tn.$$.fragment,jt),Ca=l(jt),qn=o(jt,"P",{"data-svelte-h":!0}),u(qn)!=="svelte-1ff7ilh"&&(qn.innerHTML=ps),jt.forEach(a),Q.forEach(a),this.h()},h(){g(i,"name","hf:doc:metadata"),g(i,"content",JSON.stringify(Fs)),g(d,"id","kandinsky-21"),g(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(d,"href","#kandinsky-21"),g(p,"class","relative group"),g(se,"id","diffusers.KandinskyPriorPipeline"),g(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(se,"href","#diffusers.KandinskyPriorPipeline"),g(S,"class","relative group"),g(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(re,"id","diffusers.KandinskyPipeline"),g(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(re,"href","#diffusers.KandinskyPipeline"),g(X,"class","relative group"),g(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(de,"id","diffusers.KandinskyCombinedPipeline"),g(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(de,"href","#diffusers.KandinskyCombinedPipeline"),g(H,"class","relative group"),g(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(me,"id","diffusers.KandinskyImg2ImgPipeline"),g(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(me,"href","#diffusers.KandinskyImg2ImgPipeline"),g(D,"class","relative group"),g(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ue,"id","diffusers.KandinskyImg2ImgCombinedPipeline"),g(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(ue,"href","#diffusers.KandinskyImg2ImgCombinedPipeline"),g(Y,"class","relative group"),g(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(_e,"id","diffusers.KandinskyInpaintPipeline"),g(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(_e,"href","#diffusers.KandinskyInpaintPipeline"),g(A,"class","relative group"),g(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(be,"id","diffusers.KandinskyInpaintCombinedPipeline"),g(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(be,"href","#diffusers.KandinskyInpaintCombinedPipeline"),g(O,"class","relative group"),g(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),m(e,I,c),m(e,p,c),t(p,d),t(d,f),y(n,f,null),t(p,M),t(p,rn),m(e,at,c),m(e,Ce,c),m(e,st,c),m(e,xe,c),m(e,ot,c),m(e,Ue,c),m(e,it,c),m(e,je,c),m(e,rt,c),y(te,e,c),m(e,lt,c),y(ae,e,c),m(e,dt,c),m(e,S,c),t(S,se),t(se,Rn),y($e,Rn,null),t(S,$t),t(S,ln),m(e,ct,c),m(e,P,c),y(Ze,P,null),t(P,Zt),t(P,dn),t(P,Wt),t(P,cn),t(P,Gt),t(P,G),y(We,G,null),t(G,Kt),t(G,pn),t(G,Bt),y(oe,G,null),t(P,Vt),t(P,K),y(Ge,K,null),t(K,qt),t(K,mn),t(K,Lt),y(ie,K,null),m(e,pt,c),m(e,X,c),t(X,re),t(re,Sn),y(Ke,Sn,null),t(X,Ft),t(X,gn),m(e,mt,c),m(e,j,c),y(Be,j,null),t(j,Et),t(j,un),t(j,Nt),t(j,fn),t(j,zt),t(j,B),y(Ve,B,null),t(B,Qt),t(B,hn),t(B,Rt),y(le,B,null),m(e,gt,c),m(e,H,c),t(H,de),t(de,Xn),y(qe,Xn,null),t(H,St),t(H,_n),m(e,ut,c),m(e,C,c),y(Le,C,null),t(C,Xt),t(C,yn),t(C,Ht),t(C,bn),t(C,Dt),t(C,V),y(Fe,V,null),t(V,Yt),t(V,kn),t(V,At),y(ce,V,null),t(C,Ot),t(C,pe),y(Ee,pe,null),t(pe,ea),t(pe,wn),m(e,ft,c),m(e,D,c),t(D,me),t(me,Hn),y(Ne,Hn,null),t(D,na),t(D,vn),m(e,ht,c),m(e,$,c),y(ze,$,null),t($,ta),t($,Mn),t($,aa),t($,In),t($,sa),t($,q),y(Qe,q,null),t(q,oa),t(q,Tn),t(q,ia),y(ge,q,null),m(e,_t,c),m(e,Y,c),t(Y,ue),t(ue,Dn),y(Re,Dn,null),t(Y,ra),t(Y,Jn),m(e,yt,c),m(e,x,c),y(Se,x,null),t(x,la),t(x,Pn),t(x,da),t(x,Cn),t(x,ca),t(x,L),y(Xe,L,null),t(L,pa),t(L,xn),t(L,ma),y(fe,L,null),t(x,ga),t(x,he),y(He,he,null),t(he,ua),t(he,Un),m(e,bt,c),m(e,A,c),t(A,_e),t(_e,Yn),y(De,Yn,null),t(A,fa),t(A,jn),m(e,kt,c),m(e,Z,c),y(Ye,Z,null),t(Z,ha),t(Z,$n),t(Z,_a),t(Z,Zn),t(Z,ya),t(Z,F),y(Ae,F,null),t(F,ba),t(F,Wn),t(F,ka),y(ye,F,null),m(e,wt,c),m(e,O,c),t(O,be),t(be,An),y(Oe,An,null),t(O,wa),t(O,Gn),m(e,vt,c),m(e,U,c),y(en,U,null),t(U,va),t(U,Kn),t(U,Ma),t(U,Bn),t(U,Ia),t(U,E),y(nn,E,null),t(E,Ta),t(E,Vn),t(E,Ja),y(ke,E,null),t(U,Pa),t(U,we),y(tn,we,null),t(we,Ca),t(we,qn),Mt=!0},p(e,[c]){const an={};c&2&&(an.$$scope={dirty:c,ctx:e}),te.$set(an);const On={};c&2&&(On.$$scope={dirty:c,ctx:e}),ae.$set(On);const et={};c&2&&(et.$$scope={dirty:c,ctx:e}),oe.$set(et);const sn={};c&2&&(sn.$$scope={dirty:c,ctx:e}),ie.$set(sn);const nt={};c&2&&(nt.$$scope={dirty:c,ctx:e}),le.$set(nt);const tt={};c&2&&(tt.$$scope={dirty:c,ctx:e}),ce.$set(tt);const W={};c&2&&(W.$$scope={dirty:c,ctx:e}),ge.$set(W);const ee={};c&2&&(ee.$$scope={dirty:c,ctx:e}),fe.$set(ee);const ne={};c&2&&(ne.$$scope={dirty:c,ctx:e}),ye.$set(ne);const on={};c&2&&(on.$$scope={dirty:c,ctx:e}),ke.$set(on)},i(e){Mt||(b(n.$$.fragment,e),b(te.$$.fragment,e),b(ae.$$.fragment,e),b($e.$$.fragment,e),b(Ze.$$.fragment,e),b(We.$$.fragment,e),b(oe.$$.fragment,e),b(Ge.$$.fragment,e),b(ie.$$.fragment,e),b(Ke.$$.fragment,e),b(Be.$$.fragment,e),b(Ve.$$.fragment,e),b(le.$$.fragment,e),b(qe.$$.fragment,e),b(Le.$$.fragment,e),b(Fe.$$.fragment,e),b(ce.$$.fragment,e),b(Ee.$$.fragment,e),b(Ne.$$.fragment,e),b(ze.$$.fragment,e),b(Qe.$$.fragment,e),b(ge.$$.fragment,e),b(Re.$$.fragment,e),b(Se.$$.fragment,e),b(Xe.$$.fragment,e),b(fe.$$.fragment,e),b(He.$$.fragment,e),b(De.$$.fragment,e),b(Ye.$$.fragment,e),b(Ae.$$.fragment,e),b(ye.$$.fragment,e),b(Oe.$$.fragment,e),b(en.$$.fragment,e),b(nn.$$.fragment,e),b(ke.$$.fragment,e),b(tn.$$.fragment,e),Mt=!0)},o(e){k(n.$$.fragment,e),k(te.$$.fragment,e),k(ae.$$.fragment,e),k($e.$$.fragment,e),k(Ze.$$.fragment,e),k(We.$$.fragment,e),k(oe.$$.fragment,e),k(Ge.$$.fragment,e),k(ie.$$.fragment,e),k(Ke.$$.fragment,e),k(Be.$$.fragment,e),k(Ve.$$.fragment,e),k(le.$$.fragment,e),k(qe.$$.fragment,e),k(Le.$$.fragment,e),k(Fe.$$.fragment,e),k(ce.$$.fragment,e),k(Ee.$$.fragment,e),k(Ne.$$.fragment,e),k(ze.$$.fragment,e),k(Qe.$$.fragment,e),k(ge.$$.fragment,e),k(Re.$$.fragment,e),k(Se.$$.fragment,e),k(Xe.$$.fragment,e),k(fe.$$.fragment,e),k(He.$$.fragment,e),k(De.$$.fragment,e),k(Ye.$$.fragment,e),k(Ae.$$.fragment,e),k(ye.$$.fragment,e),k(Oe.$$.fragment,e),k(en.$$.fragment,e),k(nn.$$.fragment,e),k(ke.$$.fragment,e),k(tn.$$.fragment,e),Mt=!1},d(e){e&&(a(I),a(p),a(at),a(Ce),a(st),a(xe),a(ot),a(Ue),a(it),a(je),a(rt),a(lt),a(dt),a(S),a(ct),a(P),a(pt),a(X),a(mt),a(j),a(gt),a(H),a(ut),a(C),a(ft),a(D),a(ht),a($),a(_t),a(Y),a(yt),a(x),a(bt),a(A),a(kt),a(Z),a(wt),a(O),a(vt),a(U)),a(i),w(n),w(te,e),w(ae,e),w($e),w(Ze),w(We),w(oe),w(Ge),w(ie),w(Ke),w(Be),w(Ve),w(le),w(qe),w(Le),w(Fe),w(ce),w(Ee),w(Ne),w(ze),w(Qe),w(ge),w(Re),w(Se),w(Xe),w(fe),w(He),w(De),w(Ye),w(Ae),w(ye),w(Oe),w(en),w(nn),w(ke),w(tn)}}}const Fs={local:"kandinsky-21",sections:[{local:"diffusers.KandinskyPriorPipeline",title:"KandinskyPriorPipeline"},{local:"diffusers.KandinskyPipeline",title:"KandinskyPipeline"},{local:"diffusers.KandinskyCombinedPipeline",title:"KandinskyCombinedPipeline"},{local:"diffusers.KandinskyImg2ImgPipeline",title:"KandinskyImg2ImgPipeline"},{local:"diffusers.KandinskyImg2ImgCombinedPipeline",title:"KandinskyImg2ImgCombinedPipeline"},{local:"diffusers.KandinskyInpaintPipeline",title:"KandinskyInpaintPipeline"},{local:"diffusers.KandinskyInpaintCombinedPipeline",title:"KandinskyInpaintCombinedPipeline"}],title:"Kandinsky 2.1"};function Es(T){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ps{constructor(i){super(),Cs(this,i,Es,Ls,Ts,{})}}export{Ds as component};
