import{s as Gi,o as Wi,n as I}from"../chunks/scheduler.182ea377.js";import{S as Hi,i as Bi,g as i,s as a,p as g,A as Fi,h as s,f as p,c as r,j as U,q as b,m as f,k as M,v as t,a as u,r as _,d as y,t as v,u as w}from"../chunks/index.008d68e4.js";import{T as dt}from"../chunks/Tip.4f096367.js";import{D}from"../chunks/Docstring.7aec8b85.js";import{C as Pe}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as Un}from"../chunks/IconCopyLink.96bbb92b.js";import{E as je}from"../chunks/ExampleCodeBlock.23e54afe.js";function Vi(j){let o,h='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',l,d,m,n,T='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=i("p"),o.innerHTML=h,l=a(),d=i("br"),m=a(),n=i("p"),n.innerHTML=T},l(k){o=s(k,"P",{"data-svelte-h":!0}),f(o)!=="svelte-17t0bk9"&&(o.innerHTML=h),l=r(k),d=s(k,"BR",{}),m=r(k),n=s(k,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1a94ctl"&&(n.innerHTML=T)},m(k,A){u(k,o,A),u(k,l,A),u(k,d,A),u(k,m,A),u(k,n,A)},p:I,d(k){k&&(p(o),p(l),p(d),p(m),p(n))}}}function Ni(j){let o,h=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=i("p"),o.textContent=h},l(l){o=s(l,"P",{"data-svelte-h":!0}),f(o)!=="svelte-18gkv0g"&&(o.textContent=h)},m(l,d){u(l,o,d)},p:I,d(l){l&&p(o)}}}function Si(j){let o,h="Examples:",l,d,m;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function Xi(j){let o,h=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=i("p"),o.innerHTML=h},l(l){o=s(l,"P",{"data-svelte-h":!0}),f(o)!=="svelte-6jnfc0"&&(o.innerHTML=h)},m(l,d){u(l,o,d)},p:I,d(l){l&&p(o)}}}function Li(j){let o,h=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=i("p"),o.innerHTML=h},l(l){o=s(l,"P",{"data-svelte-h":!0}),f(o)!=="svelte-ackzsn"&&(o.innerHTML=h)},m(l,d){u(l,o,d)},p:I,d(l){l&&p(o)}}}function Ei(j){let o,h="Examples:",l,d,m;return d=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function Ri(j){let o,h=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=i("p"),o.textContent=h},l(l){o=s(l,"P",{"data-svelte-h":!0}),f(o)!=="svelte-17p1lpg"&&(o.textContent=h)},m(l,d){u(l,o,d)},p:I,d(l){l&&p(o)}}}function zi(j){let o,h="Examples:",l,d,m;return d=new Pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function Yi(j){let o,h="If you get the error message below, you need to finetune the weights for your downstream task:",l,d,m;return d=new Pe({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-xueb0m"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function qi(j){let o,h=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=i("p"),o.innerHTML=h},l(l){o=s(l,"P",{"data-svelte-h":!0}),f(o)!=="svelte-x73rgs"&&(o.innerHTML=h)},m(l,d){u(l,o,d)},p:I,d(l){l&&p(o)}}}function Qi(j){let o,h="Examples:",l,d,m;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function Ai(j){let o,h="If you get the error message below, you need to finetune the weights for your downstream task:",l,d,m;return d=new Pe({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQQ==",highlighted:'Some weights <span class="hljs-keyword">of</span> FlaxUNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:'}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-xueb0m"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function Oi(j){let o,h=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=i("p"),o.innerHTML=h},l(l){o=s(l,"P",{"data-svelte-h":!0}),f(o)!=="svelte-6jnfc0"&&(o.innerHTML=h)},m(l,d){u(l,o,d)},p:I,d(l){l&&p(o)}}}function Ki(j){let o,h="Examples:",l,d,m;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZHBtcHAlMkMlMjBkcG1wcF9zdGF0ZSUyMCUzRCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBKSUwQSUwQWRwbV9waXBlJTJDJTIwZHBtX3BhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function es(j){let o,h="Examples:",l,d,m;return d=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`}}),{c(){o=i("p"),o.textContent=h,l=a(),g(d.$$.fragment)},l(n){o=s(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=h),l=r(n),b(d.$$.fragment,n)},m(n,T){u(n,o,T),u(n,l,T),_(d,n,T),m=!0},p:I,i(n){m||(y(d.$$.fragment,n),m=!0)},o(n){v(d.$$.fragment,n),m=!1},d(n){n&&(p(o),p(l)),w(d,n)}}}function ts(j){let o,h,l,d,m,n,T,k,A="Pipelines",sn,De,Lo="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",an,ke,Eo='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',rn,O,ln,Ze,Ro="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",dn,Je,zo='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="alt_diffusion">AltDiffusion</a></td> <td>image2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audio_diffusion">Audio Diffusion</a></td> <td>image2audio</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="cycle_diffusion">Cycle Diffusion</a></td> <td>image2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/gligen">GLIGEN</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="stable_diffusion/ldm3d_diffusion">LDM3D</a></td> <td>text2image, text-to-3D, text-to-pano, upscaling</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="paradigms">ParaDiGMS</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix_zero">Pix2Pix Zero</a></td> <td>image editing</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pndm">PNDM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="repaint">RePaint</a></td> <td>inpainting</td></tr> <tr><td><a href="score_sde_ve">Score SDE VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="spectrogram_diffusion">Spectrogram Diffusion</a></td> <td></td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="model_editing">Stable Diffusion Model Editing</a></td> <td>model editing</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stochastic_karras_ve">Stochastic Karras VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="latent_diffusion_uncond">Unconditional Latent Diffusion</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="versatile_diffusion">Versatile Diffusion</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="vq_diffusion">VQ Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr></tbody>',pn,z,K,Qt,Ce,jn,pt,Yo="DiffusionPipeline",cn,x,Ie,Pn,ct,qo="Base class for all pipelines.",Dn,ft,Qo=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,kn,mt,Ao="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",Zn,ut,Oo="Class attributes:",Jn,ht,Ko=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,Cn,ee,Ge,In,gt,ei="Call self as a function.",Gn,bt,We,Wn,G,He,Hn,_t,ti=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,Bn,te,Fn,yt,ni="Here are the ways to call <code>to</code>:",Vn,vt,oi=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,Nn,H,Be,Sn,wt,ii=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,Xn,xt,si=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,Ln,ne,En,oe,Fe,Rn,$t,ai=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,zn,ie,Ve,Yn,Mt,ri='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',qn,E,Ne,Qn,Tt,li="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",An,se,On,B,Se,Kn,Ut,di=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,eo,ae,to,re,no,le,Xe,oo,jt,pi=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,io,de,Le,so,Pt,ci=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,ao,F,Ee,ro,Dt,fi=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,lo,pe,po,ce,co,J,Re,fo,kt,mi="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",mo,Zt,ui="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",uo,fe,ho,me,go,ue,bo,he,ze,_o,Jt,hi=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,yo,ge,Ye,vo,Ct,gi="Convert a NumPy image or a batch of images to a PIL image.",wo,be,qe,xo,It,bi=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,fn,Y,_e,At,Qe,$o,Gt,_i="FlaxDiffusionPipeline",mn,P,Ae,Mo,Wt,yi="Base class for Flax-based pipelines.",To,Ht,vi=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Uo,Bt,wi="<li>enable/disable the progress bar for the denoising iteration</li>",jo,Ft,xi="Class attributes:",Po,Vt,$i=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,Do,C,Oe,ko,Nt,Mi="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",Zo,St,Ti="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",Jo,ye,Co,ve,Io,we,Go,xe,Ke,Wo,Xt,Ui="Convert a NumPy image or a batch of images to a PIL image.",Ho,$e,et,Bo,Lt,ji=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,un,q,Me,Ot,tt,Fo,Et,Pi="PushToHubMixin",hn,S,nt,Vo,Rt,Di="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",No,R,ot,So,zt,ki="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",Xo,Te,gn;return n=new Un({}),O=new dt({props:{warning:!0,$$slots:{default:[Vi]},$$scope:{ctx:j}}}),Ce=new Un({}),Ie=new D({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L533"}}),Ge=new D({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),We=new D({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L886",returnDescription:`
<p>The torch device on which the pipeline is located.</p>
`,returnType:`
<p><code>torch.device</code></p>
`}}),He=new D({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L727",returnDescription:`
<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),te=new dt({props:{$$slots:{default:[Ni]},$$scope:{ctx:j}}}),Be=new D({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1926"}}),ne=new je({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[Si]},$$scope:{ctx:j}}}),Fe=new D({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),Ve=new D({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),Ne=new D({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1537",returnDescription:`
<p>A path to the downloaded pipeline.</p>
`,returnType:`
<p><code>os.PathLike</code></p>
`}}),se=new dt({props:{$$slots:{default:[Xi]},$$scope:{ctx:j}}}),Se=new D({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),ae=new dt({props:{warning:!0,$$slots:{default:[Li]},$$scope:{ctx:j}}}),re=new je({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[Ei]},$$scope:{ctx:j}}}),Xe=new D({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1395"}}),Le=new D({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1484"}}),Ee=new D({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),pe=new dt({props:{warning:!0,$$slots:{default:[Ri]},$$scope:{ctx:j}}}),ce=new je({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[zi]},$$scope:{ctx:j}}}),Re=new D({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L916"}}),fe=new je({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[Yi]},$$scope:{ctx:j}}}),me=new dt({props:{$$slots:{default:[qi]},$$scope:{ctx:j}}}),ue=new je({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Qi]},$$scope:{ctx:j}}}),ze=new D({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1465"}}),Ye=new D({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1962"}}),qe=new D({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L614"}}),Qe=new Un({}),Ae=new D({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),Oe=new D({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype. If <code>&quot;auto&quot;</code>, the dtype is
automatically derived from the model&#x2019;s weights.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),ye=new je({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[Ai]},$$scope:{ctx:j}}}),ve=new dt({props:{$$slots:{default:[Oi]},$$scope:{ctx:j}}}),we=new je({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Ki]},$$scope:{ctx:j}}}),Ke=new D({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L588"}}),et=new D({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"params",val:": Union"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),tt=new Un({}),nt=new D({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L361"}}),ot=new D({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L390"}}),Te=new je({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[es]},$$scope:{ctx:j}}}),{c(){o=i("meta"),h=a(),l=i("h1"),d=i("a"),m=i("span"),g(n.$$.fragment),T=a(),k=i("span"),k.textContent=A,sn=a(),De=i("p"),De.textContent=Lo,an=a(),ke=i("p"),ke.innerHTML=Eo,rn=a(),g(O.$$.fragment),ln=a(),Ze=i("p"),Ze.textContent=Ro,dn=a(),Je=i("table"),Je.innerHTML=zo,pn=a(),z=i("h2"),K=i("a"),Qt=i("span"),g(Ce.$$.fragment),jn=a(),pt=i("span"),pt.textContent=Yo,cn=a(),x=i("div"),g(Ie.$$.fragment),Pn=a(),ct=i("p"),ct.textContent=qo,Dn=a(),ft=i("p"),ft.innerHTML=Qo,kn=a(),mt=i("ul"),mt.innerHTML=Ao,Zn=a(),ut=i("p"),ut.textContent=Oo,Jn=a(),ht=i("ul"),ht.innerHTML=Ko,Cn=a(),ee=i("div"),g(Ge.$$.fragment),In=a(),gt=i("p"),gt.textContent=ei,Gn=a(),bt=i("div"),g(We.$$.fragment),Wn=a(),G=i("div"),g(He.$$.fragment),Hn=a(),_t=i("p"),_t.innerHTML=ti,Bn=a(),g(te.$$.fragment),Fn=a(),yt=i("p"),yt.innerHTML=ni,Vn=a(),vt=i("ul"),vt.innerHTML=oi,Nn=a(),H=i("div"),g(Be.$$.fragment),Sn=a(),wt=i("p"),wt.innerHTML=ii,Xn=a(),xt=i("p"),xt.innerHTML=si,Ln=a(),g(ne.$$.fragment),En=a(),oe=i("div"),g(Fe.$$.fragment),Rn=a(),$t=i("p"),$t.innerHTML=ai,zn=a(),ie=i("div"),g(Ve.$$.fragment),Yn=a(),Mt=i("p"),Mt.innerHTML=ri,qn=a(),E=i("div"),g(Ne.$$.fragment),Qn=a(),Tt=i("p"),Tt.textContent=li,An=a(),g(se.$$.fragment),On=a(),B=i("div"),g(Se.$$.fragment),Kn=a(),Ut=i("p"),Ut.textContent=di,eo=a(),g(ae.$$.fragment),to=a(),g(re.$$.fragment),no=a(),le=i("div"),g(Xe.$$.fragment),oo=a(),jt=i("p"),jt.innerHTML=pi,io=a(),de=i("div"),g(Le.$$.fragment),so=a(),Pt=i("p"),Pt.innerHTML=ci,ao=a(),F=i("div"),g(Ee.$$.fragment),ro=a(),Dt=i("p"),Dt.innerHTML=fi,lo=a(),g(pe.$$.fragment),po=a(),g(ce.$$.fragment),co=a(),J=i("div"),g(Re.$$.fragment),fo=a(),kt=i("p"),kt.textContent=mi,mo=a(),Zt=i("p"),Zt.innerHTML=ui,uo=a(),g(fe.$$.fragment),ho=a(),g(me.$$.fragment),go=a(),g(ue.$$.fragment),bo=a(),he=i("div"),g(ze.$$.fragment),_o=a(),Jt=i("p"),Jt.innerHTML=hi,yo=a(),ge=i("div"),g(Ye.$$.fragment),vo=a(),Ct=i("p"),Ct.textContent=gi,wo=a(),be=i("div"),g(qe.$$.fragment),xo=a(),It=i("p"),It.innerHTML=bi,fn=a(),Y=i("h2"),_e=i("a"),At=i("span"),g(Qe.$$.fragment),$o=a(),Gt=i("span"),Gt.textContent=_i,mn=a(),P=i("div"),g(Ae.$$.fragment),Mo=a(),Wt=i("p"),Wt.textContent=yi,To=a(),Ht=i("p"),Ht.innerHTML=vi,Uo=a(),Bt=i("ul"),Bt.innerHTML=wi,jo=a(),Ft=i("p"),Ft.textContent=xi,Po=a(),Vt=i("ul"),Vt.innerHTML=$i,Do=a(),C=i("div"),g(Oe.$$.fragment),ko=a(),Nt=i("p"),Nt.textContent=Mi,Zo=a(),St=i("p"),St.textContent=Ti,Jo=a(),g(ye.$$.fragment),Co=a(),g(ve.$$.fragment),Io=a(),g(we.$$.fragment),Go=a(),xe=i("div"),g(Ke.$$.fragment),Wo=a(),Xt=i("p"),Xt.textContent=Ui,Ho=a(),$e=i("div"),g(et.$$.fragment),Bo=a(),Lt=i("p"),Lt.innerHTML=ji,un=a(),q=i("h2"),Me=i("a"),Ot=i("span"),g(tt.$$.fragment),Fo=a(),Et=i("span"),Et.textContent=Pi,hn=a(),S=i("div"),g(nt.$$.fragment),Vo=a(),Rt=i("p"),Rt.textContent=Di,No=a(),R=i("div"),g(ot.$$.fragment),So=a(),zt=i("p"),zt.textContent=ki,Xo=a(),g(Te.$$.fragment),this.h()},l(e){const c=Fi("svelte-1phssyn",document.head);o=s(c,"META",{name:!0,content:!0}),c.forEach(p),h=r(e),l=s(e,"H1",{class:!0});var it=U(l);d=s(it,"A",{id:!0,class:!0,href:!0});var Kt=U(d);m=s(Kt,"SPAN",{});var en=U(m);b(n.$$.fragment,en),en.forEach(p),Kt.forEach(p),T=r(it),k=s(it,"SPAN",{"data-svelte-h":!0}),f(k)!=="svelte-l4debw"&&(k.textContent=A),it.forEach(p),sn=r(e),De=s(e,"P",{"data-svelte-h":!0}),f(De)!=="svelte-eejdx6"&&(De.textContent=Lo),an=r(e),ke=s(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1d3b6kb"&&(ke.innerHTML=Eo),rn=r(e),b(O.$$.fragment,e),ln=r(e),Ze=s(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-2xd39c"&&(Ze.textContent=Ro),dn=r(e),Je=s(e,"TABLE",{"data-svelte-h":!0}),f(Je)!=="svelte-ht6h0o"&&(Je.innerHTML=zo),pn=r(e),z=s(e,"H2",{class:!0});var st=U(z);K=s(st,"A",{id:!0,class:!0,href:!0});var tn=U(K);Qt=s(tn,"SPAN",{});var nn=U(Qt);b(Ce.$$.fragment,nn),nn.forEach(p),tn.forEach(p),jn=r(st),pt=s(st,"SPAN",{"data-svelte-h":!0}),f(pt)!=="svelte-1huqf0a"&&(pt.textContent=Yo),st.forEach(p),cn=r(e),x=s(e,"DIV",{class:!0});var $=U(x);b(Ie.$$.fragment,$),Pn=r($),ct=s($,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-1neg3rw"&&(ct.textContent=qo),Dn=r($),ft=s($,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-1kbb8l4"&&(ft.innerHTML=Qo),kn=r($),mt=s($,"UL",{"data-svelte-h":!0}),f(mt)!=="svelte-2a5chx"&&(mt.innerHTML=Ao),Zn=r($),ut=s($,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-wz8va1"&&(ut.textContent=Oo),Jn=r($),ht=s($,"UL",{"data-svelte-h":!0}),f(ht)!=="svelte-1ilr6sx"&&(ht.innerHTML=Ko),Cn=r($),ee=s($,"DIV",{class:!0});var at=U(ee);b(Ge.$$.fragment,at),In=r(at),gt=s(at,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-1eed40t"&&(gt.textContent=ei),at.forEach(p),Gn=r($),bt=s($,"DIV",{class:!0});var on=U(bt);b(We.$$.fragment,on),on.forEach(p),Wn=r($),G=s($,"DIV",{class:!0});var W=U(G);b(He.$$.fragment,W),Hn=r(W),_t=s(W,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-1vbhnip"&&(_t.innerHTML=ti),Bn=r(W),b(te.$$.fragment,W),Fn=r(W),yt=s(W,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-5ul9n2"&&(yt.innerHTML=ni),Vn=r(W),vt=s(W,"UL",{"data-svelte-h":!0}),f(vt)!=="svelte-1icy6l9"&&(vt.innerHTML=oi),W.forEach(p),Nn=r($),H=s($,"DIV",{class:!0});var X=U(H);b(Be.$$.fragment,X),Sn=r(X),wt=s(X,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-had4mb"&&(wt.innerHTML=ii),Xn=r(X),xt=s(X,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-19k67ce"&&(xt.innerHTML=si),Ln=r(X),b(ne.$$.fragment,X),X.forEach(p),En=r($),oe=s($,"DIV",{class:!0});var rt=U(oe);b(Fe.$$.fragment,rt),Rn=r(rt),$t=s(rt,"P",{"data-svelte-h":!0}),f($t)!=="svelte-1lh0nh5"&&($t.innerHTML=ai),rt.forEach(p),zn=r($),ie=s($,"DIV",{class:!0});var lt=U(ie);b(Ve.$$.fragment,lt),Yn=r(lt),Mt=s(lt,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-1vfte1e"&&(Mt.innerHTML=ri),lt.forEach(p),qn=r($),E=s($,"DIV",{class:!0});var Q=U(E);b(Ne.$$.fragment,Q),Qn=r(Q),Tt=s(Q,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-1mfctah"&&(Tt.textContent=li),An=r(Q),b(se.$$.fragment,Q),Q.forEach(p),On=r($),B=s($,"DIV",{class:!0});var L=U(B);b(Se.$$.fragment,L),Kn=r(L),Ut=s(L,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-10jaql7"&&(Ut.textContent=di),eo=r(L),b(ae.$$.fragment,L),to=r(L),b(re.$$.fragment,L),L.forEach(p),no=r($),le=s($,"DIV",{class:!0});var bn=U(le);b(Xe.$$.fragment,bn),oo=r(bn),jt=s(bn,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-d7vywi"&&(jt.innerHTML=pi),bn.forEach(p),io=r($),de=s($,"DIV",{class:!0});var _n=U(de);b(Le.$$.fragment,_n),so=r(_n),Pt=s(_n,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-n1oyuv"&&(Pt.innerHTML=ci),_n.forEach(p),ao=r($),F=s($,"DIV",{class:!0});var Ue=U(F);b(Ee.$$.fragment,Ue),ro=r(Ue),Dt=s(Ue,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-e03q3e"&&(Dt.innerHTML=fi),lo=r(Ue),b(pe.$$.fragment,Ue),po=r(Ue),b(ce.$$.fragment,Ue),Ue.forEach(p),co=r($),J=s($,"DIV",{class:!0});var V=U(J);b(Re.$$.fragment,V),fo=r(V),kt=s(V,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-ccbjek"&&(kt.textContent=mi),mo=r(V),Zt=s(V,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-1p5vgmd"&&(Zt.innerHTML=ui),uo=r(V),b(fe.$$.fragment,V),ho=r(V),b(me.$$.fragment,V),go=r(V),b(ue.$$.fragment,V),V.forEach(p),bo=r($),he=s($,"DIV",{class:!0});var yn=U(he);b(ze.$$.fragment,yn),_o=r(yn),Jt=s(yn,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-zkab0b"&&(Jt.innerHTML=hi),yn.forEach(p),yo=r($),ge=s($,"DIV",{class:!0});var vn=U(ge);b(Ye.$$.fragment,vn),vo=r(vn),Ct=s(vn,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-1gut907"&&(Ct.textContent=gi),vn.forEach(p),wo=r($),be=s($,"DIV",{class:!0});var wn=U(be);b(qe.$$.fragment,wn),xo=r(wn),It=s(wn,"P",{"data-svelte-h":!0}),f(It)!=="svelte-1jcmq84"&&(It.innerHTML=bi),wn.forEach(p),$.forEach(p),fn=r(e),Y=s(e,"H2",{class:!0});var xn=U(Y);_e=s(xn,"A",{id:!0,class:!0,href:!0});var Zi=U(_e);At=s(Zi,"SPAN",{});var Ji=U(At);b(Qe.$$.fragment,Ji),Ji.forEach(p),Zi.forEach(p),$o=r(xn),Gt=s(xn,"SPAN",{"data-svelte-h":!0}),f(Gt)!=="svelte-rg3s2z"&&(Gt.textContent=_i),xn.forEach(p),mn=r(e),P=s(e,"DIV",{class:!0});var Z=U(P);b(Ae.$$.fragment,Z),Mo=r(Z),Wt=s(Z,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-1o1wti6"&&(Wt.textContent=yi),To=r(Z),Ht=s(Z,"P",{"data-svelte-h":!0}),f(Ht)!=="svelte-1h33ucg"&&(Ht.innerHTML=vi),Uo=r(Z),Bt=s(Z,"UL",{"data-svelte-h":!0}),f(Bt)!=="svelte-1kk3msp"&&(Bt.innerHTML=wi),jo=r(Z),Ft=s(Z,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-wz8va1"&&(Ft.textContent=xi),Po=r(Z),Vt=s(Z,"UL",{"data-svelte-h":!0}),f(Vt)!=="svelte-56flce"&&(Vt.innerHTML=$i),Do=r(Z),C=s(Z,"DIV",{class:!0});var N=U(C);b(Oe.$$.fragment,N),ko=r(N),Nt=s(N,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-7z61o"&&(Nt.textContent=Mi),Zo=r(N),St=s(N,"P",{"data-svelte-h":!0}),f(St)!=="svelte-wyh2cr"&&(St.textContent=Ti),Jo=r(N),b(ye.$$.fragment,N),Co=r(N),b(ve.$$.fragment,N),Io=r(N),b(we.$$.fragment,N),N.forEach(p),Go=r(Z),xe=s(Z,"DIV",{class:!0});var $n=U(xe);b(Ke.$$.fragment,$n),Wo=r($n),Xt=s($n,"P",{"data-svelte-h":!0}),f(Xt)!=="svelte-1gut907"&&(Xt.textContent=Ui),$n.forEach(p),Ho=r(Z),$e=s(Z,"DIV",{class:!0});var Mn=U($e);b(et.$$.fragment,Mn),Bo=r(Mn),Lt=s(Mn,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-spoull"&&(Lt.innerHTML=ji),Mn.forEach(p),Z.forEach(p),un=r(e),q=s(e,"H2",{class:!0});var Tn=U(q);Me=s(Tn,"A",{id:!0,class:!0,href:!0});var Ci=U(Me);Ot=s(Ci,"SPAN",{});var Ii=U(Ot);b(tt.$$.fragment,Ii),Ii.forEach(p),Ci.forEach(p),Fo=r(Tn),Et=s(Tn,"SPAN",{"data-svelte-h":!0}),f(Et)!=="svelte-2a7r8a"&&(Et.textContent=Pi),Tn.forEach(p),hn=r(e),S=s(e,"DIV",{class:!0});var Yt=U(S);b(nt.$$.fragment,Yt),Vo=r(Yt),Rt=s(Yt,"P",{"data-svelte-h":!0}),f(Rt)!=="svelte-7y8zei"&&(Rt.textContent=Di),No=r(Yt),R=s(Yt,"DIV",{class:!0});var qt=U(R);b(ot.$$.fragment,qt),So=r(qt),zt=s(qt,"P",{"data-svelte-h":!0}),f(zt)!=="svelte-5nfhmh"&&(zt.textContent=ki),Xo=r(qt),b(Te.$$.fragment,qt),qt.forEach(p),Yt.forEach(p),this.h()},h(){M(o,"name","hf:doc:metadata"),M(o,"content",JSON.stringify(ns)),M(d,"id","pipelines"),M(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(d,"href","#pipelines"),M(l,"class","relative group"),M(K,"id","diffusers.DiffusionPipeline"),M(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(K,"href","#diffusers.DiffusionPipeline"),M(z,"class","relative group"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"id","diffusers.FlaxDiffusionPipeline"),M(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(_e,"href","#diffusers.FlaxDiffusionPipeline"),M(Y,"class","relative group"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Me,"id","diffusers.utils.PushToHubMixin"),M(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Me,"href","#diffusers.utils.PushToHubMixin"),M(q,"class","relative group"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,o),u(e,h,c),u(e,l,c),t(l,d),t(d,m),_(n,m,null),t(l,T),t(l,k),u(e,sn,c),u(e,De,c),u(e,an,c),u(e,ke,c),u(e,rn,c),_(O,e,c),u(e,ln,c),u(e,Ze,c),u(e,dn,c),u(e,Je,c),u(e,pn,c),u(e,z,c),t(z,K),t(K,Qt),_(Ce,Qt,null),t(z,jn),t(z,pt),u(e,cn,c),u(e,x,c),_(Ie,x,null),t(x,Pn),t(x,ct),t(x,Dn),t(x,ft),t(x,kn),t(x,mt),t(x,Zn),t(x,ut),t(x,Jn),t(x,ht),t(x,Cn),t(x,ee),_(Ge,ee,null),t(ee,In),t(ee,gt),t(x,Gn),t(x,bt),_(We,bt,null),t(x,Wn),t(x,G),_(He,G,null),t(G,Hn),t(G,_t),t(G,Bn),_(te,G,null),t(G,Fn),t(G,yt),t(G,Vn),t(G,vt),t(x,Nn),t(x,H),_(Be,H,null),t(H,Sn),t(H,wt),t(H,Xn),t(H,xt),t(H,Ln),_(ne,H,null),t(x,En),t(x,oe),_(Fe,oe,null),t(oe,Rn),t(oe,$t),t(x,zn),t(x,ie),_(Ve,ie,null),t(ie,Yn),t(ie,Mt),t(x,qn),t(x,E),_(Ne,E,null),t(E,Qn),t(E,Tt),t(E,An),_(se,E,null),t(x,On),t(x,B),_(Se,B,null),t(B,Kn),t(B,Ut),t(B,eo),_(ae,B,null),t(B,to),_(re,B,null),t(x,no),t(x,le),_(Xe,le,null),t(le,oo),t(le,jt),t(x,io),t(x,de),_(Le,de,null),t(de,so),t(de,Pt),t(x,ao),t(x,F),_(Ee,F,null),t(F,ro),t(F,Dt),t(F,lo),_(pe,F,null),t(F,po),_(ce,F,null),t(x,co),t(x,J),_(Re,J,null),t(J,fo),t(J,kt),t(J,mo),t(J,Zt),t(J,uo),_(fe,J,null),t(J,ho),_(me,J,null),t(J,go),_(ue,J,null),t(x,bo),t(x,he),_(ze,he,null),t(he,_o),t(he,Jt),t(x,yo),t(x,ge),_(Ye,ge,null),t(ge,vo),t(ge,Ct),t(x,wo),t(x,be),_(qe,be,null),t(be,xo),t(be,It),u(e,fn,c),u(e,Y,c),t(Y,_e),t(_e,At),_(Qe,At,null),t(Y,$o),t(Y,Gt),u(e,mn,c),u(e,P,c),_(Ae,P,null),t(P,Mo),t(P,Wt),t(P,To),t(P,Ht),t(P,Uo),t(P,Bt),t(P,jo),t(P,Ft),t(P,Po),t(P,Vt),t(P,Do),t(P,C),_(Oe,C,null),t(C,ko),t(C,Nt),t(C,Zo),t(C,St),t(C,Jo),_(ye,C,null),t(C,Co),_(ve,C,null),t(C,Io),_(we,C,null),t(P,Go),t(P,xe),_(Ke,xe,null),t(xe,Wo),t(xe,Xt),t(P,Ho),t(P,$e),_(et,$e,null),t($e,Bo),t($e,Lt),u(e,un,c),u(e,q,c),t(q,Me),t(Me,Ot),_(tt,Ot,null),t(q,Fo),t(q,Et),u(e,hn,c),u(e,S,c),_(nt,S,null),t(S,Vo),t(S,Rt),t(S,No),t(S,R),_(ot,R,null),t(R,So),t(R,zt),t(R,Xo),_(Te,R,null),gn=!0},p(e,[c]){const it={};c&2&&(it.$$scope={dirty:c,ctx:e}),O.$set(it);const Kt={};c&2&&(Kt.$$scope={dirty:c,ctx:e}),te.$set(Kt);const en={};c&2&&(en.$$scope={dirty:c,ctx:e}),ne.$set(en);const st={};c&2&&(st.$$scope={dirty:c,ctx:e}),se.$set(st);const tn={};c&2&&(tn.$$scope={dirty:c,ctx:e}),ae.$set(tn);const nn={};c&2&&(nn.$$scope={dirty:c,ctx:e}),re.$set(nn);const $={};c&2&&($.$$scope={dirty:c,ctx:e}),pe.$set($);const at={};c&2&&(at.$$scope={dirty:c,ctx:e}),ce.$set(at);const on={};c&2&&(on.$$scope={dirty:c,ctx:e}),fe.$set(on);const W={};c&2&&(W.$$scope={dirty:c,ctx:e}),me.$set(W);const X={};c&2&&(X.$$scope={dirty:c,ctx:e}),ue.$set(X);const rt={};c&2&&(rt.$$scope={dirty:c,ctx:e}),ye.$set(rt);const lt={};c&2&&(lt.$$scope={dirty:c,ctx:e}),ve.$set(lt);const Q={};c&2&&(Q.$$scope={dirty:c,ctx:e}),we.$set(Q);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),Te.$set(L)},i(e){gn||(y(n.$$.fragment,e),y(O.$$.fragment,e),y(Ce.$$.fragment,e),y(Ie.$$.fragment,e),y(Ge.$$.fragment,e),y(We.$$.fragment,e),y(He.$$.fragment,e),y(te.$$.fragment,e),y(Be.$$.fragment,e),y(ne.$$.fragment,e),y(Fe.$$.fragment,e),y(Ve.$$.fragment,e),y(Ne.$$.fragment,e),y(se.$$.fragment,e),y(Se.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(Xe.$$.fragment,e),y(Le.$$.fragment,e),y(Ee.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(Re.$$.fragment,e),y(fe.$$.fragment,e),y(me.$$.fragment,e),y(ue.$$.fragment,e),y(ze.$$.fragment,e),y(Ye.$$.fragment,e),y(qe.$$.fragment,e),y(Qe.$$.fragment,e),y(Ae.$$.fragment,e),y(Oe.$$.fragment,e),y(ye.$$.fragment,e),y(ve.$$.fragment,e),y(we.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(nt.$$.fragment,e),y(ot.$$.fragment,e),y(Te.$$.fragment,e),gn=!0)},o(e){v(n.$$.fragment,e),v(O.$$.fragment,e),v(Ce.$$.fragment,e),v(Ie.$$.fragment,e),v(Ge.$$.fragment,e),v(We.$$.fragment,e),v(He.$$.fragment,e),v(te.$$.fragment,e),v(Be.$$.fragment,e),v(ne.$$.fragment,e),v(Fe.$$.fragment,e),v(Ve.$$.fragment,e),v(Ne.$$.fragment,e),v(se.$$.fragment,e),v(Se.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(Xe.$$.fragment,e),v(Le.$$.fragment,e),v(Ee.$$.fragment,e),v(pe.$$.fragment,e),v(ce.$$.fragment,e),v(Re.$$.fragment,e),v(fe.$$.fragment,e),v(me.$$.fragment,e),v(ue.$$.fragment,e),v(ze.$$.fragment,e),v(Ye.$$.fragment,e),v(qe.$$.fragment,e),v(Qe.$$.fragment,e),v(Ae.$$.fragment,e),v(Oe.$$.fragment,e),v(ye.$$.fragment,e),v(ve.$$.fragment,e),v(we.$$.fragment,e),v(Ke.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(nt.$$.fragment,e),v(ot.$$.fragment,e),v(Te.$$.fragment,e),gn=!1},d(e){e&&(p(h),p(l),p(sn),p(De),p(an),p(ke),p(rn),p(ln),p(Ze),p(dn),p(Je),p(pn),p(z),p(cn),p(x),p(fn),p(Y),p(mn),p(P),p(un),p(q),p(hn),p(S)),p(o),w(n),w(O,e),w(Ce),w(Ie),w(Ge),w(We),w(He),w(te),w(Be),w(ne),w(Fe),w(Ve),w(Ne),w(se),w(Se),w(ae),w(re),w(Xe),w(Le),w(Ee),w(pe),w(ce),w(Re),w(fe),w(me),w(ue),w(ze),w(Ye),w(qe),w(Qe),w(Ae),w(Oe),w(ye),w(ve),w(we),w(Ke),w(et),w(tt),w(nt),w(ot),w(Te)}}}const ns={local:"pipelines",sections:[{local:"diffusers.DiffusionPipeline",title:"DiffusionPipeline"},{local:"diffusers.FlaxDiffusionPipeline",title:"FlaxDiffusionPipeline"},{local:"diffusers.utils.PushToHubMixin",title:"PushToHubMixin"}],title:"Pipelines"};function os(j){return Wi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Hi{constructor(o){super(),Bi(this,o,os,ts,Gi,{})}}export{cs as component};
