import{s as pa,o as da,n as hs}from"../chunks/scheduler.182ea377.js";import{S as ca,i as ma,g as n,s as a,p as g,A as ga,h as s,f as o,c as i,j as d,q as f,m,k as r,v as t,a as I,r as u,d as h,t as _,u as b}from"../chunks/index.008d68e4.js";import{T as fa}from"../chunks/Tip.4f096367.js";import{D as T}from"../chunks/Docstring.7aec8b85.js";import{C as ra}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as gn}from"../chunks/IconCopyLink.96bbb92b.js";import{E as la}from"../chunks/ExampleCodeBlock.23e54afe.js";function ua(D){let w,U='Make sure to check out the Stable Diffusion <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/overview#tips" rel="nofollow">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality and how to reuse pipeline components efficiently!',G,v,J='If you want to use one of the official checkpoints for a task, explore the <a href="https://huggingface.co/gligen" rel="nofollow">gligen</a> Hub organizations!';return{c(){w=n("p"),w.innerHTML=U,G=a(),v=n("p"),v.innerHTML=J},l(l){w=s(l,"P",{"data-svelte-h":!0}),m(w)!=="svelte-v9h8gm"&&(w.innerHTML=U),G=i(l),v=s(l,"P",{"data-svelte-h":!0}),m(v)!=="svelte-9ek9ww"&&(v.innerHTML=J)},m(l,j){I(l,w,j),I(l,G,j),I(l,v,j)},p:hs,d(l){l&&(o(w),o(G),o(v))}}}function ha(D){let w,U="Examples:",G,v,J;return v=new ra({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionGLIGENPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Insert objects described by text at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;masterful/gligen-1-4-inpainting-text-box&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/livingroom_modern.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a birthday cake&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.2676</span>, <span class="hljs-number">0.6088</span>, <span class="hljs-number">0.4773</span>, <span class="hljs-number">0.7183</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;a birthday cake&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_inpaint_image=input_image,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-1-4-inpainting-text-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># insert objects described by text at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;masterful/gligen-1-4-generation-text-box&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a waterfall and a modern high speed train running through the tunnel in a beautiful forest with fall foliage&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.1387</span>, <span class="hljs-number">0.2051</span>, <span class="hljs-number">0.4277</span>, <span class="hljs-number">0.7090</span>], [<span class="hljs-number">0.4980</span>, <span class="hljs-number">0.4355</span>, <span class="hljs-number">0.8516</span>, <span class="hljs-number">0.7266</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;a waterfall&quot;</span>, <span class="hljs-string">&quot;a modern high speed train running through the tunnel&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-1-4-generation-text-box.jpg&quot;</span>)`}}),{c(){w=n("p"),w.textContent=U,G=a(),g(v.$$.fragment)},l(l){w=s(l,"P",{"data-svelte-h":!0}),m(w)!=="svelte-kvfsh7"&&(w.textContent=U),G=i(l),f(v.$$.fragment,l)},m(l,j){I(l,w,j),I(l,G,j),u(v,l,j),J=!0},p:hs,i(l){J||(h(v.$$.fragment,l),J=!0)},o(l){_(v.$$.fragment,l),J=!1},d(l){l&&(o(w),o(G)),b(v,l)}}}function _a(D){let w,U="Examples:",G,v,J;return v=new ra({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionGLIGENTextImagePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Insert objects described by image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Inpainting_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/livingroom_modern.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a backpack&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.2676</span>, <span class="hljs-number">0.4088</span>, <span class="hljs-number">0.4773</span>, <span class="hljs-number">0.7183</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = <span class="hljs-literal">None</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/backpack.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_inpaint_image=input_image,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_images=[gligen_image],
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-inpainting-text-image-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># insert objects described by text and image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a flower sitting on the beach&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.0</span>, <span class="hljs-number">0.09</span>, <span class="hljs-number">0.53</span>, <span class="hljs-number">0.76</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;flower&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/pexels-pixabay-60597.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_images=[gligen_image],
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-generation-text-image-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transfer style described by image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a dragon flying on the sky&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.4</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>], [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>]]  <span class="hljs-comment"># Set \`[0.0, 1.0, 0.0, 1.0]\` for the style</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_placeholder = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;dragon&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;placeholder&quot;</span>,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># Can use any text instead of \`placeholder\` token, because we will use mask here</span>
<span class="hljs-meta">... </span>    gligen_images=[
<span class="hljs-meta">... </span>        gligen_placeholder,
<span class="hljs-meta">... </span>        gligen_image,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># Can use any image in gligen_placeholder, because we will use mask here</span>
<span class="hljs-meta">... </span>    input_phrases_mask=[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],  <span class="hljs-comment"># Set 0 for the placeholder token</span>
<span class="hljs-meta">... </span>    input_images_mask=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>],  <span class="hljs-comment"># Set 0 for the placeholder image</span>
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-generation-text-image-box-style-transfer.jpg&quot;</span>)`}}),{c(){w=n("p"),w.textContent=U,G=a(),g(v.$$.fragment)},l(l){w=s(l,"P",{"data-svelte-h":!0}),m(w)!=="svelte-kvfsh7"&&(w.textContent=U),G=i(l),f(v.$$.fragment,l)},m(l,j){I(l,w,j),I(l,G,j),u(v,l,j),J=!0},p:hs,i(l){J||(h(v.$$.fragment,l),J=!0)},o(l){_(v.$$.fragment,l),J=!1},d(l){l&&(o(w),o(G)),b(v,l)}}}function ba(D){let w,U,G,v,J,l,j,Re,_s="GLIGEN (Grounded Language-to-Image Generation)",Nt,re,bs='The GLIGEN model was created by researchers and engineers from <a href="https://github.com/gligen/GLIGEN" rel="nofollow">University of Wisconsin-Madison, Columbia University, and Microsoft</a>. The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> can generate photorealistic images conditioned on grounding inputs. Along with text and bounding boxes with <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a>, if input images are given, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> can insert objects described by text at the region defined by bounding boxes. Otherwise, it’ll generate an image described by the caption/prompt and insert objects described by text at the region defined by bounding boxes. It’s trained on COCO2014D and COCO2014CD datasets, and the model uses a frozen CLIP ViT-L/14 text encoder to condition itself on grounding inputs.',Et,pe,Ms='The abstract from the <a href="https://huggingface.co/papers/2301.07093" rel="nofollow">paper</a> is:',Ct,de,ws="<em>Large-scale text-to-image diffusion models have made amazing advances. However, the status quo is to use text input alone, which can impede controllability. In this work, we propose GLIGEN, Grounded-Language-to-Image Generation, a novel approach that builds upon and extends the functionality of existing pre-trained text-to-image diffusion models by enabling them to also be conditioned on grounding inputs. To preserve the vast concept knowledge of the pre-trained model, we freeze all of its weights and inject the grounding information into new trainable layers via a gated mechanism. Our model achieves open-world grounded text2img generation with caption and bounding box condition inputs, and the grounding ability generalizes well to novel spatial configurations and concepts. GLIGEN’s zeroshot performance on COCO and LVIS outperforms existing supervised layout-to-image baselines by a large margin.</em>",Zt,k,St,ce,vs='<a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a> was contributed by <a href="https://github.com/nikhil-masterful" rel="nofollow">Nikhil Gajendrakumar</a> and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> was contributed by <a href="https://github.com/tuanh123789" rel="nofollow">Nguyễn Công Tú Anh</a>.',Dt,E,$,xt,me,fn,ze,Is="StableDiffusionGLIGENPipeline",kt,y,ge,un,Ye,ys="Pipeline for text-to-image generation using Stable Diffusion with Grounded-Language-to-Image Generation (GLIGEN).",hn,Xe,Ts=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.).`,_n,L,fe,bn,Qe,Gs="The call function to the pipeline for generation.",Mn,P,wn,W,ue,vn,He,xs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,In,B,he,yn,qe,Js=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Tn,V,_e,Gn,Fe,js=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,xn,A,be,Jn,Oe,Us=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,jn,R,Me,Un,Ke,Ls=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Ln,et,we,Nn,tt,ve,En,z,Ie,Cn,nt,Ns="Encodes the prompt into text encoder hidden states.",$t,C,Y,Jt,ye,Zn,st,Es="StableDiffusionGLIGENTextImagePipeline",Pt,p,Te,Sn,at,Cs="Pipeline for text-to-image generation using Stable Diffusion with Grounded-Language-to-Image Generation (GLIGEN).",Dn,it,Zs=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.).`,kn,N,Ge,$n,ot,Ss="The call function to the pipeline for generation.",Pn,X,Wn,Q,xe,Bn,lt,Ds=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Vn,H,Je,An,rt,ks=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Rn,q,je,zn,pt,$s=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Yn,F,Ue,Xn,dt,Ps=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Qn,O,Le,Hn,ct,Ws=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,qn,mt,Ne,Fn,gt,Ee,On,K,Ce,Kn,ft,Bs=`Based on the input mask corresponding value <code>0 or 1</code> for each phrases and image, mask the features
corresponding to phrases and images.`,es,ee,Ze,ts,ut,Vs="Crop the input image to the specified dimensions.",ns,te,Se,ss,ht,As=`Create an inpainting mask based on given boxes. This function generates an inpainting mask using the provided
boxes to mark regions that need to be inpainted.`,as,ne,De,is,_t,Rs="Encodes the prompt into text encoder hidden states.",os,se,ke,ls,bt,zs=`Get image and phrases embedding by using CLIP pretrain model. The image embedding is transformed into the
phrases embedding space through a projection.`,rs,ae,$e,ps,Mt,Ys=`Prepare the cross-attention kwargs containing information about the grounded input (boxes, mask, image
embedding, phrases embedding).`,ds,ie,Pe,cs,wt,Xs=`Prepare the cross-attention kwargs without information about the grounded input (boxes, mask, image embedding,
phrases embedding) (All are zero tensor).`,ms,oe,We,gs,vt,Qs="Crop and resize the image to the target size while keeping the center.",Wt,Z,le,jt,Be,fs,It,Hs="StableDiffusionPipelineOutput",Bt,S,Ve,us,yt,qs="Output class for Stable Diffusion pipelines.",Vt;return l=new gn({}),k=new fa({props:{$$slots:{default:[ua]},$$scope:{ctx:D}}}),me=new gn({}),ge=new T({props:{name:"class diffusers.StableDiffusionGLIGENPipeline",anchor:"diffusers.StableDiffusionGLIGENPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L102"}}),fe=new T({props:{name:"__call__",anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"gligen_scheduled_sampling_beta",val:": float = 0.3"},{name:"gligen_phrases",val:": List = None"},{name:"gligen_boxes",val:": List = None"},{name:"gligen_inpaint_image",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_phrases",description:`<strong>gligen_phrases</strong> (<code>List[str]</code>) &#x2014;
The phrases to guide what to include in each of the regions defined by the corresponding
<code>gligen_boxes</code>. There should only be one phrase per bounding box.`,name:"gligen_phrases"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_boxes",description:`<strong>gligen_boxes</strong> (<code>List[List[float]]</code>) &#x2014;
The bounding boxes that identify rectangular regions of the image that are going to be filled with the
content described by the corresponding <code>gligen_phrases</code>. Each rectangular box is defined as a
<code>List[float]</code> of 4 elements <code>[xmin, ymin, xmax, ymax]</code> where each value is between [0,1].`,name:"gligen_boxes"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_inpaint_image",description:`<strong>gligen_inpaint_image</strong> (<code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
The input image, if provided, is inpainted with objects described by the <code>gligen_boxes</code> and
<code>gligen_phrases</code>. Otherwise, it is treated as a generation task on a blank input image.`,name:"gligen_inpaint_image"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_scheduled_sampling_beta",description:`<strong>gligen_scheduled_sampling_beta</strong> (<code>float</code>, defaults to 0.3) &#x2014;
Scheduled Sampling factor from <a href="https://arxiv.org/pdf/2301.07093.pdf" rel="nofollow">GLIGEN: Open-Set Grounded Text-to-Image
Generation</a>. Scheduled Sampling factor is only varied for
scheduled sampling during inference for improved quality and controllability.`,name:"gligen_scheduled_sampling_beta"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L551",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),P=new la({props:{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.example",$$slots:{default:[ha]},$$scope:{ctx:D}}}),ue=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L175"}}),he=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L182"}}),_e=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L189"}}),be=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L197"}}),Me=new T({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1395"}}),we=new T({props:{name:"prepare_latents",anchor:"diffusers.StableDiffusionGLIGENPipeline.prepare_latents",parameters:[{name:"batch_size",val:""},{name:"num_channels_latents",val:""},{name:"height",val:""},{name:"width",val:""},{name:"dtype",val:""},{name:"device",val:""},{name:"generator",val:""},{name:"latents",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L507"}}),ve=new T({props:{name:"enable_fuser",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_fuser",parameters:[{name:"enabled",val:" = True"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L524"}}),Ie=new T({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L238"}}),ye=new gn({}),Te=new T({props:{name:"class diffusers.StableDiffusionGLIGENTextImagePipeline",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"processor",val:": CLIPProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_project",val:": CLIPImageProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.processor",description:`<strong>processor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPProcessor" rel="nofollow">CLIPProcessor</a>) &#x2014;
A <code>CLIPProcessor</code> to procces reference image.`,name:"processor"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.image_encoder",description:`<strong>image_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>) &#x2014;
Frozen image-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"image_encoder"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.image_project",description:`<strong>image_project</strong> (<code>CLIPImageProjection</code>) &#x2014;
A <code>CLIPImageProjection</code> to project image embedding into phrases embedding space.`,name:"image_project"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L148"}}),Ge=new T({props:{name:"__call__",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"gligen_scheduled_sampling_beta",val:": float = 0.3"},{name:"gligen_phrases",val:": List = None"},{name:"gligen_images",val:": List = None"},{name:"input_phrases_mask",val:": Union = None"},{name:"input_images_mask",val:": Union = None"},{name:"gligen_boxes",val:": List = None"},{name:"gligen_inpaint_image",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"gligen_normalize_constant",val:": float = 28.7"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_phrases",description:`<strong>gligen_phrases</strong> (<code>List[str]</code>) &#x2014;
The phrases to guide what to include in each of the regions defined by the corresponding
<code>gligen_boxes</code>. There should only be one phrase per bounding box.`,name:"gligen_phrases"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_images",description:`<strong>gligen_images</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The images to guide what to include in each of the regions defined by the corresponding <code>gligen_boxes</code>.
There should only be one image per bounding box`,name:"gligen_images"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.input_phrases_mask",description:`<strong>input_phrases_mask</strong> (<code>int</code> or <code>List[int]</code>) &#x2014;
pre phrases mask input defined by the correspongding <code>input_phrases_mask</code>`,name:"input_phrases_mask"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.input_images_mask",description:`<strong>input_images_mask</strong> (<code>int</code> or <code>List[int]</code>) &#x2014;
pre images mask input defined by the correspongding <code>input_images_mask</code>`,name:"input_images_mask"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_boxes",description:`<strong>gligen_boxes</strong> (<code>List[List[float]]</code>) &#x2014;
The bounding boxes that identify rectangular regions of the image that are going to be filled with the
content described by the corresponding <code>gligen_phrases</code>. Each rectangular box is defined as a
<code>List[float]</code> of 4 elements <code>[xmin, ymin, xmax, ymax]</code> where each value is between [0,1].`,name:"gligen_boxes"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_inpaint_image",description:`<strong>gligen_inpaint_image</strong> (<code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
The input image, if provided, is inpainted with objects described by the <code>gligen_boxes</code> and
<code>gligen_phrases</code>. Otherwise, it is treated as a generation task on a blank input image.`,name:"gligen_inpaint_image"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_scheduled_sampling_beta",description:`<strong>gligen_scheduled_sampling_beta</strong> (<code>float</code>, defaults to 0.3) &#x2014;
Scheduled Sampling factor from <a href="https://arxiv.org/pdf/2301.07093.pdf" rel="nofollow">GLIGEN: Open-Set Grounded Text-to-Image
Generation</a>. Scheduled Sampling factor is only varied for
scheduled sampling during inference for improved quality and controllability.`,name:"gligen_scheduled_sampling_beta"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_normalize_constant",description:`<strong>gligen_normalize_constant</strong> (<code>float</code>, <em>optional</em>, defaults to 28.7) &#x2014;
The normalize value of the image embedding.`,name:"gligen_normalize_constant"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L712",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),X=new la({props:{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.example",$$slots:{default:[_a]},$$scope:{ctx:D}}}),xe=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L233"}}),Je=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L240"}}),je=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L247"}}),Ue=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L255"}}),Le=new T({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1395"}}),Ne=new T({props:{name:"prepare_latents",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.prepare_latents",parameters:[{name:"batch_size",val:""},{name:"num_channels_latents",val:""},{name:"height",val:""},{name:"width",val:""},{name:"dtype",val:""},{name:"device",val:""},{name:"generator",val:""},{name:"latents",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L531"}}),Ee=new T({props:{name:"enable_fuser",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_fuser",parameters:[{name:"enabled",val:" = True"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L548"}}),Ce=new T({props:{name:"complete_mask",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.complete_mask",parameters:[{name:"has_mask",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L585"}}),Ze=new T({props:{name:"crop",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.crop",parameters:[{name:"im",val:""},{name:"new_width",val:""},{name:"new_height",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L565"}}),Se=new T({props:{name:"draw_inpaint_mask_from_boxes",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.draw_inpaint_mask_from_boxes",parameters:[{name:"boxes",val:""},{name:"size",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L553"}}),De=new T({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L263"}}),ke=new T({props:{name:"get_clip_feature",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_clip_feature",parameters:[{name:"input",val:""},{name:"normalize_constant",val:""},{name:"device",val:""},{name:"is_image",val:" = False"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L601"}}),$e=new T({props:{name:"get_cross_attention_kwargs_with_grounded",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_cross_attention_kwargs_with_grounded",parameters:[{name:"hidden_size",val:""},{name:"gligen_phrases",val:""},{name:"gligen_images",val:""},{name:"gligen_boxes",val:""},{name:"input_phrases_mask",val:""},{name:"input_images_mask",val:""},{name:"repeat_batch",val:""},{name:"normalize_constant",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L625"}}),Pe=new T({props:{name:"get_cross_attention_kwargs_without_grounded",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_cross_attention_kwargs_without_grounded",parameters:[{name:"hidden_size",val:""},{name:"repeat_batch",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L689"}}),We=new T({props:{name:"target_size_center_crop",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.target_size_center_crop",parameters:[{name:"im",val:""},{name:"new_hw",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L576"}}),Be=new gn({}),Ve=new T({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){w=n("meta"),U=a(),G=n("h1"),v=n("a"),J=n("span"),g(l.$$.fragment),j=a(),Re=n("span"),Re.textContent=_s,Nt=a(),re=n("p"),re.innerHTML=bs,Et=a(),pe=n("p"),pe.innerHTML=Ms,Ct=a(),de=n("p"),de.innerHTML=ws,Zt=a(),g(k.$$.fragment),St=a(),ce=n("p"),ce.innerHTML=vs,Dt=a(),E=n("h2"),$=n("a"),xt=n("span"),g(me.$$.fragment),fn=a(),ze=n("span"),ze.textContent=Is,kt=a(),y=n("div"),g(ge.$$.fragment),un=a(),Ye=n("p"),Ye.textContent=ys,hn=a(),Xe=n("p"),Xe.innerHTML=Ts,_n=a(),L=n("div"),g(fe.$$.fragment),bn=a(),Qe=n("p"),Qe.textContent=Gs,Mn=a(),g(P.$$.fragment),wn=a(),W=n("div"),g(ue.$$.fragment),vn=a(),He=n("p"),He.textContent=xs,In=a(),B=n("div"),g(he.$$.fragment),yn=a(),qe=n("p"),qe.innerHTML=Js,Tn=a(),V=n("div"),g(_e.$$.fragment),Gn=a(),Fe=n("p"),Fe.textContent=js,xn=a(),A=n("div"),g(be.$$.fragment),Jn=a(),Oe=n("p"),Oe.innerHTML=Us,jn=a(),R=n("div"),g(Me.$$.fragment),Un=a(),Ke=n("p"),Ke.innerHTML=Ls,Ln=a(),et=n("div"),g(we.$$.fragment),Nn=a(),tt=n("div"),g(ve.$$.fragment),En=a(),z=n("div"),g(Ie.$$.fragment),Cn=a(),nt=n("p"),nt.textContent=Ns,$t=a(),C=n("h2"),Y=n("a"),Jt=n("span"),g(ye.$$.fragment),Zn=a(),st=n("span"),st.textContent=Es,Pt=a(),p=n("div"),g(Te.$$.fragment),Sn=a(),at=n("p"),at.textContent=Cs,Dn=a(),it=n("p"),it.innerHTML=Zs,kn=a(),N=n("div"),g(Ge.$$.fragment),$n=a(),ot=n("p"),ot.textContent=Ss,Pn=a(),g(X.$$.fragment),Wn=a(),Q=n("div"),g(xe.$$.fragment),Bn=a(),lt=n("p"),lt.textContent=Ds,Vn=a(),H=n("div"),g(Je.$$.fragment),An=a(),rt=n("p"),rt.innerHTML=ks,Rn=a(),q=n("div"),g(je.$$.fragment),zn=a(),pt=n("p"),pt.textContent=$s,Yn=a(),F=n("div"),g(Ue.$$.fragment),Xn=a(),dt=n("p"),dt.innerHTML=Ps,Qn=a(),O=n("div"),g(Le.$$.fragment),Hn=a(),ct=n("p"),ct.innerHTML=Ws,qn=a(),mt=n("div"),g(Ne.$$.fragment),Fn=a(),gt=n("div"),g(Ee.$$.fragment),On=a(),K=n("div"),g(Ce.$$.fragment),Kn=a(),ft=n("p"),ft.innerHTML=Bs,es=a(),ee=n("div"),g(Ze.$$.fragment),ts=a(),ut=n("p"),ut.textContent=Vs,ns=a(),te=n("div"),g(Se.$$.fragment),ss=a(),ht=n("p"),ht.textContent=As,as=a(),ne=n("div"),g(De.$$.fragment),is=a(),_t=n("p"),_t.textContent=Rs,os=a(),se=n("div"),g(ke.$$.fragment),ls=a(),bt=n("p"),bt.textContent=zs,rs=a(),ae=n("div"),g($e.$$.fragment),ps=a(),Mt=n("p"),Mt.textContent=Ys,ds=a(),ie=n("div"),g(Pe.$$.fragment),cs=a(),wt=n("p"),wt.textContent=Xs,ms=a(),oe=n("div"),g(We.$$.fragment),gs=a(),vt=n("p"),vt.textContent=Qs,Wt=a(),Z=n("h2"),le=n("a"),jt=n("span"),g(Be.$$.fragment),fs=a(),It=n("span"),It.textContent=Hs,Bt=a(),S=n("div"),g(Ve.$$.fragment),us=a(),yt=n("p"),yt.textContent=qs,this.h()},l(e){const M=ga("svelte-1phssyn",document.head);w=s(M,"META",{name:!0,content:!0}),M.forEach(o),U=i(e),G=s(e,"H1",{class:!0});var Ae=d(G);v=s(Ae,"A",{id:!0,class:!0,href:!0});var Ut=d(v);J=s(Ut,"SPAN",{});var Lt=d(J);f(l.$$.fragment,Lt),Lt.forEach(o),Ut.forEach(o),j=i(Ae),Re=s(Ae,"SPAN",{"data-svelte-h":!0}),m(Re)!=="svelte-aeitmc"&&(Re.textContent=_s),Ae.forEach(o),Nt=i(e),re=s(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-l5ge0a"&&(re.innerHTML=bs),Et=i(e),pe=s(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-uh0q2i"&&(pe.innerHTML=Ms),Ct=i(e),de=s(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-5czwpf"&&(de.innerHTML=ws),Zt=i(e),f(k.$$.fragment,e),St=i(e),ce=s(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-43r83w"&&(ce.innerHTML=vs),Dt=i(e),E=s(e,"H2",{class:!0});var At=d(E);$=s(At,"A",{id:!0,class:!0,href:!0});var Fs=d($);xt=s(Fs,"SPAN",{});var Os=d(xt);f(me.$$.fragment,Os),Os.forEach(o),Fs.forEach(o),fn=i(At),ze=s(At,"SPAN",{"data-svelte-h":!0}),m(ze)!=="svelte-aqdlzf"&&(ze.textContent=Is),At.forEach(o),kt=i(e),y=s(e,"DIV",{class:!0});var x=d(y);f(ge.$$.fragment,x),un=i(x),Ye=s(x,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-gowtb8"&&(Ye.textContent=ys),hn=i(x),Xe=s(x,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1s3mvdr"&&(Xe.innerHTML=Ts),_n=i(x),L=s(x,"DIV",{class:!0});var Tt=d(L);f(fe.$$.fragment,Tt),bn=i(Tt),Qe=s(Tt,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-50j04k"&&(Qe.textContent=Gs),Mn=i(Tt),f(P.$$.fragment,Tt),Tt.forEach(o),wn=i(x),W=s(x,"DIV",{class:!0});var Rt=d(W);f(ue.$$.fragment,Rt),vn=i(Rt),He=s(Rt,"P",{"data-svelte-h":!0}),m(He)!=="svelte-14bnrb6"&&(He.textContent=xs),Rt.forEach(o),In=i(x),B=s(x,"DIV",{class:!0});var zt=d(B);f(he.$$.fragment,zt),yn=i(zt),qe=s(zt,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1s3c06i"&&(qe.innerHTML=Js),zt.forEach(o),Tn=i(x),V=s(x,"DIV",{class:!0});var Yt=d(V);f(_e.$$.fragment,Yt),Gn=i(Yt),Fe=s(Yt,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-1xwrf7t"&&(Fe.textContent=js),Yt.forEach(o),xn=i(x),A=s(x,"DIV",{class:!0});var Xt=d(A);f(be.$$.fragment,Xt),Jn=i(Xt),Oe=s(Xt,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-pkn4ui"&&(Oe.innerHTML=Us),Xt.forEach(o),jn=i(x),R=s(x,"DIV",{class:!0});var Qt=d(R);f(Me.$$.fragment,Qt),Un=i(Qt),Ke=s(Qt,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-d7vywi"&&(Ke.innerHTML=Ls),Qt.forEach(o),Ln=i(x),et=s(x,"DIV",{class:!0});var Ks=d(et);f(we.$$.fragment,Ks),Ks.forEach(o),Nn=i(x),tt=s(x,"DIV",{class:!0});var ea=d(tt);f(ve.$$.fragment,ea),ea.forEach(o),En=i(x),z=s(x,"DIV",{class:!0});var Ht=d(z);f(Ie.$$.fragment,Ht),Cn=i(Ht),nt=s(Ht,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-16q0ax1"&&(nt.textContent=Ns),Ht.forEach(o),x.forEach(o),$t=i(e),C=s(e,"H2",{class:!0});var qt=d(C);Y=s(qt,"A",{id:!0,class:!0,href:!0});var ta=d(Y);Jt=s(ta,"SPAN",{});var na=d(Jt);f(ye.$$.fragment,na),na.forEach(o),ta.forEach(o),Zn=i(qt),st=s(qt,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-1h62ho5"&&(st.textContent=Es),qt.forEach(o),Pt=i(e),p=s(e,"DIV",{class:!0});var c=d(p);f(Te.$$.fragment,c),Sn=i(c),at=s(c,"P",{"data-svelte-h":!0}),m(at)!=="svelte-gowtb8"&&(at.textContent=Cs),Dn=i(c),it=s(c,"P",{"data-svelte-h":!0}),m(it)!=="svelte-1s3mvdr"&&(it.innerHTML=Zs),kn=i(c),N=s(c,"DIV",{class:!0});var Gt=d(N);f(Ge.$$.fragment,Gt),$n=i(Gt),ot=s(Gt,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-50j04k"&&(ot.textContent=Ss),Pn=i(Gt),f(X.$$.fragment,Gt),Gt.forEach(o),Wn=i(c),Q=s(c,"DIV",{class:!0});var Ft=d(Q);f(xe.$$.fragment,Ft),Bn=i(Ft),lt=s(Ft,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-14bnrb6"&&(lt.textContent=Ds),Ft.forEach(o),Vn=i(c),H=s(c,"DIV",{class:!0});var Ot=d(H);f(Je.$$.fragment,Ot),An=i(Ot),rt=s(Ot,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1s3c06i"&&(rt.innerHTML=ks),Ot.forEach(o),Rn=i(c),q=s(c,"DIV",{class:!0});var Kt=d(q);f(je.$$.fragment,Kt),zn=i(Kt),pt=s(Kt,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1xwrf7t"&&(pt.textContent=$s),Kt.forEach(o),Yn=i(c),F=s(c,"DIV",{class:!0});var en=d(F);f(Ue.$$.fragment,en),Xn=i(en),dt=s(en,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-pkn4ui"&&(dt.innerHTML=Ps),en.forEach(o),Qn=i(c),O=s(c,"DIV",{class:!0});var tn=d(O);f(Le.$$.fragment,tn),Hn=i(tn),ct=s(tn,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-d7vywi"&&(ct.innerHTML=Ws),tn.forEach(o),qn=i(c),mt=s(c,"DIV",{class:!0});var sa=d(mt);f(Ne.$$.fragment,sa),sa.forEach(o),Fn=i(c),gt=s(c,"DIV",{class:!0});var aa=d(gt);f(Ee.$$.fragment,aa),aa.forEach(o),On=i(c),K=s(c,"DIV",{class:!0});var nn=d(K);f(Ce.$$.fragment,nn),Kn=i(nn),ft=s(nn,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-z0y3an"&&(ft.innerHTML=Bs),nn.forEach(o),es=i(c),ee=s(c,"DIV",{class:!0});var sn=d(ee);f(Ze.$$.fragment,sn),ts=i(sn),ut=s(sn,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-11j7r65"&&(ut.textContent=Vs),sn.forEach(o),ns=i(c),te=s(c,"DIV",{class:!0});var an=d(te);f(Se.$$.fragment,an),ss=i(an),ht=s(an,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-9eocln"&&(ht.textContent=As),an.forEach(o),as=i(c),ne=s(c,"DIV",{class:!0});var on=d(ne);f(De.$$.fragment,on),is=i(on),_t=s(on,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-16q0ax1"&&(_t.textContent=Rs),on.forEach(o),os=i(c),se=s(c,"DIV",{class:!0});var ln=d(se);f(ke.$$.fragment,ln),ls=i(ln),bt=s(ln,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-1hybt25"&&(bt.textContent=zs),ln.forEach(o),rs=i(c),ae=s(c,"DIV",{class:!0});var rn=d(ae);f($e.$$.fragment,rn),ps=i(rn),Mt=s(rn,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1f1gk5j"&&(Mt.textContent=Ys),rn.forEach(o),ds=i(c),ie=s(c,"DIV",{class:!0});var pn=d(ie);f(Pe.$$.fragment,pn),cs=i(pn),wt=s(pn,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-1tqrrzw"&&(wt.textContent=Xs),pn.forEach(o),ms=i(c),oe=s(c,"DIV",{class:!0});var dn=d(oe);f(We.$$.fragment,dn),gs=i(dn),vt=s(dn,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-gczl07"&&(vt.textContent=Qs),dn.forEach(o),c.forEach(o),Wt=i(e),Z=s(e,"H2",{class:!0});var cn=d(Z);le=s(cn,"A",{id:!0,class:!0,href:!0});var ia=d(le);jt=s(ia,"SPAN",{});var oa=d(jt);f(Be.$$.fragment,oa),oa.forEach(o),ia.forEach(o),fs=i(cn),It=s(cn,"SPAN",{"data-svelte-h":!0}),m(It)!=="svelte-1ocdz42"&&(It.textContent=Hs),cn.forEach(o),Bt=i(e),S=s(e,"DIV",{class:!0});var mn=d(S);f(Ve.$$.fragment,mn),us=i(mn),yt=s(mn,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1qpjiuf"&&(yt.textContent=qs),mn.forEach(o),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",JSON.stringify(Ma)),r(v,"id","gligen-grounded-languagetoimage-generation"),r(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(v,"href","#gligen-grounded-languagetoimage-generation"),r(G,"class","relative group"),r($,"id","diffusers.StableDiffusionGLIGENPipeline"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#diffusers.StableDiffusionGLIGENPipeline"),r(E,"class","relative group"),r(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(Y,"id","diffusers.StableDiffusionGLIGENTextImagePipeline"),r(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Y,"href","#diffusers.StableDiffusionGLIGENTextImagePipeline"),r(C,"class","relative group"),r(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),r(le,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),r(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(le,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),r(Z,"class","relative group"),r(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,M){t(document.head,w),I(e,U,M),I(e,G,M),t(G,v),t(v,J),u(l,J,null),t(G,j),t(G,Re),I(e,Nt,M),I(e,re,M),I(e,Et,M),I(e,pe,M),I(e,Ct,M),I(e,de,M),I(e,Zt,M),u(k,e,M),I(e,St,M),I(e,ce,M),I(e,Dt,M),I(e,E,M),t(E,$),t($,xt),u(me,xt,null),t(E,fn),t(E,ze),I(e,kt,M),I(e,y,M),u(ge,y,null),t(y,un),t(y,Ye),t(y,hn),t(y,Xe),t(y,_n),t(y,L),u(fe,L,null),t(L,bn),t(L,Qe),t(L,Mn),u(P,L,null),t(y,wn),t(y,W),u(ue,W,null),t(W,vn),t(W,He),t(y,In),t(y,B),u(he,B,null),t(B,yn),t(B,qe),t(y,Tn),t(y,V),u(_e,V,null),t(V,Gn),t(V,Fe),t(y,xn),t(y,A),u(be,A,null),t(A,Jn),t(A,Oe),t(y,jn),t(y,R),u(Me,R,null),t(R,Un),t(R,Ke),t(y,Ln),t(y,et),u(we,et,null),t(y,Nn),t(y,tt),u(ve,tt,null),t(y,En),t(y,z),u(Ie,z,null),t(z,Cn),t(z,nt),I(e,$t,M),I(e,C,M),t(C,Y),t(Y,Jt),u(ye,Jt,null),t(C,Zn),t(C,st),I(e,Pt,M),I(e,p,M),u(Te,p,null),t(p,Sn),t(p,at),t(p,Dn),t(p,it),t(p,kn),t(p,N),u(Ge,N,null),t(N,$n),t(N,ot),t(N,Pn),u(X,N,null),t(p,Wn),t(p,Q),u(xe,Q,null),t(Q,Bn),t(Q,lt),t(p,Vn),t(p,H),u(Je,H,null),t(H,An),t(H,rt),t(p,Rn),t(p,q),u(je,q,null),t(q,zn),t(q,pt),t(p,Yn),t(p,F),u(Ue,F,null),t(F,Xn),t(F,dt),t(p,Qn),t(p,O),u(Le,O,null),t(O,Hn),t(O,ct),t(p,qn),t(p,mt),u(Ne,mt,null),t(p,Fn),t(p,gt),u(Ee,gt,null),t(p,On),t(p,K),u(Ce,K,null),t(K,Kn),t(K,ft),t(p,es),t(p,ee),u(Ze,ee,null),t(ee,ts),t(ee,ut),t(p,ns),t(p,te),u(Se,te,null),t(te,ss),t(te,ht),t(p,as),t(p,ne),u(De,ne,null),t(ne,is),t(ne,_t),t(p,os),t(p,se),u(ke,se,null),t(se,ls),t(se,bt),t(p,rs),t(p,ae),u($e,ae,null),t(ae,ps),t(ae,Mt),t(p,ds),t(p,ie),u(Pe,ie,null),t(ie,cs),t(ie,wt),t(p,ms),t(p,oe),u(We,oe,null),t(oe,gs),t(oe,vt),I(e,Wt,M),I(e,Z,M),t(Z,le),t(le,jt),u(Be,jt,null),t(Z,fs),t(Z,It),I(e,Bt,M),I(e,S,M),u(Ve,S,null),t(S,us),t(S,yt),Vt=!0},p(e,[M]){const Ae={};M&2&&(Ae.$$scope={dirty:M,ctx:e}),k.$set(Ae);const Ut={};M&2&&(Ut.$$scope={dirty:M,ctx:e}),P.$set(Ut);const Lt={};M&2&&(Lt.$$scope={dirty:M,ctx:e}),X.$set(Lt)},i(e){Vt||(h(l.$$.fragment,e),h(k.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(fe.$$.fragment,e),h(P.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(ve.$$.fragment,e),h(Ie.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(Ge.$$.fragment,e),h(X.$$.fragment,e),h(xe.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Le.$$.fragment,e),h(Ne.$$.fragment,e),h(Ee.$$.fragment,e),h(Ce.$$.fragment,e),h(Ze.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(ke.$$.fragment,e),h($e.$$.fragment,e),h(Pe.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),Vt=!0)},o(e){_(l.$$.fragment,e),_(k.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(fe.$$.fragment,e),_(P.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(Ie.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),_(Ge.$$.fragment,e),_(X.$$.fragment,e),_(xe.$$.fragment,e),_(Je.$$.fragment,e),_(je.$$.fragment,e),_(Ue.$$.fragment,e),_(Le.$$.fragment,e),_(Ne.$$.fragment,e),_(Ee.$$.fragment,e),_(Ce.$$.fragment,e),_(Ze.$$.fragment,e),_(Se.$$.fragment,e),_(De.$$.fragment,e),_(ke.$$.fragment,e),_($e.$$.fragment,e),_(Pe.$$.fragment,e),_(We.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),Vt=!1},d(e){e&&(o(U),o(G),o(Nt),o(re),o(Et),o(pe),o(Ct),o(de),o(Zt),o(St),o(ce),o(Dt),o(E),o(kt),o(y),o($t),o(C),o(Pt),o(p),o(Wt),o(Z),o(Bt),o(S)),o(w),b(l),b(k,e),b(me),b(ge),b(fe),b(P),b(ue),b(he),b(_e),b(be),b(Me),b(we),b(ve),b(Ie),b(ye),b(Te),b(Ge),b(X),b(xe),b(Je),b(je),b(Ue),b(Le),b(Ne),b(Ee),b(Ce),b(Ze),b(Se),b(De),b(ke),b($e),b(Pe),b(We),b(Be),b(Ve)}}}const Ma={local:"gligen-grounded-languagetoimage-generation",sections:[{local:"diffusers.StableDiffusionGLIGENPipeline",title:"StableDiffusionGLIGENPipeline"},{local:"diffusers.StableDiffusionGLIGENTextImagePipeline",title:"StableDiffusionGLIGENTextImagePipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"}],title:"GLIGEN (Grounded Language-to-Image Generation)"};function wa(D){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ja extends ca{constructor(w){super(),ma(this,w,wa,ba,pa,{})}}export{ja as component};
