import{s as Cs,o as Us,n as B}from"../chunks/scheduler.182ea377.js";import{S as Zs,i as Ws,g as s,s as i,p as g,A as Bs,h as a,f as l,c as r,j as T,q as h,m as f,k as x,v as t,a as m,r as _,d as b,t as v,u as y}from"../chunks/index.008d68e4.js";import{T as tn}from"../chunks/Tip.4f096367.js";import{D as J}from"../chunks/Docstring.7aec8b85.js";import{C as ot}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as nn}from"../chunks/IconCopyLink.96bbb92b.js";import{E as nt}from"../chunks/ExampleCodeBlock.23e54afe.js";function Gs(j){let o,I='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!';return{c(){o=s("p"),o.innerHTML=I},l(d){o=a(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1j961ct"&&(o.innerHTML=I)},m(d,c){m(d,o,c)},p:B,d(d){d&&l(o)}}}function Fs(j){let o,I="Examples:",d,c,M;return c=new ot({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkX29yX3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oZGV2aWNlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNzY4JTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyQyUyMHRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionImg2ImgPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function Ns(j){let o,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=s("p"),o.innerHTML=I},l(d){o=a(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-ackzsn"&&(o.innerHTML=I)},m(d,c){m(d,o,c)},p:B,d(d){d&&l(o)}}}function Ls(j){let o,I="Examples:",d,c,M;return c=new ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function Es(j){let o,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=s("p"),o.textContent=I},l(d){o=a(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-17p1lpg"&&(o.textContent=I)},m(d,c){m(d,o,c)},p:B,d(d){d&&l(o)}}}function zs(j){let o,I="Examples:",d,c,M;return c=new ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function Vs(j){let o,I="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",d,c,M;return c=new ot({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1gc783q"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function As(j){let o,I="locally:",d,c,M;return c=new ot({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-4c75kq"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function Xs(j){let o,I="Examples:",d,c,M;return c=new ot({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function Rs(j){let o,I="This API is 🧪 experimental.";return{c(){o=s("p"),o.textContent=I},l(d){o=a(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-89q1io"&&(o.textContent=I)},m(d,c){m(d,o,c)},p:B,d(d){d&&l(o)}}}function qs(j){let o,I="This API is 🧪 experimental.";return{c(){o=s("p"),o.textContent=I},l(d){o=a(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-89q1io"&&(o.textContent=I)},m(d,c){m(d,o,c)},p:B,d(d){d&&l(o)}}}function Ys(j){let o,I="Examples:",d,c,M;return c=new ot({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionImg2ImgPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)


<span class="hljs-meta">&gt;&gt;&gt; </span>rng = create_key(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_img = init_img.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;flax&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>rng = jax.random.split(rng, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids, processed_image = pipeline.prepare_inputs(
<span class="hljs-meta">... </span>    prompt=[prompts] * num_samples, image=[init_img] * num_samples
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>p_params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = shard(processed_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipeline(
<span class="hljs-meta">... </span>    prompt_ids=prompt_ids,
<span class="hljs-meta">... </span>    image=processed_image,
<span class="hljs-meta">... </span>    params=p_params,
<span class="hljs-meta">... </span>    prng_seed=rng,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.75</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    jit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = pipeline.numpy_to_pil(np.asarray(output.reshape((num_samples,) + output.shape[-<span class="hljs-number">3</span>:])))`}}),{c(){o=s("p"),o.textContent=I,d=i(),g(c.$$.fragment)},l(n){o=a(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=I),d=r(n),h(c.$$.fragment,n)},m(n,$){m(n,o,$),m(n,d,$),_(c,n,$),M=!0},p:B,i(n){M||(b(c.$$.fragment,n),M=!0)},o(n){v(c.$$.fragment,n),M=!1},d(n){n&&(l(o),l(d)),y(c,n)}}}function Hs(j){let o,I,d,c,M,n,$,st,Fo="Image-to-image",on,Ie,No="The Stable Diffusion model can also be applied to image-to-image generation by passing a text prompt and an initial image to condition the generation of new images.",sn,Me,Lo='The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> uses the diffusion-denoising mechanism proposed in <a href="https://huggingface.co/papers/2108.01073" rel="nofollow">SDEdit: Guided Image Synthesis and Editing with Stochastic Differential Equations</a> by Chenlin Meng, Yutong He, Yang Song, Jiaming Song, Jiajun Wu, Jun-Yan Zhu, Stefano Ermon.',an,Te,Eo="The abstract from the paper is:",rn,$e,zo="<em>Guided image synthesis enables everyday users to create and edit photo-realistic images with minimum effort. The key challenge is balancing faithfulness to the user input (e.g., hand-drawn colored strokes) and realism of the synthesized image. Existing GAN-based methods attempt to achieve such balance using either conditional GANs or GAN inversions, which are challenging and often require additional training data or loss functions for individual applications. To address these issues, we introduce a new image synthesis and editing method, Stochastic Differential Editing (SDEdit), based on a diffusion model generative prior, which synthesizes realistic images by iteratively denoising through a stochastic differential equation (SDE). Given an input image with user guide of any type, SDEdit first adds noise to the input, then subsequently denoises the resulting image through the SDE prior to increase its realism. SDEdit does not require task-specific training or inversions and can naturally achieve the balance between realism and faithfulness. SDEdit significantly outperforms state-of-the-art GAN-based methods by up to 98.09% on realism and 91.72% on overall satisfaction scores, according to a human perception study, on multiple tasks, including stroke-based image synthesis and editing as well as image compositing.</em>",ln,O,dn,X,K,Rt,je,jn,at,Vo="StableDiffusionImg2ImgPipeline",cn,u,Je,Jn,it,Ao="Pipeline for text-guided image-to-image generation using Stable Diffusion.",Sn,rt,Xo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,kn,lt,Ro="The pipeline also inherits the following loading methods:",Pn,dt,qo='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Dn,L,Se,Cn,ct,Yo="The call function to the pipeline for generation.",Un,ee,Zn,D,ke,Wn,pt,Ho=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Bn,te,Gn,ne,Fn,oe,Pe,Nn,ft,Qo=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Ln,C,De,En,mt,Oo=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,zn,se,Vn,ae,An,ie,Ce,Xn,ut,Ko='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Rn,S,Ue,qn,gt,es=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Yn,ht,ts="Example:",Hn,re,Qn,_t,ns=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,On,le,Kn,E,Ze,eo,bt,os=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,to,de,no,k,We,oo,vt,ss=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,so,yt,as="All kwargs are forwarded to <code>self.lora_state_dict</code>.",ao,wt,is='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',io,xt,rs=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,ro,It,ls=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,lo,ce,Be,co,Mt,ds="Save the LoRA parameters corresponding to the UNet and text encoder.",po,pe,Ge,fo,Tt,cs="Disables the FreeU mechanism if enabled.",mo,U,Fe,uo,$t,ps='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',go,jt,fs="The suffixes after the scaling factors represent the stages where they are being applied.",ho,Jt,ms=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,_o,fe,Ne,bo,St,us="Encodes the prompt into text encoder hidden states.",vo,z,Le,yo,kt,gs=`Enables fused QKV projections. For self-attention modules, all projection matrices (i.e., query,
key, value) are fused. For cross-attention modules, key and value projection matrices are fused.`,wo,me,xo,ue,Ee,Io,Pt,hs='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Mo,V,ze,To,Dt,_s="Disable QKV projection fusion if enabled.",$o,ge,pn,R,he,qt,Ve,jo,Ct,bs="StableDiffusionPipelineOutput",fn,q,Ae,Jo,Ut,vs="Output class for Stable Diffusion pipelines.",mn,Y,_e,Yt,Xe,So,Zt,ys="FlaxStableDiffusionImg2ImgPipeline",un,P,Re,ko,Wt,ws="Flax-based pipeline for text-guided image-to-image generation using Stable Diffusion.",Po,Bt,xs=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Do,A,qe,Co,Gt,Is="The call function to the pipeline for generation.",Uo,be,gn,H,ve,Ht,Ye,Zo,Ft,Ms="FlaxStableDiffusionPipelineOutput",hn,G,He,Wo,Nt,Ts="Output class for Flax-based Stable Diffusion pipelines.",Bo,ye,Qe,Go,Lt,$s="“Returns a new object replacing the specified fields with new values.",_n;return n=new nn({}),O=new tn({props:{$$slots:{default:[Gs]},$$scope:{ctx:j}}}),je=new nn({}),Je=new J({props:{name:"class diffusers.StableDiffusionImg2ImgPipeline",anchor:"diffusers.StableDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L158"}}),Se=new J({props:{name:"__call__",anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": Optional = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": Optional = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": Optional = 0.0"},{name:"generator",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L839",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ee=new nt({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[Fs]},$$scope:{ctx:j}}}),ke=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),te=new tn({props:{warning:!0,$$slots:{default:[Ns]},$$scope:{ctx:j}}}),ne=new nt({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[Ls]},$$scope:{ctx:j}}}),Pe=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),De=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),se=new tn({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:j}}}),ae=new nt({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[zs]},$$scope:{ctx:j}}}),Ce=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),Ue=new J({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),re=new nt({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.example",$$slots:{default:[Vs]},$$scope:{ctx:j}}}),le=new nt({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[As]},$$scope:{ctx:j}}}),Ze=new J({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L53"}}),de=new nt({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.example",$$slots:{default:[Xs]},$$scope:{ctx:j}}}),We=new J({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L82"}}),Be=new J({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L869"}}),Ge=new J({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L718"}}),Fe=new J({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L695"}}),Ne=new J({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L325"}}),Le=new J({props:{name:"fuse_qkv_projections",anchor:"diffusers.StableDiffusionImg2ImgPipeline.fuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.fuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.fuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L723"}}),me=new tn({props:{warning:!0,$$slots:{default:[Rs]},$$scope:{ctx:j}}}),Ee=new J({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L784",returnDescription:`
<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`
<p><code>torch.FloatTensor</code></p>
`}}),ze=new J({props:{name:"unfuse_qkv_projections",anchor:"diffusers.StableDiffusionImg2ImgPipeline.unfuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unfuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unfuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L755"}}),ge=new tn({props:{warning:!0,$$slots:{default:[qs]},$$scope:{ctx:j}}}),Ve=new nn({}),Ae=new J({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Xe=new nn({}),Re=new J({props:{name:"class diffusers.FlaxStableDiffusionImg2ImgPipeline",anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_img2img.py#L105"}}),qe=new J({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"noise",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.prompt_ids",description:`<strong>prompt_ids</strong> (<code>jnp.ndarray</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt_ids"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>jnp.ndarray</code>) &#x2014;
Array representing an image batch to be used as the starting point.`,name:"image"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.params",description:`<strong>params</strong> (<code>Dict</code> or <code>FrozenDict</code>) &#x2014;
Dictionary containing the model parameters/weights.`,name:"params"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.prng_seed",description:`<strong>prng_seed</strong> (<code>jax.Array</code> or <code>jax.Array</code>) &#x2014;
Array containing random number generator key.`,name:"prng_seed"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.noise",description:`<strong>noise</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. The array is generated by
sampling using the supplied random <code>generator</code>.`,name:"noise"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_img2img.py#L337",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),be=new nt({props:{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[Ys]},$$scope:{ctx:j}}}),Ye=new nn({}),He=new J({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Qe=new J({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L110"}}),{c(){o=s("meta"),I=i(),d=s("h1"),c=s("a"),M=s("span"),g(n.$$.fragment),$=i(),st=s("span"),st.textContent=Fo,on=i(),Ie=s("p"),Ie.textContent=No,sn=i(),Me=s("p"),Me.innerHTML=Lo,an=i(),Te=s("p"),Te.textContent=Eo,rn=i(),$e=s("p"),$e.innerHTML=zo,ln=i(),g(O.$$.fragment),dn=i(),X=s("h2"),K=s("a"),Rt=s("span"),g(je.$$.fragment),jn=i(),at=s("span"),at.textContent=Vo,cn=i(),u=s("div"),g(Je.$$.fragment),Jn=i(),it=s("p"),it.textContent=Ao,Sn=i(),rt=s("p"),rt.innerHTML=Xo,kn=i(),lt=s("p"),lt.textContent=Ro,Pn=i(),dt=s("ul"),dt.innerHTML=qo,Dn=i(),L=s("div"),g(Se.$$.fragment),Cn=i(),ct=s("p"),ct.textContent=Yo,Un=i(),g(ee.$$.fragment),Zn=i(),D=s("div"),g(ke.$$.fragment),Wn=i(),pt=s("p"),pt.textContent=Ho,Bn=i(),g(te.$$.fragment),Gn=i(),g(ne.$$.fragment),Fn=i(),oe=s("div"),g(Pe.$$.fragment),Nn=i(),ft=s("p"),ft.innerHTML=Qo,Ln=i(),C=s("div"),g(De.$$.fragment),En=i(),mt=s("p"),mt.innerHTML=Oo,zn=i(),g(se.$$.fragment),Vn=i(),g(ae.$$.fragment),An=i(),ie=s("div"),g(Ce.$$.fragment),Xn=i(),ut=s("p"),ut.innerHTML=Ko,Rn=i(),S=s("div"),g(Ue.$$.fragment),qn=i(),gt=s("p"),gt.innerHTML=es,Yn=i(),ht=s("p"),ht.textContent=ts,Hn=i(),g(re.$$.fragment),Qn=i(),_t=s("p"),_t.innerHTML=ns,On=i(),g(le.$$.fragment),Kn=i(),E=s("div"),g(Ze.$$.fragment),eo=i(),bt=s("p"),bt.innerHTML=os,to=i(),g(de.$$.fragment),no=i(),k=s("div"),g(We.$$.fragment),oo=i(),vt=s("p"),vt.innerHTML=ss,so=i(),yt=s("p"),yt.innerHTML=as,ao=i(),wt=s("p"),wt.innerHTML=is,io=i(),xt=s("p"),xt.innerHTML=rs,ro=i(),It=s("p"),It.innerHTML=ls,lo=i(),ce=s("div"),g(Be.$$.fragment),co=i(),Mt=s("p"),Mt.textContent=ds,po=i(),pe=s("div"),g(Ge.$$.fragment),fo=i(),Tt=s("p"),Tt.textContent=cs,mo=i(),U=s("div"),g(Fe.$$.fragment),uo=i(),$t=s("p"),$t.innerHTML=ps,go=i(),jt=s("p"),jt.textContent=fs,ho=i(),Jt=s("p"),Jt.innerHTML=ms,_o=i(),fe=s("div"),g(Ne.$$.fragment),bo=i(),St=s("p"),St.textContent=us,vo=i(),z=s("div"),g(Le.$$.fragment),yo=i(),kt=s("p"),kt.textContent=gs,wo=i(),g(me.$$.fragment),xo=i(),ue=s("div"),g(Ee.$$.fragment),Io=i(),Pt=s("p"),Pt.innerHTML=hs,Mo=i(),V=s("div"),g(ze.$$.fragment),To=i(),Dt=s("p"),Dt.textContent=_s,$o=i(),g(ge.$$.fragment),pn=i(),R=s("h2"),he=s("a"),qt=s("span"),g(Ve.$$.fragment),jo=i(),Ct=s("span"),Ct.textContent=bs,fn=i(),q=s("div"),g(Ae.$$.fragment),Jo=i(),Ut=s("p"),Ut.textContent=vs,mn=i(),Y=s("h2"),_e=s("a"),Yt=s("span"),g(Xe.$$.fragment),So=i(),Zt=s("span"),Zt.textContent=ys,un=i(),P=s("div"),g(Re.$$.fragment),ko=i(),Wt=s("p"),Wt.textContent=ws,Po=i(),Bt=s("p"),Bt.innerHTML=xs,Do=i(),A=s("div"),g(qe.$$.fragment),Co=i(),Gt=s("p"),Gt.textContent=Is,Uo=i(),g(be.$$.fragment),gn=i(),H=s("h2"),ve=s("a"),Ht=s("span"),g(Ye.$$.fragment),Zo=i(),Ft=s("span"),Ft.textContent=Ms,hn=i(),G=s("div"),g(He.$$.fragment),Wo=i(),Nt=s("p"),Nt.textContent=Ts,Bo=i(),ye=s("div"),g(Qe.$$.fragment),Go=i(),Lt=s("p"),Lt.textContent=$s,this.h()},l(e){const p=Bs("svelte-1phssyn",document.head);o=a(p,"META",{name:!0,content:!0}),p.forEach(l),I=r(e),d=a(e,"H1",{class:!0});var Oe=T(d);c=a(Oe,"A",{id:!0,class:!0,href:!0});var Qt=T(c);M=a(Qt,"SPAN",{});var Ot=T(M);h(n.$$.fragment,Ot),Ot.forEach(l),Qt.forEach(l),$=r(Oe),st=a(Oe,"SPAN",{"data-svelte-h":!0}),f(st)!=="svelte-1r5u1a2"&&(st.textContent=Fo),Oe.forEach(l),on=r(e),Ie=a(e,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1wz97a4"&&(Ie.textContent=No),sn=r(e),Me=a(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1ju27vr"&&(Me.innerHTML=Lo),an=r(e),Te=a(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-1cwsb16"&&(Te.textContent=Eo),rn=r(e),$e=a(e,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1nbpwa2"&&($e.innerHTML=zo),ln=r(e),h(O.$$.fragment,e),dn=r(e),X=a(e,"H2",{class:!0});var Ke=T(X);K=a(Ke,"A",{id:!0,class:!0,href:!0});var Kt=T(K);Rt=a(Kt,"SPAN",{});var en=T(Rt);h(je.$$.fragment,en),en.forEach(l),Kt.forEach(l),jn=r(Ke),at=a(Ke,"SPAN",{"data-svelte-h":!0}),f(at)!=="svelte-ihxf6j"&&(at.textContent=Vo),Ke.forEach(l),cn=r(e),u=a(e,"DIV",{class:!0});var w=T(u);h(Je.$$.fragment,w),Jn=r(w),it=a(w,"P",{"data-svelte-h":!0}),f(it)!=="svelte-1n95u1g"&&(it.textContent=Ao),Sn=r(w),rt=a(w,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-496sm0"&&(rt.innerHTML=Xo),kn=r(w),lt=a(w,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-14s6m4u"&&(lt.textContent=Ro),Pn=r(w),dt=a(w,"UL",{"data-svelte-h":!0}),f(dt)!=="svelte-1ak2zof"&&(dt.innerHTML=qo),Dn=r(w),L=a(w,"DIV",{class:!0});var Q=T(L);h(Se.$$.fragment,Q),Cn=r(Q),ct=a(Q,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-50j04k"&&(ct.textContent=Yo),Un=r(Q),h(ee.$$.fragment,Q),Q.forEach(l),Zn=r(w),D=a(w,"DIV",{class:!0});var F=T(D);h(ke.$$.fragment,F),Wn=r(F),pt=a(F,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-10jaql7"&&(pt.textContent=Ho),Bn=r(F),h(te.$$.fragment,F),Gn=r(F),h(ne.$$.fragment,F),F.forEach(l),Fn=r(w),oe=a(w,"DIV",{class:!0});var et=T(oe);h(Pe.$$.fragment,et),Nn=r(et),ft=a(et,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-1lh0nh5"&&(ft.innerHTML=Qo),et.forEach(l),Ln=r(w),C=a(w,"DIV",{class:!0});var N=T(C);h(De.$$.fragment,N),En=r(N),mt=a(N,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-e03q3e"&&(mt.innerHTML=Oo),zn=r(N),h(se.$$.fragment,N),Vn=r(N),h(ae.$$.fragment,N),N.forEach(l),An=r(w),ie=a(w,"DIV",{class:!0});var tt=T(ie);h(Ce.$$.fragment,tt),Xn=r(tt),ut=a(tt,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-1vfte1e"&&(ut.innerHTML=Ko),tt.forEach(l),Rn=r(w),S=a(w,"DIV",{class:!0});var Z=T(S);h(Ue.$$.fragment,Z),qn=r(Z),gt=a(Z,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-1lv88wo"&&(gt.innerHTML=es),Yn=r(Z),ht=a(Z,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-11lpom8"&&(ht.textContent=ts),Hn=r(Z),h(re.$$.fragment,Z),Qn=r(Z),_t=a(Z,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-15d7mv5"&&(_t.innerHTML=ns),On=r(Z),h(le.$$.fragment,Z),Z.forEach(l),Kn=r(w),E=a(w,"DIV",{class:!0});var Et=T(E);h(Ze.$$.fragment,Et),eo=r(Et),bt=a(Et,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-pmqrln"&&(bt.innerHTML=os),to=r(Et),h(de.$$.fragment,Et),Et.forEach(l),no=r(w),k=a(w,"DIV",{class:!0});var W=T(k);h(We.$$.fragment,W),oo=r(W),vt=a(W,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-vs7s0z"&&(vt.innerHTML=ss),so=r(W),yt=a(W,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-15b960v"&&(yt.innerHTML=as),ao=r(W),wt=a(W,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-12uyc98"&&(wt.innerHTML=is),io=r(W),xt=a(W,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-1q3yzk7"&&(xt.innerHTML=rs),ro=r(W),It=a(W,"P",{"data-svelte-h":!0}),f(It)!=="svelte-10xxjud"&&(It.innerHTML=ls),W.forEach(l),lo=r(w),ce=a(w,"DIV",{class:!0});var bn=T(ce);h(Be.$$.fragment,bn),co=r(bn),Mt=a(bn,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-1ufq5ot"&&(Mt.textContent=ds),bn.forEach(l),po=r(w),pe=a(w,"DIV",{class:!0});var vn=T(pe);h(Ge.$$.fragment,vn),fo=r(vn),Tt=a(vn,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-psupw6"&&(Tt.textContent=cs),vn.forEach(l),mo=r(w),U=a(w,"DIV",{class:!0});var we=T(U);h(Fe.$$.fragment,we),uo=r(we),$t=a(we,"P",{"data-svelte-h":!0}),f($t)!=="svelte-1f3tmq1"&&($t.innerHTML=ps),go=r(we),jt=a(we,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-xjijlp"&&(jt.textContent=fs),ho=r(we),Jt=a(we,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-hy0nzs"&&(Jt.innerHTML=ms),we.forEach(l),_o=r(w),fe=a(w,"DIV",{class:!0});var yn=T(fe);h(Ne.$$.fragment,yn),bo=r(yn),St=a(yn,"P",{"data-svelte-h":!0}),f(St)!=="svelte-16q0ax1"&&(St.textContent=us),yn.forEach(l),vo=r(w),z=a(w,"DIV",{class:!0});var zt=T(z);h(Le.$$.fragment,zt),yo=r(zt),kt=a(zt,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-le0q9u"&&(kt.textContent=gs),wo=r(zt),h(me.$$.fragment,zt),zt.forEach(l),xo=r(w),ue=a(w,"DIV",{class:!0});var wn=T(ue);h(Ee.$$.fragment,wn),Io=r(wn),Pt=a(wn,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-vo59ec"&&(Pt.innerHTML=hs),wn.forEach(l),Mo=r(w),V=a(w,"DIV",{class:!0});var Vt=T(V);h(ze.$$.fragment,Vt),To=r(Vt),Dt=a(Vt,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-fohozp"&&(Dt.textContent=_s),$o=r(Vt),h(ge.$$.fragment,Vt),Vt.forEach(l),w.forEach(l),pn=r(e),R=a(e,"H2",{class:!0});var xn=T(R);he=a(xn,"A",{id:!0,class:!0,href:!0});var js=T(he);qt=a(js,"SPAN",{});var Js=T(qt);h(Ve.$$.fragment,Js),Js.forEach(l),js.forEach(l),jo=r(xn),Ct=a(xn,"SPAN",{"data-svelte-h":!0}),f(Ct)!=="svelte-1ocdz42"&&(Ct.textContent=bs),xn.forEach(l),fn=r(e),q=a(e,"DIV",{class:!0});var In=T(q);h(Ae.$$.fragment,In),Jo=r(In),Ut=a(In,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-1qpjiuf"&&(Ut.textContent=vs),In.forEach(l),mn=r(e),Y=a(e,"H2",{class:!0});var Mn=T(Y);_e=a(Mn,"A",{id:!0,class:!0,href:!0});var Ss=T(_e);Yt=a(Ss,"SPAN",{});var ks=T(Yt);h(Xe.$$.fragment,ks),ks.forEach(l),Ss.forEach(l),So=r(Mn),Zt=a(Mn,"SPAN",{"data-svelte-h":!0}),f(Zt)!=="svelte-1fnyr0q"&&(Zt.textContent=ys),Mn.forEach(l),un=r(e),P=a(e,"DIV",{class:!0});var xe=T(P);h(Re.$$.fragment,xe),ko=r(xe),Wt=a(xe,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-at7ys7"&&(Wt.textContent=ws),Po=r(xe),Bt=a(xe,"P",{"data-svelte-h":!0}),f(Bt)!=="svelte-knddhk"&&(Bt.innerHTML=xs),Do=r(xe),A=a(xe,"DIV",{class:!0});var At=T(A);h(qe.$$.fragment,At),Co=r(At),Gt=a(At,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-50j04k"&&(Gt.textContent=Is),Uo=r(At),h(be.$$.fragment,At),At.forEach(l),xe.forEach(l),gn=r(e),H=a(e,"H2",{class:!0});var Tn=T(H);ve=a(Tn,"A",{id:!0,class:!0,href:!0});var Ps=T(ve);Ht=a(Ps,"SPAN",{});var Ds=T(Ht);h(Ye.$$.fragment,Ds),Ds.forEach(l),Ps.forEach(l),Zo=r(Tn),Ft=a(Tn,"SPAN",{"data-svelte-h":!0}),f(Ft)!=="svelte-1yazx8z"&&(Ft.textContent=Ms),Tn.forEach(l),hn=r(e),G=a(e,"DIV",{class:!0});var Xt=T(G);h(He.$$.fragment,Xt),Wo=r(Xt),Nt=a(Xt,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-wzv2jc"&&(Nt.textContent=Ts),Bo=r(Xt),ye=a(Xt,"DIV",{class:!0});var $n=T(ye);h(Qe.$$.fragment,$n),Go=r($n),Lt=a($n,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-5ihtpa"&&(Lt.textContent=$s),$n.forEach(l),Xt.forEach(l),this.h()},h(){x(o,"name","hf:doc:metadata"),x(o,"content",JSON.stringify(Qs)),x(c,"id","imagetoimage"),x(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),x(c,"href","#imagetoimage"),x(d,"class","relative group"),x(K,"id","diffusers.StableDiffusionImg2ImgPipeline"),x(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),x(K,"href","#diffusers.StableDiffusionImg2ImgPipeline"),x(X,"class","relative group"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(he,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),x(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),x(he,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),x(R,"class","relative group"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_e,"id","diffusers.FlaxStableDiffusionImg2ImgPipeline"),x(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),x(_e,"href","#diffusers.FlaxStableDiffusionImg2ImgPipeline"),x(Y,"class","relative group"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ve,"id","diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"),x(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),x(ve,"href","#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"),x(H,"class","relative group"),x(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,o),m(e,I,p),m(e,d,p),t(d,c),t(c,M),_(n,M,null),t(d,$),t(d,st),m(e,on,p),m(e,Ie,p),m(e,sn,p),m(e,Me,p),m(e,an,p),m(e,Te,p),m(e,rn,p),m(e,$e,p),m(e,ln,p),_(O,e,p),m(e,dn,p),m(e,X,p),t(X,K),t(K,Rt),_(je,Rt,null),t(X,jn),t(X,at),m(e,cn,p),m(e,u,p),_(Je,u,null),t(u,Jn),t(u,it),t(u,Sn),t(u,rt),t(u,kn),t(u,lt),t(u,Pn),t(u,dt),t(u,Dn),t(u,L),_(Se,L,null),t(L,Cn),t(L,ct),t(L,Un),_(ee,L,null),t(u,Zn),t(u,D),_(ke,D,null),t(D,Wn),t(D,pt),t(D,Bn),_(te,D,null),t(D,Gn),_(ne,D,null),t(u,Fn),t(u,oe),_(Pe,oe,null),t(oe,Nn),t(oe,ft),t(u,Ln),t(u,C),_(De,C,null),t(C,En),t(C,mt),t(C,zn),_(se,C,null),t(C,Vn),_(ae,C,null),t(u,An),t(u,ie),_(Ce,ie,null),t(ie,Xn),t(ie,ut),t(u,Rn),t(u,S),_(Ue,S,null),t(S,qn),t(S,gt),t(S,Yn),t(S,ht),t(S,Hn),_(re,S,null),t(S,Qn),t(S,_t),t(S,On),_(le,S,null),t(u,Kn),t(u,E),_(Ze,E,null),t(E,eo),t(E,bt),t(E,to),_(de,E,null),t(u,no),t(u,k),_(We,k,null),t(k,oo),t(k,vt),t(k,so),t(k,yt),t(k,ao),t(k,wt),t(k,io),t(k,xt),t(k,ro),t(k,It),t(u,lo),t(u,ce),_(Be,ce,null),t(ce,co),t(ce,Mt),t(u,po),t(u,pe),_(Ge,pe,null),t(pe,fo),t(pe,Tt),t(u,mo),t(u,U),_(Fe,U,null),t(U,uo),t(U,$t),t(U,go),t(U,jt),t(U,ho),t(U,Jt),t(u,_o),t(u,fe),_(Ne,fe,null),t(fe,bo),t(fe,St),t(u,vo),t(u,z),_(Le,z,null),t(z,yo),t(z,kt),t(z,wo),_(me,z,null),t(u,xo),t(u,ue),_(Ee,ue,null),t(ue,Io),t(ue,Pt),t(u,Mo),t(u,V),_(ze,V,null),t(V,To),t(V,Dt),t(V,$o),_(ge,V,null),m(e,pn,p),m(e,R,p),t(R,he),t(he,qt),_(Ve,qt,null),t(R,jo),t(R,Ct),m(e,fn,p),m(e,q,p),_(Ae,q,null),t(q,Jo),t(q,Ut),m(e,mn,p),m(e,Y,p),t(Y,_e),t(_e,Yt),_(Xe,Yt,null),t(Y,So),t(Y,Zt),m(e,un,p),m(e,P,p),_(Re,P,null),t(P,ko),t(P,Wt),t(P,Po),t(P,Bt),t(P,Do),t(P,A),_(qe,A,null),t(A,Co),t(A,Gt),t(A,Uo),_(be,A,null),m(e,gn,p),m(e,H,p),t(H,ve),t(ve,Ht),_(Ye,Ht,null),t(H,Zo),t(H,Ft),m(e,hn,p),m(e,G,p),_(He,G,null),t(G,Wo),t(G,Nt),t(G,Bo),t(G,ye),_(Qe,ye,null),t(ye,Go),t(ye,Lt),_n=!0},p(e,[p]){const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),O.$set(Oe);const Qt={};p&2&&(Qt.$$scope={dirty:p,ctx:e}),ee.$set(Qt);const Ot={};p&2&&(Ot.$$scope={dirty:p,ctx:e}),te.$set(Ot);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:e}),ne.$set(Ke);const Kt={};p&2&&(Kt.$$scope={dirty:p,ctx:e}),se.$set(Kt);const en={};p&2&&(en.$$scope={dirty:p,ctx:e}),ae.$set(en);const w={};p&2&&(w.$$scope={dirty:p,ctx:e}),re.$set(w);const Q={};p&2&&(Q.$$scope={dirty:p,ctx:e}),le.$set(Q);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),de.$set(F);const et={};p&2&&(et.$$scope={dirty:p,ctx:e}),me.$set(et);const N={};p&2&&(N.$$scope={dirty:p,ctx:e}),ge.$set(N);const tt={};p&2&&(tt.$$scope={dirty:p,ctx:e}),be.$set(tt)},i(e){_n||(b(n.$$.fragment,e),b(O.$$.fragment,e),b(je.$$.fragment,e),b(Je.$$.fragment,e),b(Se.$$.fragment,e),b(ee.$$.fragment,e),b(ke.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(Pe.$$.fragment,e),b(De.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(Ce.$$.fragment,e),b(Ue.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(Ze.$$.fragment,e),b(de.$$.fragment,e),b(We.$$.fragment,e),b(Be.$$.fragment,e),b(Ge.$$.fragment,e),b(Fe.$$.fragment,e),b(Ne.$$.fragment,e),b(Le.$$.fragment,e),b(me.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(ge.$$.fragment,e),b(Ve.$$.fragment,e),b(Ae.$$.fragment,e),b(Xe.$$.fragment,e),b(Re.$$.fragment,e),b(qe.$$.fragment,e),b(be.$$.fragment,e),b(Ye.$$.fragment,e),b(He.$$.fragment,e),b(Qe.$$.fragment,e),_n=!0)},o(e){v(n.$$.fragment,e),v(O.$$.fragment,e),v(je.$$.fragment,e),v(Je.$$.fragment,e),v(Se.$$.fragment,e),v(ee.$$.fragment,e),v(ke.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(Pe.$$.fragment,e),v(De.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(Ce.$$.fragment,e),v(Ue.$$.fragment,e),v(re.$$.fragment,e),v(le.$$.fragment,e),v(Ze.$$.fragment,e),v(de.$$.fragment,e),v(We.$$.fragment,e),v(Be.$$.fragment,e),v(Ge.$$.fragment,e),v(Fe.$$.fragment,e),v(Ne.$$.fragment,e),v(Le.$$.fragment,e),v(me.$$.fragment,e),v(Ee.$$.fragment,e),v(ze.$$.fragment,e),v(ge.$$.fragment,e),v(Ve.$$.fragment,e),v(Ae.$$.fragment,e),v(Xe.$$.fragment,e),v(Re.$$.fragment,e),v(qe.$$.fragment,e),v(be.$$.fragment,e),v(Ye.$$.fragment,e),v(He.$$.fragment,e),v(Qe.$$.fragment,e),_n=!1},d(e){e&&(l(I),l(d),l(on),l(Ie),l(sn),l(Me),l(an),l(Te),l(rn),l($e),l(ln),l(dn),l(X),l(cn),l(u),l(pn),l(R),l(fn),l(q),l(mn),l(Y),l(un),l(P),l(gn),l(H),l(hn),l(G)),l(o),y(n),y(O,e),y(je),y(Je),y(Se),y(ee),y(ke),y(te),y(ne),y(Pe),y(De),y(se),y(ae),y(Ce),y(Ue),y(re),y(le),y(Ze),y(de),y(We),y(Be),y(Ge),y(Fe),y(Ne),y(Le),y(me),y(Ee),y(ze),y(ge),y(Ve),y(Ae),y(Xe),y(Re),y(qe),y(be),y(Ye),y(He),y(Qe)}}}const Qs={local:"imagetoimage",sections:[{local:"diffusers.StableDiffusionImg2ImgPipeline",title:"StableDiffusionImg2ImgPipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"},{local:"diffusers.FlaxStableDiffusionImg2ImgPipeline",title:"FlaxStableDiffusionImg2ImgPipeline"},{local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",title:"FlaxStableDiffusionPipelineOutput"}],title:"Image-to-image"};function Os(j){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ia extends Zs{constructor(o){super(),Ws(this,o,Os,Hs,Cs,{})}}export{ia as component};
