import{s as xe,n as De,o as $e}from"../chunks/scheduler.182ea377.js";import{S as Se,i as Ee,g as a,s as o,r as g,A as Te,h as d,f as t,c as i,j as k,u as _,x as F,k as P,y as r,a as c,v as b,d as v,t as x,w as D}from"../chunks/index.abf12888.js";import{D as U}from"../chunks/Docstring.93f6f462.js";import{H as ue}from"../chunks/Heading.16916d63.js";function ye(pe){let u,K,A,R,$,W,S,fe='The Euler scheduler (Algorithm 2) is from the <a href="https://huggingface.co/papers/2206.00364" rel="nofollow">Elucidating the Design Space of Diffusion-Based Generative Models</a> paper by Karras et al. This is a fast scheduler which can often generate good outputs in 20-30 steps. The scheduler is based on the original <a href="https://github.com/crowsonkb/k-diffusion/blob/481677d114f6ea445aa009cf5bd7a9cdee909e47/k_diffusion/sampling.py#L51" rel="nofollow">k-diffusion</a> implementation by <a href="https://github.com/crowsonkb/" rel="nofollow">Katherine Crowson</a>.',G,E,j,n,T,se,q,me="Euler scheduler.",re,M,he=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/v0.26.0/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,ne,f,y,oe,z,ge=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep. Scales the denoising model input by <code>(sigma**2 + 1) ** 0.5</code> to match the Euler algorithm.`,ie,m,w,ae,H,_e="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",de,h,C,ce,I,be=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).`,B,O,Y,p,L,le,N,ve="Output class for the scheduler’s <code>step</code> function output.",J,V,Q;return $=new ue({props:{title:"EulerDiscreteScheduler",local:"eulerdiscretescheduler",headingTag:"h1"}}),E=new ue({props:{title:"EulerDiscreteScheduler",local:"diffusers.EulerDiscreteScheduler",headingTag:"h2"}}),T=new U({props:{name:"class diffusers.EulerDiscreteScheduler",anchor:"diffusers.EulerDiscreteScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": Union = None"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"interpolation_type",val:": str = 'linear'"},{name:"use_karras_sigmas",val:": Optional = False"},{name:"sigma_min",val:": Optional = None"},{name:"sigma_max",val:": Optional = None"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"timestep_type",val:": str = 'discrete'"},{name:"steps_offset",val:": int = 0"},{name:"rescale_betas_zero_snr",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.EulerDiscreteScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.EulerDiscreteScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.EulerDiscreteScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code> or <code>scaled_linear</code>.`,name:"beta_schedule"},{anchor:"diffusers.EulerDiscreteScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.EulerDiscreteScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.EulerDiscreteScheduler.interpolation_type(str,",description:`<strong>interpolation_type(<code>str</code>,</strong> defaults to <code>&quot;linear&quot;</code>, <em>optional</em>) &#x2014;
The interpolation type to compute intermediate sigmas for the scheduler denoising steps. Should be on of
<code>&quot;linear&quot;</code> or <code>&quot;log_linear&quot;</code>.`,name:"interpolation_type(str,"},{anchor:"diffusers.EulerDiscreteScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.EulerDiscreteScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.EulerDiscreteScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps. You can use a combination of <code>offset=1</code> and
<code>set_alpha_to_one=False</code> to make the last step use step 0 for the previous alpha product like in Stable
Diffusion.`,name:"steps_offset"},{anchor:"diffusers.EulerDiscreteScheduler.rescale_betas_zero_snr",description:`<strong>rescale_betas_zero_snr</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
dark samples instead of limiting it to samples with medium brightness. Loosely related to
<a href="https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506" rel="nofollow"><code>--offset_noise</code></a>.`,name:"rescale_betas_zero_snr"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/schedulers/scheduling_euler_discrete.py#L132"}}),y=new U({props:{name:"scale_model_input",anchor:"diffusers.EulerDiscreteScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": Union"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"},{anchor:"diffusers.EulerDiscreteScheduler.scale_model_input.timestep",description:`<strong>timestep</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The current timestep in the diffusion chain.`,name:"timestep"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/schedulers/scheduling_euler_discrete.py#L258",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),w=new U({props:{name:"set_timesteps",anchor:"diffusers.EulerDiscreteScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int"},{name:"device",val:": Union = None"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.EulerDiscreteScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/schedulers/scheduling_euler_discrete.py#L284"}}),C=new U({props:{name:"step",anchor:"diffusers.EulerDiscreteScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": Union"},{name:"sample",val:": FloatTensor"},{name:"s_churn",val:": float = 0.0"},{name:"s_tmin",val:": float = 0.0"},{name:"s_tmax",val:": float = inf"},{name:"s_noise",val:": float = 1.0"},{name:"generator",val:": Optional = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.EulerDiscreteScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.EulerDiscreteScheduler.step.timestep",description:`<strong>timestep</strong> (<code>float</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.EulerDiscreteScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_churn",description:"<strong>s_churn</strong> (<code>float</code>) &#x2014;",name:"s_churn"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_tmin",description:"<strong>s_tmin</strong>  (<code>float</code>) &#x2014;",name:"s_tmin"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_tmax",description:"<strong>s_tmax</strong>  (<code>float</code>) &#x2014;",name:"s_tmax"},{anchor:"diffusers.EulerDiscreteScheduler.step.s_noise",description:`<strong>s_noise</strong> (<code>float</code>, defaults to 1.0) &#x2014;
Scaling factor for noise added to the sample.`,name:"s_noise"},{anchor:"diffusers.EulerDiscreteScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator.`,name:"generator"},{anchor:"diffusers.EulerDiscreteScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/schedulers/euler#diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput">EulerDiscreteSchedulerOutput</a> or
tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/schedulers/scheduling_euler_discrete.py#L413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/v0.26.0/en/api/schedulers/euler#diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput"
>EulerDiscreteSchedulerOutput</a> is
returned, otherwise a tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/schedulers/euler#diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput"
>EulerDiscreteSchedulerOutput</a> or <code>tuple</code></p>
`}}),O=new ue({props:{title:"EulerDiscreteSchedulerOutput",local:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput",headingTag:"h2"}}),L=new U({props:{name:"class diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput",anchor:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"},{name:"pred_original_sample",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"},{anchor:"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput.pred_original_sample",description:`<strong>pred_original_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
The predicted denoised sample <code>(x_{0})</code> based on the model output from the current timestep.
<code>pred_original_sample</code> can be used to preview progress or for guidance.`,name:"pred_original_sample"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/schedulers/scheduling_euler_discrete.py#L31"}}),{c(){u=a("meta"),K=o(),A=a("p"),R=o(),g($.$$.fragment),W=o(),S=a("p"),S.innerHTML=fe,G=o(),g(E.$$.fragment),j=o(),n=a("div"),g(T.$$.fragment),se=o(),q=a("p"),q.textContent=me,re=o(),M=a("p"),M.innerHTML=he,ne=o(),f=a("div"),g(y.$$.fragment),oe=o(),z=a("p"),z.innerHTML=ge,ie=o(),m=a("div"),g(w.$$.fragment),ae=o(),H=a("p"),H.textContent=_e,de=o(),h=a("div"),g(C.$$.fragment),ce=o(),I=a("p"),I.textContent=be,B=o(),g(O.$$.fragment),Y=o(),p=a("div"),g(L.$$.fragment),le=o(),N=a("p"),N.innerHTML=ve,J=o(),V=a("p"),this.h()},l(e){const s=Te("svelte-u9bgzb",document.head);u=d(s,"META",{name:!0,content:!0}),s.forEach(t),K=i(e),A=d(e,"P",{}),k(A).forEach(t),R=i(e),_($.$$.fragment,e),W=i(e),S=d(e,"P",{"data-svelte-h":!0}),F(S)!=="svelte-1gv4s4b"&&(S.innerHTML=fe),G=i(e),_(E.$$.fragment,e),j=i(e),n=d(e,"DIV",{class:!0});var l=k(n);_(T.$$.fragment,l),se=i(l),q=d(l,"P",{"data-svelte-h":!0}),F(q)!=="svelte-rqsn3u"&&(q.textContent=me),re=i(l),M=d(l,"P",{"data-svelte-h":!0}),F(M)!=="svelte-9uikl1"&&(M.innerHTML=he),ne=i(l),f=d(l,"DIV",{class:!0});var X=k(f);_(y.$$.fragment,X),oe=i(X),z=d(X,"P",{"data-svelte-h":!0}),F(z)!=="svelte-1hew89w"&&(z.innerHTML=ge),X.forEach(t),ie=i(l),m=d(l,"DIV",{class:!0});var Z=k(m);_(w.$$.fragment,Z),ae=i(Z),H=d(Z,"P",{"data-svelte-h":!0}),F(H)!=="svelte-1vzm9q"&&(H.textContent=_e),Z.forEach(t),de=i(l),h=d(l,"DIV",{class:!0});var ee=k(h);_(C.$$.fragment,ee),ce=i(ee),I=d(ee,"P",{"data-svelte-h":!0}),F(I)!=="svelte-hi84tp"&&(I.textContent=be),ee.forEach(t),l.forEach(t),B=i(e),_(O.$$.fragment,e),Y=i(e),p=d(e,"DIV",{class:!0});var te=k(p);_(L.$$.fragment,te),le=i(te),N=d(te,"P",{"data-svelte-h":!0}),F(N)!=="svelte-id9kic"&&(N.innerHTML=ve),te.forEach(t),J=i(e),V=d(e,"P",{}),k(V).forEach(t),this.h()},h(){P(u,"name","hf:doc:metadata"),P(u,"content",we),P(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){r(document.head,u),c(e,K,s),c(e,A,s),c(e,R,s),b($,e,s),c(e,W,s),c(e,S,s),c(e,G,s),b(E,e,s),c(e,j,s),c(e,n,s),b(T,n,null),r(n,se),r(n,q),r(n,re),r(n,M),r(n,ne),r(n,f),b(y,f,null),r(f,oe),r(f,z),r(n,ie),r(n,m),b(w,m,null),r(m,ae),r(m,H),r(n,de),r(n,h),b(C,h,null),r(h,ce),r(h,I),c(e,B,s),b(O,e,s),c(e,Y,s),c(e,p,s),b(L,p,null),r(p,le),r(p,N),c(e,J,s),c(e,V,s),Q=!0},p:De,i(e){Q||(v($.$$.fragment,e),v(E.$$.fragment,e),v(T.$$.fragment,e),v(y.$$.fragment,e),v(w.$$.fragment,e),v(C.$$.fragment,e),v(O.$$.fragment,e),v(L.$$.fragment,e),Q=!0)},o(e){x($.$$.fragment,e),x(E.$$.fragment,e),x(T.$$.fragment,e),x(y.$$.fragment,e),x(w.$$.fragment,e),x(C.$$.fragment,e),x(O.$$.fragment,e),x(L.$$.fragment,e),Q=!1},d(e){e&&(t(K),t(A),t(R),t(W),t(S),t(G),t(j),t(n),t(B),t(Y),t(p),t(J),t(V)),t(u),D($,e),D(E,e),D(T),D(y),D(w),D(C),D(O,e),D(L)}}}const we='{"title":"EulerDiscreteScheduler","local":"eulerdiscretescheduler","sections":[{"title":"EulerDiscreteScheduler","local":"diffusers.EulerDiscreteScheduler","sections":[],"depth":2},{"title":"EulerDiscreteSchedulerOutput","local":"diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteSchedulerOutput","sections":[],"depth":2}],"depth":1}';function Ce(pe){return $e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends Se{constructor(u){super(),Ee(this,u,Ce,ye,xe,{})}}export{Pe as component};
