import{s as Et,o as Lt,n as We}from"../chunks/scheduler.182ea377.js";import{S as Pt,i as Dt,g as m,s as i,r as J,A as Kt,h as c,f as t,c as p,j as zt,u as U,x as f,k as x,y as Ot,a as l,v as b,d as w,t as T,w as W}from"../chunks/index.abf12888.js";import{T as gt}from"../chunks/Tip.230e2334.js";import{C}from"../chunks/CodeBlock.57fe6e13.js";import{H as Te}from"../chunks/Heading.16916d63.js";import{H as ea,a as ht}from"../chunks/HfOption.fc88c804.js";function ta(R){let n,G='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){n=m("p"),n.innerHTML=G},l(d){n=c(d,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1lc7m22"&&(n.innerHTML=G)},m(d,u){l(d,n,u)},p:We,d(d){d&&t(n)}}}function aa(R){let n,G="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",d,u,_='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',j,M,I,o,h="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",v,g,k,Z,X='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',r;return M=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),g=new C({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>, 
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>, 
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=G,d=i(),u=m("p"),u.innerHTML=_,j=i(),J(M.$$.fragment),I=i(),o=m("p"),o.textContent=h,v=i(),J(g.$$.fragment),k=i(),Z=m("div"),Z.innerHTML=X,this.h()},l(a){n=c(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1kuilfu"&&(n.textContent=G),d=p(a),u=c(a,"P",{"data-svelte-h":!0}),f(u)!=="svelte-10sdaqe"&&(u.innerHTML=_),j=p(a),U(M.$$.fragment,a),I=p(a),o=c(a,"P",{"data-svelte-h":!0}),f(o)!=="svelte-yvbljp"&&(o.textContent=h),v=p(a),U(g.$$.fragment,a),k=p(a),Z=c(a,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-4jgjc0"&&(Z.innerHTML=X),this.h()},h(){x(Z,"class","flex flex-row gap-4")},m(a,y){l(a,n,y),l(a,d,y),l(a,u,y),l(a,j,y),b(M,a,y),l(a,I,y),l(a,o,y),l(a,v,y),b(g,a,y),l(a,k,y),l(a,Z,y),r=!0},p:We,i(a){r||(w(M.$$.fragment,a),w(g.$$.fragment,a),r=!0)},o(a){T(M.$$.fragment,a),T(g.$$.fragment,a),r=!1},d(a){a&&(t(n),t(d),t(u),t(j),t(I),t(o),t(v),t(k),t(Z)),W(M,a),W(g,a)}}}function la(R){let n,G="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",d,u,_='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',j,M,I,o,h="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",v,g,k,Z,X='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',r;return M=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),g=new C({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=G,d=i(),u=m("p"),u.innerHTML=_,j=i(),J(M.$$.fragment),I=i(),o=m("p"),o.textContent=h,v=i(),J(g.$$.fragment),k=i(),Z=m("div"),Z.innerHTML=X,this.h()},l(a){n=c(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-avn1rr"&&(n.textContent=G),d=p(a),u=c(a,"P",{"data-svelte-h":!0}),f(u)!=="svelte-10sdaqe"&&(u.innerHTML=_),j=p(a),U(M.$$.fragment,a),I=p(a),o=c(a,"P",{"data-svelte-h":!0}),f(o)!=="svelte-10sbd9g"&&(o.textContent=h),v=p(a),U(g.$$.fragment,a),k=p(a),Z=c(a,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-8bse9r"&&(Z.innerHTML=X),this.h()},h(){x(Z,"class","flex gap-4")},m(a,y){l(a,n,y),l(a,d,y),l(a,u,y),l(a,j,y),b(M,a,y),l(a,I,y),l(a,o,y),l(a,v,y),b(g,a,y),l(a,k,y),l(a,Z,y),r=!0},p:We,i(a){r||(w(M.$$.fragment,a),w(g.$$.fragment,a),r=!0)},o(a){T(M.$$.fragment,a),T(g.$$.fragment,a),r=!1},d(a){a&&(t(n),t(d),t(u),t(j),t(I),t(o),t(v),t(k),t(Z)),W(M,a),W(g,a)}}}function sa(R){let n,G="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",d,u,_='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',j,M,I,o,h="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",v,g,k,Z,X='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',r;return M=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),g=new C({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=G,d=i(),u=m("p"),u.innerHTML=_,j=i(),J(M.$$.fragment),I=i(),o=m("p"),o.textContent=h,v=i(),J(g.$$.fragment),k=i(),Z=m("div"),Z.innerHTML=X,this.h()},l(a){n=c(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-11wjoqr"&&(n.textContent=G),d=p(a),u=c(a,"P",{"data-svelte-h":!0}),f(u)!=="svelte-10sdaqe"&&(u.innerHTML=_),j=p(a),U(M.$$.fragment,a),I=p(a),o=c(a,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1wfeic0"&&(o.textContent=h),v=p(a),U(g.$$.fragment,a),k=p(a),Z=c(a,"DIV",{class:!0,"data-svelte-h":!0}),f(Z)!=="svelte-5iola2"&&(Z.innerHTML=X),this.h()},h(){x(Z,"class","flex gap-4")},m(a,y){l(a,n,y),l(a,d,y),l(a,u,y),l(a,j,y),b(M,a,y),l(a,I,y),l(a,o,y),l(a,v,y),b(g,a,y),l(a,k,y),l(a,Z,y),r=!0},p:We,i(a){r||(w(M.$$.fragment,a),w(g.$$.fragment,a),r=!0)},o(a){T(M.$$.fragment,a),T(g.$$.fragment,a),r=!1},d(a){a&&(t(n),t(d),t(u),t(j),t(I),t(o),t(v),t(k),t(Z)),W(M,a),W(g,a)}}}function na(R){let n,G='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){n=m("p"),n.innerHTML=G},l(d){n=c(d,"P",{"data-svelte-h":!0}),f(n)!=="svelte-pqh7g3"&&(n.innerHTML=G)},m(d,u){l(d,n,u)},p:We,d(d){d&&t(n)}}}function ia(R){let n,G='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',d,u,_,j,M,I,o="Pass a prompt and an image prompt to the pipeline to generate a short video.",h,v,g,k,Z='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',X;return u=new gt({props:{warning:!0,$$slots:{default:[na]},$$scope:{ctx:R}}}),j=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),v=new C({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=G,d=i(),J(u.$$.fragment),_=i(),J(j.$$.fragment),M=i(),I=m("p"),I.textContent=o,h=i(),J(v.$$.fragment),g=i(),k=m("div"),k.innerHTML=Z,this.h()},l(r){n=c(r,"P",{"data-svelte-h":!0}),f(n)!=="svelte-10zqvoq"&&(n.innerHTML=G),d=p(r),U(u.$$.fragment,r),_=p(r),U(j.$$.fragment,r),M=p(r),I=c(r,"P",{"data-svelte-h":!0}),f(I)!=="svelte-a6opnh"&&(I.textContent=o),h=p(r),U(v.$$.fragment,r),g=p(r),k=c(r,"DIV",{class:!0,"data-svelte-h":!0}),f(k)!=="svelte-ihoum9"&&(k.innerHTML=Z),this.h()},h(){x(k,"class","flex flex-row gap-4")},m(r,a){l(r,n,a),l(r,d,a),b(u,r,a),l(r,_,a),b(j,r,a),l(r,M,a),l(r,I,a),l(r,h,a),b(v,r,a),l(r,g,a),l(r,k,a),X=!0},p(r,a){const y={};a&2&&(y.$$scope={dirty:a,ctx:r}),u.$set(y)},i(r){X||(w(u.$$.fragment,r),w(j.$$.fragment,r),w(v.$$.fragment,r),X=!0)},o(r){T(u.$$.fragment,r),T(j.$$.fragment,r),T(v.$$.fragment,r),X=!1},d(r){r&&(t(n),t(d),t(_),t(M),t(I),t(h),t(g),t(k)),W(u,r),W(j,r),W(v,r)}}}function pa(R){let n,G,d,u,_,j,M,I;return n=new ht({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[aa]},$$scope:{ctx:R}}}),d=new ht({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[la]},$$scope:{ctx:R}}}),_=new ht({props:{id:"tasks",option:"Inpainting",$$slots:{default:[sa]},$$scope:{ctx:R}}}),M=new ht({props:{id:"tasks",option:"Video",$$slots:{default:[ia]},$$scope:{ctx:R}}}),{c(){J(n.$$.fragment),G=i(),J(d.$$.fragment),u=i(),J(_.$$.fragment),j=i(),J(M.$$.fragment)},l(o){U(n.$$.fragment,o),G=p(o),U(d.$$.fragment,o),u=p(o),U(_.$$.fragment,o),j=p(o),U(M.$$.fragment,o)},m(o,h){b(n,o,h),l(o,G,h),b(d,o,h),l(o,u,h),b(_,o,h),l(o,j,h),b(M,o,h),I=!0},p(o,h){const v={};h&2&&(v.$$scope={dirty:h,ctx:o}),n.$set(v);const g={};h&2&&(g.$$scope={dirty:h,ctx:o}),d.$set(g);const k={};h&2&&(k.$$scope={dirty:h,ctx:o}),_.$set(k);const Z={};h&2&&(Z.$$scope={dirty:h,ctx:o}),M.$set(Z)},i(o){I||(w(n.$$.fragment,o),w(d.$$.fragment,o),w(_.$$.fragment,o),w(M.$$.fragment,o),I=!0)},o(o){T(n.$$.fragment,o),T(d.$$.fragment,o),T(_.$$.fragment,o),T(M.$$.fragment,o),I=!1},d(o){o&&(t(G),t(u),t(j)),W(n,o),W(d,o),W(_,o),W(M,o)}}}function oa(R){let n,G='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){n=m("p"),n.innerHTML=G},l(d){n=c(d,"P",{"data-svelte-h":!0}),f(n)!=="svelte-apa7ha"&&(n.innerHTML=G)},m(d,u){l(d,n,u)},p:We,d(d){d&&t(n)}}}function ra(R){let n,G,d,u,_,j,M,I='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',o,h,v,g,k="This guide will walk you through using IP-Adapter for various tasks and use cases.",Z,X,r,a,y='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',Ge,Q,Zt='In all the following examples, you’ll see the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',_e,$,Ie,A,ve,q,Jt="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",ke,z,Xe,E,Ut="Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces:",Re,L,bt='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',Ce,P,wt='<p>[TIP][IP-Adapter-FaceID](<a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">https://huggingface.co/h94/IP-Adapter-FaceID</a>) is a face-specific IP-Adapter trained with face ID embeddings instead of CLIP image embeddings, allowing you to generate more consistent faces in different contexts and styles. Try out this popular <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#ip-adapter-face-id" rel="nofollow">community pipeline</a> and see how it compares to the other face IP-Adapters.</p>',xe,D,Tt='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',$e,K,Ve,V,Wt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Be,O,Ye,ee,jt="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",Fe,B,He,te,Gt='Load the image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',Ne,ae,Se,le,_t="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",Qe,se,It='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',Ae,ne,qe,ie,vt="Load an image prompt and a folder containing images of a certain style you want to use.",ze,pe,Ee,Y,kt='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',Le,oe,Xt="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",Pe,re,De,F,Rt='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',Ke,de,Oe,me,Ct='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',et,ce,xt='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',tt,ue,at,fe,$t='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',lt,Me,st,H,Vt='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',nt,ye,it,he,Bt='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',pt,ge,Yt='Load a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',ot,Ze,rt,Je,Ft="Now load the IP-Adapter image and depth map.",dt,Ue,mt,N,Ht='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',ct,be,Nt="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",ut,we,ft,S,St='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',Mt,je,yt;return _=new Te({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),h=new gt({props:{warning:!1,$$slots:{default:[ta]},$$scope:{ctx:R}}}),X=new Te({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),$=new ea({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[pa]},$$scope:{ctx:R}}}),A=new Te({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),z=new Te({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),K=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZnVsbC1mYWNlX3NkMTUuYmluJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9laW5zdGVpbl9iYXNlLnBuZyUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBwaG90byUyMG9mJTIwRWluc3RlaW4lMjBhcyUyMGElMjBjaGVmJTJDJTIwd2VhcmluZyUyMGFuJTIwYXByb24lMkMlMjBjb29raW5nJTIwaW4lMjBhJTIwRnJlbmNoJTIwcmVzdGF1cmFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>, 
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),O=new Te({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),B=new gt({props:{warning:!1,$$slots:{default:[oa]},$$scope:{ctx:R}}}),ae=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),ne=new C({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjAlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMCUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, 
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, 
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),pe=new C({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images =  [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),re=new C({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>, 
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new Te({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),ue=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id =  <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Me=new C({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ye=new Te({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),Ze=new C({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),Ue=new C({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),we=new C({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2UlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>, 
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>, 
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).image[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){n=m("meta"),G=i(),d=m("p"),u=i(),J(_.$$.fragment),j=i(),M=m("p"),M.innerHTML=I,o=i(),J(h.$$.fragment),v=i(),g=m("p"),g.textContent=k,Z=i(),J(X.$$.fragment),r=i(),a=m("p"),a.innerHTML=y,Ge=i(),Q=m("p"),Q.innerHTML=Zt,_e=i(),J($.$$.fragment),Ie=i(),J(A.$$.fragment),ve=i(),q=m("p"),q.textContent=Jt,ke=i(),J(z.$$.fragment),Xe=i(),E=m("p"),E.textContent=Ut,Re=i(),L=m("ul"),L.innerHTML=bt,Ce=i(),P=m("blockquote"),P.innerHTML=wt,xe=i(),D=m("p"),D.innerHTML=Tt,$e=i(),J(K.$$.fragment),Ve=i(),V=m("div"),V.innerHTML=Wt,Be=i(),J(O.$$.fragment),Ye=i(),ee=m("p"),ee.textContent=jt,Fe=i(),J(B.$$.fragment),He=i(),te=m("p"),te.innerHTML=Gt,Ne=i(),J(ae.$$.fragment),Se=i(),le=m("p"),le.innerHTML=_t,Qe=i(),se=m("ul"),se.innerHTML=It,Ae=i(),J(ne.$$.fragment),qe=i(),ie=m("p"),ie.textContent=vt,ze=i(),J(pe.$$.fragment),Ee=i(),Y=m("div"),Y.innerHTML=kt,Le=i(),oe=m("p"),oe.innerHTML=Xt,Pe=i(),J(re.$$.fragment),De=i(),F=m("div"),F.innerHTML=Rt,Ke=i(),J(de.$$.fragment),Oe=i(),me=m("p"),me.innerHTML=Ct,et=i(),ce=m("p"),ce.innerHTML=xt,tt=i(),J(ue.$$.fragment),at=i(),fe=m("p"),fe.innerHTML=$t,lt=i(),J(Me.$$.fragment),st=i(),H=m("div"),H.innerHTML=Vt,nt=i(),J(ye.$$.fragment),it=i(),he=m("p"),he.innerHTML=Bt,pt=i(),ge=m("p"),ge.innerHTML=Yt,ot=i(),J(Ze.$$.fragment),rt=i(),Je=m("p"),Je.textContent=Ft,dt=i(),J(Ue.$$.fragment),mt=i(),N=m("div"),N.innerHTML=Ht,ct=i(),be=m("p"),be.textContent=Nt,ut=i(),J(we.$$.fragment),ft=i(),S=m("div"),S.innerHTML=St,Mt=i(),je=m("p"),this.h()},l(e){const s=Kt("svelte-u9bgzb",document.head);n=c(s,"META",{name:!0,content:!0}),s.forEach(t),G=p(e),d=c(e,"P",{}),zt(d).forEach(t),u=p(e),U(_.$$.fragment,e),j=p(e),M=c(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-rd9njz"&&(M.innerHTML=I),o=p(e),U(h.$$.fragment,e),v=p(e),g=c(e,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1211s0v"&&(g.textContent=k),Z=p(e),U(X.$$.fragment,e),r=p(e),a=c(e,"P",{"data-svelte-h":!0}),f(a)!=="svelte-49swfq"&&(a.innerHTML=y),Ge=p(e),Q=c(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1pmqs0j"&&(Q.innerHTML=Zt),_e=p(e),U($.$$.fragment,e),Ie=p(e),U(A.$$.fragment,e),ve=p(e),q=c(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-3uurtn"&&(q.textContent=Jt),ke=p(e),U(z.$$.fragment,e),Xe=p(e),E=c(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1md71yv"&&(E.textContent=Ut),Re=p(e),L=c(e,"UL",{"data-svelte-h":!0}),f(L)!=="svelte-1a56pqx"&&(L.innerHTML=bt),Ce=p(e),P=c(e,"BLOCKQUOTE",{"data-svelte-h":!0}),f(P)!=="svelte-l9v07s"&&(P.innerHTML=wt),xe=p(e),D=c(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1dtaqqk"&&(D.innerHTML=Tt),$e=p(e),U(K.$$.fragment,e),Ve=p(e),V=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(V)!=="svelte-lbwedl"&&(V.innerHTML=Wt),Be=p(e),U(O.$$.fragment,e),Ye=p(e),ee=c(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1tk2m7v"&&(ee.textContent=jt),Fe=p(e),U(B.$$.fragment,e),He=p(e),te=c(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-qgg0iy"&&(te.innerHTML=Gt),Ne=p(e),U(ae.$$.fragment,e),Se=p(e),le=c(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-1vw2kqb"&&(le.innerHTML=_t),Qe=p(e),se=c(e,"UL",{"data-svelte-h":!0}),f(se)!=="svelte-tpz2u9"&&(se.innerHTML=It),Ae=p(e),U(ne.$$.fragment,e),qe=p(e),ie=c(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1p6lwr0"&&(ie.textContent=vt),ze=p(e),U(pe.$$.fragment,e),Ee=p(e),Y=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(Y)!=="svelte-im3du6"&&(Y.innerHTML=kt),Le=p(e),oe=c(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-1kkzavx"&&(oe.innerHTML=Xt),Pe=p(e),U(re.$$.fragment,e),De=p(e),F=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(F)!=="svelte-1t1eqqe"&&(F.innerHTML=Rt),Ke=p(e),U(de.$$.fragment,e),Oe=p(e),me=c(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1am74qu"&&(me.innerHTML=Ct),et=p(e),ce=c(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-ntp5s3"&&(ce.innerHTML=xt),tt=p(e),U(ue.$$.fragment,e),at=p(e),fe=c(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-13u2z8i"&&(fe.innerHTML=$t),lt=p(e),U(Me.$$.fragment,e),st=p(e),H=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(H)!=="svelte-1cw2b12"&&(H.innerHTML=Vt),nt=p(e),U(ye.$$.fragment,e),it=p(e),he=c(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-sz8jif"&&(he.innerHTML=Bt),pt=p(e),ge=c(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-837b2y"&&(ge.innerHTML=Yt),ot=p(e),U(Ze.$$.fragment,e),rt=p(e),Je=c(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-77tfin"&&(Je.textContent=Ft),dt=p(e),U(Ue.$$.fragment,e),mt=p(e),N=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(N)!=="svelte-mjuwpp"&&(N.innerHTML=Ht),ct=p(e),be=c(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-12fzw16"&&(be.textContent=Nt),ut=p(e),U(we.$$.fragment,e),ft=p(e),S=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(S)!=="svelte-kc4794"&&(S.innerHTML=St),Mt=p(e),je=c(e,"P",{}),zt(je).forEach(t),this.h()},h(){x(n,"name","hf:doc:metadata"),x(n,"content",da),x(V,"class","flex flex-row gap-4"),x(Y,"class","flex flex-row gap-4"),x(F,"class","flex justify-center"),x(H,"class","flex justify-center"),x(N,"class","flex flex-row gap-4"),x(S,"class","flex justify-center")},m(e,s){Ot(document.head,n),l(e,G,s),l(e,d,s),l(e,u,s),b(_,e,s),l(e,j,s),l(e,M,s),l(e,o,s),b(h,e,s),l(e,v,s),l(e,g,s),l(e,Z,s),b(X,e,s),l(e,r,s),l(e,a,s),l(e,Ge,s),l(e,Q,s),l(e,_e,s),b($,e,s),l(e,Ie,s),b(A,e,s),l(e,ve,s),l(e,q,s),l(e,ke,s),b(z,e,s),l(e,Xe,s),l(e,E,s),l(e,Re,s),l(e,L,s),l(e,Ce,s),l(e,P,s),l(e,xe,s),l(e,D,s),l(e,$e,s),b(K,e,s),l(e,Ve,s),l(e,V,s),l(e,Be,s),b(O,e,s),l(e,Ye,s),l(e,ee,s),l(e,Fe,s),b(B,e,s),l(e,He,s),l(e,te,s),l(e,Ne,s),b(ae,e,s),l(e,Se,s),l(e,le,s),l(e,Qe,s),l(e,se,s),l(e,Ae,s),b(ne,e,s),l(e,qe,s),l(e,ie,s),l(e,ze,s),b(pe,e,s),l(e,Ee,s),l(e,Y,s),l(e,Le,s),l(e,oe,s),l(e,Pe,s),b(re,e,s),l(e,De,s),l(e,F,s),l(e,Ke,s),b(de,e,s),l(e,Oe,s),l(e,me,s),l(e,et,s),l(e,ce,s),l(e,tt,s),b(ue,e,s),l(e,at,s),l(e,fe,s),l(e,lt,s),b(Me,e,s),l(e,st,s),l(e,H,s),l(e,nt,s),b(ye,e,s),l(e,it,s),l(e,he,s),l(e,pt,s),l(e,ge,s),l(e,ot,s),b(Ze,e,s),l(e,rt,s),l(e,Je,s),l(e,dt,s),b(Ue,e,s),l(e,mt,s),l(e,N,s),l(e,ct,s),l(e,be,s),l(e,ut,s),b(we,e,s),l(e,ft,s),l(e,S,s),l(e,Mt,s),l(e,je,s),yt=!0},p(e,[s]){const Qt={};s&2&&(Qt.$$scope={dirty:s,ctx:e}),h.$set(Qt);const At={};s&2&&(At.$$scope={dirty:s,ctx:e}),$.$set(At);const qt={};s&2&&(qt.$$scope={dirty:s,ctx:e}),B.$set(qt)},i(e){yt||(w(_.$$.fragment,e),w(h.$$.fragment,e),w(X.$$.fragment,e),w($.$$.fragment,e),w(A.$$.fragment,e),w(z.$$.fragment,e),w(K.$$.fragment,e),w(O.$$.fragment,e),w(B.$$.fragment,e),w(ae.$$.fragment,e),w(ne.$$.fragment,e),w(pe.$$.fragment,e),w(re.$$.fragment,e),w(de.$$.fragment,e),w(ue.$$.fragment,e),w(Me.$$.fragment,e),w(ye.$$.fragment,e),w(Ze.$$.fragment,e),w(Ue.$$.fragment,e),w(we.$$.fragment,e),yt=!0)},o(e){T(_.$$.fragment,e),T(h.$$.fragment,e),T(X.$$.fragment,e),T($.$$.fragment,e),T(A.$$.fragment,e),T(z.$$.fragment,e),T(K.$$.fragment,e),T(O.$$.fragment,e),T(B.$$.fragment,e),T(ae.$$.fragment,e),T(ne.$$.fragment,e),T(pe.$$.fragment,e),T(re.$$.fragment,e),T(de.$$.fragment,e),T(ue.$$.fragment,e),T(Me.$$.fragment,e),T(ye.$$.fragment,e),T(Ze.$$.fragment,e),T(Ue.$$.fragment,e),T(we.$$.fragment,e),yt=!1},d(e){e&&(t(G),t(d),t(u),t(j),t(M),t(o),t(v),t(g),t(Z),t(r),t(a),t(Ge),t(Q),t(_e),t(Ie),t(ve),t(q),t(ke),t(Xe),t(E),t(Re),t(L),t(Ce),t(P),t(xe),t(D),t($e),t(Ve),t(V),t(Be),t(Ye),t(ee),t(Fe),t(He),t(te),t(Ne),t(Se),t(le),t(Qe),t(se),t(Ae),t(qe),t(ie),t(ze),t(Ee),t(Y),t(Le),t(oe),t(Pe),t(De),t(F),t(Ke),t(Oe),t(me),t(et),t(ce),t(tt),t(at),t(fe),t(lt),t(st),t(H),t(nt),t(it),t(he),t(pt),t(ge),t(ot),t(rt),t(Je),t(dt),t(mt),t(N),t(ct),t(be),t(ut),t(ft),t(S),t(Mt),t(je)),t(n),W(_,e),W(h,e),W(X,e),W($,e),W(A,e),W(z,e),W(K,e),W(O,e),W(B,e),W(ae,e),W(ne,e),W(pe,e),W(re,e),W(de,e),W(ue,e),W(Me,e),W(ye,e),W(Ze,e),W(Ue,e),W(we,e)}}}const da='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3}],"depth":2}],"depth":1}';function ma(R){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ga extends Pt{constructor(n){super(),Dt(this,n,ma,ra,Et,{})}}export{ga as component};
