import{s as Ye,n as Be,o as Ce}from"../chunks/scheduler.b108d059.js";import{S as qe,i as _e,g as i,s as l,r as o,A as xe,h as p,f as t,c as n,j as L,u as d,x as r,k as He,y as m,a,v as h,d as u,t as y,w as M}from"../chunks/index.008de539.js";import{C as Q}from"../chunks/CodeBlock.3968c746.js";import{H as fe}from"../chunks/Heading.88bfeb84.js";function Le(Ze){let g,D,N,P,j,K,J,Ge='Zusätzlich zur <code>HfApi</code> bietet die <code>huggingface_hub</code> Bibliothek <code>HfFileSystem</code>, eine pythonische, <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-kompatible</a> Dateischnittstelle zum Hugging Face Hub. Das <code>HfFileSystem</code> basiert auf der <code>HfApi</code> und bietet typische Dateisystemoperationen wie <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, und <code>put_file</code>.',O,w,ee,U,se,b,ke="Das optionale Argument <code>revision</code> kann übergeben werden, um eine Operation von einem spezifischen Commit auszuführen, wie z.B. einem Branch, Tag-Namen oder einem Commit-Hash.",te,T,Re="Anders als bei Pythons eingebautem <code>open</code>, ist der Standardmodus von <code>fsspec</code>’s <code>open</code> binär, <code>&quot;rb&quot;</code>. Das bedeutet, dass Sie den Modus explizit auf <code>&quot;r&quot;</code> zum Lesen und <code>&quot;w&quot;</code> zum Schreiben im Textmodus setzen müssen. Das Anhängen an eine Datei (Modi <code>&quot;a&quot;</code> und <code>&quot;ab&quot;</code>) wird noch nicht unterstützt.",ae,Z,le,G,Ie="Das <code>HfFileSystem</code> kann mit jeder Bibliothek verwendet werden, die <code>fsspec</code> integriert, vorausgesetzt die URL folgt dem Schema:",ne,k,ie,R,ve="Der <code>repo_type_prefix</code> ist <code>datasets/</code> für Datensätze, <code>spaces/</code> für Spaces, und Modelle benötigen kein Präfix in der URL.",pe,I,ze="Einige interessante Integrationen, bei denen <code>HfFileSystem</code> die Interaktion mit dem Hub vereinfacht, sind unten aufgeführt:",me,c,f,Y,Se='Lesen/Schreiben eines <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame aus/in ein Hub-Repository:',je,v,Je,B,We='Der gleiche Arbeitsablauf kann auch für  <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> und <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> verwendet werden.',we,z,C,Xe='Abfrage von (entfernten) Hub-Dateien mit  <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Ue,S,be,W,q,$e='Verwendung des Hub als Array-Speicher mit <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Te,X,re,$,ce,E,Ee='In vielen Fällen müssen Sie mit einem Hugging Face-Konto angemeldet sein, um mit dem Hub zu interagieren. Lesen Sie den <a href="../quick-start#login">Login</a>-Abschnitt der Dokumentation, um mehr über Authentifizierungsmethoden auf dem Hub zu erfahren.',oe,F,Fe="Es ist auch möglich, sich programmatisch anzumelden, indem Sie Ihr <code>token</code> als Argument an <code>HfFileSystem</code> übergeben:",de,V,he,H,Ve="Wenn Sie sich auf diese Weise anmelden, seien Sie vorsichtig, das Token nicht versehentlich zu veröffentlichen, wenn Sie Ihren Quellcode teilen!",ue,A,ye;return j=new fe({props:{title:"Interagieren mit dem Hub über die Filesystem API",local:"interagieren-mit-dem-hub-über-die-filesystem-api",headingTag:"h1"}}),w=new fe({props:{title:"Verwendung",local:"verwendung",headingTag:"h2"}}),U=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBBbGxlJTIwRGF0ZWllbiUyMGluJTIwZWluZW0lMjBWZXJ6ZWljaG5pcyUyMGF1Zmxpc3RlbiUwQWZzLmxzKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTIyJTJDJTIwZGV0YWlsJTNERmFsc2UpJTBBJTBBJTIzJTIwQWxsZSUyMCUyMi5jc3YlMjItRGF0ZWllbiUyMGluJTIwZWluZW0lMjBSZXBvJTIwYXVmbGlzdGVuJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMEVpbmUlMjBlbnRmZXJudGUlMjBEYXRlaSUyMGxlc2VuJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGElMjAlM0QlMjBmLnJlYWRsaW5lcygpJTBBJTBBJTIzJTIwRGVuJTIwSW5oYWx0JTIwZWluZXIlMjBlbnRmZXJudGVuJTIwRGF0ZWklMjBhbHMlMjBaZWljaGVua2V0dGUlMjAlMkYlMjBTdHJpbmclMjBsZXNlbiUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBFaW5lJTIwZW50ZmVybnRlJTIwRGF0ZWklMjBzY2hyZWliZW4lMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnZhbGlkYXRpb24uY3N2JTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnRleHQlMkNsYWJlbCUyMiklMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMkZhbnRhc3RpYyUyMG1vdmllISUyQ2dvb2QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Alle Dateien in einem Verzeichnis auflisten</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Alle &quot;.csv&quot;-Dateien in einem Repo auflisten</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Den Inhalt einer entfernten Datei als Zeichenkette / String lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),Z=new fe({props:{title:"Integrationen",local:"integrationen",headingTag:"h2"}}),k=new Q({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGZhZCUyRmltJTJGcmVwbyUzRQ==",highlighted:'hf://[<span class="hljs-attribute">&lt;repo_type_prefix&gt;</span>]<span class="hljs-attribute">&lt;repo_id&gt;</span>[@<span class="hljs-attribute">&lt;revision&gt;</span>]/<span class="hljs-attribute">&lt;pfad/im/repo&gt;</span>',wrap:!1}}),v=new Q({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMEVpbmUlMjBlbnRmZXJudGUlMjBDU1YtRGF0ZWklMjBpbiUyMGVpbmVuJTIwRGF0YUZyYW1lJTIwbGVzZW4lMEFkZiUyMCUzRCUyMHBkLnJlYWRfY3N2KCUyMmhmJTNBJTJGJTJGZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRnRyYWluLmNzdiUyMiklMEElMEElMjMlMjBFaW5lbiUyMERhdGFGcmFtZSUyMGluJTIwZWluZSUyMGVudGZlcm50ZSUyMENTVi1EYXRlaSUyMHNjaHJlaWJlbiUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte CSV-Datei in einen DataFrame lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Einen DataFrame in eine entfernte CSV-Datei schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),S=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBFaW5lJTIwZW50ZmVybnRlJTIwRGF0ZWklMjBhYmZyYWdlbiUyMHVuZCUyMGRhcyUyMEVyZ2VibmlzJTIwYWxzJTIwRGF0YUZyYW1lJTIwenVyJUMzJUJDY2tiZWtvbW1lbiUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei abfragen und das Ergebnis als DataFrame zurückbekommen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),X=new Q({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBFaW4lMjBBcnJheSUyMGluJTIwZWluJTIwUmVwbyUyMHNjaHJlaWJlbiUwQXdpdGglMjB6YXJyLm9wZW5fZ3JvdXAoJTIyaGYlM0ElMkYlMkZteS11c2VybmFtZSUyRm15LW1vZGVsLXJlcG8lMkZhcnJheS1zdG9yZSUyMiUyQyUyMG1vZGUlM0QlMjJ3JTIyKSUyMGFzJTIwcm9vdCUzQSUwQSUyMCUyMCUyMGZvbyUyMCUzRCUyMHJvb3QuY3JlYXRlX2dyb3VwKCUyMmVtYmVkZGluZ3MlMjIpJTBBJTIwJTIwJTIwZm9vYmFyJTIwJTNEJTIwZm9vLnplcm9zKCdleHBlcmltZW50XzAnJTJDJTIwc2hhcGUlM0QoNTAwMDAlMkMlMjAxMDAwKSUyQyUyMGNodW5rcyUzRCgxMDAwMCUyQyUyMDEwMDApJTJDJTIwZHR5cGUlM0QnZjQnKSUwQSUyMCUyMCUyMGZvb2JhciU1QiUzQSU1RCUyMCUzRCUyMGVtYmVkZGluZ3MlMEElMEElMjMlMjBFaW4lMjBBcnJheSUyMGF1cyUyMGVpbmVtJTIwUmVwbyUyMGxlc2VuJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Ein Array in ein Repo schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Ein Array aus einem Repo lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),$=new fe({props:{title:"Authentifizierung",local:"authentifizierung",headingTag:"h2"}}),V=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),{c(){g=i("meta"),D=l(),N=i("p"),P=l(),o(j.$$.fragment),K=l(),J=i("p"),J.innerHTML=Ge,O=l(),o(w.$$.fragment),ee=l(),o(U.$$.fragment),se=l(),b=i("p"),b.innerHTML=ke,te=l(),T=i("p"),T.innerHTML=Re,ae=l(),o(Z.$$.fragment),le=l(),G=i("p"),G.innerHTML=Ie,ne=l(),o(k.$$.fragment),ie=l(),R=i("p"),R.innerHTML=ve,pe=l(),I=i("p"),I.innerHTML=ze,me=l(),c=i("ul"),f=i("li"),Y=i("p"),Y.innerHTML=Se,je=l(),o(v.$$.fragment),Je=l(),B=i("p"),B.innerHTML=We,we=l(),z=i("li"),C=i("p"),C.innerHTML=Xe,Ue=l(),o(S.$$.fragment),be=l(),W=i("li"),q=i("p"),q.innerHTML=$e,Te=l(),o(X.$$.fragment),re=l(),o($.$$.fragment),ce=l(),E=i("p"),E.innerHTML=Ee,oe=l(),F=i("p"),F.innerHTML=Fe,de=l(),o(V.$$.fragment),he=l(),H=i("p"),H.textContent=Ve,ue=l(),A=i("p"),this.h()},l(e){const s=xe("svelte-u9bgzb",document.head);g=p(s,"META",{name:!0,content:!0}),s.forEach(t),D=n(e),N=p(e,"P",{}),L(N).forEach(t),P=n(e),d(j.$$.fragment,e),K=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18w92na"&&(J.innerHTML=Ge),O=n(e),d(w.$$.fragment,e),ee=n(e),d(U.$$.fragment,e),se=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-3z26mg"&&(b.innerHTML=ke),te=n(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-tbpook"&&(T.innerHTML=Re),ae=n(e),d(Z.$$.fragment,e),le=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-eeqd0a"&&(G.innerHTML=Ie),ne=n(e),d(k.$$.fragment,e),ie=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-967d81"&&(R.innerHTML=ve),pe=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-wufznp"&&(I.innerHTML=ze),me=n(e),c=p(e,"UL",{});var _=L(c);f=p(_,"LI",{});var x=L(f);Y=p(x,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-5rmyjs"&&(Y.innerHTML=Se),je=n(x),d(v.$$.fragment,x),Je=n(x),B=p(x,"P",{"data-svelte-h":!0}),r(B)!=="svelte-11g4kom"&&(B.innerHTML=We),x.forEach(t),we=n(_),z=p(_,"LI",{});var Me=L(z);C=p(Me,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1j784ud"&&(C.innerHTML=Xe),Ue=n(Me),d(S.$$.fragment,Me),Me.forEach(t),be=n(_),W=p(_,"LI",{});var ge=L(W);q=p(ge,"P",{"data-svelte-h":!0}),r(q)!=="svelte-guwc20"&&(q.innerHTML=$e),Te=n(ge),d(X.$$.fragment,ge),ge.forEach(t),_.forEach(t),re=n(e),d($.$$.fragment,e),ce=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-aphqiq"&&(E.innerHTML=Ee),oe=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1enyw3z"&&(F.innerHTML=Fe),de=n(e),d(V.$$.fragment,e),he=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16usaea"&&(H.textContent=Ve),ue=n(e),A=p(e,"P",{}),L(A).forEach(t),this.h()},h(){He(g,"name","hf:doc:metadata"),He(g,"content",Qe)},m(e,s){m(document.head,g),a(e,D,s),a(e,N,s),a(e,P,s),h(j,e,s),a(e,K,s),a(e,J,s),a(e,O,s),h(w,e,s),a(e,ee,s),h(U,e,s),a(e,se,s),a(e,b,s),a(e,te,s),a(e,T,s),a(e,ae,s),h(Z,e,s),a(e,le,s),a(e,G,s),a(e,ne,s),h(k,e,s),a(e,ie,s),a(e,R,s),a(e,pe,s),a(e,I,s),a(e,me,s),a(e,c,s),m(c,f),m(f,Y),m(f,je),h(v,f,null),m(f,Je),m(f,B),m(c,we),m(c,z),m(z,C),m(z,Ue),h(S,z,null),m(c,be),m(c,W),m(W,q),m(W,Te),h(X,W,null),a(e,re,s),h($,e,s),a(e,ce,s),a(e,E,s),a(e,oe,s),a(e,F,s),a(e,de,s),h(V,e,s),a(e,he,s),a(e,H,s),a(e,ue,s),a(e,A,s),ye=!0},p:Be,i(e){ye||(u(j.$$.fragment,e),u(w.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),u($.$$.fragment,e),u(V.$$.fragment,e),ye=!0)},o(e){y(j.$$.fragment,e),y(w.$$.fragment,e),y(U.$$.fragment,e),y(Z.$$.fragment,e),y(k.$$.fragment,e),y(v.$$.fragment,e),y(S.$$.fragment,e),y(X.$$.fragment,e),y($.$$.fragment,e),y(V.$$.fragment,e),ye=!1},d(e){e&&(t(D),t(N),t(P),t(K),t(J),t(O),t(ee),t(se),t(b),t(te),t(T),t(ae),t(le),t(G),t(ne),t(ie),t(R),t(pe),t(I),t(me),t(c),t(re),t(ce),t(E),t(oe),t(F),t(de),t(he),t(H),t(ue),t(A)),t(g),M(j,e),M(w,e),M(U,e),M(Z,e),M(k,e),M(v),M(S),M(X),M($,e),M(V,e)}}}const Qe='{"title":"Interagieren mit dem Hub über die Filesystem API","local":"interagieren-mit-dem-hub-über-die-filesystem-api","sections":[{"title":"Verwendung","local":"verwendung","sections":[],"depth":2},{"title":"Integrationen","local":"integrationen","sections":[],"depth":2},{"title":"Authentifizierung","local":"authentifizierung","sections":[],"depth":2}],"depth":1}';function Ne(Ze){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends qe{constructor(g){super(),_e(this,g,Ne,Le,Ye,{})}}export{Oe as component};
