import{s as pe,f as de,n as Me,o as ue}from"../chunks/scheduler.9039eef2.js";import{S as ce,i as ye,g as o,s as a,r as U,A as he,h as i,f as t,c as n,j as me,u as Z,x as W,k as D,y as we,a as s,v as B,d as g,t as I,w as V}from"../chunks/index.ded8f90d.js";import{C as O}from"../chunks/CodeBlock.8580f3e8.js";import{H as K}from"../chunks/Heading.f027f30d.js";function Je(ee){let r,G,k,X,m,_,p,Q,d,le="Fine-tuning a language model via PPO consists of roughly three steps:",R,M,te="<li><strong>Rollout</strong>: The language model generates a response or continuation based on a query which could be the start of a sentence.</li> <li><strong>Evaluation</strong>: The query and response are evaluated with a function, model, human feedback, or some combination of them. The important thing is that this process should yield a scalar value for each query/response pair. The optimization will aim at maximizing this value.</li> <li><strong>Optimization</strong>: This is the most complex part. In the optimisation step the query/response pairs are used to calculate the log-probabilities of the tokens in the sequences. This is done with the model that is trained and a reference model, which is usually the pre-trained model before fine-tuning. The KL-divergence between the two outputs is used as an additional reward signal to make sure the generated responses don’t deviate too far from the reference language model. The active language model is then trained with PPO.</li>",H,u,se="The full process is illustrated in the following figure:",$,C,ae,E,c,x,y,ne="The following code illustrates the steps above.",F,h,q,w,oe="In general, you would run steps 3-6 in a for-loop and run it on many diverse queries. You can find more realistic examples in the examples section.",S,J,z,T,ie="After training a <code>AutoModelForCausalLMWithValueHead</code>, you can directly use the model in <code>transformers</code>.",N,b,L,j,re="You can also load your model with <code>AutoModelForCausalLMWithValueHead</code> if you want to use the value head, for example to continue training.",A,f,Y,v,P;return m=new K({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),p=new K({props:{title:"How does it work?",local:"how-does-it-work",headingTag:"h2"}}),c=new K({props:{title:"Minimal example",local:"minimal-example",headingTag:"h2"}}),h=new O({props:{code:"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",highlighted:`<span class="hljs-comment"># 0. imports</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer


<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-comment"># 2. initialize trainer</span>
ppo_config = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>}
config = PPOConfig(**ppo_config)
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer)

<span class="hljs-comment"># 3. encode a query</span>
query_txt = <span class="hljs-string">&quot;This morning I went to the &quot;</span>
query_tensor = tokenizer.encode(query_txt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.pretrained_model.device)

<span class="hljs-comment"># 4. generate model response</span>
generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">20</span>,
}
response_tensor = ppo_trainer.generate([item <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> query_tensor], return_prompt=<span class="hljs-literal">False</span>, **generation_kwargs)
response_txt = tokenizer.decode(response_tensor[<span class="hljs-number">0</span>])

<span class="hljs-comment"># 5. define a reward for response</span>
<span class="hljs-comment"># (this could be any reward such as human feedback or output from another model)</span>
reward = [torch.tensor(<span class="hljs-number">1.0</span>, device=model.pretrained_model.device)]

<span class="hljs-comment"># 6. train model with ppo</span>
train_stats = ppo_trainer.step([query_tensor[<span class="hljs-number">0</span>]], [response_tensor[<span class="hljs-number">0</span>]], reward)`,wrap:!1}}),J=new K({props:{title:"How to use a trained model",local:"how-to-use-a-trained-model",headingTag:"h2"}}),b=new O({props:{code:"JTBBJTIzJTIwLi4lMjBMZXQncyUyMGFzc3VtZSUyMHdlJTIwaGF2ZSUyMGElMjB0cmFpbmVkJTIwbW9kZWwlMjB1c2luZyUyMCU2MFBQT1RyYWluZXIlNjAlMjBhbmQlMjAlNjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQlNjAlMEElMEElMjMlMjBwdXNoJTIwdGhlJTIwbW9kZWwlMjBvbiUyMHRoZSUyMEh1YiUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWZpbmUtdHVuZWQtbW9kZWwtcHBvJTIyKSUwQSUwQSUyMyUyMG9yJTIwc2F2ZSUyMGl0JTIwbG9jYWxseSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteS1maW5lLXR1bmVkLW1vZGVsLXBwbyUyMiklMEElMEElMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwSHViJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybXktZmluZS10dW5lZC1tb2RlbC1wcG8lMjIp",highlighted:`
<span class="hljs-comment"># .. Let&#x27;s assume we have a trained model using \`PPOTrainer\` and \`AutoModelForCausalLMWithValueHead\`</span>

<span class="hljs-comment"># push the model on the Hub</span>
model.push_to_hub(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)

<span class="hljs-comment"># or save it locally</span>
model.save_pretrained(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)

<span class="hljs-comment"># load the model from the Hub</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)`,wrap:!1}}),f=new O({props:{code:"ZnJvbSUyMHRybC5tb2RlbCUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCglMjJteS1maW5lLXR1bmVkLW1vZGVsLXBwbyUyMik=",highlighted:`<span class="hljs-keyword">from</span> trl.model <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead

model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&quot;my-fine-tuned-model-ppo&quot;</span>)`,wrap:!1}}),{c(){r=o("meta"),G=a(),k=o("p"),X=a(),U(m.$$.fragment),_=a(),U(p.$$.fragment),Q=a(),d=o("p"),d.textContent=le,R=a(),M=o("ol"),M.innerHTML=te,H=a(),u=o("p"),u.textContent=se,$=a(),C=o("img"),E=a(),U(c.$$.fragment),x=a(),y=o("p"),y.textContent=ne,F=a(),U(h.$$.fragment),q=a(),w=o("p"),w.textContent=oe,S=a(),U(J.$$.fragment),z=a(),T=o("p"),T.innerHTML=ie,N=a(),U(b.$$.fragment),L=a(),j=o("p"),j.innerHTML=re,A=a(),U(f.$$.fragment),Y=a(),v=o("p"),this.h()},l(e){const l=he("svelte-u9bgzb",document.head);r=i(l,"META",{name:!0,content:!0}),l.forEach(t),G=n(e),k=i(e,"P",{}),me(k).forEach(t),X=n(e),Z(m.$$.fragment,e),_=n(e),Z(p.$$.fragment,e),Q=n(e),d=i(e,"P",{"data-svelte-h":!0}),W(d)!=="svelte-79li59"&&(d.textContent=le),R=n(e),M=i(e,"OL",{"data-svelte-h":!0}),W(M)!=="svelte-1uekaot"&&(M.innerHTML=te),H=n(e),u=i(e,"P",{"data-svelte-h":!0}),W(u)!=="svelte-62xfzx"&&(u.textContent=se),$=n(e),C=i(e,"IMG",{src:!0}),E=n(e),Z(c.$$.fragment,e),x=n(e),y=i(e,"P",{"data-svelte-h":!0}),W(y)!=="svelte-11erqnm"&&(y.textContent=ne),F=n(e),Z(h.$$.fragment,e),q=n(e),w=i(e,"P",{"data-svelte-h":!0}),W(w)!=="svelte-1rp76uw"&&(w.textContent=oe),S=n(e),Z(J.$$.fragment,e),z=n(e),T=i(e,"P",{"data-svelte-h":!0}),W(T)!=="svelte-znbdcu"&&(T.innerHTML=ie),N=n(e),Z(b.$$.fragment,e),L=n(e),j=i(e,"P",{"data-svelte-h":!0}),W(j)!=="svelte-12cg6c8"&&(j.innerHTML=re),A=n(e),Z(f.$$.fragment,e),Y=n(e),v=i(e,"P",{}),me(v).forEach(t),this.h()},h(){D(r,"name","hf:doc:metadata"),D(r,"content",Te),de(C.src,ae="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl_overview.png")||D(C,"src",ae)},m(e,l){we(document.head,r),s(e,G,l),s(e,k,l),s(e,X,l),B(m,e,l),s(e,_,l),B(p,e,l),s(e,Q,l),s(e,d,l),s(e,R,l),s(e,M,l),s(e,H,l),s(e,u,l),s(e,$,l),s(e,C,l),s(e,E,l),B(c,e,l),s(e,x,l),s(e,y,l),s(e,F,l),B(h,e,l),s(e,q,l),s(e,w,l),s(e,S,l),B(J,e,l),s(e,z,l),s(e,T,l),s(e,N,l),B(b,e,l),s(e,L,l),s(e,j,l),s(e,A,l),B(f,e,l),s(e,Y,l),s(e,v,l),P=!0},p:Me,i(e){P||(g(m.$$.fragment,e),g(p.$$.fragment,e),g(c.$$.fragment,e),g(h.$$.fragment,e),g(J.$$.fragment,e),g(b.$$.fragment,e),g(f.$$.fragment,e),P=!0)},o(e){I(m.$$.fragment,e),I(p.$$.fragment,e),I(c.$$.fragment,e),I(h.$$.fragment,e),I(J.$$.fragment,e),I(b.$$.fragment,e),I(f.$$.fragment,e),P=!1},d(e){e&&(t(G),t(k),t(X),t(_),t(Q),t(d),t(R),t(M),t(H),t(u),t($),t(C),t(E),t(x),t(y),t(F),t(q),t(w),t(S),t(z),t(T),t(N),t(L),t(j),t(A),t(Y),t(v)),t(r),V(m,e),V(p,e),V(c,e),V(h,e),V(J,e),V(b,e),V(f,e)}}}const Te='{"title":"Quickstart","local":"quickstart","sections":[{"title":"How does it work?","local":"how-does-it-work","sections":[],"depth":2},{"title":"Minimal example","local":"minimal-example","sections":[],"depth":2},{"title":"How to use a trained model","local":"how-to-use-a-trained-model","sections":[],"depth":2}],"depth":1}';function be(ee){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends ce{constructor(r){super(),ye(this,r,be,Je,pe,{})}}export{We as component};
