import{s as Zt,n as Bt,o as kt}from"../chunks/scheduler.85c25b89.js";import{S as Gt,i as Nt,g as p,s as l,r as o,A as Qt,h as i,f as e,c as n,j as xt,u as r,x as m,k as Ct,y as vt,a,v as h,d as c,t as M,w as d}from"../chunks/index.c9bcf812.js";import{C as _}from"../chunks/CodeBlock.94efc595.js";import{H as F}from"../chunks/Heading.3c6e5b17.js";function Vt(wt){let w,X,Y,H,J,z,g,Jt='A <strong>ResNeXt</strong> repeats a <a href="https://paperswithcode.com/method/resnext-block" rel="nofollow">building block</a> that aggregates a set of transformations with the same topology. Compared to a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>, it exposes a new dimension,  <em>cardinality</em> (the size of the set of transformations) $C$, as an essential factor in addition to the dimensions of depth and width.',S,y,gt="This model was trained on billions of Instagram images using thousands of distinct hashtags as labels exhibit excellent transfer learning performance.",A,j,yt="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",L,T,D,u,jt="To load a pretrained model:",P,f,q,b,Tt="To load and preprocess the image:",K,U,O,I,ut="To get the model predictions:",tt,W,st,$,ft="To get the top-5 predictions class names:",et,x,at,C,bt="Replace the model name with the variant you want to use, e.g. <code>ig_resnext101_32x16d</code>. You can find the IDs in the model summaries at the top of this page.",lt,Z,Ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',nt,B,pt,k,It="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",it,G,mt,N,Wt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ot,Q,rt,v,$t='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ht,V,ct,E,Mt,R,dt;return J=new F({props:{title:"Instagram ResNeXt WSL",local:"instagram-resnext-wsl",headingTag:"h1"}}),T=new F({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2lnX3Jlc25leHQxMDFfMzJ4MTZkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ig_resnext101_32x16d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),W=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new F({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaWdfcmVzbmV4dDEwMV8zMngxNmQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ig_resnext101_32x16d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),Q=new F({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),V=new F({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new _({props:{code:"JTQwbWlzYyU3Qm1haGFqYW4yMDE4ZXhwbG9yaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JFeHBsb3JpbmclMjB0aGUlMjBMaW1pdHMlMjBvZiUyMFdlYWtseSUyMFN1cGVydmlzZWQlMjBQcmV0cmFpbmluZyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkRocnV2JTIwTWFoYWphbiUyMGFuZCUyMFJvc3MlMjBHaXJzaGljayUyMGFuZCUyMFZpZ25lc2glMjBSYW1hbmF0aGFuJTIwYW5kJTIwS2FpbWluZyUyMEhlJTIwYW5kJTIwTWFub2hhciUyMFBhbHVyaSUyMGFuZCUyMFlpeHVhbiUyMExpJTIwYW5kJTIwQXNod2luJTIwQmhhcmFtYmUlMjBhbmQlMjBMYXVyZW5zJTIwdmFuJTIwZGVyJTIwTWFhdGVuJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODA1LjAwOTMyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{mahajan2018exploring,
      title={Exploring the Limits of Weakly Supervised Pretraining}, 
      author={Dhruv Mahajan <span class="hljs-keyword">and </span>Ross Girshick <span class="hljs-keyword">and </span>Vignesh Ramanathan <span class="hljs-keyword">and </span>Kaiming He <span class="hljs-keyword">and </span>Manohar Paluri <span class="hljs-keyword">and </span>Yixuan Li <span class="hljs-keyword">and </span>Ashwin <span class="hljs-keyword">Bharambe </span><span class="hljs-keyword">and </span>Laurens van der Maaten},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1805</span>.<span class="hljs-number">00932</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){w=p("meta"),X=l(),Y=p("p"),H=l(),o(J.$$.fragment),z=l(),g=p("p"),g.innerHTML=Jt,S=l(),y=p("p"),y.textContent=gt,A=l(),j=p("p"),j.textContent=yt,L=l(),o(T.$$.fragment),D=l(),u=p("p"),u.textContent=jt,P=l(),o(f.$$.fragment),q=l(),b=p("p"),b.textContent=Tt,K=l(),o(U.$$.fragment),O=l(),I=p("p"),I.textContent=ut,tt=l(),o(W.$$.fragment),st=l(),$=p("p"),$.textContent=ft,et=l(),o(x.$$.fragment),at=l(),C=p("p"),C.innerHTML=bt,lt=l(),Z=p("p"),Z.innerHTML=Ut,nt=l(),o(B.$$.fragment),pt=l(),k=p("p"),k.textContent=It,it=l(),o(G.$$.fragment),mt=l(),N=p("p"),N.innerHTML=Wt,ot=l(),o(Q.$$.fragment),rt=l(),v=p("p"),v.innerHTML=$t,ht=l(),o(V.$$.fragment),ct=l(),o(E.$$.fragment),Mt=l(),R=p("p"),this.h()},l(t){const s=Qt("svelte-u9bgzb",document.head);w=i(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),Y=i(t,"P",{}),xt(Y).forEach(e),H=n(t),r(J.$$.fragment,t),z=n(t),g=i(t,"P",{"data-svelte-h":!0}),m(g)!=="svelte-lhf39w"&&(g.innerHTML=Jt),S=n(t),y=i(t,"P",{"data-svelte-h":!0}),m(y)!=="svelte-p7w55n"&&(y.textContent=gt),A=n(t),j=i(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-ye38bd"&&(j.textContent=yt),L=n(t),r(T.$$.fragment,t),D=n(t),u=i(t,"P",{"data-svelte-h":!0}),m(u)!=="svelte-18ywhxh"&&(u.textContent=jt),P=n(t),r(f.$$.fragment,t),q=n(t),b=i(t,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1c2ipa8"&&(b.textContent=Tt),K=n(t),r(U.$$.fragment,t),O=n(t),I=i(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1n9qsq1"&&(I.textContent=ut),tt=n(t),r(W.$$.fragment,t),st=n(t),$=i(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-19cnvx1"&&($.textContent=ft),et=n(t),r(x.$$.fragment,t),at=n(t),C=i(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1xxxcw3"&&(C.innerHTML=bt),lt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Ut),nt=n(t),r(B.$$.fragment,t),pt=n(t),k=i(t,"P",{"data-svelte-h":!0}),m(k)!=="svelte-9sr7nh"&&(k.textContent=It),it=n(t),r(G.$$.fragment,t),mt=n(t),N=i(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1kguc51"&&(N.innerHTML=Wt),ot=n(t),r(Q.$$.fragment,t),rt=n(t),v=i(t,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1n0coha"&&(v.innerHTML=$t),ht=n(t),r(V.$$.fragment,t),ct=n(t),r(E.$$.fragment,t),Mt=n(t),R=i(t,"P",{}),xt(R).forEach(e),this.h()},h(){Ct(w,"name","hf:doc:metadata"),Ct(w,"content",Et)},m(t,s){vt(document.head,w),a(t,X,s),a(t,Y,s),a(t,H,s),h(J,t,s),a(t,z,s),a(t,g,s),a(t,S,s),a(t,y,s),a(t,A,s),a(t,j,s),a(t,L,s),h(T,t,s),a(t,D,s),a(t,u,s),a(t,P,s),h(f,t,s),a(t,q,s),a(t,b,s),a(t,K,s),h(U,t,s),a(t,O,s),a(t,I,s),a(t,tt,s),h(W,t,s),a(t,st,s),a(t,$,s),a(t,et,s),h(x,t,s),a(t,at,s),a(t,C,s),a(t,lt,s),a(t,Z,s),a(t,nt,s),h(B,t,s),a(t,pt,s),a(t,k,s),a(t,it,s),h(G,t,s),a(t,mt,s),a(t,N,s),a(t,ot,s),h(Q,t,s),a(t,rt,s),a(t,v,s),a(t,ht,s),h(V,t,s),a(t,ct,s),h(E,t,s),a(t,Mt,s),a(t,R,s),dt=!0},p:Bt,i(t){dt||(c(J.$$.fragment,t),c(T.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c(W.$$.fragment,t),c(x.$$.fragment,t),c(B.$$.fragment,t),c(G.$$.fragment,t),c(Q.$$.fragment,t),c(V.$$.fragment,t),c(E.$$.fragment,t),dt=!0)},o(t){M(J.$$.fragment,t),M(T.$$.fragment,t),M(f.$$.fragment,t),M(U.$$.fragment,t),M(W.$$.fragment,t),M(x.$$.fragment,t),M(B.$$.fragment,t),M(G.$$.fragment,t),M(Q.$$.fragment,t),M(V.$$.fragment,t),M(E.$$.fragment,t),dt=!1},d(t){t&&(e(X),e(Y),e(H),e(z),e(g),e(S),e(y),e(A),e(j),e(L),e(D),e(u),e(P),e(q),e(b),e(K),e(O),e(I),e(tt),e(st),e($),e(et),e(at),e(C),e(lt),e(Z),e(nt),e(pt),e(k),e(it),e(mt),e(N),e(ot),e(rt),e(v),e(ht),e(ct),e(Mt),e(R)),e(w),d(J,t),d(T,t),d(f,t),d(U,t),d(W,t),d(x,t),d(B,t),d(G,t),d(Q,t),d(V,t),d(E,t)}}}const Et='{"title":"Instagram ResNeXt WSL","local":"instagram-resnext-wsl","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _t(wt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Gt{constructor(w){super(),Nt(this,w,_t,Vt,Zt,{})}}export{Ht as component};
