import{s as Pt,o as xt,n as it}from"../chunks/scheduler.182ea377.js";import{S as Zt,i as kt,g as l,s as i,r as u,A as Gt,h as r,f as n,c as s,j as ue,u as g,x as p,k as ge,y as c,a,v as h,d as _,t as b,w as M}from"../chunks/index.abf12888.js";import{T as Ut}from"../chunks/Tip.230e2334.js";import{D as ze}from"../chunks/Docstring.93f6f462.js";import{C as at}from"../chunks/CodeBlock.57fe6e13.js";import{E as jt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as B}from"../chunks/Heading.16916d63.js";function Bt(x){let o,v="If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the PIA checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){o=l("p"),o.innerHTML=v},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1a93myr"&&(o.innerHTML=v)},m(d,w){a(d,o,w)},p:it,d(d){d&&n(o)}}}function $t(x){let o,v="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){o=l("p"),o.innerHTML=v},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-xxwpr5"&&(o.innerHTML=v)},m(d,w){a(d,o,w)},p:it,d(d){d&&n(o)}}}function Wt(x){let o,v="Examples:",d,w,I;return w=new at({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    EulerDiscreteScheduler,
<span class="hljs-meta">... </span>    MotionAdapter,
<span class="hljs-meta">... </span>    PIAPipeline,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image
<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;../checkpoints/pia-diffusers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat in a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality, deformed, distorted, disfigured, bad eyes, wrong lips,weird mouth, bad teeth, mutated hands and fingers, bad anatomy,wrong anatomy, amputation, extra limb, missing limb, floating,limbs, disconnected limbs, mutation, ugly, disgusting, bad_pictures, negative_hand-neg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(image=image, prompt=prompt, negative_prompt=negative_prompt, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=v,d=i(),u(w.$$.fragment)},l(m){o=r(m,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=s(m),g(w.$$.fragment,m)},m(m,T){a(m,o,T),a(m,d,T),h(w,m,T),I=!0},p:it,i(m){I||(_(w.$$.fragment,m),I=!0)},o(m){b(w.$$.fragment,m),I=!1},d(m){m&&(n(o),n(d)),M(w,m)}}}function At(x){let o,v,d,w,I,m,T,_e,$,st='<a href="https://arxiv.org/abs/2312.13964" rel="nofollow">PIA: Your Personalized Image Animator via Plug-and-Play Modules in Text-to-Image Models</a> by Yiming Zhang, Zhening Xing, Yanhong Zeng, Youqing Fang, Kai Chen',be,W,ot="Recent advancements in personalized text-to-image (T2I) models have revolutionized content creation, empowering non-experts to generate stunning images with unique styles. While promising, adding realistic motions into these personalized images by text poses significant challenges in preserving distinct styles, high-fidelity details, and achieving motion controllability by text. In this paper, we present PIA, a Personalized Image Animator that excels in aligning with condition images, achieving motion controllability by text, and the compatibility with various personalized T2I models without specific tuning. To achieve these goals, PIA builds upon a base T2I model with well-trained temporal alignment layers, allowing for the seamless transformation of any personalized T2I model into an image animation model. A key component of PIA is the introduction of the condition module, which utilizes the condition frame and inter-frame affinity as input to transfer appearance information guided by the affinity hint for individual frame synthesis in the latent space. This design mitigates the challenges of appearance-related image alignment within and allows for a stronger focus on aligning with motion-related guidance.",Me,A,lt='<a href="https://pi-animator.github.io/" rel="nofollow">Project page</a>',ye,C,we,V,rt='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py" rel="nofollow">PIAPipeline</a></td> <td><em>Image-to-Video Generation with PIA</em></td> <td align="center"></td></tr></tbody>',ve,X,Ie,R,pt='Motion Adapter checkpoints for PIA can be found under the <a href="https://huggingface.co/openmmlab/PIA-condition-adapter" rel="nofollow">OpenMMLab org</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.5',Te,F,Je,Y,dt="PIA works with a MotionAdapter checkpoint and a Stable Diffusion 1.5 model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in the Stable Diffusion UNet. In addition to the motion modules, PIA also replaces the input convolution layer of the SD 1.5 UNet model with a 9 channel input convolution layer.",Ue,N,ct="The following example demonstrates how to use PIA to generate a video from a single image.",Pe,E,xe,S,mt="Here are some sample outputs:",Ze,z,ft=`<tbody><tr><td><center>cat in a field.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-default-output.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,ke,Z,Ge,H,je,L,ut='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',Be,Q,gt="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to PIA, AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",$e,D,ht="The following example demonstrates the usage of FreeInit.",We,q,Ae,O,_t=`<tbody><tr><td><center>cat in a field.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-freeinit-output-cat.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,Ce,k,Ve,K,Xe,f,ee,He,le,bt="Pipeline for text-to-video generation.",Le,re,Mt=`This model inherits from <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Qe,pe,yt="The pipeline also inherits the following loading methods:",De,de,wt='<li><a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.27.1/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',qe,J,te,Oe,ce,vt="The call function to the pipeline for generation.",Ke,G,et,j,ne,tt,me,It="Encodes the prompt into text encoder hidden states.",Re,ae,Tt="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_free_init</li> <li>disable_free_init</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",Fe,ie,Ye,U,se,nt,fe,Jt="Output class for PIAPipeline.",Ne,he,Ee;return I=new B({props:{title:"Image-to-Video Generation with PIA (Personalized Image Animator)",local:"image-to-video-generation-with-pia-personalized-image-animator",headingTag:"h1"}}),T=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new B({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),X=new B({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),F=new B({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),E=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpeDJwaXglMkZjYXRfNi5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIlMEEpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwaW4lMjBhJTIwZmllbGQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3cm9uZyUyMHdoaXRlJTIwYmFsYW5jZSUyQyUyMGRhcmslMkMlMjBza2V0Y2hlcyUyQ3dvcnN0JTIwcXVhbGl0eSUyQ2xvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoaW1hZ2UlM0RpbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciklMEFmcmFtZXMlMjAlM0QlMjBvdXRwdXQuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b19naWYoZnJhbWVzJTJDJTIwJTIycGlhLWFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    EulerDiscreteScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),Z=new Ut({props:{$$slots:{default:[Bt]},$$scope:{ctx:x}}}),H=new B({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),q=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMERESU1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyKSUwQSUwQSUyMyUyMGVuYWJsZSUyMEZyZWVJbml0JTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMGVuYWJsZV9mcmVlX2luaXQlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwYSUyMGZ1bGwlMjBsaXN0JTIwb2YlMjBjb25maWd1cmFibGUlMjBwYXJhbWV0ZXJzJTBBcGlwZS5lbmFibGVfZnJlZV9pbml0KG1ldGhvZCUzRCUyMmJ1dHRlcndvcnRoJTIyJTJDJTIwdXNlX2Zhc3Rfc2FtcGxpbmclM0RUcnVlKSUwQSUwQSUyMyUyME1lbW9yeSUyMHNhdmluZyUyMG9wdGlvbnMlMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXgycGl4JTJGY2F0XzYucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMGluJTIwYSUyMGZpZWxkJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyd3JvbmclMjB3aGl0ZSUyMGJhbGFuY2UlMkMlMjBkYXJrJTJDJTIwc2tldGNoZXMlMkN3b3JzdCUyMHF1YWxpdHklMkNsb3clMjBxdWFsaXR5JTIyJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW1hZ2UlMkMlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMnBpYS1mcmVlaW5pdC1hbmltYXRpb24uZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Memory saving options</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-freeinit-animation.gif&quot;</span>)`,wrap:!1}}),k=new Ut({props:{warning:!0,$$slots:{default:[$t]},$$scope:{ctx:x}}}),K=new B({props:{title:"PIAPipeline",local:"diffusers.PIAPipeline",headingTag:"h2"}}),ee=new ze({props:{name:"class diffusers.PIAPipeline",anchor:"diffusers.PIAPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"scheduler",val:": Union"},{name:"motion_adapter",val:": Optional = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PIAPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.PIAPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.PIAPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.27.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.PIAPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.PIAPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.27.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.27.1/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.27.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.1/src/diffusers/pipelines/pia/pipeline_pia.py#L213"}}),te=new ze({props:{name:"__call__",anchor:"diffusers.PIAPipeline.__call__",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Union = None"},{name:"strength",val:": float = 1.0"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"motion_scale",val:": int = 0"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to be used for video generation.`,name:"image"},{anchor:"diffusers.PIAPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.PIAPipeline.__call__.strength",description:"<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1.",name:"strength"},{anchor:"diffusers.PIAPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.PIAPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.PIAPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.PIAPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PIAPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.27.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.PIAPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.PIAPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.PIAPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.
motion_scale &#x2014; (<code>int</code>, <em>optional</em>, defaults to 0):
Parameter that controls the amount and type of motion that is added to the image. Increasing the value increases the amount of motion, while specific
ranges of values control the type of motion that is added. Must be between 0 and 8.
Set between 0-2 to only increase the amount of motion.
Set between 3-5 to create looping motion.
Set between 6-8 to perform motion with image style transfer.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.PIAPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PIAPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.1/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PIAPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.PIAPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.1/src/diffusers/pipelines/pia/pipeline_pia.py#L754",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.1/en/api/pipelines/pia#diffusers.pipelines.pia.PIAPipelineOutput"
>PIAPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.1/en/api/pipelines/pia#diffusers.pipelines.pia.PIAPipelineOutput"
>PIAPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new jt({props:{anchor:"diffusers.PIAPipeline.__call__.example",$$slots:{default:[Wt]},$$scope:{ctx:x}}}),ne=new ze({props:{name:"encode_prompt",anchor:"diffusers.PIAPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.PIAPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.1/src/diffusers/pipelines/pia/pipeline_pia.py#L290"}}),ie=new B({props:{title:"PIAPipelineOutput",local:"diffusers.pipelines.pia.PIAPipelineOutput",headingTag:"h2"}}),se=new ze({props:{name:"class diffusers.pipelines.pia.PIAPipelineOutput",anchor:"diffusers.pipelines.pia.PIAPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.frames",description:"<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;",name:"frames"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.Nested",description:"<strong>Nested</strong> list of length <code>batch_size</code> with denoised PIL image sequences of length <code>num_frames</code>, &#x2014;",name:"Nested"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.NumPy",description:"<strong>NumPy</strong> array of shape `(batch_size, num_frames, channels, height, width, &#x2014;",name:"NumPy"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.Torch",description:"<strong>Torch</strong> tensor of shape <code>(batch_size, num_frames, channels, height, width)</code>. &#x2014;",name:"Torch"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.1/src/diffusers/pipelines/pia/pipeline_pia.py#L198"}}),{c(){o=l("meta"),v=i(),d=l("p"),w=i(),u(I.$$.fragment),m=i(),u(T.$$.fragment),_e=i(),$=l("p"),$.innerHTML=st,be=i(),W=l("p"),W.textContent=ot,Me=i(),A=l("p"),A.innerHTML=lt,ye=i(),u(C.$$.fragment),we=i(),V=l("table"),V.innerHTML=rt,ve=i(),u(X.$$.fragment),Ie=i(),R=l("p"),R.innerHTML=pt,Te=i(),u(F.$$.fragment),Je=i(),Y=l("p"),Y.textContent=dt,Ue=i(),N=l("p"),N.textContent=ct,Pe=i(),u(E.$$.fragment),xe=i(),S=l("p"),S.textContent=mt,Ze=i(),z=l("table"),z.innerHTML=ft,ke=i(),u(Z.$$.fragment),Ge=i(),u(H.$$.fragment),je=i(),L=l("p"),L.innerHTML=ut,Be=i(),Q=l("p"),Q.textContent=gt,$e=i(),D=l("p"),D.textContent=ht,We=i(),u(q.$$.fragment),Ae=i(),O=l("table"),O.innerHTML=_t,Ce=i(),u(k.$$.fragment),Ve=i(),u(K.$$.fragment),Xe=i(),f=l("div"),u(ee.$$.fragment),He=i(),le=l("p"),le.textContent=bt,Le=i(),re=l("p"),re.innerHTML=Mt,Qe=i(),pe=l("p"),pe.textContent=yt,De=i(),de=l("ul"),de.innerHTML=wt,qe=i(),J=l("div"),u(te.$$.fragment),Oe=i(),ce=l("p"),ce.textContent=vt,Ke=i(),u(G.$$.fragment),et=i(),j=l("div"),u(ne.$$.fragment),tt=i(),me=l("p"),me.textContent=It,Re=i(),ae=l("ul"),ae.innerHTML=Tt,Fe=i(),u(ie.$$.fragment),Ye=i(),U=l("div"),u(se.$$.fragment),nt=i(),fe=l("p"),fe.textContent=Jt,Ne=i(),he=l("p"),this.h()},l(e){const t=Gt("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(n),v=s(e),d=r(e,"P",{}),ue(d).forEach(n),w=s(e),g(I.$$.fragment,e),m=s(e),g(T.$$.fragment,e),_e=s(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-nano8w"&&($.innerHTML=st),be=s(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1jcs7ly"&&(W.textContent=ot),Me=s(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-q609lx"&&(A.innerHTML=lt),ye=s(e),g(C.$$.fragment,e),we=s(e),V=r(e,"TABLE",{"data-svelte-h":!0}),p(V)!=="svelte-5p4fpx"&&(V.innerHTML=rt),ve=s(e),g(X.$$.fragment,e),Ie=s(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1bi1ry7"&&(R.innerHTML=pt),Te=s(e),g(F.$$.fragment,e),Je=s(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-woui0n"&&(Y.textContent=dt),Ue=s(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-wwfxrb"&&(N.textContent=ct),Pe=s(e),g(E.$$.fragment,e),xe=s(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1pxzje"&&(S.textContent=mt),Ze=s(e),z=r(e,"TABLE",{"data-svelte-h":!0}),p(z)!=="svelte-7kzy88"&&(z.innerHTML=ft),ke=s(e),g(Z.$$.fragment,e),Ge=s(e),g(H.$$.fragment,e),je=s(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-a52po1"&&(L.innerHTML=ut),Be=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-bwalkj"&&(Q.textContent=gt),$e=s(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1qq4ux4"&&(D.textContent=ht),We=s(e),g(q.$$.fragment,e),Ae=s(e),O=r(e,"TABLE",{"data-svelte-h":!0}),p(O)!=="svelte-fegy4a"&&(O.innerHTML=_t),Ce=s(e),g(k.$$.fragment,e),Ve=s(e),g(K.$$.fragment,e),Xe=s(e),f=r(e,"DIV",{class:!0});var y=ue(f);g(ee.$$.fragment,y),He=s(y),le=r(y,"P",{"data-svelte-h":!0}),p(le)!=="svelte-19ipoo4"&&(le.textContent=bt),Le=s(y),re=r(y,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1t9e089"&&(re.innerHTML=Mt),Qe=s(y),pe=r(y,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-14s6m4u"&&(pe.textContent=yt),De=s(y),de=r(y,"UL",{"data-svelte-h":!0}),p(de)!=="svelte-l6o9v4"&&(de.innerHTML=wt),qe=s(y),J=r(y,"DIV",{class:!0});var P=ue(J);g(te.$$.fragment,P),Oe=s(P),ce=r(P,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-50j04k"&&(ce.textContent=vt),Ke=s(P),g(G.$$.fragment,P),P.forEach(n),et=s(y),j=r(y,"DIV",{class:!0});var oe=ue(j);g(ne.$$.fragment,oe),tt=s(oe),me=r(oe,"P",{"data-svelte-h":!0}),p(me)!=="svelte-16q0ax1"&&(me.textContent=It),oe.forEach(n),y.forEach(n),Re=s(e),ae=r(e,"UL",{"data-svelte-h":!0}),p(ae)!=="svelte-1piu0vk"&&(ae.innerHTML=Tt),Fe=s(e),g(ie.$$.fragment,e),Ye=s(e),U=r(e,"DIV",{class:!0});var Se=ue(U);g(se.$$.fragment,Se),nt=s(Se),fe=r(Se,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-6skj8c"&&(fe.textContent=Jt),Se.forEach(n),Ne=s(e),he=r(e,"P",{}),ue(he).forEach(n),this.h()},h(){ge(o,"name","hf:doc:metadata"),ge(o,"content",Ct),ge(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ge(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ge(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ge(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,o),a(e,v,t),a(e,d,t),a(e,w,t),h(I,e,t),a(e,m,t),h(T,e,t),a(e,_e,t),a(e,$,t),a(e,be,t),a(e,W,t),a(e,Me,t),a(e,A,t),a(e,ye,t),h(C,e,t),a(e,we,t),a(e,V,t),a(e,ve,t),h(X,e,t),a(e,Ie,t),a(e,R,t),a(e,Te,t),h(F,e,t),a(e,Je,t),a(e,Y,t),a(e,Ue,t),a(e,N,t),a(e,Pe,t),h(E,e,t),a(e,xe,t),a(e,S,t),a(e,Ze,t),a(e,z,t),a(e,ke,t),h(Z,e,t),a(e,Ge,t),h(H,e,t),a(e,je,t),a(e,L,t),a(e,Be,t),a(e,Q,t),a(e,$e,t),a(e,D,t),a(e,We,t),h(q,e,t),a(e,Ae,t),a(e,O,t),a(e,Ce,t),h(k,e,t),a(e,Ve,t),h(K,e,t),a(e,Xe,t),a(e,f,t),h(ee,f,null),c(f,He),c(f,le),c(f,Le),c(f,re),c(f,Qe),c(f,pe),c(f,De),c(f,de),c(f,qe),c(f,J),h(te,J,null),c(J,Oe),c(J,ce),c(J,Ke),h(G,J,null),c(f,et),c(f,j),h(ne,j,null),c(j,tt),c(j,me),a(e,Re,t),a(e,ae,t),a(e,Fe,t),h(ie,e,t),a(e,Ye,t),a(e,U,t),h(se,U,null),c(U,nt),c(U,fe),a(e,Ne,t),a(e,he,t),Ee=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),Z.$set(y);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),k.$set(P);const oe={};t&2&&(oe.$$scope={dirty:t,ctx:e}),G.$set(oe)},i(e){Ee||(_(I.$$.fragment,e),_(T.$$.fragment,e),_(C.$$.fragment,e),_(X.$$.fragment,e),_(F.$$.fragment,e),_(E.$$.fragment,e),_(Z.$$.fragment,e),_(H.$$.fragment,e),_(q.$$.fragment,e),_(k.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(G.$$.fragment,e),_(ne.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),Ee=!0)},o(e){b(I.$$.fragment,e),b(T.$$.fragment,e),b(C.$$.fragment,e),b(X.$$.fragment,e),b(F.$$.fragment,e),b(E.$$.fragment,e),b(Z.$$.fragment,e),b(H.$$.fragment,e),b(q.$$.fragment,e),b(k.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(G.$$.fragment,e),b(ne.$$.fragment,e),b(ie.$$.fragment,e),b(se.$$.fragment,e),Ee=!1},d(e){e&&(n(v),n(d),n(w),n(m),n(_e),n($),n(be),n(W),n(Me),n(A),n(ye),n(we),n(V),n(ve),n(Ie),n(R),n(Te),n(Je),n(Y),n(Ue),n(N),n(Pe),n(xe),n(S),n(Ze),n(z),n(ke),n(Ge),n(je),n(L),n(Be),n(Q),n($e),n(D),n(We),n(Ae),n(O),n(Ce),n(Ve),n(Xe),n(f),n(Re),n(ae),n(Fe),n(Ye),n(U),n(Ne),n(he)),n(o),M(I,e),M(T,e),M(C,e),M(X,e),M(F,e),M(E,e),M(Z,e),M(H,e),M(q,e),M(k,e),M(K,e),M(ee),M(te),M(G),M(ne),M(ie,e),M(se)}}}const Ct='{"title":"Image-to-Video Generation with PIA (Personalized Image Animator)","local":"image-to-video-generation-with-pia-personalized-image-animator","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"PIAPipeline","local":"diffusers.PIAPipeline","sections":[],"depth":2},{"title":"PIAPipelineOutput","local":"diffusers.pipelines.pia.PIAPipelineOutput","sections":[],"depth":2}],"depth":1}';function Vt(x){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Zt{constructor(o){super(),kt(this,o,Vt,At,Pt,{})}}export{zt as component};
