import{s as Gp,f as b,n as Rp,o as Yp}from"../chunks/scheduler.37c15a92.js";import{S as Ep,i as Xp,g as i,s,r as p,A as Vp,h as o,f as l,c as a,j as kp,u as m,x as r,k as c,y as Sp,a as n,v as u,d as M,t as h,w as d}from"../chunks/index.7cb9c9b8.js";import{C as y}from"../chunks/CodeBlock.abae2786.js";import{C as Fp}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as f,E as Qp}from"../chunks/getInferenceSnippets.15b814d1.js";function zp(Oi){let g,nn,tn,sn,U,an,J,on,C,Ki=`Now that you’ve studied the bases of Reinforcement Learning, you’re ready to train your first agent and share it with the community through the Hub 🔥:
A Lunar Lander agent that will learn to land correctly on the Moon 🌕`,rn,I,eo,pn,$,to="And finally, you’ll <strong>upload this trained agent to the Hugging Face Hub 🤗, a free, open platform where people can share ML models, datasets, and demos.</strong>",mn,_,lo='Thanks to our <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard">leaderboard</a>, you’ll be able to compare your results with other classmates and exchange the best practices to improve your agent’s scores. Who will win the challenge for Unit 1 🏆?',un,Z,no='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained model to the Hub and <strong>get a result of &gt;= 200</strong>.',Mn,B,so='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',hn,L,ao="<strong>If you don’t find your model, go to the bottom of the page and click on the refresh button.</strong>",dn,W,io='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',cn,H,oo='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',fn,x,ro="So let’s get started! 🚀",yn,k,po="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",bn,G,mo='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit1/unit1.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',gn,R,uo="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",wn,Y,Mo="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",Tn,E,vn,w,ho,jn,X,co='In this notebook, you’ll train your <strong>first Deep Reinforcement Learning agent</strong> a Lunar Lander agent that will learn to <strong>land correctly on the Moon 🌕</strong>. Using <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable-Baselines3</a> a Deep Reinforcement Learning library, share them with the community, and experiment with different configurations',Un,V,Jn,S,fo='<li><a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">LunarLander-v2</a></li>',Cn,F,In,Q,yo='<li><a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable-Baselines3</a></li>',$n,z,bo='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the Github Repo</a>.',_n,P,Zn,A,go="At the end of the notebook, you will:",Bn,N,wo="<li>Be able to use <strong>Gymnasium</strong>, the environment library.</li> <li>Be able to use <strong>Stable-Baselines3</strong>, the deep reinforcement learning library.</li> <li>Be able to <strong>push your trained agent to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Ln,D,Wn,q,To,Hn,O,vo="In this free course, you will:",xn,K,jo="<li>📖 Study Deep Reinforcement Learning in <strong>theory and practice</strong>.</li> <li>🧑‍💻 Learn to <strong>use famous Deep RL libraries</strong> such as Stable Baselines3, RL Baselines3 Zoo, CleanRL and Sample Factory 2.0.</li> <li>🤖 Train <strong>agents in unique environments</strong></li> <li>🎓 <strong>Earn a certificate of completion</strong> by completing 80% of the assignments.</li>",kn,ee,Uo="And more!",Gn,te,Jo='Check 📚 the syllabus 👉 <a href="https://simoninithomas.github.io/deep-rl-course" rel="nofollow">https://simoninithomas.github.io/deep-rl-course</a>',Rn,le,Co='Don’t forget to <strong><a href="http://eepurl.com/ic5ZUD">sign up to the course</a></strong> (we are collecting your email to be able to <strong>send you the links when each Unit is published and give you information about the challenges and updates).</strong>',Yn,ne,Io='The best way to keep in touch and ask questions is <strong>to join our discord server</strong> to exchange with the community and with us 👉🏻 <a href="https://discord.gg/ydHrjt3WP5" rel="nofollow">https://discord.gg/ydHrjt3WP5</a>',En,se,Xn,ae,$o="Before diving into the notebook, you need to:",Vn,ie,_o='🔲 📝 <strong><a href="https://huggingface.co/deep-rl-course/unit0/introduction" rel="nofollow">Read Unit 0</a></strong> that gives you all the <strong>information about the course and helps you to onboard</strong> 🤗',Sn,oe,Zo='🔲 📚 <strong>Develop an understanding of the foundations of Reinforcement learning</strong> (MC, TD, Rewards hypothesis…) by <a href="https://huggingface.co/deep-rl-course/unit1/introduction" rel="nofollow">reading Unit 1</a>.',Fn,re,Qn,T,Bo,zn,pe,Lo="Let’s do a small recap on what we learned in the first Unit:",Pn,me,Wo="<li><p>Reinforcement Learning is a <strong>computational approach to learning from actions</strong>. We build an agent that learns from the environment by <strong>interacting with it through trial and error</strong> and receiving rewards (negative or positive) as feedback.</p></li> <li><p>The goal of any RL agent is to <strong>maximize its expected cumulative reward</strong> (also called expected return) because RL is based on the <em>reward hypothesis</em>, which is that all goals can be described as the maximization of an expected cumulative reward.</p></li> <li><p>The RL process is a <strong>loop that outputs a sequence of state, action, reward, and next state</strong>.</p></li> <li><p>To calculate the expected cumulative reward (expected return), <strong>we discount the rewards</strong>: the rewards that come sooner (at the beginning of the game) are more probable to happen since they are more predictable than the long-term future reward.</p></li> <li><p>To solve an RL problem, you want to <strong>find an optimal policy</strong>; the policy is the “brain” of your AI that will tell us what action to take given a state. The optimal one is the one that gives you the actions that max the expected return.</p></li>",An,ue,Ho="There are <strong>two</strong> ways to find your optimal policy:",Nn,Me,xo="<li><p>By <strong>training your policy directly</strong>: policy-based methods.</p></li> <li><p>By <strong>training a value function</strong> that tells us the expected return the agent will get at each state and use this function to define our policy: value-based methods.</p></li> <li><p>Finally, we spoke about Deep RL because <strong>we introduce deep neural networks to estimate the action to take (policy-based) or to estimate the value of a state (value-based) hence the name “deep.”</strong></p></li>",Dn,he,qn,de,On,ce,ko='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained model to the Hub and <strong>get a result of &gt;= 200</strong>.',Kn,fe,Go='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',es,ye,Ro='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',ts,be,ls,ge,Yo="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",ns,we,Eo,ss,Te,Xo="<li><code>Hardware Accelerator &gt; GPU</code></li>",as,ve,Vo,is,je,os,Ue,So="The first step is to install the dependencies, we’ll install multiple ones.",rs,Je,Fo="<li><code>gymnasium[box2d]</code>: Contains the LunarLander-v2 environment 🌛</li> <li><code>stable-baselines3[extra]</code>: The deep reinforcement learning library.</li> <li><code>huggingface_sb3</code>: Additional code for Stable-baselines3 to load and upload models from the Hugging Face 🤗 Hub.</li>",ps,Ce,Qo="To make things easier, we created a script to install all these dependencies.",ms,Ie,us,$e,Ms,_e,zo="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",hs,Ze,Po="Hence the following cell will install virtual screen libraries and create and run a virtual screen 🖥",ds,Be,cs,Le,Ao="To make sure the new installed libraries are used, <strong>sometimes it’s required to restart the notebook runtime</strong>. The next cell will force the <strong>runtime to crash, so you’ll need to connect again and run the code starting from here</strong>. Thanks to this trick, <strong>we will be able to run our virtual screen.</strong>",fs,We,ys,He,bs,xe,gs,ke,No="One additional library we import is huggingface_hub <strong>to be able to upload and download trained models from the hub</strong>.",ws,Ge,Do="The Hugging Face Hub 🤗 works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations and other features that will allow you to easily collaborate with others.",Ts,Re,qo='You can see here all the Deep reinforcement Learning models available here👉 <a href="https://huggingface.co/models?pipeline_tag=reinforcement-learning&amp;sort=downloads" rel="nofollow">https://huggingface.co/models?pipeline_tag=reinforcement-learning&amp;sort=downloads</a>',vs,Ye,js,Ee,Us,Xe,Oo=`🏋 The library containing our environment is called Gymnasium.
<strong>You’ll use Gymnasium a lot in Deep Reinforcement Learning.</strong>`,Js,Ve,Ko='Gymnasium is the <strong>new version of Gym library</strong> <a href="https://farama.org/" rel="nofollow">maintained by the Farama Foundation</a>.',Cs,Se,er="The Gymnasium library provides two things:",Is,Fe,tr="<li>An interface that allows you to <strong>create RL environments</strong>.</li> <li>A <strong>collection of environments</strong> (gym-control, atari, box2D…).</li>",$s,Qe,lr="Let’s look at an example, but first let’s recall the RL loop.",_s,v,nr,Zs,ze,sr="At each step:",Bs,Pe,ar="<li>Our Agent receives a <strong>state (S0)</strong> from the <strong>Environment</strong> — we receive the first frame of our game (Environment).</li> <li>Based on that <strong>state (S0),</strong> the Agent takes an <strong>action (A0)</strong> — our Agent will move to the right.</li> <li>The environment transitions to a <strong>new</strong> <strong>state (S1)</strong> — new frame.</li> <li>The environment gives some <strong>reward (R1)</strong> to the Agent — we’re not dead <em>(Positive Reward +1)</em>.</li>",Ls,Ae,ir="With Gymnasium:",Ws,Ne,or="1️⃣ We create our environment using <code>gymnasium.make()</code>",Hs,De,rr="2️⃣ We reset the environment to its initial state with <code>observation = env.reset()</code>",xs,qe,pr="At each step:",ks,Oe,mr="3️⃣ Get an action using our model (in our example we take a random action)",Gs,Ke,ur="4️⃣ Using <code>env.step(action)</code>, we perform this action in the environment and get",Rs,et,Mr="<li><code>observation</code>: The new state (st+1)</li> <li><code>reward</code>: The reward we get after executing the action</li> <li><code>terminated</code>: Indicates if the episode terminated (agent reach the terminal state)</li> <li><code>truncated</code>: Introduced with this new version, it indicates a timelimit or if an agent go out of bounds of the environment for instance.</li> <li><code>info</code>: A dictionary that provides additional information (depends on the environment).</li>",Ys,tt,hr='For more explanations check this 👉 <a href="https://gymnasium.farama.org/api/env/#gymnasium.Env.step" rel="nofollow">https://gymnasium.farama.org/api/env/#gymnasium.Env.step</a>',Es,lt,dr="If the episode is terminated:",Xs,nt,cr="<li>We reset the environment to its initial state with <code>observation = env.reset()</code></li>",Vs,st,fr="<strong>Let’s look at an example!</strong> Make sure to read the code",Ss,at,Fs,it,Qs,ot,zs,rt,yr='In this first tutorial, we’re going to train our agent, a <a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">Lunar Lander</a>, <strong>to land correctly on the moon</strong>. To do that, the agent needs to learn <strong>to adapt its speed and position (horizontal, vertical, and angular) to land correctly.</strong>',Ps,As,Ns,pt,br="💡 A good habit when you start to use an environment is to check its documentation",Ds,mt,gr='👉 <a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">https://gymnasium.farama.org/environments/box2d/lunar_lander/</a>',qs,Os,Ks,ut,wr="Let’s see what the Environment looks like:",ea,Mt,ta,ht,Tr="We see with <code>Observation Space Shape (8,)</code> that the observation is a vector of size 8, where each value contains different information about the lander:",la,dt,vr="<li>Horizontal pad coordinate (x)</li> <li>Vertical pad coordinate (y)</li> <li>Horizontal speed (x)</li> <li>Vertical speed (y)</li> <li>Angle</li> <li>Angular speed</li> <li>If the left leg contact point has touched the land (boolean)</li> <li>If the right leg contact point has touched the land (boolean)</li>",na,ct,sa,ft,jr="The action space (the set of possible actions the agent can take) is discrete with 4 actions available 🎮:",aa,yt,Ur="<li>Action 0: Do nothing,</li> <li>Action 1: Fire left orientation engine,</li> <li>Action 2: Fire the main engine,</li> <li>Action 3: Fire right orientation engine.</li>",ia,bt,Jr="Reward function (the function that will give a reward at each timestep) 💰:",oa,gt,Cr="After every step a reward is granted. The total reward of an episode is the <strong>sum of the rewards for all the steps within that episode</strong>.",ra,wt,Ir="For each step, the reward:",pa,Tt,$r="<li>Is increased/decreased the closer/further the lander is to the landing pad.</li> <li>Is increased/decreased the slower/faster the lander is moving.</li> <li>Is decreased the more the lander is tilted (angle not horizontal).</li> <li>Is increased by 10 points for each leg that is in contact with the ground.</li> <li>Is decreased by 0.03 points each frame a side engine is firing.</li> <li>Is decreased by 0.3 points each frame the main engine is firing.</li>",ma,vt,_r="The episode receive an <strong>additional reward of -100 or +100 points for crashing or landing safely respectively.</strong>",ua,jt,Zr="An episode is <strong>considered a solution if it scores at least 200 points.</strong>",Ma,Ut,ha,Jt,Br="<li>We create a vectorized environment (a method for stacking multiple independent environments into a single environment) of 16 environments, this way, <strong>we’ll have more diverse experiences during the training.</strong></li>",da,Ct,ca,It,fa,$t,Lr='<li><p>We have studied our environment and we understood the problem: <strong>being able to land the Lunar Lander to the Landing Pad correctly by controlling left, right and main orientation engine</strong>. Now let’s build the algorithm we’re going to use to solve this Problem 🚀.</p></li> <li><p>To do so, we’re going to use our first Deep RL library, <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable Baselines3 (SB3)</a>.</p></li> <li><p>SB3 is a set of <strong>reliable implementations of reinforcement learning algorithms in PyTorch</strong>.</p></li>',ya,ba,ga,_t,Wr='💡 A good habit when using a new library is to dive first on the documentation: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/</a> and then try some tutorials.',wa,Ta,va,Zt,Hr,ja,Bt,xr='To solve this problem, we’re going to use SB3 <strong>PPO</strong>. <a href="https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#example%5D" rel="nofollow">PPO (aka Proximal Policy Optimization) is one of the SOTA (state of the art) Deep Reinforcement Learning algorithms that you’ll study during this course</a>.',Ua,Lt,kr="PPO is a combination of:",Ja,Wt,Gr="<li><em>Value-based reinforcement learning method</em>: learning an action-value function that will tell us the <strong>most valuable action to take given a state and action</strong>.</li> <li><em>Policy-based reinforcement learning method</em>: learning a policy that will <strong>give us a probability distribution over actions</strong>.</li>",Ca,Ht,Rr="Stable-Baselines3 is easy to set up:",Ia,xt,Yr="1️⃣ You <strong>create your environment</strong> (in our case it was done above)",$a,kt,Er="2️⃣ You define the <strong>model you want to use and instantiate this model</strong> <code>model = PPO(&quot;MlpPolicy&quot;)</code>",_a,Gt,Xr="3️⃣ You <strong>train the agent</strong> with <code>model.learn</code> and define the number of training timesteps",Za,Rt,Ba,Yt,La,Et,Wa,Xt,Ha,Vt,xa,St,Vr="<li>Let’s train our agent for 1,000,000 timesteps, don’t forget to use GPU on Colab. It will take approximately ~20min, but you can use fewer timesteps if you just want to try it out.</li> <li>During the training, take a ☕ break you deserved it 🤗</li>",ka,Ft,Ga,Qt,Ra,zt,Ya,Pt,Ea,At,Sr='<li>Remember to wrap the environment in a <a href="https://stable-baselines3.readthedocs.io/en/master/common/monitor.html" rel="nofollow">Monitor</a>.</li> <li>Now that our Lunar Lander agent is trained 🚀, we need to <strong>check its performance</strong>.</li> <li>Stable-Baselines3 provides a method to do that: <code>evaluate_policy</code>.</li> <li>To fill that part you need to <a href="https://stable-baselines3.readthedocs.io/en/master/guide/examples.html#basic-usage-training-saving-loading" rel="nofollow">check the documentation</a></li> <li>In the next step,  we’ll see <strong>how to automatically evaluate and share your agent to compete in a leaderboard, but for now let’s do it ourselves</strong></li>',Xa,Nt,Fr="💡 When you evaluate your agent, you should not use your training environment but create an evaluation environment.",Va,Dt,Sa,qt,Fa,Ot,Qa,Kt,Qr="<li>In my case, I got a mean reward of <code>200.20 +/- 20.80</code> after training for 1 million steps, which means that our lunar lander agent is ready to land on the moon 🌛🥳.</li>",za,el,Pa,tl,zr="Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.",Aa,ll,Pr='📚 The libraries documentation 👉 <a href="https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face--x-stable-baselines3-v20" rel="nofollow">https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face—x-stable-baselines3-v20</a>',Na,nl,Ar="Here’s an example of a Model Card (with Space Invaders):",Da,sl,Nr="By using <code>package_to_hub</code> <strong>you evaluate, record a replay, generate a model card of your agent and push it to the hub</strong>.",qa,al,Dr="This way:",Oa,il,qr='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share with the community an agent that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',Ka,ol,Or="To be able to share your model with the community there are three more steps to follow:",ei,rl,Kr='1️⃣ (If it’s not already done) create an account on Hugging Face ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',ti,pl,ep="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",li,ml,tp='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',ni,ul,lp,si,Ml,np="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",ai,hl,ii,dl,sp="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",oi,cl,ap="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function",ri,fl,ip="Let’s fill the <code>package_to_hub</code> function:",pi,yl,op="<li><code>model</code>: our trained model.</li> <li><code>model_name</code>: the name of the trained model that we defined in <code>model_save</code></li> <li><code>model_architecture</code>: the model architecture we used, in our case PPO</li> <li><code>env_id</code>: the name of the environment, in our case <code>LunarLander-v2</code></li> <li><code>eval_env</code>: the evaluation environment defined in eval_env</li> <li><code>repo_id</code>: the name of the Hugging Face Hub Repository that will be created/updated <code>(repo_id = {username}/{repo_name})</code></li>",mi,bl,rp="💡 <strong>A good name is <code>{username}/{model_architecture}-{env_id}</code></strong>",ui,gl,pp="<li><code>commit_message</code>: message of the commit</li>",Mi,wl,hi,Tl,di,vl,ci,jl,mp='Congrats 🥳 you’ve just trained and uploaded your first Deep Reinforcement Learning agent. The script above should have displayed a link to a model repository such as <a href="https://huggingface.co/osanseviero/test_sb3" rel="nofollow">https://huggingface.co/osanseviero/test_sb3</a>. When you go to this link, you can:',fi,Ul,up="<li>See a video preview of your agent at the right.</li> <li>Click “Files and versions” to see all the files in the repository.</li> <li>Click “Use in stable-baselines3” to get a code snippet that shows how to load the model.</li> <li>A model card (<code>README.md</code> file) which gives a description of the model</li>",yi,Jl,Mp="Under the hood, the Hub uses git-based repositories (don’t worry if you don’t know what git is), which means you can update the model with new versions as you experiment and improve your agent.",bi,Cl,hp='Compare the results of your LunarLander-v2 with your classmates using the leaderboard 🏆 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a>',gi,Il,wi,$l,dp='Thanks to <a href="https://github.com/ironbar" rel="nofollow">ironbar</a> for the contribution.',Ti,_l,cp="Loading a saved model from the Hub is really easy.",vi,Zl,fp='You go to <a href="https://huggingface.co/models?library=stable-baselines3" rel="nofollow">https://huggingface.co/models?library=stable-baselines3</a> to see the list of all the Stable-baselines3 saved models.',ji,Bl,yp="<li>You select one and copy its repo_id</li>",Ui,Ll,bp,Ji,j,gp="<li>Then we just need to use load_from_hub with:</li>",Ci,Wl,wp="<li>The repo_id</li> <li>The filename: the saved model inside the repo and its extension (*.zip)</li>",Ii,Hl,Tp="Because the model I download from the Hub was trained with Gym (the former version of Gymnasium) we need to install shimmy a API conversion tool that will help us to run the environment correctly.",$i,xl,vp='Shimmy Documentation: <a href="https://github.com/Farama-Foundation/Shimmy" rel="nofollow">https://github.com/Farama-Foundation/Shimmy</a>',_i,kl,Zi,Gl,Bi,Rl,jp="Let’s evaluate this agent:",Li,Yl,Wi,El,Hi,Xl,Up="The best way to learn <strong>is to try things by your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. With 1,000,000 steps, we saw some great results!",xi,Vl,Jp='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',ki,Sl,Cp="Here are some ideas to achieve so:",Gi,Fl,Ip='<li>Train more steps</li> <li>Try different hyperparameters for <code>PPO</code>. You can see them at <a href="https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#parameters" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#parameters</a>.</li> <li>Check the <a href="https://stable-baselines3.readthedocs.io/en/master/modules/dqn.html" rel="nofollow">Stable-Baselines3 documentation</a> and try another model such as DQN.</li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li>',Ri,Ql,$p='<strong>Compare the results of your LunarLander-v2 with your classmates</strong> using the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> 🏆',Yi,zl,_p='Is moon landing too boring for you? Try to <strong>change the environment</strong>, why not use MountainCar-v0, CartPole-v1 or CarRacing-v0? Check how they work <a href="https://www.gymlibrary.dev/" rel="nofollow">using the gym documentation</a> and have fun 🎉.',Ei,Xi,Vi,Pl,Zp="Congrats on finishing this chapter! That was the biggest one, <strong>and there was a lot of information.</strong>",Si,Al,Bp="If you’re still feel confused with all these elements…it’s totally normal! <strong>This was the same for me and for all people who studied RL.</strong>",Fi,Nl,Lp="Take time to really <strong>grasp the material before continuing and try the additional challenges</strong>. It’s important to master these elements and have a solid foundations.",Qi,Dl,Wp="Naturally, during the course, we’re going to dive deeper into these concepts but <strong>it’s better to have a good understanding of them now before diving into the next chapters.</strong>",zi,ql,Hp="Next time, in the bonus unit 1, you’ll train Huggy the Dog to fetch the stick.",Pi,Ol,xp,Ai,Kl,Ni,en,Di,ln,qi;return U=new f({props:{title:"Train your first Deep Reinforcement Learning Agent 🤖",local:"hands-on",headingTag:"h1"}}),J=new Fp({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit1/unit1.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),E=new f({props:{title:"Unit 1: Train your first Deep Reinforcement Learning Agent 🤖",local:"unit-1-train-your-first-deep-reinforcement-learning-agent-",headingTag:"h1"}}),V=new f({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h3"}}),F=new f({props:{title:"The library used 📚",local:"the-library-used-",headingTag:"h3"}}),P=new f({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),D=new f({props:{title:"This notebook is from Deep Reinforcement Learning Course",local:"this-notebook-is-from-deep-reinforcement-learning-course",headingTag:"h2"}}),se=new f({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),re=new f({props:{title:"A small recap of Deep Reinforcement Learning 📚",local:"a-small-recap-of-deep-reinforcement-learning-",headingTag:"h2"}}),he=new f({props:{title:"Let’s train our first Deep Reinforcement Learning agent and upload it to the Hub 🚀",local:"lets-train-our-first-deep-reinforcement-learning-agent-and-upload-it-to-the-hub-",headingTag:"h1"}}),de=new f({props:{title:"Get a certificate 🎓",local:"get-a-certificate-",headingTag:"h2"}}),be=new f({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),je=new f({props:{title:"Install dependencies and create a virtual screen 🔽",local:"install-dependencies-and-create-a-virtual-screen-",headingTag:"h2"}}),Ie=new y({props:{code:"YXB0JTIwaW5zdGFsbCUyMHN3aWclMjBjbWFrZQ==",highlighted:"apt install swig cmake",wrap:!1}}),$e=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkZWVwLXJsLWNsYXNzJTJGbWFpbiUyRm5vdGVib29rcyUyRnVuaXQxJTJGcmVxdWlyZW1lbnRzLXVuaXQxLnR4dA==",highlighted:"pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit1/requirements-unit1.txt",wrap:!1}}),Be=new y({props:{code:"c3VkbyUyMGFwdC1nZXQlMjB1cGRhdGUlMEFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uMy1vcGVuZ2wlMEFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBYXB0JTIwaW5zdGFsbCUyMHh2ZmIlMEFwaXAzJTIwaW5zdGFsbCUyMHB5dmlydHVhbGRpc3BsYXk=",highlighted:`sudo apt-get update
apt install python3-opengl
apt install ffmpeg
apt install xvfb
pip3 install pyvirtualdisplay`,wrap:!1}}),We=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5raWxsKG9zLmdldHBpZCgpJTJDJTIwOSk=",highlighted:`<span class="hljs-keyword">import</span> os

os.kill(os.getpid(), <span class="hljs-number">9</span>)`,wrap:!1}}),He=new y({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),xe=new f({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),Ye=new y({props:{code:"aW1wb3J0JTIwZ3ltbmFzaXVtJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMGxvYWRfZnJvbV9odWIlMkMlMjBwYWNrYWdlX3RvX2h1YiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwbm90ZWJvb2tfbG9naW4lMkMlMEEpJTIwJTIwJTIzJTIwVG8lMjBsb2clMjB0byUyMG91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjb3VudCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjB0byUyMHRoZSUyMEh1Yi4lMEElMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBQUE8lMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLmVudl91dGlsJTIwaW1wb3J0JTIwbWFrZV92ZWNfZW52JTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi5ldmFsdWF0aW9uJTIwaW1wb3J0JTIwZXZhbHVhdGVfcG9saWN5JTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi5tb25pdG9yJTIwaW1wb3J0JTIwTW9uaXRvcg==",highlighted:`<span class="hljs-keyword">import</span> gymnasium

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub, package_to_hub
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> (
    notebook_login,
)  <span class="hljs-comment"># To log to our Hugging Face account to be able to upload models to the Hub.</span>

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy
<span class="hljs-keyword">from</span> stable_baselines3.common.monitor <span class="hljs-keyword">import</span> Monitor`,wrap:!1}}),Ee=new f({props:{title:"Understand Gymnasium and how it works 🤖",local:"understand-gymnasium-and-how-it-works-",headingTag:"h2"}}),at=new y({props:{code:"aW1wb3J0JTIwZ3ltbmFzaXVtJTIwYXMlMjBneW0lMEElMEElMjMlMjBGaXJzdCUyQyUyMHdlJTIwY3JlYXRlJTIwb3VyJTIwZW52aXJvbm1lbnQlMjBjYWxsZWQlMjBMdW5hckxhbmRlci12MiUwQWVudiUyMCUzRCUyMGd5bS5tYWtlKCUyMkx1bmFyTGFuZGVyLXYyJTIyKSUwQSUwQSUyMyUyMFRoZW4lMjB3ZSUyMHJlc2V0JTIwdGhpcyUyMGVudmlyb25tZW50JTBBb2JzZXJ2YXRpb24lMkMlMjBpbmZvJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgyMCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwYSUyMHJhbmRvbSUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCklMEElMjAlMjAlMjAlMjBwcmludCglMjJBY3Rpb24lMjB0YWtlbiUzQSUyMiUyQyUyMGFjdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBEbyUyMHRoaXMlMjBhY3Rpb24lMjBpbiUyMHRoZSUyMGVudmlyb25tZW50JTIwYW5kJTIwZ2V0JTBBJTIwJTIwJTIwJTIwJTIzJTIwbmV4dF9zdGF0ZSUyQyUyMHJld2FyZCUyQyUyMHRlcm1pbmF0ZWQlMkMlMjB0cnVuY2F0ZWQlMjBhbmQlMjBpbmZvJTBBJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb24lMkMlMjByZXdhcmQlMkMlMjB0ZXJtaW5hdGVkJTJDJTIwdHJ1bmNhdGVkJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5zdGVwKGFjdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGdhbWUlMjBpcyUyMHRlcm1pbmF0ZWQlMjAoaW4lMjBvdXIlMjBjYXNlJTIwd2UlMjBsYW5kJTJDJTIwY3Jhc2hlZCklMjBvciUyMHRydW5jYXRlZCUyMCh0aW1lb3V0KSUwQSUyMCUyMCUyMCUyMGlmJTIwdGVybWluYXRlZCUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVzZXQlMjB0aGUlMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkVudmlyb25tZW50JTIwaXMlMjByZXNldCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUwQWVudi5jbG9zZSgp",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym

<span class="hljs-comment"># First, we create our environment called LunarLander-v2</span>
env = gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>)

<span class="hljs-comment"># Then we reset this environment</span>
observation, info = env.reset()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    <span class="hljs-comment"># Take a random action</span>
    action = env.action_space.sample()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action taken:&quot;</span>, action)

    <span class="hljs-comment"># Do this action in the environment and get</span>
    <span class="hljs-comment"># next_state, reward, terminated, truncated and info</span>
    observation, reward, terminated, truncated, info = env.step(action)

    <span class="hljs-comment"># If the game is terminated (in our case we land, crashed) or truncated (timeout)</span>
    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-comment"># Reset the environment</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Environment is reset&quot;</span>)
        observation, info = env.reset()

env.close()`,wrap:!1}}),it=new f({props:{title:"Create the LunarLander environment 🌛 and understand how it works",local:"create-the-lunarlander-environment--and-understand-how-it-works",headingTag:"h2"}}),ot=new f({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h3"}}),Mt=new y({props:{code:"JTIzJTIwV2UlMjBjcmVhdGUlMjBvdXIlMjBlbnZpcm9ubWVudCUyMHdpdGglMjBneW0ubWFrZSglMjIlM0NuYW1lX29mX3RoZV9lbnZpcm9ubWVudCUzRSUyMiklMEFlbnYlMjAlM0QlMjBneW0ubWFrZSglMjJMdW5hckxhbmRlci12MiUyMiklMEFlbnYucmVzZXQoKSUwQXByaW50KCUyMl9fX19fT0JTRVJWQVRJT04lMjBTUEFDRV9fX19fJTIwJTVDbiUyMiklMEFwcmludCglMjJPYnNlcnZhdGlvbiUyMFNwYWNlJTIwU2hhcGUlMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2hhcGUpJTBBcHJpbnQoJTIyU2FtcGxlJTIwb2JzZXJ2YXRpb24lMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwR2V0JTIwYSUyMHJhbmRvbSUyMG9ic2VydmF0aW9u",highlighted:`<span class="hljs-comment"># We create our environment with gym.make(&quot;&lt;name_of_the_environment&gt;&quot;)</span>
env = gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>)
env.reset()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Observation Space Shape&quot;</span>, env.observation_space.shape)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),ct=new y({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyQWN0aW9uJTIwU3BhY2UlMjBTaGFwZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2UubiklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Shape&quot;</span>, env.action_space.n)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),Ut=new f({props:{title:"Vectorized Environment",local:"vectorized-environment",headingTag:"h4"}}),Ct=new y({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBtYWtlX3ZlY19lbnYoJTIyTHVuYXJMYW5kZXItdjIlMjIlMkMlMjBuX2VudnMlM0QxNik=",highlighted:`<span class="hljs-comment"># Create the environment</span>
env = make_vec_env(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>, n_envs=<span class="hljs-number">16</span>)`,wrap:!1}}),It=new f({props:{title:"Create the Model 🤖",local:"create-the-model-",headingTag:"h2"}}),Rt=new y({props:{code:"JTIzJTIwQ3JlYXRlJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSgnTHVuYXJMYW5kZXItdjInKSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwdGhlJTIwYWdlbnQlMEFtb2RlbCUyMCUzRCUyMFBQTygnTWxwUG9saWN5JyUyQyUyMGVudiUyQyUyMHZlcmJvc2UlM0QxKSUwQSUyMyUyMFRyYWluJTIwdGhlJTIwYWdlbnQlMEFtb2RlbC5sZWFybih0b3RhbF90aW1lc3RlcHMlM0RpbnQoMmU1KSk=",highlighted:`<span class="hljs-comment"># Create environment</span>
env = gym.make(<span class="hljs-string">&#x27;LunarLander-v2&#x27;</span>)

<span class="hljs-comment"># Instantiate the agent</span>
model = PPO(<span class="hljs-string">&#x27;MlpPolicy&#x27;</span>, env, <span class="hljs-attribute">verbose</span>=1)
<span class="hljs-comment"># Train the agent</span>
model.learn(<span class="hljs-attribute">total_timesteps</span>=int(2e5))`,wrap:!1}}),Yt=new y({props:{code:"JTIzJTIwVE9ETyUzQSUyMERlZmluZSUyMGElMjBQUE8lMjBNbHBQb2xpY3klMjBhcmNoaXRlY3R1cmUlMEElMjMlMjBXZSUyMHVzZSUyME11bHRpTGF5ZXJQZXJjZXB0cm9uJTIwKE1MUFBvbGljeSklMjBiZWNhdXNlJTIwdGhlJTIwaW5wdXQlMjBpcyUyMGElMjB2ZWN0b3IlMkMlMEElMjMlMjBpZiUyMHdlJTIwaGFkJTIwZnJhbWVzJTIwYXMlMjBpbnB1dCUyMHdlJTIwd291bGQlMjB1c2UlMjBDbm5Qb2xpY3klMEFtb2RlbCUyMCUzRA==",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define a PPO MlpPolicy architecture</span>
<span class="hljs-comment"># We use MultiLayerPerceptron (MLPPolicy) because the input is a vector,</span>
<span class="hljs-comment"># if we had frames as input we would use CnnPolicy</span>
model =`,wrap:!1}}),Et=new f({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Xt=new y({props:{code:"JTIzJTIwU09MVVRJT04lMEElMjMlMjBXZSUyMGFkZGVkJTIwc29tZSUyMHBhcmFtZXRlcnMlMjB0byUyMGFjY2VsZXJhdGUlMjB0aGUlMjB0cmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwUFBPKCUwQSUyMCUyMCUyMCUyMHBvbGljeSUzRCUyMk1scFBvbGljeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRGVudiUyQyUwQSUyMCUyMCUyMCUyMG5fc3RlcHMlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwbl9lcG9jaHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ2FtbWElM0QwLjk5OSUyQyUwQSUyMCUyMCUyMCUyMGdhZV9sYW1iZGElM0QwLjk4JTJDJTBBJTIwJTIwJTIwJTIwZW50X2NvZWYlM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zZSUzRDElMkMlMEEp",highlighted:`<span class="hljs-comment"># SOLUTION</span>
<span class="hljs-comment"># We added some parameters to accelerate the training</span>
model = PPO(
    policy=<span class="hljs-string">&quot;MlpPolicy&quot;</span>,
    env=env,
    n_steps=<span class="hljs-number">1024</span>,
    batch_size=<span class="hljs-number">64</span>,
    n_epochs=<span class="hljs-number">4</span>,
    gamma=<span class="hljs-number">0.999</span>,
    gae_lambda=<span class="hljs-number">0.98</span>,
    ent_coef=<span class="hljs-number">0.01</span>,
    verbose=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Vt=new f({props:{title:"Train the PPO agent 🏃",local:"train-the-ppo-agent-",headingTag:"h2"}}),Ft=new y({props:{code:"JTIzJTIwVE9ETyUzQSUyMFRyYWluJTIwaXQlMjBmb3IlMjAxJTJDMDAwJTJDMDAwJTIwdGltZXN0ZXBzJTBBJTBBJTIzJTIwVE9ETyUzQSUyMFNwZWNpZnklMjBmaWxlJTIwbmFtZSUyMGZvciUyMG1vZGVsJTIwYW5kJTIwc2F2ZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBmaWxlJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12MiUyMg==",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Train it for 1,000,000 timesteps</span>

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Specify file name for model and save the model to file</span>
model_name = <span class="hljs-string">&quot;ppo-LunarLander-v2&quot;</span>`,wrap:!1}}),Qt=new f({props:{title:"Solution",local:"solution",headingTag:"h4"}}),zt=new y({props:{code:"JTIzJTIwU09MVVRJT04lMEElMjMlMjBUcmFpbiUyMGl0JTIwZm9yJTIwMSUyQzAwMCUyQzAwMCUyMHRpbWVzdGVwcyUwQW1vZGVsLmxlYXJuKHRvdGFsX3RpbWVzdGVwcyUzRDEwMDAwMDApJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMG1vZGVsJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12MiUyMiUwQW1vZGVsLnNhdmUobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-comment"># SOLUTION</span>
<span class="hljs-comment"># Train it for 1,000,000 timesteps</span>
model.learn(total_timesteps=<span class="hljs-number">1000000</span>)
<span class="hljs-comment"># Save the model</span>
model_name = <span class="hljs-string">&quot;ppo-LunarLander-v2&quot;</span>
model.save(model_name)`,wrap:!1}}),Pt=new f({props:{title:"Evaluate the agent 📈",local:"evaluate-the-agent-",headingTag:"h2"}}),Dt=new y({props:{code:"JTIzJTIwVE9ETyUzQSUyMEV2YWx1YXRlJTIwdGhlJTIwYWdlbnQlMEElMjMlMjBDcmVhdGUlMjBhJTIwbmV3JTIwZW52aXJvbm1lbnQlMjBmb3IlMjBldmFsdWF0aW9uJTBBZXZhbF9lbnYlMjAlM0QlMEElMEElMjMlMjBFdmFsdWF0ZSUyMHRoZSUyMG1vZGVsJTIwd2l0aCUyMDEwJTIwZXZhbHVhdGlvbiUyMGVwaXNvZGVzJTIwYW5kJTIwZGV0ZXJtaW5pc3RpYyUzRFRydWUlMEFtZWFuX3Jld2FyZCUyQyUyMHN0ZF9yZXdhcmQlMjAlM0QlMjAlMEElMEElMjMlMjBQcmludCUyMHRoZSUyMHJlc3VsdHM=",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Evaluate the agent</span>
<span class="hljs-comment"># Create a new environment for evaluation</span>
eval_env =

<span class="hljs-comment"># Evaluate the model with 10 evaluation episodes and deterministic=True</span>
mean_reward, std_reward = 

<span class="hljs-comment"># Print the results</span>`,wrap:!1}}),qt=new f({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Ot=new y({props:{code:"JTIzJTIwJTQwdGl0bGUlMEFldmFsX2VudiUyMCUzRCUyME1vbml0b3IoZ3ltLm1ha2UoJTIyTHVuYXJMYW5kZXItdjIlMjIpKSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52JTJDJTIwbl9ldmFsX2VwaXNvZGVzJTNEMTAlMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEFwcmludChmJTIybWVhbl9yZXdhcmQlM0QlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># @title</span>
eval_env = Monitor(gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>))
mean_reward, std_reward = evaluate_policy(model, eval_env, n_eval_episodes=<span class="hljs-number">10</span>, deterministic=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward}</span>&quot;</span>)`,wrap:!1}}),el=new f({props:{title:"Publish our trained model on the Hub 🔥",local:"publish-our-trained-model-on-the-hub-",headingTag:"h2"}}),hl=new y({props:{code:"bm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),wl=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

<span class="hljs-comment">## <span class="hljs-doctag">TODO:</span> Define a repo_id</span>
<span class="hljs-comment">## repo_id is the id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
repo_id = 

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the name of the environment</span>
env_id = 

<span class="hljs-comment"># Create the evaluation env and set the render_mode=&quot;rgb_array&quot;</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(env_id, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)])


<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the model architecture we used</span>
model_architecture = <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-comment">## <span class="hljs-doctag">TODO:</span> Define the commit message</span>
commit_message = <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-comment"># method save, evaluate, generate a model card and record a replay video of your agent before pushing the repo to the hub</span>
package_to_hub(model=model, <span class="hljs-comment"># Our trained model</span>
               model_name=model_name, <span class="hljs-comment"># The name of our trained model </span>
               model_architecture=model_architecture, <span class="hljs-comment"># The model architecture we used: in our case PPO</span>
               env_id=env_id, <span class="hljs-comment"># Name of the environment</span>
               eval_env=eval_env, <span class="hljs-comment"># Evaluation Environment</span>
               repo_id=repo_id, <span class="hljs-comment"># id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
               commit_message=commit_message)`,wrap:!1}}),Tl=new f({props:{title:"Solution",local:"solution",headingTag:"h4"}}),vl=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

<span class="hljs-comment"># PLACE the variables you&#x27;ve just defined two cells above</span>
<span class="hljs-comment"># Define the name of the environment</span>
env_id = <span class="hljs-string">&quot;LunarLander-v2&quot;</span>

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the model architecture we used</span>
model_architecture = <span class="hljs-string">&quot;PPO&quot;</span>

<span class="hljs-comment">## Define a repo_id</span>
<span class="hljs-comment">## repo_id is the id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
<span class="hljs-comment">## CHANGE WITH YOUR REPO ID</span>
repo_id = <span class="hljs-string">&quot;ThomasSimonini/ppo-LunarLander-v2&quot;</span>  <span class="hljs-comment"># Change with your repo id, you can&#x27;t push with mine 😄</span>

<span class="hljs-comment">## Define the commit message</span>
commit_message = <span class="hljs-string">&quot;Upload PPO LunarLander-v2 trained agent&quot;</span>

<span class="hljs-comment"># Create the evaluation env and set the render_mode=&quot;rgb_array&quot;</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: Monitor(gym.make(env_id, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>))])

<span class="hljs-comment"># PLACE the package_to_hub function you&#x27;ve just filled here</span>
package_to_hub(
    model=model,  <span class="hljs-comment"># Our trained model</span>
    model_name=model_name,  <span class="hljs-comment"># The name of our trained model</span>
    model_architecture=model_architecture,  <span class="hljs-comment"># The model architecture we used: in our case PPO</span>
    env_id=env_id,  <span class="hljs-comment"># Name of the environment</span>
    eval_env=eval_env,  <span class="hljs-comment"># Evaluation Environment</span>
    repo_id=repo_id,  <span class="hljs-comment"># id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
    commit_message=commit_message,
)`,wrap:!1}}),Il=new f({props:{title:"Load a saved LunarLander model from the Hub 🤗",local:"load-a-saved-lunarlander-model-from-the-hub-",headingTag:"h2"}}),kl=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzaGltbXk=",highlighted:"!pip install shimmy",wrap:!1}}),Gl=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMGxvYWRfZnJvbV9odWIlMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyQ2xhc3Nyb29tLXdvcmtzaG9wJTJGYXNzaWdubWVudDItb21hciUyMiUyMCUyMCUyMyUyMFRoZSUyMHJlcG9faWQlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12Mi56aXAlMjIlMjAlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMGZpbGVuYW1lLnppcCUwQSUwQSUyMyUyMFdoZW4lMjB0aGUlMjBtb2RlbCUyMHdhcyUyMHRyYWluZWQlMjBvbiUyMFB5dGhvbiUyMDMuOCUyMHRoZSUyMHBpY2tsZSUyMHByb3RvY29sJTIwaXMlMjA1JTBBJTIzJTIwQnV0JTIwUHl0aG9uJTIwMy42JTJDJTIwMy43JTIwdXNlJTIwcHJvdG9jb2wlMjA0JTBBJTIzJTIwSW4lMjBvcmRlciUyMHRvJTIwZ2V0JTIwY29tcGF0aWJpbGl0eSUyMHdlJTIwbmVlZCUyMHRvJTNBJTBBJTIzJTIwMS4lMjBJbnN0YWxsJTIwcGlja2xlNSUyMCh3ZSUyMGRvbmUlMjBpdCUyMGF0JTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjB0aGUlMjBjb2xhYiklMEElMjMlMjAyLiUyMENyZWF0ZSUyMGElMjBjdXN0b20lMjBlbXB0eSUyMG9iamVjdCUyMHdlJTIwcGFzcyUyMGFzJTIwcGFyYW1ldGVyJTIwdG8lMjBQUE8ubG9hZCgpJTBBY3VzdG9tX29iamVjdHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybHJfc2NoZWR1bGUlMjIlM0ElMjBsYW1iZGElMjBfJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2xpcF9yYW5nZSUyMiUzQSUyMGxhbWJkYSUyMF8lM0ElMjAwLjAlMkMlMEElN0QlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwbG9hZF9mcm9tX2h1YihyZXBvX2lkJTJDJTIwZmlsZW5hbWUpJTBBbW9kZWwlMjAlM0QlMjBQUE8ubG9hZChjaGVja3BvaW50JTJDJTIwY3VzdG9tX29iamVjdHMlM0RjdXN0b21fb2JqZWN0cyUyQyUyMHByaW50X3N5c3RlbV9pbmZvJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub

repo_id = <span class="hljs-string">&quot;Classroom-workshop/assignment2-omar&quot;</span>  <span class="hljs-comment"># The repo_id</span>
filename = <span class="hljs-string">&quot;ppo-LunarLander-v2.zip&quot;</span>  <span class="hljs-comment"># The model filename.zip</span>

<span class="hljs-comment"># When the model was trained on Python 3.8 the pickle protocol is 5</span>
<span class="hljs-comment"># But Python 3.6, 3.7 use protocol 4</span>
<span class="hljs-comment"># In order to get compatibility we need to:</span>
<span class="hljs-comment"># 1. Install pickle5 (we done it at the beginning of the colab)</span>
<span class="hljs-comment"># 2. Create a custom empty object we pass as parameter to PPO.load()</span>
custom_objects = {
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;lr_schedule&quot;</span>: <span class="hljs-keyword">lambda</span> _: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;clip_range&quot;</span>: <span class="hljs-keyword">lambda</span> _: <span class="hljs-number">0.0</span>,
}

checkpoint = load_from_hub(repo_id, filename)
model = PPO.load(checkpoint, custom_objects=custom_objects, print_system_info=<span class="hljs-literal">True</span>)`,wrap:!1}}),Yl=new y({props:{code:"JTIzJTIwJTQwdGl0bGUlMEFldmFsX2VudiUyMCUzRCUyME1vbml0b3IoZ3ltLm1ha2UoJTIyTHVuYXJMYW5kZXItdjIlMjIpKSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52JTJDJTIwbl9ldmFsX2VwaXNvZGVzJTNEMTAlMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEFwcmludChmJTIybWVhbl9yZXdhcmQlM0QlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># @title</span>
eval_env = Monitor(gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>))
mean_reward, std_reward = evaluate_policy(model, eval_env, n_eval_episodes=<span class="hljs-number">10</span>, deterministic=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward}</span>&quot;</span>)`,wrap:!1}}),El=new f({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),Kl=new f({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),en=new Qp({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unit1/hands-on.mdx"}}),{c(){g=i("meta"),nn=s(),tn=i("p"),sn=s(),p(U.$$.fragment),an=s(),p(J.$$.fragment),on=s(),C=i("p"),C.textContent=Ki,rn=s(),I=i("img"),pn=s(),$=i("p"),$.innerHTML=to,mn=s(),_=i("p"),_.innerHTML=lo,un=s(),Z=i("p"),Z.innerHTML=no,Mn=s(),B=i("p"),B.innerHTML=so,hn=s(),L=i("p"),L.innerHTML=ao,dn=s(),W=i("p"),W.innerHTML=io,cn=s(),H=i("p"),H.innerHTML=oo,fn=s(),x=i("p"),x.textContent=ro,yn=s(),k=i("p"),k.innerHTML=po,bn=s(),G=i("p"),G.innerHTML=mo,gn=s(),R=i("p"),R.innerHTML=uo,wn=s(),Y=i("p"),Y.innerHTML=Mo,Tn=s(),p(E.$$.fragment),vn=s(),w=i("img"),jn=s(),X=i("p"),X.innerHTML=co,Un=s(),p(V.$$.fragment),Jn=s(),S=i("ul"),S.innerHTML=fo,Cn=s(),p(F.$$.fragment),In=s(),Q=i("ul"),Q.innerHTML=yo,$n=s(),z=i("p"),z.innerHTML=bo,_n=s(),p(P.$$.fragment),Zn=s(),A=i("p"),A.textContent=go,Bn=s(),N=i("ul"),N.innerHTML=wo,Ln=s(),p(D.$$.fragment),Wn=s(),q=i("img"),Hn=s(),O=i("p"),O.textContent=vo,xn=s(),K=i("ul"),K.innerHTML=jo,kn=s(),ee=i("p"),ee.textContent=Uo,Gn=s(),te=i("p"),te.innerHTML=Jo,Rn=s(),le=i("p"),le.innerHTML=Co,Yn=s(),ne=i("p"),ne.innerHTML=Io,En=s(),p(se.$$.fragment),Xn=s(),ae=i("p"),ae.textContent=$o,Vn=s(),ie=i("p"),ie.innerHTML=_o,Sn=s(),oe=i("p"),oe.innerHTML=Zo,Fn=s(),p(re.$$.fragment),Qn=s(),T=i("img"),zn=s(),pe=i("p"),pe.textContent=Lo,Pn=s(),me=i("ul"),me.innerHTML=Wo,An=s(),ue=i("p"),ue.innerHTML=Ho,Nn=s(),Me=i("ul"),Me.innerHTML=xo,Dn=s(),p(he.$$.fragment),qn=s(),p(de.$$.fragment),On=s(),ce=i("p"),ce.innerHTML=ko,Kn=s(),fe=i("p"),fe.innerHTML=Go,es=s(),ye=i("p"),ye.innerHTML=Ro,ts=s(),p(be.$$.fragment),ls=s(),ge=i("ul"),ge.innerHTML=Yo,ns=s(),we=i("img"),ss=s(),Te=i("ul"),Te.innerHTML=Xo,as=s(),ve=i("img"),is=s(),p(je.$$.fragment),os=s(),Ue=i("p"),Ue.textContent=So,rs=s(),Je=i("ul"),Je.innerHTML=Fo,ps=s(),Ce=i("p"),Ce.textContent=Qo,ms=s(),p(Ie.$$.fragment),us=s(),p($e.$$.fragment),Ms=s(),_e=i("p"),_e.innerHTML=zo,hs=s(),Ze=i("p"),Ze.textContent=Po,ds=s(),p(Be.$$.fragment),cs=s(),Le=i("p"),Le.innerHTML=Ao,fs=s(),p(We.$$.fragment),ys=s(),p(He.$$.fragment),bs=s(),p(xe.$$.fragment),gs=s(),ke=i("p"),ke.innerHTML=No,ws=s(),Ge=i("p"),Ge.textContent=Do,Ts=s(),Re=i("p"),Re.innerHTML=qo,vs=s(),p(Ye.$$.fragment),js=s(),p(Ee.$$.fragment),Us=s(),Xe=i("p"),Xe.innerHTML=Oo,Js=s(),Ve=i("p"),Ve.innerHTML=Ko,Cs=s(),Se=i("p"),Se.textContent=er,Is=s(),Fe=i("ul"),Fe.innerHTML=tr,$s=s(),Qe=i("p"),Qe.textContent=lr,_s=s(),v=i("img"),Zs=s(),ze=i("p"),ze.textContent=sr,Bs=s(),Pe=i("ul"),Pe.innerHTML=ar,Ls=s(),Ae=i("p"),Ae.textContent=ir,Ws=s(),Ne=i("p"),Ne.innerHTML=or,Hs=s(),De=i("p"),De.innerHTML=rr,xs=s(),qe=i("p"),qe.textContent=pr,ks=s(),Oe=i("p"),Oe.textContent=mr,Gs=s(),Ke=i("p"),Ke.innerHTML=ur,Rs=s(),et=i("ul"),et.innerHTML=Mr,Ys=s(),tt=i("p"),tt.innerHTML=hr,Es=s(),lt=i("p"),lt.textContent=dr,Xs=s(),nt=i("ul"),nt.innerHTML=cr,Vs=s(),st=i("p"),st.innerHTML=fr,Ss=s(),p(at.$$.fragment),Fs=s(),p(it.$$.fragment),Qs=s(),p(ot.$$.fragment),zs=s(),rt=i("p"),rt.innerHTML=yr,Ps=s(),As=i("hr"),Ns=s(),pt=i("p"),pt.textContent=br,Ds=s(),mt=i("p"),mt.innerHTML=gr,qs=s(),Os=i("hr"),Ks=s(),ut=i("p"),ut.textContent=wr,ea=s(),p(Mt.$$.fragment),ta=s(),ht=i("p"),ht.innerHTML=Tr,la=s(),dt=i("ul"),dt.innerHTML=vr,na=s(),p(ct.$$.fragment),sa=s(),ft=i("p"),ft.textContent=jr,aa=s(),yt=i("ul"),yt.innerHTML=Ur,ia=s(),bt=i("p"),bt.textContent=Jr,oa=s(),gt=i("p"),gt.innerHTML=Cr,ra=s(),wt=i("p"),wt.textContent=Ir,pa=s(),Tt=i("ul"),Tt.innerHTML=$r,ma=s(),vt=i("p"),vt.innerHTML=_r,ua=s(),jt=i("p"),jt.innerHTML=Zr,Ma=s(),p(Ut.$$.fragment),ha=s(),Jt=i("ul"),Jt.innerHTML=Br,da=s(),p(Ct.$$.fragment),ca=s(),p(It.$$.fragment),fa=s(),$t=i("ul"),$t.innerHTML=Lr,ya=s(),ba=i("hr"),ga=s(),_t=i("p"),_t.innerHTML=Wr,wa=s(),Ta=i("hr"),va=s(),Zt=i("img"),ja=s(),Bt=i("p"),Bt.innerHTML=xr,Ua=s(),Lt=i("p"),Lt.textContent=kr,Ja=s(),Wt=i("ul"),Wt.innerHTML=Gr,Ca=s(),Ht=i("p"),Ht.textContent=Rr,Ia=s(),xt=i("p"),xt.innerHTML=Yr,$a=s(),kt=i("p"),kt.innerHTML=Er,_a=s(),Gt=i("p"),Gt.innerHTML=Xr,Za=s(),p(Rt.$$.fragment),Ba=s(),p(Yt.$$.fragment),La=s(),p(Et.$$.fragment),Wa=s(),p(Xt.$$.fragment),Ha=s(),p(Vt.$$.fragment),xa=s(),St=i("ul"),St.innerHTML=Vr,ka=s(),p(Ft.$$.fragment),Ga=s(),p(Qt.$$.fragment),Ra=s(),p(zt.$$.fragment),Ya=s(),p(Pt.$$.fragment),Ea=s(),At=i("ul"),At.innerHTML=Sr,Xa=s(),Nt=i("p"),Nt.textContent=Fr,Va=s(),p(Dt.$$.fragment),Sa=s(),p(qt.$$.fragment),Fa=s(),p(Ot.$$.fragment),Qa=s(),Kt=i("ul"),Kt.innerHTML=Qr,za=s(),p(el.$$.fragment),Pa=s(),tl=i("p"),tl.textContent=zr,Aa=s(),ll=i("p"),ll.innerHTML=Pr,Na=s(),nl=i("p"),nl.textContent=Ar,Da=s(),sl=i("p"),sl.innerHTML=Nr,qa=s(),al=i("p"),al.textContent=Dr,Oa=s(),il=i("ul"),il.innerHTML=qr,Ka=s(),ol=i("p"),ol.textContent=Or,ei=s(),rl=i("p"),rl.innerHTML=Kr,ti=s(),pl=i("p"),pl.textContent=ep,li=s(),ml=i("ul"),ml.innerHTML=tp,ni=s(),ul=i("img"),si=s(),Ml=i("ul"),Ml.innerHTML=np,ai=s(),p(hl.$$.fragment),ii=s(),dl=i("p"),dl.innerHTML=sp,oi=s(),cl=i("p"),cl.innerHTML=ap,ri=s(),fl=i("p"),fl.innerHTML=ip,pi=s(),yl=i("ul"),yl.innerHTML=op,mi=s(),bl=i("p"),bl.innerHTML=rp,ui=s(),gl=i("ul"),gl.innerHTML=pp,Mi=s(),p(wl.$$.fragment),hi=s(),p(Tl.$$.fragment),di=s(),p(vl.$$.fragment),ci=s(),jl=i("p"),jl.innerHTML=mp,fi=s(),Ul=i("ul"),Ul.innerHTML=up,yi=s(),Jl=i("p"),Jl.textContent=Mp,bi=s(),Cl=i("p"),Cl.innerHTML=hp,gi=s(),p(Il.$$.fragment),wi=s(),$l=i("p"),$l.innerHTML=dp,Ti=s(),_l=i("p"),_l.textContent=cp,vi=s(),Zl=i("p"),Zl.innerHTML=fp,ji=s(),Bl=i("ol"),Bl.innerHTML=yp,Ui=s(),Ll=i("img"),Ji=s(),j=i("ol"),j.innerHTML=gp,Ci=s(),Wl=i("ul"),Wl.innerHTML=wp,Ii=s(),Hl=i("p"),Hl.textContent=Tp,$i=s(),xl=i("p"),xl.innerHTML=vp,_i=s(),p(kl.$$.fragment),Zi=s(),p(Gl.$$.fragment),Bi=s(),Rl=i("p"),Rl.textContent=jp,Li=s(),p(Yl.$$.fragment),Wi=s(),p(El.$$.fragment),Hi=s(),Xl=i("p"),Xl.innerHTML=Up,xi=s(),Vl=i("p"),Vl.innerHTML=Jp,ki=s(),Sl=i("p"),Sl.textContent=Cp,Gi=s(),Fl=i("ul"),Fl.innerHTML=Ip,Ri=s(),Ql=i("p"),Ql.innerHTML=$p,Yi=s(),zl=i("p"),zl.innerHTML=_p,Ei=s(),Xi=i("hr"),Vi=s(),Pl=i("p"),Pl.innerHTML=Zp,Si=s(),Al=i("p"),Al.innerHTML=Bp,Fi=s(),Nl=i("p"),Nl.innerHTML=Lp,Qi=s(),Dl=i("p"),Dl.innerHTML=Wp,zi=s(),ql=i("p"),ql.textContent=Hp,Pi=s(),Ol=i("img"),Ai=s(),p(Kl.$$.fragment),Ni=s(),p(en.$$.fragment),Di=s(),ln=i("p"),this.h()},l(e){const t=Vp("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(l),nn=a(e),tn=o(e,"P",{}),kp(tn).forEach(l),sn=a(e),m(U.$$.fragment,e),an=a(e),m(J.$$.fragment,e),on=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1fyqzqg"&&(C.textContent=Ki),rn=a(e),I=o(e,"IMG",{src:!0,alt:!0}),pn=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-qeetmg"&&($.innerHTML=to),mn=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6a5et3"&&(_.innerHTML=lo),un=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1yw7b9f"&&(Z.innerHTML=no),Mn=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-lt0dbq"&&(B.innerHTML=so),hn=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1c0nyzi"&&(L.innerHTML=ao),dn=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1qkxyrx"&&(W.innerHTML=io),cn=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-znarat"&&(H.innerHTML=oo),fn=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-vkoquy"&&(x.textContent=ro),yn=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10pdw2g"&&(k.innerHTML=po),bn=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ur7x3v"&&(G.innerHTML=mo),gn=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-uilrpw"&&(R.innerHTML=uo),wn=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-p9mrd0"&&(Y.innerHTML=Mo),Tn=a(e),m(E.$$.fragment,e),vn=a(e),w=o(e,"IMG",{src:!0,alt:!0,width:!0}),jn=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-gtyyy1"&&(X.innerHTML=co),Un=a(e),m(V.$$.fragment,e),Jn=a(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1i75yc"&&(S.innerHTML=fo),Cn=a(e),m(F.$$.fragment,e),In=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1lt8xht"&&(Q.innerHTML=yo),$n=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1nezll8"&&(z.innerHTML=bo),_n=a(e),m(P.$$.fragment,e),Zn=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-nsjs09"&&(A.textContent=go),Bn=a(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-rzgp9v"&&(N.innerHTML=wo),Ln=a(e),m(D.$$.fragment,e),Wn=a(e),q=o(e,"IMG",{src:!0,alt:!0}),Hn=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6wur6d"&&(O.textContent=vo),xn=a(e),K=o(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-1uvcz43"&&(K.innerHTML=jo),kn=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-l0ox3l"&&(ee.textContent=Uo),Gn=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-df6xsg"&&(te.innerHTML=Jo),Rn=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-i91mrq"&&(le.innerHTML=Co),Yn=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1sstckl"&&(ne.innerHTML=Io),En=a(e),m(se.$$.fragment,e),Xn=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1v25wk6"&&(ae.textContent=$o),Vn=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ex8j5d"&&(ie.innerHTML=_o),Sn=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-fgg92r"&&(oe.innerHTML=Zo),Fn=a(e),m(re.$$.fragment,e),Qn=a(e),T=o(e,"IMG",{src:!0,alt:!0,width:!0}),zn=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-7aaye9"&&(pe.textContent=Lo),Pn=a(e),me=o(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-1q6p5tv"&&(me.innerHTML=Wo),An=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-vmzi2g"&&(ue.innerHTML=Ho),Nn=a(e),Me=o(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-15oilwj"&&(Me.innerHTML=xo),Dn=a(e),m(he.$$.fragment,e),qn=a(e),m(de.$$.fragment,e),On=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1yw7b9f"&&(ce.innerHTML=ko),Kn=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-lt0dbq"&&(fe.innerHTML=Go),es=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1qkxyrx"&&(ye.innerHTML=Ro),ts=a(e),m(be.$$.fragment,e),ls=a(e),ge=o(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-1funvfi"&&(ge.innerHTML=Yo),ns=a(e),we=o(e,"IMG",{src:!0,alt:!0}),ss=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-1cge6gn"&&(Te.innerHTML=Xo),as=a(e),ve=o(e,"IMG",{src:!0,alt:!0}),is=a(e),m(je.$$.fragment,e),os=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-240n94"&&(Ue.textContent=So),rs=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-176sd9d"&&(Je.innerHTML=Fo),ps=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-yvi6vy"&&(Ce.textContent=Qo),ms=a(e),m(Ie.$$.fragment,e),us=a(e),m($e.$$.fragment,e),Ms=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1t10iqv"&&(_e.innerHTML=zo),hs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-xvjq2n"&&(Ze.textContent=Po),ds=a(e),m(Be.$$.fragment,e),cs=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-bx852m"&&(Le.innerHTML=Ao),fs=a(e),m(We.$$.fragment,e),ys=a(e),m(He.$$.fragment,e),bs=a(e),m(xe.$$.fragment,e),gs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1a8ukem"&&(ke.innerHTML=No),ws=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1ub567"&&(Ge.textContent=Do),Ts=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-179moh"&&(Re.innerHTML=qo),vs=a(e),m(Ye.$$.fragment,e),js=a(e),m(Ee.$$.fragment,e),Us=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-18clawh"&&(Xe.innerHTML=Oo),Js=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-4pwxen"&&(Ve.innerHTML=Ko),Cs=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1omhoff"&&(Se.textContent=er),Is=a(e),Fe=o(e,"UL",{"data-svelte-h":!0}),r(Fe)!=="svelte-1gr0wpr"&&(Fe.innerHTML=tr),$s=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1d4ybay"&&(Qe.textContent=lr),_s=a(e),v=o(e,"IMG",{src:!0,alt:!0,width:!0}),Zs=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1buylsu"&&(ze.textContent=sr),Bs=a(e),Pe=o(e,"UL",{"data-svelte-h":!0}),r(Pe)!=="svelte-18q8eyd"&&(Pe.innerHTML=ar),Ls=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1vqqw6i"&&(Ae.textContent=ir),Ws=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-13b9y4a"&&(Ne.innerHTML=or),Hs=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1bdnzh6"&&(De.innerHTML=rr),xs=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1buylsu"&&(qe.textContent=pr),ks=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-5kldyy"&&(Oe.textContent=mr),Gs=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-55e9cg"&&(Ke.innerHTML=ur),Rs=a(e),et=o(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-xz0jlk"&&(et.innerHTML=Mr),Ys=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1w6llkl"&&(tt.innerHTML=hr),Es=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-4sv61e"&&(lt.textContent=dr),Xs=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-14fsfpn"&&(nt.innerHTML=cr),Vs=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1gwp7j4"&&(st.innerHTML=fr),Ss=a(e),m(at.$$.fragment,e),Fs=a(e),m(it.$$.fragment,e),Qs=a(e),m(ot.$$.fragment,e),zs=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-2un6m0"&&(rt.innerHTML=yr),Ps=a(e),As=o(e,"HR",{}),Ns=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-15dw51a"&&(pt.textContent=br),Ds=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-jnu6xx"&&(mt.innerHTML=gr),qs=a(e),Os=o(e,"HR",{}),Ks=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-mlxrgb"&&(ut.textContent=wr),ea=a(e),m(Mt.$$.fragment,e),ta=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1dc7m7j"&&(ht.innerHTML=Tr),la=a(e),dt=o(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-gm5axf"&&(dt.innerHTML=vr),na=a(e),m(ct.$$.fragment,e),sa=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-l9gcgq"&&(ft.textContent=jr),aa=a(e),yt=o(e,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-1gafu9z"&&(yt.innerHTML=Ur),ia=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-19etirz"&&(bt.textContent=Jr),oa=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-163y6uv"&&(gt.innerHTML=Cr),ra=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1er0mm6"&&(wt.textContent=Ir),pa=a(e),Tt=o(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1yozgp2"&&(Tt.innerHTML=$r),ma=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-b6qau5"&&(vt.innerHTML=_r),ua=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-ta04ov"&&(jt.innerHTML=Zr),Ma=a(e),m(Ut.$$.fragment,e),ha=a(e),Jt=o(e,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-8jx2x9"&&(Jt.innerHTML=Br),da=a(e),m(Ct.$$.fragment,e),ca=a(e),m(It.$$.fragment,e),fa=a(e),$t=o(e,"UL",{"data-svelte-h":!0}),r($t)!=="svelte-1zi2xo"&&($t.innerHTML=Lr),ya=a(e),ba=o(e,"HR",{}),ga=a(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-157uj5u"&&(_t.innerHTML=Wr),wa=a(e),Ta=o(e,"HR",{}),va=a(e),Zt=o(e,"IMG",{src:!0,alt:!0}),ja=a(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1blqo6u"&&(Bt.innerHTML=xr),Ua=a(e),Lt=o(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1j8t0lq"&&(Lt.textContent=kr),Ja=a(e),Wt=o(e,"UL",{"data-svelte-h":!0}),r(Wt)!=="svelte-hdfg8e"&&(Wt.innerHTML=Gr),Ca=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-80yx2p"&&(Ht.textContent=Rr),Ia=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1b4vrh6"&&(xt.innerHTML=Yr),$a=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-122u5fk"&&(kt.innerHTML=Er),_a=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-12b0l2y"&&(Gt.innerHTML=Xr),Za=a(e),m(Rt.$$.fragment,e),Ba=a(e),m(Yt.$$.fragment,e),La=a(e),m(Et.$$.fragment,e),Wa=a(e),m(Xt.$$.fragment,e),Ha=a(e),m(Vt.$$.fragment,e),xa=a(e),St=o(e,"UL",{"data-svelte-h":!0}),r(St)!=="svelte-1kussd2"&&(St.innerHTML=Vr),ka=a(e),m(Ft.$$.fragment,e),Ga=a(e),m(Qt.$$.fragment,e),Ra=a(e),m(zt.$$.fragment,e),Ya=a(e),m(Pt.$$.fragment,e),Ea=a(e),At=o(e,"UL",{"data-svelte-h":!0}),r(At)!=="svelte-dmghau"&&(At.innerHTML=Sr),Xa=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-11gty83"&&(Nt.textContent=Fr),Va=a(e),m(Dt.$$.fragment,e),Sa=a(e),m(qt.$$.fragment,e),Fa=a(e),m(Ot.$$.fragment,e),Qa=a(e),Kt=o(e,"UL",{"data-svelte-h":!0}),r(Kt)!=="svelte-aj3t8h"&&(Kt.innerHTML=Qr),za=a(e),m(el.$$.fragment,e),Pa=a(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-13d1cnp"&&(tl.textContent=zr),Aa=a(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1vcevn6"&&(ll.innerHTML=Pr),Na=a(e),nl=o(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-w1lcgd"&&(nl.textContent=Ar),Da=a(e),sl=o(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1r6eiir"&&(sl.innerHTML=Nr),qa=a(e),al=o(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-vgzxi7"&&(al.textContent=Dr),Oa=a(e),il=o(e,"UL",{"data-svelte-h":!0}),r(il)!=="svelte-19ddql5"&&(il.innerHTML=qr),Ka=a(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-6k9qpu"&&(ol.textContent=Or),ei=a(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-7v2fwq"&&(rl.innerHTML=Kr),ti=a(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1cn3tld"&&(pl.textContent=ep),li=a(e),ml=o(e,"UL",{"data-svelte-h":!0}),r(ml)!=="svelte-19b5tev"&&(ml.innerHTML=tp),ni=a(e),ul=o(e,"IMG",{src:!0,alt:!0}),si=a(e),Ml=o(e,"UL",{"data-svelte-h":!0}),r(Ml)!=="svelte-ricdz6"&&(Ml.innerHTML=np),ai=a(e),m(hl.$$.fragment,e),ii=a(e),dl=o(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1g9v6di"&&(dl.innerHTML=sp),oi=a(e),cl=o(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-1enm9m5"&&(cl.innerHTML=ap),ri=a(e),fl=o(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-1bz1l0q"&&(fl.innerHTML=ip),pi=a(e),yl=o(e,"UL",{"data-svelte-h":!0}),r(yl)!=="svelte-1lm8teg"&&(yl.innerHTML=op),mi=a(e),bl=o(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-11ha3rd"&&(bl.innerHTML=rp),ui=a(e),gl=o(e,"UL",{"data-svelte-h":!0}),r(gl)!=="svelte-10dry3f"&&(gl.innerHTML=pp),Mi=a(e),m(wl.$$.fragment,e),hi=a(e),m(Tl.$$.fragment,e),di=a(e),m(vl.$$.fragment,e),ci=a(e),jl=o(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-hp3w20"&&(jl.innerHTML=mp),fi=a(e),Ul=o(e,"UL",{"data-svelte-h":!0}),r(Ul)!=="svelte-123gpq9"&&(Ul.innerHTML=up),yi=a(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-1pr3qlz"&&(Jl.textContent=Mp),bi=a(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-1ekdy5l"&&(Cl.innerHTML=hp),gi=a(e),m(Il.$$.fragment,e),wi=a(e),$l=o(e,"P",{"data-svelte-h":!0}),r($l)!=="svelte-1xob9fr"&&($l.innerHTML=dp),Ti=a(e),_l=o(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-j6e6xs"&&(_l.textContent=cp),vi=a(e),Zl=o(e,"P",{"data-svelte-h":!0}),r(Zl)!=="svelte-1u6nkgv"&&(Zl.innerHTML=fp),ji=a(e),Bl=o(e,"OL",{"data-svelte-h":!0}),r(Bl)!=="svelte-prvn3y"&&(Bl.innerHTML=yp),Ui=a(e),Ll=o(e,"IMG",{src:!0,alt:!0}),Ji=a(e),j=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-w87ej2"&&(j.innerHTML=gp),Ci=a(e),Wl=o(e,"UL",{"data-svelte-h":!0}),r(Wl)!=="svelte-uec4xf"&&(Wl.innerHTML=wp),Ii=a(e),Hl=o(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-13gqrjl"&&(Hl.textContent=Tp),$i=a(e),xl=o(e,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-ytxq9m"&&(xl.innerHTML=vp),_i=a(e),m(kl.$$.fragment,e),Zi=a(e),m(Gl.$$.fragment,e),Bi=a(e),Rl=o(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-1nd8fiz"&&(Rl.textContent=jp),Li=a(e),m(Yl.$$.fragment,e),Wi=a(e),m(El.$$.fragment,e),Hi=a(e),Xl=o(e,"P",{"data-svelte-h":!0}),r(Xl)!=="svelte-6x0xu6"&&(Xl.innerHTML=Up),xi=a(e),Vl=o(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-131ixzr"&&(Vl.innerHTML=Jp),ki=a(e),Sl=o(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-qrxvcm"&&(Sl.textContent=Cp),Gi=a(e),Fl=o(e,"UL",{"data-svelte-h":!0}),r(Fl)!=="svelte-11s3zll"&&(Fl.innerHTML=Ip),Ri=a(e),Ql=o(e,"P",{"data-svelte-h":!0}),r(Ql)!=="svelte-1dyozfn"&&(Ql.innerHTML=$p),Yi=a(e),zl=o(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-otwf19"&&(zl.innerHTML=_p),Ei=a(e),Xi=o(e,"HR",{}),Vi=a(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-4ab4sp"&&(Pl.innerHTML=Zp),Si=a(e),Al=o(e,"P",{"data-svelte-h":!0}),r(Al)!=="svelte-zyppti"&&(Al.innerHTML=Bp),Fi=a(e),Nl=o(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-6h5jhw"&&(Nl.innerHTML=Lp),Qi=a(e),Dl=o(e,"P",{"data-svelte-h":!0}),r(Dl)!=="svelte-7f0plk"&&(Dl.innerHTML=Wp),zi=a(e),ql=o(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-6b51l9"&&(ql.textContent=Hp),Pi=a(e),Ol=o(e,"IMG",{src:!0,alt:!0}),Ai=a(e),m(Kl.$$.fragment,e),Ni=a(e),m(en.$$.fragment,e),Di=a(e),ln=o(e,"P",{}),kp(ln).forEach(l),this.h()},h(){c(g,"name","hf:doc:metadata"),c(g,"content",Pp),b(I.src,eo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/lunarLander.gif")||c(I,"src",eo),c(I,"alt","LunarLander"),b(w.src,ho="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/thumbnail.jpg")||c(w,"src",ho),c(w,"alt","Unit 1 thumbnail"),c(w,"width","100%"),b(q.src,To="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/deep-rl-course-illustration.jpg")||c(q,"src",To),c(q,"alt","Deep RL Course illustration"),b(T.src,Bo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/RL_process_game.jpg")||c(T,"src",Bo),c(T,"alt","The RL process"),c(T,"width","100%"),b(we.src,Eo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||c(we,"src",Eo),c(we,"alt","GPU Step 1"),b(ve.src,Vo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||c(ve,"src",Vo),c(ve,"alt","GPU Step 2"),b(v.src,nr="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/RL_process_game.jpg")||c(v,"src",nr),c(v,"alt","The RL process"),c(v,"width","100%"),b(Zt.src,Hr="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/sb3.png")||c(Zt,"src",Hr),c(Zt,"alt","Stable Baselines3"),b(ul.src,lp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||c(ul,"src",lp),c(ul,"alt","Create HF Token"),b(Ll.src,bp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit1/copy-id.png")||c(Ll,"src",bp),c(Ll,"alt","Copy-id"),c(j,"start","2"),b(Ol.src,xp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit1/huggy.jpg")||c(Ol,"src",xp),c(Ol,"alt","Huggy")},m(e,t){Sp(document.head,g),n(e,nn,t),n(e,tn,t),n(e,sn,t),u(U,e,t),n(e,an,t),u(J,e,t),n(e,on,t),n(e,C,t),n(e,rn,t),n(e,I,t),n(e,pn,t),n(e,$,t),n(e,mn,t),n(e,_,t),n(e,un,t),n(e,Z,t),n(e,Mn,t),n(e,B,t),n(e,hn,t),n(e,L,t),n(e,dn,t),n(e,W,t),n(e,cn,t),n(e,H,t),n(e,fn,t),n(e,x,t),n(e,yn,t),n(e,k,t),n(e,bn,t),n(e,G,t),n(e,gn,t),n(e,R,t),n(e,wn,t),n(e,Y,t),n(e,Tn,t),u(E,e,t),n(e,vn,t),n(e,w,t),n(e,jn,t),n(e,X,t),n(e,Un,t),u(V,e,t),n(e,Jn,t),n(e,S,t),n(e,Cn,t),u(F,e,t),n(e,In,t),n(e,Q,t),n(e,$n,t),n(e,z,t),n(e,_n,t),u(P,e,t),n(e,Zn,t),n(e,A,t),n(e,Bn,t),n(e,N,t),n(e,Ln,t),u(D,e,t),n(e,Wn,t),n(e,q,t),n(e,Hn,t),n(e,O,t),n(e,xn,t),n(e,K,t),n(e,kn,t),n(e,ee,t),n(e,Gn,t),n(e,te,t),n(e,Rn,t),n(e,le,t),n(e,Yn,t),n(e,ne,t),n(e,En,t),u(se,e,t),n(e,Xn,t),n(e,ae,t),n(e,Vn,t),n(e,ie,t),n(e,Sn,t),n(e,oe,t),n(e,Fn,t),u(re,e,t),n(e,Qn,t),n(e,T,t),n(e,zn,t),n(e,pe,t),n(e,Pn,t),n(e,me,t),n(e,An,t),n(e,ue,t),n(e,Nn,t),n(e,Me,t),n(e,Dn,t),u(he,e,t),n(e,qn,t),u(de,e,t),n(e,On,t),n(e,ce,t),n(e,Kn,t),n(e,fe,t),n(e,es,t),n(e,ye,t),n(e,ts,t),u(be,e,t),n(e,ls,t),n(e,ge,t),n(e,ns,t),n(e,we,t),n(e,ss,t),n(e,Te,t),n(e,as,t),n(e,ve,t),n(e,is,t),u(je,e,t),n(e,os,t),n(e,Ue,t),n(e,rs,t),n(e,Je,t),n(e,ps,t),n(e,Ce,t),n(e,ms,t),u(Ie,e,t),n(e,us,t),u($e,e,t),n(e,Ms,t),n(e,_e,t),n(e,hs,t),n(e,Ze,t),n(e,ds,t),u(Be,e,t),n(e,cs,t),n(e,Le,t),n(e,fs,t),u(We,e,t),n(e,ys,t),u(He,e,t),n(e,bs,t),u(xe,e,t),n(e,gs,t),n(e,ke,t),n(e,ws,t),n(e,Ge,t),n(e,Ts,t),n(e,Re,t),n(e,vs,t),u(Ye,e,t),n(e,js,t),u(Ee,e,t),n(e,Us,t),n(e,Xe,t),n(e,Js,t),n(e,Ve,t),n(e,Cs,t),n(e,Se,t),n(e,Is,t),n(e,Fe,t),n(e,$s,t),n(e,Qe,t),n(e,_s,t),n(e,v,t),n(e,Zs,t),n(e,ze,t),n(e,Bs,t),n(e,Pe,t),n(e,Ls,t),n(e,Ae,t),n(e,Ws,t),n(e,Ne,t),n(e,Hs,t),n(e,De,t),n(e,xs,t),n(e,qe,t),n(e,ks,t),n(e,Oe,t),n(e,Gs,t),n(e,Ke,t),n(e,Rs,t),n(e,et,t),n(e,Ys,t),n(e,tt,t),n(e,Es,t),n(e,lt,t),n(e,Xs,t),n(e,nt,t),n(e,Vs,t),n(e,st,t),n(e,Ss,t),u(at,e,t),n(e,Fs,t),u(it,e,t),n(e,Qs,t),u(ot,e,t),n(e,zs,t),n(e,rt,t),n(e,Ps,t),n(e,As,t),n(e,Ns,t),n(e,pt,t),n(e,Ds,t),n(e,mt,t),n(e,qs,t),n(e,Os,t),n(e,Ks,t),n(e,ut,t),n(e,ea,t),u(Mt,e,t),n(e,ta,t),n(e,ht,t),n(e,la,t),n(e,dt,t),n(e,na,t),u(ct,e,t),n(e,sa,t),n(e,ft,t),n(e,aa,t),n(e,yt,t),n(e,ia,t),n(e,bt,t),n(e,oa,t),n(e,gt,t),n(e,ra,t),n(e,wt,t),n(e,pa,t),n(e,Tt,t),n(e,ma,t),n(e,vt,t),n(e,ua,t),n(e,jt,t),n(e,Ma,t),u(Ut,e,t),n(e,ha,t),n(e,Jt,t),n(e,da,t),u(Ct,e,t),n(e,ca,t),u(It,e,t),n(e,fa,t),n(e,$t,t),n(e,ya,t),n(e,ba,t),n(e,ga,t),n(e,_t,t),n(e,wa,t),n(e,Ta,t),n(e,va,t),n(e,Zt,t),n(e,ja,t),n(e,Bt,t),n(e,Ua,t),n(e,Lt,t),n(e,Ja,t),n(e,Wt,t),n(e,Ca,t),n(e,Ht,t),n(e,Ia,t),n(e,xt,t),n(e,$a,t),n(e,kt,t),n(e,_a,t),n(e,Gt,t),n(e,Za,t),u(Rt,e,t),n(e,Ba,t),u(Yt,e,t),n(e,La,t),u(Et,e,t),n(e,Wa,t),u(Xt,e,t),n(e,Ha,t),u(Vt,e,t),n(e,xa,t),n(e,St,t),n(e,ka,t),u(Ft,e,t),n(e,Ga,t),u(Qt,e,t),n(e,Ra,t),u(zt,e,t),n(e,Ya,t),u(Pt,e,t),n(e,Ea,t),n(e,At,t),n(e,Xa,t),n(e,Nt,t),n(e,Va,t),u(Dt,e,t),n(e,Sa,t),u(qt,e,t),n(e,Fa,t),u(Ot,e,t),n(e,Qa,t),n(e,Kt,t),n(e,za,t),u(el,e,t),n(e,Pa,t),n(e,tl,t),n(e,Aa,t),n(e,ll,t),n(e,Na,t),n(e,nl,t),n(e,Da,t),n(e,sl,t),n(e,qa,t),n(e,al,t),n(e,Oa,t),n(e,il,t),n(e,Ka,t),n(e,ol,t),n(e,ei,t),n(e,rl,t),n(e,ti,t),n(e,pl,t),n(e,li,t),n(e,ml,t),n(e,ni,t),n(e,ul,t),n(e,si,t),n(e,Ml,t),n(e,ai,t),u(hl,e,t),n(e,ii,t),n(e,dl,t),n(e,oi,t),n(e,cl,t),n(e,ri,t),n(e,fl,t),n(e,pi,t),n(e,yl,t),n(e,mi,t),n(e,bl,t),n(e,ui,t),n(e,gl,t),n(e,Mi,t),u(wl,e,t),n(e,hi,t),u(Tl,e,t),n(e,di,t),u(vl,e,t),n(e,ci,t),n(e,jl,t),n(e,fi,t),n(e,Ul,t),n(e,yi,t),n(e,Jl,t),n(e,bi,t),n(e,Cl,t),n(e,gi,t),u(Il,e,t),n(e,wi,t),n(e,$l,t),n(e,Ti,t),n(e,_l,t),n(e,vi,t),n(e,Zl,t),n(e,ji,t),n(e,Bl,t),n(e,Ui,t),n(e,Ll,t),n(e,Ji,t),n(e,j,t),n(e,Ci,t),n(e,Wl,t),n(e,Ii,t),n(e,Hl,t),n(e,$i,t),n(e,xl,t),n(e,_i,t),u(kl,e,t),n(e,Zi,t),u(Gl,e,t),n(e,Bi,t),n(e,Rl,t),n(e,Li,t),u(Yl,e,t),n(e,Wi,t),u(El,e,t),n(e,Hi,t),n(e,Xl,t),n(e,xi,t),n(e,Vl,t),n(e,ki,t),n(e,Sl,t),n(e,Gi,t),n(e,Fl,t),n(e,Ri,t),n(e,Ql,t),n(e,Yi,t),n(e,zl,t),n(e,Ei,t),n(e,Xi,t),n(e,Vi,t),n(e,Pl,t),n(e,Si,t),n(e,Al,t),n(e,Fi,t),n(e,Nl,t),n(e,Qi,t),n(e,Dl,t),n(e,zi,t),n(e,ql,t),n(e,Pi,t),n(e,Ol,t),n(e,Ai,t),u(Kl,e,t),n(e,Ni,t),u(en,e,t),n(e,Di,t),n(e,ln,t),qi=!0},p:Rp,i(e){qi||(M(U.$$.fragment,e),M(J.$$.fragment,e),M(E.$$.fragment,e),M(V.$$.fragment,e),M(F.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(de.$$.fragment,e),M(be.$$.fragment,e),M(je.$$.fragment,e),M(Ie.$$.fragment,e),M($e.$$.fragment,e),M(Be.$$.fragment,e),M(We.$$.fragment,e),M(He.$$.fragment,e),M(xe.$$.fragment,e),M(Ye.$$.fragment,e),M(Ee.$$.fragment,e),M(at.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(Mt.$$.fragment,e),M(ct.$$.fragment,e),M(Ut.$$.fragment,e),M(Ct.$$.fragment,e),M(It.$$.fragment,e),M(Rt.$$.fragment,e),M(Yt.$$.fragment,e),M(Et.$$.fragment,e),M(Xt.$$.fragment,e),M(Vt.$$.fragment,e),M(Ft.$$.fragment,e),M(Qt.$$.fragment,e),M(zt.$$.fragment,e),M(Pt.$$.fragment,e),M(Dt.$$.fragment,e),M(qt.$$.fragment,e),M(Ot.$$.fragment,e),M(el.$$.fragment,e),M(hl.$$.fragment,e),M(wl.$$.fragment,e),M(Tl.$$.fragment,e),M(vl.$$.fragment,e),M(Il.$$.fragment,e),M(kl.$$.fragment,e),M(Gl.$$.fragment,e),M(Yl.$$.fragment,e),M(El.$$.fragment,e),M(Kl.$$.fragment,e),M(en.$$.fragment,e),qi=!0)},o(e){h(U.$$.fragment,e),h(J.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h($e.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(He.$$.fragment,e),h(xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ee.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(ot.$$.fragment,e),h(Mt.$$.fragment,e),h(ct.$$.fragment,e),h(Ut.$$.fragment,e),h(Ct.$$.fragment,e),h(It.$$.fragment,e),h(Rt.$$.fragment,e),h(Yt.$$.fragment,e),h(Et.$$.fragment,e),h(Xt.$$.fragment,e),h(Vt.$$.fragment,e),h(Ft.$$.fragment,e),h(Qt.$$.fragment,e),h(zt.$$.fragment,e),h(Pt.$$.fragment,e),h(Dt.$$.fragment,e),h(qt.$$.fragment,e),h(Ot.$$.fragment,e),h(el.$$.fragment,e),h(hl.$$.fragment,e),h(wl.$$.fragment,e),h(Tl.$$.fragment,e),h(vl.$$.fragment,e),h(Il.$$.fragment,e),h(kl.$$.fragment,e),h(Gl.$$.fragment,e),h(Yl.$$.fragment,e),h(El.$$.fragment,e),h(Kl.$$.fragment,e),h(en.$$.fragment,e),qi=!1},d(e){e&&(l(nn),l(tn),l(sn),l(an),l(on),l(C),l(rn),l(I),l(pn),l($),l(mn),l(_),l(un),l(Z),l(Mn),l(B),l(hn),l(L),l(dn),l(W),l(cn),l(H),l(fn),l(x),l(yn),l(k),l(bn),l(G),l(gn),l(R),l(wn),l(Y),l(Tn),l(vn),l(w),l(jn),l(X),l(Un),l(Jn),l(S),l(Cn),l(In),l(Q),l($n),l(z),l(_n),l(Zn),l(A),l(Bn),l(N),l(Ln),l(Wn),l(q),l(Hn),l(O),l(xn),l(K),l(kn),l(ee),l(Gn),l(te),l(Rn),l(le),l(Yn),l(ne),l(En),l(Xn),l(ae),l(Vn),l(ie),l(Sn),l(oe),l(Fn),l(Qn),l(T),l(zn),l(pe),l(Pn),l(me),l(An),l(ue),l(Nn),l(Me),l(Dn),l(qn),l(On),l(ce),l(Kn),l(fe),l(es),l(ye),l(ts),l(ls),l(ge),l(ns),l(we),l(ss),l(Te),l(as),l(ve),l(is),l(os),l(Ue),l(rs),l(Je),l(ps),l(Ce),l(ms),l(us),l(Ms),l(_e),l(hs),l(Ze),l(ds),l(cs),l(Le),l(fs),l(ys),l(bs),l(gs),l(ke),l(ws),l(Ge),l(Ts),l(Re),l(vs),l(js),l(Us),l(Xe),l(Js),l(Ve),l(Cs),l(Se),l(Is),l(Fe),l($s),l(Qe),l(_s),l(v),l(Zs),l(ze),l(Bs),l(Pe),l(Ls),l(Ae),l(Ws),l(Ne),l(Hs),l(De),l(xs),l(qe),l(ks),l(Oe),l(Gs),l(Ke),l(Rs),l(et),l(Ys),l(tt),l(Es),l(lt),l(Xs),l(nt),l(Vs),l(st),l(Ss),l(Fs),l(Qs),l(zs),l(rt),l(Ps),l(As),l(Ns),l(pt),l(Ds),l(mt),l(qs),l(Os),l(Ks),l(ut),l(ea),l(ta),l(ht),l(la),l(dt),l(na),l(sa),l(ft),l(aa),l(yt),l(ia),l(bt),l(oa),l(gt),l(ra),l(wt),l(pa),l(Tt),l(ma),l(vt),l(ua),l(jt),l(Ma),l(ha),l(Jt),l(da),l(ca),l(fa),l($t),l(ya),l(ba),l(ga),l(_t),l(wa),l(Ta),l(va),l(Zt),l(ja),l(Bt),l(Ua),l(Lt),l(Ja),l(Wt),l(Ca),l(Ht),l(Ia),l(xt),l($a),l(kt),l(_a),l(Gt),l(Za),l(Ba),l(La),l(Wa),l(Ha),l(xa),l(St),l(ka),l(Ga),l(Ra),l(Ya),l(Ea),l(At),l(Xa),l(Nt),l(Va),l(Sa),l(Fa),l(Qa),l(Kt),l(za),l(Pa),l(tl),l(Aa),l(ll),l(Na),l(nl),l(Da),l(sl),l(qa),l(al),l(Oa),l(il),l(Ka),l(ol),l(ei),l(rl),l(ti),l(pl),l(li),l(ml),l(ni),l(ul),l(si),l(Ml),l(ai),l(ii),l(dl),l(oi),l(cl),l(ri),l(fl),l(pi),l(yl),l(mi),l(bl),l(ui),l(gl),l(Mi),l(hi),l(di),l(ci),l(jl),l(fi),l(Ul),l(yi),l(Jl),l(bi),l(Cl),l(gi),l(wi),l($l),l(Ti),l(_l),l(vi),l(Zl),l(ji),l(Bl),l(Ui),l(Ll),l(Ji),l(j),l(Ci),l(Wl),l(Ii),l(Hl),l($i),l(xl),l(_i),l(Zi),l(Bi),l(Rl),l(Li),l(Wi),l(Hi),l(Xl),l(xi),l(Vl),l(ki),l(Sl),l(Gi),l(Fl),l(Ri),l(Ql),l(Yi),l(zl),l(Ei),l(Xi),l(Vi),l(Pl),l(Si),l(Al),l(Fi),l(Nl),l(Qi),l(Dl),l(zi),l(ql),l(Pi),l(Ol),l(Ai),l(Ni),l(Di),l(ln)),l(g),d(U,e),d(J,e),d(E,e),d(V,e),d(F,e),d(P,e),d(D,e),d(se,e),d(re,e),d(he,e),d(de,e),d(be,e),d(je,e),d(Ie,e),d($e,e),d(Be,e),d(We,e),d(He,e),d(xe,e),d(Ye,e),d(Ee,e),d(at,e),d(it,e),d(ot,e),d(Mt,e),d(ct,e),d(Ut,e),d(Ct,e),d(It,e),d(Rt,e),d(Yt,e),d(Et,e),d(Xt,e),d(Vt,e),d(Ft,e),d(Qt,e),d(zt,e),d(Pt,e),d(Dt,e),d(qt,e),d(Ot,e),d(el,e),d(hl,e),d(wl,e),d(Tl,e),d(vl,e),d(Il,e),d(kl,e),d(Gl,e),d(Yl,e),d(El,e),d(Kl,e),d(en,e)}}}const Pp='{"title":"Train your first Deep Reinforcement Learning Agent 🤖","local":"hands-on","sections":[],"depth":1}';function Ap(Oi){return Yp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class em extends Ep{constructor(g){super(),Xp(this,g,Ap,zp,Gp,{})}}export{em as component};
