import{s as nl,n as Tl,o as Jl}from"../chunks/scheduler.7da89386.js";import{S as il,i as wl,g as n,s,r as Q,A as ol,h as T,f as a,c as M,j as el,u as G,x as i,k as sl,y as jl,a as e,v as H,d as L,t as V,w as $}from"../chunks/index.20910acc.js";import{C as Ml}from"../chunks/CodeBlock.143bd81e.js";import{H as Il,E as pl}from"../chunks/getInferenceSnippets.217b4024.js";function ul(Y){let J,g,C,f,w,b,o,z="It can be useful to evaluate models on a variety of different tasks to understand their downstream performance. Assessing the model on several types of tasks can reveal gaps in performance along some axis. For example, when training a language model, it is often useful to measure perplexity on an in-domain corpus, but also to concurrently evaluate on tasks which test for general language capabilities like natural language entailment or question-answering, or tasks designed to probe the model along fairness and bias dimensions.",v,j,R='The <code>EvaluationSuite</code> provides a way to compose any number of (<a href="base_evaluator">evaluator</a>, dataset, metric) tuples as a SubTask to evaluate a model on a collection of several evaluation tasks. See the <a href="base_evaluator">evaluator documentation</a> for a list of currently supported tasks.',_,I,P="A new <code>EvaluationSuite</code> is made up of a list of <code>SubTask</code> classes, each defining an evaluation task. The Python file containing the definition can be uploaded to a Space on the Hugging Face Hub so it can be shared with the community or saved/loaded locally as a Python script.",E,p,D="Some datasets require additional preprocessing before passing them to an <code>Evaluator</code>. You can set a <code>data_preprocessor</code> for each <code>SubTask</code> which is applied via a <code>map</code> operation using the <code>datasets</code> library. Keyword arguments for the <code>Evaluator</code> can be passed down through the <code>args_for_task</code> attribute.",B,u,K='To create a new <code>EvaluationSuite</code>, create a <a href="https://huggingface.co/new-space" rel="nofollow">new Space</a> with a .py file which matches the name of the Space, add the below template to a Python file, and fill in the attributes for a new task.',q,y,O="The mandatory attributes for a new <code>SubTask</code> are <code>task_type</code> and <code>data</code>.",k,r,ll="<li><code>task_type</code> maps to the tasks currently supported by the Evaluator.</li> <li><code>data</code> can be an instantiated Hugging Face dataset object or the name of a dataset.</li> <li><code>subset</code> and <code>split</code> can be used to define which name and split of the dataset should be used for evaluation.</li> <li><code>args_for_task</code> should be a dictionary with kwargs to be passed to the Evaluator.</li>",W,A,x,c,tl="An <code>EvaluationSuite</code> can be loaded by name from the Hugging Face Hub, or locally by providing a path, and run with the <code>run(model_or_pipeline)</code> method. The evaluation results are returned along with their task names and information about the time it took to obtain predictions through the pipeline. These can be easily displayed with a <code>pandas.DataFrame</code>:",S,d,Z,h,al='<thead><tr><th align="right">accuracy</th> <th align="right">total_time_in_seconds</th> <th align="right">samples_per_second</th> <th align="right">latency_in_seconds</th> <th align="left">task_name</th></tr></thead> <tbody><tr><td align="right">0.5</td> <td align="right">0.740811</td> <td align="right">13.4987</td> <td align="right">0.0740811</td> <td align="left">glue/sst2</td></tr> <tr><td align="right">0.4</td> <td align="right">1.67552</td> <td align="right">5.9683</td> <td align="right">0.167552</td> <td align="left">glue/rte</td></tr></tbody>',N,U,F,m,X;return w=new Il({props:{title:"Creating an EvaluationSuite",local:"creating-an-evaluationsuite",headingTag:"h1"}}),A=new Ml({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> evaluate.evaluation_suite <span class="hljs-keyword">import</span> SubTask

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Suite</span>(evaluate.EvaluationSuite):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, name</span>):
        <span class="hljs-built_in">super</span>().__init__(name)
        self.preprocessor = <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text&quot;</span>: x[<span class="hljs-string">&quot;text&quot;</span>].lower()}
        self.suite = [
            SubTask(
                task_type=<span class="hljs-string">&quot;text-classification&quot;</span>,
                data=<span class="hljs-string">&quot;glue&quot;</span>,
                subset=<span class="hljs-string">&quot;sst2&quot;</span>,
                split=<span class="hljs-string">&quot;validation[:10]&quot;</span>,
                args_for_task={
                    <span class="hljs-string">&quot;metric&quot;</span>: <span class="hljs-string">&quot;accuracy&quot;</span>,
                    <span class="hljs-string">&quot;input_column&quot;</span>: <span class="hljs-string">&quot;sentence&quot;</span>,
                    <span class="hljs-string">&quot;label_column&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>,
                    <span class="hljs-string">&quot;label_mapping&quot;</span>: {
                        <span class="hljs-string">&quot;LABEL_0&quot;</span>: <span class="hljs-number">0.0</span>,
                        <span class="hljs-string">&quot;LABEL_1&quot;</span>: <span class="hljs-number">1.0</span>
                    }
                }
            ),
            SubTask(
                task_type=<span class="hljs-string">&quot;text-classification&quot;</span>,
                data=<span class="hljs-string">&quot;glue&quot;</span>,
                subset=<span class="hljs-string">&quot;rte&quot;</span>,
                split=<span class="hljs-string">&quot;validation[:10]&quot;</span>,
                args_for_task={
                    <span class="hljs-string">&quot;metric&quot;</span>: <span class="hljs-string">&quot;accuracy&quot;</span>,
                    <span class="hljs-string">&quot;input_column&quot;</span>: <span class="hljs-string">&quot;sentence1&quot;</span>,
                    <span class="hljs-string">&quot;second_input_column&quot;</span>: <span class="hljs-string">&quot;sentence2&quot;</span>,
                    <span class="hljs-string">&quot;label_column&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>,
                    <span class="hljs-string">&quot;label_mapping&quot;</span>: {
                        <span class="hljs-string">&quot;LABEL_0&quot;</span>: <span class="hljs-number">0</span>,
                        <span class="hljs-string">&quot;LABEL_1&quot;</span>: <span class="hljs-number">1</span>
                    }
                }
            )
        ]`,wrap:!1}}),d=new Ml({props:{code:"ZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwRXZhbHVhdGlvblN1aXRlJTBBc3VpdGUlMjAlM0QlMjBFdmFsdWF0aW9uU3VpdGUubG9hZCgnbWF0aGVtYWtpdHRlbiUyRmdsdWUtZXZhbHVhdGlvbi1zdWl0ZScpJTBBcmVzdWx0cyUyMCUzRCUyMHN1aXRlLnJ1biglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> EvaluationSuite</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">suite = EvaluationSuite.load(<span class="hljs-string">&#x27;mathemakitten/glue-evaluation-suite&#x27;</span>)</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">results = suite.run(<span class="hljs-string">&quot;gpt2&quot;</span>)</span>`,wrap:!1}}),U=new pl({props:{source:"https://github.com/huggingface/evaluate/blob/main/docs/source/evaluation_suite.mdx"}}),{c(){J=n("meta"),g=s(),C=n("p"),f=s(),Q(w.$$.fragment),b=s(),o=n("p"),o.textContent=z,v=s(),j=n("p"),j.innerHTML=R,_=s(),I=n("p"),I.innerHTML=P,E=s(),p=n("p"),p.innerHTML=D,B=s(),u=n("p"),u.innerHTML=K,q=s(),y=n("p"),y.innerHTML=O,k=s(),r=n("ol"),r.innerHTML=ll,W=s(),Q(A.$$.fragment),x=s(),c=n("p"),c.innerHTML=tl,S=s(),Q(d.$$.fragment),Z=s(),h=n("table"),h.innerHTML=al,N=s(),Q(U.$$.fragment),F=s(),m=n("p"),this.h()},l(l){const t=ol("svelte-u9bgzb",document.head);J=T(t,"META",{name:!0,content:!0}),t.forEach(a),g=M(l),C=T(l,"P",{}),el(C).forEach(a),f=M(l),G(w.$$.fragment,l),b=M(l),o=T(l,"P",{"data-svelte-h":!0}),i(o)!=="svelte-1o9jx98"&&(o.textContent=z),v=M(l),j=T(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-ilp2q5"&&(j.innerHTML=R),_=M(l),I=T(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1n2uses"&&(I.innerHTML=P),E=M(l),p=T(l,"P",{"data-svelte-h":!0}),i(p)!=="svelte-vv6oy3"&&(p.innerHTML=D),B=M(l),u=T(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-hb1yl5"&&(u.innerHTML=K),q=M(l),y=T(l,"P",{"data-svelte-h":!0}),i(y)!=="svelte-8icix4"&&(y.innerHTML=O),k=M(l),r=T(l,"OL",{"data-svelte-h":!0}),i(r)!=="svelte-14zybc3"&&(r.innerHTML=ll),W=M(l),G(A.$$.fragment,l),x=M(l),c=T(l,"P",{"data-svelte-h":!0}),i(c)!=="svelte-j5in79"&&(c.innerHTML=tl),S=M(l),G(d.$$.fragment,l),Z=M(l),h=T(l,"TABLE",{"data-svelte-h":!0}),i(h)!=="svelte-1ictp82"&&(h.innerHTML=al),N=M(l),G(U.$$.fragment,l),F=M(l),m=T(l,"P",{}),el(m).forEach(a),this.h()},h(){sl(J,"name","hf:doc:metadata"),sl(J,"content",yl)},m(l,t){jl(document.head,J),e(l,g,t),e(l,C,t),e(l,f,t),H(w,l,t),e(l,b,t),e(l,o,t),e(l,v,t),e(l,j,t),e(l,_,t),e(l,I,t),e(l,E,t),e(l,p,t),e(l,B,t),e(l,u,t),e(l,q,t),e(l,y,t),e(l,k,t),e(l,r,t),e(l,W,t),H(A,l,t),e(l,x,t),e(l,c,t),e(l,S,t),H(d,l,t),e(l,Z,t),e(l,h,t),e(l,N,t),H(U,l,t),e(l,F,t),e(l,m,t),X=!0},p:Tl,i(l){X||(L(w.$$.fragment,l),L(A.$$.fragment,l),L(d.$$.fragment,l),L(U.$$.fragment,l),X=!0)},o(l){V(w.$$.fragment,l),V(A.$$.fragment,l),V(d.$$.fragment,l),V(U.$$.fragment,l),X=!1},d(l){l&&(a(g),a(C),a(f),a(b),a(o),a(v),a(j),a(_),a(I),a(E),a(p),a(B),a(u),a(q),a(y),a(k),a(r),a(W),a(x),a(c),a(S),a(Z),a(h),a(N),a(F),a(m)),a(J),$(w,l),$(A,l),$(d,l),$(U,l)}}}const yl='{"title":"Creating an EvaluationSuite","local":"creating-an-evaluationsuite","sections":[],"depth":1}';function rl(Y){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends il{constructor(J){super(),wl(this,J,rl,ul,nl,{})}}export{Ul as component};
