import{s as fs,n as Cs,o as Is}from"../chunks/scheduler.85c25b89.js";import{S as Zs,i as ks,g as p,s as a,r as i,A as $s,h as m,f as l,c as n,j as bs,u as o,x as j,k as Us,y as Ws,a as e,v as M,d as r,t as c,w as h}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as V}from"../chunks/Heading.3097d2ed.js";function Ns(rs){let J,_,G,X,y,H,d,cs='<strong>Wide Residual Networks</strong> are a variant on <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> where we decrease depth and increase the width of residual networks. This is achieved through the use of <a href="https://paperswithcode.com/method/wide-residual-block" rel="nofollow">wide residual blocks</a>.',Y,w,S,g,hs="To load a pretrained model:",z,T,F,u,js="To load and preprocess the image:",D,b,L,U,Js="To get the model predictions:",q,f,P,C,ys="To get the top-5 predictions class names:",K,I,O,Z,ds="Replace the model name with the variant you want to use, e.g. <code>wide_resnet101_2</code>. You can find the IDs in the model summaries at the top of this page.",ss,k,ws='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,$,ls,W,gs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,N,as,B,Ts=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,x,ps,R,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,E,is,A,os,v,Ms;return y=new V({props:{title:"Wide ResNet",local:"wide-resnet",headingTag:"h1"}}),w=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3dpZGVfcmVzbmV0MTAxXzInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),$=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnd2lkZV9yZXNuZXQxMDFfMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),A=new Q({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTZXJnZXklMjBaYWdvcnV5a28lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOaWtvcyUyMEtvbW9kYWtpcyU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCV2lkZSUyMFJlc2lkdWFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDUuMDcxNDYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA1LjA3MTQ2JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwNS4wNzE0NiU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEzJTIwQXVnJTIwMjAxOCUyMDE2JTNBNDYlM0E0MiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGWmFnb3J1eWtvSzE2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16,
  author    = {Sergey Zagoruyko and
               Nikos Komodakis},
  title     = {Wide Residual Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1605.07146</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1605.07146</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1605.07146</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">46</span>:<span class="hljs-number">42</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),{c(){J=p("meta"),_=a(),G=p("p"),X=a(),i(y.$$.fragment),H=a(),d=p("p"),d.innerHTML=cs,Y=a(),i(w.$$.fragment),S=a(),g=p("p"),g.textContent=hs,z=a(),i(T.$$.fragment),F=a(),u=p("p"),u.textContent=js,D=a(),i(b.$$.fragment),L=a(),U=p("p"),U.textContent=Js,q=a(),i(f.$$.fragment),P=a(),C=p("p"),C.textContent=ys,K=a(),i(I.$$.fragment),O=a(),Z=p("p"),Z.innerHTML=ds,ss=a(),k=p("p"),k.innerHTML=ws,ts=a(),i($.$$.fragment),ls=a(),W=p("p"),W.textContent=gs,es=a(),i(N.$$.fragment),as=a(),B=p("p"),B.innerHTML=Ts,ns=a(),i(x.$$.fragment),ps=a(),R=p("p"),R.innerHTML=us,ms=a(),i(E.$$.fragment),is=a(),i(A.$$.fragment),os=a(),v=p("p"),this.h()},l(s){const t=$s("svelte-u9bgzb",document.head);J=m(t,"META",{name:!0,content:!0}),t.forEach(l),_=n(s),G=m(s,"P",{}),bs(G).forEach(l),X=n(s),o(y.$$.fragment,s),H=n(s),d=m(s,"P",{"data-svelte-h":!0}),j(d)!=="svelte-k7y9u3"&&(d.innerHTML=cs),Y=n(s),o(w.$$.fragment,s),S=n(s),g=m(s,"P",{"data-svelte-h":!0}),j(g)!=="svelte-18ywhxh"&&(g.textContent=hs),z=n(s),o(T.$$.fragment,s),F=n(s),u=m(s,"P",{"data-svelte-h":!0}),j(u)!=="svelte-1c2ipa8"&&(u.textContent=js),D=n(s),o(b.$$.fragment,s),L=n(s),U=m(s,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1n9qsq1"&&(U.textContent=Js),q=n(s),o(f.$$.fragment,s),P=n(s),C=m(s,"P",{"data-svelte-h":!0}),j(C)!=="svelte-19cnvx1"&&(C.textContent=ys),K=n(s),o(I.$$.fragment,s),O=n(s),Z=m(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1x7kcxy"&&(Z.innerHTML=ds),ss=n(s),k=m(s,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1wmi3ea"&&(k.innerHTML=ws),ts=n(s),o($.$$.fragment,s),ls=n(s),W=m(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-9sr7nh"&&(W.textContent=gs),es=n(s),o(N.$$.fragment,s),as=n(s),B=m(s,"P",{"data-svelte-h":!0}),j(B)!=="svelte-1kguc51"&&(B.innerHTML=Ts),ns=n(s),o(x.$$.fragment,s),ps=n(s),R=m(s,"P",{"data-svelte-h":!0}),j(R)!=="svelte-1n0coha"&&(R.innerHTML=us),ms=n(s),o(E.$$.fragment,s),is=n(s),o(A.$$.fragment,s),os=n(s),v=m(s,"P",{}),bs(v).forEach(l),this.h()},h(){Us(J,"name","hf:doc:metadata"),Us(J,"content",Bs)},m(s,t){Ws(document.head,J),e(s,_,t),e(s,G,t),e(s,X,t),M(y,s,t),e(s,H,t),e(s,d,t),e(s,Y,t),M(w,s,t),e(s,S,t),e(s,g,t),e(s,z,t),M(T,s,t),e(s,F,t),e(s,u,t),e(s,D,t),M(b,s,t),e(s,L,t),e(s,U,t),e(s,q,t),M(f,s,t),e(s,P,t),e(s,C,t),e(s,K,t),M(I,s,t),e(s,O,t),e(s,Z,t),e(s,ss,t),e(s,k,t),e(s,ts,t),M($,s,t),e(s,ls,t),e(s,W,t),e(s,es,t),M(N,s,t),e(s,as,t),e(s,B,t),e(s,ns,t),M(x,s,t),e(s,ps,t),e(s,R,t),e(s,ms,t),M(E,s,t),e(s,is,t),M(A,s,t),e(s,os,t),e(s,v,t),Ms=!0},p:Cs,i(s){Ms||(r(y.$$.fragment,s),r(w.$$.fragment,s),r(T.$$.fragment,s),r(b.$$.fragment,s),r(f.$$.fragment,s),r(I.$$.fragment,s),r($.$$.fragment,s),r(N.$$.fragment,s),r(x.$$.fragment,s),r(E.$$.fragment,s),r(A.$$.fragment,s),Ms=!0)},o(s){c(y.$$.fragment,s),c(w.$$.fragment,s),c(T.$$.fragment,s),c(b.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c($.$$.fragment,s),c(N.$$.fragment,s),c(x.$$.fragment,s),c(E.$$.fragment,s),c(A.$$.fragment,s),Ms=!1},d(s){s&&(l(_),l(G),l(X),l(H),l(d),l(Y),l(S),l(g),l(z),l(F),l(u),l(D),l(L),l(U),l(q),l(P),l(C),l(K),l(O),l(Z),l(ss),l(k),l(ts),l(ls),l(W),l(es),l(as),l(B),l(ns),l(ps),l(R),l(ms),l(is),l(os),l(v)),l(J),h(y,s),h(w,s),h(T,s),h(b,s),h(f,s),h(I,s),h($,s),h(N,s),h(x,s),h(E,s),h(A,s)}}}const Bs='{"title":"Wide ResNet","local":"wide-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(rs){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends Zs{constructor(J){super(),ks(this,J,xs,Ns,fs,{})}}export{Gs as component};
