import{s as kh,o as vh,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as qh,i as Ah,g as u,s as i,r as h,A as Eh,h as m,f as g,c as r,j as k,u as d,x as I,k as v,y as l,a as _,v as f,d as y,t as b,w as M}from"../chunks/index.4bca734e.js";import{T as G}from"../chunks/Tip.b9ac1f03.js";import{D as A}from"../chunks/Docstring.81ba5e3c.js";import{C as w}from"../chunks/CodeBlock.fa01571c.js";import{E as C}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as ql,E as Nh}from"../chunks/EditOnGithub.74ab2baa.js";function Zh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Wh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Gh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Bh(T){let n,p=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function Qh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Sh(T){let n,p="Example using streaming:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Vh(T){let n,p="Example using OpenAI’s syntax:",a,t,o;return t=new w({props:{code:"JTIzJTIwaW5zdGVhZCUyMG9mJTIwJTYwZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSU2MCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QuLi4lMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDb3VudCUyMHRvJTIwMTAlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBZm9yJTIwY2h1bmslMjBpbiUyMG91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQp",highlighted:`<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = InferenceClient(
    base_url=...,
    api_key=...,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Yh(T){let n,p="Example using Image + Text as input:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function zh(T){let n,p="Example using tools:",a,t,o;return t=new w({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJEb24ndCUyMG1ha2UlMjBhc3N1bXB0aW9ucyUyMGFib3V0JTIwd2hhdCUyMHZhbHVlcyUyMHRvJTIwcGx1ZyUyMGludG8lMjBmdW5jdGlvbnMuJTIwQXNrJTIwZm9yJTIwY2xhcmlmaWNhdGlvbiUyMGlmJTIwYSUyMHVzZXIlMjByZXF1ZXN0JTIwaXMlMjBhbWJpZ3VvdXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGxpa2UlMjB0aGUlMjBuZXh0JTIwMyUyMGRheXMlMjBpbiUyMFNhbiUyMEZyYW5jaXNjbyUyQyUyMENBJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBdG9vbHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF93ZWF0aGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJHZXQlMjB0aGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxvY2F0aW9uJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwY2l0eSUyMGFuZCUyMHN0YXRlJTJDJTIwZS5nLiUyMFNhbiUyMEZyYW5jaXNjbyUyQyUyMENBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZm9ybWF0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVudW0lMjIlM0ElMjAlNUIlMjJjZWxzaXVzJTIyJTJDJTIwJTIyZmFocmVuaGVpdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwdGVtcGVyYXR1cmUlMjB1bml0JTIwdG8lMjB1c2UuJTIwSW5mZXIlMjB0aGlzJTIwZnJvbSUyMHRoZSUyMHVzZXJzJTIwbG9jYXRpb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVxdWlyZWQlMjIlM0ElMjAlNUIlMjJsb2NhdGlvbiUyMiUyQyUyMCUyMmZvcm1hdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZ1bmN0aW9uJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9uX2RheV93ZWF0aGVyX2ZvcmVjYXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJHZXQlMjBhbiUyME4tZGF5JTIwd2VhdGhlciUyMGZvcmVjYXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJvYmplY3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcm9wZXJ0aWVzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9jYXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBjaXR5JTIwYW5kJTIwc3RhdGUlMkMlMjBlLmcuJTIwU2FuJTIwRnJhbmNpc2NvJTJDJTIwQ0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmb3JtYXQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW51bSUyMiUzQSUyMCU1QiUyMmNlbHNpdXMlMjIlMkMlMjAlMjJmYWhyZW5oZWl0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjB0ZW1wZXJhdHVyZSUyMHVuaXQlMjB0byUyMHVzZS4lMjBJbmZlciUyMHRoaXMlMjBmcm9tJTIwdGhlJTIwdXNlcnMlMjBsb2NhdGlvbi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1fZGF5cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbnRlZ2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBudW1iZXIlMjBvZiUyMGRheXMlMjB0byUyMGZvcmVjYXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVxdWlyZWQlMjIlM0ElMjAlNUIlMjJsb2NhdGlvbiUyMiUyQyUyMCUyMmZvcm1hdCUyMiUyQyUyMCUyMm51bV9kYXlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRG1lc3NhZ2VzJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0R0b29scyUyQyUwQSUyMCUyMCUyMCUyMHRvb2xfY2hvaWNlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0Q1MDAlMkMlMEEpJTBBcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS50b29sX2NhbGxzJTVCMCU1RC5mdW5jdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Rh(T){let n,p="Example using response_format:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Xh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Fh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Dh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Oh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Hh(T){let n,p=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-33gpw6"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function Lh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Ph(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Kh(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function ed(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function nd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function td(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function sd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function ad(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function ld(T){let n,p=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-79tj90"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function od(T){let n,p=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1vz9qc7"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function id(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function rd(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function cd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function pd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function gd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function ud(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function md(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function hd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function dd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function fd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function yd(T){let n,p=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1jtiv7y"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function bd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Md(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function jd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function _d(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Td(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Id(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Jd(T){let n,p="Specifying languages:",a,t,o;return t=new w({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function wd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function xd(T){let n,p="Example with <code>multi_label=False</code>:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Cd(T){let n,p="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Ud(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function $d(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function kd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function vd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function qd(T){let n,p=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function Ad(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Ed(T){let n,p="Example using streaming:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Nd(T){let n,p="Example using OpenAI’s syntax:",a,t,o;return t=new w({props:{code:"JTIzJTIwTXVzdCUyMGJlJTIwcnVuJTIwaW4lMjBhbiUyMGFzeW5jJTIwY29udGV4dCUwQSUyMyUyMGluc3RlYWQlMjBvZiUyMCU2MGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklNjAlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEElMEFvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = AsyncInferenceClient(
    base_url=...,
    api_key=...,
)

output = <span class="hljs-keyword">await</span> client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Zd(T){let n,p="Example using Image + Text as input:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Wd(T){let n,p="Example using tools:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Gd(T){let n,p="Example using response_format:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Bd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Qd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Sd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Vd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Yd(T){let n,p=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-33gpw6"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function zd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Rd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Xd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Fd(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function Dd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Od(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function Hd(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Ld(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Pd(T){let n,p=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-79tj90"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function Kd(T){let n,p=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1vz9qc7"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function ef(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function nf(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function tf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function sf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function af(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function lf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function of(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function rf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function cf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function pf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function gf(T){let n,p=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1jtiv7y"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function uf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function mf(T){let n,p="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=p},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=p)},m(a,t){_(a,n,t)},p:J,d(a){a&&g(n)}}}function hf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function df(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function ff(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function yf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function bf(T){let n,p="Specifying languages:",a,t,o;return t=new w({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Mf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function jf(T){let n,p="Example with <code>multi_label=False</code>:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function _f(T){let n,p="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Tf(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function If(T){let n,p="Example:",a,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=p,a=i(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=p),a=r(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(g(n),g(a)),M(t,e)}}}function Jf(T){let n,p,a,t,o,e,c,Mu="추론은 학습된 모델을 사용하여 새로운 데이터를 예측하는 과정입니다. 이 과정은 계산량이 많을 수 있기 때문에, 전용 서버에서 실행하는 것이 흥미로운 옵션이 될 수 있습니다. <code>huggingface_hub</code> 라이브러리는 호스팅된 모델에 대한 추론을 실행하는 간단한 방법을 제공합니다. 연결할 수 있는 서비스는 여러가지가 있습니다:",yi,Os,ju='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">추론 API</a>: Hugging Face의 인프라에서 가속화된 추론을 무료로 실행할 수 있는 서비스입니다. 이 서비스는 시작하기 위한 빠른 방법이며, 다양한 모델을 테스트하고 AI 제품을 프로토타입화하는 데에도 유용합니다.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">추론 엔드포인트</a>: 모델을 쉽게 운영 환경으로 배포할 수 있는 제품입니다. 추론은 여러분이 선택한 클라우드 제공업체의 전용 및 완전히 관리되는 인프라에서 Hugging Face에 의해 실행됩니다.</li>',bi,Hs,_u='이러한 서비스는 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> 객체를 사용하여 호출할 수 있습니다. 자세한 사용 방법에 대해서는 <a href="../guides/inference">이 가이드</a>를 참조해주세요.',Mi,Ls,ji,U,Ps,Wi,Al,Tu="Initialize a new Inference Client.",Gi,El,Iu=`<a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,Bi,We,Ks,Qi,Nl,Ju="Perform audio classification on the provided audio content.",Si,at,Vi,Ge,ea,Yi,Zl,wu="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",zi,lt,Ri,Be,na,Xi,Wl,xu="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Fi,ot,Di,E,ta,Oi,Gl,Cu="A method for completing conversations using a specified language model.",Hi,it,Li,rt,Pi,ct,Ki,pt,er,gt,nr,ut,tr,mt,sr,Qe,sa,ar,Bl,Uu="Answer questions on document images.",lr,ht,or,Se,aa,ir,Ql,$u="Generate embeddings for a given text.",rr,dt,cr,Ve,la,pr,Sl,ku="Fill in a hole with a missing word (token to be precise).",gr,ft,ur,K,oa,mr,Vl,vu="Get information about the deployed endpoint.",hr,Yl,qu=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,dr,yt,fr,ee,ia,yr,zl,Au="Get the status of a model hosted on the Inference API.",br,bt,Mr,Mt,jr,ne,ra,_r,Rl,Eu="Check the health of the deployed endpoint.",Tr,Xl,Nu=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Ir,jt,Jr,Ye,ca,wr,Fl,Zu="Perform image classification on the given image using the specified model.",xr,_t,Cr,te,pa,Ur,Dl,Wu="Perform image segmentation on the given image using the specified model.",$r,Tt,kr,It,vr,se,ga,qr,Ol,Gu="Perform image-to-image translation using a specified model.",Ar,Jt,Er,wt,Nr,ae,ua,Zr,Hl,Bu="Takes an input image and return text.",Wr,Ll,Qu=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,Gr,xt,Br,B,ma,Qr,Pl,Su="List models deployed on the Serverless Inference API service.",Sr,Kl,Vu=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Vr,Ct,Yr,Ut,zr,$t,Rr,le,ha,Xr,eo,Yu="Perform object detection on the given image using the specified model.",Fr,kt,Dr,vt,Or,qt,da,Hr,no,zu="Make a POST request to the inference server.",Lr,ze,fa,Pr,to,Ru="Retrieve the answer to a question from a given text.",Kr,At,ec,Re,ya,nc,so,Xu="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",tc,Et,sc,Xe,ba,ac,ao,Fu="Generate a summary of a given text using a specified model.",lc,Nt,oc,Fe,Ma,ic,lo,Du="Retrieve the answer to a question from information given in a table.",rc,Zt,cc,De,ja,pc,oo,Ou="Classifying a target category (a group) based on a set of attributes.",gc,Wt,uc,Oe,_a,mc,io,Hu="Predicting a numerical target value given a set of attributes/features in a table.",hc,Gt,dc,He,Ta,fc,ro,Lu="Perform text classification (e.g. sentiment-analysis) on the given text.",yc,Bt,bc,Q,Ia,Mc,co,Pu="Given a prompt, generate the following text.",jc,po,Ku=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,_c,go,em='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Tc,Qt,Ic,St,Jc,oe,Ja,wc,uo,nm="Generate an image based on a given text using a specified model.",xc,Vt,Cc,Yt,Uc,Le,wa,$c,mo,tm="Synthesize an audio of a voice pronouncing a given text.",kc,zt,vc,Pe,xa,qc,ho,sm=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Ac,Rt,Ec,D,Ca,Nc,fo,am="Convert text from one language to another.",Zc,yo,lm=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Wc,Xt,Gc,Ft,Bc,Ke,Ua,Qc,bo,om="Answering open-ended questions based on an image.",Sc,Dt,Vc,ie,$a,Yc,Mo,im="Provide as input a text and a set of candidate labels to classify the input text.",zc,Ot,Rc,Ht,Xc,en,ka,Fc,jo,rm="Provide input image and text labels to predict text labels for the image.",Dc,Lt,_i,va,Ti,qa,cm=`비동기 버전의 클라이언트도 제공되며, 이는 <code>asyncio</code>와 <code>aiohttp</code>를 기반으로 작동합니다.
이를 사용하려면 <code>aiohttp</code>를 직접 설치하거나 <code>[inference]</code> 추가 기능을 사용할 수 있습니다:`,Ii,Aa,Ji,x,Ea,Oc,_o,pm="Initialize a new Inference Client.",Hc,To,gm=`<a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,Lc,nn,Na,Pc,Io,um="Perform audio classification on the provided audio content.",Kc,Pt,ep,tn,Za,np,Jo,mm="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",tp,Kt,sp,sn,Wa,ap,wo,hm="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",lp,es,op,N,Ga,ip,xo,dm="A method for completing conversations using a specified language model.",rp,ns,cp,ts,pp,ss,gp,as,up,ls,mp,os,hp,is,dp,re,Ba,fp,Co,fm="Close all open sessions.",yp,Uo,ym=`By default, ‘aiohttp.ClientSession’ objects are closed automatically when a call is completed. However, if you
are streaming data from the server and you stop before the stream is complete, you must call this method to
close the session properly.`,bp,$o,bm="Another possibility is to use an async context (e.g. <code>async with AsyncInferenceClient(): ...</code>).",Mp,an,Qa,jp,ko,Mm="Answer questions on document images.",_p,rs,Tp,ln,Sa,Ip,vo,jm="Generate embeddings for a given text.",Jp,cs,wp,on,Va,xp,qo,_m="Fill in a hole with a missing word (token to be precise).",Cp,ps,Up,ce,Ya,$p,Ao,Tm="Get information about the deployed endpoint.",kp,Eo,Im=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,vp,gs,qp,pe,za,Ap,No,Jm="Get the status of a model hosted on the Inference API.",Ep,us,Np,ms,Zp,ge,Ra,Wp,Zo,wm="Check the health of the deployed endpoint.",Gp,Wo,xm=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Bp,hs,Qp,rn,Xa,Sp,Go,Cm="Perform image classification on the given image using the specified model.",Vp,ds,Yp,ue,Fa,zp,Bo,Um="Perform image segmentation on the given image using the specified model.",Rp,fs,Xp,ys,Fp,me,Da,Dp,Qo,$m="Perform image-to-image translation using a specified model.",Op,bs,Hp,Ms,Lp,he,Oa,Pp,So,km="Takes an input image and return text.",Kp,Vo,vm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,eg,js,ng,S,Ha,tg,Yo,qm="List models deployed on the Serverless Inference API service.",sg,zo,Am=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,ag,_s,lg,Ts,og,Is,ig,de,La,rg,Ro,Em="Perform object detection on the given image using the specified model.",cg,Js,pg,ws,gg,xs,Pa,ug,Xo,Nm="Make a POST request to the inference server.",mg,cn,Ka,hg,Fo,Zm="Retrieve the answer to a question from a given text.",dg,Cs,fg,pn,el,yg,Do,Wm="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",bg,Us,Mg,gn,nl,jg,Oo,Gm="Generate a summary of a given text using a specified model.",_g,$s,Tg,un,tl,Ig,Ho,Bm="Retrieve the answer to a question from information given in a table.",Jg,ks,wg,mn,sl,xg,Lo,Qm="Classifying a target category (a group) based on a set of attributes.",Cg,vs,Ug,hn,al,$g,Po,Sm="Predicting a numerical target value given a set of attributes/features in a table.",kg,qs,vg,dn,ll,qg,Ko,Vm="Perform text classification (e.g. sentiment-analysis) on the given text.",Ag,As,Eg,V,ol,Ng,ei,Ym="Given a prompt, generate the following text.",Zg,ni,zm=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Wg,ti,Rm='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Gg,Es,Bg,Ns,Qg,fe,il,Sg,si,Xm="Generate an image based on a given text using a specified model.",Vg,Zs,Yg,Ws,zg,fn,rl,Rg,ai,Fm="Synthesize an audio of a voice pronouncing a given text.",Xg,Gs,Fg,yn,cl,Dg,li,Dm=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Og,Bs,Hg,O,pl,Lg,oi,Om="Convert text from one language to another.",Pg,ii,Hm=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Kg,Qs,eu,Ss,nu,bn,gl,tu,ri,Lm="Answering open-ended questions based on an image.",su,Vs,au,ye,ul,lu,ci,Pm="Provide as input a text and a set of candidate labels to classify the input text.",ou,Ys,iu,zs,ru,Mn,ml,cu,pi,Km="Provide input image and text labels to predict text labels for the image.",pu,Rs,wi,hl,xi,jn,dl,gu,gi,eh="Error raised when a model is unavailable or the request times out.",Ci,fl,Ui,yl,nh="대부분의 작업에 대해, 반환 값은 내장된 유형(string, list, image…)을 갖습니다. 보다 복잡한 유형을 위한 목록은 다음과 같습니다.",$i,bl,ki,_n,Ml,uu,ui,th="This Dataclass represents the model status in the Hugging Face Inference API.",vi,jl,qi,_l,sh='<code>InferenceAPI</code>는 추론 API를 호출하는 레거시 방식입니다. 이 인터페이스는 더 간단하며 각 작업의 입력 매개변수와 출력 형식을 알아야 합니다. 또한 추론 엔드포인트나 AWS SageMaker와 같은 다른 서비스에 연결할 수 있는 기능이 없습니다. <code>InferenceAPI</code>는 곧 폐지될 예정이므로 가능한 경우 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>를 사용하는 것을 권장합니다. 스크립트에서 <code>InferenceAPI</code>를 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>로 전환하는 방법에 대해 알아보려면 <a href="../guides/inference#legacy-inferenceapi-client">이 가이드</a>를 참조하세요.',Ai,Y,Tl,mu,mi,ah="Client to configure requests and make calls to the HuggingFace Inference API.",hu,Xs,du,Fs,Il,fu,hi,lh="Inits headers and API call information.",yu,Ds,Jl,bu,di,oh="Make a call to the Inference API.",Ei,wl,Ni,fi,Zi;return o=new ql({props:{title:"추론",local:"inference",headingTag:"h1"}}),Ls=new ql({props:{title:"추론 클라이언트",local:"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient",headingTag:"h2"}}),Ps=new A({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the provider to use for inference. Can be <code>&quot;replicate&quot;</code>, <code>&quot;together&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;sambanova&quot;</code> or <code>&quot;hf-inference&quot;</code>.
defaults to hf-inference (Hugging Face Serverless Inference API).
If model is a URL or <code>base_url</code> is passed, then <code>provider</code> is not used.`,name:"provider"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.InferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.InferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.InferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L120"}}),Ks=new A({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L357",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),at=new C({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[Zh]},$$scope:{ctx:T}}}),ea=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L414",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),lt=new C({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[Wh]},$$scope:{ctx:T}}}),na=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.parameters",description:`<strong>parameters</strong> (Dict[str, Any], <em>optional</em>) &#x2014;
Additional parameters to pass to the model.`,name:"parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L459",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ot=new C({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[Gh]},$$scope:{ctx:T}}}),ta=new A({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Dict]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputGrammarType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
UNUSED. Currently not implemented in text-generation-inference (TGI). Kept as a parameter for OpenAI compatibility.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED. Currently not implemented in text-generation-inference (TGI). Kept as a parameter for OpenAI compatibility.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L576",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),it=new G({props:{$$slots:{default:[Bh]},$$scope:{ctx:T}}}),rt=new C({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[Qh]},$$scope:{ctx:T}}}),ct=new C({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-2",$$slots:{default:[Sh]},$$scope:{ctx:T}}}),pt=new C({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-3",$$slots:{default:[Vh]},$$scope:{ctx:T}}}),gt=new C({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-4",$$slots:{default:[Yh]},$$scope:{ctx:T}}}),ut=new C({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-5",$$slots:{default:[zh]},$$scope:{ctx:T}}}),mt=new C({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-6",$$slots:{default:[Rh]},$$scope:{ctx:T}}}),sa=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L958",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ht=new C({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Xh]},$$scope:{ctx:T}}}),aa=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1041",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),dt=new C({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[Fh]},$$scope:{ctx:T}}}),la=new A({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.InferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1111",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ft=new C({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[Dh]},$$scope:{ctx:T}}}),oa=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3081",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),yt=new C({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[Oh]},$$scope:{ctx:T}}}),ia=new A({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3170",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),bt=new G({props:{$$slots:{default:[Hh]},$$scope:{ctx:T}}}),Mt=new C({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[Lh]},$$scope:{ctx:T}}}),ra=new A({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3136",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),jt=new C({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[Ph]},$$scope:{ctx:T}}}),ca=new A({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.InferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1167",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),_t=new C({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[Kh]},$$scope:{ctx:T}}}),pa=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1217",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Tt=new G({props:{warning:!0,$$slots:{default:[ed]},$$scope:{ctx:T}}}),It=new C({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[nd]},$$scope:{ctx:T}}}),ga=new A({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1284",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Jt=new G({props:{warning:!0,$$slots:{default:[td]},$$scope:{ctx:T}}}),wt=new C({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[sd]},$$scope:{ctx:T}}}),ua=new A({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1357",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),xt=new C({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[ad]},$$scope:{ctx:T}}}),ma=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": typing.Union[NoneType, str, typing.Literal['all'], typing.List[str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1396",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Ct=new G({props:{warning:!0,$$slots:{default:[ld]},$$scope:{ctx:T}}}),Ut=new G({props:{$$slots:{default:[od]},$$scope:{ctx:T}}}),$t=new C({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[id]},$$scope:{ctx:T}}}),ha=new A({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1479",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),kt=new G({props:{warning:!0,$$slots:{default:[rd]},$$scope:{ctx:T}}}),vt=new C({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[cd]},$$scope:{ctx:T}}}),da=new A({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": typing.Union[str, typing.Dict, typing.List, NoneType] = None"},{name:"data",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, NoneType] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"task",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.InferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.InferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. if you are passing a provider, <code>task</code> is required.
Verify which tasks are supported by the provider.For <code>hf-inference</code>, all available tasks
can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"},{anchor:"huggingface_hub.InferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L255",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),fa=new A({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.InferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1529",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),At=new C({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[pd]},$$scope:{ctx:T}}}),ya=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1611",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new C({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[gd]},$$scope:{ctx:T}}}),ba=new A({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1660",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new C({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[ud]},$$scope:{ctx:T}}}),Ma=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Zt=new C({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[md]},$$scope:{ctx:T}}}),ja=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1798",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Wt=new C({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[hd]},$$scope:{ctx:T}}}),_a=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1849",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Gt=new C({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[dd]},$$scope:{ctx:T}}}),Ta=new A({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Bt=new C({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[fd]},$$scope:{ctx:T}}}),Ia=new A({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = False"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2100",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new G({props:{$$slots:{default:[yd]},$$scope:{ctx:T}}}),St=new C({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[bd]},$$scope:{ctx:T}}}),Ja=new A({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"height",val:": typing.Optional[float] = None"},{name:"width",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.text_to_image.TextToImageTargetSize] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.InferenceClient.text_to_image.target_size",description:`<strong>target_size</strong> (<code>TextToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image`,name:"target_size"},{anchor:"huggingface_hub.InferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Vt=new G({props:{warning:!0,$$slots:{default:[Md]},$$scope:{ctx:T}}}),Yt=new C({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[jd]},$$scope:{ctx:T}}}),wa=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),zt=new C({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[_d]},$$scope:{ctx:T}}}),xa=new A({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.InferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.InferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2668",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Rt=new C({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[Td]},$$scope:{ctx:T}}}),Ca=new A({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.InferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.InferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2740",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Xt=new C({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[Id]},$$scope:{ctx:T}}}),Ft=new C({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[Jd]},$$scope:{ctx:T}}}),Ua=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2825",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),Dt=new C({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[wd]},$$scope:{ctx:T}}}),$a=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2879",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ot=new C({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[xd]},$$scope:{ctx:T}}}),Ht=new C({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[Cd]},$$scope:{ctx:T}}}),ka=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2999",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Lt=new C({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[Ud]},$$scope:{ctx:T}}}),va=new ql({props:{title:"비동기 추론 클라이언트",local:"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),Aa=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUwQSUyMyUyMHBpcCUyMGluc3RhbGwlMjBhaW9odHRw",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># 또는</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Ea=new A({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"trust_env",val:": bool = False"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the provider to use for inference. Can be <code>&quot;replicate&quot;</code>, <code>&quot;together&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;sambanova&quot;</code> or <code>&quot;hf-inference&quot;</code>.
defaults to hf-inference (Hugging Face Serverless Inference API).
If model is a URL or <code>base_url</code> is passed, then <code>provider</code> is not used.`,name:"provider"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.AsyncInferenceClient.trust_env",description:`<strong>trust_env</strong> (&#x2018;bool&#x2019;, &#x2018;optional&#x2019;) &#x2014;
Trust environment settings for proxy configuration if the parameter is <code>True</code> (<code>False</code> by default).`,name:"trust_env"},{anchor:"huggingface_hub.AsyncInferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.AsyncInferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.AsyncInferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L109"}}),Na=new A({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Pt=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[$d]},$$scope:{ctx:T}}}),Za=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Kt=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[kd]},$$scope:{ctx:T}}}),Wa=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.parameters",description:`<strong>parameters</strong> (Dict[str, Any], <em>optional</em>) &#x2014;
Additional parameters to pass to the model.`,name:"parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L494",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),es=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[vd]},$$scope:{ctx:T}}}),Ga=new A({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Dict]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputGrammarType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
UNUSED. Currently not implemented in text-generation-inference (TGI). Kept as a parameter for OpenAI compatibility.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED. Currently not implemented in text-generation-inference (TGI). Kept as a parameter for OpenAI compatibility.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ns=new G({props:{$$slots:{default:[qd]},$$scope:{ctx:T}}}),ts=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[Ad]},$$scope:{ctx:T}}}),ss=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-2",$$slots:{default:[Ed]},$$scope:{ctx:T}}}),as=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-3",$$slots:{default:[Nd]},$$scope:{ctx:T}}}),ls=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-4",$$slots:{default:[Zd]},$$scope:{ctx:T}}}),os=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-5",$$slots:{default:[Wd]},$$scope:{ctx:T}}}),is=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-6",$$slots:{default:[Gd]},$$scope:{ctx:T}}}),Ba=new A({props:{name:"close",anchor:"huggingface_hub.AsyncInferenceClient.close",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L379"}}),Qa=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1000",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),rs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[Bd]},$$scope:{ctx:T}}}),Sa=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1084",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),cs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[Qd]},$$scope:{ctx:T}}}),Va=new A({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1155",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ps=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[Sd]},$$scope:{ctx:T}}}),Ya=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3194",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),gs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[Vd]},$$scope:{ctx:T}}}),za=new A({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3287",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),us=new G({props:{$$slots:{default:[Yd]},$$scope:{ctx:T}}}),ms=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[zd]},$$scope:{ctx:T}}}),Ra=new A({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3251",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),hs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[Rd]},$$scope:{ctx:T}}}),Xa=new A({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ds=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[Xd]},$$scope:{ctx:T}}}),Fa=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),fs=new G({props:{warning:!0,$$slots:{default:[Fd]},$$scope:{ctx:T}}}),ys=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[Dd]},$$scope:{ctx:T}}}),Da=new A({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1331",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),bs=new G({props:{warning:!0,$$slots:{default:[Od]},$$scope:{ctx:T}}}),Ms=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[Hd]},$$scope:{ctx:T}}}),Oa=new A({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1405",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),js=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[Ld]},$$scope:{ctx:T}}}),Ha=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": typing.Union[NoneType, str, typing.Literal['all'], typing.List[str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1445",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),_s=new G({props:{warning:!0,$$slots:{default:[Pd]},$$scope:{ctx:T}}}),Ts=new G({props:{$$slots:{default:[Kd]},$$scope:{ctx:T}}}),Is=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[ef]},$$scope:{ctx:T}}}),La=new A({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1534",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Js=new G({props:{warning:!0,$$slots:{default:[nf]},$$scope:{ctx:T}}}),ws=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[tf]},$$scope:{ctx:T}}}),Pa=new A({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": typing.Union[str, typing.Dict, typing.List, NoneType] = None"},{name:"data",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, NoneType] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"task",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.AsyncInferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.AsyncInferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. if you are passing a provider, <code>task</code> is required.
Verify which tasks are supported by the provider.For <code>hf-inference</code>, all available tasks
can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"},{anchor:"huggingface_hub.AsyncInferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L251",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ka=new A({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1585",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Cs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[sf]},$$scope:{ctx:T}}}),el=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1668",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Us=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[af]},$$scope:{ctx:T}}}),nl=new A({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1718",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[lf]},$$scope:{ctx:T}}}),tl=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ks=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[of]},$$scope:{ctx:T}}}),sl=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),vs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[rf]},$$scope:{ctx:T}}}),al=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1910",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),qs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[cf]},$$scope:{ctx:T}}}),ll=new A({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1953",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),As=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[pf]},$$scope:{ctx:T}}}),ol=new A({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = False"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2163",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Es=new G({props:{$$slots:{default:[gf]},$$scope:{ctx:T}}}),Ns=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[uf]},$$scope:{ctx:T}}}),il=new A({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"height",val:": typing.Optional[float] = None"},{name:"width",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.text_to_image.TextToImageTargetSize] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.target_size",description:`<strong>target_size</strong> (<code>TextToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image`,name:"target_size"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Zs=new G({props:{warning:!0,$$slots:{default:[mf]},$$scope:{ctx:T}}}),Ws=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[hf]},$$scope:{ctx:T}}}),rl=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2609",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[df]},$$scope:{ctx:T}}}),cl=new A({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2734",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[ff]},$$scope:{ctx:T}}}),pl=new A({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2807",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Qs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[yf]},$$scope:{ctx:T}}}),Ss=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[bf]},$$scope:{ctx:T}}}),gl=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2893",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Vs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[Mf]},$$scope:{ctx:T}}}),ul=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2948",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ys=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[jf]},$$scope:{ctx:T}}}),zs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[_f]},$$scope:{ctx:T}}}),ml=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3070",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Rs=new C({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[Tf]},$$scope:{ctx:T}}}),hl=new ql({props:{title:"추론 시간 초과 오류",local:"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),dl=new A({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L92"}}),fl=new ql({props:{title:"반환 유형",local:"return-types",headingTag:"h2"}}),bl=new ql({props:{title:"모델 상태",local:"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),Ml=new A({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": typing.Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_common.py#L78"}}),jl=new ql({props:{title:"추론 API",local:"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi",headingTag:"h2"}}),Tl=new A({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L46"}}),Xs=new C({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[If]},$$scope:{ctx:T}}}),Il=new A({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L93"}}),Jl=new A({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.Dict, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"params",val:": typing.Optional[typing.Dict] = None"},{name:"data",val:": typing.Optional[bytes] = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L158"}}),wl=new Nh({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/inference_client.md"}}),{c(){n=u("meta"),p=i(),a=u("p"),t=i(),h(o.$$.fragment),e=i(),c=u("p"),c.innerHTML=Mu,yi=i(),Os=u("ul"),Os.innerHTML=ju,bi=i(),Hs=u("p"),Hs.innerHTML=_u,Mi=i(),h(Ls.$$.fragment),ji=i(),U=u("div"),h(Ps.$$.fragment),Wi=i(),Al=u("p"),Al.textContent=Tu,Gi=i(),El=u("p"),El.innerHTML=Iu,Bi=i(),We=u("div"),h(Ks.$$.fragment),Qi=i(),Nl=u("p"),Nl.textContent=Ju,Si=i(),h(at.$$.fragment),Vi=i(),Ge=u("div"),h(ea.$$.fragment),Yi=i(),Zl=u("p"),Zl.textContent=wu,zi=i(),h(lt.$$.fragment),Ri=i(),Be=u("div"),h(na.$$.fragment),Xi=i(),Wl=u("p"),Wl.textContent=xu,Fi=i(),h(ot.$$.fragment),Di=i(),E=u("div"),h(ta.$$.fragment),Oi=i(),Gl=u("p"),Gl.textContent=Cu,Hi=i(),h(it.$$.fragment),Li=i(),h(rt.$$.fragment),Pi=i(),h(ct.$$.fragment),Ki=i(),h(pt.$$.fragment),er=i(),h(gt.$$.fragment),nr=i(),h(ut.$$.fragment),tr=i(),h(mt.$$.fragment),sr=i(),Qe=u("div"),h(sa.$$.fragment),ar=i(),Bl=u("p"),Bl.textContent=Uu,lr=i(),h(ht.$$.fragment),or=i(),Se=u("div"),h(aa.$$.fragment),ir=i(),Ql=u("p"),Ql.textContent=$u,rr=i(),h(dt.$$.fragment),cr=i(),Ve=u("div"),h(la.$$.fragment),pr=i(),Sl=u("p"),Sl.textContent=ku,gr=i(),h(ft.$$.fragment),ur=i(),K=u("div"),h(oa.$$.fragment),mr=i(),Vl=u("p"),Vl.textContent=vu,hr=i(),Yl=u("p"),Yl.innerHTML=qu,dr=i(),h(yt.$$.fragment),fr=i(),ee=u("div"),h(ia.$$.fragment),yr=i(),zl=u("p"),zl.textContent=Au,br=i(),h(bt.$$.fragment),Mr=i(),h(Mt.$$.fragment),jr=i(),ne=u("div"),h(ra.$$.fragment),_r=i(),Rl=u("p"),Rl.textContent=Eu,Tr=i(),Xl=u("p"),Xl.innerHTML=Nu,Ir=i(),h(jt.$$.fragment),Jr=i(),Ye=u("div"),h(ca.$$.fragment),wr=i(),Fl=u("p"),Fl.textContent=Zu,xr=i(),h(_t.$$.fragment),Cr=i(),te=u("div"),h(pa.$$.fragment),Ur=i(),Dl=u("p"),Dl.textContent=Wu,$r=i(),h(Tt.$$.fragment),kr=i(),h(It.$$.fragment),vr=i(),se=u("div"),h(ga.$$.fragment),qr=i(),Ol=u("p"),Ol.textContent=Gu,Ar=i(),h(Jt.$$.fragment),Er=i(),h(wt.$$.fragment),Nr=i(),ae=u("div"),h(ua.$$.fragment),Zr=i(),Hl=u("p"),Hl.textContent=Bu,Wr=i(),Ll=u("p"),Ll.textContent=Qu,Gr=i(),h(xt.$$.fragment),Br=i(),B=u("div"),h(ma.$$.fragment),Qr=i(),Pl=u("p"),Pl.textContent=Su,Sr=i(),Kl=u("p"),Kl.innerHTML=Vu,Vr=i(),h(Ct.$$.fragment),Yr=i(),h(Ut.$$.fragment),zr=i(),h($t.$$.fragment),Rr=i(),le=u("div"),h(ha.$$.fragment),Xr=i(),eo=u("p"),eo.textContent=Yu,Fr=i(),h(kt.$$.fragment),Dr=i(),h(vt.$$.fragment),Or=i(),qt=u("div"),h(da.$$.fragment),Hr=i(),no=u("p"),no.textContent=zu,Lr=i(),ze=u("div"),h(fa.$$.fragment),Pr=i(),to=u("p"),to.textContent=Ru,Kr=i(),h(At.$$.fragment),ec=i(),Re=u("div"),h(ya.$$.fragment),nc=i(),so=u("p"),so.textContent=Xu,tc=i(),h(Et.$$.fragment),sc=i(),Xe=u("div"),h(ba.$$.fragment),ac=i(),ao=u("p"),ao.textContent=Fu,lc=i(),h(Nt.$$.fragment),oc=i(),Fe=u("div"),h(Ma.$$.fragment),ic=i(),lo=u("p"),lo.textContent=Du,rc=i(),h(Zt.$$.fragment),cc=i(),De=u("div"),h(ja.$$.fragment),pc=i(),oo=u("p"),oo.textContent=Ou,gc=i(),h(Wt.$$.fragment),uc=i(),Oe=u("div"),h(_a.$$.fragment),mc=i(),io=u("p"),io.textContent=Hu,hc=i(),h(Gt.$$.fragment),dc=i(),He=u("div"),h(Ta.$$.fragment),fc=i(),ro=u("p"),ro.textContent=Lu,yc=i(),h(Bt.$$.fragment),bc=i(),Q=u("div"),h(Ia.$$.fragment),Mc=i(),co=u("p"),co.textContent=Pu,jc=i(),po=u("p"),po.innerHTML=Ku,_c=i(),go=u("p"),go.innerHTML=em,Tc=i(),h(Qt.$$.fragment),Ic=i(),h(St.$$.fragment),Jc=i(),oe=u("div"),h(Ja.$$.fragment),wc=i(),uo=u("p"),uo.textContent=nm,xc=i(),h(Vt.$$.fragment),Cc=i(),h(Yt.$$.fragment),Uc=i(),Le=u("div"),h(wa.$$.fragment),$c=i(),mo=u("p"),mo.textContent=tm,kc=i(),h(zt.$$.fragment),vc=i(),Pe=u("div"),h(xa.$$.fragment),qc=i(),ho=u("p"),ho.textContent=sm,Ac=i(),h(Rt.$$.fragment),Ec=i(),D=u("div"),h(Ca.$$.fragment),Nc=i(),fo=u("p"),fo.textContent=am,Zc=i(),yo=u("p"),yo.innerHTML=lm,Wc=i(),h(Xt.$$.fragment),Gc=i(),h(Ft.$$.fragment),Bc=i(),Ke=u("div"),h(Ua.$$.fragment),Qc=i(),bo=u("p"),bo.textContent=om,Sc=i(),h(Dt.$$.fragment),Vc=i(),ie=u("div"),h($a.$$.fragment),Yc=i(),Mo=u("p"),Mo.textContent=im,zc=i(),h(Ot.$$.fragment),Rc=i(),h(Ht.$$.fragment),Xc=i(),en=u("div"),h(ka.$$.fragment),Fc=i(),jo=u("p"),jo.textContent=rm,Dc=i(),h(Lt.$$.fragment),_i=i(),h(va.$$.fragment),Ti=i(),qa=u("p"),qa.innerHTML=cm,Ii=i(),h(Aa.$$.fragment),Ji=i(),x=u("div"),h(Ea.$$.fragment),Oc=i(),_o=u("p"),_o.textContent=pm,Hc=i(),To=u("p"),To.innerHTML=gm,Lc=i(),nn=u("div"),h(Na.$$.fragment),Pc=i(),Io=u("p"),Io.textContent=um,Kc=i(),h(Pt.$$.fragment),ep=i(),tn=u("div"),h(Za.$$.fragment),np=i(),Jo=u("p"),Jo.textContent=mm,tp=i(),h(Kt.$$.fragment),sp=i(),sn=u("div"),h(Wa.$$.fragment),ap=i(),wo=u("p"),wo.textContent=hm,lp=i(),h(es.$$.fragment),op=i(),N=u("div"),h(Ga.$$.fragment),ip=i(),xo=u("p"),xo.textContent=dm,rp=i(),h(ns.$$.fragment),cp=i(),h(ts.$$.fragment),pp=i(),h(ss.$$.fragment),gp=i(),h(as.$$.fragment),up=i(),h(ls.$$.fragment),mp=i(),h(os.$$.fragment),hp=i(),h(is.$$.fragment),dp=i(),re=u("div"),h(Ba.$$.fragment),fp=i(),Co=u("p"),Co.textContent=fm,yp=i(),Uo=u("p"),Uo.textContent=ym,bp=i(),$o=u("p"),$o.innerHTML=bm,Mp=i(),an=u("div"),h(Qa.$$.fragment),jp=i(),ko=u("p"),ko.textContent=Mm,_p=i(),h(rs.$$.fragment),Tp=i(),ln=u("div"),h(Sa.$$.fragment),Ip=i(),vo=u("p"),vo.textContent=jm,Jp=i(),h(cs.$$.fragment),wp=i(),on=u("div"),h(Va.$$.fragment),xp=i(),qo=u("p"),qo.textContent=_m,Cp=i(),h(ps.$$.fragment),Up=i(),ce=u("div"),h(Ya.$$.fragment),$p=i(),Ao=u("p"),Ao.textContent=Tm,kp=i(),Eo=u("p"),Eo.innerHTML=Im,vp=i(),h(gs.$$.fragment),qp=i(),pe=u("div"),h(za.$$.fragment),Ap=i(),No=u("p"),No.textContent=Jm,Ep=i(),h(us.$$.fragment),Np=i(),h(ms.$$.fragment),Zp=i(),ge=u("div"),h(Ra.$$.fragment),Wp=i(),Zo=u("p"),Zo.textContent=wm,Gp=i(),Wo=u("p"),Wo.innerHTML=xm,Bp=i(),h(hs.$$.fragment),Qp=i(),rn=u("div"),h(Xa.$$.fragment),Sp=i(),Go=u("p"),Go.textContent=Cm,Vp=i(),h(ds.$$.fragment),Yp=i(),ue=u("div"),h(Fa.$$.fragment),zp=i(),Bo=u("p"),Bo.textContent=Um,Rp=i(),h(fs.$$.fragment),Xp=i(),h(ys.$$.fragment),Fp=i(),me=u("div"),h(Da.$$.fragment),Dp=i(),Qo=u("p"),Qo.textContent=$m,Op=i(),h(bs.$$.fragment),Hp=i(),h(Ms.$$.fragment),Lp=i(),he=u("div"),h(Oa.$$.fragment),Pp=i(),So=u("p"),So.textContent=km,Kp=i(),Vo=u("p"),Vo.textContent=vm,eg=i(),h(js.$$.fragment),ng=i(),S=u("div"),h(Ha.$$.fragment),tg=i(),Yo=u("p"),Yo.textContent=qm,sg=i(),zo=u("p"),zo.innerHTML=Am,ag=i(),h(_s.$$.fragment),lg=i(),h(Ts.$$.fragment),og=i(),h(Is.$$.fragment),ig=i(),de=u("div"),h(La.$$.fragment),rg=i(),Ro=u("p"),Ro.textContent=Em,cg=i(),h(Js.$$.fragment),pg=i(),h(ws.$$.fragment),gg=i(),xs=u("div"),h(Pa.$$.fragment),ug=i(),Xo=u("p"),Xo.textContent=Nm,mg=i(),cn=u("div"),h(Ka.$$.fragment),hg=i(),Fo=u("p"),Fo.textContent=Zm,dg=i(),h(Cs.$$.fragment),fg=i(),pn=u("div"),h(el.$$.fragment),yg=i(),Do=u("p"),Do.textContent=Wm,bg=i(),h(Us.$$.fragment),Mg=i(),gn=u("div"),h(nl.$$.fragment),jg=i(),Oo=u("p"),Oo.textContent=Gm,_g=i(),h($s.$$.fragment),Tg=i(),un=u("div"),h(tl.$$.fragment),Ig=i(),Ho=u("p"),Ho.textContent=Bm,Jg=i(),h(ks.$$.fragment),wg=i(),mn=u("div"),h(sl.$$.fragment),xg=i(),Lo=u("p"),Lo.textContent=Qm,Cg=i(),h(vs.$$.fragment),Ug=i(),hn=u("div"),h(al.$$.fragment),$g=i(),Po=u("p"),Po.textContent=Sm,kg=i(),h(qs.$$.fragment),vg=i(),dn=u("div"),h(ll.$$.fragment),qg=i(),Ko=u("p"),Ko.textContent=Vm,Ag=i(),h(As.$$.fragment),Eg=i(),V=u("div"),h(ol.$$.fragment),Ng=i(),ei=u("p"),ei.textContent=Ym,Zg=i(),ni=u("p"),ni.innerHTML=zm,Wg=i(),ti=u("p"),ti.innerHTML=Rm,Gg=i(),h(Es.$$.fragment),Bg=i(),h(Ns.$$.fragment),Qg=i(),fe=u("div"),h(il.$$.fragment),Sg=i(),si=u("p"),si.textContent=Xm,Vg=i(),h(Zs.$$.fragment),Yg=i(),h(Ws.$$.fragment),zg=i(),fn=u("div"),h(rl.$$.fragment),Rg=i(),ai=u("p"),ai.textContent=Fm,Xg=i(),h(Gs.$$.fragment),Fg=i(),yn=u("div"),h(cl.$$.fragment),Dg=i(),li=u("p"),li.textContent=Dm,Og=i(),h(Bs.$$.fragment),Hg=i(),O=u("div"),h(pl.$$.fragment),Lg=i(),oi=u("p"),oi.textContent=Om,Pg=i(),ii=u("p"),ii.innerHTML=Hm,Kg=i(),h(Qs.$$.fragment),eu=i(),h(Ss.$$.fragment),nu=i(),bn=u("div"),h(gl.$$.fragment),tu=i(),ri=u("p"),ri.textContent=Lm,su=i(),h(Vs.$$.fragment),au=i(),ye=u("div"),h(ul.$$.fragment),lu=i(),ci=u("p"),ci.textContent=Pm,ou=i(),h(Ys.$$.fragment),iu=i(),h(zs.$$.fragment),ru=i(),Mn=u("div"),h(ml.$$.fragment),cu=i(),pi=u("p"),pi.textContent=Km,pu=i(),h(Rs.$$.fragment),wi=i(),h(hl.$$.fragment),xi=i(),jn=u("div"),h(dl.$$.fragment),gu=i(),gi=u("p"),gi.textContent=eh,Ci=i(),h(fl.$$.fragment),Ui=i(),yl=u("p"),yl.textContent=nh,$i=i(),h(bl.$$.fragment),ki=i(),_n=u("div"),h(Ml.$$.fragment),uu=i(),ui=u("p"),ui.textContent=th,vi=i(),h(jl.$$.fragment),qi=i(),_l=u("p"),_l.innerHTML=sh,Ai=i(),Y=u("div"),h(Tl.$$.fragment),mu=i(),mi=u("p"),mi.textContent=ah,hu=i(),h(Xs.$$.fragment),du=i(),Fs=u("div"),h(Il.$$.fragment),fu=i(),hi=u("p"),hi.textContent=lh,yu=i(),Ds=u("div"),h(Jl.$$.fragment),bu=i(),di=u("p"),di.textContent=oh,Ei=i(),h(wl.$$.fragment),Ni=i(),fi=u("p"),this.h()},l(s){const j=Eh("svelte-u9bgzb",document.head);n=m(j,"META",{name:!0,content:!0}),j.forEach(g),p=r(s),a=m(s,"P",{}),k(a).forEach(g),t=r(s),d(o.$$.fragment,s),e=r(s),c=m(s,"P",{"data-svelte-h":!0}),I(c)!=="svelte-10zkjtm"&&(c.innerHTML=Mu),yi=r(s),Os=m(s,"UL",{"data-svelte-h":!0}),I(Os)!=="svelte-5iysbw"&&(Os.innerHTML=ju),bi=r(s),Hs=m(s,"P",{"data-svelte-h":!0}),I(Hs)!=="svelte-1bl7dx4"&&(Hs.innerHTML=_u),Mi=r(s),d(Ls.$$.fragment,s),ji=r(s),U=m(s,"DIV",{class:!0});var q=k(U);d(Ps.$$.fragment,q),Wi=r(q),Al=m(q,"P",{"data-svelte-h":!0}),I(Al)!=="svelte-1p4u01l"&&(Al.textContent=Tu),Gi=r(q),El=m(q,"P",{"data-svelte-h":!0}),I(El)!=="svelte-kbf9lm"&&(El.innerHTML=Iu),Bi=r(q),We=m(q,"DIV",{class:!0});var Tn=k(We);d(Ks.$$.fragment,Tn),Qi=r(Tn),Nl=m(Tn,"P",{"data-svelte-h":!0}),I(Nl)!=="svelte-1hs5qib"&&(Nl.textContent=Ju),Si=r(Tn),d(at.$$.fragment,Tn),Tn.forEach(g),Vi=r(q),Ge=m(q,"DIV",{class:!0});var In=k(Ge);d(ea.$$.fragment,In),Yi=r(In),Zl=m(In,"P",{"data-svelte-h":!0}),I(Zl)!=="svelte-z9e742"&&(Zl.textContent=wu),zi=r(In),d(lt.$$.fragment,In),In.forEach(g),Ri=r(q),Be=m(q,"DIV",{class:!0});var Jn=k(Be);d(na.$$.fragment,Jn),Xi=r(Jn),Wl=m(Jn,"P",{"data-svelte-h":!0}),I(Wl)!=="svelte-lahnll"&&(Wl.textContent=xu),Fi=r(Jn),d(ot.$$.fragment,Jn),Jn.forEach(g),Di=r(q),E=m(q,"DIV",{class:!0});var Z=k(E);d(ta.$$.fragment,Z),Oi=r(Z),Gl=m(Z,"P",{"data-svelte-h":!0}),I(Gl)!=="svelte-5o70yf"&&(Gl.textContent=Cu),Hi=r(Z),d(it.$$.fragment,Z),Li=r(Z),d(rt.$$.fragment,Z),Pi=r(Z),d(ct.$$.fragment,Z),Ki=r(Z),d(pt.$$.fragment,Z),er=r(Z),d(gt.$$.fragment,Z),nr=r(Z),d(ut.$$.fragment,Z),tr=r(Z),d(mt.$$.fragment,Z),Z.forEach(g),sr=r(q),Qe=m(q,"DIV",{class:!0});var wn=k(Qe);d(sa.$$.fragment,wn),ar=r(wn),Bl=m(wn,"P",{"data-svelte-h":!0}),I(Bl)!=="svelte-qs8cmr"&&(Bl.textContent=Uu),lr=r(wn),d(ht.$$.fragment,wn),wn.forEach(g),or=r(q),Se=m(q,"DIV",{class:!0});var xn=k(Se);d(aa.$$.fragment,xn),ir=r(xn),Ql=m(xn,"P",{"data-svelte-h":!0}),I(Ql)!=="svelte-1axtrg9"&&(Ql.textContent=$u),rr=r(xn),d(dt.$$.fragment,xn),xn.forEach(g),cr=r(q),Ve=m(q,"DIV",{class:!0});var Cn=k(Ve);d(la.$$.fragment,Cn),pr=r(Cn),Sl=m(Cn,"P",{"data-svelte-h":!0}),I(Sl)!=="svelte-1lnjtsz"&&(Sl.textContent=ku),gr=r(Cn),d(ft.$$.fragment,Cn),Cn.forEach(g),ur=r(q),K=m(q,"DIV",{class:!0});var be=k(K);d(oa.$$.fragment,be),mr=r(be),Vl=m(be,"P",{"data-svelte-h":!0}),I(Vl)!=="svelte-s2la9t"&&(Vl.textContent=vu),hr=r(be),Yl=m(be,"P",{"data-svelte-h":!0}),I(Yl)!=="svelte-1xhka28"&&(Yl.innerHTML=qu),dr=r(be),d(yt.$$.fragment,be),be.forEach(g),fr=r(q),ee=m(q,"DIV",{class:!0});var Me=k(ee);d(ia.$$.fragment,Me),yr=r(Me),zl=m(Me,"P",{"data-svelte-h":!0}),I(zl)!=="svelte-1htupoc"&&(zl.textContent=Au),br=r(Me),d(bt.$$.fragment,Me),Mr=r(Me),d(Mt.$$.fragment,Me),Me.forEach(g),jr=r(q),ne=m(q,"DIV",{class:!0});var je=k(ne);d(ra.$$.fragment,je),_r=r(je),Rl=m(je,"P",{"data-svelte-h":!0}),I(Rl)!=="svelte-1m9sgvu"&&(Rl.textContent=Eu),Tr=r(je),Xl=m(je,"P",{"data-svelte-h":!0}),I(Xl)!=="svelte-1xj24a2"&&(Xl.innerHTML=Nu),Ir=r(je),d(jt.$$.fragment,je),je.forEach(g),Jr=r(q),Ye=m(q,"DIV",{class:!0});var Un=k(Ye);d(ca.$$.fragment,Un),wr=r(Un),Fl=m(Un,"P",{"data-svelte-h":!0}),I(Fl)!=="svelte-u63854"&&(Fl.textContent=Zu),xr=r(Un),d(_t.$$.fragment,Un),Un.forEach(g),Cr=r(q),te=m(q,"DIV",{class:!0});var _e=k(te);d(pa.$$.fragment,_e),Ur=r(_e),Dl=m(_e,"P",{"data-svelte-h":!0}),I(Dl)!=="svelte-k6f11e"&&(Dl.textContent=Wu),$r=r(_e),d(Tt.$$.fragment,_e),kr=r(_e),d(It.$$.fragment,_e),_e.forEach(g),vr=r(q),se=m(q,"DIV",{class:!0});var Te=k(se);d(ga.$$.fragment,Te),qr=r(Te),Ol=m(Te,"P",{"data-svelte-h":!0}),I(Ol)!=="svelte-7cx5l1"&&(Ol.textContent=Gu),Ar=r(Te),d(Jt.$$.fragment,Te),Er=r(Te),d(wt.$$.fragment,Te),Te.forEach(g),Nr=r(q),ae=m(q,"DIV",{class:!0});var Ie=k(ae);d(ua.$$.fragment,Ie),Zr=r(Ie),Hl=m(Ie,"P",{"data-svelte-h":!0}),I(Hl)!=="svelte-1tnfouk"&&(Hl.textContent=Bu),Wr=r(Ie),Ll=m(Ie,"P",{"data-svelte-h":!0}),I(Ll)!=="svelte-qrqo93"&&(Ll.textContent=Qu),Gr=r(Ie),d(xt.$$.fragment,Ie),Ie.forEach(g),Br=r(q),B=m(q,"DIV",{class:!0});var z=k(B);d(ma.$$.fragment,z),Qr=r(z),Pl=m(z,"P",{"data-svelte-h":!0}),I(Pl)!=="svelte-71vo6e"&&(Pl.textContent=Su),Sr=r(z),Kl=m(z,"P",{"data-svelte-h":!0}),I(Kl)!=="svelte-1k36r1q"&&(Kl.innerHTML=Vu),Vr=r(z),d(Ct.$$.fragment,z),Yr=r(z),d(Ut.$$.fragment,z),zr=r(z),d($t.$$.fragment,z),z.forEach(g),Rr=r(q),le=m(q,"DIV",{class:!0});var Je=k(le);d(ha.$$.fragment,Je),Xr=r(Je),eo=m(Je,"P",{"data-svelte-h":!0}),I(eo)!=="svelte-fzfwfh"&&(eo.textContent=Yu),Fr=r(Je),d(kt.$$.fragment,Je),Dr=r(Je),d(vt.$$.fragment,Je),Je.forEach(g),Or=r(q),qt=m(q,"DIV",{class:!0});var xl=k(qt);d(da.$$.fragment,xl),Hr=r(xl),no=m(xl,"P",{"data-svelte-h":!0}),I(no)!=="svelte-14tnsya"&&(no.textContent=zu),xl.forEach(g),Lr=r(q),ze=m(q,"DIV",{class:!0});var $n=k(ze);d(fa.$$.fragment,$n),Pr=r($n),to=m($n,"P",{"data-svelte-h":!0}),I(to)!=="svelte-1mibg86"&&(to.textContent=Ru),Kr=r($n),d(At.$$.fragment,$n),$n.forEach(g),ec=r(q),Re=m(q,"DIV",{class:!0});var kn=k(Re);d(ya.$$.fragment,kn),nc=r(kn),so=m(kn,"P",{"data-svelte-h":!0}),I(so)!=="svelte-1nuhgbh"&&(so.textContent=Xu),tc=r(kn),d(Et.$$.fragment,kn),kn.forEach(g),sc=r(q),Xe=m(q,"DIV",{class:!0});var vn=k(Xe);d(ba.$$.fragment,vn),ac=r(vn),ao=m(vn,"P",{"data-svelte-h":!0}),I(ao)!=="svelte-1uepm2o"&&(ao.textContent=Fu),lc=r(vn),d(Nt.$$.fragment,vn),vn.forEach(g),oc=r(q),Fe=m(q,"DIV",{class:!0});var qn=k(Fe);d(Ma.$$.fragment,qn),ic=r(qn),lo=m(qn,"P",{"data-svelte-h":!0}),I(lo)!=="svelte-77a94i"&&(lo.textContent=Du),rc=r(qn),d(Zt.$$.fragment,qn),qn.forEach(g),cc=r(q),De=m(q,"DIV",{class:!0});var An=k(De);d(ja.$$.fragment,An),pc=r(An),oo=m(An,"P",{"data-svelte-h":!0}),I(oo)!=="svelte-61sxmo"&&(oo.textContent=Ou),gc=r(An),d(Wt.$$.fragment,An),An.forEach(g),uc=r(q),Oe=m(q,"DIV",{class:!0});var En=k(Oe);d(_a.$$.fragment,En),mc=r(En),io=m(En,"P",{"data-svelte-h":!0}),I(io)!=="svelte-hzldyu"&&(io.textContent=Hu),hc=r(En),d(Gt.$$.fragment,En),En.forEach(g),dc=r(q),He=m(q,"DIV",{class:!0});var Nn=k(He);d(Ta.$$.fragment,Nn),fc=r(Nn),ro=m(Nn,"P",{"data-svelte-h":!0}),I(ro)!=="svelte-b4yzyj"&&(ro.textContent=Lu),yc=r(Nn),d(Bt.$$.fragment,Nn),Nn.forEach(g),bc=r(q),Q=m(q,"DIV",{class:!0});var R=k(Q);d(Ia.$$.fragment,R),Mc=r(R),co=m(R,"P",{"data-svelte-h":!0}),I(co)!=="svelte-qakvx8"&&(co.textContent=Pu),jc=r(R),po=m(R,"P",{"data-svelte-h":!0}),I(po)!=="svelte-1irx2op"&&(po.innerHTML=Ku),_c=r(R),go=m(R,"P",{"data-svelte-h":!0}),I(go)!=="svelte-140zl9b"&&(go.innerHTML=em),Tc=r(R),d(Qt.$$.fragment,R),Ic=r(R),d(St.$$.fragment,R),R.forEach(g),Jc=r(q),oe=m(q,"DIV",{class:!0});var we=k(oe);d(Ja.$$.fragment,we),wc=r(we),uo=m(we,"P",{"data-svelte-h":!0}),I(uo)!=="svelte-9lmcnw"&&(uo.textContent=nm),xc=r(we),d(Vt.$$.fragment,we),Cc=r(we),d(Yt.$$.fragment,we),we.forEach(g),Uc=r(q),Le=m(q,"DIV",{class:!0});var Zn=k(Le);d(wa.$$.fragment,Zn),$c=r(Zn),mo=m(Zn,"P",{"data-svelte-h":!0}),I(mo)!=="svelte-12mjzdy"&&(mo.textContent=tm),kc=r(Zn),d(zt.$$.fragment,Zn),Zn.forEach(g),vc=r(q),Pe=m(q,"DIV",{class:!0});var Wn=k(Pe);d(xa.$$.fragment,Wn),qc=r(Wn),ho=m(Wn,"P",{"data-svelte-h":!0}),I(ho)!=="svelte-1araal"&&(ho.textContent=sm),Ac=r(Wn),d(Rt.$$.fragment,Wn),Wn.forEach(g),Ec=r(q),D=m(q,"DIV",{class:!0});var H=k(D);d(Ca.$$.fragment,H),Nc=r(H),fo=m(H,"P",{"data-svelte-h":!0}),I(fo)!=="svelte-1v3lqck"&&(fo.textContent=am),Zc=r(H),yo=m(H,"P",{"data-svelte-h":!0}),I(yo)!=="svelte-jwmjgr"&&(yo.innerHTML=lm),Wc=r(H),d(Xt.$$.fragment,H),Gc=r(H),d(Ft.$$.fragment,H),H.forEach(g),Bc=r(q),Ke=m(q,"DIV",{class:!0});var Gn=k(Ke);d(Ua.$$.fragment,Gn),Qc=r(Gn),bo=m(Gn,"P",{"data-svelte-h":!0}),I(bo)!=="svelte-1jbp6ey"&&(bo.textContent=om),Sc=r(Gn),d(Dt.$$.fragment,Gn),Gn.forEach(g),Vc=r(q),ie=m(q,"DIV",{class:!0});var xe=k(ie);d($a.$$.fragment,xe),Yc=r(xe),Mo=m(xe,"P",{"data-svelte-h":!0}),I(Mo)!=="svelte-1c9xuqj"&&(Mo.textContent=im),zc=r(xe),d(Ot.$$.fragment,xe),Rc=r(xe),d(Ht.$$.fragment,xe),xe.forEach(g),Xc=r(q),en=m(q,"DIV",{class:!0});var Bn=k(en);d(ka.$$.fragment,Bn),Fc=r(Bn),jo=m(Bn,"P",{"data-svelte-h":!0}),I(jo)!=="svelte-108ipf8"&&(jo.textContent=rm),Dc=r(Bn),d(Lt.$$.fragment,Bn),Bn.forEach(g),q.forEach(g),_i=r(s),d(va.$$.fragment,s),Ti=r(s),qa=m(s,"P",{"data-svelte-h":!0}),I(qa)!=="svelte-1vkrv9k"&&(qa.innerHTML=cm),Ii=r(s),d(Aa.$$.fragment,s),Ji=r(s),x=m(s,"DIV",{class:!0});var $=k(x);d(Ea.$$.fragment,$),Oc=r($),_o=m($,"P",{"data-svelte-h":!0}),I(_o)!=="svelte-1p4u01l"&&(_o.textContent=pm),Hc=r($),To=m($,"P",{"data-svelte-h":!0}),I(To)!=="svelte-kbf9lm"&&(To.innerHTML=gm),Lc=r($),nn=m($,"DIV",{class:!0});var Qn=k(nn);d(Na.$$.fragment,Qn),Pc=r(Qn),Io=m(Qn,"P",{"data-svelte-h":!0}),I(Io)!=="svelte-1hs5qib"&&(Io.textContent=um),Kc=r(Qn),d(Pt.$$.fragment,Qn),Qn.forEach(g),ep=r($),tn=m($,"DIV",{class:!0});var Sn=k(tn);d(Za.$$.fragment,Sn),np=r(Sn),Jo=m(Sn,"P",{"data-svelte-h":!0}),I(Jo)!=="svelte-z9e742"&&(Jo.textContent=mm),tp=r(Sn),d(Kt.$$.fragment,Sn),Sn.forEach(g),sp=r($),sn=m($,"DIV",{class:!0});var Vn=k(sn);d(Wa.$$.fragment,Vn),ap=r(Vn),wo=m(Vn,"P",{"data-svelte-h":!0}),I(wo)!=="svelte-lahnll"&&(wo.textContent=hm),lp=r(Vn),d(es.$$.fragment,Vn),Vn.forEach(g),op=r($),N=m($,"DIV",{class:!0});var W=k(N);d(Ga.$$.fragment,W),ip=r(W),xo=m(W,"P",{"data-svelte-h":!0}),I(xo)!=="svelte-5o70yf"&&(xo.textContent=dm),rp=r(W),d(ns.$$.fragment,W),cp=r(W),d(ts.$$.fragment,W),pp=r(W),d(ss.$$.fragment,W),gp=r(W),d(as.$$.fragment,W),up=r(W),d(ls.$$.fragment,W),mp=r(W),d(os.$$.fragment,W),hp=r(W),d(is.$$.fragment,W),W.forEach(g),dp=r($),re=m($,"DIV",{class:!0});var Ce=k(re);d(Ba.$$.fragment,Ce),fp=r(Ce),Co=m(Ce,"P",{"data-svelte-h":!0}),I(Co)!=="svelte-vcr7iw"&&(Co.textContent=fm),yp=r(Ce),Uo=m(Ce,"P",{"data-svelte-h":!0}),I(Uo)!=="svelte-1jtca0b"&&(Uo.textContent=ym),bp=r(Ce),$o=m(Ce,"P",{"data-svelte-h":!0}),I($o)!=="svelte-1sz3ulv"&&($o.innerHTML=bm),Ce.forEach(g),Mp=r($),an=m($,"DIV",{class:!0});var Yn=k(an);d(Qa.$$.fragment,Yn),jp=r(Yn),ko=m(Yn,"P",{"data-svelte-h":!0}),I(ko)!=="svelte-qs8cmr"&&(ko.textContent=Mm),_p=r(Yn),d(rs.$$.fragment,Yn),Yn.forEach(g),Tp=r($),ln=m($,"DIV",{class:!0});var zn=k(ln);d(Sa.$$.fragment,zn),Ip=r(zn),vo=m(zn,"P",{"data-svelte-h":!0}),I(vo)!=="svelte-1axtrg9"&&(vo.textContent=jm),Jp=r(zn),d(cs.$$.fragment,zn),zn.forEach(g),wp=r($),on=m($,"DIV",{class:!0});var Rn=k(on);d(Va.$$.fragment,Rn),xp=r(Rn),qo=m(Rn,"P",{"data-svelte-h":!0}),I(qo)!=="svelte-1lnjtsz"&&(qo.textContent=_m),Cp=r(Rn),d(ps.$$.fragment,Rn),Rn.forEach(g),Up=r($),ce=m($,"DIV",{class:!0});var Ue=k(ce);d(Ya.$$.fragment,Ue),$p=r(Ue),Ao=m(Ue,"P",{"data-svelte-h":!0}),I(Ao)!=="svelte-s2la9t"&&(Ao.textContent=Tm),kp=r(Ue),Eo=m(Ue,"P",{"data-svelte-h":!0}),I(Eo)!=="svelte-1xhka28"&&(Eo.innerHTML=Im),vp=r(Ue),d(gs.$$.fragment,Ue),Ue.forEach(g),qp=r($),pe=m($,"DIV",{class:!0});var $e=k(pe);d(za.$$.fragment,$e),Ap=r($e),No=m($e,"P",{"data-svelte-h":!0}),I(No)!=="svelte-1htupoc"&&(No.textContent=Jm),Ep=r($e),d(us.$$.fragment,$e),Np=r($e),d(ms.$$.fragment,$e),$e.forEach(g),Zp=r($),ge=m($,"DIV",{class:!0});var ke=k(ge);d(Ra.$$.fragment,ke),Wp=r(ke),Zo=m(ke,"P",{"data-svelte-h":!0}),I(Zo)!=="svelte-1m9sgvu"&&(Zo.textContent=wm),Gp=r(ke),Wo=m(ke,"P",{"data-svelte-h":!0}),I(Wo)!=="svelte-1xj24a2"&&(Wo.innerHTML=xm),Bp=r(ke),d(hs.$$.fragment,ke),ke.forEach(g),Qp=r($),rn=m($,"DIV",{class:!0});var Xn=k(rn);d(Xa.$$.fragment,Xn),Sp=r(Xn),Go=m(Xn,"P",{"data-svelte-h":!0}),I(Go)!=="svelte-u63854"&&(Go.textContent=Cm),Vp=r(Xn),d(ds.$$.fragment,Xn),Xn.forEach(g),Yp=r($),ue=m($,"DIV",{class:!0});var ve=k(ue);d(Fa.$$.fragment,ve),zp=r(ve),Bo=m(ve,"P",{"data-svelte-h":!0}),I(Bo)!=="svelte-k6f11e"&&(Bo.textContent=Um),Rp=r(ve),d(fs.$$.fragment,ve),Xp=r(ve),d(ys.$$.fragment,ve),ve.forEach(g),Fp=r($),me=m($,"DIV",{class:!0});var qe=k(me);d(Da.$$.fragment,qe),Dp=r(qe),Qo=m(qe,"P",{"data-svelte-h":!0}),I(Qo)!=="svelte-7cx5l1"&&(Qo.textContent=$m),Op=r(qe),d(bs.$$.fragment,qe),Hp=r(qe),d(Ms.$$.fragment,qe),qe.forEach(g),Lp=r($),he=m($,"DIV",{class:!0});var Ae=k(he);d(Oa.$$.fragment,Ae),Pp=r(Ae),So=m(Ae,"P",{"data-svelte-h":!0}),I(So)!=="svelte-1tnfouk"&&(So.textContent=km),Kp=r(Ae),Vo=m(Ae,"P",{"data-svelte-h":!0}),I(Vo)!=="svelte-qrqo93"&&(Vo.textContent=vm),eg=r(Ae),d(js.$$.fragment,Ae),Ae.forEach(g),ng=r($),S=m($,"DIV",{class:!0});var X=k(S);d(Ha.$$.fragment,X),tg=r(X),Yo=m(X,"P",{"data-svelte-h":!0}),I(Yo)!=="svelte-71vo6e"&&(Yo.textContent=qm),sg=r(X),zo=m(X,"P",{"data-svelte-h":!0}),I(zo)!=="svelte-1k36r1q"&&(zo.innerHTML=Am),ag=r(X),d(_s.$$.fragment,X),lg=r(X),d(Ts.$$.fragment,X),og=r(X),d(Is.$$.fragment,X),X.forEach(g),ig=r($),de=m($,"DIV",{class:!0});var Ee=k(de);d(La.$$.fragment,Ee),rg=r(Ee),Ro=m(Ee,"P",{"data-svelte-h":!0}),I(Ro)!=="svelte-fzfwfh"&&(Ro.textContent=Em),cg=r(Ee),d(Js.$$.fragment,Ee),pg=r(Ee),d(ws.$$.fragment,Ee),Ee.forEach(g),gg=r($),xs=m($,"DIV",{class:!0});var Cl=k(xs);d(Pa.$$.fragment,Cl),ug=r(Cl),Xo=m(Cl,"P",{"data-svelte-h":!0}),I(Xo)!=="svelte-14tnsya"&&(Xo.textContent=Nm),Cl.forEach(g),mg=r($),cn=m($,"DIV",{class:!0});var Fn=k(cn);d(Ka.$$.fragment,Fn),hg=r(Fn),Fo=m(Fn,"P",{"data-svelte-h":!0}),I(Fo)!=="svelte-1mibg86"&&(Fo.textContent=Zm),dg=r(Fn),d(Cs.$$.fragment,Fn),Fn.forEach(g),fg=r($),pn=m($,"DIV",{class:!0});var Dn=k(pn);d(el.$$.fragment,Dn),yg=r(Dn),Do=m(Dn,"P",{"data-svelte-h":!0}),I(Do)!=="svelte-1nuhgbh"&&(Do.textContent=Wm),bg=r(Dn),d(Us.$$.fragment,Dn),Dn.forEach(g),Mg=r($),gn=m($,"DIV",{class:!0});var On=k(gn);d(nl.$$.fragment,On),jg=r(On),Oo=m(On,"P",{"data-svelte-h":!0}),I(Oo)!=="svelte-1uepm2o"&&(Oo.textContent=Gm),_g=r(On),d($s.$$.fragment,On),On.forEach(g),Tg=r($),un=m($,"DIV",{class:!0});var Hn=k(un);d(tl.$$.fragment,Hn),Ig=r(Hn),Ho=m(Hn,"P",{"data-svelte-h":!0}),I(Ho)!=="svelte-77a94i"&&(Ho.textContent=Bm),Jg=r(Hn),d(ks.$$.fragment,Hn),Hn.forEach(g),wg=r($),mn=m($,"DIV",{class:!0});var Ln=k(mn);d(sl.$$.fragment,Ln),xg=r(Ln),Lo=m(Ln,"P",{"data-svelte-h":!0}),I(Lo)!=="svelte-61sxmo"&&(Lo.textContent=Qm),Cg=r(Ln),d(vs.$$.fragment,Ln),Ln.forEach(g),Ug=r($),hn=m($,"DIV",{class:!0});var Pn=k(hn);d(al.$$.fragment,Pn),$g=r(Pn),Po=m(Pn,"P",{"data-svelte-h":!0}),I(Po)!=="svelte-hzldyu"&&(Po.textContent=Sm),kg=r(Pn),d(qs.$$.fragment,Pn),Pn.forEach(g),vg=r($),dn=m($,"DIV",{class:!0});var Kn=k(dn);d(ll.$$.fragment,Kn),qg=r(Kn),Ko=m(Kn,"P",{"data-svelte-h":!0}),I(Ko)!=="svelte-b4yzyj"&&(Ko.textContent=Vm),Ag=r(Kn),d(As.$$.fragment,Kn),Kn.forEach(g),Eg=r($),V=m($,"DIV",{class:!0});var F=k(V);d(ol.$$.fragment,F),Ng=r(F),ei=m(F,"P",{"data-svelte-h":!0}),I(ei)!=="svelte-qakvx8"&&(ei.textContent=Ym),Zg=r(F),ni=m(F,"P",{"data-svelte-h":!0}),I(ni)!=="svelte-1irx2op"&&(ni.innerHTML=zm),Wg=r(F),ti=m(F,"P",{"data-svelte-h":!0}),I(ti)!=="svelte-140zl9b"&&(ti.innerHTML=Rm),Gg=r(F),d(Es.$$.fragment,F),Bg=r(F),d(Ns.$$.fragment,F),F.forEach(g),Qg=r($),fe=m($,"DIV",{class:!0});var Ne=k(fe);d(il.$$.fragment,Ne),Sg=r(Ne),si=m(Ne,"P",{"data-svelte-h":!0}),I(si)!=="svelte-9lmcnw"&&(si.textContent=Xm),Vg=r(Ne),d(Zs.$$.fragment,Ne),Yg=r(Ne),d(Ws.$$.fragment,Ne),Ne.forEach(g),zg=r($),fn=m($,"DIV",{class:!0});var et=k(fn);d(rl.$$.fragment,et),Rg=r(et),ai=m(et,"P",{"data-svelte-h":!0}),I(ai)!=="svelte-12mjzdy"&&(ai.textContent=Fm),Xg=r(et),d(Gs.$$.fragment,et),et.forEach(g),Fg=r($),yn=m($,"DIV",{class:!0});var nt=k(yn);d(cl.$$.fragment,nt),Dg=r(nt),li=m(nt,"P",{"data-svelte-h":!0}),I(li)!=="svelte-1araal"&&(li.textContent=Dm),Og=r(nt),d(Bs.$$.fragment,nt),nt.forEach(g),Hg=r($),O=m($,"DIV",{class:!0});var L=k(O);d(pl.$$.fragment,L),Lg=r(L),oi=m(L,"P",{"data-svelte-h":!0}),I(oi)!=="svelte-1v3lqck"&&(oi.textContent=Om),Pg=r(L),ii=m(L,"P",{"data-svelte-h":!0}),I(ii)!=="svelte-jwmjgr"&&(ii.innerHTML=Hm),Kg=r(L),d(Qs.$$.fragment,L),eu=r(L),d(Ss.$$.fragment,L),L.forEach(g),nu=r($),bn=m($,"DIV",{class:!0});var tt=k(bn);d(gl.$$.fragment,tt),tu=r(tt),ri=m(tt,"P",{"data-svelte-h":!0}),I(ri)!=="svelte-1jbp6ey"&&(ri.textContent=Lm),su=r(tt),d(Vs.$$.fragment,tt),tt.forEach(g),au=r($),ye=m($,"DIV",{class:!0});var Ze=k(ye);d(ul.$$.fragment,Ze),lu=r(Ze),ci=m(Ze,"P",{"data-svelte-h":!0}),I(ci)!=="svelte-1c9xuqj"&&(ci.textContent=Pm),ou=r(Ze),d(Ys.$$.fragment,Ze),iu=r(Ze),d(zs.$$.fragment,Ze),Ze.forEach(g),ru=r($),Mn=m($,"DIV",{class:!0});var st=k(Mn);d(ml.$$.fragment,st),cu=r(st),pi=m(st,"P",{"data-svelte-h":!0}),I(pi)!=="svelte-108ipf8"&&(pi.textContent=Km),pu=r(st),d(Rs.$$.fragment,st),st.forEach(g),$.forEach(g),wi=r(s),d(hl.$$.fragment,s),xi=r(s),jn=m(s,"DIV",{class:!0});var Ul=k(jn);d(dl.$$.fragment,Ul),gu=r(Ul),gi=m(Ul,"P",{"data-svelte-h":!0}),I(gi)!=="svelte-2793d9"&&(gi.textContent=eh),Ul.forEach(g),Ci=r(s),d(fl.$$.fragment,s),Ui=r(s),yl=m(s,"P",{"data-svelte-h":!0}),I(yl)!=="svelte-1lzrumh"&&(yl.textContent=nh),$i=r(s),d(bl.$$.fragment,s),ki=r(s),_n=m(s,"DIV",{class:!0});var $l=k(_n);d(Ml.$$.fragment,$l),uu=r($l),ui=m($l,"P",{"data-svelte-h":!0}),I(ui)!=="svelte-1hj6bfi"&&(ui.textContent=th),$l.forEach(g),vi=r(s),d(jl.$$.fragment,s),qi=r(s),_l=m(s,"P",{"data-svelte-h":!0}),I(_l)!=="svelte-12jme9g"&&(_l.innerHTML=sh),Ai=r(s),Y=m(s,"DIV",{class:!0});var P=k(Y);d(Tl.$$.fragment,P),mu=r(P),mi=m(P,"P",{"data-svelte-h":!0}),I(mi)!=="svelte-xkrgz1"&&(mi.textContent=ah),hu=r(P),d(Xs.$$.fragment,P),du=r(P),Fs=m(P,"DIV",{class:!0});var kl=k(Fs);d(Il.$$.fragment,kl),fu=r(kl),hi=m(kl,"P",{"data-svelte-h":!0}),I(hi)!=="svelte-1ruvvxs"&&(hi.textContent=lh),kl.forEach(g),yu=r(P),Ds=m(P,"DIV",{class:!0});var vl=k(Ds);d(Jl.$$.fragment,vl),bu=r(vl),di=m(vl,"P",{"data-svelte-h":!0}),I(di)!=="svelte-ss15d2"&&(di.textContent=oh),vl.forEach(g),P.forEach(g),Ei=r(s),d(wl.$$.fragment,s),Ni=r(s),fi=m(s,"P",{}),k(fi).forEach(g),this.h()},h(){v(n,"name","hf:doc:metadata"),v(n,"content",wf),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,j){l(document.head,n),_(s,p,j),_(s,a,j),_(s,t,j),f(o,s,j),_(s,e,j),_(s,c,j),_(s,yi,j),_(s,Os,j),_(s,bi,j),_(s,Hs,j),_(s,Mi,j),f(Ls,s,j),_(s,ji,j),_(s,U,j),f(Ps,U,null),l(U,Wi),l(U,Al),l(U,Gi),l(U,El),l(U,Bi),l(U,We),f(Ks,We,null),l(We,Qi),l(We,Nl),l(We,Si),f(at,We,null),l(U,Vi),l(U,Ge),f(ea,Ge,null),l(Ge,Yi),l(Ge,Zl),l(Ge,zi),f(lt,Ge,null),l(U,Ri),l(U,Be),f(na,Be,null),l(Be,Xi),l(Be,Wl),l(Be,Fi),f(ot,Be,null),l(U,Di),l(U,E),f(ta,E,null),l(E,Oi),l(E,Gl),l(E,Hi),f(it,E,null),l(E,Li),f(rt,E,null),l(E,Pi),f(ct,E,null),l(E,Ki),f(pt,E,null),l(E,er),f(gt,E,null),l(E,nr),f(ut,E,null),l(E,tr),f(mt,E,null),l(U,sr),l(U,Qe),f(sa,Qe,null),l(Qe,ar),l(Qe,Bl),l(Qe,lr),f(ht,Qe,null),l(U,or),l(U,Se),f(aa,Se,null),l(Se,ir),l(Se,Ql),l(Se,rr),f(dt,Se,null),l(U,cr),l(U,Ve),f(la,Ve,null),l(Ve,pr),l(Ve,Sl),l(Ve,gr),f(ft,Ve,null),l(U,ur),l(U,K),f(oa,K,null),l(K,mr),l(K,Vl),l(K,hr),l(K,Yl),l(K,dr),f(yt,K,null),l(U,fr),l(U,ee),f(ia,ee,null),l(ee,yr),l(ee,zl),l(ee,br),f(bt,ee,null),l(ee,Mr),f(Mt,ee,null),l(U,jr),l(U,ne),f(ra,ne,null),l(ne,_r),l(ne,Rl),l(ne,Tr),l(ne,Xl),l(ne,Ir),f(jt,ne,null),l(U,Jr),l(U,Ye),f(ca,Ye,null),l(Ye,wr),l(Ye,Fl),l(Ye,xr),f(_t,Ye,null),l(U,Cr),l(U,te),f(pa,te,null),l(te,Ur),l(te,Dl),l(te,$r),f(Tt,te,null),l(te,kr),f(It,te,null),l(U,vr),l(U,se),f(ga,se,null),l(se,qr),l(se,Ol),l(se,Ar),f(Jt,se,null),l(se,Er),f(wt,se,null),l(U,Nr),l(U,ae),f(ua,ae,null),l(ae,Zr),l(ae,Hl),l(ae,Wr),l(ae,Ll),l(ae,Gr),f(xt,ae,null),l(U,Br),l(U,B),f(ma,B,null),l(B,Qr),l(B,Pl),l(B,Sr),l(B,Kl),l(B,Vr),f(Ct,B,null),l(B,Yr),f(Ut,B,null),l(B,zr),f($t,B,null),l(U,Rr),l(U,le),f(ha,le,null),l(le,Xr),l(le,eo),l(le,Fr),f(kt,le,null),l(le,Dr),f(vt,le,null),l(U,Or),l(U,qt),f(da,qt,null),l(qt,Hr),l(qt,no),l(U,Lr),l(U,ze),f(fa,ze,null),l(ze,Pr),l(ze,to),l(ze,Kr),f(At,ze,null),l(U,ec),l(U,Re),f(ya,Re,null),l(Re,nc),l(Re,so),l(Re,tc),f(Et,Re,null),l(U,sc),l(U,Xe),f(ba,Xe,null),l(Xe,ac),l(Xe,ao),l(Xe,lc),f(Nt,Xe,null),l(U,oc),l(U,Fe),f(Ma,Fe,null),l(Fe,ic),l(Fe,lo),l(Fe,rc),f(Zt,Fe,null),l(U,cc),l(U,De),f(ja,De,null),l(De,pc),l(De,oo),l(De,gc),f(Wt,De,null),l(U,uc),l(U,Oe),f(_a,Oe,null),l(Oe,mc),l(Oe,io),l(Oe,hc),f(Gt,Oe,null),l(U,dc),l(U,He),f(Ta,He,null),l(He,fc),l(He,ro),l(He,yc),f(Bt,He,null),l(U,bc),l(U,Q),f(Ia,Q,null),l(Q,Mc),l(Q,co),l(Q,jc),l(Q,po),l(Q,_c),l(Q,go),l(Q,Tc),f(Qt,Q,null),l(Q,Ic),f(St,Q,null),l(U,Jc),l(U,oe),f(Ja,oe,null),l(oe,wc),l(oe,uo),l(oe,xc),f(Vt,oe,null),l(oe,Cc),f(Yt,oe,null),l(U,Uc),l(U,Le),f(wa,Le,null),l(Le,$c),l(Le,mo),l(Le,kc),f(zt,Le,null),l(U,vc),l(U,Pe),f(xa,Pe,null),l(Pe,qc),l(Pe,ho),l(Pe,Ac),f(Rt,Pe,null),l(U,Ec),l(U,D),f(Ca,D,null),l(D,Nc),l(D,fo),l(D,Zc),l(D,yo),l(D,Wc),f(Xt,D,null),l(D,Gc),f(Ft,D,null),l(U,Bc),l(U,Ke),f(Ua,Ke,null),l(Ke,Qc),l(Ke,bo),l(Ke,Sc),f(Dt,Ke,null),l(U,Vc),l(U,ie),f($a,ie,null),l(ie,Yc),l(ie,Mo),l(ie,zc),f(Ot,ie,null),l(ie,Rc),f(Ht,ie,null),l(U,Xc),l(U,en),f(ka,en,null),l(en,Fc),l(en,jo),l(en,Dc),f(Lt,en,null),_(s,_i,j),f(va,s,j),_(s,Ti,j),_(s,qa,j),_(s,Ii,j),f(Aa,s,j),_(s,Ji,j),_(s,x,j),f(Ea,x,null),l(x,Oc),l(x,_o),l(x,Hc),l(x,To),l(x,Lc),l(x,nn),f(Na,nn,null),l(nn,Pc),l(nn,Io),l(nn,Kc),f(Pt,nn,null),l(x,ep),l(x,tn),f(Za,tn,null),l(tn,np),l(tn,Jo),l(tn,tp),f(Kt,tn,null),l(x,sp),l(x,sn),f(Wa,sn,null),l(sn,ap),l(sn,wo),l(sn,lp),f(es,sn,null),l(x,op),l(x,N),f(Ga,N,null),l(N,ip),l(N,xo),l(N,rp),f(ns,N,null),l(N,cp),f(ts,N,null),l(N,pp),f(ss,N,null),l(N,gp),f(as,N,null),l(N,up),f(ls,N,null),l(N,mp),f(os,N,null),l(N,hp),f(is,N,null),l(x,dp),l(x,re),f(Ba,re,null),l(re,fp),l(re,Co),l(re,yp),l(re,Uo),l(re,bp),l(re,$o),l(x,Mp),l(x,an),f(Qa,an,null),l(an,jp),l(an,ko),l(an,_p),f(rs,an,null),l(x,Tp),l(x,ln),f(Sa,ln,null),l(ln,Ip),l(ln,vo),l(ln,Jp),f(cs,ln,null),l(x,wp),l(x,on),f(Va,on,null),l(on,xp),l(on,qo),l(on,Cp),f(ps,on,null),l(x,Up),l(x,ce),f(Ya,ce,null),l(ce,$p),l(ce,Ao),l(ce,kp),l(ce,Eo),l(ce,vp),f(gs,ce,null),l(x,qp),l(x,pe),f(za,pe,null),l(pe,Ap),l(pe,No),l(pe,Ep),f(us,pe,null),l(pe,Np),f(ms,pe,null),l(x,Zp),l(x,ge),f(Ra,ge,null),l(ge,Wp),l(ge,Zo),l(ge,Gp),l(ge,Wo),l(ge,Bp),f(hs,ge,null),l(x,Qp),l(x,rn),f(Xa,rn,null),l(rn,Sp),l(rn,Go),l(rn,Vp),f(ds,rn,null),l(x,Yp),l(x,ue),f(Fa,ue,null),l(ue,zp),l(ue,Bo),l(ue,Rp),f(fs,ue,null),l(ue,Xp),f(ys,ue,null),l(x,Fp),l(x,me),f(Da,me,null),l(me,Dp),l(me,Qo),l(me,Op),f(bs,me,null),l(me,Hp),f(Ms,me,null),l(x,Lp),l(x,he),f(Oa,he,null),l(he,Pp),l(he,So),l(he,Kp),l(he,Vo),l(he,eg),f(js,he,null),l(x,ng),l(x,S),f(Ha,S,null),l(S,tg),l(S,Yo),l(S,sg),l(S,zo),l(S,ag),f(_s,S,null),l(S,lg),f(Ts,S,null),l(S,og),f(Is,S,null),l(x,ig),l(x,de),f(La,de,null),l(de,rg),l(de,Ro),l(de,cg),f(Js,de,null),l(de,pg),f(ws,de,null),l(x,gg),l(x,xs),f(Pa,xs,null),l(xs,ug),l(xs,Xo),l(x,mg),l(x,cn),f(Ka,cn,null),l(cn,hg),l(cn,Fo),l(cn,dg),f(Cs,cn,null),l(x,fg),l(x,pn),f(el,pn,null),l(pn,yg),l(pn,Do),l(pn,bg),f(Us,pn,null),l(x,Mg),l(x,gn),f(nl,gn,null),l(gn,jg),l(gn,Oo),l(gn,_g),f($s,gn,null),l(x,Tg),l(x,un),f(tl,un,null),l(un,Ig),l(un,Ho),l(un,Jg),f(ks,un,null),l(x,wg),l(x,mn),f(sl,mn,null),l(mn,xg),l(mn,Lo),l(mn,Cg),f(vs,mn,null),l(x,Ug),l(x,hn),f(al,hn,null),l(hn,$g),l(hn,Po),l(hn,kg),f(qs,hn,null),l(x,vg),l(x,dn),f(ll,dn,null),l(dn,qg),l(dn,Ko),l(dn,Ag),f(As,dn,null),l(x,Eg),l(x,V),f(ol,V,null),l(V,Ng),l(V,ei),l(V,Zg),l(V,ni),l(V,Wg),l(V,ti),l(V,Gg),f(Es,V,null),l(V,Bg),f(Ns,V,null),l(x,Qg),l(x,fe),f(il,fe,null),l(fe,Sg),l(fe,si),l(fe,Vg),f(Zs,fe,null),l(fe,Yg),f(Ws,fe,null),l(x,zg),l(x,fn),f(rl,fn,null),l(fn,Rg),l(fn,ai),l(fn,Xg),f(Gs,fn,null),l(x,Fg),l(x,yn),f(cl,yn,null),l(yn,Dg),l(yn,li),l(yn,Og),f(Bs,yn,null),l(x,Hg),l(x,O),f(pl,O,null),l(O,Lg),l(O,oi),l(O,Pg),l(O,ii),l(O,Kg),f(Qs,O,null),l(O,eu),f(Ss,O,null),l(x,nu),l(x,bn),f(gl,bn,null),l(bn,tu),l(bn,ri),l(bn,su),f(Vs,bn,null),l(x,au),l(x,ye),f(ul,ye,null),l(ye,lu),l(ye,ci),l(ye,ou),f(Ys,ye,null),l(ye,iu),f(zs,ye,null),l(x,ru),l(x,Mn),f(ml,Mn,null),l(Mn,cu),l(Mn,pi),l(Mn,pu),f(Rs,Mn,null),_(s,wi,j),f(hl,s,j),_(s,xi,j),_(s,jn,j),f(dl,jn,null),l(jn,gu),l(jn,gi),_(s,Ci,j),f(fl,s,j),_(s,Ui,j),_(s,yl,j),_(s,$i,j),f(bl,s,j),_(s,ki,j),_(s,_n,j),f(Ml,_n,null),l(_n,uu),l(_n,ui),_(s,vi,j),f(jl,s,j),_(s,qi,j),_(s,_l,j),_(s,Ai,j),_(s,Y,j),f(Tl,Y,null),l(Y,mu),l(Y,mi),l(Y,hu),f(Xs,Y,null),l(Y,du),l(Y,Fs),f(Il,Fs,null),l(Fs,fu),l(Fs,hi),l(Y,yu),l(Y,Ds),f(Jl,Ds,null),l(Ds,bu),l(Ds,di),_(s,Ei,j),f(wl,s,j),_(s,Ni,j),_(s,fi,j),Zi=!0},p(s,[j]){const q={};j&2&&(q.$$scope={dirty:j,ctx:s}),at.$set(q);const Tn={};j&2&&(Tn.$$scope={dirty:j,ctx:s}),lt.$set(Tn);const In={};j&2&&(In.$$scope={dirty:j,ctx:s}),ot.$set(In);const Jn={};j&2&&(Jn.$$scope={dirty:j,ctx:s}),it.$set(Jn);const Z={};j&2&&(Z.$$scope={dirty:j,ctx:s}),rt.$set(Z);const wn={};j&2&&(wn.$$scope={dirty:j,ctx:s}),ct.$set(wn);const xn={};j&2&&(xn.$$scope={dirty:j,ctx:s}),pt.$set(xn);const Cn={};j&2&&(Cn.$$scope={dirty:j,ctx:s}),gt.$set(Cn);const be={};j&2&&(be.$$scope={dirty:j,ctx:s}),ut.$set(be);const Me={};j&2&&(Me.$$scope={dirty:j,ctx:s}),mt.$set(Me);const je={};j&2&&(je.$$scope={dirty:j,ctx:s}),ht.$set(je);const Un={};j&2&&(Un.$$scope={dirty:j,ctx:s}),dt.$set(Un);const _e={};j&2&&(_e.$$scope={dirty:j,ctx:s}),ft.$set(_e);const Te={};j&2&&(Te.$$scope={dirty:j,ctx:s}),yt.$set(Te);const Ie={};j&2&&(Ie.$$scope={dirty:j,ctx:s}),bt.$set(Ie);const z={};j&2&&(z.$$scope={dirty:j,ctx:s}),Mt.$set(z);const Je={};j&2&&(Je.$$scope={dirty:j,ctx:s}),jt.$set(Je);const xl={};j&2&&(xl.$$scope={dirty:j,ctx:s}),_t.$set(xl);const $n={};j&2&&($n.$$scope={dirty:j,ctx:s}),Tt.$set($n);const kn={};j&2&&(kn.$$scope={dirty:j,ctx:s}),It.$set(kn);const vn={};j&2&&(vn.$$scope={dirty:j,ctx:s}),Jt.$set(vn);const qn={};j&2&&(qn.$$scope={dirty:j,ctx:s}),wt.$set(qn);const An={};j&2&&(An.$$scope={dirty:j,ctx:s}),xt.$set(An);const En={};j&2&&(En.$$scope={dirty:j,ctx:s}),Ct.$set(En);const Nn={};j&2&&(Nn.$$scope={dirty:j,ctx:s}),Ut.$set(Nn);const R={};j&2&&(R.$$scope={dirty:j,ctx:s}),$t.$set(R);const we={};j&2&&(we.$$scope={dirty:j,ctx:s}),kt.$set(we);const Zn={};j&2&&(Zn.$$scope={dirty:j,ctx:s}),vt.$set(Zn);const Wn={};j&2&&(Wn.$$scope={dirty:j,ctx:s}),At.$set(Wn);const H={};j&2&&(H.$$scope={dirty:j,ctx:s}),Et.$set(H);const Gn={};j&2&&(Gn.$$scope={dirty:j,ctx:s}),Nt.$set(Gn);const xe={};j&2&&(xe.$$scope={dirty:j,ctx:s}),Zt.$set(xe);const Bn={};j&2&&(Bn.$$scope={dirty:j,ctx:s}),Wt.$set(Bn);const $={};j&2&&($.$$scope={dirty:j,ctx:s}),Gt.$set($);const Qn={};j&2&&(Qn.$$scope={dirty:j,ctx:s}),Bt.$set(Qn);const Sn={};j&2&&(Sn.$$scope={dirty:j,ctx:s}),Qt.$set(Sn);const Vn={};j&2&&(Vn.$$scope={dirty:j,ctx:s}),St.$set(Vn);const W={};j&2&&(W.$$scope={dirty:j,ctx:s}),Vt.$set(W);const Ce={};j&2&&(Ce.$$scope={dirty:j,ctx:s}),Yt.$set(Ce);const Yn={};j&2&&(Yn.$$scope={dirty:j,ctx:s}),zt.$set(Yn);const zn={};j&2&&(zn.$$scope={dirty:j,ctx:s}),Rt.$set(zn);const Rn={};j&2&&(Rn.$$scope={dirty:j,ctx:s}),Xt.$set(Rn);const Ue={};j&2&&(Ue.$$scope={dirty:j,ctx:s}),Ft.$set(Ue);const $e={};j&2&&($e.$$scope={dirty:j,ctx:s}),Dt.$set($e);const ke={};j&2&&(ke.$$scope={dirty:j,ctx:s}),Ot.$set(ke);const Xn={};j&2&&(Xn.$$scope={dirty:j,ctx:s}),Ht.$set(Xn);const ve={};j&2&&(ve.$$scope={dirty:j,ctx:s}),Lt.$set(ve);const qe={};j&2&&(qe.$$scope={dirty:j,ctx:s}),Pt.$set(qe);const Ae={};j&2&&(Ae.$$scope={dirty:j,ctx:s}),Kt.$set(Ae);const X={};j&2&&(X.$$scope={dirty:j,ctx:s}),es.$set(X);const Ee={};j&2&&(Ee.$$scope={dirty:j,ctx:s}),ns.$set(Ee);const Cl={};j&2&&(Cl.$$scope={dirty:j,ctx:s}),ts.$set(Cl);const Fn={};j&2&&(Fn.$$scope={dirty:j,ctx:s}),ss.$set(Fn);const Dn={};j&2&&(Dn.$$scope={dirty:j,ctx:s}),as.$set(Dn);const On={};j&2&&(On.$$scope={dirty:j,ctx:s}),ls.$set(On);const Hn={};j&2&&(Hn.$$scope={dirty:j,ctx:s}),os.$set(Hn);const Ln={};j&2&&(Ln.$$scope={dirty:j,ctx:s}),is.$set(Ln);const Pn={};j&2&&(Pn.$$scope={dirty:j,ctx:s}),rs.$set(Pn);const Kn={};j&2&&(Kn.$$scope={dirty:j,ctx:s}),cs.$set(Kn);const F={};j&2&&(F.$$scope={dirty:j,ctx:s}),ps.$set(F);const Ne={};j&2&&(Ne.$$scope={dirty:j,ctx:s}),gs.$set(Ne);const et={};j&2&&(et.$$scope={dirty:j,ctx:s}),us.$set(et);const nt={};j&2&&(nt.$$scope={dirty:j,ctx:s}),ms.$set(nt);const L={};j&2&&(L.$$scope={dirty:j,ctx:s}),hs.$set(L);const tt={};j&2&&(tt.$$scope={dirty:j,ctx:s}),ds.$set(tt);const Ze={};j&2&&(Ze.$$scope={dirty:j,ctx:s}),fs.$set(Ze);const st={};j&2&&(st.$$scope={dirty:j,ctx:s}),ys.$set(st);const Ul={};j&2&&(Ul.$$scope={dirty:j,ctx:s}),bs.$set(Ul);const $l={};j&2&&($l.$$scope={dirty:j,ctx:s}),Ms.$set($l);const P={};j&2&&(P.$$scope={dirty:j,ctx:s}),js.$set(P);const kl={};j&2&&(kl.$$scope={dirty:j,ctx:s}),_s.$set(kl);const vl={};j&2&&(vl.$$scope={dirty:j,ctx:s}),Ts.$set(vl);const ih={};j&2&&(ih.$$scope={dirty:j,ctx:s}),Is.$set(ih);const rh={};j&2&&(rh.$$scope={dirty:j,ctx:s}),Js.$set(rh);const ch={};j&2&&(ch.$$scope={dirty:j,ctx:s}),ws.$set(ch);const ph={};j&2&&(ph.$$scope={dirty:j,ctx:s}),Cs.$set(ph);const gh={};j&2&&(gh.$$scope={dirty:j,ctx:s}),Us.$set(gh);const uh={};j&2&&(uh.$$scope={dirty:j,ctx:s}),$s.$set(uh);const mh={};j&2&&(mh.$$scope={dirty:j,ctx:s}),ks.$set(mh);const hh={};j&2&&(hh.$$scope={dirty:j,ctx:s}),vs.$set(hh);const dh={};j&2&&(dh.$$scope={dirty:j,ctx:s}),qs.$set(dh);const fh={};j&2&&(fh.$$scope={dirty:j,ctx:s}),As.$set(fh);const yh={};j&2&&(yh.$$scope={dirty:j,ctx:s}),Es.$set(yh);const bh={};j&2&&(bh.$$scope={dirty:j,ctx:s}),Ns.$set(bh);const Mh={};j&2&&(Mh.$$scope={dirty:j,ctx:s}),Zs.$set(Mh);const jh={};j&2&&(jh.$$scope={dirty:j,ctx:s}),Ws.$set(jh);const _h={};j&2&&(_h.$$scope={dirty:j,ctx:s}),Gs.$set(_h);const Th={};j&2&&(Th.$$scope={dirty:j,ctx:s}),Bs.$set(Th);const Ih={};j&2&&(Ih.$$scope={dirty:j,ctx:s}),Qs.$set(Ih);const Jh={};j&2&&(Jh.$$scope={dirty:j,ctx:s}),Ss.$set(Jh);const wh={};j&2&&(wh.$$scope={dirty:j,ctx:s}),Vs.$set(wh);const xh={};j&2&&(xh.$$scope={dirty:j,ctx:s}),Ys.$set(xh);const Ch={};j&2&&(Ch.$$scope={dirty:j,ctx:s}),zs.$set(Ch);const Uh={};j&2&&(Uh.$$scope={dirty:j,ctx:s}),Rs.$set(Uh);const $h={};j&2&&($h.$$scope={dirty:j,ctx:s}),Xs.$set($h)},i(s){Zi||(y(o.$$.fragment,s),y(Ls.$$.fragment,s),y(Ps.$$.fragment,s),y(Ks.$$.fragment,s),y(at.$$.fragment,s),y(ea.$$.fragment,s),y(lt.$$.fragment,s),y(na.$$.fragment,s),y(ot.$$.fragment,s),y(ta.$$.fragment,s),y(it.$$.fragment,s),y(rt.$$.fragment,s),y(ct.$$.fragment,s),y(pt.$$.fragment,s),y(gt.$$.fragment,s),y(ut.$$.fragment,s),y(mt.$$.fragment,s),y(sa.$$.fragment,s),y(ht.$$.fragment,s),y(aa.$$.fragment,s),y(dt.$$.fragment,s),y(la.$$.fragment,s),y(ft.$$.fragment,s),y(oa.$$.fragment,s),y(yt.$$.fragment,s),y(ia.$$.fragment,s),y(bt.$$.fragment,s),y(Mt.$$.fragment,s),y(ra.$$.fragment,s),y(jt.$$.fragment,s),y(ca.$$.fragment,s),y(_t.$$.fragment,s),y(pa.$$.fragment,s),y(Tt.$$.fragment,s),y(It.$$.fragment,s),y(ga.$$.fragment,s),y(Jt.$$.fragment,s),y(wt.$$.fragment,s),y(ua.$$.fragment,s),y(xt.$$.fragment,s),y(ma.$$.fragment,s),y(Ct.$$.fragment,s),y(Ut.$$.fragment,s),y($t.$$.fragment,s),y(ha.$$.fragment,s),y(kt.$$.fragment,s),y(vt.$$.fragment,s),y(da.$$.fragment,s),y(fa.$$.fragment,s),y(At.$$.fragment,s),y(ya.$$.fragment,s),y(Et.$$.fragment,s),y(ba.$$.fragment,s),y(Nt.$$.fragment,s),y(Ma.$$.fragment,s),y(Zt.$$.fragment,s),y(ja.$$.fragment,s),y(Wt.$$.fragment,s),y(_a.$$.fragment,s),y(Gt.$$.fragment,s),y(Ta.$$.fragment,s),y(Bt.$$.fragment,s),y(Ia.$$.fragment,s),y(Qt.$$.fragment,s),y(St.$$.fragment,s),y(Ja.$$.fragment,s),y(Vt.$$.fragment,s),y(Yt.$$.fragment,s),y(wa.$$.fragment,s),y(zt.$$.fragment,s),y(xa.$$.fragment,s),y(Rt.$$.fragment,s),y(Ca.$$.fragment,s),y(Xt.$$.fragment,s),y(Ft.$$.fragment,s),y(Ua.$$.fragment,s),y(Dt.$$.fragment,s),y($a.$$.fragment,s),y(Ot.$$.fragment,s),y(Ht.$$.fragment,s),y(ka.$$.fragment,s),y(Lt.$$.fragment,s),y(va.$$.fragment,s),y(Aa.$$.fragment,s),y(Ea.$$.fragment,s),y(Na.$$.fragment,s),y(Pt.$$.fragment,s),y(Za.$$.fragment,s),y(Kt.$$.fragment,s),y(Wa.$$.fragment,s),y(es.$$.fragment,s),y(Ga.$$.fragment,s),y(ns.$$.fragment,s),y(ts.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ls.$$.fragment,s),y(os.$$.fragment,s),y(is.$$.fragment,s),y(Ba.$$.fragment,s),y(Qa.$$.fragment,s),y(rs.$$.fragment,s),y(Sa.$$.fragment,s),y(cs.$$.fragment,s),y(Va.$$.fragment,s),y(ps.$$.fragment,s),y(Ya.$$.fragment,s),y(gs.$$.fragment,s),y(za.$$.fragment,s),y(us.$$.fragment,s),y(ms.$$.fragment,s),y(Ra.$$.fragment,s),y(hs.$$.fragment,s),y(Xa.$$.fragment,s),y(ds.$$.fragment,s),y(Fa.$$.fragment,s),y(fs.$$.fragment,s),y(ys.$$.fragment,s),y(Da.$$.fragment,s),y(bs.$$.fragment,s),y(Ms.$$.fragment,s),y(Oa.$$.fragment,s),y(js.$$.fragment,s),y(Ha.$$.fragment,s),y(_s.$$.fragment,s),y(Ts.$$.fragment,s),y(Is.$$.fragment,s),y(La.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(Pa.$$.fragment,s),y(Ka.$$.fragment,s),y(Cs.$$.fragment,s),y(el.$$.fragment,s),y(Us.$$.fragment,s),y(nl.$$.fragment,s),y($s.$$.fragment,s),y(tl.$$.fragment,s),y(ks.$$.fragment,s),y(sl.$$.fragment,s),y(vs.$$.fragment,s),y(al.$$.fragment,s),y(qs.$$.fragment,s),y(ll.$$.fragment,s),y(As.$$.fragment,s),y(ol.$$.fragment,s),y(Es.$$.fragment,s),y(Ns.$$.fragment,s),y(il.$$.fragment,s),y(Zs.$$.fragment,s),y(Ws.$$.fragment,s),y(rl.$$.fragment,s),y(Gs.$$.fragment,s),y(cl.$$.fragment,s),y(Bs.$$.fragment,s),y(pl.$$.fragment,s),y(Qs.$$.fragment,s),y(Ss.$$.fragment,s),y(gl.$$.fragment,s),y(Vs.$$.fragment,s),y(ul.$$.fragment,s),y(Ys.$$.fragment,s),y(zs.$$.fragment,s),y(ml.$$.fragment,s),y(Rs.$$.fragment,s),y(hl.$$.fragment,s),y(dl.$$.fragment,s),y(fl.$$.fragment,s),y(bl.$$.fragment,s),y(Ml.$$.fragment,s),y(jl.$$.fragment,s),y(Tl.$$.fragment,s),y(Xs.$$.fragment,s),y(Il.$$.fragment,s),y(Jl.$$.fragment,s),y(wl.$$.fragment,s),Zi=!0)},o(s){b(o.$$.fragment,s),b(Ls.$$.fragment,s),b(Ps.$$.fragment,s),b(Ks.$$.fragment,s),b(at.$$.fragment,s),b(ea.$$.fragment,s),b(lt.$$.fragment,s),b(na.$$.fragment,s),b(ot.$$.fragment,s),b(ta.$$.fragment,s),b(it.$$.fragment,s),b(rt.$$.fragment,s),b(ct.$$.fragment,s),b(pt.$$.fragment,s),b(gt.$$.fragment,s),b(ut.$$.fragment,s),b(mt.$$.fragment,s),b(sa.$$.fragment,s),b(ht.$$.fragment,s),b(aa.$$.fragment,s),b(dt.$$.fragment,s),b(la.$$.fragment,s),b(ft.$$.fragment,s),b(oa.$$.fragment,s),b(yt.$$.fragment,s),b(ia.$$.fragment,s),b(bt.$$.fragment,s),b(Mt.$$.fragment,s),b(ra.$$.fragment,s),b(jt.$$.fragment,s),b(ca.$$.fragment,s),b(_t.$$.fragment,s),b(pa.$$.fragment,s),b(Tt.$$.fragment,s),b(It.$$.fragment,s),b(ga.$$.fragment,s),b(Jt.$$.fragment,s),b(wt.$$.fragment,s),b(ua.$$.fragment,s),b(xt.$$.fragment,s),b(ma.$$.fragment,s),b(Ct.$$.fragment,s),b(Ut.$$.fragment,s),b($t.$$.fragment,s),b(ha.$$.fragment,s),b(kt.$$.fragment,s),b(vt.$$.fragment,s),b(da.$$.fragment,s),b(fa.$$.fragment,s),b(At.$$.fragment,s),b(ya.$$.fragment,s),b(Et.$$.fragment,s),b(ba.$$.fragment,s),b(Nt.$$.fragment,s),b(Ma.$$.fragment,s),b(Zt.$$.fragment,s),b(ja.$$.fragment,s),b(Wt.$$.fragment,s),b(_a.$$.fragment,s),b(Gt.$$.fragment,s),b(Ta.$$.fragment,s),b(Bt.$$.fragment,s),b(Ia.$$.fragment,s),b(Qt.$$.fragment,s),b(St.$$.fragment,s),b(Ja.$$.fragment,s),b(Vt.$$.fragment,s),b(Yt.$$.fragment,s),b(wa.$$.fragment,s),b(zt.$$.fragment,s),b(xa.$$.fragment,s),b(Rt.$$.fragment,s),b(Ca.$$.fragment,s),b(Xt.$$.fragment,s),b(Ft.$$.fragment,s),b(Ua.$$.fragment,s),b(Dt.$$.fragment,s),b($a.$$.fragment,s),b(Ot.$$.fragment,s),b(Ht.$$.fragment,s),b(ka.$$.fragment,s),b(Lt.$$.fragment,s),b(va.$$.fragment,s),b(Aa.$$.fragment,s),b(Ea.$$.fragment,s),b(Na.$$.fragment,s),b(Pt.$$.fragment,s),b(Za.$$.fragment,s),b(Kt.$$.fragment,s),b(Wa.$$.fragment,s),b(es.$$.fragment,s),b(Ga.$$.fragment,s),b(ns.$$.fragment,s),b(ts.$$.fragment,s),b(ss.$$.fragment,s),b(as.$$.fragment,s),b(ls.$$.fragment,s),b(os.$$.fragment,s),b(is.$$.fragment,s),b(Ba.$$.fragment,s),b(Qa.$$.fragment,s),b(rs.$$.fragment,s),b(Sa.$$.fragment,s),b(cs.$$.fragment,s),b(Va.$$.fragment,s),b(ps.$$.fragment,s),b(Ya.$$.fragment,s),b(gs.$$.fragment,s),b(za.$$.fragment,s),b(us.$$.fragment,s),b(ms.$$.fragment,s),b(Ra.$$.fragment,s),b(hs.$$.fragment,s),b(Xa.$$.fragment,s),b(ds.$$.fragment,s),b(Fa.$$.fragment,s),b(fs.$$.fragment,s),b(ys.$$.fragment,s),b(Da.$$.fragment,s),b(bs.$$.fragment,s),b(Ms.$$.fragment,s),b(Oa.$$.fragment,s),b(js.$$.fragment,s),b(Ha.$$.fragment,s),b(_s.$$.fragment,s),b(Ts.$$.fragment,s),b(Is.$$.fragment,s),b(La.$$.fragment,s),b(Js.$$.fragment,s),b(ws.$$.fragment,s),b(Pa.$$.fragment,s),b(Ka.$$.fragment,s),b(Cs.$$.fragment,s),b(el.$$.fragment,s),b(Us.$$.fragment,s),b(nl.$$.fragment,s),b($s.$$.fragment,s),b(tl.$$.fragment,s),b(ks.$$.fragment,s),b(sl.$$.fragment,s),b(vs.$$.fragment,s),b(al.$$.fragment,s),b(qs.$$.fragment,s),b(ll.$$.fragment,s),b(As.$$.fragment,s),b(ol.$$.fragment,s),b(Es.$$.fragment,s),b(Ns.$$.fragment,s),b(il.$$.fragment,s),b(Zs.$$.fragment,s),b(Ws.$$.fragment,s),b(rl.$$.fragment,s),b(Gs.$$.fragment,s),b(cl.$$.fragment,s),b(Bs.$$.fragment,s),b(pl.$$.fragment,s),b(Qs.$$.fragment,s),b(Ss.$$.fragment,s),b(gl.$$.fragment,s),b(Vs.$$.fragment,s),b(ul.$$.fragment,s),b(Ys.$$.fragment,s),b(zs.$$.fragment,s),b(ml.$$.fragment,s),b(Rs.$$.fragment,s),b(hl.$$.fragment,s),b(dl.$$.fragment,s),b(fl.$$.fragment,s),b(bl.$$.fragment,s),b(Ml.$$.fragment,s),b(jl.$$.fragment,s),b(Tl.$$.fragment,s),b(Xs.$$.fragment,s),b(Il.$$.fragment,s),b(Jl.$$.fragment,s),b(wl.$$.fragment,s),Zi=!1},d(s){s&&(g(p),g(a),g(t),g(e),g(c),g(yi),g(Os),g(bi),g(Hs),g(Mi),g(ji),g(U),g(_i),g(Ti),g(qa),g(Ii),g(Ji),g(x),g(wi),g(xi),g(jn),g(Ci),g(Ui),g(yl),g($i),g(ki),g(_n),g(vi),g(qi),g(_l),g(Ai),g(Y),g(Ei),g(Ni),g(fi)),g(n),M(o,s),M(Ls,s),M(Ps),M(Ks),M(at),M(ea),M(lt),M(na),M(ot),M(ta),M(it),M(rt),M(ct),M(pt),M(gt),M(ut),M(mt),M(sa),M(ht),M(aa),M(dt),M(la),M(ft),M(oa),M(yt),M(ia),M(bt),M(Mt),M(ra),M(jt),M(ca),M(_t),M(pa),M(Tt),M(It),M(ga),M(Jt),M(wt),M(ua),M(xt),M(ma),M(Ct),M(Ut),M($t),M(ha),M(kt),M(vt),M(da),M(fa),M(At),M(ya),M(Et),M(ba),M(Nt),M(Ma),M(Zt),M(ja),M(Wt),M(_a),M(Gt),M(Ta),M(Bt),M(Ia),M(Qt),M(St),M(Ja),M(Vt),M(Yt),M(wa),M(zt),M(xa),M(Rt),M(Ca),M(Xt),M(Ft),M(Ua),M(Dt),M($a),M(Ot),M(Ht),M(ka),M(Lt),M(va,s),M(Aa,s),M(Ea),M(Na),M(Pt),M(Za),M(Kt),M(Wa),M(es),M(Ga),M(ns),M(ts),M(ss),M(as),M(ls),M(os),M(is),M(Ba),M(Qa),M(rs),M(Sa),M(cs),M(Va),M(ps),M(Ya),M(gs),M(za),M(us),M(ms),M(Ra),M(hs),M(Xa),M(ds),M(Fa),M(fs),M(ys),M(Da),M(bs),M(Ms),M(Oa),M(js),M(Ha),M(_s),M(Ts),M(Is),M(La),M(Js),M(ws),M(Pa),M(Ka),M(Cs),M(el),M(Us),M(nl),M($s),M(tl),M(ks),M(sl),M(vs),M(al),M(qs),M(ll),M(As),M(ol),M(Es),M(Ns),M(il),M(Zs),M(Ws),M(rl),M(Gs),M(cl),M(Bs),M(pl),M(Qs),M(Ss),M(gl),M(Vs),M(ul),M(Ys),M(zs),M(ml),M(Rs),M(hl,s),M(dl),M(fl,s),M(bl,s),M(Ml),M(jl,s),M(Tl),M(Xs),M(Il),M(Jl),M(wl,s)}}}const wf='{"title":"추론","local":"inference","sections":[{"title":"추론 클라이언트","local":"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"비동기 추론 클라이언트","local":"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"추론 시간 초과 오류","local":"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError","sections":[],"depth":2},{"title":"반환 유형","local":"return-types","sections":[{"title":"모델 상태","local":"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"추론 API","local":"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function xf(T){return vh(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ef extends qh{constructor(n){super(),Ah(this,n,xf,Jf,kh,{})}}export{Ef as component};
