import{s as nd,n as rd,o as ud}from"../chunks/scheduler.b108d059.js";import{S as ad,i as pd,g as d,s as o,r as p,A as cd,h as n,f as l,c as s,j as a,u as c,x as r,k as u,y as fd,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.008de539.js";import{H as _,E as hd}from"../chunks/EditOnGithub.d1c48e3d.js";function md(Wo){let $,jt,wt,Et,T,Ot,v,Ut,g,Yo='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',Bt,R,Vo='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..isValidUrl"><code>~isValidUrl(string, [protocols], [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li></ul></li></ul></li>',Kt,Nt,qt,P,kt,y,It,C,Go="Helper function to get a file, using either the Fetch API or FileSystem API.",Jt,M,Qo='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',St,F,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",zt,Dt,Wt,H,Yt,L,Vt,x,Zo=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,Gt,w,es='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise</code> - A Promise that resolves with the file content as a buffer.<br/> <strong>Throws</strong>:',Qt,A,ts="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Xt,j,ls="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Zt,E,is='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',el,tl,ll,O,il,U,ol,B,os='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',sl,dl,nl,K,rl,N,ul,q,ss='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',al,pl,cl,k,fl,I,hl,J,ds='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',ml,bl,_l,S,$l,z,Tl,D,ns="Fetches a JSON file from a given path and file name.",vl,W,rs='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',gl,Y,us="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Rl,V,as="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Pl,yl,Cl,G,Ml,Q,Fl,X,ps='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Hl,Z,cs='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Ll,xl,wl,ee,Al,te,jl,le,fs="Creates a new <code>FileResponse</code> object.",El,ie,hs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code> | <code>URL</code></td></tr></tbody>",Ol,Ul,Bl,oe,Kl,se,Nl,de,ms="Mapping from file extensions to MIME types.",ql,ne,bs='<strong>Kind</strong>: instance property of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',kl,Il,Jl,re,Sl,ue,zl,ae,_s=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,Dl,pe,$s='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Wl,Yl,Vl,ce,Gl,fe,Ql,he,Ts="Clone the current FileResponse object.",Xl,me,vs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',Zl,ei,ti,be,li,_e,ii,$e,gs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,oi,Te,Rs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',si,ve,Ps="<li><code>Error</code> If the file cannot be read.</li>",di,ni,ri,ge,ui,Re,ai,Pe,ys=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,pi,ye,Cs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',ci,Ce,Ms="<li><code>Error</code> If the file cannot be read.</li>",fi,hi,mi,Me,bi,Fe,_i,He,Fs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,$i,Le,Hs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',Ti,xe,Ls="<li><code>Error</code> If the file cannot be read.</li>",vi,gi,Ri,we,Pi,Ae,yi,je,xs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Ci,Ee,ws='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Mi,Oe,As="<li><code>Error</code> If the file cannot be read.</li>",Fi,Hi,Li,Ue,xi,Be,wi,Ke,js='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Ai,Ne,Es='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',ji,Ei,Oi,qe,Ui,ke,Bi,Ie,Os="Instantiate a <code>FileCache</code> object.",Ki,Je,Us="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",Ni,qi,ki,Se,Ii,ze,Ji,De,Bs="Checks whether the given request is in the cache.",Si,We,Ks='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',zi,Ye,Ns="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",Di,Wi,Yi,Ve,Vi,Ge,Gi,Qe,qs="Adds the given response to the cache.",Qi,Xe,ks='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Xi,Ze,Is="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td> </tr><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td></tr></tbody>",Zi,eo,to,et,lo,tt,io,lt,Js="Determines whether the given string is a valid URL.",oo,it,Ss='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid URL, false otherwise.',so,ot,zs="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an URL.</p></td> </tr><tr><td>[protocols]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid protocols. If specified, the protocol must be in this list.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",no,ro,uo,st,ao,dt,po,nt,Ds="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",co,rt,Ws='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',fo,ut,Ys="<li><code>Error</code> If `fatal = false`.</li>",ho,at,Vs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",mo,bo,_o,pt,$o,ct,To,ft,Gs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',vo,ht,Qs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",go,Ro,Po,mt,yo,bt,Co,_t,Xs="Read and track progress when reading a Response object",Mo,$t,Zs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',Fo,Tt,ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>any</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>function</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Ho,Lo,xo,vt,wo,gt,Ao,Rt,td="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",jo,Pt,ld='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',Eo,yt,id="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Oo,Uo,Bo,Ct,Ko,Mt,No,Ft,od="Options for loading a pretrained model.",qo,Ht,sd='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',ko,Lt,dd=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[quantized]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to load the 8-bit quantized version of the model (only applicable when loading model files).</p></td> </tr><tr><td>[progress_callback]</td><td><code>function</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>Object</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td></tr></tbody>`,Io,Jo,So,xt,zo,At,Do;return v=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),y=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),L=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),N=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),I=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),z=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Q=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),te=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),se=new _({props:{title:"fileResponse._CONTENT_TYPE_MAP",local:"fileresponsecontenttypemap",headingTag:"h3"}}),ue=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),_e=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),Re=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Fe=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),Ae=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Be=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),ke=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),ze=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),Ge=new _({props:{title:"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response--code-promise--void--code",headingTag:"h3"}}),tt=new _({props:{title:"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code",headingTag:"h2"}}),dt=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),ct=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),bt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),gt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Mt=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),xt=new hd({props:{source:"https://github.com/xenova/transformers.js/blob/v2.17.2/docs/source/api/utils/hub.md"}}),{c(){$=d("meta"),jt=o(),wt=d("p"),Et=o(),T=d("a"),Ot=o(),p(v.$$.fragment),Ut=o(),g=d("p"),g.innerHTML=Yo,Bt=o(),R=d("ul"),R.innerHTML=Vo,Kt=o(),Nt=d("hr"),qt=o(),P=d("a"),kt=o(),p(y.$$.fragment),It=o(),C=d("p"),C.textContent=Go,Jt=o(),M=d("p"),M.innerHTML=Qo,St=o(),F=d("table"),F.innerHTML=Xo,zt=o(),Dt=d("hr"),Wt=o(),H=d("a"),Yt=o(),p(L.$$.fragment),Vt=o(),x=d("p"),x.innerHTML=Zo,Gt=o(),w=d("p"),w.innerHTML=es,Qt=o(),A=d("ul"),A.innerHTML=ts,Xt=o(),j=d("table"),j.innerHTML=ls,Zt=o(),E=d("ul"),E.innerHTML=is,el=o(),tl=d("hr"),ll=o(),O=d("a"),il=o(),p(U.$$.fragment),ol=o(),B=d("p"),B.innerHTML=os,sl=o(),dl=d("hr"),nl=o(),K=d("a"),rl=o(),p(N.$$.fragment),ul=o(),q=d("p"),q.innerHTML=ss,al=o(),pl=d("hr"),cl=o(),k=d("a"),fl=o(),p(I.$$.fragment),hl=o(),J=d("p"),J.innerHTML=ds,ml=o(),bl=d("hr"),_l=o(),S=d("a"),$l=o(),p(z.$$.fragment),Tl=o(),D=d("p"),D.textContent=ns,vl=o(),W=d("p"),W.innerHTML=rs,gl=o(),Y=d("ul"),Y.innerHTML=us,Rl=o(),V=d("table"),V.innerHTML=as,Pl=o(),yl=d("hr"),Cl=o(),G=d("a"),Ml=o(),p(Q.$$.fragment),Fl=o(),X=d("p"),X.innerHTML=ps,Hl=o(),Z=d("ul"),Z.innerHTML=cs,Ll=o(),xl=d("hr"),wl=o(),ee=d("a"),Al=o(),p(te.$$.fragment),jl=o(),le=d("p"),le.innerHTML=fs,El=o(),ie=d("table"),ie.innerHTML=hs,Ol=o(),Ul=d("hr"),Bl=o(),oe=d("a"),Kl=o(),p(se.$$.fragment),Nl=o(),de=d("p"),de.textContent=ms,ql=o(),ne=d("p"),ne.innerHTML=bs,kl=o(),Il=d("hr"),Jl=o(),re=d("a"),Sl=o(),p(ue.$$.fragment),zl=o(),ae=d("p"),ae.textContent=_s,Dl=o(),pe=d("p"),pe.innerHTML=$s,Wl=o(),Yl=d("hr"),Vl=o(),ce=d("a"),Gl=o(),p(fe.$$.fragment),Ql=o(),he=d("p"),he.textContent=Ts,Xl=o(),me=d("p"),me.innerHTML=vs,Zl=o(),ei=d("hr"),ti=o(),be=d("a"),li=o(),p(_e.$$.fragment),ii=o(),$e=d("p"),$e.textContent=gs,oi=o(),Te=d("p"),Te.innerHTML=Rs,si=o(),ve=d("ul"),ve.innerHTML=Ps,di=o(),ni=d("hr"),ri=o(),ge=d("a"),ui=o(),p(Re.$$.fragment),ai=o(),Pe=d("p"),Pe.textContent=ys,pi=o(),ye=d("p"),ye.innerHTML=Cs,ci=o(),Ce=d("ul"),Ce.innerHTML=Ms,fi=o(),hi=d("hr"),mi=o(),Me=d("a"),bi=o(),p(Fe.$$.fragment),_i=o(),He=d("p"),He.textContent=Fs,$i=o(),Le=d("p"),Le.innerHTML=Hs,Ti=o(),xe=d("ul"),xe.innerHTML=Ls,vi=o(),gi=d("hr"),Ri=o(),we=d("a"),Pi=o(),p(Ae.$$.fragment),yi=o(),je=d("p"),je.textContent=xs,Ci=o(),Ee=d("p"),Ee.innerHTML=ws,Mi=o(),Oe=d("ul"),Oe.innerHTML=As,Fi=o(),Hi=d("hr"),Li=o(),Ue=d("a"),xi=o(),p(Be.$$.fragment),wi=o(),Ke=d("p"),Ke.innerHTML=js,Ai=o(),Ne=d("ul"),Ne.innerHTML=Es,ji=o(),Ei=d("hr"),Oi=o(),qe=d("a"),Ui=o(),p(ke.$$.fragment),Bi=o(),Ie=d("p"),Ie.innerHTML=Os,Ki=o(),Je=d("table"),Je.innerHTML=Us,Ni=o(),qi=d("hr"),ki=o(),Se=d("a"),Ii=o(),p(ze.$$.fragment),Ji=o(),De=d("p"),De.textContent=Bs,Si=o(),We=d("p"),We.innerHTML=Ks,zi=o(),Ye=d("table"),Ye.innerHTML=Ns,Di=o(),Wi=d("hr"),Yi=o(),Ve=d("a"),Vi=o(),p(Ge.$$.fragment),Gi=o(),Qe=d("p"),Qe.textContent=qs,Qi=o(),Xe=d("p"),Xe.innerHTML=ks,Xi=o(),Ze=d("table"),Ze.innerHTML=Is,Zi=o(),eo=d("hr"),to=o(),et=d("a"),lo=o(),p(tt.$$.fragment),io=o(),lt=d("p"),lt.textContent=Js,oo=o(),it=d("p"),it.innerHTML=Ss,so=o(),ot=d("table"),ot.innerHTML=zs,no=o(),ro=d("hr"),uo=o(),st=d("a"),ao=o(),p(dt.$$.fragment),po=o(),nt=d("p"),nt.textContent=Ds,co=o(),rt=d("p"),rt.innerHTML=Ws,fo=o(),ut=d("ul"),ut.innerHTML=Ys,ho=o(),at=d("table"),at.innerHTML=Vs,mo=o(),bo=d("hr"),_o=o(),pt=d("a"),$o=o(),p(ct.$$.fragment),To=o(),ft=d("p"),ft.innerHTML=Gs,vo=o(),ht=d("table"),ht.innerHTML=Qs,go=o(),Ro=d("hr"),Po=o(),mt=d("a"),yo=o(),p(bt.$$.fragment),Co=o(),_t=d("p"),_t.textContent=Xs,Mo=o(),$t=d("p"),$t.innerHTML=Zs,Fo=o(),Tt=d("table"),Tt.innerHTML=ed,Ho=o(),Lo=d("hr"),xo=o(),vt=d("a"),wo=o(),p(gt.$$.fragment),Ao=o(),Rt=d("p"),Rt.textContent=td,jo=o(),Pt=d("p"),Pt.innerHTML=ld,Eo=o(),yt=d("table"),yt.innerHTML=id,Oo=o(),Uo=d("hr"),Bo=o(),Ct=d("a"),Ko=o(),p(Mt.$$.fragment),No=o(),Ft=d("p"),Ft.textContent=od,qo=o(),Ht=d("p"),Ht.innerHTML=sd,ko=o(),Lt=d("table"),Lt.innerHTML=dd,Io=o(),Jo=d("hr"),So=o(),p(xt.$$.fragment),zo=o(),At=d("p"),this.h()},l(e){const t=cd("svelte-u9bgzb",document.head);$=n(t,"META",{name:!0,content:!0}),t.forEach(l),jt=s(e),wt=n(e,"P",{}),a(wt).forEach(l),Et=s(e),T=n(e,"A",{id:!0,class:!0}),a(T).forEach(l),Ot=s(e),c(v.$$.fragment,e),Ut=s(e),g=n(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1jxl61c"&&(g.innerHTML=Yo),Bt=s(e),R=n(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-jptjy4"&&(R.innerHTML=Vo),Kt=s(e),Nt=n(e,"HR",{}),qt=s(e),P=n(e,"A",{id:!0,class:!0}),a(P).forEach(l),kt=s(e),c(y.$$.fragment,e),It=s(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10mshiw"&&(C.textContent=Go),Jt=s(e),M=n(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1jj7eze"&&(M.innerHTML=Qo),St=s(e),F=n(e,"TABLE",{"data-svelte-h":!0}),r(F)!=="svelte-pbwhgs"&&(F.innerHTML=Xo),zt=s(e),Dt=n(e,"HR",{}),Wt=s(e),H=n(e,"A",{id:!0,class:!0}),a(H).forEach(l),Yt=s(e),c(L.$$.fragment,e),Vt=s(e),x=n(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l3bjq3"&&(x.innerHTML=Zo),Gt=s(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1rwfklh"&&(w.innerHTML=es),Qt=s(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=ts),Xt=s(e),j=n(e,"TABLE",{"data-svelte-h":!0}),r(j)!=="svelte-1o6u9nv"&&(j.innerHTML=ls),Zt=s(e),E=n(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xatn75"&&(E.innerHTML=is),el=s(e),tl=n(e,"HR",{}),ll=s(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(l),il=s(e),c(U.$$.fragment,e),ol=s(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=os),sl=s(e),dl=n(e,"HR",{}),nl=s(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(l),rl=s(e),c(N.$$.fragment,e),ul=s(e),q=n(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ys3w38"&&(q.innerHTML=ss),al=s(e),pl=n(e,"HR",{}),cl=s(e),k=n(e,"A",{id:!0,class:!0}),a(k).forEach(l),fl=s(e),c(I.$$.fragment,e),hl=s(e),J=n(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ys3w38"&&(J.innerHTML=ds),ml=s(e),bl=n(e,"HR",{}),_l=s(e),S=n(e,"A",{id:!0,class:!0}),a(S).forEach(l),$l=s(e),c(z.$$.fragment,e),Tl=s(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1en2wh4"&&(D.textContent=ns),vl=s(e),W=n(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1l5qo0i"&&(W.innerHTML=rs),gl=s(e),Y=n(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-jl6z4b"&&(Y.innerHTML=us),Rl=s(e),V=n(e,"TABLE",{"data-svelte-h":!0}),r(V)!=="svelte-1iel3tk"&&(V.innerHTML=as),Pl=s(e),yl=n(e,"HR",{}),Cl=s(e),G=n(e,"A",{id:!0,class:!0}),a(G).forEach(l),Ml=s(e),c(Q.$$.fragment,e),Fl=s(e),X=n(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16uuos4"&&(X.innerHTML=ps),Hl=s(e),Z=n(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-165ijwb"&&(Z.innerHTML=cs),Ll=s(e),xl=n(e,"HR",{}),wl=s(e),ee=n(e,"A",{id:!0,class:!0}),a(ee).forEach(l),Al=s(e),c(te.$$.fragment,e),jl=s(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zzl0lp"&&(le.innerHTML=fs),El=s(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1y2k5ta"&&(ie.innerHTML=hs),Ol=s(e),Ul=n(e,"HR",{}),Bl=s(e),oe=n(e,"A",{id:!0,class:!0}),a(oe).forEach(l),Kl=s(e),c(se.$$.fragment,e),Nl=s(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-15u13r6"&&(de.textContent=ms),ql=s(e),ne=n(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-g2qxul"&&(ne.innerHTML=bs),kl=s(e),Il=n(e,"HR",{}),Jl=s(e),re=n(e,"A",{id:!0,class:!0}),a(re).forEach(l),Sl=s(e),c(ue.$$.fragment,e),zl=s(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1u1tjx3"&&(ae.textContent=_s),Dl=s(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1sowe6d"&&(pe.innerHTML=$s),Wl=s(e),Yl=n(e,"HR",{}),Vl=s(e),ce=n(e,"A",{id:!0,class:!0}),a(ce).forEach(l),Gl=s(e),c(fe.$$.fragment,e),Ql=s(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-d8j2xp"&&(he.textContent=Ts),Xl=s(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-8jlahc"&&(me.innerHTML=vs),Zl=s(e),ei=n(e,"HR",{}),ti=s(e),be=n(e,"A",{id:!0,class:!0}),a(be).forEach(l),li=s(e),c(_e.$$.fragment,e),ii=s(e),$e=n(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1a8fecx"&&($e.textContent=gs),oi=s(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-v2f2ae"&&(Te.innerHTML=Rs),si=s(e),ve=n(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-1f4f3jw"&&(ve.innerHTML=Ps),di=s(e),ni=n(e,"HR",{}),ri=s(e),ge=n(e,"A",{id:!0,class:!0}),a(ge).forEach(l),ui=s(e),c(Re.$$.fragment,e),ai=s(e),Pe=n(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-h3zv97"&&(Pe.textContent=ys),pi=s(e),ye=n(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1e723py"&&(ye.innerHTML=Cs),ci=s(e),Ce=n(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1f4f3jw"&&(Ce.innerHTML=Ms),fi=s(e),hi=n(e,"HR",{}),mi=s(e),Me=n(e,"A",{id:!0,class:!0}),a(Me).forEach(l),bi=s(e),c(Fe.$$.fragment,e),_i=s(e),He=n(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-jd4zuh"&&(He.textContent=Fs),$i=s(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ozy582"&&(Le.innerHTML=Hs),Ti=s(e),xe=n(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-1f4f3jw"&&(xe.innerHTML=Ls),vi=s(e),gi=n(e,"HR",{}),Ri=s(e),we=n(e,"A",{id:!0,class:!0}),a(we).forEach(l),Pi=s(e),c(Ae.$$.fragment,e),yi=s(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-cd4397"&&(je.textContent=xs),Ci=s(e),Ee=n(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-j83voe"&&(Ee.innerHTML=ws),Mi=s(e),Oe=n(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-1f4f3jw"&&(Oe.innerHTML=As),Fi=s(e),Hi=n(e,"HR",{}),Li=s(e),Ue=n(e,"A",{id:!0,class:!0}),a(Ue).forEach(l),xi=s(e),c(Be.$$.fragment,e),wi=s(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-16uuos4"&&(Ke.innerHTML=js),Ai=s(e),Ne=n(e,"UL",{"data-svelte-h":!0}),r(Ne)!=="svelte-136j1yr"&&(Ne.innerHTML=Es),ji=s(e),Ei=n(e,"HR",{}),Oi=s(e),qe=n(e,"A",{id:!0,class:!0}),a(qe).forEach(l),Ui=s(e),c(ke.$$.fragment,e),Bi=s(e),Ie=n(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-pake4r"&&(Ie.innerHTML=Os),Ki=s(e),Je=n(e,"TABLE",{"data-svelte-h":!0}),r(Je)!=="svelte-f03x1m"&&(Je.innerHTML=Us),Ni=s(e),qi=n(e,"HR",{}),ki=s(e),Se=n(e,"A",{id:!0,class:!0}),a(Se).forEach(l),Ii=s(e),c(ze.$$.fragment,e),Ji=s(e),De=n(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-13oc2rp"&&(De.textContent=Bs),Si=s(e),We=n(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wxlxpn"&&(We.innerHTML=Ks),zi=s(e),Ye=n(e,"TABLE",{"data-svelte-h":!0}),r(Ye)!=="svelte-2kmk06"&&(Ye.innerHTML=Ns),Di=s(e),Wi=n(e,"HR",{}),Yi=s(e),Ve=n(e,"A",{id:!0,class:!0}),a(Ve).forEach(l),Vi=s(e),c(Ge.$$.fragment,e),Gi=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-bwoz3v"&&(Qe.textContent=qs),Qi=s(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1wxlxpn"&&(Xe.innerHTML=ks),Xi=s(e),Ze=n(e,"TABLE",{"data-svelte-h":!0}),r(Ze)!=="svelte-yj5tj6"&&(Ze.innerHTML=Is),Zi=s(e),eo=n(e,"HR",{}),to=s(e),et=n(e,"A",{id:!0,class:!0}),a(et).forEach(l),lo=s(e),c(tt.$$.fragment,e),io=s(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-fkm19c"&&(lt.textContent=Js),oo=s(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-xyh2rt"&&(it.innerHTML=Ss),so=s(e),ot=n(e,"TABLE",{"data-svelte-h":!0}),r(ot)!=="svelte-mnoe75"&&(ot.innerHTML=zs),no=s(e),ro=n(e,"HR",{}),uo=s(e),st=n(e,"A",{id:!0,class:!0}),a(st).forEach(l),ao=s(e),c(dt.$$.fragment,e),po=s(e),nt=n(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-112gzs0"&&(nt.textContent=Ds),co=s(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-9i72aw"&&(rt.innerHTML=Ws),fo=s(e),ut=n(e,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-w7pu3"&&(ut.innerHTML=Ys),ho=s(e),at=n(e,"TABLE",{"data-svelte-h":!0}),r(at)!=="svelte-bpbhxc"&&(at.innerHTML=Vs),mo=s(e),bo=n(e,"HR",{}),_o=s(e),pt=n(e,"A",{id:!0,class:!0}),a(pt).forEach(l),$o=s(e),c(ct.$$.fragment,e),To=s(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1h1o1yf"&&(ft.innerHTML=Gs),vo=s(e),ht=n(e,"TABLE",{"data-svelte-h":!0}),r(ht)!=="svelte-17sk6uf"&&(ht.innerHTML=Qs),go=s(e),Ro=n(e,"HR",{}),Po=s(e),mt=n(e,"A",{id:!0,class:!0}),a(mt).forEach(l),yo=s(e),c(bt.$$.fragment,e),Co=s(e),_t=n(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1tqccie"&&(_t.textContent=Xs),Mo=s(e),$t=n(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-dyyw29"&&($t.innerHTML=Zs),Fo=s(e),Tt=n(e,"TABLE",{"data-svelte-h":!0}),r(Tt)!=="svelte-13fau3m"&&(Tt.innerHTML=ed),Ho=s(e),Lo=n(e,"HR",{}),xo=s(e),vt=n(e,"A",{id:!0,class:!0}),a(vt).forEach(l),wo=s(e),c(gt.$$.fragment,e),Ao=s(e),Rt=n(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-7vbcne"&&(Rt.textContent=td),jo=s(e),Pt=n(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-wjfx67"&&(Pt.innerHTML=ld),Eo=s(e),yt=n(e,"TABLE",{"data-svelte-h":!0}),r(yt)!=="svelte-61qi9d"&&(yt.innerHTML=id),Oo=s(e),Uo=n(e,"HR",{}),Bo=s(e),Ct=n(e,"A",{id:!0,class:!0}),a(Ct).forEach(l),Ko=s(e),c(Mt.$$.fragment,e),No=s(e),Ft=n(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1oi15lr"&&(Ft.textContent=od),qo=s(e),Ht=n(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-121rdz"&&(Ht.innerHTML=sd),ko=s(e),Lt=n(e,"TABLE",{"data-svelte-h":!0}),r(Lt)!=="svelte-1kbnzqd"&&(Lt.innerHTML=dd),Io=s(e),Jo=n(e,"HR",{}),So=s(e),c(xt.$$.fragment,e),zo=s(e),At=n(e,"P",{}),a(At).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",bd),u(T,"id","module_utils/hub"),u(T,"class","group"),u(P,"id","module_utils/hub.getFile"),u(P,"class","group"),u(H,"id","module_utils/hub.getModelFile"),u(H,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(k,"id","module_utils/hub.getModelFile..buffer"),u(k,"class","group"),u(S,"id","module_utils/hub.getModelJSON"),u(S,"class","group"),u(G,"id","module_utils/hub..FileResponse"),u(G,"class","group"),u(ee,"id","new_module_utils/hub..FileResponse_new"),u(ee,"class","group"),u(oe,"id","module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"),u(oe,"class","group"),u(re,"id","module_utils/hub..FileResponse+updateContentType"),u(re,"class","group"),u(ce,"id","module_utils/hub..FileResponse+clone"),u(ce,"class","group"),u(be,"id","module_utils/hub..FileResponse+arrayBuffer"),u(be,"class","group"),u(ge,"id","module_utils/hub..FileResponse+blob"),u(ge,"class","group"),u(Me,"id","module_utils/hub..FileResponse+text"),u(Me,"class","group"),u(we,"id","module_utils/hub..FileResponse+json"),u(we,"class","group"),u(Ue,"id","module_utils/hub..FileCache"),u(Ue,"class","group"),u(qe,"id","new_module_utils/hub..FileCache_new"),u(qe,"class","group"),u(Se,"id","module_utils/hub..FileCache+match"),u(Se,"class","group"),u(Ve,"id","module_utils/hub..FileCache+put"),u(Ve,"class","group"),u(et,"id","module_utils/hub..isValidUrl"),u(et,"class","group"),u(st,"id","module_utils/hub..handleError"),u(st,"class","group"),u(pt,"id","module_utils/hub..tryCache"),u(pt,"class","group"),u(mt,"id","module_utils/hub..readResponse"),u(mt,"class","group"),u(vt,"id","module_utils/hub..pathJoin"),u(vt,"class","group"),u(Ct,"id","module_utils/hub..PretrainedOptions"),u(Ct,"class","group")},m(e,t){fd(document.head,$),i(e,jt,t),i(e,wt,t),i(e,Et,t),i(e,T,t),i(e,Ot,t),f(v,e,t),i(e,Ut,t),i(e,g,t),i(e,Bt,t),i(e,R,t),i(e,Kt,t),i(e,Nt,t),i(e,qt,t),i(e,P,t),i(e,kt,t),f(y,e,t),i(e,It,t),i(e,C,t),i(e,Jt,t),i(e,M,t),i(e,St,t),i(e,F,t),i(e,zt,t),i(e,Dt,t),i(e,Wt,t),i(e,H,t),i(e,Yt,t),f(L,e,t),i(e,Vt,t),i(e,x,t),i(e,Gt,t),i(e,w,t),i(e,Qt,t),i(e,A,t),i(e,Xt,t),i(e,j,t),i(e,Zt,t),i(e,E,t),i(e,el,t),i(e,tl,t),i(e,ll,t),i(e,O,t),i(e,il,t),f(U,e,t),i(e,ol,t),i(e,B,t),i(e,sl,t),i(e,dl,t),i(e,nl,t),i(e,K,t),i(e,rl,t),f(N,e,t),i(e,ul,t),i(e,q,t),i(e,al,t),i(e,pl,t),i(e,cl,t),i(e,k,t),i(e,fl,t),f(I,e,t),i(e,hl,t),i(e,J,t),i(e,ml,t),i(e,bl,t),i(e,_l,t),i(e,S,t),i(e,$l,t),f(z,e,t),i(e,Tl,t),i(e,D,t),i(e,vl,t),i(e,W,t),i(e,gl,t),i(e,Y,t),i(e,Rl,t),i(e,V,t),i(e,Pl,t),i(e,yl,t),i(e,Cl,t),i(e,G,t),i(e,Ml,t),f(Q,e,t),i(e,Fl,t),i(e,X,t),i(e,Hl,t),i(e,Z,t),i(e,Ll,t),i(e,xl,t),i(e,wl,t),i(e,ee,t),i(e,Al,t),f(te,e,t),i(e,jl,t),i(e,le,t),i(e,El,t),i(e,ie,t),i(e,Ol,t),i(e,Ul,t),i(e,Bl,t),i(e,oe,t),i(e,Kl,t),f(se,e,t),i(e,Nl,t),i(e,de,t),i(e,ql,t),i(e,ne,t),i(e,kl,t),i(e,Il,t),i(e,Jl,t),i(e,re,t),i(e,Sl,t),f(ue,e,t),i(e,zl,t),i(e,ae,t),i(e,Dl,t),i(e,pe,t),i(e,Wl,t),i(e,Yl,t),i(e,Vl,t),i(e,ce,t),i(e,Gl,t),f(fe,e,t),i(e,Ql,t),i(e,he,t),i(e,Xl,t),i(e,me,t),i(e,Zl,t),i(e,ei,t),i(e,ti,t),i(e,be,t),i(e,li,t),f(_e,e,t),i(e,ii,t),i(e,$e,t),i(e,oi,t),i(e,Te,t),i(e,si,t),i(e,ve,t),i(e,di,t),i(e,ni,t),i(e,ri,t),i(e,ge,t),i(e,ui,t),f(Re,e,t),i(e,ai,t),i(e,Pe,t),i(e,pi,t),i(e,ye,t),i(e,ci,t),i(e,Ce,t),i(e,fi,t),i(e,hi,t),i(e,mi,t),i(e,Me,t),i(e,bi,t),f(Fe,e,t),i(e,_i,t),i(e,He,t),i(e,$i,t),i(e,Le,t),i(e,Ti,t),i(e,xe,t),i(e,vi,t),i(e,gi,t),i(e,Ri,t),i(e,we,t),i(e,Pi,t),f(Ae,e,t),i(e,yi,t),i(e,je,t),i(e,Ci,t),i(e,Ee,t),i(e,Mi,t),i(e,Oe,t),i(e,Fi,t),i(e,Hi,t),i(e,Li,t),i(e,Ue,t),i(e,xi,t),f(Be,e,t),i(e,wi,t),i(e,Ke,t),i(e,Ai,t),i(e,Ne,t),i(e,ji,t),i(e,Ei,t),i(e,Oi,t),i(e,qe,t),i(e,Ui,t),f(ke,e,t),i(e,Bi,t),i(e,Ie,t),i(e,Ki,t),i(e,Je,t),i(e,Ni,t),i(e,qi,t),i(e,ki,t),i(e,Se,t),i(e,Ii,t),f(ze,e,t),i(e,Ji,t),i(e,De,t),i(e,Si,t),i(e,We,t),i(e,zi,t),i(e,Ye,t),i(e,Di,t),i(e,Wi,t),i(e,Yi,t),i(e,Ve,t),i(e,Vi,t),f(Ge,e,t),i(e,Gi,t),i(e,Qe,t),i(e,Qi,t),i(e,Xe,t),i(e,Xi,t),i(e,Ze,t),i(e,Zi,t),i(e,eo,t),i(e,to,t),i(e,et,t),i(e,lo,t),f(tt,e,t),i(e,io,t),i(e,lt,t),i(e,oo,t),i(e,it,t),i(e,so,t),i(e,ot,t),i(e,no,t),i(e,ro,t),i(e,uo,t),i(e,st,t),i(e,ao,t),f(dt,e,t),i(e,po,t),i(e,nt,t),i(e,co,t),i(e,rt,t),i(e,fo,t),i(e,ut,t),i(e,ho,t),i(e,at,t),i(e,mo,t),i(e,bo,t),i(e,_o,t),i(e,pt,t),i(e,$o,t),f(ct,e,t),i(e,To,t),i(e,ft,t),i(e,vo,t),i(e,ht,t),i(e,go,t),i(e,Ro,t),i(e,Po,t),i(e,mt,t),i(e,yo,t),f(bt,e,t),i(e,Co,t),i(e,_t,t),i(e,Mo,t),i(e,$t,t),i(e,Fo,t),i(e,Tt,t),i(e,Ho,t),i(e,Lo,t),i(e,xo,t),i(e,vt,t),i(e,wo,t),f(gt,e,t),i(e,Ao,t),i(e,Rt,t),i(e,jo,t),i(e,Pt,t),i(e,Eo,t),i(e,yt,t),i(e,Oo,t),i(e,Uo,t),i(e,Bo,t),i(e,Ct,t),i(e,Ko,t),f(Mt,e,t),i(e,No,t),i(e,Ft,t),i(e,qo,t),i(e,Ht,t),i(e,ko,t),i(e,Lt,t),i(e,Io,t),i(e,Jo,t),i(e,So,t),f(xt,e,t),i(e,zo,t),i(e,At,t),Do=!0},p:rd,i(e){Do||(h(v.$$.fragment,e),h(y.$$.fragment,e),h(L.$$.fragment,e),h(U.$$.fragment,e),h(N.$$.fragment,e),h(I.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(Re.$$.fragment,e),h(Fe.$$.fragment,e),h(Ae.$$.fragment,e),h(Be.$$.fragment,e),h(ke.$$.fragment,e),h(ze.$$.fragment,e),h(Ge.$$.fragment,e),h(tt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(gt.$$.fragment,e),h(Mt.$$.fragment,e),h(xt.$$.fragment,e),Do=!0)},o(e){m(v.$$.fragment,e),m(y.$$.fragment,e),m(L.$$.fragment,e),m(U.$$.fragment,e),m(N.$$.fragment,e),m(I.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(Re.$$.fragment,e),m(Fe.$$.fragment,e),m(Ae.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(ze.$$.fragment,e),m(Ge.$$.fragment,e),m(tt.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(bt.$$.fragment,e),m(gt.$$.fragment,e),m(Mt.$$.fragment,e),m(xt.$$.fragment,e),Do=!1},d(e){e&&(l(jt),l(wt),l(Et),l(T),l(Ot),l(Ut),l(g),l(Bt),l(R),l(Kt),l(Nt),l(qt),l(P),l(kt),l(It),l(C),l(Jt),l(M),l(St),l(F),l(zt),l(Dt),l(Wt),l(H),l(Yt),l(Vt),l(x),l(Gt),l(w),l(Qt),l(A),l(Xt),l(j),l(Zt),l(E),l(el),l(tl),l(ll),l(O),l(il),l(ol),l(B),l(sl),l(dl),l(nl),l(K),l(rl),l(ul),l(q),l(al),l(pl),l(cl),l(k),l(fl),l(hl),l(J),l(ml),l(bl),l(_l),l(S),l($l),l(Tl),l(D),l(vl),l(W),l(gl),l(Y),l(Rl),l(V),l(Pl),l(yl),l(Cl),l(G),l(Ml),l(Fl),l(X),l(Hl),l(Z),l(Ll),l(xl),l(wl),l(ee),l(Al),l(jl),l(le),l(El),l(ie),l(Ol),l(Ul),l(Bl),l(oe),l(Kl),l(Nl),l(de),l(ql),l(ne),l(kl),l(Il),l(Jl),l(re),l(Sl),l(zl),l(ae),l(Dl),l(pe),l(Wl),l(Yl),l(Vl),l(ce),l(Gl),l(Ql),l(he),l(Xl),l(me),l(Zl),l(ei),l(ti),l(be),l(li),l(ii),l($e),l(oi),l(Te),l(si),l(ve),l(di),l(ni),l(ri),l(ge),l(ui),l(ai),l(Pe),l(pi),l(ye),l(ci),l(Ce),l(fi),l(hi),l(mi),l(Me),l(bi),l(_i),l(He),l($i),l(Le),l(Ti),l(xe),l(vi),l(gi),l(Ri),l(we),l(Pi),l(yi),l(je),l(Ci),l(Ee),l(Mi),l(Oe),l(Fi),l(Hi),l(Li),l(Ue),l(xi),l(wi),l(Ke),l(Ai),l(Ne),l(ji),l(Ei),l(Oi),l(qe),l(Ui),l(Bi),l(Ie),l(Ki),l(Je),l(Ni),l(qi),l(ki),l(Se),l(Ii),l(Ji),l(De),l(Si),l(We),l(zi),l(Ye),l(Di),l(Wi),l(Yi),l(Ve),l(Vi),l(Gi),l(Qe),l(Qi),l(Xe),l(Xi),l(Ze),l(Zi),l(eo),l(to),l(et),l(lo),l(io),l(lt),l(oo),l(it),l(so),l(ot),l(no),l(ro),l(uo),l(st),l(ao),l(po),l(nt),l(co),l(rt),l(fo),l(ut),l(ho),l(at),l(mo),l(bo),l(_o),l(pt),l($o),l(To),l(ft),l(vo),l(ht),l(go),l(Ro),l(Po),l(mt),l(yo),l(Co),l(_t),l(Mo),l($t),l(Fo),l(Tt),l(Ho),l(Lo),l(xo),l(vt),l(wo),l(Ao),l(Rt),l(jo),l(Pt),l(Eo),l(yt),l(Oo),l(Uo),l(Bo),l(Ct),l(Ko),l(No),l(Ft),l(qo),l(Ht),l(ko),l(Lt),l(Io),l(Jo),l(So),l(zo),l(At)),l($),b(v,e),b(y,e),b(L,e),b(U,e),b(N,e),b(I,e),b(z,e),b(Q,e),b(te,e),b(se,e),b(ue,e),b(fe,e),b(_e,e),b(Re,e),b(Fe,e),b(Ae,e),b(Be,e),b(ke,e),b(ze,e),b(Ge,e),b(tt,e),b(dt,e),b(ct,e),b(bt,e),b(gt,e),b(Mt,e),b(xt,e)}}}const bd='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse._CONTENT_TYPE_MAP","local":"fileresponsecontenttypemap","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2}],"depth":1}';function _d(Wo){return ud(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gd extends ad{constructor($){super(),pd(this,$,_d,md,nd,{})}}export{gd as component};
