import{s as ql,n as Sl,o as El}from"../chunks/scheduler.9680c161.js";import{S as Wl,i as Al,g as M,s as n,r as i,A as kl,h as o,f as e,c as a,j as Ql,u as p,x as U,k as Zl,y as $l,a as t,v as y,d as J,t as u,w as T}from"../chunks/index.38d74ee1.js";import{C as X}from"../chunks/CodeBlock.1371964c.js";import{H as r}from"../chunks/Heading.74c51a96.js";function Vl(wl){let c,z,v,R,w,_,j,jl="Text Generation Inference (TGI) now supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. This feature is available starting from version 1.4.0. You can use OpenAI’s client libraries or third-party libraries expecting OpenAI schema to interact with TGI’s Messages API. Below are some examples of how to utilize this compatibility.",H,m,ml="<p><strong>Note:</strong> The Messages API is supported from TGI version 1.4.0 and above. Ensure you are using a compatible version to access this feature.</p>",F,I,L,h,Il='<li><a href="#making-a-request">Making a Request</a></li> <li><a href="#streaming">Streaming</a></li> <li><a href="#synchronous">Synchronous</a></li> <li><a href="#hugging-face-inference-endpoints">Hugging Face Inference Endpoints</a></li> <li><a href="#cloud-providers">Cloud Providers</a><ul><li><a href="#amazon-sagemaker">Amazon SageMaker</a></li></ul></li>',P,d,D,g,hl="You can make a request to TGI’s Messages API using <code>curl</code>. Here’s an example:",O,C,K,b,ll,B,dl="You can also use OpenAI’s Python client library to make a streaming request. Here’s how:",sl,f,el,G,tl,Q,gl="If you prefer to make a synchronous request, you can do so like this:",nl,Z,al,q,Ml,S,Cl=`The Messages API is integrated with <a href="https://huggingface.co/inference-endpoints/dedicated" rel="nofollow">Inference Endpoints</a>.
Every endpoint that uses “Text Generation Inference” with an LLM, which has a chat template can now be used. Below is an example of how to use IE with TGI using OpenAI’s Python client library:`,ol,E,bl="<p><strong>Note:</strong> Make sure to replace <code>base_url</code> with your endpoint URL and to include <code>v1/</code> at the end of the URL. The <code>api_key</code> should be replaced with your Hugging Face API key.</p>",il,W,pl,A,yl,k,Bl="TGI can be deployed on various cloud providers for scalable and robust text generation. One such provider is Amazon SageMaker, which has recently added support for TGI. Here’s how you can deploy TGI on Amazon SageMaker:",Jl,$,ul,V,fl="To enable the Messages API in Amazon SageMaker you need to set the environment variable <code>MESSAGES_API_ENABLED=true</code>.",Tl,N,Gl="This will modify the <code>/invocations</code> route to accept Messages dictonaries consisting out of role and content. See the example below on how to deploy Llama with the new Messages API.",Ul,Y,cl,x,rl;return w=new r({props:{title:"Messages API",local:"messages-api",headingTag:"h1"}}),I=new r({props:{title:"Table of Contents",local:"table-of-contents",headingTag:"h4"}}),d=new r({props:{title:"Making a Request",local:"making-a-request",headingTag:"h2"}}),C=new X({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTMwMDAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:3000/v1/chat/completions \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;model&quot;: &quot;tgi&quot;,
  &quot;messages&quot;: [
    {
      &quot;role&quot;: &quot;system&quot;,
      &quot;content&quot;: &quot;You are a helpful assistant.&quot;
    },
    {
      &quot;role&quot;: &quot;user&quot;,
      &quot;content&quot;: &quot;What is deep learning?&quot;
    }
  ],
  &quot;stream&quot;: true,
  &quot;max_tokens&quot;: 20
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),b=new r({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),f=new X({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMEEpJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMGFuZCUyMHByaW50JTIwc3RyZWFtJTBBZm9yJTIwbWVzc2FnZSUyMGluJTIwY2hhdF9jb21wbGV0aW9uJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobWVzc2FnZSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message)`,wrap:!1}}),G=new r({props:{title:"Synchronous",local:"synchronous",headingTag:"h2"}}),Z=new X({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzREZhbHNlJTBBKSUwQSUwQXByaW50KGNoYXRfY29tcGxldGlvbik=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(chat_completion)`,wrap:!1}}),q=new r({props:{title:"Hugging Face Inference Endpoints",local:"hugging-face-inference-endpoints",headingTag:"h2"}}),W=new X({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwZW5kcG9pbnQlMjB1cmwlMkMlMjBtYWtlJTIwc3VyZSUyMHRvJTIwaW5jbHVkZSUyMCUyMnYxJTJGJTIyJTIwYXQlMjB0aGUlMjBlbmQlMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGdmx6ejEwZXEzZm9sMzQyOS51cy1lYXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwQVBJJTIwa2V5JTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmX1hYWCUyMiUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    <span class="hljs-comment"># replace with your endpoint url, make sure to include &quot;v1/&quot; at the end</span>
    base_url=<span class="hljs-string">&quot;https://vlzz10eq3fol3429.us-east-1.aws.endpoints.huggingface.cloud/v1/&quot;</span>,
    <span class="hljs-comment"># replace with your API key</span>
    api_key=<span class="hljs-string">&quot;hf_XXX&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),A=new r({props:{title:"Cloud Providers",local:"cloud-providers",headingTag:"h2"}}),$=new r({props:{title:"Amazon SageMaker",local:"amazon-sagemaker",headingTag:"h2"}}),Y=new X({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHNhZ2VtYWtlciUwQWltcG9ydCUyMGJvdG8zJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQSUwQXRyeSUzQSUwQSUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQSUyMyUyMEh1YiUyME1vZGVsJTIwY29uZmlndXJhdGlvbi4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTBBaHViJTIwJTNEJTIwJTdCJTBBJTIwJ0hGX01PREVMX0lEJyUzQSdIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGEnJTJDJTBBJTIwJ1NNX05VTV9HUFVTJyUzQSUyMGpzb24uZHVtcHMoMSklMkMlMEElMjAnTUVTU0FHRVNfQVBJX0VOQUJMRUQnJTNBJTIwVHJ1ZSUwQSU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMEh1Z2dpbmclMjBGYWNlJTIwTW9kZWwlMjBDbGFzcyUwQWh1Z2dpbmdmYWNlX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjBpbWFnZV91cmklM0RnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSglMjJodWdnaW5nZmFjZSUyMiUyQ3ZlcnNpb24lM0QlMjIxLjQuMCUyMiklMkMlMEElMjBlbnYlM0RodWIlMkMlMEElMjByb2xlJTNEcm9sZSUyQyUwQSklMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfbW9kZWwuZGVwbG95KCUwQSUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjBjb250YWluZXJfc3RhcnR1cF9oZWFsdGhfY2hlY2tfdGltZW91dCUzRDMwMCUyQyUwQSUyMCUyMCklMEElMEElMjMlMjBzZW5kJTIwcmVxdWVzdCUwQXByZWRpY3Rvci5wcmVkaWN0KCU3QiUwQSUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri

<span class="hljs-keyword">try</span>:
 role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
 iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
 role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

<span class="hljs-comment"># Hub Model configuration. https://huggingface.co/models</span>
hub = {
 <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>,
 <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>: json.dumps(<span class="hljs-number">1</span>),
 <span class="hljs-string">&#x27;MESSAGES_API_ENABLED&#x27;</span>: <span class="hljs-literal">True</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
 image_uri=get_huggingface_llm_image_uri(<span class="hljs-string">&quot;huggingface&quot;</span>,version=<span class="hljs-string">&quot;1.4.0&quot;</span>),
 env=hub,
 role=role,
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
 initial_instance_count=<span class="hljs-number">1</span>,
 instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
 container_startup_health_check_timeout=<span class="hljs-number">300</span>,
  )

<span class="hljs-comment"># send request</span>
predictor.predict({
<span class="hljs-string">&quot;messages&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ]
})`,wrap:!1}}),{c(){c=M("meta"),z=n(),v=M("p"),R=n(),i(w.$$.fragment),_=n(),j=M("p"),j.textContent=jl,H=n(),m=M("blockquote"),m.innerHTML=ml,F=n(),i(I.$$.fragment),L=n(),h=M("ul"),h.innerHTML=Il,P=n(),i(d.$$.fragment),D=n(),g=M("p"),g.innerHTML=hl,O=n(),i(C.$$.fragment),K=n(),i(b.$$.fragment),ll=n(),B=M("p"),B.textContent=dl,sl=n(),i(f.$$.fragment),el=n(),i(G.$$.fragment),tl=n(),Q=M("p"),Q.textContent=gl,nl=n(),i(Z.$$.fragment),al=n(),i(q.$$.fragment),Ml=n(),S=M("p"),S.innerHTML=Cl,ol=n(),E=M("blockquote"),E.innerHTML=bl,il=n(),i(W.$$.fragment),pl=n(),i(A.$$.fragment),yl=n(),k=M("p"),k.textContent=Bl,Jl=n(),i($.$$.fragment),ul=n(),V=M("p"),V.innerHTML=fl,Tl=n(),N=M("p"),N.innerHTML=Gl,Ul=n(),i(Y.$$.fragment),cl=n(),x=M("p"),this.h()},l(l){const s=kl("svelte-u9bgzb",document.head);c=o(s,"META",{name:!0,content:!0}),s.forEach(e),z=a(l),v=o(l,"P",{}),Ql(v).forEach(e),R=a(l),p(w.$$.fragment,l),_=a(l),j=o(l,"P",{"data-svelte-h":!0}),U(j)!=="svelte-1npf6uj"&&(j.textContent=jl),H=a(l),m=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),U(m)!=="svelte-d3rfkz"&&(m.innerHTML=ml),F=a(l),p(I.$$.fragment,l),L=a(l),h=o(l,"UL",{"data-svelte-h":!0}),U(h)!=="svelte-uach1w"&&(h.innerHTML=Il),P=a(l),p(d.$$.fragment,l),D=a(l),g=o(l,"P",{"data-svelte-h":!0}),U(g)!=="svelte-1w70cim"&&(g.innerHTML=hl),O=a(l),p(C.$$.fragment,l),K=a(l),p(b.$$.fragment,l),ll=a(l),B=o(l,"P",{"data-svelte-h":!0}),U(B)!=="svelte-1g3ypvi"&&(B.textContent=dl),sl=a(l),p(f.$$.fragment,l),el=a(l),p(G.$$.fragment,l),tl=a(l),Q=o(l,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-1xyk36t"&&(Q.textContent=gl),nl=a(l),p(Z.$$.fragment,l),al=a(l),p(q.$$.fragment,l),Ml=a(l),S=o(l,"P",{"data-svelte-h":!0}),U(S)!=="svelte-1xit2od"&&(S.innerHTML=Cl),ol=a(l),E=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),U(E)!=="svelte-1ga4y2y"&&(E.innerHTML=bl),il=a(l),p(W.$$.fragment,l),pl=a(l),p(A.$$.fragment,l),yl=a(l),k=o(l,"P",{"data-svelte-h":!0}),U(k)!=="svelte-10f0asl"&&(k.textContent=Bl),Jl=a(l),p($.$$.fragment,l),ul=a(l),V=o(l,"P",{"data-svelte-h":!0}),U(V)!=="svelte-zm7msf"&&(V.innerHTML=fl),Tl=a(l),N=o(l,"P",{"data-svelte-h":!0}),U(N)!=="svelte-7x0wid"&&(N.innerHTML=Gl),Ul=a(l),p(Y.$$.fragment,l),cl=a(l),x=o(l,"P",{}),Ql(x).forEach(e),this.h()},h(){Zl(c,"name","hf:doc:metadata"),Zl(c,"content",Nl)},m(l,s){$l(document.head,c),t(l,z,s),t(l,v,s),t(l,R,s),y(w,l,s),t(l,_,s),t(l,j,s),t(l,H,s),t(l,m,s),t(l,F,s),y(I,l,s),t(l,L,s),t(l,h,s),t(l,P,s),y(d,l,s),t(l,D,s),t(l,g,s),t(l,O,s),y(C,l,s),t(l,K,s),y(b,l,s),t(l,ll,s),t(l,B,s),t(l,sl,s),y(f,l,s),t(l,el,s),y(G,l,s),t(l,tl,s),t(l,Q,s),t(l,nl,s),y(Z,l,s),t(l,al,s),y(q,l,s),t(l,Ml,s),t(l,S,s),t(l,ol,s),t(l,E,s),t(l,il,s),y(W,l,s),t(l,pl,s),y(A,l,s),t(l,yl,s),t(l,k,s),t(l,Jl,s),y($,l,s),t(l,ul,s),t(l,V,s),t(l,Tl,s),t(l,N,s),t(l,Ul,s),y(Y,l,s),t(l,cl,s),t(l,x,s),rl=!0},p:Sl,i(l){rl||(J(w.$$.fragment,l),J(I.$$.fragment,l),J(d.$$.fragment,l),J(C.$$.fragment,l),J(b.$$.fragment,l),J(f.$$.fragment,l),J(G.$$.fragment,l),J(Z.$$.fragment,l),J(q.$$.fragment,l),J(W.$$.fragment,l),J(A.$$.fragment,l),J($.$$.fragment,l),J(Y.$$.fragment,l),rl=!0)},o(l){u(w.$$.fragment,l),u(I.$$.fragment,l),u(d.$$.fragment,l),u(C.$$.fragment,l),u(b.$$.fragment,l),u(f.$$.fragment,l),u(G.$$.fragment,l),u(Z.$$.fragment,l),u(q.$$.fragment,l),u(W.$$.fragment,l),u(A.$$.fragment,l),u($.$$.fragment,l),u(Y.$$.fragment,l),rl=!1},d(l){l&&(e(z),e(v),e(R),e(_),e(j),e(H),e(m),e(F),e(L),e(h),e(P),e(D),e(g),e(O),e(K),e(ll),e(B),e(sl),e(el),e(tl),e(Q),e(nl),e(al),e(Ml),e(S),e(ol),e(E),e(il),e(pl),e(yl),e(k),e(Jl),e(ul),e(V),e(Tl),e(N),e(Ul),e(cl),e(x)),e(c),T(w,l),T(I,l),T(d,l),T(C,l),T(b,l),T(f,l),T(G,l),T(Z,l),T(q,l),T(W,l),T(A,l),T($,l),T(Y,l)}}}const Nl='{"title":"Messages API","local":"messages-api","sections":[{"title":"Table of Contents","local":"table-of-contents","sections":[],"depth":4},{"title":"Making a Request","local":"making-a-request","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Synchronous","local":"synchronous","sections":[],"depth":2},{"title":"Hugging Face Inference Endpoints","local":"hugging-face-inference-endpoints","sections":[],"depth":2},{"title":"Cloud Providers","local":"cloud-providers","sections":[],"depth":2},{"title":"Amazon SageMaker","local":"amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function Yl(wl){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends Wl{constructor(c){super(),Al(this,c,Yl,Vl,ql,{})}}export{Rl as component};
