import{s as Uc,f as vc,o as kc,n as W}from"../chunks/scheduler.9bc65507.js";import{S as Ic,i as Cc,g as r,s as c,u as T,A as Fc,h as i,f as t,c as d,j as C,v as y,y as m,k as J,o as p,a as l,w as _,d as w,t as b,x as j}from"../chunks/index.78c82d43.js";import{T as he}from"../chunks/Tip.87d55b76.js";import{D as x}from"../chunks/Docstring.f3d04bd2.js";import{C as N}from"../chunks/CodeBlock.48618ec2.js";import{I as H}from"../chunks/IconCopyLink.bedaa44d.js";import{F as So,M as Is}from"../chunks/Markdown.993b48ef.js";import{E as Ae}from"../chunks/ExampleCodeBlock.872b014d.js";function Ac(I){let s,u="Initializing a model with a pre-trained base and randomly initialized classification heads from the hub can be done as shown below.",n,o,g,a,f='Of course, you don’t necessarily have to follow one of these three ways in which TAPAS was fine-tuned. You can also experiment by defining any hyperparameters you want when initializing <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, and then create a <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> based on that configuration. For example, if you have a dataset that has both conversational questions and questions that might involve aggregation, then you can do it this way. Here’s an example:',z,U,v;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMGZvciUyMGV4YW1wbGUlMkMlMjB0aGUlMjBiYXNlJTIwc2l6ZWQlMjBtb2RlbCUyMHdpdGglMjBkZWZhdWx0JTIwU1FBJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdUUSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWclMjAlM0QlMjBUYXBhc0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdpa2lTUUwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcoJTIyZ29vZ2xlLWJhc2UtZmluZXR1bmVkLXdpa2lzcWwtc3VwZXJ2aXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIlMkMlMjBjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, the base sized model with default SQA configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WikiSQL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(<span class="hljs-string">&quot;google-base-finetuned-wikisql-supervised&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`}}),U=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMHlvdSUyMGNhbiUyMGluaXRpYWxpemUlMjB0aGUlMjBjbGFzc2lmaWNhdGlvbiUyMGhlYWRzJTIwYW55JTIwd2F5JTIweW91JTIwd2FudCUyMChzZWUlMjBkb2NzJTIwb2YlMjBUYXBhc0NvbmZpZyklMEFjb25maWclMjAlM0QlMjBUYXBhc0NvbmZpZyhudW1fYWdncmVnYXRpb25fbGFiZWxzJTNEMyUyQyUyMGF2ZXJhZ2VfbG9naXRzX3Blcl9jZWxsJTNEVHJ1ZSklMEElMjMlMjBpbml0aWFsaXppbmclMjB0aGUlMjBwcmUtdHJhaW5lZCUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMG91ciUyMGN1c3RvbSUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZHMlMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIlMkMlMjBjb25maWclM0Rjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can initialize the classification heads any way you want (see docs of TapasConfig)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(num_aggregation_labels=<span class="hljs-number">3</span>, average_logits_per_cell=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initializing the pre-trained base sized model with our custom classification heads</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment),g=c(),a=r("p"),a.innerHTML=f,z=c(),T(U.$$.fragment)},l(k){s=i(k,"P",{"data-svelte-h":!0}),m(s)!=="svelte-4jdzmp"&&(s.textContent=u),n=d(k),y(o.$$.fragment,k),g=d(k),a=i(k,"P",{"data-svelte-h":!0}),m(a)!=="svelte-b04gpe"&&(a.innerHTML=f),z=d(k),y(U.$$.fragment,k)},m(k,Z){l(k,s,Z),l(k,n,Z),_(o,k,Z),l(k,g,Z),l(k,a,Z),l(k,z,Z),_(U,k,Z),v=!0},p:W,i(k){v||(w(o.$$.fragment,k),w(U.$$.fragment,k),v=!0)},o(k){b(o.$$.fragment,k),b(U.$$.fragment,k),v=!1},d(k){k&&(t(s),t(n),t(g),t(a),t(z)),j(o,k),j(U,k)}}}function Zc(I){let s,u;return s=new Is({props:{$$slots:{default:[Ac]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Bc(I){let s,u='Initializing a model with a pre-trained base and randomly initialized classification heads from the hub can be done as shown below. Be sure to have installed the <a href="https://github.com/tensorflow/probability" rel="nofollow">tensorflow_probability</a> dependency:',n,o,g,a,f='Of course, you don’t necessarily have to follow one of these three ways in which TAPAS was fine-tuned. You can also experiment by defining any hyperparameters you want when initializing <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, and then create a <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> based on that configuration. For example, if you have a dataset that has both conversational questions and questions that might involve aggregation, then you can do it this way. Here’s an example:',z,U,v;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwZm9yJTIwZXhhbXBsZSUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMGRlZmF1bHQlMjBTUUElMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBURlRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBJTBBJTIzJTIwb3IlMkMlMjB0aGUlMjBiYXNlJTIwc2l6ZWQlMjBtb2RlbCUyMHdpdGglMjBXVFElMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBvciUyQyUyMHRoZSUyMGJhc2UlMjBzaXplZCUyMG1vZGVsJTIwd2l0aCUyMFdpa2lTUUwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlnJTIwJTNEJTIwVGFwYXNDb25maWcoJTIyZ29vZ2xlLWJhc2UtZmluZXR1bmVkLXdpa2lzcWwtc3VwZXJ2aXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVGFwYXNGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZSUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for example, the base sized model with default SQA configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># or, the base sized model with WikiSQL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(<span class="hljs-string">&quot;google-base-finetuned-wikisql-supervised&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`}}),U=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzQ29uZmlnJTJDJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIweW91JTIwY2FuJTIwaW5pdGlhbGl6ZSUyMHRoZSUyMGNsYXNzaWZpY2F0aW9uJTIwaGVhZHMlMjBhbnklMjB3YXklMjB5b3UlMjB3YW50JTIwKHNlZSUyMGRvY3MlMjBvZiUyMFRhcGFzQ29uZmlnKSUwQWNvbmZpZyUyMCUzRCUyMFRhcGFzQ29uZmlnKG51bV9hZ2dyZWdhdGlvbl9sYWJlbHMlM0QzJTJDJTIwYXZlcmFnZV9sb2dpdHNfcGVyX2NlbGwlM0RUcnVlKSUwQSUyMyUyMGluaXRpYWxpemluZyUyMHRoZSUyMHByZS10cmFpbmVkJTIwYmFzZSUyMHNpemVkJTIwbW9kZWwlMjB3aXRoJTIwb3VyJTIwY3VzdG9tJTIwY2xhc3NpZmljYXRpb24lMjBoZWFkcyUwQW1vZGVsJTIwJTNEJTIwVEZUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTJDJTIwY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can initialize the classification heads any way you want (see docs of TapasConfig)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(num_aggregation_labels=<span class="hljs-number">3</span>, average_logits_per_cell=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initializing the pre-trained base sized model with our custom classification heads</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),T(o.$$.fragment),g=c(),a=r("p"),a.innerHTML=f,z=c(),T(U.$$.fragment)},l(k){s=i(k,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1b9vztz"&&(s.innerHTML=u),n=d(k),y(o.$$.fragment,k),g=d(k),a=i(k,"P",{"data-svelte-h":!0}),m(a)!=="svelte-17ecc2i"&&(a.innerHTML=f),z=d(k),y(U.$$.fragment,k)},m(k,Z){l(k,s,Z),l(k,n,Z),_(o,k,Z),l(k,g,Z),l(k,a,Z),l(k,z,Z),_(U,k,Z),v=!0},p:W,i(k){v||(w(o.$$.fragment,k),w(U.$$.fragment,k),v=!0)},o(k){b(o.$$.fragment,k),b(U.$$.fragment,k),v=!1},d(k){k&&(t(s),t(n),t(g),t(a),t(z)),j(o,k),j(U,k)}}}function zc(I){let s,u;return s=new Is({props:{$$slots:{default:[Bc]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function $c(I){let s,u=`Third, given that you’ve prepared your data in this TSV/CSV format (and corresponding CSV files containing the tabular data), you can then use <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> to convert table-question pairs into <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code> and so on. Again, based on which of the three cases you picked above, <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> requires different
inputs to be fine-tuned:`,n,o,g="<thead><tr><th><strong>Task</strong></th> <th><strong>Required inputs</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code></td></tr> <tr><td>Weak supervision for aggregation</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code>, <code>numeric_values</code>, <code>numeric_values_scale</code>, <code>float_answer</code></td></tr> <tr><td>Strong supervision for aggregation</td> <td><code>input ids</code>, <code>attention mask</code>, <code>token type ids</code>, <code>labels</code>, <code>aggregation_labels</code></td></tr></tbody>",a,f,z='<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates the <code>labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> based on the <code>answer_coordinates</code> and <code>answer_text</code> columns of the TSV file. The <code>float_answer</code> and <code>aggregation_labels</code> are already in the TSV file of step 2. Here’s an example:',U,v,k,Z,B=`Note that <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> expects the data of the table to be <strong>text-only</strong>. You can use <code>.astype(str)</code> on a dataframe to turn it into text-only data.
Of course, this only shows how to encode a single training example. It is advised to create a dataloader to iterate over batches:`,$,M,A;return v=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVGFwYXNUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUyMkFjdG9ycyUyMiUzQSUyMCU1QiUyMkJyYWQlMjBQaXR0JTIyJTJDJTIwJTIyTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMiUyQyUyMCUyMkdlb3JnZSUyMENsb29uZXklMjIlNUQlMkMlMjAlMjJOdW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCU3RCUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaXJzdCUyMGFjdG9yJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMHRvdGFsJTIwbnVtYmVyJTIwb2YlMjBtb3ZpZXMlM0YlMjIlMkMlMEElNUQlMEFhbnN3ZXJfY29vcmRpbmF0ZXMlMjAlM0QlMjAlNUIlNUIoMCUyQyUyMDApJTVEJTJDJTIwJTVCKDIlMkMlMjAxKSU1RCUyQyUyMCU1QigwJTJDJTIwMSklMkMlMjAoMSUyQyUyMDEpJTJDJTIwKDIlMkMlMjAxKSU1RCU1RCUwQWFuc3dlcl90ZXh0JTIwJTNEJTIwJTVCJTVCJTIyQnJhZCUyMFBpdHQlMjIlNUQlMkMlMjAlNUIlMjI2OSUyMiU1RCUyQyUyMCU1QiUyMjIwOSUyMiU1RCU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RhbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfdGV4dCUzRGFuc3dlcl90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWlucHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_coordinates = [[(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>)], [(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)], [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)]]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_text = [[<span class="hljs-string">&quot;Brad Pitt&quot;</span>], [<span class="hljs-string">&quot;69&quot;</span>], [<span class="hljs-string">&quot;209&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table,
<span class="hljs-meta">... </span>    queries=queries,
<span class="hljs-meta">... </span>    answer_coordinates=answer_coordinates,
<span class="hljs-meta">... </span>    answer_text=answer_text,
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[...]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[[...]]]),
<span class="hljs-string">&#x27;numeric_values&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;numeric_values_scale: tensor([[ ... ]]), labels: tensor([[ ... ]])}</span>`}}),M=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tsv_path = <span class="hljs-string">&quot;your_path_to_the_tsv_file&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table_csv_path = <span class="hljs-string">&quot;your_path_to_a_directory_containing_all_csv_files&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TableDataset</span>(torch.utils.data.Dataset):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, data, tokenizer</span>):
<span class="hljs-meta">... </span>        self.data = data
<span class="hljs-meta">... </span>        self.tokenizer = tokenizer

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        item = data.iloc[idx]
<span class="hljs-meta">... </span>        table = pd.read_csv(table_csv_path + item.table_file).astype(
<span class="hljs-meta">... </span>            <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>        )  <span class="hljs-comment"># be sure to make your table data text only</span>
<span class="hljs-meta">... </span>        encoding = self.tokenizer(
<span class="hljs-meta">... </span>            table=table,
<span class="hljs-meta">... </span>            queries=item.question,
<span class="hljs-meta">... </span>            answer_coordinates=item.answer_coordinates,
<span class="hljs-meta">... </span>            answer_text=item.answer_text,
<span class="hljs-meta">... </span>            truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        <span class="hljs-comment"># remove the batch dimension which the tokenizer adds by default</span>
<span class="hljs-meta">... </span>        encoding = {key: val.squeeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">... </span>        <span class="hljs-comment"># add the float_answer which is also required (weak supervision for aggregation case)</span>
<span class="hljs-meta">... </span>        encoding[<span class="hljs-string">&quot;float_answer&quot;</span>] = torch.tensor(item.float_answer)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> encoding

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.data)


<span class="hljs-meta">&gt;&gt;&gt; </span>data = pd.read_csv(tsv_path, sep=<span class="hljs-string">&quot;\\t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = TableDataset(data, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(train_dataset, batch_size=<span class="hljs-number">32</span>)`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("table"),o.innerHTML=g,a=c(),f=r("p"),f.innerHTML=z,U=c(),T(v.$$.fragment),k=c(),Z=r("p"),Z.innerHTML=B,$=c(),T(M.$$.fragment)},l(F){s=i(F,"P",{"data-svelte-h":!0}),m(s)!=="svelte-yql2by"&&(s.innerHTML=u),n=d(F),o=i(F,"TABLE",{"data-svelte-h":!0}),m(o)!=="svelte-1f72bji"&&(o.innerHTML=g),a=d(F),f=i(F,"P",{"data-svelte-h":!0}),m(f)!=="svelte-rhyrgo"&&(f.innerHTML=z),U=d(F),y(v.$$.fragment,F),k=d(F),Z=i(F,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-lok51r"&&(Z.innerHTML=B),$=d(F),y(M.$$.fragment,F)},m(F,q){l(F,s,q),l(F,n,q),l(F,o,q),l(F,a,q),l(F,f,q),l(F,U,q),_(v,F,q),l(F,k,q),l(F,Z,q),l(F,$,q),_(M,F,q),A=!0},p:W,i(F){A||(w(v.$$.fragment,F),w(M.$$.fragment,F),A=!0)},o(F){b(v.$$.fragment,F),b(M.$$.fragment,F),A=!1},d(F){F&&(t(s),t(n),t(o),t(a),t(f),t(U),t(k),t(Z),t($)),j(v,F),j(M,F)}}}function qc(I){let s,u;return s=new Is({props:{$$slots:{default:[$c]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Wc(I){let s,u=`Third, given that you’ve prepared your data in this TSV/CSV format (and corresponding CSV files containing the tabular data), you can then use <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> to convert table-question pairs into <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code> and so on. Again, based on which of the three cases you picked above, <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> requires different
inputs to be fine-tuned:`,n,o,g="<thead><tr><th><strong>Task</strong></th> <th><strong>Required inputs</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code></td></tr> <tr><td>Weak supervision for aggregation</td> <td><code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>labels</code>, <code>numeric_values</code>, <code>numeric_values_scale</code>, <code>float_answer</code></td></tr> <tr><td>Strong supervision for aggregation</td> <td><code>input ids</code>, <code>attention mask</code>, <code>token type ids</code>, <code>labels</code>, <code>aggregation_labels</code></td></tr></tbody>",a,f,z='<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates the <code>labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> based on the <code>answer_coordinates</code> and <code>answer_text</code> columns of the TSV file. The <code>float_answer</code> and <code>aggregation_labels</code> are already in the TSV file of step 2. Here’s an example:',U,v,k,Z,B=`Note that <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> expects the data of the table to be <strong>text-only</strong>. You can use <code>.astype(str)</code> on a dataframe to turn it into text-only data.
Of course, this only shows how to encode a single training example. It is advised to create a dataloader to iterate over batches:`,$,M,A;return v=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzVG9rZW5pemVyJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVGFwYXNUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUyMkFjdG9ycyUyMiUzQSUyMCU1QiUyMkJyYWQlMjBQaXR0JTIyJTJDJTIwJTIyTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMiUyQyUyMCUyMkdlb3JnZSUyMENsb29uZXklMjIlNUQlMkMlMjAlMjJOdW1iZXIlMjBvZiUyMG1vdmllcyUyMiUzQSUyMCU1QiUyMjg3JTIyJTJDJTIwJTIyNTMlMjIlMkMlMjAlMjI2OSUyMiU1RCU3RCUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaXJzdCUyMGFjdG9yJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMHRvdGFsJTIwbnVtYmVyJTIwb2YlMjBtb3ZpZXMlM0YlMjIlMkMlMEElNUQlMEFhbnN3ZXJfY29vcmRpbmF0ZXMlMjAlM0QlMjAlNUIlNUIoMCUyQyUyMDApJTVEJTJDJTIwJTVCKDIlMkMlMjAxKSU1RCUyQyUyMCU1QigwJTJDJTIwMSklMkMlMjAoMSUyQyUyMDEpJTJDJTIwKDIlMkMlMjAxKSU1RCU1RCUwQWFuc3dlcl90ZXh0JTIwJTNEJTIwJTVCJTVCJTIyQnJhZCUyMFBpdHQlMjIlNUQlMkMlMjAlNUIlMjI2OSUyMiU1RCUyQyUyMCU1QiUyMjIwOSUyMiU1RCU1RCUwQXRhYmxlJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChkYXRhKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjB0YWJsZSUzRHRhYmxlJTJDJTBBJTIwJTIwJTIwJTIwcXVlcmllcyUzRHF1ZXJpZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfY29vcmRpbmF0ZXMlM0RhbnN3ZXJfY29vcmRpbmF0ZXMlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXJfdGV4dCUzRGFuc3dlcl90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTJDJTBBKSUwQWlucHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_coordinates = [[(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>)], [(<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)], [(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>)]]
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_text = [[<span class="hljs-string">&quot;Brad Pitt&quot;</span>], [<span class="hljs-string">&quot;69&quot;</span>], [<span class="hljs-string">&quot;209&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table,
<span class="hljs-meta">... </span>    queries=queries,
<span class="hljs-meta">... </span>    answer_coordinates=answer_coordinates,
<span class="hljs-meta">... </span>    answer_text=answer_text,
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[...]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[[...]]]),
<span class="hljs-string">&#x27;numeric_values&#x27;</span>: tensor([[ ... ]]), <span class="hljs-string">&#x27;numeric_values_scale: tensor([[ ... ]]), labels: tensor([[ ... ]])}</span>`}}),M=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tsv_path = <span class="hljs-string">&quot;your_path_to_the_tsv_file&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table_csv_path = <span class="hljs-string">&quot;your_path_to_a_directory_containing_all_csv_files&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TableDataset</span>:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, data, tokenizer</span>):
<span class="hljs-meta">... </span>        self.data = data
<span class="hljs-meta">... </span>        self.tokenizer = tokenizer

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__iter__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.__len__()):
<span class="hljs-meta">... </span>            item = self.data.iloc[idx]
<span class="hljs-meta">... </span>            table = pd.read_csv(table_csv_path + item.table_file).astype(
<span class="hljs-meta">... </span>                <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>            )  <span class="hljs-comment"># be sure to make your table data text only</span>
<span class="hljs-meta">... </span>            encoding = self.tokenizer(
<span class="hljs-meta">... </span>                table=table,
<span class="hljs-meta">... </span>                queries=item.question,
<span class="hljs-meta">... </span>                answer_coordinates=item.answer_coordinates,
<span class="hljs-meta">... </span>                answer_text=item.answer_text,
<span class="hljs-meta">... </span>                truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>                padding=<span class="hljs-string">&quot;max_length&quot;</span>,
<span class="hljs-meta">... </span>                return_tensors=<span class="hljs-string">&quot;tf&quot;</span>,
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            <span class="hljs-comment"># remove the batch dimension which the tokenizer adds by default</span>
<span class="hljs-meta">... </span>            encoding = {key: tf.squeeze(val, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">... </span>            <span class="hljs-comment"># add the float_answer which is also required (weak supervision for aggregation case)</span>
<span class="hljs-meta">... </span>            encoding[<span class="hljs-string">&quot;float_answer&quot;</span>] = tf.convert_to_tensor(item.float_answer, dtype=tf.float32)
<span class="hljs-meta">... </span>            <span class="hljs-keyword">yield</span> encoding[<span class="hljs-string">&quot;input_ids&quot;</span>], encoding[<span class="hljs-string">&quot;attention_mask&quot;</span>], encoding[<span class="hljs-string">&quot;numeric_values&quot;</span>], encoding[
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;numeric_values_scale&quot;</span>
<span class="hljs-meta">... </span>            ], encoding[<span class="hljs-string">&quot;token_type_ids&quot;</span>], encoding[<span class="hljs-string">&quot;labels&quot;</span>], encoding[<span class="hljs-string">&quot;float_answer&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.data)


<span class="hljs-meta">&gt;&gt;&gt; </span>data = pd.read_csv(tsv_path, sep=<span class="hljs-string">&quot;\\t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = TableDataset(data, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_signature = (
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>, <span class="hljs-number">7</span>), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.int32),
<span class="hljs-meta">... </span>    tf.TensorSpec(shape=(<span class="hljs-number">512</span>,), dtype=tf.float32),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = tf.data.Dataset.from_generator(train_dataset, output_signature=output_signature).batch(<span class="hljs-number">32</span>)`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("table"),o.innerHTML=g,a=c(),f=r("p"),f.innerHTML=z,U=c(),T(v.$$.fragment),k=c(),Z=r("p"),Z.innerHTML=B,$=c(),T(M.$$.fragment)},l(F){s=i(F,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1nebuae"&&(s.innerHTML=u),n=d(F),o=i(F,"TABLE",{"data-svelte-h":!0}),m(o)!=="svelte-1f72bji"&&(o.innerHTML=g),a=d(F),f=i(F,"P",{"data-svelte-h":!0}),m(f)!=="svelte-rhyrgo"&&(f.innerHTML=z),U=d(F),y(v.$$.fragment,F),k=d(F),Z=i(F,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-lok51r"&&(Z.innerHTML=B),$=d(F),y(M.$$.fragment,F)},m(F,q){l(F,s,q),l(F,n,q),l(F,o,q),l(F,a,q),l(F,f,q),l(F,U,q),_(v,F,q),l(F,k,q),l(F,Z,q),l(F,$,q),_(M,F,q),A=!0},p:W,i(F){A||(w(v.$$.fragment,F),w(M.$$.fragment,F),A=!0)},o(F){b(v.$$.fragment,F),b(M.$$.fragment,F),A=!1},d(F){F&&(t(s),t(n),t(o),t(a),t(f),t(U),t(k),t(Z),t($)),j(v,F),j(M,F)}}}function xc(I){let s,u;return s=new Is({props:{$$slots:{default:[Wc]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Gc(I){let s,u='You can then fine-tune <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> as follows (shown here for the weak supervision for aggregation case):',n,o,g;return o=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TapasForQuestionAnswering, AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># this is the default WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(
<span class="hljs-meta">... </span>    num_aggregation_labels=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    use_answer_as_supervision=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    answer_loss_cutoff=<span class="hljs-number">0.664694</span>,
<span class="hljs-meta">... </span>    cell_selection_preference=<span class="hljs-number">0.207951</span>,
<span class="hljs-meta">... </span>    huber_loss_delta=<span class="hljs-number">0.121194</span>,
<span class="hljs-meta">... </span>    init_cell_selection_weights_to_zero=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    select_one_column=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_empty_column_selection=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.0352513</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):  <span class="hljs-comment"># loop over the dataset multiple times</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># get the inputs;</span>
<span class="hljs-meta">... </span>        input_ids = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">... </span>        attention_mask = batch[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>        token_type_ids = batch[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
<span class="hljs-meta">... </span>        labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        numeric_values = batch[<span class="hljs-string">&quot;numeric_values&quot;</span>]
<span class="hljs-meta">... </span>        numeric_values_scale = batch[<span class="hljs-string">&quot;numeric_values_scale&quot;</span>]
<span class="hljs-meta">... </span>        float_answer = batch[<span class="hljs-string">&quot;float_answer&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># zero the parameter gradients</span>
<span class="hljs-meta">... </span>        optimizer.zero_grad()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward + backward + optimize</span>
<span class="hljs-meta">... </span>        outputs = model(
<span class="hljs-meta">... </span>            input_ids=input_ids,
<span class="hljs-meta">... </span>            attention_mask=attention_mask,
<span class="hljs-meta">... </span>            token_type_ids=token_type_ids,
<span class="hljs-meta">... </span>            labels=labels,
<span class="hljs-meta">... </span>            numeric_values=numeric_values,
<span class="hljs-meta">... </span>            numeric_values_scale=numeric_values_scale,
<span class="hljs-meta">... </span>            float_answer=float_answer,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1r39bz3"&&(s.innerHTML=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function Nc(I){let s,u;return s=new Is({props:{$$slots:{default:[Gc]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Rc(I){let s,u='You can then fine-tune <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> as follows (shown here for the weak supervision for aggregation case):',n,o,g;return o=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasConfig, TFTapasForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># this is the default WTQ configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = TapasConfig(
<span class="hljs-meta">... </span>    num_aggregation_labels=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    use_answer_as_supervision=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    answer_loss_cutoff=<span class="hljs-number">0.664694</span>,
<span class="hljs-meta">... </span>    cell_selection_preference=<span class="hljs-number">0.207951</span>,
<span class="hljs-meta">... </span>    huber_loss_delta=<span class="hljs-number">0.121194</span>,
<span class="hljs-meta">... </span>    init_cell_selection_weights_to_zero=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    select_one_column=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_empty_column_selection=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.0352513</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>, config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">2</span>):  <span class="hljs-comment"># loop over the dataset multiple times</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># get the inputs;</span>
<span class="hljs-meta">... </span>        input_ids = batch[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        attention_mask = batch[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        token_type_ids = batch[<span class="hljs-number">4</span>]
<span class="hljs-meta">... </span>        labels = batch[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        numeric_values = batch[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>        numeric_values_scale = batch[<span class="hljs-number">3</span>]
<span class="hljs-meta">... </span>        float_answer = batch[<span class="hljs-number">6</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward + backward + optimize</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> tf.GradientTape() <span class="hljs-keyword">as</span> tape:
<span class="hljs-meta">... </span>            outputs = model(
<span class="hljs-meta">... </span>                input_ids=input_ids,
<span class="hljs-meta">... </span>                attention_mask=attention_mask,
<span class="hljs-meta">... </span>                token_type_ids=token_type_ids,
<span class="hljs-meta">... </span>                labels=labels,
<span class="hljs-meta">... </span>                numeric_values=numeric_values,
<span class="hljs-meta">... </span>                numeric_values_scale=numeric_values_scale,
<span class="hljs-meta">... </span>                float_answer=float_answer,
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>        grads = tape.gradient(outputs.loss, model.trainable_weights)
<span class="hljs-meta">... </span>        optimizer.apply_gradients(<span class="hljs-built_in">zip</span>(grads, model.trainable_weights))`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1qzq1h3"&&(s.innerHTML=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function Qc(I){let s,u;return s=new Is({props:{$$slots:{default:[Rc]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Vc(I){let s,u='Here we explain how you can use <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> for inference (i.e. making predictions on new data). For inference, only <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> (which you can obtain using <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) have to be provided to the model to obtain the logits. Next, you can use the handy <code>~models.tapas.tokenization_tapas.convert_logits_to_predictions</code> method to convert these into predicted coordinates and optional aggregation indices.',n,o,g="However, note that inference is <strong>different</strong> depending on whether or not the setup is conversational. In a non-conversational set-up, inference can be done in parallel on all table-question pairs of a batch. Here’s an example of that:",a,f,z;return f=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer_coordinates, predicted_aggregation_indices = tokenizer.convert_logits_to_predictions(
<span class="hljs-meta">... </span>    inputs, outputs.logits.detach(), outputs.logits_aggregation.detach()
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s print out the results:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2aggregation = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;NONE&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;SUM&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;AVERAGE&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;COUNT&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aggregation_predictions_string = [id2aggregation[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> predicted_aggregation_indices]

<span class="hljs-meta">&gt;&gt;&gt; </span>answers = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> coordinates <span class="hljs-keyword">in</span> predicted_answer_coordinates:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(coordinates) == <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># only a single cell:</span>
<span class="hljs-meta">... </span>        answers.append(table.iat[coordinates[<span class="hljs-number">0</span>]])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># multiple cells</span>
<span class="hljs-meta">... </span>        cell_values = []
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> coordinate <span class="hljs-keyword">in</span> coordinates:
<span class="hljs-meta">... </span>            cell_values.append(table.iat[coordinate])
<span class="hljs-meta">... </span>        answers.append(<span class="hljs-string">&quot;, &quot;</span>.join(cell_values))

<span class="hljs-meta">&gt;&gt;&gt; </span>display(table)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> query, answer, predicted_agg <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queries, answers, aggregation_predictions_string):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> predicted_agg == <span class="hljs-string">&quot;NONE&quot;</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + answer)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + predicted_agg + <span class="hljs-string">&quot; &gt; &quot;</span> + answer)
What <span class="hljs-keyword">is</span> the name of the first actor?
Predicted answer: Brad Pitt
How many movies has George Clooney played <span class="hljs-keyword">in</span>?
Predicted answer: COUNT &gt; <span class="hljs-number">69</span>
What <span class="hljs-keyword">is</span> the total number of movies?
Predicted answer: SUM &gt; <span class="hljs-number">87</span>, <span class="hljs-number">53</span>, <span class="hljs-number">69</span>`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("p"),o.innerHTML=g,a=c(),T(f.$$.fragment)},l(U){s=i(U,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1atfgmg"&&(s.innerHTML=u),n=d(U),o=i(U,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1xx2q6p"&&(o.innerHTML=g),a=d(U),y(f.$$.fragment,U)},m(U,v){l(U,s,v),l(U,n,v),l(U,o,v),l(U,a,v),_(f,U,v),z=!0},p:W,i(U){z||(w(f.$$.fragment,U),z=!0)},o(U){b(f.$$.fragment,U),z=!1},d(U){U&&(t(s),t(n),t(o),t(a)),j(f,U)}}}function Ec(I){let s,u;return s=new Is({props:{$$slots:{default:[Vc]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Xc(I){let s,u='Here we explain how you can use <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> for inference (i.e. making predictions on new data). For inference, only <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> (which you can obtain using <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) have to be provided to the model to obtain the logits. Next, you can use the handy <code>~models.tapas.tokenization_tapas.convert_logits_to_predictions</code> method to convert these into predicted coordinates and optional aggregation indices.',n,o,g="However, note that inference is <strong>different</strong> depending on whether or not the setup is conversational. In a non-conversational set-up, inference can be done in parallel on all table-question pairs of a batch. Here’s an example of that:",a,f,z;return f=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasTokenizer, TFTapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFTapasForQuestionAnswering.from_pretrained(model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = TapasTokenizer.from_pretrained(model_name)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the name of the first actor?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;What is the total number of movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer_coordinates, predicted_aggregation_indices = tokenizer.convert_logits_to_predictions(
<span class="hljs-meta">... </span>    inputs, outputs.logits, outputs.logits_aggregation
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s print out the results:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2aggregation = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;NONE&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;SUM&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;AVERAGE&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;COUNT&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aggregation_predictions_string = [id2aggregation[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> predicted_aggregation_indices]

<span class="hljs-meta">&gt;&gt;&gt; </span>answers = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> coordinates <span class="hljs-keyword">in</span> predicted_answer_coordinates:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(coordinates) == <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># only a single cell:</span>
<span class="hljs-meta">... </span>        answers.append(table.iat[coordinates[<span class="hljs-number">0</span>]])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># multiple cells</span>
<span class="hljs-meta">... </span>        cell_values = []
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> coordinate <span class="hljs-keyword">in</span> coordinates:
<span class="hljs-meta">... </span>            cell_values.append(table.iat[coordinate])
<span class="hljs-meta">... </span>        answers.append(<span class="hljs-string">&quot;, &quot;</span>.join(cell_values))

<span class="hljs-meta">&gt;&gt;&gt; </span>display(table)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> query, answer, predicted_agg <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queries, answers, aggregation_predictions_string):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> predicted_agg == <span class="hljs-string">&quot;NONE&quot;</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + answer)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer: &quot;</span> + predicted_agg + <span class="hljs-string">&quot; &gt; &quot;</span> + answer)
What <span class="hljs-keyword">is</span> the name of the first actor?
Predicted answer: Brad Pitt
How many movies has George Clooney played <span class="hljs-keyword">in</span>?
Predicted answer: COUNT &gt; <span class="hljs-number">69</span>
What <span class="hljs-keyword">is</span> the total number of movies?
Predicted answer: SUM &gt; <span class="hljs-number">87</span>, <span class="hljs-number">53</span>, <span class="hljs-number">69</span>`}}),{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("p"),o.innerHTML=g,a=c(),T(f.$$.fragment)},l(U){s=i(U,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1mpff71"&&(s.innerHTML=u),n=d(U),o=i(U,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1xx2q6p"&&(o.innerHTML=g),a=d(U),y(f.$$.fragment,U)},m(U,v){l(U,s,v),l(U,n,v),l(U,o,v),l(U,a,v),_(f,U,v),z=!0},p:W,i(U){z||(w(f.$$.fragment,U),z=!0)},o(U){b(f.$$.fragment,U),z=!1},d(U){U&&(t(s),t(n),t(o),t(a)),j(f,U)}}}function Sc(I){let s,u;return s=new Is({props:{$$slots:{default:[Xc]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment)},l(n){y(s.$$.fragment,n)},m(n,o){_(s,n,o),u=!0},p(n,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:n}),s.$set(g)},i(n){u||(w(s.$$.fragment,n),u=!0)},o(n){b(s.$$.fragment,n),u=!1},d(n){j(s,n)}}}function Hc(I){let s,u="Example:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhcGFzTW9kZWwlMkMlMjBUYXBhc0NvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBkZWZhdWx0JTIwKFNRQSklMjBUYXBhcyUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVGFwYXNDb25maWcoKSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TapasModel, TapasConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a default (SQA) Tapas configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TapasConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-11lpom8"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function Yc(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function Lc(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc01vZGVsJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMCUyMkhvdyUyMG9sZCUyMGlzJTIwQnJhZCUyMFBpdHQlM0YlMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIodGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0RxdWVyaWVzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function Pc(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function Dc(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0Zvck1hc2tlZExNJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0Zvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwdGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0QlMjJIb3clMjBtYW55JTIwJTVCTUFTSyU1RCUyMGhhcyUyMEdlb3JnZSUyMCU1Qk1BU0slNUQlMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many [MASK] has George [MASK] played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function Oc(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function Kc(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhlcmUlMjBpcyUyMG9ubHklMjBvbmUlMjBhY3RvciUyMHdobyUyMGlzJTIwNDUlMjB5ZWFycyUyMG9sZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZXJlJTIwYXJlJTIwMyUyMGFjdG9ycyUyMHdoaWNoJTIwcGxheWVkJTIwaW4lMjBtb3JlJTIwdGhhbiUyMDYwJTIwbW92aWVzJTIyJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSUyQyUyMDAlNUQpJTIwJTIwJTIzJTIwMSUyMG1lYW5zJTIwZW50YWlsZWQlMkMlMjAwJTIwbWVhbnMlMjByZWZ1dGVkJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There is only one actor who is 45 years old&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There are 3 actors which played in more than 60 movies&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>, <span class="hljs-number">0</span>])  <span class="hljs-comment"># 1 means entailed, 0 means refuted</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function ed(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function sd(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkFnZSUyMiUzQSUyMCU1QiUyMjU2JTIyJTJDJTIwJTIyNDUlMjIlMkMlMjAlMjI1OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTJDJTBBJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMjAlMjJIb3clMjBvbGQlMjBpcyUyMEJyYWQlMjBQaXR0JTNGJTIyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsb2dpdHNfYWdncmVnYXRpb24lMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19hZ2dyZWdhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_aggregation = outputs.logits_aggregation`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function td(I){let s,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,f,z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,v,k=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,B,$=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("ul"),o.innerHTML=g,a=c(),f=r("p"),f.innerHTML=z,U=c(),v=r("ul"),v.innerHTML=k,Z=c(),B=r("p"),B.innerHTML=$},l(M){s=i(M,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1ajbfxg"&&(s.innerHTML=u),n=d(M),o=i(M,"UL",{"data-svelte-h":!0}),m(o)!=="svelte-qm1t26"&&(o.innerHTML=g),a=d(M),f=i(M,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1v9qsc5"&&(f.innerHTML=z),U=d(M),v=i(M,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-15scerc"&&(v.innerHTML=k),Z=d(M),B=i(M,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1an3odd"&&(B.innerHTML=$)},m(M,A){l(M,s,A),l(M,n,A),l(M,o,A),l(M,a,A),l(M,f,A),l(M,U,A),l(M,v,A),l(M,Z,A),l(M,B,A)},p:W,d(M){M&&(t(s),t(n),t(o),t(a),t(f),t(U),t(v),t(Z),t(B))}}}function nd(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function ad(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc01vZGVsJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMCUyMkhvdyUyMG9sZCUyMGlzJTIwQnJhZCUyMFBpdHQlM0YlMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIodGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0RxdWVyaWVzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasModel.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function od(I){let s,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,f,z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,v,k=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,B,$=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("ul"),o.innerHTML=g,a=c(),f=r("p"),f.innerHTML=z,U=c(),v=r("ul"),v.innerHTML=k,Z=c(),B=r("p"),B.innerHTML=$},l(M){s=i(M,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1ajbfxg"&&(s.innerHTML=u),n=d(M),o=i(M,"UL",{"data-svelte-h":!0}),m(o)!=="svelte-qm1t26"&&(o.innerHTML=g),a=d(M),f=i(M,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1v9qsc5"&&(f.innerHTML=z),U=d(M),v=i(M,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-15scerc"&&(v.innerHTML=k),Z=d(M),B=i(M,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1an3odd"&&(B.innerHTML=$)},m(M,A){l(M,s,A),l(M,n,A),l(M,o,A),l(M,a,A),l(M,f,A),l(M,U,A),l(M,v,A),l(M,Z,A),l(M,B,A)},p:W,d(M){M&&(t(s),t(n),t(o),t(a),t(f),t(U),t(v),t(Z),t(B))}}}function ld(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function rd(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0Zvck1hc2tlZExNJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBUYXBhc0Zvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlJTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwdGFibGUlM0R0YWJsZSUyQyUyMHF1ZXJpZXMlM0QlMjJIb3clMjBtYW55JTIwJTVCTUFTSyU1RCUyMGhhcyUyMEdlb3JnZSUyMCU1Qk1BU0slNUQlMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEJTIySG93JTIwbWFueSUyMG1vdmllcyUyMGhhcyUyMEdlb3JnZSUyMENsb29uZXklMjBwbGF5ZWQlMjBpbiUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google/tapas-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many [MASK] has George [MASK] played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(
<span class="hljs-meta">... </span>    table=table, queries=<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function id(I){let s,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,f,z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,v,k=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,B,$=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("ul"),o.innerHTML=g,a=c(),f=r("p"),f.innerHTML=z,U=c(),v=r("ul"),v.innerHTML=k,Z=c(),B=r("p"),B.innerHTML=$},l(M){s=i(M,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1ajbfxg"&&(s.innerHTML=u),n=d(M),o=i(M,"UL",{"data-svelte-h":!0}),m(o)!=="svelte-qm1t26"&&(o.innerHTML=g),a=d(M),f=i(M,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1v9qsc5"&&(f.innerHTML=z),U=d(M),v=i(M,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-15scerc"&&(v.innerHTML=k),Z=d(M),B=i(M,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1an3odd"&&(B.innerHTML=$)},m(M,A){l(M,s,A),l(M,n,A),l(M,o,A),l(M,a,A),l(M,f,A),l(M,U,A),l(M,v,A),l(M,Z,A),l(M,B,A)},p:W,d(M){M&&(t(s),t(n),t(o),t(a),t(f),t(U),t(v),t(Z),t(B))}}}function cd(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function dd(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFwYXNGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC10YWJmYWN0JTIyKSUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyQWdlJTIyJTNBJTIwJTVCJTIyNTYlMjIlMkMlMjAlMjI0NSUyMiUyQyUyMCUyMjU5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlMkMlMEElN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVyaWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhlcmUlMjBpcyUyMG9ubHklMjBvbmUlMjBhY3RvciUyMHdobyUyMGlzJTIwNDUlMjB5ZWFycyUyMG9sZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZXJlJTIwYXJlJTIwMyUyMGFjdG9ycyUyMHdoaWNoJTIwcGxheWVkJTIwaW4lMjBtb3JlJTIwdGhhbiUyMDYwJTIwbW92aWVzJTIyJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsYWJlbHMlMjAlM0QlMjB0Zi5jb252ZXJ0X3RvX3RlbnNvciglNUIxJTJDJTIwMCU1RCklMjAlMjAlMjMlMjAxJTIwbWVhbnMlMjBlbnRhaWxlZCUyQyUyMDAlMjBtZWFucyUyMHJlZnV0ZWQlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There is only one actor who is 45 years old&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;There are 3 actors which played in more than 60 movies&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.convert_to_tensor([<span class="hljs-number">1</span>, <span class="hljs-number">0</span>])  <span class="hljs-comment"># 1 means entailed, 0 means refuted</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function pd(I){let s,u="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",a,f,z=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,U,v,k=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,Z,B,$=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){s=r("p"),s.innerHTML=u,n=c(),o=r("ul"),o.innerHTML=g,a=c(),f=r("p"),f.innerHTML=z,U=c(),v=r("ul"),v.innerHTML=k,Z=c(),B=r("p"),B.innerHTML=$},l(M){s=i(M,"P",{"data-svelte-h":!0}),m(s)!=="svelte-1ajbfxg"&&(s.innerHTML=u),n=d(M),o=i(M,"UL",{"data-svelte-h":!0}),m(o)!=="svelte-qm1t26"&&(o.innerHTML=g),a=d(M),f=i(M,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1v9qsc5"&&(f.innerHTML=z),U=d(M),v=i(M,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-15scerc"&&(v.innerHTML=k),Z=d(M),B=i(M,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1an3odd"&&(B.innerHTML=$)},m(M,A){l(M,s,A),l(M,n,A),l(M,o,A),l(M,a,A),l(M,f,A),l(M,U,A),l(M,v,A),l(M,Z,A),l(M,B,A)},p:W,d(M){M&&(t(s),t(n),t(o),t(a),t(f),t(U),t(v),t(Z),t(B))}}}function hd(I){let s,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=r("p"),s.innerHTML=u},l(n){s=i(n,"P",{"data-svelte-h":!0}),m(s)!=="svelte-fincs2"&&(s.innerHTML=u)},m(n,o){l(n,s,o)},p:W,d(n){n&&t(s)}}}function md(I){let s,u="Examples:",n,o,g;return o=new N({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUYXBhc0ZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMFRhcGFzRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkFnZSUyMiUzQSUyMCU1QiUyMjU2JTIyJTJDJTIwJTIyNDUlMjIlMkMlMjAlMjI1OSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTJDJTBBJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlcmllcyUyMCUzRCUyMCU1QiUyMkhvdyUyMG1hbnklMjBtb3ZpZXMlMjBoYXMlMjBHZW9yZ2UlMjBDbG9vbmV5JTIwcGxheWVkJTIwaW4lM0YlMjIlMkMlMjAlMjJIb3clMjBvbGQlMjBpcyUyMEJyYWQlMjBQaXR0JTNGJTIyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTNEdGFibGUlMkMlMjBxdWVyaWVzJTNEcXVlcmllcyUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsb2dpdHNfYWdncmVnYXRpb24lMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19hZ2dyZWdhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TapasForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TapasForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Age&quot;</span>: [<span class="hljs-string">&quot;56&quot;</span>, <span class="hljs-string">&quot;45&quot;</span>, <span class="hljs-string">&quot;59&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>queries = [<span class="hljs-string">&quot;How many movies has George Clooney played in?&quot;</span>, <span class="hljs-string">&quot;How old is Brad Pitt?&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(table=table, queries=queries, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_aggregation = outputs.logits_aggregation`}}),{c(){s=r("p"),s.textContent=u,n=c(),T(o.$$.fragment)},l(a){s=i(a,"P",{"data-svelte-h":!0}),m(s)!=="svelte-kvfsh7"&&(s.textContent=u),n=d(a),y(o.$$.fragment,a)},m(a,f){l(a,s,f),l(a,n,f),_(o,a,f),g=!0},p:W,i(a){g||(w(o.$$.fragment,a),g=!0)},o(a){b(o.$$.fragment,a),g=!1},d(a){a&&(t(s),t(n)),j(o,a)}}}function ud(I){let s,u,n,o,g,a,f,z,U,v,k="TAPAS",Z,B,$,M,A,F,q,Ir="Overview",Fa,Cs,Cr=`The TAPAS model was proposed in <a href="https://www.aclweb.org/anthology/2020.acl-main.398" rel="nofollow">TAPAS: Weakly Supervised Table Parsing via Pre-training</a>
by Jonathan Herzig, Paweł Krzysztof Nowak, Thomas Müller, Francesco Piccinno and Julian Martin Eisenschlos. It’s a BERT-based model specifically
designed (and pre-trained) for answering questions about tabular data. Compared to BERT, TAPAS uses relative position embeddings and has 7
token types that encode tabular structure. TAPAS is pre-trained on the masked language modeling (MLM) objective on a large dataset comprising
millions of tables from English Wikipedia and corresponding texts.`,Aa,Fs,Fr="For question answering, TAPAS has 2 heads on top: a cell selection head and an aggregation head, for (optionally) performing aggregations (such as counting or summing) among selected cells. TAPAS has been fine-tuned on several datasets:",Za,As,Ar='<li><a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> (Sequential Question Answering by Microsoft)</li> <li><a href="https://github.com/ppasupat/WikiTableQuestions" rel="nofollow">WTQ</a> (Wiki Table Questions by Stanford University)</li> <li><a href="https://github.com/salesforce/WikiSQL" rel="nofollow">WikiSQL</a> (by Salesforce).</li>',Ba,Zs,Zr="It achieves state-of-the-art on both SQA and WTQ, while having comparable performance to SOTA on WikiSQL, with a much simpler architecture.",za,Bs,Br="The abstract from the paper is the following:",$a,zs,zr="<em>Answering natural language questions over tables is usually seen as a semantic parsing task. To alleviate the collection cost of full logical forms, one popular approach focuses on weak supervision consisting of denotations instead of logical forms. However, training semantic parsers from weak supervision poses difficulties, and in addition, the generated logical forms are only used as an intermediate step prior to retrieving the denotation. In this paper, we present TAPAS, an approach to question answering over tables without generating logical forms. TAPAS trains from weak supervision, and predicts the denotation by selecting table cells and optionally applying a corresponding aggregation operator to such selection. TAPAS extends BERT’s architecture to encode tables as input, initializes from an effective joint pre-training of text segments and tables crawled from Wikipedia, and is trained end-to-end. We experiment with three different semantic parsing datasets, and find that TAPAS outperforms or rivals semantic parsing models by improving state-of-the-art accuracy on SQA from 55.1 to 67.2 and performing on par with the state-of-the-art on WIKISQL and WIKITQ, but with a simpler model architecture. We additionally find that transfer learning, which is trivial in our setting, from WIKISQL to WIKITQ, yields 48.7 accuracy, 4.2 points above the state-of-the-art.</em>",qa,$s,$r='In addition, the authors have further pre-trained TAPAS to recognize <strong>table entailment</strong>, by creating a balanced dataset of millions of automatically created training examples which are learned in an intermediate step prior to fine-tuning. The authors of TAPAS call this further pre-training intermediate pre-training (since TAPAS is first pre-trained on MLM, and then on another dataset). They found that intermediate pre-training further improves performance on SQA, achieving a new state-of-the-art as well as state-of-the-art on <a href="https://github.com/wenhuchen/Table-Fact-Checking" rel="nofollow">TabFact</a>, a large-scale dataset with 16k Wikipedia tables for table entailment (a binary classification task). For more details, see their follow-up paper: <a href="https://www.aclweb.org/anthology/2020.findings-emnlp.27/" rel="nofollow">Understanding tables with intermediate pre-training</a> by Julian Martin Eisenschlos, Syrine Krichene and Thomas Müller.',Wa,Ze,qr,xa,qs,Wr='TAPAS architecture. Taken from the <a href="https://ai.googleblog.com/2020/04/using-neural-networks-to-find-answers.html">original blog post</a>.',Ga,Ws,xr='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The Tensorflow version of this model was contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/google-research/tapas" rel="nofollow">here</a>.',Na,xs,Gr="Tips:",Ra,Gs,Nr='<li>TAPAS is a model that uses relative position embeddings by default (restarting the position embeddings at every cell of the table). Note that this is something that was added after the publication of the original TAPAS paper. According to the authors, this usually results in a slightly better performance, and allows you to encode longer sequences without running out of embeddings. This is reflected in the <code>reset_position_index_per_cell</code> parameter of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>, which is set to <code>True</code> by default. The default versions of the models available on the <a href="https://huggingface.co/models?search=tapas" rel="nofollow">hub</a> all use relative position embeddings. You can still use the ones with absolute position embeddings by passing in an additional argument <code>revision=&quot;no_reset&quot;</code> when calling the <code>from_pretrained()</code> method. Note that it’s usually advised to pad the inputs on the right rather than the left.</li> <li>TAPAS is based on BERT, so <code>TAPAS-base</code> for example corresponds to a <code>BERT-base</code> architecture. Of course, <code>TAPAS-large</code> will result in the best performance (the results reported in the paper are from <code>TAPAS-large</code>). Results of the various sized models are shown on the <a href="https://github.com/google-research/tapas%3E" rel="nofollow">original Github repository</a>.</li> <li>TAPAS has checkpoints fine-tuned on SQA, which are capable of answering questions related to a table in a conversational set-up. This means that you can ask follow-up questions such as “what is his age?” related to the previous question. Note that the forward pass of TAPAS is a bit different in case of a conversational set-up: in that case, you have to feed every table-question pair one by one to the model, such that the <code>prev_labels</code> token type ids can be overwritten by the predicted <code>labels</code> of the model to the previous question. See “Usage” section for more info.</li> <li>TAPAS is similar to BERT and therefore relies on the masked language modeling (MLM) objective. It is therefore efficient at predicting masked tokens and at NLU in general, but is not optimal for text generation. Models trained with a causal language modeling (CLM) objective are better in that regard. Note that TAPAS can be used as an encoder in the EncoderDecoderModel framework, to combine it with an autoregressive text decoder such as GPT-2.</li>',Qa,fe,Be,ea,Ns,Ho,Yt,Rr="Usage: fine-tuning",Va,Rs,Qr='Here we explain how you can fine-tune <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> on your own dataset.',Ea,Qs,Vr="<strong>STEP 1: Choose one of the 3 ways in which you can use TAPAS - or experiment</strong>",Xa,Vs,Er='Basically, there are 3 different ways in which one can fine-tune <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a>, corresponding to the different datasets on which Tapas was fine-tuned:',Sa,Es,Xr="<li>SQA: if you’re interested in asking follow-up questions related to a table, in a conversational set-up. For example if you first ask “what’s the name of the first actor?” then you can ask a follow-up question such as “how old is he?“. Here, questions do not involve any aggregation (all questions are cell selection questions).</li> <li>WTQ: if you’re not interested in asking questions in a conversational set-up, but rather just asking questions related to a table, which might involve aggregation, such as counting a number of rows, summing up cell values or averaging cell values. You can then for example ask “what’s the total number of goals Cristiano Ronaldo made in his career?“. This case is also called <strong>weak supervision</strong>, since the model itself must learn the appropriate aggregation operator (SUM/COUNT/AVERAGE/NONE) given only the answer to the question as supervision.</li> <li>WikiSQL-supervised: this dataset is based on WikiSQL with the model being given the ground truth aggregation operator during training. This is also called <strong>strong supervision</strong>. Here, learning the appropriate aggregation operator is much easier.</li>",Ha,Xs,Sr="To summarize:",Ya,Ss,Hr="<thead><tr><th><strong>Task</strong></th> <th><strong>Example dataset</strong></th> <th><strong>Description</strong></th></tr></thead> <tbody><tr><td>Conversational</td> <td>SQA</td> <td>Conversational, only cell selection questions</td></tr> <tr><td>Weak supervision for aggregation</td> <td>WTQ</td> <td>Questions might involve aggregation, and the model must learn this given only the answer as supervision</td></tr> <tr><td>Strong supervision for aggregation</td> <td>WikiSQL-supervised</td> <td>Questions might involve aggregation, and the model must learn this given the gold aggregation operator</td></tr></tbody>",La,ze,Pa,Hs,Yr='What you can also do is start from an already fine-tuned checkpoint. A note here is that the already fine-tuned checkpoint on WTQ has some issues due to the L2-loss which is somewhat brittle. See <a href="https://github.com/google-research/tapas/issues/91#issuecomment-735719340" rel="nofollow">here</a> for more info.',Da,Ys,Lr='For a list of all pre-trained and fine-tuned TAPAS checkpoints available on HuggingFace’s  hub, see <a href="https://huggingface.co/models?search=tapas" rel="nofollow">here</a>.',Oa,Ls,Pr="<strong>STEP 2: Prepare your data in the SQA format</strong>",Ka,Ps,Dr='Second, no matter what you picked above, you should prepare your dataset in the <a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> format. This format is a TSV/CSV file with the following columns:',eo,Ds,Or="<li><code>id</code>: optional, id of the table-question pair, for bookkeeping purposes.</li> <li><code>annotator</code>: optional, id of the person who annotated the table-question pair, for bookkeeping purposes.</li> <li><code>position</code>: integer indicating if the question is the first, second, third,… related to the table. Only required in case of conversational setup (SQA). You don’t need this column in case you’re going for WTQ/WikiSQL-supervised.</li> <li><code>question</code>: string</li> <li><code>table_file</code>: string, name of a csv file containing the tabular data</li> <li><code>answer_coordinates</code>: list of one or more tuples (each tuple being a cell coordinate, i.e. row, column pair that is part of the answer)</li> <li><code>answer_text</code>: list of one or more strings (each string being a cell value that is part of the answer)</li> <li><code>aggregation_label</code>: index of the aggregation operator. Only required in case of strong supervision for aggregation (the WikiSQL-supervised case)</li> <li><code>float_answer</code>: the float answer to the question, if there is one (np.nan if there isn’t). Only required in case of weak supervision for aggregation (such as WTQ and WikiSQL)</li>",so,Os,Kr='The tables themselves should be present in a folder, each table being a separate csv file. Note that the authors of the TAPAS algorithm used conversion scripts with some automated logic to convert the other datasets (WTQ, WikiSQL) into the SQA format. The author explains this <a href="https://github.com/google-research/tapas/issues/50#issuecomment-705465960" rel="nofollow">here</a>. A conversion of this script that works with HuggingFace’s implementation can be found <a href="https://github.com/NielsRogge/tapas_utils" rel="nofollow">here</a>. Interestingly, these conversion scripts are not perfect (the <code>answer_coordinates</code> and <code>float_answer</code> fields are populated based on the <code>answer_text</code>), meaning that WTQ and WikiSQL results could actually be improved.',to,Ks,ei="<strong>STEP 3: Convert your data into tensors using TapasTokenizer</strong>",no,$e,ao,et,si=`Note that here, we encode each table-question pair independently. This is fine as long as your dataset is <strong>not conversational</strong>. In case your dataset involves conversational questions (such as in SQA), then you should first group together the <code>queries</code>, <code>answer_coordinates</code> and <code>answer_text</code> per table (in the order of their <code>position</code>
index) and batch encode each table with its questions. This will make sure that the <code>prev_labels</code> token types (see docs of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>) are set correctly. See <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> for more info. See <a href="https://github.com/kamalkraj/Tapas-Tutorial/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> for more info regarding using the TensorFlow model.`,oo,st,ti="**STEP 4: Train (fine-tune) the model",lo,qe,ro,Me,We,sa,tt,Yo,Lt,ni="Usage: inference",io,xe,co,nt,ai='In case of a conversational set-up, then each table-question pair must be provided <strong>sequentially</strong> to the model, such that the <code>prev_labels</code> token types can be overwritten by the predicted <code>labels</code> of the previous table-question pair. Again, more info can be found in <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> (for PyTorch) and <a href="https://github.com/kamalkraj/Tapas-Tutorial/blob/master/TAPAS/Fine_tuning_TapasForQuestionAnswering_on_SQA.ipynb" rel="nofollow">this notebook</a> (for TensorFlow).',po,Te,Ge,ta,at,Lo,Pt,oi="Documentation resources",ho,ot,li='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li>',mo,ye,Ne,na,lt,Po,Dt,ri="TAPAS specific outputs",uo,_e,rt,Do,Ot,ii='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a>.',go,we,Re,aa,it,Oo,Kt,ci="TapasConfig",fo,Y,ct,Ko,en,di=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>. It is used to instantiate a TAPAS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the TAPAS
<a href="https://huggingface.co/google/tapas-base-finetuned-sqa" rel="nofollow">google/tapas-base-finetuned-sqa</a> architecture.`,el,sn,pi=`Configuration objects inherit from <code>PreTrainedConfig</code> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,sl,tn,hi=`Hyperparameters additional to BERT are taken from run_task_main.py and hparam_utils.py of the original
implementation. Original implementation available at <a href="https://github.com/google-research/tapas/tree/master" rel="nofollow">https://github.com/google-research/tapas/tree/master</a>.`,tl,Qe,Mo,be,Ve,oa,dt,nl,nn,mi="TapasTokenizer",To,G,pt,al,an,ui=`Construct a TAPAS tokenizer. Based on WordPiece. Flattens a table and one or more related sentences to be used by
TAPAS models.`,ol,on,gi=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods. <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> creates several token type ids to
encode tabular structure. To be more precise, it adds 7 token type ids, in the following order: <code>segment_ids</code>,
<code>column_ids</code>, <code>row_ids</code>, <code>prev_labels</code>, <code>column_ranks</code>, <code>inv_column_ranks</code> and <code>numeric_relations</code>:`,ll,ln,fi=`<li>segment_ids: indicate whether a token belongs to the question (0) or the table (1). 0 for special tokens and
padding.</li> <li>column_ids: indicate to which column of the table a token belongs (starting from 1). Is 0 for all question
tokens, special tokens and padding.</li> <li>row_ids: indicate to which row of the table a token belongs (starting from 1). Is 0 for all question tokens,
special tokens and padding. Tokens of column headers are also 0.</li> <li>prev_labels: indicate whether a token was (part of) an answer to the previous question (1) or not (0). Useful in
a conversational setup (such as SQA).</li> <li>column_ranks: indicate the rank of a table token relative to a column, if applicable. For example, if you have a
column “number of movies” with values 87, 53 and 69, then the column ranks of these tokens are 3, 1 and 2
respectively. 0 for all question tokens, special tokens and padding.</li> <li>inv_column_ranks: indicate the inverse rank of a table token relative to a column, if applicable. For example, if
you have a column “number of movies” with values 87, 53 and 69, then the inverse column ranks of these tokens are
1, 3 and 2 respectively. 0 for all question tokens, special tokens and padding.</li> <li>numeric_relations: indicate numeric relations between the question and the tokens of the table. 0 for all
question tokens, special tokens and padding.</li>`,rl,rn,Mi=`<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> runs end-to-end tokenization on a table and associated sentences: punctuation splitting and
wordpiece.`,il,Ee,ht,cl,cn,Ti="Main method to tokenize and prepare for the model one or several sequence(s) related to a table.",dl,me,mt,pl,dn,yi=`Converts logits of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> to actual predicted answer coordinates and optional
aggregation indices.`,hl,pn,_i=`The original implementation, on which this function is based, can be found
<a href="https://github.com/google-research/tapas/blob/4908213eb4df7aa988573350278b44c4dbe3f71b/tapas/experiments/prediction_utils.py#L288" rel="nofollow">here</a>.`,ml,hn,ut,yo,je,Xe,la,gt,ul,mn,wi="TapasModel",_o,R,ft,gl,un,bi=`The bare Tapas Model transformer outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,fl,gn,ji=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ml,fn,Ji='This class is a small change compared to <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertModel">BertModel</a>, taking into account the additional token type ids.',Tl,Mn,Ui=`The model can behave as an encoder (with only self-attention) as well as a decoder, in which case a layer of
cross-attention is added between the self-attention layers, following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is
all you need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit,
Llion Jones, Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,yl,K,Mt,_l,Tn,vi='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> forward method, overrides the <code>__call__</code> special method.',wl,Se,bl,He,wo,Je,Ye,ra,Tt,jl,yn,ki="TapasForMaskedLM",bo,D,yt,Jl,_n,Ii=`Tapas Model with a <code>language modeling</code> head on top.
This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ul,wn,Ci=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,vl,ee,_t,kl,bn,Fi='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Il,Le,Cl,Pe,jo,Ue,De,ia,wt,Fl,jn,Ai="TapasForSequenceClassification",Jo,L,bt,Al,Jn,Zi=`Tapas Model with a sequence classification head on top (a linear layer on top of the pooled output), e.g. for table
entailment tasks, such as TabFact (Chen et al., 2020).`,Zl,Un,Bi=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bl,vn,zi=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zl,se,jt,$l,kn,$i='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForSequenceClassification">TapasForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ql,Oe,Wl,Ke,Uo,ve,es,ca,Jt,xl,In,qi="TapasForQuestionAnswering",vo,P,Ut,Gl,Cn,Wi=`Tapas Model with a cell selection head and optional aggregation head on top for question-answering tasks on tables
(linear layers on top of the hidden-states output to compute <code>logits</code> and optional <code>logits_aggregation</code>), e.g. for
SQA, WTQ or WikiSQL-supervised tasks.`,Nl,Fn,xi=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its models (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rl,An,Gi=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ql,te,vt,Vl,Zn,Ni='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',El,ss,Xl,ts,ko,ke,ns,da,kt,Sl,Bn,Ri="TFTapasModel",Io,Q,It,Hl,zn,Qi="The bare Tapas Model transformer outputting raw hidden-states without any specific head on top.",Yl,$n,Vi=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ll,qn,Ei=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Pl,as,Dl,ne,Ct,Ol,Wn,Xi='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> forward method, overrides the <code>__call__</code> special method.',Kl,os,er,ls,Co,Ie,rs,pa,Ft,sr,xn,Si="TFTapasForMaskedLM",Fo,V,At,tr,Gn,Hi="Tapas Model with a <code>language modeling</code> head on top.",nr,Nn,Yi=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ar,Rn,Li=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,or,is,lr,ae,Zt,rr,Qn,Pi='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',ir,cs,cr,ds,Ao,Ce,ps,ha,Bt,dr,Vn,Di="TFTapasForSequenceClassification",Zo,E,zt,pr,En,Oi=`Tapas Model with a sequence classification head on top (a linear layer on top of the pooled output), e.g. for table
entailment tasks, such as TabFact (Chen et al., 2020).`,hr,Xn,Ki=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mr,Sn,ec=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,ur,hs,gr,oe,$t,fr,Hn,sc='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForSequenceClassification">TFTapasForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Mr,ms,Tr,us,Bo,Fe,gs,ma,qt,yr,Yn,tc="TFTapasForQuestionAnswering",zo,X,Wt,_r,Ln,nc=`Tapas Model with a cell selection head and optional aggregation head on top for question-answering tasks on tables
(linear layers on top of the hidden-states output to compute <code>logits</code> and optional <code>logits_aggregation</code>), e.g. for
SQA, WTQ or WikiSQL-supervised tasks.`,wr,Pn,ac=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,br,Dn,oc=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,jr,fs,Jr,le,xt,Ur,On,lc='The <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',vr,Ms,kr,Ts,$o,ua,qo;return z=new H({}),A=new H({}),Ns=new H({}),ze=new So({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[zc],pytorch:[Zc]},$$scope:{ctx:I}}}),$e=new So({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[xc],pytorch:[qc]},$$scope:{ctx:I}}}),qe=new So({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Qc],pytorch:[Nc]},$$scope:{ctx:I}}}),tt=new H({}),xe=new So({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Sc],pytorch:[Ec]},$$scope:{ctx:I}}}),at=new H({}),lt=new H({}),rt=new x({props:{name:"class transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"logits_aggregation",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) &#x2014;
Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.`,name:"loss"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Prediction scores of the cell selection head, for every token.`,name:"logits"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.logits_aggregation",description:`<strong>logits_aggregation</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) &#x2014;
Prediction scores of the aggregation head, for every aggregation operator.`,name:"logits_aggregation"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L98"}}),it=new H({}),ct=new x({props:{name:"class transformers.TapasConfig",anchor:"transformers.TapasConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 1024"},{name:"type_vocab_sizes",val:" = [3, 256, 256, 2, 256, 256, 10]"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"positive_label_weight",val:" = 10.0"},{name:"num_aggregation_labels",val:" = 0"},{name:"aggregation_loss_weight",val:" = 1.0"},{name:"use_answer_as_supervision",val:" = None"},{name:"answer_loss_importance",val:" = 1.0"},{name:"use_normalized_answer_loss",val:" = False"},{name:"huber_loss_delta",val:" = None"},{name:"temperature",val:" = 1.0"},{name:"aggregation_temperature",val:" = 1.0"},{name:"use_gumbel_for_cells",val:" = False"},{name:"use_gumbel_for_aggregation",val:" = False"},{name:"average_approximation_function",val:" = 'ratio'"},{name:"cell_selection_preference",val:" = None"},{name:"answer_loss_cutoff",val:" = None"},{name:"max_num_rows",val:" = 64"},{name:"max_num_columns",val:" = 32"},{name:"average_logits_per_cell",val:" = False"},{name:"select_one_column",val:" = True"},{name:"allow_empty_column_selection",val:" = False"},{name:"init_cell_selection_weights_to_zero",val:" = False"},{name:"reset_position_index_per_cell",val:" = True"},{name:"disable_per_token_loss",val:" = False"},{name:"aggregation_labels",val:" = None"},{name:"no_aggregation_label_index",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the TAPAS model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>.`,name:"vocab_size"},{anchor:"transformers.TapasConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.TapasConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TapasConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TapasConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TapasConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;swish&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TapasConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.TapasConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.TapasConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TapasConfig.type_vocab_sizes",description:`<strong>type_vocab_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 256, 256, 2, 256, 256, 10]</code>) &#x2014;
The vocabulary sizes of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasModel">TapasModel</a>.`,name:"type_vocab_sizes"},{anchor:"transformers.TapasConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TapasConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TapasConfig.positive_label_weight",description:`<strong>positive_label_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
Weight for positive labels.`,name:"positive_label_weight"},{anchor:"transformers.TapasConfig.num_aggregation_labels",description:`<strong>num_aggregation_labels</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The number of aggregation operators to predict.`,name:"num_aggregation_labels"},{anchor:"transformers.TapasConfig.aggregation_loss_weight",description:`<strong>aggregation_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Importance weight for the aggregation loss.`,name:"aggregation_loss_weight"},{anchor:"transformers.TapasConfig.use_answer_as_supervision",description:`<strong>use_answer_as_supervision</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the answer as the only supervision for aggregation examples.`,name:"use_answer_as_supervision"},{anchor:"transformers.TapasConfig.answer_loss_importance",description:`<strong>answer_loss_importance</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Importance weight for the regression loss.`,name:"answer_loss_importance"},{anchor:"transformers.TapasConfig.use_normalized_answer_loss",description:`<strong>use_normalized_answer_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the answer loss by the maximum of the predicted and expected value.`,name:"use_normalized_answer_loss"},{anchor:"transformers.TapasConfig.huber_loss_delta",description:`<strong>huber_loss_delta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Delta parameter used to calculate the regression loss.`,name:"huber_loss_delta"},{anchor:"transformers.TapasConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Value used to control (OR change) the skewness of cell logits probabilities.`,name:"temperature"},{anchor:"transformers.TapasConfig.aggregation_temperature",description:`<strong>aggregation_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Scales aggregation logits to control the skewness of probabilities.`,name:"aggregation_temperature"},{anchor:"transformers.TapasConfig.use_gumbel_for_cells",description:`<strong>use_gumbel_for_cells</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply Gumbel-Softmax to cell selection.`,name:"use_gumbel_for_cells"},{anchor:"transformers.TapasConfig.use_gumbel_for_aggregation",description:`<strong>use_gumbel_for_aggregation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply Gumbel-Softmax to aggregation selection.`,name:"use_gumbel_for_aggregation"},{anchor:"transformers.TapasConfig.average_approximation_function",description:`<strong>average_approximation_function</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;ratio&quot;</code>) &#x2014;
Method to calculate the expected average of cells in the weak supervision case. One of <code>&quot;ratio&quot;</code>,
<code>&quot;first_order&quot;</code> or <code>&quot;second_order&quot;</code>.`,name:"average_approximation_function"},{anchor:"transformers.TapasConfig.cell_selection_preference",description:`<strong>cell_selection_preference</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Preference for cell selection in ambiguous cases. Only applicable in case of weak supervision for
aggregation (WTQ, WikiSQL). If the total mass of the aggregation probabilities (excluding the &#x201C;NONE&#x201D;
operator) is higher than this hyperparameter, then aggregation is predicted for an example.`,name:"cell_selection_preference"},{anchor:"transformers.TapasConfig.answer_loss_cutoff",description:`<strong>answer_loss_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Ignore examples with answer loss larger than cutoff.`,name:"answer_loss_cutoff"},{anchor:"transformers.TapasConfig.max_num_rows",description:`<strong>max_num_rows</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Maximum number of rows.`,name:"max_num_rows"},{anchor:"transformers.TapasConfig.max_num_columns",description:`<strong>max_num_columns</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Maximum number of columns.`,name:"max_num_columns"},{anchor:"transformers.TapasConfig.average_logits_per_cell",description:`<strong>average_logits_per_cell</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to average logits per cell.`,name:"average_logits_per_cell"},{anchor:"transformers.TapasConfig.select_one_column",description:`<strong>select_one_column</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to constrain the model to only select cells from a single column.`,name:"select_one_column"},{anchor:"transformers.TapasConfig.allow_empty_column_selection",description:`<strong>allow_empty_column_selection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow not to select any column.`,name:"allow_empty_column_selection"},{anchor:"transformers.TapasConfig.init_cell_selection_weights_to_zero",description:`<strong>init_cell_selection_weights_to_zero</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to initialize cell selection weights to 0 so that the initial probabilities are 50%.`,name:"init_cell_selection_weights_to_zero"},{anchor:"transformers.TapasConfig.reset_position_index_per_cell",description:`<strong>reset_position_index_per_cell</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to restart position indexes at every cell (i.e. use relative position embeddings).`,name:"reset_position_index_per_cell"},{anchor:"transformers.TapasConfig.disable_per_token_loss",description:`<strong>disable_per_token_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable any (strong or weak) supervision on cells.`,name:"disable_per_token_loss"},{anchor:"transformers.TapasConfig.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>Dict[int, label]</code>, <em>optional</em>) &#x2014;
The aggregation labels used to aggregate the results. For example, the WTQ models have the following
aggregation labels: <code>{0: &quot;NONE&quot;, 1: &quot;SUM&quot;, 2: &quot;AVERAGE&quot;, 3: &quot;COUNT&quot;}</code>`,name:"aggregation_labels"},{anchor:"transformers.TapasConfig.no_aggregation_label_index",description:`<strong>no_aggregation_label_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the aggregation labels are defined and one of these labels represents &#x201C;No aggregation&#x201D;, this should be
set to its index. For example, the WTQ models have the &#x201C;NONE&#x201D; aggregation label at index 0, so that value
should be set to 0 for these models.`,name:"no_aggregation_label_index"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/configuration_tapas.py#L45"}}),Qe=new Ae({props:{anchor:"transformers.TapasConfig.example",$$slots:{default:[Hc]},$$scope:{ctx:I}}}),dt=new H({}),pt=new x({props:{name:"class transformers.TapasTokenizer",anchor:"transformers.TapasTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"empty_token",val:" = '[EMPTY]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"cell_trim_length",val:": int = -1"},{name:"max_column_id",val:": int = None"},{name:"max_row_id",val:": int = None"},{name:"strip_column_names",val:": bool = False"},{name:"update_answer_coordinates",val:": bool = False"},{name:"min_question_length",val:" = None"},{name:"max_question_length",val:" = None"},{name:"model_max_length",val:": int = 512"},{name:"additional_special_tokens",val:": typing.Optional[typing.List[str]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.TapasTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.TapasTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.TapasTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.TapasTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.TapasTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.TapasTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.TapasTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.TapasTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.TapasTokenizer.empty_token",description:`<strong>empty_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EMPTY]&quot;</code>) &#x2014;
The token used for empty cell values in a table. Empty cell values include &quot;&quot;, &#x201C;n/a&#x201D;, &#x201C;nan&#x201D; and &#x201D;?&#x201C;.`,name:"empty_token"},{anchor:"transformers.TapasTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.TapasTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.TapasTokenizer.cell_trim_length",description:`<strong>cell_trim_length</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
If &gt; 0: Trim cells so that the length is &lt;= this value. Also disables further cell trimming, should thus be
used with <code>truncation</code> set to <code>True</code>.`,name:"cell_trim_length"},{anchor:"transformers.TapasTokenizer.max_column_id",description:`<strong>max_column_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Max column id to extract.`,name:"max_column_id"},{anchor:"transformers.TapasTokenizer.max_row_id",description:`<strong>max_row_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Max row id to extract.`,name:"max_row_id"},{anchor:"transformers.TapasTokenizer.strip_column_names",description:`<strong>strip_column_names</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add empty strings instead of column names.`,name:"strip_column_names"},{anchor:"transformers.TapasTokenizer.update_answer_coordinates",description:`<strong>update_answer_coordinates</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to recompute the answer coordinates from the answer text.`,name:"update_answer_coordinates"},{anchor:"transformers.TapasTokenizer.min_question_length",description:`<strong>min_question_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Minimum length of each question in terms of tokens (will be skipped otherwise).`,name:"min_question_length"},{anchor:"transformers.TapasTokenizer.max_question_length",description:`<strong>max_question_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of each question in terms of tokens (will be skipped otherwise).`,name:"max_question_length"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/tokenization_tapas.py#L236"}}),ht=new x({props:{name:"__call__",anchor:"transformers.TapasTokenizer.__call__",parameters:[{name:"table",val:": pd.DataFrame"},{name:"queries",val:": typing.Union[str, typing.List[str], typing.List[int], typing.List[typing.List[str]], typing.List[typing.List[int]], NoneType] = None"},{name:"answer_coordinates",val:": typing.Union[typing.List[typing.Tuple], typing.List[typing.List[typing.Tuple]], NoneType] = None"},{name:"answer_text",val:": typing.Union[typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.models.tapas.tokenization_tapas.TapasTruncationStrategy] = False"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasTokenizer.__call__.table",description:`<strong>table</strong> (<code>pd.DataFrame</code>) &#x2014;
Table containing tabular data. Note that all cell values must be text. Use <em>.astype(str)</em> on a Pandas
dataframe to convert it to string.`,name:"table"},{anchor:"transformers.TapasTokenizer.__call__.queries",description:`<strong>queries</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
Question or batch of questions related to a table to be encoded. Note that in case of a batch, all
questions must refer to the <strong>same</strong> table.`,name:"queries"},{anchor:"transformers.TapasTokenizer.__call__.answer_coordinates",description:`<strong>answer_coordinates</strong> (<code>List[Tuple]</code> or <code>List[List[Tuple]]</code>, <em>optional</em>) &#x2014;
Answer coordinates of each table-question pair in the batch. In case only a single table-question pair
is provided, then the answer_coordinates must be a single list of one or more tuples. Each tuple must
be a (row_index, column_index) pair. The first data row (not the column header row) has index 0. The
first column has index 0. In case a batch of table-question pairs is provided, then the
answer_coordinates must be a list of lists of tuples (each list corresponding to a single
table-question pair).`,name:"answer_coordinates"},{anchor:"transformers.TapasTokenizer.__call__.answer_text",description:`<strong>answer_text</strong> (<code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Answer text of each table-question pair in the batch. In case only a single table-question pair is
provided, then the answer_text must be a single list of one or more strings. Each string must be the
answer text of a corresponding answer coordinate. In case a batch of table-question pairs is provided,
then the answer_coordinates must be a list of lists of strings (each list corresponding to a single
table-question pair).`,name:"answer_text"},{anchor:"transformers.TapasTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.TapasTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.TapasTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <code>TapasTruncationStrategy</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;drop_rows_to_fit&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code>
or to the maximum acceptable input length for the model if that argument is not provided. This will
truncate row by row, removing rows from the table.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.TapasTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.TapasTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.TapasTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.TapasTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/tokenization_tapas.py#L575"}}),mt=new x({props:{name:"convert_logits_to_predictions",anchor:"transformers.TapasTokenizer.convert_logits_to_predictions",parameters:[{name:"data",val:""},{name:"logits",val:""},{name:"logits_agg",val:" = None"},{name:"cell_classification_threshold",val:" = 0.5"}],parametersDescription:[{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary mapping features to actual values. Should be created using <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a>.`,name:"data"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.logits",description:`<strong>logits</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Tensor containing the logits at the token level.`,name:"logits"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.logits_agg",description:`<strong>logits_agg</strong> (<code>torch.Tensor</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_aggregation_labels)</code>, <em>optional</em>) &#x2014;
Tensor containing the aggregation logits.`,name:"logits_agg"},{anchor:"transformers.TapasTokenizer.convert_logits_to_predictions.cell_classification_threshold",description:`<strong>cell_classification_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to be used for cell selection. All table cells for which their probability is larger than
this threshold will be selected.`,name:"cell_classification_threshold"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/tokenization_tapas.py#L1938",returnDescription:`
<ul>
<li>predicted_answer_coordinates (<code>List[List[[tuple]]</code> of length <code>batch_size</code>): Predicted answer coordinates
as a list of lists of tuples. Each element in the list contains the predicted answer coordinates of a
single example in the batch, as a list of tuples. Each tuple is a cell, i.e. (row index, column index).</li>
<li>predicted_aggregation_indices (<code>List[int]</code>of length <code>batch_size</code>, <em>optional</em>, returned when
<code>logits_aggregation</code> is provided): Predicted aggregation operator indices of the aggregation head.</li>
</ul>
`,returnType:`
<p><code>tuple</code> comprising various elements depending on the inputs</p>
`}}),ut=new x({props:{name:"save_vocabulary",anchor:"transformers.TapasTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/tokenization_tapas.py#L443"}}),gt=new H({}),ft=new x({props:{name:"class transformers.TapasModel",anchor:"transformers.TapasModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.TapasModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L848"}}),Mt=new x({props:{name:"forward",anchor:"transformers.TapasModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TapasModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L885",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Se=new he({props:{$$slots:{default:[Yc]},$$scope:{ctx:I}}}),He=new Ae({props:{anchor:"transformers.TapasModel.forward.example",$$slots:{default:[Lc]},$$scope:{ctx:I}}}),Tt=new H({}),yt=new x({props:{name:"class transformers.TapasForMaskedLM",anchor:"transformers.TapasForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TapasForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L1001"}}),_t=new x({props:{name:"forward",anchor:"transformers.TapasForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapasForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForMaskedLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L1021",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Le=new he({props:{$$slots:{default:[Pc]},$$scope:{ctx:I}}}),Pe=new Ae({props:{anchor:"transformers.TapasForMaskedLM.forward.example",$$slots:{default:[Dc]},$$scope:{ctx:I}}}),wt=new H({}),bt=new x({props:{name:"class transformers.TapasForSequenceClassification",anchor:"transformers.TapasForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TapasForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L1462"}}),jt=new x({props:{name:"forward",anchor:"transformers.TapasForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TapasForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy). Note: this is called
&#x201C;classification_class_index&#x201D; in the original implementation.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L1474",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Oe=new he({props:{$$slots:{default:[Oc]},$$scope:{ctx:I}}}),Ke=new Ae({props:{anchor:"transformers.TapasForSequenceClassification.forward.example",$$slots:{default:[Kc]},$$scope:{ctx:I}}}),Jt=new H({}),Ut=new x({props:{name:"class transformers.TapasForQuestionAnswering",anchor:"transformers.TapasForQuestionAnswering",parameters:[{name:"config",val:": TapasConfig"}],parametersDescription:[{anchor:"transformers.TapasForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L1117"}}),vt=new x({props:{name:"forward",anchor:"transformers.TapasForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"table_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"aggregation_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"float_answer",val:": typing.Optional[torch.FloatTensor] = None"},{name:"numeric_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"numeric_values_scale",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TapasForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TapasForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: - 1
indicates the head is <strong>not masked</strong>, - 0 indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TapasForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TapasForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TapasForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TapasForQuestionAnswering.forward.table_mask",description:`<strong>table_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Mask for the table. Indicates which tokens belong to the table (1). Question tokens, table headers and
padding are 0.`,name:"table_mask"},{anchor:"transformers.TapasForQuestionAnswering.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Labels per token for computing the hierarchical cell selection loss. This encodes the positions of the
answer appearing in the table. Can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.</p>
<ul>
<li>1 for tokens that are <strong>part of the answer</strong>,</li>
<li>0 for tokens that are <strong>not part of the answer</strong>.</li>
</ul>`,name:"labels"},{anchor:"transformers.TapasForQuestionAnswering.forward.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Aggregation function index for every example in the batch for computing the aggregation loss. Indices
should be in <code>[0, ..., config.num_aggregation_labels - 1]</code>. Only required in case of strong supervision for
aggregation (WikiSQL-supervised).`,name:"aggregation_labels"},{anchor:"transformers.TapasForQuestionAnswering.forward.float_answer",description:`<strong>float_answer</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Float answer for every example in the batch. Set to <em>float(&#x2018;nan&#x2019;)</em> for cell selection questions. Only
required in case of weak supervision (WTQ) to calculate the aggregate mask and regression loss.`,name:"float_answer"},{anchor:"transformers.TapasForQuestionAnswering.forward.numeric_values",description:`<strong>numeric_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Numeric values of every token, NaN for tokens which are not numeric values. Can be obtained using
<a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case of weak supervision for aggregation (WTQ) to calculate the
regression loss.`,name:"numeric_values"},{anchor:"transformers.TapasForQuestionAnswering.forward.numeric_values_scale",description:`<strong>numeric_values_scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Scale of the numeric values of every token. Can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case
of weak supervision for aggregation (WTQ) to calculate the regression loss.`,name:"numeric_values_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tapas.py#L1152",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"
>transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) — Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Prediction scores of the cell selection head, for every token.</li>
<li><strong>logits_aggregation</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) — Prediction scores of the aggregation head, for every aggregation operator.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"
>transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ss=new he({props:{$$slots:{default:[ed]},$$scope:{ctx:I}}}),ts=new Ae({props:{anchor:"transformers.TapasForQuestionAnswering.forward.example",$$slots:{default:[sd]},$$scope:{ctx:I}}}),kt=new H({}),It=new x({props:{name:"class transformers.TFTapasModel",anchor:"transformers.TFTapasModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L974"}}),as=new he({props:{$$slots:{default:[td]},$$scope:{ctx:I}}}),Ct=new x({props:{name:"call",anchor:"transformers.TFTapasModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasModel.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasModel.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasModel.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L980",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),os=new he({props:{$$slots:{default:[nd]},$$scope:{ctx:I}}}),ls=new Ae({props:{anchor:"transformers.TFTapasModel.call.example",$$slots:{default:[ad]},$$scope:{ctx:I}}}),Ft=new H({}),At=new x({props:{name:"class transformers.TFTapasForMaskedLM",anchor:"transformers.TFTapasForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L1038"}}),is=new he({props:{$$slots:{default:[od]},$$scope:{ctx:I}}}),Zt=new x({props:{name:"call",anchor:"transformers.TFTapasForMaskedLM.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForMaskedLM.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForMaskedLM.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForMaskedLM.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForMaskedLM.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForMaskedLM.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForMaskedLM.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForMaskedLM.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForMaskedLM.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForMaskedLM.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> or <code>np.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L1054",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFMaskedLMOutput"
>transformers.modeling_tf_outputs.TFMaskedLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),cs=new he({props:{$$slots:{default:[ld]},$$scope:{ctx:I}}}),ds=new Ae({props:{anchor:"transformers.TFTapasForMaskedLM.call.example",$$slots:{default:[rd]},$$scope:{ctx:I}}}),Bt=new H({}),zt=new x({props:{name:"class transformers.TFTapasForSequenceClassification",anchor:"transformers.TFTapasForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L1563"}}),hs=new he({props:{$$slots:{default:[id]},$$scope:{ctx:I}}}),$t=new x({props:{name:"call",anchor:"transformers.TFTapasForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy). Note: this is called
&#x201C;classification_class_index&#x201D; in the original implementation.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L1574",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),ms=new he({props:{$$slots:{default:[cd]},$$scope:{ctx:I}}}),us=new Ae({props:{anchor:"transformers.TFTapasForSequenceClassification.call.example",$$slots:{default:[dd]},$$scope:{ctx:I}}}),qt=new H({}),Wt=new x({props:{name:"class transformers.TFTapasForQuestionAnswering",anchor:"transformers.TFTapasForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFTapasForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L1238"}}),fs=new he({props:{$$slots:{default:[pd]},$$scope:{ctx:I}}}),xt=new x({props:{name:"call",anchor:"transformers.TFTapasForQuestionAnswering.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"table_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"aggregation_labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"float_answer",val:": np.ndarray | tf.Tensor | None = None"},{name:"numeric_values",val:": np.ndarray | tf.Tensor | None = None"},{name:"numeric_values_scale",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFTapasForQuestionAnswering.call.input_ids",description:`<strong>input_ids</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> \`<code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, 7)</code>, <em>optional</em>) &#x2014;
Token indices that encode tabular structure. Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See this
class for more info.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. If
<code>reset_position_index_per_cell</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> is set to <code>True</code>, relative position embeddings will be
used. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFTapasForQuestionAnswering.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFTapasForQuestionAnswering.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFTapasForQuestionAnswering.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFTapasForQuestionAnswering.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFTapasForQuestionAnswering.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFTapasForQuestionAnswering.call.table_mask",description:`<strong>table_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Mask for the table. Indicates which tokens belong to the table (1). Question tokens, table headers and
padding are 0.`,name:"table_mask"},{anchor:"transformers.TFTapasForQuestionAnswering.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Labels per token for computing the hierarchical cell selection loss. This encodes the positions of the
answer appearing in the table. Can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.</p>
<ul>
<li>1 for tokens that are <strong>part of the answer</strong>,</li>
<li>0 for tokens that are <strong>not part of the answer</strong>.</li>
</ul>`,name:"labels"},{anchor:"transformers.TFTapasForQuestionAnswering.call.aggregation_labels",description:`<strong>aggregation_labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Aggregation function index for every example in the batch for computing the aggregation loss. Indices
should be in <code>[0, ..., config.num_aggregation_labels - 1]</code>. Only required in case of strong supervision for
aggregation (WikiSQL-supervised).`,name:"aggregation_labels"},{anchor:"transformers.TFTapasForQuestionAnswering.call.float_answer",description:`<strong>float_answer</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
Float answer for every example in the batch. Set to <em>float(&#x2018;nan&#x2019;)</em> for cell selection questions. Only
required in case of weak supervision (WTQ) to calculate the aggregate mask and regression loss.`,name:"float_answer"},{anchor:"transformers.TFTapasForQuestionAnswering.call.numeric_values",description:`<strong>numeric_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Numeric values of every token, NaN for tokens which are not numeric values. Can be obtained using
<a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case of weak supervision for aggregation (WTQ) to calculate the
regression loss.`,name:"numeric_values"},{anchor:"transformers.TFTapasForQuestionAnswering.call.numeric_values_scale",description:`<strong>numeric_values_scale</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, seq_length)</code>, <em>optional</em>) &#x2014;
Scale of the numeric values of every token. Can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. Only required in case
of weak supervision for aggregation (WTQ) to calculate the regression loss.`,name:"numeric_values_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/tapas/modeling_tf_tapas.py#L1260",returnDescription:`
<p>A <code>transformers.models.tapas.modeling_tf_tapas.TFTableQuestionAnsweringOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/tapas#transformers.TapasConfig"
>TapasConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> (and possibly <code>answer</code>, <code>aggregation_labels</code>, <code>numeric_values</code> and <code>numeric_values_scale</code> are provided)) — Total loss as the sum of the hierarchical cell selection log-likelihood loss and (optionally) the
semi-supervised regression loss and (optionally) supervised loss for aggregations.</li>
<li><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) — Prediction scores of the cell selection head, for every token.</li>
<li><strong>logits_aggregation</strong> (<code>tf.Tensor</code>, <em>optional</em>, of shape <code>(batch_size, num_aggregation_labels)</code>) — Prediction scores of the aggregation head, for every aggregation operator.</li>
<li><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`
<p><code>transformers.models.tapas.modeling_tf_tapas.TFTableQuestionAnsweringOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Ms=new he({props:{$$slots:{default:[hd]},$$scope:{ctx:I}}}),Ts=new Ae({props:{anchor:"transformers.TFTapasForQuestionAnswering.call.example",$$slots:{default:[md]},$$scope:{ctx:I}}}),{c(){s=r("meta"),u=c(),n=r("p"),o=c(),g=r("h1"),a=r("a"),f=r("span"),T(z.$$.fragment),U=c(),v=r("span"),v.textContent=k,Z=c(),B=r("h2"),$=r("a"),M=r("span"),T(A.$$.fragment),F=c(),q=r("span"),q.textContent=Ir,Fa=c(),Cs=r("p"),Cs.innerHTML=Cr,Aa=c(),Fs=r("p"),Fs.textContent=Fr,Za=c(),As=r("ul"),As.innerHTML=Ar,Ba=c(),Zs=r("p"),Zs.textContent=Zr,za=c(),Bs=r("p"),Bs.textContent=Br,$a=c(),zs=r("p"),zs.innerHTML=zr,qa=c(),$s=r("p"),$s.innerHTML=$r,Wa=c(),Ze=r("img"),xa=c(),qs=r("small"),qs.innerHTML=Wr,Ga=c(),Ws=r("p"),Ws.innerHTML=xr,Na=c(),xs=r("p"),xs.textContent=Gr,Ra=c(),Gs=r("ul"),Gs.innerHTML=Nr,Qa=c(),fe=r("h2"),Be=r("a"),ea=r("span"),T(Ns.$$.fragment),Ho=c(),Yt=r("span"),Yt.textContent=Rr,Va=c(),Rs=r("p"),Rs.innerHTML=Qr,Ea=c(),Qs=r("p"),Qs.innerHTML=Vr,Xa=c(),Vs=r("p"),Vs.innerHTML=Er,Sa=c(),Es=r("ol"),Es.innerHTML=Xr,Ha=c(),Xs=r("p"),Xs.textContent=Sr,Ya=c(),Ss=r("table"),Ss.innerHTML=Hr,La=c(),T(ze.$$.fragment),Pa=c(),Hs=r("p"),Hs.innerHTML=Yr,Da=c(),Ys=r("p"),Ys.innerHTML=Lr,Oa=c(),Ls=r("p"),Ls.innerHTML=Pr,Ka=c(),Ps=r("p"),Ps.innerHTML=Dr,eo=c(),Ds=r("ul"),Ds.innerHTML=Or,so=c(),Os=r("p"),Os.innerHTML=Kr,to=c(),Ks=r("p"),Ks.innerHTML=ei,no=c(),T($e.$$.fragment),ao=c(),et=r("p"),et.innerHTML=si,oo=c(),st=r("p"),st.textContent=ti,lo=c(),T(qe.$$.fragment),ro=c(),Me=r("h2"),We=r("a"),sa=r("span"),T(tt.$$.fragment),Yo=c(),Lt=r("span"),Lt.textContent=ni,io=c(),T(xe.$$.fragment),co=c(),nt=r("p"),nt.innerHTML=ai,po=c(),Te=r("h2"),Ge=r("a"),ta=r("span"),T(at.$$.fragment),Lo=c(),Pt=r("span"),Pt.textContent=oi,ho=c(),ot=r("ul"),ot.innerHTML=li,mo=c(),ye=r("h2"),Ne=r("a"),na=r("span"),T(lt.$$.fragment),Po=c(),Dt=r("span"),Dt.textContent=ri,uo=c(),_e=r("div"),T(rt.$$.fragment),Do=c(),Ot=r("p"),Ot.innerHTML=ii,go=c(),we=r("h2"),Re=r("a"),aa=r("span"),T(it.$$.fragment),Oo=c(),Kt=r("span"),Kt.textContent=ci,fo=c(),Y=r("div"),T(ct.$$.fragment),Ko=c(),en=r("p"),en.innerHTML=di,el=c(),sn=r("p"),sn.innerHTML=pi,sl=c(),tn=r("p"),tn.innerHTML=hi,tl=c(),T(Qe.$$.fragment),Mo=c(),be=r("h2"),Ve=r("a"),oa=r("span"),T(dt.$$.fragment),nl=c(),nn=r("span"),nn.textContent=mi,To=c(),G=r("div"),T(pt.$$.fragment),al=c(),an=r("p"),an.textContent=ui,ol=c(),on=r("p"),on.innerHTML=gi,ll=c(),ln=r("ul"),ln.innerHTML=fi,rl=c(),rn=r("p"),rn.innerHTML=Mi,il=c(),Ee=r("div"),T(ht.$$.fragment),cl=c(),cn=r("p"),cn.textContent=Ti,dl=c(),me=r("div"),T(mt.$$.fragment),pl=c(),dn=r("p"),dn.innerHTML=yi,hl=c(),pn=r("p"),pn.innerHTML=_i,ml=c(),hn=r("div"),T(ut.$$.fragment),yo=c(),je=r("h2"),Xe=r("a"),la=r("span"),T(gt.$$.fragment),ul=c(),mn=r("span"),mn.textContent=wi,_o=c(),R=r("div"),T(ft.$$.fragment),gl=c(),un=r("p"),un.innerHTML=bi,fl=c(),gn=r("p"),gn.innerHTML=ji,Ml=c(),fn=r("p"),fn.innerHTML=Ji,Tl=c(),Mn=r("p"),Mn.innerHTML=Ui,yl=c(),K=r("div"),T(Mt.$$.fragment),_l=c(),Tn=r("p"),Tn.innerHTML=vi,wl=c(),T(Se.$$.fragment),bl=c(),T(He.$$.fragment),wo=c(),Je=r("h2"),Ye=r("a"),ra=r("span"),T(Tt.$$.fragment),jl=c(),yn=r("span"),yn.textContent=ki,bo=c(),D=r("div"),T(yt.$$.fragment),Jl=c(),_n=r("p"),_n.innerHTML=Ii,Ul=c(),wn=r("p"),wn.innerHTML=Ci,vl=c(),ee=r("div"),T(_t.$$.fragment),kl=c(),bn=r("p"),bn.innerHTML=Fi,Il=c(),T(Le.$$.fragment),Cl=c(),T(Pe.$$.fragment),jo=c(),Ue=r("h2"),De=r("a"),ia=r("span"),T(wt.$$.fragment),Fl=c(),jn=r("span"),jn.textContent=Ai,Jo=c(),L=r("div"),T(bt.$$.fragment),Al=c(),Jn=r("p"),Jn.textContent=Zi,Zl=c(),Un=r("p"),Un.innerHTML=Bi,Bl=c(),vn=r("p"),vn.innerHTML=zi,zl=c(),se=r("div"),T(jt.$$.fragment),$l=c(),kn=r("p"),kn.innerHTML=$i,ql=c(),T(Oe.$$.fragment),Wl=c(),T(Ke.$$.fragment),Uo=c(),ve=r("h2"),es=r("a"),ca=r("span"),T(Jt.$$.fragment),xl=c(),In=r("span"),In.textContent=qi,vo=c(),P=r("div"),T(Ut.$$.fragment),Gl=c(),Cn=r("p"),Cn.innerHTML=Wi,Nl=c(),Fn=r("p"),Fn.innerHTML=xi,Rl=c(),An=r("p"),An.innerHTML=Gi,Ql=c(),te=r("div"),T(vt.$$.fragment),Vl=c(),Zn=r("p"),Zn.innerHTML=Ni,El=c(),T(ss.$$.fragment),Xl=c(),T(ts.$$.fragment),ko=c(),ke=r("h2"),ns=r("a"),da=r("span"),T(kt.$$.fragment),Sl=c(),Bn=r("span"),Bn.textContent=Ri,Io=c(),Q=r("div"),T(It.$$.fragment),Hl=c(),zn=r("p"),zn.textContent=Qi,Yl=c(),$n=r("p"),$n.innerHTML=Vi,Ll=c(),qn=r("p"),qn.innerHTML=Ei,Pl=c(),T(as.$$.fragment),Dl=c(),ne=r("div"),T(Ct.$$.fragment),Ol=c(),Wn=r("p"),Wn.innerHTML=Xi,Kl=c(),T(os.$$.fragment),er=c(),T(ls.$$.fragment),Co=c(),Ie=r("h2"),rs=r("a"),pa=r("span"),T(Ft.$$.fragment),sr=c(),xn=r("span"),xn.textContent=Si,Fo=c(),V=r("div"),T(At.$$.fragment),tr=c(),Gn=r("p"),Gn.innerHTML=Hi,nr=c(),Nn=r("p"),Nn.innerHTML=Yi,ar=c(),Rn=r("p"),Rn.innerHTML=Li,or=c(),T(is.$$.fragment),lr=c(),ae=r("div"),T(Zt.$$.fragment),rr=c(),Qn=r("p"),Qn.innerHTML=Pi,ir=c(),T(cs.$$.fragment),cr=c(),T(ds.$$.fragment),Ao=c(),Ce=r("h2"),ps=r("a"),ha=r("span"),T(Bt.$$.fragment),dr=c(),Vn=r("span"),Vn.textContent=Di,Zo=c(),E=r("div"),T(zt.$$.fragment),pr=c(),En=r("p"),En.textContent=Oi,hr=c(),Xn=r("p"),Xn.innerHTML=Ki,mr=c(),Sn=r("p"),Sn.innerHTML=ec,ur=c(),T(hs.$$.fragment),gr=c(),oe=r("div"),T($t.$$.fragment),fr=c(),Hn=r("p"),Hn.innerHTML=sc,Mr=c(),T(ms.$$.fragment),Tr=c(),T(us.$$.fragment),Bo=c(),Fe=r("h2"),gs=r("a"),ma=r("span"),T(qt.$$.fragment),yr=c(),Yn=r("span"),Yn.textContent=tc,zo=c(),X=r("div"),T(Wt.$$.fragment),_r=c(),Ln=r("p"),Ln.innerHTML=nc,wr=c(),Pn=r("p"),Pn.innerHTML=ac,br=c(),Dn=r("p"),Dn.innerHTML=oc,jr=c(),T(fs.$$.fragment),Jr=c(),le=r("div"),T(xt.$$.fragment),Ur=c(),On=r("p"),On.innerHTML=lc,vr=c(),T(Ms.$$.fragment),kr=c(),T(Ts.$$.fragment),$o=c(),ua=r("p"),this.h()},l(e){const h=Fc("svelte-1phssyn",document.head);s=i(h,"META",{name:!0,content:!0}),h.forEach(t),u=d(e),n=i(e,"P",{}),C(n).forEach(t),o=d(e),g=i(e,"H1",{class:!0});var Gt=C(g);a=i(Gt,"A",{id:!0,class:!0,href:!0});var ga=C(a);f=i(ga,"SPAN",{});var fa=C(f);y(z.$$.fragment,fa),fa.forEach(t),ga.forEach(t),U=d(Gt),v=i(Gt,"SPAN",{"data-svelte-h":!0}),m(v)!=="svelte-bt3zkm"&&(v.textContent=k),Gt.forEach(t),Z=d(e),B=i(e,"H2",{class:!0});var Nt=C(B);$=i(Nt,"A",{id:!0,class:!0,href:!0});var Ma=C($);M=i(Ma,"SPAN",{});var Ta=C(M);y(A.$$.fragment,Ta),Ta.forEach(t),Ma.forEach(t),F=d(Nt),q=i(Nt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1jsw1pg"&&(q.textContent=Ir),Nt.forEach(t),Fa=d(e),Cs=i(e,"P",{"data-svelte-h":!0}),m(Cs)!=="svelte-am6ou9"&&(Cs.innerHTML=Cr),Aa=d(e),Fs=i(e,"P",{"data-svelte-h":!0}),m(Fs)!=="svelte-1snuwkh"&&(Fs.textContent=Fr),Za=d(e),As=i(e,"UL",{"data-svelte-h":!0}),m(As)!=="svelte-1aokkv"&&(As.innerHTML=Ar),Ba=d(e),Zs=i(e,"P",{"data-svelte-h":!0}),m(Zs)!=="svelte-1pk4od4"&&(Zs.textContent=Zr),za=d(e),Bs=i(e,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-vfdo9a"&&(Bs.textContent=Br),$a=d(e),zs=i(e,"P",{"data-svelte-h":!0}),m(zs)!=="svelte-1oi615j"&&(zs.innerHTML=zr),qa=d(e),$s=i(e,"P",{"data-svelte-h":!0}),m($s)!=="svelte-1fjg7gp"&&($s.innerHTML=$r),Wa=d(e),Ze=i(e,"IMG",{src:!0,alt:!0,width:!0}),xa=d(e),qs=i(e,"SMALL",{"data-svelte-h":!0}),m(qs)!=="svelte-1fxzkn1"&&(qs.innerHTML=Wr),Ga=d(e),Ws=i(e,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-1kjfplh"&&(Ws.innerHTML=xr),Na=d(e),xs=i(e,"P",{"data-svelte-h":!0}),m(xs)!=="svelte-axv494"&&(xs.textContent=Gr),Ra=d(e),Gs=i(e,"UL",{"data-svelte-h":!0}),m(Gs)!=="svelte-1jytta1"&&(Gs.innerHTML=Nr),Qa=d(e),fe=i(e,"H2",{class:!0});var Rt=C(fe);Be=i(Rt,"A",{id:!0,class:!0,href:!0});var ya=C(Be);ea=i(ya,"SPAN",{});var _a=C(ea);y(Ns.$$.fragment,_a),_a.forEach(t),ya.forEach(t),Ho=d(Rt),Yt=i(Rt,"SPAN",{"data-svelte-h":!0}),m(Yt)!=="svelte-8fp8em"&&(Yt.textContent=Rr),Rt.forEach(t),Va=d(e),Rs=i(e,"P",{"data-svelte-h":!0}),m(Rs)!=="svelte-1mlnymv"&&(Rs.innerHTML=Qr),Ea=d(e),Qs=i(e,"P",{"data-svelte-h":!0}),m(Qs)!=="svelte-1u8kyba"&&(Qs.innerHTML=Vr),Xa=d(e),Vs=i(e,"P",{"data-svelte-h":!0}),m(Vs)!=="svelte-a9zi1f"&&(Vs.innerHTML=Er),Sa=d(e),Es=i(e,"OL",{"data-svelte-h":!0}),m(Es)!=="svelte-tuiuxn"&&(Es.innerHTML=Xr),Ha=d(e),Xs=i(e,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-qp6rba"&&(Xs.textContent=Sr),Ya=d(e),Ss=i(e,"TABLE",{"data-svelte-h":!0}),m(Ss)!=="svelte-b5t657"&&(Ss.innerHTML=Hr),La=d(e),y(ze.$$.fragment,e),Pa=d(e),Hs=i(e,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-1lvt4t7"&&(Hs.innerHTML=Yr),Da=d(e),Ys=i(e,"P",{"data-svelte-h":!0}),m(Ys)!=="svelte-11t6wp"&&(Ys.innerHTML=Lr),Oa=d(e),Ls=i(e,"P",{"data-svelte-h":!0}),m(Ls)!=="svelte-pu8jy3"&&(Ls.innerHTML=Pr),Ka=d(e),Ps=i(e,"P",{"data-svelte-h":!0}),m(Ps)!=="svelte-1nqdyw2"&&(Ps.innerHTML=Dr),eo=d(e),Ds=i(e,"UL",{"data-svelte-h":!0}),m(Ds)!=="svelte-1togvt3"&&(Ds.innerHTML=Or),so=d(e),Os=i(e,"P",{"data-svelte-h":!0}),m(Os)!=="svelte-1e5s2fl"&&(Os.innerHTML=Kr),to=d(e),Ks=i(e,"P",{"data-svelte-h":!0}),m(Ks)!=="svelte-1gz8ozq"&&(Ks.innerHTML=ei),no=d(e),y($e.$$.fragment,e),ao=d(e),et=i(e,"P",{"data-svelte-h":!0}),m(et)!=="svelte-ixdhma"&&(et.innerHTML=si),oo=d(e),st=i(e,"P",{"data-svelte-h":!0}),m(st)!=="svelte-t321cw"&&(st.textContent=ti),lo=d(e),y(qe.$$.fragment,e),ro=d(e),Me=i(e,"H2",{class:!0});var Qt=C(Me);We=i(Qt,"A",{id:!0,class:!0,href:!0});var wa=C(We);sa=i(wa,"SPAN",{});var ba=C(sa);y(tt.$$.fragment,ba),ba.forEach(t),wa.forEach(t),Yo=d(Qt),Lt=i(Qt,"SPAN",{"data-svelte-h":!0}),m(Lt)!=="svelte-uxz3z9"&&(Lt.textContent=ni),Qt.forEach(t),io=d(e),y(xe.$$.fragment,e),co=d(e),nt=i(e,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-6imxw1"&&(nt.innerHTML=ai),po=d(e),Te=i(e,"H2",{class:!0});var Vt=C(Te);Ge=i(Vt,"A",{id:!0,class:!0,href:!0});var ja=C(Ge);ta=i(ja,"SPAN",{});var Ja=C(ta);y(at.$$.fragment,Ja),Ja.forEach(t),ja.forEach(t),Lo=d(Vt),Pt=i(Vt,"SPAN",{"data-svelte-h":!0}),m(Pt)!=="svelte-n3f0j0"&&(Pt.textContent=oi),Vt.forEach(t),ho=d(e),ot=i(e,"UL",{"data-svelte-h":!0}),m(ot)!=="svelte-1cf57f1"&&(ot.innerHTML=li),mo=d(e),ye=i(e,"H2",{class:!0});var Et=C(ye);Ne=i(Et,"A",{id:!0,class:!0,href:!0});var Ua=C(Ne);na=i(Ua,"SPAN",{});var va=C(na);y(lt.$$.fragment,va),va.forEach(t),Ua.forEach(t),Po=d(Et),Dt=i(Et,"SPAN",{"data-svelte-h":!0}),m(Dt)!=="svelte-1ma46u2"&&(Dt.textContent=ri),Et.forEach(t),uo=d(e),_e=i(e,"DIV",{class:!0});var Xt=C(_e);y(rt.$$.fragment,Xt),Do=d(Xt),Ot=i(Xt,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1xgunfg"&&(Ot.innerHTML=ii),Xt.forEach(t),go=d(e),we=i(e,"H2",{class:!0});var St=C(we);Re=i(St,"A",{id:!0,class:!0,href:!0});var ka=C(Re);aa=i(ka,"SPAN",{});var Ia=C(aa);y(it.$$.fragment,Ia),Ia.forEach(t),ka.forEach(t),Oo=d(St),Kt=i(St,"SPAN",{"data-svelte-h":!0}),m(Kt)!=="svelte-1nrfc44"&&(Kt.textContent=ci),St.forEach(t),fo=d(e),Y=i(e,"DIV",{class:!0});var O=C(Y);y(ct.$$.fragment,O),Ko=d(O),en=i(O,"P",{"data-svelte-h":!0}),m(en)!=="svelte-19nowfy"&&(en.innerHTML=di),el=d(O),sn=i(O,"P",{"data-svelte-h":!0}),m(sn)!=="svelte-1gb315p"&&(sn.innerHTML=pi),sl=d(O),tn=i(O,"P",{"data-svelte-h":!0}),m(tn)!=="svelte-n4fsha"&&(tn.innerHTML=hi),tl=d(O),y(Qe.$$.fragment,O),O.forEach(t),Mo=d(e),be=i(e,"H2",{class:!0});var Ht=C(be);Ve=i(Ht,"A",{id:!0,class:!0,href:!0});var Ca=C(Ve);oa=i(Ca,"SPAN",{});var rc=C(oa);y(dt.$$.fragment,rc),rc.forEach(t),Ca.forEach(t),nl=d(Ht),nn=i(Ht,"SPAN",{"data-svelte-h":!0}),m(nn)!=="svelte-jzwyfv"&&(nn.textContent=mi),Ht.forEach(t),To=d(e),G=i(e,"DIV",{class:!0});var S=C(G);y(pt.$$.fragment,S),al=d(S),an=i(S,"P",{"data-svelte-h":!0}),m(an)!=="svelte-1hmtb4d"&&(an.textContent=ui),ol=d(S),on=i(S,"P",{"data-svelte-h":!0}),m(on)!=="svelte-1sex1nt"&&(on.innerHTML=gi),ll=d(S),ln=i(S,"UL",{"data-svelte-h":!0}),m(ln)!=="svelte-hp7g7u"&&(ln.innerHTML=fi),rl=d(S),rn=i(S,"P",{"data-svelte-h":!0}),m(rn)!=="svelte-m4txce"&&(rn.innerHTML=Mi),il=d(S),Ee=i(S,"DIV",{class:!0});var Wo=C(Ee);y(ht.$$.fragment,Wo),cl=d(Wo),cn=i(Wo,"P",{"data-svelte-h":!0}),m(cn)!=="svelte-1j6vv4o"&&(cn.textContent=Ti),Wo.forEach(t),dl=d(S),me=i(S,"DIV",{class:!0});var Kn=C(me);y(mt.$$.fragment,Kn),pl=d(Kn),dn=i(Kn,"P",{"data-svelte-h":!0}),m(dn)!=="svelte-7f6vaj"&&(dn.innerHTML=yi),hl=d(Kn),pn=i(Kn,"P",{"data-svelte-h":!0}),m(pn)!=="svelte-1yeewnh"&&(pn.innerHTML=_i),Kn.forEach(t),ml=d(S),hn=i(S,"DIV",{class:!0});var ic=C(hn);y(ut.$$.fragment,ic),ic.forEach(t),S.forEach(t),yo=d(e),je=i(e,"H2",{class:!0});var xo=C(je);Xe=i(xo,"A",{id:!0,class:!0,href:!0});var cc=C(Xe);la=i(cc,"SPAN",{});var dc=C(la);y(gt.$$.fragment,dc),dc.forEach(t),cc.forEach(t),ul=d(xo),mn=i(xo,"SPAN",{"data-svelte-h":!0}),m(mn)!=="svelte-1mc9kaj"&&(mn.textContent=wi),xo.forEach(t),_o=d(e),R=i(e,"DIV",{class:!0});var re=C(R);y(ft.$$.fragment,re),gl=d(re),un=i(re,"P",{"data-svelte-h":!0}),m(un)!=="svelte-o4wsdx"&&(un.innerHTML=bi),fl=d(re),gn=i(re,"P",{"data-svelte-h":!0}),m(gn)!=="svelte-hswkmf"&&(gn.innerHTML=ji),Ml=d(re),fn=i(re,"P",{"data-svelte-h":!0}),m(fn)!=="svelte-1nbdwdk"&&(fn.innerHTML=Ji),Tl=d(re),Mn=i(re,"P",{"data-svelte-h":!0}),m(Mn)!=="svelte-1du13oj"&&(Mn.innerHTML=Ui),yl=d(re),K=i(re,"DIV",{class:!0});var ys=C(K);y(Mt.$$.fragment,ys),_l=d(ys),Tn=i(ys,"P",{"data-svelte-h":!0}),m(Tn)!=="svelte-mv2uq"&&(Tn.innerHTML=vi),wl=d(ys),y(Se.$$.fragment,ys),bl=d(ys),y(He.$$.fragment,ys),ys.forEach(t),re.forEach(t),wo=d(e),Je=i(e,"H2",{class:!0});var Go=C(Je);Ye=i(Go,"A",{id:!0,class:!0,href:!0});var pc=C(Ye);ra=i(pc,"SPAN",{});var hc=C(ra);y(Tt.$$.fragment,hc),hc.forEach(t),pc.forEach(t),jl=d(Go),yn=i(Go,"SPAN",{"data-svelte-h":!0}),m(yn)!=="svelte-1lj3zir"&&(yn.textContent=ki),Go.forEach(t),bo=d(e),D=i(e,"DIV",{class:!0});var _s=C(D);y(yt.$$.fragment,_s),Jl=d(_s),_n=i(_s,"P",{"data-svelte-h":!0}),m(_n)!=="svelte-1y2mzpk"&&(_n.innerHTML=Ii),Ul=d(_s),wn=i(_s,"P",{"data-svelte-h":!0}),m(wn)!=="svelte-hswkmf"&&(wn.innerHTML=Ci),vl=d(_s),ee=i(_s,"DIV",{class:!0});var ws=C(ee);y(_t.$$.fragment,ws),kl=d(ws),bn=i(ws,"P",{"data-svelte-h":!0}),m(bn)!=="svelte-1tv4lua"&&(bn.innerHTML=Fi),Il=d(ws),y(Le.$$.fragment,ws),Cl=d(ws),y(Pe.$$.fragment,ws),ws.forEach(t),_s.forEach(t),jo=d(e),Ue=i(e,"H2",{class:!0});var No=C(Ue);De=i(No,"A",{id:!0,class:!0,href:!0});var mc=C(De);ia=i(mc,"SPAN",{});var uc=C(ia);y(wt.$$.fragment,uc),uc.forEach(t),mc.forEach(t),Fl=d(No),jn=i(No,"SPAN",{"data-svelte-h":!0}),m(jn)!=="svelte-1xxd0q6"&&(jn.textContent=Ai),No.forEach(t),Jo=d(e),L=i(e,"DIV",{class:!0});var ue=C(L);y(bt.$$.fragment,ue),Al=d(ue),Jn=i(ue,"P",{"data-svelte-h":!0}),m(Jn)!=="svelte-1ez74bv"&&(Jn.textContent=Zi),Zl=d(ue),Un=i(ue,"P",{"data-svelte-h":!0}),m(Un)!=="svelte-1g9ikmn"&&(Un.innerHTML=Bi),Bl=d(ue),vn=i(ue,"P",{"data-svelte-h":!0}),m(vn)!=="svelte-hswkmf"&&(vn.innerHTML=zi),zl=d(ue),se=i(ue,"DIV",{class:!0});var bs=C(se);y(jt.$$.fragment,bs),$l=d(bs),kn=i(bs,"P",{"data-svelte-h":!0}),m(kn)!=="svelte-1nrom6g"&&(kn.innerHTML=$i),ql=d(bs),y(Oe.$$.fragment,bs),Wl=d(bs),y(Ke.$$.fragment,bs),bs.forEach(t),ue.forEach(t),Uo=d(e),ve=i(e,"H2",{class:!0});var Ro=C(ve);es=i(Ro,"A",{id:!0,class:!0,href:!0});var gc=C(es);ca=i(gc,"SPAN",{});var fc=C(ca);y(Jt.$$.fragment,fc),fc.forEach(t),gc.forEach(t),xl=d(Ro),In=i(Ro,"SPAN",{"data-svelte-h":!0}),m(In)!=="svelte-1vwcyeh"&&(In.textContent=qi),Ro.forEach(t),vo=d(e),P=i(e,"DIV",{class:!0});var ge=C(P);y(Ut.$$.fragment,ge),Gl=d(ge),Cn=i(ge,"P",{"data-svelte-h":!0}),m(Cn)!=="svelte-5p7316"&&(Cn.innerHTML=Wi),Nl=d(ge),Fn=i(ge,"P",{"data-svelte-h":!0}),m(Fn)!=="svelte-1g9ikmn"&&(Fn.innerHTML=xi),Rl=d(ge),An=i(ge,"P",{"data-svelte-h":!0}),m(An)!=="svelte-hswkmf"&&(An.innerHTML=Gi),Ql=d(ge),te=i(ge,"DIV",{class:!0});var js=C(te);y(vt.$$.fragment,js),Vl=d(js),Zn=i(js,"P",{"data-svelte-h":!0}),m(Zn)!=="svelte-10m406"&&(Zn.innerHTML=Ni),El=d(js),y(ss.$$.fragment,js),Xl=d(js),y(ts.$$.fragment,js),js.forEach(t),ge.forEach(t),ko=d(e),ke=i(e,"H2",{class:!0});var Qo=C(ke);ns=i(Qo,"A",{id:!0,class:!0,href:!0});var Mc=C(ns);da=i(Mc,"SPAN",{});var Tc=C(da);y(kt.$$.fragment,Tc),Tc.forEach(t),Mc.forEach(t),Sl=d(Qo),Bn=i(Qo,"SPAN",{"data-svelte-h":!0}),m(Bn)!=="svelte-17u34bp"&&(Bn.textContent=Ri),Qo.forEach(t),Io=d(e),Q=i(e,"DIV",{class:!0});var ie=C(Q);y(It.$$.fragment,ie),Hl=d(ie),zn=i(ie,"P",{"data-svelte-h":!0}),m(zn)!=="svelte-a941xg"&&(zn.textContent=Qi),Yl=d(ie),$n=i(ie,"P",{"data-svelte-h":!0}),m($n)!=="svelte-1e9g3w8"&&($n.innerHTML=Vi),Ll=d(ie),qn=i(ie,"P",{"data-svelte-h":!0}),m(qn)!=="svelte-1ivrf8m"&&(qn.innerHTML=Ei),Pl=d(ie),y(as.$$.fragment,ie),Dl=d(ie),ne=i(ie,"DIV",{class:!0});var Js=C(ne);y(Ct.$$.fragment,Js),Ol=d(Js),Wn=i(Js,"P",{"data-svelte-h":!0}),m(Wn)!=="svelte-1g9oheu"&&(Wn.innerHTML=Xi),Kl=d(Js),y(os.$$.fragment,Js),er=d(Js),y(ls.$$.fragment,Js),Js.forEach(t),ie.forEach(t),Co=d(e),Ie=i(e,"H2",{class:!0});var Vo=C(Ie);rs=i(Vo,"A",{id:!0,class:!0,href:!0});var yc=C(rs);pa=i(yc,"SPAN",{});var _c=C(pa);y(Ft.$$.fragment,_c),_c.forEach(t),yc.forEach(t),sr=d(Vo),xn=i(Vo,"SPAN",{"data-svelte-h":!0}),m(xn)!=="svelte-135qt9"&&(xn.textContent=Si),Vo.forEach(t),Fo=d(e),V=i(e,"DIV",{class:!0});var ce=C(V);y(At.$$.fragment,ce),tr=d(ce),Gn=i(ce,"P",{"data-svelte-h":!0}),m(Gn)!=="svelte-1e80fxn"&&(Gn.innerHTML=Hi),nr=d(ce),Nn=i(ce,"P",{"data-svelte-h":!0}),m(Nn)!=="svelte-1e9g3w8"&&(Nn.innerHTML=Yi),ar=d(ce),Rn=i(ce,"P",{"data-svelte-h":!0}),m(Rn)!=="svelte-1ivrf8m"&&(Rn.innerHTML=Li),or=d(ce),y(is.$$.fragment,ce),lr=d(ce),ae=i(ce,"DIV",{class:!0});var Us=C(ae);y(Zt.$$.fragment,Us),rr=d(Us),Qn=i(Us,"P",{"data-svelte-h":!0}),m(Qn)!=="svelte-vgi1py"&&(Qn.innerHTML=Pi),ir=d(Us),y(cs.$$.fragment,Us),cr=d(Us),y(ds.$$.fragment,Us),Us.forEach(t),ce.forEach(t),Ao=d(e),Ce=i(e,"H2",{class:!0});var Eo=C(Ce);ps=i(Eo,"A",{id:!0,class:!0,href:!0});var wc=C(ps);ha=i(wc,"SPAN",{});var bc=C(ha);y(Bt.$$.fragment,bc),bc.forEach(t),wc.forEach(t),dr=d(Eo),Vn=i(Eo,"SPAN",{"data-svelte-h":!0}),m(Vn)!=="svelte-b744mo"&&(Vn.textContent=Di),Eo.forEach(t),Zo=d(e),E=i(e,"DIV",{class:!0});var de=C(E);y(zt.$$.fragment,de),pr=d(de),En=i(de,"P",{"data-svelte-h":!0}),m(En)!=="svelte-1ez74bv"&&(En.textContent=Oi),hr=d(de),Xn=i(de,"P",{"data-svelte-h":!0}),m(Xn)!=="svelte-1e9g3w8"&&(Xn.innerHTML=Ki),mr=d(de),Sn=i(de,"P",{"data-svelte-h":!0}),m(Sn)!=="svelte-1ivrf8m"&&(Sn.innerHTML=ec),ur=d(de),y(hs.$$.fragment,de),gr=d(de),oe=i(de,"DIV",{class:!0});var vs=C(oe);y($t.$$.fragment,vs),fr=d(vs),Hn=i(vs,"P",{"data-svelte-h":!0}),m(Hn)!=="svelte-iu8t6g"&&(Hn.innerHTML=sc),Mr=d(vs),y(ms.$$.fragment,vs),Tr=d(vs),y(us.$$.fragment,vs),vs.forEach(t),de.forEach(t),Bo=d(e),Fe=i(e,"H2",{class:!0});var Xo=C(Fe);gs=i(Xo,"A",{id:!0,class:!0,href:!0});var jc=C(gs);ma=i(jc,"SPAN",{});var Jc=C(ma);y(qt.$$.fragment,Jc),Jc.forEach(t),jc.forEach(t),yr=d(Xo),Yn=i(Xo,"SPAN",{"data-svelte-h":!0}),m(Yn)!=="svelte-s2d8u7"&&(Yn.textContent=tc),Xo.forEach(t),zo=d(e),X=i(e,"DIV",{class:!0});var pe=C(X);y(Wt.$$.fragment,pe),_r=d(pe),Ln=i(pe,"P",{"data-svelte-h":!0}),m(Ln)!=="svelte-5p7316"&&(Ln.innerHTML=nc),wr=d(pe),Pn=i(pe,"P",{"data-svelte-h":!0}),m(Pn)!=="svelte-1e9g3w8"&&(Pn.innerHTML=ac),br=d(pe),Dn=i(pe,"P",{"data-svelte-h":!0}),m(Dn)!=="svelte-1ivrf8m"&&(Dn.innerHTML=oc),jr=d(pe),y(fs.$$.fragment,pe),Jr=d(pe),le=i(pe,"DIV",{class:!0});var ks=C(le);y(xt.$$.fragment,ks),Ur=d(ks),On=i(ks,"P",{"data-svelte-h":!0}),m(On)!=="svelte-1lrtzb2"&&(On.innerHTML=lc),vr=d(ks),y(Ms.$$.fragment,ks),kr=d(ks),y(Ts.$$.fragment,ks),ks.forEach(t),pe.forEach(t),$o=d(e),ua=i(e,"P",{}),C(ua).forEach(t),this.h()},h(){J(s,"name","hf:doc:metadata"),J(s,"content",JSON.stringify(gd)),J(a,"id","tapas"),J(a,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(a,"href","#tapas"),J(g,"class","relative group"),J($,"id","overview"),J($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J($,"href","#overview"),J(B,"class","relative group"),vc(Ze.src,qr="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tapas_architecture.png")||J(Ze,"src",qr),J(Ze,"alt","drawing"),J(Ze,"width","600"),J(Be,"id","usage-finetuning"),J(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Be,"href","#usage-finetuning"),J(fe,"class","relative group"),J(We,"id","usage-inference"),J(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(We,"href","#usage-inference"),J(Me,"class","relative group"),J(Ge,"id","documentation-resources"),J(Ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Ge,"href","#documentation-resources"),J(Te,"class","relative group"),J(Ne,"id","transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"),J(Ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Ne,"href","#transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput"),J(ye,"class","relative group"),J(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Re,"id","transformers.TapasConfig"),J(Re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Re,"href","#transformers.TapasConfig"),J(we,"class","relative group"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ve,"id","transformers.TapasTokenizer"),J(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Ve,"href","#transformers.TapasTokenizer"),J(be,"class","relative group"),J(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Xe,"id","transformers.TapasModel"),J(Xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Xe,"href","#transformers.TapasModel"),J(je,"class","relative group"),J(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ye,"id","transformers.TapasForMaskedLM"),J(Ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(Ye,"href","#transformers.TapasForMaskedLM"),J(Je,"class","relative group"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(De,"id","transformers.TapasForSequenceClassification"),J(De,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(De,"href","#transformers.TapasForSequenceClassification"),J(Ue,"class","relative group"),J(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(es,"id","transformers.TapasForQuestionAnswering"),J(es,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(es,"href","#transformers.TapasForQuestionAnswering"),J(ve,"class","relative group"),J(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ns,"id","transformers.TFTapasModel"),J(ns,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(ns,"href","#transformers.TFTapasModel"),J(ke,"class","relative group"),J(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(rs,"id","transformers.TFTapasForMaskedLM"),J(rs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(rs,"href","#transformers.TFTapasForMaskedLM"),J(Ie,"class","relative group"),J(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ps,"id","transformers.TFTapasForSequenceClassification"),J(ps,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(ps,"href","#transformers.TFTapasForSequenceClassification"),J(Ce,"class","relative group"),J(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(gs,"id","transformers.TFTapasForQuestionAnswering"),J(gs,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),J(gs,"href","#transformers.TFTapasForQuestionAnswering"),J(Fe,"class","relative group"),J(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,h){p(document.head,s),l(e,u,h),l(e,n,h),l(e,o,h),l(e,g,h),p(g,a),p(a,f),_(z,f,null),p(g,U),p(g,v),l(e,Z,h),l(e,B,h),p(B,$),p($,M),_(A,M,null),p(B,F),p(B,q),l(e,Fa,h),l(e,Cs,h),l(e,Aa,h),l(e,Fs,h),l(e,Za,h),l(e,As,h),l(e,Ba,h),l(e,Zs,h),l(e,za,h),l(e,Bs,h),l(e,$a,h),l(e,zs,h),l(e,qa,h),l(e,$s,h),l(e,Wa,h),l(e,Ze,h),l(e,xa,h),l(e,qs,h),l(e,Ga,h),l(e,Ws,h),l(e,Na,h),l(e,xs,h),l(e,Ra,h),l(e,Gs,h),l(e,Qa,h),l(e,fe,h),p(fe,Be),p(Be,ea),_(Ns,ea,null),p(fe,Ho),p(fe,Yt),l(e,Va,h),l(e,Rs,h),l(e,Ea,h),l(e,Qs,h),l(e,Xa,h),l(e,Vs,h),l(e,Sa,h),l(e,Es,h),l(e,Ha,h),l(e,Xs,h),l(e,Ya,h),l(e,Ss,h),l(e,La,h),_(ze,e,h),l(e,Pa,h),l(e,Hs,h),l(e,Da,h),l(e,Ys,h),l(e,Oa,h),l(e,Ls,h),l(e,Ka,h),l(e,Ps,h),l(e,eo,h),l(e,Ds,h),l(e,so,h),l(e,Os,h),l(e,to,h),l(e,Ks,h),l(e,no,h),_($e,e,h),l(e,ao,h),l(e,et,h),l(e,oo,h),l(e,st,h),l(e,lo,h),_(qe,e,h),l(e,ro,h),l(e,Me,h),p(Me,We),p(We,sa),_(tt,sa,null),p(Me,Yo),p(Me,Lt),l(e,io,h),_(xe,e,h),l(e,co,h),l(e,nt,h),l(e,po,h),l(e,Te,h),p(Te,Ge),p(Ge,ta),_(at,ta,null),p(Te,Lo),p(Te,Pt),l(e,ho,h),l(e,ot,h),l(e,mo,h),l(e,ye,h),p(ye,Ne),p(Ne,na),_(lt,na,null),p(ye,Po),p(ye,Dt),l(e,uo,h),l(e,_e,h),_(rt,_e,null),p(_e,Do),p(_e,Ot),l(e,go,h),l(e,we,h),p(we,Re),p(Re,aa),_(it,aa,null),p(we,Oo),p(we,Kt),l(e,fo,h),l(e,Y,h),_(ct,Y,null),p(Y,Ko),p(Y,en),p(Y,el),p(Y,sn),p(Y,sl),p(Y,tn),p(Y,tl),_(Qe,Y,null),l(e,Mo,h),l(e,be,h),p(be,Ve),p(Ve,oa),_(dt,oa,null),p(be,nl),p(be,nn),l(e,To,h),l(e,G,h),_(pt,G,null),p(G,al),p(G,an),p(G,ol),p(G,on),p(G,ll),p(G,ln),p(G,rl),p(G,rn),p(G,il),p(G,Ee),_(ht,Ee,null),p(Ee,cl),p(Ee,cn),p(G,dl),p(G,me),_(mt,me,null),p(me,pl),p(me,dn),p(me,hl),p(me,pn),p(G,ml),p(G,hn),_(ut,hn,null),l(e,yo,h),l(e,je,h),p(je,Xe),p(Xe,la),_(gt,la,null),p(je,ul),p(je,mn),l(e,_o,h),l(e,R,h),_(ft,R,null),p(R,gl),p(R,un),p(R,fl),p(R,gn),p(R,Ml),p(R,fn),p(R,Tl),p(R,Mn),p(R,yl),p(R,K),_(Mt,K,null),p(K,_l),p(K,Tn),p(K,wl),_(Se,K,null),p(K,bl),_(He,K,null),l(e,wo,h),l(e,Je,h),p(Je,Ye),p(Ye,ra),_(Tt,ra,null),p(Je,jl),p(Je,yn),l(e,bo,h),l(e,D,h),_(yt,D,null),p(D,Jl),p(D,_n),p(D,Ul),p(D,wn),p(D,vl),p(D,ee),_(_t,ee,null),p(ee,kl),p(ee,bn),p(ee,Il),_(Le,ee,null),p(ee,Cl),_(Pe,ee,null),l(e,jo,h),l(e,Ue,h),p(Ue,De),p(De,ia),_(wt,ia,null),p(Ue,Fl),p(Ue,jn),l(e,Jo,h),l(e,L,h),_(bt,L,null),p(L,Al),p(L,Jn),p(L,Zl),p(L,Un),p(L,Bl),p(L,vn),p(L,zl),p(L,se),_(jt,se,null),p(se,$l),p(se,kn),p(se,ql),_(Oe,se,null),p(se,Wl),_(Ke,se,null),l(e,Uo,h),l(e,ve,h),p(ve,es),p(es,ca),_(Jt,ca,null),p(ve,xl),p(ve,In),l(e,vo,h),l(e,P,h),_(Ut,P,null),p(P,Gl),p(P,Cn),p(P,Nl),p(P,Fn),p(P,Rl),p(P,An),p(P,Ql),p(P,te),_(vt,te,null),p(te,Vl),p(te,Zn),p(te,El),_(ss,te,null),p(te,Xl),_(ts,te,null),l(e,ko,h),l(e,ke,h),p(ke,ns),p(ns,da),_(kt,da,null),p(ke,Sl),p(ke,Bn),l(e,Io,h),l(e,Q,h),_(It,Q,null),p(Q,Hl),p(Q,zn),p(Q,Yl),p(Q,$n),p(Q,Ll),p(Q,qn),p(Q,Pl),_(as,Q,null),p(Q,Dl),p(Q,ne),_(Ct,ne,null),p(ne,Ol),p(ne,Wn),p(ne,Kl),_(os,ne,null),p(ne,er),_(ls,ne,null),l(e,Co,h),l(e,Ie,h),p(Ie,rs),p(rs,pa),_(Ft,pa,null),p(Ie,sr),p(Ie,xn),l(e,Fo,h),l(e,V,h),_(At,V,null),p(V,tr),p(V,Gn),p(V,nr),p(V,Nn),p(V,ar),p(V,Rn),p(V,or),_(is,V,null),p(V,lr),p(V,ae),_(Zt,ae,null),p(ae,rr),p(ae,Qn),p(ae,ir),_(cs,ae,null),p(ae,cr),_(ds,ae,null),l(e,Ao,h),l(e,Ce,h),p(Ce,ps),p(ps,ha),_(Bt,ha,null),p(Ce,dr),p(Ce,Vn),l(e,Zo,h),l(e,E,h),_(zt,E,null),p(E,pr),p(E,En),p(E,hr),p(E,Xn),p(E,mr),p(E,Sn),p(E,ur),_(hs,E,null),p(E,gr),p(E,oe),_($t,oe,null),p(oe,fr),p(oe,Hn),p(oe,Mr),_(ms,oe,null),p(oe,Tr),_(us,oe,null),l(e,Bo,h),l(e,Fe,h),p(Fe,gs),p(gs,ma),_(qt,ma,null),p(Fe,yr),p(Fe,Yn),l(e,zo,h),l(e,X,h),_(Wt,X,null),p(X,_r),p(X,Ln),p(X,wr),p(X,Pn),p(X,br),p(X,Dn),p(X,jr),_(fs,X,null),p(X,Jr),p(X,le),_(xt,le,null),p(le,Ur),p(le,On),p(le,vr),_(Ms,le,null),p(le,kr),_(Ts,le,null),l(e,$o,h),l(e,ua,h),qo=!0},p(e,[h]){const Gt={};h&2&&(Gt.$$scope={dirty:h,ctx:e}),ze.$set(Gt);const ga={};h&2&&(ga.$$scope={dirty:h,ctx:e}),$e.$set(ga);const fa={};h&2&&(fa.$$scope={dirty:h,ctx:e}),qe.$set(fa);const Nt={};h&2&&(Nt.$$scope={dirty:h,ctx:e}),xe.$set(Nt);const Ma={};h&2&&(Ma.$$scope={dirty:h,ctx:e}),Qe.$set(Ma);const Ta={};h&2&&(Ta.$$scope={dirty:h,ctx:e}),Se.$set(Ta);const Rt={};h&2&&(Rt.$$scope={dirty:h,ctx:e}),He.$set(Rt);const ya={};h&2&&(ya.$$scope={dirty:h,ctx:e}),Le.$set(ya);const _a={};h&2&&(_a.$$scope={dirty:h,ctx:e}),Pe.$set(_a);const Qt={};h&2&&(Qt.$$scope={dirty:h,ctx:e}),Oe.$set(Qt);const wa={};h&2&&(wa.$$scope={dirty:h,ctx:e}),Ke.$set(wa);const ba={};h&2&&(ba.$$scope={dirty:h,ctx:e}),ss.$set(ba);const Vt={};h&2&&(Vt.$$scope={dirty:h,ctx:e}),ts.$set(Vt);const ja={};h&2&&(ja.$$scope={dirty:h,ctx:e}),as.$set(ja);const Ja={};h&2&&(Ja.$$scope={dirty:h,ctx:e}),os.$set(Ja);const Et={};h&2&&(Et.$$scope={dirty:h,ctx:e}),ls.$set(Et);const Ua={};h&2&&(Ua.$$scope={dirty:h,ctx:e}),is.$set(Ua);const va={};h&2&&(va.$$scope={dirty:h,ctx:e}),cs.$set(va);const Xt={};h&2&&(Xt.$$scope={dirty:h,ctx:e}),ds.$set(Xt);const St={};h&2&&(St.$$scope={dirty:h,ctx:e}),hs.$set(St);const ka={};h&2&&(ka.$$scope={dirty:h,ctx:e}),ms.$set(ka);const Ia={};h&2&&(Ia.$$scope={dirty:h,ctx:e}),us.$set(Ia);const O={};h&2&&(O.$$scope={dirty:h,ctx:e}),fs.$set(O);const Ht={};h&2&&(Ht.$$scope={dirty:h,ctx:e}),Ms.$set(Ht);const Ca={};h&2&&(Ca.$$scope={dirty:h,ctx:e}),Ts.$set(Ca)},i(e){qo||(w(z.$$.fragment,e),w(A.$$.fragment,e),w(Ns.$$.fragment,e),w(ze.$$.fragment,e),w($e.$$.fragment,e),w(qe.$$.fragment,e),w(tt.$$.fragment,e),w(xe.$$.fragment,e),w(at.$$.fragment,e),w(lt.$$.fragment,e),w(rt.$$.fragment,e),w(it.$$.fragment,e),w(ct.$$.fragment,e),w(Qe.$$.fragment,e),w(dt.$$.fragment,e),w(pt.$$.fragment,e),w(ht.$$.fragment,e),w(mt.$$.fragment,e),w(ut.$$.fragment,e),w(gt.$$.fragment,e),w(ft.$$.fragment,e),w(Mt.$$.fragment,e),w(Se.$$.fragment,e),w(He.$$.fragment,e),w(Tt.$$.fragment,e),w(yt.$$.fragment,e),w(_t.$$.fragment,e),w(Le.$$.fragment,e),w(Pe.$$.fragment,e),w(wt.$$.fragment,e),w(bt.$$.fragment,e),w(jt.$$.fragment,e),w(Oe.$$.fragment,e),w(Ke.$$.fragment,e),w(Jt.$$.fragment,e),w(Ut.$$.fragment,e),w(vt.$$.fragment,e),w(ss.$$.fragment,e),w(ts.$$.fragment,e),w(kt.$$.fragment,e),w(It.$$.fragment,e),w(as.$$.fragment,e),w(Ct.$$.fragment,e),w(os.$$.fragment,e),w(ls.$$.fragment,e),w(Ft.$$.fragment,e),w(At.$$.fragment,e),w(is.$$.fragment,e),w(Zt.$$.fragment,e),w(cs.$$.fragment,e),w(ds.$$.fragment,e),w(Bt.$$.fragment,e),w(zt.$$.fragment,e),w(hs.$$.fragment,e),w($t.$$.fragment,e),w(ms.$$.fragment,e),w(us.$$.fragment,e),w(qt.$$.fragment,e),w(Wt.$$.fragment,e),w(fs.$$.fragment,e),w(xt.$$.fragment,e),w(Ms.$$.fragment,e),w(Ts.$$.fragment,e),qo=!0)},o(e){b(z.$$.fragment,e),b(A.$$.fragment,e),b(Ns.$$.fragment,e),b(ze.$$.fragment,e),b($e.$$.fragment,e),b(qe.$$.fragment,e),b(tt.$$.fragment,e),b(xe.$$.fragment,e),b(at.$$.fragment,e),b(lt.$$.fragment,e),b(rt.$$.fragment,e),b(it.$$.fragment,e),b(ct.$$.fragment,e),b(Qe.$$.fragment,e),b(dt.$$.fragment,e),b(pt.$$.fragment,e),b(ht.$$.fragment,e),b(mt.$$.fragment,e),b(ut.$$.fragment,e),b(gt.$$.fragment,e),b(ft.$$.fragment,e),b(Mt.$$.fragment,e),b(Se.$$.fragment,e),b(He.$$.fragment,e),b(Tt.$$.fragment,e),b(yt.$$.fragment,e),b(_t.$$.fragment,e),b(Le.$$.fragment,e),b(Pe.$$.fragment,e),b(wt.$$.fragment,e),b(bt.$$.fragment,e),b(jt.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(Jt.$$.fragment,e),b(Ut.$$.fragment,e),b(vt.$$.fragment,e),b(ss.$$.fragment,e),b(ts.$$.fragment,e),b(kt.$$.fragment,e),b(It.$$.fragment,e),b(as.$$.fragment,e),b(Ct.$$.fragment,e),b(os.$$.fragment,e),b(ls.$$.fragment,e),b(Ft.$$.fragment,e),b(At.$$.fragment,e),b(is.$$.fragment,e),b(Zt.$$.fragment,e),b(cs.$$.fragment,e),b(ds.$$.fragment,e),b(Bt.$$.fragment,e),b(zt.$$.fragment,e),b(hs.$$.fragment,e),b($t.$$.fragment,e),b(ms.$$.fragment,e),b(us.$$.fragment,e),b(qt.$$.fragment,e),b(Wt.$$.fragment,e),b(fs.$$.fragment,e),b(xt.$$.fragment,e),b(Ms.$$.fragment,e),b(Ts.$$.fragment,e),qo=!1},d(e){e&&(t(u),t(n),t(o),t(g),t(Z),t(B),t(Fa),t(Cs),t(Aa),t(Fs),t(Za),t(As),t(Ba),t(Zs),t(za),t(Bs),t($a),t(zs),t(qa),t($s),t(Wa),t(Ze),t(xa),t(qs),t(Ga),t(Ws),t(Na),t(xs),t(Ra),t(Gs),t(Qa),t(fe),t(Va),t(Rs),t(Ea),t(Qs),t(Xa),t(Vs),t(Sa),t(Es),t(Ha),t(Xs),t(Ya),t(Ss),t(La),t(Pa),t(Hs),t(Da),t(Ys),t(Oa),t(Ls),t(Ka),t(Ps),t(eo),t(Ds),t(so),t(Os),t(to),t(Ks),t(no),t(ao),t(et),t(oo),t(st),t(lo),t(ro),t(Me),t(io),t(co),t(nt),t(po),t(Te),t(ho),t(ot),t(mo),t(ye),t(uo),t(_e),t(go),t(we),t(fo),t(Y),t(Mo),t(be),t(To),t(G),t(yo),t(je),t(_o),t(R),t(wo),t(Je),t(bo),t(D),t(jo),t(Ue),t(Jo),t(L),t(Uo),t(ve),t(vo),t(P),t(ko),t(ke),t(Io),t(Q),t(Co),t(Ie),t(Fo),t(V),t(Ao),t(Ce),t(Zo),t(E),t(Bo),t(Fe),t(zo),t(X),t($o),t(ua)),t(s),j(z),j(A),j(Ns),j(ze,e),j($e,e),j(qe,e),j(tt),j(xe,e),j(at),j(lt),j(rt),j(it),j(ct),j(Qe),j(dt),j(pt),j(ht),j(mt),j(ut),j(gt),j(ft),j(Mt),j(Se),j(He),j(Tt),j(yt),j(_t),j(Le),j(Pe),j(wt),j(bt),j(jt),j(Oe),j(Ke),j(Jt),j(Ut),j(vt),j(ss),j(ts),j(kt),j(It),j(as),j(Ct),j(os),j(ls),j(Ft),j(At),j(is),j(Zt),j(cs),j(ds),j(Bt),j(zt),j(hs),j($t),j(ms),j(us),j(qt),j(Wt),j(fs),j(xt),j(Ms),j(Ts)}}}const gd={local:"tapas",sections:[{local:"overview",title:"Overview"},{local:"usage-finetuning",title:"Usage: fine-tuning"},{local:"usage-inference",title:"Usage: inference"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.models.tapas.modeling_tapas.TableQuestionAnsweringOutput",title:"TAPAS specific outputs"},{local:"transformers.TapasConfig",title:"TapasConfig"},{local:"transformers.TapasTokenizer",title:"TapasTokenizer"},{local:"transformers.TapasModel",title:"TapasModel"},{local:"transformers.TapasForMaskedLM",title:"TapasForMaskedLM"},{local:"transformers.TapasForSequenceClassification",title:"TapasForSequenceClassification"},{local:"transformers.TapasForQuestionAnswering",title:"TapasForQuestionAnswering"},{local:"transformers.TFTapasModel",title:"TFTapasModel"},{local:"transformers.TFTapasForMaskedLM",title:"TFTapasForMaskedLM"},{local:"transformers.TFTapasForSequenceClassification",title:"TFTapasForSequenceClassification"},{local:"transformers.TFTapasForQuestionAnswering",title:"TFTapasForQuestionAnswering"}],title:"TAPAS"};function fd(I){return kc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ud extends Ic{constructor(s){super(),Cc(this,s,fd,ud,Uc,{})}}export{Ud as component};
