import{s as nl,n as sl,o as al}from"../chunks/scheduler.9bc65507.js";import{S as ol,i as il,g as s,s as o,u,A as rl,h as a,f as t,c as i,j as h,v as d,y as r,k as p,o as c,a as n,w as m,d as f,t as w,x as M}from"../chunks/index.78c82d43.js";import{I as je}from"../chunks/IconCopyLink.bedaa44d.js";import{C as j}from"../chunks/CodeBlock.48618ec2.js";import{D as pl}from"../chunks/DocNotebookDropdown.40f7599b.js";function cl(gt){let y,Ue,Me,ke,b,U,ye,X,ft,ue,Tt="XLA Integration for TensorFlow Models",_e,G,Ze,C,Jt='Accelerated Linear Algebra, dubbed XLA, is a compiler for accelerating the runtime of TensorFlow Models. From the <a href="https://www.tensorflow.org/xla" rel="nofollow">official documentation</a>:',xe,R,vt="XLA (Accelerated Linear Algebra) is a domain-specific compiler for linear algebra that can accelerate TensorFlow models with potentially no source code changes.",Xe,W,jt='Using XLA in TensorFlow is simple – it comes packaged inside the <code>tensorflow</code> library, and it can be triggered with the <code>jit_compile</code> argument in any graph-creating function such as <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>. When using Keras methods like <code>fit()</code> and <code>predict()</code>, you can enable XLA simply by passing the <code>jit_compile</code> argument to <code>model.compile()</code>. However, XLA is not limited to these methods - it can also be used to accelerate any arbitrary <code>tf.function</code>.',Ge,I,Ut='Several TensorFlow methods in 🤗 Transformers have been rewritten to be XLA-compatible, including text generation for models such as <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a> and <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>, as well as speech processing for models such as <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.',Ce,B,kt="While the exact amount of speed-up is very much model-dependent, for TensorFlow text generation models inside 🤗 Transformers, we noticed a speed-up of ~100x. This document will explain how you can use XLA for these models to get the maximum amount of performance. We’ll also provide links to additional resources if you’re interested to learn more about the benchmarks and our design philosophy behind the XLA integration.",Re,g,k,be,$,wt,de,_t="Running TF functions with XLA",We,F,Zt="Let us consider the following model in TensorFlow:",Ie,V,Be,E,xt="The above model accepts inputs having a dimension of <code>(10, )</code>. We can use the model for running a forward pass like so:",$e,z,Fe,A,Xt="In order to run the forward pass with an XLA-compiled function, we’d need to do:",Ve,L,Ee,N,Gt="The default <code>call()</code> function of the <code>model</code> is used for compiling the XLA graph. But if there’s any other model function you want to compile into XLA that’s also possible with:",ze,H,Ae,T,_,ge,Q,Mt,me,Ct="Running a TF text generation model with XLA from 🤗 Transformers",Le,Y,Rt="To enable XLA-accelerated generation within 🤗 Transformers, you need to have a recent version of <code>transformers</code> installed. You can install it by running:",Ne,q,He,S,Wt="And then you can run the following code:",Qe,P,Ye,K,It="As you can notice, enabling XLA on <code>generate()</code> is just a single line of code. The rest of the code remains unchanged. However, there are a couple of gotchas in the above code snippet that are specific to XLA. You need to be aware of those to realize the speed-ups that XLA can bring in. We discuss these in the following section.",qe,J,Z,Te,D,yt,fe,Bt="Gotchas to be aware of",Se,O,$t='When you are executing an XLA-enabled function (like <code>xla_generate()</code> above) for the first time, it will internally try to infer the computation graph, which is time-consuming.  This process is known as <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“tracing”</a>.',Pe,ee,Ft="You might notice that the generation time is not fast. Successive calls of <code>xla_generate()</code> (or any other XLA-enabled function) won’t have to infer the computation graph, given the inputs to the function follow the same shape with which the computation graph was initially built. While this is not a problem for modalities with fixed input shapes (e.g., images), you must pay attention if you are working with variable input shape modalities (e.g., text).",Ke,te,Vt="To ensure <code>xla_generate()</code> always operates with the same input shapes, you can specify the <code>padding</code> arguments when calling the tokenizer.",De,le,Oe,ne,Et="This way, you can ensure that the inputs to <code>xla_generate()</code> will always receive inputs with the shape it was traced with and thus leading to speed-ups in the generation time. You can verify this with the code below:",et,se,tt,ae,zt="On a Tesla T4 GPU, you can expect the outputs like so:",lt,oe,nt,ie,At="The first call to <code>xla_generate()</code> is time-consuming because of tracing, but the successive calls are orders of magnitude faster. Keep in mind that any change in the generation options at any point with trigger re-tracing and thus leading to slow-downs in the generation time.",st,re,Lt="We didn’t cover all the text generation options 🤗 Transformers provides in this document. We encourage you to read the documentation for advanced use cases.",at,v,x,Je,pe,bt,we,Nt="Additional Resources",ot,ce,Ht="Here, we leave you with some additional resources if you want to delve deeper into XLA in 🤗 Transformers and in general.",it,he,Qt='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">This Colab Notebook</a> provides an interactive demonstration if you want to fiddle with the XLA-compatible encoder-decoder (like <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>) and decoder-only (like <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>) text generation models.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">This blog post</a> provides an overview of the comparison benchmarks for XLA-compatible models along with a friendly introduction to XLA in TensorFlow.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">This blog post</a> discusses our design philosophy behind adding XLA support to the TensorFlow models in 🤗 Transformers.</li> <li>Recommended posts for learning more about XLA and TensorFlow graphs in general:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: Optimizing Compiler for Machine Learning</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">Introduction to graphs and tf.function</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">Better performance with tf.function</a></li></ul></li>',rt,ve,pt;return X=new je({}),G=new pl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"}]}}),$=new je({}),V=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`}}),z=new j({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`}}),L=new j({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`}}),H=new j({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)'}}),Q=new je({}),q=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade"}}),P=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dF9zdHJpbmclMjAlM0QlMjAlNUIlMjJUZW5zb3JGbG93JTIwaXMlMjIlNUQlMEElMEElMjMlMjBPbmUlMjBsaW5lJTIwdG8lMjBjcmVhdGUlMjBhbiUyMFhMQSUyMGdlbmVyYXRpb24lMjBmdW5jdGlvbiUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQXRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWdlbmVyYXRlZF90b2tlbnMlMjAlM0QlMjB4bGFfZ2VuZXJhdGUoKip0b2tlbml6ZWRfaW5wdXQlMkMlMjBudW1fYmVhbXMlM0QyKSUwQSUwQWRlY29kZWRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChmJTIyR2VuZXJhdGVkJTIwLS0lMjAlN0JkZWNvZGVkX3RleHQlN0QlMjIpJTBBJTIzJTIwR2VuZXJhdGVkJTIwLS0lMjBUZW5zb3JGbG93JTIwaXMlMjBhbiUyMG9wZW4tc291cmNlJTJDJTIwb3Blbi1zb3VyY2UlMkMlMjBkaXN0cmlidXRlZC1zb3VyY2UlMjBhcHBsaWNhdGlvbiUyMCUyMyUyMGZyYW1ld29yayUyMGZvciUyMHRoZQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`}}),D=new je({}),le=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMEhlcmUlMkMlMjB3ZSUyMGNhbGwlMjB0aGUlMjB0b2tlbml6ZXIlMjB3aXRoJTIwcGFkZGluZyUyMG9wdGlvbnMuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`}}),se=new j({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`}}),oe=new j({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`}}),pe=new je({}),{c(){y=s("meta"),Ue=o(),Me=s("p"),ke=o(),b=s("h1"),U=s("a"),ye=s("span"),u(X.$$.fragment),ft=o(),ue=s("span"),ue.textContent=Tt,_e=o(),u(G.$$.fragment),Ze=o(),C=s("p"),C.innerHTML=Jt,xe=o(),R=s("p"),R.textContent=vt,Xe=o(),W=s("p"),W.innerHTML=jt,Ge=o(),I=s("p"),I.innerHTML=Ut,Ce=o(),B=s("p"),B.textContent=kt,Re=o(),g=s("h2"),k=s("a"),be=s("span"),u($.$$.fragment),wt=o(),de=s("span"),de.textContent=_t,We=o(),F=s("p"),F.textContent=Zt,Ie=o(),u(V.$$.fragment),Be=o(),E=s("p"),E.innerHTML=xt,$e=o(),u(z.$$.fragment),Fe=o(),A=s("p"),A.textContent=Xt,Ve=o(),u(L.$$.fragment),Ee=o(),N=s("p"),N.innerHTML=Gt,ze=o(),u(H.$$.fragment),Ae=o(),T=s("h2"),_=s("a"),ge=s("span"),u(Q.$$.fragment),Mt=o(),me=s("span"),me.textContent=Ct,Le=o(),Y=s("p"),Y.innerHTML=Rt,Ne=o(),u(q.$$.fragment),He=o(),S=s("p"),S.textContent=Wt,Qe=o(),u(P.$$.fragment),Ye=o(),K=s("p"),K.innerHTML=It,qe=o(),J=s("h2"),Z=s("a"),Te=s("span"),u(D.$$.fragment),yt=o(),fe=s("span"),fe.textContent=Bt,Se=o(),O=s("p"),O.innerHTML=$t,Pe=o(),ee=s("p"),ee.innerHTML=Ft,Ke=o(),te=s("p"),te.innerHTML=Vt,De=o(),u(le.$$.fragment),Oe=o(),ne=s("p"),ne.innerHTML=Et,et=o(),u(se.$$.fragment),tt=o(),ae=s("p"),ae.textContent=zt,lt=o(),u(oe.$$.fragment),nt=o(),ie=s("p"),ie.innerHTML=At,st=o(),re=s("p"),re.textContent=Lt,at=o(),v=s("h2"),x=s("a"),Je=s("span"),u(pe.$$.fragment),bt=o(),we=s("span"),we.textContent=Nt,ot=o(),ce=s("p"),ce.textContent=Ht,it=o(),he=s("ul"),he.innerHTML=Qt,rt=o(),ve=s("p"),this.h()},l(e){const l=rl("svelte-1phssyn",document.head);y=a(l,"META",{name:!0,content:!0}),l.forEach(t),Ue=i(e),Me=a(e,"P",{}),h(Me).forEach(t),ke=i(e),b=a(e,"H1",{class:!0});var ct=h(b);U=a(ct,"A",{id:!0,class:!0,href:!0});var Yt=h(U);ye=a(Yt,"SPAN",{});var qt=h(ye);d(X.$$.fragment,qt),qt.forEach(t),Yt.forEach(t),ft=i(ct),ue=a(ct,"SPAN",{"data-svelte-h":!0}),r(ue)!=="svelte-qgnen0"&&(ue.textContent=Tt),ct.forEach(t),_e=i(e),d(G.$$.fragment,e),Ze=i(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-afit4t"&&(C.innerHTML=Jt),xe=i(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1rjg69l"&&(R.textContent=vt),Xe=i(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-8rwpb7"&&(W.innerHTML=jt),Ge=i(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1sup5o3"&&(I.innerHTML=Ut),Ce=i(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-v22hyz"&&(B.textContent=kt),Re=i(e),g=a(e,"H2",{class:!0});var ht=h(g);k=a(ht,"A",{id:!0,class:!0,href:!0});var St=h(k);be=a(St,"SPAN",{});var Pt=h(be);d($.$$.fragment,Pt),Pt.forEach(t),St.forEach(t),wt=i(ht),de=a(ht,"SPAN",{"data-svelte-h":!0}),r(de)!=="svelte-11enf4e"&&(de.textContent=_t),ht.forEach(t),We=i(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1n8d5xl"&&(F.textContent=Zt),Ie=i(e),d(V.$$.fragment,e),Be=i(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-137qaqi"&&(E.innerHTML=xt),$e=i(e),d(z.$$.fragment,e),Fe=i(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1xkaplb"&&(A.textContent=Xt),Ve=i(e),d(L.$$.fragment,e),Ee=i(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-3tnenm"&&(N.innerHTML=Gt),ze=i(e),d(H.$$.fragment,e),Ae=i(e),T=a(e,"H2",{class:!0});var ut=h(T);_=a(ut,"A",{id:!0,class:!0,href:!0});var Kt=h(_);ge=a(Kt,"SPAN",{});var Dt=h(ge);d(Q.$$.fragment,Dt),Dt.forEach(t),Kt.forEach(t),Mt=i(ut),me=a(ut,"SPAN",{"data-svelte-h":!0}),r(me)!=="svelte-11azny9"&&(me.textContent=Ct),ut.forEach(t),Le=i(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1tqra4o"&&(Y.innerHTML=Rt),Ne=i(e),d(q.$$.fragment,e),He=i(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-5mrt6v"&&(S.textContent=Wt),Qe=i(e),d(P.$$.fragment,e),Ye=i(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-xz55ih"&&(K.innerHTML=It),qe=i(e),J=a(e,"H2",{class:!0});var dt=h(J);Z=a(dt,"A",{id:!0,class:!0,href:!0});var Ot=h(Z);Te=a(Ot,"SPAN",{});var el=h(Te);d(D.$$.fragment,el),el.forEach(t),Ot.forEach(t),yt=i(dt),fe=a(dt,"SPAN",{"data-svelte-h":!0}),r(fe)!=="svelte-uc32sf"&&(fe.textContent=Bt),dt.forEach(t),Se=i(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1tw7ufk"&&(O.innerHTML=$t),Pe=i(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1v603pg"&&(ee.innerHTML=Ft),Ke=i(e),te=a(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1s9agvy"&&(te.innerHTML=Vt),De=i(e),d(le.$$.fragment,e),Oe=i(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1nbul0x"&&(ne.innerHTML=Et),et=i(e),d(se.$$.fragment,e),tt=i(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-zm3wt3"&&(ae.textContent=zt),lt=i(e),d(oe.$$.fragment,e),nt=i(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-18ijq7m"&&(ie.innerHTML=At),st=i(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-149gqik"&&(re.textContent=Lt),at=i(e),v=a(e,"H2",{class:!0});var mt=h(v);x=a(mt,"A",{id:!0,class:!0,href:!0});var tl=h(x);Je=a(tl,"SPAN",{});var ll=h(Je);d(pe.$$.fragment,ll),ll.forEach(t),tl.forEach(t),bt=i(mt),we=a(mt,"SPAN",{"data-svelte-h":!0}),r(we)!=="svelte-1myqx91"&&(we.textContent=Nt),mt.forEach(t),ot=i(e),ce=a(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-k2oxa5"&&(ce.textContent=Ht),it=i(e),he=a(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-19xtsh9"&&(he.innerHTML=Qt),rt=i(e),ve=a(e,"P",{}),h(ve).forEach(t),this.h()},h(){p(y,"name","hf:doc:metadata"),p(y,"content",JSON.stringify(hl)),p(U,"id","xla-integration-for-tensorflow-models"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#xla-integration-for-tensorflow-models"),p(b,"class","relative group"),p(k,"id","running-tf-functions-with-xla"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#running-tf-functions-with-xla"),p(g,"class","relative group"),p(_,"id","running-a-tf-text-generation-model-with-xla-from-transformers"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#running-a-tf-text-generation-model-with-xla-from-transformers"),p(T,"class","relative group"),p(Z,"id","gotchas-to-be-aware-of"),p(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Z,"href","#gotchas-to-be-aware-of"),p(J,"class","relative group"),p(x,"id","additional-resources"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#additional-resources"),p(v,"class","relative group")},m(e,l){c(document.head,y),n(e,Ue,l),n(e,Me,l),n(e,ke,l),n(e,b,l),c(b,U),c(U,ye),m(X,ye,null),c(b,ft),c(b,ue),n(e,_e,l),m(G,e,l),n(e,Ze,l),n(e,C,l),n(e,xe,l),n(e,R,l),n(e,Xe,l),n(e,W,l),n(e,Ge,l),n(e,I,l),n(e,Ce,l),n(e,B,l),n(e,Re,l),n(e,g,l),c(g,k),c(k,be),m($,be,null),c(g,wt),c(g,de),n(e,We,l),n(e,F,l),n(e,Ie,l),m(V,e,l),n(e,Be,l),n(e,E,l),n(e,$e,l),m(z,e,l),n(e,Fe,l),n(e,A,l),n(e,Ve,l),m(L,e,l),n(e,Ee,l),n(e,N,l),n(e,ze,l),m(H,e,l),n(e,Ae,l),n(e,T,l),c(T,_),c(_,ge),m(Q,ge,null),c(T,Mt),c(T,me),n(e,Le,l),n(e,Y,l),n(e,Ne,l),m(q,e,l),n(e,He,l),n(e,S,l),n(e,Qe,l),m(P,e,l),n(e,Ye,l),n(e,K,l),n(e,qe,l),n(e,J,l),c(J,Z),c(Z,Te),m(D,Te,null),c(J,yt),c(J,fe),n(e,Se,l),n(e,O,l),n(e,Pe,l),n(e,ee,l),n(e,Ke,l),n(e,te,l),n(e,De,l),m(le,e,l),n(e,Oe,l),n(e,ne,l),n(e,et,l),m(se,e,l),n(e,tt,l),n(e,ae,l),n(e,lt,l),m(oe,e,l),n(e,nt,l),n(e,ie,l),n(e,st,l),n(e,re,l),n(e,at,l),n(e,v,l),c(v,x),c(x,Je),m(pe,Je,null),c(v,bt),c(v,we),n(e,ot,l),n(e,ce,l),n(e,it,l),n(e,he,l),n(e,rt,l),n(e,ve,l),pt=!0},p:sl,i(e){pt||(f(X.$$.fragment,e),f(G.$$.fragment,e),f($.$$.fragment,e),f(V.$$.fragment,e),f(z.$$.fragment,e),f(L.$$.fragment,e),f(H.$$.fragment,e),f(Q.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),pt=!0)},o(e){w(X.$$.fragment,e),w(G.$$.fragment,e),w($.$$.fragment,e),w(V.$$.fragment,e),w(z.$$.fragment,e),w(L.$$.fragment,e),w(H.$$.fragment,e),w(Q.$$.fragment,e),w(q.$$.fragment,e),w(P.$$.fragment,e),w(D.$$.fragment,e),w(le.$$.fragment,e),w(se.$$.fragment,e),w(oe.$$.fragment,e),w(pe.$$.fragment,e),pt=!1},d(e){e&&(t(Ue),t(Me),t(ke),t(b),t(_e),t(Ze),t(C),t(xe),t(R),t(Xe),t(W),t(Ge),t(I),t(Ce),t(B),t(Re),t(g),t(We),t(F),t(Ie),t(Be),t(E),t($e),t(Fe),t(A),t(Ve),t(Ee),t(N),t(ze),t(Ae),t(T),t(Le),t(Y),t(Ne),t(He),t(S),t(Qe),t(Ye),t(K),t(qe),t(J),t(Se),t(O),t(Pe),t(ee),t(Ke),t(te),t(De),t(Oe),t(ne),t(et),t(tt),t(ae),t(lt),t(nt),t(ie),t(st),t(re),t(at),t(v),t(ot),t(ce),t(it),t(he),t(rt),t(ve)),t(y),M(X),M(G,e),M($),M(V,e),M(z,e),M(L,e),M(H,e),M(Q),M(q,e),M(P,e),M(D),M(le,e),M(se,e),M(oe,e),M(pe)}}}const hl={local:"xla-integration-for-tensorflow-models",sections:[{local:"running-tf-functions-with-xla",title:"Running TF functions with XLA"},{local:"running-a-tf-text-generation-model-with-xla-from-transformers",title:"Running a TF text generation model with XLA from 🤗 Transformers"},{local:"gotchas-to-be-aware-of",title:"Gotchas to be aware of"},{local:"additional-resources",title:"Additional Resources"}],title:"XLA Integration for TensorFlow Models"};function ul(gt){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yl extends ol{constructor(y){super(),il(this,y,ul,cl,nl,{})}}export{yl as component};
