import{s as $a,o as Ca,n as Pt}from"../chunks/scheduler.9bc65507.js";import{S as za,i as Ia,g as n,s as a,u as g,A as Na,h as s,f as t,c as i,j as h,v as u,y as l,k as p,o,a as d,w as f,d as _,t as b,x as y}from"../chunks/index.78c82d43.js";import{T as ar}from"../chunks/Tip.87d55b76.js";import{D as x}from"../chunks/Docstring.f3d04bd2.js";import{C as qt}from"../chunks/CodeBlock.48618ec2.js";import{I as R}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Kn}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as Ja}from"../chunks/PipelineTag.75b0f707.js";function Ea(k){let m,D="Examples:",v,T,w;return T=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJDb25maWclMkMlMjBEZXRyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwREVUUiUyMGZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGV0ckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrConfig, DetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DETR facebook/detr-resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/detr-resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){m=n("p"),m.textContent=D,v=a(),g(T.$$.fragment)},l(c){m=s(c,"P",{"data-svelte-h":!0}),l(m)!=="svelte-kvfsh7"&&(m.textContent=D),v=i(c),u(T.$$.fragment,c)},m(c,M){d(c,m,M),d(c,v,M),f(T,c,M),w=!0},p:Pt,i(c){w||(_(T.$$.fragment,c),w=!0)},o(c){b(T.$$.fragment,c),w=!1},d(c){c&&(t(m),t(v)),y(T,c)}}}function Oa(k){let m,D=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=n("p"),m.innerHTML=D},l(v){m=s(v,"P",{"data-svelte-h":!0}),l(m)!=="svelte-fincs2"&&(m.innerHTML=D)},m(v,T){d(v,m,T)},p:Pt,d(v){v&&t(m)}}}function Ua(k){let m,D="Examples:",v,T,w;return T=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERldHJNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMERldHJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwdGhlJTIwbGFzdCUyMGhpZGRlbiUyMHN0YXRlcyUyMGFyZSUyMHRoZSUyMGZpbmFsJTIwcXVlcnklMjBlbWJlZGRpbmdzJTIwb2YlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGRlY29kZXIlMEElMjMlMjB0aGVzZSUyMGFyZSUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9xdWVyaWVzJTJDJTIwaGlkZGVuX3NpemUpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DetrModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrModel.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>]`}}),{c(){m=n("p"),m.textContent=D,v=a(),g(T.$$.fragment)},l(c){m=s(c,"P",{"data-svelte-h":!0}),l(m)!=="svelte-kvfsh7"&&(m.textContent=D),v=i(c),u(T.$$.fragment,c)},m(c,M){d(c,m,M),d(c,v,M),f(T,c,M),w=!0},p:Pt,i(c){w||(_(T.$$.fragment,c),w=!0)},o(c){b(T.$$.fragment,c),w=!1},d(c){c&&(t(m),t(v)),y(T,c)}}}function qa(k){let m,D=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=n("p"),m.innerHTML=D},l(v){m=s(v,"P",{"data-svelte-h":!0}),l(m)!=="svelte-fincs2"&&(m.innerHTML=D)},m(v,T){d(v,m,T)},p:Pt,d(v){v&&t(m)}}}function Pa(k){let m,D="Examples:",v,T,w;return T=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERldHJGb3JPYmplY3REZXRlY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMERldHJGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwY29udmVydCUyMG91dHB1dHMlMjAoYm91bmRpbmclMjBib3hlcyUyMGFuZCUyMGNsYXNzJTIwbG9naXRzKSUyMHRvJTIwQ09DTyUyMEFQSSUwQXRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBcmVzdWx0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC45JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QiUwQSUyMCUyMCUyMCUyMDAlMEElNUQlMEElMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMyklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DetrForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">40.16</span>, <span class="hljs-number">70.81</span>, <span class="hljs-number">175.55</span>, <span class="hljs-number">117.98</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.996</span> at location [<span class="hljs-number">333.24</span>, <span class="hljs-number">72.55</span>, <span class="hljs-number">368.33</span>, <span class="hljs-number">187.66</span>]
Detected couch <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.995</span> at location [-<span class="hljs-number">0.02</span>, <span class="hljs-number">1.15</span>, <span class="hljs-number">639.73</span>, <span class="hljs-number">473.76</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.999</span> at location [<span class="hljs-number">13.24</span>, <span class="hljs-number">52.05</span>, <span class="hljs-number">314.02</span>, <span class="hljs-number">470.93</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.999</span> at location [<span class="hljs-number">345.4</span>, <span class="hljs-number">23.85</span>, <span class="hljs-number">640.37</span>, <span class="hljs-number">368.72</span>]`}}),{c(){m=n("p"),m.textContent=D,v=a(),g(T.$$.fragment)},l(c){m=s(c,"P",{"data-svelte-h":!0}),l(m)!=="svelte-kvfsh7"&&(m.textContent=D),v=i(c),u(T.$$.fragment,c)},m(c,M){d(c,m,M),d(c,v,M),f(T,c,M),w=!0},p:Pt,i(c){w||(_(T.$$.fragment,c),w=!0)},o(c){b(T.$$.fragment,c),w=!1},d(c){c&&(t(m),t(v)),y(T,c)}}}function La(k){let m,D=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=n("p"),m.innerHTML=D},l(v){m=s(v,"P",{"data-svelte-h":!0}),l(m)!=="svelte-fincs2"&&(m.innerHTML=D)},m(v,T){d(v,m,T)},p:Pt,d(v){v&&t(m)}}}function Za(k){let m,D="Examples:",v,T,w;return T=new qt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> io
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DetrForSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.image_transforms <span class="hljs-keyword">import</span> rgb_to_id

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50-panoptic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use the \`post_process_panoptic_segmentation\` method of the \`image_processor\` to retrieve post-processed panoptic segmentation maps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Segmentation results are returned as a list of dictionaries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[(<span class="hljs-number">300</span>, <span class="hljs-number">500</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A tensor of shape (height, width) where each value denotes a segment id, filled with -1 if no segment is found</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>panoptic_seg = result[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get prediction score and segment_id to class_id mapping of each segment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>panoptic_segments_info = result[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segments_info&quot;</span>]`}}),{c(){m=n("p"),m.textContent=D,v=a(),g(T.$$.fragment)},l(c){m=s(c,"P",{"data-svelte-h":!0}),l(m)!=="svelte-kvfsh7"&&(m.textContent=D),v=i(c),u(T.$$.fragment,c)},m(c,M){d(c,m,M),d(c,v,M),f(T,c,M),w=!0},p:Pt,i(c){w||(_(T.$$.fragment,c),w=!0)},o(c){b(T.$$.fragment,c),w=!1},d(c){c&&(t(m),t(v)),y(T,c)}}}function Ra(k){let m,D,v,T,w,c,M,ze,es,Lt,ir="DETR",Lo,S,te,jo,Ie,ts,Zt,dr="Overview",Zo,Ne,cr=`The DETR model was proposed in <a href="https://arxiv.org/abs/2005.12872" rel="nofollow">End-to-End Object Detection with Transformers</a> by
Nicolas Carion, Francisco Massa, Gabriel Synnaeve, Nicolas Usunier, Alexander Kirillov and Sergey Zagoruyko. DETR
consists of a convolutional backbone followed by an encoder-decoder Transformer which can be trained end-to-end for
object detection. It greatly simplifies a lot of the complexity of models like Faster-R-CNN and Mask-R-CNN, which use
things like region proposals, non-maximum suppression procedure and anchor generation. Moreover, DETR can also be
naturally extended to perform panoptic segmentation, by simply adding a mask head on top of the decoder outputs.`,Ro,Je,lr="The abstract from the paper is the following:",So,Ee,mr=`<em>We present a new method that views object detection as a direct set prediction problem. Our approach streamlines the
detection pipeline, effectively removing the need for many hand-designed components like a non-maximum suppression
procedure or anchor generation that explicitly encode our prior knowledge about the task. The main ingredients of the
new framework, called DEtection TRansformer or DETR, are a set-based global loss that forces unique predictions via
bipartite matching, and a transformer encoder-decoder architecture. Given a fixed small set of learned object queries,
DETR reasons about the relations of the objects and the global image context to directly output the final set of
predictions in parallel. The new model is conceptually simple and does not require a specialized library, unlike many
other modern detectors. DETR demonstrates accuracy and run-time performance on par with the well-established and
highly-optimized Faster RCNN baseline on the challenging COCO object detection dataset. Moreover, DETR can be easily
generalized to produce panoptic segmentation in a unified manner. We show that it significantly outperforms competitive
baselines.</em>`,Wo,Oe,pr='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/facebookresearch/detr" rel="nofollow">here</a>.',Ho,Ue,hr='Here’s a TLDR explaining how <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> works:',Bo,qe,gr=`First, an image is sent through a pre-trained convolutional backbone (in the paper, the authors use
ResNet-50/ResNet-101). Let’s assume we also add a batch dimension. This means that the input to the backbone is a
tensor of shape <code>(batch_size, 3, height, width)</code>, assuming the image has 3 color channels (RGB). The CNN backbone
outputs a new lower-resolution feature map, typically of shape <code>(batch_size, 2048, height/32, width/32)</code>. This is
then projected to match the hidden dimension of the Transformer of DETR, which is <code>256</code> by default, using a
<code>nn.Conv2D</code> layer. So now, we have a tensor of shape <code>(batch_size, 256, height/32, width/32).</code> Next, the
feature map is flattened and transposed to obtain a tensor of shape <code>(batch_size, seq_len, d_model)</code> =
<code>(batch_size, width/32*height/32, 256)</code>. So a difference with NLP models is that the sequence length is actually
longer than usual, but with a smaller <code>d_model</code> (which in NLP is typically 768 or higher).`,Ao,Pe,ur=`Next, this is sent through the encoder, outputting <code>encoder_hidden_states</code> of the same shape (you can consider
these as image features). Next, so-called <strong>object queries</strong> are sent through the decoder. This is a tensor of shape
<code>(batch_size, num_queries, d_model)</code>, with <code>num_queries</code> typically set to 100 and initialized with zeros.
These input embeddings are learnt positional encodings that the authors refer to as object queries, and similarly to
the encoder, they are added to the input of each attention layer. Each object query will look for a particular object
in the image. The decoder updates these embeddings through multiple self-attention and encoder-decoder attention layers
to output <code>decoder_hidden_states</code> of the same shape: <code>(batch_size, num_queries, d_model)</code>. Next, two heads
are added on top for object detection: a linear layer for classifying each object query into one of the objects or “no
object”, and a MLP to predict bounding boxes for each query.`,Go,Le,fr=`The model is trained using a <strong>bipartite matching loss</strong>: so what we actually do is compare the predicted classes +
bounding boxes of each of the N = 100 object queries to the ground truth annotations, padded up to the same length N
(so if an image only contains 4 objects, 96 annotations will just have a “no object” as class and “no bounding box” as
bounding box). The <a href="https://en.wikipedia.org/wiki/Hungarian_algorithm" rel="nofollow">Hungarian matching algorithm</a> is used to find
an optimal one-to-one mapping of each of the N queries to each of the N annotations. Next, standard cross-entropy (for
the classes) and a linear combination of the L1 and <a href="https://giou.stanford.edu/" rel="nofollow">generalized IoU loss</a> (for the
bounding boxes) are used to optimize the parameters of the model.`,Vo,Ze,_r=`DETR can be naturally extended to perform panoptic segmentation (which unifies semantic segmentation and instance
segmentation). <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> adds a segmentation mask head on top of
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>. The mask head can be trained either jointly, or in a two steps process,
where one first trains a <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> model to detect bounding boxes around both
“things” (instances) and “stuff” (background things like trees, roads, sky), then freeze all the weights and train only
the mask head for 25 epochs. Experimentally, these two approaches give similar results. Note that predicting boxes is
required for the training to be possible, since the Hungarian matching is computed using distances between boxes.`,Xo,Re,br="Tips:",Yo,Se,yr=`<li>DETR uses so-called <strong>object queries</strong> to detect objects in an image. The number of queries determines the maximum
number of objects that can be detected in a single image, and is set to 100 by default (see parameter
<code>num_queries</code> of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>). Note that it’s good to have some slack (in COCO, the
authors used 100, while the maximum number of objects in a COCO image is ~70).</li> <li>The decoder of DETR updates the query embeddings in parallel. This is different from language models like GPT-2,
which use autoregressive decoding instead of parallel. Hence, no causal attention mask is used.</li> <li>DETR adds position embeddings to the hidden states at each self-attention and cross-attention layer before projecting
to queries and keys. For the position embeddings of the image, one can choose between fixed sinusoidal or learned
absolute position embeddings. By default, the parameter <code>position_embedding_type</code> of
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> is set to <code>&quot;sine&quot;</code>.</li> <li>During training, the authors of DETR did find it helpful to use auxiliary losses in the decoder, especially to help
the model output the correct number of objects of each class. If you set the parameter <code>auxiliary_loss</code> of
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> to <code>True</code>, then prediction feedforward neural networks and Hungarian losses
are added after each decoder layer (with the FFNs sharing parameters).</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<em>num_boxes</em> variable in the <em>DetrLoss</em> class of <em>modeling_detr.py</em>. When training on multiple nodes, this should be
set to the average number of target boxes across all nodes, as can be seen in the original implementation <a href="https://github.com/facebookresearch/detr/blob/a54b77800eb8e64e3ad0d8237789fcbf2f8350c5/models/detr.py#L227-L232" rel="nofollow">here</a>.</li> <li><a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> and <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> can be initialized with
any convolutional backbone available in the <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm library</a>.
Initializing with a MobileNet backbone for example can be done by setting the <code>backbone</code> attribute of
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> to <code>&quot;tf_mobilenetv3_small_075&quot;</code>, and then initializing the model with that
config.</li> <li>DETR resizes the input images such that the shortest side is at least a certain amount of pixels while the longest is
at most 1333 pixels. At training time, scale augmentation is used such that the shortest side is randomly set to at
least 480 and at most 800 pixels. At inference time, the shortest side is set to 800. One can use
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> to prepare images (and optional annotations in COCO format) for the
model. Due to this resizing, images in a batch can have different sizes. DETR solves this by padding images up to the
largest size in a batch, and by creating a pixel mask that indicates which pixels are real/which are padding.
Alternatively, one can also define a custom <code>collate_fn</code> in order to batch images together, using
<code>~transformers.DetrImageProcessor.pad_and_create_pixel_mask</code>.</li> <li>The size of the images will determine the amount of memory being used, and will thus determine the <code>batch_size</code>.
It is advised to use a batch size of 2 per GPU. See <a href="https://github.com/facebookresearch/detr/issues/150" rel="nofollow">this Github thread</a> for more info.</li>`,Qo,We,vr="There are three ways to instantiate a DETR model (depending on what you prefer):",Ko,He,Tr="Option 1: Instantiate DETR with pre-trained weights for entire model",en,Be,tn,Ae,wr="Option 2: Instantiate DETR with randomly initialized weights for Transformer, but pre-trained weights for backbone",on,Ge,nn,Ve,Dr="Option 3: Instantiate DETR with randomly initialized weights for backbone + Transformer",sn,Xe,rn,Ye,xr="As a summary, consider the following table:",an,Qe,Mr='<thead><tr><th>Task</th> <th>Object detection</th> <th>Instance segmentation</th> <th>Panoptic segmentation</th></tr></thead> <tbody><tr><td><strong>Description</strong></td> <td>Predicting bounding boxes and class labels around objects in an image</td> <td>Predicting masks around objects (i.e. instances) in an image</td> <td>Predicting masks around both objects (i.e. instances) as well as “stuff” (i.e. background things like trees and roads) in an image</td></tr> <tr><td><strong>Model</strong></td> <td><a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a></td> <td><a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a></td> <td><a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a></td></tr> <tr><td><strong>Example dataset</strong></td> <td>COCO detection</td> <td>COCO detection, COCO panoptic</td> <td>COCO panoptic</td></tr> <tr><td><strong>Format of annotations to provide to</strong> <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a></td> <td>{‘image_id’: <code>int</code>, ‘annotations’: <code>List[Dict]</code>} each Dict being a COCO object annotation</td> <td>{‘image_id’: <code>int</code>, ‘annotations’: <code>List[Dict]</code>}  (in case of COCO detection) or {‘file_name’: <code>str</code>, ‘image_id’: <code>int</code>, ‘segments_info’: <code>List[Dict]</code>} (in case of COCO panoptic)</td> <td>{‘file_name’: <code>str</code>, ‘image_id’: <code>int</code>, ‘segments_info’: <code>List[Dict]</code>} and masks_path (path to directory containing PNG files of the masks)</td></tr> <tr><td><strong>Postprocessing</strong> (i.e. converting the output of the model to COCO API)</td> <td><code>post_process()</code></td> <td><code>post_process_segmentation()</code></td> <td><code>post_process_segmentation()</code>, <code>post_process_panoptic()</code></td></tr> <tr><td><strong>evaluators</strong></td> <td><code>CocoEvaluator</code> with <code>iou_types=&quot;bbox&quot;</code></td> <td><code>CocoEvaluator</code> with <code>iou_types=&quot;bbox&quot;</code> or <code>&quot;segm&quot;</code></td> <td><code>CocoEvaluator</code> with <code>iou_tupes=&quot;bbox&quot;</code> or <code>&quot;segm&quot;</code>, <code>PanopticEvaluator</code></td></tr></tbody>',dn,Ke,jr=`In short, one should prepare the data either in COCO detection or COCO panoptic format, then use
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> to create <code>pixel_values</code>, <code>pixel_mask</code> and optional
<code>labels</code>, which can then be used to train (or fine-tune) a model. For evaluation, one should first convert the
outputs of the model using one of the postprocessing methods of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. These can
be be provided to either <code>CocoEvaluator</code> or <code>PanopticEvaluator</code>, which allow you to calculate metrics like
mean Average Precision (mAP) and Panoptic Quality (PQ). The latter objects are implemented in the <a href="https://github.com/facebookresearch/detr" rel="nofollow">original repository</a>. See the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DETR" rel="nofollow">example notebooks</a> for more info regarding evaluation.`,cn,W,oe,Fo,et,os,Rt,Fr="Resources",ln,tt,kr="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DETR.",mn,ot,pn,nt,$r='<li>All example notebooks illustrating fine-tuning <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> and <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> on a custom dataset an be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DETR" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',hn,st,Cr="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",gn,H,ne,ko,rt,ns,St,zr="DETR specific outputs",un,B,at,ss,Wt,Ir=`Base class for outputs of the DETR encoder-decoder model. This class adds one attribute to Seq2SeqModelOutput,
namely an optional stack of intermediate decoder activations, i.e. the output of each decoder layer, each of them
gone through a layernorm. This is useful when training the model with auxiliary decoding losses.`,fn,A,it,rs,Ht,Nr='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>.',_n,G,dt,as,Bt,Jr='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>.',bn,V,se,$o,ct,is,At,Er="DetrConfig",yn,$,lt,ds,Gt,Or=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrModel">DetrModel</a>. It is used to instantiate a DETR
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DETR
<a href="https://huggingface.co/facebook/detr-resnet-50" rel="nofollow">facebook/detr-resnet-50</a> architecture.`,cs,Vt,Ur=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ls,re,ms,ae,mt,ps,Xt,qr='Instantiate a <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> (or a derived class) from a pre-trained backbone model configuration.',vn,X,ie,Co,pt,hs,Yt,Pr="DetrImageProcessor",Tn,j,ht,gs,Qt,Lr="Constructs a Detr image processor.",us,de,gt,fs,Kt,Zr="Preprocess an image or a batch of images so that it can be used by the model.",_s,ce,ut,bs,eo,Rr=`Converts the raw output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,ys,le,ft,vs,to,Sr='Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Ts,me,_t,ws,oo,Wr='Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into instance segmentation predictions. Only supports PyTorch.',Ds,pe,bt,xs,no,Hr=`Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into image panoptic segmentation predictions. Only supports
PyTorch.`,wn,Y,he,zo,yt,Ms,so,Br="DetrFeatureExtractor",Dn,F,vt,js,ge,Tt,Fs,ro,Ar="Preprocess an image or a batch of images.",ks,ue,wt,$s,ao,Gr=`Converts the raw output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Cs,fe,Dt,zs,io,Vr='Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Is,_e,xt,Ns,co,Xr='Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into instance segmentation predictions. Only supports PyTorch.',Js,be,Mt,Es,lo,Yr=`Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> into image panoptic segmentation predictions. Only supports
PyTorch.`,xn,Q,ye,Io,jt,Os,mo,Qr="DetrModel",Mn,C,Ft,Us,po,Kr=`The bare DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw hidden-states without
any specific head on top.`,qs,ho,ea=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ps,go,ta=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ls,J,kt,Zs,uo,oa='The <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrModel">DetrModel</a> forward method, overrides the <code>__call__</code> special method.',Rs,ve,Ss,Te,jn,K,we,No,$t,Ws,fo,na="DetrForObjectDetection",Fn,z,Ct,Hs,_o,sa=`DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on top, for tasks
such as COCO detection.`,Bs,bo,ra=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,As,yo,aa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gs,E,zt,Vs,vo,ia='The <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Xs,De,Ys,xe,kn,ee,Me,Jo,It,Qs,To,da="DetrForSegmentation",$n,I,Nt,Ks,wo,ca=`DETR Model (consisting of a backbone and encoder-decoder Transformer) with a segmentation head on top, for tasks
such as COCO panoptic.`,er,Do,la=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,tr,xo,ma=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,or,O,Jt,nr,Mo,pa='The <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> forward method, overrides the <code>__call__</code> special method.',sr,je,rr,Fe,Cn,Eo,zn;return ze=new R({}),Ie=new R({}),Be=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJGb3JPYmplY3REZXRlY3Rpb24lMEElMEFtb2RlbCUyMCUzRCUyMERldHJGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)`}}),Ge=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJDb25maWclMkMlMjBEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uJTBBJTBBY29uZmlnJTIwJTNEJTIwRGV0ckNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrConfig, DetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>config = DetrConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection(config)`}}),Xe=new qt({props:{code:"Y29uZmlnJTIwJTNEJTIwRGV0ckNvbmZpZyh1c2VfcHJldHJhaW5lZF9iYWNrYm9uZSUzREZhbHNlKSUwQW1vZGVsJTIwJTNEJTIwRGV0ckZvck9iamVjdERldGVjdGlvbihjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config = DetrConfig(use_pretrained_backbone=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DetrForObjectDetection(config)`}}),et=new R({}),ot=new Ja({props:{pipeline:"object-detection"}}),rt=new R({}),at=new x({props:{name:"class transformers.models.detr.modeling_detr.DetrModelOutput",anchor:"transformers.models.detr.modeling_detr.DetrModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"intermediate_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrModelOutput.intermediate_hidden_states",description:`<strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"intermediate_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L94"}}),it=new x({props:{name:"class transformers.models.detr.modeling_detr.DetrObjectDetectionOutput",anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"loss_dict",val:": typing.Optional[typing.Dict] = None"},{name:"logits",val:": FloatTensor = None"},{name:"pred_boxes",val:": FloatTensor = None"},{name:"auxiliary_outputs",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) &#x2014;
Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.`,name:"loss"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.loss_dict",description:`<strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the individual losses. Useful for logging.`,name:"loss_dict"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) &#x2014;
Classification logits (including no-object) for all queries.`,name:"logits"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.pred_boxes",description:`<strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) &#x2014;
Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection">post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.`,name:"pred_boxes"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.auxiliary_outputs",description:`<strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) &#x2014;
Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.`,name:"auxiliary_outputs"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrObjectDetectionOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L134"}}),dt=new x({props:{name:"class transformers.models.detr.modeling_detr.DetrSegmentationOutput",anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"loss_dict",val:": typing.Optional[typing.Dict] = None"},{name:"logits",val:": FloatTensor = None"},{name:"pred_boxes",val:": FloatTensor = None"},{name:"pred_masks",val:": FloatTensor = None"},{name:"auxiliary_outputs",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) &#x2014;
Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.`,name:"loss"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.loss_dict",description:`<strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the individual losses. Useful for logging.`,name:"loss_dict"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) &#x2014;
Classification logits (including no-object) for all queries.`,name:"logits"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.pred_boxes",description:`<strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) &#x2014;
Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection">post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.`,name:"pred_boxes"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.pred_masks",description:`<strong>pred_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height/4, width/4)</code>) &#x2014;
Segmentation masks logits for all queries. See also
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_instance_segmentation">post_process_instance_segmentation()</a>
<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to evaluate semantic, instance and panoptic
segmentation masks respectively.`,name:"pred_masks"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.auxiliary_outputs",description:`<strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) &#x2014;
Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.`,name:"auxiliary_outputs"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.models.detr.modeling_detr.DetrSegmentationOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L197"}}),ct=new R({}),lt=new x({props:{name:"class transformers.DetrConfig",anchor:"transformers.DetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 100"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <code>AutoBackbone</code>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.DetrConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrModel">DetrModel</a> can
detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.DetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.DetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.DetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.DetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.DetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.DetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.DetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.DetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.DetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.DetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.DetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.DetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.DetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.DetrConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.DetrConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.DetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.DetrConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.DetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of convolutional backbone to use in case <code>use_timm_backbone</code> = <code>True</code>. Supports any convolutional
backbone from the timm package. For a list of all available models, see <a href="https://rwightman.github.io/pytorch-image-models/#load-a-pretrained-model" rel="nofollow">this
page</a>.`,name:"backbone"},{anchor:"transformers.DetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone. Only supported when <code>use_timm_backbone</code> = <code>True</code>.`,name:"use_pretrained_backbone"},{anchor:"transformers.DetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.DetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.DetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.DetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.DetrConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.DetrConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.DetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.DetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.DetrConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/configuration_detr.py#L36"}}),re=new Kn({props:{anchor:"transformers.DetrConfig.example",$$slots:{default:[Ea]},$$scope:{ctx:k}}}),mt=new x({props:{name:"from_backbone_config",anchor:"transformers.DetrConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/configuration_detr.py#L238",returnDescription:`
<p>An instance of a configuration object</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a></p>
`}}),pt=new R({}),ht=new x({props:{name:"class transformers.DetrImageProcessor",anchor:"transformers.DetrImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.detr.image_processing_detr.AnnotionFormat] = <AnnotionFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.DetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s <code>(height, width)</code> dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.DetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.DetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image to the largest image in a batch and create a pixel mask. Can be
overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L746"}}),gt=new x({props:{name:"preprocess",anchor:"transformers.DetrImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.detr.image_processing_detr.AnnotionFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.DetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.DetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.DetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.DetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.DetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.DetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.DetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.DetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.DetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotionFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.DetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.DetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1074"}}),ut=new x({props:{name:"post_process_object_detection",anchor:"transformers.DetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1591",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),ft=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DetrImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple[int, int]] = None"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
A list of tuples (<code>Tuple[int, int]</code>) containing the target size (height, width) of each image in the
batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1644",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),_t=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DetrImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE)
format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1692",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),bt=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
The outputs from <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>.`,name:"outputs"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.DetrImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1776",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized to
the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),yt=new R({}),vt=new x({props:{name:"class transformers.DetrFeatureExtractor",anchor:"transformers.DetrFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/feature_extraction_detr.py#L26"}}),Tt=new x({props:{name:"__call__",anchor:"transformers.DetrFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/image_processing_utils.py#L544"}}),wt=new x({props:{name:"post_process_object_detection",anchor:"transformers.DetrFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1591",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Dt=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DetrFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple[int, int]] = None"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
A list of tuples (<code>Tuple[int, int]</code>) containing the target size (height, width) of each image in the
batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1644",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),xt=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DetrFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE)
format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1692",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Mt=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>) &#x2014;
The outputs from <a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a>.`,name:"outputs"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.DetrFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/image_processing_detr.py#L1776",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized to
the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),jt=new R({}),Ft=new x({props:{name:"class transformers.DetrModel",anchor:"transformers.DetrModel",parameters:[{name:"config",val:": DetrConfig"}],parametersDescription:[{anchor:"transformers.DetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L1325"}}),kt=new x({props:{name:"forward",anchor:"transformers.DetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L1359",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrModelOutput"
>transformers.models.detr.modeling_detr.DetrModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrModelOutput"
>transformers.models.detr.modeling_detr.DetrModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new ar({props:{$$slots:{default:[Oa]},$$scope:{ctx:k}}}),Te=new Kn({props:{anchor:"transformers.DetrModel.forward.example",$$slots:{default:[Ua]},$$scope:{ctx:k}}}),$t=new R({}),Ct=new x({props:{name:"class transformers.DetrForObjectDetection",anchor:"transformers.DetrForObjectDetection",parameters:[{name:"config",val:": DetrConfig"}],parametersDescription:[{anchor:"transformers.DetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L1493"}}),zt=new x({props:{name:"forward",anchor:"transformers.DetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L1519",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrObjectDetectionOutput"
>transformers.models.detr.modeling_detr.DetrObjectDetectionOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrObjectDetectionOutput"
>transformers.models.detr.modeling_detr.DetrObjectDetectionOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new ar({props:{$$slots:{default:[qa]},$$scope:{ctx:k}}}),xe=new Kn({props:{anchor:"transformers.DetrForObjectDetection.forward.example",$$slots:{default:[Pa]},$$scope:{ctx:k}}}),It=new R({}),Nt=new x({props:{name:"class transformers.DetrForSegmentation",anchor:"transformers.DetrForSegmentation",parameters:[{name:"config",val:": DetrConfig"}],parametersDescription:[{anchor:"transformers.DetrForSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L1667"}}),Jt=new x({props:{name:"forward",anchor:"transformers.DetrForSegmentation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DetrForSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DetrForSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DetrForSegmentation.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DetrForSegmentation.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DetrForSegmentation.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DetrForSegmentation.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DetrForSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DetrForSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DetrForSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DetrForSegmentation.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss, DICE/F-1 loss and Focal loss. List of dicts, each
dictionary containing at least the following 3 keys: &#x2018;class_labels&#x2019;, &#x2018;boxes&#x2019; and &#x2018;masks&#x2019; (the class labels,
bounding boxes and segmentation masks of an image in the batch respectively). The class labels themselves
should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code>, the boxes a
<code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code> and the masks a
<code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, height, width)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/detr/modeling_detr.py#L1689",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrSegmentationOutput"
>transformers.models.detr.modeling_detr.DetrSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrConfig"
>DetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>pred_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height/4, width/4)</code>) — Segmentation masks logits for all queries. See also
<a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_semantic_segmentation"
>post_process_semantic_segmentation()</a> or
<a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_instance_segmentation"
>post_process_instance_segmentation()</a>
<a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.DetrFeatureExtractor.post_process_panoptic_segmentation"
>post_process_panoptic_segmentation()</a> to evaluate semantic, instance and panoptic
segmentation masks respectively.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/detr#transformers.models.detr.modeling_detr.DetrSegmentationOutput"
>transformers.models.detr.modeling_detr.DetrSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),je=new ar({props:{$$slots:{default:[La]},$$scope:{ctx:k}}}),Fe=new Kn({props:{anchor:"transformers.DetrForSegmentation.forward.example",$$slots:{default:[Za]},$$scope:{ctx:k}}}),{c(){m=n("meta"),D=a(),v=n("p"),T=a(),w=n("h1"),c=n("a"),M=n("span"),g(ze.$$.fragment),es=a(),Lt=n("span"),Lt.textContent=ir,Lo=a(),S=n("h2"),te=n("a"),jo=n("span"),g(Ie.$$.fragment),ts=a(),Zt=n("span"),Zt.textContent=dr,Zo=a(),Ne=n("p"),Ne.innerHTML=cr,Ro=a(),Je=n("p"),Je.textContent=lr,So=a(),Ee=n("p"),Ee.innerHTML=mr,Wo=a(),Oe=n("p"),Oe.innerHTML=pr,Ho=a(),Ue=n("p"),Ue.innerHTML=hr,Bo=a(),qe=n("p"),qe.innerHTML=gr,Ao=a(),Pe=n("p"),Pe.innerHTML=ur,Go=a(),Le=n("p"),Le.innerHTML=fr,Vo=a(),Ze=n("p"),Ze.innerHTML=_r,Xo=a(),Re=n("p"),Re.textContent=br,Yo=a(),Se=n("ul"),Se.innerHTML=yr,Qo=a(),We=n("p"),We.textContent=vr,Ko=a(),He=n("p"),He.textContent=Tr,en=a(),g(Be.$$.fragment),tn=a(),Ae=n("p"),Ae.textContent=wr,on=a(),g(Ge.$$.fragment),nn=a(),Ve=n("p"),Ve.textContent=Dr,sn=a(),g(Xe.$$.fragment),rn=a(),Ye=n("p"),Ye.textContent=xr,an=a(),Qe=n("table"),Qe.innerHTML=Mr,dn=a(),Ke=n("p"),Ke.innerHTML=jr,cn=a(),W=n("h2"),oe=n("a"),Fo=n("span"),g(et.$$.fragment),os=a(),Rt=n("span"),Rt.textContent=Fr,ln=a(),tt=n("p"),tt.textContent=kr,mn=a(),g(ot.$$.fragment),pn=a(),nt=n("ul"),nt.innerHTML=$r,hn=a(),st=n("p"),st.textContent=Cr,gn=a(),H=n("h2"),ne=n("a"),ko=n("span"),g(rt.$$.fragment),ns=a(),St=n("span"),St.textContent=zr,un=a(),B=n("div"),g(at.$$.fragment),ss=a(),Wt=n("p"),Wt.textContent=Ir,fn=a(),A=n("div"),g(it.$$.fragment),rs=a(),Ht=n("p"),Ht.innerHTML=Nr,_n=a(),G=n("div"),g(dt.$$.fragment),as=a(),Bt=n("p"),Bt.innerHTML=Jr,bn=a(),V=n("h2"),se=n("a"),$o=n("span"),g(ct.$$.fragment),is=a(),At=n("span"),At.textContent=Er,yn=a(),$=n("div"),g(lt.$$.fragment),ds=a(),Gt=n("p"),Gt.innerHTML=Or,cs=a(),Vt=n("p"),Vt.innerHTML=Ur,ls=a(),g(re.$$.fragment),ms=a(),ae=n("div"),g(mt.$$.fragment),ps=a(),Xt=n("p"),Xt.innerHTML=qr,vn=a(),X=n("h2"),ie=n("a"),Co=n("span"),g(pt.$$.fragment),hs=a(),Yt=n("span"),Yt.textContent=Pr,Tn=a(),j=n("div"),g(ht.$$.fragment),gs=a(),Qt=n("p"),Qt.textContent=Lr,us=a(),de=n("div"),g(gt.$$.fragment),fs=a(),Kt=n("p"),Kt.textContent=Zr,_s=a(),ce=n("div"),g(ut.$$.fragment),bs=a(),eo=n("p"),eo.innerHTML=Rr,ys=a(),le=n("div"),g(ft.$$.fragment),vs=a(),to=n("p"),to.innerHTML=Sr,Ts=a(),me=n("div"),g(_t.$$.fragment),ws=a(),oo=n("p"),oo.innerHTML=Wr,Ds=a(),pe=n("div"),g(bt.$$.fragment),xs=a(),no=n("p"),no.innerHTML=Hr,wn=a(),Y=n("h2"),he=n("a"),zo=n("span"),g(yt.$$.fragment),Ms=a(),so=n("span"),so.textContent=Br,Dn=a(),F=n("div"),g(vt.$$.fragment),js=a(),ge=n("div"),g(Tt.$$.fragment),Fs=a(),ro=n("p"),ro.textContent=Ar,ks=a(),ue=n("div"),g(wt.$$.fragment),$s=a(),ao=n("p"),ao.innerHTML=Gr,Cs=a(),fe=n("div"),g(Dt.$$.fragment),zs=a(),io=n("p"),io.innerHTML=Vr,Is=a(),_e=n("div"),g(xt.$$.fragment),Ns=a(),co=n("p"),co.innerHTML=Xr,Js=a(),be=n("div"),g(Mt.$$.fragment),Es=a(),lo=n("p"),lo.innerHTML=Yr,xn=a(),Q=n("h2"),ye=n("a"),Io=n("span"),g(jt.$$.fragment),Os=a(),mo=n("span"),mo.textContent=Qr,Mn=a(),C=n("div"),g(Ft.$$.fragment),Us=a(),po=n("p"),po.textContent=Kr,qs=a(),ho=n("p"),ho.innerHTML=ea,Ps=a(),go=n("p"),go.innerHTML=ta,Ls=a(),J=n("div"),g(kt.$$.fragment),Zs=a(),uo=n("p"),uo.innerHTML=oa,Rs=a(),g(ve.$$.fragment),Ss=a(),g(Te.$$.fragment),jn=a(),K=n("h2"),we=n("a"),No=n("span"),g($t.$$.fragment),Ws=a(),fo=n("span"),fo.textContent=na,Fn=a(),z=n("div"),g(Ct.$$.fragment),Hs=a(),_o=n("p"),_o.textContent=sa,Bs=a(),bo=n("p"),bo.innerHTML=ra,As=a(),yo=n("p"),yo.innerHTML=aa,Gs=a(),E=n("div"),g(zt.$$.fragment),Vs=a(),vo=n("p"),vo.innerHTML=ia,Xs=a(),g(De.$$.fragment),Ys=a(),g(xe.$$.fragment),kn=a(),ee=n("h2"),Me=n("a"),Jo=n("span"),g(It.$$.fragment),Qs=a(),To=n("span"),To.textContent=da,$n=a(),I=n("div"),g(Nt.$$.fragment),Ks=a(),wo=n("p"),wo.textContent=ca,er=a(),Do=n("p"),Do.innerHTML=la,tr=a(),xo=n("p"),xo.innerHTML=ma,or=a(),O=n("div"),g(Jt.$$.fragment),nr=a(),Mo=n("p"),Mo.innerHTML=pa,sr=a(),g(je.$$.fragment),rr=a(),g(Fe.$$.fragment),Cn=a(),Eo=n("p"),this.h()},l(e){const r=Na("svelte-1phssyn",document.head);m=s(r,"META",{name:!0,content:!0}),r.forEach(t),D=i(e),v=s(e,"P",{}),h(v).forEach(t),T=i(e),w=s(e,"H1",{class:!0});var Et=h(w);c=s(Et,"A",{id:!0,class:!0,href:!0});var Oo=h(c);M=s(Oo,"SPAN",{});var Uo=h(M);u(ze.$$.fragment,Uo),Uo.forEach(t),Oo.forEach(t),es=i(Et),Lt=s(Et,"SPAN",{"data-svelte-h":!0}),l(Lt)!=="svelte-8bm23i"&&(Lt.textContent=ir),Et.forEach(t),Lo=i(e),S=s(e,"H2",{class:!0});var Ot=h(S);te=s(Ot,"A",{id:!0,class:!0,href:!0});var qo=h(te);jo=s(qo,"SPAN",{});var Po=h(jo);u(Ie.$$.fragment,Po),Po.forEach(t),qo.forEach(t),ts=i(Ot),Zt=s(Ot,"SPAN",{"data-svelte-h":!0}),l(Zt)!=="svelte-1jsw1pg"&&(Zt.textContent=dr),Ot.forEach(t),Zo=i(e),Ne=s(e,"P",{"data-svelte-h":!0}),l(Ne)!=="svelte-1619prt"&&(Ne.innerHTML=cr),Ro=i(e),Je=s(e,"P",{"data-svelte-h":!0}),l(Je)!=="svelte-vfdo9a"&&(Je.textContent=lr),So=i(e),Ee=s(e,"P",{"data-svelte-h":!0}),l(Ee)!=="svelte-s87elr"&&(Ee.innerHTML=mr),Wo=i(e),Oe=s(e,"P",{"data-svelte-h":!0}),l(Oe)!=="svelte-1gw5wuz"&&(Oe.innerHTML=pr),Ho=i(e),Ue=s(e,"P",{"data-svelte-h":!0}),l(Ue)!=="svelte-1fg2tuy"&&(Ue.innerHTML=hr),Bo=i(e),qe=s(e,"P",{"data-svelte-h":!0}),l(qe)!=="svelte-x01cd0"&&(qe.innerHTML=gr),Ao=i(e),Pe=s(e,"P",{"data-svelte-h":!0}),l(Pe)!=="svelte-i2avyi"&&(Pe.innerHTML=ur),Go=i(e),Le=s(e,"P",{"data-svelte-h":!0}),l(Le)!=="svelte-351ubi"&&(Le.innerHTML=fr),Vo=i(e),Ze=s(e,"P",{"data-svelte-h":!0}),l(Ze)!=="svelte-1kew707"&&(Ze.innerHTML=_r),Xo=i(e),Re=s(e,"P",{"data-svelte-h":!0}),l(Re)!=="svelte-axv494"&&(Re.textContent=br),Yo=i(e),Se=s(e,"UL",{"data-svelte-h":!0}),l(Se)!=="svelte-1c8xg1o"&&(Se.innerHTML=yr),Qo=i(e),We=s(e,"P",{"data-svelte-h":!0}),l(We)!=="svelte-5tif3l"&&(We.textContent=vr),Ko=i(e),He=s(e,"P",{"data-svelte-h":!0}),l(He)!=="svelte-ixg096"&&(He.textContent=Tr),en=i(e),u(Be.$$.fragment,e),tn=i(e),Ae=s(e,"P",{"data-svelte-h":!0}),l(Ae)!=="svelte-14rhv4g"&&(Ae.textContent=wr),on=i(e),u(Ge.$$.fragment,e),nn=i(e),Ve=s(e,"P",{"data-svelte-h":!0}),l(Ve)!=="svelte-1hfzzjq"&&(Ve.textContent=Dr),sn=i(e),u(Xe.$$.fragment,e),rn=i(e),Ye=s(e,"P",{"data-svelte-h":!0}),l(Ye)!=="svelte-1e3p89m"&&(Ye.textContent=xr),an=i(e),Qe=s(e,"TABLE",{"data-svelte-h":!0}),l(Qe)!=="svelte-1f6byrp"&&(Qe.innerHTML=Mr),dn=i(e),Ke=s(e,"P",{"data-svelte-h":!0}),l(Ke)!=="svelte-kz60r2"&&(Ke.innerHTML=jr),cn=i(e),W=s(e,"H2",{class:!0});var Ut=h(W);oe=s(Ut,"A",{id:!0,class:!0,href:!0});var ha=h(oe);Fo=s(ha,"SPAN",{});var ga=h(Fo);u(et.$$.fragment,ga),ga.forEach(t),ha.forEach(t),os=i(Ut),Rt=s(Ut,"SPAN",{"data-svelte-h":!0}),l(Rt)!=="svelte-w4zzv6"&&(Rt.textContent=Fr),Ut.forEach(t),ln=i(e),tt=s(e,"P",{"data-svelte-h":!0}),l(tt)!=="svelte-5jc6k6"&&(tt.textContent=kr),mn=i(e),u(ot.$$.fragment,e),pn=i(e),nt=s(e,"UL",{"data-svelte-h":!0}),l(nt)!=="svelte-1oxiq2t"&&(nt.innerHTML=$r),hn=i(e),st=s(e,"P",{"data-svelte-h":!0}),l(st)!=="svelte-1xesile"&&(st.textContent=Cr),gn=i(e),H=s(e,"H2",{class:!0});var In=h(H);ne=s(In,"A",{id:!0,class:!0,href:!0});var ua=h(ne);ko=s(ua,"SPAN",{});var fa=h(ko);u(rt.$$.fragment,fa),fa.forEach(t),ua.forEach(t),ns=i(In),St=s(In,"SPAN",{"data-svelte-h":!0}),l(St)!=="svelte-1xz2fi2"&&(St.textContent=zr),In.forEach(t),un=i(e),B=s(e,"DIV",{class:!0});var Nn=h(B);u(at.$$.fragment,Nn),ss=i(Nn),Wt=s(Nn,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1ya2yj5"&&(Wt.textContent=Ir),Nn.forEach(t),fn=i(e),A=s(e,"DIV",{class:!0});var Jn=h(A);u(it.$$.fragment,Jn),rs=i(Jn),Ht=s(Jn,"P",{"data-svelte-h":!0}),l(Ht)!=="svelte-1abt6ys"&&(Ht.innerHTML=Nr),Jn.forEach(t),_n=i(e),G=s(e,"DIV",{class:!0});var En=h(G);u(dt.$$.fragment,En),as=i(En),Bt=s(En,"P",{"data-svelte-h":!0}),l(Bt)!=="svelte-1ex0cxg"&&(Bt.innerHTML=Jr),En.forEach(t),bn=i(e),V=s(e,"H2",{class:!0});var On=h(V);se=s(On,"A",{id:!0,class:!0,href:!0});var _a=h(se);$o=s(_a,"SPAN",{});var ba=h($o);u(ct.$$.fragment,ba),ba.forEach(t),_a.forEach(t),is=i(On),At=s(On,"SPAN",{"data-svelte-h":!0}),l(At)!=="svelte-y53hvk"&&(At.textContent=Er),On.forEach(t),yn=i(e),$=s(e,"DIV",{class:!0});var q=h($);u(lt.$$.fragment,q),ds=i(q),Gt=s(q,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-2tobfw"&&(Gt.innerHTML=Or),cs=i(q),Vt=s(q,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-cfh5wl"&&(Vt.innerHTML=Ur),ls=i(q),u(re.$$.fragment,q),ms=i(q),ae=s(q,"DIV",{class:!0});var Un=h(ae);u(mt.$$.fragment,Un),ps=i(Un),Xt=s(Un,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-1w1aq61"&&(Xt.innerHTML=qr),Un.forEach(t),q.forEach(t),vn=i(e),X=s(e,"H2",{class:!0});var qn=h(X);ie=s(qn,"A",{id:!0,class:!0,href:!0});var ya=h(ie);Co=s(ya,"SPAN",{});var va=h(Co);u(pt.$$.fragment,va),va.forEach(t),ya.forEach(t),hs=i(qn),Yt=s(qn,"SPAN",{"data-svelte-h":!0}),l(Yt)!=="svelte-1k6awzb"&&(Yt.textContent=Pr),qn.forEach(t),Tn=i(e),j=s(e,"DIV",{class:!0});var N=h(j);u(ht.$$.fragment,N),gs=i(N),Qt=s(N,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-19j0nu1"&&(Qt.textContent=Lr),us=i(N),de=s(N,"DIV",{class:!0});var Pn=h(de);u(gt.$$.fragment,Pn),fs=i(Pn),Kt=s(Pn,"P",{"data-svelte-h":!0}),l(Kt)!=="svelte-jgz2ra"&&(Kt.textContent=Zr),Pn.forEach(t),_s=i(N),ce=s(N,"DIV",{class:!0});var Ln=h(ce);u(ut.$$.fragment,Ln),bs=i(Ln),eo=s(Ln,"P",{"data-svelte-h":!0}),l(eo)!=="svelte-1yho898"&&(eo.innerHTML=Rr),Ln.forEach(t),ys=i(N),le=s(N,"DIV",{class:!0});var Zn=h(le);u(ft.$$.fragment,Zn),vs=i(Zn),to=s(Zn,"P",{"data-svelte-h":!0}),l(to)!=="svelte-w5t2kh"&&(to.innerHTML=Sr),Zn.forEach(t),Ts=i(N),me=s(N,"DIV",{class:!0});var Rn=h(me);u(_t.$$.fragment,Rn),ws=i(Rn),oo=s(Rn,"P",{"data-svelte-h":!0}),l(oo)!=="svelte-1nretpt"&&(oo.innerHTML=Wr),Rn.forEach(t),Ds=i(N),pe=s(N,"DIV",{class:!0});var Sn=h(pe);u(bt.$$.fragment,Sn),xs=i(Sn),no=s(Sn,"P",{"data-svelte-h":!0}),l(no)!=="svelte-3nsd3f"&&(no.innerHTML=Hr),Sn.forEach(t),N.forEach(t),wn=i(e),Y=s(e,"H2",{class:!0});var Wn=h(Y);he=s(Wn,"A",{id:!0,class:!0,href:!0});var Ta=h(he);zo=s(Ta,"SPAN",{});var wa=h(zo);u(yt.$$.fragment,wa),wa.forEach(t),Ta.forEach(t),Ms=i(Wn),so=s(Wn,"SPAN",{"data-svelte-h":!0}),l(so)!=="svelte-17jb4qs"&&(so.textContent=Br),Wn.forEach(t),Dn=i(e),F=s(e,"DIV",{class:!0});var U=h(F);u(vt.$$.fragment,U),js=i(U),ge=s(U,"DIV",{class:!0});var Hn=h(ge);u(Tt.$$.fragment,Hn),Fs=i(Hn),ro=s(Hn,"P",{"data-svelte-h":!0}),l(ro)!=="svelte-khengj"&&(ro.textContent=Ar),Hn.forEach(t),ks=i(U),ue=s(U,"DIV",{class:!0});var Bn=h(ue);u(wt.$$.fragment,Bn),$s=i(Bn),ao=s(Bn,"P",{"data-svelte-h":!0}),l(ao)!=="svelte-1yho898"&&(ao.innerHTML=Gr),Bn.forEach(t),Cs=i(U),fe=s(U,"DIV",{class:!0});var An=h(fe);u(Dt.$$.fragment,An),zs=i(An),io=s(An,"P",{"data-svelte-h":!0}),l(io)!=="svelte-w5t2kh"&&(io.innerHTML=Vr),An.forEach(t),Is=i(U),_e=s(U,"DIV",{class:!0});var Gn=h(_e);u(xt.$$.fragment,Gn),Ns=i(Gn),co=s(Gn,"P",{"data-svelte-h":!0}),l(co)!=="svelte-1nretpt"&&(co.innerHTML=Xr),Gn.forEach(t),Js=i(U),be=s(U,"DIV",{class:!0});var Vn=h(be);u(Mt.$$.fragment,Vn),Es=i(Vn),lo=s(Vn,"P",{"data-svelte-h":!0}),l(lo)!=="svelte-3nsd3f"&&(lo.innerHTML=Yr),Vn.forEach(t),U.forEach(t),xn=i(e),Q=s(e,"H2",{class:!0});var Xn=h(Q);ye=s(Xn,"A",{id:!0,class:!0,href:!0});var Da=h(ye);Io=s(Da,"SPAN",{});var xa=h(Io);u(jt.$$.fragment,xa),xa.forEach(t),Da.forEach(t),Os=i(Xn),mo=s(Xn,"SPAN",{"data-svelte-h":!0}),l(mo)!=="svelte-gk1ryx"&&(mo.textContent=Qr),Xn.forEach(t),Mn=i(e),C=s(e,"DIV",{class:!0});var P=h(C);u(Ft.$$.fragment,P),Us=i(P),po=s(P,"P",{"data-svelte-h":!0}),l(po)!=="svelte-esnh0n"&&(po.textContent=Kr),qs=i(P),ho=s(P,"P",{"data-svelte-h":!0}),l(ho)!=="svelte-ev63c"&&(ho.innerHTML=ea),Ps=i(P),go=s(P,"P",{"data-svelte-h":!0}),l(go)!=="svelte-hswkmf"&&(go.innerHTML=ta),Ls=i(P),J=s(P,"DIV",{class:!0});var ke=h(J);u(kt.$$.fragment,ke),Zs=i(ke),uo=s(ke,"P",{"data-svelte-h":!0}),l(uo)!=="svelte-10mheps"&&(uo.innerHTML=oa),Rs=i(ke),u(ve.$$.fragment,ke),Ss=i(ke),u(Te.$$.fragment,ke),ke.forEach(t),P.forEach(t),jn=i(e),K=s(e,"H2",{class:!0});var Yn=h(K);we=s(Yn,"A",{id:!0,class:!0,href:!0});var Ma=h(we);No=s(Ma,"SPAN",{});var ja=h(No);u($t.$$.fragment,ja),ja.forEach(t),Ma.forEach(t),Ws=i(Yn),fo=s(Yn,"SPAN",{"data-svelte-h":!0}),l(fo)!=="svelte-1asl6rr"&&(fo.textContent=na),Yn.forEach(t),Fn=i(e),z=s(e,"DIV",{class:!0});var L=h(z);u(Ct.$$.fragment,L),Hs=i(L),_o=s(L,"P",{"data-svelte-h":!0}),l(_o)!=="svelte-dw6bi4"&&(_o.textContent=sa),Bs=i(L),bo=s(L,"P",{"data-svelte-h":!0}),l(bo)!=="svelte-ev63c"&&(bo.innerHTML=ra),As=i(L),yo=s(L,"P",{"data-svelte-h":!0}),l(yo)!=="svelte-hswkmf"&&(yo.innerHTML=aa),Gs=i(L),E=s(L,"DIV",{class:!0});var $e=h(E);u(zt.$$.fragment,$e),Vs=i($e),vo=s($e,"P",{"data-svelte-h":!0}),l(vo)!=="svelte-1on4l9k"&&(vo.innerHTML=ia),Xs=i($e),u(De.$$.fragment,$e),Ys=i($e),u(xe.$$.fragment,$e),$e.forEach(t),L.forEach(t),kn=i(e),ee=s(e,"H2",{class:!0});var Qn=h(ee);Me=s(Qn,"A",{id:!0,class:!0,href:!0});var Fa=h(Me);Jo=s(Fa,"SPAN",{});var ka=h(Jo);u(It.$$.fragment,ka),ka.forEach(t),Fa.forEach(t),Qs=i(Qn),To=s(Qn,"SPAN",{"data-svelte-h":!0}),l(To)!=="svelte-1mkzi19"&&(To.textContent=da),Qn.forEach(t),$n=i(e),I=s(e,"DIV",{class:!0});var Z=h(I);u(Nt.$$.fragment,Z),Ks=i(Z),wo=s(Z,"P",{"data-svelte-h":!0}),l(wo)!=="svelte-1yivh9f"&&(wo.textContent=ca),er=i(Z),Do=s(Z,"P",{"data-svelte-h":!0}),l(Do)!=="svelte-ev63c"&&(Do.innerHTML=la),tr=i(Z),xo=s(Z,"P",{"data-svelte-h":!0}),l(xo)!=="svelte-hswkmf"&&(xo.innerHTML=ma),or=i(Z),O=s(Z,"DIV",{class:!0});var Ce=h(O);u(Jt.$$.fragment,Ce),nr=i(Ce),Mo=s(Ce,"P",{"data-svelte-h":!0}),l(Mo)!=="svelte-147i6eo"&&(Mo.innerHTML=pa),sr=i(Ce),u(je.$$.fragment,Ce),rr=i(Ce),u(Fe.$$.fragment,Ce),Ce.forEach(t),Z.forEach(t),Cn=i(e),Eo=s(e,"P",{}),h(Eo).forEach(t),this.h()},h(){p(m,"name","hf:doc:metadata"),p(m,"content",JSON.stringify(Sa)),p(c,"id","detr"),p(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(c,"href","#detr"),p(w,"class","relative group"),p(te,"id","overview"),p(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(te,"href","#overview"),p(S,"class","relative group"),p(oe,"id","resources"),p(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(oe,"href","#resources"),p(W,"class","relative group"),p(ne,"id","transformers.models.detr.modeling_detr.DetrModelOutput"),p(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ne,"href","#transformers.models.detr.modeling_detr.DetrModelOutput"),p(H,"class","relative group"),p(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(se,"id","transformers.DetrConfig"),p(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(se,"href","#transformers.DetrConfig"),p(V,"class","relative group"),p(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ie,"id","transformers.DetrImageProcessor"),p(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ie,"href","#transformers.DetrImageProcessor"),p(X,"class","relative group"),p(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(he,"id","transformers.DetrFeatureExtractor"),p(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(he,"href","#transformers.DetrFeatureExtractor"),p(Y,"class","relative group"),p(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ye,"id","transformers.DetrModel"),p(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ye,"href","#transformers.DetrModel"),p(Q,"class","relative group"),p(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(we,"id","transformers.DetrForObjectDetection"),p(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(we,"href","#transformers.DetrForObjectDetection"),p(K,"class","relative group"),p(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Me,"id","transformers.DetrForSegmentation"),p(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Me,"href","#transformers.DetrForSegmentation"),p(ee,"class","relative group"),p(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){o(document.head,m),d(e,D,r),d(e,v,r),d(e,T,r),d(e,w,r),o(w,c),o(c,M),f(ze,M,null),o(w,es),o(w,Lt),d(e,Lo,r),d(e,S,r),o(S,te),o(te,jo),f(Ie,jo,null),o(S,ts),o(S,Zt),d(e,Zo,r),d(e,Ne,r),d(e,Ro,r),d(e,Je,r),d(e,So,r),d(e,Ee,r),d(e,Wo,r),d(e,Oe,r),d(e,Ho,r),d(e,Ue,r),d(e,Bo,r),d(e,qe,r),d(e,Ao,r),d(e,Pe,r),d(e,Go,r),d(e,Le,r),d(e,Vo,r),d(e,Ze,r),d(e,Xo,r),d(e,Re,r),d(e,Yo,r),d(e,Se,r),d(e,Qo,r),d(e,We,r),d(e,Ko,r),d(e,He,r),d(e,en,r),f(Be,e,r),d(e,tn,r),d(e,Ae,r),d(e,on,r),f(Ge,e,r),d(e,nn,r),d(e,Ve,r),d(e,sn,r),f(Xe,e,r),d(e,rn,r),d(e,Ye,r),d(e,an,r),d(e,Qe,r),d(e,dn,r),d(e,Ke,r),d(e,cn,r),d(e,W,r),o(W,oe),o(oe,Fo),f(et,Fo,null),o(W,os),o(W,Rt),d(e,ln,r),d(e,tt,r),d(e,mn,r),f(ot,e,r),d(e,pn,r),d(e,nt,r),d(e,hn,r),d(e,st,r),d(e,gn,r),d(e,H,r),o(H,ne),o(ne,ko),f(rt,ko,null),o(H,ns),o(H,St),d(e,un,r),d(e,B,r),f(at,B,null),o(B,ss),o(B,Wt),d(e,fn,r),d(e,A,r),f(it,A,null),o(A,rs),o(A,Ht),d(e,_n,r),d(e,G,r),f(dt,G,null),o(G,as),o(G,Bt),d(e,bn,r),d(e,V,r),o(V,se),o(se,$o),f(ct,$o,null),o(V,is),o(V,At),d(e,yn,r),d(e,$,r),f(lt,$,null),o($,ds),o($,Gt),o($,cs),o($,Vt),o($,ls),f(re,$,null),o($,ms),o($,ae),f(mt,ae,null),o(ae,ps),o(ae,Xt),d(e,vn,r),d(e,X,r),o(X,ie),o(ie,Co),f(pt,Co,null),o(X,hs),o(X,Yt),d(e,Tn,r),d(e,j,r),f(ht,j,null),o(j,gs),o(j,Qt),o(j,us),o(j,de),f(gt,de,null),o(de,fs),o(de,Kt),o(j,_s),o(j,ce),f(ut,ce,null),o(ce,bs),o(ce,eo),o(j,ys),o(j,le),f(ft,le,null),o(le,vs),o(le,to),o(j,Ts),o(j,me),f(_t,me,null),o(me,ws),o(me,oo),o(j,Ds),o(j,pe),f(bt,pe,null),o(pe,xs),o(pe,no),d(e,wn,r),d(e,Y,r),o(Y,he),o(he,zo),f(yt,zo,null),o(Y,Ms),o(Y,so),d(e,Dn,r),d(e,F,r),f(vt,F,null),o(F,js),o(F,ge),f(Tt,ge,null),o(ge,Fs),o(ge,ro),o(F,ks),o(F,ue),f(wt,ue,null),o(ue,$s),o(ue,ao),o(F,Cs),o(F,fe),f(Dt,fe,null),o(fe,zs),o(fe,io),o(F,Is),o(F,_e),f(xt,_e,null),o(_e,Ns),o(_e,co),o(F,Js),o(F,be),f(Mt,be,null),o(be,Es),o(be,lo),d(e,xn,r),d(e,Q,r),o(Q,ye),o(ye,Io),f(jt,Io,null),o(Q,Os),o(Q,mo),d(e,Mn,r),d(e,C,r),f(Ft,C,null),o(C,Us),o(C,po),o(C,qs),o(C,ho),o(C,Ps),o(C,go),o(C,Ls),o(C,J),f(kt,J,null),o(J,Zs),o(J,uo),o(J,Rs),f(ve,J,null),o(J,Ss),f(Te,J,null),d(e,jn,r),d(e,K,r),o(K,we),o(we,No),f($t,No,null),o(K,Ws),o(K,fo),d(e,Fn,r),d(e,z,r),f(Ct,z,null),o(z,Hs),o(z,_o),o(z,Bs),o(z,bo),o(z,As),o(z,yo),o(z,Gs),o(z,E),f(zt,E,null),o(E,Vs),o(E,vo),o(E,Xs),f(De,E,null),o(E,Ys),f(xe,E,null),d(e,kn,r),d(e,ee,r),o(ee,Me),o(Me,Jo),f(It,Jo,null),o(ee,Qs),o(ee,To),d(e,$n,r),d(e,I,r),f(Nt,I,null),o(I,Ks),o(I,wo),o(I,er),o(I,Do),o(I,tr),o(I,xo),o(I,or),o(I,O),f(Jt,O,null),o(O,nr),o(O,Mo),o(O,sr),f(je,O,null),o(O,rr),f(Fe,O,null),d(e,Cn,r),d(e,Eo,r),zn=!0},p(e,[r]){const Et={};r&2&&(Et.$$scope={dirty:r,ctx:e}),re.$set(Et);const Oo={};r&2&&(Oo.$$scope={dirty:r,ctx:e}),ve.$set(Oo);const Uo={};r&2&&(Uo.$$scope={dirty:r,ctx:e}),Te.$set(Uo);const Ot={};r&2&&(Ot.$$scope={dirty:r,ctx:e}),De.$set(Ot);const qo={};r&2&&(qo.$$scope={dirty:r,ctx:e}),xe.$set(qo);const Po={};r&2&&(Po.$$scope={dirty:r,ctx:e}),je.$set(Po);const Ut={};r&2&&(Ut.$$scope={dirty:r,ctx:e}),Fe.$set(Ut)},i(e){zn||(_(ze.$$.fragment,e),_(Ie.$$.fragment,e),_(Be.$$.fragment,e),_(Ge.$$.fragment,e),_(Xe.$$.fragment,e),_(et.$$.fragment,e),_(ot.$$.fragment,e),_(rt.$$.fragment,e),_(at.$$.fragment,e),_(it.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(lt.$$.fragment,e),_(re.$$.fragment,e),_(mt.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(gt.$$.fragment,e),_(ut.$$.fragment,e),_(ft.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(yt.$$.fragment,e),_(vt.$$.fragment,e),_(Tt.$$.fragment,e),_(wt.$$.fragment,e),_(Dt.$$.fragment,e),_(xt.$$.fragment,e),_(Mt.$$.fragment,e),_(jt.$$.fragment,e),_(Ft.$$.fragment,e),_(kt.$$.fragment,e),_(ve.$$.fragment,e),_(Te.$$.fragment,e),_($t.$$.fragment,e),_(Ct.$$.fragment,e),_(zt.$$.fragment,e),_(De.$$.fragment,e),_(xe.$$.fragment,e),_(It.$$.fragment,e),_(Nt.$$.fragment,e),_(Jt.$$.fragment,e),_(je.$$.fragment,e),_(Fe.$$.fragment,e),zn=!0)},o(e){b(ze.$$.fragment,e),b(Ie.$$.fragment,e),b(Be.$$.fragment,e),b(Ge.$$.fragment,e),b(Xe.$$.fragment,e),b(et.$$.fragment,e),b(ot.$$.fragment,e),b(rt.$$.fragment,e),b(at.$$.fragment,e),b(it.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(lt.$$.fragment,e),b(re.$$.fragment,e),b(mt.$$.fragment,e),b(pt.$$.fragment,e),b(ht.$$.fragment,e),b(gt.$$.fragment,e),b(ut.$$.fragment,e),b(ft.$$.fragment,e),b(_t.$$.fragment,e),b(bt.$$.fragment,e),b(yt.$$.fragment,e),b(vt.$$.fragment,e),b(Tt.$$.fragment,e),b(wt.$$.fragment,e),b(Dt.$$.fragment,e),b(xt.$$.fragment,e),b(Mt.$$.fragment,e),b(jt.$$.fragment,e),b(Ft.$$.fragment,e),b(kt.$$.fragment,e),b(ve.$$.fragment,e),b(Te.$$.fragment,e),b($t.$$.fragment,e),b(Ct.$$.fragment,e),b(zt.$$.fragment,e),b(De.$$.fragment,e),b(xe.$$.fragment,e),b(It.$$.fragment,e),b(Nt.$$.fragment,e),b(Jt.$$.fragment,e),b(je.$$.fragment,e),b(Fe.$$.fragment,e),zn=!1},d(e){e&&(t(D),t(v),t(T),t(w),t(Lo),t(S),t(Zo),t(Ne),t(Ro),t(Je),t(So),t(Ee),t(Wo),t(Oe),t(Ho),t(Ue),t(Bo),t(qe),t(Ao),t(Pe),t(Go),t(Le),t(Vo),t(Ze),t(Xo),t(Re),t(Yo),t(Se),t(Qo),t(We),t(Ko),t(He),t(en),t(tn),t(Ae),t(on),t(nn),t(Ve),t(sn),t(rn),t(Ye),t(an),t(Qe),t(dn),t(Ke),t(cn),t(W),t(ln),t(tt),t(mn),t(pn),t(nt),t(hn),t(st),t(gn),t(H),t(un),t(B),t(fn),t(A),t(_n),t(G),t(bn),t(V),t(yn),t($),t(vn),t(X),t(Tn),t(j),t(wn),t(Y),t(Dn),t(F),t(xn),t(Q),t(Mn),t(C),t(jn),t(K),t(Fn),t(z),t(kn),t(ee),t($n),t(I),t(Cn),t(Eo)),t(m),y(ze),y(Ie),y(Be,e),y(Ge,e),y(Xe,e),y(et),y(ot,e),y(rt),y(at),y(it),y(dt),y(ct),y(lt),y(re),y(mt),y(pt),y(ht),y(gt),y(ut),y(ft),y(_t),y(bt),y(yt),y(vt),y(Tt),y(wt),y(Dt),y(xt),y(Mt),y(jt),y(Ft),y(kt),y(ve),y(Te),y($t),y(Ct),y(zt),y(De),y(xe),y(It),y(Nt),y(Jt),y(je),y(Fe)}}}const Sa={local:"detr",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.models.detr.modeling_detr.DetrModelOutput",title:"DETR specific outputs"},{local:"transformers.DetrConfig",title:"DetrConfig"},{local:"transformers.DetrImageProcessor",title:"DetrImageProcessor"},{local:"transformers.DetrFeatureExtractor",title:"DetrFeatureExtractor"},{local:"transformers.DetrModel",title:"DetrModel"},{local:"transformers.DetrForObjectDetection",title:"DetrForObjectDetection"},{local:"transformers.DetrForSegmentation",title:"DetrForSegmentation"}],title:"DETR"};function Wa(k){return Ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends za{constructor(m){super(),Ia(this,m,Wa,Ra,$a,{})}}export{Ka as component};
