import{s as ea,o as la,n as ul}from"../chunks/scheduler.36a0863c.js";import{S as aa,i as na,g as p,s as n,u as i,A as ta,h as r,f as l,c as t,j as J,v as m,y as u,k as b,o as T,a,w as d,d as M,t as j,x as w}from"../chunks/index.d0f7a4c4.js";import{T as rl}from"../chunks/Tip.4c7d7eb1.js";import{I as ll}from"../chunks/IconCopyLink.bc5fad79.js";import{C as h}from"../chunks/CodeBlock.69433f87.js";function pa(A){let o,y="Esta función está disponible actualmente sólo para PyTorch.";return{c(){o=p("p"),o.textContent=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),u(o)!=="svelte-ymsays"&&(o.textContent=y)},m(c,I){a(c,o,I)},p:ul,d(c){c&&l(o)}}}function ra(A){let o,y="Para el entrenamiento multi-GPU, requiere DDP (<code>torch.distributed.launch</code>).";return{c(){o=p("p"),o.innerHTML=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),u(o)!=="svelte-1svbjk8"&&(o.innerHTML=y)},m(c,I){a(c,o,I)},p:ul,d(c){c&&l(o)}}}function ua(A){let o,y="Esta función puede utilizarse con cualquier modelo basado en <code>nn.Module</code>.";return{c(){o=p("p"),o.innerHTML=y},l(c){o=r(c,"P",{"data-svelte-h":!0}),u(o)!=="svelte-16216u7"&&(o.innerHTML=y)},m(c,I){a(c,o,I)},p:ul,d(c){c&&l(o)}}}function oa(A){let o,y,c,I,U,v,Ws,$,al,xs,ol="Debugging",zs,f,G,Xs,g,nl,Ns,cl="Debug de problemas de Network multi-GPU",Fs,x,il="Cuando entrenas o infieres con <code>DistributedDataParallel</code> y varias GPUs, si encuentras problemas de intercomunicación entre procesos y/o nodos, puedes usar el siguiente script para diagnosticar problemas de red.",Ps,N,qs,L,ml="Por ejemplo, para probar cómo interactúan 2 GPUs, haz lo siguiente:",Ks,E,Os,W,dl="Si ambos procesos pueden hablar entre sí y asignar la memoria de la GPU, cada uno imprimirá un status OK.",se,X,Ml="Para más GPUs o nodos, ajusta los argumentos en el script.",ee,Q,jl="Encontrarás muchos más detalles dentro del script de diagnóstico e incluso una receta de cómo ejecutarlo en un entorno SLURM.",le,D,wl="Un nivel adicional de debug es agregar la variable de entorno <code>NCCL_DEBUG=INFO</code> de la siguiente manera:",ae,S,ne,H,bl="Esto mostrará mucha información de debug relacionada con NCCL, que luego puedes buscar online si encuentras que reporta algún problema. O si no estás seguro de cómo interpretar el output, puedes compartir el archivo de log en un Issue.",te,C,V,Qs,Y,tl,Ls,Tl="Detección de Underflow y Overflow",pe,k,re,B,ue,R,oe,z,hl=`Si empiezas a obtener <code>loss=NaN</code> o el modelo muestra algún otro comportamiento anormal debido a <code>inf</code> o <code>nan</code> en
activations o weights hay que descubrir dónde se produce el primer underflow o overflow y qué lo ha provocado. Por suerte
puedes lograrlo fácilmente activando un módulo especial que hará la detección automáticamente.`,ce,F,Jl="Si estás usando <code>Trainer</code>, solo necesitas añadir:",ie,P,me,q,yl="a los argumentos normales de la línea de comandos, o pasar <code>debug=&quot;underflow_overflow&quot;</code> al crear el objeto <code>TrainingArguments</code>.",de,K,Il="Si estás usando tu propio bucle de entrenamiento u otro Trainer puedes lograr lo mismo con:",Me,O,je,ss,Ul=`<code>DebugUnderflowOverflow</code> inserta hooks en el modelo que inmediatamente después de cada forward
testeará las variables de input y output y también los weights del módulo correspondiente. Tan pronto como se detecte <code>inf</code> o
<code>nan</code> se detecta en al menos un elemento de las activations o weights, el programa afirmará e imprimirá un informe
como este (esto fue capturado con <code>google/mt5-small</code> bajo fp16 mixed precision):`,we,es,be,ls,fl="El output del ejemplo se ha recortado en el centro por razones de brevedad.",Te,as,Cl=`La segunda columna muestra el valor del elemento más grande en términos absolutos, por lo que si observas con detenimiento los últimos fotogramas,
los inputs y outputs estaban en el rango de <code>1e4</code>. Así que cuando este entrenamiento se hizo con fp16 mixed precision,
el último paso sufrió overflow (ya que bajo <code>fp16</code> el mayor número antes de <code>inf</code> es <code>64e3</code>). Para evitar overflows en
<code>fp16</code> las activations deben permanecer muy por debajo de <code>1e4</code>, porque <code>1e4 * 1e4 = 1e8</code> por lo que cualquier matrix multiplication con
grandes activations va a llevar a una condición de overflow numérico.`,he,ns,Zl="Al principio del output puedes descubrir en qué número de batch se produjo el problema (aquí <code>Detected inf/nan during batch_number=0</code> significa que el problema se produjo en el primer batch).",Je,ts,Al=`Cada frame del informe comienza declarando la entrada completamente calificada para el módulo correspondiente que este frame está reportando.
Si nos fijamos sólo en este frame:`,ye,ps,Ie,rs,vl=`Aquí, <code>encoder.block.2.layer.1.layer_norm</code> indica que era una layer norm para la primera capa, del segundo
block del encoder. Y la call específica del <code>forward</code> es <code>T5LayerNorm</code>.`,Ue,us,Gl="Veamos los últimos frames de ese informe:",fe,os,Ce,cs,Vl=`El último frame informa para la función <code>Dropout.forward</code> con la primera entrada para el único input y la segunda para el
único output. Puedes ver que fue llamada desde un atributo <code>dropout</code> dentro de la clase <code>DenseReluDense</code>. Podemos ver
que ocurrió durante la primera capa, del segundo block, durante el primer batch. Por último, el mayor absoluto
elementos de input fue <code>6.27e+04</code> y el mismo para el output fue <code>inf</code>.`,Ze,is,kl=`Puedes ver aquí, que <code>T5DenseGatedGeluDense.forward</code> resultó en output activations, cuyo valor máximo absoluto fue
alrededor de 62.7K, que está muy cerca del límite máximo de fp16 de 64K. En el siguiente frame tenemos <code>Dropout</code>, el cual renormaliza
los weights, después de poner a cero algunos de los elementos, lo que empuja el valor máximo absoluto a más de 64K, y obtenemos un
overflow (<code>inf</code>).`,Ae,ms,Bl="Como puedes ver son los frames anteriores los que tenemos que mirar cuando los números empiezan a ser muy grandes para números fp16.",ve,ds,Rl="Combinemos el informe con el código de <code>models/t5/modeling_t5.py</code>:",Ge,Ms,Ve,js,_l="Ahora es fácil ver la call <code>dropout</code>, y también todas las calls anteriores.",ke,ws,$l=`Dado que la detección se produce en un forward hook, estos informes se imprimen inmediatamente después de que cada <code>forward</code>
responda.`,Be,bs,gl=`Volviendo al informe completo, para actuar sobre él y arreglar el problema, tenemos que subir unos cuantos frames donde los números
empezaron a subir y probablemente cambiar al modo <code>fp32</code> aquí, para que los números no sufran overflow cuando se multipliquen
o al sumarlos. Por supuesto, puede haber otras soluciones. Por ejemplo, podríamos desactivar <code>amp</code> temporalmente si está
activado, después de mover el original <code>forward</code> dentro de un helper wrapper, así:`,Re,Ts,_e,hs,xl=`Como el detector automático sólo informa de los inputs y outputs de los frames completos, una vez que sepas dónde buscar, puedes
analizar también las etapas intermedias de una función específica de <code>forward</code>. En este caso, puede utilizar la función
función de ayuda <code>detect_overflow</code> para inyectar el detector donde quieras, por ejemplo:`,$e,Js,ge,ys,Nl=`Puedes ver que hemos añadido 2 de estos y ahora se trackea si <code>inf</code> o <code>nan</code> para <code>forwarded_states</code> fue detectado
en algún punto intermedio.`,xe,Is,Ll=`De hecho, el detector ya informa de esto porque cada una de las llamadas en el ejemplo anterior es un <code>nn.Module</code>, pero
digamos que si tuvieras algunos cálculos directos locales, así es como lo harías.`,Ne,Us,El=`Además, si estás instanciando el debugger en tu propio código, puedes ajustar el número de frames impresos de
su valor por defecto, por ejemplo:`,Le,fs,Ee,Z,_,Ds,Cs,pl,Es,Wl="Rastreo de valores mínimos y máximos absolutos de batches específicos",We,Zs,Xl="La misma clase de debugging se puede utilizar para el rastreo por batches con la función de detección de underflow/overflow desactivada.",Xe,As,Ql=`Digamos que quieres ver los valores mínimos y máximos absolutos de todos los ingredientes de cada call <code>forward</code> de un determinado
batch, y sólo hacerlo para los batches 1 y 3. Entonces instancias esta clase como:`,Qe,vs,De,Gs,Dl="Y ahora los batches 1 y 3 completos serán rastreados usando el mismo formato que el detector de underflow/overflow.",Se,Vs,Sl="Los batches son 0-index.",He,ks,Hl=`Esto es muy útil si sabes que el programa empieza a comportarse mal después de un determinado número de batch, para que puedas avanzar rápidamente
hasta esa área. Aquí hay un ejemplo de output recortado para tal configuración:`,Ye,Bs,ze,Rs,Yl=`Aquí obtendrás un gran número de frames mostrados - tantos como forward calls haya en tu modelo, por lo que puede o no ser lo que quieras, pero a veces puede ser más fácil de usar para debug que un debugger normal.
Por ejemplo, si un problema comienza a ocurrir en el batch 150. Entonces puedes mostrar las trazas de los batches 149 y 150 y comparar dónde
los números empezaron a divergir.`,Fe,_s,zl="También puedes especificar el número de batch después del cual se debe detener el entrenamiento, con:",Pe,$s,qe,Ss,Ke;return $=new ll({}),g=new ll({}),N=new h({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTJGbWFpbiUyRnNjcmlwdHMlMkZkaXN0cmlidXRlZCUyRnRvcmNoLWRpc3RyaWJ1dGVkLWdwdS10ZXN0LnB5",highlighted:"wget https://raw.githubusercontent.com/huggingface/transformers/main/scripts/distributed/torch-distributed-gpu-test.py"}}),E=new h({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMC0tbm5vZGVzJTIwMSUyMHRvcmNoLWRpc3RyaWJ1dGVkLWdwdS10ZXN0LnB5",highlighted:"python -m torch.distributed.run --nproc_per_node 2 --nnodes 1 torch-distributed-gpu-test.py"}}),S=new h({props:{code:"TkNDTF9ERUJVRyUzRElORk8lMjBweXRob24lMjAtbSUyMHRvcmNoLmRpc3RyaWJ1dGVkLnJ1biUyMC0tbnByb2NfcGVyX25vZGUlMjAyJTIwLS1ubm9kZXMlMjAxJTIwdG9yY2gtZGlzdHJpYnV0ZWQtZ3B1LXRlc3QucHk=",highlighted:"NCCL_DEBUG=INFO python -m torch.distributed.run --nproc_per_node 2 --nnodes 1 torch-distributed-gpu-test.py"}}),Y=new ll({}),k=new rl({props:{$$slots:{default:[pa]},$$scope:{ctx:A}}}),B=new rl({props:{$$slots:{default:[ra]},$$scope:{ctx:A}}}),R=new rl({props:{$$slots:{default:[ua]},$$scope:{ctx:A}}}),P=new h({props:{code:"LS1kZWJ1ZyUyMHVuZGVyZmxvd19vdmVyZmxvdw==",highlighted:"--debug underflow_overflow"}}),O=new h({props:{code:"ZnJvbSUyMC5kZWJ1Z191dGlscyUyMGltcG9ydCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3clMEElMEFkZWJ1Z19vdmVyZmxvdyUyMCUzRCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3cobW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> .debug_utils <span class="hljs-keyword">import</span> DebugUnderflowOverflow

debug_overflow = DebugUnderflowOverflow(model)`}}),es=new h({props:{code:"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",highlighted:`<span class="hljs-attribute">Detected</span> inf/nan during batch_number=<span class="hljs-number">0</span>
<span class="hljs-attribute">Last</span> <span class="hljs-number">21</span> forward frames:
<span class="hljs-attribute">abs</span> min  abs max  metadata
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">1</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.dropout Dropout
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">2</span>.<span class="hljs-number">57</span>e+<span class="hljs-number">02</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">2</span>.<span class="hljs-number">85</span>e+<span class="hljs-number">02</span> output<span class="hljs-meta">
[...]</span>
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">0</span> T5LayerSelfAttention
<span class="hljs-attribute">6</span>.<span class="hljs-number">78</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">15</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> output[<span class="hljs-number">0</span>]
             <span class="hljs-attribute">None</span> output[<span class="hljs-number">1</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">25</span>e-<span class="hljs-number">01</span> <span class="hljs-number">1</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">04</span> output[<span class="hljs-number">2</span>]
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.layer_norm T5LayerNorm
<span class="hljs-attribute">8</span>.<span class="hljs-number">69</span>e-<span class="hljs-number">02</span> <span class="hljs-number">4</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">01</span> weight
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_0 Linear
<span class="hljs-attribute">2</span>.<span class="hljs-number">17</span>e-<span class="hljs-number">07</span> <span class="hljs-number">4</span>.<span class="hljs-number">50</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">68</span>e-<span class="hljs-number">06</span> <span class="hljs-number">3</span>.<span class="hljs-number">70</span>e+<span class="hljs-number">01</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_1 Linear
<span class="hljs-attribute">8</span>.<span class="hljs-number">08</span>e-<span class="hljs-number">07</span> <span class="hljs-number">2</span>.<span class="hljs-number">66</span>e+<span class="hljs-number">01</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">27</span>e-<span class="hljs-number">04</span> <span class="hljs-number">2</span>.<span class="hljs-number">37</span>e+<span class="hljs-number">02</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.dropout Dropout
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">8</span>.<span class="hljs-number">76</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wo Linear
<span class="hljs-attribute">1</span>.<span class="hljs-number">01</span>e-<span class="hljs-number">06</span> <span class="hljs-number">6</span>.<span class="hljs-number">44</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense T5DenseGatedGeluDense
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.dropout Dropout
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span>      inf output`}}),ps=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEubGF5ZXJfbm9ybSUyMFQ1TGF5ZXJOb3JtJTBBOC42OWUtMDIlMjA0LjE4ZS0wMSUyMHdlaWdodCUwQTIuNjVlLTA0JTIwMy40MmUlMkIwMyUyMGlucHV0JTVCMCU1RCUwQTEuNzllLTA2JTIwNC42NWUlMkIwMCUyMG91dHB1dA==",highlighted:`                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.layer_norm T5LayerNorm
<span class="hljs-attribute">8</span>.<span class="hljs-number">69</span>e-<span class="hljs-number">02</span> <span class="hljs-number">4</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">01</span> weight
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> output`}}),os=new h({props:{code:"RGV0ZWN0ZWQlMjBpbmYlMkZuYW4lMjBkdXJpbmclMjBiYXRjaF9udW1iZXIlM0QwJTBBTGFzdCUyMDIxJTIwZm9yd2FyZCUyMGZyYW1lcyUzQSUwQWFicyUyMG1pbiUyMCUyMGFicyUyMG1heCUyMCUyMG1ldGFkYXRhJTBBJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEuRGVuc2VSZWx1RGVuc2Uud2lfMCUyMExpbmVhciUwQTIuMTdlLTA3JTIwNC41MGUlMkIwMCUyMHdlaWdodCUwQTEuNzllLTA2JTIwNC42NWUlMkIwMCUyMGlucHV0JTVCMCU1RCUwQTIuNjhlLTA2JTIwMy43MGUlMkIwMSUyMG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuY29kZXIuYmxvY2suMi5sYXllci4xLkRlbnNlUmVsdURlbnNlLndpXzElMjBMaW5lYXIlMEE4LjA4ZS0wNyUyMDIuNjZlJTJCMDElMjB3ZWlnaHQlMEExLjc5ZS0wNiUyMDQuNjVlJTJCMDAlMjBpbnB1dCU1QjAlNUQlMEExLjI3ZS0wNCUyMDIuMzdlJTJCMDIlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGVyLmJsb2NrLjIubGF5ZXIuMS5EZW5zZVJlbHVEZW5zZS53byUyMExpbmVhciUwQTEuMDFlLTA2JTIwNi40NGUlMkIwMCUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjA5Ljc0ZSUyQjAzJTIwaW5wdXQlNUIwJTVEJTBBMy4xOGUtMDQlMjA2LjI3ZSUyQjA0JTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEuRGVuc2VSZWx1RGVuc2UlMjBUNURlbnNlR2F0ZWRHZWx1RGVuc2UlMEExLjc5ZS0wNiUyMDQuNjVlJTJCMDAlMjBpbnB1dCU1QjAlNUQlMEEzLjE4ZS0wNCUyMDYuMjdlJTJCMDQlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGVyLmJsb2NrLjIubGF5ZXIuMS5kcm9wb3V0JTIwRHJvcG91dCUwQTMuMThlLTA0JTIwNi4yN2UlMkIwNCUyMGlucHV0JTVCMCU1RCUwQTAuMDBlJTJCMDAlMjAlMjAlMjAlMjAlMjAlMjBpbmYlMjBvdXRwdXQ=",highlighted:`<span class="hljs-attribute">Detected</span> inf/nan during batch_number=<span class="hljs-number">0</span>
<span class="hljs-attribute">Last</span> <span class="hljs-number">21</span> forward frames:
<span class="hljs-attribute">abs</span> min  abs max  metadata<span class="hljs-meta">
[...]</span>
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_0 Linear
<span class="hljs-attribute">2</span>.<span class="hljs-number">17</span>e-<span class="hljs-number">07</span> <span class="hljs-number">4</span>.<span class="hljs-number">50</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">68</span>e-<span class="hljs-number">06</span> <span class="hljs-number">3</span>.<span class="hljs-number">70</span>e+<span class="hljs-number">01</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_1 Linear
<span class="hljs-attribute">8</span>.<span class="hljs-number">08</span>e-<span class="hljs-number">07</span> <span class="hljs-number">2</span>.<span class="hljs-number">66</span>e+<span class="hljs-number">01</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">27</span>e-<span class="hljs-number">04</span> <span class="hljs-number">2</span>.<span class="hljs-number">37</span>e+<span class="hljs-number">02</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wo Linear
<span class="hljs-attribute">1</span>.<span class="hljs-number">01</span>e-<span class="hljs-number">06</span> <span class="hljs-number">6</span>.<span class="hljs-number">44</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense T5DenseGatedGeluDense
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.dropout Dropout
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span>      inf output`}}),Ms=new h({props:{code:"Y2xhc3MlMjBUNURlbnNlR2F0ZWRHZWx1RGVuc2Uobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53aV8wJTIwJTNEJTIwbm4uTGluZWFyKGNvbmZpZy5kX21vZGVsJTJDJTIwY29uZmlnLmRfZmYlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53aV8xJTIwJTNEJTIwbm4uTGluZWFyKGNvbmZpZy5kX21vZGVsJTJDJTIwY29uZmlnLmRfZmYlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53byUyMCUzRCUyMG5uLkxpbmVhcihjb25maWcuZF9mZiUyQyUyMGNvbmZpZy5kX21vZGVsJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZHJvcG91dCUyMCUzRCUyMG5uLkRyb3BvdXQoY29uZmlnLmRyb3BvdXRfcmF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmdlbHVfYWN0JTIwJTNEJTIwQUNUMkZOJTVCJTIyZ2VsdV9uZXclMjIlNUQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBoaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9nZWx1JTIwJTNEJTIwc2VsZi5nZWx1X2FjdChzZWxmLndpXzAoaGlkZGVuX3N0YXRlcykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX2xpbmVhciUyMCUzRCUyMHNlbGYud2lfMShoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBoaWRkZW5fZ2VsdSUyMColMjBoaWRkZW5fbGluZWFyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHNlbGYuZHJvcG91dChoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBzZWxmLndvKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaGlkZGVuX3N0YXRlcw==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">T5DenseGatedGeluDense</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.wi_0 = nn.Linear(config.d_model, config.d_ff, bias=<span class="hljs-literal">False</span>)
        self.wi_1 = nn.Linear(config.d_model, config.d_ff, bias=<span class="hljs-literal">False</span>)
        self.wo = nn.Linear(config.d_ff, config.d_model, bias=<span class="hljs-literal">False</span>)
        self.dropout = nn.Dropout(config.dropout_rate)
        self.gelu_act = ACT2FN[<span class="hljs-string">&quot;gelu_new&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
        hidden_gelu = self.gelu_act(self.wi_0(hidden_states))
        hidden_linear = self.wi_1(hidden_states)
        hidden_states = hidden_gelu * hidden_linear
        hidden_states = self.dropout(hidden_states)
        hidden_states = self.wo(hidden_states)
        <span class="hljs-keyword">return</span> hidden_states`}}),Ts=new h({props:{code:"ZGVmJTIwX2ZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwaGlkZGVuX2dlbHUlMjAlM0QlMjBzZWxmLmdlbHVfYWN0KHNlbGYud2lfMChoaWRkZW5fc3RhdGVzKSklMEElMjAlMjAlMjAlMjBoaWRkZW5fbGluZWFyJTIwJTNEJTIwc2VsZi53aV8xKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMGhpZGRlbl9nZWx1JTIwKiUyMGhpZGRlbl9saW5lYXIlMEElMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTIwJTNEJTIwc2VsZi5kcm9wb3V0KGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHNlbGYud28oaGlkZGVuX3N0YXRlcyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaWRkZW5fc3RhdGVzJTBBJTBBJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBoaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guaXNfYXV0b2Nhc3RfZW5hYmxlZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmN1ZGEuYW1wLmF1dG9jYXN0KGVuYWJsZWQlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9mb3J3YXJkKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuX2ZvcndhcmQoaGlkZGVuX3N0YXRlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, hidden_states</span>):
    hidden_gelu = self.gelu_act(self.wi_0(hidden_states))
    hidden_linear = self.wi_1(hidden_states)
    hidden_states = hidden_gelu * hidden_linear
    hidden_states = self.dropout(hidden_states)
    hidden_states = self.wo(hidden_states)
    <span class="hljs-keyword">return</span> hidden_states


<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
    <span class="hljs-keyword">if</span> torch.is_autocast_enabled():
        <span class="hljs-keyword">with</span> torch.cuda.amp.autocast(enabled=<span class="hljs-literal">False</span>):
            <span class="hljs-keyword">return</span> self._forward(hidden_states)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> self._forward(hidden_states)`}}),Js=new h({props:{code:"ZnJvbSUyMGRlYnVnX3V0aWxzJTIwaW1wb3J0JTIwZGV0ZWN0X292ZXJmbG93JTBBJTBBJTBBY2xhc3MlMjBUNUxheWVyRkYobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCU1Qi4uLiU1RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yd2FyZGVkX3N0YXRlcyUyMCUzRCUyMHNlbGYubGF5ZXJfbm9ybShoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldGVjdF9vdmVyZmxvdyhmb3J3YXJkZWRfc3RhdGVzJTJDJTIwJTIyYWZ0ZXIlMjBsYXllcl9ub3JtJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcndhcmRlZF9zdGF0ZXMlMjAlM0QlMjBzZWxmLkRlbnNlUmVsdURlbnNlKGZvcndhcmRlZF9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV0ZWN0X292ZXJmbG93KGZvcndhcmRlZF9zdGF0ZXMlMkMlMjAlMjJhZnRlciUyMERlbnNlUmVsdURlbnNlJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGhpZGRlbl9zdGF0ZXMlMjAlMkIlMjBzZWxmLmRyb3BvdXQoZm9yd2FyZGVkX3N0YXRlcyk=",highlighted:`<span class="hljs-keyword">from</span> debug_utils <span class="hljs-keyword">import</span> detect_overflow


<span class="hljs-keyword">class</span> <span class="hljs-title class_">T5LayerFF</span>(nn.Module):
    [...]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
        forwarded_states = self.layer_norm(hidden_states)
        detect_overflow(forwarded_states, <span class="hljs-string">&quot;after layer_norm&quot;</span>)
        forwarded_states = self.DenseReluDense(forwarded_states)
        detect_overflow(forwarded_states, <span class="hljs-string">&quot;after DenseReluDense&quot;</span>)
        <span class="hljs-keyword">return</span> hidden_states + self.dropout(forwarded_states)`}}),fs=new h({props:{code:"ZnJvbSUyMC5kZWJ1Z191dGlscyUyMGltcG9ydCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3clMEElMEFkZWJ1Z19vdmVyZmxvdyUyMCUzRCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3cobW9kZWwlMkMlMjBtYXhfZnJhbWVzX3RvX3NhdmUlM0QxMDAp",highlighted:`<span class="hljs-keyword">from</span> .debug_utils <span class="hljs-keyword">import</span> DebugUnderflowOverflow

debug_overflow = DebugUnderflowOverflow(model, max_frames_to_save=<span class="hljs-number">100</span>)`}}),Cs=new ll({}),vs=new h({props:{code:"ZGVidWdfb3ZlcmZsb3clMjAlM0QlMjBEZWJ1Z1VuZGVyZmxvd092ZXJmbG93KG1vZGVsJTJDJTIwdHJhY2VfYmF0Y2hfbnVtcyUzRCU1QjElMkMlMjAzJTVEKQ==",highlighted:'debug_overflow = DebugUnderflowOverflow(model, trace_batch_nums=[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>])'}}),Bs=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKioqJTIwU3RhcnRpbmclMjBiYXRjaCUyMG51bWJlciUzRDElMjAqKiolMEFhYnMlMjBtaW4lMjAlMjBhYnMlMjBtYXglMjAlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXJlZCUyMEVtYmVkZGluZyUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAyLjQ3ZSUyQjA0JTIwaW5wdXQlNUIwJTVEJTBBNS4zNmUtMDUlMjA3LjkyZSUyQjAyJTIwb3V0cHV0JTBBJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2Rlci5kcm9wb3V0JTIwRHJvcG91dCUwQTEuNjBlLTA3JTIwMi4yN2UlMkIwMSUyMGlucHV0JTVCMCU1RCUwQTAuMDBlJTJCMDAlMjAyLjUyZSUyQjAxJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2RlciUyMFQ1U3RhY2slMEElMjAlMjAlMjAlMjAlMjBub3QlMjBhJTIwdGVuc29yJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG1faGVhZCUyMExpbmVhciUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAxLjExZSUyQjAwJTIwaW5wdXQlNUIwJTVEJTBBNi4wNmUtMDIlMjA4LjM5ZSUyQjAxJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMjAlMjAlMjAlMjAlMjBub3QlMjBhJTIwdGVuc29yJTIwb3V0cHV0JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKioqJTIwU3RhcnRpbmclMjBiYXRjaCUyMG51bWJlciUzRDMlMjAqKiolMEFhYnMlMjBtaW4lMjAlMjBhYnMlMjBtYXglMjAlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXJlZCUyMEVtYmVkZGluZyUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAyLjc4ZSUyQjA0JTIwaW5wdXQlNUIwJTVEJTBBNS4zNmUtMDUlMjA3LjkyZSUyQjAyJTIwb3V0cHV0JTBBJTVCLi4uJTVE",highlighted:`                  *** Starting batch number=1 ***
abs min  abs max  metadata
                  shared Embedding
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 2.47e<span class="hljs-string">+04</span> input[0]
5.36e<span class="hljs-string">-05</span> 7.92e<span class="hljs-string">+02</span> output
[...]
                  decoder.dropout Dropout
1.60e<span class="hljs-string">-07</span> 2.27e<span class="hljs-string">+01</span> input[0]
0.00e<span class="hljs-string">+00</span> 2.52e<span class="hljs-string">+01</span> output
                  decoder T5Stack
     not a tensor output
                  lm_head Linear
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 1.11e<span class="hljs-string">+00</span> input[0]
6.06e<span class="hljs-string">-02</span> 8.39e<span class="hljs-string">+01</span> output
                   T5ForConditionalGeneration
     not a tensor output

                  *** Starting batch number=3 ***
abs min  abs max  metadata
                  shared Embedding
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 2.78e<span class="hljs-string">+04</span> input[0]
5.36e<span class="hljs-string">-05</span> 7.92e<span class="hljs-string">+02</span> output
[...]`}}),$s=new h({props:{code:"ZGVidWdfb3ZlcmZsb3clMjAlM0QlMjBEZWJ1Z1VuZGVyZmxvd092ZXJmbG93KG1vZGVsJTJDJTIwdHJhY2VfYmF0Y2hfbnVtcyUzRCU1QjElMkMlMjAzJTVEJTJDJTIwYWJvcnRfYWZ0ZXJfYmF0Y2hfbnVtJTNEMyk=",highlighted:'debug_overflow = DebugUnderflowOverflow(model, trace_batch_nums=[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>], abort_after_batch_num=<span class="hljs-number">3</span>)'}}),{c(){o=p("meta"),y=n(),c=p("p"),I=n(),U=p("h1"),v=p("a"),Ws=p("span"),i($.$$.fragment),al=n(),xs=p("span"),xs.textContent=ol,zs=n(),f=p("h2"),G=p("a"),Xs=p("span"),i(g.$$.fragment),nl=n(),Ns=p("span"),Ns.textContent=cl,Fs=n(),x=p("p"),x.innerHTML=il,Ps=n(),i(N.$$.fragment),qs=n(),L=p("p"),L.textContent=ml,Ks=n(),i(E.$$.fragment),Os=n(),W=p("p"),W.textContent=dl,se=n(),X=p("p"),X.textContent=Ml,ee=n(),Q=p("p"),Q.textContent=jl,le=n(),D=p("p"),D.innerHTML=wl,ae=n(),i(S.$$.fragment),ne=n(),H=p("p"),H.textContent=bl,te=n(),C=p("h2"),V=p("a"),Qs=p("span"),i(Y.$$.fragment),tl=n(),Ls=p("span"),Ls.textContent=Tl,pe=n(),i(k.$$.fragment),re=n(),i(B.$$.fragment),ue=n(),i(R.$$.fragment),oe=n(),z=p("p"),z.innerHTML=hl,ce=n(),F=p("p"),F.innerHTML=Jl,ie=n(),i(P.$$.fragment),me=n(),q=p("p"),q.innerHTML=yl,de=n(),K=p("p"),K.textContent=Il,Me=n(),i(O.$$.fragment),je=n(),ss=p("p"),ss.innerHTML=Ul,we=n(),i(es.$$.fragment),be=n(),ls=p("p"),ls.textContent=fl,Te=n(),as=p("p"),as.innerHTML=Cl,he=n(),ns=p("p"),ns.innerHTML=Zl,Je=n(),ts=p("p"),ts.textContent=Al,ye=n(),i(ps.$$.fragment),Ie=n(),rs=p("p"),rs.innerHTML=vl,Ue=n(),us=p("p"),us.textContent=Gl,fe=n(),i(os.$$.fragment),Ce=n(),cs=p("p"),cs.innerHTML=Vl,Ze=n(),is=p("p"),is.innerHTML=kl,Ae=n(),ms=p("p"),ms.textContent=Bl,ve=n(),ds=p("p"),ds.innerHTML=Rl,Ge=n(),i(Ms.$$.fragment),Ve=n(),js=p("p"),js.innerHTML=_l,ke=n(),ws=p("p"),ws.innerHTML=$l,Be=n(),bs=p("p"),bs.innerHTML=gl,Re=n(),i(Ts.$$.fragment),_e=n(),hs=p("p"),hs.innerHTML=xl,$e=n(),i(Js.$$.fragment),ge=n(),ys=p("p"),ys.innerHTML=Nl,xe=n(),Is=p("p"),Is.innerHTML=Ll,Ne=n(),Us=p("p"),Us.textContent=El,Le=n(),i(fs.$$.fragment),Ee=n(),Z=p("h3"),_=p("a"),Ds=p("span"),i(Cs.$$.fragment),pl=n(),Es=p("span"),Es.textContent=Wl,We=n(),Zs=p("p"),Zs.textContent=Xl,Xe=n(),As=p("p"),As.innerHTML=Ql,Qe=n(),i(vs.$$.fragment),De=n(),Gs=p("p"),Gs.textContent=Dl,Se=n(),Vs=p("p"),Vs.textContent=Sl,He=n(),ks=p("p"),ks.textContent=Hl,Ye=n(),i(Bs.$$.fragment),ze=n(),Rs=p("p"),Rs.textContent=Yl,Fe=n(),_s=p("p"),_s.textContent=zl,Pe=n(),i($s.$$.fragment),qe=n(),Ss=p("p"),this.h()},l(s){const e=ta("svelte-1phssyn",document.head);o=r(e,"META",{name:!0,content:!0}),e.forEach(l),y=t(s),c=r(s,"P",{}),J(c).forEach(l),I=t(s),U=r(s,"H1",{class:!0});var gs=J(U);v=r(gs,"A",{id:!0,class:!0,href:!0});var Hs=J(v);Ws=r(Hs,"SPAN",{});var Ys=J(Ws);m($.$$.fragment,Ys),Ys.forEach(l),Hs.forEach(l),al=t(gs),xs=r(gs,"SPAN",{"data-svelte-h":!0}),u(xs)!=="svelte-1gm1qgf"&&(xs.textContent=ol),gs.forEach(l),zs=t(s),f=r(s,"H2",{class:!0});var Oe=J(f);G=r(Oe,"A",{id:!0,class:!0,href:!0});var Fl=J(G);Xs=r(Fl,"SPAN",{});var Pl=J(Xs);m(g.$$.fragment,Pl),Pl.forEach(l),Fl.forEach(l),nl=t(Oe),Ns=r(Oe,"SPAN",{"data-svelte-h":!0}),u(Ns)!=="svelte-1bkrmbj"&&(Ns.textContent=cl),Oe.forEach(l),Fs=t(s),x=r(s,"P",{"data-svelte-h":!0}),u(x)!=="svelte-b2gmoe"&&(x.innerHTML=il),Ps=t(s),m(N.$$.fragment,s),qs=t(s),L=r(s,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1936y28"&&(L.textContent=ml),Ks=t(s),m(E.$$.fragment,s),Os=t(s),W=r(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1m3rn6q"&&(W.textContent=dl),se=t(s),X=r(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1qjrb86"&&(X.textContent=Ml),ee=t(s),Q=r(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1ku6vfi"&&(Q.textContent=jl),le=t(s),D=r(s,"P",{"data-svelte-h":!0}),u(D)!=="svelte-deyufk"&&(D.innerHTML=wl),ae=t(s),m(S.$$.fragment,s),ne=t(s),H=r(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-114ng1i"&&(H.textContent=bl),te=t(s),C=r(s,"H2",{class:!0});var sl=J(C);V=r(sl,"A",{id:!0,class:!0,href:!0});var ql=J(V);Qs=r(ql,"SPAN",{});var Kl=J(Qs);m(Y.$$.fragment,Kl),Kl.forEach(l),ql.forEach(l),tl=t(sl),Ls=r(sl,"SPAN",{"data-svelte-h":!0}),u(Ls)!=="svelte-1n6aztj"&&(Ls.textContent=Tl),sl.forEach(l),pe=t(s),m(k.$$.fragment,s),re=t(s),m(B.$$.fragment,s),ue=t(s),m(R.$$.fragment,s),oe=t(s),z=r(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-7sit9h"&&(z.innerHTML=hl),ce=t(s),F=r(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-j3cpcs"&&(F.innerHTML=Jl),ie=t(s),m(P.$$.fragment,s),me=t(s),q=r(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-15ev0q2"&&(q.innerHTML=yl),de=t(s),K=r(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-wqtp9c"&&(K.textContent=Il),Me=t(s),m(O.$$.fragment,s),je=t(s),ss=r(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-1jo5kre"&&(ss.innerHTML=Ul),we=t(s),m(es.$$.fragment,s),be=t(s),ls=r(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-x04aaj"&&(ls.textContent=fl),Te=t(s),as=r(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-4r89ln"&&(as.innerHTML=Cl),he=t(s),ns=r(s,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-6zf2z9"&&(ns.innerHTML=Zl),Je=t(s),ts=r(s,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-1opunmv"&&(ts.textContent=Al),ye=t(s),m(ps.$$.fragment,s),Ie=t(s),rs=r(s,"P",{"data-svelte-h":!0}),u(rs)!=="svelte-dwkjw4"&&(rs.innerHTML=vl),Ue=t(s),us=r(s,"P",{"data-svelte-h":!0}),u(us)!=="svelte-1l806z7"&&(us.textContent=Gl),fe=t(s),m(os.$$.fragment,s),Ce=t(s),cs=r(s,"P",{"data-svelte-h":!0}),u(cs)!=="svelte-15sbs2p"&&(cs.innerHTML=Vl),Ze=t(s),is=r(s,"P",{"data-svelte-h":!0}),u(is)!=="svelte-1h0cfpa"&&(is.innerHTML=kl),Ae=t(s),ms=r(s,"P",{"data-svelte-h":!0}),u(ms)!=="svelte-6rkr7t"&&(ms.textContent=Bl),ve=t(s),ds=r(s,"P",{"data-svelte-h":!0}),u(ds)!=="svelte-1odtud2"&&(ds.innerHTML=Rl),Ge=t(s),m(Ms.$$.fragment,s),Ve=t(s),js=r(s,"P",{"data-svelte-h":!0}),u(js)!=="svelte-pypfv9"&&(js.innerHTML=_l),ke=t(s),ws=r(s,"P",{"data-svelte-h":!0}),u(ws)!=="svelte-14ofdnz"&&(ws.innerHTML=$l),Be=t(s),bs=r(s,"P",{"data-svelte-h":!0}),u(bs)!=="svelte-p0ujj7"&&(bs.innerHTML=gl),Re=t(s),m(Ts.$$.fragment,s),_e=t(s),hs=r(s,"P",{"data-svelte-h":!0}),u(hs)!=="svelte-1nnn3eq"&&(hs.innerHTML=xl),$e=t(s),m(Js.$$.fragment,s),ge=t(s),ys=r(s,"P",{"data-svelte-h":!0}),u(ys)!=="svelte-ewhn06"&&(ys.innerHTML=Nl),xe=t(s),Is=r(s,"P",{"data-svelte-h":!0}),u(Is)!=="svelte-1psj6in"&&(Is.innerHTML=Ll),Ne=t(s),Us=r(s,"P",{"data-svelte-h":!0}),u(Us)!=="svelte-vdijwi"&&(Us.textContent=El),Le=t(s),m(fs.$$.fragment,s),Ee=t(s),Z=r(s,"H3",{class:!0});var el=J(Z);_=r(el,"A",{id:!0,class:!0,href:!0});var Ol=J(_);Ds=r(Ol,"SPAN",{});var sa=J(Ds);m(Cs.$$.fragment,sa),sa.forEach(l),Ol.forEach(l),pl=t(el),Es=r(el,"SPAN",{"data-svelte-h":!0}),u(Es)!=="svelte-764251"&&(Es.textContent=Wl),el.forEach(l),We=t(s),Zs=r(s,"P",{"data-svelte-h":!0}),u(Zs)!=="svelte-12vhr9v"&&(Zs.textContent=Xl),Xe=t(s),As=r(s,"P",{"data-svelte-h":!0}),u(As)!=="svelte-4ky2ig"&&(As.innerHTML=Ql),Qe=t(s),m(vs.$$.fragment,s),De=t(s),Gs=r(s,"P",{"data-svelte-h":!0}),u(Gs)!=="svelte-1deawea"&&(Gs.textContent=Dl),Se=t(s),Vs=r(s,"P",{"data-svelte-h":!0}),u(Vs)!=="svelte-1d0mz9t"&&(Vs.textContent=Sl),He=t(s),ks=r(s,"P",{"data-svelte-h":!0}),u(ks)!=="svelte-1gv06dh"&&(ks.textContent=Hl),Ye=t(s),m(Bs.$$.fragment,s),ze=t(s),Rs=r(s,"P",{"data-svelte-h":!0}),u(Rs)!=="svelte-k61p1e"&&(Rs.textContent=Yl),Fe=t(s),_s=r(s,"P",{"data-svelte-h":!0}),u(_s)!=="svelte-1vqwv9x"&&(_s.textContent=zl),Pe=t(s),m($s.$$.fragment,s),qe=t(s),Ss=r(s,"P",{}),J(Ss).forEach(l),this.h()},h(){b(o,"name","hf:doc:metadata"),b(o,"content",JSON.stringify(ca)),b(v,"id","debugging"),b(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),b(v,"href","#debugging"),b(U,"class","relative group"),b(G,"id","debug-de-problemas-de-network-multigpu"),b(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),b(G,"href","#debug-de-problemas-de-network-multigpu"),b(f,"class","relative group"),b(V,"id","deteccin-de-underflow-y-overflow"),b(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),b(V,"href","#deteccin-de-underflow-y-overflow"),b(C,"class","relative group"),b(_,"id","rastreo-de-valores-mnimos-y-mximos-absolutos-de-batches-especficos"),b(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),b(_,"href","#rastreo-de-valores-mnimos-y-mximos-absolutos-de-batches-especficos"),b(Z,"class","relative group")},m(s,e){T(document.head,o),a(s,y,e),a(s,c,e),a(s,I,e),a(s,U,e),T(U,v),T(v,Ws),d($,Ws,null),T(U,al),T(U,xs),a(s,zs,e),a(s,f,e),T(f,G),T(G,Xs),d(g,Xs,null),T(f,nl),T(f,Ns),a(s,Fs,e),a(s,x,e),a(s,Ps,e),d(N,s,e),a(s,qs,e),a(s,L,e),a(s,Ks,e),d(E,s,e),a(s,Os,e),a(s,W,e),a(s,se,e),a(s,X,e),a(s,ee,e),a(s,Q,e),a(s,le,e),a(s,D,e),a(s,ae,e),d(S,s,e),a(s,ne,e),a(s,H,e),a(s,te,e),a(s,C,e),T(C,V),T(V,Qs),d(Y,Qs,null),T(C,tl),T(C,Ls),a(s,pe,e),d(k,s,e),a(s,re,e),d(B,s,e),a(s,ue,e),d(R,s,e),a(s,oe,e),a(s,z,e),a(s,ce,e),a(s,F,e),a(s,ie,e),d(P,s,e),a(s,me,e),a(s,q,e),a(s,de,e),a(s,K,e),a(s,Me,e),d(O,s,e),a(s,je,e),a(s,ss,e),a(s,we,e),d(es,s,e),a(s,be,e),a(s,ls,e),a(s,Te,e),a(s,as,e),a(s,he,e),a(s,ns,e),a(s,Je,e),a(s,ts,e),a(s,ye,e),d(ps,s,e),a(s,Ie,e),a(s,rs,e),a(s,Ue,e),a(s,us,e),a(s,fe,e),d(os,s,e),a(s,Ce,e),a(s,cs,e),a(s,Ze,e),a(s,is,e),a(s,Ae,e),a(s,ms,e),a(s,ve,e),a(s,ds,e),a(s,Ge,e),d(Ms,s,e),a(s,Ve,e),a(s,js,e),a(s,ke,e),a(s,ws,e),a(s,Be,e),a(s,bs,e),a(s,Re,e),d(Ts,s,e),a(s,_e,e),a(s,hs,e),a(s,$e,e),d(Js,s,e),a(s,ge,e),a(s,ys,e),a(s,xe,e),a(s,Is,e),a(s,Ne,e),a(s,Us,e),a(s,Le,e),d(fs,s,e),a(s,Ee,e),a(s,Z,e),T(Z,_),T(_,Ds),d(Cs,Ds,null),T(Z,pl),T(Z,Es),a(s,We,e),a(s,Zs,e),a(s,Xe,e),a(s,As,e),a(s,Qe,e),d(vs,s,e),a(s,De,e),a(s,Gs,e),a(s,Se,e),a(s,Vs,e),a(s,He,e),a(s,ks,e),a(s,Ye,e),d(Bs,s,e),a(s,ze,e),a(s,Rs,e),a(s,Fe,e),a(s,_s,e),a(s,Pe,e),d($s,s,e),a(s,qe,e),a(s,Ss,e),Ke=!0},p(s,[e]){const gs={};e&2&&(gs.$$scope={dirty:e,ctx:s}),k.$set(gs);const Hs={};e&2&&(Hs.$$scope={dirty:e,ctx:s}),B.$set(Hs);const Ys={};e&2&&(Ys.$$scope={dirty:e,ctx:s}),R.$set(Ys)},i(s){Ke||(M($.$$.fragment,s),M(g.$$.fragment,s),M(N.$$.fragment,s),M(E.$$.fragment,s),M(S.$$.fragment,s),M(Y.$$.fragment,s),M(k.$$.fragment,s),M(B.$$.fragment,s),M(R.$$.fragment,s),M(P.$$.fragment,s),M(O.$$.fragment,s),M(es.$$.fragment,s),M(ps.$$.fragment,s),M(os.$$.fragment,s),M(Ms.$$.fragment,s),M(Ts.$$.fragment,s),M(Js.$$.fragment,s),M(fs.$$.fragment,s),M(Cs.$$.fragment,s),M(vs.$$.fragment,s),M(Bs.$$.fragment,s),M($s.$$.fragment,s),Ke=!0)},o(s){j($.$$.fragment,s),j(g.$$.fragment,s),j(N.$$.fragment,s),j(E.$$.fragment,s),j(S.$$.fragment,s),j(Y.$$.fragment,s),j(k.$$.fragment,s),j(B.$$.fragment,s),j(R.$$.fragment,s),j(P.$$.fragment,s),j(O.$$.fragment,s),j(es.$$.fragment,s),j(ps.$$.fragment,s),j(os.$$.fragment,s),j(Ms.$$.fragment,s),j(Ts.$$.fragment,s),j(Js.$$.fragment,s),j(fs.$$.fragment,s),j(Cs.$$.fragment,s),j(vs.$$.fragment,s),j(Bs.$$.fragment,s),j($s.$$.fragment,s),Ke=!1},d(s){s&&(l(y),l(c),l(I),l(U),l(zs),l(f),l(Fs),l(x),l(Ps),l(qs),l(L),l(Ks),l(Os),l(W),l(se),l(X),l(ee),l(Q),l(le),l(D),l(ae),l(ne),l(H),l(te),l(C),l(pe),l(re),l(ue),l(oe),l(z),l(ce),l(F),l(ie),l(me),l(q),l(de),l(K),l(Me),l(je),l(ss),l(we),l(be),l(ls),l(Te),l(as),l(he),l(ns),l(Je),l(ts),l(ye),l(Ie),l(rs),l(Ue),l(us),l(fe),l(Ce),l(cs),l(Ze),l(is),l(Ae),l(ms),l(ve),l(ds),l(Ge),l(Ve),l(js),l(ke),l(ws),l(Be),l(bs),l(Re),l(_e),l(hs),l($e),l(ge),l(ys),l(xe),l(Is),l(Ne),l(Us),l(Le),l(Ee),l(Z),l(We),l(Zs),l(Xe),l(As),l(Qe),l(De),l(Gs),l(Se),l(Vs),l(He),l(ks),l(Ye),l(ze),l(Rs),l(Fe),l(_s),l(Pe),l(qe),l(Ss)),l(o),w($),w(g),w(N,s),w(E,s),w(S,s),w(Y),w(k,s),w(B,s),w(R,s),w(P,s),w(O,s),w(es,s),w(ps,s),w(os,s),w(Ms,s),w(Ts,s),w(Js,s),w(fs,s),w(Cs),w(vs,s),w(Bs,s),w($s,s)}}}const ca={local:"debugging",sections:[{local:"debug-de-problemas-de-network-multigpu",title:"Debug de problemas de Network multi-GPU"},{local:"deteccin-de-underflow-y-overflow",sections:[{local:"rastreo-de-valores-mnimos-y-mximos-absolutos-de-batches-especficos",title:"Rastreo de valores mínimos y máximos absolutos de batches específicos"}],title:"Detección de Underflow y Overflow"}],title:"Debugging"};function ia(A){return la(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends aa{constructor(o){super(),na(this,o,ia,oa,ea,{})}}export{ba as component};
