import{s as Sl,n as xl,o as $l}from"../chunks/scheduler.b108d059.js";import{S as Rl,i as Fl,g as a,s,r as d,A as Ll,h as M,f as n,c as i,j as Vl,u as o,x as r,k as Ml,y as Ql,a as t,v as p,d as h,t as m,w as c}from"../chunks/index.008de539.js";import{C as de}from"../chunks/CodeBlock.7b00c886.js";import{H as u,E as Xl}from"../chunks/getInferenceSnippets.1e6d1c4a.js";function Nl(rl){let y,he,oe,me,j,ce,T,dl='Der Hugging Face Hub erleichtert das Hosten und Teilen von Modellen mit der Community. Er unterstützt <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">Dutzende von Bibliotheken</a> im Open Source-Ökosystem. Wir arbeiten ständig daran, diese Unterstützung zu erweitern, um kollaboratives Machine Learning voranzutreiben. Die <code>huggingface_hub</code>-Bibliothek spielt eine Schlüsselrolle in diesem Prozess und ermöglicht es jedem Python-Skript, Dateien einfach hochzuladen und zu laden.',ue,J,ol="Es gibt vier Hauptwege, eine Bibliothek mit dem Hub zu integrieren:",ye,U,pl=`<li><strong>Push to Hub</strong>: Implementieren Sie eine Methode, um ein Modell auf den Hub hochzuladen.
Dies beinhaltet das Modellgewicht sowie <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">die Modellkarte</a> und alle anderen relevanten Informationen oder Daten, die für den Betrieb des Modells erforderlich sind (zum Beispiel Trainingsprotokolle). Diese Methode wird oft <code>push_to_hub()</code> genannt.</li> <li><strong>Download from Hub</strong>: Implementieren Sie eine Methode, um ein Modell vom Hub zu laden.
Die Methode sollte die Modellkonfiguration/-gewichte herunterladen und das Modell laden. Diese Methode wird oft <code>from_pretrained</code> oder <code>load_from_hub()</code> genannt.</li> <li><strong>Widgets</strong>: Zeigen Sie ein Widget auf der Landing Page Ihrer Modelle auf dem Hub an.
Dies ermöglicht es Benutzern, ein Modell schnell aus dem Browser heraus auszuprobieren.</li>`,we,f,hl="In diesem Leitfaden konzentrieren wir uns auf die ersten beiden Themen. Wir werden die beiden Hauptansätze vorstellen, die Sie zur Integration einer Bibliothek verwenden können, mit ihren Vor- und Nachteilen. Am Ende des Leitfadens ist alles zusammengefasst, um Ihnen bei der Auswahl zwischen den beiden zu helfen. Bitte beachten Sie, dass dies nur Richtlinien sind, die Sie an Ihre Anforderungen anpassen können.",be,I,ml='Wenn Sie sich für Inferenz und Widgets interessieren, können Sie <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">diesem Leitfaden</a> folgen. In beiden Fällen können Sie sich an uns wenden, wenn Sie eine Bibliothek mit dem Hub integrieren und <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in unserer Dokumentation</a> aufgeführt haben möchten.',je,g,Te,C,cl=`Der erste Ansatz zur Integration einer Bibliothek in den Hub besteht tatsächlich darin, die <code>push_to_hub</code> und <code>from_pretrained</code> Methoden selbst zu implementieren. Dies gibt Ihnen volle Flexibilität hinsichtlich der Dateien, die Sie hoch-/herunterladen möchten, und wie Sie Eingaben, die speziell für Ihr Framework sind, behandeln. Sie können sich die beiden Leitfäden <a href="./upload">Dateien hochladen</a> und <a href="./download">Dateien herunterladen</a> ansehen, um mehr darüber zu erfahren, wie dies funktioniert. Dies ist zum Beispiel die Art und Weise, wie die FastAI-Integration implementiert ist (siehe <code>push_to_hub_fastai()</code>
und <code>from_pretrained_fastai()</code>).`,Je,k,ul="Die Implementierung kann zwischen den Bibliotheken variieren, aber der Workflow ist oft ähnlich.",Ue,_,fe,B,yl="So sieht eine <code>from_pretrained</code> Methode normalerweise aus:",Ie,v,ge,Z,Ce,A,wl="Die <code>push_to_hub</code> Methode erfordert oft etwas mehr Komplexität, um die Repo-Erstellung, die Generierung der Modellkarte und das Speichern von Gewichten zu behandeln. Ein üblicher Ansatz besteht darin, all diese Dateien in einem temporären Ordner zu speichern, ihn hochzuladen und dann zu löschen.",ke,W,_e,G,bl='Dies ist natürlich nur ein Beispiel. Wenn Sie an komplexeren Manipulationen interessiert sind (entfernen von entfernten Dateien, hochladen von Gewichten on-the-fly, lokales Speichern von Gewichten, usw.), beachten Sie bitte den <a href="./upload">Dateien hochladen</a> Leitfaden.',Be,z,ve,E,jl="Obwohl dieser Ansatz flexibel ist, hat er einige Nachteile, insbesondere in Bezug auf die Wartung. Hugging Face-Benutzer sind oft an zusätzliche Funktionen gewöhnt, wenn sie mit <code>huggingface_hub</code> arbeiten. Zum Beispiel ist es beim Laden von Dateien aus dem Hub üblich, Parameter wie folgt anzubieten:",Ze,H,Tl="<li><code>token</code>: zum Herunterladen aus einem privaten Repository</li> <li><code>revision</code>: zum Herunterladen von einem spezifischen Branch</li> <li><code>cache_dir</code>: um Dateien in einem spezifischen Verzeichnis zu cachen</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: um den Cache wieder zu verwenden oder nicht</li> <li><code>api_endpoint</code>/<code>proxies</code>: HTTP-Session konfigurieren</li>",Ae,V,Jl="Beim Pushen von Modellen werden ähnliche Parameter unterstützt:",We,S,Ul="<li><code>commit_message</code>: benutzerdefinierte Commit-Nachricht</li> <li><code>private</code>: ein privates Repository erstellen, falls nicht vorhanden</li> <li><code>create_pr</code>: erstellen Sie einen PR anstatt auf <code>main</code> zu pushen</li> <li><code>branch</code>: auf einen Branch pushen anstatt auf den <code>main</code> Branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filtern, welche Dateien hochgeladen werden sollen</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",Ge,x,fl=`Alle diese Parameter können den zuvor gesehenen Implementierungen hinzugefügt und an die <code>huggingface_hub</code>-Methoden übergeben werden.
Wenn sich jedoch ein Parameter ändert oder eine neue Funktion hinzugefügt wird, müssen Sie Ihr Paket aktualisieren.
Die Unterstützung dieser Parameter bedeutet auch mehr Dokumentation, die Sie auf Ihrer Seite pflegen müssen.
Um zu sehen, wie man diese Einschränkungen mildert, springen wir zu unserem nächsten Abschnitt <strong>Klassenvererbung</strong>.`,ze,$,Ee,R,Il="Wie wir oben gesehen haben, gibt es zwei Hauptmethoden, um Ihre Bibliothek mit dem Hub zu integrieren: Dateien hochladen (<code>push_to_hub</code>) und Dateien herunterladen (<code>from_pretrained</code>). Sie können diese Methoden selbst implementieren, aber das hat seine Tücken. Um dies zu bewältigen, bietet <code>huggingface_hub</code> ein Werkzeug an, das Klassenvererbung verwendet. Schauen wir uns an, wie es funktioniert!",He,F,gl='In vielen Fällen implementiert eine Bibliothek ihr Modell bereits mit einer Python-Klasse. Die Klasse enthält die Eigenschaften des Modells und Methoden zum Laden, Ausführen, Trainieren und Evaluieren. Unser Ansatz besteht darin, diese Klasse zu erweitern, um Upload- und Download-Funktionen mit Mixins hinzuzufügen. Ein <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> ist eine Klasse, die dazu bestimmt ist, eine vorhandene Klasse mit einem Satz spezifischer Funktionen durch Mehrfachvererbung zu erweitern. <code>huggingface_hub</code> bietet sein eigenes Mixin, das <code>ModelHubMixin</code>. Der Schlüssel hier ist zu verstehen, wie es funktioniert und wie man es anpassen kann.',Ve,L,Cl="Die Klasse [ModelHubMixin] implementiert 3 <em>öffentliche</em> Methoden (<code>push_to_hub</code>, <code>save_pretrained</code> und <code>from_pretrained</code>). Dies sind die Methoden, die Ihre Benutzer aufrufen werden, um Modelle mit Ihrer Bibliothek zu laden/speichern. <code>ModelHubMixin</code> definiert auch 2 private Methoden (<code>_save_pretrained</code> und <code>_from_pretrained</code>). Diese müssen Sie implementieren. Um Ihre Bibliothek zu integrieren, sollten Sie:",Se,Q,kl=`<li>Lassen Sie Ihre Modell-Klasse von <code>ModelHubMixin</code> erben.</li> <li>Implementieren Sie die privaten Methoden:<ul><li><code>_save_pretrained()</code>: Methode, die als Eingabe einen Pfad zu einem Verzeichnis nimmt und das Modell dort speichert. Sie müssen die gesamte Logik zum Speichern Ihres Modells in dieser Methode schreiben: Modellkarte, Modellgewichte, Konfigurationsdateien, Trainingsprotokolle und Diagramme. Alle relevanten Informationen für dieses Modell müssen von dieser Methode behandelt werden.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> sind besonders wichtig, um Ihr Modell zu beschreiben. Weitere Details finden Sie in <a href="./model-cards">unserem Implementierungsleitfaden</a>.</li> <li>[~ModelHubMixin._from_pretrained]: <strong>Klassenmethode</strong>, die als Eingabe eine <code>model_id</code> nimmt und ein instanziiertes Modell zurückgibt. Die Methode muss die relevanten Dateien herunterladen und laden.</li></ul></li> <li>Sie sind fertig!</li>`,xe,X,_l="Der Vorteil der Verwendung von <code>ModelHubMixin</code> besteht darin, dass Sie, sobald Sie sich um die Serialisierung/das Laden der Dateien gekümmert haben, bereit sind los zu legen. Sie müssen sich keine Gedanken über Dinge wie Repository-Erstellung, Commits, PRs oder Revisionen machen. All dies wird von dem Mixin gehandhabt und steht Ihren Benutzern zur Verfügung. Das Mixin stellt auch sicher, dass öffentliche Methoden gut dokumentiert und typisiert sind.",$e,N,Re,Y,Bl="Ein gutes Beispiel für das, was wir oben gesehen haben, ist <code>PyTorchModelHubMixin</code>, unsere Integration für das PyTorch-Framework. Dies ist eine einsatzbereite Integration.",Fe,D,Le,P,vl="Hier ist, wie jeder Benutzer ein PyTorch-Modell vom/auf den Hub laden/speichern kann:",Qe,K,Xe,q,Ne,O,Zl='Die Implementierung ist tatsächlich sehr einfach, und die vollständige Implementierung finden Sie <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">hier</a>.',Ye,ee,Al="<li>Zuerst, erben Ihrer Klasse von <code>ModelHubMixin</code>:</li>",De,le,Pe,w,Wl="<li>Implementieren der <code>_save_pretrained</code> Methode:</li>",Ke,ne,qe,b,Gl="<li>Implementieren der <code>_from_pretrained</code> Methode:</li>",Oe,te,el,se,zl="Und das war’s! Ihre Bibliothek ermöglicht es Benutzern nun, Dateien vom und zum Hub hoch- und herunterzuladen.",ll,ie,nl,ae,El="Lassen Sie uns die beiden Ansätze, die wir gesehen haben, schnell mit ihren Vor- und Nachteilen zusammenfassen. Die untenstehende Tabelle ist nur indikativ. Ihr Framework könnte einige Besonderheiten haben, die Sie berücksichtigen müssen. Dieser Leitfaden soll nur Richtlinien und Ideen geben, wie Sie die Integration handhaben können. Kontaktieren Sie uns in jedem Fall, wenn Sie Fragen haben!",tl,Me,Hl='<thead><tr><th align="center">Integration</th> <th align="center">Mit Helfern</th> <th align="center">Mit <code>ModelHubMixin</code></th></tr></thead> <tbody><tr><td align="center">Benutzererfahrung</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibilität</td> <td align="center">Sehr flexibel.<br/>Sie haben die volle Kontrolle über die Implementierung.</td> <td align="center">Weniger flexibel.<br/>Ihr Framework muss eine Modellklasse haben.</td></tr> <tr><td align="center">Wartung</td> <td align="center">Mehr Wartung, um Unterstützung für Konfiguration und neue Funktionen hinzuzufügen. Könnte auch das Beheben von Benutzerproblemen erfordern.</td> <td align="center">Weniger Wartung, da die meisten Interaktionen mit dem Hub in <code>huggingface_hub</code> implementiert sind.</td></tr> <tr><td align="center">Dokumentation/Typ-Annotation</td> <td align="center">Manuell zu schreiben.</td> <td align="center">Teilweise durch <code>huggingface_hub</code> behandelt.</td></tr></tbody>',sl,re,il,pe,al;return j=new u({props:{title:"Integrieren Sie jedes ML-Framework mit dem Hub",local:"integrieren-sie-jedes-ml-framework-mit-dem-hub",headingTag:"h1"}}),g=new u({props:{title:"Ein flexibler Ansatz: Helfer",local:"ein-flexibler-ansatz-helfer",headingTag:"h2"}}),_=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),v=new de({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjB2b20lMjBIdWIlMjBoZXJ1bnRlcmxhZGVuJTBBJTIwJTIwJTIwY2FjaGVkX21vZGVsJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJtb2RlbC5wa2wlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X25hbWUlM0QlMjJmYXN0YWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X3ZlcnNpb24lM0RnZXRfZmFzdGFpX3ZlcnNpb24oKSUyQyUwQSUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjBsYWRlbiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvYWRfbW9kZWwoY2FjaGVkX21vZGVsKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Modell vom Hub herunterladen</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Modell laden</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),Z=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),W=new de({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwUmVwbyUyMGVyc3RlbGxlbiUyQyUyMHdlbm4lMjBub2NoJTIwbmljaHQlMjB2b3JoYW5kZW4lMjB1bmQlMjBkaWUlMjB6dWdlaCVDMyVCNnJpZ2UlMjByZXBvX2lkJTIwZXJoYWx0ZW4lMEElMjAlMjAlMjByZXBvX2lkJTIwJTNEJTIwYXBpLmNyZWF0ZV9yZXBvKHJlcG9fbmFtZSUyQyUyMGV4aXN0X29rJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjBpbiUyMHRlbXBvciVDMyVBNHJlbSUyME9yZG5lciUyMHNwZWljaGVybiUyMHVuZCUyMGluJTIwZWluZW0lMjBlbnppZ2VuJTIwQ29tbWl0JTIwcHVzaGVuJTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZXdpY2h0ZSUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNb2RlbGxrYXJ0ZSUyMGdlbmVyaWVyZW4lMEElMjAlMjAlMjAlMjAlMjAlMjBjYXJkJTIwJTNEJTIwZ2VuZXJhdGVfbW9kZWxfY2FyZChtb2RlbCklMEElMjAlMjAlMjAlMjAlMjAlMjAodG1wZGlyJTIwJTJGJTIwJTIyUkVBRE1FLm1kJTIyKS53cml0ZV90ZXh0KGNhcmQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9ncyUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERpYWdyYW1tZSUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEV2YWx1YXRpb25zbWV0cmlrZW4lMjBzcGVpY2hlcm4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBdWYlMjBkZW4lMjBIdWIlMjBwdXNoZW4lMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhcGkudXBsb2FkX2ZvbGRlcihyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZvbGRlcl9wYXRoJTNEdG1wZGlyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Repo erstellen, wenn noch nicht vorhanden und die zugehörige repo_id erhalten</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Modell in temporärem Ordner speichern und in einem enzigen Commit pushen</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Gewichte speichern</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Modellkarte generieren</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Logs speichern</span>
      <span class="hljs-comment"># Diagramme speichern</span>
      <span class="hljs-comment"># Evaluationsmetriken speichern</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Auf den Hub pushen</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),z=new u({props:{title:"Einschränkungen",local:"einschränkungen",headingTag:"h3"}}),$=new u({props:{title:"Ein komplexerer Ansatz: Klassenvererbung",local:"ein-komplexerer-ansatz-klassenvererbung",headingTag:"h2"}}),N=new u({props:{title:"Ein konkretes Beispiel: PyTorch",local:"ein-konkretes-beispiel-pytorch",headingTag:"h3"}}),D=new u({props:{title:"Wie verwendet man es?",local:"wie-verwendet-man-es",headingTag:"h4"}}),K=new de({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwTWVocmZhY2h2ZXJlcmJ1bmclMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGFyYW0lMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCgzJTJDJTIwNCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIoNCUyQyUyMDUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmxpbmVhcih4JTIwJTJCJTIwc2VsZi5wYXJhbSklMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Definieren Sie Ihr Pytorch-Modell genau so, wie Sie es gewohnt sind</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># Mehrfachvererbung</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optional) Modell in lokales Verzeichnis speichern</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Modellgewichte an den Hub übertragen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Modell vom Hub initialisieren</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),q=new u({props:{title:"Implementierung",local:"implementierung",headingTag:"h4"}}),le=new de({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),ne=new de({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJpZXJlJTIwTW9kZWxsa2FydGUlMjB1bmQlMjBzcGVpY2hlcmUlMjBHZXdpY2h0ZSUyMHZvbiUyMGVpbmVtJTIwUHl0b3JjaC1Nb2RlbGwlMjBpbiUyMGVpbmVtJTIwbG9rYWxlbiUyMFZlcnplaWNobmlzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2NhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXJkX2RhdGElM0RNb2RlbENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfc3VtbWFyeSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX3R5cGUlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwJTIyUkVBRE1FLm1kJTIyKS53cml0ZV90ZXh0KHN0cihtb2RlbCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc2F2ZShvYmolM0RzZWxmLm1vZHVsZS5zdGF0ZV9kaWN0KCklMkMlMjBmJTNEc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Generiere Modellkarte und speichere Gewichte von einem Pytorch-Modell in einem lokalen Verzeichnis.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),te=new de({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Muss eine Klassenmethode sein!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># zusätzliches Argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># zusätzliches Argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Kann entweder ein lokales Verzeichnis sein</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Oder ein Modell am Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Herunterladen vom Hub, gleiche Eingabeargumente</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Modell laden und zurückgeben - benutzerdefinierte Logik je nach Ihrem Framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ie=new u({props:{title:"Kurzer Vergleich",local:"kurzer-vergleich",headingTag:"h2"}}),re=new Xl({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/integrations.md"}}),{c(){y=a("meta"),he=s(),oe=a("p"),me=s(),d(j.$$.fragment),ce=s(),T=a("p"),T.innerHTML=dl,ue=s(),J=a("p"),J.textContent=ol,ye=s(),U=a("ol"),U.innerHTML=pl,we=s(),f=a("p"),f.textContent=hl,be=s(),I=a("p"),I.innerHTML=ml,je=s(),d(g.$$.fragment),Te=s(),C=a("p"),C.innerHTML=cl,Je=s(),k=a("p"),k.textContent=ul,Ue=s(),d(_.$$.fragment),fe=s(),B=a("p"),B.innerHTML=yl,Ie=s(),d(v.$$.fragment),ge=s(),d(Z.$$.fragment),Ce=s(),A=a("p"),A.innerHTML=wl,ke=s(),d(W.$$.fragment),_e=s(),G=a("p"),G.innerHTML=bl,Be=s(),d(z.$$.fragment),ve=s(),E=a("p"),E.innerHTML=jl,Ze=s(),H=a("ul"),H.innerHTML=Tl,Ae=s(),V=a("p"),V.textContent=Jl,We=s(),S=a("ul"),S.innerHTML=Ul,Ge=s(),x=a("p"),x.innerHTML=fl,ze=s(),d($.$$.fragment),Ee=s(),R=a("p"),R.innerHTML=Il,He=s(),F=a("p"),F.innerHTML=gl,Ve=s(),L=a("p"),L.innerHTML=Cl,Se=s(),Q=a("ol"),Q.innerHTML=kl,xe=s(),X=a("p"),X.innerHTML=_l,$e=s(),d(N.$$.fragment),Re=s(),Y=a("p"),Y.innerHTML=Bl,Fe=s(),d(D.$$.fragment),Le=s(),P=a("p"),P.textContent=vl,Qe=s(),d(K.$$.fragment),Xe=s(),d(q.$$.fragment),Ne=s(),O=a("p"),O.innerHTML=Zl,Ye=s(),ee=a("ol"),ee.innerHTML=Al,De=s(),d(le.$$.fragment),Pe=s(),w=a("ol"),w.innerHTML=Wl,Ke=s(),d(ne.$$.fragment),qe=s(),b=a("ol"),b.innerHTML=Gl,Oe=s(),d(te.$$.fragment),el=s(),se=a("p"),se.textContent=zl,ll=s(),d(ie.$$.fragment),nl=s(),ae=a("p"),ae.textContent=El,tl=s(),Me=a("table"),Me.innerHTML=Hl,sl=s(),d(re.$$.fragment),il=s(),pe=a("p"),this.h()},l(e){const l=Ll("svelte-u9bgzb",document.head);y=M(l,"META",{name:!0,content:!0}),l.forEach(n),he=i(e),oe=M(e,"P",{}),Vl(oe).forEach(n),me=i(e),o(j.$$.fragment,e),ce=i(e),T=M(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1uv5xno"&&(T.innerHTML=dl),ue=i(e),J=M(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1wuvm32"&&(J.textContent=ol),ye=i(e),U=M(e,"OL",{"data-svelte-h":!0}),r(U)!=="svelte-18hrhsl"&&(U.innerHTML=pl),we=i(e),f=M(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-18fkufj"&&(f.textContent=hl),be=i(e),I=M(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1iwhhmw"&&(I.innerHTML=ml),je=i(e),o(g.$$.fragment,e),Te=i(e),C=M(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-d1foe8"&&(C.innerHTML=cl),Je=i(e),k=M(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1v7bx6l"&&(k.textContent=ul),Ue=i(e),o(_.$$.fragment,e),fe=i(e),B=M(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1m7ctz2"&&(B.innerHTML=yl),Ie=i(e),o(v.$$.fragment,e),ge=i(e),o(Z.$$.fragment,e),Ce=i(e),A=M(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-12y5xmc"&&(A.innerHTML=wl),ke=i(e),o(W.$$.fragment,e),_e=i(e),G=M(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-calp58"&&(G.innerHTML=bl),Be=i(e),o(z.$$.fragment,e),ve=i(e),E=M(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-bl4t77"&&(E.innerHTML=jl),Ze=i(e),H=M(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-knqj8g"&&(H.innerHTML=Tl),Ae=i(e),V=M(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1lnppi9"&&(V.textContent=Jl),We=i(e),S=M(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-q0zixo"&&(S.innerHTML=Ul),Ge=i(e),x=M(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-w69vgv"&&(x.innerHTML=fl),ze=i(e),o($.$$.fragment,e),Ee=i(e),R=M(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1kz5ea2"&&(R.innerHTML=Il),He=i(e),F=M(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-d3dywx"&&(F.innerHTML=gl),Ve=i(e),L=M(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-18mc3qm"&&(L.innerHTML=Cl),Se=i(e),Q=M(e,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-l8lpe8"&&(Q.innerHTML=kl),xe=i(e),X=M(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-116c8ma"&&(X.innerHTML=_l),$e=i(e),o(N.$$.fragment,e),Re=i(e),Y=M(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1macysc"&&(Y.innerHTML=Bl),Fe=i(e),o(D.$$.fragment,e),Le=i(e),P=M(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1el4w9u"&&(P.textContent=vl),Qe=i(e),o(K.$$.fragment,e),Xe=i(e),o(q.$$.fragment,e),Ne=i(e),O=M(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-oavmpb"&&(O.innerHTML=Zl),Ye=i(e),ee=M(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-zz071o"&&(ee.innerHTML=Al),De=i(e),o(le.$$.fragment,e),Pe=i(e),w=M(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-8qqg6p"&&(w.innerHTML=Wl),Ke=i(e),o(ne.$$.fragment,e),qe=i(e),b=M(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-1tllved"&&(b.innerHTML=Gl),Oe=i(e),o(te.$$.fragment,e),el=i(e),se=M(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-13k5c2u"&&(se.textContent=zl),ll=i(e),o(ie.$$.fragment,e),nl=i(e),ae=M(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1mc7cfl"&&(ae.textContent=El),tl=i(e),Me=M(e,"TABLE",{"data-svelte-h":!0}),r(Me)!=="svelte-1or8grg"&&(Me.innerHTML=Hl),sl=i(e),o(re.$$.fragment,e),il=i(e),pe=M(e,"P",{}),Vl(pe).forEach(n),this.h()},h(){Ml(y,"name","hf:doc:metadata"),Ml(y,"content",Yl),Ml(w,"start","2"),Ml(b,"start","3")},m(e,l){Ql(document.head,y),t(e,he,l),t(e,oe,l),t(e,me,l),p(j,e,l),t(e,ce,l),t(e,T,l),t(e,ue,l),t(e,J,l),t(e,ye,l),t(e,U,l),t(e,we,l),t(e,f,l),t(e,be,l),t(e,I,l),t(e,je,l),p(g,e,l),t(e,Te,l),t(e,C,l),t(e,Je,l),t(e,k,l),t(e,Ue,l),p(_,e,l),t(e,fe,l),t(e,B,l),t(e,Ie,l),p(v,e,l),t(e,ge,l),p(Z,e,l),t(e,Ce,l),t(e,A,l),t(e,ke,l),p(W,e,l),t(e,_e,l),t(e,G,l),t(e,Be,l),p(z,e,l),t(e,ve,l),t(e,E,l),t(e,Ze,l),t(e,H,l),t(e,Ae,l),t(e,V,l),t(e,We,l),t(e,S,l),t(e,Ge,l),t(e,x,l),t(e,ze,l),p($,e,l),t(e,Ee,l),t(e,R,l),t(e,He,l),t(e,F,l),t(e,Ve,l),t(e,L,l),t(e,Se,l),t(e,Q,l),t(e,xe,l),t(e,X,l),t(e,$e,l),p(N,e,l),t(e,Re,l),t(e,Y,l),t(e,Fe,l),p(D,e,l),t(e,Le,l),t(e,P,l),t(e,Qe,l),p(K,e,l),t(e,Xe,l),p(q,e,l),t(e,Ne,l),t(e,O,l),t(e,Ye,l),t(e,ee,l),t(e,De,l),p(le,e,l),t(e,Pe,l),t(e,w,l),t(e,Ke,l),p(ne,e,l),t(e,qe,l),t(e,b,l),t(e,Oe,l),p(te,e,l),t(e,el,l),t(e,se,l),t(e,ll,l),p(ie,e,l),t(e,nl,l),t(e,ae,l),t(e,tl,l),t(e,Me,l),t(e,sl,l),p(re,e,l),t(e,il,l),t(e,pe,l),al=!0},p:xl,i(e){al||(h(j.$$.fragment,e),h(g.$$.fragment,e),h(_.$$.fragment,e),h(v.$$.fragment,e),h(Z.$$.fragment,e),h(W.$$.fragment,e),h(z.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(q.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),al=!0)},o(e){m(j.$$.fragment,e),m(g.$$.fragment,e),m(_.$$.fragment,e),m(v.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),m($.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),al=!1},d(e){e&&(n(he),n(oe),n(me),n(ce),n(T),n(ue),n(J),n(ye),n(U),n(we),n(f),n(be),n(I),n(je),n(Te),n(C),n(Je),n(k),n(Ue),n(fe),n(B),n(Ie),n(ge),n(Ce),n(A),n(ke),n(_e),n(G),n(Be),n(ve),n(E),n(Ze),n(H),n(Ae),n(V),n(We),n(S),n(Ge),n(x),n(ze),n(Ee),n(R),n(He),n(F),n(Ve),n(L),n(Se),n(Q),n(xe),n(X),n($e),n(Re),n(Y),n(Fe),n(Le),n(P),n(Qe),n(Xe),n(Ne),n(O),n(Ye),n(ee),n(De),n(Pe),n(w),n(Ke),n(qe),n(b),n(Oe),n(el),n(se),n(ll),n(nl),n(ae),n(tl),n(Me),n(sl),n(il),n(pe)),n(y),c(j,e),c(g,e),c(_,e),c(v,e),c(Z,e),c(W,e),c(z,e),c($,e),c(N,e),c(D,e),c(K,e),c(q,e),c(le,e),c(ne,e),c(te,e),c(ie,e),c(re,e)}}}const Yl='{"title":"Integrieren Sie jedes ML-Framework mit dem Hub","local":"integrieren-sie-jedes-ml-framework-mit-dem-hub","sections":[{"title":"Ein flexibler Ansatz: Helfer","local":"ein-flexibler-ansatz-helfer","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Einschränkungen","local":"einschränkungen","sections":[],"depth":3}],"depth":2},{"title":"Ein komplexerer Ansatz: Klassenvererbung","local":"ein-komplexerer-ansatz-klassenvererbung","sections":[{"title":"Ein konkretes Beispiel: PyTorch","local":"ein-konkretes-beispiel-pytorch","sections":[{"title":"Wie verwendet man es?","local":"wie-verwendet-man-es","sections":[],"depth":4},{"title":"Implementierung","local":"implementierung","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Kurzer Vergleich","local":"kurzer-vergleich","sections":[],"depth":2}],"depth":1}';function Dl(rl){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends Rl{constructor(y){super(),Fl(this,y,Dl,Nl,Sl,{})}}export{en as component};
