import{s as Na,o as Ya,n as Ra}from"../chunks/scheduler.6062bdaf.js";import{S as Ea,i as Sa,g as p,s as e,r as c,A as La,h as o,f as t,c as l,j as Qa,u as r,x as i,k as Ba,y as Va,a as n,v as h,d as u,t as m,w as g}from"../chunks/index.4bca734e.js";import{T as Pa}from"../chunks/Tip.b9ac1f03.js";import{C as j}from"../chunks/CodeBlock.cbbddafc.js";import{H as us,E as Xa}from"../chunks/getInferenceSnippets.b564dd8b.js";function Fa(ys){let y,b='<strong>Hugging Face Jobs</strong> are available only to <a href="https://huggingface.co/pro" rel="nofollow">Pro users</a> and <a href="https://huggingface.co/enterprise" rel="nofollow">Team or Enterprise organizations</a>. Upgrade your plan to get started!';return{c(){y=p("p"),y.innerHTML=b},l(M){y=o(M,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1esirrz"&&(y.innerHTML=b)},m(M,ms){n(M,y,ms)},p:Ra,d(M){M&&t(y)}}}function za(ys){let y,b,M,ms,f,js,U,ra=`The Hugging Face Hub provides compute for AI and data workflows via Jobs.
A job runs on Hugging Face infrastructure and are defined with a command to run (e.g. a python command), a Docker Image from Hugging Face Spaces or Docker Hub, and a hardware flavor (CPU, GPU, TPU). This guide will show you how to interact with Jobs on the Hub, especially:`,Ms,J,ha="<li>Run a job.</li> <li>Check job status.</li> <li>Select the hardware.</li> <li>Configure environment variables and secrets.</li> <li>Run UV scripts.</li>",ds,w,ua=`If you want to run and manage a job on the Hub, your machine must be logged in. If you are not, please refer to
<a href="../quick-start#authentication">this section</a>. In the rest of this guide, we will assume that your machine is logged in.`,bs,d,fs,T,Us,C,ma='Use the <a href="./cli#hf-jobs"><code>hf jobs</code> CLI</a> to run Jobs from the command line, and pass <code>--flavor</code> to specify your hardware.',Js,I,ga="<code>hf jobs run</code> runs Jobs with a Docker image and a command with a familiar Docker-like interface. Think <code>docker run</code>, but for running code on any hardware:",ws,_,Ts,v,ya="Use <code>hf jobs uv run</code> to run local or remote UV scripts:",Cs,$,Is,q,ja='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax defined in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',_s,G,Ma=`Now the rest of this guide will show you the python API.
If you would like to view all the available <code>hf jobs</code> commands and options instead, check out the <a href="./cli#hf-jobs">guide on the <code>hf jobs</code> command line interface</a>.`,vs,x,$s,k,da="Run compute Jobs defined with a command and a Docker Image on Hugging Face infrastructure (including GPUs and TPUs).",qs,W,ba=`You can only manage Jobs that you own (under your username namespace) or from organizations in which you have write permissions.
This feature is pay-as-you-go: you only pay for the seconds you use.`,Gs,Z,fa='<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> lets you run any command on Hugging Face’s infrastructure:',xs,H,ks,Q,Ua=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> returns the <a href="/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobInfo">JobInfo</a> which has the URL of the Job on Hugging Face, where you can see the Job status and the logs.
Save the Job ID from <a href="/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobInfo">JobInfo</a> to manage the job:`,Ws,B,Zs,N,Ja='Jobs run in the background. The next section guides you through <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job">inspect_job()</a> to know a jobs’ status and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.fetch_job_logs">fetch_job_logs()</a> to view the logs.',Hs,Y,Qs,R,Bs,E,wa='Check the status of multiple jobs to know when they’re all finished using a loop and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job">inspect_job()</a>:',Ns,S,Ys,L,Rs,V,Ta="There are numerous cases where running Jobs on GPUs are useful:",Es,P,Ca="<li><strong>Model Training</strong>: Fine-tune or train models on GPUs (T4, A10G, A100) without managing infrastructure</li> <li><strong>Synthetic Data Generation</strong>: Generate large-scale datasets using LLMs on powerful hardware</li> <li><strong>Data Processing</strong>: Process massive datasets with high-CPU configurations for parallel workloads</li> <li><strong>Batch Inference</strong>: Run offline inference on thousands of samples using optimized GPU setups</li> <li><strong>Experiments &amp; Benchmarks</strong>: Run ML experiments on consistent hardware for reproducible results</li> <li><strong>Development &amp; Debugging</strong>: Test GPU code without local CUDA setup</li>",Ss,X,Ia="Run jobs on GPUs or TPUs with the <code>flavor</code> argument. For example, to run a PyTorch job on an A10G GPU:",Ls,F,Vs,z,_a="Running this will show the following output!",Ps,A,Xs,K,va='Use this to run a fine tuning script like <a href="https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py" rel="nofollow">trl/scripts/sft.py</a> with UV:',Fs,D,zs,O,$a="Available <code>flavor</code> options:",As,ss,qa="<li>CPU: <code>cpu-basic</code>, <code>cpu-upgrade</code></li> <li>GPU: <code>t4-small</code>, <code>t4-medium</code>, <code>l4x1</code>, <code>l4x4</code>, <code>a10g-small</code>, <code>a10g-large</code>, <code>a10g-largex2</code>, <code>a10g-largex4</code>,<code>a100-large</code></li> <li>TPU: <code>v5e-1x1</code>, <code>v5e-2x2</code>, <code>v5e-2x4</code></li>",Ks,as,Ga='(updated in 07/2025 from Hugging Face <a href="https://huggingface.co/docs/hub/en/spaces-config-reference" rel="nofollow">suggested_hardware docs</a>)',Ds,ts,xa="That’s it! You’re now running code on Hugging Face’s infrastructure.",Os,ns,sa,es,ka="You can pass environment variables to your job using <code>env</code> and <code>secrets</code>:",aa,ls,ta,ps,na,os,ea,is,Wa="Run UV scripts (Python scripts with inline dependencies) on HF infrastructure:",la,cs,pa,rs,Za='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax. This makes them perfect for self-contained tasks that don’t require complex project setups. Learn more about UV scripts in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',oa,hs,ia,gs,ca;return f=new us({props:{title:"Run and manage Jobs",local:"run-and-manage-jobs",headingTag:"h1"}}),d=new Pa({props:{$$slots:{default:[Fa]},$$scope:{ctx:ys}}}),T=new us({props:{title:"Jobs Command Line Interface",local:"jobs-command-line-interface",headingTag:"h2"}}),_=new j({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMTIlMjAtYyUyMCUyMnByaW50KCdIZWxsbyUyMHdvcmxkIScpJTIyJTBBaGYlMjBqb2JzJTIwcnVuJTIwLS1mbGF2b3IlMjBhMTBnLXNtYWxsJTIwcHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjBweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQodG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSklMjI=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:12 -c <span class="hljs-string">&quot;print(&#x27;Hello world!&#x27;)&quot;</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>`,wrap:!1}}),$=new j({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjBteV9zY3JpcHQucHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMC0tZmxhdm9yJTIwYTEwZy1zbWFsbCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJsJTJGbWFpbiUyRnRybCUyRnNjcmlwdHMlMkZzZnQucHklMjIlMjA=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --flavor a10g-small <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> `,wrap:!1}}),x=new us({props:{title:"Run a Job",local:"run-a-job",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdIZWxsbyUyMGZyb20lMjB0aGUlMjBjbG91ZCEnKSUyMiU1RCUyQyUwQSklMEElMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCkpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSklMEElMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdSdW5uaW5nJTIwaW4lMjBhbiUyMG9yZyUyMGFjY291bnQnKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG5hbWVzcGFjZSUzRCUyMm15LW9yZy1uYW1lJTIyJTJDJTBBKSUwQSUwQXJ1bl9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJoZi5jbyUyRnNwYWNlcyUyRmxob2VzdHElMkZkdWNrZGIlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIyZHVja2RiJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJzZWxlY3QlMjAnaGVsbG8lMjB3b3JsZCclMjIlNUQlMkMlMEEpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMik=",highlighted:`<span class="hljs-comment"># Directly run Python code</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Use GPUs without any setup</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run in an organization account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Running in an org account&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    namespace=<span class="hljs-string">&quot;my-org-name&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run from Hugging Face Spaces</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;hf.co/spaces/lhoestq/duckdb&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;duckdb&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;select &#x27;hello world&#x27;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run a Python script with \`uv\` (experimental)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>)`,wrap:!1}}),B=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdIZWxsbyUyMGZyb20lMjB0aGUlMjBjbG91ZCEnKSUyMiU1RCUwQSklMEFqb2IudXJsJTBBam9iLmlk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>job.url
https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a
<span class="hljs-meta">&gt;&gt;&gt; </span>job.<span class="hljs-built_in">id</span>
687f911eaea852de79c4a50a`,wrap:!1}}),Y=new us({props:{title:"Check Job status",local:"check-job-status",headingTag:"h2"}}),R=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfam9icyUwQWpvYnMlMjAlM0QlMjBsaXN0X2pvYnMoKSUwQWpvYnMlNUIwJTVEJTBBJTBBcnVubmluZ19qb2JzJTIwJTNEJTIwJTVCam9iJTIwZm9yJTIwam9iJTIwaW4lMjBsaXN0X2pvYnMoKSUyMGlmJTIwam9iLnN0YXR1cy5zdGFnZSUyMCUzRCUzRCUyMCUyMlJVTk5JTkclMjIlNUQlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwaW5zcGVjdF9qb2IlMEFpbnNwZWN0X2pvYihqb2JfaWQlM0Rqb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZldGNoX2pvYl9sb2dzJTBBZm9yJTIwbG9nJTIwaW4lMjBmZXRjaF9qb2JfbG9ncyhqb2JfaWQlM0Rqb2JfaWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobG9nKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjYW5jZWxfam9iJTBBY2FuY2VsX2pvYihqb2JfaWQlM0Rqb2JfaWQp",highlighted:`<span class="hljs-comment"># List your jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_jobs
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs = list_jobs()
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs[<span class="hljs-number">0</span>]
JobInfo(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;687f911eaea852de79c4a50a&#x27;</span>, created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">22</span>, <span class="hljs-number">13</span>, <span class="hljs-number">24</span>, <span class="hljs-number">46</span>, <span class="hljs-number">909000</span>, tzinfo=datetime.timezone.utc), docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>, space_id=<span class="hljs-literal">None</span>, command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>], arguments=[], environment={}, secrets={}, flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>, status=JobStatus(stage=<span class="hljs-string">&#x27;COMPLETED&#x27;</span>, message=<span class="hljs-literal">None</span>), owner=JobOwner(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;5e9ecfc04957053f60648a3e&#x27;</span>, name=<span class="hljs-string">&#x27;lhoestq&#x27;</span>), endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, url=<span class="hljs-string">&#x27;https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a&#x27;</span>)

<span class="hljs-comment"># List your running jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>running_jobs = [job <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> list_jobs() <span class="hljs-keyword">if</span> job.status.stage == <span class="hljs-string">&quot;RUNNING&quot;</span>]

<span class="hljs-comment"># Inspect the status of a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_job(job_id=job_id)
JobInfo(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;687f911eaea852de79c4a50a&#x27;</span>, created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">22</span>, <span class="hljs-number">13</span>, <span class="hljs-number">24</span>, <span class="hljs-number">46</span>, <span class="hljs-number">909000</span>, tzinfo=datetime.timezone.utc), docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>, space_id=<span class="hljs-literal">None</span>, command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>], arguments=[], environment={}, secrets={}, flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>, status=JobStatus(stage=<span class="hljs-string">&#x27;COMPLETED&#x27;</span>, message=<span class="hljs-literal">None</span>), owner=JobOwner(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;5e9ecfc04957053f60648a3e&#x27;</span>, name=<span class="hljs-string">&#x27;lhoestq&#x27;</span>), endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, url=<span class="hljs-string">&#x27;https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a&#x27;</span>)

<span class="hljs-comment"># View logs from a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> fetch_job_logs
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job_id=job_id):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(log)
Hello <span class="hljs-keyword">from</span> the cloud!

<span class="hljs-comment"># Cancel a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cancel_job
<span class="hljs-meta">&gt;&gt;&gt; </span>cancel_job(job_id=job_id)`,wrap:!1}}),S=new j({props:{code:"aW1wb3J0JTIwdGltZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBpbnNwZWN0X2pvYiUyQyUyMHJ1bl9qb2IlMEFqb2JzJTIwJTNEJTIwJTVCcnVuX2pvYihpbWFnZSUzRGltYWdlJTJDJTIwY29tbWFuZCUzRGNvbW1hbmQpJTIwZm9yJTIwY29tbWFuZCUyMGluJTIwY29tbWFuZHMlNUQlMEFmb3IlMjBqb2IlMjBpbiUyMGpvYnMlM0ElMEElMjAlMjAlMjAlMjB3aGlsZSUyMGluc3BlY3Rfam9iKGpvYl9pZCUzRGpvYi5pZCkuc3RhdHVzLnN0YWdlJTIwbm90JTIwaW4lMjAoJTIyQ09NUExFVEVEJTIyJTJDJTIwJTIyRVJST1IlMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZS5zbGVlcCgxMCk=",highlighted:`<span class="hljs-comment"># Run multiple jobs in parallel and wait for their completions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs = [run_job(image=image, command=command) <span class="hljs-keyword">for</span> command <span class="hljs-keyword">in</span> commands]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> inspect_job(job_id=job.<span class="hljs-built_in">id</span>).status.stage <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> (<span class="hljs-string">&quot;COMPLETED&quot;</span>, <span class="hljs-string">&quot;ERROR&quot;</span>):
<span class="hljs-meta">... </span>        time.sleep(<span class="hljs-number">10</span>)`,wrap:!1}}),L=new us({props:{title:"Select the hardware",local:"select-the-hardware",headingTag:"h2"}}),F=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KGYnVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCcpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Use an A10G GPU to check PyTorch CUDA</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&#x27;This code ran with the following GPU: {torch.cuda.get_device_name()}&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),A=new j({props:{code:"VGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwTlZJRElBJTIwQTEwRw==",highlighted:"This code ran with the following GPU: NVIDIA A10G",wrap:!1}}),D=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUwQSUyMCUyMCUyMCUyMCUyMnNmdC5weSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjcmlwdF9hcmdzJTNEJTVCJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjAlMjJRd2VuJTJGUXdlbjItMC41QiUyMiUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMnRybCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMkhGX1RPS0VOJTIyJTNBJTIwLi4uJTdEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sft.py&quot;</span>,
<span class="hljs-meta">... </span>    script_args=[<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, ...],
<span class="hljs-meta">... </span>    dependencies=[<span class="hljs-string">&quot;trl&quot;</span>],
<span class="hljs-meta">... </span>    env={<span class="hljs-string">&quot;HF_TOKEN&quot;</span>: ...},
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ns=new us({props:{title:"Pass Environment variables and Secrets",local:"pass-environment-variables-and-secrets",headingTag:"h2"}}),ls=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidGT08nJTVEJTJDJTIwb3MuZW52aXJvbiU1QidCQVInJTVEKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMkZPTyUyMiUzQSUyMCUyMmZvbyUyMiUyQyUyMCUyMkJBUiUyMiUzQSUyMCUyMmJhciUyMiU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Pass environment variables</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>],
<span class="hljs-meta">... </span>    env={<span class="hljs-string">&quot;FOO&quot;</span>: <span class="hljs-string">&quot;foo&quot;</span>, <span class="hljs-string">&quot;BAR&quot;</span>: <span class="hljs-string">&quot;bar&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),ps=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidNWV9TRUNSRVQnJTVEKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVQlMjIlM0ElMjAlMjJwc3N3cmQlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-comment"># Pass secrets - they will be encrypted server side</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>],
<span class="hljs-meta">... </span>    secrets={<span class="hljs-string">&quot;MY_SECRET&quot;</span>: <span class="hljs-string">&quot;psswrd&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),os=new us({props:{title:"UV Scripts (Experimental)",local:"uv-scripts-experimental",headingTag:"h3"}}),cs=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMiklMEElMEFydW5fdXZfam9iKCUyMm1sX3RyYWluaW5nLnB5JTIyJTJDJTIwZmxhdm9yJTNEJTIyZ3B1LXQ0LXNtYWxsJTIyKSUwQSUwQXJ1bl91dl9qb2IoJTIyaW5mZXJlbmNlLnB5JTIyJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIydHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIydG9yY2glMjIlNUQpJTBBJTBBcnVuX3V2X2pvYiglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZ1c2VybmFtZSUyRnNjcmlwdHMlMkZyZXNvbHZlJTJGbWFpbiUyRmV4YW1wbGUucHklMjIp",highlighted:`<span class="hljs-comment"># Run a UV script (creates temporary repo)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>)

<span class="hljs-comment"># Run with GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;ml_training.py&quot;</span>, flavor=<span class="hljs-string">&quot;gpu-t4-small&quot;</span>)

<span class="hljs-comment"># Run with dependencies</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;inference.py&quot;</span>, dependencies=[<span class="hljs-string">&quot;transformers&quot;</span>, <span class="hljs-string">&quot;torch&quot;</span>])

<span class="hljs-comment"># Run a script directly from a URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;https://huggingface.co/datasets/username/scripts/resolve/main/example.py&quot;</span>)`,wrap:!1}}),hs=new Xa({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/jobs.md"}}),{c(){y=p("meta"),b=e(),M=p("p"),ms=e(),c(f.$$.fragment),js=e(),U=p("p"),U.textContent=ra,Ms=e(),J=p("ul"),J.innerHTML=ha,ds=e(),w=p("p"),w.innerHTML=ua,bs=e(),c(d.$$.fragment),fs=e(),c(T.$$.fragment),Us=e(),C=p("p"),C.innerHTML=ma,Js=e(),I=p("p"),I.innerHTML=ga,ws=e(),c(_.$$.fragment),Ts=e(),v=p("p"),v.innerHTML=ya,Cs=e(),c($.$$.fragment),Is=e(),q=p("p"),q.innerHTML=ja,_s=e(),G=p("p"),G.innerHTML=Ma,vs=e(),c(x.$$.fragment),$s=e(),k=p("p"),k.textContent=da,qs=e(),W=p("p"),W.textContent=ba,Gs=e(),Z=p("p"),Z.innerHTML=fa,xs=e(),c(H.$$.fragment),ks=e(),Q=p("p"),Q.innerHTML=Ua,Ws=e(),c(B.$$.fragment),Zs=e(),N=p("p"),N.innerHTML=Ja,Hs=e(),c(Y.$$.fragment),Qs=e(),c(R.$$.fragment),Bs=e(),E=p("p"),E.innerHTML=wa,Ns=e(),c(S.$$.fragment),Ys=e(),c(L.$$.fragment),Rs=e(),V=p("p"),V.textContent=Ta,Es=e(),P=p("ul"),P.innerHTML=Ca,Ss=e(),X=p("p"),X.innerHTML=Ia,Ls=e(),c(F.$$.fragment),Vs=e(),z=p("p"),z.textContent=_a,Ps=e(),c(A.$$.fragment),Xs=e(),K=p("p"),K.innerHTML=va,Fs=e(),c(D.$$.fragment),zs=e(),O=p("p"),O.innerHTML=$a,As=e(),ss=p("ul"),ss.innerHTML=qa,Ks=e(),as=p("p"),as.innerHTML=Ga,Ds=e(),ts=p("p"),ts.textContent=xa,Os=e(),c(ns.$$.fragment),sa=e(),es=p("p"),es.innerHTML=ka,aa=e(),c(ls.$$.fragment),ta=e(),c(ps.$$.fragment),na=e(),c(os.$$.fragment),ea=e(),is=p("p"),is.textContent=Wa,la=e(),c(cs.$$.fragment),pa=e(),rs=p("p"),rs.innerHTML=Za,oa=e(),c(hs.$$.fragment),ia=e(),gs=p("p"),this.h()},l(s){const a=La("svelte-u9bgzb",document.head);y=o(a,"META",{name:!0,content:!0}),a.forEach(t),b=l(s),M=o(s,"P",{}),Qa(M).forEach(t),ms=l(s),r(f.$$.fragment,s),js=l(s),U=o(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-t6wsly"&&(U.textContent=ra),Ms=l(s),J=o(s,"UL",{"data-svelte-h":!0}),i(J)!=="svelte-q7wdvs"&&(J.innerHTML=ha),ds=l(s),w=o(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-7cmlg1"&&(w.innerHTML=ua),bs=l(s),r(d.$$.fragment,s),fs=l(s),r(T.$$.fragment,s),Us=l(s),C=o(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-nb89vp"&&(C.innerHTML=ma),Js=l(s),I=o(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-khpb9d"&&(I.innerHTML=ga),ws=l(s),r(_.$$.fragment,s),Ts=l(s),v=o(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-2oc699"&&(v.innerHTML=ya),Cs=l(s),r($.$$.fragment,s),Is=l(s),q=o(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1jtgrvk"&&(q.innerHTML=ja),_s=l(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-o9zjjm"&&(G.innerHTML=Ma),vs=l(s),r(x.$$.fragment,s),$s=l(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-q7l5as"&&(k.textContent=da),qs=l(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1rskhba"&&(W.textContent=ba),Gs=l(s),Z=o(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1t6shks"&&(Z.innerHTML=fa),xs=l(s),r(H.$$.fragment,s),ks=l(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-pv8bt6"&&(Q.innerHTML=Ua),Ws=l(s),r(B.$$.fragment,s),Zs=l(s),N=o(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-amrg6a"&&(N.innerHTML=Ja),Hs=l(s),r(Y.$$.fragment,s),Qs=l(s),r(R.$$.fragment,s),Bs=l(s),E=o(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-7qiidc"&&(E.innerHTML=wa),Ns=l(s),r(S.$$.fragment,s),Ys=l(s),r(L.$$.fragment,s),Rs=l(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1egj941"&&(V.textContent=Ta),Es=l(s),P=o(s,"UL",{"data-svelte-h":!0}),i(P)!=="svelte-6zsta5"&&(P.innerHTML=Ca),Ss=l(s),X=o(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-14jm2jm"&&(X.innerHTML=Ia),Ls=l(s),r(F.$$.fragment,s),Vs=l(s),z=o(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-130z5ko"&&(z.textContent=_a),Ps=l(s),r(A.$$.fragment,s),Xs=l(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-s6s8yx"&&(K.innerHTML=va),Fs=l(s),r(D.$$.fragment,s),zs=l(s),O=o(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1hwnt8u"&&(O.innerHTML=$a),As=l(s),ss=o(s,"UL",{"data-svelte-h":!0}),i(ss)!=="svelte-13lveum"&&(ss.innerHTML=qa),Ks=l(s),as=o(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-2bse8c"&&(as.innerHTML=Ga),Ds=l(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-u6u7ww"&&(ts.textContent=xa),Os=l(s),r(ns.$$.fragment,s),sa=l(s),es=o(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-cxmn16"&&(es.innerHTML=ka),aa=l(s),r(ls.$$.fragment,s),ta=l(s),r(ps.$$.fragment,s),na=l(s),r(os.$$.fragment,s),ea=l(s),is=o(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-qbe5en"&&(is.textContent=Wa),la=l(s),r(cs.$$.fragment,s),pa=l(s),rs=o(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1dnltsa"&&(rs.innerHTML=Za),oa=l(s),r(hs.$$.fragment,s),ia=l(s),gs=o(s,"P",{}),Qa(gs).forEach(t),this.h()},h(){Ba(y,"name","hf:doc:metadata"),Ba(y,"content",Aa)},m(s,a){Va(document.head,y),n(s,b,a),n(s,M,a),n(s,ms,a),h(f,s,a),n(s,js,a),n(s,U,a),n(s,Ms,a),n(s,J,a),n(s,ds,a),n(s,w,a),n(s,bs,a),h(d,s,a),n(s,fs,a),h(T,s,a),n(s,Us,a),n(s,C,a),n(s,Js,a),n(s,I,a),n(s,ws,a),h(_,s,a),n(s,Ts,a),n(s,v,a),n(s,Cs,a),h($,s,a),n(s,Is,a),n(s,q,a),n(s,_s,a),n(s,G,a),n(s,vs,a),h(x,s,a),n(s,$s,a),n(s,k,a),n(s,qs,a),n(s,W,a),n(s,Gs,a),n(s,Z,a),n(s,xs,a),h(H,s,a),n(s,ks,a),n(s,Q,a),n(s,Ws,a),h(B,s,a),n(s,Zs,a),n(s,N,a),n(s,Hs,a),h(Y,s,a),n(s,Qs,a),h(R,s,a),n(s,Bs,a),n(s,E,a),n(s,Ns,a),h(S,s,a),n(s,Ys,a),h(L,s,a),n(s,Rs,a),n(s,V,a),n(s,Es,a),n(s,P,a),n(s,Ss,a),n(s,X,a),n(s,Ls,a),h(F,s,a),n(s,Vs,a),n(s,z,a),n(s,Ps,a),h(A,s,a),n(s,Xs,a),n(s,K,a),n(s,Fs,a),h(D,s,a),n(s,zs,a),n(s,O,a),n(s,As,a),n(s,ss,a),n(s,Ks,a),n(s,as,a),n(s,Ds,a),n(s,ts,a),n(s,Os,a),h(ns,s,a),n(s,sa,a),n(s,es,a),n(s,aa,a),h(ls,s,a),n(s,ta,a),h(ps,s,a),n(s,na,a),h(os,s,a),n(s,ea,a),n(s,is,a),n(s,la,a),h(cs,s,a),n(s,pa,a),n(s,rs,a),n(s,oa,a),h(hs,s,a),n(s,ia,a),n(s,gs,a),ca=!0},p(s,[a]){const Ha={};a&2&&(Ha.$$scope={dirty:a,ctx:s}),d.$set(Ha)},i(s){ca||(u(f.$$.fragment,s),u(d.$$.fragment,s),u(T.$$.fragment,s),u(_.$$.fragment,s),u($.$$.fragment,s),u(x.$$.fragment,s),u(H.$$.fragment,s),u(B.$$.fragment,s),u(Y.$$.fragment,s),u(R.$$.fragment,s),u(S.$$.fragment,s),u(L.$$.fragment,s),u(F.$$.fragment,s),u(A.$$.fragment,s),u(D.$$.fragment,s),u(ns.$$.fragment,s),u(ls.$$.fragment,s),u(ps.$$.fragment,s),u(os.$$.fragment,s),u(cs.$$.fragment,s),u(hs.$$.fragment,s),ca=!0)},o(s){m(f.$$.fragment,s),m(d.$$.fragment,s),m(T.$$.fragment,s),m(_.$$.fragment,s),m($.$$.fragment,s),m(x.$$.fragment,s),m(H.$$.fragment,s),m(B.$$.fragment,s),m(Y.$$.fragment,s),m(R.$$.fragment,s),m(S.$$.fragment,s),m(L.$$.fragment,s),m(F.$$.fragment,s),m(A.$$.fragment,s),m(D.$$.fragment,s),m(ns.$$.fragment,s),m(ls.$$.fragment,s),m(ps.$$.fragment,s),m(os.$$.fragment,s),m(cs.$$.fragment,s),m(hs.$$.fragment,s),ca=!1},d(s){s&&(t(b),t(M),t(ms),t(js),t(U),t(Ms),t(J),t(ds),t(w),t(bs),t(fs),t(Us),t(C),t(Js),t(I),t(ws),t(Ts),t(v),t(Cs),t(Is),t(q),t(_s),t(G),t(vs),t($s),t(k),t(qs),t(W),t(Gs),t(Z),t(xs),t(ks),t(Q),t(Ws),t(Zs),t(N),t(Hs),t(Qs),t(Bs),t(E),t(Ns),t(Ys),t(Rs),t(V),t(Es),t(P),t(Ss),t(X),t(Ls),t(Vs),t(z),t(Ps),t(Xs),t(K),t(Fs),t(zs),t(O),t(As),t(ss),t(Ks),t(as),t(Ds),t(ts),t(Os),t(sa),t(es),t(aa),t(ta),t(na),t(ea),t(is),t(la),t(pa),t(rs),t(oa),t(ia),t(gs)),t(y),g(f,s),g(d,s),g(T,s),g(_,s),g($,s),g(x,s),g(H,s),g(B,s),g(Y,s),g(R,s),g(S,s),g(L,s),g(F,s),g(A,s),g(D,s),g(ns,s),g(ls,s),g(ps,s),g(os,s),g(cs,s),g(hs,s)}}}const Aa='{"title":"Run and manage Jobs","local":"run-and-manage-jobs","sections":[{"title":"Jobs Command Line Interface","local":"jobs-command-line-interface","sections":[],"depth":2},{"title":"Run a Job","local":"run-a-job","sections":[],"depth":2},{"title":"Check Job status","local":"check-job-status","sections":[],"depth":2},{"title":"Select the hardware","local":"select-the-hardware","sections":[],"depth":2},{"title":"Pass Environment variables and Secrets","local":"pass-environment-variables-and-secrets","sections":[{"title":"UV Scripts (Experimental)","local":"uv-scripts-experimental","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ka(ys){return Ya(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Ea{constructor(y){super(),Sa(this,y,Ka,za,Na,{})}}export{nt as component};
