import{s as Jq,o as Eq,n as H}from"../chunks/scheduler.6062bdaf.js";import{S as Dq,i as Rq,g as c,s,r as u,A as Gq,h as l,f as p,c as r,j,u as h,x as d,k as q,y as n,a as $,v as f,d as m,t as _,w as b,m as Fq,n as Sq}from"../chunks/index.4bca734e.js";import{T as I}from"../chunks/Tip.b9ac1f03.js";import{D as M}from"../chunks/Docstring.b6251191.js";import{C as U}from"../chunks/CodeBlock.cbbddafc.js";import{E as C}from"../chunks/ExampleCodeBlock.8d71e6b1.js";import{H as J,E as Lq}from"../chunks/getInferenceSnippets.b564dd8b.js";function Zq(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGFkZF9jb2xsZWN0aW9uX2l0ZW0lMEFjb2xsZWN0aW9uJTIwJTNEJTIwYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX3NsdWclM0QlMjJkYXZhbnN0cmllbiUyRmNsaW1hdGUtNjRmOTlkYzJhNTA2N2Y2YjY1NTMxYmFiJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV9pZCUzRCUyMnBpZXJyZS1sb2ljJTJGY2xpbWF0ZS1uZXdzLWFydGljbGVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV90eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFjb2xsZWN0aW9uLml0ZW1zJTVCLTElNUQuaXRlbV9pZCUwQSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyZGF2YW5zdHJpZW4lMkZjbGltYXRlLTY0Zjk5ZGMyYTUwNjdmNmI2NTUzMWJhYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1faWQlM0QlMjJkYXRhc2V0cyUyRmNsaW1hdGVfZmV2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMlRoaXMlMjBkYXRhc2V0JTIwYWRvcHRzJTIwdGhlJTIwRkVWRVIlMjBtZXRob2RvbG9neSUyMHRoYXQlMjBjb25zaXN0cyUyMG9mJTIwMSUyQzUzNSUyMHJlYWwtd29ybGQlMjBjbGFpbXMlMjByZWdhcmRpbmclMjBjbGltYXRlLWNoYW5nZSUyMGNvbGxlY3RlZCUyMG9uJTIwdGhlJTIwaW50ZXJuZXQuJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> add_collection_item
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[-<span class="hljs-number">1</span>].item_id
<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>
<span class="hljs-comment"># ^item got added to the collection on last position</span>

<span class="hljs-comment"># Add item with a note</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;datasets/climate_fever&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset adopts the FEVER methodology that consists of 1,535 real-world claims regarding climate-change collected on the internet.&quot;</span>
<span class="hljs-meta">... </span>)
(...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Wq(T){let o,v="Check if the user has access to a repository:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGF1dGhfY2hlY2slMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnV0aWxzJTIwaW1wb3J0JTIwR2F0ZWRSZXBvRXJyb3IlMkMlMjBSZXBvc2l0b3J5Tm90Rm91bmRFcnJvciUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> auth_check
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> GatedRepoError, RepositoryNotFoundError

<span class="hljs-keyword">try</span>:
    auth_check(<span class="hljs-string">&quot;user/my-cool-model&quot;</span>)
<span class="hljs-keyword">except</span> GatedRepoError:
    <span class="hljs-comment"># Handle gated repository error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;You do not have permission to access this gated repository.&quot;</span>)
<span class="hljs-keyword">except</span> RepositoryNotFoundError:
    <span class="hljs-comment"># Handle repository not found error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The repository was not found or you do not have access.&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-12u7bhh"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Pq(T){let o,v="Examples:",i,a,g;return a=new U({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionStatusChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;status-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Vq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Bq(T){let o,v="Examples:",i,a,g;return a=new U({props:{code:"JTBBY29tbWVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQUhlbGxvJTIwJTQwb3RoZXJ1c2VyISUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjB0aXRsZSUwQSoqVGhpcyUyMGlzJTIwYm9sZCoqJTJDJTIwKnRoaXMlMjBpcyUyMGl0YWxpYyolMjBhbmQlMjB+dGhpcyUyMGlzJTIwc3RyaWtldGhyb3VnaH4lMEFBbmQlMjAlNUJ0aGlzJTVEKGh0dHAlM0ElMkYlMkZ1cmwpJTIwaXMlMjBhJTIwbGluayUwQSUyMiUyMiUyMiUwQSUwQUhmQXBpKCkuY29tbWVudF9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG9fbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb25fbnVtJTNEMzQlMEElMjAlMjAlMjAlMjBjb21tZW50JTNEY29tbWVudCUwQSklMEE=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span>comment = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>Hello @otheruser!
...
<span class="hljs-meta">... </span># This is a title
...
<span class="hljs-meta">... </span>**This is bold**, *this is italic* and ~this is strikethrough~
<span class="hljs-meta">... </span>And [this](http://url) is a link
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().comment_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    comment=comment
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionComment(id=&#x27;deadbeef0000000&#x27;, type=&#x27;comment&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Yq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Xq(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSklMEFjb2xsZWN0aW9uLnNsdWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function zq(T){let o,v=`The input list of <code>CommitOperation</code> will be mutated during the commit process. Do not reuse the same objects
for multiple commits.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1i3qk8u"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Oq(T){let o,v=`<code>create_commit</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-hn9ry1"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Qq(T){let o,v="<code>create_commit</code> is limited to 25k LFS files and a 1GB payload for regular files.";return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-yun5lq"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Kq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function eM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTJDJTBBKSUwQWVuZHBvaW50JTBBJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, status=<span class="hljs-string">&quot;pending&quot;</span>,...)

<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
<span class="hljs-string">&quot;...&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function tM(T){let o,v;return o=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9pbWFnZSUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlYWx0aF9yb3V0ZSUyMiUzQSUyMCUyMiUyRmhlYWx0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVRfS0VZJTIyJTNBJTIwJTIyc2VjcmV0X3ZhbHVlJTIyJTdEJTJDJTBBJTIwJTIwJTIwdGFncyUzRCU1QiUyMmRldiUyMiUyQyUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    env={
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>   secrets={<span class="hljs-string">&quot;MY_SECRET_KEY&quot;</span>: <span class="hljs-string">&quot;secret_value&quot;</span>},
<span class="hljs-meta">... </span>   tags=[<span class="hljs-string">&quot;dev&quot;</span>, <span class="hljs-string">&quot;text-generation&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function nM(T){let o,v;return o=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyZmluYmVydC1jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3NpdG9yeSUzRCUyMlByb3N1c0FJJTJGZmluYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZyYW1ld29yayUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1pbl9yZXBsaWNhJTNEMCUyQyUwQSUyMCUyMCUyMCUyMHNjYWxlX3RvX3plcm9fdGltZW91dCUzRDE1JTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlM0QlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjB2ZW5kb3IlM0QlMjJhd3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZWdpb24lM0QlMjJ1cy1lYXN0LTElMjIlMkMlMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIycHJvdGVjdGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMngyJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMiUyQyUwQSklMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QzMDApJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running ProsusAI/finbert while scaling to zero in 15 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;finbert-classifier&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;ProsusAI/finbert&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-classification&quot;</span>,
<span class="hljs-meta">... </span>    min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    scale_to_zero_timeout=<span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">300</span>)
<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
TextClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.8983615040779114</span>)`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function oM(T){let o,v=`<code>create_inference_endpoint_from_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1bm6hf4"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function aM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function sM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBcGF5bG9hZCUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGd2ViaG9vay5zaXRlJTJGYTIxNzZlODItNTcyMC00M2VlLTllMDYtZjkxY2I0YzkxNTQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHBheWxvYWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>payload = create_webhook(
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function rM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function iM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function cM(T){let o,v="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1k7dttx"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function lM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwZGVsZXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQWRlbGV0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, delete_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Delete item based on its ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function pM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError">EntryNotFoundError</a>
If the file to download cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1qc32pt"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function dM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBZGVsZXRlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function gM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRpc2FibGVfd2ViaG9vayUwQWRpc2FibGVkX3dlYmhvb2slMjAlM0QlMjBkaXNhYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWRpc2FibGVkX3dlYmhvb2s=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> disable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook = disable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function uM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiklMEElMEFkdXBsaWNhdGVfc3BhY2UoJTIybXVsdGltb2RhbGFydCUyRmRyZWFtYm9vdGgtdHJhaW5pbmclMjIlMkMlMjB0b19pZCUzRCUyMm15LWRyZWFtYm9vdGglMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space

<span class="hljs-comment"># Duplicate a Space to your account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)

<span class="hljs-comment"># Can set custom destination id and visibility flag.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, to_id=<span class="hljs-string">&quot;my-dreambooth&quot;</span>, private=<span class="hljs-literal">True</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/my-dreambooth&#x27;</span>,...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function hM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function fM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTBBZW5hYmxlZF93ZWJob29rJTIwJTNEJTIwZW5hYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWVuYWJsZWRfd2ViaG9vaw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook = enable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function mM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZldGNoX2pvYl9sb2dzJTJDJTIwcnVuX2pvYiUwQWpvYiUyMCUzRCUyMHJ1bl9qb2IoJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCklMEFmb3IlMjBsb2clMjBpbiUyMGZldGNoX2pvYl9sb2dzKGpvYi5qb2JfaWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobG9nKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> fetch_job_logs, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(<span class="hljs-string">&quot;python:3.12&quot;</span>, [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job.job_id):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(log)
Hello <span class="hljs-keyword">from</span> HF compute!`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function _M(T){let o,v="Examples:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZpbGVfZXhpc3RzJTBBZmlsZV9leGlzdHMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMCUyMmNvbmZpZy5qc29uJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIlMjIlMkMlMjAlMjJub3QtYS1maWxlJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZub3QtYS1yZXBvJTIyJTJDJTIwJTIyY29uZmlnLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> file_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;not-a-file&quot;</span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/not-a-repo&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function bM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbi50aXRsZSUwQWxlbihjb2xsZWN0aW9uLml0ZW1zKSUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&#x27;Recent models&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(collection.items)
<span class="hljs-number">37</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
    item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
    item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
    item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
    position=<span class="hljs-number">88</span>,
    note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function vM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function yM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function xM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9wYXRoc19pbmZvJTBBcGF0aHNfaW5mbyUyMCUzRCUyMGdldF9wYXRoc19pbmZvKCUyMmFsbGVuYWklMkZjNCUyMiUyQyUyMCU1QiUyMlJFQURNRS5tZCUyMiUyQyUyMCUyMmVuJTIyJTVEJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEFwYXRoc19pbmZv",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_paths_info
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info = get_paths_info(<span class="hljs-string">&quot;allenai/c4&quot;</span>, [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>], repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info
[
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">2379</span>, blob_id=<span class="hljs-string">&#x27;f84cb4c97182890fc1dbdeaf1a6a468fd27b4fff&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFolder(path=<span class="hljs-string">&#x27;en&#x27;</span>, tree_id=<span class="hljs-string">&#x27;dc943c4c40f53d02b31ced1defa7e5f438d5862e&#x27;</span>, last_commit=<span class="hljs-literal">None</span>)
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function $M(T){let o,v="Collecting all discussions of a repo in a list:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1p6axsk"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function wM(T){let o,v="Iterating over discussions of a repo:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRpc2N1c3Npb24ubnVtJTJDJTIwZGlzY3Vzc2lvbi50aXRsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(discussion.num, discussion.title)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-121l6g4"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function kM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"bWV0YWRhdGElMjAlM0QlMjBnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQW1ldGFkYXRhJTBBbWV0YWRhdGEuZmlsZXNfbWV0YWRhdGElNUIlMjJtb2RlbC5zYWZldGVuc29ycyUyMiU1RC5tZXRhZGF0YSUwQSUwQW1ldGFkYXRhJTIwJTNEJTIwZ2V0X3NhZmV0ZW5zb3JzX21ldGFkYXRhKCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklMEFtZXRhZGF0YSUwQWxlbihtZXRhZGF0YS5maWxlc19tZXRhZGF0YSklMEElMEFnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIp",highlighted:`<span class="hljs-comment"># Parse repo with single weights file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(
    metadata=<span class="hljs-literal">None</span>,
    sharded=<span class="hljs-literal">False</span>,
    weight_map={<span class="hljs-string">&#x27;h.0.input_layernorm.bias&#x27;</span>: <span class="hljs-string">&#x27;model.safetensors&#x27;</span>, ...},
    files_metadata={<span class="hljs-string">&#x27;model.safetensors&#x27;</span>: SafetensorsFileMetadata(...)}
)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata.files_metadata[<span class="hljs-string">&quot;model.safetensors&quot;</span>].metadata
{<span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;pt&#x27;</span>}

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>)
Parse safetensors files: <span class="hljs-number">100</span>%|██████████████████████████████████████████| <span class="hljs-number">72</span>/<span class="hljs-number">72</span> [<span class="hljs-number">00</span>:<span class="hljs-number">12</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.78</span>it/s]
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(metadata={<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">352494542848</span>}, sharded=<span class="hljs-literal">True</span>, weight_map={...}, files_metadata={...})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(metadata.files_metadata)
<span class="hljs-number">72</span>  <span class="hljs-comment"># All safetensors files have been fetched</span>

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_safetensors_metadata(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
NotASafetensorsRepoError: <span class="hljs-string">&#x27;runwayml/stable-diffusion-v1-5&#x27;</span> <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> a safetensors repo. Couldn<span class="hljs-string">&#x27;t find &#x27;</span>model.safetensors.index.json<span class="hljs-string">&#x27; or &#x27;</span>model.safetensors<span class="hljs-string">&#x27; files.</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function TM(T){let o,v=`This method is deprecated and will be removed in version 1.0. Permissions are more complex than when
<code>get_token_permission</code> was first introduced. OAuth and fine-grain tokens allows for more detailed permissions.
If you need to know the permissions associated with a token, please use <code>whoami</code> and check the <code>&#39;auth&#39;</code> key.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1uyfywd"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function jM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF93ZWJob29rJTBBd2ViaG9vayUyMCUzRCUyMGdldF93ZWJob29rKCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiklMEFwcmludCh3ZWJob29rKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>webhook = get_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(webhook)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function qM(T){let o,v;return o=new U({props:{code:"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",highlighted:`<span class="hljs-selector-attr">[  96]</span>  .
└── <span class="hljs-selector-attr">[ 160]</span>  models<span class="hljs-attr">--julien-c--EsperBERTo-small</span>
    ├── <span class="hljs-selector-attr">[ 160]</span>  blobs
    │   ├── <span class="hljs-selector-attr">[321M]</span>  <span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
    │   ├── <span class="hljs-selector-attr">[ 398]</span>  <span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
    │   └── <span class="hljs-selector-attr">[1.4K]</span>  d7edf6bd2a681fb0175f7735299831ee1b22b812
    ├── <span class="hljs-selector-attr">[  96]</span>  refs
    │   └── <span class="hljs-selector-attr">[  40]</span>  <span class="hljs-selector-tag">main</span>
    └── <span class="hljs-selector-attr">[ 128]</span>  snapshots
        ├── <span class="hljs-selector-attr">[ 128]</span>  <span class="hljs-number">2439</span>f60ef33a0d46d85da5001d52aeda5b00ce9f
        │   ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
        │   └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        └── <span class="hljs-selector-attr">[ 128]</span>  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
            ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/<span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
            └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function MM(T){let o;return{c(){o=Fq("Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},l(v){o=Sq(v,"Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},m(v,i){$(v,o,i)},d(v){v&&p(o)}}}function HM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function UM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwcnVuX2pvYiUwQWpvYiUyMCUzRCUyMHJ1bl9qb2IoJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTIwJTJDJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMiU1RCklMEFpbnNwZWN0X2pvYihqb2Iuam9iX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(<span class="hljs-string">&quot;python:3.12&quot;</span>, [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_job(job.job_id)
JobInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;68780d00bbe36d38803f645f&#x27;</span>,
    created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">16</span>, <span class="hljs-number">20</span>, <span class="hljs-number">35</span>, <span class="hljs-number">12</span>, <span class="hljs-number">808000</span>, tzinfo=datetime.timezone.utc),
    docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>,
    space_id=<span class="hljs-literal">None</span>,
    command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>],
    arguments=[],
    environment={},
    secrets={},
    flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>,
    status=JobStatus(stage=<span class="hljs-string">&#x27;RUNNING&#x27;</span>, message=<span class="hljs-literal">None</span>)
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function CM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfYWNjZXB0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X2FjY2VwdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_accepted_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_accepted_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;accepted&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function IM(T){let o,v=`When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items
from a collection, you must use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1azfyye"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function AM(T){let o,v="Example usage with the <code>filter</code> argument:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCklMEElMEElMEFhcGkubGlzdF9kYXRhc2V0cyhmaWx0ZXIlM0QlMjJ0YXNrX2NhdGVnb3JpZXMlM0F0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCUwQSUyMCUyMCUyMCUyMGZpbHRlciUzRCglMjJsYW5ndWFnZSUzQXJ1JTIyJTJDJTIwJTIydGFza19pZHMlM0FsYW5ndWFnZS1tb2RlbGluZyUyMiklMEEpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHModGFncyUzRCUyMmZpZnR5b25lJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets()


<span class="hljs-comment"># List only the text classification datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;task_categories:text-classification&quot;</span>)


<span class="hljs-comment"># List only the datasets in russian for language modeling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">filter</span>=(<span class="hljs-string">&quot;language:ru&quot;</span>, <span class="hljs-string">&quot;task_ids:language-modeling&quot;</span>)
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># List FiftyOne datasets (identified by the tag &quot;fiftyone&quot; in dataset card)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1lrmw6w"&&(o.innerHTML=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function NM(T){let o,v="Example usage with the <code>search</code> argument:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKHNlYXJjaCUzRCUyMnRleHQlMjIpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHMoc2VhcmNoJTNEJTIydGV4dCUyMiUyQyUyMGF1dGhvciUzRCUyMmdvb2dsZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>)

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name made by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oyacuq"&&(o.innerHTML=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function JM(T){let o,v=`<code>list_inference_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-jn3ftn"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function EM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2luZmVyZW5jZV9lbmRwb2ludHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_inference_endpoints()
[InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint&#x27;</span>, ...), ...]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function DM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function RM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMEElMEFsaWtlcyUyMCUzRCUyMGxpc3RfbGlrZWRfcmVwb3MoJTIyanVsaWVuLWMlMjIpJTBBJTBBbGlrZXMudXNlciUwQSUwQWxpa2VzLm1vZGVscw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos

<span class="hljs-meta">&gt;&gt;&gt; </span>likes = list_liked_repos(<span class="hljs-string">&quot;julien-c&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.user
<span class="hljs-string">&quot;julien-c&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.models
[<span class="hljs-string">&quot;osanseviero/streamlit_1.15&quot;</span>, <span class="hljs-string">&quot;Xhaheen/ChatGPT_HF&quot;</span>, ...]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function GM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X21vZGVscygpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMmtlcmFzLWh1YiUyMiklMEElMEFhcGkubGlzdF9tb2RlbHMoaW5mZXJlbmNlX3Byb3ZpZGVyJTNEJTIyY29oZXJlJTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyJTJDJTIwYXV0aG9yJTNEJTIyZ29vZ2xlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models()

<span class="hljs-comment"># List text classification models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># List models from the KerasHub library</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;keras-hub&quot;</span>)

<span class="hljs-comment"># List models served by Cohere</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(inference_provider=<span class="hljs-string">&quot;cohere&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name and pushed by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function FM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X3BhcGVycyhxdWVyeSUzRCUyMmF0dGVudGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all papers with &quot;attention&quot; in their title</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_papers(query=<span class="hljs-string">&quot;attention&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function SM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMlMkMlMjBhY2NlcHRfYWNjZXNzX3JlcXVlc3QlMEElMEFyZXF1ZXN0cyUyMCUzRCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2IlMjIpJTBBbGVuKHJlcXVlc3RzKSUwQXJlcXVlc3RzJTVCMCU1RCUwQSUwQWFjY2VwdF9hY2Nlc3NfcmVxdWVzdCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiUyQyUyMCUyMmNsZW0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_pending_access_requests, accept_access_request

<span class="hljs-comment"># List pending requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_pending_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;pending&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]

<span class="hljs-comment"># Accept Clem&#x27;s request</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>accept_access_request(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>, <span class="hljs-string">&quot;clem&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function LM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVqZWN0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X3JlamVjdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_rejected_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_rejected_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;rejected&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function ZM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWluaXRpYWxfY29tbWl0JTIwJTNEJTIwYXBpLmxpc3RfcmVwb19jb21taXRzKCUyMmdwdDIlMjIpJTVCLTElNUQlMEElMEFpbml0aWFsX2NvbW1pdCUwQSUwQWFwaS5jcmVhdGVfYnJhbmNoKCUyMmdwdDIlMjIlMkMlMjAlMjJuZXdfZW1wdHlfYnJhbmNoJTIyJTJDJTIwcmV2aXNpb24lM0Rpbml0aWFsX2NvbW1pdC5jb21taXRfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Commits are sorted by date (last commit first)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit = api.list_repo_commits(<span class="hljs-string">&quot;gpt2&quot;</span>)[-<span class="hljs-number">1</span>]

<span class="hljs-comment"># Initial commit is always a system commit containing the \`.gitattributes\` file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit
GitCommitInfo(
    commit_id=<span class="hljs-string">&#x27;9b865efde13a30c13e0a33e536cf3e4a5a9d71d8&#x27;</span>,
    authors=[<span class="hljs-string">&#x27;system&#x27;</span>],
    created_at=datetime.datetime(<span class="hljs-number">2019</span>, <span class="hljs-number">2</span>, <span class="hljs-number">18</span>, <span class="hljs-number">10</span>, <span class="hljs-number">36</span>, <span class="hljs-number">15</span>, tzinfo=datetime.timezone.utc),
    title=<span class="hljs-string">&#x27;initial commit&#x27;</span>,
    message=<span class="hljs-string">&#x27;&#x27;</span>,
    formatted_title=<span class="hljs-literal">None</span>,
    formatted_message=<span class="hljs-literal">None</span>
)

<span class="hljs-comment"># Create an empty branch by deriving from initial commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_branch(<span class="hljs-string">&quot;gpt2&quot;</span>, <span class="hljs-string">&quot;new_empty_branch&quot;</span>, revision=initial_commit.commit_id)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function WM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJncHQyJTIyKSUwQSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJ2RhdGFzZXQnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;gpt2&quot;</span>)
GitRefs(branches=[GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&#x27;</span>)], converts=[], tags=[])

<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>)
GitRefs(
    branches=[
        GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
    ],
    converts=[],
    tags=[
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
    ]
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function PM(T){let o,v;return o=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIpJTBBcmVwb190cmVlJTBBbGlzdChyZXBvX3RyZWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree
&lt;generator <span class="hljs-built_in">object</span> HfApi.list_repo_tree at <span class="hljs-number">0x7fa4088e1ac0</span>&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFile(path=<span class="hljs-string">&#x27;.gitattributes&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;ae8c63daedbd4206d7d40126955d4e6ab1c80f8f&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;43bd404b159de6fba7c2f4d3264347668d43af25&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;config.json&#x27;</span>, size=<span class="hljs-number">554</span>, blob_id=<span class="hljs-string">&#x27;2f9618c3a19b9a61add74f70bfb121335aeef666&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;flax_model.msgpack&#x27;</span>, size=<span class="hljs-number">497764107</span>, blob_id=<span class="hljs-string">&#x27;8095a62ccb4d806da7666fcda07467e2d150218e&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">497764107</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;d88b0d6a6ff9c3f8151f9d3228f57092aaea997f09af009eefd7373a77b5abb9&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;merges.txt&#x27;</span>, size=<span class="hljs-number">456318</span>, blob_id=<span class="hljs-string">&#x27;226b0752cac7789c48f0cb3ec53eda48b7be36cc&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>, size=<span class="hljs-number">548123560</span>, blob_id=<span class="hljs-string">&#x27;64eaa9c526867e404b68f2c5d66fd78e27026523&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">548123560</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;9be78edb5b928eba33aa88f431551348f7466ba9f5ef3daf1d552398722a5436&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;vocab.json&#x27;</span>, size=<span class="hljs-number">898669</span>, blob_id=<span class="hljs-string">&#x27;b00361fece0387ca34b4b8b8539ed830d644dbeb&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>)]
]`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function VM(T){let o,v;return o=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIycHJvbXB0aGVybyUyRm9wZW5qb3VybmV5LXY0JTIyJTJDJTIwZXhwYW5kJTNEVHJ1ZSklMEFsaXN0KHJlcG9fdHJlZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>, expand=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFolder(
        path=<span class="hljs-string">&#x27;feature_extractor&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;aa536c4ea18073388b5b0bc791057a7296a00398&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFolder(
        path=<span class="hljs-string">&#x27;safety_checker&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;65aef9d787e5557373fdf714d6c34d4fcdd70440&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFile(
        path=<span class="hljs-string">&#x27;model_index.json&#x27;</span>,
        size=<span class="hljs-number">582</span>,
        blob_id=<span class="hljs-string">&#x27;d3d7c1e8c3e78eeb1640b8e2041ee256e24c9ee1&#x27;</span>,
        lfs=<span class="hljs-literal">None</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;b195ed2d503f3eb29637050a886d77bd81d35f0e&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Fix deprecation warning by changing \`CLIPFeatureExtractor\` to \`CLIPImageProcessor\`. (#54)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">5</span>, <span class="hljs-number">15</span>, <span class="hljs-number">21</span>, <span class="hljs-number">41</span>, <span class="hljs-number">59</span>, tzinfo=datetime.timezone.utc)
        },
        security={
            <span class="hljs-string">&#x27;safe&#x27;</span>: <span class="hljs-literal">True</span>,
            <span class="hljs-string">&#x27;av_scan&#x27;</span>: {<span class="hljs-string">&#x27;virusFound&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;virusNames&#x27;</span>: <span class="hljs-literal">None</span>},
            <span class="hljs-string">&#x27;pickle_import_scan&#x27;</span>: <span class="hljs-literal">None</span>
        }
    )
    ...
]`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function BM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEF3ZWJob29rcyUyMCUzRCUyMGxpc3Rfd2ViaG9va3MoKSUwQWxlbih3ZWJob29rcyklMEF3ZWJob29rcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks = list_webhooks()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(webhooks)
<span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks[<span class="hljs-number">0</span>]
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function YM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function XM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function zM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1bg6k8f"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function OM(T){let o,v=`This is a permanent action that will affect all commits referencing the deleted files and might corrupt your
repository. This is a non-revertible operation. Use it only if you know what you are doing.`;return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1tduvyk"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function QM(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function KM(T){let o,v=`This is a power-user method. You shouldn’t need to call it directly to make a normal commit.
Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> directly instead.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1p5fkuq"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function eH(T){let o,v=`Commit operations will be mutated during the process. In particular, the attached <code>path_or_fileobj</code> will be
removed after the upload to save memory (and replaced by an empty <code>bytes</code> object). Do not reuse the same
objects except to pass them to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. If you don’t want to remove the attached content from the
commit operation object, pass <code>free_memory=False</code>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-3d3emz"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function tH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTIwJTIzJTIwdXBsb2FkJTIwJTJCJTIwZnJlZSUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMuYXBwZW5kKGFkZGl0aW9uKSUwQSUwQWNyZWF0ZV9jb21taXQocmVwb19pZCUyQyUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJDb21taXQlMjBhbGwlMjBzaGFyZHMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-comment"># Generate and preupload LFS files one by one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition]) <span class="hljs-comment"># upload + free memory</span>
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function nH(T){let o,v="Examples:",i,a,g;return a=new U({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionTitleChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;title-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function oH(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-apfbx2"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function aH(T){let o,v="Examples:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlcG9fZXhpc3RzJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGZ2VtbWEtN2IlMjIpJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGbm90LWEtcmVwbyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> repo_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/not-a-repo&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function sH(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function rH(T){let o,v='It is also possible to request hardware directly when creating the Space repo! See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> for details.';return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-s3mdaf"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function iH(T){let o,v=`It is not possible to decrease persistent storage after its granted. To do so, you must delete it
via <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_space_storage">delete_space_storage()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-n1vlsa"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function cH(T){let o,v="Examples:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJldmlzaW9uX2V4aXN0cyUwQXJldmlzaW9uX2V4aXN0cyglMjJnb29nbGUlMkZnZW1tYS03YiUyMiUyQyUyMCUyMmZsb2F0MTYlMjIpJTBBcmV2aXNpb25fZXhpc3RzKCUyMmdvb2dsZSUyRmdlbW1hLTdiJTIyJTJDJTIwJTIybm90LWEtcmV2aXNpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> revision_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;float16&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;not-a-revision&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function lH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS5ydW5fYXNfZnV0dXJlKGFwaS53aG9hbWkpJTIwJTIzJTIwaW5zdGFudCUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjB3YWl0JTIwdW50aWwlMjBjb21wbGV0ZSUyMGFuZCUyMHJldHVybiUyMHJlc3VsdCUwQWZ1dHVyZS5kb25lKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.run_as_future(api.whoami) <span class="hljs-comment"># instant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># wait until complete and return result</span>
(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function pH(T){let o,v="Run your first Job:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUyMnB5dGhvbiUzQTMuMTIlMjIlMkMlMjAlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyMCUyQyUyMnByaW50KCdIZWxsbyUyMGZyb20lMjBIRiUyMGNvbXB1dGUhJyklMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(<span class="hljs-string">&quot;python:3.12&quot;</span>, [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span> ,<span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>])`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1t6yql5"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function dH(T){let o,v="Run a GPU Job:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFpbWFnZSUyMCUzRCUyMCUyMnB5dG9yY2glMkZweXRvcmNoJTNBMi42LjAtY3VkYTEyLjQtY3Vkbm45LWRldmVsJTIyJTBBY29tbWFuZCUyMCUzRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIyaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIyVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCUyMiklMjIlNUQlMEFydW5fam9iKGltYWdlJTJDJTIwY29tbWFuZCUyQyUyMGZsYXZvciUzRCUyMmExMGctc21hbGwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>command = [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran <span class="hljs-keyword">with</span> the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(image, command, flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1b2mkbl"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function gH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFzY3JpcHQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRnJlZnMlMkZoZWFkcyUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTBBcnVuX3V2X2pvYihzY3JpcHQlMkMlMjBkZXBlbmRlbmNpZXMlM0QlNUIlMjJ0cmwlMjIlNUQlMkMlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>script = <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/refs/heads/main/trl/scripts/sft.py&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(script, dependencies=[<span class="hljs-string">&quot;trl&quot;</span>], flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function uH(T){let o,v='It is also possible to set a custom sleep time when requesting hardware with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.request_space_hardware">request_space_hardware()</a>.';return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1kki46i"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function hH(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1jar68o"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function fH(T){let o,v="Once squashed, the commit history cannot be retrieved. This is a non-revertible operation.";return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-16nd2e3"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function mH(T){let o,v=`Once the history of a branch has been squashed, it is not possible to merge it back into another branch since
their history will have diverged.`;return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-qbmppr"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function _H(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQXJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8oJTIydGVzdC1zcXVhc2glMjIpLnJlcG9faWQlMEElMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJjb250ZW50JTIyKSUwQWFwaS51cGxvYWRfZmlsZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMmxmcy5iaW4lMjIlMkMlMjBwYXRoX29yX2ZpbGVvYmolM0RiJTIyY29udGVudCUyMiklMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJhbm90aGVyX2NvbnRlbnQlMjIpJTBBJTBBYXBpLnN1cGVyX3NxdWFzaF9oaXN0b3J5KHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Create repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = api.create_repo(<span class="hljs-string">&quot;test-squash&quot;</span>).repo_id

<span class="hljs-comment"># Make a lot of commits.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;lfs.bin&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;another_content&quot;</span>)

<span class="hljs-comment"># Squash history</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.super_squash_history(repo_id=repo_id)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function bH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMkMlMjB1bmxpa2UlMEElMjJncHQyJTIyJTIwaW4lMjBsaXN0X2xpa2VkX3JlcG9zKCkubW9kZWxzJTIwJTIzJTIwd2UlMjBhc3N1bWUlMjB5b3UlMjBoYXZlJTIwYWxyZWFkeSUyMGxpa2VkJTIwZ3B0MiUwQXVubGlrZSglMjJncHQyJTIyKSUwQSUyMmdwdDIlMjIlMjBpbiUyMGxpc3RfbGlrZWRfcmVwb3MoKS5tb2RlbHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos, unlike
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models <span class="hljs-comment"># we assume you have already liked gpt2</span>
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unlike(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function vH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQXVwZGF0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMk5ld2x5JTIwdXBkYXRlZCUyMG1vZGVsISUyMiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNEMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Update item based on its ID (add note + update position)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Newly updated model!&quot;</span>
<span class="hljs-meta">... </span>    position=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function yH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhJTBBY29sbGVjdGlvbiUyMCUzRCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMnVzZXJuYW1lJTJGaWNjdi0yMDIzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyME9jdC4lMjAyMDIzJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJQb3J0Zm9saW8lMjBvZiUyMG1vZGVscyUyQyUyMGRhdGFzZXRzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwT2N0LiUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aGVtZSUzRCUyMnBpbmslMjIlMkMlMEEpJTBBY29sbGVjdGlvbi5zbHVn",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_collection_metadata
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = update_collection_metadata(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV Oct. 2023&quot;</span>
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, datasets, papers and demos I presented at ICCV Oct. 2023&quot;</span>,
<span class="hljs-meta">... </span>    private=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    theme=<span class="hljs-string">&quot;pink&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-oct-2023-64f9a55bb3115b4f513ec026&quot;</span>
<span class="hljs-comment"># ^collection slug got updated but not the trailing ID</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function xH(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1bg6k8f"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function $H(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBdXBkYXRlZF9wYXlsb2FkJTIwJTNEJTIwdXBkYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwd2ViaG9va19pZCUzRCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGbmV3LndlYmhvb2suc2l0ZSUyRmEyMTc2ZTgyLTU3MjAtNDNlZS05ZTA2LWY5MWNiNGM5MTU0OCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHVwZGF0ZWRfcGF5bG9hZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_payload = update_webhook(
<span class="hljs-meta">... </span>    webhook_id=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function wH(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1m0jr8h"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function kH(T){let o,v=`<code>upload_file</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-14jkuxx"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function TH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBJTBBd2l0aCUyMG9wZW4oJTIyLiUyRmxvY2FsJTJGZmlsZXBhdGglMjIlMkMlMjAlMjJyYiUyMiklMjBhcyUyMGZvYmolM0ElMEElMjAlMjAlMjAlMjB1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0RmaWxlb2JqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIycmVtb3RlJTJGZmlsZSUyRnBhdGguaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEJTIybXlfdG9rZW4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyLiU1QyU1Q2xvY2FsJTVDJTVDZmlsZSU1QyU1Q3BhdGglMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZmaWxlJTJGcGF0aC5oNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJteV90b2tlbiUyMiUyQyUwQSklMEElMEF1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTVDJTVDbG9jYWwlNUMlNUNmaWxlJTVDJTVDcGF0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmZpbGUlMkZwYXRoLmg1JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./local/filepath&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> fobj:
<span class="hljs-meta">... </span>    upload_file(
<span class="hljs-meta">... </span>        path_or_fileobj=fileobj,
<span class="hljs-meta">... </span>        path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>        repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>        token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/refs%2Fpr%2F1/remote/file/path.h5&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function jH(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1l6tbi1"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function qH(T){let o,v=`<code>upload_folder</code> assumes that the repo already exists on the Hub. If you get a Client error 404, please make
sure you are authenticated and that <code>repo_id</code> and <code>repo_type</code> are set correctly. If repo does not exist, create
it first using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1ji36op"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function MH(T){let o,v='When dealing with a large folder (thousands of files or hundreds of GB), we recommend using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> instead.';return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-10xj0hr"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function HH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsZXRlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSklMEE=",highlighted:`<span class="hljs-comment"># Upload checkpoints folder except the log files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># &quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder including logs while deleting existing logs from the repo</span>
<span class="hljs-comment"># Useful if you don&#x27;t know exactly which log files have already being pushed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder while creating a PR</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/refs%2Fpr%2F1/remote/experiment/checkpoints&quot;</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function UH(T){let o,v="A few things to keep in mind:",i,a,g='<li>Repository limits still apply: <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">https://huggingface.co/docs/hub/repositories-recommendations</a></li> <li>Do not start several processes in parallel.</li> <li>You can interrupt and resume the process at any time.</li> <li>Do not upload the same folder to several repositories. If you need to do so, you must delete the local <code>.cache/.huggingface/</code> folder first.</li>';return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-vnn6d1"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1iweq7b"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function CH(T){let o,v='While being much more robust to upload large folders, <code>upload_large_folder</code> is more limited than <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> feature-wise. In practice:',i,a,g='<li>you cannot set a custom <code>path_in_repo</code>. If you want to upload to a subfolder, you need to set the proper structure locally.</li> <li>you cannot set a custom <code>commit_message</code> and <code>commit_description</code> since multiple commits are created.</li> <li>you cannot delete from the repo while uploading. Please make a separate commit first.</li> <li>you cannot create a PR directly. Please create a PR first (from the UI or using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">create_pull_request()</a>) and then commit to it by passing <code>revision</code>.</li>';return{c(){o=c("p"),o.innerHTML=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-wp9z6w"&&(o.innerHTML=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-mz4t5f"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function IH(T){let o,v=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing datasets
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-5rfhi2"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function AH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function NH(T){let o,v=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing models
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-15v1iox"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function JH(T){let o,v=`All attributes of this class are optional except <code>rfilename</code>. This is because only the file names are returned when
listing repositories on the Hub (with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>). If you need more
information like file size, blob id or lfs details, you must request them specifically from one repo at a time
(using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>) as it adds more constraints on the backend server to
retrieve these.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-6ldscx"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function EH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"UmVwb1VybCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmdwdDInKSUwQSUwQVJlcG9VcmwoJ2h0dHBzJTNBJTJGJTJGaHViLWNpLmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkdW1teV91c2VyJTJGZHVtbXlfZGF0YXNldCclMkMlMjBlbmRwb2ludCUzRCdodHRwcyUzQSUyRiUyRmh1Yi1jaS5odWdnaW5nZmFjZS5jbycpJTBBJTBBUmVwb1VybCgnaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXIlMkZteS1kYXRhc2V0JyklMEElMEFIZkFwaS5jcmVhdGVfcmVwbyglMjJkdW1teV9tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;dummy_user/dummy_dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;user/dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi.create_repo(<span class="hljs-string">&quot;dummy_model&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/Wauplin/dummy_model&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;Wauplin/dummy_model&#x27;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function DH(T){let o,v=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing spaces
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-hrpd0g"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function RH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"b3BlcmF0aW9uJTIwJTNEJTIwQ29tbWl0T3BlcmF0aW9uQWRkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmRpciUyRndlaWdodHMuaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTJGbG9jYWwlMkZ3ZWlnaHRzLmg1JTIyJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVyYXRpb24uYXNfZmlsZSgpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwY29udGVudCUyMCUzRCUyMGZpbGUucmVhZCgpJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGZpbGUucmVhZCgxMDI0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm90JTIwZGF0YSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucHV0KC4uLiUyQyUyMGRhdGElM0RmaWxlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>operation = CommitOperationAdd(
<span class="hljs-meta">... </span>       path_in_repo=<span class="hljs-string">&quot;remote/dir/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>       path_or_fileobj=<span class="hljs-string">&quot;./local/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>)
CommitOperationAdd(path_in_repo=<span class="hljs-string">&#x27;remote/dir/weights.h5&#x27;</span>, path_or_fileobj=<span class="hljs-string">&#x27;./local/weights.h5&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file() <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    content = file.read()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
<span class="hljs-meta">... </span>        data = file.read(<span class="hljs-number">1024</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> data:
<span class="hljs-meta">... </span>             <span class="hljs-keyword">break</span>
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    requests.put(..., data=file)
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function GH(T){let o,v="Example:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWNzdl9wYXRoJTIwJTNEJTIwUGF0aCglMjJ3YXRjaGVkX2ZvbGRlciUyRmRhdGEuY3N2JTIyKSUwQUNvbW1pdFNjaGVkdWxlcihyZXBvX2lkJTNEJTIydGVzdF9zY2hlZHVsZXIlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTIwZm9sZGVyX3BhdGglM0Rjc3ZfcGF0aC5wYXJlbnQlMkMlMjBldmVyeSUzRDEwKSUwQSUwQXdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJmaXJzdCUyMGxpbmUlMjIpJTBBJTBBd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnNlY29uZCUyMGxpbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Scheduler uploads every 10 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=csv_path.parent, every=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;first line&quot;</span>)

<span class="hljs-comment"># Some time later (...)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;second line&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function FH(T){let o,v="Example using a context manager:",i,a,g;return a=new U({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQXdpdGglMjBDb21taXRTY2hlZHVsZXIocmVwb19pZCUzRCUyMnRlc3Rfc2NoZWR1bGVyJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyd2F0Y2hlZF9mb2xkZXIlMjIlMkMlMjBldmVyeSUzRDEwKSUyMGFzJTIwc2NoZWR1bGVyJTNBJTBBJTIwJTIwJTIwJTIwY3N2X3BhdGglMjAlM0QlMjBQYXRoKCUyMndhdGNoZWRfZm9sZGVyJTJGZGF0YS5jc3YlMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKCUyMmZpcnN0JTIwbGluZSUyMiklMEElMjAlMjAlMjAlMjAoLi4uKSUwQSUyMCUyMCUyMCUyMHdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjJzZWNvbmQlMjBsaW5lJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=<span class="hljs-string">&quot;watched_folder&quot;</span>, every=<span class="hljs-number">10</span>) <span class="hljs-keyword">as</span> scheduler:
<span class="hljs-meta">... </span>    csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;first line&quot;</span>)
<span class="hljs-meta">... </span>    (...)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;second line&quot;</span>)

<span class="hljs-comment"># Scheduler is now stopped and last commit have been triggered</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-k44prv"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function SH(T){let o,v=`This method is not meant to be called directly. It is run in the background by the scheduler, respecting a
queue mechanism to avoid concurrent commits. Making a direct call to the method might lead to concurrency
issues.`;return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oh5a50"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function LH(T){let o,v,i,a,g,e,x,Cw="Below is the documentation for the <code>HfApi</code> class, which serves as a Python wrapper for the Hugging Face Hub’s API.",rf,pr,Iw="All methods from the <code>HfApi</code> are also accessible from the package’s root directly. Both approaches are detailed below.",cf,dr,Aw=`Using the root method is more straightforward but the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> class gives you more flexibility.
In particular, you can pass a token that will be reused in all HTTP calls. This is different
than <code>hf auth login</code> or <a href="/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login">login()</a> as the token is not persisted on the machine.
It is also possible to provide a different endpoint or configure a custom user-agent.`,lf,gr,pf,ur,df,w,hr,vm,Vl,Nw="Client to interact with the Hugging Face Hub via HTTP.",ym,Bl,Jw=`The client is initialized with some high-level settings used in all requests
made to the Hub (HF endpoint, authentication, user agents…). Using the <code>HfApi</code>
client is preferred but not mandatory as all of its public methods are exposed
directly at the root of <code>huggingface_hub</code>.`,xm,Ae,fr,$m,Yl,Ew="Accept an access request from a user for a given gated repo.",wm,Xl,Dw=`Once the request is accepted, the user will be able to download any file of the repo and access the community
tab. If the approval mode is automatic, you don’t have to accept requests manually. An accepted request can be
cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,km,zl,Rw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Tm,Ne,mr,jm,Ol,Gw="Add an item to a collection on the Hub.",qm,Ql,Fw='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',Mm,Ro,Hm,Ot,_r,Um,Kl,Sw="Adds or updates a secret in a Space.",Cm,ep,Lw=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,Im,Qt,br,Am,tp,Zw="Adds or updates a variable in a Space.",Nm,np,Ww=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,Jm,G,vr,Em,op,Pw="Check if the provided user token has access to a specific repository on the Hugging Face Hub.",Dm,ap,Vw=`This method verifies whether the user, authenticated via the provided token, has access to the specified
repository. If the repository is not found or if the user lacks the required permissions to access it,
the method raises an appropriate exception.`,Rm,sp,Bw="Example:",Gm,Go,Fm,rp,Yw="In this example:",Sm,ip,Xw=`<li>If the user has access, the method completes successfully.</li> <li>If the repository is gated or does not exist, appropriate exceptions are raised, allowing the user
to handle them accordingly.</li>`,Lm,Je,yr,Zm,cp,zw="Cancel an access request from a user for a given gated repo.",Wm,lp,Ow="A cancelled request will go back to the pending list and the user will lose access to the repo.",Pm,pp,Qw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Vm,Fo,xr,Bm,dp,Kw="Cancel a compute Job on Hugging Face infrastructure.",Ym,Ee,$r,Xm,gp,ek="Closes or re-opens a Discussion or Pull Request.",zm,So,Om,Lo,Qm,De,wr,Km,up,tk="Creates a new comment on the given Discussion.",e_,Zo,t_,Wo,n_,Po,kr,o_,hp,nk=`Create a new branch for a repo on the Hub, starting from the specified revision (defaults to <code>main</code>).
To find a revision suiting your needs, you can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a>.`,a_,Re,Tr,s_,fp,ok="Create a new Collection on the Hub.",r_,mp,ak='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',i_,Vo,c_,re,jr,l_,_p,sk="Creates a commit in the given repo, deleting & uploading files as needed.",p_,Bo,d_,Yo,g_,Xo,u_,Z,qr,h_,bp,rk="Creates a Discussion or Pull Request.",f_,vp,ik="Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",m_,yp,ck='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>.',__,xp,lk='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',b_,zo,v_,ie,Mr,y_,$p,pk="Create a new Inference Endpoint.",x_,Oo,$_,Qo,w_,Ko,k_,Ge,Hr,T_,wp,dk="Create a new Inference Endpoint from a model in the Hugging Face Inference Catalog.",j_,kp,gk=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,q_,ea,M_,W,Ur,H_,Tp,uk="Creates a Pull Request . Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",U_,jp,hk='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>;',C_,qp,fk='This is a wrapper around <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a>.',I_,Mp,mk='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',A_,ta,N_,na,Cr,J_,Hp,_k="Create an empty repo on the HuggingFace Hub.",E_,oa,Ir,D_,Up,bk="Tag a given commit of a repo on the Hub.",R_,Kt,Ar,G_,Cp,vk="Create a new webhook.",F_,aa,S_,Fe,Nr,L_,Ip,yk="Get info on one specific dataset on huggingface.co.",Z_,Ap,xk="Dataset can be private if you pass an acceptable token.",W_,sa,P_,ra,Jr,V_,Np,$k="Delete a branch from a repo on the Hub.",B_,Se,Er,Y_,Jp,wk="Delete a collection on the Hub.",X_,ia,z_,ca,O_,en,Dr,Q_,Ep,kk="Delete an item from a collection.",K_,la,eb,tn,Rr,tb,Dp,Tk="Deletes a file in the given repo.",nb,pa,ob,nn,Gr,ab,Rp,jk="Delete files from a repository on the Hub.",sb,Gp,qk=`If a folder path is provided, the entire folder is deleted as well as
all files it contained.`,rb,on,Fr,ib,Fp,Mk="Deletes a folder in the given repo.",cb,Sp,Hk='Simple wrapper around <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> method.',lb,Le,Sr,pb,Lp,Uk="Delete an Inference Endpoint.",db,Zp,Ck=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> or scale it to zero with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>.`,gb,Wp,Ik='For convenience, you can also delete an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">InferenceEndpoint.delete()</a>.',ub,da,Lr,hb,Pp,Ak="Delete a repo from the HuggingFace Hub. CAUTION: this is irreversible.",fb,an,Zr,mb,Vp,Nk="Deletes a secret from a Space.",_b,Bp,Jk=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,bb,ga,Wr,vb,Yp,Ek="Delete persistent storage for a Space.",yb,sn,Pr,xb,Xp,Dk="Deletes a variable from a Space.",$b,zp,Rk=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,wb,ua,Vr,kb,Op,Gk="Delete a tag from a repo on the Hub.",Tb,rn,Br,jb,Qp,Fk="Delete a webhook.",qb,ha,Mb,cn,Yr,Hb,Kp,Sk="Disable a webhook (makes it “disabled”).",Ub,fa,Cb,Ze,Xr,Ib,ed,Lk="Duplicate a Space.",Ab,td,Zk=`Programmatically duplicate a Space. The new Space will be created in your account and will be in the same state
as the original Space (running or paused). You can duplicate a Space no matter the current state of a Space.`,Nb,ma,Jb,ln,zr,Eb,nd,Wk="Edits a comment on a Discussion / Pull Request.",Db,_a,Rb,pn,Or,Gb,od,Pk="Enable a webhook (makes it “active”).",Fb,ba,Sb,dn,Qr,Lb,ad,Vk="Fetch all the logs from a compute Job on Hugging Face infrastructure.",Zb,va,Wb,gn,Kr,Pb,sd,Bk="Checks if a file exists in a repository on the Hugging Face Hub.",Vb,ya,Bb,We,ei,Yb,rd,Yk="Gets information about a Collection on the Hub.",Xb,id,Xk='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',zb,xa,Ob,$a,ti,Qb,cd,zk="List all valid dataset tags as a nested namespace object.",Kb,Pe,ni,ev,ld,Ok="Fetches a Discussion’s / Pull Request ‘s details from the Hub.",tv,pd,Qk='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',nv,wa,ov,ka,oi,av,dd,Kk=`Returns the repository name for a given model ID and optional
organization.`,sv,Ta,ai,rv,gd,eT="Fetch metadata of a file versioned on the Hub for a given url.",iv,un,si,cv,ud,tT="Get information about an Inference Endpoint.",lv,ja,pv,qa,ri,dv,hd,nT="List all valid model tags as a nested namespace object",gv,hn,ii,uv,fd,oT="Get information about a repo’s paths.",hv,Ma,fv,ce,ci,mv,md,aT="Fetches Discussions and Pull Requests for the given repo.",_v,_d,sT="Example:",bv,Ha,vv,Ua,yv,P,li,xv,bd,rT="Parse metadata for a safetensors repo on the Hub.",$v,vd,iT=`We first check if the repo has a single safetensors file or a sharded safetensors repo. If it’s a single
safetensors file, we parse the metadata from this file. If it’s a sharded safetensors repo, we parse the
metadata from the index file and then parse the metadata from each shard.`,wv,yd,cT='To parse metadata from a single safetensors file, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',kv,xd,lT='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Tv,Ca,jv,Ia,pi,qv,$d,pT="Gets runtime information about a Space.",Mv,fn,di,Hv,wd,dT="Gets all variables from a Space.",Uv,kd,gT=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,Cv,Ve,gi,Iv,Td,uT="Check if a given <code>token</code> is valid and return its permissions.",Av,Aa,Nv,jd,hT='For more details about tokens, please refer to <a href="https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens" rel="nofollow">https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens</a>.',Jv,Na,ui,Ev,qd,fT="Get an overview of a user on the Hub.",Dv,mn,hi,Rv,Md,mT="Get a webhook by its id.",Gv,Ja,Fv,Be,fi,Sv,Hd,_T="Grant access to a user for a given gated repo.",Lv,Ud,bT=`Granting access don’t require for the user to send an access request by themselves. The user is automatically
added to the accepted list meaning they can download the files You can revoke the granted access at any time
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Zv,Cd,vT='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Wv,V,mi,Pv,Id,yT="Download a given file if it’s not already present in the local cache.",Vv,Ad,xT="The new cache file layout looks like this:",Bv,Nd,$T=`<li>The cache directory contains one subfolder per repo_id (namespaced by repo type)</li> <li>inside each repo folder:<ul><li>refs is a list of the latest known revision =&gt; commit_hash pairs</li> <li>blobs contains the actual file blobs (identified by their git-sha or sha256, depending on
whether they’re LFS files or not)</li> <li>snapshots contains one subfolder per commit, each “commit” contains the subset of the files
that have been resolved at that particular commit. Each filename is a symlink to the blob
at that particular commit.</li></ul></li>`,Yv,Ea,Xv,Jd,wT=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files. While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,zv,Ye,_i,Ov,Ed,kT="Hides a comment on a Discussion / Pull Request.",Qv,Da,Kv,Ra,ey,_n,bi,ty,Dd,TT="Inspect a compute Job on Hugging Face infrastructure.",ny,Ga,oy,le,vi,ay,Rd,jT="Get accepted access requests for a given gated repo.",sy,Gd,qT=`An accepted request means the user has requested access to the repo and the request has been accepted. The user
can download any file of the repo. If the approval mode is automatic, this list should contains by default all
requests. Accepted requests can be cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>. A cancelled request will go back to the pending list while a rejected request will
go to the rejected list. In both cases, the user will lose access to the repo.`,ry,Fd,MT='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',iy,Fa,cy,bn,yi,ly,Sd,HT="List collections on the Huggingface Hub, given some filters.",py,Sa,dy,Xe,xi,gy,Ld,UT="List datasets hosted on the Huggingface Hub, given some filters.",uy,La,hy,Za,fy,pe,$i,my,Zd,CT="List models available in the Hugging Face Inference Catalog.",_y,Wd,IT=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,by,Pd,AT='Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> to deploy a model from the catalog.',vy,Wa,yy,vn,wi,xy,Vd,NT="Lists all inference endpoints for the given namespace.",$y,Pa,wy,Va,ki,ky,Bd,JT="List compute Jobs on Hugging Face infrastructure.",Ty,ze,Ti,jy,Yd,ET="List all LFS files in a repo on the Hub.",qy,Xd,DT=`This is primarily useful to count how much storage a repo is using and to eventually clean up large files
with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.permanently_delete_lfs_files">permanently_delete_lfs_files()</a>. Note that this would be a permanent action that will affect all commits
referencing this deleted files and that cannot be undone.`,My,Ba,Hy,de,ji,Uy,zd,RT="List all public repos liked by a user on huggingface.co.",Cy,Od,GT=`This list is public so token is optional. If <code>user</code> is not passed, it defaults to
the logged in user.`,Iy,Qd,FT='See also <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.unlike">unlike()</a>.',Ay,Ya,Ny,yn,qi,Jy,Kd,ST="List models hosted on the Huggingface Hub, given some filters.",Ey,Xa,Dy,za,Mi,Ry,eg,LT="List of members of an organization on the Hub.",Gy,xn,Hi,Fy,tg,ZT="List daily papers on the Hugging Face Hub given a search query.",Sy,Oa,Ly,ge,Ui,Zy,ng,WT="Get pending access requests for a given gated repo.",Wy,og,PT=`A pending request means the user has requested access to the repo but the request has not been processed yet.
If the approval mode is automatic, this list should be empty. Pending requests can be accepted or rejected
using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Py,ag,VT='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Vy,Qa,By,ue,Ci,Yy,sg,BT="Get rejected access requests for a given gated repo.",Xy,rg,YT=`A rejected request means the user has requested access to the repo and the request has been explicitly rejected
by a repo owner (either you or another user from your organization). The user cannot download any file of the
repo. Rejected requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>. A cancelled request will go back to the pending list while an accepted request will
go to the accepted list.`,zy,ig,XT='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Oy,Ka,Qy,Oe,Ii,Ky,cg,zT="Get the list of commits of a given revision for a repo on the Hub.",ex,lg,OT="Commits are sorted by date (last commit first).",tx,es,nx,ts,Ai,ox,pg,QT="Get the list of files in a given repo.",ax,$n,Ni,sx,dg,KT="List all users who liked a given repo on the hugging Face Hub.",rx,gg,e0='See also <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',ix,wn,Ji,cx,ug,t0="Get the list of refs of a given repo (both tags and branches).",lx,ns,px,F,Ei,dx,hg,n0="List a repo tree’s files and folders and get information about them.",gx,fg,o0="Examples:",ux,mg,a0="Get information about a repo’s tree.",hx,os,fx,_g,s0="Get even more information about a repo’s tree (last commit and files’ security scan results)",mx,as,_x,ss,Di,bx,bg,r0="List spaces hosted on the Huggingface Hub, given some filters.",vx,rs,Ri,yx,vg,i0="Get the list of followers of a user on the Hub.",xx,is,Gi,$x,yg,c0="Get the list of users followed by a user on the Hub.",wx,kn,Fi,kx,xg,l0="List all configured webhooks.",Tx,cs,jx,Tn,Si,qx,$g,p0="Merges a Pull Request.",Mx,ls,Hx,Qe,Li,Ux,wg,d0="Get info on one specific model on huggingface.co",Cx,kg,g0="Model can be private if you pass an acceptable token or are logged in.",Ix,ps,Ax,Ke,Zi,Nx,Tg,u0="Moving a repository from namespace1/repo_name1 to namespace2/repo_name2",Jx,jg,h0=`Note there are certain limitations. For more information about moving
repositories, please see
<a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo</a>.`,Ex,ds,Dx,gs,Wi,Rx,qg,f0="Get information for a paper on the Hub.",Gx,et,Pi,Fx,Mg,m0="Parse metadata from a safetensors file on the Hub.",Sx,Hg,_0='To parse metadata from all safetensors files in a repo at once, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',Lx,Ug,b0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Zx,tt,Vi,Wx,Cg,v0="Pause an Inference Endpoint.",Px,Ig,y0=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, which
would be automatically restarted when a request is made to it.`,Vx,Ag,x0='For convenience, you can also pause an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>.',Bx,nt,Bi,Yx,Ng,$0="Pause your Space.",Xx,Jg,w0=`A paused Space stops executing until manually restarted by its owner. This is different from the sleeping
state in which free Spaces go after 48h of inactivity. Paused time is not billed to your account, no matter the
hardware you’ve selected. To restart your Space, use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a> and go to your Space settings page.`,zx,Eg,k0='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',Ox,ot,Yi,Qx,Dg,T0="Permanently delete LFS files from a repo on the Hub.",Kx,us,e$,hs,t$,B,Xi,n$,Rg,j0="Pre-upload LFS files to S3 in preparation on a future commit.",o$,Gg,q0=`This method is useful if you are generating the files to upload on-the-fly and you don’t want to store them
in memory before uploading them all at once.`,a$,fs,s$,ms,r$,_s,i$,at,zi,c$,Fg,M0="Reject an access request from a user for a given gated repo.",l$,Sg,H0=`A rejected request will go to the rejected list. The user cannot download any file of the repo. Rejected
requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>.
A cancelled request will go back to the pending list while an accepted request will go to the accepted list.`,p$,Lg,U0='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',d$,st,Oi,g$,Zg,C0="Renames a Discussion.",u$,bs,h$,vs,f$,jn,Qi,m$,Wg,I0="Checks if a repository exists on the Hugging Face Hub.",_$,ys,b$,qn,Ki,v$,Pg,A0="Get the info object for a given repo of a given type.",y$,xs,x$,Mn,ec,$$,Vg,N0="Request new hardware for a Space.",w$,$s,k$,Hn,tc,T$,Bg,J0="Request persistent storage for a Space.",j$,ws,q$,rt,nc,M$,Yg,E0="Restart your Space.",H$,Xg,D0=`This is the only way to programmatically restart a Space if you’ve put it on Pause (see <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>). You
must be the owner of the Space to restart it. If you are using an upgraded hardware, your account will be
billed as soon as the Space is restarted. You can trigger a restart no matter the current state of a Space.`,U$,zg,R0='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',C$,Un,oc,I$,Og,G0="Resume an Inference Endpoint.",A$,Qg,F0='For convenience, you can also resume an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.',N$,Cn,ac,J$,Kg,S0="Checks if a specific revision exists on a repo on the Hugging Face Hub.",E$,ks,D$,he,sc,R$,eu,L0="Run a method in the background and return a Future instance.",G$,tu,Z0=`The main goal is to run methods without blocking the main thread (e.g. to push data during a training).
Background jobs are queued to preserve order but are not ran in parallel. If you need to speed-up your scripts
by parallelizing lots of call to the API, you must setup and use your own <a href="https://docs.python.org/3/library/concurrent.futures.html#threadpoolexecutor" rel="nofollow">ThreadPoolExecutor</a>.`,F$,nu,W0=`Note: Most-used methods like <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> have a <code>run_as_future: bool</code>
argument to directly call them in the background. This is equivalent to calling <code>api.run_as_future(...)</code> on them
but less verbose.`,S$,Ts,L$,fe,rc,Z$,ou,P0="Run compute Jobs on Hugging Face infrastructure.",W$,au,V0="Example:",P$,js,V$,qs,B$,In,ic,Y$,su,B0="Run a UV script Job on Hugging Face infrastructure.",X$,Ms,z$,it,cc,O$,ru,Y0="Scale Inference Endpoint to zero.",Q$,iu,X0=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.`,K$,cu,z0='For convenience, you can also scale an Inference Endpoint to zero using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.',e2,ct,lc,t2,lu,O0="Set a custom sleep time for a Space running on upgraded hardware..",n2,pu,Q0=`Your Space will go to sleep after X seconds of inactivity. You are not billed when your Space is in “sleep”
mode. If a new visitor lands on your Space, it will “wake it up”. Only upgraded hardware can have a
configurable sleep time. To know more about the sleep stage, please refer to
<a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a>.`,o2,Hs,a2,me,pc,s2,du,K0="Download repo files.",r2,gu,ej=`Download a whole snapshot of a repo’s files at the specified revision. This is useful when you want all files from
a repo, because you don’t know which ones you will need a priori. All files are nested inside a folder in order
to keep their actual filename relative to that folder. You can also filter which files to download using
<code>allow_patterns</code> and <code>ignore_patterns</code>.`,i2,uu,tj=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files.While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,c2,hu,nj=`An alternative would be to clone the repo but this requires git and git-lfs to be installed and properly
configured. It is also not possible to filter which files to download when cloning a repository using git.`,l2,lt,dc,p2,fu,oj="Get info on one specific Space on huggingface.co.",d2,mu,aj="Space can be private if you pass an acceptable token.",g2,Us,u2,Y,gc,h2,_u,sj="Squash commit history on a branch for a repo on the Hub.",f2,bu,rj=`Squashing the repo history is useful when you know you’ll make hundreds of commits and you don’t want to
clutter the history. Squashing commits can only be performed from the head of a branch.`,m2,Cs,_2,Is,b2,As,v2,_e,uc,y2,vu,ij="Unlike a given repo on the Hub (e.g. remove from favorite list).",x2,yu,cj="To prevent spam usage, it is not possible to <code>like</code> a repository from a script.",$2,xu,lj='See also <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',w2,Ns,k2,An,hc,T2,$u,pj="Update an item in a collection.",j2,Js,q2,be,fc,M2,wu,dj="Update metadata of a collection on the Hub.",H2,ku,gj="All arguments are optional. Only provided metadata will be updated.",U2,Tu,uj='Returns: <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>',C2,Es,I2,pt,mc,A2,ju,hj="Update an Inference Endpoint.",N2,qu,fj=`This method allows the update of either the compute configuration, the deployed model, the route, or any combination.
All arguments are optional but at least one must be provided.`,J2,Mu,mj='For convenience, you can also update an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">InferenceEndpoint.update()</a>.',E2,Nn,_c,D2,Hu,_j="Update the settings of a repository, including gated access and visibility.",R2,Uu,bj=`To give more control over how repos are used, the Hub allows repo authors to enable
access requests for their repos, and also to set the visibility of the repo to private.`,G2,dt,bc,F2,Cu,vj="Update the visibility setting of a repository.",S2,Iu,yj="Deprecated. Use <code>update_repo_settings</code> instead.",L2,Ds,Z2,Jn,vc,W2,Au,xj="Update an existing webhook.",P2,Rs,V2,ve,yc,B2,Nu,$j=`Upload a local file (up to 50 GB) to the given repo. The upload is done
through a HTTP post request, and doesn’t require git or git-lfs to be
installed.`,Y2,Gs,X2,Fs,z2,Ss,O2,N,xc,Q2,Ju,wj=`Upload a local folder to the given repo. The upload is done through a HTTP requests, and doesn’t require git or
git-lfs to be installed.`,K2,Eu,kj=`The structure of the folder will be preserved. Files with the same name already present in the repository will
be overwritten. Others will be left untouched.`,e1,Du,Tj=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters
accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing patterns) as
documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. If both <code>allow_patterns</code> and
<code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,t1,Ru,jj=`Use the <code>delete_patterns</code> argument to specify remote files you want to delete. Input type is the same as for
<code>allow_patterns</code> (see above). If <code>path_in_repo</code> is also provided, the patterns are matched against paths
relative to this folder. For example, <code>upload_folder(..., path_in_repo=&quot;experiment&quot;, delete_patterns=&quot;logs/*&quot;)</code>
will delete any remote file under <code>./experiment/logs/</code>. Note that the <code>.gitattributes</code> file will not be deleted
even if it matches the patterns.`,n1,Gu,qj=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code>
file is not taken into account.`,o1,Fu,Mj="Uses <code>HfApi.create_commit</code> under the hood.",a1,Ls,s1,Zs,r1,Ws,i1,Ps,c1,A,$c,l1,Su,Hj="Upload a large folder to the Hub in the most resilient way possible.",p1,Lu,Uj=`Several workers are started to upload files in an optimized way. Before being committed to a repo, files must be
hashed and be pre-uploaded if they are LFS files. Workers will perform these tasks for each file in the folder.
At each step, some metadata information about the upload process is saved in the folder under <code>.cache/.huggingface/</code>
to be able to resume the process if interrupted. The whole process might result in several commits.`,d1,Vs,g1,Bs,u1,Zu,Cj="<strong>Technical details:</strong>",h1,Wu,Ij="<code>upload_large_folder</code> process is as follow:",f1,Pu,Aj=`<li>(Check parameters and setup.)</li> <li>Create repo if missing.</li> <li>List local files to upload.</li> <li>Start workers. Workers can perform the following tasks:<ul><li>Hash a file.</li> <li>Get upload mode (regular or LFS) for a list of files.</li> <li>Pre-upload an LFS file.</li> <li>Commit a bunch of files.
Once a worker finishes a task, it will move on to the next task based on the priority list (see below) until
all files are uploaded and committed.</li></ul></li> <li>While workers are up, regularly print a report to sys.stdout.</li>`,m1,Vu,Nj="Order of priority:",_1,Bu,Jj="<li>Commit if more than 5 minutes since last commit attempt (and at least 1 file).</li> <li>Commit if at least 150 files are ready to commit.</li> <li>Get upload mode if at least 10 files have been hashed.</li> <li>Pre-upload LFS file if at least 1 file and no worker is pre-uploading.</li> <li>Hash file if at least 1 file and no worker is hashing.</li> <li>Get upload mode if at least 1 file and no worker is getting upload mode.</li> <li>Pre-upload LFS file if at least 1 file (exception: if hf_transfer is enabled, only 1 worker can preupload LFS at a time).</li> <li>Hash file if at least 1 file to hash.</li> <li>Get upload mode if at least 1 file to get upload mode.</li> <li>Commit if at least 1 file to commit and at least 1 min since last commit attempt.</li> <li>Commit if at least 1 file to commit and all other queues are empty.</li>",b1,Yu,Ej="Special rules:",v1,Xu,Dj="<li>If <code>hf_transfer</code> is enabled, only 1 LFS uploader at a time. Otherwise the CPU would be bloated by <code>hf_transfer</code>.</li> <li>Only one worker can commit at a time.</li> <li>If no tasks are available, the worker waits for 10 seconds before checking again.</li>",y1,Ys,wc,x1,zu,Rj="Call HF API to know “whoami”.",gf,kc,uf,Tc,hf,Bn,jc,$1,Ou,Gj="Data structure containing information about a user access request.",ff,qc,mf,ut,Mc,w1,Qu,Fj="Data structure containing information about a newly created commit.",k1,Ku,Sj=`Returned by any method that creates a commit on the Hub: <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>,
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a>. It inherits from <code>str</code> for backward compatibility but using methods specific
to <code>str</code> is deprecated.`,_f,Hc,bf,ht,Uc,T1,eh,Lj='Contains information about a dataset on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a>.',j1,Xs,vf,Cc,yf,Yn,Ic,q1,th,Zj="Contains information about a git reference for a repo on the Hub.",xf,Ac,$f,Xn,Nc,M1,nh,Wj='Contains information about a git commit for a repo on the Hub. Check out <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a> for more details.',wf,Jc,kf,ft,Ec,H1,oh,Pj="Contains information about all git references for a repo on the Hub.",U1,ah,Vj='Object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>.',Tf,Dc,jf,Rc,Gc,qf,Fc,Mf,z,Sc,C1,sh,Bj="Contains information about a file stored as LFS on a repo on the Hub.",I1,rh,Yj=`Used in the context of listing and permanently deleting LFS files from a repo to free-up space.
See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_lfs_files">list_lfs_files()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.permanently_delete_lfs_files">permanently_delete_lfs_files()</a> for more details.`,A1,ih,Xj=`Git LFS files are tracked using SHA-256 object IDs, rather than file paths, to optimize performance
This approach is necessary because a single object can be referenced by multiple paths across different commits,
making it impractical to search and resolve these connections. Check out <a href="https://huggingface.co/docs/hub/storage-limits#advanced-track-lfs-file-references" rel="nofollow">our documentation</a>
to learn how to know which filename(s) is(are) associated with each SHA.`,N1,zs,Hf,Lc,Uf,mt,Zc,J1,ch,zj='Contains information about a model on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>.',E1,Os,Cf,Wc,If,_t,Pc,D1,lh,Oj="Contains basic information about a repo file inside a repo on the Hub.",R1,Qs,Af,Vc,Nf,zn,Bc,G1,ph,Qj="Contains information about a file on the Hub.",Jf,Yc,Ef,O,Xc,F1,dh,Kj="Subclass of <code>str</code> describing a repo URL on the Hub.",S1,gh,eq=`<code>RepoUrl</code> is returned by <code>HfApi.create_repo</code>. It inherits from <code>str</code> for backward
compatibility. At initialization, the URL is parsed to populate properties:`,L1,uh,tq="<li>endpoint (<code>str</code>)</li> <li>namespace (<code>Optional[str]</code>)</li> <li>repo_name (<code>str</code>)</li> <li>repo_id (<code>str</code>)</li> <li>repo_type (<code>Literal[&quot;model&quot;, &quot;dataset&quot;, &quot;space&quot;]</code>)</li> <li>url (<code>str</code>)</li>",Z1,Ks,Df,zc,Rf,Q,Oc,W1,hh,nq="Metadata for a Safetensors repo.",P1,fh,oq=`A repo is considered to be a Safetensors repo if it contains either a ‘model.safetensors’ weight file (non-shared
model) or a ‘model.safetensors.index.json’ index file (sharded model) at its root.`,V1,mh,aq='This class is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',B1,_h,sq='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Gf,Qc,Ff,ye,Kc,Y1,bh,rq="Metadata for a Safetensors file hosted on the Hub.",X1,vh,iq='This class is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',z1,yh,cq='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Sf,el,Lf,bt,tl,O1,xh,lq='Contains information about a Space on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>.',Q1,er,Zf,nl,Wf,vt,ol,K1,$h,pq="Information about a tensor.",ew,wh,dq='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Pf,al,Vf,On,sl,tw,kh,gq="Contains information about a user on the Hub.",Bf,rl,Yf,Qn,il,nw,Th,uq="Contains information about a user likes on the Hub.",Xf,cl,zf,Kn,ll,ow,jh,hq="Data structure containing information about a webhook.",Of,pl,Qf,eo,dl,aw,qh,fq="Data structure containing information about the items watched by a webhook.",Kf,gl,em,ul,mq="Below are the supported values for <code>CommitOperation()</code>:",tm,xe,hl,sw,Mh,_q="Data structure holding necessary info to upload a file to a repository on the Hub.",rw,En,fl,iw,Hh,bq=`A context manager that yields a file-like object allowing to read the underlying
data behind <code>path_or_fileobj</code>.`,cw,tr,lw,Dn,ml,pw,Uh,vq="The base64-encoded content of <code>path_or_fileobj</code>",dw,Ch,yq="Returns: <code>bytes</code>",nm,to,_l,gw,Ih,xq=`Data structure holding necessary info to delete a file or a folder from a repository
on the Hub.`,om,K,bl,uw,Ah,$q="Data structure holding necessary info to copy a file in a repository on the Hub.",hw,Nh,wq="Limitations:",fw,Jh,kq="<li>Only LFS files can be copied. To copy a regular file, you need to download it locally and re-upload it</li> <li>Cross-repository copies are not supported.</li>",mw,Eh,Tq='Note: you can combine a <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> and a <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to rename an LFS file on the Hub.',am,vl,sm,R,yl,_w,Dh,jq="Scheduler to upload a local folder to the Hub at regular intervals (e.g. push to hub every 5 minutes).",bw,Rh,qq=`The recommended way to use the scheduler is to use it as a context manager. This ensures that the scheduler is
properly stopped and the last commit is triggered when the script ends. The scheduler can also be stopped manually
with the <code>stop</code> method. Checkout the <a href="https://huggingface.co/docs/huggingface_hub/guides/upload#scheduled-uploads" rel="nofollow">upload guide</a>
to learn more about how to use it.`,vw,nr,yw,or,xw,gt,xl,$w,Gh,Mq="Push folder to the Hub and return the commit info.",ww,ar,kw,Fh,Hq=`The default behavior of <code>push_to_hub</code> is to assume an append-only folder. It lists all files in the folder and
uploads only changed files. If no changes are found, the method returns without committing anything. If you want
to change this behavior, you can inherit from <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and override this method. This can be useful
for example to compress data together in a single file before committing. For more details and examples, check
out our <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">integration guide</a>.`,Tw,Rn,$l,jw,Sh,Uq="Stop the scheduler.",qw,Lh,Cq="A stopped scheduler cannot be restarted. Mostly for tests purposes.",Mw,Gn,wl,Hw,Zh,Iq="Trigger a <code>push_to_hub</code> and return a future.",Uw,Wh,Aq=`This method is automatically called every <code>every</code> minutes. You can also call it manually to trigger a commit
immediately, without waiting for the next scheduled commit.`,rm,kl,im,sf,cm;return g=new J({props:{title:"HfApi Client",local:"hfapi-client",headingTag:"h1"}}),gr=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbGlzdF9tb2RlbHMlMEElMEElMjMlMjBVc2UlMjByb290JTIwbWV0aG9kJTBBbW9kZWxzJTIwJTNEJTIwbGlzdF9tb2RlbHMoKSUwQSUwQSUyMyUyME9yJTIwY29uZmlndXJlJTIwYSUyMEhmQXBpJTIwY2xpZW50JTBBaGZfYXBpJTIwJTNEJTIwSGZBcGkoJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTIyJTJDJTIwJTIzJTIwQ2FuJTIwYmUlMjBhJTIwUHJpdmF0ZSUyMEh1YiUyMGVuZHBvaW50LiUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyaGZfeHh4JTIyJTJDJTIwJTIzJTIwVG9rZW4lMjBpcyUyMG5vdCUyMHBlcnNpc3RlZCUyMG9uJTIwdGhlJTIwbWFjaGluZS4lMEEpJTBBbW9kZWxzJTIwJTNEJTIwaGZfYXBpLmxpc3RfbW9kZWxzKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, list_models

<span class="hljs-comment"># Use root method</span>
models = list_models()

<span class="hljs-comment"># Or configure a HfApi client</span>
hf_api = HfApi(
    endpoint=<span class="hljs-string">&quot;https://huggingface.co&quot;</span>, <span class="hljs-comment"># Can be a Private Hub endpoint.</span>
    token=<span class="hljs-string">&quot;hf_xxx&quot;</span>, <span class="hljs-comment"># Token is not persisted on the machine.</span>
)
models = hf_api.list_models()`,wrap:!1}}),ur=new J({props:{title:"HfApi",local:"huggingface_hub.HfApi",headingTag:"h2"}}),hr=new M({props:{name:"class huggingface_hub.HfApi",anchor:"huggingface_hub.HfApi",parameters:[{name:"endpoint",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"library_name",val:": Optional[str] = None"},{name:"library_version",val:": Optional[str] = None"},{name:"user_agent",val:": Union[Dict, str, None] = None"},{name:"headers",val:": Optional[Dict[str, str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"},{anchor:"huggingface_hub.HfApi.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the library that is making the HTTP request. Will be added to
the user-agent header. Example: <code>&quot;transformers&quot;</code>.`,name:"library_name"},{anchor:"huggingface_hub.HfApi.library_version",description:`<strong>library_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The version of the library that is making the HTTP request. Will be added
to the user-agent header. Example: <code>&quot;4.24.0&quot;</code>.`,name:"library_version"},{anchor:"huggingface_hub.HfApi.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The user agent info in the form of a dictionary or a single string. It will
be completed with information about the installed packages.`,name:"user_agent"},{anchor:"huggingface_hub.HfApi.headers",description:`<strong>headers</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional headers to be sent with each request. Example: <code>{&quot;X-My-Header&quot;: &quot;value&quot;}</code>.
Headers passed here are taking precedence over the default headers.`,name:"headers"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1671"}}),fr=new M({props:{name:"accept_access_request",anchor:"huggingface_hub.HfApi.accept_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.accept_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to accept access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.accept_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be accepted.`,name:"user"},{anchor:"huggingface_hub.HfApi.accept_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to accept access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.accept_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8974",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the accepted list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),mr=new M({props:{name:"add_collection_item",anchor:"huggingface_hub.HfApi.add_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_id",val:": str"},{name:"item_type",val:": CollectionItemType_T"},{name:"note",val:": Optional[str] = None"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_id",description:`<strong>item_id</strong> (<code>str</code>) &#x2014;
ID of the item to add to the collection. It can be the ID of a repo on the Hub (e.g. <code>&quot;facebook/bart-large-mnli&quot;</code>)
or a paper id (e.g. <code>&quot;2307.09288&quot;</code>).`,name:"item_id"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_type",description:`<strong>item_type</strong> (<code>str</code>) &#x2014;
Type of the item to add. Can be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, <code>&quot;space&quot;</code> or <code>&quot;paper&quot;</code>.`,name:"item_type"},{anchor:"huggingface_hub.HfApi.add_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.add_collection_item.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.add_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8526",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the item you try to add to the collection does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 409 if the item you try to add to the collection is already in the collection (and exists_ok=False)</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ro=new C({props:{anchor:"huggingface_hub.HfApi.add_collection_item.example",$$slots:{default:[Zq]},$$scope:{ctx:T}}}),_r=new M({props:{name:"add_space_secret",anchor:"huggingface_hub.HfApi.add_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_secret.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Secret value. Example: <code>&quot;your_github_api_key&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_secret.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret description. Example: <code>&quot;Github API key to access the Github API&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6975"}}),br=new M({props:{name:"add_space_variable",anchor:"huggingface_hub.HfApi.add_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_variable.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Variable value. Example: <code>&quot;the_model_repo_id&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_variable.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
Description of the variable. Example: <code>&quot;Model Repo ID of the implemented model&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7063"}}),vr=new M({props:{name:"auth_check",anchor:"huggingface_hub.HfApi.auth_check",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.auth_check.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to check for access. Format should be <code>&quot;user/repo_name&quot;</code>.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.auth_check.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository. Should be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, or <code>&quot;space&quot;</code>.
If not specified, the default is <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.auth_check.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9882",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>
<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
Raised if the repository does not exist, is private, or the user does not have access. This can
occur if the <code>repo_id</code> or <code>repo_type</code> is incorrect or if the repository is private but the user
is not authenticated.</p>
</li>
<li>
<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a> —
Raised if the repository exists but is gated and the user is not authorized to access it.</p>
</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a></p>
`}}),Go=new C({props:{anchor:"huggingface_hub.HfApi.auth_check.example",$$slots:{default:[Wq]},$$scope:{ctx:T}}}),yr=new M({props:{name:"cancel_access_request",anchor:"huggingface_hub.HfApi.cancel_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to cancel access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.cancel_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be cancelled.`,name:"user"},{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to cancel access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.cancel_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8934",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the pending list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),xr=new M({props:{name:"cancel_job",anchor:"huggingface_hub.HfApi.cancel_job",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_job.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.cancel_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.cancel_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10228"}}),$r=new M({props:{name:"change_discussion_status",anchor:"huggingface_hub.HfApi.change_discussion_status",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_status",val:": Literal['open', 'closed']"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.change_discussion_status.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.change_discussion_status.new_status",description:`<strong>new_status</strong> (<code>str</code>) &#x2014;
The new status for the discussion, either <code>&quot;open&quot;</code> or <code>&quot;closed&quot;</code>.`,name:"new_status"},{anchor:"huggingface_hub.HfApi.change_discussion_status.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.change_discussion_status.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6717",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),So=new C({props:{anchor:"huggingface_hub.HfApi.change_discussion_status.example",$$slots:{default:[Pq]},$$scope:{ctx:T}}}),Lo=new I({props:{$$slots:{default:[Vq]},$$scope:{ctx:T}}}),wr=new M({props:{name:"comment_discussion",anchor:"huggingface_hub.HfApi.comment_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.comment_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.comment_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.comment_discussion.comment",description:`<strong>comment</strong> (<code>str</code>) &#x2014;
The content of the comment to create. Comments support markdown formatting.`,name:"comment"},{anchor:"huggingface_hub.HfApi.comment_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.comment_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6568",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the newly created comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Zo=new C({props:{anchor:"huggingface_hub.HfApi.comment_discussion.example",$$slots:{default:[Bq]},$$scope:{ctx:T}}}),Wo=new I({props:{$$slots:{default:[Yq]},$$scope:{ctx:T}}}),kr=new M({props:{name:"create_branch",anchor:"huggingface_hub.HfApi.create_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the branch will be created.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to create.`,name:"branch"},{anchor:"huggingface_hub.HfApi.create_branch.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to create the branch from. It can be a branch name or
the OID/SHA of a commit, as a hexadecimal string. Defaults to the head
of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_branch.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if branch already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5909",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. Ex: <code>refs/pr/5</code> or ‘refs/foo/bar’.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Tr=new M({props:{name:"create_collection",anchor:"huggingface_hub.HfApi.create_collection",parameters:[{name:"title",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"private",val:": bool = False"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_collection.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to create. Example: <code>&quot;Recent models&quot;</code>.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_collection.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Namespace of the collection to create (username or org). Will default to the owner name.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_collection.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to create.`,name:"description"},{anchor:"huggingface_hub.HfApi.create_collection.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not. Defaults to <code>False</code> (i.e. public collection).`,name:"private"},{anchor:"huggingface_hub.HfApi.create_collection.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.create_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8349"}}),Vo=new C({props:{anchor:"huggingface_hub.HfApi.create_collection.example",$$slots:{default:[Xq]},$$scope:{ctx:T}}}),jr=new M({props:{name:"create_commit",anchor:"huggingface_hub.HfApi.create_commit",parameters:[{name:"repo_id",val:": str"},{name:"operations",val:": Iterable[CommitOperation]"},{name:"commit_message",val:": str"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_commit.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the commit will be created, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_commit.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <code>CommitOperation()</code>) &#x2014;
An iterable of operations to include in the commit, either:</p>
<ul>
<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> to upload a file</li>
<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to delete a file</li>
<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> to copy a file</li>
</ul>
<p>Operation objects will be mutated to include information relative to the upload. Do not reuse the
same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.create_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that will be created.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.create_commit.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.create_commit.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_commit.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_commit.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_commit.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.create_commit.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.create_commit.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string.
Shorthands (7 first characters) are also supported. If specified and <code>create_pr</code> is <code>False</code>,
the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>. If specified and <code>create_pr</code>
is <code>True</code>, the pull request will be created from <code>parent_commit</code>. Specifying <code>parent_commit</code>
ensures the repo has not changed before committing the changes, and can be especially useful
if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.create_commit.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4054",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If commit message is empty.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If parent commit is not a valid commit OID.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If a README.md file with an invalid metadata section is committed. In this case, the commit will fail
early, before trying to upload any file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>create_pr</code> is <code>True</code> and revision is neither <code>None</code> nor <code>"main"</code>.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Bo=new I({props:{warning:!0,$$slots:{default:[zq]},$$scope:{ctx:T}}}),Yo=new I({props:{warning:!0,$$slots:{default:[Oq]},$$scope:{ctx:T}}}),Xo=new I({props:{warning:!0,$$slots:{default:[Qq]},$$scope:{ctx:T}}}),qr=new M({props:{name:"create_discussion",anchor:"huggingface_hub.HfApi.create_discussion",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"pull_request",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_discussion.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_discussion.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_discussion.pull_request",description:`<strong>pull_request</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to create a Pull Request or discussion. If <code>True</code>, creates a Pull Request.
If <code>False</code>, creates a discussion. Defaults to <code>False</code>.`,name:"pull_request"},{anchor:"huggingface_hub.HfApi.create_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6389"}}),zo=new I({props:{$$slots:{default:[Kq]},$$scope:{ctx:T}}}),Mr=new M({props:{name:"create_inference_endpoint",anchor:"huggingface_hub.HfApi.create_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"repository",val:": str"},{name:"framework",val:": str"},{name:"accelerator",val:": str"},{name:"instance_size",val:": str"},{name:"instance_type",val:": str"},{name:"region",val:": str"},{name:"vendor",val:": str"},{name:"account_id",val:": Optional[str] = None"},{name:"min_replica",val:": int = 1"},{name:"max_replica",val:": int = 1"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"type",val:": InferenceEndpointType = <InferenceEndpointType.PROTECTED: 'protected'>"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name for the new Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.region",description:`<strong>region</strong> (<code>str</code>) &#x2014;
The cloud region in which the Inference Endpoint will be created (e.g. <code>&quot;us-east-1&quot;</code>).`,name:"region"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.vendor",description:`<strong>vendor</strong> (<code>str</code>) &#x2014;
The cloud provider or vendor where the Inference Endpoint will be hosted (e.g. <code>&quot;aws&quot;</code>).`,name:"vendor"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.account_id",description:`<strong>account_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The account ID used to link a VPC to a private Inference Endpoint (if applicable).`,name:"account_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint. To enable
scaling to zero, set this value to 0 and adjust <code>scale_to_zero_timeout</code> accordingly. Defaults to 1.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint. Defaults to 1.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero, or no scaling to zero if
set to None and <code>min_replica</code> is not 0. Defaults to None.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.type",description:"<strong>type</strong> ([`InferenceEndpointType]<code>, *optional*) -- The type of the Inference Endpoint, which can be </code>&#x201C;protected&#x201D;<code>(default),</code>&#x201C;public&#x201D;<code>or</code>&#x201C;private&#x201D;`.",name:"type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint. Defaults to <code>False</code>.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Oo=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example",$$slots:{default:[eM]},$$scope:{ctx:T}}}),Qo=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-2",$$slots:{default:[tM]},$$scope:{ctx:T}}}),Ko=new C({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-3",$$slots:{default:[nM]},$$scope:{ctx:T}}}),Hr=new M({props:{name:"create_inference_endpoint_from_catalog",anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog",parameters:[{name:"repo_id",val:": str"},{name:"name",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"namespace",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The ID of the model in the catalog to deploy as an Inference Endpoint.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The unique name for the new Inference Endpoint. If not provided, a random name will be generated.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7821",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the new Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ea=new I({props:{warning:!0,$$slots:{default:[oM]},$$scope:{ctx:T}}}),Ur=new M({props:{name:"create_pull_request",anchor:"huggingface_hub.HfApi.create_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_pull_request.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_pull_request.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6481"}}),ta=new I({props:{$$slots:{default:[aM]},$$scope:{ctx:T}}}),Cr=new M({props:{name:"create_repo",anchor:"huggingface_hub.HfApi.create_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"private",val:": Optional[bool] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"},{name:"resource_group_id",val:": Optional[str] = None"},{name:"space_sdk",val:": Optional[str] = None"},{name:"space_hardware",val:": Optional[SpaceHardware] = None"},{name:"space_storage",val:": Optional[SpaceStorage] = None"},{name:"space_sleep_time",val:": Optional[int] = None"},{name:"space_secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"space_variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_repo.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.HfApi.create_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_repo.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.create_repo.resource_group_id",description:`<strong>resource_group_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Resource group in which to create the repo. Resource groups is only available for Enterprise Hub organizations and
allow to define which members of the organization can access the resource. The ID of a resource group
can be found in the URL of the resource&#x2019;s page on the Hub (e.g. <code>&quot;66670e5163145ca562cb1988&quot;</code>).
To learn more about resource groups, see <a href="https://huggingface.co/docs/hub/en/security-resource-groups" rel="nofollow">https://huggingface.co/docs/hub/en/security-resource-groups</a>.`,name:"resource_group_id"},{anchor:"huggingface_hub.HfApi.create_repo.space_sdk",description:`<strong>space_sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Choice of SDK to use if repo_type is &#x201C;space&#x201D;. Can be &#x201C;streamlit&#x201D;, &#x201C;gradio&#x201D;, &#x201C;docker&#x201D;, or &#x201C;static&#x201D;.`,name:"space_sdk"},{anchor:"huggingface_hub.HfApi.create_repo.space_hardware",description:`<strong>space_hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware if repo_type is &#x201C;space&#x201D;. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"space_hardware"},{anchor:"huggingface_hub.HfApi.create_repo.space_storage",description:`<strong>space_storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"space_storage"},{anchor:"huggingface_hub.HfApi.create_repo.space_sleep_time",description:`<strong>space_sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"space_sleep_time"},{anchor:"huggingface_hub.HfApi.create_repo.space_secrets",description:`<strong>space_secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"space_secrets"},{anchor:"huggingface_hub.HfApi.create_repo.space_variables",description:`<strong>space_variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"space_variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3620",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`}}),Ir=new M({props:{name:"create_tag",anchor:"huggingface_hub.HfApi.create_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"tag_message",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a commit will be tagged.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to create.`,name:"tag"},{anchor:"huggingface_hub.HfApi.create_tag.tag_message",description:`<strong>tag_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the tag to create.`,name:"tag_message"},{anchor:"huggingface_hub.HfApi.create_tag.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to tag. It can be a branch name or the OID/SHA of a
commit, as a hexadecimal string. Shorthands (7 first characters) are
also supported. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_tag.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if tag already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6041",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Ar=new M({props:{name:"create_webhook",anchor:"huggingface_hub.HfApi.create_webhook",parameters:[{name:"url",val:": str"},{name:"watched",val:": List[Union[Dict, WebhookWatchedItem]]"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_webhook.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL to send the payload to.`,name:"url"},{anchor:"huggingface_hub.HfApi.create_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookWatchedItem">WebhookWatchedItem</a> to be watched by the webhook. It can be users, orgs, models, datasets or spaces.
Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.create_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
List of domains to watch. It can be &#x201C;repo&#x201D;, &#x201C;discussion&#x201D; or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.create_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with.`,name:"secret"},{anchor:"huggingface_hub.HfApi.create_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9253",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the newly created webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),aa=new C({props:{anchor:"huggingface_hub.HfApi.create_webhook.example",$$slots:{default:[sM]},$$scope:{ctx:T}}}),Nr=new M({props:{name:"dataset_info",anchor:"huggingface_hub.HfApi.dataset_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.dataset_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.dataset_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the dataset repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.dataset_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.dataset_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.dataset_info.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>,<code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.dataset_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dataset repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DatasetInfo"
>hf_api.DatasetInfo</a></p>
`}}),sa=new I({props:{$$slots:{default:[rM]},$$scope:{ctx:T}}}),Jr=new M({props:{name:"delete_branch",anchor:"huggingface_hub.HfApi.delete_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a branch will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to delete.`,name:"branch"},{anchor:"huggingface_hub.HfApi.delete_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5989",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a protected branch. Ex: <code>main</code> cannot be deleted.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a branch that does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Er=new M({props:{name:"delete_collection",anchor:"huggingface_hub.HfApi.delete_collection",parameters:[{name:"collection_slug",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to delete. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8485"}}),ia=new C({props:{anchor:"huggingface_hub.HfApi.delete_collection.example",$$slots:{default:[iM]},$$scope:{ctx:T}}}),ca=new I({props:{warning:!0,$$slots:{default:[cM]},$$scope:{ctx:T}}}),Dr=new M({props:{name:"delete_collection_item",anchor:"huggingface_hub.HfApi.delete_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.delete_collection_item.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8661"}}),la=new C({props:{anchor:"huggingface_hub.HfApi.delete_collection_item.example",$$slots:{default:[lM]},$$scope:{ctx:T}}}),Rr=new M({props:{name:"delete_file",anchor:"huggingface_hub.HfApi.delete_file",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the file will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5006"}}),pa=new I({props:{$$slots:{default:[pM]},$$scope:{ctx:T}}}),Gr=new M({props:{name:"delete_files",anchor:"huggingface_hub.HfApi.delete_files",parameters:[{name:"repo_id",val:": str"},{name:"delete_patterns",val:": List[str]"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_files.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code>) &#x2014;
List of files or folders to delete. Each string can either be
a file path, a folder path or a Unix shell-style wildcard.
E.g. <code>[&quot;file.txt&quot;, &quot;folder/&quot;, &quot;data/*.parquet&quot;]</code>`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.delete_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of the repo to delete files from. Can be <code>&quot;model&quot;</code>,
<code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>. Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_files.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary (first line) of the generated commit. Defaults to
<code>f&quot;Delete files using huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_files.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_files.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5096"}}),Fr=new M({props:{name:"delete_folder",anchor:"huggingface_hub.HfApi.delete_folder",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative folder path in the repo, for example: <code>&quot;checkpoints/1fec34a&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the folder is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete folder {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5172"}}),Sr=new M({props:{name:"delete_inference_endpoint",anchor:"huggingface_hub.HfApi.delete_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to delete.`,name:"name"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8093"}}),Lr=new M({props:{name:"delete_repo",anchor:"huggingface_hub.HfApi.delete_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"missing_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_repo.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo does not exist.`,name:"missing_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3769",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to delete from cannot be found and <code>missing_ok</code> is set to False (default).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Zr=new M({props:{name:"delete_space_secret",anchor:"huggingface_hub.HfApi.delete_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>.`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7015"}}),Wr=new M({props:{name:"delete_space_storage",anchor:"huggingface_hub.HfApi.delete_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7499",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>BadRequestError</code> —
If space has no persistent storage.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>BadRequestError</code></p>
`}}),Pr=new M({props:{name:"delete_space_variable",anchor:"huggingface_hub.HfApi.delete_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7104"}}),Vr=new M({props:{name:"delete_tag",anchor:"huggingface_hub.HfApi.delete_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a tag will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to delete.`,name:"tag"},{anchor:"huggingface_hub.HfApi.delete_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6115",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If tag is not found.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),Br=new M({props:{name:"delete_webhook",anchor:"huggingface_hub.HfApi.delete_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to delete.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.delete_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9507",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>None</code></p>
`}}),ha=new C({props:{anchor:"huggingface_hub.HfApi.delete_webhook.example",$$slots:{default:[dM]},$$scope:{ctx:T}}}),Yr=new M({props:{name:"disable_webhook",anchor:"huggingface_hub.HfApi.disable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.disable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to disable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.disable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9456",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the disabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),fa=new C({props:{anchor:"huggingface_hub.HfApi.disable_webhook.example",$$slots:{default:[gM]},$$scope:{ctx:T}}}),Xr=new M({props:{name:"duplicate_space",anchor:"huggingface_hub.HfApi.duplicate_space",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"exist_ok",val:": bool = False"},{name:"hardware",val:": Optional[SpaceHardware] = None"},{name:"storage",val:": Optional[SpaceStorage] = None"},{name:"sleep_time",val:": Optional[int] = None"},{name:"secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.duplicate_space.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
ID of the Space to duplicate. Example: <code>&quot;pharma/CLIP-Interrogator&quot;</code>.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.to_id",description:`<strong>to_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the new Space. Example: <code>&quot;dog/CLIP-Interrogator&quot;</code>. If not provided, the new Space will have the same
name as the original Space, but in your account.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the new Space should be private or not. Defaults to the same privacy as the original Space.`,name:"private"},{anchor:"huggingface_hub.HfApi.duplicate_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.duplicate_space.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.duplicate_space.hardware",description:`<strong>hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware. Example: <code>&quot;t4-medium&quot;</code>. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.duplicate_space.storage",description:`<strong>storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"storage"},{anchor:"huggingface_hub.HfApi.duplicate_space.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.duplicate_space.secrets",description:`<strong>secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.duplicate_space.variables",description:`<strong>variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If one of <code>from_id</code> or <code>to_id</code> cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
If the HuggingFace API returned an error</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <code>HTTPError</code></p>
`}}),ma=new C({props:{anchor:"huggingface_hub.HfApi.duplicate_space.example",$$slots:{default:[uM]},$$scope:{ctx:T}}}),zr=new M({props:{name:"edit_discussion_comment",anchor:"huggingface_hub.HfApi.edit_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"new_content",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.new_content",description:`<strong>new_content</strong> (<code>str</code>) &#x2014;
The new content of the comment. Comments support markdown formatting.`,name:"new_content"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6851",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the edited comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),_a=new I({props:{$$slots:{default:[hM]},$$scope:{ctx:T}}}),Or=new M({props:{name:"enable_webhook",anchor:"huggingface_hub.HfApi.enable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.enable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to enable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.enable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9405",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the enabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),ba=new C({props:{anchor:"huggingface_hub.HfApi.enable_webhook.example",$$slots:{default:[fM]},$$scope:{ctx:T}}}),Qr=new M({props:{name:"fetch_job_logs",anchor:"huggingface_hub.HfApi.fetch_job_logs",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.fetch_job_logs.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.fetch_job_logs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.fetch_job_logs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10053"}}),va=new C({props:{anchor:"huggingface_hub.HfApi.fetch_job_logs.example",$$slots:{default:[mM]},$$scope:{ctx:T}}}),Kr=new M({props:{name:"file_exists",anchor:"huggingface_hub.HfApi.file_exists",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.file_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.file_exists.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file to check, for example:
<code>&quot;config.json&quot;</code>`,name:"filename"},{anchor:"huggingface_hub.HfApi.file_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.file_exists.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.file_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2947",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the file exists, False otherwise.</p>
`}}),ya=new C({props:{anchor:"huggingface_hub.HfApi.file_exists.example",$$slots:{default:[_M]},$$scope:{ctx:T}}}),ei=new M({props:{name:"get_collection",anchor:"huggingface_hub.HfApi.get_collection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection of the Hub. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.get_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8310"}}),xa=new C({props:{anchor:"huggingface_hub.HfApi.get_collection.example",$$slots:{default:[bM]},$$scope:{ctx:T}}}),ti=new M({props:{name:"get_dataset_tags",anchor:"huggingface_hub.HfApi.get_dataset_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1843"}}),ni=new M({props:{name:"get_discussion_details",anchor:"huggingface_hub.HfApi.get_discussion_details",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_discussion_details.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_discussion_details.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6310"}}),wa=new I({props:{$$slots:{default:[vM]},$$scope:{ctx:T}}}),oi=new M({props:{name:"get_full_repo_name",anchor:"huggingface_hub.HfApi.get_full_repo_name",parameters:[{name:"model_id",val:": str"},{name:"organization",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_full_repo_name.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The name of the model.`,name:"model_id"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If passed, the repository name will be in the organization
namespace instead of the user namespace.`,name:"organization"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6164",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository name in the user’s namespace
({username}/{model_id}) if no organization is passed, and under the
organization namespace ({organization}/{model_id}) otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ai=new M({props:{name:"get_hf_file_metadata",anchor:"huggingface_hub.HfApi.get_hf_file_metadata",parameters:[{name:"url",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"timeout",val:": Optional[float] = 10"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
File url, for example returned by <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a>.`,name:"url"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to <code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to 10) &#x2014;
How many seconds to wait for the server to send metadata before giving up.`,name:"timeout"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5359",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.HfFileMetadata"
>HfFileMetadata</a> object containing metadata such as location, etag, size and commit_hash.</p>
`}}),si=new M({props:{name:"get_inference_endpoint",anchor:"huggingface_hub.HfApi.get_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to retrieve information about.`,name:"name"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7909",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the requested Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ja=new C({props:{anchor:"huggingface_hub.HfApi.get_inference_endpoint.example",$$slots:{default:[yM]},$$scope:{ctx:T}}}),ri=new M({props:{name:"get_model_tags",anchor:"huggingface_hub.HfApi.get_model_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1834"}}),ii=new M({props:{name:"get_paths_info",anchor:"huggingface_hub.HfApi.get_paths_info",parameters:[{name:"repo_id",val:": str"},{name:"paths",val:": Union[List[str], str]"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_paths_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_paths_info.paths",description:`<strong>paths</strong> (<code>Union[List[str], str]</code>, <em>optional</em>) &#x2014;
The paths to get information about. If a path do not exist, it is ignored without raising
an exception.`,name:"paths"},{anchor:"huggingface_hub.HfApi.get_paths_info.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the paths (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.get_paths_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_paths_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the information (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_paths_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the paths, as a list of <code>RepoFile</code> and <code>RepoFolder</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),Ma=new C({props:{anchor:"huggingface_hub.HfApi.get_paths_info.example",$$slots:{default:[xM]},$$scope:{ctx:T}}}),ci=new M({props:{name:"get_repo_discussions",anchor:"huggingface_hub.HfApi.get_repo_discussions",parameters:[{name:"repo_id",val:": str"},{name:"author",val:": Optional[str] = None"},{name:"discussion_type",val:": Optional[constants.DiscussionTypeFilter] = None"},{name:"discussion_status",val:": Optional[constants.DiscussionStatusFilter] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass a value to filter by discussion author. <code>None</code> means no filter.
Default is <code>None</code>.`,name:"author"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_type",description:`<strong>discussion_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;pull_request&quot;</code> to fetch only pull requests, <code>&quot;discussion&quot;</code>
to fetch only discussions. Set to <code>&quot;all&quot;</code> or <code>None</code> to fetch both.
Default is <code>None</code>.`,name:"discussion_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_status",description:`<strong>discussion_status</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;open&quot;</code> (respectively <code>&quot;closed&quot;</code>) to fetch only open
(respectively closed) discussions. Set to <code>&quot;all&quot;</code> or <code>None</code>
to fetch both.
Default is <code>None</code>.`,name:"discussion_status"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if fetching from a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if fetching from a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.Discussion"
>Discussion</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterator[Discussion]</code></p>
`}}),Ha=new C({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example",$$slots:{default:[$M]},$$scope:{ctx:T}}}),Ua=new C({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example-2",$$slots:{default:[wM]},$$scope:{ctx:T}}}),li=new M({props:{name:"get_safetensors_metadata",anchor:"huggingface_hub.HfApi.get_safetensors_metadata",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5666",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to safetensors repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsRepoMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),Ca=new C({props:{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.example",$$slots:{default:[kM]},$$scope:{ctx:T}}}),pi=new M({props:{name:"get_space_runtime",anchor:"huggingface_hub.HfApi.get_space_runtime",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_runtime.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_runtime.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7132",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),di=new M({props:{name:"get_space_variables",anchor:"huggingface_hub.HfApi.get_space_variables",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_variables.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to query. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_variables.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7040"}}),gi=new M({props:{name:"get_token_permission",anchor:"huggingface_hub.HfApi.get_token_permission",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_token_permission.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1794",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Permission granted by the token (“read” or “write”). Returns <code>None</code> if no
token passed, if token is invalid or if role is not returned by the server. This typically happens when the token is an OAuth token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Literal["read", "write", "fineGrained", None]</code></p>
`}}),Aa=new I({props:{warning:!0,$$slots:{default:[TM]},$$scope:{ctx:T}}}),ui=new M({props:{name:"get_user_overview",anchor:"huggingface_hub.HfApi.get_user_overview",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_user_overview.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get an overview of.`,name:"username"},{anchor:"huggingface_hub.HfApi.get_user_overview.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9706",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> object with the user’s overview.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>User</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),hi=new M({props:{name:"get_webhook",anchor:"huggingface_hub.HfApi.get_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to get.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.get_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9152",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),Ja=new C({props:{anchor:"huggingface_hub.HfApi.get_webhook.example",$$slots:{default:[jM]},$$scope:{ctx:T}}}),fi=new M({props:{name:"grant_access",anchor:"huggingface_hub.HfApi.grant_access",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.grant_access.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to grant access to.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.grant_access.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user to grant access.`,name:"user"},{anchor:"huggingface_hub.HfApi.grant_access.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to grant access to. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.grant_access.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9097",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the user already has access to the repo.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),mi=new M({props:{name:"hf_hub_download",anchor:"huggingface_hub.HfApi.hf_hub_download",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"subfolder",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"force_download",val:": bool = False"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"resume_download",val:": Optional[bool] = None"},{name:"force_filename",val:": Optional[str] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hf_hub_download.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.hf_hub_download.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional value corresponding to a folder inside the repository.`,name:"subfolder"},{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hf_hub_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.hf_hub_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded file will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in
the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.hf_hub_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.hf_hub_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.hf_hub_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Local path of file or if networking is off, last version of file cached on disk.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the file to download cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> —
If network is disabled or unavailable and file is not found in cache.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> but the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> —
If ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),Ea=new C({props:{anchor:"huggingface_hub.HfApi.hf_hub_download.example",$$slots:{default:[qM]},$$scope:{ctx:T}}}),_i=new M({props:{name:"hide_discussion_comment",anchor:"huggingface_hub.HfApi.hide_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6911",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the hidden comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Da=new I({props:{warning:!0,$$slots:{default:[MM]},$$scope:{ctx:T}}}),Ra=new I({props:{$$slots:{default:[HM]},$$scope:{ctx:T}}}),bi=new M({props:{name:"inspect_job",anchor:"huggingface_hub.HfApi.inspect_job",parameters:[{name:"job_id",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.inspect_job.job_id",description:`<strong>job_id</strong> (<code>str</code>) &#x2014;
ID of the Job.`,name:"job_id"},{anchor:"huggingface_hub.HfApi.inspect_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job is running. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.inspect_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10177"}}),Ga=new C({props:{anchor:"huggingface_hub.HfApi.inspect_job.example",$$slots:{default:[UM]},$$scope:{ctx:T}}}),vi=new M({props:{name:"list_accepted_access_requests",anchor:"huggingface_hub.HfApi.list_accepted_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Fa=new C({props:{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.example",$$slots:{default:[CM]},$$scope:{ctx:T}}}),yi=new M({props:{name:"list_collections",anchor:"huggingface_hub.HfApi.list_collections",parameters:[{name:"owner",val:": Union[List[str], str, None] = None"},{name:"item",val:": Union[List[str], str, None] = None"},{name:"sort",val:": Optional[Literal['lastModified', 'trending', 'upvotes']] = None"},{name:"limit",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_collections.owner",description:`<strong>owner</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter by owner&#x2019;s username.`,name:"owner"},{anchor:"huggingface_hub.HfApi.list_collections.item",description:`<strong>item</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter collections containing a particular items. Example: <code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code>, <code>&quot;datasets/squad&quot;</code> or <code>&quot;papers/2311.12983&quot;</code>.`,name:"item"},{anchor:"huggingface_hub.HfApi.list_collections.sort",description:`<strong>sort</strong> (<code>Literal[&quot;lastModified&quot;, &quot;trending&quot;, &quot;upvotes&quot;]</code>, <em>optional</em>) &#x2014;
Sort collections by last modified, trending or upvotes.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_collections.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of collections to be returned.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_collections.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8251",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection"
>Collection</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Collection]</code></p>
`}}),Sa=new I({props:{warning:!0,$$slots:{default:[IM]},$$scope:{ctx:T}}}),xi=new M({props:{name:"list_datasets",anchor:"huggingface_hub.HfApi.list_datasets",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"benchmark",val:": Optional[Union[str, List[str]]] = None"},{name:"dataset_name",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"language_creators",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"multilinguality",val:": Optional[Union[str, List[str]]] = None"},{name:"size_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"task_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_ids",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"sort",val:": Optional[Union[Literal['last_modified'], str]] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_datasets.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter datasets on the hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_datasets.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned datasets.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_datasets.benchmark",description:`<strong>benchmark</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by their official benchmark.`,name:"benchmark"},{anchor:"huggingface_hub.HfApi.list_datasets.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by its name, such as <code>SQAC</code> or <code>wikineural</code>`,name:"dataset_name"},{anchor:"huggingface_hub.HfApi.list_datasets.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter datasets on the Hub that are gated or not. By default, all datasets are returned.
If <code>gated=True</code> is passed, only gated datasets are returned.
If <code>gated=False</code> is passed, only non-gated datasets are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_datasets.language_creators",description:`<strong>language_creators</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub with how the data was curated, such as <code>crowdsourced</code> or
<code>machine_generated</code>.`,name:"language_creators"},{anchor:"huggingface_hub.HfApi.list_datasets.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a two-character language to
filter datasets by on the Hub.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_datasets.multilinguality",description:`<strong>multilinguality</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a filter for datasets that
contain multiple languages.`,name:"multilinguality"},{anchor:"huggingface_hub.HfApi.list_datasets.size_categories",description:`<strong>size_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the size of the dataset such as <code>100K&lt;n&lt;1M</code> or
<code>1M&lt;n&lt;10M</code>.`,name:"size_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of tags to filter datasets on the Hub.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_datasets.task_categories",description:`<strong>task_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the designed task, such as <code>audio_classification</code> or
<code>named_entity_recognition</code>.`,name:"task_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.task_ids",description:`<strong>task_ids</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the specific task such as <code>speech_emotion_recognition</code> or
<code>paraphrase</code>.`,name:"task_ids"},{anchor:"huggingface_hub.HfApi.list_datasets.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned datasets.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_datasets.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_datasets.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_datasets.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of datasets fetched. Leaving this option
to <code>None</code> fetches all datasets.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_datasets.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_datasets.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all dataset data, including the <code>last_modified</code>,
the <code>card_data</code> and  the files. Can contain useful information such as the
PapersWithCode ID.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_datasets.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2071",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[DatasetInfo]</code></p>
`}}),La=new C({props:{anchor:"huggingface_hub.HfApi.list_datasets.example",$$slots:{default:[AM]},$$scope:{ctx:T}}}),Za=new C({props:{anchor:"huggingface_hub.HfApi.list_datasets.example-2",$$slots:{default:[NM]},$$scope:{ctx:T}}}),$i=new M({props:{name:"list_inference_catalog",anchor:"huggingface_hub.HfApi.list_inference_catalog",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7876",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of model IDs available in the catalog.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>str</code></p>
`}}),Wa=new I({props:{warning:!0,$$slots:{default:[JM]},$$scope:{ctx:T}}}),wi=new M({props:{name:"list_inference_endpoints",anchor:"huggingface_hub.HfApi.list_inference_endpoints",parameters:[{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_endpoints.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace to list endpoints for. Defaults to the current user. Set to <code>&quot;*&quot;</code> to list all endpoints
from all namespaces (i.e. personal namespace and all orgs the user belongs to).`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_inference_endpoints.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7534",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of all inference endpoints for the given namespace.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Pa=new C({props:{anchor:"huggingface_hub.HfApi.list_inference_endpoints.example",$$slots:{default:[EM]},$$scope:{ctx:T}}}),ki=new M({props:{name:"list_jobs",anchor:"huggingface_hub.HfApi.list_jobs",parameters:[{name:"timeout",val:": Optional[int] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_jobs.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.list_jobs.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace from where it lists the jobs. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_jobs.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10145"}}),Ti=new M({props:{name:"list_lfs_files",anchor:"huggingface_hub.HfApi.list_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3495",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <code>LFSFileInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[LFSFileInfo]</code></p>
`}}),Ba=new C({props:{anchor:"huggingface_hub.HfApi.list_lfs_files.example",$$slots:{default:[DM]},$$scope:{ctx:T}}}),ji=new M({props:{name:"list_liked_repos",anchor:"huggingface_hub.HfApi.list_liked_repos",parameters:[{name:"user",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_liked_repos.user",description:`<strong>user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the user for which you want to fetch the likes.`,name:"user"},{anchor:"huggingface_hub.HfApi.list_liked_repos.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2443",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing the user name and 3 lists of repo ids (1 for
models, 1 for datasets and 1 for Spaces).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.UserLikes"
>UserLikes</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>user</code> is not passed and no token found (either from argument or from machine).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ya=new C({props:{anchor:"huggingface_hub.HfApi.list_liked_repos.example",$$slots:{default:[RM]},$$scope:{ctx:T}}}),qi=new M({props:{name:"list_models",anchor:"huggingface_hub.HfApi.list_models",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"inference",val:": Optional[Literal['warm']] = None"},{name:"inference_provider",val:": Optional[Union[Literal['all'], 'PROVIDER_T', List['PROVIDER_T']]] = None"},{name:"library",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"model_name",val:": Optional[str] = None"},{name:"task",val:": Optional[Union[str, List[str]]] = None"},{name:"trained_dataset",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"pipeline_tag",val:": Optional[str] = None"},{name:"emissions_thresholds",val:": Optional[Tuple[float, float]] = None"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"cardData",val:": bool = False"},{name:"fetch_config",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_models.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter models on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_models.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author (user or organization) of the
returned models.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_models.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter models on the Hub that are gated or not. By default, all models are returned.
If <code>gated=True</code> is passed, only gated models are returned.
If <code>gated=False</code> is passed, only non-gated models are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_models.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
If &#x201C;warm&#x201D;, filter models on the Hub currently served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.HfApi.list_models.inference_provider",description:`<strong>inference_provider</strong> (<code>Literal[&quot;all&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
A string to filter models on the Hub that are served by a specific provider.
Pass <code>&quot;all&quot;</code> to get all models served by at least one provider.`,name:"inference_provider"},{anchor:"huggingface_hub.HfApi.list_models.library",description:`<strong>library</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of foundational libraries models were
originally trained from, such as pytorch, tensorflow, or allennlp.`,name:"library"},{anchor:"huggingface_hub.HfApi.list_models.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of languages, both by name and country
code, such as &#x201C;en&#x201D; or &#x201C;English&#x201D;`,name:"language"},{anchor:"huggingface_hub.HfApi.list_models.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that contain complete or partial names for models on the
Hub, such as &#x201C;bert&#x201D; or &#x201C;bert-base-cased&#x201D;`,name:"model_name"},{anchor:"huggingface_hub.HfApi.list_models.task",description:`<strong>task</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of tasks models were designed for, such
as: &#x201C;fill-mask&#x201D; or &#x201C;automatic-speech-recognition&#x201D;`,name:"task"},{anchor:"huggingface_hub.HfApi.list_models.trained_dataset",description:`<strong>trained_dataset</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of string tags of the trained dataset for a
model on the Hub.`,name:"trained_dataset"},{anchor:"huggingface_hub.HfApi.list_models.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of tags to filter models on the Hub by, such
as <code>text-generation</code> or <code>spacy</code>.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_models.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned model ids.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_models.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string pipeline tag to filter models on the Hub by, such as <code>summarization</code>.`,name:"pipeline_tag"},{anchor:"huggingface_hub.HfApi.list_models.emissions_thresholds",description:`<strong>emissions_thresholds</strong> (<code>Tuple</code>, <em>optional</em>) &#x2014;
A tuple of two ints or floats representing a minimum and maximum
carbon footprint to filter the resulting models with in grams.`,name:"emissions_thresholds"},{anchor:"huggingface_hub.HfApi.list_models.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_models.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_models.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of models fetched. Leaving this option
to <code>None</code> fetches all models.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_models.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code>, <code>cardData</code> or <code>fetch_config</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_models.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all model data, including the <code>last_modified</code>,
the <code>sha</code>, the files and the <code>tags</code>. This is set to <code>True</code> by
default when using a filter.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_models.cardData",description:`<strong>cardData</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to grab the metadata for the model as well. Can contain
useful information such as carbon emissions, metrics, and
datasets trained on.`,name:"cardData"},{anchor:"huggingface_hub.HfApi.list_models.fetch_config",description:`<strong>fetch_config</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch the model configs as well. This is not included
in <code>full</code> due to its size.`,name:"fetch_config"},{anchor:"huggingface_hub.HfApi.list_models.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1852",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[ModelInfo]</code></p>
`}}),Xa=new C({props:{anchor:"huggingface_hub.HfApi.list_models.example",$$slots:{default:[GM]},$$scope:{ctx:T}}}),Mi=new M({props:{name:"list_organization_members",anchor:"huggingface_hub.HfApi.list_organization_members",parameters:[{name:"organization",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_organization_members.organization",description:`<strong>organization</strong> (<code>str</code>) &#x2014;
Name of the organization to get the members of.`,name:"organization"},{anchor:"huggingface_hub.HfApi.list_organization_members.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9732",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the members of the organization.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the organization does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Hi=new M({props:{name:"list_papers",anchor:"huggingface_hub.HfApi.list_papers",parameters:[{name:"query",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_papers.query",description:`<strong>query</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A search query string to find papers.
If provided, returns papers that match the query.`,name:"query"},{anchor:"huggingface_hub.HfApi.list_papers.token",description:`<strong>token</strong> (Union[bool, str, None], <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9816",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <code>huggingface_hub.hf_api.PaperInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[PaperInfo]</code></p>
`}}),Oa=new C({props:{anchor:"huggingface_hub.HfApi.list_papers.example",$$slots:{default:[FM]},$$scope:{ctx:T}}}),Ui=new M({props:{name:"list_pending_access_requests",anchor:"huggingface_hub.HfApi.list_pending_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8717",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Qa=new C({props:{anchor:"huggingface_hub.HfApi.list_pending_access_requests.example",$$slots:{default:[SM]},$$scope:{ctx:T}}}),Ci=new M({props:{name:"list_rejected_access_requests",anchor:"huggingface_hub.HfApi.list_rejected_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8843",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ka=new C({props:{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.example",$$slots:{default:[LM]},$$scope:{ctx:T}}}),Ii=new M({props:{name:"list_repo_commits",anchor:"huggingface_hub.HfApi.list_repo_commits",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"revision",val:": Optional[str] = None"},{name:"formatted",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_commits.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_commits.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_commits.formatted",description:`<strong>formatted</strong> (<code>bool</code>) &#x2014;
Whether to return the HTML-formatted title and description of the commits. Defaults to False.`,name:"formatted"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3246",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of objects containing information about the commits for a repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[<a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitCommitInfo"
>GitCommitInfo</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),es=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_commits.example",$$slots:{default:[ZM]},$$scope:{ctx:T}}}),Ai=new M({props:{name:"list_repo_files",anchor:"huggingface_hub.HfApi.list_repo_files",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to
a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3005",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the list of files in a given repository.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Ni=new M({props:{name:"list_repo_likers",anchor:"huggingface_hub.HfApi.list_repo_likers",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to retrieve . Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_likers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2519",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>huggingface_hub.hf_api.User</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`}}),Ji=new M({props:{name:"list_repo_refs",anchor:"huggingface_hub.HfApi.list_repo_refs",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"include_pull_requests",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing refs from a dataset or a Space,
<code>None</code> or <code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_refs.include_pull_requests",description:`<strong>include_pull_requests</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to include refs from pull requests in the list. Defaults to <code>False</code>.`,name:"include_pull_requests"},{anchor:"huggingface_hub.HfApi.list_repo_refs.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3174",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing all information about branches and tags for a
repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefs"
>GitRefs</a></p>
`}}),ns=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_refs.example",$$slots:{default:[WM]},$$scope:{ctx:T}}}),Ei=new M({props:{name:"list_repo_tree",anchor:"huggingface_hub.HfApi.list_repo_tree",parameters:[{name:"repo_id",val:": str"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"recursive",val:": bool = False"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_tree.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the tree (folder) in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root tree (folder) of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.list_repo_tree.recursive",description:`<strong>recursive</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to list tree&#x2019;s files and folders recursively.`,name:"recursive"},{anchor:"huggingface_hub.HfApi.list_repo_tree.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the tree&#x2019;s files and folders (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_repo_tree.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the tree. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the tree (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_tree.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3042",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the tree’s files and folders, as an iterable of <code>RepoFile</code> and <code>RepoFolder</code> objects. The order of the files and folders is
not guaranteed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the tree (folder) does not exist (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a></p>
`}}),os=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example",$$slots:{default:[PM]},$$scope:{ctx:T}}}),as=new C({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example-2",$$slots:{default:[VM]},$$scope:{ctx:T}}}),Di=new M({props:{name:"list_spaces",anchor:"huggingface_hub.HfApi.list_spaces",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"search",val:": Optional[str] = None"},{name:"datasets",val:": Union[str, Iterable[str], None] = None"},{name:"models",val:": Union[str, Iterable[str], None] = None"},{name:"linked",val:": bool = False"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_spaces.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
A string tag or list of tags that can be used to identify Spaces on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_spaces.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned Spaces.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_spaces.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned Spaces.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_spaces.datasets",description:`<strong>datasets</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a dataset.
The name of a specific dataset can be passed as a string.`,name:"datasets"},{anchor:"huggingface_hub.HfApi.list_spaces.models",description:`<strong>models</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a model.
The name of a specific model can be passed as a string.`,name:"models"},{anchor:"huggingface_hub.HfApi.list_spaces.linked",description:`<strong>linked</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of either a model or a dataset.`,name:"linked"},{anchor:"huggingface_hub.HfApi.list_spaces.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_spaces.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_spaces.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of Spaces fetched. Leaving this option
to <code>None</code> fetches all Spaces.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_spaces.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_spaces.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all Spaces data, including the <code>last_modified</code>, <code>siblings</code>
and <code>card_data</code> fields.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_spaces.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2282",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[SpaceInfo]</code></p>
`}}),Ri=new M({props:{name:"list_user_followers",anchor:"huggingface_hub.HfApi.list_user_followers",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_followers.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the followers of.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_followers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9760",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the followers of the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Gi=new M({props:{name:"list_user_following",anchor:"huggingface_hub.HfApi.list_user_following",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_following.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the users followed by.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_following.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9788",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the users followed by the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Fi=new M({props:{name:"list_webhooks",anchor:"huggingface_hub.HfApi.list_webhooks",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_webhooks.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9203",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of webhook info objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[WebhookInfo]</code></p>
`}}),cs=new C({props:{anchor:"huggingface_hub.HfApi.list_webhooks.example",$$slots:{default:[BM]},$$scope:{ctx:T}}}),Si=new M({props:{name:"merge_pull_request",anchor:"huggingface_hub.HfApi.merge_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.merge_pull_request.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.merge_pull_request.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.merge_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6795",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),ls=new I({props:{$$slots:{default:[YM]},$$scope:{ctx:T}}}),Li=new M({props:{name:"model_info",anchor:"huggingface_hub.HfApi.model_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"securityStatus",val:": Optional[bool] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.model_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.model_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the model repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.model_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.model_info.securityStatus",description:`<strong>securityStatus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to retrieve the security status from the model
repository as well. The security status will be returned in the <code>security_repo_status</code> field.`,name:"securityStatus"},{anchor:"huggingface_hub.HfApi.model_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.model_info.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>securityStatus</code> or <code>files_metadata</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;baseModels&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;childrenModelCount&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.model_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The model repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a></p>
`}}),ps=new I({props:{$$slots:{default:[XM]},$$scope:{ctx:T}}}),Zi=new M({props:{name:"move_repo",anchor:"huggingface_hub.HfApi.move_repo",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.move_repo.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Original repository identifier.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.move_repo.to_id",description:`<strong>to_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Final repository identifier.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.move_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.move_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3955"}}),ds=new I({props:{$$slots:{default:[zM]},$$scope:{ctx:T}}}),Wi=new M({props:{name:"paper_info",anchor:"huggingface_hub.HfApi.paper_info",parameters:[{name:"id",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.paper_info.id",description:`<strong>id</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
ArXiv id of the paper.`,name:"id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9862",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>PaperInfo</code> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PaperInfo</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the paper does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Pi=new M({props:{name:"parse_safetensors_file_metadata",anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5806",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to a safetensors file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsFileMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),Vi=new M({props:{name:"pause_inference_endpoint",anchor:"huggingface_hub.HfApi.pause_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to pause.`,name:"name"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8121",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the paused Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Bi=new M({props:{name:"pause_space",anchor:"huggingface_hub.HfApi.pause_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to pause. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.pause_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7257",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space including <code>stage=PAUSED</code> and requested hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can pause it. If you want to manage a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),Yi=new M({props:{name:"permanently_delete_lfs_files",anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"lfs_files",val:": Iterable[LFSFileInfo]"},{name:"rewrite_history",val:": bool = True"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.lfs_files",description:`<strong>lfs_files</strong> (<code>Iterable[LFSFileInfo]</code>) &#x2014;
An iterable of <code>LFSFileInfo</code> items to permanently delete from the repo. Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_lfs_files">list_lfs_files()</a> to list
all LFS files from a repo.`,name:"lfs_files"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.rewrite_history",description:`<strong>rewrite_history</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to rewrite repository history to remove file pointers referencing the deleted LFS files (recommended).`,name:"rewrite_history"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3549"}}),us=new I({props:{warning:!0,$$slots:{default:[OM]},$$scope:{ctx:T}}}),hs=new C({props:{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.example",$$slots:{default:[QM]},$$scope:{ctx:T}}}),Xi=new M({props:{name:"preupload_lfs_files",anchor:"huggingface_hub.HfApi.preupload_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"additions",val:": Iterable[CommitOperationAdd]"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"free_memory",val:": bool = True"},{name:"gitignore_content",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which you will commit the files, for example: <code>&quot;username/custom_transformers&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a>) &#x2014;
The list of files to upload. Warning: the objects in this list will be mutated to include information
relative to the upload. Do not reuse the same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of repository to upload to (e.g. <code>&quot;model&quot;</code> -default-, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not you plan to create a Pull Request with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.gitignore_content",description:`<strong>gitignore_content</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The content of the <code>.gitignore</code> file to know which files should be ignored. The order of priority
is to first check if <code>gitignore_content</code> is passed, then check if the <code>.gitignore</code> file is present
in the list of files to commit and finally default to the <code>.gitignore</code> file already hosted on the Hub
(if any).`,name:"gitignore_content"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4350"}}),fs=new I({props:{warning:!0,$$slots:{default:[KM]},$$scope:{ctx:T}}}),ms=new I({props:{warning:!0,$$slots:{default:[eH]},$$scope:{ctx:T}}}),_s=new C({props:{anchor:"huggingface_hub.HfApi.preupload_lfs_files.example",$$slots:{default:[tH]},$$scope:{ctx:T}}}),zi=new M({props:{name:"reject_access_request",anchor:"huggingface_hub.HfApi.reject_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"rejection_reason",val:": Optional[str]"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.reject_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to reject access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.reject_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be rejected.`,name:"user"},{anchor:"huggingface_hub.HfApi.reject_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to reject access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.reject_access_request.rejection_reason",description:`<strong>rejection_reason</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional rejection reason that will be visible to the user (max 200 characters).`,name:"rejection_reason"},{anchor:"huggingface_hub.HfApi.reject_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9016",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the rejected list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Oi=new M({props:{name:"rename_discussion",anchor:"huggingface_hub.HfApi.rename_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.rename_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.rename_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.rename_discussion.new_title",description:`<strong>new_title</strong> (<code>str</code>) &#x2014;
The new title for the discussion`,name:"new_title"},{anchor:"huggingface_hub.HfApi.rename_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.rename_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6647",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the title change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/community#huggingface_hub.DiscussionTitleChange"
>DiscussionTitleChange</a></p>
`}}),bs=new C({props:{anchor:"huggingface_hub.HfApi.rename_discussion.example",$$slots:{default:[nH]},$$scope:{ctx:T}}}),vs=new I({props:{$$slots:{default:[oH]},$$scope:{ctx:T}}}),Qi=new M({props:{name:"repo_exists",anchor:"huggingface_hub.HfApi.repo_exists",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2856",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository exists, False otherwise.</p>
`}}),ys=new C({props:{anchor:"huggingface_hub.HfApi.repo_exists.example",$$slots:{default:[aH]},$$scope:{ctx:T}}}),Ki=new M({props:{name:"repo_info",anchor:"huggingface_hub.HfApi.repo_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[Union[ExpandModelProperty_T, ExpandDatasetProperty_T, ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.repo_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.repo_info.expand",description:`<strong>expand</strong> (<code>ExpandModelProperty_T</code> or <code>ExpandDatasetProperty_T</code> or <code>ExpandSpaceProperty_T</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
For an exhaustive list of available properties, check out <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.repo_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.repo_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository information, as a
<a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a>, <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a>
or <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SpaceInfo, DatasetInfo, ModelInfo]</code></p>
`}}),xs=new I({props:{$$slots:{default:[sH]},$$scope:{ctx:T}}}),ec=new M({props:{name:"request_space_hardware",anchor:"huggingface_hub.HfApi.request_space_hardware",parameters:[{name:"repo_id",val:": str"},{name:"hardware",val:": SpaceHardware"},{name:"token",val:": Union[bool, str, None] = None"},{name:"sleep_time",val:": Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_hardware.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_hardware.hardware",description:`<strong>hardware</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a>) &#x2014;
Hardware on which to run the Space. Example: <code>&quot;t4-medium&quot;</code>.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.request_space_hardware.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.request_space_hardware.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7153",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),$s=new I({props:{$$slots:{default:[rH]},$$scope:{ctx:T}}}),tc=new M({props:{name:"request_space_storage",anchor:"huggingface_hub.HfApi.request_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"storage",val:": SpaceStorage"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_storage.storage",description:`<strong>storage</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a>) &#x2014;
Storage tier. Either &#x2018;small&#x2019;, &#x2018;medium&#x2019;, or &#x2018;large&#x2019;.`,name:"storage"},{anchor:"huggingface_hub.HfApi.request_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),ws=new I({props:{$$slots:{default:[iH]},$$scope:{ctx:T}}}),nc=new M({props:{name:"restart_space",anchor:"huggingface_hub.HfApi.restart_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"factory_reboot",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.restart_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to restart. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.restart_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.restart_space.factory_reboot",description:`<strong>factory_reboot</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the Space will be rebuilt from scratch without caching any requirements.`,name:"factory_reboot"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7296",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can restart it. If you want to restart a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),oc=new M({props:{name:"resume_inference_endpoint",anchor:"huggingface_hub.HfApi.resume_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"running_ok",val:": bool = True"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to resume.`,name:"name"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.running_ok",description:`<strong>running_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the method will not raise an error if the Inference Endpoint is already running. Defaults to
<code>True</code>.`,name:"running_ok"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the resumed Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ac=new M({props:{name:"revision_exists",anchor:"huggingface_hub.HfApi.revision_exists",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.revision_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.revision_exists.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision of the repository to check.`,name:"revision"},{anchor:"huggingface_hub.HfApi.revision_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.revision_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2900",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository and the revision exists, False otherwise.</p>
`}}),ks=new C({props:{anchor:"huggingface_hub.HfApi.revision_exists.example",$$slots:{default:[cH]},$$scope:{ctx:T}}}),sc=new M({props:{name:"run_as_future",anchor:"huggingface_hub.HfApi.run_as_future",parameters:[{name:"fn",val:": Callable[..., R]"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_as_future.fn",description:`<strong>fn</strong> (<code>Callable</code>) &#x2014;
The method to run in the background.`,name:"fn"},{anchor:"huggingface_hub.HfApi.run_as_future.*args,",description:`<strong>*args,</strong> **kwargs &#x2014;
Arguments with which the method will be called.`,name:"*args,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1719",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a <a
  href="https://docs.python.org/3/library/concurrent.futures.html#future-objects"
  rel="nofollow"
>Future</a> instance to
get the result of the task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Future</code></p>
`}}),Ts=new C({props:{anchor:"huggingface_hub.HfApi.run_as_future.example",$$slots:{default:[lH]},$$scope:{ctx:T}}}),rc=new M({props:{name:"run_job",anchor:"huggingface_hub.HfApi.run_job",parameters:[{name:"image",val:": str"},{name:"command",val:": List[str]"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_job.image",description:`<strong>image</strong> (<code>str</code>) &#x2014;
The Docker image to use.
Examples: <code>&quot;ubuntu&quot;</code>, <code>&quot;python:3.12&quot;</code>, <code>&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</code>.
Example with an image from a Space: <code>&quot;hf.co/spaces/lhoestq/duckdb&quot;</code>.`,name:"image"},{anchor:"huggingface_hub.HfApi.run_job.command",description:`<strong>command</strong> (<code>List[str]</code>) &#x2014;
The command to run. Example: <code>[&quot;echo&quot;, &quot;hello&quot;]</code>.`,name:"command"},{anchor:"huggingface_hub.HfApi.run_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.run_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.run_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.run_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.run_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.run_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9946"}}),js=new C({props:{anchor:"huggingface_hub.HfApi.run_job.example",$$slots:{default:[pH]},$$scope:{ctx:T}}}),qs=new C({props:{anchor:"huggingface_hub.HfApi.run_job.example-2",$$slots:{default:[dH]},$$scope:{ctx:T}}}),ic=new M({props:{name:"run_uv_job",anchor:"huggingface_hub.HfApi.run_uv_job",parameters:[{name:"script",val:": str"},{name:"script_args",val:": Optional[List[str]] = None"},{name:"dependencies",val:": Optional[List[str]] = None"},{name:"python",val:": Optional[str] = None"},{name:"image",val:": Optional[str] = None"},{name:"env",val:": Optional[Dict[str, Any]] = None"},{name:"secrets",val:": Optional[Dict[str, Any]] = None"},{name:"flavor",val:": Optional[SpaceHardware] = None"},{name:"timeout",val:": Optional[Union[int, float, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"_repo",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_uv_job.script",description:`<strong>script</strong> (<code>str</code>) &#x2014;
Path or URL of the UV script.`,name:"script"},{anchor:"huggingface_hub.HfApi.run_uv_job.script_args",description:`<strong>script_args</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Arguments to pass to the script.`,name:"script_args"},{anchor:"huggingface_hub.HfApi.run_uv_job.dependencies",description:`<strong>dependencies</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Dependencies to use to run the UV script.`,name:"dependencies"},{anchor:"huggingface_hub.HfApi.run_uv_job.python",description:`<strong>python</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use a specific Python version. Default is 3.12.`,name:"python"},{anchor:"huggingface_hub.HfApi.run_uv_job.image",description:`<strong>image</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;ghcr.io/astral-sh/uv &#x2014;python3.12-bookworm-slim&#x201D;):
Use a custom Docker image with <code>uv</code> installed.`,name:"image"},{anchor:"huggingface_hub.HfApi.run_uv_job.env",description:`<strong>env</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the environment variables for the Job.`,name:"env"},{anchor:"huggingface_hub.HfApi.run_uv_job.secrets",description:`<strong>secrets</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Defines the secret environment variables for the Job.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.run_uv_job.flavor",description:`<strong>flavor</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Flavor for the hardware, as in Hugging Face Spaces. See <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for possible values.
Defaults to <code>&quot;cpu-basic&quot;</code>.`,name:"flavor"},{anchor:"huggingface_hub.HfApi.run_uv_job.timeout",description:`<strong>timeout</strong> (<code>Union[int, float, str]</code>, <em>optional</em>) &#x2014;
Max duration for the Job: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
Example: <code>300</code> or <code>&quot;5m&quot;</code> for 5 minutes.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.run_uv_job.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Job will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.run_uv_job.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L10257"}}),Ms=new C({props:{anchor:"huggingface_hub.HfApi.run_uv_job.example",$$slots:{default:[gH]},$$scope:{ctx:T}}}),cc=new M({props:{name:"scale_to_zero_inference_endpoint",anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to scale to zero.`,name:"name"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the scaled-to-zero Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),lc=new M({props:{name:"set_space_sleep_time",anchor:"huggingface_hub.HfApi.set_space_sleep_time",parameters:[{name:"repo_id",val:": str"},{name:"sleep_time",val:": int"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.set_space_sleep_time.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to pause (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7206",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Hs=new I({props:{$$slots:{default:[uH]},$$scope:{ctx:T}}}),pc=new M({props:{name:"snapshot_download",anchor:"huggingface_hub.HfApi.snapshot_download",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"force_download",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"max_workers",val:": int = 8"},{name:"tqdm_class",val:": Optional[Type[base_tqdm]] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"},{name:"resume_download",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.snapshot_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.snapshot_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.snapshot_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.snapshot_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded files will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.snapshot_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.snapshot_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.snapshot_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.HfApi.snapshot_download.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are downloaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not downloaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.max_workers",description:`<strong>max_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads to download files (1 thread = 1 file download).
Defaults to 8.`,name:"max_workers"},{anchor:"huggingface_hub.HfApi.snapshot_download.tqdm_class",description:`<strong>tqdm_class</strong> (<code>tqdm</code>, <em>optional</em>) &#x2014;
If provided, overwrites the default behavior for the progress bar. Passed
argument must inherit from <code>tqdm.auto.tqdm</code> or at least mimic its behavior.
Note that the <code>tqdm_class</code> is not passed to each individual download.
Defaults to the custom HF progress bar that can be disabled by setting
<code>HF_HUB_DISABLE_PROGRESS_BARS</code> environment variable.`,name:"tqdm_class"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5541",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>folder path of the repo snapshot.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> and the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> — if
ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
if some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),dc=new M({props:{name:"space_info",anchor:"huggingface_hub.HfApi.space_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.space_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.space_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the space repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.space_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.space_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.space_info.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.space_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2709",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The space repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.SpaceInfo"
>SpaceInfo</a></p>
`}}),Us=new I({props:{$$slots:{default:[hH]},$$scope:{ctx:T}}}),gc=new M({props:{name:"super_squash_history",anchor:"huggingface_hub.HfApi.super_squash_history",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.super_squash_history.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.super_squash_history.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch to squash. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"branch"},{anchor:"huggingface_hub.HfApi.super_squash_history.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The commit message to use for the squashed commit.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.super_squash_history.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.super_squash_history.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3409",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the branch to squash cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. You cannot squash history on tags.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),Cs=new I({props:{warning:!0,$$slots:{default:[fH]},$$scope:{ctx:T}}}),Is=new I({props:{warning:!0,$$slots:{default:[mH]},$$scope:{ctx:T}}}),As=new C({props:{anchor:"huggingface_hub.HfApi.super_squash_history.example",$$slots:{default:[_H]},$$scope:{ctx:T}}}),uc=new M({props:{name:"unlike",anchor:"huggingface_hub.HfApi.unlike",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.unlike.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to unlike. Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.unlike.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.unlike.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if unliking a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if unliking a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2392",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Ns=new C({props:{anchor:"huggingface_hub.HfApi.unlike.example",$$slots:{default:[bH]},$$scope:{ctx:T}}}),hc=new M({props:{name:"update_collection_item",anchor:"huggingface_hub.HfApi.update_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"note",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.update_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.update_collection_item.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the item in the collection.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8608"}}),Js=new C({props:{anchor:"huggingface_hub.HfApi.update_collection_item.example",$$slots:{default:[vH]},$$scope:{ctx:T}}}),fc=new M({props:{name:"update_collection_metadata",anchor:"huggingface_hub.HfApi.update_collection_metadata",parameters:[{name:"collection_slug",val:": str"},{name:"title",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"private",val:": Optional[bool] = None"},{name:"theme",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_metadata.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to update.`,name:"title"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to update.`,name:"description"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the collection in the list of collections of the user.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.theme",description:`<strong>theme</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Theme of the collection on the Hub.`,name:"theme"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8417"}}),Es=new C({props:{anchor:"huggingface_hub.HfApi.update_collection_metadata.example",$$slots:{default:[yH]},$$scope:{ctx:T}}}),mc=new M({props:{name:"update_inference_endpoint",anchor:"huggingface_hub.HfApi.update_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"accelerator",val:": Optional[str] = None"},{name:"instance_size",val:": Optional[str] = None"},{name:"instance_type",val:": Optional[str] = None"},{name:"min_replica",val:": Optional[int] = None"},{name:"max_replica",val:": Optional[int] = None"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"repository",val:": Optional[str] = None"},{name:"framework",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to update.`,name:"name"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment`,name:"env"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be updated. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7956",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),_c=new M({props:{name:"update_repo_settings",anchor:"huggingface_hub.HfApi.update_repo_settings",parameters:[{name:"repo_id",val:": str"},{name:"gated",val:": Optional[Literal['auto', 'manual', False]] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"xet_enabled",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a /.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_settings.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
The gated status for the repository. If set to <code>None</code> (default), the <code>gated</code> setting of the repository won&#x2019;t be updated.<ul>
<li>&#x201C;auto&#x201D;: The repository is gated, and access requests are automatically approved or denied based on predefined criteria.</li>
<li>&#x201C;manual&#x201D;: The repository is gated, and access requests require manual approval.</li>
<li>False : The repository is not gated, and anyone can access it.</li>
</ul>`,name:"gated"},{anchor:"huggingface_hub.HfApi.update_repo_settings.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_settings.token",description:`<strong>token</strong> (<code>Union[str, bool, None]</code>, <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved token,
which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass False.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository to update settings from (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.update_repo_settings.xet_enabled",description:`<strong>xet_enabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be enabled for Xet Storage.`,name:"xet_enabled"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3874",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If gated is not one of “auto”, “manual”, or False.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If repo_type is not one of the values in constants.REPO_TYPES.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the request to the Hugging Face Hub API fails.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/en/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),bc=new M({props:{name:"update_repo_visibility",anchor:"huggingface_hub.HfApi.update_repo_visibility",parameters:[{name:"repo_id",val:": str"},{name:"private",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3819",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The HTTP response in json.</p>
`}}),Ds=new I({props:{$$slots:{default:[xH]},$$scope:{ctx:T}}}),vc=new M({props:{name:"update_webhook",anchor:"huggingface_hub.HfApi.update_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"url",val:": Optional[str] = None"},{name:"watched",val:": Optional[List[Union[Dict, WebhookWatchedItem]]] = None"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to be updated.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.update_webhook.url",description:`<strong>url</strong> (<code>str</code>, optional) &#x2014;
The URL to which the payload will be sent.`,name:"url"},{anchor:"huggingface_hub.HfApi.update_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>, optional) &#x2014;
List of items to watch. It can be users, orgs, models, datasets, or spaces.
Refer to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookWatchedItem">WebhookWatchedItem</a> for more details. Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.update_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
The domains to watch. This can include &#x201C;repo&#x201D;, &#x201C;discussion&#x201D;, or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.update_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with, providing an additional layer of security.`,name:"secret"},{anchor:"huggingface_hub.HfApi.update_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9326",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the updated webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookInfo"
>WebhookInfo</a></p>
`}}),Rs=new C({props:{anchor:"huggingface_hub.HfApi.update_webhook.example",$$slots:{default:[$H]},$$scope:{ctx:T}}}),yc=new M({props:{name:"upload_file",anchor:"huggingface_hub.HfApi.upload_file",parameters:[{name:"path_or_fileobj",val:": Union[str, Path, bytes, BinaryIO]"},{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_file.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>IO</code>) &#x2014;
Path to a file on the local machine or binary data stream /
fileobj / buffer.`,name:"path_or_fileobj"},{anchor:"huggingface_hub.HfApi.upload_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_file.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4565",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),Gs=new I({props:{$$slots:{default:[wH]},$$scope:{ctx:T}}}),Fs=new I({props:{warning:!0,$$slots:{default:[kH]},$$scope:{ctx:T}}}),Ss=new C({props:{anchor:"huggingface_hub.HfApi.upload_file.example",$$slots:{default:[TH]},$$scope:{ctx:T}}}),xc=new M({props:{name:"upload_folder",anchor:"huggingface_hub.HfApi.upload_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"delete_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root folder of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to:
<code>f&quot;Upload {path_in_repo} with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>. If <code>revision</code> is not
set, PR is opened against the <code>&quot;main&quot;</code> branch. If <code>revision</code> is set and is a branch, PR is opened
against this branch. If <code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo while committing
new files. This is useful if you don&#x2019;t know which files have already been uploaded.
Note: to avoid discrepancies the <code>.gitattributes</code> file is not deleted even if it matches the pattern.`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4773",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),Ls=new I({props:{$$slots:{default:[jH]},$$scope:{ctx:T}}}),Zs=new I({props:{warning:!0,$$slots:{default:[qH]},$$scope:{ctx:T}}}),Ws=new I({props:{$$slots:{default:[MH]},$$scope:{ctx:T}}}),Ps=new C({props:{anchor:"huggingface_hub.HfApi.upload_folder.example",$$slots:{default:[HH]},$$scope:{ctx:T}}}),$c=new M({props:{name:"upload_large_folder",anchor:"huggingface_hub.HfApi.upload_large_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"repo_type",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"num_workers",val:": Optional[int] = None"},{name:"print_report",val:": bool = True"},{name:"print_report_every",val:": int = 60"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded.
E.g. <code>&quot;HuggingFaceTB/smollm-corpus&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_large_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system.`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>) &#x2014;
Type of the repository. Must be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Unlike in all other <code>HfApi</code> methods, <code>repo_type</code> is explicitly required here. This is to avoid
any mistake when uploading a large folder to the Hub, and therefore prevent from having to re-upload
everything.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_large_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The branch to commit to. If not provided, the <code>main</code> branch will be used.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_large_folder.private",description:`<strong>private</strong> (<code>bool</code>, <code>optional</code>) &#x2014;
Whether the repository should be private.
If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.HfApi.upload_large_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of workers to start. Defaults to <code>os.cpu_count() - 2</code> (minimum 2).
A higher number of workers may speed up the process if your machine allows it. However, on machines with a
slower connection, it is recommended to keep the number of workers low to ensure better resumability.
Indeed, partially uploaded files will have to be completely re-uploaded if the process is interrupted.`,name:"num_workers"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report",description:`<strong>print_report</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to print a report of the upload progress. Defaults to True.
Report is printed to <code>sys.stdout</code> every X seconds (60 by defaults) and overwrites the previous report.`,name:"print_report"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report_every",description:`<strong>print_report_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frequency at which the report is printed. Defaults to 60 seconds.`,name:"print_report_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5240"}}),Vs=new I({props:{$$slots:{default:[UH]},$$scope:{ctx:T}}}),Bs=new I({props:{warning:!0,$$slots:{default:[CH]},$$scope:{ctx:T}}}),wc=new M({props:{name:"whoami",anchor:"huggingface_hub.HfApi.whoami",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.whoami.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1759"}}),kc=new J({props:{title:"API Dataclasses",local:"api-dataclasses",headingTag:"h2"}}),Tc=new J({props:{title:"AccessRequest",local:"huggingface_hub.hf_api.AccessRequest",headingTag:"h3"}}),jc=new M({props:{name:"class huggingface_hub.hf_api.AccessRequest",anchor:"huggingface_hub.hf_api.AccessRequest",parameters:[{name:"username",val:": str"},{name:"fullname",val:": str"},{name:"email",val:": Optional[str]"},{name:"timestamp",val:": datetime"},{name:"status",val:": Literal['pending', 'accepted', 'rejected']"},{name:"fields",val:": Optional[Dict[str, Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.AccessRequest.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user who requested access.`,name:"username"},{anchor:"huggingface_hub.hf_api.AccessRequest.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
Fullname of the user who requested access.`,name:"fullname"},{anchor:"huggingface_hub.hf_api.AccessRequest.email",description:`<strong>email</strong> (<code>Optional[str]</code>) &#x2014;
Email of the user who requested access.
Can only be <code>None</code> in the /accepted list if the user was granted access manually.`,name:"email"},{anchor:"huggingface_hub.hf_api.AccessRequest.timestamp",description:`<strong>timestamp</strong> (<code>datetime</code>) &#x2014;
Timestamp of the request.`,name:"timestamp"},{anchor:"huggingface_hub.hf_api.AccessRequest.status",description:`<strong>status</strong> (<code>Literal[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>) &#x2014;
Status of the request. Can be one of <code>[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>.`,name:"status"},{anchor:"huggingface_hub.hf_api.AccessRequest.fields",description:`<strong>fields</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional fields filled by the user in the gate form.`,name:"fields"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L460"}}),qc=new J({props:{title:"CommitInfo",local:"huggingface_hub.CommitInfo",headingTag:"h3"}}),Mc=new M({props:{name:"class huggingface_hub.CommitInfo",anchor:"huggingface_hub.CommitInfo",parameters:[{name:"*args",val:""},{name:"commit_url",val:": str"},{name:"_url",val:": Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.CommitInfo.commit_url",description:`<strong>commit_url</strong> (<code>str</code>) &#x2014;
Url where to find the commit.`,name:"commit_url"},{anchor:"huggingface_hub.CommitInfo.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that has been created.`,name:"commit_message"},{anchor:"huggingface_hub.CommitInfo.commit_description",description:`<strong>commit_description</strong> (<code>str</code>) &#x2014;
Description of the commit that has been created. Can be empty.`,name:"commit_description"},{anchor:"huggingface_hub.CommitInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
Commit hash id. Example: <code>&quot;91c54ad1727ee830252e457677f467be0bfd8a57&quot;</code>.`,name:"oid"},{anchor:"huggingface_hub.CommitInfo.pr_url",description:`<strong>pr_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Url to the PR that has been created, if any. Populated when <code>create_pr=True</code>
is passed.`,name:"pr_url"},{anchor:"huggingface_hub.CommitInfo.pr_revision",description:`<strong>pr_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the PR that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Example: <code>&quot;refs/pr/1&quot;</code>.`,name:"pr_revision"},{anchor:"huggingface_hub.CommitInfo.pr_num",description:`<strong>pr_num</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of the PR discussion that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Can be passed as <code>discussion_num</code> in
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">get_discussion_details()</a>. Example: <code>1</code>.`,name:"pr_num"},{anchor:"huggingface_hub.CommitInfo.repo_url",description:`<strong>repo_url</strong> (<code>RepoUrl</code>) &#x2014;
Repo URL of the commit containing info like repo_id, repo_type, etc.`,name:"repo_url"},{anchor:"huggingface_hub.CommitInfo._url",description:`<strong>_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Legacy url for <code>str</code> compatibility. Can be the url to the uploaded file on the Hub (if returned by
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>), to the uploaded folder on the Hub (if returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>) or to the commit on
the Hub (if returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>). Defaults to <code>commit_url</code>. It is deprecated to use this
attribute. Please use <code>commit_url</code> instead.`,name:"_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L380"}}),Hc=new J({props:{title:"DatasetInfo",local:"huggingface_hub.DatasetInfo",headingTag:"h3"}}),Uc=new M({props:{name:"class huggingface_hub.DatasetInfo",anchor:"huggingface_hub.DatasetInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of dataset.`,name:"id"},{anchor:"huggingface_hub.DatasetInfo.author",description:`<strong>author</strong> (<code>str</code>) &#x2014;
Author of the dataset.`,name:"author"},{anchor:"huggingface_hub.DatasetInfo.sha",description:`<strong>sha</strong> (<code>str</code>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.DatasetInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.DatasetInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.DatasetInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.DatasetInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.DatasetInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.DatasetInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the dataset over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.DatasetInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.DatasetInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the dataset.`,name:"likes"},{anchor:"huggingface_hub.DatasetInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the dataset.`,name:"tags"},{anchor:"huggingface_hub.DatasetInfo.card_data",description:`<strong>card_data</strong> (<code>DatasetCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.DatasetCardData">huggingface_hub.repocard_data.DatasetCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.DatasetInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the dataset.`,name:"siblings"},{anchor:"huggingface_hub.DatasetInfo.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Papers with code ID of the dataset.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the dataset.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L941"}}),Xs=new I({props:{$$slots:{default:[IH]},$$scope:{ctx:T}}}),Cc=new J({props:{title:"GitRefInfo",local:"huggingface_hub.GitRefInfo",headingTag:"h3"}}),Ic=new M({props:{name:"class huggingface_hub.GitRefInfo",anchor:"huggingface_hub.GitRefInfo",parameters:[{name:"name",val:": str"},{name:"ref",val:": str"},{name:"target_commit",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.GitRefInfo.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the reference (e.g. tag name or branch name).`,name:"name"},{anchor:"huggingface_hub.GitRefInfo.ref",description:`<strong>ref</strong> (<code>str</code>) &#x2014;
Full git ref on the Hub (e.g. <code>&quot;refs/heads/main&quot;</code> or <code>&quot;refs/tags/v1.0&quot;</code>).`,name:"ref"},{anchor:"huggingface_hub.GitRefInfo.target_commit",description:`<strong>target_commit</strong> (<code>str</code>) &#x2014;
OID of the target commit for the ref (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"target_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1299"}}),Ac=new J({props:{title:"GitCommitInfo",local:"huggingface_hub.GitCommitInfo",headingTag:"h3"}}),Nc=new M({props:{name:"class huggingface_hub.GitCommitInfo",anchor:"huggingface_hub.GitCommitInfo",parameters:[{name:"commit_id",val:": str"},{name:"authors",val:": List[str]"},{name:"created_at",val:": datetime"},{name:"title",val:": str"},{name:"message",val:": str"},{name:"formatted_title",val:": Optional[str]"},{name:"formatted_message",val:": Optional[str]"}],parametersDescription:[{anchor:"huggingface_hub.GitCommitInfo.commit_id",description:`<strong>commit_id</strong> (<code>str</code>) &#x2014;
OID of the commit (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"commit_id"},{anchor:"huggingface_hub.GitCommitInfo.authors",description:`<strong>authors</strong> (<code>List[str]</code>) &#x2014;
List of authors of the commit.`,name:"authors"},{anchor:"huggingface_hub.GitCommitInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>) &#x2014;
Datetime when the commit was created.`,name:"created_at"},{anchor:"huggingface_hub.GitCommitInfo.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the commit. This is a free-text value entered by the authors.`,name:"title"},{anchor:"huggingface_hub.GitCommitInfo.message",description:`<strong>message</strong> (<code>str</code>) &#x2014;
Description of the commit. This is a free-text value entered by the authors.`,name:"message"},{anchor:"huggingface_hub.GitCommitInfo.formatted_title",description:`<strong>formatted_title</strong> (<code>str</code>) &#x2014;
Title of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_title"},{anchor:"huggingface_hub.GitCommitInfo.formatted_message",description:`<strong>formatted_message</strong> (<code>str</code>) &#x2014;
Description of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1344"}}),Jc=new J({props:{title:"GitRefs",local:"huggingface_hub.GitRefs",headingTag:"h3"}}),Ec=new M({props:{name:"class huggingface_hub.GitRefs",anchor:"huggingface_hub.GitRefs",parameters:[{name:"branches",val:": List[GitRefInfo]"},{name:"converts",val:": List[GitRefInfo]"},{name:"tags",val:": List[GitRefInfo]"},{name:"pull_requests",val:": Optional[List[GitRefInfo]] = None"}],parametersDescription:[{anchor:"huggingface_hub.GitRefs.branches",description:`<strong>branches</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about branches on the repo.`,name:"branches"},{anchor:"huggingface_hub.GitRefs.converts",description:`<strong>converts</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about &#x201C;convert&#x201D; refs on the repo.
Converts are refs used (internally) to push preprocessed data in Dataset repos.`,name:"converts"},{anchor:"huggingface_hub.GitRefs.tags",description:`<strong>tags</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about tags on the repo.`,name:"tags"},{anchor:"huggingface_hub.GitRefs.pull_requests",description:`<strong>pull_requests</strong> (<code>List[GitRefInfo]</code>, <em>optional</em>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about pull requests on the repo.
Only returned if <code>include_prs=True</code> is set.`,name:"pull_requests"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1318"}}),Dc=new J({props:{title:"InferenceProviderMapping",local:"huggingface_hub.hf_api.InferenceProviderMapping",headingTag:"h3"}}),Gc=new M({props:{name:"class huggingface_hub.hf_api.InferenceProviderMapping",anchor:"huggingface_hub.hf_api.InferenceProviderMapping",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L717"}}),Fc=new J({props:{title:"LFSFileInfo",local:"huggingface_hub.hf_api.LFSFileInfo",headingTag:"h3"}}),Sc=new M({props:{name:"class huggingface_hub.hf_api.LFSFileInfo",anchor:"huggingface_hub.hf_api.LFSFileInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.LFSFileInfo.file_oid",description:`<strong>file_oid</strong> (<code>str</code>) &#x2014;
SHA-256 object ID of the file. This is the identifier to pass when permanently deleting the file.`,name:"file_oid"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
Possible filename for the LFS object. See the note above for more information.`,name:"filename"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
OID of the LFS object.`,name:"oid"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.pushed_at",description:`<strong>pushed_at</strong> (<code>datetime</code>) &#x2014;
Date the LFS object was pushed to the repo.`,name:"pushed_at"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.ref",description:`<strong>ref</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Ref where the LFS object has been pushed (if any).`,name:"ref"},{anchor:"huggingface_hub.hf_api.LFSFileInfo.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
Size of the LFS object.`,name:"size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1577"}}),zs=new C({props:{anchor:"huggingface_hub.hf_api.LFSFileInfo.example",$$slots:{default:[AH]},$$scope:{ctx:T}}}),Lc=new J({props:{title:"ModelInfo",local:"huggingface_hub.ModelInfo",headingTag:"h3"}}),Zc=new M({props:{name:"class huggingface_hub.ModelInfo",anchor:"huggingface_hub.ModelInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of model.`,name:"id"},{anchor:"huggingface_hub.ModelInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the model.`,name:"author"},{anchor:"huggingface_hub.ModelInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.ModelInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.ModelInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.ModelInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.ModelInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.ModelInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the model over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.ModelInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.ModelInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.ModelInfo.gguf",description:`<strong>gguf</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
GGUF information of the model.`,name:"gguf"},{anchor:"huggingface_hub.ModelInfo.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
Status of the model on Inference Providers. Warm if the model is served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.ModelInfo.inference_provider_mapping",description:`<strong>inference_provider_mapping</strong> (<code>List[InferenceProviderMapping]</code>, <em>optional</em>) &#x2014;
A list of <code>InferenceProviderMapping</code> ordered after the user&#x2019;s provider order.`,name:"inference_provider_mapping"},{anchor:"huggingface_hub.ModelInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the model.`,name:"likes"},{anchor:"huggingface_hub.ModelInfo.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Library associated with the model.`,name:"library_name"},{anchor:"huggingface_hub.ModelInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the model. Compared to <code>card_data.tags</code>, contains extra tags computed by the Hub
(e.g. supported libraries, model&#x2019;s arXiv).`,name:"tags"},{anchor:"huggingface_hub.ModelInfo.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pipeline tag associated with the model.`,name:"pipeline_tag"},{anchor:"huggingface_hub.ModelInfo.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mask token used by the model.`,name:"mask_token"},{anchor:"huggingface_hub.ModelInfo.widget_data",description:`<strong>widget_data</strong> (<code>Any</code>, <em>optional</em>) &#x2014;
Widget data associated with the model.`,name:"widget_data"},{anchor:"huggingface_hub.ModelInfo.model_index",description:`<strong>model_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model index for evaluation.`,name:"model_index"},{anchor:"huggingface_hub.ModelInfo.config",description:`<strong>config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model configuration.`,name:"config"},{anchor:"huggingface_hub.ModelInfo.transformers_info",description:`<strong>transformers_info</strong> (<code>TransformersInfo</code>, <em>optional</em>) &#x2014;
Transformers-specific info (auto class, processor, etc.) associated with the model.`,name:"transformers_info"},{anchor:"huggingface_hub.ModelInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the model.`,name:"trending_score"},{anchor:"huggingface_hub.ModelInfo.card_data",description:`<strong>card_data</strong> (<code>ModelCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.ModelCardData">huggingface_hub.repocard_data.ModelCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.ModelInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the model.`,name:"siblings"},{anchor:"huggingface_hub.ModelInfo.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of spaces using the model.`,name:"spaces"},{anchor:"huggingface_hub.ModelInfo.safetensors",description:`<strong>safetensors</strong> (<code>SafeTensorsInfo</code>, <em>optional</em>) &#x2014;
Model&#x2019;s safetensors information.`,name:"safetensors"},{anchor:"huggingface_hub.ModelInfo.security_repo_status",description:`<strong>security_repo_status</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model&#x2019;s security scan status.`,name:"security_repo_status"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L742"}}),Os=new I({props:{$$slots:{default:[NH]},$$scope:{ctx:T}}}),Wc=new J({props:{title:"RepoSibling",local:"huggingface_hub.hf_api.RepoSibling",headingTag:"h3"}}),Pc=new M({props:{name:"class huggingface_hub.hf_api.RepoSibling",anchor:"huggingface_hub.hf_api.RepoSibling",parameters:[{name:"rfilename",val:": str"},{name:"size",val:": Optional[int] = None"},{name:"blob_id",val:": Optional[str] = None"},{name:"lfs",val:": Optional[BlobLfsInfo] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoSibling.rfilename",description:`<strong>rfilename</strong> (str) &#x2014;
file name, relative to the repo root.`,name:"rfilename"},{anchor:"huggingface_hub.hf_api.RepoSibling.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The file&#x2019;s size, in bytes. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set
to <code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoSibling.blob_id",description:`<strong>blob_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file&#x2019;s git OID. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoSibling.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s LFS metadata. This attribute is defined when<code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code> and the file is stored with Git LFS. It&#x2019;s <code>None</code> otherwise.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L593"}}),Qs=new I({props:{$$slots:{default:[JH]},$$scope:{ctx:T}}}),Vc=new J({props:{title:"RepoFile",local:"huggingface_hub.hf_api.RepoFile",headingTag:"h3"}}),Bc=new M({props:{name:"class huggingface_hub.hf_api.RepoFile",anchor:"huggingface_hub.hf_api.RepoFile",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoFile.path",description:`<strong>path</strong> (str) &#x2014;
file path relative to the repo root.`,name:"path"},{anchor:"huggingface_hub.hf_api.RepoFile.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
The file&#x2019;s size, in bytes.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoFile.blob_id",description:`<strong>blob_id</strong> (<code>str</code>) &#x2014;
The file&#x2019;s git OID.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoFile.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>) &#x2014;
The file&#x2019;s LFS metadata.`,name:"lfs"},{anchor:"huggingface_hub.hf_api.RepoFile.last_commit",description:`<strong>last_commit</strong> (<code>LastCommitInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s last commit metadata. Only defined if <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"last_commit"},{anchor:"huggingface_hub.hf_api.RepoFile.security",description:`<strong>security</strong> (<code>BlobSecurityInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s security scan metadata. Only defined if <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"security"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L628"}}),Yc=new J({props:{title:"RepoUrl",local:"huggingface_hub.RepoUrl",headingTag:"h3"}}),Xc=new M({props:{name:"class huggingface_hub.RepoUrl",anchor:"huggingface_hub.RepoUrl",parameters:[{name:"url",val:": Any"},{name:"endpoint",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoUrl.url",description:`<strong>url</strong> (<code>Any</code>) &#x2014;
String value of the repo url.`,name:"url"},{anchor:"huggingface_hub.RepoUrl.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L532",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If URL cannot be parsed.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>repo_type</code> is unknown.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ks=new C({props:{anchor:"huggingface_hub.RepoUrl.example",$$slots:{default:[EH]},$$scope:{ctx:T}}}),zc=new J({props:{title:"SafetensorsRepoMetadata",local:"huggingface_hub.utils.SafetensorsRepoMetadata",headingTag:"h3"}}),Oc=new M({props:{name:"class huggingface_hub.utils.SafetensorsRepoMetadata",anchor:"huggingface_hub.utils.SafetensorsRepoMetadata",parameters:[{name:"metadata",val:": typing.Optional[typing.Dict]"},{name:"sharded",val:": bool"},{name:"weight_map",val:": typing.Dict[str, str]"},{name:"files_metadata",val:": typing.Dict[str, huggingface_hub.utils._safetensors.SafetensorsFileMetadata]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The metadata contained in the &#x2018;model.safetensors.index.json&#x2019; file, if it exists. Only populated for sharded
models.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.sharded",description:`<strong>sharded</strong> (<code>bool</code>) &#x2014;
Whether the repo contains a sharded model or not.`,name:"sharded"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.weight_map",description:`<strong>weight_map</strong> (<code>Dict[str, str]</code>) &#x2014;
A map of all weights. Keys are tensor names and values are filenames of the files containing the tensors.`,name:"weight_map"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.files_metadata",description:`<strong>files_metadata</strong> (<code>Dict[str, SafetensorsFileMetadata]</code>) &#x2014;
A map of all files metadata. Keys are filenames and values are the metadata of the corresponding file, as
a <code>SafetensorsFileMetadata</code> object.`,name:"files_metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L73"}}),Qc=new J({props:{title:"SafetensorsFileMetadata",local:"huggingface_hub.utils.SafetensorsFileMetadata",headingTag:"h3"}}),Kc=new M({props:{name:"class huggingface_hub.utils.SafetensorsFileMetadata",anchor:"huggingface_hub.utils.SafetensorsFileMetadata",parameters:[{name:"metadata",val:": typing.Dict[str, str]"},{name:"tensors",val:": typing.Dict[str, huggingface_hub.utils._safetensors.TensorInfo]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>) &#x2014;
The metadata contained in the file.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.tensors",description:`<strong>tensors</strong> (<code>Dict[str, TensorInfo]</code>) &#x2014;
A map of all tensors. Keys are tensor names and values are information about the corresponding tensor, as a
<code>TensorInfo</code> object.`,name:"tensors"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L43"}}),el=new J({props:{title:"SpaceInfo",local:"huggingface_hub.SpaceInfo",headingTag:"h3"}}),tl=new M({props:{name:"class huggingface_hub.SpaceInfo",anchor:"huggingface_hub.SpaceInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the Space.`,name:"id"},{anchor:"huggingface_hub.SpaceInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the Space.`,name:"author"},{anchor:"huggingface_hub.SpaceInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.SpaceInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.SpaceInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.SpaceInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.SpaceInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.SpaceInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the Space disabled.`,name:"disabled"},{anchor:"huggingface_hub.SpaceInfo.host",description:`<strong>host</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Host URL of the Space.`,name:"host"},{anchor:"huggingface_hub.SpaceInfo.subdomain",description:`<strong>subdomain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Subdomain of the Space.`,name:"subdomain"},{anchor:"huggingface_hub.SpaceInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the Space.`,name:"likes"},{anchor:"huggingface_hub.SpaceInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the Space.`,name:"tags"},{anchor:"huggingface_hub.SpaceInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the Space.`,name:"siblings"},{anchor:"huggingface_hub.SpaceInfo.card_data",description:`<strong>card_data</strong> (<code>SpaceCardData</code>, <em>optional</em>) &#x2014;
Space Card Metadata  as a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.SpaceCardData">huggingface_hub.repocard_data.SpaceCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.SpaceInfo.runtime",description:`<strong>runtime</strong> (<code>SpaceRuntime</code>, <em>optional</em>) &#x2014;
Space runtime information as a <a href="/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceRuntime">huggingface_hub.hf_api.SpaceRuntime</a> object.`,name:"runtime"},{anchor:"huggingface_hub.SpaceInfo.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK used by the Space.`,name:"sdk"},{anchor:"huggingface_hub.SpaceInfo.models",description:`<strong>models</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of models used by the Space.`,name:"models"},{anchor:"huggingface_hub.SpaceInfo.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets used by the Space.`,name:"datasets"},{anchor:"huggingface_hub.SpaceInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the Space.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1060"}}),er=new I({props:{$$slots:{default:[DH]},$$scope:{ctx:T}}}),nl=new J({props:{title:"TensorInfo",local:"huggingface_hub.utils.TensorInfo",headingTag:"h3"}}),ol=new M({props:{name:"class huggingface_hub.utils.TensorInfo",anchor:"huggingface_hub.utils.TensorInfo",parameters:[{name:"dtype",val:": typing.Literal['F64', 'F32', 'F16', 'BF16', 'I64', 'I32', 'I16', 'I8', 'U8', 'BOOL']"},{name:"shape",val:": typing.List[int]"},{name:"data_offsets",val:": typing.Tuple[int, int]"}],parametersDescription:[{anchor:"huggingface_hub.utils.TensorInfo.dtype",description:`<strong>dtype</strong> (<code>str</code>) &#x2014;
The data type of the tensor (&#x201C;F64&#x201D;, &#x201C;F32&#x201D;, &#x201C;F16&#x201D;, &#x201C;BF16&#x201D;, &#x201C;I64&#x201D;, &#x201C;I32&#x201D;, &#x201C;I16&#x201D;, &#x201C;I8&#x201D;, &#x201C;U8&#x201D;, &#x201C;BOOL&#x201D;).`,name:"dtype"},{anchor:"huggingface_hub.utils.TensorInfo.shape",description:`<strong>shape</strong> (<code>List[int]</code>) &#x2014;
The shape of the tensor.`,name:"shape"},{anchor:"huggingface_hub.utils.TensorInfo.data_offsets",description:`<strong>data_offsets</strong> (<code>Tuple[int, int]</code>) &#x2014;
The offsets of the data in the file as a tuple <code>[BEGIN, END]</code>.`,name:"data_offsets"},{anchor:"huggingface_hub.utils.TensorInfo.parameter_count",description:`<strong>parameter_count</strong> (<code>int</code>) &#x2014;
The number of parameters in the tensor.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L13"}}),al=new J({props:{title:"User",local:"huggingface_hub.User",headingTag:"h3"}}),sl=new M({props:{name:"class huggingface_hub.User",anchor:"huggingface_hub.User",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.User.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Name of the user on the Hub (unique).`,name:"username"},{anchor:"huggingface_hub.User.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
User&#x2019;s full name.`,name:"fullname"},{anchor:"huggingface_hub.User.avatar_url",description:`<strong>avatar_url</strong> (<code>str</code>) &#x2014;
URL of the user&#x2019;s avatar.`,name:"avatar_url"},{anchor:"huggingface_hub.User.details",description:`<strong>details</strong> (<code>str</code>, <em>optional</em>) &#x2014;
User&#x2019;s details.`,name:"details"},{anchor:"huggingface_hub.User.is_following",description:`<strong>is_following</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the authenticated user is following this user.`,name:"is_following"},{anchor:"huggingface_hub.User.is_pro",description:`<strong>is_pro</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the user is a pro user.`,name:"is_pro"},{anchor:"huggingface_hub.User.num_models",description:`<strong>num_models</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of models created by the user.`,name:"num_models"},{anchor:"huggingface_hub.User.num_datasets",description:`<strong>num_datasets</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of datasets created by the user.`,name:"num_datasets"},{anchor:"huggingface_hub.User.num_spaces",description:`<strong>num_spaces</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of spaces created by the user.`,name:"num_spaces"},{anchor:"huggingface_hub.User.num_discussions",description:`<strong>num_discussions</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of discussions initiated by the user.`,name:"num_discussions"},{anchor:"huggingface_hub.User.num_papers",description:`<strong>num_papers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of papers authored by the user.`,name:"num_papers"},{anchor:"huggingface_hub.User.num_upvotes",description:`<strong>num_upvotes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of upvotes received by the user.`,name:"num_upvotes"},{anchor:"huggingface_hub.User.num_likes",description:`<strong>num_likes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of likes given by the user.`,name:"num_likes"},{anchor:"huggingface_hub.User.num_following",description:`<strong>num_following</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users this user is following.`,name:"num_following"},{anchor:"huggingface_hub.User.num_followers",description:`<strong>num_followers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users following this user.`,name:"num_followers"},{anchor:"huggingface_hub.User.orgs",description:`<strong>orgs</strong> (list of <code>Organization</code>) &#x2014;
List of organizations the user is part of.`,name:"orgs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1432"}}),rl=new J({props:{title:"UserLikes",local:"huggingface_hub.UserLikes",headingTag:"h3"}}),il=new M({props:{name:"class huggingface_hub.UserLikes",anchor:"huggingface_hub.UserLikes",parameters:[{name:"user",val:": str"},{name:"total",val:": int"},{name:"datasets",val:": List[str]"},{name:"models",val:": List[str]"},{name:"spaces",val:": List[str]"}],parametersDescription:[{anchor:"huggingface_hub.UserLikes.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
Name of the user for which we fetched the likes.`,name:"user"},{anchor:"huggingface_hub.UserLikes.total",description:`<strong>total</strong> (<code>int</code>) &#x2014;
Total number of likes.`,name:"total"},{anchor:"huggingface_hub.UserLikes.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>) &#x2014;
List of datasets liked by the user (as repo_ids).`,name:"datasets"},{anchor:"huggingface_hub.UserLikes.models",description:`<strong>models</strong> (<code>List[str]</code>) &#x2014;
List of models liked by the user (as repo_ids).`,name:"models"},{anchor:"huggingface_hub.UserLikes.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>) &#x2014;
List of spaces liked by the user (as repo_ids).`,name:"spaces"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1377"}}),cl=new J({props:{title:"WebhookInfo",local:"huggingface_hub.WebhookInfo",headingTag:"h3"}}),ll=new M({props:{name:"class huggingface_hub.WebhookInfo",anchor:"huggingface_hub.WebhookInfo",parameters:[{name:"id",val:": str"},{name:"url",val:": str"},{name:"watched",val:": List[WebhookWatchedItem]"},{name:"domains",val:": List[constants.WEBHOOK_DOMAIN_T]"},{name:"secret",val:": Optional[str]"},{name:"disabled",val:": bool"}],parametersDescription:[{anchor:"huggingface_hub.WebhookInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the webhook.`,name:"id"},{anchor:"huggingface_hub.WebhookInfo.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL of the webhook.`,name:"url"},{anchor:"huggingface_hub.WebhookInfo.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of items watched by the webhook, see <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.WebhookWatchedItem">WebhookWatchedItem</a>.`,name:"watched"},{anchor:"huggingface_hub.WebhookInfo.domains",description:`<strong>domains</strong> (<code>List[WEBHOOK_DOMAIN_T]</code>) &#x2014;
List of domains the webhook is watching. Can be one of <code>[&quot;repo&quot;, &quot;discussions&quot;]</code>.`,name:"domains"},{anchor:"huggingface_hub.WebhookInfo.secret",description:`<strong>secret</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret of the webhook.`,name:"secret"},{anchor:"huggingface_hub.WebhookInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>) &#x2014;
Whether the webhook is disabled or not.`,name:"disabled"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L505"}}),pl=new J({props:{title:"WebhookWatchedItem",local:"huggingface_hub.WebhookWatchedItem",headingTag:"h3"}}),dl=new M({props:{name:"class huggingface_hub.WebhookWatchedItem",anchor:"huggingface_hub.WebhookWatchedItem",parameters:[{name:"type",val:": Literal['dataset', 'model', 'org', 'space', 'user']"},{name:"name",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.WebhookWatchedItem.type",description:`<strong>type</strong> (<code>Literal[&quot;dataset&quot;, &quot;model&quot;, &quot;org&quot;, &quot;space&quot;, &quot;user&quot;]</code>) &#x2014;
Type of the item to be watched. Can be one of <code>[&quot;dataset&quot;, &quot;model&quot;, &quot;org&quot;, &quot;space&quot;, &quot;user&quot;]</code>.`,name:"type"},{anchor:"huggingface_hub.WebhookWatchedItem.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the item to be watched. Can be the username, organization name, model name, dataset name or space name.`,name:"name"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L490"}}),gl=new J({props:{title:"CommitOperation",local:"huggingface_hub.CommitOperationAdd",headingTag:"h2"}}),hl=new M({props:{name:"class huggingface_hub.CommitOperationAdd",anchor:"huggingface_hub.CommitOperationAdd",parameters:[{name:"path_in_repo",val:": str"},{name:"path_or_fileobj",val:": typing.Union[str, pathlib.Path, bytes, typing.BinaryIO]"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationAdd.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>BinaryIO</code>) &#x2014;
Either:<ul>
<li>a path to a local file (as <code>str</code> or <code>pathlib.Path</code>) to upload</li>
<li>a buffer of bytes (<code>bytes</code>) holding the content of the file to upload</li>
<li>a &#x201C;file object&#x201D; (subclass of <code>io.BufferedIOBase</code>), typically obtained
with <code>open(path, &quot;rb&quot;)</code>. It must support <code>seek()</code> and <code>tell()</code> methods.</li>
</ul>`,name:"path_or_fileobj"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L123",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is not one of <code>str</code>, <code>Path</code>, <code>bytes</code> or <code>io.BufferedIOBase</code>.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>str</code> or <code>Path</code> but not a path to an existing file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>io.BufferedIOBase</code> but it doesn’t support both
<code>seek()</code> and <code>tell()</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),fl=new M({props:{name:"as_file",anchor:"huggingface_hub.CommitOperationAdd.as_file",parameters:[{name:"with_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.as_file.with_tqdm",description:`<strong>with_tqdm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, iterating over the file object will display a progress bar. Only
works if the file-like object is a path to a file. Pure bytes and buffers
are not supported.`,name:"with_tqdm"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L206"}}),tr=new C({props:{anchor:"huggingface_hub.CommitOperationAdd.as_file.example",$$slots:{default:[RH]},$$scope:{ctx:T}}}),ml=new M({props:{name:"b64content",anchor:"huggingface_hub.CommitOperationAdd.b64content",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L256"}}),_l=new M({props:{name:"class huggingface_hub.CommitOperationDelete",anchor:"huggingface_hub.CommitOperationDelete",parameters:[{name:"path_in_repo",val:": str"},{name:"is_folder",val:": typing.Union[bool, typing.Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationDelete.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>
for a file or <code>&quot;checkpoints/1fec34a/&quot;</code> for a folder.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationDelete.is_folder",description:`<strong>is_folder</strong> (<code>bool</code> or <code>Literal[&quot;auto&quot;]</code>, <em>optional</em>) &#x2014;
Whether the Delete Operation applies to a folder or not. If &#x201C;auto&#x201D;, the path
type (file or folder) is guessed automatically by looking if path ends with
a &#x201D;/&#x201D; (folder) or not (file). To explicitly set the path type, you can set
<code>is_folder=True</code> or <code>is_folder=False</code>.`,name:"is_folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L56"}}),bl=new M({props:{name:"class huggingface_hub.CommitOperationCopy",anchor:"huggingface_hub.CommitOperationCopy",parameters:[{name:"src_path_in_repo",val:": str"},{name:"path_in_repo",val:": str"},{name:"src_revision",val:": typing.Optional[str] = None"},{name:"_src_oid",val:": typing.Optional[str] = None"},{name:"_dest_oid",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationCopy.src_path_in_repo",description:`<strong>src_path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo of the file to be copied, e.g. <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>.`,name:"src_path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo where to copy the file, e.g. <code>&quot;checkpoints/1fec34a/weights_copy.bin&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.src_revision",description:`<strong>src_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision of the file to be copied. Can be any valid git revision.
Default to the target commit revision.`,name:"src_revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L87"}}),vl=new J({props:{title:"CommitScheduler",local:"huggingface_hub.CommitScheduler",headingTag:"h2"}}),yl=new M({props:{name:"class huggingface_hub.CommitScheduler",anchor:"huggingface_hub.CommitScheduler",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": typing.Union[str, pathlib.Path]"},{name:"every",val:": typing.Union[int, float] = 5"},{name:"path_in_repo",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"squash_history",val:": bool = False"},{name:"hf_api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitScheduler.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to commit to.`,name:"repo_id"},{anchor:"huggingface_hub.CommitScheduler.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the local folder to upload regularly.`,name:"folder_path"},{anchor:"huggingface_hub.CommitScheduler.every",description:`<strong>every</strong> (<code>int</code> or <code>float</code>, <em>optional</em>) &#x2014;
The number of minutes between each commit. Defaults to 5 minutes.`,name:"every"},{anchor:"huggingface_hub.CommitScheduler.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example: <code>&quot;checkpoints/&quot;</code>. Defaults to the root folder
of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitScheduler.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to commit to. Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.CommitScheduler.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repo to commit to. Defaults to <code>main</code>.`,name:"revision"},{anchor:"huggingface_hub.CommitScheduler.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.CommitScheduler.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use to commit to the repo. Defaults to the token saved on the machine.`,name:"token"},{anchor:"huggingface_hub.CommitScheduler.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.CommitScheduler.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.CommitScheduler.squash_history",description:`<strong>squash_history</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to squash the history of the repo after each commit. Defaults to <code>False</code>. Squashing commits is
useful to avoid degraded performances on the repo when it grows too large.`,name:"squash_history"},{anchor:"huggingface_hub.CommitScheduler.hf_api",description:`<strong>hf_api</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client to use to commit to the Hub. Can be set with custom settings (user agent, token,&#x2026;).`,name:"hf_api"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L29"}}),nr=new C({props:{anchor:"huggingface_hub.CommitScheduler.example",$$slots:{default:[GH]},$$scope:{ctx:T}}}),or=new C({props:{anchor:"huggingface_hub.CommitScheduler.example-2",$$slots:{default:[FH]},$$scope:{ctx:T}}}),xl=new M({props:{name:"push_to_hub",anchor:"huggingface_hub.CommitScheduler.push_to_hub",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L204"}}),ar=new I({props:{warning:!0,$$slots:{default:[SH]},$$scope:{ctx:T}}}),$l=new M({props:{name:"stop",anchor:"huggingface_hub.CommitScheduler.stop",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L157"}}),wl=new M({props:{name:"trigger",anchor:"huggingface_hub.CommitScheduler.trigger",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L181"}}),kl=new Lq({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/hf_api.md"}}),{c(){o=c("meta"),v=s(),i=c("p"),a=s(),u(g.$$.fragment),e=s(),x=c("p"),x.innerHTML=Cw,rf=s(),pr=c("p"),pr.innerHTML=Iw,cf=s(),dr=c("p"),dr.innerHTML=Aw,lf=s(),u(gr.$$.fragment),pf=s(),u(ur.$$.fragment),df=s(),w=c("div"),u(hr.$$.fragment),vm=s(),Vl=c("p"),Vl.textContent=Nw,ym=s(),Bl=c("p"),Bl.innerHTML=Jw,xm=s(),Ae=c("div"),u(fr.$$.fragment),$m=s(),Yl=c("p"),Yl.textContent=Ew,wm=s(),Xl=c("p"),Xl.innerHTML=Dw,km=s(),zl=c("p"),zl.innerHTML=Rw,Tm=s(),Ne=c("div"),u(mr.$$.fragment),jm=s(),Ol=c("p"),Ol.textContent=Gw,qm=s(),Ql=c("p"),Ql.innerHTML=Fw,Mm=s(),u(Ro.$$.fragment),Hm=s(),Ot=c("div"),u(_r.$$.fragment),Um=s(),Kl=c("p"),Kl.textContent=Sw,Cm=s(),ep=c("p"),ep.innerHTML=Lw,Im=s(),Qt=c("div"),u(br.$$.fragment),Am=s(),tp=c("p"),tp.textContent=Zw,Nm=s(),np=c("p"),np.innerHTML=Ww,Jm=s(),G=c("div"),u(vr.$$.fragment),Em=s(),op=c("p"),op.textContent=Pw,Dm=s(),ap=c("p"),ap.textContent=Vw,Rm=s(),sp=c("p"),sp.textContent=Bw,Gm=s(),u(Go.$$.fragment),Fm=s(),rp=c("p"),rp.textContent=Yw,Sm=s(),ip=c("ul"),ip.innerHTML=Xw,Lm=s(),Je=c("div"),u(yr.$$.fragment),Zm=s(),cp=c("p"),cp.textContent=zw,Wm=s(),lp=c("p"),lp.textContent=Ow,Pm=s(),pp=c("p"),pp.innerHTML=Qw,Vm=s(),Fo=c("div"),u(xr.$$.fragment),Bm=s(),dp=c("p"),dp.textContent=Kw,Ym=s(),Ee=c("div"),u($r.$$.fragment),Xm=s(),gp=c("p"),gp.textContent=ek,zm=s(),u(So.$$.fragment),Om=s(),u(Lo.$$.fragment),Qm=s(),De=c("div"),u(wr.$$.fragment),Km=s(),up=c("p"),up.textContent=tk,e_=s(),u(Zo.$$.fragment),t_=s(),u(Wo.$$.fragment),n_=s(),Po=c("div"),u(kr.$$.fragment),o_=s(),hp=c("p"),hp.innerHTML=nk,a_=s(),Re=c("div"),u(Tr.$$.fragment),s_=s(),fp=c("p"),fp.textContent=ok,r_=s(),mp=c("p"),mp.innerHTML=ak,i_=s(),u(Vo.$$.fragment),c_=s(),re=c("div"),u(jr.$$.fragment),l_=s(),_p=c("p"),_p.textContent=sk,p_=s(),u(Bo.$$.fragment),d_=s(),u(Yo.$$.fragment),g_=s(),u(Xo.$$.fragment),u_=s(),Z=c("div"),u(qr.$$.fragment),h_=s(),bp=c("p"),bp.textContent=rk,f_=s(),vp=c("p"),vp.innerHTML=ik,m_=s(),yp=c("p"),yp.innerHTML=ck,__=s(),xp=c("p"),xp.innerHTML=lk,b_=s(),u(zo.$$.fragment),v_=s(),ie=c("div"),u(Mr.$$.fragment),y_=s(),$p=c("p"),$p.textContent=pk,x_=s(),u(Oo.$$.fragment),$_=s(),u(Qo.$$.fragment),w_=s(),u(Ko.$$.fragment),k_=s(),Ge=c("div"),u(Hr.$$.fragment),T_=s(),wp=c("p"),wp.textContent=dk,j_=s(),kp=c("p"),kp.innerHTML=gk,q_=s(),u(ea.$$.fragment),M_=s(),W=c("div"),u(Ur.$$.fragment),H_=s(),Tp=c("p"),Tp.innerHTML=uk,U_=s(),jp=c("p"),jp.innerHTML=hk,C_=s(),qp=c("p"),qp.innerHTML=fk,I_=s(),Mp=c("p"),Mp.innerHTML=mk,A_=s(),u(ta.$$.fragment),N_=s(),na=c("div"),u(Cr.$$.fragment),J_=s(),Hp=c("p"),Hp.textContent=_k,E_=s(),oa=c("div"),u(Ir.$$.fragment),D_=s(),Up=c("p"),Up.textContent=bk,R_=s(),Kt=c("div"),u(Ar.$$.fragment),G_=s(),Cp=c("p"),Cp.textContent=vk,F_=s(),u(aa.$$.fragment),S_=s(),Fe=c("div"),u(Nr.$$.fragment),L_=s(),Ip=c("p"),Ip.textContent=yk,Z_=s(),Ap=c("p"),Ap.textContent=xk,W_=s(),u(sa.$$.fragment),P_=s(),ra=c("div"),u(Jr.$$.fragment),V_=s(),Np=c("p"),Np.textContent=$k,B_=s(),Se=c("div"),u(Er.$$.fragment),Y_=s(),Jp=c("p"),Jp.textContent=wk,X_=s(),u(ia.$$.fragment),z_=s(),u(ca.$$.fragment),O_=s(),en=c("div"),u(Dr.$$.fragment),Q_=s(),Ep=c("p"),Ep.textContent=kk,K_=s(),u(la.$$.fragment),eb=s(),tn=c("div"),u(Rr.$$.fragment),tb=s(),Dp=c("p"),Dp.textContent=Tk,nb=s(),u(pa.$$.fragment),ob=s(),nn=c("div"),u(Gr.$$.fragment),ab=s(),Rp=c("p"),Rp.textContent=jk,sb=s(),Gp=c("p"),Gp.textContent=qk,rb=s(),on=c("div"),u(Fr.$$.fragment),ib=s(),Fp=c("p"),Fp.textContent=Mk,cb=s(),Sp=c("p"),Sp.innerHTML=Hk,lb=s(),Le=c("div"),u(Sr.$$.fragment),pb=s(),Lp=c("p"),Lp.textContent=Uk,db=s(),Zp=c("p"),Zp.innerHTML=Ck,gb=s(),Wp=c("p"),Wp.innerHTML=Ik,ub=s(),da=c("div"),u(Lr.$$.fragment),hb=s(),Pp=c("p"),Pp.textContent=Ak,fb=s(),an=c("div"),u(Zr.$$.fragment),mb=s(),Vp=c("p"),Vp.textContent=Nk,_b=s(),Bp=c("p"),Bp.innerHTML=Jk,bb=s(),ga=c("div"),u(Wr.$$.fragment),vb=s(),Yp=c("p"),Yp.textContent=Ek,yb=s(),sn=c("div"),u(Pr.$$.fragment),xb=s(),Xp=c("p"),Xp.textContent=Dk,$b=s(),zp=c("p"),zp.innerHTML=Rk,wb=s(),ua=c("div"),u(Vr.$$.fragment),kb=s(),Op=c("p"),Op.textContent=Gk,Tb=s(),rn=c("div"),u(Br.$$.fragment),jb=s(),Qp=c("p"),Qp.textContent=Fk,qb=s(),u(ha.$$.fragment),Mb=s(),cn=c("div"),u(Yr.$$.fragment),Hb=s(),Kp=c("p"),Kp.textContent=Sk,Ub=s(),u(fa.$$.fragment),Cb=s(),Ze=c("div"),u(Xr.$$.fragment),Ib=s(),ed=c("p"),ed.textContent=Lk,Ab=s(),td=c("p"),td.textContent=Zk,Nb=s(),u(ma.$$.fragment),Jb=s(),ln=c("div"),u(zr.$$.fragment),Eb=s(),nd=c("p"),nd.textContent=Wk,Db=s(),u(_a.$$.fragment),Rb=s(),pn=c("div"),u(Or.$$.fragment),Gb=s(),od=c("p"),od.textContent=Pk,Fb=s(),u(ba.$$.fragment),Sb=s(),dn=c("div"),u(Qr.$$.fragment),Lb=s(),ad=c("p"),ad.textContent=Vk,Zb=s(),u(va.$$.fragment),Wb=s(),gn=c("div"),u(Kr.$$.fragment),Pb=s(),sd=c("p"),sd.textContent=Bk,Vb=s(),u(ya.$$.fragment),Bb=s(),We=c("div"),u(ei.$$.fragment),Yb=s(),rd=c("p"),rd.textContent=Yk,Xb=s(),id=c("p"),id.innerHTML=Xk,zb=s(),u(xa.$$.fragment),Ob=s(),$a=c("div"),u(ti.$$.fragment),Qb=s(),cd=c("p"),cd.textContent=zk,Kb=s(),Pe=c("div"),u(ni.$$.fragment),ev=s(),ld=c("p"),ld.textContent=Ok,tv=s(),pd=c("p"),pd.innerHTML=Qk,nv=s(),u(wa.$$.fragment),ov=s(),ka=c("div"),u(oi.$$.fragment),av=s(),dd=c("p"),dd.textContent=Kk,sv=s(),Ta=c("div"),u(ai.$$.fragment),rv=s(),gd=c("p"),gd.textContent=eT,iv=s(),un=c("div"),u(si.$$.fragment),cv=s(),ud=c("p"),ud.textContent=tT,lv=s(),u(ja.$$.fragment),pv=s(),qa=c("div"),u(ri.$$.fragment),dv=s(),hd=c("p"),hd.textContent=nT,gv=s(),hn=c("div"),u(ii.$$.fragment),uv=s(),fd=c("p"),fd.textContent=oT,hv=s(),u(Ma.$$.fragment),fv=s(),ce=c("div"),u(ci.$$.fragment),mv=s(),md=c("p"),md.textContent=aT,_v=s(),_d=c("p"),_d.textContent=sT,bv=s(),u(Ha.$$.fragment),vv=s(),u(Ua.$$.fragment),yv=s(),P=c("div"),u(li.$$.fragment),xv=s(),bd=c("p"),bd.textContent=rT,$v=s(),vd=c("p"),vd.textContent=iT,wv=s(),yd=c("p"),yd.innerHTML=cT,kv=s(),xd=c("p"),xd.innerHTML=lT,Tv=s(),u(Ca.$$.fragment),jv=s(),Ia=c("div"),u(pi.$$.fragment),qv=s(),$d=c("p"),$d.textContent=pT,Mv=s(),fn=c("div"),u(di.$$.fragment),Hv=s(),wd=c("p"),wd.textContent=dT,Uv=s(),kd=c("p"),kd.innerHTML=gT,Cv=s(),Ve=c("div"),u(gi.$$.fragment),Iv=s(),Td=c("p"),Td.innerHTML=uT,Av=s(),u(Aa.$$.fragment),Nv=s(),jd=c("p"),jd.innerHTML=hT,Jv=s(),Na=c("div"),u(ui.$$.fragment),Ev=s(),qd=c("p"),qd.textContent=fT,Dv=s(),mn=c("div"),u(hi.$$.fragment),Rv=s(),Md=c("p"),Md.textContent=mT,Gv=s(),u(Ja.$$.fragment),Fv=s(),Be=c("div"),u(fi.$$.fragment),Sv=s(),Hd=c("p"),Hd.textContent=_T,Lv=s(),Ud=c("p"),Ud.innerHTML=bT,Zv=s(),Cd=c("p"),Cd.innerHTML=vT,Wv=s(),V=c("div"),u(mi.$$.fragment),Pv=s(),Id=c("p"),Id.textContent=yT,Vv=s(),Ad=c("p"),Ad.textContent=xT,Bv=s(),Nd=c("ul"),Nd.innerHTML=$T,Yv=s(),u(Ea.$$.fragment),Xv=s(),Jd=c("p"),Jd.innerHTML=wT,zv=s(),Ye=c("div"),u(_i.$$.fragment),Ov=s(),Ed=c("p"),Ed.textContent=kT,Qv=s(),u(Da.$$.fragment),Kv=s(),u(Ra.$$.fragment),ey=s(),_n=c("div"),u(bi.$$.fragment),ty=s(),Dd=c("p"),Dd.textContent=TT,ny=s(),u(Ga.$$.fragment),oy=s(),le=c("div"),u(vi.$$.fragment),ay=s(),Rd=c("p"),Rd.textContent=jT,sy=s(),Gd=c("p"),Gd.innerHTML=qT,ry=s(),Fd=c("p"),Fd.innerHTML=MT,iy=s(),u(Fa.$$.fragment),cy=s(),bn=c("div"),u(yi.$$.fragment),ly=s(),Sd=c("p"),Sd.textContent=HT,py=s(),u(Sa.$$.fragment),dy=s(),Xe=c("div"),u(xi.$$.fragment),gy=s(),Ld=c("p"),Ld.textContent=UT,uy=s(),u(La.$$.fragment),hy=s(),u(Za.$$.fragment),fy=s(),pe=c("div"),u($i.$$.fragment),my=s(),Zd=c("p"),Zd.textContent=CT,_y=s(),Wd=c("p"),Wd.innerHTML=IT,by=s(),Pd=c("p"),Pd.innerHTML=AT,vy=s(),u(Wa.$$.fragment),yy=s(),vn=c("div"),u(wi.$$.fragment),xy=s(),Vd=c("p"),Vd.textContent=NT,$y=s(),u(Pa.$$.fragment),wy=s(),Va=c("div"),u(ki.$$.fragment),ky=s(),Bd=c("p"),Bd.textContent=JT,Ty=s(),ze=c("div"),u(Ti.$$.fragment),jy=s(),Yd=c("p"),Yd.textContent=ET,qy=s(),Xd=c("p"),Xd.innerHTML=DT,My=s(),u(Ba.$$.fragment),Hy=s(),de=c("div"),u(ji.$$.fragment),Uy=s(),zd=c("p"),zd.textContent=RT,Cy=s(),Od=c("p"),Od.innerHTML=GT,Iy=s(),Qd=c("p"),Qd.innerHTML=FT,Ay=s(),u(Ya.$$.fragment),Ny=s(),yn=c("div"),u(qi.$$.fragment),Jy=s(),Kd=c("p"),Kd.textContent=ST,Ey=s(),u(Xa.$$.fragment),Dy=s(),za=c("div"),u(Mi.$$.fragment),Ry=s(),eg=c("p"),eg.textContent=LT,Gy=s(),xn=c("div"),u(Hi.$$.fragment),Fy=s(),tg=c("p"),tg.textContent=ZT,Sy=s(),u(Oa.$$.fragment),Ly=s(),ge=c("div"),u(Ui.$$.fragment),Zy=s(),ng=c("p"),ng.textContent=WT,Wy=s(),og=c("p"),og.innerHTML=PT,Py=s(),ag=c("p"),ag.innerHTML=VT,Vy=s(),u(Qa.$$.fragment),By=s(),ue=c("div"),u(Ci.$$.fragment),Yy=s(),sg=c("p"),sg.textContent=BT,Xy=s(),rg=c("p"),rg.innerHTML=YT,zy=s(),ig=c("p"),ig.innerHTML=XT,Oy=s(),u(Ka.$$.fragment),Qy=s(),Oe=c("div"),u(Ii.$$.fragment),Ky=s(),cg=c("p"),cg.textContent=zT,ex=s(),lg=c("p"),lg.textContent=OT,tx=s(),u(es.$$.fragment),nx=s(),ts=c("div"),u(Ai.$$.fragment),ox=s(),pg=c("p"),pg.textContent=QT,ax=s(),$n=c("div"),u(Ni.$$.fragment),sx=s(),dg=c("p"),dg.textContent=KT,rx=s(),gg=c("p"),gg.innerHTML=e0,ix=s(),wn=c("div"),u(Ji.$$.fragment),cx=s(),ug=c("p"),ug.textContent=t0,lx=s(),u(ns.$$.fragment),px=s(),F=c("div"),u(Ei.$$.fragment),dx=s(),hg=c("p"),hg.textContent=n0,gx=s(),fg=c("p"),fg.textContent=o0,ux=s(),mg=c("p"),mg.textContent=a0,hx=s(),u(os.$$.fragment),fx=s(),_g=c("p"),_g.textContent=s0,mx=s(),u(as.$$.fragment),_x=s(),ss=c("div"),u(Di.$$.fragment),bx=s(),bg=c("p"),bg.textContent=r0,vx=s(),rs=c("div"),u(Ri.$$.fragment),yx=s(),vg=c("p"),vg.textContent=i0,xx=s(),is=c("div"),u(Gi.$$.fragment),$x=s(),yg=c("p"),yg.textContent=c0,wx=s(),kn=c("div"),u(Fi.$$.fragment),kx=s(),xg=c("p"),xg.textContent=l0,Tx=s(),u(cs.$$.fragment),jx=s(),Tn=c("div"),u(Si.$$.fragment),qx=s(),$g=c("p"),$g.textContent=p0,Mx=s(),u(ls.$$.fragment),Hx=s(),Qe=c("div"),u(Li.$$.fragment),Ux=s(),wg=c("p"),wg.textContent=d0,Cx=s(),kg=c("p"),kg.textContent=g0,Ix=s(),u(ps.$$.fragment),Ax=s(),Ke=c("div"),u(Zi.$$.fragment),Nx=s(),Tg=c("p"),Tg.textContent=u0,Jx=s(),jg=c("p"),jg.innerHTML=h0,Ex=s(),u(ds.$$.fragment),Dx=s(),gs=c("div"),u(Wi.$$.fragment),Rx=s(),qg=c("p"),qg.textContent=f0,Gx=s(),et=c("div"),u(Pi.$$.fragment),Fx=s(),Mg=c("p"),Mg.textContent=m0,Sx=s(),Hg=c("p"),Hg.innerHTML=_0,Lx=s(),Ug=c("p"),Ug.innerHTML=b0,Zx=s(),tt=c("div"),u(Vi.$$.fragment),Wx=s(),Cg=c("p"),Cg.textContent=v0,Px=s(),Ig=c("p"),Ig.innerHTML=y0,Vx=s(),Ag=c("p"),Ag.innerHTML=x0,Bx=s(),nt=c("div"),u(Bi.$$.fragment),Yx=s(),Ng=c("p"),Ng.textContent=$0,Xx=s(),Jg=c("p"),Jg.innerHTML=w0,zx=s(),Eg=c("p"),Eg.innerHTML=k0,Ox=s(),ot=c("div"),u(Yi.$$.fragment),Qx=s(),Dg=c("p"),Dg.textContent=T0,Kx=s(),u(us.$$.fragment),e$=s(),u(hs.$$.fragment),t$=s(),B=c("div"),u(Xi.$$.fragment),n$=s(),Rg=c("p"),Rg.textContent=j0,o$=s(),Gg=c("p"),Gg.textContent=q0,a$=s(),u(fs.$$.fragment),s$=s(),u(ms.$$.fragment),r$=s(),u(_s.$$.fragment),i$=s(),at=c("div"),u(zi.$$.fragment),c$=s(),Fg=c("p"),Fg.textContent=M0,l$=s(),Sg=c("p"),Sg.innerHTML=H0,p$=s(),Lg=c("p"),Lg.innerHTML=U0,d$=s(),st=c("div"),u(Oi.$$.fragment),g$=s(),Zg=c("p"),Zg.textContent=C0,u$=s(),u(bs.$$.fragment),h$=s(),u(vs.$$.fragment),f$=s(),jn=c("div"),u(Qi.$$.fragment),m$=s(),Wg=c("p"),Wg.textContent=I0,_$=s(),u(ys.$$.fragment),b$=s(),qn=c("div"),u(Ki.$$.fragment),v$=s(),Pg=c("p"),Pg.textContent=A0,y$=s(),u(xs.$$.fragment),x$=s(),Mn=c("div"),u(ec.$$.fragment),$$=s(),Vg=c("p"),Vg.textContent=N0,w$=s(),u($s.$$.fragment),k$=s(),Hn=c("div"),u(tc.$$.fragment),T$=s(),Bg=c("p"),Bg.textContent=J0,j$=s(),u(ws.$$.fragment),q$=s(),rt=c("div"),u(nc.$$.fragment),M$=s(),Yg=c("p"),Yg.textContent=E0,H$=s(),Xg=c("p"),Xg.innerHTML=D0,U$=s(),zg=c("p"),zg.innerHTML=R0,C$=s(),Un=c("div"),u(oc.$$.fragment),I$=s(),Og=c("p"),Og.textContent=G0,A$=s(),Qg=c("p"),Qg.innerHTML=F0,N$=s(),Cn=c("div"),u(ac.$$.fragment),J$=s(),Kg=c("p"),Kg.textContent=S0,E$=s(),u(ks.$$.fragment),D$=s(),he=c("div"),u(sc.$$.fragment),R$=s(),eu=c("p"),eu.textContent=L0,G$=s(),tu=c("p"),tu.innerHTML=Z0,F$=s(),nu=c("p"),nu.innerHTML=W0,S$=s(),u(Ts.$$.fragment),L$=s(),fe=c("div"),u(rc.$$.fragment),Z$=s(),ou=c("p"),ou.textContent=P0,W$=s(),au=c("p"),au.textContent=V0,P$=s(),u(js.$$.fragment),V$=s(),u(qs.$$.fragment),B$=s(),In=c("div"),u(ic.$$.fragment),Y$=s(),su=c("p"),su.textContent=B0,X$=s(),u(Ms.$$.fragment),z$=s(),it=c("div"),u(cc.$$.fragment),O$=s(),ru=c("p"),ru.textContent=Y0,Q$=s(),iu=c("p"),iu.innerHTML=X0,K$=s(),cu=c("p"),cu.innerHTML=z0,e2=s(),ct=c("div"),u(lc.$$.fragment),t2=s(),lu=c("p"),lu.textContent=O0,n2=s(),pu=c("p"),pu.innerHTML=Q0,o2=s(),u(Hs.$$.fragment),a2=s(),me=c("div"),u(pc.$$.fragment),s2=s(),du=c("p"),du.textContent=K0,r2=s(),gu=c("p"),gu.innerHTML=ej,i2=s(),uu=c("p"),uu.innerHTML=tj,c2=s(),hu=c("p"),hu.textContent=nj,l2=s(),lt=c("div"),u(dc.$$.fragment),p2=s(),fu=c("p"),fu.textContent=oj,d2=s(),mu=c("p"),mu.textContent=aj,g2=s(),u(Us.$$.fragment),u2=s(),Y=c("div"),u(gc.$$.fragment),h2=s(),_u=c("p"),_u.textContent=sj,f2=s(),bu=c("p"),bu.textContent=rj,m2=s(),u(Cs.$$.fragment),_2=s(),u(Is.$$.fragment),b2=s(),u(As.$$.fragment),v2=s(),_e=c("div"),u(uc.$$.fragment),y2=s(),vu=c("p"),vu.textContent=ij,x2=s(),yu=c("p"),yu.innerHTML=cj,$2=s(),xu=c("p"),xu.innerHTML=lj,w2=s(),u(Ns.$$.fragment),k2=s(),An=c("div"),u(hc.$$.fragment),T2=s(),$u=c("p"),$u.textContent=pj,j2=s(),u(Js.$$.fragment),q2=s(),be=c("div"),u(fc.$$.fragment),M2=s(),wu=c("p"),wu.textContent=dj,H2=s(),ku=c("p"),ku.textContent=gj,U2=s(),Tu=c("p"),Tu.innerHTML=uj,C2=s(),u(Es.$$.fragment),I2=s(),pt=c("div"),u(mc.$$.fragment),A2=s(),ju=c("p"),ju.textContent=hj,N2=s(),qu=c("p"),qu.textContent=fj,J2=s(),Mu=c("p"),Mu.innerHTML=mj,E2=s(),Nn=c("div"),u(_c.$$.fragment),D2=s(),Hu=c("p"),Hu.textContent=_j,R2=s(),Uu=c("p"),Uu.textContent=bj,G2=s(),dt=c("div"),u(bc.$$.fragment),F2=s(),Cu=c("p"),Cu.textContent=vj,S2=s(),Iu=c("p"),Iu.innerHTML=yj,L2=s(),u(Ds.$$.fragment),Z2=s(),Jn=c("div"),u(vc.$$.fragment),W2=s(),Au=c("p"),Au.textContent=xj,P2=s(),u(Rs.$$.fragment),V2=s(),ve=c("div"),u(yc.$$.fragment),B2=s(),Nu=c("p"),Nu.textContent=$j,Y2=s(),u(Gs.$$.fragment),X2=s(),u(Fs.$$.fragment),z2=s(),u(Ss.$$.fragment),O2=s(),N=c("div"),u(xc.$$.fragment),Q2=s(),Ju=c("p"),Ju.textContent=wj,K2=s(),Eu=c("p"),Eu.textContent=kj,e1=s(),Du=c("p"),Du.innerHTML=Tj,t1=s(),Ru=c("p"),Ru.innerHTML=jj,n1=s(),Gu=c("p"),Gu.innerHTML=qj,o1=s(),Fu=c("p"),Fu.innerHTML=Mj,a1=s(),u(Ls.$$.fragment),s1=s(),u(Zs.$$.fragment),r1=s(),u(Ws.$$.fragment),i1=s(),u(Ps.$$.fragment),c1=s(),A=c("div"),u($c.$$.fragment),l1=s(),Su=c("p"),Su.textContent=Hj,p1=s(),Lu=c("p"),Lu.innerHTML=Uj,d1=s(),u(Vs.$$.fragment),g1=s(),u(Bs.$$.fragment),u1=s(),Zu=c("p"),Zu.innerHTML=Cj,h1=s(),Wu=c("p"),Wu.innerHTML=Ij,f1=s(),Pu=c("ol"),Pu.innerHTML=Aj,m1=s(),Vu=c("p"),Vu.textContent=Nj,_1=s(),Bu=c("ol"),Bu.innerHTML=Jj,b1=s(),Yu=c("p"),Yu.textContent=Ej,v1=s(),Xu=c("ul"),Xu.innerHTML=Dj,y1=s(),Ys=c("div"),u(wc.$$.fragment),x1=s(),zu=c("p"),zu.textContent=Rj,gf=s(),u(kc.$$.fragment),uf=s(),u(Tc.$$.fragment),hf=s(),Bn=c("div"),u(jc.$$.fragment),$1=s(),Ou=c("p"),Ou.textContent=Gj,ff=s(),u(qc.$$.fragment),mf=s(),ut=c("div"),u(Mc.$$.fragment),w1=s(),Qu=c("p"),Qu.textContent=Fj,k1=s(),Ku=c("p"),Ku.innerHTML=Sj,_f=s(),u(Hc.$$.fragment),bf=s(),ht=c("div"),u(Uc.$$.fragment),T1=s(),eh=c("p"),eh.innerHTML=Lj,j1=s(),u(Xs.$$.fragment),vf=s(),u(Cc.$$.fragment),yf=s(),Yn=c("div"),u(Ic.$$.fragment),q1=s(),th=c("p"),th.textContent=Zj,xf=s(),u(Ac.$$.fragment),$f=s(),Xn=c("div"),u(Nc.$$.fragment),M1=s(),nh=c("p"),nh.innerHTML=Wj,wf=s(),u(Jc.$$.fragment),kf=s(),ft=c("div"),u(Ec.$$.fragment),H1=s(),oh=c("p"),oh.textContent=Pj,U1=s(),ah=c("p"),ah.innerHTML=Vj,Tf=s(),u(Dc.$$.fragment),jf=s(),Rc=c("div"),u(Gc.$$.fragment),qf=s(),u(Fc.$$.fragment),Mf=s(),z=c("div"),u(Sc.$$.fragment),C1=s(),sh=c("p"),sh.textContent=Bj,I1=s(),rh=c("p"),rh.innerHTML=Yj,A1=s(),ih=c("p"),ih.innerHTML=Xj,N1=s(),u(zs.$$.fragment),Hf=s(),u(Lc.$$.fragment),Uf=s(),mt=c("div"),u(Zc.$$.fragment),J1=s(),ch=c("p"),ch.innerHTML=zj,E1=s(),u(Os.$$.fragment),Cf=s(),u(Wc.$$.fragment),If=s(),_t=c("div"),u(Pc.$$.fragment),D1=s(),lh=c("p"),lh.textContent=Oj,R1=s(),u(Qs.$$.fragment),Af=s(),u(Vc.$$.fragment),Nf=s(),zn=c("div"),u(Bc.$$.fragment),G1=s(),ph=c("p"),ph.textContent=Qj,Jf=s(),u(Yc.$$.fragment),Ef=s(),O=c("div"),u(Xc.$$.fragment),F1=s(),dh=c("p"),dh.innerHTML=Kj,S1=s(),gh=c("p"),gh.innerHTML=eq,L1=s(),uh=c("ul"),uh.innerHTML=tq,Z1=s(),u(Ks.$$.fragment),Df=s(),u(zc.$$.fragment),Rf=s(),Q=c("div"),u(Oc.$$.fragment),W1=s(),hh=c("p"),hh.textContent=nq,P1=s(),fh=c("p"),fh.textContent=oq,V1=s(),mh=c("p"),mh.innerHTML=aq,B1=s(),_h=c("p"),_h.innerHTML=sq,Gf=s(),u(Qc.$$.fragment),Ff=s(),ye=c("div"),u(Kc.$$.fragment),Y1=s(),bh=c("p"),bh.textContent=rq,X1=s(),vh=c("p"),vh.innerHTML=iq,z1=s(),yh=c("p"),yh.innerHTML=cq,Sf=s(),u(el.$$.fragment),Lf=s(),bt=c("div"),u(tl.$$.fragment),O1=s(),xh=c("p"),xh.innerHTML=lq,Q1=s(),u(er.$$.fragment),Zf=s(),u(nl.$$.fragment),Wf=s(),vt=c("div"),u(ol.$$.fragment),K1=s(),$h=c("p"),$h.textContent=pq,ew=s(),wh=c("p"),wh.innerHTML=dq,Pf=s(),u(al.$$.fragment),Vf=s(),On=c("div"),u(sl.$$.fragment),tw=s(),kh=c("p"),kh.textContent=gq,Bf=s(),u(rl.$$.fragment),Yf=s(),Qn=c("div"),u(il.$$.fragment),nw=s(),Th=c("p"),Th.textContent=uq,Xf=s(),u(cl.$$.fragment),zf=s(),Kn=c("div"),u(ll.$$.fragment),ow=s(),jh=c("p"),jh.textContent=hq,Of=s(),u(pl.$$.fragment),Qf=s(),eo=c("div"),u(dl.$$.fragment),aw=s(),qh=c("p"),qh.textContent=fq,Kf=s(),u(gl.$$.fragment),em=s(),ul=c("p"),ul.innerHTML=mq,tm=s(),xe=c("div"),u(hl.$$.fragment),sw=s(),Mh=c("p"),Mh.textContent=_q,rw=s(),En=c("div"),u(fl.$$.fragment),iw=s(),Hh=c("p"),Hh.innerHTML=bq,cw=s(),u(tr.$$.fragment),lw=s(),Dn=c("div"),u(ml.$$.fragment),pw=s(),Uh=c("p"),Uh.innerHTML=vq,dw=s(),Ch=c("p"),Ch.innerHTML=yq,nm=s(),to=c("div"),u(_l.$$.fragment),gw=s(),Ih=c("p"),Ih.textContent=xq,om=s(),K=c("div"),u(bl.$$.fragment),uw=s(),Ah=c("p"),Ah.textContent=$q,hw=s(),Nh=c("p"),Nh.textContent=wq,fw=s(),Jh=c("ul"),Jh.innerHTML=kq,mw=s(),Eh=c("p"),Eh.innerHTML=Tq,am=s(),u(vl.$$.fragment),sm=s(),R=c("div"),u(yl.$$.fragment),_w=s(),Dh=c("p"),Dh.textContent=jq,bw=s(),Rh=c("p"),Rh.innerHTML=qq,vw=s(),u(nr.$$.fragment),yw=s(),u(or.$$.fragment),xw=s(),gt=c("div"),u(xl.$$.fragment),$w=s(),Gh=c("p"),Gh.textContent=Mq,ww=s(),u(ar.$$.fragment),kw=s(),Fh=c("p"),Fh.innerHTML=Hq,Tw=s(),Rn=c("div"),u($l.$$.fragment),jw=s(),Sh=c("p"),Sh.textContent=Uq,qw=s(),Lh=c("p"),Lh.textContent=Cq,Mw=s(),Gn=c("div"),u(wl.$$.fragment),Hw=s(),Zh=c("p"),Zh.innerHTML=Iq,Uw=s(),Wh=c("p"),Wh.innerHTML=Aq,rm=s(),u(kl.$$.fragment),im=s(),sf=c("p"),this.h()},l(t){const y=Gq("svelte-u9bgzb",document.head);o=l(y,"META",{name:!0,content:!0}),y.forEach(p),v=r(t),i=l(t,"P",{}),j(i).forEach(p),a=r(t),h(g.$$.fragment,t),e=r(t),x=l(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-vbqehn"&&(x.innerHTML=Cw),rf=r(t),pr=l(t,"P",{"data-svelte-h":!0}),d(pr)!=="svelte-ii6hxn"&&(pr.innerHTML=Iw),cf=r(t),dr=l(t,"P",{"data-svelte-h":!0}),d(dr)!=="svelte-trrml4"&&(dr.innerHTML=Aw),lf=r(t),h(gr.$$.fragment,t),pf=r(t),h(ur.$$.fragment,t),df=r(t),w=l(t,"DIV",{class:!0});var k=j(w);h(hr.$$.fragment,k),vm=r(k),Vl=l(k,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-868tea"&&(Vl.textContent=Nw),ym=r(k),Bl=l(k,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-mq1mm2"&&(Bl.innerHTML=Jw),xm=r(k),Ae=l(k,"DIV",{class:!0});var yt=j(Ae);h(fr.$$.fragment,yt),$m=r(yt),Yl=l(yt,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-nwim5u"&&(Yl.textContent=Ew),wm=r(yt),Xl=l(yt,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-1p3hclb"&&(Xl.innerHTML=Dw),km=r(yt),zl=l(yt,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-xxbgtf"&&(zl.innerHTML=Rw),yt.forEach(p),Tm=r(k),Ne=l(k,"DIV",{class:!0});var xt=j(Ne);h(mr.$$.fragment,xt),jm=r(xt),Ol=l(xt,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-pl69v6"&&(Ol.textContent=Gw),qm=r(xt),Ql=l(xt,"P",{"data-svelte-h":!0}),d(Ql)!=="svelte-164ppjv"&&(Ql.innerHTML=Fw),Mm=r(xt),h(Ro.$$.fragment,xt),xt.forEach(p),Hm=r(k),Ot=l(k,"DIV",{class:!0});var no=j(Ot);h(_r.$$.fragment,no),Um=r(no),Kl=l(no,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-p5bez4"&&(Kl.textContent=Sw),Cm=r(no),ep=l(no,"P",{"data-svelte-h":!0}),d(ep)!=="svelte-eb77qn"&&(ep.innerHTML=Lw),no.forEach(p),Im=r(k),Qt=l(k,"DIV",{class:!0});var oo=j(Qt);h(br.$$.fragment,oo),Am=r(oo),tp=l(oo,"P",{"data-svelte-h":!0}),d(tp)!=="svelte-1ck64b0"&&(tp.textContent=Zw),Nm=r(oo),np=l(oo,"P",{"data-svelte-h":!0}),d(np)!=="svelte-xt39ay"&&(np.innerHTML=Ww),oo.forEach(p),Jm=r(k),G=l(k,"DIV",{class:!0});var S=j(G);h(vr.$$.fragment,S),Em=r(S),op=l(S,"P",{"data-svelte-h":!0}),d(op)!=="svelte-1ryj8c0"&&(op.textContent=Pw),Dm=r(S),ap=l(S,"P",{"data-svelte-h":!0}),d(ap)!=="svelte-vnh51y"&&(ap.textContent=Vw),Rm=r(S),sp=l(S,"P",{"data-svelte-h":!0}),d(sp)!=="svelte-11lpom8"&&(sp.textContent=Bw),Gm=r(S),h(Go.$$.fragment,S),Fm=r(S),rp=l(S,"P",{"data-svelte-h":!0}),d(rp)!=="svelte-15bi1il"&&(rp.textContent=Yw),Sm=r(S),ip=l(S,"UL",{"data-svelte-h":!0}),d(ip)!=="svelte-1cixf91"&&(ip.innerHTML=Xw),S.forEach(p),Lm=r(k),Je=l(k,"DIV",{class:!0});var $t=j(Je);h(yr.$$.fragment,$t),Zm=r($t),cp=l($t,"P",{"data-svelte-h":!0}),d(cp)!=="svelte-1v3ljxo"&&(cp.textContent=zw),Wm=r($t),lp=l($t,"P",{"data-svelte-h":!0}),d(lp)!=="svelte-zq4mwt"&&(lp.textContent=Ow),Pm=r($t),pp=l($t,"P",{"data-svelte-h":!0}),d(pp)!=="svelte-xxbgtf"&&(pp.innerHTML=Qw),$t.forEach(p),Vm=r(k),Fo=l(k,"DIV",{class:!0});var Tl=j(Fo);h(xr.$$.fragment,Tl),Bm=r(Tl),dp=l(Tl,"P",{"data-svelte-h":!0}),d(dp)!=="svelte-a2pb7d"&&(dp.textContent=Kw),Tl.forEach(p),Ym=r(k),Ee=l(k,"DIV",{class:!0});var wt=j(Ee);h($r.$$.fragment,wt),Xm=r(wt),gp=l(wt,"P",{"data-svelte-h":!0}),d(gp)!=="svelte-16mfbn3"&&(gp.textContent=ek),zm=r(wt),h(So.$$.fragment,wt),Om=r(wt),h(Lo.$$.fragment,wt),wt.forEach(p),Qm=r(k),De=l(k,"DIV",{class:!0});var kt=j(De);h(wr.$$.fragment,kt),Km=r(kt),up=l(kt,"P",{"data-svelte-h":!0}),d(up)!=="svelte-1xtlk3i"&&(up.textContent=tk),e_=r(kt),h(Zo.$$.fragment,kt),t_=r(kt),h(Wo.$$.fragment,kt),kt.forEach(p),n_=r(k),Po=l(k,"DIV",{class:!0});var jl=j(Po);h(kr.$$.fragment,jl),o_=r(jl),hp=l(jl,"P",{"data-svelte-h":!0}),d(hp)!=="svelte-q41614"&&(hp.innerHTML=nk),jl.forEach(p),a_=r(k),Re=l(k,"DIV",{class:!0});var Tt=j(Re);h(Tr.$$.fragment,Tt),s_=r(Tt),fp=l(Tt,"P",{"data-svelte-h":!0}),d(fp)!=="svelte-8lce12"&&(fp.textContent=ok),r_=r(Tt),mp=l(Tt,"P",{"data-svelte-h":!0}),d(mp)!=="svelte-164ppjv"&&(mp.innerHTML=ak),i_=r(Tt),h(Vo.$$.fragment,Tt),Tt.forEach(p),c_=r(k),re=l(k,"DIV",{class:!0});var $e=j(re);h(jr.$$.fragment,$e),l_=r($e),_p=l($e,"P",{"data-svelte-h":!0}),d(_p)!=="svelte-pth6mb"&&(_p.textContent=sk),p_=r($e),h(Bo.$$.fragment,$e),d_=r($e),h(Yo.$$.fragment,$e),g_=r($e),h(Xo.$$.fragment,$e),$e.forEach(p),u_=r(k),Z=l(k,"DIV",{class:!0});var ee=j(Z);h(qr.$$.fragment,ee),h_=r(ee),bp=l(ee,"P",{"data-svelte-h":!0}),d(bp)!=="svelte-1g87pq3"&&(bp.textContent=rk),f_=r(ee),vp=l(ee,"P",{"data-svelte-h":!0}),d(vp)!=="svelte-1gunwzz"&&(vp.innerHTML=ik),m_=r(ee),yp=l(ee,"P",{"data-svelte-h":!0}),d(yp)!=="svelte-r5v8l0"&&(yp.innerHTML=ck),__=r(ee),xp=l(ee,"P",{"data-svelte-h":!0}),d(xp)!=="svelte-1on7ni7"&&(xp.innerHTML=lk),b_=r(ee),h(zo.$$.fragment,ee),ee.forEach(p),v_=r(k),ie=l(k,"DIV",{class:!0});var we=j(ie);h(Mr.$$.fragment,we),y_=r(we),$p=l(we,"P",{"data-svelte-h":!0}),d($p)!=="svelte-aoy5wl"&&($p.textContent=pk),x_=r(we),h(Oo.$$.fragment,we),$_=r(we),h(Qo.$$.fragment,we),w_=r(we),h(Ko.$$.fragment,we),we.forEach(p),k_=r(k),Ge=l(k,"DIV",{class:!0});var jt=j(Ge);h(Hr.$$.fragment,jt),T_=r(jt),wp=l(jt,"P",{"data-svelte-h":!0}),d(wp)!=="svelte-1mk48gz"&&(wp.textContent=dk),j_=r(jt),kp=l(jt,"P",{"data-svelte-h":!0}),d(kp)!=="svelte-s9x0iz"&&(kp.innerHTML=gk),q_=r(jt),h(ea.$$.fragment,jt),jt.forEach(p),M_=r(k),W=l(k,"DIV",{class:!0});var te=j(W);h(Ur.$$.fragment,te),H_=r(te),Tp=l(te,"P",{"data-svelte-h":!0}),d(Tp)!=="svelte-1hp36yr"&&(Tp.innerHTML=uk),U_=r(te),jp=l(te,"P",{"data-svelte-h":!0}),d(jp)!=="svelte-r57fdn"&&(jp.innerHTML=hk),C_=r(te),qp=l(te,"P",{"data-svelte-h":!0}),d(qp)!=="svelte-13rslc6"&&(qp.innerHTML=fk),I_=r(te),Mp=l(te,"P",{"data-svelte-h":!0}),d(Mp)!=="svelte-1on7ni7"&&(Mp.innerHTML=mk),A_=r(te),h(ta.$$.fragment,te),te.forEach(p),N_=r(k),na=l(k,"DIV",{class:!0});var ql=j(na);h(Cr.$$.fragment,ql),J_=r(ql),Hp=l(ql,"P",{"data-svelte-h":!0}),d(Hp)!=="svelte-12go647"&&(Hp.textContent=_k),ql.forEach(p),E_=r(k),oa=l(k,"DIV",{class:!0});var Ml=j(oa);h(Ir.$$.fragment,Ml),D_=r(Ml),Up=l(Ml,"P",{"data-svelte-h":!0}),d(Up)!=="svelte-14fvvbg"&&(Up.textContent=bk),Ml.forEach(p),R_=r(k),Kt=l(k,"DIV",{class:!0});var ao=j(Kt);h(Ar.$$.fragment,ao),G_=r(ao),Cp=l(ao,"P",{"data-svelte-h":!0}),d(Cp)!=="svelte-1g6e2ay"&&(Cp.textContent=vk),F_=r(ao),h(aa.$$.fragment,ao),ao.forEach(p),S_=r(k),Fe=l(k,"DIV",{class:!0});var qt=j(Fe);h(Nr.$$.fragment,qt),L_=r(qt),Ip=l(qt,"P",{"data-svelte-h":!0}),d(Ip)!=="svelte-15pbnj8"&&(Ip.textContent=yk),Z_=r(qt),Ap=l(qt,"P",{"data-svelte-h":!0}),d(Ap)!=="svelte-1fg5f6l"&&(Ap.textContent=xk),W_=r(qt),h(sa.$$.fragment,qt),qt.forEach(p),P_=r(k),ra=l(k,"DIV",{class:!0});var Hl=j(ra);h(Jr.$$.fragment,Hl),V_=r(Hl),Np=l(Hl,"P",{"data-svelte-h":!0}),d(Np)!=="svelte-1n7quvg"&&(Np.textContent=$k),Hl.forEach(p),B_=r(k),Se=l(k,"DIV",{class:!0});var Mt=j(Se);h(Er.$$.fragment,Mt),Y_=r(Mt),Jp=l(Mt,"P",{"data-svelte-h":!0}),d(Jp)!=="svelte-1s6a009"&&(Jp.textContent=wk),X_=r(Mt),h(ia.$$.fragment,Mt),z_=r(Mt),h(ca.$$.fragment,Mt),Mt.forEach(p),O_=r(k),en=l(k,"DIV",{class:!0});var so=j(en);h(Dr.$$.fragment,so),Q_=r(so),Ep=l(so,"P",{"data-svelte-h":!0}),d(Ep)!=="svelte-gmiayq"&&(Ep.textContent=kk),K_=r(so),h(la.$$.fragment,so),so.forEach(p),eb=r(k),tn=l(k,"DIV",{class:!0});var ro=j(tn);h(Rr.$$.fragment,ro),tb=r(ro),Dp=l(ro,"P",{"data-svelte-h":!0}),d(Dp)!=="svelte-l8j8qy"&&(Dp.textContent=Tk),nb=r(ro),h(pa.$$.fragment,ro),ro.forEach(p),ob=r(k),nn=l(k,"DIV",{class:!0});var io=j(nn);h(Gr.$$.fragment,io),ab=r(io),Rp=l(io,"P",{"data-svelte-h":!0}),d(Rp)!=="svelte-eigln8"&&(Rp.textContent=jk),sb=r(io),Gp=l(io,"P",{"data-svelte-h":!0}),d(Gp)!=="svelte-11xoqkr"&&(Gp.textContent=qk),io.forEach(p),rb=r(k),on=l(k,"DIV",{class:!0});var co=j(on);h(Fr.$$.fragment,co),ib=r(co),Fp=l(co,"P",{"data-svelte-h":!0}),d(Fp)!=="svelte-1gp9ysc"&&(Fp.textContent=Mk),cb=r(co),Sp=l(co,"P",{"data-svelte-h":!0}),d(Sp)!=="svelte-1seiqi6"&&(Sp.innerHTML=Hk),co.forEach(p),lb=r(k),Le=l(k,"DIV",{class:!0});var Ht=j(Le);h(Sr.$$.fragment,Ht),pb=r(Ht),Lp=l(Ht,"P",{"data-svelte-h":!0}),d(Lp)!=="svelte-xvin3w"&&(Lp.textContent=Uk),db=r(Ht),Zp=l(Ht,"P",{"data-svelte-h":!0}),d(Zp)!=="svelte-1vd9l2b"&&(Zp.innerHTML=Ck),gb=r(Ht),Wp=l(Ht,"P",{"data-svelte-h":!0}),d(Wp)!=="svelte-wf2uv4"&&(Wp.innerHTML=Ik),Ht.forEach(p),ub=r(k),da=l(k,"DIV",{class:!0});var Ul=j(da);h(Lr.$$.fragment,Ul),hb=r(Ul),Pp=l(Ul,"P",{"data-svelte-h":!0}),d(Pp)!=="svelte-17rezgl"&&(Pp.textContent=Ak),Ul.forEach(p),fb=r(k),an=l(k,"DIV",{class:!0});var lo=j(an);h(Zr.$$.fragment,lo),mb=r(lo),Vp=l(lo,"P",{"data-svelte-h":!0}),d(Vp)!=="svelte-1lh7ib8"&&(Vp.textContent=Nk),_b=r(lo),Bp=l(lo,"P",{"data-svelte-h":!0}),d(Bp)!=="svelte-eb77qn"&&(Bp.innerHTML=Jk),lo.forEach(p),bb=r(k),ga=l(k,"DIV",{class:!0});var Cl=j(ga);h(Wr.$$.fragment,Cl),vb=r(Cl),Yp=l(Cl,"P",{"data-svelte-h":!0}),d(Yp)!=="svelte-2wnalp"&&(Yp.textContent=Ek),Cl.forEach(p),yb=r(k),sn=l(k,"DIV",{class:!0});var po=j(sn);h(Pr.$$.fragment,po),xb=r(po),Xp=l(po,"P",{"data-svelte-h":!0}),d(Xp)!=="svelte-idifvk"&&(Xp.textContent=Dk),$b=r(po),zp=l(po,"P",{"data-svelte-h":!0}),d(zp)!=="svelte-xt39ay"&&(zp.innerHTML=Rk),po.forEach(p),wb=r(k),ua=l(k,"DIV",{class:!0});var Il=j(ua);h(Vr.$$.fragment,Il),kb=r(Il),Op=l(Il,"P",{"data-svelte-h":!0}),d(Op)!=="svelte-1k595hs"&&(Op.textContent=Gk),Il.forEach(p),Tb=r(k),rn=l(k,"DIV",{class:!0});var go=j(rn);h(Br.$$.fragment,go),jb=r(go),Qp=l(go,"P",{"data-svelte-h":!0}),d(Qp)!=="svelte-odm3i5"&&(Qp.textContent=Fk),qb=r(go),h(ha.$$.fragment,go),go.forEach(p),Mb=r(k),cn=l(k,"DIV",{class:!0});var uo=j(cn);h(Yr.$$.fragment,uo),Hb=r(uo),Kp=l(uo,"P",{"data-svelte-h":!0}),d(Kp)!=="svelte-u3qpxi"&&(Kp.textContent=Sk),Ub=r(uo),h(fa.$$.fragment,uo),uo.forEach(p),Cb=r(k),Ze=l(k,"DIV",{class:!0});var Ut=j(Ze);h(Xr.$$.fragment,Ut),Ib=r(Ut),ed=l(Ut,"P",{"data-svelte-h":!0}),d(ed)!=="svelte-106oizm"&&(ed.textContent=Lk),Ab=r(Ut),td=l(Ut,"P",{"data-svelte-h":!0}),d(td)!=="svelte-1tfv4hv"&&(td.textContent=Zk),Nb=r(Ut),h(ma.$$.fragment,Ut),Ut.forEach(p),Jb=r(k),ln=l(k,"DIV",{class:!0});var ho=j(ln);h(zr.$$.fragment,ho),Eb=r(ho),nd=l(ho,"P",{"data-svelte-h":!0}),d(nd)!=="svelte-13117mw"&&(nd.textContent=Wk),Db=r(ho),h(_a.$$.fragment,ho),ho.forEach(p),Rb=r(k),pn=l(k,"DIV",{class:!0});var fo=j(pn);h(Or.$$.fragment,fo),Gb=r(fo),od=l(fo,"P",{"data-svelte-h":!0}),d(od)!=="svelte-isyqd"&&(od.textContent=Pk),Fb=r(fo),h(ba.$$.fragment,fo),fo.forEach(p),Sb=r(k),dn=l(k,"DIV",{class:!0});var mo=j(dn);h(Qr.$$.fragment,mo),Lb=r(mo),ad=l(mo,"P",{"data-svelte-h":!0}),d(ad)!=="svelte-idzq2w"&&(ad.textContent=Vk),Zb=r(mo),h(va.$$.fragment,mo),mo.forEach(p),Wb=r(k),gn=l(k,"DIV",{class:!0});var _o=j(gn);h(Kr.$$.fragment,_o),Pb=r(_o),sd=l(_o,"P",{"data-svelte-h":!0}),d(sd)!=="svelte-sivey2"&&(sd.textContent=Bk),Vb=r(_o),h(ya.$$.fragment,_o),_o.forEach(p),Bb=r(k),We=l(k,"DIV",{class:!0});var Ct=j(We);h(ei.$$.fragment,Ct),Yb=r(Ct),rd=l(Ct,"P",{"data-svelte-h":!0}),d(rd)!=="svelte-1niezvm"&&(rd.textContent=Yk),Xb=r(Ct),id=l(Ct,"P",{"data-svelte-h":!0}),d(id)!=="svelte-164ppjv"&&(id.innerHTML=Xk),zb=r(Ct),h(xa.$$.fragment,Ct),Ct.forEach(p),Ob=r(k),$a=l(k,"DIV",{class:!0});var Al=j($a);h(ti.$$.fragment,Al),Qb=r(Al),cd=l(Al,"P",{"data-svelte-h":!0}),d(cd)!=="svelte-1o179eo"&&(cd.textContent=zk),Al.forEach(p),Kb=r(k),Pe=l(k,"DIV",{class:!0});var It=j(Pe);h(ni.$$.fragment,It),ev=r(It),ld=l(It,"P",{"data-svelte-h":!0}),d(ld)!=="svelte-1av5ht1"&&(ld.textContent=Ok),tv=r(It),pd=l(It,"P",{"data-svelte-h":!0}),d(pd)!=="svelte-1on7ni7"&&(pd.innerHTML=Qk),nv=r(It),h(wa.$$.fragment,It),It.forEach(p),ov=r(k),ka=l(k,"DIV",{class:!0});var Nl=j(ka);h(oi.$$.fragment,Nl),av=r(Nl),dd=l(Nl,"P",{"data-svelte-h":!0}),d(dd)!=="svelte-1a5sg0y"&&(dd.textContent=Kk),Nl.forEach(p),sv=r(k),Ta=l(k,"DIV",{class:!0});var Jl=j(Ta);h(ai.$$.fragment,Jl),rv=r(Jl),gd=l(Jl,"P",{"data-svelte-h":!0}),d(gd)!=="svelte-13tt6xv"&&(gd.textContent=eT),Jl.forEach(p),iv=r(k),un=l(k,"DIV",{class:!0});var bo=j(un);h(si.$$.fragment,bo),cv=r(bo),ud=l(bo,"P",{"data-svelte-h":!0}),d(ud)!=="svelte-oj23bg"&&(ud.textContent=tT),lv=r(bo),h(ja.$$.fragment,bo),bo.forEach(p),pv=r(k),qa=l(k,"DIV",{class:!0});var El=j(qa);h(ri.$$.fragment,El),dv=r(El),hd=l(El,"P",{"data-svelte-h":!0}),d(hd)!=="svelte-d99h9l"&&(hd.textContent=nT),El.forEach(p),gv=r(k),hn=l(k,"DIV",{class:!0});var vo=j(hn);h(ii.$$.fragment,vo),uv=r(vo),fd=l(vo,"P",{"data-svelte-h":!0}),d(fd)!=="svelte-fasffe"&&(fd.textContent=oT),hv=r(vo),h(Ma.$$.fragment,vo),vo.forEach(p),fv=r(k),ce=l(k,"DIV",{class:!0});var ke=j(ce);h(ci.$$.fragment,ke),mv=r(ke),md=l(ke,"P",{"data-svelte-h":!0}),d(md)!=="svelte-1ipows8"&&(md.textContent=aT),_v=r(ke),_d=l(ke,"P",{"data-svelte-h":!0}),d(_d)!=="svelte-11lpom8"&&(_d.textContent=sT),bv=r(ke),h(Ha.$$.fragment,ke),vv=r(ke),h(Ua.$$.fragment,ke),ke.forEach(p),yv=r(k),P=l(k,"DIV",{class:!0});var ne=j(P);h(li.$$.fragment,ne),xv=r(ne),bd=l(ne,"P",{"data-svelte-h":!0}),d(bd)!=="svelte-1d865z6"&&(bd.textContent=rT),$v=r(ne),vd=l(ne,"P",{"data-svelte-h":!0}),d(vd)!=="svelte-vb94yg"&&(vd.textContent=iT),wv=r(ne),yd=l(ne,"P",{"data-svelte-h":!0}),d(yd)!=="svelte-cpm9yd"&&(yd.innerHTML=cT),kv=r(ne),xd=l(ne,"P",{"data-svelte-h":!0}),d(xd)!=="svelte-ndzof3"&&(xd.innerHTML=lT),Tv=r(ne),h(Ca.$$.fragment,ne),ne.forEach(p),jv=r(k),Ia=l(k,"DIV",{class:!0});var Dl=j(Ia);h(pi.$$.fragment,Dl),qv=r(Dl),$d=l(Dl,"P",{"data-svelte-h":!0}),d($d)!=="svelte-130dnbj"&&($d.textContent=pT),Dl.forEach(p),Mv=r(k),fn=l(k,"DIV",{class:!0});var yo=j(fn);h(di.$$.fragment,yo),Hv=r(yo),wd=l(yo,"P",{"data-svelte-h":!0}),d(wd)!=="svelte-20b1wq"&&(wd.textContent=dT),Uv=r(yo),kd=l(yo,"P",{"data-svelte-h":!0}),d(kd)!=="svelte-xt39ay"&&(kd.innerHTML=gT),yo.forEach(p),Cv=r(k),Ve=l(k,"DIV",{class:!0});var At=j(Ve);h(gi.$$.fragment,At),Iv=r(At),Td=l(At,"P",{"data-svelte-h":!0}),d(Td)!=="svelte-1vu5uho"&&(Td.innerHTML=uT),Av=r(At),h(Aa.$$.fragment,At),Nv=r(At),jd=l(At,"P",{"data-svelte-h":!0}),d(jd)!=="svelte-65kopl"&&(jd.innerHTML=hT),At.forEach(p),Jv=r(k),Na=l(k,"DIV",{class:!0});var Rl=j(Na);h(ui.$$.fragment,Rl),Ev=r(Rl),qd=l(Rl,"P",{"data-svelte-h":!0}),d(qd)!=="svelte-i5g6s6"&&(qd.textContent=fT),Rl.forEach(p),Dv=r(k),mn=l(k,"DIV",{class:!0});var xo=j(mn);h(hi.$$.fragment,xo),Rv=r(xo),Md=l(xo,"P",{"data-svelte-h":!0}),d(Md)!=="svelte-1qqa7u0"&&(Md.textContent=mT),Gv=r(xo),h(Ja.$$.fragment,xo),xo.forEach(p),Fv=r(k),Be=l(k,"DIV",{class:!0});var Nt=j(Be);h(fi.$$.fragment,Nt),Sv=r(Nt),Hd=l(Nt,"P",{"data-svelte-h":!0}),d(Hd)!=="svelte-19fc6id"&&(Hd.textContent=_T),Lv=r(Nt),Ud=l(Nt,"P",{"data-svelte-h":!0}),d(Ud)!=="svelte-14mt8n5"&&(Ud.innerHTML=bT),Zv=r(Nt),Cd=l(Nt,"P",{"data-svelte-h":!0}),d(Cd)!=="svelte-xxbgtf"&&(Cd.innerHTML=vT),Nt.forEach(p),Wv=r(k),V=l(k,"DIV",{class:!0});var oe=j(V);h(mi.$$.fragment,oe),Pv=r(oe),Id=l(oe,"P",{"data-svelte-h":!0}),d(Id)!=="svelte-gsbehr"&&(Id.textContent=yT),Vv=r(oe),Ad=l(oe,"P",{"data-svelte-h":!0}),d(Ad)!=="svelte-1rkm1l0"&&(Ad.textContent=xT),Bv=r(oe),Nd=l(oe,"UL",{"data-svelte-h":!0}),d(Nd)!=="svelte-1t8qnom"&&(Nd.innerHTML=$T),Yv=r(oe),h(Ea.$$.fragment,oe),Xv=r(oe),Jd=l(oe,"P",{"data-svelte-h":!0}),d(Jd)!=="svelte-mwwpv9"&&(Jd.innerHTML=wT),oe.forEach(p),zv=r(k),Ye=l(k,"DIV",{class:!0});var Jt=j(Ye);h(_i.$$.fragment,Jt),Ov=r(Jt),Ed=l(Jt,"P",{"data-svelte-h":!0}),d(Ed)!=="svelte-1ia1m9g"&&(Ed.textContent=kT),Qv=r(Jt),h(Da.$$.fragment,Jt),Kv=r(Jt),h(Ra.$$.fragment,Jt),Jt.forEach(p),ey=r(k),_n=l(k,"DIV",{class:!0});var $o=j(_n);h(bi.$$.fragment,$o),ty=r($o),Dd=l($o,"P",{"data-svelte-h":!0}),d(Dd)!=="svelte-1eaf7r1"&&(Dd.textContent=TT),ny=r($o),h(Ga.$$.fragment,$o),$o.forEach(p),oy=r(k),le=l(k,"DIV",{class:!0});var Te=j(le);h(vi.$$.fragment,Te),ay=r(Te),Rd=l(Te,"P",{"data-svelte-h":!0}),d(Rd)!=="svelte-1a7k7d"&&(Rd.textContent=jT),sy=r(Te),Gd=l(Te,"P",{"data-svelte-h":!0}),d(Gd)!=="svelte-145s2tk"&&(Gd.innerHTML=qT),ry=r(Te),Fd=l(Te,"P",{"data-svelte-h":!0}),d(Fd)!=="svelte-xxbgtf"&&(Fd.innerHTML=MT),iy=r(Te),h(Fa.$$.fragment,Te),Te.forEach(p),cy=r(k),bn=l(k,"DIV",{class:!0});var wo=j(bn);h(yi.$$.fragment,wo),ly=r(wo),Sd=l(wo,"P",{"data-svelte-h":!0}),d(Sd)!=="svelte-1rbvjim"&&(Sd.textContent=HT),py=r(wo),h(Sa.$$.fragment,wo),wo.forEach(p),dy=r(k),Xe=l(k,"DIV",{class:!0});var Et=j(Xe);h(xi.$$.fragment,Et),gy=r(Et),Ld=l(Et,"P",{"data-svelte-h":!0}),d(Ld)!=="svelte-f61qi5"&&(Ld.textContent=UT),uy=r(Et),h(La.$$.fragment,Et),hy=r(Et),h(Za.$$.fragment,Et),Et.forEach(p),fy=r(k),pe=l(k,"DIV",{class:!0});var je=j(pe);h($i.$$.fragment,je),my=r(je),Zd=l(je,"P",{"data-svelte-h":!0}),d(Zd)!=="svelte-5021cf"&&(Zd.textContent=CT),_y=r(je),Wd=l(je,"P",{"data-svelte-h":!0}),d(Wd)!=="svelte-s9x0iz"&&(Wd.innerHTML=IT),by=r(je),Pd=l(je,"P",{"data-svelte-h":!0}),d(Pd)!=="svelte-1rebg38"&&(Pd.innerHTML=AT),vy=r(je),h(Wa.$$.fragment,je),je.forEach(p),yy=r(k),vn=l(k,"DIV",{class:!0});var ko=j(vn);h(wi.$$.fragment,ko),xy=r(ko),Vd=l(ko,"P",{"data-svelte-h":!0}),d(Vd)!=="svelte-omx1g3"&&(Vd.textContent=NT),$y=r(ko),h(Pa.$$.fragment,ko),ko.forEach(p),wy=r(k),Va=l(k,"DIV",{class:!0});var Gl=j(Va);h(ki.$$.fragment,Gl),ky=r(Gl),Bd=l(Gl,"P",{"data-svelte-h":!0}),d(Bd)!=="svelte-2krbhz"&&(Bd.textContent=JT),Gl.forEach(p),Ty=r(k),ze=l(k,"DIV",{class:!0});var Dt=j(ze);h(Ti.$$.fragment,Dt),jy=r(Dt),Yd=l(Dt,"P",{"data-svelte-h":!0}),d(Yd)!=="svelte-1wmqeve"&&(Yd.textContent=ET),qy=r(Dt),Xd=l(Dt,"P",{"data-svelte-h":!0}),d(Xd)!=="svelte-1qhy0tu"&&(Xd.innerHTML=DT),My=r(Dt),h(Ba.$$.fragment,Dt),Dt.forEach(p),Hy=r(k),de=l(k,"DIV",{class:!0});var qe=j(de);h(ji.$$.fragment,qe),Uy=r(qe),zd=l(qe,"P",{"data-svelte-h":!0}),d(zd)!=="svelte-lufmym"&&(zd.textContent=RT),Cy=r(qe),Od=l(qe,"P",{"data-svelte-h":!0}),d(Od)!=="svelte-517n25"&&(Od.innerHTML=GT),Iy=r(qe),Qd=l(qe,"P",{"data-svelte-h":!0}),d(Qd)!=="svelte-1qdx753"&&(Qd.innerHTML=FT),Ay=r(qe),h(Ya.$$.fragment,qe),qe.forEach(p),Ny=r(k),yn=l(k,"DIV",{class:!0});var To=j(yn);h(qi.$$.fragment,To),Jy=r(To),Kd=l(To,"P",{"data-svelte-h":!0}),d(Kd)!=="svelte-7xr8du"&&(Kd.textContent=ST),Ey=r(To),h(Xa.$$.fragment,To),To.forEach(p),Dy=r(k),za=l(k,"DIV",{class:!0});var Fl=j(za);h(Mi.$$.fragment,Fl),Ry=r(Fl),eg=l(Fl,"P",{"data-svelte-h":!0}),d(eg)!=="svelte-1lk5pt4"&&(eg.textContent=LT),Fl.forEach(p),Gy=r(k),xn=l(k,"DIV",{class:!0});var jo=j(xn);h(Hi.$$.fragment,jo),Fy=r(jo),tg=l(jo,"P",{"data-svelte-h":!0}),d(tg)!=="svelte-1qh0k4h"&&(tg.textContent=ZT),Sy=r(jo),h(Oa.$$.fragment,jo),jo.forEach(p),Ly=r(k),ge=l(k,"DIV",{class:!0});var Me=j(ge);h(Ui.$$.fragment,Me),Zy=r(Me),ng=l(Me,"P",{"data-svelte-h":!0}),d(ng)!=="svelte-1tc2fi9"&&(ng.textContent=WT),Wy=r(Me),og=l(Me,"P",{"data-svelte-h":!0}),d(og)!=="svelte-svm7t8"&&(og.innerHTML=PT),Py=r(Me),ag=l(Me,"P",{"data-svelte-h":!0}),d(ag)!=="svelte-xxbgtf"&&(ag.innerHTML=VT),Vy=r(Me),h(Qa.$$.fragment,Me),Me.forEach(p),By=r(k),ue=l(k,"DIV",{class:!0});var He=j(ue);h(Ci.$$.fragment,He),Yy=r(He),sg=l(He,"P",{"data-svelte-h":!0}),d(sg)!=="svelte-eo3dek"&&(sg.textContent=BT),Xy=r(He),rg=l(He,"P",{"data-svelte-h":!0}),d(rg)!=="svelte-fokgh9"&&(rg.innerHTML=YT),zy=r(He),ig=l(He,"P",{"data-svelte-h":!0}),d(ig)!=="svelte-xxbgtf"&&(ig.innerHTML=XT),Oy=r(He),h(Ka.$$.fragment,He),He.forEach(p),Qy=r(k),Oe=l(k,"DIV",{class:!0});var Rt=j(Oe);h(Ii.$$.fragment,Rt),Ky=r(Rt),cg=l(Rt,"P",{"data-svelte-h":!0}),d(cg)!=="svelte-1vpgi7z"&&(cg.textContent=zT),ex=r(Rt),lg=l(Rt,"P",{"data-svelte-h":!0}),d(lg)!=="svelte-11ohrqa"&&(lg.textContent=OT),tx=r(Rt),h(es.$$.fragment,Rt),Rt.forEach(p),nx=r(k),ts=l(k,"DIV",{class:!0});var Sl=j(ts);h(Ai.$$.fragment,Sl),ox=r(Sl),pg=l(Sl,"P",{"data-svelte-h":!0}),d(pg)!=="svelte-wnw53w"&&(pg.textContent=QT),Sl.forEach(p),ax=r(k),$n=l(k,"DIV",{class:!0});var qo=j($n);h(Ni.$$.fragment,qo),sx=r(qo),dg=l(qo,"P",{"data-svelte-h":!0}),d(dg)!=="svelte-b4yhj"&&(dg.textContent=KT),rx=r(qo),gg=l(qo,"P",{"data-svelte-h":!0}),d(gg)!=="svelte-19j5u9b"&&(gg.innerHTML=e0),qo.forEach(p),ix=r(k),wn=l(k,"DIV",{class:!0});var Mo=j(wn);h(Ji.$$.fragment,Mo),cx=r(Mo),ug=l(Mo,"P",{"data-svelte-h":!0}),d(ug)!=="svelte-12l2ojn"&&(ug.textContent=t0),lx=r(Mo),h(ns.$$.fragment,Mo),Mo.forEach(p),px=r(k),F=l(k,"DIV",{class:!0});var L=j(F);h(Ei.$$.fragment,L),dx=r(L),hg=l(L,"P",{"data-svelte-h":!0}),d(hg)!=="svelte-ihiuvu"&&(hg.textContent=n0),gx=r(L),fg=l(L,"P",{"data-svelte-h":!0}),d(fg)!=="svelte-kvfsh7"&&(fg.textContent=o0),ux=r(L),mg=l(L,"P",{"data-svelte-h":!0}),d(mg)!=="svelte-cs4ah2"&&(mg.textContent=a0),hx=r(L),h(os.$$.fragment,L),fx=r(L),_g=l(L,"P",{"data-svelte-h":!0}),d(_g)!=="svelte-1pnedrv"&&(_g.textContent=s0),mx=r(L),h(as.$$.fragment,L),L.forEach(p),_x=r(k),ss=l(k,"DIV",{class:!0});var Ll=j(ss);h(Di.$$.fragment,Ll),bx=r(Ll),bg=l(Ll,"P",{"data-svelte-h":!0}),d(bg)!=="svelte-uowooj"&&(bg.textContent=r0),Ll.forEach(p),vx=r(k),rs=l(k,"DIV",{class:!0});var Zl=j(rs);h(Ri.$$.fragment,Zl),yx=r(Zl),vg=l(Zl,"P",{"data-svelte-h":!0}),d(vg)!=="svelte-apiozp"&&(vg.textContent=i0),Zl.forEach(p),xx=r(k),is=l(k,"DIV",{class:!0});var Wl=j(is);h(Gi.$$.fragment,Wl),$x=r(Wl),yg=l(Wl,"P",{"data-svelte-h":!0}),d(yg)!=="svelte-1qehg6u"&&(yg.textContent=c0),Wl.forEach(p),wx=r(k),kn=l(k,"DIV",{class:!0});var Ho=j(kn);h(Fi.$$.fragment,Ho),kx=r(Ho),xg=l(Ho,"P",{"data-svelte-h":!0}),d(xg)!=="svelte-zuangp"&&(xg.textContent=l0),Tx=r(Ho),h(cs.$$.fragment,Ho),Ho.forEach(p),jx=r(k),Tn=l(k,"DIV",{class:!0});var Uo=j(Tn);h(Si.$$.fragment,Uo),qx=r(Uo),$g=l(Uo,"P",{"data-svelte-h":!0}),d($g)!=="svelte-tnvivq"&&($g.textContent=p0),Mx=r(Uo),h(ls.$$.fragment,Uo),Uo.forEach(p),Hx=r(k),Qe=l(k,"DIV",{class:!0});var Gt=j(Qe);h(Li.$$.fragment,Gt),Ux=r(Gt),wg=l(Gt,"P",{"data-svelte-h":!0}),d(wg)!=="svelte-1qa90id"&&(wg.textContent=d0),Cx=r(Gt),kg=l(Gt,"P",{"data-svelte-h":!0}),d(kg)!=="svelte-1knrefm"&&(kg.textContent=g0),Ix=r(Gt),h(ps.$$.fragment,Gt),Gt.forEach(p),Ax=r(k),Ke=l(k,"DIV",{class:!0});var Ft=j(Ke);h(Zi.$$.fragment,Ft),Nx=r(Ft),Tg=l(Ft,"P",{"data-svelte-h":!0}),d(Tg)!=="svelte-3q13qo"&&(Tg.textContent=u0),Jx=r(Ft),jg=l(Ft,"P",{"data-svelte-h":!0}),d(jg)!=="svelte-1p5ibr4"&&(jg.innerHTML=h0),Ex=r(Ft),h(ds.$$.fragment,Ft),Ft.forEach(p),Dx=r(k),gs=l(k,"DIV",{class:!0});var Pl=j(gs);h(Wi.$$.fragment,Pl),Rx=r(Pl),qg=l(Pl,"P",{"data-svelte-h":!0}),d(qg)!=="svelte-15c9e8d"&&(qg.textContent=f0),Pl.forEach(p),Gx=r(k),et=l(k,"DIV",{class:!0});var St=j(et);h(Pi.$$.fragment,St),Fx=r(St),Mg=l(St,"P",{"data-svelte-h":!0}),d(Mg)!=="svelte-cs1v9f"&&(Mg.textContent=m0),Sx=r(St),Hg=l(St,"P",{"data-svelte-h":!0}),d(Hg)!=="svelte-1kxlgey"&&(Hg.innerHTML=_0),Lx=r(St),Ug=l(St,"P",{"data-svelte-h":!0}),d(Ug)!=="svelte-ndzof3"&&(Ug.innerHTML=b0),St.forEach(p),Zx=r(k),tt=l(k,"DIV",{class:!0});var Lt=j(tt);h(Vi.$$.fragment,Lt),Wx=r(Lt),Cg=l(Lt,"P",{"data-svelte-h":!0}),d(Cg)!=="svelte-16tls2x"&&(Cg.textContent=v0),Px=r(Lt),Ig=l(Lt,"P",{"data-svelte-h":!0}),d(Ig)!=="svelte-n0cprg"&&(Ig.innerHTML=y0),Vx=r(Lt),Ag=l(Lt,"P",{"data-svelte-h":!0}),d(Ag)!=="svelte-mf5z8c"&&(Ag.innerHTML=x0),Lt.forEach(p),Bx=r(k),nt=l(k,"DIV",{class:!0});var Zt=j(nt);h(Bi.$$.fragment,Zt),Yx=r(Zt),Ng=l(Zt,"P",{"data-svelte-h":!0}),d(Ng)!=="svelte-keb9bv"&&(Ng.textContent=$0),Xx=r(Zt),Jg=l(Zt,"P",{"data-svelte-h":!0}),d(Jg)!=="svelte-2lslon"&&(Jg.innerHTML=w0),zx=r(Zt),Eg=l(Zt,"P",{"data-svelte-h":!0}),d(Eg)!=="svelte-12do56u"&&(Eg.innerHTML=k0),Zt.forEach(p),Ox=r(k),ot=l(k,"DIV",{class:!0});var Wt=j(ot);h(Yi.$$.fragment,Wt),Qx=r(Wt),Dg=l(Wt,"P",{"data-svelte-h":!0}),d(Dg)!=="svelte-10xq13g"&&(Dg.textContent=T0),Kx=r(Wt),h(us.$$.fragment,Wt),e$=r(Wt),h(hs.$$.fragment,Wt),Wt.forEach(p),t$=r(k),B=l(k,"DIV",{class:!0});var ae=j(B);h(Xi.$$.fragment,ae),n$=r(ae),Rg=l(ae,"P",{"data-svelte-h":!0}),d(Rg)!=="svelte-13c8xg2"&&(Rg.textContent=j0),o$=r(ae),Gg=l(ae,"P",{"data-svelte-h":!0}),d(Gg)!=="svelte-5htwml"&&(Gg.textContent=q0),a$=r(ae),h(fs.$$.fragment,ae),s$=r(ae),h(ms.$$.fragment,ae),r$=r(ae),h(_s.$$.fragment,ae),ae.forEach(p),i$=r(k),at=l(k,"DIV",{class:!0});var Pt=j(at);h(zi.$$.fragment,Pt),c$=r(Pt),Fg=l(Pt,"P",{"data-svelte-h":!0}),d(Fg)!=="svelte-1o1ui5j"&&(Fg.textContent=M0),l$=r(Pt),Sg=l(Pt,"P",{"data-svelte-h":!0}),d(Sg)!=="svelte-zzdx9o"&&(Sg.innerHTML=H0),p$=r(Pt),Lg=l(Pt,"P",{"data-svelte-h":!0}),d(Lg)!=="svelte-xxbgtf"&&(Lg.innerHTML=U0),Pt.forEach(p),d$=r(k),st=l(k,"DIV",{class:!0});var Vt=j(st);h(Oi.$$.fragment,Vt),g$=r(Vt),Zg=l(Vt,"P",{"data-svelte-h":!0}),d(Zg)!=="svelte-vjmct2"&&(Zg.textContent=C0),u$=r(Vt),h(bs.$$.fragment,Vt),h$=r(Vt),h(vs.$$.fragment,Vt),Vt.forEach(p),f$=r(k),jn=l(k,"DIV",{class:!0});var Co=j(jn);h(Qi.$$.fragment,Co),m$=r(Co),Wg=l(Co,"P",{"data-svelte-h":!0}),d(Wg)!=="svelte-1h0ufuc"&&(Wg.textContent=I0),_$=r(Co),h(ys.$$.fragment,Co),Co.forEach(p),b$=r(k),qn=l(k,"DIV",{class:!0});var Io=j(qn);h(Ki.$$.fragment,Io),v$=r(Io),Pg=l(Io,"P",{"data-svelte-h":!0}),d(Pg)!=="svelte-1my46uo"&&(Pg.textContent=A0),y$=r(Io),h(xs.$$.fragment,Io),Io.forEach(p),x$=r(k),Mn=l(k,"DIV",{class:!0});var Ao=j(Mn);h(ec.$$.fragment,Ao),$$=r(Ao),Vg=l(Ao,"P",{"data-svelte-h":!0}),d(Vg)!=="svelte-5pcxuz"&&(Vg.textContent=N0),w$=r(Ao),h($s.$$.fragment,Ao),Ao.forEach(p),k$=r(k),Hn=l(k,"DIV",{class:!0});var No=j(Hn);h(tc.$$.fragment,No),T$=r(No),Bg=l(No,"P",{"data-svelte-h":!0}),d(Bg)!=="svelte-10aqzwl"&&(Bg.textContent=J0),j$=r(No),h(ws.$$.fragment,No),No.forEach(p),q$=r(k),rt=l(k,"DIV",{class:!0});var Bt=j(rt);h(nc.$$.fragment,Bt),M$=r(Bt),Yg=l(Bt,"P",{"data-svelte-h":!0}),d(Yg)!=="svelte-38gi4y"&&(Yg.textContent=E0),H$=r(Bt),Xg=l(Bt,"P",{"data-svelte-h":!0}),d(Xg)!=="svelte-65s7rh"&&(Xg.innerHTML=D0),U$=r(Bt),zg=l(Bt,"P",{"data-svelte-h":!0}),d(zg)!=="svelte-12do56u"&&(zg.innerHTML=R0),Bt.forEach(p),C$=r(k),Un=l(k,"DIV",{class:!0});var Jo=j(Un);h(oc.$$.fragment,Jo),I$=r(Jo),Og=l(Jo,"P",{"data-svelte-h":!0}),d(Og)!=="svelte-o2dz8s"&&(Og.textContent=G0),A$=r(Jo),Qg=l(Jo,"P",{"data-svelte-h":!0}),d(Qg)!=="svelte-198t660"&&(Qg.innerHTML=F0),Jo.forEach(p),N$=r(k),Cn=l(k,"DIV",{class:!0});var Eo=j(Cn);h(ac.$$.fragment,Eo),J$=r(Eo),Kg=l(Eo,"P",{"data-svelte-h":!0}),d(Kg)!=="svelte-kx7a2l"&&(Kg.textContent=S0),E$=r(Eo),h(ks.$$.fragment,Eo),Eo.forEach(p),D$=r(k),he=l(k,"DIV",{class:!0});var Ue=j(he);h(sc.$$.fragment,Ue),R$=r(Ue),eu=l(Ue,"P",{"data-svelte-h":!0}),d(eu)!=="svelte-i4rj9b"&&(eu.textContent=L0),G$=r(Ue),tu=l(Ue,"P",{"data-svelte-h":!0}),d(tu)!=="svelte-15iw2gd"&&(tu.innerHTML=Z0),F$=r(Ue),nu=l(Ue,"P",{"data-svelte-h":!0}),d(nu)!=="svelte-8s7qco"&&(nu.innerHTML=W0),S$=r(Ue),h(Ts.$$.fragment,Ue),Ue.forEach(p),L$=r(k),fe=l(k,"DIV",{class:!0});var Ce=j(fe);h(rc.$$.fragment,Ce),Z$=r(Ce),ou=l(Ce,"P",{"data-svelte-h":!0}),d(ou)!=="svelte-1o4vhqw"&&(ou.textContent=P0),W$=r(Ce),au=l(Ce,"P",{"data-svelte-h":!0}),d(au)!=="svelte-11lpom8"&&(au.textContent=V0),P$=r(Ce),h(js.$$.fragment,Ce),V$=r(Ce),h(qs.$$.fragment,Ce),Ce.forEach(p),B$=r(k),In=l(k,"DIV",{class:!0});var Do=j(In);h(ic.$$.fragment,Do),Y$=r(Do),su=l(Do,"P",{"data-svelte-h":!0}),d(su)!=="svelte-13uq06b"&&(su.textContent=B0),X$=r(Do),h(Ms.$$.fragment,Do),Do.forEach(p),z$=r(k),it=l(k,"DIV",{class:!0});var Yt=j(it);h(cc.$$.fragment,Yt),O$=r(Yt),ru=l(Yt,"P",{"data-svelte-h":!0}),d(ru)!=="svelte-6vx93v"&&(ru.textContent=Y0),Q$=r(Yt),iu=l(Yt,"P",{"data-svelte-h":!0}),d(iu)!=="svelte-1992tg8"&&(iu.innerHTML=X0),K$=r(Yt),cu=l(Yt,"P",{"data-svelte-h":!0}),d(cu)!=="svelte-gmy86i"&&(cu.innerHTML=z0),Yt.forEach(p),e2=r(k),ct=l(k,"DIV",{class:!0});var Xt=j(ct);h(lc.$$.fragment,Xt),t2=r(Xt),lu=l(Xt,"P",{"data-svelte-h":!0}),d(lu)!=="svelte-h8ye5s"&&(lu.textContent=O0),n2=r(Xt),pu=l(Xt,"P",{"data-svelte-h":!0}),d(pu)!=="svelte-1u14fwi"&&(pu.innerHTML=Q0),o2=r(Xt),h(Hs.$$.fragment,Xt),Xt.forEach(p),a2=r(k),me=l(k,"DIV",{class:!0});var Ie=j(me);h(pc.$$.fragment,Ie),s2=r(Ie),du=l(Ie,"P",{"data-svelte-h":!0}),d(du)!=="svelte-t9d1pp"&&(du.textContent=K0),r2=r(Ie),gu=l(Ie,"P",{"data-svelte-h":!0}),d(gu)!=="svelte-xxyl9g"&&(gu.innerHTML=ej),i2=r(Ie),uu=l(Ie,"P",{"data-svelte-h":!0}),d(uu)!=="svelte-1v8h65f"&&(uu.innerHTML=tj),c2=r(Ie),hu=l(Ie,"P",{"data-svelte-h":!0}),d(hu)!=="svelte-k7g81c"&&(hu.textContent=nj),Ie.forEach(p),l2=r(k),lt=l(k,"DIV",{class:!0});var zt=j(lt);h(dc.$$.fragment,zt),p2=r(zt),fu=l(zt,"P",{"data-svelte-h":!0}),d(fu)!=="svelte-1lgtcoe"&&(fu.textContent=oj),d2=r(zt),mu=l(zt,"P",{"data-svelte-h":!0}),d(mu)!=="svelte-zugpyn"&&(mu.textContent=aj),g2=r(zt),h(Us.$$.fragment,zt),zt.forEach(p),u2=r(k),Y=l(k,"DIV",{class:!0});var se=j(Y);h(gc.$$.fragment,se),h2=r(se),_u=l(se,"P",{"data-svelte-h":!0}),d(_u)!=="svelte-1j5taqn"&&(_u.textContent=sj),f2=r(se),bu=l(se,"P",{"data-svelte-h":!0}),d(bu)!=="svelte-1oloczu"&&(bu.textContent=rj),m2=r(se),h(Cs.$$.fragment,se),_2=r(se),h(Is.$$.fragment,se),b2=r(se),h(As.$$.fragment,se),se.forEach(p),v2=r(k),_e=l(k,"DIV",{class:!0});var Fn=j(_e);h(uc.$$.fragment,Fn),y2=r(Fn),vu=l(Fn,"P",{"data-svelte-h":!0}),d(vu)!=="svelte-z82c1y"&&(vu.textContent=ij),x2=r(Fn),yu=l(Fn,"P",{"data-svelte-h":!0}),d(yu)!=="svelte-w9m9bs"&&(yu.innerHTML=cj),$2=r(Fn),xu=l(Fn,"P",{"data-svelte-h":!0}),d(xu)!=="svelte-19j5u9b"&&(xu.innerHTML=lj),w2=r(Fn),h(Ns.$$.fragment,Fn),Fn.forEach(p),k2=r(k),An=l(k,"DIV",{class:!0});var Ph=j(An);h(hc.$$.fragment,Ph),T2=r(Ph),$u=l(Ph,"P",{"data-svelte-h":!0}),d($u)!=="svelte-klf1wz"&&($u.textContent=pj),j2=r(Ph),h(Js.$$.fragment,Ph),Ph.forEach(p),q2=r(k),be=l(k,"DIV",{class:!0});var Sn=j(be);h(fc.$$.fragment,Sn),M2=r(Sn),wu=l(Sn,"P",{"data-svelte-h":!0}),d(wu)!=="svelte-6tdefx"&&(wu.textContent=dj),H2=r(Sn),ku=l(Sn,"P",{"data-svelte-h":!0}),d(ku)!=="svelte-sjutdt"&&(ku.textContent=gj),U2=r(Sn),Tu=l(Sn,"P",{"data-svelte-h":!0}),d(Tu)!=="svelte-164ppjv"&&(Tu.innerHTML=uj),C2=r(Sn),h(Es.$$.fragment,Sn),Sn.forEach(p),I2=r(k),pt=l(k,"DIV",{class:!0});var sr=j(pt);h(mc.$$.fragment,sr),A2=r(sr),ju=l(sr,"P",{"data-svelte-h":!0}),d(ju)!=="svelte-tgkk8q"&&(ju.textContent=hj),N2=r(sr),qu=l(sr,"P",{"data-svelte-h":!0}),d(qu)!=="svelte-1yeoh0w"&&(qu.textContent=fj),J2=r(sr),Mu=l(sr,"P",{"data-svelte-h":!0}),d(Mu)!=="svelte-1bxaipy"&&(Mu.innerHTML=mj),sr.forEach(p),E2=r(k),Nn=l(k,"DIV",{class:!0});var Vh=j(Nn);h(_c.$$.fragment,Vh),D2=r(Vh),Hu=l(Vh,"P",{"data-svelte-h":!0}),d(Hu)!=="svelte-1xslq7e"&&(Hu.textContent=_j),R2=r(Vh),Uu=l(Vh,"P",{"data-svelte-h":!0}),d(Uu)!=="svelte-zgmljc"&&(Uu.textContent=bj),Vh.forEach(p),G2=r(k),dt=l(k,"DIV",{class:!0});var rr=j(dt);h(bc.$$.fragment,rr),F2=r(rr),Cu=l(rr,"P",{"data-svelte-h":!0}),d(Cu)!=="svelte-1icdi1y"&&(Cu.textContent=vj),S2=r(rr),Iu=l(rr,"P",{"data-svelte-h":!0}),d(Iu)!=="svelte-1b93kvt"&&(Iu.innerHTML=yj),L2=r(rr),h(Ds.$$.fragment,rr),rr.forEach(p),Z2=r(k),Jn=l(k,"DIV",{class:!0});var Bh=j(Jn);h(vc.$$.fragment,Bh),W2=r(Bh),Au=l(Bh,"P",{"data-svelte-h":!0}),d(Au)!=="svelte-1a9paom"&&(Au.textContent=xj),P2=r(Bh),h(Rs.$$.fragment,Bh),Bh.forEach(p),V2=r(k),ve=l(k,"DIV",{class:!0});var Ln=j(ve);h(yc.$$.fragment,Ln),B2=r(Ln),Nu=l(Ln,"P",{"data-svelte-h":!0}),d(Nu)!=="svelte-kukbcr"&&(Nu.textContent=$j),Y2=r(Ln),h(Gs.$$.fragment,Ln),X2=r(Ln),h(Fs.$$.fragment,Ln),z2=r(Ln),h(Ss.$$.fragment,Ln),Ln.forEach(p),O2=r(k),N=l(k,"DIV",{class:!0});var D=j(N);h(xc.$$.fragment,D),Q2=r(D),Ju=l(D,"P",{"data-svelte-h":!0}),d(Ju)!=="svelte-1nvey1d"&&(Ju.textContent=wj),K2=r(D),Eu=l(D,"P",{"data-svelte-h":!0}),d(Eu)!=="svelte-1vu0l4l"&&(Eu.textContent=kj),e1=r(D),Du=l(D,"P",{"data-svelte-h":!0}),d(Du)!=="svelte-adrskp"&&(Du.innerHTML=Tj),t1=r(D),Ru=l(D,"P",{"data-svelte-h":!0}),d(Ru)!=="svelte-1m6fudm"&&(Ru.innerHTML=jj),n1=r(D),Gu=l(D,"P",{"data-svelte-h":!0}),d(Gu)!=="svelte-nojwu3"&&(Gu.innerHTML=qj),o1=r(D),Fu=l(D,"P",{"data-svelte-h":!0}),d(Fu)!=="svelte-90ewc6"&&(Fu.innerHTML=Mj),a1=r(D),h(Ls.$$.fragment,D),s1=r(D),h(Zs.$$.fragment,D),r1=r(D),h(Ws.$$.fragment,D),i1=r(D),h(Ps.$$.fragment,D),D.forEach(p),c1=r(k),A=l(k,"DIV",{class:!0});var E=j(A);h($c.$$.fragment,E),l1=r(E),Su=l(E,"P",{"data-svelte-h":!0}),d(Su)!=="svelte-1a1ittk"&&(Su.textContent=Hj),p1=r(E),Lu=l(E,"P",{"data-svelte-h":!0}),d(Lu)!=="svelte-3l9535"&&(Lu.innerHTML=Uj),d1=r(E),h(Vs.$$.fragment,E),g1=r(E),h(Bs.$$.fragment,E),u1=r(E),Zu=l(E,"P",{"data-svelte-h":!0}),d(Zu)!=="svelte-8c4beu"&&(Zu.innerHTML=Cj),h1=r(E),Wu=l(E,"P",{"data-svelte-h":!0}),d(Wu)!=="svelte-25734v"&&(Wu.innerHTML=Ij),f1=r(E),Pu=l(E,"OL",{"data-svelte-h":!0}),d(Pu)!=="svelte-1ewi7og"&&(Pu.innerHTML=Aj),m1=r(E),Vu=l(E,"P",{"data-svelte-h":!0}),d(Vu)!=="svelte-59ei85"&&(Vu.textContent=Nj),_1=r(E),Bu=l(E,"OL",{"data-svelte-h":!0}),d(Bu)!=="svelte-1igkyl7"&&(Bu.innerHTML=Jj),b1=r(E),Yu=l(E,"P",{"data-svelte-h":!0}),d(Yu)!=="svelte-w718ua"&&(Yu.textContent=Ej),v1=r(E),Xu=l(E,"UL",{"data-svelte-h":!0}),d(Xu)!=="svelte-c57nbb"&&(Xu.innerHTML=Dj),E.forEach(p),y1=r(k),Ys=l(k,"DIV",{class:!0});var lm=j(Ys);h(wc.$$.fragment,lm),x1=r(lm),zu=l(lm,"P",{"data-svelte-h":!0}),d(zu)!=="svelte-l7gr50"&&(zu.textContent=Rj),lm.forEach(p),k.forEach(p),gf=r(t),h(kc.$$.fragment,t),uf=r(t),h(Tc.$$.fragment,t),hf=r(t),Bn=l(t,"DIV",{class:!0});var pm=j(Bn);h(jc.$$.fragment,pm),$1=r(pm),Ou=l(pm,"P",{"data-svelte-h":!0}),d(Ou)!=="svelte-frgpd7"&&(Ou.textContent=Gj),pm.forEach(p),ff=r(t),h(qc.$$.fragment,t),mf=r(t),ut=l(t,"DIV",{class:!0});var Yh=j(ut);h(Mc.$$.fragment,Yh),w1=r(Yh),Qu=l(Yh,"P",{"data-svelte-h":!0}),d(Qu)!=="svelte-n4j72f"&&(Qu.textContent=Fj),k1=r(Yh),Ku=l(Yh,"P",{"data-svelte-h":!0}),d(Ku)!=="svelte-102qt1n"&&(Ku.innerHTML=Sj),Yh.forEach(p),_f=r(t),h(Hc.$$.fragment,t),bf=r(t),ht=l(t,"DIV",{class:!0});var Xh=j(ht);h(Uc.$$.fragment,Xh),T1=r(Xh),eh=l(Xh,"P",{"data-svelte-h":!0}),d(eh)!=="svelte-swwjpw"&&(eh.innerHTML=Lj),j1=r(Xh),h(Xs.$$.fragment,Xh),Xh.forEach(p),vf=r(t),h(Cc.$$.fragment,t),yf=r(t),Yn=l(t,"DIV",{class:!0});var dm=j(Yn);h(Ic.$$.fragment,dm),q1=r(dm),th=l(dm,"P",{"data-svelte-h":!0}),d(th)!=="svelte-1dp8z99"&&(th.textContent=Zj),dm.forEach(p),xf=r(t),h(Ac.$$.fragment,t),$f=r(t),Xn=l(t,"DIV",{class:!0});var gm=j(Xn);h(Nc.$$.fragment,gm),M1=r(gm),nh=l(gm,"P",{"data-svelte-h":!0}),d(nh)!=="svelte-1m53mfe"&&(nh.innerHTML=Wj),gm.forEach(p),wf=r(t),h(Jc.$$.fragment,t),kf=r(t),ft=l(t,"DIV",{class:!0});var zh=j(ft);h(Ec.$$.fragment,zh),H1=r(zh),oh=l(zh,"P",{"data-svelte-h":!0}),d(oh)!=="svelte-8pkqdq"&&(oh.textContent=Pj),U1=r(zh),ah=l(zh,"P",{"data-svelte-h":!0}),d(ah)!=="svelte-vdyl1q"&&(ah.innerHTML=Vj),zh.forEach(p),Tf=r(t),h(Dc.$$.fragment,t),jf=r(t),Rc=l(t,"DIV",{class:!0});var Nq=j(Rc);h(Gc.$$.fragment,Nq),Nq.forEach(p),qf=r(t),h(Fc.$$.fragment,t),Mf=r(t),z=l(t,"DIV",{class:!0});var Zn=j(z);h(Sc.$$.fragment,Zn),C1=r(Zn),sh=l(Zn,"P",{"data-svelte-h":!0}),d(sh)!=="svelte-ezr8kg"&&(sh.textContent=Bj),I1=r(Zn),rh=l(Zn,"P",{"data-svelte-h":!0}),d(rh)!=="svelte-1e5wnmv"&&(rh.innerHTML=Yj),A1=r(Zn),ih=l(Zn,"P",{"data-svelte-h":!0}),d(ih)!=="svelte-333hb6"&&(ih.innerHTML=Xj),N1=r(Zn),h(zs.$$.fragment,Zn),Zn.forEach(p),Hf=r(t),h(Lc.$$.fragment,t),Uf=r(t),mt=l(t,"DIV",{class:!0});var Oh=j(mt);h(Zc.$$.fragment,Oh),J1=r(Oh),ch=l(Oh,"P",{"data-svelte-h":!0}),d(ch)!=="svelte-fvugq9"&&(ch.innerHTML=zj),E1=r(Oh),h(Os.$$.fragment,Oh),Oh.forEach(p),Cf=r(t),h(Wc.$$.fragment,t),If=r(t),_t=l(t,"DIV",{class:!0});var Qh=j(_t);h(Pc.$$.fragment,Qh),D1=r(Qh),lh=l(Qh,"P",{"data-svelte-h":!0}),d(lh)!=="svelte-pzc88f"&&(lh.textContent=Oj),R1=r(Qh),h(Qs.$$.fragment,Qh),Qh.forEach(p),Af=r(t),h(Vc.$$.fragment,t),Nf=r(t),zn=l(t,"DIV",{class:!0});var um=j(zn);h(Bc.$$.fragment,um),G1=r(um),ph=l(um,"P",{"data-svelte-h":!0}),d(ph)!=="svelte-1eicjbk"&&(ph.textContent=Qj),um.forEach(p),Jf=r(t),h(Yc.$$.fragment,t),Ef=r(t),O=l(t,"DIV",{class:!0});var Wn=j(O);h(Xc.$$.fragment,Wn),F1=r(Wn),dh=l(Wn,"P",{"data-svelte-h":!0}),d(dh)!=="svelte-1v78htg"&&(dh.innerHTML=Kj),S1=r(Wn),gh=l(Wn,"P",{"data-svelte-h":!0}),d(gh)!=="svelte-murgw9"&&(gh.innerHTML=eq),L1=r(Wn),uh=l(Wn,"UL",{"data-svelte-h":!0}),d(uh)!=="svelte-1mrng5l"&&(uh.innerHTML=tq),Z1=r(Wn),h(Ks.$$.fragment,Wn),Wn.forEach(p),Df=r(t),h(zc.$$.fragment,t),Rf=r(t),Q=l(t,"DIV",{class:!0});var Pn=j(Q);h(Oc.$$.fragment,Pn),W1=r(Pn),hh=l(Pn,"P",{"data-svelte-h":!0}),d(hh)!=="svelte-ovnxfi"&&(hh.textContent=nq),P1=r(Pn),fh=l(Pn,"P",{"data-svelte-h":!0}),d(fh)!=="svelte-afv8fv"&&(fh.textContent=oq),V1=r(Pn),mh=l(Pn,"P",{"data-svelte-h":!0}),d(mh)!=="svelte-18gvp4f"&&(mh.innerHTML=aq),B1=r(Pn),_h=l(Pn,"P",{"data-svelte-h":!0}),d(_h)!=="svelte-ndzof3"&&(_h.innerHTML=sq),Pn.forEach(p),Gf=r(t),h(Qc.$$.fragment,t),Ff=r(t),ye=l(t,"DIV",{class:!0});var ir=j(ye);h(Kc.$$.fragment,ir),Y1=r(ir),bh=l(ir,"P",{"data-svelte-h":!0}),d(bh)!=="svelte-2ejdv8"&&(bh.textContent=rq),X1=r(ir),vh=l(ir,"P",{"data-svelte-h":!0}),d(vh)!=="svelte-1ff2vxz"&&(vh.innerHTML=iq),z1=r(ir),yh=l(ir,"P",{"data-svelte-h":!0}),d(yh)!=="svelte-ndzof3"&&(yh.innerHTML=cq),ir.forEach(p),Sf=r(t),h(el.$$.fragment,t),Lf=r(t),bt=l(t,"DIV",{class:!0});var Kh=j(bt);h(tl.$$.fragment,Kh),O1=r(Kh),xh=l(Kh,"P",{"data-svelte-h":!0}),d(xh)!=="svelte-1fsd0x6"&&(xh.innerHTML=lq),Q1=r(Kh),h(er.$$.fragment,Kh),Kh.forEach(p),Zf=r(t),h(nl.$$.fragment,t),Wf=r(t),vt=l(t,"DIV",{class:!0});var ef=j(vt);h(ol.$$.fragment,ef),K1=r(ef),$h=l(ef,"P",{"data-svelte-h":!0}),d($h)!=="svelte-by9v9h"&&($h.textContent=pq),ew=r(ef),wh=l(ef,"P",{"data-svelte-h":!0}),d(wh)!=="svelte-ndzof3"&&(wh.innerHTML=dq),ef.forEach(p),Pf=r(t),h(al.$$.fragment,t),Vf=r(t),On=l(t,"DIV",{class:!0});var hm=j(On);h(sl.$$.fragment,hm),tw=r(hm),kh=l(hm,"P",{"data-svelte-h":!0}),d(kh)!=="svelte-f10xp"&&(kh.textContent=gq),hm.forEach(p),Bf=r(t),h(rl.$$.fragment,t),Yf=r(t),Qn=l(t,"DIV",{class:!0});var fm=j(Qn);h(il.$$.fragment,fm),nw=r(fm),Th=l(fm,"P",{"data-svelte-h":!0}),d(Th)!=="svelte-s36het"&&(Th.textContent=uq),fm.forEach(p),Xf=r(t),h(cl.$$.fragment,t),zf=r(t),Kn=l(t,"DIV",{class:!0});var mm=j(Kn);h(ll.$$.fragment,mm),ow=r(mm),jh=l(mm,"P",{"data-svelte-h":!0}),d(jh)!=="svelte-11wrzrg"&&(jh.textContent=hq),mm.forEach(p),Of=r(t),h(pl.$$.fragment,t),Qf=r(t),eo=l(t,"DIV",{class:!0});var _m=j(eo);h(dl.$$.fragment,_m),aw=r(_m),qh=l(_m,"P",{"data-svelte-h":!0}),d(qh)!=="svelte-10dpb22"&&(qh.textContent=fq),_m.forEach(p),Kf=r(t),h(gl.$$.fragment,t),em=r(t),ul=l(t,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-eea1xn"&&(ul.innerHTML=mq),tm=r(t),xe=l(t,"DIV",{class:!0});var cr=j(xe);h(hl.$$.fragment,cr),sw=r(cr),Mh=l(cr,"P",{"data-svelte-h":!0}),d(Mh)!=="svelte-1nyzeix"&&(Mh.textContent=_q),rw=r(cr),En=l(cr,"DIV",{class:!0});var tf=j(En);h(fl.$$.fragment,tf),iw=r(tf),Hh=l(tf,"P",{"data-svelte-h":!0}),d(Hh)!=="svelte-1d7s5nc"&&(Hh.innerHTML=bq),cw=r(tf),h(tr.$$.fragment,tf),tf.forEach(p),lw=r(cr),Dn=l(cr,"DIV",{class:!0});var nf=j(Dn);h(ml.$$.fragment,nf),pw=r(nf),Uh=l(nf,"P",{"data-svelte-h":!0}),d(Uh)!=="svelte-1o44akx"&&(Uh.innerHTML=vq),dw=r(nf),Ch=l(nf,"P",{"data-svelte-h":!0}),d(Ch)!=="svelte-huzhzj"&&(Ch.innerHTML=yq),nf.forEach(p),cr.forEach(p),nm=r(t),to=l(t,"DIV",{class:!0});var bm=j(to);h(_l.$$.fragment,bm),gw=r(bm),Ih=l(bm,"P",{"data-svelte-h":!0}),d(Ih)!=="svelte-1cij9yu"&&(Ih.textContent=xq),bm.forEach(p),om=r(t),K=l(t,"DIV",{class:!0});var Vn=j(K);h(bl.$$.fragment,Vn),uw=r(Vn),Ah=l(Vn,"P",{"data-svelte-h":!0}),d(Ah)!=="svelte-bx32lj"&&(Ah.textContent=$q),hw=r(Vn),Nh=l(Vn,"P",{"data-svelte-h":!0}),d(Nh)!=="svelte-1a6nwfz"&&(Nh.textContent=wq),fw=r(Vn),Jh=l(Vn,"UL",{"data-svelte-h":!0}),d(Jh)!=="svelte-1wreq5n"&&(Jh.innerHTML=kq),mw=r(Vn),Eh=l(Vn,"P",{"data-svelte-h":!0}),d(Eh)!=="svelte-zlmtk1"&&(Eh.innerHTML=Tq),Vn.forEach(p),am=r(t),h(vl.$$.fragment,t),sm=r(t),R=l(t,"DIV",{class:!0});var X=j(R);h(yl.$$.fragment,X),_w=r(X),Dh=l(X,"P",{"data-svelte-h":!0}),d(Dh)!=="svelte-1wfz9hx"&&(Dh.textContent=jq),bw=r(X),Rh=l(X,"P",{"data-svelte-h":!0}),d(Rh)!=="svelte-10g22je"&&(Rh.innerHTML=qq),vw=r(X),h(nr.$$.fragment,X),yw=r(X),h(or.$$.fragment,X),xw=r(X),gt=l(X,"DIV",{class:!0});var lr=j(gt);h(xl.$$.fragment,lr),$w=r(lr),Gh=l(lr,"P",{"data-svelte-h":!0}),d(Gh)!=="svelte-e95u7k"&&(Gh.textContent=Mq),ww=r(lr),h(ar.$$.fragment,lr),kw=r(lr),Fh=l(lr,"P",{"data-svelte-h":!0}),d(Fh)!=="svelte-eijr4"&&(Fh.innerHTML=Hq),lr.forEach(p),Tw=r(X),Rn=l(X,"DIV",{class:!0});var of=j(Rn);h($l.$$.fragment,of),jw=r(of),Sh=l(of,"P",{"data-svelte-h":!0}),d(Sh)!=="svelte-t1x1k0"&&(Sh.textContent=Uq),qw=r(of),Lh=l(of,"P",{"data-svelte-h":!0}),d(Lh)!=="svelte-1jdo3t2"&&(Lh.textContent=Cq),of.forEach(p),Mw=r(X),Gn=l(X,"DIV",{class:!0});var af=j(Gn);h(wl.$$.fragment,af),Hw=r(af),Zh=l(af,"P",{"data-svelte-h":!0}),d(Zh)!=="svelte-m2dnyn"&&(Zh.innerHTML=Iq),Uw=r(af),Wh=l(af,"P",{"data-svelte-h":!0}),d(Wh)!=="svelte-aasb0o"&&(Wh.innerHTML=Aq),af.forEach(p),X.forEach(p),rm=r(t),h(kl.$$.fragment,t),im=r(t),sf=l(t,"P",{}),j(sf).forEach(p),this.h()},h(){q(o,"name","hf:doc:metadata"),q(o,"content",ZH),q(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Fo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Po,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(oa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ra,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ga,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ua,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q($a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ka,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(qa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ia,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Va,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(za,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(to,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,y){n(document.head,o),$(t,v,y),$(t,i,y),$(t,a,y),f(g,t,y),$(t,e,y),$(t,x,y),$(t,rf,y),$(t,pr,y),$(t,cf,y),$(t,dr,y),$(t,lf,y),f(gr,t,y),$(t,pf,y),f(ur,t,y),$(t,df,y),$(t,w,y),f(hr,w,null),n(w,vm),n(w,Vl),n(w,ym),n(w,Bl),n(w,xm),n(w,Ae),f(fr,Ae,null),n(Ae,$m),n(Ae,Yl),n(Ae,wm),n(Ae,Xl),n(Ae,km),n(Ae,zl),n(w,Tm),n(w,Ne),f(mr,Ne,null),n(Ne,jm),n(Ne,Ol),n(Ne,qm),n(Ne,Ql),n(Ne,Mm),f(Ro,Ne,null),n(w,Hm),n(w,Ot),f(_r,Ot,null),n(Ot,Um),n(Ot,Kl),n(Ot,Cm),n(Ot,ep),n(w,Im),n(w,Qt),f(br,Qt,null),n(Qt,Am),n(Qt,tp),n(Qt,Nm),n(Qt,np),n(w,Jm),n(w,G),f(vr,G,null),n(G,Em),n(G,op),n(G,Dm),n(G,ap),n(G,Rm),n(G,sp),n(G,Gm),f(Go,G,null),n(G,Fm),n(G,rp),n(G,Sm),n(G,ip),n(w,Lm),n(w,Je),f(yr,Je,null),n(Je,Zm),n(Je,cp),n(Je,Wm),n(Je,lp),n(Je,Pm),n(Je,pp),n(w,Vm),n(w,Fo),f(xr,Fo,null),n(Fo,Bm),n(Fo,dp),n(w,Ym),n(w,Ee),f($r,Ee,null),n(Ee,Xm),n(Ee,gp),n(Ee,zm),f(So,Ee,null),n(Ee,Om),f(Lo,Ee,null),n(w,Qm),n(w,De),f(wr,De,null),n(De,Km),n(De,up),n(De,e_),f(Zo,De,null),n(De,t_),f(Wo,De,null),n(w,n_),n(w,Po),f(kr,Po,null),n(Po,o_),n(Po,hp),n(w,a_),n(w,Re),f(Tr,Re,null),n(Re,s_),n(Re,fp),n(Re,r_),n(Re,mp),n(Re,i_),f(Vo,Re,null),n(w,c_),n(w,re),f(jr,re,null),n(re,l_),n(re,_p),n(re,p_),f(Bo,re,null),n(re,d_),f(Yo,re,null),n(re,g_),f(Xo,re,null),n(w,u_),n(w,Z),f(qr,Z,null),n(Z,h_),n(Z,bp),n(Z,f_),n(Z,vp),n(Z,m_),n(Z,yp),n(Z,__),n(Z,xp),n(Z,b_),f(zo,Z,null),n(w,v_),n(w,ie),f(Mr,ie,null),n(ie,y_),n(ie,$p),n(ie,x_),f(Oo,ie,null),n(ie,$_),f(Qo,ie,null),n(ie,w_),f(Ko,ie,null),n(w,k_),n(w,Ge),f(Hr,Ge,null),n(Ge,T_),n(Ge,wp),n(Ge,j_),n(Ge,kp),n(Ge,q_),f(ea,Ge,null),n(w,M_),n(w,W),f(Ur,W,null),n(W,H_),n(W,Tp),n(W,U_),n(W,jp),n(W,C_),n(W,qp),n(W,I_),n(W,Mp),n(W,A_),f(ta,W,null),n(w,N_),n(w,na),f(Cr,na,null),n(na,J_),n(na,Hp),n(w,E_),n(w,oa),f(Ir,oa,null),n(oa,D_),n(oa,Up),n(w,R_),n(w,Kt),f(Ar,Kt,null),n(Kt,G_),n(Kt,Cp),n(Kt,F_),f(aa,Kt,null),n(w,S_),n(w,Fe),f(Nr,Fe,null),n(Fe,L_),n(Fe,Ip),n(Fe,Z_),n(Fe,Ap),n(Fe,W_),f(sa,Fe,null),n(w,P_),n(w,ra),f(Jr,ra,null),n(ra,V_),n(ra,Np),n(w,B_),n(w,Se),f(Er,Se,null),n(Se,Y_),n(Se,Jp),n(Se,X_),f(ia,Se,null),n(Se,z_),f(ca,Se,null),n(w,O_),n(w,en),f(Dr,en,null),n(en,Q_),n(en,Ep),n(en,K_),f(la,en,null),n(w,eb),n(w,tn),f(Rr,tn,null),n(tn,tb),n(tn,Dp),n(tn,nb),f(pa,tn,null),n(w,ob),n(w,nn),f(Gr,nn,null),n(nn,ab),n(nn,Rp),n(nn,sb),n(nn,Gp),n(w,rb),n(w,on),f(Fr,on,null),n(on,ib),n(on,Fp),n(on,cb),n(on,Sp),n(w,lb),n(w,Le),f(Sr,Le,null),n(Le,pb),n(Le,Lp),n(Le,db),n(Le,Zp),n(Le,gb),n(Le,Wp),n(w,ub),n(w,da),f(Lr,da,null),n(da,hb),n(da,Pp),n(w,fb),n(w,an),f(Zr,an,null),n(an,mb),n(an,Vp),n(an,_b),n(an,Bp),n(w,bb),n(w,ga),f(Wr,ga,null),n(ga,vb),n(ga,Yp),n(w,yb),n(w,sn),f(Pr,sn,null),n(sn,xb),n(sn,Xp),n(sn,$b),n(sn,zp),n(w,wb),n(w,ua),f(Vr,ua,null),n(ua,kb),n(ua,Op),n(w,Tb),n(w,rn),f(Br,rn,null),n(rn,jb),n(rn,Qp),n(rn,qb),f(ha,rn,null),n(w,Mb),n(w,cn),f(Yr,cn,null),n(cn,Hb),n(cn,Kp),n(cn,Ub),f(fa,cn,null),n(w,Cb),n(w,Ze),f(Xr,Ze,null),n(Ze,Ib),n(Ze,ed),n(Ze,Ab),n(Ze,td),n(Ze,Nb),f(ma,Ze,null),n(w,Jb),n(w,ln),f(zr,ln,null),n(ln,Eb),n(ln,nd),n(ln,Db),f(_a,ln,null),n(w,Rb),n(w,pn),f(Or,pn,null),n(pn,Gb),n(pn,od),n(pn,Fb),f(ba,pn,null),n(w,Sb),n(w,dn),f(Qr,dn,null),n(dn,Lb),n(dn,ad),n(dn,Zb),f(va,dn,null),n(w,Wb),n(w,gn),f(Kr,gn,null),n(gn,Pb),n(gn,sd),n(gn,Vb),f(ya,gn,null),n(w,Bb),n(w,We),f(ei,We,null),n(We,Yb),n(We,rd),n(We,Xb),n(We,id),n(We,zb),f(xa,We,null),n(w,Ob),n(w,$a),f(ti,$a,null),n($a,Qb),n($a,cd),n(w,Kb),n(w,Pe),f(ni,Pe,null),n(Pe,ev),n(Pe,ld),n(Pe,tv),n(Pe,pd),n(Pe,nv),f(wa,Pe,null),n(w,ov),n(w,ka),f(oi,ka,null),n(ka,av),n(ka,dd),n(w,sv),n(w,Ta),f(ai,Ta,null),n(Ta,rv),n(Ta,gd),n(w,iv),n(w,un),f(si,un,null),n(un,cv),n(un,ud),n(un,lv),f(ja,un,null),n(w,pv),n(w,qa),f(ri,qa,null),n(qa,dv),n(qa,hd),n(w,gv),n(w,hn),f(ii,hn,null),n(hn,uv),n(hn,fd),n(hn,hv),f(Ma,hn,null),n(w,fv),n(w,ce),f(ci,ce,null),n(ce,mv),n(ce,md),n(ce,_v),n(ce,_d),n(ce,bv),f(Ha,ce,null),n(ce,vv),f(Ua,ce,null),n(w,yv),n(w,P),f(li,P,null),n(P,xv),n(P,bd),n(P,$v),n(P,vd),n(P,wv),n(P,yd),n(P,kv),n(P,xd),n(P,Tv),f(Ca,P,null),n(w,jv),n(w,Ia),f(pi,Ia,null),n(Ia,qv),n(Ia,$d),n(w,Mv),n(w,fn),f(di,fn,null),n(fn,Hv),n(fn,wd),n(fn,Uv),n(fn,kd),n(w,Cv),n(w,Ve),f(gi,Ve,null),n(Ve,Iv),n(Ve,Td),n(Ve,Av),f(Aa,Ve,null),n(Ve,Nv),n(Ve,jd),n(w,Jv),n(w,Na),f(ui,Na,null),n(Na,Ev),n(Na,qd),n(w,Dv),n(w,mn),f(hi,mn,null),n(mn,Rv),n(mn,Md),n(mn,Gv),f(Ja,mn,null),n(w,Fv),n(w,Be),f(fi,Be,null),n(Be,Sv),n(Be,Hd),n(Be,Lv),n(Be,Ud),n(Be,Zv),n(Be,Cd),n(w,Wv),n(w,V),f(mi,V,null),n(V,Pv),n(V,Id),n(V,Vv),n(V,Ad),n(V,Bv),n(V,Nd),n(V,Yv),f(Ea,V,null),n(V,Xv),n(V,Jd),n(w,zv),n(w,Ye),f(_i,Ye,null),n(Ye,Ov),n(Ye,Ed),n(Ye,Qv),f(Da,Ye,null),n(Ye,Kv),f(Ra,Ye,null),n(w,ey),n(w,_n),f(bi,_n,null),n(_n,ty),n(_n,Dd),n(_n,ny),f(Ga,_n,null),n(w,oy),n(w,le),f(vi,le,null),n(le,ay),n(le,Rd),n(le,sy),n(le,Gd),n(le,ry),n(le,Fd),n(le,iy),f(Fa,le,null),n(w,cy),n(w,bn),f(yi,bn,null),n(bn,ly),n(bn,Sd),n(bn,py),f(Sa,bn,null),n(w,dy),n(w,Xe),f(xi,Xe,null),n(Xe,gy),n(Xe,Ld),n(Xe,uy),f(La,Xe,null),n(Xe,hy),f(Za,Xe,null),n(w,fy),n(w,pe),f($i,pe,null),n(pe,my),n(pe,Zd),n(pe,_y),n(pe,Wd),n(pe,by),n(pe,Pd),n(pe,vy),f(Wa,pe,null),n(w,yy),n(w,vn),f(wi,vn,null),n(vn,xy),n(vn,Vd),n(vn,$y),f(Pa,vn,null),n(w,wy),n(w,Va),f(ki,Va,null),n(Va,ky),n(Va,Bd),n(w,Ty),n(w,ze),f(Ti,ze,null),n(ze,jy),n(ze,Yd),n(ze,qy),n(ze,Xd),n(ze,My),f(Ba,ze,null),n(w,Hy),n(w,de),f(ji,de,null),n(de,Uy),n(de,zd),n(de,Cy),n(de,Od),n(de,Iy),n(de,Qd),n(de,Ay),f(Ya,de,null),n(w,Ny),n(w,yn),f(qi,yn,null),n(yn,Jy),n(yn,Kd),n(yn,Ey),f(Xa,yn,null),n(w,Dy),n(w,za),f(Mi,za,null),n(za,Ry),n(za,eg),n(w,Gy),n(w,xn),f(Hi,xn,null),n(xn,Fy),n(xn,tg),n(xn,Sy),f(Oa,xn,null),n(w,Ly),n(w,ge),f(Ui,ge,null),n(ge,Zy),n(ge,ng),n(ge,Wy),n(ge,og),n(ge,Py),n(ge,ag),n(ge,Vy),f(Qa,ge,null),n(w,By),n(w,ue),f(Ci,ue,null),n(ue,Yy),n(ue,sg),n(ue,Xy),n(ue,rg),n(ue,zy),n(ue,ig),n(ue,Oy),f(Ka,ue,null),n(w,Qy),n(w,Oe),f(Ii,Oe,null),n(Oe,Ky),n(Oe,cg),n(Oe,ex),n(Oe,lg),n(Oe,tx),f(es,Oe,null),n(w,nx),n(w,ts),f(Ai,ts,null),n(ts,ox),n(ts,pg),n(w,ax),n(w,$n),f(Ni,$n,null),n($n,sx),n($n,dg),n($n,rx),n($n,gg),n(w,ix),n(w,wn),f(Ji,wn,null),n(wn,cx),n(wn,ug),n(wn,lx),f(ns,wn,null),n(w,px),n(w,F),f(Ei,F,null),n(F,dx),n(F,hg),n(F,gx),n(F,fg),n(F,ux),n(F,mg),n(F,hx),f(os,F,null),n(F,fx),n(F,_g),n(F,mx),f(as,F,null),n(w,_x),n(w,ss),f(Di,ss,null),n(ss,bx),n(ss,bg),n(w,vx),n(w,rs),f(Ri,rs,null),n(rs,yx),n(rs,vg),n(w,xx),n(w,is),f(Gi,is,null),n(is,$x),n(is,yg),n(w,wx),n(w,kn),f(Fi,kn,null),n(kn,kx),n(kn,xg),n(kn,Tx),f(cs,kn,null),n(w,jx),n(w,Tn),f(Si,Tn,null),n(Tn,qx),n(Tn,$g),n(Tn,Mx),f(ls,Tn,null),n(w,Hx),n(w,Qe),f(Li,Qe,null),n(Qe,Ux),n(Qe,wg),n(Qe,Cx),n(Qe,kg),n(Qe,Ix),f(ps,Qe,null),n(w,Ax),n(w,Ke),f(Zi,Ke,null),n(Ke,Nx),n(Ke,Tg),n(Ke,Jx),n(Ke,jg),n(Ke,Ex),f(ds,Ke,null),n(w,Dx),n(w,gs),f(Wi,gs,null),n(gs,Rx),n(gs,qg),n(w,Gx),n(w,et),f(Pi,et,null),n(et,Fx),n(et,Mg),n(et,Sx),n(et,Hg),n(et,Lx),n(et,Ug),n(w,Zx),n(w,tt),f(Vi,tt,null),n(tt,Wx),n(tt,Cg),n(tt,Px),n(tt,Ig),n(tt,Vx),n(tt,Ag),n(w,Bx),n(w,nt),f(Bi,nt,null),n(nt,Yx),n(nt,Ng),n(nt,Xx),n(nt,Jg),n(nt,zx),n(nt,Eg),n(w,Ox),n(w,ot),f(Yi,ot,null),n(ot,Qx),n(ot,Dg),n(ot,Kx),f(us,ot,null),n(ot,e$),f(hs,ot,null),n(w,t$),n(w,B),f(Xi,B,null),n(B,n$),n(B,Rg),n(B,o$),n(B,Gg),n(B,a$),f(fs,B,null),n(B,s$),f(ms,B,null),n(B,r$),f(_s,B,null),n(w,i$),n(w,at),f(zi,at,null),n(at,c$),n(at,Fg),n(at,l$),n(at,Sg),n(at,p$),n(at,Lg),n(w,d$),n(w,st),f(Oi,st,null),n(st,g$),n(st,Zg),n(st,u$),f(bs,st,null),n(st,h$),f(vs,st,null),n(w,f$),n(w,jn),f(Qi,jn,null),n(jn,m$),n(jn,Wg),n(jn,_$),f(ys,jn,null),n(w,b$),n(w,qn),f(Ki,qn,null),n(qn,v$),n(qn,Pg),n(qn,y$),f(xs,qn,null),n(w,x$),n(w,Mn),f(ec,Mn,null),n(Mn,$$),n(Mn,Vg),n(Mn,w$),f($s,Mn,null),n(w,k$),n(w,Hn),f(tc,Hn,null),n(Hn,T$),n(Hn,Bg),n(Hn,j$),f(ws,Hn,null),n(w,q$),n(w,rt),f(nc,rt,null),n(rt,M$),n(rt,Yg),n(rt,H$),n(rt,Xg),n(rt,U$),n(rt,zg),n(w,C$),n(w,Un),f(oc,Un,null),n(Un,I$),n(Un,Og),n(Un,A$),n(Un,Qg),n(w,N$),n(w,Cn),f(ac,Cn,null),n(Cn,J$),n(Cn,Kg),n(Cn,E$),f(ks,Cn,null),n(w,D$),n(w,he),f(sc,he,null),n(he,R$),n(he,eu),n(he,G$),n(he,tu),n(he,F$),n(he,nu),n(he,S$),f(Ts,he,null),n(w,L$),n(w,fe),f(rc,fe,null),n(fe,Z$),n(fe,ou),n(fe,W$),n(fe,au),n(fe,P$),f(js,fe,null),n(fe,V$),f(qs,fe,null),n(w,B$),n(w,In),f(ic,In,null),n(In,Y$),n(In,su),n(In,X$),f(Ms,In,null),n(w,z$),n(w,it),f(cc,it,null),n(it,O$),n(it,ru),n(it,Q$),n(it,iu),n(it,K$),n(it,cu),n(w,e2),n(w,ct),f(lc,ct,null),n(ct,t2),n(ct,lu),n(ct,n2),n(ct,pu),n(ct,o2),f(Hs,ct,null),n(w,a2),n(w,me),f(pc,me,null),n(me,s2),n(me,du),n(me,r2),n(me,gu),n(me,i2),n(me,uu),n(me,c2),n(me,hu),n(w,l2),n(w,lt),f(dc,lt,null),n(lt,p2),n(lt,fu),n(lt,d2),n(lt,mu),n(lt,g2),f(Us,lt,null),n(w,u2),n(w,Y),f(gc,Y,null),n(Y,h2),n(Y,_u),n(Y,f2),n(Y,bu),n(Y,m2),f(Cs,Y,null),n(Y,_2),f(Is,Y,null),n(Y,b2),f(As,Y,null),n(w,v2),n(w,_e),f(uc,_e,null),n(_e,y2),n(_e,vu),n(_e,x2),n(_e,yu),n(_e,$2),n(_e,xu),n(_e,w2),f(Ns,_e,null),n(w,k2),n(w,An),f(hc,An,null),n(An,T2),n(An,$u),n(An,j2),f(Js,An,null),n(w,q2),n(w,be),f(fc,be,null),n(be,M2),n(be,wu),n(be,H2),n(be,ku),n(be,U2),n(be,Tu),n(be,C2),f(Es,be,null),n(w,I2),n(w,pt),f(mc,pt,null),n(pt,A2),n(pt,ju),n(pt,N2),n(pt,qu),n(pt,J2),n(pt,Mu),n(w,E2),n(w,Nn),f(_c,Nn,null),n(Nn,D2),n(Nn,Hu),n(Nn,R2),n(Nn,Uu),n(w,G2),n(w,dt),f(bc,dt,null),n(dt,F2),n(dt,Cu),n(dt,S2),n(dt,Iu),n(dt,L2),f(Ds,dt,null),n(w,Z2),n(w,Jn),f(vc,Jn,null),n(Jn,W2),n(Jn,Au),n(Jn,P2),f(Rs,Jn,null),n(w,V2),n(w,ve),f(yc,ve,null),n(ve,B2),n(ve,Nu),n(ve,Y2),f(Gs,ve,null),n(ve,X2),f(Fs,ve,null),n(ve,z2),f(Ss,ve,null),n(w,O2),n(w,N),f(xc,N,null),n(N,Q2),n(N,Ju),n(N,K2),n(N,Eu),n(N,e1),n(N,Du),n(N,t1),n(N,Ru),n(N,n1),n(N,Gu),n(N,o1),n(N,Fu),n(N,a1),f(Ls,N,null),n(N,s1),f(Zs,N,null),n(N,r1),f(Ws,N,null),n(N,i1),f(Ps,N,null),n(w,c1),n(w,A),f($c,A,null),n(A,l1),n(A,Su),n(A,p1),n(A,Lu),n(A,d1),f(Vs,A,null),n(A,g1),f(Bs,A,null),n(A,u1),n(A,Zu),n(A,h1),n(A,Wu),n(A,f1),n(A,Pu),n(A,m1),n(A,Vu),n(A,_1),n(A,Bu),n(A,b1),n(A,Yu),n(A,v1),n(A,Xu),n(w,y1),n(w,Ys),f(wc,Ys,null),n(Ys,x1),n(Ys,zu),$(t,gf,y),f(kc,t,y),$(t,uf,y),f(Tc,t,y),$(t,hf,y),$(t,Bn,y),f(jc,Bn,null),n(Bn,$1),n(Bn,Ou),$(t,ff,y),f(qc,t,y),$(t,mf,y),$(t,ut,y),f(Mc,ut,null),n(ut,w1),n(ut,Qu),n(ut,k1),n(ut,Ku),$(t,_f,y),f(Hc,t,y),$(t,bf,y),$(t,ht,y),f(Uc,ht,null),n(ht,T1),n(ht,eh),n(ht,j1),f(Xs,ht,null),$(t,vf,y),f(Cc,t,y),$(t,yf,y),$(t,Yn,y),f(Ic,Yn,null),n(Yn,q1),n(Yn,th),$(t,xf,y),f(Ac,t,y),$(t,$f,y),$(t,Xn,y),f(Nc,Xn,null),n(Xn,M1),n(Xn,nh),$(t,wf,y),f(Jc,t,y),$(t,kf,y),$(t,ft,y),f(Ec,ft,null),n(ft,H1),n(ft,oh),n(ft,U1),n(ft,ah),$(t,Tf,y),f(Dc,t,y),$(t,jf,y),$(t,Rc,y),f(Gc,Rc,null),$(t,qf,y),f(Fc,t,y),$(t,Mf,y),$(t,z,y),f(Sc,z,null),n(z,C1),n(z,sh),n(z,I1),n(z,rh),n(z,A1),n(z,ih),n(z,N1),f(zs,z,null),$(t,Hf,y),f(Lc,t,y),$(t,Uf,y),$(t,mt,y),f(Zc,mt,null),n(mt,J1),n(mt,ch),n(mt,E1),f(Os,mt,null),$(t,Cf,y),f(Wc,t,y),$(t,If,y),$(t,_t,y),f(Pc,_t,null),n(_t,D1),n(_t,lh),n(_t,R1),f(Qs,_t,null),$(t,Af,y),f(Vc,t,y),$(t,Nf,y),$(t,zn,y),f(Bc,zn,null),n(zn,G1),n(zn,ph),$(t,Jf,y),f(Yc,t,y),$(t,Ef,y),$(t,O,y),f(Xc,O,null),n(O,F1),n(O,dh),n(O,S1),n(O,gh),n(O,L1),n(O,uh),n(O,Z1),f(Ks,O,null),$(t,Df,y),f(zc,t,y),$(t,Rf,y),$(t,Q,y),f(Oc,Q,null),n(Q,W1),n(Q,hh),n(Q,P1),n(Q,fh),n(Q,V1),n(Q,mh),n(Q,B1),n(Q,_h),$(t,Gf,y),f(Qc,t,y),$(t,Ff,y),$(t,ye,y),f(Kc,ye,null),n(ye,Y1),n(ye,bh),n(ye,X1),n(ye,vh),n(ye,z1),n(ye,yh),$(t,Sf,y),f(el,t,y),$(t,Lf,y),$(t,bt,y),f(tl,bt,null),n(bt,O1),n(bt,xh),n(bt,Q1),f(er,bt,null),$(t,Zf,y),f(nl,t,y),$(t,Wf,y),$(t,vt,y),f(ol,vt,null),n(vt,K1),n(vt,$h),n(vt,ew),n(vt,wh),$(t,Pf,y),f(al,t,y),$(t,Vf,y),$(t,On,y),f(sl,On,null),n(On,tw),n(On,kh),$(t,Bf,y),f(rl,t,y),$(t,Yf,y),$(t,Qn,y),f(il,Qn,null),n(Qn,nw),n(Qn,Th),$(t,Xf,y),f(cl,t,y),$(t,zf,y),$(t,Kn,y),f(ll,Kn,null),n(Kn,ow),n(Kn,jh),$(t,Of,y),f(pl,t,y),$(t,Qf,y),$(t,eo,y),f(dl,eo,null),n(eo,aw),n(eo,qh),$(t,Kf,y),f(gl,t,y),$(t,em,y),$(t,ul,y),$(t,tm,y),$(t,xe,y),f(hl,xe,null),n(xe,sw),n(xe,Mh),n(xe,rw),n(xe,En),f(fl,En,null),n(En,iw),n(En,Hh),n(En,cw),f(tr,En,null),n(xe,lw),n(xe,Dn),f(ml,Dn,null),n(Dn,pw),n(Dn,Uh),n(Dn,dw),n(Dn,Ch),$(t,nm,y),$(t,to,y),f(_l,to,null),n(to,gw),n(to,Ih),$(t,om,y),$(t,K,y),f(bl,K,null),n(K,uw),n(K,Ah),n(K,hw),n(K,Nh),n(K,fw),n(K,Jh),n(K,mw),n(K,Eh),$(t,am,y),f(vl,t,y),$(t,sm,y),$(t,R,y),f(yl,R,null),n(R,_w),n(R,Dh),n(R,bw),n(R,Rh),n(R,vw),f(nr,R,null),n(R,yw),f(or,R,null),n(R,xw),n(R,gt),f(xl,gt,null),n(gt,$w),n(gt,Gh),n(gt,ww),f(ar,gt,null),n(gt,kw),n(gt,Fh),n(R,Tw),n(R,Rn),f($l,Rn,null),n(Rn,jw),n(Rn,Sh),n(Rn,qw),n(Rn,Lh),n(R,Mw),n(R,Gn),f(wl,Gn,null),n(Gn,Hw),n(Gn,Zh),n(Gn,Uw),n(Gn,Wh),$(t,rm,y),f(kl,t,y),$(t,im,y),$(t,sf,y),cm=!0},p(t,[y]){const k={};y&2&&(k.$$scope={dirty:y,ctx:t}),Ro.$set(k);const yt={};y&2&&(yt.$$scope={dirty:y,ctx:t}),Go.$set(yt);const xt={};y&2&&(xt.$$scope={dirty:y,ctx:t}),So.$set(xt);const no={};y&2&&(no.$$scope={dirty:y,ctx:t}),Lo.$set(no);const oo={};y&2&&(oo.$$scope={dirty:y,ctx:t}),Zo.$set(oo);const S={};y&2&&(S.$$scope={dirty:y,ctx:t}),Wo.$set(S);const $t={};y&2&&($t.$$scope={dirty:y,ctx:t}),Vo.$set($t);const Tl={};y&2&&(Tl.$$scope={dirty:y,ctx:t}),Bo.$set(Tl);const wt={};y&2&&(wt.$$scope={dirty:y,ctx:t}),Yo.$set(wt);const kt={};y&2&&(kt.$$scope={dirty:y,ctx:t}),Xo.$set(kt);const jl={};y&2&&(jl.$$scope={dirty:y,ctx:t}),zo.$set(jl);const Tt={};y&2&&(Tt.$$scope={dirty:y,ctx:t}),Oo.$set(Tt);const $e={};y&2&&($e.$$scope={dirty:y,ctx:t}),Qo.$set($e);const ee={};y&2&&(ee.$$scope={dirty:y,ctx:t}),Ko.$set(ee);const we={};y&2&&(we.$$scope={dirty:y,ctx:t}),ea.$set(we);const jt={};y&2&&(jt.$$scope={dirty:y,ctx:t}),ta.$set(jt);const te={};y&2&&(te.$$scope={dirty:y,ctx:t}),aa.$set(te);const ql={};y&2&&(ql.$$scope={dirty:y,ctx:t}),sa.$set(ql);const Ml={};y&2&&(Ml.$$scope={dirty:y,ctx:t}),ia.$set(Ml);const ao={};y&2&&(ao.$$scope={dirty:y,ctx:t}),ca.$set(ao);const qt={};y&2&&(qt.$$scope={dirty:y,ctx:t}),la.$set(qt);const Hl={};y&2&&(Hl.$$scope={dirty:y,ctx:t}),pa.$set(Hl);const Mt={};y&2&&(Mt.$$scope={dirty:y,ctx:t}),ha.$set(Mt);const so={};y&2&&(so.$$scope={dirty:y,ctx:t}),fa.$set(so);const ro={};y&2&&(ro.$$scope={dirty:y,ctx:t}),ma.$set(ro);const io={};y&2&&(io.$$scope={dirty:y,ctx:t}),_a.$set(io);const co={};y&2&&(co.$$scope={dirty:y,ctx:t}),ba.$set(co);const Ht={};y&2&&(Ht.$$scope={dirty:y,ctx:t}),va.$set(Ht);const Ul={};y&2&&(Ul.$$scope={dirty:y,ctx:t}),ya.$set(Ul);const lo={};y&2&&(lo.$$scope={dirty:y,ctx:t}),xa.$set(lo);const Cl={};y&2&&(Cl.$$scope={dirty:y,ctx:t}),wa.$set(Cl);const po={};y&2&&(po.$$scope={dirty:y,ctx:t}),ja.$set(po);const Il={};y&2&&(Il.$$scope={dirty:y,ctx:t}),Ma.$set(Il);const go={};y&2&&(go.$$scope={dirty:y,ctx:t}),Ha.$set(go);const uo={};y&2&&(uo.$$scope={dirty:y,ctx:t}),Ua.$set(uo);const Ut={};y&2&&(Ut.$$scope={dirty:y,ctx:t}),Ca.$set(Ut);const ho={};y&2&&(ho.$$scope={dirty:y,ctx:t}),Aa.$set(ho);const fo={};y&2&&(fo.$$scope={dirty:y,ctx:t}),Ja.$set(fo);const mo={};y&2&&(mo.$$scope={dirty:y,ctx:t}),Ea.$set(mo);const _o={};y&2&&(_o.$$scope={dirty:y,ctx:t}),Da.$set(_o);const Ct={};y&2&&(Ct.$$scope={dirty:y,ctx:t}),Ra.$set(Ct);const Al={};y&2&&(Al.$$scope={dirty:y,ctx:t}),Ga.$set(Al);const It={};y&2&&(It.$$scope={dirty:y,ctx:t}),Fa.$set(It);const Nl={};y&2&&(Nl.$$scope={dirty:y,ctx:t}),Sa.$set(Nl);const Jl={};y&2&&(Jl.$$scope={dirty:y,ctx:t}),La.$set(Jl);const bo={};y&2&&(bo.$$scope={dirty:y,ctx:t}),Za.$set(bo);const El={};y&2&&(El.$$scope={dirty:y,ctx:t}),Wa.$set(El);const vo={};y&2&&(vo.$$scope={dirty:y,ctx:t}),Pa.$set(vo);const ke={};y&2&&(ke.$$scope={dirty:y,ctx:t}),Ba.$set(ke);const ne={};y&2&&(ne.$$scope={dirty:y,ctx:t}),Ya.$set(ne);const Dl={};y&2&&(Dl.$$scope={dirty:y,ctx:t}),Xa.$set(Dl);const yo={};y&2&&(yo.$$scope={dirty:y,ctx:t}),Oa.$set(yo);const At={};y&2&&(At.$$scope={dirty:y,ctx:t}),Qa.$set(At);const Rl={};y&2&&(Rl.$$scope={dirty:y,ctx:t}),Ka.$set(Rl);const xo={};y&2&&(xo.$$scope={dirty:y,ctx:t}),es.$set(xo);const Nt={};y&2&&(Nt.$$scope={dirty:y,ctx:t}),ns.$set(Nt);const oe={};y&2&&(oe.$$scope={dirty:y,ctx:t}),os.$set(oe);const Jt={};y&2&&(Jt.$$scope={dirty:y,ctx:t}),as.$set(Jt);const $o={};y&2&&($o.$$scope={dirty:y,ctx:t}),cs.$set($o);const Te={};y&2&&(Te.$$scope={dirty:y,ctx:t}),ls.$set(Te);const wo={};y&2&&(wo.$$scope={dirty:y,ctx:t}),ps.$set(wo);const Et={};y&2&&(Et.$$scope={dirty:y,ctx:t}),ds.$set(Et);const je={};y&2&&(je.$$scope={dirty:y,ctx:t}),us.$set(je);const ko={};y&2&&(ko.$$scope={dirty:y,ctx:t}),hs.$set(ko);const Gl={};y&2&&(Gl.$$scope={dirty:y,ctx:t}),fs.$set(Gl);const Dt={};y&2&&(Dt.$$scope={dirty:y,ctx:t}),ms.$set(Dt);const qe={};y&2&&(qe.$$scope={dirty:y,ctx:t}),_s.$set(qe);const To={};y&2&&(To.$$scope={dirty:y,ctx:t}),bs.$set(To);const Fl={};y&2&&(Fl.$$scope={dirty:y,ctx:t}),vs.$set(Fl);const jo={};y&2&&(jo.$$scope={dirty:y,ctx:t}),ys.$set(jo);const Me={};y&2&&(Me.$$scope={dirty:y,ctx:t}),xs.$set(Me);const He={};y&2&&(He.$$scope={dirty:y,ctx:t}),$s.$set(He);const Rt={};y&2&&(Rt.$$scope={dirty:y,ctx:t}),ws.$set(Rt);const Sl={};y&2&&(Sl.$$scope={dirty:y,ctx:t}),ks.$set(Sl);const qo={};y&2&&(qo.$$scope={dirty:y,ctx:t}),Ts.$set(qo);const Mo={};y&2&&(Mo.$$scope={dirty:y,ctx:t}),js.$set(Mo);const L={};y&2&&(L.$$scope={dirty:y,ctx:t}),qs.$set(L);const Ll={};y&2&&(Ll.$$scope={dirty:y,ctx:t}),Ms.$set(Ll);const Zl={};y&2&&(Zl.$$scope={dirty:y,ctx:t}),Hs.$set(Zl);const Wl={};y&2&&(Wl.$$scope={dirty:y,ctx:t}),Us.$set(Wl);const Ho={};y&2&&(Ho.$$scope={dirty:y,ctx:t}),Cs.$set(Ho);const Uo={};y&2&&(Uo.$$scope={dirty:y,ctx:t}),Is.$set(Uo);const Gt={};y&2&&(Gt.$$scope={dirty:y,ctx:t}),As.$set(Gt);const Ft={};y&2&&(Ft.$$scope={dirty:y,ctx:t}),Ns.$set(Ft);const Pl={};y&2&&(Pl.$$scope={dirty:y,ctx:t}),Js.$set(Pl);const St={};y&2&&(St.$$scope={dirty:y,ctx:t}),Es.$set(St);const Lt={};y&2&&(Lt.$$scope={dirty:y,ctx:t}),Ds.$set(Lt);const Zt={};y&2&&(Zt.$$scope={dirty:y,ctx:t}),Rs.$set(Zt);const Wt={};y&2&&(Wt.$$scope={dirty:y,ctx:t}),Gs.$set(Wt);const ae={};y&2&&(ae.$$scope={dirty:y,ctx:t}),Fs.$set(ae);const Pt={};y&2&&(Pt.$$scope={dirty:y,ctx:t}),Ss.$set(Pt);const Vt={};y&2&&(Vt.$$scope={dirty:y,ctx:t}),Ls.$set(Vt);const Co={};y&2&&(Co.$$scope={dirty:y,ctx:t}),Zs.$set(Co);const Io={};y&2&&(Io.$$scope={dirty:y,ctx:t}),Ws.$set(Io);const Ao={};y&2&&(Ao.$$scope={dirty:y,ctx:t}),Ps.$set(Ao);const No={};y&2&&(No.$$scope={dirty:y,ctx:t}),Vs.$set(No);const Bt={};y&2&&(Bt.$$scope={dirty:y,ctx:t}),Bs.$set(Bt);const Jo={};y&2&&(Jo.$$scope={dirty:y,ctx:t}),Xs.$set(Jo);const Eo={};y&2&&(Eo.$$scope={dirty:y,ctx:t}),zs.$set(Eo);const Ue={};y&2&&(Ue.$$scope={dirty:y,ctx:t}),Os.$set(Ue);const Ce={};y&2&&(Ce.$$scope={dirty:y,ctx:t}),Qs.$set(Ce);const Do={};y&2&&(Do.$$scope={dirty:y,ctx:t}),Ks.$set(Do);const Yt={};y&2&&(Yt.$$scope={dirty:y,ctx:t}),er.$set(Yt);const Xt={};y&2&&(Xt.$$scope={dirty:y,ctx:t}),tr.$set(Xt);const Ie={};y&2&&(Ie.$$scope={dirty:y,ctx:t}),nr.$set(Ie);const zt={};y&2&&(zt.$$scope={dirty:y,ctx:t}),or.$set(zt);const se={};y&2&&(se.$$scope={dirty:y,ctx:t}),ar.$set(se)},i(t){cm||(m(g.$$.fragment,t),m(gr.$$.fragment,t),m(ur.$$.fragment,t),m(hr.$$.fragment,t),m(fr.$$.fragment,t),m(mr.$$.fragment,t),m(Ro.$$.fragment,t),m(_r.$$.fragment,t),m(br.$$.fragment,t),m(vr.$$.fragment,t),m(Go.$$.fragment,t),m(yr.$$.fragment,t),m(xr.$$.fragment,t),m($r.$$.fragment,t),m(So.$$.fragment,t),m(Lo.$$.fragment,t),m(wr.$$.fragment,t),m(Zo.$$.fragment,t),m(Wo.$$.fragment,t),m(kr.$$.fragment,t),m(Tr.$$.fragment,t),m(Vo.$$.fragment,t),m(jr.$$.fragment,t),m(Bo.$$.fragment,t),m(Yo.$$.fragment,t),m(Xo.$$.fragment,t),m(qr.$$.fragment,t),m(zo.$$.fragment,t),m(Mr.$$.fragment,t),m(Oo.$$.fragment,t),m(Qo.$$.fragment,t),m(Ko.$$.fragment,t),m(Hr.$$.fragment,t),m(ea.$$.fragment,t),m(Ur.$$.fragment,t),m(ta.$$.fragment,t),m(Cr.$$.fragment,t),m(Ir.$$.fragment,t),m(Ar.$$.fragment,t),m(aa.$$.fragment,t),m(Nr.$$.fragment,t),m(sa.$$.fragment,t),m(Jr.$$.fragment,t),m(Er.$$.fragment,t),m(ia.$$.fragment,t),m(ca.$$.fragment,t),m(Dr.$$.fragment,t),m(la.$$.fragment,t),m(Rr.$$.fragment,t),m(pa.$$.fragment,t),m(Gr.$$.fragment,t),m(Fr.$$.fragment,t),m(Sr.$$.fragment,t),m(Lr.$$.fragment,t),m(Zr.$$.fragment,t),m(Wr.$$.fragment,t),m(Pr.$$.fragment,t),m(Vr.$$.fragment,t),m(Br.$$.fragment,t),m(ha.$$.fragment,t),m(Yr.$$.fragment,t),m(fa.$$.fragment,t),m(Xr.$$.fragment,t),m(ma.$$.fragment,t),m(zr.$$.fragment,t),m(_a.$$.fragment,t),m(Or.$$.fragment,t),m(ba.$$.fragment,t),m(Qr.$$.fragment,t),m(va.$$.fragment,t),m(Kr.$$.fragment,t),m(ya.$$.fragment,t),m(ei.$$.fragment,t),m(xa.$$.fragment,t),m(ti.$$.fragment,t),m(ni.$$.fragment,t),m(wa.$$.fragment,t),m(oi.$$.fragment,t),m(ai.$$.fragment,t),m(si.$$.fragment,t),m(ja.$$.fragment,t),m(ri.$$.fragment,t),m(ii.$$.fragment,t),m(Ma.$$.fragment,t),m(ci.$$.fragment,t),m(Ha.$$.fragment,t),m(Ua.$$.fragment,t),m(li.$$.fragment,t),m(Ca.$$.fragment,t),m(pi.$$.fragment,t),m(di.$$.fragment,t),m(gi.$$.fragment,t),m(Aa.$$.fragment,t),m(ui.$$.fragment,t),m(hi.$$.fragment,t),m(Ja.$$.fragment,t),m(fi.$$.fragment,t),m(mi.$$.fragment,t),m(Ea.$$.fragment,t),m(_i.$$.fragment,t),m(Da.$$.fragment,t),m(Ra.$$.fragment,t),m(bi.$$.fragment,t),m(Ga.$$.fragment,t),m(vi.$$.fragment,t),m(Fa.$$.fragment,t),m(yi.$$.fragment,t),m(Sa.$$.fragment,t),m(xi.$$.fragment,t),m(La.$$.fragment,t),m(Za.$$.fragment,t),m($i.$$.fragment,t),m(Wa.$$.fragment,t),m(wi.$$.fragment,t),m(Pa.$$.fragment,t),m(ki.$$.fragment,t),m(Ti.$$.fragment,t),m(Ba.$$.fragment,t),m(ji.$$.fragment,t),m(Ya.$$.fragment,t),m(qi.$$.fragment,t),m(Xa.$$.fragment,t),m(Mi.$$.fragment,t),m(Hi.$$.fragment,t),m(Oa.$$.fragment,t),m(Ui.$$.fragment,t),m(Qa.$$.fragment,t),m(Ci.$$.fragment,t),m(Ka.$$.fragment,t),m(Ii.$$.fragment,t),m(es.$$.fragment,t),m(Ai.$$.fragment,t),m(Ni.$$.fragment,t),m(Ji.$$.fragment,t),m(ns.$$.fragment,t),m(Ei.$$.fragment,t),m(os.$$.fragment,t),m(as.$$.fragment,t),m(Di.$$.fragment,t),m(Ri.$$.fragment,t),m(Gi.$$.fragment,t),m(Fi.$$.fragment,t),m(cs.$$.fragment,t),m(Si.$$.fragment,t),m(ls.$$.fragment,t),m(Li.$$.fragment,t),m(ps.$$.fragment,t),m(Zi.$$.fragment,t),m(ds.$$.fragment,t),m(Wi.$$.fragment,t),m(Pi.$$.fragment,t),m(Vi.$$.fragment,t),m(Bi.$$.fragment,t),m(Yi.$$.fragment,t),m(us.$$.fragment,t),m(hs.$$.fragment,t),m(Xi.$$.fragment,t),m(fs.$$.fragment,t),m(ms.$$.fragment,t),m(_s.$$.fragment,t),m(zi.$$.fragment,t),m(Oi.$$.fragment,t),m(bs.$$.fragment,t),m(vs.$$.fragment,t),m(Qi.$$.fragment,t),m(ys.$$.fragment,t),m(Ki.$$.fragment,t),m(xs.$$.fragment,t),m(ec.$$.fragment,t),m($s.$$.fragment,t),m(tc.$$.fragment,t),m(ws.$$.fragment,t),m(nc.$$.fragment,t),m(oc.$$.fragment,t),m(ac.$$.fragment,t),m(ks.$$.fragment,t),m(sc.$$.fragment,t),m(Ts.$$.fragment,t),m(rc.$$.fragment,t),m(js.$$.fragment,t),m(qs.$$.fragment,t),m(ic.$$.fragment,t),m(Ms.$$.fragment,t),m(cc.$$.fragment,t),m(lc.$$.fragment,t),m(Hs.$$.fragment,t),m(pc.$$.fragment,t),m(dc.$$.fragment,t),m(Us.$$.fragment,t),m(gc.$$.fragment,t),m(Cs.$$.fragment,t),m(Is.$$.fragment,t),m(As.$$.fragment,t),m(uc.$$.fragment,t),m(Ns.$$.fragment,t),m(hc.$$.fragment,t),m(Js.$$.fragment,t),m(fc.$$.fragment,t),m(Es.$$.fragment,t),m(mc.$$.fragment,t),m(_c.$$.fragment,t),m(bc.$$.fragment,t),m(Ds.$$.fragment,t),m(vc.$$.fragment,t),m(Rs.$$.fragment,t),m(yc.$$.fragment,t),m(Gs.$$.fragment,t),m(Fs.$$.fragment,t),m(Ss.$$.fragment,t),m(xc.$$.fragment,t),m(Ls.$$.fragment,t),m(Zs.$$.fragment,t),m(Ws.$$.fragment,t),m(Ps.$$.fragment,t),m($c.$$.fragment,t),m(Vs.$$.fragment,t),m(Bs.$$.fragment,t),m(wc.$$.fragment,t),m(kc.$$.fragment,t),m(Tc.$$.fragment,t),m(jc.$$.fragment,t),m(qc.$$.fragment,t),m(Mc.$$.fragment,t),m(Hc.$$.fragment,t),m(Uc.$$.fragment,t),m(Xs.$$.fragment,t),m(Cc.$$.fragment,t),m(Ic.$$.fragment,t),m(Ac.$$.fragment,t),m(Nc.$$.fragment,t),m(Jc.$$.fragment,t),m(Ec.$$.fragment,t),m(Dc.$$.fragment,t),m(Gc.$$.fragment,t),m(Fc.$$.fragment,t),m(Sc.$$.fragment,t),m(zs.$$.fragment,t),m(Lc.$$.fragment,t),m(Zc.$$.fragment,t),m(Os.$$.fragment,t),m(Wc.$$.fragment,t),m(Pc.$$.fragment,t),m(Qs.$$.fragment,t),m(Vc.$$.fragment,t),m(Bc.$$.fragment,t),m(Yc.$$.fragment,t),m(Xc.$$.fragment,t),m(Ks.$$.fragment,t),m(zc.$$.fragment,t),m(Oc.$$.fragment,t),m(Qc.$$.fragment,t),m(Kc.$$.fragment,t),m(el.$$.fragment,t),m(tl.$$.fragment,t),m(er.$$.fragment,t),m(nl.$$.fragment,t),m(ol.$$.fragment,t),m(al.$$.fragment,t),m(sl.$$.fragment,t),m(rl.$$.fragment,t),m(il.$$.fragment,t),m(cl.$$.fragment,t),m(ll.$$.fragment,t),m(pl.$$.fragment,t),m(dl.$$.fragment,t),m(gl.$$.fragment,t),m(hl.$$.fragment,t),m(fl.$$.fragment,t),m(tr.$$.fragment,t),m(ml.$$.fragment,t),m(_l.$$.fragment,t),m(bl.$$.fragment,t),m(vl.$$.fragment,t),m(yl.$$.fragment,t),m(nr.$$.fragment,t),m(or.$$.fragment,t),m(xl.$$.fragment,t),m(ar.$$.fragment,t),m($l.$$.fragment,t),m(wl.$$.fragment,t),m(kl.$$.fragment,t),cm=!0)},o(t){_(g.$$.fragment,t),_(gr.$$.fragment,t),_(ur.$$.fragment,t),_(hr.$$.fragment,t),_(fr.$$.fragment,t),_(mr.$$.fragment,t),_(Ro.$$.fragment,t),_(_r.$$.fragment,t),_(br.$$.fragment,t),_(vr.$$.fragment,t),_(Go.$$.fragment,t),_(yr.$$.fragment,t),_(xr.$$.fragment,t),_($r.$$.fragment,t),_(So.$$.fragment,t),_(Lo.$$.fragment,t),_(wr.$$.fragment,t),_(Zo.$$.fragment,t),_(Wo.$$.fragment,t),_(kr.$$.fragment,t),_(Tr.$$.fragment,t),_(Vo.$$.fragment,t),_(jr.$$.fragment,t),_(Bo.$$.fragment,t),_(Yo.$$.fragment,t),_(Xo.$$.fragment,t),_(qr.$$.fragment,t),_(zo.$$.fragment,t),_(Mr.$$.fragment,t),_(Oo.$$.fragment,t),_(Qo.$$.fragment,t),_(Ko.$$.fragment,t),_(Hr.$$.fragment,t),_(ea.$$.fragment,t),_(Ur.$$.fragment,t),_(ta.$$.fragment,t),_(Cr.$$.fragment,t),_(Ir.$$.fragment,t),_(Ar.$$.fragment,t),_(aa.$$.fragment,t),_(Nr.$$.fragment,t),_(sa.$$.fragment,t),_(Jr.$$.fragment,t),_(Er.$$.fragment,t),_(ia.$$.fragment,t),_(ca.$$.fragment,t),_(Dr.$$.fragment,t),_(la.$$.fragment,t),_(Rr.$$.fragment,t),_(pa.$$.fragment,t),_(Gr.$$.fragment,t),_(Fr.$$.fragment,t),_(Sr.$$.fragment,t),_(Lr.$$.fragment,t),_(Zr.$$.fragment,t),_(Wr.$$.fragment,t),_(Pr.$$.fragment,t),_(Vr.$$.fragment,t),_(Br.$$.fragment,t),_(ha.$$.fragment,t),_(Yr.$$.fragment,t),_(fa.$$.fragment,t),_(Xr.$$.fragment,t),_(ma.$$.fragment,t),_(zr.$$.fragment,t),_(_a.$$.fragment,t),_(Or.$$.fragment,t),_(ba.$$.fragment,t),_(Qr.$$.fragment,t),_(va.$$.fragment,t),_(Kr.$$.fragment,t),_(ya.$$.fragment,t),_(ei.$$.fragment,t),_(xa.$$.fragment,t),_(ti.$$.fragment,t),_(ni.$$.fragment,t),_(wa.$$.fragment,t),_(oi.$$.fragment,t),_(ai.$$.fragment,t),_(si.$$.fragment,t),_(ja.$$.fragment,t),_(ri.$$.fragment,t),_(ii.$$.fragment,t),_(Ma.$$.fragment,t),_(ci.$$.fragment,t),_(Ha.$$.fragment,t),_(Ua.$$.fragment,t),_(li.$$.fragment,t),_(Ca.$$.fragment,t),_(pi.$$.fragment,t),_(di.$$.fragment,t),_(gi.$$.fragment,t),_(Aa.$$.fragment,t),_(ui.$$.fragment,t),_(hi.$$.fragment,t),_(Ja.$$.fragment,t),_(fi.$$.fragment,t),_(mi.$$.fragment,t),_(Ea.$$.fragment,t),_(_i.$$.fragment,t),_(Da.$$.fragment,t),_(Ra.$$.fragment,t),_(bi.$$.fragment,t),_(Ga.$$.fragment,t),_(vi.$$.fragment,t),_(Fa.$$.fragment,t),_(yi.$$.fragment,t),_(Sa.$$.fragment,t),_(xi.$$.fragment,t),_(La.$$.fragment,t),_(Za.$$.fragment,t),_($i.$$.fragment,t),_(Wa.$$.fragment,t),_(wi.$$.fragment,t),_(Pa.$$.fragment,t),_(ki.$$.fragment,t),_(Ti.$$.fragment,t),_(Ba.$$.fragment,t),_(ji.$$.fragment,t),_(Ya.$$.fragment,t),_(qi.$$.fragment,t),_(Xa.$$.fragment,t),_(Mi.$$.fragment,t),_(Hi.$$.fragment,t),_(Oa.$$.fragment,t),_(Ui.$$.fragment,t),_(Qa.$$.fragment,t),_(Ci.$$.fragment,t),_(Ka.$$.fragment,t),_(Ii.$$.fragment,t),_(es.$$.fragment,t),_(Ai.$$.fragment,t),_(Ni.$$.fragment,t),_(Ji.$$.fragment,t),_(ns.$$.fragment,t),_(Ei.$$.fragment,t),_(os.$$.fragment,t),_(as.$$.fragment,t),_(Di.$$.fragment,t),_(Ri.$$.fragment,t),_(Gi.$$.fragment,t),_(Fi.$$.fragment,t),_(cs.$$.fragment,t),_(Si.$$.fragment,t),_(ls.$$.fragment,t),_(Li.$$.fragment,t),_(ps.$$.fragment,t),_(Zi.$$.fragment,t),_(ds.$$.fragment,t),_(Wi.$$.fragment,t),_(Pi.$$.fragment,t),_(Vi.$$.fragment,t),_(Bi.$$.fragment,t),_(Yi.$$.fragment,t),_(us.$$.fragment,t),_(hs.$$.fragment,t),_(Xi.$$.fragment,t),_(fs.$$.fragment,t),_(ms.$$.fragment,t),_(_s.$$.fragment,t),_(zi.$$.fragment,t),_(Oi.$$.fragment,t),_(bs.$$.fragment,t),_(vs.$$.fragment,t),_(Qi.$$.fragment,t),_(ys.$$.fragment,t),_(Ki.$$.fragment,t),_(xs.$$.fragment,t),_(ec.$$.fragment,t),_($s.$$.fragment,t),_(tc.$$.fragment,t),_(ws.$$.fragment,t),_(nc.$$.fragment,t),_(oc.$$.fragment,t),_(ac.$$.fragment,t),_(ks.$$.fragment,t),_(sc.$$.fragment,t),_(Ts.$$.fragment,t),_(rc.$$.fragment,t),_(js.$$.fragment,t),_(qs.$$.fragment,t),_(ic.$$.fragment,t),_(Ms.$$.fragment,t),_(cc.$$.fragment,t),_(lc.$$.fragment,t),_(Hs.$$.fragment,t),_(pc.$$.fragment,t),_(dc.$$.fragment,t),_(Us.$$.fragment,t),_(gc.$$.fragment,t),_(Cs.$$.fragment,t),_(Is.$$.fragment,t),_(As.$$.fragment,t),_(uc.$$.fragment,t),_(Ns.$$.fragment,t),_(hc.$$.fragment,t),_(Js.$$.fragment,t),_(fc.$$.fragment,t),_(Es.$$.fragment,t),_(mc.$$.fragment,t),_(_c.$$.fragment,t),_(bc.$$.fragment,t),_(Ds.$$.fragment,t),_(vc.$$.fragment,t),_(Rs.$$.fragment,t),_(yc.$$.fragment,t),_(Gs.$$.fragment,t),_(Fs.$$.fragment,t),_(Ss.$$.fragment,t),_(xc.$$.fragment,t),_(Ls.$$.fragment,t),_(Zs.$$.fragment,t),_(Ws.$$.fragment,t),_(Ps.$$.fragment,t),_($c.$$.fragment,t),_(Vs.$$.fragment,t),_(Bs.$$.fragment,t),_(wc.$$.fragment,t),_(kc.$$.fragment,t),_(Tc.$$.fragment,t),_(jc.$$.fragment,t),_(qc.$$.fragment,t),_(Mc.$$.fragment,t),_(Hc.$$.fragment,t),_(Uc.$$.fragment,t),_(Xs.$$.fragment,t),_(Cc.$$.fragment,t),_(Ic.$$.fragment,t),_(Ac.$$.fragment,t),_(Nc.$$.fragment,t),_(Jc.$$.fragment,t),_(Ec.$$.fragment,t),_(Dc.$$.fragment,t),_(Gc.$$.fragment,t),_(Fc.$$.fragment,t),_(Sc.$$.fragment,t),_(zs.$$.fragment,t),_(Lc.$$.fragment,t),_(Zc.$$.fragment,t),_(Os.$$.fragment,t),_(Wc.$$.fragment,t),_(Pc.$$.fragment,t),_(Qs.$$.fragment,t),_(Vc.$$.fragment,t),_(Bc.$$.fragment,t),_(Yc.$$.fragment,t),_(Xc.$$.fragment,t),_(Ks.$$.fragment,t),_(zc.$$.fragment,t),_(Oc.$$.fragment,t),_(Qc.$$.fragment,t),_(Kc.$$.fragment,t),_(el.$$.fragment,t),_(tl.$$.fragment,t),_(er.$$.fragment,t),_(nl.$$.fragment,t),_(ol.$$.fragment,t),_(al.$$.fragment,t),_(sl.$$.fragment,t),_(rl.$$.fragment,t),_(il.$$.fragment,t),_(cl.$$.fragment,t),_(ll.$$.fragment,t),_(pl.$$.fragment,t),_(dl.$$.fragment,t),_(gl.$$.fragment,t),_(hl.$$.fragment,t),_(fl.$$.fragment,t),_(tr.$$.fragment,t),_(ml.$$.fragment,t),_(_l.$$.fragment,t),_(bl.$$.fragment,t),_(vl.$$.fragment,t),_(yl.$$.fragment,t),_(nr.$$.fragment,t),_(or.$$.fragment,t),_(xl.$$.fragment,t),_(ar.$$.fragment,t),_($l.$$.fragment,t),_(wl.$$.fragment,t),_(kl.$$.fragment,t),cm=!1},d(t){t&&(p(v),p(i),p(a),p(e),p(x),p(rf),p(pr),p(cf),p(dr),p(lf),p(pf),p(df),p(w),p(gf),p(uf),p(hf),p(Bn),p(ff),p(mf),p(ut),p(_f),p(bf),p(ht),p(vf),p(yf),p(Yn),p(xf),p($f),p(Xn),p(wf),p(kf),p(ft),p(Tf),p(jf),p(Rc),p(qf),p(Mf),p(z),p(Hf),p(Uf),p(mt),p(Cf),p(If),p(_t),p(Af),p(Nf),p(zn),p(Jf),p(Ef),p(O),p(Df),p(Rf),p(Q),p(Gf),p(Ff),p(ye),p(Sf),p(Lf),p(bt),p(Zf),p(Wf),p(vt),p(Pf),p(Vf),p(On),p(Bf),p(Yf),p(Qn),p(Xf),p(zf),p(Kn),p(Of),p(Qf),p(eo),p(Kf),p(em),p(ul),p(tm),p(xe),p(nm),p(to),p(om),p(K),p(am),p(sm),p(R),p(rm),p(im),p(sf)),p(o),b(g,t),b(gr,t),b(ur,t),b(hr),b(fr),b(mr),b(Ro),b(_r),b(br),b(vr),b(Go),b(yr),b(xr),b($r),b(So),b(Lo),b(wr),b(Zo),b(Wo),b(kr),b(Tr),b(Vo),b(jr),b(Bo),b(Yo),b(Xo),b(qr),b(zo),b(Mr),b(Oo),b(Qo),b(Ko),b(Hr),b(ea),b(Ur),b(ta),b(Cr),b(Ir),b(Ar),b(aa),b(Nr),b(sa),b(Jr),b(Er),b(ia),b(ca),b(Dr),b(la),b(Rr),b(pa),b(Gr),b(Fr),b(Sr),b(Lr),b(Zr),b(Wr),b(Pr),b(Vr),b(Br),b(ha),b(Yr),b(fa),b(Xr),b(ma),b(zr),b(_a),b(Or),b(ba),b(Qr),b(va),b(Kr),b(ya),b(ei),b(xa),b(ti),b(ni),b(wa),b(oi),b(ai),b(si),b(ja),b(ri),b(ii),b(Ma),b(ci),b(Ha),b(Ua),b(li),b(Ca),b(pi),b(di),b(gi),b(Aa),b(ui),b(hi),b(Ja),b(fi),b(mi),b(Ea),b(_i),b(Da),b(Ra),b(bi),b(Ga),b(vi),b(Fa),b(yi),b(Sa),b(xi),b(La),b(Za),b($i),b(Wa),b(wi),b(Pa),b(ki),b(Ti),b(Ba),b(ji),b(Ya),b(qi),b(Xa),b(Mi),b(Hi),b(Oa),b(Ui),b(Qa),b(Ci),b(Ka),b(Ii),b(es),b(Ai),b(Ni),b(Ji),b(ns),b(Ei),b(os),b(as),b(Di),b(Ri),b(Gi),b(Fi),b(cs),b(Si),b(ls),b(Li),b(ps),b(Zi),b(ds),b(Wi),b(Pi),b(Vi),b(Bi),b(Yi),b(us),b(hs),b(Xi),b(fs),b(ms),b(_s),b(zi),b(Oi),b(bs),b(vs),b(Qi),b(ys),b(Ki),b(xs),b(ec),b($s),b(tc),b(ws),b(nc),b(oc),b(ac),b(ks),b(sc),b(Ts),b(rc),b(js),b(qs),b(ic),b(Ms),b(cc),b(lc),b(Hs),b(pc),b(dc),b(Us),b(gc),b(Cs),b(Is),b(As),b(uc),b(Ns),b(hc),b(Js),b(fc),b(Es),b(mc),b(_c),b(bc),b(Ds),b(vc),b(Rs),b(yc),b(Gs),b(Fs),b(Ss),b(xc),b(Ls),b(Zs),b(Ws),b(Ps),b($c),b(Vs),b(Bs),b(wc),b(kc,t),b(Tc,t),b(jc),b(qc,t),b(Mc),b(Hc,t),b(Uc),b(Xs),b(Cc,t),b(Ic),b(Ac,t),b(Nc),b(Jc,t),b(Ec),b(Dc,t),b(Gc),b(Fc,t),b(Sc),b(zs),b(Lc,t),b(Zc),b(Os),b(Wc,t),b(Pc),b(Qs),b(Vc,t),b(Bc),b(Yc,t),b(Xc),b(Ks),b(zc,t),b(Oc),b(Qc,t),b(Kc),b(el,t),b(tl),b(er),b(nl,t),b(ol),b(al,t),b(sl),b(rl,t),b(il),b(cl,t),b(ll),b(pl,t),b(dl),b(gl,t),b(hl),b(fl),b(tr),b(ml),b(_l),b(bl),b(vl,t),b(yl),b(nr),b(or),b(xl),b(ar),b($l),b(wl),b(kl,t)}}}const ZH='{"title":"HfApi Client","local":"hfapi-client","sections":[{"title":"HfApi","local":"huggingface_hub.HfApi","sections":[],"depth":2},{"title":"API Dataclasses","local":"api-dataclasses","sections":[{"title":"AccessRequest","local":"huggingface_hub.hf_api.AccessRequest","sections":[],"depth":3},{"title":"CommitInfo","local":"huggingface_hub.CommitInfo","sections":[],"depth":3},{"title":"DatasetInfo","local":"huggingface_hub.DatasetInfo","sections":[],"depth":3},{"title":"GitRefInfo","local":"huggingface_hub.GitRefInfo","sections":[],"depth":3},{"title":"GitCommitInfo","local":"huggingface_hub.GitCommitInfo","sections":[],"depth":3},{"title":"GitRefs","local":"huggingface_hub.GitRefs","sections":[],"depth":3},{"title":"InferenceProviderMapping","local":"huggingface_hub.hf_api.InferenceProviderMapping","sections":[],"depth":3},{"title":"LFSFileInfo","local":"huggingface_hub.hf_api.LFSFileInfo","sections":[],"depth":3},{"title":"ModelInfo","local":"huggingface_hub.ModelInfo","sections":[],"depth":3},{"title":"RepoSibling","local":"huggingface_hub.hf_api.RepoSibling","sections":[],"depth":3},{"title":"RepoFile","local":"huggingface_hub.hf_api.RepoFile","sections":[],"depth":3},{"title":"RepoUrl","local":"huggingface_hub.RepoUrl","sections":[],"depth":3},{"title":"SafetensorsRepoMetadata","local":"huggingface_hub.utils.SafetensorsRepoMetadata","sections":[],"depth":3},{"title":"SafetensorsFileMetadata","local":"huggingface_hub.utils.SafetensorsFileMetadata","sections":[],"depth":3},{"title":"SpaceInfo","local":"huggingface_hub.SpaceInfo","sections":[],"depth":3},{"title":"TensorInfo","local":"huggingface_hub.utils.TensorInfo","sections":[],"depth":3},{"title":"User","local":"huggingface_hub.User","sections":[],"depth":3},{"title":"UserLikes","local":"huggingface_hub.UserLikes","sections":[],"depth":3},{"title":"WebhookInfo","local":"huggingface_hub.WebhookInfo","sections":[],"depth":3},{"title":"WebhookWatchedItem","local":"huggingface_hub.WebhookWatchedItem","sections":[],"depth":3}],"depth":2},{"title":"CommitOperation","local":"huggingface_hub.CommitOperationAdd","sections":[],"depth":2},{"title":"CommitScheduler","local":"huggingface_hub.CommitScheduler","sections":[],"depth":2}],"depth":1}';function WH(T){return Eq(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class QH extends Dq{constructor(o){super(),Rq(this,o,WH,LH,Jq,{})}}export{QH as component};
