import{s as Oi,n as eo,o as to}from"../chunks/scheduler.36a0863c.js";import{S as lo,i as io,g as a,s as o,r as d,A as oo,h as s,f as l,c as n,j as Ki,u as p,x as r,k as Di,y as no,a as i,v as m,d as c,t as u,w as M}from"../chunks/index.9c13489a.js";import{C as y}from"../chunks/CodeBlock.05d8ec32.js";import{H as T}from"../chunks/Heading.7a254a62.js";function ao(El){let b,it,tt,ot,v,nt,f,at,J,Al=`Un paio di modifiche sono state introdotte nel passaggio dalla versione 3 alla versione 4. Di seguito è riportato un riepilogo delle
modifiche previste:`,st,w,rt,z,Yl="I tokenizer python e rust hanno all’incirca le stesse API, ma i tokenizer rust hanno un set di funzionalità più completo.",dt,_,Sl="Ciò introduce due modifiche sostanziali:",pt,U,Nl="<li>La gestione dei token in overflow tra i tokenizer Python e Rust è diversa.</li> <li>I tokenizers di rust non accettano numeri interi nei metodi di codifica.</li>",mt,j,ct,$,Pl='<li>Le pipeline ora contengono funzionalità aggiuntive pronte all’uso. Vedi la <a href="main_classes/pipelines#transformers.TokenClassificationPipeline">pipeline di classificazione dei token con il flag <code>grouped_entities</code></a>.</li> <li>Gli auto-tokenizer ora restituiscono tokenizer rust. Per ottenere invece i tokenizer python, l’utente deve usare il flag <code>use_fast</code> impostandolo <code>False</code>:</li>',ut,g,Ql="Nella versione <code>v3.x</code>:",Mt,h,Tt,C,ql="per ottenere lo stesso nella versione <code>v4.x</code>:",yt,I,bt,Z,vt,k,Kl="Il requisito sulla dipendenza SentencePiece è stato rimosso da <code>setup.py</code>. È stato fatto per avere un canale su anaconda cloud senza basarsi su <code>conda-forge</code>. Ciò significa che i tokenizer che dipendono dalla libreria SentencePiece non saranno disponibili con un’installazione standard di <code>transformers</code>.",ft,x,Dl="Ciò include le versioni <strong>lente</strong> di:",Jt,B,Ol="<li><code>XLNetTokenizer</code></li> <li><code>AlbertTokenizer</code></li> <li><code>CamembertTokenizer</code></li> <li><code>MBartTokenizer</code></li> <li><code>PegasusTokenizer</code></li> <li><code>T5Tokenizer</code></li> <li><code>ReformerTokenizer</code></li> <li><code>XLMRobertaTokenizer</code></li>",wt,W,zt,H,ei="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, devi installare anche <code>sentencepiece</code>:",_t,L,ti="Nella versione <code>v3.x</code>:",Ut,G,jt,X,li="per ottenere lo stesso nella versione <code>v4.x</code>:",$t,V,gt,F,ii="o",ht,R,Ct,E,It,A,oi="Con l’aggiunta di nuovi modelli, il numero di file nella cartella <code>src/transformers</code> continua a crescere e diventa più difficile navigare e capire. Abbiamo fatto la scelta di inserire ogni modello e i file che lo accompagnano nelle proprie sottocartelle.",Zt,Y,ni="Si tratta di una modifica sostanziale in quanto l’importazione di layer intermedi utilizzando direttamente il modulo di un modello deve essere eseguita tramite un percorso diverso.",kt,S,xt,N,ai="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, devi aggiornare il percorso utilizzato per accedere ai layer.",Bt,P,si="Nella versione <code>v3.x</code>:",Wt,Q,Ht,q,ri="per ottenere lo stesso nella versione <code>v4.x</code>:",Lt,K,Gt,D,Xt,O,di='L’<a href="main_classes/output">argomento <code>return_dict</code></a> abilita la restituzione di oggetti python dict-like contenenti gli output del modello, invece delle tuple standard. Questo oggetto è self-documented poiché le chiavi possono essere utilizzate per recuperare valori, comportandosi anche come una tupla e gli utenti possono recuperare oggetti per indexing o slicing.',Vt,ee,pi="Questa è una modifica sostanziale poiché la tupla non può essere decompressa: <code>value0, value1 = outputs</code> non funzionerà.",Ft,te,Rt,le,mi="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, specifica l’argomento <code>return_dict</code> come <code>False</code>, sia nella configurazione del modello che nel passaggio successivo.",Et,ie,ci="Nella versione <code>v3.x</code>:",At,oe,Yt,ne,ui="per ottenere lo stesso nella versione <code>v4.x</code>:",St,ae,Nt,se,Mi="o",Pt,re,Qt,de,qt,pe,Ti='Gli attributi sono stati rimossi se deprecati da almeno un mese. L’elenco completo degli attributi obsoleti è disponibile in <a href="https://github.com/huggingface/transformers/pull/8604" rel="nofollow">#8604</a>.',Kt,me,yi="Ecco un elenco di questi attributi/metodi/argomenti e quali dovrebbero essere le loro sostituzioni:",Dt,ce,bi="In diversi modelli, le etichette diventano coerenti con gli altri modelli:",Ot,ue,vi="<li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>AlbertForMaskedLM</code> e <code>AlbertForPreTraining</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>BertForMaskedLM</code> e <code>BertForPreTraining</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>DistilBertForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>ElectraForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>LongformerForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>MobileBertForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>RobertaForMaskedLM</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>BartForConditionalGeneration</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>GPT2DoubleHeadsModel</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>OpenAIGPTDoubleHeadsModel</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>T5ForConditionalGeneration</code>.</li>",el,Me,fi="In diversi modelli, il meccanismo di memorizzazione nella cache diventa coerente con gli altri:",tl,Te,Ji="<li><code>decoder_cached_states</code> diventa <code>past_key_values</code> in tutti i modelli BART-like, FSMT e T5.</li> <li><code>decoder_past_key_values</code> diventa <code>past_key_values</code> in tutti i modelli BART-like, FSMT e T5.</li> <li><code>past</code> diventa <code>past_key_values</code> in tutti i modelli CTRL.</li> <li><code>past</code> diventa <code>past_key_values</code> in tutti i modelli GPT-2.</li>",ll,ye,wi="Per quanto riguarda le classi tokenizer:",il,be,zi="<li>L’attributo tokenizer <code>max_len</code> diventa <code>model_max_length</code>.</li> <li>L’attributo tokenizer <code>return_lengths</code> diventa <code>return_length</code>.</li> <li>L’argomento di codifica del tokenizer <code>is_pretokenized</code> diventa <code>is_split_into_words</code>.</li>",ol,ve,_i="Per quanto riguarda la classe <code>Trainer</code>:",nl,fe,Ui="<li>L’argomento <code>tb_writer</code> di <code>Trainer</code> è stato rimosso in favore della funzione richiamabile <code>TensorBoardCallback(tb_writer=...)</code>.</li> <li>L’argomento <code>prediction_loss_only</code> di <code>Trainer</code> è stato rimosso in favore dell’argomento di classe <code>args.prediction_loss_only</code>.</li> <li>L’attributo <code>data_collator</code> di <code>Trainer</code> sarà richiamabile.</li> <li>Il metodo <code>_log</code> di <code>Trainer</code> è deprecato a favore di <code>log</code>.</li> <li>Il metodo <code>_training_step</code> di <code>Trainer</code> è deprecato a favore di <code>training_step</code>.</li> <li>Il metodo <code>_prediction_loop</code> di <code>Trainer</code> è deprecato a favore di <code>prediction_loop</code>.</li> <li>Il metodo <code>is_local_master</code> di <code>Trainer</code> è deprecato a favore di <code>is_local_process_zero</code>.</li> <li>Il metodo <code>is_world_master</code> di <code>Trainer</code> è deprecato a favore di <code>is_world_process_zero</code>.</li>",al,Je,ji="Per quanto riguarda la classe <code>TFTrainer</code>:",sl,we,$i="<li>L’argomento <code>prediction_loss_only</code> di <code>TFTrainer</code> è stato rimosso a favore dell’argomento di classe <code>args.prediction_loss_only</code>.</li> <li>Il metodo <code>_log</code> di <code>Trainer</code> è deprecato a favore di <code>log</code>.</li> <li>Il metodo <code>_prediction_loop</code> di <code>TFTrainer</code> è deprecato a favore di <code>prediction_loop</code>.</li> <li>Il metodo <code>_setup_wandb</code> di <code>TFTrainer</code> è deprecato a favore di <code>setup_wandb</code>.</li> <li>Il metodo <code>_run_model</code> di <code>TFTrainer</code> è deprecato a favore di <code>run_model</code>.</li>",rl,ze,gi="Per quanto riguarda la classe <code>TrainingArguments</code>:",dl,_e,hi="<li>L’argomento <code>evaluate_during_training</code> di <code>TrainingArguments</code> è deprecato a favore di <code>evaluation_strategy</code>.</li>",pl,Ue,Ci="Per quanto riguarda il modello Transfo-XL:",ml,je,Ii="<li>L’attributo di configurazione <code>tie_weight</code> di Transfo-XL diventa <code>tie_words_embeddings</code>.</li> <li>Il metodo di modellazione <code>reset_length</code> di Transfo-XL diventa <code>reset_memory_length</code>.</li>",cl,$e,Zi="Per quanto riguarda le pipeline:",ul,ge,ki="<li>L’argomento <code>topk</code> di <code>FillMaskPipeline</code> diventa <code>top_k</code>.</li>",Ml,he,Tl,Ce,xi="Ecco un breve riepilogo di ciò a cui prestare attenzione durante il passaggio da <code>pytorch-transformers</code> a 🤗 Transformers.",yl,Ie,bl,Ze,Bi="Per usare Torchscript (vedi #1010, #1204 e #1195) l’ordine specifico delle <strong>parole chiave di input</strong> di alcuni modelli (<code>attention_mask</code>, <code>token_type_ids</code>…) è stato modificato.",vl,ke,Wi="Se inizializzavi i modelli usando parole chiave per gli argomenti, ad esempio <code>model(inputs_ids, attention_mask=attention_mask, token_type_ids=token_type_ids)</code>, questo non dovrebbe causare alcun cambiamento.",fl,xe,Hi="Se inizializzavi i modelli con input posizionali per gli argomenti, ad esempio <code>model(inputs_ids, attention_mask, token_type_ids)</code>, potrebbe essere necessario ricontrollare l’ordine esatto degli argomenti di input.",Jl,Be,wl,We,Li="Ecco un breve riepilogo di ciò a cui prestare attenzione durante la migrazione da <code>pytorch-pretrained-bert</code> a 🤗 Transformers",zl,He,_l,Le,Gi="La principale modifica di rilievo durante la migrazione da <code>pytorch-pretrained-bert</code> a 🤗 Transformers è che il metodo dei modelli di previsione dà sempre una <code>tupla</code> con vari elementi a seconda del modello e dei parametri di configurazione.",Ul,Ge,Xi='Il contenuto esatto delle tuple per ciascun modello è mostrato in dettaglio nelle docstring dei modelli e nella <a href="https://huggingface.co/transformers/" rel="nofollow">documentazione</a>.',jl,Xe,Vi="In quasi tutti i casi, andrà bene prendendo il primo elemento dell’output come quello che avresti precedentemente utilizzato in <code>pytorch-pretrained-bert</code>.",$l,Ve,Fi=`Ecco un esempio di conversione da <code>pytorch-pretrained-bert</code>
a 🤗 Transformers per un modello di classificazione <code>BertForSequenceClassification</code>:`,gl,Fe,hl,Re,Cl,Ee,Ri="Modifica sostanziale nel metodo <code>from_pretrained()</code>:",Il,Ae,Ei="<li><p>I modelli sono ora impostati in modalità di valutazione in maniera predefinita quando usi il metodo <code>from_pretrained()</code>. Per addestrarli non dimenticare di riportarli in modalità di addestramento (<code>model.train()</code>) per attivare i moduli di dropout.</p></li> <li><p>Gli argomenti aggiuntivi <code>*inputs</code> e <code>**kwargs</code> forniti al metodo <code>from_pretrained()</code> venivano passati direttamente al metodo <code>__init__()</code> della classe sottostante del modello. Ora sono usati per aggiornare prima l’attributo di configurazione del modello, che può non funzionare con le classi del modello derivate costruite basandosi sui precedenti esempi di <code>BertForSequenceClassification</code>. Più precisamente, gli argomenti posizionali <code>*inputs</code> forniti a <code>from_pretrained()</code> vengono inoltrati direttamente al metodo <code>__init__()</code>  del modello mentre gli argomenti keyword <code>**kwargs</code> (i) che corrispondono agli attributi della classe di configurazione, vengono utilizzati per aggiornare tali attributi (ii) che non corrispondono ad alcun attributo della classe di configurazione, vengono inoltrati al metodo <code>__init__()</code>.</p></li>",Zl,Ye,Ai="Inoltre, sebbene non si tratti di una modifica sostanziale, i metodi di serializzazione sono stati standardizzati e probabilmente dovresti passare al nuovo metodo <code>save_pretrained(save_directory)</code> se prima usavi qualsiasi altro metodo di serializzazione.",kl,Se,Yi="Ecco un esempio:",xl,Ne,Bl,Pe,Wl,Qe,Si="I due ottimizzatori precedenti inclusi, <code>BertAdam</code> e <code>OpenAIAdam</code>, sono stati sostituiti da un singolo <code>AdamW</code> che presenta alcune differenze:",Hl,qe,Ni="<li>implementa solo la correzione del weights decay,</li> <li>lo scheduling ora è esterno (vedi sotto),</li> <li>anche il gradient clipping ora è esterno (vedi sotto).</li>",Ll,Ke,Pi="Il nuovo ottimizzatore <code>AdamW</code> corrisponde alle API di <code>Adam</code> di PyTorch e ti consente di utilizzare metodi PyTorch o apex per lo scheduling e il clipping.",Gl,De,Qi='Lo scheduling è ora standard <a href="https://pytorch.org/docs/stable/optim.html#how-to-adjust-learning-rate" rel="nofollow">PyTorch learning rate schedulers</a> e non fanno più parte dell’ottimizzatore.',Xl,Oe,qi="Ecco un esempio di linear warmup e decay con <code>BertAdam</code> e con <code>AdamW</code>:",Vl,et,Fl,lt,Rl;return v=new T({props:{title:"Migrazione da pacchetti precedenti",local:"migrazione-da-pacchetti-precedenti",headingTag:"h1"}}),f=new T({props:{title:"Migrazione da transformers v3.x a v4.x",local:"migrazione-da-transformers-v3x-a-v4x",headingTag:"h2"}}),w=new T({props:{title:"1. AutoTokenizer e pipeline ora utilizzano tokenizer veloci (rust) per impostazione predefinita.",local:"1-autotokenizer-e-pipeline-ora-utilizzano-tokenizer-veloci-rust-per-impostazione-predefinita",headingTag:"h4"}}),j=new T({props:{title:"Come ottenere lo stesso comportamento di v3.x in v4.x",local:"come-ottenere-lo-stesso-comportamento-di-v3x-in-v4x",headingTag:"h5"}}),h=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMjAlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTIw",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer 

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>) `,wrap:!1}}),I=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMjAlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIlMkMlMjB1c2VfZmFzdCUzREZhbHNlKSUyMA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer 

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, use_fast=<span class="hljs-literal">False</span>) `,wrap:!1}}),Z=new T({props:{title:"2. SentencePiece è stato rimosso dalle dipendenze richieste",local:"2-sentencepiece-è-stato-rimosso-dalle-dipendenze-richieste",headingTag:"h4"}}),W=new T({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),G=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMA==",highlighted:"pip install transformers ",wrap:!1}}),V=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QnNlbnRlbmNlcGllY2UlNUQlMjA=",highlighted:"pip install transformers[sentencepiece] ",wrap:!1}}),R=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMHN0ZW50ZW5jZXBpZWNlJTIw",highlighted:"pip install transformers stentencepiece ",wrap:!1}}),E=new T({props:{title:"3. L’architettura delle repo è stato aggiornata in modo che ogni modello abbia la propria cartella",local:"3-larchitettura-delle-repo-è-stato-aggiornata-in-modo-che-ogni-modello-abbia-la-propria-cartella",headingTag:"h4"}}),S=new T({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),Q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ19iZXJ0JTIwaW1wb3J0JTIwQmVydExheWVyJTIw",highlighted:"from transformers.modeling_bert import BertLayer ",wrap:!1}}),K=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuYmVydC5tb2RlbGluZ19iZXJ0JTIwaW1wb3J0JTIwQmVydExheWVyJTIw",highlighted:"from transformers.models.bert.modeling_bert import BertLayer ",wrap:!1}}),D=new T({props:{title:"4. Impostare l’argomento return_dict su True per impostazione predefinita",local:"4-impostare-largomento-returndict-su-true-per-impostazione-predefinita",headingTag:"h4"}}),te=new T({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),oe=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMjAlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTIw",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>) 
outputs = model(**inputs) `,wrap:!1}}),ae=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMjAlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSUyMA==",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>) 
outputs = model(**inputs, return_dict=False) `,wrap:!1}}),re=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTIwJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUyMA==",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, return_dict=False) 
outputs = model(**inputs) `,wrap:!1}}),de=new T({props:{title:"5. Rimozione di alcuni attributi deprecati",local:"5-rimozione-di-alcuni-attributi-deprecati",headingTag:"h4"}}),he=new T({props:{title:"Passaggio da pytorch-transformers a 🤗 Transformers",local:"passaggio-da-pytorch-transformers-a--transformers",headingTag:"h2"}}),Ie=new T({props:{title:"L’ordine posizionale di alcune parole chiave di input dei modelli ( attention_mask , token_type_ids …) è cambiato",local:"lordine-posizionale-di-alcune-parole-chiave-di-input-dei-modelli--attentionmask--tokentypeids--è-cambiato",headingTag:"h3"}}),Be=new T({props:{title:"Migrazione da pytorch-pretrained-bert",local:"migrazione-da-pytorch-pretrained-bert",headingTag:"h2"}}),He=new T({props:{title:"I modelli restituiscono sempre tuple",local:"i-modelli-restituiscono-sempre-tuple",headingTag:"h3"}}),Fe=new y({props:{code:"JTIzJTIwQ2FyaWNoaWFtbyUyMGlsJTIwbm9zdHJvJTIwbW9kZWxsbyUyMCUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUyMCUwQSUwQSUyMyUyMFNlJTIwdXNhdmklMjBxdWVzdGElMjByaWdhJTIwaW4lMjBweXRvcmNoLXByZXRyYWluZWQtYmVydCUyMCUzQSUyMCUwQWxvc3MlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTIwJTBBJTBBJTIzJTIwT3JhJTIwdXNhJTIwcXVlc3RhJTIwcmlnYSUyMGluJTIwJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTIwcGVyJTIwZXN0cmFycmUlMjBsYSUyMHBlcmRpdGElMjBkYWxsYSUyMHR1cGxhJTIwZGklMjBvdXRwdXQlM0ElMjAlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUyMCUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzJTVCMCU1RCUyMCUwQSUwQSUyMyUyMEluJTIwJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTIwcHVvaSUyMGFuY2hlJTIwYXZlcmUlMjBhY2Nlc3NvJTIwYWklMjBsb2dpdCUzQSUyMCUwQWxvc3MlMkMlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzJTVCJTNBMiU1RCUyMCUwQSUwQSUyMyUyMEVkJTIwYW5jaGUlMjBhZ2xpJTIwYXR0ZW50aW9uJTIwd2VpZ2h0JTIwc2UlMjBjb25maWd1cmklMjBpbCUyMG1vZGVsbG8lMjBwZXIlMjByZXN0aXR1aXJsaSUyMChlJTIwYW5jaGUlMjBhbHRyaSUyMG91dHB1dCUyQyUyMHZlZGklMjBsZSUyMGRvY3N0cmluZyUyMGUlMjBsYSUyMGRvY3VtZW50YXppb25lKSUyMCUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMiUyMGJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUyMCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTIwJTBBbG9zcyUyQyUyMGxvZ2l0cyUyQyUyMGF0dGVudGlvbnMlMjAlM0QlMjBvdXRwdXRzJTIw",highlighted:`<span class="hljs-comment"># Carichiamo il nostro modello </span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>) 

<span class="hljs-comment"># Se usavi questa riga in pytorch-pretrained-bert : </span>
loss = model(input_ids, labels=labels) 

<span class="hljs-comment"># Ora usa questa riga in 🤗 Transformers per estrarre la perdita dalla tupla di output: </span>
outputs = model(input_ids, labels=labels) 
loss = outputs[<span class="hljs-number">0</span>] 

<span class="hljs-comment"># In 🤗 Transformers puoi anche avere accesso ai logit: </span>
loss, logits = outputs[:<span class="hljs-number">2</span>] 

<span class="hljs-comment"># Ed anche agli attention weight se configuri il modello per restituirli (e anche altri output, vedi le docstring e la documentazione) </span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot; bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>) 
outputs = model(input_ids, labels=labels) 
loss, logits, attentions = outputs `,wrap:!1}}),Re=new T({props:{title:"Serializzazione",local:"serializzazione",headingTag:"h3"}}),Ne=new y({props:{code:"JTIzJTIzJTIzJTIwQ2FyaWNoaWFtbyUyMHVuJTIwbW9kZWxsbyUyMGUlMjB1biUyMHRva2VuaXplciUyMCUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUyMCUwQXRva2VuaXplciUyMCUzRCUyMEJlcnRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUyMCUwQSUwQSUyMyUyMyUyMyUyMEZhY2NpYW1vJTIwZmFyZSUyMGFsY3VuZSUyMGNvc2UlMjBhbCUyMG5vc3RybyUyMG1vZGVsbG8lMjBlJTIwdG9rZW5pemVyJTIwJTBBJTIzJTIwRXMlM0ElMjBhZ2dpdW5naWFtbyUyMG51b3ZpJTIwdG9rZW4lMjBhbCUyMHZvY2Fib2xhcmlvJTIwZSUyMGFnbGklMjBlbWJlbmRpbmclMjBkZWwlMjBub3N0cm8lMjBtb2RlbGxvJTIwJTBBdG9rZW5pemVyLmFkZF90b2tlbnMoJTVCJTIyJTVCU1BFQ0lBTF9UT0tFTl8xJTVEJTIyJTJDJTIwJTIyJTVCU1BFQ0lBTF9UT0tFTl8yJTVEJTIyJTVEKSUyMCUwQW1vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUyMCUwQSUyMyUyMEFsbGVuaWFtbyUyMGlsJTIwbm9zdHJvJTIwbW9kZWxsbyUwQXRyYWluKG1vZGVsKSUyMCUwQSUwQSUyMyUyMyUyMyUyME9yYSUyMHNhbHZpYW1vJTIwaWwlMjBub3N0cm8lMjBtb2RlbGxvJTIwZSUyMGlsJTIwdG9rZW5pemVyJTIwaW4lMjB1bmElMjBjYXJ0ZWxsYSUyMCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbXlfc2F2ZWRfbW9kZWxfZGlyZWN0b3J5JTJGJTIyKSUyMCUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm15X3NhdmVkX21vZGVsX2RpcmVjdG9yeSUyRiUyMiklMjAlMEElMEElMjMlMjMlMjMlMjBSaWNhcmljaGlhbW8lMjBpbCUyMG1vZGVsbG8lMjBlJTIwaWwlMjB0b2tlbml6ZXIlMjAlMEFtb2RlbCUyMCUzRCUyMEJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjIuJTJGbXlfc2F2ZWRfbW9kZWxfZGlyZWN0b3J5JTJGJTIyKSUyMCUwQXRva2VuaXplciUyMCUzRCUyMEJlcnRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZteV9zYXZlZF9tb2RlbF9kaXJlY3RvcnklMkYlMjIpJTIw",highlighted:`<span class="hljs-comment">### Carichiamo un modello e un tokenizer </span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>) 
tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>) 

<span class="hljs-comment">### Facciamo fare alcune cose al nostro modello e tokenizer </span>
<span class="hljs-comment"># Es: aggiungiamo nuovi token al vocabolario e agli embending del nostro modello </span>
tokenizer.add_tokens([<span class="hljs-string">&quot;[SPECIAL_TOKEN_1]&quot;</span>, <span class="hljs-string">&quot;[SPECIAL_TOKEN_2]&quot;</span>]) 
model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer)) 
<span class="hljs-comment"># Alleniamo il nostro modello</span>
train(model) 

<span class="hljs-comment">### Ora salviamo il nostro modello e il tokenizer in una cartella </span>
model.save_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>) 
tokenizer.save_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>) 

<span class="hljs-comment">### Ricarichiamo il modello e il tokenizer </span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>) 
tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>) `,wrap:!1}}),Pe=new T({props:{title:"Ottimizzatori: BertAdam e OpenAIAdam ora sono AdamW, lo scheduling è quello standard PyTorch",local:"ottimizzatori-bertadam-e-openaiadam-ora-sono-adamw-lo-scheduling-è-quello-standard-pytorch",headingTag:"h3"}}),et=new y({props:{code:"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",highlighted:`<span class="hljs-comment"># Parametri: </span>
lr = <span class="hljs-number">1e-3</span> 
max_grad_norm = <span class="hljs-number">1.0</span> 
num_training_steps = <span class="hljs-number">1000</span> 
num_warmup_steps = <span class="hljs-number">100</span> 
warmup_proportion = <span class="hljs-built_in">float</span>( num_warmup_steps) / <span class="hljs-built_in">float</span>(num_training_steps) <span class="hljs-comment"># 0.1 </span>

<span class="hljs-comment">### In precedenza l&#x27;ottimizzatore BertAdam veniva istanziato in questo modo: </span>
optimizer = BertAdam( 
   model.parameters(), 
   lr=lr, 
   schedule=<span class="hljs-string">&quot;warmup_linear&quot;</span>, 
   warmup=warmup_proportion, 
   num_training_steps=num_training_steps, 
) 
<span class="hljs-comment">### e usato in questo modo: </span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_data: 
   loss = model(batch) 
   loss.backward() 
   optimizer.step() 

<span class="hljs-comment">### In 🤗 Transformers, ottimizzatore e schedule sono divisi e usati in questo modo: </span>
optimizer = AdamW( 
   model.parameters(), lr=lr, correct_bias=<span class="hljs-literal">False</span> 
) <span class="hljs-comment"># Per riprodurre il comportamento specifico di BertAdam impostare correct_bias=False </span>
scheduler = get_linear_schedule_with_warmup( 
   optimizer, num_warmup_steps=num_warmup_steps, num_training_steps=num_training_steps 
) <span class="hljs-comment"># PyTorch scheduler </span>
<span class="hljs-comment">### e va usato così: </span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_data: 
   loss = model(batch) 
   loss.backward() 
   torch.nn.utils.clip_grad_norm_( 
   model.parameters(), max_grad_norm 
   ) <span class="hljs-comment"># Gradient clipping non è più in AdamW (quindi puoi usare amp senza problemi) </span>
   optimizer.step() 
   scheduler.step()`,wrap:!1}}),{c(){b=a("meta"),it=o(),tt=a("p"),ot=o(),d(v.$$.fragment),nt=o(),d(f.$$.fragment),at=o(),J=a("p"),J.textContent=Al,st=o(),d(w.$$.fragment),rt=o(),z=a("p"),z.textContent=Yl,dt=o(),_=a("p"),_.textContent=Sl,pt=o(),U=a("ul"),U.innerHTML=Nl,mt=o(),d(j.$$.fragment),ct=o(),$=a("ul"),$.innerHTML=Pl,ut=o(),g=a("p"),g.innerHTML=Ql,Mt=o(),d(h.$$.fragment),Tt=o(),C=a("p"),C.innerHTML=ql,yt=o(),d(I.$$.fragment),bt=o(),d(Z.$$.fragment),vt=o(),k=a("p"),k.innerHTML=Kl,ft=o(),x=a("p"),x.innerHTML=Dl,Jt=o(),B=a("ul"),B.innerHTML=Ol,wt=o(),d(W.$$.fragment),zt=o(),H=a("p"),H.innerHTML=ei,_t=o(),L=a("p"),L.innerHTML=ti,Ut=o(),d(G.$$.fragment),jt=o(),X=a("p"),X.innerHTML=li,$t=o(),d(V.$$.fragment),gt=o(),F=a("p"),F.textContent=ii,ht=o(),d(R.$$.fragment),Ct=o(),d(E.$$.fragment),It=o(),A=a("p"),A.innerHTML=oi,Zt=o(),Y=a("p"),Y.textContent=ni,kt=o(),d(S.$$.fragment),xt=o(),N=a("p"),N.innerHTML=ai,Bt=o(),P=a("p"),P.innerHTML=si,Wt=o(),d(Q.$$.fragment),Ht=o(),q=a("p"),q.innerHTML=ri,Lt=o(),d(K.$$.fragment),Gt=o(),d(D.$$.fragment),Xt=o(),O=a("p"),O.innerHTML=di,Vt=o(),ee=a("p"),ee.innerHTML=pi,Ft=o(),d(te.$$.fragment),Rt=o(),le=a("p"),le.innerHTML=mi,Et=o(),ie=a("p"),ie.innerHTML=ci,At=o(),d(oe.$$.fragment),Yt=o(),ne=a("p"),ne.innerHTML=ui,St=o(),d(ae.$$.fragment),Nt=o(),se=a("p"),se.textContent=Mi,Pt=o(),d(re.$$.fragment),Qt=o(),d(de.$$.fragment),qt=o(),pe=a("p"),pe.innerHTML=Ti,Kt=o(),me=a("p"),me.textContent=yi,Dt=o(),ce=a("p"),ce.textContent=bi,Ot=o(),ue=a("ul"),ue.innerHTML=vi,el=o(),Me=a("p"),Me.textContent=fi,tl=o(),Te=a("ul"),Te.innerHTML=Ji,ll=o(),ye=a("p"),ye.textContent=wi,il=o(),be=a("ul"),be.innerHTML=zi,ol=o(),ve=a("p"),ve.innerHTML=_i,nl=o(),fe=a("ul"),fe.innerHTML=Ui,al=o(),Je=a("p"),Je.innerHTML=ji,sl=o(),we=a("ul"),we.innerHTML=$i,rl=o(),ze=a("p"),ze.innerHTML=gi,dl=o(),_e=a("ul"),_e.innerHTML=hi,pl=o(),Ue=a("p"),Ue.textContent=Ci,ml=o(),je=a("ul"),je.innerHTML=Ii,cl=o(),$e=a("p"),$e.textContent=Zi,ul=o(),ge=a("ul"),ge.innerHTML=ki,Ml=o(),d(he.$$.fragment),Tl=o(),Ce=a("p"),Ce.innerHTML=xi,yl=o(),d(Ie.$$.fragment),bl=o(),Ze=a("p"),Ze.innerHTML=Bi,vl=o(),ke=a("p"),ke.innerHTML=Wi,fl=o(),xe=a("p"),xe.innerHTML=Hi,Jl=o(),d(Be.$$.fragment),wl=o(),We=a("p"),We.innerHTML=Li,zl=o(),d(He.$$.fragment),_l=o(),Le=a("p"),Le.innerHTML=Gi,Ul=o(),Ge=a("p"),Ge.innerHTML=Xi,jl=o(),Xe=a("p"),Xe.innerHTML=Vi,$l=o(),Ve=a("p"),Ve.innerHTML=Fi,gl=o(),d(Fe.$$.fragment),hl=o(),d(Re.$$.fragment),Cl=o(),Ee=a("p"),Ee.innerHTML=Ri,Il=o(),Ae=a("ol"),Ae.innerHTML=Ei,Zl=o(),Ye=a("p"),Ye.innerHTML=Ai,kl=o(),Se=a("p"),Se.textContent=Yi,xl=o(),d(Ne.$$.fragment),Bl=o(),d(Pe.$$.fragment),Wl=o(),Qe=a("p"),Qe.innerHTML=Si,Hl=o(),qe=a("ul"),qe.innerHTML=Ni,Ll=o(),Ke=a("p"),Ke.innerHTML=Pi,Gl=o(),De=a("p"),De.innerHTML=Qi,Xl=o(),Oe=a("p"),Oe.innerHTML=qi,Vl=o(),d(et.$$.fragment),Fl=o(),lt=a("p"),this.h()},l(e){const t=oo("svelte-u9bgzb",document.head);b=s(t,"META",{name:!0,content:!0}),t.forEach(l),it=n(e),tt=s(e,"P",{}),Ki(tt).forEach(l),ot=n(e),p(v.$$.fragment,e),nt=n(e),p(f.$$.fragment,e),at=n(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-12ps4eh"&&(J.textContent=Al),st=n(e),p(w.$$.fragment,e),rt=n(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-qmmnq4"&&(z.textContent=Yl),dt=n(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ybieta"&&(_.textContent=Sl),pt=n(e),U=s(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-vamnh8"&&(U.innerHTML=Nl),mt=n(e),p(j.$$.fragment,e),ct=n(e),$=s(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-xq7rpc"&&($.innerHTML=Pl),ut=n(e),g=s(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1myz5e1"&&(g.innerHTML=Ql),Mt=n(e),p(h.$$.fragment,e),Tt=n(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10agfjt"&&(C.innerHTML=ql),yt=n(e),p(I.$$.fragment,e),bt=n(e),p(Z.$$.fragment,e),vt=n(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1aolgbs"&&(k.innerHTML=Kl),ft=n(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1y4dl4s"&&(x.innerHTML=Dl),Jt=n(e),B=s(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1ehv4ps"&&(B.innerHTML=Ol),wt=n(e),p(W.$$.fragment,e),zt=n(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-v41ndc"&&(H.innerHTML=ei),_t=n(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1myz5e1"&&(L.innerHTML=ti),Ut=n(e),p(G.$$.fragment,e),jt=n(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-10agfjt"&&(X.innerHTML=li),$t=n(e),p(V.$$.fragment,e),gt=n(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-9vdevt"&&(F.textContent=ii),ht=n(e),p(R.$$.fragment,e),Ct=n(e),p(E.$$.fragment,e),It=n(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1y9v2vv"&&(A.innerHTML=oi),Zt=n(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-8bv1ru"&&(Y.textContent=ni),kt=n(e),p(S.$$.fragment,e),xt=n(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1qt2azy"&&(N.innerHTML=ai),Bt=n(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1myz5e1"&&(P.innerHTML=si),Wt=n(e),p(Q.$$.fragment,e),Ht=n(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-10agfjt"&&(q.innerHTML=ri),Lt=n(e),p(K.$$.fragment,e),Gt=n(e),p(D.$$.fragment,e),Xt=n(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-11ae58v"&&(O.innerHTML=di),Vt=n(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1hdvxqq"&&(ee.innerHTML=pi),Ft=n(e),p(te.$$.fragment,e),Rt=n(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-18yut6l"&&(le.innerHTML=mi),Et=n(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1myz5e1"&&(ie.innerHTML=ci),At=n(e),p(oe.$$.fragment,e),Yt=n(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10agfjt"&&(ne.innerHTML=ui),St=n(e),p(ae.$$.fragment,e),Nt=n(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-9vdevt"&&(se.textContent=Mi),Pt=n(e),p(re.$$.fragment,e),Qt=n(e),p(de.$$.fragment,e),qt=n(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1smlxei"&&(pe.innerHTML=Ti),Kt=n(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-37ye4w"&&(me.textContent=yi),Dt=n(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-qg5nrc"&&(ce.textContent=bi),Ot=n(e),ue=s(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-6r2632"&&(ue.innerHTML=vi),el=n(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-13xmow3"&&(Me.textContent=fi),tl=n(e),Te=s(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-uuytv1"&&(Te.innerHTML=Ji),ll=n(e),ye=s(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1ww4bmn"&&(ye.textContent=wi),il=n(e),be=s(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-1q8lyb"&&(be.innerHTML=zi),ol=n(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-84bife"&&(ve.innerHTML=_i),nl=n(e),fe=s(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-kpjcp6"&&(fe.innerHTML=Ui),al=n(e),Je=s(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-d361u4"&&(Je.innerHTML=ji),sl=n(e),we=s(e,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-1cj6ynj"&&(we.innerHTML=$i),rl=n(e),ze=s(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-or0kcx"&&(ze.innerHTML=gi),dl=n(e),_e=s(e,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-hm0dj4"&&(_e.innerHTML=hi),pl=n(e),Ue=s(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-f9m5f7"&&(Ue.textContent=Ci),ml=n(e),je=s(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-1wegf7y"&&(je.innerHTML=Ii),cl=n(e),$e=s(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1oeu247"&&($e.textContent=Zi),ul=n(e),ge=s(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-13op50h"&&(ge.innerHTML=ki),Ml=n(e),p(he.$$.fragment,e),Tl=n(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-127eqyr"&&(Ce.innerHTML=xi),yl=n(e),p(Ie.$$.fragment,e),bl=n(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1ki0hk0"&&(Ze.innerHTML=Bi),vl=n(e),ke=s(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-noq89k"&&(ke.innerHTML=Wi),fl=n(e),xe=s(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1x76piw"&&(xe.innerHTML=Hi),Jl=n(e),p(Be.$$.fragment,e),wl=n(e),We=s(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ff3rjq"&&(We.innerHTML=Li),zl=n(e),p(He.$$.fragment,e),_l=n(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ego3kz"&&(Le.innerHTML=Gi),Ul=n(e),Ge=s(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1kcubrt"&&(Ge.innerHTML=Xi),jl=n(e),Xe=s(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-4wdjuy"&&(Xe.innerHTML=Vi),$l=n(e),Ve=s(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-3xb0tb"&&(Ve.innerHTML=Fi),gl=n(e),p(Fe.$$.fragment,e),hl=n(e),p(Re.$$.fragment,e),Cl=n(e),Ee=s(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1yajen3"&&(Ee.innerHTML=Ri),Il=n(e),Ae=s(e,"OL",{"data-svelte-h":!0}),r(Ae)!=="svelte-p99gqs"&&(Ae.innerHTML=Ei),Zl=n(e),Ye=s(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1umxgoh"&&(Ye.innerHTML=Ai),kl=n(e),Se=s(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-11m6zo5"&&(Se.textContent=Yi),xl=n(e),p(Ne.$$.fragment,e),Bl=n(e),p(Pe.$$.fragment,e),Wl=n(e),Qe=s(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-oi5jct"&&(Qe.innerHTML=Si),Hl=n(e),qe=s(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-6ya09s"&&(qe.innerHTML=Ni),Ll=n(e),Ke=s(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-5iz2eq"&&(Ke.innerHTML=Pi),Gl=n(e),De=s(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-nuhb3n"&&(De.innerHTML=Qi),Xl=n(e),Oe=s(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1m53sr7"&&(Oe.innerHTML=qi),Vl=n(e),p(et.$$.fragment,e),Fl=n(e),lt=s(e,"P",{}),Ki(lt).forEach(l),this.h()},h(){Di(b,"name","hf:doc:metadata"),Di(b,"content",so)},m(e,t){no(document.head,b),i(e,it,t),i(e,tt,t),i(e,ot,t),m(v,e,t),i(e,nt,t),m(f,e,t),i(e,at,t),i(e,J,t),i(e,st,t),m(w,e,t),i(e,rt,t),i(e,z,t),i(e,dt,t),i(e,_,t),i(e,pt,t),i(e,U,t),i(e,mt,t),m(j,e,t),i(e,ct,t),i(e,$,t),i(e,ut,t),i(e,g,t),i(e,Mt,t),m(h,e,t),i(e,Tt,t),i(e,C,t),i(e,yt,t),m(I,e,t),i(e,bt,t),m(Z,e,t),i(e,vt,t),i(e,k,t),i(e,ft,t),i(e,x,t),i(e,Jt,t),i(e,B,t),i(e,wt,t),m(W,e,t),i(e,zt,t),i(e,H,t),i(e,_t,t),i(e,L,t),i(e,Ut,t),m(G,e,t),i(e,jt,t),i(e,X,t),i(e,$t,t),m(V,e,t),i(e,gt,t),i(e,F,t),i(e,ht,t),m(R,e,t),i(e,Ct,t),m(E,e,t),i(e,It,t),i(e,A,t),i(e,Zt,t),i(e,Y,t),i(e,kt,t),m(S,e,t),i(e,xt,t),i(e,N,t),i(e,Bt,t),i(e,P,t),i(e,Wt,t),m(Q,e,t),i(e,Ht,t),i(e,q,t),i(e,Lt,t),m(K,e,t),i(e,Gt,t),m(D,e,t),i(e,Xt,t),i(e,O,t),i(e,Vt,t),i(e,ee,t),i(e,Ft,t),m(te,e,t),i(e,Rt,t),i(e,le,t),i(e,Et,t),i(e,ie,t),i(e,At,t),m(oe,e,t),i(e,Yt,t),i(e,ne,t),i(e,St,t),m(ae,e,t),i(e,Nt,t),i(e,se,t),i(e,Pt,t),m(re,e,t),i(e,Qt,t),m(de,e,t),i(e,qt,t),i(e,pe,t),i(e,Kt,t),i(e,me,t),i(e,Dt,t),i(e,ce,t),i(e,Ot,t),i(e,ue,t),i(e,el,t),i(e,Me,t),i(e,tl,t),i(e,Te,t),i(e,ll,t),i(e,ye,t),i(e,il,t),i(e,be,t),i(e,ol,t),i(e,ve,t),i(e,nl,t),i(e,fe,t),i(e,al,t),i(e,Je,t),i(e,sl,t),i(e,we,t),i(e,rl,t),i(e,ze,t),i(e,dl,t),i(e,_e,t),i(e,pl,t),i(e,Ue,t),i(e,ml,t),i(e,je,t),i(e,cl,t),i(e,$e,t),i(e,ul,t),i(e,ge,t),i(e,Ml,t),m(he,e,t),i(e,Tl,t),i(e,Ce,t),i(e,yl,t),m(Ie,e,t),i(e,bl,t),i(e,Ze,t),i(e,vl,t),i(e,ke,t),i(e,fl,t),i(e,xe,t),i(e,Jl,t),m(Be,e,t),i(e,wl,t),i(e,We,t),i(e,zl,t),m(He,e,t),i(e,_l,t),i(e,Le,t),i(e,Ul,t),i(e,Ge,t),i(e,jl,t),i(e,Xe,t),i(e,$l,t),i(e,Ve,t),i(e,gl,t),m(Fe,e,t),i(e,hl,t),m(Re,e,t),i(e,Cl,t),i(e,Ee,t),i(e,Il,t),i(e,Ae,t),i(e,Zl,t),i(e,Ye,t),i(e,kl,t),i(e,Se,t),i(e,xl,t),m(Ne,e,t),i(e,Bl,t),m(Pe,e,t),i(e,Wl,t),i(e,Qe,t),i(e,Hl,t),i(e,qe,t),i(e,Ll,t),i(e,Ke,t),i(e,Gl,t),i(e,De,t),i(e,Xl,t),i(e,Oe,t),i(e,Vl,t),m(et,e,t),i(e,Fl,t),i(e,lt,t),Rl=!0},p:eo,i(e){Rl||(c(v.$$.fragment,e),c(f.$$.fragment,e),c(w.$$.fragment,e),c(j.$$.fragment,e),c(h.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(Ie.$$.fragment,e),c(Be.$$.fragment,e),c(He.$$.fragment,e),c(Fe.$$.fragment,e),c(Re.$$.fragment,e),c(Ne.$$.fragment,e),c(Pe.$$.fragment,e),c(et.$$.fragment,e),Rl=!0)},o(e){u(v.$$.fragment,e),u(f.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(h.$$.fragment,e),u(I.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(Ie.$$.fragment,e),u(Be.$$.fragment,e),u(He.$$.fragment,e),u(Fe.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(Pe.$$.fragment,e),u(et.$$.fragment,e),Rl=!1},d(e){e&&(l(it),l(tt),l(ot),l(nt),l(at),l(J),l(st),l(rt),l(z),l(dt),l(_),l(pt),l(U),l(mt),l(ct),l($),l(ut),l(g),l(Mt),l(Tt),l(C),l(yt),l(bt),l(vt),l(k),l(ft),l(x),l(Jt),l(B),l(wt),l(zt),l(H),l(_t),l(L),l(Ut),l(jt),l(X),l($t),l(gt),l(F),l(ht),l(Ct),l(It),l(A),l(Zt),l(Y),l(kt),l(xt),l(N),l(Bt),l(P),l(Wt),l(Ht),l(q),l(Lt),l(Gt),l(Xt),l(O),l(Vt),l(ee),l(Ft),l(Rt),l(le),l(Et),l(ie),l(At),l(Yt),l(ne),l(St),l(Nt),l(se),l(Pt),l(Qt),l(qt),l(pe),l(Kt),l(me),l(Dt),l(ce),l(Ot),l(ue),l(el),l(Me),l(tl),l(Te),l(ll),l(ye),l(il),l(be),l(ol),l(ve),l(nl),l(fe),l(al),l(Je),l(sl),l(we),l(rl),l(ze),l(dl),l(_e),l(pl),l(Ue),l(ml),l(je),l(cl),l($e),l(ul),l(ge),l(Ml),l(Tl),l(Ce),l(yl),l(bl),l(Ze),l(vl),l(ke),l(fl),l(xe),l(Jl),l(wl),l(We),l(zl),l(_l),l(Le),l(Ul),l(Ge),l(jl),l(Xe),l($l),l(Ve),l(gl),l(hl),l(Cl),l(Ee),l(Il),l(Ae),l(Zl),l(Ye),l(kl),l(Se),l(xl),l(Bl),l(Wl),l(Qe),l(Hl),l(qe),l(Ll),l(Ke),l(Gl),l(De),l(Xl),l(Oe),l(Vl),l(Fl),l(lt)),l(b),M(v,e),M(f,e),M(w,e),M(j,e),M(h,e),M(I,e),M(Z,e),M(W,e),M(G,e),M(V,e),M(R,e),M(E,e),M(S,e),M(Q,e),M(K,e),M(D,e),M(te,e),M(oe,e),M(ae,e),M(re,e),M(de,e),M(he,e),M(Ie,e),M(Be,e),M(He,e),M(Fe,e),M(Re,e),M(Ne,e),M(Pe,e),M(et,e)}}}const so='{"title":"Migrazione da pacchetti precedenti","local":"migrazione-da-pacchetti-precedenti","sections":[{"title":"Migrazione da transformers v3.x a v4.x","local":"migrazione-da-transformers-v3x-a-v4x","sections":[{"title":"1. AutoTokenizer e pipeline ora utilizzano tokenizer veloci (rust) per impostazione predefinita.","local":"1-autotokenizer-e-pipeline-ora-utilizzano-tokenizer-veloci-rust-per-impostazione-predefinita","sections":[{"title":"Come ottenere lo stesso comportamento di v3.x in v4.x","local":"come-ottenere-lo-stesso-comportamento-di-v3x-in-v4x","sections":[],"depth":5}],"depth":4},{"title":"2. SentencePiece è stato rimosso dalle dipendenze richieste","local":"2-sentencepiece-è-stato-rimosso-dalle-dipendenze-richieste","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"3. L’architettura delle repo è stato aggiornata in modo che ogni modello abbia la propria cartella","local":"3-larchitettura-delle-repo-è-stato-aggiornata-in-modo-che-ogni-modello-abbia-la-propria-cartella","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"4. Impostare l’argomento return_dict su True per impostazione predefinita","local":"4-impostare-largomento-returndict-su-true-per-impostazione-predefinita","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"5. Rimozione di alcuni attributi deprecati","local":"5-rimozione-di-alcuni-attributi-deprecati","sections":[],"depth":4}],"depth":2},{"title":"Passaggio da pytorch-transformers a 🤗 Transformers","local":"passaggio-da-pytorch-transformers-a--transformers","sections":[{"title":"L’ordine posizionale di alcune parole chiave di input dei modelli ( attention_mask , token_type_ids …) è cambiato","local":"lordine-posizionale-di-alcune-parole-chiave-di-input-dei-modelli--attentionmask--tokentypeids--è-cambiato","sections":[],"depth":3}],"depth":2},{"title":"Migrazione da pytorch-pretrained-bert","local":"migrazione-da-pytorch-pretrained-bert","sections":[{"title":"I modelli restituiscono sempre tuple","local":"i-modelli-restituiscono-sempre-tuple","sections":[],"depth":3},{"title":"Serializzazione","local":"serializzazione","sections":[],"depth":3},{"title":"Ottimizzatori: BertAdam e OpenAIAdam ora sono AdamW, lo scheduling è quello standard PyTorch","local":"ottimizzatori-bertadam-e-openaiadam-ora-sono-adamw-lo-scheduling-è-quello-standard-pytorch","sections":[],"depth":3}],"depth":2}],"depth":1}';function ro(El){return to(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mo extends lo{constructor(b){super(),io(this,b,ro,ao,Oi,{})}}export{Mo as component};
