import{s as Xa,n as Ga,o as Va}from"../chunks/scheduler.85c25b89.js";import{S as Ya,i as Ka,g as i,s as n,r as c,A as en,h as s,f as a,c as o,j as v,u as p,x as d,k as b,y as r,a as l,v as h,d as g,t as u,w as f}from"../chunks/index.c142fe32.js";import{D as C}from"../chunks/Docstring.e6639b56.js";import{C as pa}from"../chunks/CodeBlock.a5e95a57.js";import{H as T,E as tn}from"../chunks/EditOnGithub.a592e7aa.js";function an(ha){let O,Re,Qe,Xe,N,Ge,q,ga=`Contrastive Preference Optimization (CPO) as introduced in the paper <a href="https://huggingface.co/papers/2401.08417" rel="nofollow">Contrastive Preference Optimization: Pushing the Boundaries of LLM Performance in Machine Translation</a> by Haoran Xu, Amr Sharaf, Yunmo Chen, Weiting Tan, Lingfeng Shen, Benjamin Van Durme, Kenton Murray, and Young Jin Kim. At a high-level, CPO  trains models to
avoid generating adequate, but not perfect translations in Machine Translation (MT) tasks. However, CPO is a general approximation to the DPO loss and can be applied to other domains like chat.`,Ve,F,ua="CPO aims to mitigate two fundamental shortcomings of SFT. First, SFT’s methodology of minimizing the discrepancy between predicted outputs and gold-standard references inherently caps model performance at the quality level of the training data. Secondly, SFT lacks a mechanism to prevent the model from rejecting mistakes in translations. The CPO objective is derived from the DPO objective.",Ye,L,Ke,E,fa='The <a href="https://huggingface.co/papers/2405.14734" rel="nofollow">SimPO</a> method is also implemented in the <code>CPOTrainer</code>. SimPO is an alternative loss that adds a reward margin, allows for length normalization, and does not use BC regularization. To use this loss, we can use SimPO easily by turning on <code>loss_type=&quot;simpo&quot;</code> and <code>cpo_alpha=0</code> in the <code>CPOConfig</code>.',et,z,tt,S,_a='We also offer the combined use of CPO and SimPO, which enables more stable training and improved performance. Learn more details at <a href="https://github.com/fe1ixxu/CPO_SIMPO" rel="nofollow">CPO-SimPO Github</a>. To use this method, simply enable SimPO by setting <code>loss_type=&quot;simpo&quot;</code> and a non-zero <code>cpo_alpha</code> in the CPOConfig.',at,H,nt,B,va="The CPO trainer expects a format identical to the DPO trainer, which should include three entries. These entries should be named as follows:",ot,D,ba="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",lt,W,Ma="for example:",rt,Q,it,Z,Ca="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",st,R,dt,X,ya="The CPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",mt,G,ct,V,Ta="For a detailed example have a look at the <code>examples/scripts/cpo.py</code> script. At a high level we need to initialize the <code>CPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that CPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong> The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above.",pt,Y,ht,K,wa="After this one can then call:",gt,ee,ut,te,ft,ae,$a="Given the preference data, the <code>CPOTrainer</code> uses the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",_t,ne,Oa='The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. The <code>CPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',vt,oe,xa='The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the CPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike CPO which is summed only).',bt,le,Mt,re,ja=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,Ct,ie,Ua=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,yt,se,Tt,de,Pa="While training and evaluating we record the following reward metrics:",wt,me,Ja="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>nll_loss</code>: the mean negative log likelihood loss of the policy model for the chosen responses</li>",$t,ce,Ot,m,pe,Et,Oe,Ia="Initialize CPOTrainer.",zt,x,he,St,xe,ka=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Ht,w,ge,Bt,je,Aa="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Dt,Ue,Na="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Wt,j,ue,Qt,Pe,qa="Concatenate the chosen and rejected inputs into a single tensor.",Zt,U,fe,Rt,Je,Fa="Compute the CPO loss for a batch of policy and reference model log probabilities.",Xt,$,_e,Gt,Ie,La=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Vt,ke,Ea="Works both with or without labels.",Yt,P,ve,Kt,Ae,za="Compute the log probabilities of the given labels under the given logits.",ea,J,be,ta,Ne,Sa="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",aa,I,Me,na,qe,Ha="Generate samples from the model and reference model for the given batch of inputs.",oa,k,Ce,la,Fe,Ba="Log <code>logs</code> on the various objects watching training, including stored metrics.",ra,M,ye,ia,Le,Da="Tokenize a single row from a CPO specific dataset.",sa,Ee,Wa=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,da,ze,Qa=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,xt,Te,jt,y,we,ma,Se,Za='Configuration class for the <a href="/docs/trl/v0.11.2/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a>.',ca,He,Ra=`Using <a href="https://huggingface.co/docs/transformers/v4.45.2/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ut,$e,Pt,Ze,Jt;return N=new T({props:{title:"CPO Trainer",local:"cpo-trainer",headingTag:"h1"}}),L=new T({props:{title:"SimPO",local:"simpo",headingTag:"h2"}}),z=new T({props:{title:"CPO-SimPO",local:"cpo-simpo",headingTag:"h2"}}),H=new T({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),Q=new pa({props:{code:"Y3BvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`cpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),R=new T({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),G=new T({props:{title:"Using the CPOTrainer",local:"using-the-cpotrainer",headingTag:"h2"}}),Y=new pa({props:{code:"Y3BvX2NvbmZpZyUyMCUzRCUyMENQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWNwb190cmFpbmVyJTIwJTNEJTIwQ1BPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RjcG9fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`cpo_config = CPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

cpo_trainer = CPOTrainer(
    model,
    args=cpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),ee=new pa({props:{code:"Y3BvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"cpo_trainer.train()",wrap:!1}}),te=new T({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),le=new T({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),se=new T({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ce=new T({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),pe=new C({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L64"}}),he=new C({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L332"}}),ge=new C({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L679"}}),ue=new C({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),fe=new C({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L590",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),_e=new C({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L887"}}),ve=new C({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L641",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),be=new C({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L754"}}),Me=new C({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L822"}}),Ce=new C({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L935"}}),ye=new C({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_trainer.py#L382"}}),Te=new T({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),we=new C({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"cpo_alpha",val:": float = 1.0"},{name:"simpo_gamma",val:": float = 0.5"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;simpo&quot;</code>: SimPO loss from the <a href="https://huggingface.co/papers/2405.14734" rel="nofollow">SimPO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.cpo_alpha",description:`<strong>cpo_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Weight of the BC regularizer in CPO training.`,name:"cpo_alpha"},{anchor:"trl.CPOConfig.simpo_gamma",description:`<strong>simpo_gamma</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Target reward margin for the SimPO loss, used only when the <code>loss_type=&quot;simpo&quot;</code>.`,name:"simpo_gamma"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>,<em>optional</em>,  defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from the model to W&amp;B during evaluation.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/cpo_config.py#L20"}}),$e=new tn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/cpo_trainer.mdx"}}),{c(){O=i("meta"),Re=n(),Qe=i("p"),Xe=n(),c(N.$$.fragment),Ge=n(),q=i("p"),q.innerHTML=ga,Ve=n(),F=i("p"),F.textContent=ua,Ye=n(),c(L.$$.fragment),Ke=n(),E=i("p"),E.innerHTML=fa,et=n(),c(z.$$.fragment),tt=n(),S=i("p"),S.innerHTML=_a,at=n(),c(H.$$.fragment),nt=n(),B=i("p"),B.textContent=va,ot=n(),D=i("ul"),D.innerHTML=ba,lt=n(),W=i("p"),W.textContent=Ma,rt=n(),c(Q.$$.fragment),it=n(),Z=i("p"),Z.innerHTML=Ca,st=n(),c(R.$$.fragment),dt=n(),X=i("p"),X.innerHTML=ya,mt=n(),c(G.$$.fragment),ct=n(),V=i("p"),V.innerHTML=Ta,pt=n(),c(Y.$$.fragment),ht=n(),K=i("p"),K.textContent=wa,gt=n(),c(ee.$$.fragment),ut=n(),c(te.$$.fragment),ft=n(),ae=i("p"),ae.innerHTML=$a,_t=n(),ne=i("p"),ne.innerHTML=Oa,vt=n(),oe=i("p"),oe.innerHTML=xa,bt=n(),c(le.$$.fragment),Mt=n(),re=i("p"),re.innerHTML=ja,Ct=n(),ie=i("p"),ie.innerHTML=Ua,yt=n(),c(se.$$.fragment),Tt=n(),de=i("p"),de.textContent=Pa,wt=n(),me=i("ul"),me.innerHTML=Ja,$t=n(),c(ce.$$.fragment),Ot=n(),m=i("div"),c(pe.$$.fragment),Et=n(),Oe=i("p"),Oe.textContent=Ia,zt=n(),x=i("div"),c(he.$$.fragment),St=n(),xe=i("p"),xe.innerHTML=ka,Ht=n(),w=i("div"),c(ge.$$.fragment),Bt=n(),je=i("p"),je.textContent=Aa,Dt=n(),Ue=i("p"),Ue.textContent=Na,Wt=n(),j=i("div"),c(ue.$$.fragment),Qt=n(),Pe=i("p"),Pe.textContent=qa,Zt=n(),U=i("div"),c(fe.$$.fragment),Rt=n(),Je=i("p"),Je.textContent=Fa,Xt=n(),$=i("div"),c(_e.$$.fragment),Gt=n(),Ie=i("p"),Ie.innerHTML=La,Vt=n(),ke=i("p"),ke.textContent=Ea,Yt=n(),P=i("div"),c(ve.$$.fragment),Kt=n(),Ae=i("p"),Ae.textContent=za,ea=n(),J=i("div"),c(be.$$.fragment),ta=n(),Ne=i("p"),Ne.textContent=Sa,aa=n(),I=i("div"),c(Me.$$.fragment),na=n(),qe=i("p"),qe.textContent=Ha,oa=n(),k=i("div"),c(Ce.$$.fragment),la=n(),Fe=i("p"),Fe.innerHTML=Ba,ra=n(),M=i("div"),c(ye.$$.fragment),ia=n(),Le=i("p"),Le.textContent=Da,sa=n(),Ee=i("p"),Ee.textContent=Wa,da=n(),ze=i("p"),ze.textContent=Qa,xt=n(),c(Te.$$.fragment),jt=n(),y=i("div"),c(we.$$.fragment),ma=n(),Se=i("p"),Se.innerHTML=Za,ca=n(),He=i("p"),He.innerHTML=Ra,Ut=n(),c($e.$$.fragment),Pt=n(),Ze=i("p"),this.h()},l(e){const t=en("svelte-u9bgzb",document.head);O=s(t,"META",{name:!0,content:!0}),t.forEach(a),Re=o(e),Qe=s(e,"P",{}),v(Qe).forEach(a),Xe=o(e),p(N.$$.fragment,e),Ge=o(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1grcdr2"&&(q.innerHTML=ga),Ve=o(e),F=s(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-10wbspk"&&(F.textContent=ua),Ye=o(e),p(L.$$.fragment,e),Ke=o(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-z0ui0a"&&(E.innerHTML=fa),et=o(e),p(z.$$.fragment,e),tt=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-fh1eo8"&&(S.innerHTML=_a),at=o(e),p(H.$$.fragment,e),nt=o(e),B=s(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1t3enyx"&&(B.textContent=va),ot=o(e),D=s(e,"UL",{"data-svelte-h":!0}),d(D)!=="svelte-17vxuta"&&(D.innerHTML=ba),lt=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1gl9mvz"&&(W.textContent=Ma),rt=o(e),p(Q.$$.fragment,e),it=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1a8oxjk"&&(Z.innerHTML=Ca),st=o(e),p(R.$$.fragment,e),dt=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-187gqrp"&&(X.innerHTML=ya),mt=o(e),p(G.$$.fragment,e),ct=o(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1mkccty"&&(V.innerHTML=Ta),pt=o(e),p(Y.$$.fragment,e),ht=o(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1lg6q1l"&&(K.textContent=wa),gt=o(e),p(ee.$$.fragment,e),ut=o(e),p(te.$$.fragment,e),ft=o(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1nbvuj3"&&(ae.innerHTML=$a),_t=o(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-vjnctw"&&(ne.innerHTML=Oa),vt=o(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-tou577"&&(oe.innerHTML=xa),bt=o(e),p(le.$$.fragment,e),Mt=o(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-3kfva2"&&(re.innerHTML=ja),Ct=o(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1c01yo3"&&(ie.innerHTML=Ua),yt=o(e),p(se.$$.fragment,e),Tt=o(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-132s7j9"&&(de.textContent=Pa),wt=o(e),me=s(e,"UL",{"data-svelte-h":!0}),d(me)!=="svelte-yjg2sp"&&(me.innerHTML=Ja),$t=o(e),p(ce.$$.fragment,e),Ot=o(e),m=s(e,"DIV",{class:!0});var _=v(m);p(pe.$$.fragment,_),Et=o(_),Oe=s(_,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1qqtmoh"&&(Oe.textContent=Ia),zt=o(_),x=s(_,"DIV",{class:!0});var It=v(x);p(he.$$.fragment,It),St=o(It),xe=s(It,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-mcz8nm"&&(xe.innerHTML=ka),It.forEach(a),Ht=o(_),w=s(_,"DIV",{class:!0});var Be=v(w);p(ge.$$.fragment,Be),Bt=o(Be),je=s(Be,"P",{"data-svelte-h":!0}),d(je)!=="svelte-16i1nac"&&(je.textContent=Aa),Dt=o(Be),Ue=s(Be,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-tgti68"&&(Ue.textContent=Na),Be.forEach(a),Wt=o(_),j=s(_,"DIV",{class:!0});var kt=v(j);p(ue.$$.fragment,kt),Qt=o(kt),Pe=s(kt,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1cvsgkk"&&(Pe.textContent=qa),kt.forEach(a),Zt=o(_),U=s(_,"DIV",{class:!0});var At=v(U);p(fe.$$.fragment,At),Rt=o(At),Je=s(At,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1l2rxe2"&&(Je.textContent=Fa),At.forEach(a),Xt=o(_),$=s(_,"DIV",{class:!0});var De=v($);p(_e.$$.fragment,De),Gt=o(De),Ie=s(De,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-8qlty5"&&(Ie.innerHTML=La),Vt=o(De),ke=s(De,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1tyo99t"&&(ke.textContent=Ea),De.forEach(a),Yt=o(_),P=s(_,"DIV",{class:!0});var Nt=v(P);p(ve.$$.fragment,Nt),Kt=o(Nt),Ae=s(Nt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-4nmimv"&&(Ae.textContent=za),Nt.forEach(a),ea=o(_),J=s(_,"DIV",{class:!0});var qt=v(J);p(be.$$.fragment,qt),ta=o(qt),Ne=s(qt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-4kzfyw"&&(Ne.textContent=Sa),qt.forEach(a),aa=o(_),I=s(_,"DIV",{class:!0});var Ft=v(I);p(Me.$$.fragment,Ft),na=o(Ft),qe=s(Ft,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-18uwvbi"&&(qe.textContent=Ha),Ft.forEach(a),oa=o(_),k=s(_,"DIV",{class:!0});var Lt=v(k);p(Ce.$$.fragment,Lt),la=o(Lt),Fe=s(Lt,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-nqksfz"&&(Fe.innerHTML=Ba),Lt.forEach(a),ra=o(_),M=s(_,"DIV",{class:!0});var A=v(M);p(ye.$$.fragment,A),ia=o(A),Le=s(A,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1a53vwp"&&(Le.textContent=Da),sa=o(A),Ee=s(A,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1mn1gnw"&&(Ee.textContent=Wa),da=o(A),ze=s(A,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1xvpyih"&&(ze.textContent=Qa),A.forEach(a),_.forEach(a),xt=o(e),p(Te.$$.fragment,e),jt=o(e),y=s(e,"DIV",{class:!0});var We=v(y);p(we.$$.fragment,We),ma=o(We),Se=s(We,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1mjnzn5"&&(Se.innerHTML=Za),ca=o(We),He=s(We,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1iitlg5"&&(He.innerHTML=Ra),We.forEach(a),Ut=o(e),p($e.$$.fragment,e),Pt=o(e),Ze=s(e,"P",{}),v(Ze).forEach(a),this.h()},h(){b(O,"name","hf:doc:metadata"),b(O,"content",nn),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,O),l(e,Re,t),l(e,Qe,t),l(e,Xe,t),h(N,e,t),l(e,Ge,t),l(e,q,t),l(e,Ve,t),l(e,F,t),l(e,Ye,t),h(L,e,t),l(e,Ke,t),l(e,E,t),l(e,et,t),h(z,e,t),l(e,tt,t),l(e,S,t),l(e,at,t),h(H,e,t),l(e,nt,t),l(e,B,t),l(e,ot,t),l(e,D,t),l(e,lt,t),l(e,W,t),l(e,rt,t),h(Q,e,t),l(e,it,t),l(e,Z,t),l(e,st,t),h(R,e,t),l(e,dt,t),l(e,X,t),l(e,mt,t),h(G,e,t),l(e,ct,t),l(e,V,t),l(e,pt,t),h(Y,e,t),l(e,ht,t),l(e,K,t),l(e,gt,t),h(ee,e,t),l(e,ut,t),h(te,e,t),l(e,ft,t),l(e,ae,t),l(e,_t,t),l(e,ne,t),l(e,vt,t),l(e,oe,t),l(e,bt,t),h(le,e,t),l(e,Mt,t),l(e,re,t),l(e,Ct,t),l(e,ie,t),l(e,yt,t),h(se,e,t),l(e,Tt,t),l(e,de,t),l(e,wt,t),l(e,me,t),l(e,$t,t),h(ce,e,t),l(e,Ot,t),l(e,m,t),h(pe,m,null),r(m,Et),r(m,Oe),r(m,zt),r(m,x),h(he,x,null),r(x,St),r(x,xe),r(m,Ht),r(m,w),h(ge,w,null),r(w,Bt),r(w,je),r(w,Dt),r(w,Ue),r(m,Wt),r(m,j),h(ue,j,null),r(j,Qt),r(j,Pe),r(m,Zt),r(m,U),h(fe,U,null),r(U,Rt),r(U,Je),r(m,Xt),r(m,$),h(_e,$,null),r($,Gt),r($,Ie),r($,Vt),r($,ke),r(m,Yt),r(m,P),h(ve,P,null),r(P,Kt),r(P,Ae),r(m,ea),r(m,J),h(be,J,null),r(J,ta),r(J,Ne),r(m,aa),r(m,I),h(Me,I,null),r(I,na),r(I,qe),r(m,oa),r(m,k),h(Ce,k,null),r(k,la),r(k,Fe),r(m,ra),r(m,M),h(ye,M,null),r(M,ia),r(M,Le),r(M,sa),r(M,Ee),r(M,da),r(M,ze),l(e,xt,t),h(Te,e,t),l(e,jt,t),l(e,y,t),h(we,y,null),r(y,ma),r(y,Se),r(y,ca),r(y,He),l(e,Ut,t),h($e,e,t),l(e,Pt,t),l(e,Ze,t),Jt=!0},p:Ga,i(e){Jt||(g(N.$$.fragment,e),g(L.$$.fragment,e),g(z.$$.fragment,e),g(H.$$.fragment,e),g(Q.$$.fragment,e),g(R.$$.fragment,e),g(G.$$.fragment,e),g(Y.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(se.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(Ce.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),Jt=!0)},o(e){u(N.$$.fragment,e),u(L.$$.fragment,e),u(z.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(Ce.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),Jt=!1},d(e){e&&(a(Re),a(Qe),a(Xe),a(Ge),a(q),a(Ve),a(F),a(Ye),a(Ke),a(E),a(et),a(tt),a(S),a(at),a(nt),a(B),a(ot),a(D),a(lt),a(W),a(rt),a(it),a(Z),a(st),a(dt),a(X),a(mt),a(ct),a(V),a(pt),a(ht),a(K),a(gt),a(ut),a(ft),a(ae),a(_t),a(ne),a(vt),a(oe),a(bt),a(Mt),a(re),a(Ct),a(ie),a(yt),a(Tt),a(de),a(wt),a(me),a($t),a(Ot),a(m),a(xt),a(jt),a(y),a(Ut),a(Pt),a(Ze)),a(O),f(N,e),f(L,e),f(z,e),f(H,e),f(Q,e),f(R,e),f(G,e),f(Y,e),f(ee,e),f(te,e),f(le,e),f(se,e),f(ce,e),f(pe),f(he),f(ge),f(ue),f(fe),f(_e),f(ve),f(be),f(Me),f(Ce),f(ye),f(Te,e),f(we),f($e,e)}}}const nn='{"title":"CPO Trainer","local":"cpo-trainer","sections":[{"title":"SimPO","local":"simpo","sections":[],"depth":2},{"title":"CPO-SimPO","local":"cpo-simpo","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the CPOTrainer","local":"using-the-cpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2}],"depth":1}';function on(ha){return Va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Ya{constructor(O){super(),Ka(this,O,on,an,Xa,{})}}export{cn as component};
