import{s as ei,o as ti,n as Os}from"../chunks/scheduler.182ea377.js";import{S as li,i as si,g as a,s as i,p as u,A as ii,h as r,f as l,c as n,j as b,q as f,m as o,k as p,v as c,a as s,r as h,d as m,t as d,u as y}from"../chunks/index.008d68e4.js";import{T as Ks}from"../chunks/Tip.4f096367.js";import{I as Y}from"../chunks/IconCopyLink.96bbb92b.js";import{C as g}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as ni}from"../chunks/DocNotebookDropdown.bb388256.js";function ai(Ke){let M,J='💡 If you don’t have access to a GPU, you can use one for free from a GPU provider like <a href="https://colab.research.google.com/" rel="nofollow">Colab</a>!';return{c(){M=a("p"),M.innerHTML=J},l(w){M=r(w,"P",{"data-svelte-h":!0}),o(M)!=="svelte-5o248f"&&(M.innerHTML=J)},m(w,v){s(w,M,v)},p:Os,d(w){w&&l(M)}}}function ri(Ke){let M,J="💡 We strongly suggest always running your pipelines in <code>float16</code>, and so far, we’ve rarely seen any degradation in output quality.";return{c(){M=a("p"),M.innerHTML=J},l(w){M=r(w,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1i2b108"&&(M.innerHTML=J)},m(w,v){s(w,M,v)},p:Os,d(w){w&&l(M)}}}function oi(Ke){let M,J,w,v,rt,P,Il,Oe,Ql="Effective and efficient diffusion",yt,F,Mt,A,El='Getting the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to generate images in a certain style or include what you want can be tricky. Often times, you have to run the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> several times before you end up with an image you’re happy with. But generating something out of nothing is a computationally intensive process, especially if you’re running inference over and over again.',bt,D,Yl="This is why it’s important to get the most <em>computational</em> (speed) and <em>memory</em> (GPU vRAM) efficiency from the pipeline to reduce the time between inference cycles so you can iterate faster.",wt,q,Pl='This tutorial walks you through how to generate faster and better with the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',gt,K,Fl='Begin by loading the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model:',vt,O,Jt,ee,Al="The example prompt you’ll use is a portrait of an old warrior chief, but feel free to use your own prompt:",Tt,te,Ut,T,k,ot,le,Bl,et,Dl="Speed",Zt,W,jt,se,ql="One of the simplest ways to speed up inference is to place the pipeline on a GPU the same way you would with any PyTorch module:",Gt,ie,$t,ne,Kl='To make sure you can use the same image and improve on it, use a <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> and set a seed for <a href="./using-diffusers/reproducibility">reproducibility</a>:',_t,ae,kt,re,Ol="Now you can generate an image:",Wt,oe,Ct,C,es='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',Vt,pe,ts='This process took ~30 seconds on a T4 GPU (it might be faster if your allocated GPU is better than a T4). By default, the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> runs inference with full <code>float32</code> precision for 50 inference steps. You can speed this up by switching to a lower precision like <code>float16</code> or running fewer inference steps.',xt,ce,ls="Let’s start by loading the model in <code>float16</code> and generate an image:",Ht,ue,It,V,ss='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',Bt,fe,is="This time, it only took ~11 seconds to generate the image, which is almost 3x faster than before!",Xt,x,Nt,he,ns='Another option is to reduce the number of inference steps. Choosing a more efficient scheduler could help decrease the number of steps without sacrificing output quality. You can find which schedulers are compatible with the current model in the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> by calling the <code>compatibles</code> method:',Rt,me,St,de,as='The Stable Diffusion model uses the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> by default which usually requires ~50 inference steps, but more performant schedulers like <a href="/docs/diffusers/v0.25.0/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>, require only ~20 or 25 inference steps. Use the <a href="/docs/diffusers/v0.25.0/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method to load a new scheduler:',Lt,ye,zt,Me,rs="Now set the <code>num_inference_steps</code> to 20:",Qt,be,Et,H,os='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',Yt,we,ps="Great, you’ve managed to cut the inference time to just 4 seconds! ⚡️",Pt,U,I,pt,ge,Xl,tt,cs="Memory",Ft,ve,us="The other key to improving pipeline performance is consuming less memory, which indirectly implies more speed, since you’re often trying to maximize the number of images generated per second. The easiest way to see how many images you can generate at once is to try out different batch sizes until you get an <code>OutOfMemoryError</code> (OOM).",At,Je,fs="Create a function that’ll generate a batch of images from a list of prompts and <code>Generators</code>. Make sure to assign each <code>Generator</code> a seed so you can reuse it if it produces a good result.",Dt,Te,qt,Ue,hs="Start with <code>batch_size=4</code> and see how much memory you’ve consumed:",Kt,Ze,Ot,je,ms='Unless you have a GPU with more vRAM, the code above probably returned an <code>OOM</code> error! Most of the memory is taken up by the cross-attention layers. Instead of running this operation in a batch, you can run it sequentially to save a significant amount of memory. All you have to do is configure the pipeline to use the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing">enable_attention_slicing()</a> function:',el,Ge,tl,$e,ds="Now try increasing the <code>batch_size</code> to 8!",ll,_e,sl,B,ys='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',il,ke,Ms="Whereas before you couldn’t even generate a batch of 4 images, now you can generate a batch of 8 images at ~3.5 seconds per image! This is probably the fastest you can go on a T4 GPU without sacrificing quality.",nl,Z,X,ct,We,Nl,lt,bs="Quality",al,Ce,ws="In the last two sections, you learned how to optimize the speed of your pipeline by using <code>fp16</code>, reducing the number of inference steps by using a more performant scheduler, and enabling attention slicing to reduce memory consumption. Now you’re going to focus on how to improve the quality of generated images.",rl,j,N,ut,Ve,Rl,st,gs="Better checkpoints",ol,xe,vs='The most obvious step is to use better checkpoints. The Stable Diffusion model is a good starting point, and since its official launch, several improved versions have also been released. However, using a newer version doesn’t automatically mean you’ll get better results. You’ll still have to experiment with different checkpoints yourself, and do a little research (such as using <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a>) to get the best results.',pl,He,Js='As the field grows, there are more and more high-quality checkpoints finetuned to produce certain styles. Try exploring the <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a> and <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a> to find one you’re interested in!',cl,G,R,ft,Ie,Sl,it,Ts="Better pipeline components",ul,Be,Us='You can also try replacing the current pipeline components with a newer version. Let’s try loading the latest <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autoencoder</a> from Stability AI into the pipeline, and generate some images:',fl,Xe,hl,S,Zs='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',ml,$,L,ht,Ne,Ll,nt,js="Better prompt engineering",dl,Re,Gs="The text prompt you use to generate an image is super important, so much so that it is called <em>prompt engineering</em>. Some considerations to keep during prompt engineering are:",yl,Se,$s="<li>How is the image or similar images of the one I want to generate stored on the internet?</li> <li>What additional detail can I give that steers the model towards the style I want?</li>",Ml,Le,_s="With this in mind, let’s improve the prompt to include color and higher quality details:",bl,ze,wl,Qe,ks="Generate a batch of images with the new prompt:",gl,Ee,vl,z,Ws='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Jl,Ye,Cs="Pretty impressive! Let’s tweak the second image - corresponding to the <code>Generator</code> with a seed of <code>1</code> - a bit more by adding some text about the age of the subject:",Tl,Pe,Ul,Q,Vs='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Zl,_,E,mt,Fe,zl,at,xs="Next steps",jl,Ae,Hs='In this tutorial, you learned how to optimize a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for computational and memory efficiency as well as improving the quality of generated outputs. If you’re interested in making your pipeline even faster, take a look at the following resources:',Gl,De,Is='<li>Learn how <a href="./optimization/torch2.0">PyTorch 2.0</a> and <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> can yield 5 - 300% faster inference speed. On an A100 GPU, inference can be up to 50% faster!</li> <li>If you can’t use PyTorch 2, we recommend you install <a href="./optimization/xformers">xFormers</a>. Its memory-efficient attention mechanism works great with PyTorch 1.13.1 for faster speed and reduced memory consumption.</li> <li>Other optimization techniques, such as model offloading, are covered in <a href="./optimization/fp16">this guide</a>.</li>',$l;return P=new Y({}),F=new ni({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"}]}}),O=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`}}),te=new g({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>'}}),le=new Y({}),W=new Ks({props:{$$slots:{default:[ai]},$$scope:{ctx:Ke}}}),ie=new g({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)'}}),ae=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`}}),oe=new g({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`}}),ue=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`}}),x=new Ks({props:{$$slots:{default:[ri]},$$scope:{ctx:Ke}}}),me=new g({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnV0aWxzLmR1bW15X3RvcmNoX2FuZF90b3JjaHNkZV9vYmplY3RzLkRQTVNvbHZlclNERVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfaGV1bl9kaXNjcmV0ZS5IZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3BuZG0uUE5ETVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZXVsZXJfYW5jZXN0cmFsX2Rpc2NyZXRlLkV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkaW0uRERJTVNjaGVkdWxlciUyQyUwQSU1RA==",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.utils.dummy_torch_and_torchsde_objects.DPMSolverSDEScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`}}),ye=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`}}),be=new g({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`}}),ge=new Y({}),Te=new g({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`}}),Ze=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`}}),Ge=new g({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()"}}),_e=new g({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`}}),We=new Y({}),Ve=new Y({}),Ie=new Y({}),Xe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`}}),Ne=new Y({}),ze=new g({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`}}),Ee=new g({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`}}),Pe=new g({props:{code:"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",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`}}),Fe=new Y({}),{c(){M=a("meta"),J=i(),w=a("h1"),v=a("a"),rt=a("span"),u(P.$$.fragment),Il=i(),Oe=a("span"),Oe.textContent=Ql,yt=i(),u(F.$$.fragment),Mt=i(),A=a("p"),A.innerHTML=El,bt=i(),D=a("p"),D.innerHTML=Yl,wt=i(),q=a("p"),q.innerHTML=Pl,gt=i(),K=a("p"),K.innerHTML=Fl,vt=i(),u(O.$$.fragment),Jt=i(),ee=a("p"),ee.textContent=Al,Tt=i(),u(te.$$.fragment),Ut=i(),T=a("h2"),k=a("a"),ot=a("span"),u(le.$$.fragment),Bl=i(),et=a("span"),et.textContent=Dl,Zt=i(),u(W.$$.fragment),jt=i(),se=a("p"),se.textContent=ql,Gt=i(),u(ie.$$.fragment),$t=i(),ne=a("p"),ne.innerHTML=Kl,_t=i(),u(ae.$$.fragment),kt=i(),re=a("p"),re.textContent=Ol,Wt=i(),u(oe.$$.fragment),Ct=i(),C=a("div"),C.innerHTML=es,Vt=i(),pe=a("p"),pe.innerHTML=ts,xt=i(),ce=a("p"),ce.innerHTML=ls,Ht=i(),u(ue.$$.fragment),It=i(),V=a("div"),V.innerHTML=ss,Bt=i(),fe=a("p"),fe.textContent=is,Xt=i(),u(x.$$.fragment),Nt=i(),he=a("p"),he.innerHTML=ns,Rt=i(),u(me.$$.fragment),St=i(),de=a("p"),de.innerHTML=as,Lt=i(),u(ye.$$.fragment),zt=i(),Me=a("p"),Me.innerHTML=rs,Qt=i(),u(be.$$.fragment),Et=i(),H=a("div"),H.innerHTML=os,Yt=i(),we=a("p"),we.textContent=ps,Pt=i(),U=a("h2"),I=a("a"),pt=a("span"),u(ge.$$.fragment),Xl=i(),tt=a("span"),tt.textContent=cs,Ft=i(),ve=a("p"),ve.innerHTML=us,At=i(),Je=a("p"),Je.innerHTML=fs,Dt=i(),u(Te.$$.fragment),qt=i(),Ue=a("p"),Ue.innerHTML=hs,Kt=i(),u(Ze.$$.fragment),Ot=i(),je=a("p"),je.innerHTML=ms,el=i(),u(Ge.$$.fragment),tl=i(),$e=a("p"),$e.innerHTML=ds,ll=i(),u(_e.$$.fragment),sl=i(),B=a("div"),B.innerHTML=ys,il=i(),ke=a("p"),ke.textContent=Ms,nl=i(),Z=a("h2"),X=a("a"),ct=a("span"),u(We.$$.fragment),Nl=i(),lt=a("span"),lt.textContent=bs,al=i(),Ce=a("p"),Ce.innerHTML=ws,rl=i(),j=a("h3"),N=a("a"),ut=a("span"),u(Ve.$$.fragment),Rl=i(),st=a("span"),st.textContent=gs,ol=i(),xe=a("p"),xe.innerHTML=vs,pl=i(),He=a("p"),He.innerHTML=Js,cl=i(),G=a("h3"),R=a("a"),ft=a("span"),u(Ie.$$.fragment),Sl=i(),it=a("span"),it.textContent=Ts,ul=i(),Be=a("p"),Be.innerHTML=Us,fl=i(),u(Xe.$$.fragment),hl=i(),S=a("div"),S.innerHTML=Zs,ml=i(),$=a("h3"),L=a("a"),ht=a("span"),u(Ne.$$.fragment),Ll=i(),nt=a("span"),nt.textContent=js,dl=i(),Re=a("p"),Re.innerHTML=Gs,yl=i(),Se=a("ul"),Se.innerHTML=$s,Ml=i(),Le=a("p"),Le.textContent=_s,bl=i(),u(ze.$$.fragment),wl=i(),Qe=a("p"),Qe.textContent=ks,gl=i(),u(Ee.$$.fragment),vl=i(),z=a("div"),z.innerHTML=Ws,Jl=i(),Ye=a("p"),Ye.innerHTML=Cs,Tl=i(),u(Pe.$$.fragment),Ul=i(),Q=a("div"),Q.innerHTML=Vs,Zl=i(),_=a("h2"),E=a("a"),mt=a("span"),u(Fe.$$.fragment),zl=i(),at=a("span"),at.textContent=xs,jl=i(),Ae=a("p"),Ae.innerHTML=Hs,Gl=i(),De=a("ul"),De.innerHTML=Is,this.h()},l(e){const t=ii("svelte-1phssyn",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),w=r(e,"H1",{class:!0});var qe=b(w);v=r(qe,"A",{id:!0,class:!0,href:!0});var dt=b(v);rt=r(dt,"SPAN",{});var Bs=b(rt);f(P.$$.fragment,Bs),Bs.forEach(l),dt.forEach(l),Il=n(qe),Oe=r(qe,"SPAN",{"data-svelte-h":!0}),o(Oe)!=="svelte-yud11f"&&(Oe.textContent=Ql),qe.forEach(l),yt=n(e),f(F.$$.fragment,e),Mt=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-hvets1"&&(A.innerHTML=El),bt=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1s9blmo"&&(D.innerHTML=Yl),wt=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-7j3qfz"&&(q.innerHTML=Pl),gt=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-rvt2dy"&&(K.innerHTML=Fl),vt=n(e),f(O.$$.fragment,e),Jt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-10ouxny"&&(ee.textContent=Al),Tt=n(e),f(te.$$.fragment,e),Ut=n(e),T=r(e,"H2",{class:!0});var _l=b(T);k=r(_l,"A",{id:!0,class:!0,href:!0});var Xs=b(k);ot=r(Xs,"SPAN",{});var Ns=b(ot);f(le.$$.fragment,Ns),Ns.forEach(l),Xs.forEach(l),Bl=n(_l),et=r(_l,"SPAN",{"data-svelte-h":!0}),o(et)!=="svelte-1cig2rs"&&(et.textContent=Dl),_l.forEach(l),Zt=n(e),f(W.$$.fragment,e),jt=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-kanimh"&&(se.textContent=ql),Gt=n(e),f(ie.$$.fragment,e),$t=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-13gt4wm"&&(ne.innerHTML=Kl),_t=n(e),f(ae.$$.fragment,e),kt=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-fvhhns"&&(re.textContent=Ol),Wt=n(e),f(oe.$$.fragment,e),Ct=n(e),C=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1of5nwm"&&(C.innerHTML=es),Vt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1nfod2a"&&(pe.innerHTML=ts),xt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-11ahf9b"&&(ce.innerHTML=ls),Ht=n(e),f(ue.$$.fragment,e),It=n(e),V=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(V)!=="svelte-1why3l7"&&(V.innerHTML=ss),Bt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-19ensh2"&&(fe.textContent=is),Xt=n(e),f(x.$$.fragment,e),Nt=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1l8fsx3"&&(he.innerHTML=ns),Rt=n(e),f(me.$$.fragment,e),St=n(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-6zt6h3"&&(de.innerHTML=as),Lt=n(e),f(ye.$$.fragment,e),zt=n(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-cj4zg7"&&(Me.innerHTML=rs),Qt=n(e),f(be.$$.fragment,e),Et=n(e),H=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(H)!=="svelte-19w49w4"&&(H.innerHTML=os),Yt=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-t554e8"&&(we.textContent=ps),Pt=n(e),U=r(e,"H2",{class:!0});var kl=b(U);I=r(kl,"A",{id:!0,class:!0,href:!0});var Rs=b(I);pt=r(Rs,"SPAN",{});var Ss=b(pt);f(ge.$$.fragment,Ss),Ss.forEach(l),Rs.forEach(l),Xl=n(kl),tt=r(kl,"SPAN",{"data-svelte-h":!0}),o(tt)!=="svelte-1cp1nrg"&&(tt.textContent=cs),kl.forEach(l),Ft=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-xwat8v"&&(ve.innerHTML=us),At=n(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-ubghtf"&&(Je.innerHTML=fs),Dt=n(e),f(Te.$$.fragment,e),qt=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-136nem1"&&(Ue.innerHTML=hs),Kt=n(e),f(Ze.$$.fragment,e),Ot=n(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1whi0rb"&&(je.innerHTML=ms),el=n(e),f(Ge.$$.fragment,e),tl=n(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1kyeye"&&($e.innerHTML=ds),ll=n(e),f(_e.$$.fragment,e),sl=n(e),B=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(B)!=="svelte-vxa9bu"&&(B.innerHTML=ys),il=n(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-8y2h2l"&&(ke.textContent=Ms),nl=n(e),Z=r(e,"H2",{class:!0});var Wl=b(Z);X=r(Wl,"A",{id:!0,class:!0,href:!0});var Ls=b(X);ct=r(Ls,"SPAN",{});var zs=b(ct);f(We.$$.fragment,zs),zs.forEach(l),Ls.forEach(l),Nl=n(Wl),lt=r(Wl,"SPAN",{"data-svelte-h":!0}),o(lt)!=="svelte-1y24azy"&&(lt.textContent=bs),Wl.forEach(l),al=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-nie66e"&&(Ce.innerHTML=ws),rl=n(e),j=r(e,"H3",{class:!0});var Cl=b(j);N=r(Cl,"A",{id:!0,class:!0,href:!0});var Qs=b(N);ut=r(Qs,"SPAN",{});var Es=b(ut);f(Ve.$$.fragment,Es),Es.forEach(l),Qs.forEach(l),Rl=n(Cl),st=r(Cl,"SPAN",{"data-svelte-h":!0}),o(st)!=="svelte-i2thvq"&&(st.textContent=gs),Cl.forEach(l),ol=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-n6uci0"&&(xe.innerHTML=vs),pl=n(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1m9vwtz"&&(He.innerHTML=Js),cl=n(e),G=r(e,"H3",{class:!0});var Vl=b(G);R=r(Vl,"A",{id:!0,class:!0,href:!0});var Ys=b(R);ft=r(Ys,"SPAN",{});var Ps=b(ft);f(Ie.$$.fragment,Ps),Ps.forEach(l),Ys.forEach(l),Sl=n(Vl),it=r(Vl,"SPAN",{"data-svelte-h":!0}),o(it)!=="svelte-ukuisd"&&(it.textContent=Ts),Vl.forEach(l),ul=n(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-ss65n0"&&(Be.innerHTML=Us),fl=n(e),f(Xe.$$.fragment,e),hl=n(e),S=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(S)!=="svelte-610rhb"&&(S.innerHTML=Zs),ml=n(e),$=r(e,"H3",{class:!0});var xl=b($);L=r(xl,"A",{id:!0,class:!0,href:!0});var Fs=b(L);ht=r(Fs,"SPAN",{});var As=b(ht);f(Ne.$$.fragment,As),As.forEach(l),Fs.forEach(l),Ll=n(xl),nt=r(xl,"SPAN",{"data-svelte-h":!0}),o(nt)!=="svelte-6r9yl8"&&(nt.textContent=js),xl.forEach(l),dl=n(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1cdb512"&&(Re.innerHTML=Gs),yl=n(e),Se=r(e,"UL",{"data-svelte-h":!0}),o(Se)!=="svelte-o0cjrb"&&(Se.innerHTML=$s),Ml=n(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-dljusi"&&(Le.textContent=_s),bl=n(e),f(ze.$$.fragment,e),wl=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-11z4mci"&&(Qe.textContent=ks),gl=n(e),f(Ee.$$.fragment,e),vl=n(e),z=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(z)!=="svelte-n1o5lk"&&(z.innerHTML=Ws),Jl=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-fmxgeo"&&(Ye.innerHTML=Cs),Tl=n(e),f(Pe.$$.fragment,e),Ul=n(e),Q=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Q)!=="svelte-1lkw2bx"&&(Q.innerHTML=Vs),Zl=n(e),_=r(e,"H2",{class:!0});var Hl=b(_);E=r(Hl,"A",{id:!0,class:!0,href:!0});var Ds=b(E);mt=r(Ds,"SPAN",{});var qs=b(mt);f(Fe.$$.fragment,qs),qs.forEach(l),Ds.forEach(l),zl=n(Hl),at=r(Hl,"SPAN",{"data-svelte-h":!0}),o(at)!=="svelte-pr7lub"&&(at.textContent=xs),Hl.forEach(l),jl=n(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-zr0a9t"&&(Ae.innerHTML=Hs),Gl=n(e),De=r(e,"UL",{"data-svelte-h":!0}),o(De)!=="svelte-1vrqfkr"&&(De.innerHTML=Is),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",JSON.stringify(pi)),p(v,"id","effective-and-efficient-diffusion"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#effective-and-efficient-diffusion"),p(w,"class","relative group"),p(k,"id","speed"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#speed"),p(T,"class","relative group"),p(C,"class","flex justify-center"),p(V,"class","flex justify-center"),p(H,"class","flex justify-center"),p(I,"id","memory"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#memory"),p(U,"class","relative group"),p(B,"class","flex justify-center"),p(X,"id","quality"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#quality"),p(Z,"class","relative group"),p(N,"id","better-checkpoints"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#better-checkpoints"),p(j,"class","relative group"),p(R,"id","better-pipeline-components"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#better-pipeline-components"),p(G,"class","relative group"),p(S,"class","flex justify-center"),p(L,"id","better-prompt-engineering"),p(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(L,"href","#better-prompt-engineering"),p($,"class","relative group"),p(z,"class","flex justify-center"),p(Q,"class","flex justify-center"),p(E,"id","next-steps"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#next-steps"),p(_,"class","relative group")},m(e,t){c(document.head,M),s(e,J,t),s(e,w,t),c(w,v),c(v,rt),h(P,rt,null),c(w,Il),c(w,Oe),s(e,yt,t),h(F,e,t),s(e,Mt,t),s(e,A,t),s(e,bt,t),s(e,D,t),s(e,wt,t),s(e,q,t),s(e,gt,t),s(e,K,t),s(e,vt,t),h(O,e,t),s(e,Jt,t),s(e,ee,t),s(e,Tt,t),h(te,e,t),s(e,Ut,t),s(e,T,t),c(T,k),c(k,ot),h(le,ot,null),c(T,Bl),c(T,et),s(e,Zt,t),h(W,e,t),s(e,jt,t),s(e,se,t),s(e,Gt,t),h(ie,e,t),s(e,$t,t),s(e,ne,t),s(e,_t,t),h(ae,e,t),s(e,kt,t),s(e,re,t),s(e,Wt,t),h(oe,e,t),s(e,Ct,t),s(e,C,t),s(e,Vt,t),s(e,pe,t),s(e,xt,t),s(e,ce,t),s(e,Ht,t),h(ue,e,t),s(e,It,t),s(e,V,t),s(e,Bt,t),s(e,fe,t),s(e,Xt,t),h(x,e,t),s(e,Nt,t),s(e,he,t),s(e,Rt,t),h(me,e,t),s(e,St,t),s(e,de,t),s(e,Lt,t),h(ye,e,t),s(e,zt,t),s(e,Me,t),s(e,Qt,t),h(be,e,t),s(e,Et,t),s(e,H,t),s(e,Yt,t),s(e,we,t),s(e,Pt,t),s(e,U,t),c(U,I),c(I,pt),h(ge,pt,null),c(U,Xl),c(U,tt),s(e,Ft,t),s(e,ve,t),s(e,At,t),s(e,Je,t),s(e,Dt,t),h(Te,e,t),s(e,qt,t),s(e,Ue,t),s(e,Kt,t),h(Ze,e,t),s(e,Ot,t),s(e,je,t),s(e,el,t),h(Ge,e,t),s(e,tl,t),s(e,$e,t),s(e,ll,t),h(_e,e,t),s(e,sl,t),s(e,B,t),s(e,il,t),s(e,ke,t),s(e,nl,t),s(e,Z,t),c(Z,X),c(X,ct),h(We,ct,null),c(Z,Nl),c(Z,lt),s(e,al,t),s(e,Ce,t),s(e,rl,t),s(e,j,t),c(j,N),c(N,ut),h(Ve,ut,null),c(j,Rl),c(j,st),s(e,ol,t),s(e,xe,t),s(e,pl,t),s(e,He,t),s(e,cl,t),s(e,G,t),c(G,R),c(R,ft),h(Ie,ft,null),c(G,Sl),c(G,it),s(e,ul,t),s(e,Be,t),s(e,fl,t),h(Xe,e,t),s(e,hl,t),s(e,S,t),s(e,ml,t),s(e,$,t),c($,L),c(L,ht),h(Ne,ht,null),c($,Ll),c($,nt),s(e,dl,t),s(e,Re,t),s(e,yl,t),s(e,Se,t),s(e,Ml,t),s(e,Le,t),s(e,bl,t),h(ze,e,t),s(e,wl,t),s(e,Qe,t),s(e,gl,t),h(Ee,e,t),s(e,vl,t),s(e,z,t),s(e,Jl,t),s(e,Ye,t),s(e,Tl,t),h(Pe,e,t),s(e,Ul,t),s(e,Q,t),s(e,Zl,t),s(e,_,t),c(_,E),c(E,mt),h(Fe,mt,null),c(_,zl),c(_,at),s(e,jl,t),s(e,Ae,t),s(e,Gl,t),s(e,De,t),$l=!0},p(e,[t]){const qe={};t&2&&(qe.$$scope={dirty:t,ctx:e}),W.$set(qe);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),x.$set(dt)},i(e){$l||(m(P.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(W.$$.fragment,e),m(ie.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(ue.$$.fragment,e),m(x.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(ge.$$.fragment,e),m(Te.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(_e.$$.fragment,e),m(We.$$.fragment,e),m(Ve.$$.fragment,e),m(Ie.$$.fragment,e),m(Xe.$$.fragment,e),m(Ne.$$.fragment,e),m(ze.$$.fragment,e),m(Ee.$$.fragment,e),m(Pe.$$.fragment,e),m(Fe.$$.fragment,e),$l=!0)},o(e){d(P.$$.fragment,e),d(F.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(W.$$.fragment,e),d(ie.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(ue.$$.fragment,e),d(x.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(ge.$$.fragment,e),d(Te.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(_e.$$.fragment,e),d(We.$$.fragment,e),d(Ve.$$.fragment,e),d(Ie.$$.fragment,e),d(Xe.$$.fragment,e),d(Ne.$$.fragment,e),d(ze.$$.fragment,e),d(Ee.$$.fragment,e),d(Pe.$$.fragment,e),d(Fe.$$.fragment,e),$l=!1},d(e){e&&(l(J),l(w),l(yt),l(Mt),l(A),l(bt),l(D),l(wt),l(q),l(gt),l(K),l(vt),l(Jt),l(ee),l(Tt),l(Ut),l(T),l(Zt),l(jt),l(se),l(Gt),l($t),l(ne),l(_t),l(kt),l(re),l(Wt),l(Ct),l(C),l(Vt),l(pe),l(xt),l(ce),l(Ht),l(It),l(V),l(Bt),l(fe),l(Xt),l(Nt),l(he),l(Rt),l(St),l(de),l(Lt),l(zt),l(Me),l(Qt),l(Et),l(H),l(Yt),l(we),l(Pt),l(U),l(Ft),l(ve),l(At),l(Je),l(Dt),l(qt),l(Ue),l(Kt),l(Ot),l(je),l(el),l(tl),l($e),l(ll),l(sl),l(B),l(il),l(ke),l(nl),l(Z),l(al),l(Ce),l(rl),l(j),l(ol),l(xe),l(pl),l(He),l(cl),l(G),l(ul),l(Be),l(fl),l(hl),l(S),l(ml),l($),l(dl),l(Re),l(yl),l(Se),l(Ml),l(Le),l(bl),l(wl),l(Qe),l(gl),l(vl),l(z),l(Jl),l(Ye),l(Tl),l(Ul),l(Q),l(Zl),l(_),l(jl),l(Ae),l(Gl),l(De)),l(M),y(P),y(F,e),y(O,e),y(te,e),y(le),y(W,e),y(ie,e),y(ae,e),y(oe,e),y(ue,e),y(x,e),y(me,e),y(ye,e),y(be,e),y(ge),y(Te,e),y(Ze,e),y(Ge,e),y(_e,e),y(We),y(Ve),y(Ie),y(Xe,e),y(Ne),y(ze,e),y(Ee,e),y(Pe,e),y(Fe)}}}const pi={local:"effective-and-efficient-diffusion",sections:[{local:"speed",title:"Speed"},{local:"memory",title:"Memory"},{local:"quality",sections:[{local:"better-checkpoints",title:"Better checkpoints"},{local:"better-pipeline-components",title:"Better pipeline components"},{local:"better-prompt-engineering",title:"Better prompt engineering"}],title:"Quality"},{local:"next-steps",title:"Next steps"}],title:"Effective and efficient diffusion"};function ci(Ke){return ti(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mi extends li{constructor(M){super(),si(this,M,ci,oi,ei,{})}}export{Mi as component};
