import{s as vt,f as Gl,n as ft,o as gt}from"../chunks/scheduler.37c15a92.js";import{S as Ct,i as Bt,g as i,s as n,r as u,A as Zt,h as o,f as t,c as a,j as Vl,u as c,x as r,k as p,y as Gt,a as s,v as m,d as y,t as J,w as d}from"../chunks/index.2bf4358c.js";import{C as Zl}from"../chunks/CodeBlock.4e987730.js";import{H as je}from"../chunks/Heading.8ada512a.js";import{E as Vt}from"../chunks/getInferenceSnippets.54ddb825.js";function zt(zl){let T,Ie,Ue,he,w,ve,j,Wl="Dans la section précédente, nous avons appris comment créer des agents à partir de zéro en utilisant du code Python, et nous avons <strong>vu à quel point ce processus peut être fastidieux</strong>. Heureusement, de nombreuses bibliothèques d’agents simplifient ce travail en <strong>se chargeant de la majeure partie du travail lourd pour vous</strong>.",fe,U,xl="Dans ce tutoriel, <strong>vous allez créer votre tout premier agent</strong> capable d’exécuter des actions telles que la génération d’images, la recherche sur le web, la vérification de fuseaux horaires et bien plus encore !",ge,b,Al="Vous publierez également votre agent <strong>sur un <em>Space</em> Hugging Face afin de le partager avec vos amis et collègues</strong>.",Ce,I,_l="C’est parti !",Be,h,Ze,v,El,Ge,f,Hl="Pour créer cet agent, nous allons utiliser <code>smolagents</code>, une bibliothèque qui <strong>fournit un cadre facilitant le développement d’agents</strong>.",Ve,g,Ql="Cette bibliothèque légère est conçue pour être simple, tout en masquant une grande partie de la complexité liée à la construction d’un agent, permettant ainsi de vous concentrer sur la conception du comportement de l’agent.",ze,C,Sl='Nous approfondirons smolagents dans la prochaine unité. En attendant, vous pouvez également consulter cet <a href="https://huggingface.co/blog/smolagents" target="_blank">article de blog</a> ou le <a href="https://github.com/huggingface/smolagents" target="_blank">dépôt GitHub</a> de la bibliothèque.',We,B,Rl="Brièvement, <code>smolagents</code> est une bibliothèque se concentrant sur les <strong>agents générant du code</strong> (via la classe <code>CodeAgent</code>), un type d’agent qui exécute des <strong>“actions”</strong> via des blocs de code, puis <strong>“observe”</strong> les résultats en exécutant le code.",xe,Z,kl="Voici un exemple de ce que nous allons construire !",Ae,G,Xl="Nous avons équipé notre agent d’un <strong>outil de génération d’images</strong> et lui avons demandé de générer une image d’un chat.",_e,V,Nl="L’agent dans <code>smolagents</code> aura les <strong>mêmes comportements que celui personnalisé que nous avons construit précédemment</strong> : il va <strong>réfléchir, agir et observer cycliquement</strong> jusqu’à parvenir à une réponse finale :",Ee,M,ql,He,z,Fl="Excitant, n’est-ce pas ?",Qe,W,Se,x,Ll='Pour commencer, dupliquez ce <em>Space</em> : <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',Re,A,$l='<p>Merci à <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> pour ce patron ! 🙌</p>',ke,_,Yl="Dupliquer signifie <strong>créer une copie locale sur votre propre profil</strong> :",Xe,E,Pl,Ne,H,Dl="Après la duplication, vous devrez ajouter votre <em>token</em> d’API Hugging Face pour que votre agent puisse accéder à l’API du modèle :",qe,Q,Kl='<li>Tout d’abord, obtenez votre <em>token</em> Hugging Face sur <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a> avec la permission d’inférer, si vous n’en avez pas déjà un.</li> <li>Allez dans votre <em>Space</em> dupliqué et cliquez sur l’onglet <strong>Settings</strong>.</li> <li>Descendez jusqu’à la section <strong>Variables and Secrets</strong> et cliquez sur <strong>New Secret</strong>.</li> <li>Créez un secret avec le nom <code>HF_TOKEN</code> et collez votre token comme valeur.</li> <li>Cliquez sur <strong>Save</strong> pour stocker votre <em>token</em> en toute sécurité.</li>',Fe,S,Ol='Tout au long de cette leçon, le seul fichier (actuellement incomplet) que vous aurez à modifier est le <strong>“app.py”</strong>. Vous pouvez consulter l’<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original ici</a>. Pour trouver le vôtre, allez dans votre copie du <em>Space</em>, cliquez sur l’onglet <code>Files</code> puis sur <code>app.py</code> dans la liste des répertoires.',Le,R,et="Analysons le code ensemble :",$e,k,lt="<li>Le fichier commence par quelques importations de bibliothèques simples mais nécessaires</li>",Ye,X,Pe,N,tt="Comme indiqué précédemment, nous utiliserons directement la classe <strong>CodeAgent</strong> de <strong>smolagents</strong>.",De,q,Ke,F,st='Entrons maintenant dans le vif du sujet avec les outils ! Si vous souhaitez un rappel sur les outils, n’hésitez pas à consulter la section <a href="tools">Outils</a> du cours.',Oe,L,el,$,nt="Les outils sont ce que nous vous encourageons à construire dans cette section ! Nous vous donnons deux exemples :",ll,Y,at="<li>Un <strong>outil factice non fonctionnel</strong> que vous pouvez modifier pour créer quelque chose d’utile.</li> <li>Un <strong>outil réellement fonctionnel</strong> qui récupère l’heure actuelle quelque part dans le monde.</li>",tl,P,it="Pour définir votre outil, il est important de :",sl,D,ot="<li>Fournir des types d’entrée et de sortie pour votre fonction, comme dans <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li>Fournir une <strong>docstring bien formatée</strong>. <code>smolagents</code> s’attend à ce que tous les arguments aient une <strong>description textuelle dans la docstring</strong>.</li>",nl,K,al,O,rt='Il utilise <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> comme moteur LLM. C’est un modèle très performant auquel nous accéderons via l’API <em>serverless</em>.',il,ee,ol,le,Mt="Cet agent utilise toujours l’<code>InferenceClient</code> que nous avons vu dans une section précédente derrière la classe <strong>InferenceClientModel</strong> !",rl,te,pt="Nous fournirons des exemples plus détaillés lors de la présentation du <em>framework</em> dans l’Unité 2. Pour l’instant, vous devez vous concentrer sur <strong>l’ajout de nouveaux outils à la liste des outils</strong> en utilisant le paramètre <code>tools</code> de votre agent.",Ml,se,ut="Par exemple, vous pourriez utiliser <code>DuckDuckGoSearchTool</code> qui a été importé dans la première ligne du code, ou vous pouvez examiner <code>image_generation_tool</code> qui est chargé depuis le Hub plus tard dans le code.",pl,ne,ct="<strong>Ajouter des outils donnera de nouvelles capacités à votre agent</strong>, alors soyez créatif !",ul,ae,cl,ie,mt="Le <em>prompt</em> système de l’agent est stocké dans un fichier <code>prompts.yaml</code> séparé. Ce fichier contient des instructions prédéfinies qui guident le comportement de l’agent.",ml,oe,yt="Le stockage des <em>prompts</em> dans un fichier YAML permet une personnalisation et une réutilisation aisées pour différents agents ou cas d’utilisation.",yl,re,Jt='Vous pouvez consulter la <a href="https://huggingface.co/spaces/agents-course/First_agent_template/tree/main" rel="nofollow">structure des fichiers du <em>Space</em></a> pour voir où se trouve le fichier <code>prompts.yaml</code> et comment il est organisé dans le projet.',Jl,Me,dt="Le fichier complet <strong>“app.py”</strong> :",dl,pe,Tl,ue,Tt="Votre <strong>objectif</strong> est de vous familiariser avec le <em>Space</em> et l’agent.",wl,ce,wt="Actuellement, l’agent dans le patron <strong>n’utilise aucun outil, alors essayez de lui fournir certains des outils préfabriqués ou même de créer de nouveaux outils vous-même !</strong>",jl,me,jt="Nous attendons avec impatience vos incroyables agents dans le canal Discord <strong>#agents-course-showcase</strong>!",Ul,bl,Il,ye,Ut="Félicitations, vous avez construit votre premier Agent ! N’hésitez pas à le partager avec vos amis et collègues.",hl,Je,bt="Comme c’est votre première tentative, il est tout à fait normal qu’il soit un peu bogué ou lent. Dans les unités futures, nous apprendrons à construire de meilleurs agents.",vl,de,It="La meilleure façon d’apprendre est d’essayer, alors n’hésitez pas à le mettre à jour, à ajouter plus d’outils, à essayer avec un autre modèle, etc.",fl,Te,ht="Dans la prochaine section, vous allez remplir le quiz final et obtenir votre certificat !",gl,we,Cl,be,Bl;return w=new je({props:{title:"Créons notre premier agent avec smolagents",local:"créons-notre-premier-agent-avec-smolagents",headingTag:"h1"}}),h=new je({props:{title:"Qu’est-ce que smolagents ?",local:"quest-ce-que-smolagents-",headingTag:"h2"}}),W=new je({props:{title:"Construisons notre agent !",local:"construisons-notre-agent-",headingTag:"h2"}}),X=new Zl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEZpbmFsQW5zd2VyVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml`,wrap:!1}}),q=new je({props:{title:"Les outils",local:"les-outils",headingTag:"h3"}}),L=new Zl({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1: <span class="hljs-built_in">str</span>, arg2: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:  <span class="hljs-comment"># il est important de spécifier le type de retour</span>
    <span class="hljs-comment"># Conservez ce format pour la description de l&#x27;outil et des arguments, mais n&#x27;hésitez pas à modifier l&#x27;outil</span>
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui ne fait encore rien
    Arguments:
        arg1: le premier argument
        arg2: le deuxième argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Quelle magie allez-vous créer ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui récupère l&#x27;heure locale actuelle dans un fuseau horaire spécifié.
    Arguments:
        timezone: Une chaîne représentant un fuseau horaire valide (par exemple, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Créer l&#x27;objet fuseau horaire</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtenir l&#x27;heure actuelle dans ce fuseau horaire</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;L&#x27;heure locale actuelle dans <span class="hljs-subst">{timezone}</span> est : <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Erreur lors de la récupération de l&#x27;heure pour le fuseau horaire &#x27;<span class="hljs-subst">{timezone}</span>&#x27; : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),K=new je({props:{title:"L’agent",local:"lagent",headingTag:"h3"}}),ee=new Zl({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwTm91cyUyMGNyJUMzJUE5b25zJTIwbm90cmUlMjBDb2RlQWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJmaW5hbF9hbnN3ZXIlNUQlMkMlMjAlMjAlMjMlMjBham91dGV6JTIwdm9zJTIwb3V0aWxzJTIwaWNpJTIwKG5lJTIwc3VwcHJpbWV6JTIwcGFzJTIwZmluYWxfYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Nous créons notre CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer],  <span class="hljs-comment"># ajoutez vos outils ici (ne supprimez pas final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ae=new je({props:{title:"Le prompt système",local:"le-prompt-système",headingTag:"h3"}}),pe=new Zl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Voici un exemple d&#x27;un outil qui ne fait encore rien. Épatez-nous avec votre créativité !</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1: <span class="hljs-built_in">str</span>, arg2: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:  <span class="hljs-comment"># il est important de spécifier le type de retour</span>
    <span class="hljs-comment"># Conservez ce format pour la description de l&#x27;outil et des arguments, mais n&#x27;hésitez pas à modifier l&#x27;outil</span>
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui ne fait encore rien
    Arguments:
        arg1: le premier argument
        arg2: le deuxième argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Quelle magie allez-vous créer ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui récupère l&#x27;heure locale actuelle dans un fuseau horaire spécifié.
    Arguments:
        timezone: Une chaîne représentant un fuseau horaire valide (par exemple, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Créer l&#x27;objet fuseau horaire</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtenir l&#x27;heure actuelle dans ce fuseau horaire</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;L&#x27;heure locale actuelle dans <span class="hljs-subst">{timezone}</span> est : <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Erreur lors de la récupération de l&#x27;heure pour le fuseau horaire &#x27;<span class="hljs-subst">{timezone}</span>&#x27; : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Importer l&#x27;outil depuis le Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer],  <span class="hljs-comment"># ajoutez vos outils ici (ne supprimez pas final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates <span class="hljs-comment"># Transmettre le prompt du système à CodeAgent</span>
)

GradioUI(agent).launch()`,wrap:!1}}),we=new Vt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/tutorial.mdx"}}),{c(){T=i("meta"),Ie=n(),Ue=i("p"),he=n(),u(w.$$.fragment),ve=n(),j=i("p"),j.innerHTML=Wl,fe=n(),U=i("p"),U.innerHTML=xl,ge=n(),b=i("p"),b.innerHTML=Al,Ce=n(),I=i("p"),I.textContent=_l,Be=n(),u(h.$$.fragment),Ze=n(),v=i("img"),Ge=n(),f=i("p"),f.innerHTML=Hl,Ve=n(),g=i("p"),g.textContent=Ql,ze=n(),C=i("p"),C.innerHTML=Sl,We=n(),B=i("p"),B.innerHTML=Rl,xe=n(),Z=i("p"),Z.textContent=kl,Ae=n(),G=i("p"),G.innerHTML=Xl,_e=n(),V=i("p"),V.innerHTML=Nl,Ee=n(),M=i("iframe"),He=n(),z=i("p"),z.textContent=Fl,Qe=n(),u(W.$$.fragment),Se=n(),x=i("p"),x.innerHTML=Ll,Re=n(),A=i("blockquote"),A.innerHTML=$l,ke=n(),_=i("p"),_.innerHTML=Yl,Xe=n(),E=i("img"),Ne=n(),H=i("p"),H.innerHTML=Dl,qe=n(),Q=i("ol"),Q.innerHTML=Kl,Fe=n(),S=i("p"),S.innerHTML=Ol,Le=n(),R=i("p"),R.textContent=et,$e=n(),k=i("ul"),k.innerHTML=lt,Ye=n(),u(X.$$.fragment),Pe=n(),N=i("p"),N.innerHTML=tt,De=n(),u(q.$$.fragment),Ke=n(),F=i("p"),F.innerHTML=st,Oe=n(),u(L.$$.fragment),el=n(),$=i("p"),$.textContent=nt,ll=n(),Y=i("ol"),Y.innerHTML=at,tl=n(),P=i("p"),P.textContent=it,sl=n(),D=i("ol"),D.innerHTML=ot,nl=n(),u(K.$$.fragment),al=n(),O=i("p"),O.innerHTML=rt,il=n(),u(ee.$$.fragment),ol=n(),le=i("p"),le.innerHTML=Mt,rl=n(),te=i("p"),te.innerHTML=pt,Ml=n(),se=i("p"),se.innerHTML=ut,pl=n(),ne=i("p"),ne.innerHTML=ct,ul=n(),u(ae.$$.fragment),cl=n(),ie=i("p"),ie.innerHTML=mt,ml=n(),oe=i("p"),oe.innerHTML=yt,yl=n(),re=i("p"),re.innerHTML=Jt,Jl=n(),Me=i("p"),Me.innerHTML=dt,dl=n(),u(pe.$$.fragment),Tl=n(),ue=i("p"),ue.innerHTML=Tt,wl=n(),ce=i("p"),ce.innerHTML=wt,jl=n(),me=i("p"),me.innerHTML=jt,Ul=n(),bl=i("hr"),Il=n(),ye=i("p"),ye.textContent=Ut,hl=n(),Je=i("p"),Je.textContent=bt,vl=n(),de=i("p"),de.textContent=It,fl=n(),Te=i("p"),Te.textContent=ht,gl=n(),u(we.$$.fragment),Cl=n(),be=i("p"),this.h()},l(e){const l=Zt("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(t),Ie=a(e),Ue=o(e,"P",{}),Vl(Ue).forEach(t),he=a(e),c(w.$$.fragment,e),ve=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-qs4xjg"&&(j.innerHTML=Wl),fe=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1q75a4l"&&(U.innerHTML=xl),ge=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ywod5z"&&(b.innerHTML=Al),Ce=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-13o0trz"&&(I.textContent=_l),Be=a(e),c(h.$$.fragment,e),Ze=a(e),v=o(e,"IMG",{src:!0,alt:!0}),Ge=a(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-dbtthn"&&(f.innerHTML=Hl),Ve=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1bcgvwk"&&(g.textContent=Ql),ze=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1yc3dh6"&&(C.innerHTML=Sl),We=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-a02t0l"&&(B.innerHTML=Rl),xe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-x6axr8"&&(Z.textContent=kl),Ae=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-8v2mq6"&&(G.innerHTML=Xl),_e=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-jhlkvg"&&(V.innerHTML=Nl),Ee=a(e),M=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Vl(M).forEach(t),He=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1gth0ux"&&(z.textContent=Fl),Qe=a(e),c(W.$$.fragment,e),Se=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1nhw6j"&&(x.innerHTML=Ll),Re=a(e),A=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(A)!=="svelte-17wqgsx"&&(A.innerHTML=$l),ke=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-a592en"&&(_.innerHTML=Yl),Xe=a(e),E=o(e,"IMG",{src:!0,alt:!0}),Ne=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13lr74u"&&(H.innerHTML=Dl),qe=a(e),Q=o(e,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-1rl24xt"&&(Q.innerHTML=Kl),Fe=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-o6yf0f"&&(S.innerHTML=Ol),Le=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1azrb"&&(R.textContent=et),$e=a(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-118pf10"&&(k.innerHTML=lt),Ye=a(e),c(X.$$.fragment,e),Pe=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1m3exlv"&&(N.innerHTML=tt),De=a(e),c(q.$$.fragment,e),Ke=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ar0zqh"&&(F.innerHTML=st),Oe=a(e),c(L.$$.fragment,e),el=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-193l0gp"&&($.textContent=nt),ll=a(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-1petlbb"&&(Y.innerHTML=at),tl=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-qbfp30"&&(P.textContent=it),sl=a(e),D=o(e,"OL",{"data-svelte-h":!0}),r(D)!=="svelte-1opewe3"&&(D.innerHTML=ot),nl=a(e),c(K.$$.fragment,e),al=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1fhn4cw"&&(O.innerHTML=rt),il=a(e),c(ee.$$.fragment,e),ol=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-80mzrd"&&(le.innerHTML=Mt),rl=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-14umwg7"&&(te.innerHTML=pt),Ml=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1d4myhn"&&(se.innerHTML=ut),pl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-vatkzs"&&(ne.innerHTML=ct),ul=a(e),c(ae.$$.fragment,e),cl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ccs376"&&(ie.innerHTML=mt),ml=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-94hajw"&&(oe.innerHTML=yt),yl=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-wgpiab"&&(re.innerHTML=Jt),Jl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ubbbh5"&&(Me.innerHTML=dt),dl=a(e),c(pe.$$.fragment,e),Tl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-pj2es1"&&(ue.innerHTML=Tt),wl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-g8nes"&&(ce.innerHTML=wt),jl=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-kizn95"&&(me.innerHTML=jt),Ul=a(e),bl=o(e,"HR",{}),Il=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1ntujpe"&&(ye.textContent=Ut),hl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-kpv7xu"&&(Je.textContent=bt),vl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-fowehc"&&(de.textContent=It),fl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-w5fwm2"&&(Te.textContent=ht),gl=a(e),c(we.$$.fragment,e),Cl=a(e),be=o(e,"P",{}),Vl(be).forEach(t),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",Wt),Gl(v.src,El="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||p(v,"src",El),p(v,"alt","smolagents"),p(M,"width","560"),p(M,"height","315"),Gl(M.src,ql="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||p(M,"src",ql),p(M,"title","YouTube video player"),p(M,"frameborder","0"),p(M,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),p(M,"referrerpolicy","strict-origin-when-cross-origin"),M.allowFullscreen="",Gl(E.src,Pl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||p(E,"src",Pl),p(E,"alt","Duplicate")},m(e,l){Gt(document.head,T),s(e,Ie,l),s(e,Ue,l),s(e,he,l),m(w,e,l),s(e,ve,l),s(e,j,l),s(e,fe,l),s(e,U,l),s(e,ge,l),s(e,b,l),s(e,Ce,l),s(e,I,l),s(e,Be,l),m(h,e,l),s(e,Ze,l),s(e,v,l),s(e,Ge,l),s(e,f,l),s(e,Ve,l),s(e,g,l),s(e,ze,l),s(e,C,l),s(e,We,l),s(e,B,l),s(e,xe,l),s(e,Z,l),s(e,Ae,l),s(e,G,l),s(e,_e,l),s(e,V,l),s(e,Ee,l),s(e,M,l),s(e,He,l),s(e,z,l),s(e,Qe,l),m(W,e,l),s(e,Se,l),s(e,x,l),s(e,Re,l),s(e,A,l),s(e,ke,l),s(e,_,l),s(e,Xe,l),s(e,E,l),s(e,Ne,l),s(e,H,l),s(e,qe,l),s(e,Q,l),s(e,Fe,l),s(e,S,l),s(e,Le,l),s(e,R,l),s(e,$e,l),s(e,k,l),s(e,Ye,l),m(X,e,l),s(e,Pe,l),s(e,N,l),s(e,De,l),m(q,e,l),s(e,Ke,l),s(e,F,l),s(e,Oe,l),m(L,e,l),s(e,el,l),s(e,$,l),s(e,ll,l),s(e,Y,l),s(e,tl,l),s(e,P,l),s(e,sl,l),s(e,D,l),s(e,nl,l),m(K,e,l),s(e,al,l),s(e,O,l),s(e,il,l),m(ee,e,l),s(e,ol,l),s(e,le,l),s(e,rl,l),s(e,te,l),s(e,Ml,l),s(e,se,l),s(e,pl,l),s(e,ne,l),s(e,ul,l),m(ae,e,l),s(e,cl,l),s(e,ie,l),s(e,ml,l),s(e,oe,l),s(e,yl,l),s(e,re,l),s(e,Jl,l),s(e,Me,l),s(e,dl,l),m(pe,e,l),s(e,Tl,l),s(e,ue,l),s(e,wl,l),s(e,ce,l),s(e,jl,l),s(e,me,l),s(e,Ul,l),s(e,bl,l),s(e,Il,l),s(e,ye,l),s(e,hl,l),s(e,Je,l),s(e,vl,l),s(e,de,l),s(e,fl,l),s(e,Te,l),s(e,gl,l),m(we,e,l),s(e,Cl,l),s(e,be,l),Bl=!0},p:ft,i(e){Bl||(y(w.$$.fragment,e),y(h.$$.fragment,e),y(W.$$.fragment,e),y(X.$$.fragment,e),y(q.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),y(we.$$.fragment,e),Bl=!0)},o(e){J(w.$$.fragment,e),J(h.$$.fragment,e),J(W.$$.fragment,e),J(X.$$.fragment,e),J(q.$$.fragment,e),J(L.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(ae.$$.fragment,e),J(pe.$$.fragment,e),J(we.$$.fragment,e),Bl=!1},d(e){e&&(t(Ie),t(Ue),t(he),t(ve),t(j),t(fe),t(U),t(ge),t(b),t(Ce),t(I),t(Be),t(Ze),t(v),t(Ge),t(f),t(Ve),t(g),t(ze),t(C),t(We),t(B),t(xe),t(Z),t(Ae),t(G),t(_e),t(V),t(Ee),t(M),t(He),t(z),t(Qe),t(Se),t(x),t(Re),t(A),t(ke),t(_),t(Xe),t(E),t(Ne),t(H),t(qe),t(Q),t(Fe),t(S),t(Le),t(R),t($e),t(k),t(Ye),t(Pe),t(N),t(De),t(Ke),t(F),t(Oe),t(el),t($),t(ll),t(Y),t(tl),t(P),t(sl),t(D),t(nl),t(al),t(O),t(il),t(ol),t(le),t(rl),t(te),t(Ml),t(se),t(pl),t(ne),t(ul),t(cl),t(ie),t(ml),t(oe),t(yl),t(re),t(Jl),t(Me),t(dl),t(Tl),t(ue),t(wl),t(ce),t(jl),t(me),t(Ul),t(bl),t(Il),t(ye),t(hl),t(Je),t(vl),t(de),t(fl),t(Te),t(gl),t(Cl),t(be)),t(T),d(w,e),d(h,e),d(W,e),d(X,e),d(q,e),d(L,e),d(K,e),d(ee,e),d(ae,e),d(pe,e),d(we,e)}}}const Wt='{"title":"Créons notre premier agent avec smolagents","local":"créons-notre-premier-agent-avec-smolagents","sections":[{"title":"Qu’est-ce que smolagents ?","local":"quest-ce-que-smolagents-","sections":[],"depth":2},{"title":"Construisons notre agent !","local":"construisons-notre-agent-","sections":[{"title":"Les outils","local":"les-outils","sections":[],"depth":3},{"title":"L’agent","local":"lagent","sections":[],"depth":3},{"title":"Le prompt système","local":"le-prompt-système","sections":[],"depth":3}],"depth":2}],"depth":1}';function xt(zl){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Ct{constructor(T){super(),Bt(this,T,xt,zt,vt,{})}}export{St as component};
