import{s as Fe,o as _e,n as qe}from"../chunks/scheduler.37c15a92.js";import{S as He,i as Le,g as M,s as n,r as y,A as De,h as i,f as s,c as a,j as Se,u as o,x as p,k as Ue,y as Pe,a as t,v as J,d as r,t as u,w as U,m as Ne,n as Re}from"../chunks/index.2bf4358c.js";import{T as Ke}from"../chunks/Tip.363c041f.js";import{C as c}from"../chunks/CodeBlock.4e987730.js";import{H as d}from"../chunks/Heading.8ada512a.js";import{E as Oe}from"../chunks/getInferenceSnippets.54ddb825.js";function ls(dl){let T,w,I="ce <i>notebook</i>",m;return{c(){T=Ne("Vous pouvez suivre le code dans "),w=M("a"),w.innerHTML=I,m=Ne(" que vous pouvez exécuter avec Google Colab."),this.h()},l(j){T=Re(j,"Vous pouvez suivre le code dans "),w=i(j,"A",{href:!0,target:!0,"data-svelte-h":!0}),p(w)!=="svelte-1l47cv5"&&(w.innerHTML=I),m=Re(j," que vous pouvez exécuter avec Google Colab."),this.h()},h(){Ue(w,"href","https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/langgraph/agent.ipynb"),Ue(w,"target","_blank")},m(j,C){t(j,T,C),t(j,w,C),t(j,m,C)},p:qe,d(j){j&&(s(T),s(w),s(m))}}}function es(dl){let T,w,I,m,j,C,h,je="Alfred à votre service. En tant que majordome de confiance de M. Wayne, j’ai pris la liberté de documenter comment j’aide M. Wayne avec ses divers besoins documentaires. Pendant qu’il s’occupe de ses… activités nocturnes, je m’assure que tous ses papiers, programmes d’entraînement et plans nutritionnels sont correctement analysés et organisés.",cl,B,Te="Avant de partir, il a laissé une note avec son programme d’entraînement de la semaine. J’ai alors pris la responsabilité de proposer un <strong>menu</strong> pour les repas de demain.",ml,g,we="Pour de futurs événements similaires, créons un système d’analyse de documents utilisant LangGraph pour servir les besoins de M. Wayne. Ce système peut :",Il,Z,de="<li>Traiter des documents sous forme d’image</li> <li>Extraire du texte en utilisant des modèles de vision (<em>Vision Language Model</em>)</li> <li>Effectuer des calculs quand nécessaire (pour démontrer l’utilisation d’outils normaux)</li> <li>Analyser le contenu et fournir des résumés concis</li> <li>Exécuter des instructions spécifiques liées aux documents</li>",Cl,A,bl,G,ce="Le <em>workflow</em> que nous allons construire suit ce schéma structuré :",hl,f,me='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',Bl,b,gl,W,Zl,V,Al,x,Ie="et les imports :",Gl,v,fl,X,Wl,$,Ce=`Cet état est un peu plus complexe que les précédents que nous avons vus.
<code>AnyMessage</code> est une classe de LangChain qui définit les messages, et <code>add_messages</code> est un opérateur qui ajoute le dernier message plutôt que de l’écraser avec le dernier état.`,Vl,z,be="C’est un nouveau concept dans LangGraph, où vous pouvez ajouter des opérateurs dans votre état pour définir la façon dont ils doivent interagir ensemble.",xl,k,vl,E,Xl,Y,$l,Q,zl,S,kl,N,El,R,he="Permettez-moi d’expliquer l’approche dans cet agent. L’agent suit ce qu’on appelle le modèle <em>ReAct</em> (<em>Reason-Act-Observe</em>)",Yl,F,Be="<li><strong>Réfléchir</strong> sur ses documents et demandes</li> <li><strong>Agir</strong> en utilisant les outils appropriés</li> <li><strong>Observer</strong> les résultats</li> <li><strong>Répéter</strong> si nécessaire jusqu’à ce que j’aie pleinement répondu à ses besoins</li>",Ql,_,ge="C’est une implémentation simple d’un agent utilisant LangGraph.",Sl,q,Nl,H,Ze=`Nous définissons un nœud <code>tools</code> avec notre liste d’outils. Le nœud <code>assistant</code> est juste notre modèle avec les outils liés.
Nous créons un graphe avec les nœuds <code>assistant</code> et <code>tools</code>.`,Rl,L,Ae="Nous ajoutons une arête <code>tools_condition</code>, qui route vers <code>End</code> ou vers <code>tools</code> selon que l’<code>assistant</code> appelle un outil.",Fl,D,Ge="Maintenant, nous ajoutons une nouvelle étape :",_l,P,fe="Nous connectons le nœud <code>tools</code> de retour à l’<code>assistant</code>, formant une boucle.",ql,K,We="<li>Après l’exécution du nœud <code>assistant</code>, <code>tools_condition</code> vérifie si la sortie du modèle est un appel d’outil.</li> <li>Si c’est un appel d’outil, le flux est dirigé vers le nœud <code>tools</code>.</li> <li>Le nœud <code>tools</code> se reconnecte à <code>assistant</code>.</li> <li>Cette boucle continue tant que le modèle décide d’appeler des outils.</li> <li>Si la réponse du modèle n’est pas un appel d’outil, le flux est dirigé vers <em>END</em>, terminant le processus.</li>",Hl,O,Ve='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Ll,ll,Dl,el,Pl,sl,xe="Voici un exemple pour montrer un cas d’usage simple d’un agent utilisant un outil dans LangGraph.",Kl,tl,Ol,nl,ve="La conversation se déroulerait :",le,al,ee,Ml,se,il,Xe="Quand Maître Wayne laisse ses notes d’entraînement et de repas :",te,pl,ne,yl,$e="L’interaction se déroulerait :",ae,ol,Me,Jl,ie,rl,ze="Si vous souhaitez créer votre propre majordome d’analyse de documents, voici les considérations clés :",pe,ul,ke="<li><strong>Définir des outils clairs</strong> pour des tâches spécifiques liées aux documents</li> <li><strong>Créer un suivi d’état robuste</strong> pour maintenir le contexte entre les appels d’outils</li> <li><strong>Considérer la gestion d’erreurs</strong> pour les échecs d’outils</li> <li><strong>Maintenir la conscience contextuelle</strong> des interactions précédentes (assurée par l’opérateur <code>add_messages</code>)</li>",ye,Ul,Ee="Avec ces principes, vous pouvez vous aussi fournir un service d’analyse de documents exemplaire digne du manoir Wayne.",oe,jl,Ye="<em>J’espère que cette explication a été satisfaisante. Maintenant, si vous voulez bien m’excuser, la cape de Maître Wayne nécessite un repassage avant les activités de ce soir.</em>",Je,Tl,re,wl,ue;return j=new d({props:{title:"Graphe d’analyse de documents",local:"graphe-danalyse-de-documents",headingTag:"h1"}}),A=new d({props:{title:"Le workflow du majordome",local:"le-workflow-du-majordome",headingTag:"h2"}}),b=new Ke({props:{$$slots:{default:[ls]},$$scope:{ctx:dl}}}),W=new d({props:{title:"Configuration de l’environnement",local:"configuration-de-lenvironnement",headingTag:"h2"}}),V=new c({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),v=new c({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),X=new d({props:{title:"Définir l’état de l’agent",local:"définir-létat-de-lagent",headingTag:"h2"}}),k=new c({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBMZSUyMGRvY3VtZW50JTIwZm91cm5pJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGllbnQlMjBsZSUyMGNoZW1pbiUyMGR1JTIwZmljaGllciUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># Le document fourni</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contient le chemin du fichier (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),E=new d({props:{title:"Préparer les outils",local:"préparer-les-outils",headingTag:"h2"}}),Y=new c({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.
    
    Maître Wayne laisse souvent des notes avec son régime d&#x27;entraînement ou ses plans de repas.
    Cela me permet d&#x27;analyser correctement le contenu.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Lire l&#x27;image et encoder en base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Préparer le prompt incluant les données d&#x27;image base64</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extrayez tout le texte de cette image. &quot;</span>
                            <span class="hljs-string">&quot;Retournez seulement le texte extrait, sans explications.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Appeler le VLM</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Ajouter le texte extrait</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># Un majordome doit gérer les erreurs avec élégance</span>
        error_msg = <span class="hljs-string">f&quot;Erreur lors de l&#x27;extraction du texte : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Diviser a et b - pour les calculs occasionnels de Maître Wayne.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Équiper le majordome avec des outils</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),Q=new d({props:{title:"Les nœuds",local:"les-nœuds",headingTag:"h2"}}),S=new c({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBNZXNzYWdlJTIwc3lzdCVDMyVBOG1lJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWlyZSUyMGxlJTIwdGV4dGUlMjBkJ3VuJTIwZmljaGllciUyMGltYWdlJTIwZW4lMjB1dGlsaXNhbnQlMjB1biUyMG1vZCVDMyVBOGxlJTIwbXVsdGltb2RhbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBVbiUyMGNoZW1pbiUyMGRlJTIwZmljaGllciUyMGltYWdlJTIwbG9jYWwlMjAoY2hhJUMzJUFFbmVzKS4lMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5lJTIwY2hhJUMzJUFFbmUlMjB1bmlxdWUlMjBjb250ZW5hbnQlMjBsZSUyMHRleHRlJTIwY29uY2F0JUMzJUE5biVDMyVBOSUyMGV4dHJhaXQlMjBkZSUyMGNoYXF1ZSUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpc2VyJTIwYSUyMGV0JTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJWb3VzJTIwJUMzJUFBdGVzJTIwdW4lMjBtYWpvcmRvbWUlMjBzZXJ2aWFibGUlMjBub21tJUMzJUE5JTIwQWxmcmVkJTIwcXVpJTIwc2VydCUyME0uJTIwV2F5bmUlMjBldCUyMEJhdG1hbi4lMjBWb3VzJTIwcG91dmV6JTIwYW5hbHlzZXIlMjBkZXMlMjBkb2N1bWVudHMlMjBldCUyMGVmZmVjdHVlciUyMGRlcyUyMGNhbGN1bHMlMjBhdmVjJTIwbGVzJTIwb3V0aWxzJTIwZm91cm5pcyUyMCUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwVm91cyUyMGF2ZXolMjBhY2MlQzMlQThzJTIwJUMzJUEwJTIwcXVlbHF1ZXMlMjBpbWFnZXMlMjBvcHRpb25uZWxsZXMuJTIwQWN0dWVsbGVtZW50JTIwbCdpbWFnZSUyMGNoYXJnJUMzJUE5ZSUyMGVzdCUyMCUzQSUyMCU3QmltYWdlJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCbGxtX3dpdGhfdG9vbHMuaW52b2tlKCU1QnN5c19tc2clNUQlMjAlMkIlMjBzdGF0ZSU1QiUyMm1lc3NhZ2VzJTIyJTVEKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBzdGF0ZSU1QiUyMmlucHV0X2ZpbGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># Message système</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.

    Args:
        img_path: Un chemin de fichier image local (chaînes).

    Returns:
        Une chaîne unique contenant le texte concaténé extrait de chaque image.
divide(a: int, b: int) -&gt; float:
    Diviser a et b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;Vous êtes un majordome serviable nommé Alfred qui sert M. Wayne et Batman. Vous pouvez analyser des documents et effectuer des calculs avec les outils fournis :\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n Vous avez accès à quelques images optionnelles. Actuellement l&#x27;image chargée est : <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),N=new d({props:{title:"Le modèle ReAct : Comment j’aide M. Wayne",local:"le-modèle-react--comment-jaide-m-wayne",headingTag:"h2"}}),q=new c({props:{code:"JTIzJTIwTGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMEQlQzMlQTlmaW5pciUyMGxlcyUyMG4lQzUlOTN1ZHMlMjAlM0ElMjBjZXV4LWNpJTIwZm9udCUyMGxlJTIwdHJhdmFpbCUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwRCVDMyVBOWZpbmlyJTIwbGVzJTIwYXIlQzMlQUF0ZXMlMjAlM0ElMjBjZWxsZXMtY2klMjBkJUMzJUE5dGVybWluZW50JTIwY29tbWVudCUyMGxlJTIwZmx1eCUyMGRlJTIwY29udHIlQzMlQjRsZSUyMHNlJTIwZCVDMyVBOXBsYWNlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBTaSUyMGxlJTIwZGVybmllciUyMG1lc3NhZ2UlMjBuJUMzJUE5Y2Vzc2l0ZSUyMHVuJTIwb3V0aWwlMkMlMjByb3V0ZXIlMjB2ZXJzJTIwbGVzJTIwb3V0aWxzJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2lub24lMkMlMjBmb3VybmlyJTIwdW5lJTIwciVDMyVBOXBvbnNlJTIwZGlyZWN0ZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBNb250cmVyJTIwbGUlMjBwcm9jZXNzdXMlMjBkZSUyMHIlQzMlQTlmbGV4aW9uJTIwZHUlMjBtYWpvcmRvbWUlMEFkaXNwbGF5KEltYWdlKHJlYWN0X2dyYXBoLmdldF9ncmFwaCh4cmF5JTNEVHJ1ZSkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Le graphe</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Définir les nœuds : ceux-ci font le travail</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Définir les arêtes : celles-ci déterminent comment le flux de contrôle se déplace</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si le dernier message nécessite un outil, router vers les outils</span>
    <span class="hljs-comment"># Sinon, fournir une réponse directe</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Montrer le processus de réflexion du majordome</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),ll=new d({props:{title:"Le majordome en action",local:"le-majordome-en-action",headingTag:"h2"}}),el=new d({props:{title:"Exemple 1 : Calculs simples",local:"exemple-1--calculs-simples",headingTag:"h3"}}),tl=new c({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlzZXolMjA2NzkwJTIwcGFyJTIwNSUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyME5vbmUlN0QpJTBBJTBBJTIzJTIwTW9udHJlciUyMGxlcyUyMG1lc3NhZ2VzJTBBZm9yJTIwbSUyMGluJTIwbWVzc2FnZXMlNUInbWVzc2FnZXMnJTVEJTNBJTBBJTIwJTIwJTIwJTIwbS5wcmV0dHlfcHJpbnQoKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divisez 6790 par 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Montrer les messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),al=new c({props:{code:"SHVtYWluJTIwJTNBJTIwRGl2aXNleiUyMDY3OTAlMjBwYXIlMjA1JTBBJTBBQXBwZWwlMjBkJ3VuJTIwb3V0aWwlMjAlM0ElMjBkaXZpZGUoYSUzRDY3OTAlMkMlMjBiJTNENSklMEElMEFSJUMzJUE5cG9uc2UlMjBkZSUyMGwnb3V0aWwlMjAlM0ElMjAxMzU4LjAlMEElMEFBbGZyZWQlMjAlM0ElMjBMZSUyMHIlQzMlQTlzdWx0YXQlMjBkZSUyMGxhJTIwZGl2aXNpb24lMjBkZSUyMDY3OTAlMjBwYXIlMjA1JTIwZXN0JTIwMTM1OC4wLg==",highlighted:`<span class="hljs-attribute">Humain</span> : Divisez <span class="hljs-number">6790</span> par <span class="hljs-number">5</span>

<span class="hljs-attribute">Appel</span> d&#x27;un outil : divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">R</span>éponse de l&#x27;outil : <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span> : Le résultat de la division de <span class="hljs-number">6790</span> par <span class="hljs-number">5</span> est <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),Ml=new d({props:{title:"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne",local:"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne",headingTag:"h3"}}),pl=new c({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMlNlbG9uJTIwbGElMjBub3RlJTIwZm91cm5pZSUyMHBhciUyME0uJTIwV2F5bmUlMjBkYW5zJTIwbGVzJTIwaW1hZ2VzJTIwZm91cm5pZXMuJTIwUXVlbGxlJTIwZXN0JTIwbGElMjBsaXN0ZSUyMGRlcyUyMGFydGljbGVzJTIwcXVlJTIwamUlMjBkb2lzJTIwYWNoZXRlciUyMHBvdXIlMjBsZSUyMG1lbnUlMjBkdSUyMGQlQzMlQUVuZXIlMjAlM0YlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjAlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiU3RCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Selon la note fournie par M. Wayne dans les images fournies. Quelle est la liste des articles que je dois acheter pour le menu du dîner ?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),ol=new c({props:{code:"SHVtYWluJTIwJTNBJTIwU2Vsb24lMjBsYSUyMG5vdGUlMjBmb3VybmllJTIwcGFyJTIwTS4lMjBXYXluZSUyMGRhbnMlMjBsZXMlMjBpbWFnZXMlMjBmb3Vybmllcy4lMjBRdWVsbGUlMjBlc3QlMjBsYSUyMGxpc3RlJTIwZGVzJTIwYXJ0aWNsZXMlMjBxdWUlMjBqZSUyMGRvaXMlMjBhY2hldGVyJTIwcG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyMCUzRiUwQSUwQUFwcGVsJTIwZCd1biUyMG91dGlsJTIwJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBUiVDMyVBOXBvbnNlJTIwZGUlMjBsJ291dGlsJTIwJTNBJTIwJTVCVGV4dGUlMjBleHRyYWl0JTIwYXZlYyUyMGxlJTIwcHJvZ3JhbW1lJTIwZCdlbnRyYSVDMyVBRW5lbWVudCUyMGV0JTIwbGVzJTIwZCVDMyVBOXRhaWxzJTIwZHUlMjBtZW51JTVEJTBBJTBBQWxmcmVkJTIwJTNBJTIwUG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyQyUyMHZvdXMlMjBkZXZyaWV6JTIwYWNoZXRlciUyMGxlcyUyMGFydGljbGVzJTIwc3VpdmFudHMlMjAlM0ElMEElMEExLiUyMFN0ZWFrJTIwZGUlMjBzdXJsb25nZSUyMGxvY2FsJTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUwQTIuJTIwJUMzJTg5cGluYXJkcyUyMGJpb2xvZ2lxdWVzJTBBMy4lMjBQb2l2cm9ucyUyMCpwaXF1aWxsbyolMEE0LiUyMFBvbW1lcyUyMGRlJTIwdGVycmUlMjAocG91ciUyMHBvbW1lcyUyMGRlJTIwdGVycmUlMjBhdXglMjBoZXJiZXMlMjBkb3IlQzMlQTllcyUyMGF1JTIwZm91ciklMEE1LiUyMEh1aWxlJTIwZGUlMjBwb2lzc29uJTIwKDIlMjBncmFtbWVzKSUwQSUwQUFzc3VyZXotdm91cyUyMHF1ZSUyMGxlJTIwc3RlYWslMjBzb2l0JTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUyMGV0JTIwcXVlJTIwbGVzJTIwJUMzJUE5cGluYXJkcyUyMGV0JTIwcG9pdnJvbnMlMjBzb2llbnQlMjBiaW9sb2dpcXVlcyUyMHBvdXIlMjB1biUyMHJlcGFzJTIwZGUlMjBsYSUyMG1laWxsZXVyZSUyMHF1YWxpdCVDMyVBOS4=",highlighted:`Humain : Selon <span class="hljs-keyword">la</span> <span class="hljs-keyword">note</span> fournie par <span class="hljs-keyword">M</span>. Wayne dans les images fournies. Quelle <span class="hljs-keyword">est</span> <span class="hljs-keyword">la</span> liste <span class="hljs-keyword">des</span> articles <span class="hljs-keyword">que</span> je dois acheter pour le menu du <span class="hljs-keyword">d</span>îner ?

Appel <span class="hljs-keyword">d</span>&#x27;un outil : extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Réponse <span class="hljs-keyword">de</span> <span class="hljs-keyword">l</span>&#x27;outil : [Texte extrait avec le programme <span class="hljs-keyword">d</span>&#x27;entraînement et les <span class="hljs-keyword">d</span>étails du menu]

Alfred : Pour le menu du <span class="hljs-keyword">d</span>îner, vous devriez acheter les articles suivants :

1. Steak <span class="hljs-keyword">de</span> surlonge <span class="hljs-keyword">local</span> nourri à <span class="hljs-keyword">l</span>&#x27;herbe
2. Épinards biologiques
3. Poivrons *piquillo*
4. Pommes <span class="hljs-keyword">de</span> terre (pour pommes <span class="hljs-keyword">de</span> terre aux herbes dorées au four)
5. Huile <span class="hljs-keyword">de</span> <span class="hljs-keyword">poisson</span> (2 grammes)

Assurez-vous <span class="hljs-keyword">que</span> le steak soit nourri à <span class="hljs-keyword">l</span>&#x27;herbe et <span class="hljs-keyword">que</span> les épinards et poivrons soient biologiques pour un repas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> meilleure qualité.`,wrap:!1}}),Jl=new d({props:{title:"Points clés à retenir",local:"points-clés-à-retenir",headingTag:"h2"}}),Tl=new Oe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){T=M("meta"),w=n(),I=M("p"),m=n(),y(j.$$.fragment),C=n(),h=M("p"),h.textContent=je,cl=n(),B=M("p"),B.innerHTML=Te,ml=n(),g=M("p"),g.textContent=we,Il=n(),Z=M("ol"),Z.innerHTML=de,Cl=n(),y(A.$$.fragment),bl=n(),G=M("p"),G.innerHTML=ce,hl=n(),f=M("p"),f.innerHTML=me,Bl=n(),y(b.$$.fragment),gl=n(),y(W.$$.fragment),Zl=n(),y(V.$$.fragment),Al=n(),x=M("p"),x.textContent=Ie,Gl=n(),y(v.$$.fragment),fl=n(),y(X.$$.fragment),Wl=n(),$=M("p"),$.innerHTML=Ce,Vl=n(),z=M("p"),z.textContent=be,xl=n(),y(k.$$.fragment),vl=n(),y(E.$$.fragment),Xl=n(),y(Y.$$.fragment),$l=n(),y(Q.$$.fragment),zl=n(),y(S.$$.fragment),kl=n(),y(N.$$.fragment),El=n(),R=M("p"),R.innerHTML=he,Yl=n(),F=M("ol"),F.innerHTML=Be,Ql=n(),_=M("p"),_.textContent=ge,Sl=n(),y(q.$$.fragment),Nl=n(),H=M("p"),H.innerHTML=Ze,Rl=n(),L=M("p"),L.innerHTML=Ae,Fl=n(),D=M("p"),D.textContent=Ge,_l=n(),P=M("p"),P.innerHTML=fe,ql=n(),K=M("ul"),K.innerHTML=We,Hl=n(),O=M("p"),O.innerHTML=Ve,Ll=n(),y(ll.$$.fragment),Dl=n(),y(el.$$.fragment),Pl=n(),sl=M("p"),sl.textContent=xe,Kl=n(),y(tl.$$.fragment),Ol=n(),nl=M("p"),nl.textContent=ve,le=n(),y(al.$$.fragment),ee=n(),y(Ml.$$.fragment),se=n(),il=M("p"),il.textContent=Xe,te=n(),y(pl.$$.fragment),ne=n(),yl=M("p"),yl.textContent=$e,ae=n(),y(ol.$$.fragment),Me=n(),y(Jl.$$.fragment),ie=n(),rl=M("p"),rl.textContent=ze,pe=n(),ul=M("ol"),ul.innerHTML=ke,ye=n(),Ul=M("p"),Ul.textContent=Ee,oe=n(),jl=M("p"),jl.innerHTML=Ye,Je=n(),y(Tl.$$.fragment),re=n(),wl=M("p"),this.h()},l(l){const e=De("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(s),w=a(l),I=i(l,"P",{}),Se(I).forEach(s),m=a(l),o(j.$$.fragment,l),C=a(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-gt557y"&&(h.textContent=je),cl=a(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-4j0gl0"&&(B.innerHTML=Te),ml=a(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-10fnikl"&&(g.textContent=we),Il=a(l),Z=i(l,"OL",{"data-svelte-h":!0}),p(Z)!=="svelte-1hsq04l"&&(Z.innerHTML=de),Cl=a(l),o(A.$$.fragment,l),bl=a(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-3lt4u7"&&(G.innerHTML=ce),hl=a(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-g7cpwr"&&(f.innerHTML=me),Bl=a(l),o(b.$$.fragment,l),gl=a(l),o(W.$$.fragment,l),Zl=a(l),o(V.$$.fragment,l),Al=a(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-x7jdgr"&&(x.textContent=Ie),Gl=a(l),o(v.$$.fragment,l),fl=a(l),o(X.$$.fragment,l),Wl=a(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-19o7soi"&&($.innerHTML=Ce),Vl=a(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1eaw1cp"&&(z.textContent=be),xl=a(l),o(k.$$.fragment,l),vl=a(l),o(E.$$.fragment,l),Xl=a(l),o(Y.$$.fragment,l),$l=a(l),o(Q.$$.fragment,l),zl=a(l),o(S.$$.fragment,l),kl=a(l),o(N.$$.fragment,l),El=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-jejazg"&&(R.innerHTML=he),Yl=a(l),F=i(l,"OL",{"data-svelte-h":!0}),p(F)!=="svelte-svdcrr"&&(F.innerHTML=Be),Ql=a(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1h6mv9k"&&(_.textContent=ge),Sl=a(l),o(q.$$.fragment,l),Nl=a(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-kp6yb5"&&(H.innerHTML=Ze),Rl=a(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-g1y7jt"&&(L.innerHTML=Ae),Fl=a(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-llapac"&&(D.textContent=Ge),_l=a(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-rl19lj"&&(P.innerHTML=fe),ql=a(l),K=i(l,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-ronwmj"&&(K.innerHTML=We),Hl=a(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1nhlurw"&&(O.innerHTML=Ve),Ll=a(l),o(ll.$$.fragment,l),Dl=a(l),o(el.$$.fragment,l),Pl=a(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1521eea"&&(sl.textContent=xe),Kl=a(l),o(tl.$$.fragment,l),Ol=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-528ko8"&&(nl.textContent=ve),le=a(l),o(al.$$.fragment,l),ee=a(l),o(Ml.$$.fragment,l),se=a(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1xfwie6"&&(il.textContent=Xe),te=a(l),o(pl.$$.fragment,l),ne=a(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1wf0zlb"&&(yl.textContent=$e),ae=a(l),o(ol.$$.fragment,l),Me=a(l),o(Jl.$$.fragment,l),ie=a(l),rl=i(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1fpv4nj"&&(rl.textContent=ze),pe=a(l),ul=i(l,"OL",{"data-svelte-h":!0}),p(ul)!=="svelte-frrqyp"&&(ul.innerHTML=ke),ye=a(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1gn4t6x"&&(Ul.textContent=Ee),oe=a(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1fvnwmy"&&(jl.innerHTML=Ye),Je=a(l),o(Tl.$$.fragment,l),re=a(l),wl=i(l,"P",{}),Se(wl).forEach(s),this.h()},h(){Ue(T,"name","hf:doc:metadata"),Ue(T,"content",ss)},m(l,e){Pe(document.head,T),t(l,w,e),t(l,I,e),t(l,m,e),J(j,l,e),t(l,C,e),t(l,h,e),t(l,cl,e),t(l,B,e),t(l,ml,e),t(l,g,e),t(l,Il,e),t(l,Z,e),t(l,Cl,e),J(A,l,e),t(l,bl,e),t(l,G,e),t(l,hl,e),t(l,f,e),t(l,Bl,e),J(b,l,e),t(l,gl,e),J(W,l,e),t(l,Zl,e),J(V,l,e),t(l,Al,e),t(l,x,e),t(l,Gl,e),J(v,l,e),t(l,fl,e),J(X,l,e),t(l,Wl,e),t(l,$,e),t(l,Vl,e),t(l,z,e),t(l,xl,e),J(k,l,e),t(l,vl,e),J(E,l,e),t(l,Xl,e),J(Y,l,e),t(l,$l,e),J(Q,l,e),t(l,zl,e),J(S,l,e),t(l,kl,e),J(N,l,e),t(l,El,e),t(l,R,e),t(l,Yl,e),t(l,F,e),t(l,Ql,e),t(l,_,e),t(l,Sl,e),J(q,l,e),t(l,Nl,e),t(l,H,e),t(l,Rl,e),t(l,L,e),t(l,Fl,e),t(l,D,e),t(l,_l,e),t(l,P,e),t(l,ql,e),t(l,K,e),t(l,Hl,e),t(l,O,e),t(l,Ll,e),J(ll,l,e),t(l,Dl,e),J(el,l,e),t(l,Pl,e),t(l,sl,e),t(l,Kl,e),J(tl,l,e),t(l,Ol,e),t(l,nl,e),t(l,le,e),J(al,l,e),t(l,ee,e),J(Ml,l,e),t(l,se,e),t(l,il,e),t(l,te,e),J(pl,l,e),t(l,ne,e),t(l,yl,e),t(l,ae,e),J(ol,l,e),t(l,Me,e),J(Jl,l,e),t(l,ie,e),t(l,rl,e),t(l,pe,e),t(l,ul,e),t(l,ye,e),t(l,Ul,e),t(l,oe,e),t(l,jl,e),t(l,Je,e),J(Tl,l,e),t(l,re,e),t(l,wl,e),ue=!0},p(l,[e]){const Qe={};e&2&&(Qe.$$scope={dirty:e,ctx:l}),b.$set(Qe)},i(l){ue||(r(j.$$.fragment,l),r(A.$$.fragment,l),r(b.$$.fragment,l),r(W.$$.fragment,l),r(V.$$.fragment,l),r(v.$$.fragment,l),r(X.$$.fragment,l),r(k.$$.fragment,l),r(E.$$.fragment,l),r(Y.$$.fragment,l),r(Q.$$.fragment,l),r(S.$$.fragment,l),r(N.$$.fragment,l),r(q.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(Ml.$$.fragment,l),r(pl.$$.fragment,l),r(ol.$$.fragment,l),r(Jl.$$.fragment,l),r(Tl.$$.fragment,l),ue=!0)},o(l){u(j.$$.fragment,l),u(A.$$.fragment,l),u(b.$$.fragment,l),u(W.$$.fragment,l),u(V.$$.fragment,l),u(v.$$.fragment,l),u(X.$$.fragment,l),u(k.$$.fragment,l),u(E.$$.fragment,l),u(Y.$$.fragment,l),u(Q.$$.fragment,l),u(S.$$.fragment,l),u(N.$$.fragment,l),u(q.$$.fragment,l),u(ll.$$.fragment,l),u(el.$$.fragment,l),u(tl.$$.fragment,l),u(al.$$.fragment,l),u(Ml.$$.fragment,l),u(pl.$$.fragment,l),u(ol.$$.fragment,l),u(Jl.$$.fragment,l),u(Tl.$$.fragment,l),ue=!1},d(l){l&&(s(w),s(I),s(m),s(C),s(h),s(cl),s(B),s(ml),s(g),s(Il),s(Z),s(Cl),s(bl),s(G),s(hl),s(f),s(Bl),s(gl),s(Zl),s(Al),s(x),s(Gl),s(fl),s(Wl),s($),s(Vl),s(z),s(xl),s(vl),s(Xl),s($l),s(zl),s(kl),s(El),s(R),s(Yl),s(F),s(Ql),s(_),s(Sl),s(Nl),s(H),s(Rl),s(L),s(Fl),s(D),s(_l),s(P),s(ql),s(K),s(Hl),s(O),s(Ll),s(Dl),s(Pl),s(sl),s(Kl),s(Ol),s(nl),s(le),s(ee),s(se),s(il),s(te),s(ne),s(yl),s(ae),s(Me),s(ie),s(rl),s(pe),s(ul),s(ye),s(Ul),s(oe),s(jl),s(Je),s(re),s(wl)),s(T),U(j,l),U(A,l),U(b,l),U(W,l),U(V,l),U(v,l),U(X,l),U(k,l),U(E,l),U(Y,l),U(Q,l),U(S,l),U(N,l),U(q,l),U(ll,l),U(el,l),U(tl,l),U(al,l),U(Ml,l),U(pl,l),U(ol,l),U(Jl,l),U(Tl,l)}}}const ss='{"title":"Graphe d’analyse de documents","local":"graphe-danalyse-de-documents","sections":[{"title":"Le workflow du majordome","local":"le-workflow-du-majordome","sections":[],"depth":2},{"title":"Configuration de l’environnement","local":"configuration-de-lenvironnement","sections":[],"depth":2},{"title":"Définir l’état de l’agent","local":"définir-létat-de-lagent","sections":[],"depth":2},{"title":"Préparer les outils","local":"préparer-les-outils","sections":[],"depth":2},{"title":"Les nœuds","local":"les-nœuds","sections":[],"depth":2},{"title":"Le modèle ReAct : Comment j’aide M. Wayne","local":"le-modèle-react--comment-jaide-m-wayne","sections":[],"depth":2},{"title":"Le majordome en action","local":"le-majordome-en-action","sections":[{"title":"Exemple 1 : Calculs simples","local":"exemple-1--calculs-simples","sections":[],"depth":3},{"title":"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne","local":"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne","sections":[],"depth":3}],"depth":2},{"title":"Points clés à retenir","local":"points-clés-à-retenir","sections":[],"depth":2}],"depth":1}';function ts(dl){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends He{constructor(T){super(),Le(this,T,ts,es,Fe,{})}}export{os as component};
