import{s as pn,o as fn,n as dn}from"../chunks/scheduler.182ea377.js";import{S as cn,i as un,g as i,s as a,p as v,A as mn,h as o,f as t,c as s,j as h,q as b,m as f,k as p,v as n,a as l,r as D,d as x,t as w,u as M}from"../chunks/index.008d68e4.js";import{T as hn}from"../chunks/Tip.4f096367.js";import{D as T}from"../chunks/Docstring.7aec8b85.js";import{C as gn}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as st}from"../chunks/IconCopyLink.96bbb92b.js";import{E as _n}from"../chunks/ExampleCodeBlock.23e54afe.js";function vn(ce){let c,$='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!';return{c(){c=i("p"),c.innerHTML=$},l(g){c=o(g,"P",{"data-svelte-h":!0}),f(c)!=="svelte-1j961ct"&&(c.innerHTML=$)},m(g,_){l(g,c,_)},p:dn,d(g){g&&t(c)}}}function bn(ce){let c,$="Examples:",g,_,P;return _=new gn({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxETTNEUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTERNM0RQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZsZG0zZC00YyUyMiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCklMEFyZ2JfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyMCUzRCUyMG91dHB1dC5yZ2IlMkMlMjBvdXRwdXQuZGVwdGglMEFyZ2JfaW1hZ2UlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2xkbTNkX3JnYi5qcGclMjIpJTBBZGVwdGhfaW1hZ2UlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2xkbTNkX2RlcHRoLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLDM3DPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionLDM3DPipeline.from_pretrained(<span class="hljs-string">&quot;Intel/ldm3d-4c&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>rgb_image, depth_image = output.rgb, output.depth
<span class="hljs-meta">&gt;&gt;&gt; </span>rgb_image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_ldm3d_rgb.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_ldm3d_depth.png&quot;</span>)`}}),{c(){c=i("p"),c.textContent=$,g=a(),v(_.$$.fragment)},l(u){c=o(u,"P",{"data-svelte-h":!0}),f(c)!=="svelte-kvfsh7"&&(c.textContent=$),g=s(u),b(_.$$.fragment,u)},m(u,V){l(u,c,V),l(u,g,V),D(_,u,V),P=!0},p:dn,i(u){P||(x(_.$$.fragment,u),P=!0)},o(u){w(_.$$.fragment,u),P=!1},d(u){u&&(t(c),t(g)),M(_,u)}}}function Dn(ce){let c,$,g,_,P,u,V,ue,St="Text-to-(RGB, depth)",Ae,Z,Tt='LDM3D was proposed in <a href="https://huggingface.co/papers/2305.10853" rel="nofollow">LDM3D: Latent Diffusion Model for 3D</a> by Gabriela Ben Melech Stan, Diana Wofk, Scottie Fox, Alex Redden, Will Saxton, Jean Yu, Estelle Aflalo, Shao-Yen Tseng, Fabio Nonato, Matthias Muller, and Vasudev Lal. LDM3D generates an image and a depth map from a given text prompt unlike the existing text-to-image diffusion models such as <a href="./overview">Stable Diffusion</a> which only generates an image. With almost the same number of parameters, LDM3D achieves to create a latent space that can compress both the RGB images and the depth maps.',Ue,z,It="Two checkpoints are available for use:",je,q,Et='<li><a href="https://huggingface.co/Intel/ldm3d" rel="nofollow">ldm3d-original</a>. The original checkpoint used in the <a href="https://arxiv.org/pdf/2305.10853.pdf" rel="nofollow">paper</a></li> <li><a href="https://huggingface.co/Intel/ldm3d-4c" rel="nofollow">ldm3d-4c</a>. The new version of LDM3D using 4 channels inputs instead of 6-channels inputs and finetuned on higher resolution images.</li>',Oe,J,Nt="The abstract from the paper is:",Re,W,At='<em>This research paper proposes a Latent Diffusion Model for 3D (LDM3D) that generates both image and depth map data from a given text prompt, allowing users to generate RGBD images from text prompts. The LDM3D model is fine-tuned on a dataset of tuples containing an RGB image, depth map and caption, and validated through extensive experiments. We also develop an application called DepthFusion, which uses the generated RGB images and depth maps to create immersive and interactive 360-degree-view experiences using TouchDesigner. This technology has the potential to transform a wide range of industries, from entertainment and gaming to architecture and design. Overall, this paper presents a significant contribution to the field of generative AI and computer vision, and showcases the potential of LDM3D and DepthFusion to revolutionize content creation and digital experiences. A short video summarizing the approach can be found at <a href="https://t.ly/tdi2" rel="nofollow">this url</a>.</em>',Be,I,Ge,k,E,Te,F,rt,me,Ut="StableDiffusionLDM3DPipeline",He,d,X,lt,he,jt="Pipeline for text-to-image and 3D generation using LDM3D.",dt,ge,Ot=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,pt,_e,Rt="The pipeline also inherits the following loading methods:",ft,ve,Bt='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',ct,y,Y,ut,be,Gt="The call function to the pipeline for generation.",mt,N,ht,A,Q,gt,De,Ht=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,_t,U,K,vt,xe,Vt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,bt,j,ee,Dt,we,Zt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,xt,O,te,wt,Me,zt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Mt,R,ne,Lt,Le,qt="Encodes the prompt into text encoder hidden states.",Ve,C,B,Ie,ie,$t,$e,Jt="LDM3DPipelineOutput",Ze,L,oe,Pt,Pe,Wt="Output class for Stable Diffusion pipelines.",yt,G,ae,kt,ye,Ft="Call self as a function.",ze,S,H,Ee,se,Ct,ke,Xt="Upscaler",qe,re,Yt='<a href="https://arxiv.org/pdf/2311.03226.pdf" rel="nofollow">LDM3D-VR</a> is an extended version of LDM3D.',Je,le,Qt=`The abstract from the paper is:
<em>Latent diffusion models have proven to be state-of-the-art in the creation and manipulation of visual outputs. However, as far as we know, the generation of depth maps jointly with RGB is still limited. We introduce LDM3D-VR, a suite of diffusion models targeting virtual reality development that includes LDM3D-pano and LDM3D-SR. These models enable the generation of panoramic RGBD based on textual prompts and the upscaling of low-resolution inputs to high-resolution RGBD, respectively. Our models are fine-tuned from existing pretrained models on datasets containing panoramic/high-resolution RGB images, depth maps and captions. Both models are evaluated in comparison to existing related methods</em>`,We,de,Kt="Two checkpoints are available for use:",Fe,pe,en='<li><a href="https://huggingface.co/Intel/ldm3d-pano" rel="nofollow">ldm3d-pano</a>. This checkpoint enables the generation of panoramic images and requires the StableDiffusionLDM3DPipeline pipeline to be used.</li> <li><a href="https://huggingface.co/Intel/ldm3d-sr" rel="nofollow">ldm3d-sr</a>. This checkpoint enables the upscaling of RGB and depth images. Can be used in cascade after the original LDM3D pipeline using the StableDiffusionUpscaleLDM3DPipeline from communauty pipeline.</li>',Xe;return u=new st({}),I=new hn({props:{$$slots:{default:[vn]},$$scope:{ctx:ce}}}),F=new st({}),X=new T({props:{name:"class diffusers.StableDiffusionLDM3DPipeline",anchor:"diffusers.StableDiffusionLDM3DPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": Optional"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLDM3DPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L84"}}),Y=new T({props:{name:"__call__",anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 49"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L544",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),N=new _n({props:{anchor:"diffusers.StableDiffusionLDM3DPipeline.__call__.example",$$slots:{default:[bn]},$$scope:{ctx:ce}}}),Q=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionLDM3DPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L177"}}),K=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionLDM3DPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L194"}}),ee=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionLDM3DPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L169"}}),te=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionLDM3DPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L185"}}),ne=new T({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionLDM3DPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L235"}}),ie=new st({}),oe=new T({props:{name:"class diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput",parameters:[{name:"rgb",val:": Union"},{name:"depth",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput.rgb",description:`<strong>rgb</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"rgb"},{anchor:"diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput.depth",description:`<strong>depth</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"depth"},{anchor:"diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_ldm3d/pipeline_stable_diffusion_ldm3d.py#L62"}}),ae=new T({props:{name:"__call__",anchor:"diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),se=new st({}),{c(){c=i("meta"),$=a(),g=i("h1"),_=i("a"),P=i("span"),v(u.$$.fragment),V=a(),ue=i("span"),ue.textContent=St,Ae=a(),Z=i("p"),Z.innerHTML=Tt,Ue=a(),z=i("p"),z.textContent=It,je=a(),q=i("ul"),q.innerHTML=Et,Oe=a(),J=i("p"),J.textContent=Nt,Re=a(),W=i("p"),W.innerHTML=At,Be=a(),v(I.$$.fragment),Ge=a(),k=i("h2"),E=i("a"),Te=i("span"),v(F.$$.fragment),rt=a(),me=i("span"),me.textContent=Ut,He=a(),d=i("div"),v(X.$$.fragment),lt=a(),he=i("p"),he.textContent=jt,dt=a(),ge=i("p"),ge.innerHTML=Ot,pt=a(),_e=i("p"),_e.textContent=Rt,ft=a(),ve=i("ul"),ve.innerHTML=Bt,ct=a(),y=i("div"),v(Y.$$.fragment),ut=a(),be=i("p"),be.textContent=Gt,mt=a(),v(N.$$.fragment),ht=a(),A=i("div"),v(Q.$$.fragment),gt=a(),De=i("p"),De.innerHTML=Ht,_t=a(),U=i("div"),v(K.$$.fragment),vt=a(),xe=i("p"),xe.innerHTML=Vt,bt=a(),j=i("div"),v(ee.$$.fragment),Dt=a(),we=i("p"),we.textContent=Zt,xt=a(),O=i("div"),v(te.$$.fragment),wt=a(),Me=i("p"),Me.textContent=zt,Mt=a(),R=i("div"),v(ne.$$.fragment),Lt=a(),Le=i("p"),Le.textContent=qt,Ve=a(),C=i("h2"),B=i("a"),Ie=i("span"),v(ie.$$.fragment),$t=a(),$e=i("span"),$e.textContent=Jt,Ze=a(),L=i("div"),v(oe.$$.fragment),Pt=a(),Pe=i("p"),Pe.textContent=Wt,yt=a(),G=i("div"),v(ae.$$.fragment),kt=a(),ye=i("p"),ye.textContent=Ft,ze=a(),S=i("h1"),H=i("a"),Ee=i("span"),v(se.$$.fragment),Ct=a(),ke=i("span"),ke.textContent=Xt,qe=a(),re=i("p"),re.innerHTML=Yt,Je=a(),le=i("p"),le.innerHTML=Qt,We=a(),de=i("p"),de.textContent=Kt,Fe=a(),pe=i("ul"),pe.innerHTML=en,this.h()},l(e){const r=mn("svelte-1phssyn",document.head);c=o(r,"META",{name:!0,content:!0}),r.forEach(t),$=s(e),g=o(e,"H1",{class:!0});var fe=h(g);_=o(fe,"A",{id:!0,class:!0,href:!0});var Ne=h(_);P=o(Ne,"SPAN",{});var tn=h(P);b(u.$$.fragment,tn),tn.forEach(t),Ne.forEach(t),V=s(fe),ue=o(fe,"SPAN",{"data-svelte-h":!0}),f(ue)!=="svelte-mzgej2"&&(ue.textContent=St),fe.forEach(t),Ae=s(e),Z=o(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1i3wty2"&&(Z.innerHTML=Tt),Ue=s(e),z=o(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1lk6a0a"&&(z.textContent=It),je=s(e),q=o(e,"UL",{"data-svelte-h":!0}),f(q)!=="svelte-8ac7fv"&&(q.innerHTML=Et),Oe=s(e),J=o(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-1cwsb16"&&(J.textContent=Nt),Re=s(e),W=o(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-llz6tv"&&(W.innerHTML=At),Be=s(e),b(I.$$.fragment,e),Ge=s(e),k=o(e,"H2",{class:!0});var Ye=h(k);E=o(Ye,"A",{id:!0,class:!0,href:!0});var nn=h(E);Te=o(nn,"SPAN",{});var on=h(Te);b(F.$$.fragment,on),on.forEach(t),nn.forEach(t),rt=s(Ye),me=o(Ye,"SPAN",{"data-svelte-h":!0}),f(me)!=="svelte-1t6ubfx"&&(me.textContent=Ut),Ye.forEach(t),He=s(e),d=o(e,"DIV",{class:!0});var m=h(d);b(X.$$.fragment,m),lt=s(m),he=o(m,"P",{"data-svelte-h":!0}),f(he)!=="svelte-jq75w6"&&(he.textContent=jt),dt=s(m),ge=o(m,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-s6xyvg"&&(ge.innerHTML=Ot),pt=s(m),_e=o(m,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-14s6m4u"&&(_e.textContent=Rt),ft=s(m),ve=o(m,"UL",{"data-svelte-h":!0}),f(ve)!=="svelte-1kastu5"&&(ve.innerHTML=Bt),ct=s(m),y=o(m,"DIV",{class:!0});var Ce=h(y);b(Y.$$.fragment,Ce),ut=s(Ce),be=o(Ce,"P",{"data-svelte-h":!0}),f(be)!=="svelte-50j04k"&&(be.textContent=Gt),mt=s(Ce),b(N.$$.fragment,Ce),Ce.forEach(t),ht=s(m),A=o(m,"DIV",{class:!0});var Qe=h(A);b(Q.$$.fragment,Qe),gt=s(Qe),De=o(Qe,"P",{"data-svelte-h":!0}),f(De)!=="svelte-1s3c06i"&&(De.innerHTML=Ht),Qe.forEach(t),_t=s(m),U=o(m,"DIV",{class:!0});var Ke=h(U);b(K.$$.fragment,Ke),vt=s(Ke),xe=o(Ke,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-pkn4ui"&&(xe.innerHTML=Vt),Ke.forEach(t),bt=s(m),j=o(m,"DIV",{class:!0});var et=h(j);b(ee.$$.fragment,et),Dt=s(et),we=o(et,"P",{"data-svelte-h":!0}),f(we)!=="svelte-14bnrb6"&&(we.textContent=Zt),et.forEach(t),xt=s(m),O=o(m,"DIV",{class:!0});var tt=h(O);b(te.$$.fragment,tt),wt=s(tt),Me=o(tt,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1xwrf7t"&&(Me.textContent=zt),tt.forEach(t),Mt=s(m),R=o(m,"DIV",{class:!0});var nt=h(R);b(ne.$$.fragment,nt),Lt=s(nt),Le=o(nt,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-16q0ax1"&&(Le.textContent=qt),nt.forEach(t),m.forEach(t),Ve=s(e),C=o(e,"H2",{class:!0});var it=h(C);B=o(it,"A",{id:!0,class:!0,href:!0});var an=h(B);Ie=o(an,"SPAN",{});var sn=h(Ie);b(ie.$$.fragment,sn),sn.forEach(t),an.forEach(t),$t=s(it),$e=o(it,"SPAN",{"data-svelte-h":!0}),f($e)!=="svelte-vv15mk"&&($e.textContent=Jt),it.forEach(t),Ze=s(e),L=o(e,"DIV",{class:!0});var Se=h(L);b(oe.$$.fragment,Se),Pt=s(Se),Pe=o(Se,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1qpjiuf"&&(Pe.textContent=Wt),yt=s(Se),G=o(Se,"DIV",{class:!0});var ot=h(G);b(ae.$$.fragment,ot),kt=s(ot),ye=o(ot,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1eed40t"&&(ye.textContent=Ft),ot.forEach(t),Se.forEach(t),ze=s(e),S=o(e,"H1",{class:!0});var at=h(S);H=o(at,"A",{id:!0,class:!0,href:!0});var rn=h(H);Ee=o(rn,"SPAN",{});var ln=h(Ee);b(se.$$.fragment,ln),ln.forEach(t),rn.forEach(t),Ct=s(at),ke=o(at,"SPAN",{"data-svelte-h":!0}),f(ke)!=="svelte-fui9d6"&&(ke.textContent=Xt),at.forEach(t),qe=s(e),re=o(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-1dc6fr0"&&(re.innerHTML=Yt),Je=s(e),le=o(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-1k3azh3"&&(le.innerHTML=Qt),We=s(e),de=o(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1lk6a0a"&&(de.textContent=Kt),Fe=s(e),pe=o(e,"UL",{"data-svelte-h":!0}),f(pe)!=="svelte-sdp7m1"&&(pe.innerHTML=en),this.h()},h(){p(c,"name","hf:doc:metadata"),p(c,"content",JSON.stringify(xn)),p(_,"id","texttorgb-depth"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#texttorgb-depth"),p(g,"class","relative group"),p(E,"id","diffusers.StableDiffusionLDM3DPipeline"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#diffusers.StableDiffusionLDM3DPipeline"),p(k,"class","relative group"),p(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(B,"id","diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput"),p(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(B,"href","#diffusers.pipelines.stable_diffusion_ldm3d.pipeline_stable_diffusion_ldm3d.LDM3DPipelineOutput"),p(C,"class","relative group"),p(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(H,"id","upscaler"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#upscaler"),p(S,"class","relative group")},m(e,r){n(document.head,c),l(e,$,r),l(e,g,r),n(g,_),n(_,P),D(u,P,null),n(g,V),n(g,ue),l(e,Ae,r),l(e,Z,r),l(e,Ue,r),l(e,z,r),l(e,je,r),l(e,q,r),l(e,Oe,r),l(e,J,r),l(e,Re,r),l(e,W,r),l(e,Be,r),D(I,e,r),l(e,Ge,r),l(e,k,r),n(k,E),n(E,Te),D(F,Te,null),n(k,rt),n(k,me),l(e,He,r),l(e,d,r),D(X,d,null),n(d,lt),n(d,he),n(d,dt),n(d,ge),n(d,pt),n(d,_e),n(d,ft),n(d,ve),n(d,ct),n(d,y),D(Y,y,null),n(y,ut),n(y,be),n(y,mt),D(N,y,null),n(d,ht),n(d,A),D(Q,A,null),n(A,gt),n(A,De),n(d,_t),n(d,U),D(K,U,null),n(U,vt),n(U,xe),n(d,bt),n(d,j),D(ee,j,null),n(j,Dt),n(j,we),n(d,xt),n(d,O),D(te,O,null),n(O,wt),n(O,Me),n(d,Mt),n(d,R),D(ne,R,null),n(R,Lt),n(R,Le),l(e,Ve,r),l(e,C,r),n(C,B),n(B,Ie),D(ie,Ie,null),n(C,$t),n(C,$e),l(e,Ze,r),l(e,L,r),D(oe,L,null),n(L,Pt),n(L,Pe),n(L,yt),n(L,G),D(ae,G,null),n(G,kt),n(G,ye),l(e,ze,r),l(e,S,r),n(S,H),n(H,Ee),D(se,Ee,null),n(S,Ct),n(S,ke),l(e,qe,r),l(e,re,r),l(e,Je,r),l(e,le,r),l(e,We,r),l(e,de,r),l(e,Fe,r),l(e,pe,r),Xe=!0},p(e,[r]){const fe={};r&2&&(fe.$$scope={dirty:r,ctx:e}),I.$set(fe);const Ne={};r&2&&(Ne.$$scope={dirty:r,ctx:e}),N.$set(Ne)},i(e){Xe||(x(u.$$.fragment,e),x(I.$$.fragment,e),x(F.$$.fragment,e),x(X.$$.fragment,e),x(Y.$$.fragment,e),x(N.$$.fragment,e),x(Q.$$.fragment,e),x(K.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(ne.$$.fragment,e),x(ie.$$.fragment,e),x(oe.$$.fragment,e),x(ae.$$.fragment,e),x(se.$$.fragment,e),Xe=!0)},o(e){w(u.$$.fragment,e),w(I.$$.fragment,e),w(F.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),w(N.$$.fragment,e),w(Q.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),w(ie.$$.fragment,e),w(oe.$$.fragment,e),w(ae.$$.fragment,e),w(se.$$.fragment,e),Xe=!1},d(e){e&&(t($),t(g),t(Ae),t(Z),t(Ue),t(z),t(je),t(q),t(Oe),t(J),t(Re),t(W),t(Be),t(Ge),t(k),t(He),t(d),t(Ve),t(C),t(Ze),t(L),t(ze),t(S),t(qe),t(re),t(Je),t(le),t(We),t(de),t(Fe),t(pe)),t(c),M(u),M(I,e),M(F),M(X),M(Y),M(N),M(Q),M(K),M(ee),M(te),M(ne),M(ie),M(oe),M(ae),M(se)}}}const xn={local:"upscaler",title:"Upscaler"};function wn(ce){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sn extends cn{constructor(c){super(),un(this,c,wn,Dn,pn,{})}}export{Sn as component};
