import{s as ss,o as ls,n as ts}from"../chunks/scheduler.182ea377.js";import{S as as,i as ns,g as i,s as a,r as c,A as is,h as p,f as s,c as n,j as Kt,u as f,x as o,k as Ot,y as ps,a as l,v as m,d as u,t as h,w as M}from"../chunks/index.abf12888.js";import{T as es}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as os}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as be}from"../chunks/Heading.16916d63.js";function rs(ge){let r,w='LoRA checkpoints in the diffusion community are almost always obtained with <a href="https://huggingface.co/docs/diffusers/main/en/training/dreambooth" rel="nofollow">DreamBooth</a>. DreamBooth training often relies on “trigger” words in the input text prompts in order for the generation results to look as expected. When you combine multiple LoRA checkpoints, it’s important to ensure the trigger words for the corresponding LoRA checkpoints are present in the input text prompts.';return{c(){r=i("p"),r.innerHTML=w},l(d){r=p(d,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1efkoll"&&(r.innerHTML=w)},m(d,g){l(d,r,g)},p:ts,d(d){d&&s(r)}}}function cs(ge){let r,w='You can refer to the <code>torch.compile()</code> section <a href="https://huggingface.co/docs/diffusers/main/en/optimization/torch2.0#torchcompile" rel="nofollow">here</a> and <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow">here</a> for more elaborate examples.';return{c(){r=i("p"),r.innerHTML=w},l(d){r=p(d,"P",{"data-svelte-h":!0}),o(r)!=="svelte-ppgklo"&&(r.innerHTML=w)},m(d,g){l(d,r,g)},p:ts,d(d){d&&s(r)}}}function fs(ge){let r,w,d,g,J,Je,j,je,T,Jt='There are many adapters (with LoRAs being the most common type) trained in different styles to achieve different effects. You can even combine multiple adapters to create new and unique images. With the 🤗 <a href="https://huggingface.co/docs/peft/index" rel="nofollow">PEFT</a> integration in 🤗 Diffusers, it is really easy to load and manage adapters for inference. In this guide, you’ll learn how to use different adapters with <a href="../api/pipelines/stable_diffusion/stable_diffusion_xl">Stable Diffusion XL (SDXL)</a> for inference.',Te,_,jt='Throughout this guide, you’ll use LoRA as the main adapter technique, so we’ll use the terms LoRA and adapter interchangeably. You should have some familiarity with LoRA, and if you don’t, we welcome you to check out the <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">LoRA guide</a>.',_e,Z,Tt="Let’s first install all the required libraries.",Ze,B,Be,$,_t="Now, let’s load a pipeline with a SDXL checkpoint:",$e,G,Ge,C,Zt='Next, load a LoRA checkpoint with the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method.',Ce,I,Bt="With the 🤗 PEFT integration, you can assign a specific <code>adapter_name</code> to the checkpoint, which let’s you easily switch between different LoRA checkpoints. Let’s call this adapter <code>&quot;toy&quot;</code>.",Ie,X,Xe,v,$t="And then perform inference:",ve,R,Re,k,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/peft_integration/diffusers_peft_lora_inference_8_1.png" alt="toy-face"/>',ke,x,Ct='With the <code>adapter_name</code> parameter, it is really easy to use another adapter for inference! Load the <a href="https://huggingface.co/nerijs/pixel-art-xl" rel="nofollow">nerijs/pixel-art-xl</a> adapter that has been fine-tuned to generate pixel art images, and let’s call it <code>&quot;pixel&quot;</code>.',xe,W,It='The pipeline automatically sets the first loaded adapter (<code>&quot;toy&quot;</code>) as the active adapter. But you can activate the <code>&quot;pixel&quot;</code> adapter with the <a href="/docs/diffusers/main/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method as shown below:',We,V,Ve,q,Xt="Let’s now generate an image with the second adapter and check the result:",qe,F,Fe,Y,vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/peft_integration/diffusers_peft_lora_inference_12_1.png" alt="pixel-art"/>',Ye,H,He,L,Rt="You can also perform multi-adapter inference where you combine different adapter checkpoints for inference.",Le,N,kt='Once again, use the <a href="/docs/diffusers/main/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method to activate two LoRA checkpoints and specify the weight for how the checkpoints should be combined.',Ne,Q,Qe,z,xt="Now that we have set these two adapters, let’s generate an image from the combined adapters!",ze,b,Se,S,Wt='The trigger words for <a href="https://hf.co/CiroN2022/toy-face" rel="nofollow">CiroN2022/toy-face</a> and <a href="https://hf.co/nerijs/pixel-art-xl" rel="nofollow">nerijs/pixel-art-xl</a> are found in their repositories.',Ee,E,Ae,A,Vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/peft_integration/diffusers_peft_lora_inference_16_1.png" alt="toy-face-pixel-art"/>',De,D,qt="Impressive! As you can see, the model was able to generate an image that mixes the characteristics of both adapters.",Pe,P,Ft='If you want to go back to using only one adapter, use the <a href="/docs/diffusers/main/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method to activate the <code>&quot;toy&quot;</code> adapter:',Ke,K,Oe,O,Yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/peft_integration/diffusers_peft_lora_inference_18_1.png" alt="toy-face-again"/>',et,ee,Ht='If you want to switch to only the base model, disable all LoRAs with the <a href="/docs/diffusers/main/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora">disable_lora()</a> method.',tt,te,st,se,Lt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/peft_integration/diffusers_peft_lora_inference_20_1.png" alt="no-lora"/>',lt,le,at,ae,Nt='You have attached multiple adapters in this tutorial, and if you’re feeling a bit lost on what adapters have been attached to the pipeline’s components, you can easily check the list of active adapters using the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.get_active_adapters">get_active_adapters()</a> method:',nt,ne,it,ie,Qt='You can also get the active adapters of each pipeline component with <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.get_list_adapters">get_list_adapters()</a>:',pt,pe,ot,oe,rt,re,zt="If you want to compile your model with <code>torch.compile</code> make sure to first fuse the LoRA weights into the base model and unload them.",ct,ce,ft,U,mt,fe,ut,me,St='You can use PEFT to easily fuse/unfuse multiple adapters directly into the model weights (both UNet and text encoder) using the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.fuse_lora">fuse_lora()</a> method, which can lead to a speed-up in inference and lower VRAM usage.',ht,ue,Mt,he,Et="You can also fuse some adapters using <code>adapter_names</code> for faster generation:",dt,Me,yt,de,wt,ye,At="To properly save a pipeline after it’s been loaded with the adapters, it should be serialized like so:",gt,we,bt,Ue,Ut;return J=new os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/using_peft_for_inference.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/using_peft_for_inference.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/using_peft_for_inference.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/using_peft_for_inference.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/using_peft_for_inference.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/using_peft_for_inference.ipynb"}]}}),j=new be({props:{title:"Load LoRAs for inference",local:"load-loras-for-inference",headingTag:"h1"}}),B=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMEEhcGlwJTIwaW5zdGFsbCUyMHBlZnQlMEEhcGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:`!pip install -q transformers accelerate
!pip install peft
!pip install diffusers`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
pipe = DiffusionPipeline.from_pretrained(pipe_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),X=new y({props:{code:"cGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJDaXJvTjIwMjIlMkZ0b3ktZmFjZSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIydG95X2ZhY2Vfc2R4bC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRveSUyMik=",highlighted:'pipe.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy&quot;</span>)',wrap:!1}}),R=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIydG95X2ZhY2UlMjBvZiUyMGElMjBoYWNrZXIlMjB3aXRoJTIwYSUyMGhvb2RpZSUyMiUwQSUwQWxvcmFfc2NhbGUlM0QlMjAwLjklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMnNjYWxlJTIyJTNBJTIwbG9yYV9zY2FsZSU3RCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;toy_face of a hacker with a hoodie&quot;</span>

lora_scale= <span class="hljs-number">0.9</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">30</span>, cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: lora_scale}, generator=torch.manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),V=new y({props:{code:"cGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJuZXJpanMlMkZwaXhlbC1hcnQteGwlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnBpeGVsLWFydC14bC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGUuc2V0X2FkYXB0ZXJzKCUyMnBpeGVsJTIyKQ==",highlighted:`pipe.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipe.set_adapters(<span class="hljs-string">&quot;pixel&quot;</span>)`,wrap:!1}}),F=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGhhY2tlciUyMHdpdGglMjBhJTIwaG9vZGllJTJDJTIwcGl4ZWwlMjBhcnQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMnNjYWxlJTIyJTNBJTIwbG9yYV9zY2FsZSU3RCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;a hacker with a hoodie, pixel art&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">30</span>, cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: lora_scale}, generator=torch.manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),H=new be({props:{title:"Combine multiple adapters",local:"combine-multiple-adapters",headingTag:"h2"}}),Q=new y({props:{code:"cGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIycGl4ZWwlMjIlMkMlMjAlMjJ0b3klMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjUlMkMlMjAxLjAlNUQp",highlighted:'pipe.set_adapters([<span class="hljs-string">&quot;pixel&quot;</span>, <span class="hljs-string">&quot;toy&quot;</span>], adapter_weights=[<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>])',wrap:!1}}),b=new es({props:{$$slots:{default:[rs]},$$scope:{ctx:ge}}}),E=new y({props:{code:"JTIzJTIwTm90aWNlJTIwaG93JTIwdGhlJTIwcHJvbXB0JTIwaXMlMjBjb25zdHJ1Y3RlZC4lMEFwcm9tcHQlMjAlM0QlMjAlMjJ0b3lfZmFjZSUyMG9mJTIwYSUyMGhhY2tlciUyMHdpdGglMjBhJTIwaG9vZGllJTJDJTIwcGl4ZWwlMjBhcnQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMnNjYWxlJTIyJTNBJTIwMS4wJTdEJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-comment"># Notice how the prompt is constructed.</span>
prompt = <span class="hljs-string">&quot;toy_face of a hacker with a hoodie, pixel art&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">30</span>, cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1.0</span>}, generator=torch.manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),K=new y({props:{code:"JTIzJTIwRmlyc3QlMkMlMjBzZXQlMjB0aGUlMjBhZGFwdGVyLiUwQXBpcGUuc2V0X2FkYXB0ZXJzKCUyMnRveSUyMiklMEElMEElMjMlMjBUaGVuJTJDJTIwcnVuJTIwaW5mZXJlbmNlLiUwQXByb21wdCUyMCUzRCUyMCUyMnRveV9mYWNlJTIwb2YlMjBhJTIwaGFja2VyJTIwd2l0aCUyMGElMjBob29kaWUlMjIlMEFsb3JhX3NjYWxlJTNEJTIwMC45JTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGNyb3NzX2F0dGVudGlvbl9rd2FyZ3MlM0QlN0IlMjJzY2FsZSUyMiUzQSUyMGxvcmFfc2NhbGUlN0QlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-comment"># First, set the adapter.</span>
pipe.set_adapters(<span class="hljs-string">&quot;toy&quot;</span>)

<span class="hljs-comment"># Then, run inference.</span>
prompt = <span class="hljs-string">&quot;toy_face of a hacker with a hoodie&quot;</span>
lora_scale= <span class="hljs-number">0.9</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">30</span>, cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: lora_scale}, generator=torch.manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),te=new y({props:{code:"cGlwZS5kaXNhYmxlX2xvcmEoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnRveV9mYWNlJTIwb2YlMjBhJTIwaGFja2VyJTIwd2l0aCUyMGElMjBob29kaWUlMjIlMEFsb3JhX3NjYWxlJTNEJTIwMC45JTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipe.disable_lora()

prompt = <span class="hljs-string">&quot;toy_face of a hacker with a hoodie&quot;</span>
lora_scale= <span class="hljs-number">0.9</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),le=new be({props:{title:"Monitoring active adapters",local:"monitoring-active-adapters",headingTag:"h2"}}),ne=new y({props:{code:"YWN0aXZlX2FkYXB0ZXJzJTIwJTNEJTIwcGlwZS5nZXRfYWN0aXZlX2FkYXB0ZXJzKCklMEFhY3RpdmVfYWRhcHRlcnMlMEElNUIlMjJ0b3klMjIlMkMlMjAlMjJwaXhlbCUyMiU1RA==",highlighted:`active_adapters = pipe.get_active_adapters()
active_adapters
[<span class="hljs-string">&quot;toy&quot;</span>, <span class="hljs-string">&quot;pixel&quot;</span>]`,wrap:!1}}),pe=new y({props:{code:"bGlzdF9hZGFwdGVyc19jb21wb25lbnRfd2lzZSUyMCUzRCUyMHBpcGUuZ2V0X2xpc3RfYWRhcHRlcnMoKSUwQWxpc3RfYWRhcHRlcnNfY29tcG9uZW50X3dpc2UlMEElN0IlMjJ0ZXh0X2VuY29kZXIlMjIlM0ElMjAlNUIlMjJ0b3klMjIlMkMlMjAlMjJwaXhlbCUyMiU1RCUyQyUyMCUyMnVuZXQlMjIlM0ElMjAlNUIlMjJ0b3klMjIlMkMlMjAlMjJwaXhlbCUyMiU1RCUyQyUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwJTVCJTIydG95JTIyJTJDJTIwJTIycGl4ZWwlMjIlNUQlN0Q=",highlighted:`list_adapters_component_wise = pipe.get_list_adapters()
list_adapters_component_wise
{<span class="hljs-string">&quot;text_encoder&quot;</span>: [<span class="hljs-string">&quot;toy&quot;</span>, <span class="hljs-string">&quot;pixel&quot;</span>], <span class="hljs-string">&quot;unet&quot;</span>: [<span class="hljs-string">&quot;toy&quot;</span>, <span class="hljs-string">&quot;pixel&quot;</span>], <span class="hljs-string">&quot;text_encoder_2&quot;</span>: [<span class="hljs-string">&quot;toy&quot;</span>, <span class="hljs-string">&quot;pixel&quot;</span>]}`,wrap:!1}}),oe=new be({props:{title:"Compatibility with torch.compile",local:"compatibility-with-torchcompile",headingTag:"h2"}}),ce=new y({props:{code:"cGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJuZXJpanMlMkZwaXhlbC1hcnQteGwlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnBpeGVsLWFydC14bC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyQ2lyb04yMDIyJTJGdG95LWZhY2UlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnRveV9mYWNlX3NkeGwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJ0b3klMjIpJTBBJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIycGl4ZWwlMjIlMkMlMjAlMjJ0b3klMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjUlMkMlMjAxLjAlNUQpJTBBJTIzJTIwRnVzZXMlMjB0aGUlMjBMb1JBcyUyMGludG8lMjB0aGUlMjBVbmV0JTBBcGlwZS5mdXNlX2xvcmEoKSUwQXBpcGUudW5sb2FkX2xvcmFfd2VpZ2h0cygpJTBBJTBBJTJCJTIwcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUyQiUyMHBpcGUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZS51bmV0JTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIydG95X2ZhY2UlMjBvZiUyMGElMjBoYWNrZXIlMjB3aXRoJTIwYSUyMGhvb2RpZSUyQyUyMHBpeGVsJTIwYXJ0JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe.load_lora_weights(&quot;nerijs/pixel-art-xl&quot;, weight_name=&quot;pixel-art-xl.safetensors&quot;, adapter_name=&quot;pixel&quot;)
pipe.load_lora_weights(&quot;CiroN2022/toy-face&quot;, weight_name=&quot;toy_face_sdxl.safetensors&quot;, adapter_name=&quot;toy&quot;)

pipe.set_adapters([&quot;pixel&quot;, &quot;toy&quot;], adapter_weights=[0.5, 1.0])
# Fuses the LoRAs into the Unet
pipe.fuse_lora()
pipe.unload_lora_weights()

<span class="hljs-addition">+ pipe.unet.to(memory_format=torch.channels_last)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>

prompt = &quot;toy_face of a hacker with a hoodie, pixel art&quot;
image = pipe(prompt, num_inference_steps=30, generator=torch.manual_seed(0)).images[0]`,wrap:!1}}),U=new es({props:{warning:!1,$$slots:{default:[cs]},$$scope:{ctx:ge}}}),fe=new be({props:{title:"Fusing adapters into the model",local:"fusing-adapters-into-the-model",headingTag:"h2"}}),ue=new y({props:{code:"cGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJuZXJpanMlMkZwaXhlbC1hcnQteGwlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnBpeGVsLWFydC14bC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyQ2lyb04yMDIyJTJGdG95LWZhY2UlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnRveV9mYWNlX3NkeGwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJ0b3klMjIpJTBBJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIycGl4ZWwlMjIlMkMlMjAlMjJ0b3klMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjUlMkMlMjAxLjAlNUQpJTBBJTIzJTIwRnVzZXMlMjB0aGUlMjBMb1JBcyUyMGludG8lMjB0aGUlMjBVbmV0JTBBcGlwZS5mdXNlX2xvcmEoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnRveV9mYWNlJTIwb2YlMjBhJTIwaGFja2VyJTIwd2l0aCUyMGElMjBob29kaWUlMkMlMjBwaXhlbCUyMGFydCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzAlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgwKSkuaW1hZ2VzJTVCMCU1RCUwQSUwQSUyMyUyMEdldHMlMjB0aGUlMjBVbmV0JTIwYmFjayUyMHRvJTIwdGhlJTIwb3JpZ2luYWwlMjBzdGF0ZSUwQXBpcGUudW5mdXNlX2xvcmEoKQ==",highlighted:`pipe.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;pixel&quot;</span>, <span class="hljs-string">&quot;toy&quot;</span>], adapter_weights=[<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>])
<span class="hljs-comment"># Fuses the LoRAs into the Unet</span>
pipe.fuse_lora()

prompt = <span class="hljs-string">&quot;toy_face of a hacker with a hoodie, pixel art&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Gets the Unet back to the original state</span>
pipe.unfuse_lora()`,wrap:!1}}),Me=new y({props:{code:"cGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJuZXJpanMlMkZwaXhlbC1hcnQteGwlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnBpeGVsLWFydC14bC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyQ2lyb04yMDIyJTJGdG95LWZhY2UlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnRveV9mYWNlX3NkeGwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJ0b3klMjIpJTBBJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIycGl4ZWwlMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjUlMkMlMjAxLjAlNUQpJTBBJTIzJTIwRnVzZXMlMjB0aGUlMjBMb1JBcyUyMGludG8lMjB0aGUlMjBVbmV0JTBBcGlwZS5mdXNlX2xvcmEoYWRhcHRlcl9uYW1lcyUzRCU1QiUyMnBpeGVsJTIyJTVEKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBoYWNrZXIlMjB3aXRoJTIwYSUyMGhvb2RpZSUyQyUyMHBpeGVsJTIwYXJ0JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApKS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwR2V0cyUyMHRoZSUyMFVuZXQlMjBiYWNrJTIwdG8lMjB0aGUlMjBvcmlnaW5hbCUyMHN0YXRlJTBBcGlwZS51bmZ1c2VfbG9yYSgpJTBBJTBBJTIzJTIwRnVzZSUyMGFsbCUyMGFkYXB0ZXJzJTBBcGlwZS5mdXNlX2xvcmEoYWRhcHRlcl9uYW1lcyUzRCU1QiUyMnBpeGVsJTIyJTJDJTIwJTIydG95JTIyJTVEKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnRveV9mYWNlJTIwb2YlMjBhJTIwaGFja2VyJTIwd2l0aCUyMGElMjBob29kaWUlMkMlMjBwaXhlbCUyMGFydCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzAlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgwKSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipe.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;pixel&quot;</span>], adapter_weights=[<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>])
<span class="hljs-comment"># Fuses the LoRAs into the Unet</span>
pipe.fuse_lora(adapter_names=[<span class="hljs-string">&quot;pixel&quot;</span>])

prompt = <span class="hljs-string">&quot;a hacker with a hoodie, pixel art&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Gets the Unet back to the original state</span>
pipe.unfuse_lora()

<span class="hljs-comment"># Fuse all adapters</span>
pipe.fuse_lora(adapter_names=[<span class="hljs-string">&quot;pixel&quot;</span>, <span class="hljs-string">&quot;toy&quot;</span>])

prompt = <span class="hljs-string">&quot;toy_face of a hacker with a hoodie, pixel art&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new be({props:{title:"Saving a pipeline after fusing the adapters",local:"saving-a-pipeline-after-fusing-the-adapters",headingTag:"h2"}}),we=new y({props:{code:"cGlwZS5mdXNlX2xvcmEobG9yYV9zY2FsZSUzRDEuMCklMEFwaXBlLnVubG9hZF9sb3JhX3dlaWdodHMoKSUwQXBpcGUuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGgtdG8tcGlwZWxpbmUlMjIp",highlighted:`pipe.fuse_lora(lora_scale=<span class="hljs-number">1.0</span>)
pipe.unload_lora_weights()
pipe.save_pretrained(<span class="hljs-string">&quot;path-to-pipeline&quot;</span>)`,wrap:!1}}),{c(){r=i("meta"),w=a(),d=i("p"),g=a(),c(J.$$.fragment),Je=a(),c(j.$$.fragment),je=a(),T=i("p"),T.innerHTML=Jt,Te=a(),_=i("p"),_.innerHTML=jt,_e=a(),Z=i("p"),Z.textContent=Tt,Ze=a(),c(B.$$.fragment),Be=a(),$=i("p"),$.textContent=_t,$e=a(),c(G.$$.fragment),Ge=a(),C=i("p"),C.innerHTML=Zt,Ce=a(),I=i("p"),I.innerHTML=Bt,Ie=a(),c(X.$$.fragment),Xe=a(),v=i("p"),v.textContent=$t,ve=a(),c(R.$$.fragment),Re=a(),k=i("p"),k.innerHTML=Gt,ke=a(),x=i("p"),x.innerHTML=Ct,xe=a(),W=i("p"),W.innerHTML=It,We=a(),c(V.$$.fragment),Ve=a(),q=i("p"),q.textContent=Xt,qe=a(),c(F.$$.fragment),Fe=a(),Y=i("p"),Y.innerHTML=vt,Ye=a(),c(H.$$.fragment),He=a(),L=i("p"),L.textContent=Rt,Le=a(),N=i("p"),N.innerHTML=kt,Ne=a(),c(Q.$$.fragment),Qe=a(),z=i("p"),z.textContent=xt,ze=a(),c(b.$$.fragment),Se=a(),S=i("p"),S.innerHTML=Wt,Ee=a(),c(E.$$.fragment),Ae=a(),A=i("p"),A.innerHTML=Vt,De=a(),D=i("p"),D.textContent=qt,Pe=a(),P=i("p"),P.innerHTML=Ft,Ke=a(),c(K.$$.fragment),Oe=a(),O=i("p"),O.innerHTML=Yt,et=a(),ee=i("p"),ee.innerHTML=Ht,tt=a(),c(te.$$.fragment),st=a(),se=i("p"),se.innerHTML=Lt,lt=a(),c(le.$$.fragment),at=a(),ae=i("p"),ae.innerHTML=Nt,nt=a(),c(ne.$$.fragment),it=a(),ie=i("p"),ie.innerHTML=Qt,pt=a(),c(pe.$$.fragment),ot=a(),c(oe.$$.fragment),rt=a(),re=i("p"),re.innerHTML=zt,ct=a(),c(ce.$$.fragment),ft=a(),c(U.$$.fragment),mt=a(),c(fe.$$.fragment),ut=a(),me=i("p"),me.innerHTML=St,ht=a(),c(ue.$$.fragment),Mt=a(),he=i("p"),he.innerHTML=Et,dt=a(),c(Me.$$.fragment),yt=a(),c(de.$$.fragment),wt=a(),ye=i("p"),ye.textContent=At,gt=a(),c(we.$$.fragment),bt=a(),Ue=i("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(s),w=n(e),d=p(e,"P",{}),Kt(d).forEach(s),g=n(e),f(J.$$.fragment,e),Je=n(e),f(j.$$.fragment,e),je=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-4ogdj"&&(T.innerHTML=Jt),Te=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-11mcdto"&&(_.innerHTML=jt),_e=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-k7bd5g"&&(Z.textContent=Tt),Ze=n(e),f(B.$$.fragment,e),Be=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-wbs9ps"&&($.textContent=_t),$e=n(e),f(G.$$.fragment,e),Ge=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-11nxks9"&&(C.innerHTML=Zt),Ce=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-cuo3fl"&&(I.innerHTML=Bt),Ie=n(e),f(X.$$.fragment,e),Xe=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1tr5was"&&(v.textContent=$t),ve=n(e),f(R.$$.fragment,e),Re=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-pa1jxn"&&(k.innerHTML=Gt),ke=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1uq2e4p"&&(x.innerHTML=Ct),xe=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-k0nn17"&&(W.innerHTML=It),We=n(e),f(V.$$.fragment,e),Ve=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-us3nir"&&(q.textContent=Xt),qe=n(e),f(F.$$.fragment,e),Fe=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ixqz7s"&&(Y.innerHTML=vt),Ye=n(e),f(H.$$.fragment,e),He=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-y4eq9d"&&(L.textContent=Rt),Le=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-k3yuwt"&&(N.innerHTML=kt),Ne=n(e),f(Q.$$.fragment,e),Qe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1l5oueb"&&(z.textContent=xt),ze=n(e),f(b.$$.fragment,e),Se=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1dxqvbn"&&(S.innerHTML=Wt),Ee=n(e),f(E.$$.fragment,e),Ae=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-azw8sd"&&(A.innerHTML=Vt),De=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1x3u637"&&(D.textContent=qt),Pe=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-12zwwmb"&&(P.innerHTML=Ft),Ke=n(e),f(K.$$.fragment,e),Oe=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-h7m96j"&&(O.innerHTML=Yt),et=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-m7kbgc"&&(ee.innerHTML=Ht),tt=n(e),f(te.$$.fragment,e),st=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-if1nej"&&(se.innerHTML=Lt),lt=n(e),f(le.$$.fragment,e),at=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-nelech"&&(ae.innerHTML=Nt),nt=n(e),f(ne.$$.fragment,e),it=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-10oc8wh"&&(ie.innerHTML=Qt),pt=n(e),f(pe.$$.fragment,e),ot=n(e),f(oe.$$.fragment,e),rt=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1twcgcq"&&(re.innerHTML=zt),ct=n(e),f(ce.$$.fragment,e),ft=n(e),f(U.$$.fragment,e),mt=n(e),f(fe.$$.fragment,e),ut=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-xkmhlw"&&(me.innerHTML=St),ht=n(e),f(ue.$$.fragment,e),Mt=n(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-10hust8"&&(he.innerHTML=Et),dt=n(e),f(Me.$$.fragment,e),yt=n(e),f(de.$$.fragment,e),wt=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-vfsma9"&&(ye.textContent=At),gt=n(e),f(we.$$.fragment,e),bt=n(e),Ue=p(e,"P",{}),Kt(Ue).forEach(s),this.h()},h(){Ot(r,"name","hf:doc:metadata"),Ot(r,"content",ms)},m(e,t){ps(document.head,r),l(e,w,t),l(e,d,t),l(e,g,t),m(J,e,t),l(e,Je,t),m(j,e,t),l(e,je,t),l(e,T,t),l(e,Te,t),l(e,_,t),l(e,_e,t),l(e,Z,t),l(e,Ze,t),m(B,e,t),l(e,Be,t),l(e,$,t),l(e,$e,t),m(G,e,t),l(e,Ge,t),l(e,C,t),l(e,Ce,t),l(e,I,t),l(e,Ie,t),m(X,e,t),l(e,Xe,t),l(e,v,t),l(e,ve,t),m(R,e,t),l(e,Re,t),l(e,k,t),l(e,ke,t),l(e,x,t),l(e,xe,t),l(e,W,t),l(e,We,t),m(V,e,t),l(e,Ve,t),l(e,q,t),l(e,qe,t),m(F,e,t),l(e,Fe,t),l(e,Y,t),l(e,Ye,t),m(H,e,t),l(e,He,t),l(e,L,t),l(e,Le,t),l(e,N,t),l(e,Ne,t),m(Q,e,t),l(e,Qe,t),l(e,z,t),l(e,ze,t),m(b,e,t),l(e,Se,t),l(e,S,t),l(e,Ee,t),m(E,e,t),l(e,Ae,t),l(e,A,t),l(e,De,t),l(e,D,t),l(e,Pe,t),l(e,P,t),l(e,Ke,t),m(K,e,t),l(e,Oe,t),l(e,O,t),l(e,et,t),l(e,ee,t),l(e,tt,t),m(te,e,t),l(e,st,t),l(e,se,t),l(e,lt,t),m(le,e,t),l(e,at,t),l(e,ae,t),l(e,nt,t),m(ne,e,t),l(e,it,t),l(e,ie,t),l(e,pt,t),m(pe,e,t),l(e,ot,t),m(oe,e,t),l(e,rt,t),l(e,re,t),l(e,ct,t),m(ce,e,t),l(e,ft,t),m(U,e,t),l(e,mt,t),m(fe,e,t),l(e,ut,t),l(e,me,t),l(e,ht,t),m(ue,e,t),l(e,Mt,t),l(e,he,t),l(e,dt,t),m(Me,e,t),l(e,yt,t),m(de,e,t),l(e,wt,t),l(e,ye,t),l(e,gt,t),m(we,e,t),l(e,bt,t),l(e,Ue,t),Ut=!0},p(e,[t]){const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),b.$set(Dt);const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),U.$set(Pt)},i(e){Ut||(u(J.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(b.$$.fragment,e),u(E.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(U.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(de.$$.fragment,e),u(we.$$.fragment,e),Ut=!0)},o(e){h(J.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(Q.$$.fragment,e),h(b.$$.fragment,e),h(E.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(oe.$$.fragment,e),h(ce.$$.fragment,e),h(U.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(we.$$.fragment,e),Ut=!1},d(e){e&&(s(w),s(d),s(g),s(Je),s(je),s(T),s(Te),s(_),s(_e),s(Z),s(Ze),s(Be),s($),s($e),s(Ge),s(C),s(Ce),s(I),s(Ie),s(Xe),s(v),s(ve),s(Re),s(k),s(ke),s(x),s(xe),s(W),s(We),s(Ve),s(q),s(qe),s(Fe),s(Y),s(Ye),s(He),s(L),s(Le),s(N),s(Ne),s(Qe),s(z),s(ze),s(Se),s(S),s(Ee),s(Ae),s(A),s(De),s(D),s(Pe),s(P),s(Ke),s(Oe),s(O),s(et),s(ee),s(tt),s(st),s(se),s(lt),s(at),s(ae),s(nt),s(it),s(ie),s(pt),s(ot),s(rt),s(re),s(ct),s(ft),s(mt),s(ut),s(me),s(ht),s(Mt),s(he),s(dt),s(yt),s(wt),s(ye),s(gt),s(bt),s(Ue)),s(r),M(J,e),M(j,e),M(B,e),M(G,e),M(X,e),M(R,e),M(V,e),M(F,e),M(H,e),M(Q,e),M(b,e),M(E,e),M(K,e),M(te,e),M(le,e),M(ne,e),M(pe,e),M(oe,e),M(ce,e),M(U,e),M(fe,e),M(ue,e),M(Me,e),M(de,e),M(we,e)}}}const ms='{"title":"Load LoRAs for inference","local":"load-loras-for-inference","sections":[{"title":"Combine multiple adapters","local":"combine-multiple-adapters","sections":[],"depth":2},{"title":"Monitoring active adapters","local":"monitoring-active-adapters","sections":[],"depth":2},{"title":"Compatibility with torch.compile","local":"compatibility-with-torchcompile","sections":[],"depth":2},{"title":"Fusing adapters into the model","local":"fusing-adapters-into-the-model","sections":[],"depth":2},{"title":"Saving a pipeline after fusing the adapters","local":"saving-a-pipeline-after-fusing-the-adapters","sections":[],"depth":2}],"depth":1}';function us(ge){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends as{constructor(r){super(),ns(this,r,us,fs,ss,{})}}export{bs as component};
