import{s as Ts,o as hs,n as us}from"../chunks/scheduler.37c15a92.js";import{S as fs,i as Cs,g as m,s as a,r as p,A as Zs,h as o,f as s,c as n,j as js,u as M,x as d,k as bs,y as Bs,a as t,v as c,d as i,t as r,w as y}from"../chunks/index.2bf4358c.js";import{T as ws}from"../chunks/Tip.363c041f.js";import{Y as Us}from"../chunks/Youtube.1e50a667.js";import{C as j}from"../chunks/CodeBlock.4e987730.js";import{C as Is}from"../chunks/CourseFloatingBanner.06521e8b.js";import{H as Xl,E as $s}from"../chunks/index.fb305b5e.js";function Gs($l){let J,w="✏️ <strong>试试看！</strong> 修改之前的训练循环以在 SST-2 数据集上微调你的模型。";return{c(){J=m("p"),J.innerHTML=w},l(b){J=o(b,"P",{"data-svelte-h":!0}),d(J)!=="svelte-n66aug"&&(J.innerHTML=w)},m(b,U){t(b,J,U)},p:us,d(b){b&&s(J)}}}function Xs($l){let J,w="⚠️ 为了使云端 TPU 提供的加速中发挥最大的效益，我们建议使用 tokenizer 的 <code>padding=max_length</code> 和 <code>max_length</code> 参数将你的样本填充到固定长度。";return{c(){J=m("p"),J.innerHTML=w},l(b){J=o(b,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1thjlh4"&&(J.innerHTML=w)},m(b,U){t(b,J,U)},p:us,d(b){b&&s(J)}}}function ks($l){let J,w,b,U,h,kl,f,Wl,C,Rl,Z,Ne="现在，我们将了解如何在不使用 <code>Trainer</code> 类的情况下实现与上一节相同的结果。同样，我们假设你已经完成了第 2 节中的数据处理。下面对第 2 节内容的一个简短总结，涵盖了你需要在本节之前运行的所有内容：",gl,B,_l,I,Yl,$,ze="在正式开始编写我们的训练循环之前，我们需要定义一些对象。首先是我们将用于迭代 batch 的数据加载器。但在定义这些数据加载器之前，我们需要对我们的 <code>tokenized_datasets</code> 进行一些后处理，以自己实现一些 Trainer 自动为我们处理的内容。具体来说，我们需要：",vl,G,Ee="<li>删除与模型不需要的列（如 <code>sentence1</code> 和 <code>sentence2</code> 列）。</li> <li>将列名 <code>label</code> 重命名为 <code>labels</code> （因为模型默认的输入是 <code>labels</code> ）。</li> <li>设置数据集的格式，使其返回 PyTorch 张量而不是列表。</li>",Vl,X,Qe="针对上面的每个步骤，我们的 <code>tokenized_datasets</code> 都有一个方法：",Al,k,Nl,W,Fe="然后，我们可以检查结果中是否只有模型能够接受的列：",zl,R,El,g,He="至此，我们可以轻松定义数据加载器：",Ql,_,Fl,Y,xe="为了快速检验数据处理中没有错误，我们可以这样检验其中的一个 batch：",Hl,v,xl,V,Sl,A,Se="请注意，这里的形状可能与你略有不同，因为我们为训练数据加载器设置了 <code>shuffle=True</code> ，并且模型会将句子填充到 <code>batch</code> 中的最大长度。",ql,N,qe="现在我们已经完全完成了数据预处理（对于任何 ML 从业者来说都是一个令人满意但难以实现的目标），让我们将注意力转向模型。我们会像在上一节中所做的那样实例化它：",Ll,z,Kl,E,Le="为了确保训练过程中一切顺利，我们将 <code>batch</code> 传递给这个模型：",Dl,Q,Pl,F,Ol,H,Ke="当我们输入 <code>labels</code> 时，🤗 Transformers 模型都将返回这个 <code>batch</code> 的 <code>loss</code> ，我们还得到了 <code>logits</code> （ <code>batch</code> 中的每个输入有两个输出，所以张量大小为 8 x 2）。",le,x,De='我们几乎准备好编写我们的训练循环了！我们只是缺少两件事：优化器和学习率调度器。由于我们试图手动实现 <code>Trainer</code> 的功能，我们将使用相同的优化器和学习率调度器。 <code>Trainer</code> 使用的优化器是 <code>AdamW</code> ，它与 <code>Adam</code> 相同，但加入了权重衰减正则化的一点变化（参见 Ilya Loshchilov 和 Frank Hutter 的 <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> ）：',ee,S,se,q,Pe="最后，默认使用的学习率调度器只是从最大值 （5e-5） 到 0 的线性衰减。为了定义它，我们需要知道我们训练的次数，即所有数据训练的次数（epochs）乘以的 batch 的数量（即我们训练数据加载器的长度）。 <code>Trainer</code> 默认情况下使用三个 <code>epochs</code> ，因此我们定义训练过程如下：",te,L,ae,K,ne,D,pe,P,Oe="最后一件事：如果我们可以访问 GPU，我们将希望使用 GPU（在 CPU 上，训练可能需要几个小时而不是几分钟）。为此，我们定义了一个 <code>device</code> ，它在 GPU 可用的情况下指向 GPU，最后我们将把我们的模型和 <code>batch</code> 放在 <code>device</code> 上：",Me,O,ce,ll,ie,el,ls="我们现在准备好训练了！为了知道训练何时结束，我们使用 <code>tqdm</code> 库，在训练步骤数上添加了一个进度条：",re,sl,ye,tl,es="你可以看到训练循环的核心与介绍中的非常相似。我们没有要求在训练的过程中进行检验，所以这个训练循环不会告诉我们任何关于模型目前的状态。我们需要为此添加一个评估循环。",me,al,oe,nl,ss="正如我们之前所做的那样，我们将使用 🤗 Evaluate 库提供的指标。我们已经了解了 <code>metric.compute()</code> 方法，当我们使用 <code>add_batch()</code> 方法进行预测循环时，实际上该指标可以为我们累积所有 <code>batch</code> 的结果。一旦我们累积了所有 <code>batch</code> ，我们就可以使用 <code>metric.compute()</code> 评估得到的结果。以下是如何在评估循环中实现所有这些的方法：",de,pl,Je,Ml,je,cl,ts="同样，由于模型头部初始化和数据打乱的随机性，你的结果会略有不同，但应该相差不多。",be,u,we,il,Ue,rl,ue,yl,as='我们之前定义的训练循环在单个 CPU 或 GPU 上运行良好。通过使用 <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> 库，只需进行一些调整，我们就可以在多个 GPU 或 TPU 上启用分布式训练。从创建训练和验证数据加载器开始，我们的手动训练循环如下所示：',Te,ml,he,ol,ns="以下是更改的部分：",fe,dl,Ce,Jl,ps="要添加的第一行是导入 <code>Accelerator</code> 。第二行实例化一个 <code>Accelerator</code> 对象 它将查看环境并初始化适当的分布式设置。🤗 Accelerate 为你处理数据在设备间的数据传递，因此你可以删除将模型放在设备上的那行代码（或者，如果你愿意，可使用 <code>accelerator.device</code> 代替 <code>device</code> ）。",Ze,jl,Ms="然后大部分工作会在将数据加载器、模型和优化器发送到的 <code>accelerator.prepare()</code> 中完成。这将会把这些对象包装在适当的容器中，以确保你的分布式训练按预期工作。要进行的其余更改是删除将 <code>batch</code> 放在 <code>device</code> 的那行代码（同样，如果你想保留它，你可以将其更改为使用 <code>accelerator.device</code> ） 并将 <code>loss.backward()</code> 替换为 <code>accelerator.backward(loss)</code> 。",Be,T,Ie,bl,cs="如果你想复制并粘贴来直接运行，以下是 🤗 Accelerate 的完整训练循环：",$e,wl,Ge,Ul,is="把这个放在 <code>train.py</code> 文件中，可以让它在任何类型的分布式设置上运行。要在分布式设置中试用它，请运行以下命令：",Xe,ul,ke,Tl,rs="这将询问你几个配置的问题并将你的回答保存到此命令使用的配置文件中：",We,hl,Re,fl,ys="这将启动分布式训练",ge,Cl,ms="这将启动分布式训练。如果你想在 Notebook 中尝试此操作（例如，在 Colab 上使用 TPU 进行测试），只需将代码粘贴到一个 <code>training_function()</code> 函数中，并在最后一个单元格中运行：",_e,Zl,Ye,Bl,os='你可以在 <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a> 找到更多的示例。',ve,Il,Ve,Gl,Ae;return h=new Xl({props:{title:"一个完整的训练",local:"一个完整的训练",headingTag:"h1"}}),f=new Is({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section4.ipynb"}]}}),C=new Us({props:{id:"Dh9CL8fyG80"}}),B=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),I=new Xl({props:{title:"训练前的准备",local:"训练前的准备",headingTag:"h2"}}),k=new j({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),R=new j({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),_=new j({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),v=new j({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),V=new j({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),z=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),Q=new j({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),F=new j({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),S=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Q1ZS01KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),L=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new j({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),D=new Xl({props:{title:"训练循环",local:"训练循环",headingTag:"h2"}}),O=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),ll=new j({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),sl=new j({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),al=new Xl({props:{title:"评估循环",local:"评估循环",headingTag:"h2"}}),pl=new j({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),Ml=new j({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),u=new ws({props:{$$slots:{default:[Gs]},$$scope:{ctx:$l}}}),il=new Xl({props:{title:"使用🤗 Accelerate 加速你的训练循环",local:"使用🤗 Accelerate加速你的训练循环",headingTag:"h2"}}),rl=new Us({props:{id:"s7dy8QRgjJ0"}}),ml=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),dl=new j({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),T=new ws({props:{$$slots:{default:[Xs]},$$scope:{ctx:$l}}}),wl=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBZGFtVyUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ul=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),hl=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Zl=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),Il=new $s({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter3/4.mdx"}}),{c(){J=m("meta"),w=a(),b=m("p"),U=a(),p(h.$$.fragment),kl=a(),p(f.$$.fragment),Wl=a(),p(C.$$.fragment),Rl=a(),Z=m("p"),Z.innerHTML=Ne,gl=a(),p(B.$$.fragment),_l=a(),p(I.$$.fragment),Yl=a(),$=m("p"),$.innerHTML=ze,vl=a(),G=m("ul"),G.innerHTML=Ee,Vl=a(),X=m("p"),X.innerHTML=Qe,Al=a(),p(k.$$.fragment),Nl=a(),W=m("p"),W.textContent=Fe,zl=a(),p(R.$$.fragment),El=a(),g=m("p"),g.textContent=He,Ql=a(),p(_.$$.fragment),Fl=a(),Y=m("p"),Y.textContent=xe,Hl=a(),p(v.$$.fragment),xl=a(),p(V.$$.fragment),Sl=a(),A=m("p"),A.innerHTML=Se,ql=a(),N=m("p"),N.textContent=qe,Ll=a(),p(z.$$.fragment),Kl=a(),E=m("p"),E.innerHTML=Le,Dl=a(),p(Q.$$.fragment),Pl=a(),p(F.$$.fragment),Ol=a(),H=m("p"),H.innerHTML=Ke,le=a(),x=m("p"),x.innerHTML=De,ee=a(),p(S.$$.fragment),se=a(),q=m("p"),q.innerHTML=Pe,te=a(),p(L.$$.fragment),ae=a(),p(K.$$.fragment),ne=a(),p(D.$$.fragment),pe=a(),P=m("p"),P.innerHTML=Oe,Me=a(),p(O.$$.fragment),ce=a(),p(ll.$$.fragment),ie=a(),el=m("p"),el.innerHTML=ls,re=a(),p(sl.$$.fragment),ye=a(),tl=m("p"),tl.textContent=es,me=a(),p(al.$$.fragment),oe=a(),nl=m("p"),nl.innerHTML=ss,de=a(),p(pl.$$.fragment),Je=a(),p(Ml.$$.fragment),je=a(),cl=m("p"),cl.textContent=ts,be=a(),p(u.$$.fragment),we=a(),p(il.$$.fragment),Ue=a(),p(rl.$$.fragment),ue=a(),yl=m("p"),yl.innerHTML=as,Te=a(),p(ml.$$.fragment),he=a(),ol=m("p"),ol.textContent=ns,fe=a(),p(dl.$$.fragment),Ce=a(),Jl=m("p"),Jl.innerHTML=ps,Ze=a(),jl=m("p"),jl.innerHTML=Ms,Be=a(),p(T.$$.fragment),Ie=a(),bl=m("p"),bl.textContent=cs,$e=a(),p(wl.$$.fragment),Ge=a(),Ul=m("p"),Ul.innerHTML=is,Xe=a(),p(ul.$$.fragment),ke=a(),Tl=m("p"),Tl.textContent=rs,We=a(),p(hl.$$.fragment),Re=a(),fl=m("p"),fl.textContent=ys,ge=a(),Cl=m("p"),Cl.innerHTML=ms,_e=a(),p(Zl.$$.fragment),Ye=a(),Bl=m("p"),Bl.innerHTML=os,ve=a(),p(Il.$$.fragment),Ve=a(),Gl=m("p"),this.h()},l(l){const e=Zs("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(s),w=n(l),b=o(l,"P",{}),js(b).forEach(s),U=n(l),M(h.$$.fragment,l),kl=n(l),M(f.$$.fragment,l),Wl=n(l),M(C.$$.fragment,l),Rl=n(l),Z=o(l,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-13enyaf"&&(Z.innerHTML=Ne),gl=n(l),M(B.$$.fragment,l),_l=n(l),M(I.$$.fragment,l),Yl=n(l),$=o(l,"P",{"data-svelte-h":!0}),d($)!=="svelte-1yecb2p"&&($.innerHTML=ze),vl=n(l),G=o(l,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-lvny5e"&&(G.innerHTML=Ee),Vl=n(l),X=o(l,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1v2kn1o"&&(X.innerHTML=Qe),Al=n(l),M(k.$$.fragment,l),Nl=n(l),W=o(l,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1nix2jt"&&(W.textContent=Fe),zl=n(l),M(R.$$.fragment,l),El=n(l),g=o(l,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1agqx3n"&&(g.textContent=He),Ql=n(l),M(_.$$.fragment,l),Fl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1056o5f"&&(Y.textContent=xe),Hl=n(l),M(v.$$.fragment,l),xl=n(l),M(V.$$.fragment,l),Sl=n(l),A=o(l,"P",{"data-svelte-h":!0}),d(A)!=="svelte-15la3hm"&&(A.innerHTML=Se),ql=n(l),N=o(l,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1fp0mz9"&&(N.textContent=qe),Ll=n(l),M(z.$$.fragment,l),Kl=n(l),E=o(l,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1bhzb96"&&(E.innerHTML=Le),Dl=n(l),M(Q.$$.fragment,l),Pl=n(l),M(F.$$.fragment,l),Ol=n(l),H=o(l,"P",{"data-svelte-h":!0}),d(H)!=="svelte-2dyt89"&&(H.innerHTML=Ke),le=n(l),x=o(l,"P",{"data-svelte-h":!0}),d(x)!=="svelte-pzmurp"&&(x.innerHTML=De),ee=n(l),M(S.$$.fragment,l),se=n(l),q=o(l,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1wax5dr"&&(q.innerHTML=Pe),te=n(l),M(L.$$.fragment,l),ae=n(l),M(K.$$.fragment,l),ne=n(l),M(D.$$.fragment,l),pe=n(l),P=o(l,"P",{"data-svelte-h":!0}),d(P)!=="svelte-az2ahg"&&(P.innerHTML=Oe),Me=n(l),M(O.$$.fragment,l),ce=n(l),M(ll.$$.fragment,l),ie=n(l),el=o(l,"P",{"data-svelte-h":!0}),d(el)!=="svelte-spzdap"&&(el.innerHTML=ls),re=n(l),M(sl.$$.fragment,l),ye=n(l),tl=o(l,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-1ff2fnh"&&(tl.textContent=es),me=n(l),M(al.$$.fragment,l),oe=n(l),nl=o(l,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-1ddz8vi"&&(nl.innerHTML=ss),de=n(l),M(pl.$$.fragment,l),Je=n(l),M(Ml.$$.fragment,l),je=n(l),cl=o(l,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-55obbg"&&(cl.textContent=ts),be=n(l),M(u.$$.fragment,l),we=n(l),M(il.$$.fragment,l),Ue=n(l),M(rl.$$.fragment,l),ue=n(l),yl=o(l,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-wubmmt"&&(yl.innerHTML=as),Te=n(l),M(ml.$$.fragment,l),he=n(l),ol=o(l,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-8f4nle"&&(ol.textContent=ns),fe=n(l),M(dl.$$.fragment,l),Ce=n(l),Jl=o(l,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1jqk627"&&(Jl.innerHTML=ps),Ze=n(l),jl=o(l,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-yw9l7a"&&(jl.innerHTML=Ms),Be=n(l),M(T.$$.fragment,l),Ie=n(l),bl=o(l,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-cz9ffq"&&(bl.textContent=cs),$e=n(l),M(wl.$$.fragment,l),Ge=n(l),Ul=o(l,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-9sxezb"&&(Ul.innerHTML=is),Xe=n(l),M(ul.$$.fragment,l),ke=n(l),Tl=o(l,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-14ydy5s"&&(Tl.textContent=rs),We=n(l),M(hl.$$.fragment,l),Re=n(l),fl=o(l,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-wi892w"&&(fl.textContent=ys),ge=n(l),Cl=o(l,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-1mbq56y"&&(Cl.innerHTML=ms),_e=n(l),M(Zl.$$.fragment,l),Ye=n(l),Bl=o(l,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-127l9y5"&&(Bl.innerHTML=os),ve=n(l),M(Il.$$.fragment,l),Ve=n(l),Gl=o(l,"P",{}),js(Gl).forEach(s),this.h()},h(){bs(J,"name","hf:doc:metadata"),bs(J,"content",Ws)},m(l,e){Bs(document.head,J),t(l,w,e),t(l,b,e),t(l,U,e),c(h,l,e),t(l,kl,e),c(f,l,e),t(l,Wl,e),c(C,l,e),t(l,Rl,e),t(l,Z,e),t(l,gl,e),c(B,l,e),t(l,_l,e),c(I,l,e),t(l,Yl,e),t(l,$,e),t(l,vl,e),t(l,G,e),t(l,Vl,e),t(l,X,e),t(l,Al,e),c(k,l,e),t(l,Nl,e),t(l,W,e),t(l,zl,e),c(R,l,e),t(l,El,e),t(l,g,e),t(l,Ql,e),c(_,l,e),t(l,Fl,e),t(l,Y,e),t(l,Hl,e),c(v,l,e),t(l,xl,e),c(V,l,e),t(l,Sl,e),t(l,A,e),t(l,ql,e),t(l,N,e),t(l,Ll,e),c(z,l,e),t(l,Kl,e),t(l,E,e),t(l,Dl,e),c(Q,l,e),t(l,Pl,e),c(F,l,e),t(l,Ol,e),t(l,H,e),t(l,le,e),t(l,x,e),t(l,ee,e),c(S,l,e),t(l,se,e),t(l,q,e),t(l,te,e),c(L,l,e),t(l,ae,e),c(K,l,e),t(l,ne,e),c(D,l,e),t(l,pe,e),t(l,P,e),t(l,Me,e),c(O,l,e),t(l,ce,e),c(ll,l,e),t(l,ie,e),t(l,el,e),t(l,re,e),c(sl,l,e),t(l,ye,e),t(l,tl,e),t(l,me,e),c(al,l,e),t(l,oe,e),t(l,nl,e),t(l,de,e),c(pl,l,e),t(l,Je,e),c(Ml,l,e),t(l,je,e),t(l,cl,e),t(l,be,e),c(u,l,e),t(l,we,e),c(il,l,e),t(l,Ue,e),c(rl,l,e),t(l,ue,e),t(l,yl,e),t(l,Te,e),c(ml,l,e),t(l,he,e),t(l,ol,e),t(l,fe,e),c(dl,l,e),t(l,Ce,e),t(l,Jl,e),t(l,Ze,e),t(l,jl,e),t(l,Be,e),c(T,l,e),t(l,Ie,e),t(l,bl,e),t(l,$e,e),c(wl,l,e),t(l,Ge,e),t(l,Ul,e),t(l,Xe,e),c(ul,l,e),t(l,ke,e),t(l,Tl,e),t(l,We,e),c(hl,l,e),t(l,Re,e),t(l,fl,e),t(l,ge,e),t(l,Cl,e),t(l,_e,e),c(Zl,l,e),t(l,Ye,e),t(l,Bl,e),t(l,ve,e),c(Il,l,e),t(l,Ve,e),t(l,Gl,e),Ae=!0},p(l,[e]){const ds={};e&2&&(ds.$$scope={dirty:e,ctx:l}),u.$set(ds);const Js={};e&2&&(Js.$$scope={dirty:e,ctx:l}),T.$set(Js)},i(l){Ae||(i(h.$$.fragment,l),i(f.$$.fragment,l),i(C.$$.fragment,l),i(B.$$.fragment,l),i(I.$$.fragment,l),i(k.$$.fragment,l),i(R.$$.fragment,l),i(_.$$.fragment,l),i(v.$$.fragment,l),i(V.$$.fragment,l),i(z.$$.fragment,l),i(Q.$$.fragment,l),i(F.$$.fragment,l),i(S.$$.fragment,l),i(L.$$.fragment,l),i(K.$$.fragment,l),i(D.$$.fragment,l),i(O.$$.fragment,l),i(ll.$$.fragment,l),i(sl.$$.fragment,l),i(al.$$.fragment,l),i(pl.$$.fragment,l),i(Ml.$$.fragment,l),i(u.$$.fragment,l),i(il.$$.fragment,l),i(rl.$$.fragment,l),i(ml.$$.fragment,l),i(dl.$$.fragment,l),i(T.$$.fragment,l),i(wl.$$.fragment,l),i(ul.$$.fragment,l),i(hl.$$.fragment,l),i(Zl.$$.fragment,l),i(Il.$$.fragment,l),Ae=!0)},o(l){r(h.$$.fragment,l),r(f.$$.fragment,l),r(C.$$.fragment,l),r(B.$$.fragment,l),r(I.$$.fragment,l),r(k.$$.fragment,l),r(R.$$.fragment,l),r(_.$$.fragment,l),r(v.$$.fragment,l),r(V.$$.fragment,l),r(z.$$.fragment,l),r(Q.$$.fragment,l),r(F.$$.fragment,l),r(S.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(D.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(sl.$$.fragment,l),r(al.$$.fragment,l),r(pl.$$.fragment,l),r(Ml.$$.fragment,l),r(u.$$.fragment,l),r(il.$$.fragment,l),r(rl.$$.fragment,l),r(ml.$$.fragment,l),r(dl.$$.fragment,l),r(T.$$.fragment,l),r(wl.$$.fragment,l),r(ul.$$.fragment,l),r(hl.$$.fragment,l),r(Zl.$$.fragment,l),r(Il.$$.fragment,l),Ae=!1},d(l){l&&(s(w),s(b),s(U),s(kl),s(Wl),s(Rl),s(Z),s(gl),s(_l),s(Yl),s($),s(vl),s(G),s(Vl),s(X),s(Al),s(Nl),s(W),s(zl),s(El),s(g),s(Ql),s(Fl),s(Y),s(Hl),s(xl),s(Sl),s(A),s(ql),s(N),s(Ll),s(Kl),s(E),s(Dl),s(Pl),s(Ol),s(H),s(le),s(x),s(ee),s(se),s(q),s(te),s(ae),s(ne),s(pe),s(P),s(Me),s(ce),s(ie),s(el),s(re),s(ye),s(tl),s(me),s(oe),s(nl),s(de),s(Je),s(je),s(cl),s(be),s(we),s(Ue),s(ue),s(yl),s(Te),s(he),s(ol),s(fe),s(Ce),s(Jl),s(Ze),s(jl),s(Be),s(Ie),s(bl),s($e),s(Ge),s(Ul),s(Xe),s(ke),s(Tl),s(We),s(Re),s(fl),s(ge),s(Cl),s(_e),s(Ye),s(Bl),s(ve),s(Ve),s(Gl)),s(J),y(h,l),y(f,l),y(C,l),y(B,l),y(I,l),y(k,l),y(R,l),y(_,l),y(v,l),y(V,l),y(z,l),y(Q,l),y(F,l),y(S,l),y(L,l),y(K,l),y(D,l),y(O,l),y(ll,l),y(sl,l),y(al,l),y(pl,l),y(Ml,l),y(u,l),y(il,l),y(rl,l),y(ml,l),y(dl,l),y(T,l),y(wl,l),y(ul,l),y(hl,l),y(Zl,l),y(Il,l)}}}const Ws='{"title":"一个完整的训练","local":"一个完整的训练","sections":[{"title":"训练前的准备","local":"训练前的准备","sections":[],"depth":2},{"title":"训练循环","local":"训练循环","sections":[],"depth":2},{"title":"评估循环","local":"评估循环","sections":[],"depth":2},{"title":"使用🤗 Accelerate 加速你的训练循环","local":"使用🤗 Accelerate加速你的训练循环","sections":[],"depth":2}],"depth":1}';function Rs($l){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends fs{constructor(J){super(),Cs(this,J,Rs,ks,Ts,{})}}export{zs as component};
