import{s as ue,n as je,o as we}from"../chunks/scheduler.85c25b89.js";import{S as ye,i as Je,g as a,s as o,u as c,A as fe,h as n,f as e,c as p,j as h,v as M,y as m,k as i,o as r,a as l,w as d,d as g,t as u,x as j}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function be(St){let w,ht,st,mt,y,v,lt,Z,Xt,D,Ht="RexNet",ct,$,zt='<strong>Rank Expansion Networks</strong> (ReXNets) follow a set of new design principles for designing bottlenecks in image classification models. Authors refine each layer by 1) expanding the input channel size of the convolution layer and 2) replacing the <a href="https://www.paperswithcode.com/method/relu6" rel="nofollow">ReLU6s</a>.',Mt,J,U,at,I,Rt,q,Ft="How do I use this model on an image?",dt,N,Pt="To load a pretrained model:",gt,E,ut,B,Lt="To load and preprocess the image:",jt,W,wt,_,Dt="To get the model predictions:",yt,A,Jt,G,qt="To get the top-5 predictions class names:",ft,X,bt,R,Kt="Replace the model name with the variant you want to use, e.g. <code>rexnet_100</code>. You can find the IDs in the model summaries at the top of this page.",Tt,V,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,x,nt,Q,Vt,K,te="How do I finetune this model?",Ut,Y,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",xt,S,Ct,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,b,C,ot,z,Qt,O,le="How do I train this model?",Zt,F,ae='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,T,k,pt,P,Yt,tt,ne="Citation",It,L,Nt,it,Et;return Z=new rt({}),I=new rt({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JleG5ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),W=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),A=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),X=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),Q=new rt({}),S=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmV4bmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QmhhbjIwMjByZXhuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlJlWE5ldCUzQSUyMERpbWluaXNoaW5nJTIwUmVwcmVzZW50YXRpb25hbCUyMEJvdHRsZW5lY2slMjBvbiUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRG9uZ3lvb24lMjBIYW4lMjBhbmQlMjBTYW5nZG9vJTIwWXVuJTIwYW5kJTIwQnllb25naG8lMjBIZW8lMjBhbmQlMjBZb3VuZ0pvb24lMjBZb28lN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIwMDcuMDA5OTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{han2020rexnet,
      title={ReXNet: Diminishing Representational Bottleneck on Convolutional Neural Network}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Dongyoon Han and Sangdoo Yun and Byeongho Heo and YoungJoon Yoo}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2007.00992}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){w=a("meta"),ht=o(),st=a("p"),mt=o(),y=a("h1"),v=a("a"),lt=a("span"),c(Z.$$.fragment),Xt=o(),D=a("span"),D.textContent=Ht,ct=o(),$=a("p"),$.innerHTML=zt,Mt=o(),J=a("h2"),U=a("a"),at=a("span"),c(I.$$.fragment),Rt=o(),q=a("span"),q.textContent=Ft,dt=o(),N=a("p"),N.textContent=Pt,gt=o(),c(E.$$.fragment),ut=o(),B=a("p"),B.textContent=Lt,jt=o(),c(W.$$.fragment),wt=o(),_=a("p"),_.textContent=Dt,yt=o(),c(A.$$.fragment),Jt=o(),G=a("p"),G.textContent=qt,ft=o(),c(X.$$.fragment),bt=o(),R=a("p"),R.innerHTML=Kt,Tt=o(),V=a("p"),V.innerHTML=Ot,vt=o(),f=a("h2"),x=a("a"),nt=a("span"),c(Q.$$.fragment),Vt=o(),K=a("span"),K.textContent=te,Ut=o(),Y=a("p"),Y.textContent=ee,xt=o(),c(S.$$.fragment),Ct=o(),H=a("p"),H.innerHTML=se,kt=o(),b=a("h2"),C=a("a"),ot=a("span"),c(z.$$.fragment),Qt=o(),O=a("span"),O.textContent=le,Zt=o(),F=a("p"),F.innerHTML=ae,$t=o(),T=a("h2"),k=a("a"),pt=a("span"),c(P.$$.fragment),Yt=o(),tt=a("span"),tt.textContent=ne,It=o(),c(L.$$.fragment),Nt=o(),it=a("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);w=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),y=n(t,"H1",{class:!0});var Bt=h(y);v=n(Bt,"A",{id:!0,class:!0,href:!0});var oe=h(v);lt=n(oe,"SPAN",{});var pe=h(lt);M(Z.$$.fragment,pe),pe.forEach(e),oe.forEach(e),Xt=p(Bt),D=n(Bt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-edsh57"&&(D.textContent=Ht),Bt.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1inhb52"&&($.innerHTML=zt),Mt=p(t),J=n(t,"H2",{class:!0});var Wt=h(J);U=n(Wt,"A",{id:!0,class:!0,href:!0});var ie=h(U);at=n(ie,"SPAN",{});var re=h(at);M(I.$$.fragment,re),re.forEach(e),ie.forEach(e),Rt=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Wt.forEach(e),dt=p(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18ywhxh"&&(N.textContent=Pt),gt=p(t),M(E.$$.fragment,t),ut=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1c2ipa8"&&(B.textContent=Lt),jt=p(t),M(W.$$.fragment,t),wt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Dt),yt=p(t),M(A.$$.fragment,t),Jt=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-19cnvx1"&&(G.textContent=qt),ft=p(t),M(X.$$.fragment,t),bt=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-kmyudm"&&(R.innerHTML=Kt),Tt=p(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1wmi3ea"&&(V.innerHTML=Ot),vt=p(t),f=n(t,"H2",{class:!0});var _t=h(f);x=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(x);nt=n(he,"SPAN",{});var me=h(nt);M(Q.$$.fragment,me),me.forEach(e),he.forEach(e),Vt=p(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),Ut=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ee),xt=p(t),M(S.$$.fragment,t),Ct=p(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),kt=p(t),b=n(t,"H2",{class:!0});var At=h(b);C=n(At,"A",{id:!0,class:!0,href:!0});var ce=h(C);ot=n(ce,"SPAN",{});var Me=h(ot);M(z.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Qt=p(At),O=n(At,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=le),At.forEach(e),Zt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=ae),$t=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);k=n(Gt,"A",{id:!0,class:!0,href:!0});var de=h(k);pt=n(de,"SPAN",{});var ge=h(pt);M(P.$$.fragment,ge),ge.forEach(e),de.forEach(e),Yt=p(Gt),tt=n(Gt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Gt.forEach(e),It=p(t),M(L.$$.fragment,t),Nt=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(w,"name","hf:doc:metadata"),i(w,"content",JSON.stringify(Te)),i(v,"id","rexnet"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#rexnet"),i(y,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(J,"class","relative group"),i(x,"id","how-do-i-finetune-this-model"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#how-do-i-finetune-this-model"),i(f,"class","relative group"),i(C,"id","how-do-i-train-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-train-this-model"),i(b,"class","relative group"),i(k,"id","citation"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#citation"),i(T,"class","relative group")},m(t,s){r(document.head,w),l(t,ht,s),l(t,st,s),l(t,mt,s),l(t,y,s),r(y,v),r(v,lt),d(Z,lt,null),r(y,Xt),r(y,D),l(t,ct,s),l(t,$,s),l(t,Mt,s),l(t,J,s),r(J,U),r(U,at),d(I,at,null),r(J,Rt),r(J,q),l(t,dt,s),l(t,N,s),l(t,gt,s),d(E,t,s),l(t,ut,s),l(t,B,s),l(t,jt,s),d(W,t,s),l(t,wt,s),l(t,_,s),l(t,yt,s),d(A,t,s),l(t,Jt,s),l(t,G,s),l(t,ft,s),d(X,t,s),l(t,bt,s),l(t,R,s),l(t,Tt,s),l(t,V,s),l(t,vt,s),l(t,f,s),r(f,x),r(x,nt),d(Q,nt,null),r(f,Vt),r(f,K),l(t,Ut,s),l(t,Y,s),l(t,xt,s),d(S,t,s),l(t,Ct,s),l(t,H,s),l(t,kt,s),l(t,b,s),r(b,C),r(C,ot),d(z,ot,null),r(b,Qt),r(b,O),l(t,Zt,s),l(t,F,s),l(t,$t,s),l(t,T,s),r(T,k),r(k,pt),d(P,pt,null),r(T,Yt),r(T,tt),l(t,It,s),d(L,t,s),l(t,Nt,s),l(t,it,s),Et=!0},p:je,i(t){Et||(g(Z.$$.fragment,t),g(I.$$.fragment,t),g(E.$$.fragment,t),g(W.$$.fragment,t),g(A.$$.fragment,t),g(X.$$.fragment,t),g(Q.$$.fragment,t),g(S.$$.fragment,t),g(z.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),Et=!0)},o(t){u(Z.$$.fragment,t),u(I.$$.fragment,t),u(E.$$.fragment,t),u(W.$$.fragment,t),u(A.$$.fragment,t),u(X.$$.fragment,t),u(Q.$$.fragment,t),u(S.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(st),e(mt),e(y),e(ct),e($),e(Mt),e(J),e(dt),e(N),e(gt),e(ut),e(B),e(jt),e(wt),e(_),e(yt),e(Jt),e(G),e(ft),e(bt),e(R),e(Tt),e(V),e(vt),e(f),e(Ut),e(Y),e(xt),e(Ct),e(H),e(kt),e(b),e(Zt),e(F),e($t),e(T),e(It),e(Nt),e(it)),e(w),j(Z),j(I),j(E,t),j(W,t),j(A,t),j(X,t),j(Q),j(S,t),j(z),j(P),j(L,t)}}}const Te={local:"rexnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"RexNet"};function ve(St){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends ye{constructor(w){super(),Je(this,w,ve,be,ue,{})}}export{Ze as component};
