import{s as Ym,f as Sm,o as Xm,n as qm}from"../chunks/scheduler.25b97de1.js";import{S as Om,i as Km,g as s,s as o,r as d,A as ep,h as a,f as n,c as i,j as k,u as m,x as r,k as Va,y as c,a as l,v as p,d as h,t as u,w as f}from"../chunks/index.d9030fc9.js";import{T as tp}from"../chunks/Tip.baa67368.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{H as g,E as np}from"../chunks/EditOnGithub.91d95064.js";function lp(Nl){let w,_="In case you are using Windows, you should replace <code>RUN_SLOW=1</code> with <code>SET RUN_SLOW=1</code>";return{c(){w=s("p"),w.innerHTML=_},l(j){w=a(j,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1w9gxqz"&&(w.innerHTML=_)},m(j,bl){l(j,w,bl)},p:qm,d(j){j&&n(w)}}}function op(Nl){let w,_,j,bl,I,Bl,x,Fa='The 🤗 Transformers library is often able to offer new models thanks to community contributors. But this can be a challenging project and requires an in-depth knowledge of the 🤗 Transformers library and the model to implement. At Hugging Face, we’re trying to empower more of the community to actively add models and we’ve put together this guide to walk you through the process of adding a PyTorch model (make sure you have <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch installed</a>).',Pl,$,Ya="Along the way, you’ll:",zl,L,Sa="<li>get insights into open-source best practices</li> <li>understand the design principles behind one of the most popular deep learning libraries</li> <li>learn how to efficiently test large models</li> <li>learn how to integrate Python utilities like <code>black</code>, <code>ruff</code>, and <code>make fix-copies</code> to ensure clean and readable code</li>",Rl,A,Xa="A Hugging Face team member will be available to help you along the way so you’ll never be alone. 🤗 ❤️",El,H,qa='To get started, open a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=New+model&amp;template=new-model-addition.yml" rel="nofollow">New model addition</a> issue for the model you want to see in 🤗 Transformers. If you’re not especially picky about contributing a specific model, you can filter by the <a href="https://github.com/huggingface/transformers/labels/New%20model" rel="nofollow">New model label</a> to see if there are any unclaimed model requests and work on it.',Gl,Z,Oa="Once you’ve opened a new model request, the first step is to get familiar with 🤗 Transformers if you aren’t already!",Ql,W,Dl,N,Ka=`First, you should get a general overview of 🤗 Transformers. 🤗 Transformers is a very opinionated library, so there is a
chance that you don’t agree with some of the library’s philosophies or design choices. From our experience, however, we
found that the fundamental design choices and philosophies of the library are crucial to efficiently scale 🤗
Transformers while keeping maintenance costs at a reasonable level.`,Vl,B,er='A good first starting point to better understand the library is to read the <a href="philosophy">documentation of our philosophy</a>. As a result of our way of working, there are some choices that we try to apply to all models:',Fl,P,tr=`<li>Composition is generally favored over-abstraction</li> <li>Duplicating code is not always bad if it strongly improves the readability or accessibility of a model</li> <li>Model files are as self-contained as possible so that when you read the code of a specific model, you ideally only
have to look into the respective <code>modeling_....py</code> file.</li>`,Yl,z,nr=`In our opinion, the library’s code is not just a means to provide a product, <em>e.g.</em> the ability to use BERT for
inference, but also as the very product that we want to improve. Hence, when adding a model, the user is not only the
person who will use your model, but also everybody who will read, try to understand, and possibly tweak your code.`,Sl,R,lr="With this in mind, let’s go a bit deeper into the general library design.",Xl,E,ql,G,or=`To successfully add a model, it is important to understand the interaction between your model and its config,
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. For exemplary purposes, we will
call the model to be added to 🤗 Transformers <code>BrandNewBert</code>.`,Ol,Q,ir="Let’s take a look:",Kl,vl,sr,eo,D,ar=`As you can see, we do make use of inheritance in 🤗 Transformers, but we keep the level of abstraction to an absolute
minimum. There are never more than two levels of abstraction for any model in the library. <code>BrandNewBertModel</code>
inherits from <code>BrandNewBertPreTrainedModel</code> which in turn inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> and
that’s it. As a general rule, we want to make sure that a new model only depends on
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. The important functionalities that are automatically provided to every new
model are <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, which are used for serialization and deserialization. All of the
other important functionalities, such as <code>BrandNewBertModel.forward</code> should be completely defined in the new
<code>modeling_brand_new_bert.py</code> script. Next, we want to make sure that a model with a specific head layer, such as
<code>BrandNewBertForMaskedLM</code> does not inherit from <code>BrandNewBertModel</code>, but rather uses <code>BrandNewBertModel</code>
as a component that can be called in its forward pass to keep the level of abstraction low. Every new model requires a
configuration class, called <code>BrandNewBertConfig</code>. This configuration is always stored as an attribute in
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and thus can be accessed via the <code>config</code> attribute for all classes
inheriting from <code>BrandNewBertPreTrainedModel</code>:`,to,V,no,F,rr=`Similar to the model, the configuration inherits basic serialization and deserialization functionalities from
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. Note that the configuration and the model are always serialized into two
different formats - the model to a <em>pytorch_model.bin</em> file and the configuration to a <em>config.json</em> file. Calling
the model’s <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> will automatically call
the config’s <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>, so that both model and configuration are saved.`,lo,Y,oo,S,dr=`When coding your new model, keep in mind that Transformers is an opinionated library and we have a few quirks of our
own regarding how code should be written :-)`,io,X,mr=`<li>The forward pass of your model should be fully written in the modeling file while being fully independent of other
models in the library. If you want to reuse a block from another model, copy the code and paste it with a
<code># Copied from</code> comment on top (see <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">here</a>
for a good example and <a href="pr_checks#check-copies">there</a> for more documentation on Copied from).</li> <li>The code should be fully understandable, even by a non-native English speaker. This means you should pick
descriptive variable names and avoid abbreviations. As an example, <code>activation</code> is preferred to <code>act</code>.
One-letter variable names are strongly discouraged unless it’s an index in a for loop.</li> <li>More generally we prefer longer explicit code to short magical one.</li> <li>Avoid subclassing <code>nn.Sequential</code> in PyTorch but subclass <code>nn.Module</code> and write the forward pass, so that anyone
using your code can quickly debug it by adding print statements or breaking points.</li> <li>Your function signature should be type-annotated. For the rest, good variable names are way more readable and
understandable than type annotations.</li>`,so,q,ao,O,pr="Not quite ready yet :-( This section will be added soon!",ro,K,mo,ee,hr=`Everyone has different preferences of how to port a model so it can be very helpful for you to take a look at summaries
of how other contributors ported models to Hugging Face. Here is a list of community blog posts on how to port a model:`,po,te,ur='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Porting GPT2 Model</a> by <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Porting WMT19 MT Model</a> by <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',ho,ne,fr="From experience, we can tell you that the most important things to keep in mind when adding a model are:",uo,le,cr=`<li>Don’t reinvent the wheel! Most parts of the code you will add for the new 🤗 Transformers model already exist
somewhere in 🤗 Transformers. Take some time to find similar, already existing models and tokenizers you can copy
from. <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> and <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> are your
friends. Note that it might very well happen that your model’s tokenizer is based on one model implementation, and
your model’s modeling code on another one. <em>E.g.</em> FSMT’s modeling code is based on BART, while FSMT’s tokenizer code
is based on XLM.</li> <li>It’s more of an engineering challenge than a scientific challenge. You should spend more time creating an
efficient debugging environment rather than trying to understand all theoretical aspects of the model in the paper.</li> <li>Ask for help, when you’re stuck! Models are the core component of 🤗 Transformers so we at Hugging Face are more
than happy to help you at every step to add your model. Don’t hesitate to ask if you notice you are not making
progress.</li>`,fo,oe,yr="In the following, we try to give you a general recipe that we found most useful when porting a model to 🤗 Transformers.",co,ie,wr=`The following list is a summary of everything that has to be done to add a model and can be used by you as a To-Do
List:`,yo,se,Mr=`☐ (Optional) Understood the model’s theoretical aspects<br/>
☐ Prepared 🤗 Transformers dev environment<br/>
☐ Set up debugging environment of the original repository<br/>
☐ Created script that successfully runs the <code>forward()</code> pass using the original repository and checkpoint<br/>
☐ Successfully added the model skeleton to 🤗 Transformers<br/>
☐ Successfully converted original checkpoint to 🤗 Transformers checkpoint<br/>
☐ Successfully ran <code>forward()</code> pass in 🤗 Transformers that gives identical output to original checkpoint<br/>
☐ Finished model tests in 🤗 Transformers<br/>
☐ Successfully added tokenizer in 🤗 Transformers<br/>
☐ Run end-to-end integration tests<br/>
☐ Finished docs<br/>
☐ Uploaded model weights to the Hub<br/>
☐ Submitted the pull request<br/>
☐ (Optional) Added a demo notebook`,wo,ae,gr=`To begin with, we usually recommend starting by getting a good theoretical understanding of <code>BrandNewBert</code>. However,
if you prefer to understand the theoretical aspects of the model <em>on-the-job</em>, then it is totally fine to directly dive
into the <code>BrandNewBert</code>’s code-base. This option might suit you better if your engineering skills are better than
your theoretical skill, if you have trouble understanding <code>BrandNewBert</code>’s paper, or if you just enjoy programming
much more than reading scientific papers.`,Mo,re,go,de,Tr=`You should take some time to read <em>BrandNewBert’s</em> paper, if such descriptive work exists. There might be large
sections of the paper that are difficult to understand. If this is the case, this is fine - don’t worry! The goal is
not to get a deep theoretical understanding of the paper, but to extract the necessary information required to
effectively re-implement the model in 🤗 Transformers. That being said, you don’t have to spend too much time on the
theoretical aspects, but rather focus on the practical ones, namely:`,To,me,br=`<li>What type of model is <em>brand_new_bert</em>? BERT-like encoder-only model? GPT2-like decoder-only model? BART-like
encoder-decoder model? Look at the <a href="model_summary">model_summary</a> if you’re not familiar with the differences between those.</li> <li>What are the applications of <em>brand_new_bert</em>? Text classification? Text generation? Seq2Seq tasks, <em>e.g.,</em>
summarization?</li> <li>What is the novel feature of the model that makes it different from BERT/GPT-2/BART?</li> <li>Which of the already existing <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> is most
similar to <em>brand_new_bert</em>?</li> <li>What type of tokenizer is used? A sentencepiece tokenizer? Word piece tokenizer? Is it the same tokenizer as used
for BERT or BART?</li>`,bo,pe,vr=`After you feel like you have gotten a good overview of the architecture of the model, you might want to write to the
Hugging Face team with any questions you might have. This might include questions regarding the model’s architecture,
its attention layer, etc. We will be more than happy to help you.`,vo,he,Jo,b,Jl,Jr=`<p>Fork the <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> by clicking on the ‘Fork’ button on the
repository’s page. This creates a copy of the code under your GitHub user account.</p>`,ka,ue,Cl,Cr="Clone your <code>transformers</code> fork to your local disk, and add the base repository as a remote:",Ua,fe,_a,T,jl,jr="Set up a development environment, for instance by running the following command:",Ia,ce,xa,kl,kr=`Depending on your OS, and since the number of optional dependencies of Transformers is growing, you might get a
failure with this command. If that’s the case make sure to install the Deep Learning framework you are working with
(PyTorch, TensorFlow and/or Flax) then do:`,$a,ye,La,Ul,Ur="which should be enough for most use cases. You can then return to the parent directory",Aa,we,Ha,_l,_r=`<p>We recommend adding the PyTorch version of <em>brand_new_bert</em> to Transformers. To install PyTorch, please follow the
instructions on <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</p> <p><strong>Note:</strong> You don’t need to have CUDA installed. Making the new model work on CPU is sufficient.</p>`,Za,Me,Il,Ir="To port <em>brand_new_bert</em>, you will also need access to its original repository:",Wa,ge,Co,Te,xr="Now you have set up a development environment to port <em>brand_new_bert</em> to 🤗 Transformers.",jo,be,ko,ve,$r=`At first, you will work on the original <em>brand_new_bert</em> repository. Often, the original implementation is very
“researchy”. Meaning that documentation might be lacking and the code can be difficult to understand. But this should
be exactly your motivation to reimplement <em>brand_new_bert</em>. At Hugging Face, one of our main goals is to <em>make people
stand on the shoulders of giants</em> which translates here very well into taking a working model and rewriting it to make
it as <strong>accessible, user-friendly, and beautiful</strong> as possible. This is the number-one motivation to re-implement
models into 🤗 Transformers - trying to make complex new NLP technology accessible to <strong>everybody</strong>.`,Uo,Je,Lr="You should start thereby by diving into the original repository.",_o,Ce,Ar=`Successfully running the official pretrained model in the original repository is often <strong>the most difficult</strong> step.
From our experience, it is very important to spend some time getting familiar with the original code-base. You need to
figure out the following:`,Io,je,Hr=`<li>Where to find the pretrained weights?</li> <li>How to load the pretrained weights into the corresponding model?</li> <li>How to run the tokenizer independently from the model?</li> <li>Trace one forward pass so that you know which classes and functions are required for a simple forward pass. Usually,
you only have to reimplement those functions.</li> <li>Be able to locate the important components of the model: Where is the model’s class? Are there model sub-classes,
<em>e.g.</em> EncoderModel, DecoderModel? Where is the self-attention layer? Are there multiple different attention layers,
<em>e.g.</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>How can you debug the model in the original environment of the repo? Do you have to add <em>print</em> statements, can you
work with an interactive debugger like <em>ipdb</em>, or should you use an efficient IDE to debug the model, like PyCharm?</li>`,xo,ke,Zr=`It is very important that before you start the porting process, you can <strong>efficiently</strong> debug code in the original
repository! Also, remember that you are working with an open-source library, so do not hesitate to open an issue, or
even a pull request in the original repository. The maintainers of this repository are most likely very happy about
someone looking into their code!`,$o,Ue,Wr=`At this point, it is really up to you which debugging environment and strategy you prefer to use to debug the original
model. We strongly advise against setting up a costly GPU environment, but simply work on a CPU both when starting to
dive into the original repository and also when starting to write the 🤗 Transformers implementation of the model. Only
at the very end, when the model has already been successfully ported to 🤗 Transformers, one should verify that the
model also works as expected on GPU.`,Lo,_e,Nr="In general, there are two possible debugging environments for running the original model",Ao,Ie,Br='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Local python scripts.</li>',Ho,xe,Pr=`Jupyter notebooks have the advantage that they allow for cell-by-cell execution which can be helpful to better split
logical components from one another and to have faster debugging cycles as intermediate results can be stored. Also,
notebooks are often easier to share with other contributors, which might be very helpful if you want to ask the Hugging
Face team for help. If you are familiar with Jupyter notebooks, we strongly recommend you work with them.`,Zo,$e,zr=`The obvious disadvantage of Jupyter notebooks is that if you are not used to working with them you will have to spend
some time adjusting to the new programming environment and you might not be able to use your known debugging tools
anymore, like <code>ipdb</code>.`,Wo,Le,Rr=`For each code-base, a good first step is always to load a <strong>small</strong> pretrained checkpoint and to be able to reproduce a
single forward pass using a dummy integer vector of input IDs as an input. Such a script could look like this (in
pseudocode):`,No,Ae,Bo,He,Er="Next, regarding the debugging strategy, there are generally a few from which to choose from:",Po,Ze,Gr=`<li>Decompose the original model into many small testable components and run a forward pass on each of those for
verification</li> <li>Decompose the original model only into the original <em>tokenizer</em> and the original <em>model</em>, run a forward pass on
those, and use intermediate print statements or breakpoints for verification</li>`,zo,We,Qr=`Again, it is up to you which strategy to choose. Often, one or the other is advantageous depending on the original code
base.`,Ro,Ne,Dr=`If the original code-base allows you to decompose the model into smaller sub-components, <em>e.g.</em> if the original
code-base can easily be run in eager mode, it is usually worth the effort to do so. There are some important advantages
to taking the more difficult road in the beginning:`,Eo,Be,Vr=`<li>at a later stage when comparing the original model to the Hugging Face implementation, you can verify automatically
for each component individually that the corresponding component of the 🤗 Transformers implementation matches instead
of relying on visual comparison via print statements</li> <li>it can give you some rope to decompose the big problem of porting a model into smaller problems of just porting
individual components and thus structure your work better</li> <li>separating the model into logical meaningful components will help you to get a better overview of the model’s design
and thus to better understand the model</li> <li>at a later stage those component-by-component tests help you to ensure that no regression occurs as you continue
changing your code</li>`,Go,Pe,Fr=`<a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre’s</a> integration checks for ELECTRA
gives a nice example of how this can be done.`,Qo,ze,Yr=`However, if the original code-base is very complex or only allows intermediate components to be run in a compiled mode,
it might be too time-consuming or even impossible to separate the model into smaller testable sub-components. A good
example is <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">T5’s MeshTensorFlow</a> library which is
very complex and does not offer a simple way to decompose the model into its sub-components. For such libraries, one
often relies on verifying print statements.`,Do,Re,Sr=`No matter which strategy you choose, the recommended procedure is often the same that you should start to debug the
starting layers first and the ending layers last.`,Vo,Ee,Xr=`It is recommended that you retrieve the output, either by print statements or sub-component functions, of the following
layers in the following order:`,Fo,Ge,qr="<li>Retrieve the input IDs passed to the model</li> <li>Retrieve the word embeddings</li> <li>Retrieve the input of the first Transformer layer</li> <li>Retrieve the output of the first Transformer layer</li> <li>Retrieve the output of the following n - 1 Transformer layers</li> <li>Retrieve the output of the whole BrandNewBert Model</li>",Yo,Qe,Or="Input IDs should thereby consists of an array of integers, <em>e.g.</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",So,De,Kr="The outputs of the following layers often consist of multi-dimensional float arrays and can look like this:",Xo,Ve,qo,Fe,ed=`We expect that every model added to 🤗 Transformers passes a couple of integration tests, meaning that the original
model and the reimplemented version in 🤗 Transformers have to give the exact same output up to a precision of 0.001!
Since it is normal that the exact same model written in different libraries can give a slightly different output
depending on the library framework, we accept an error tolerance of 1e-3 (0.001). It is not enough if the model gives
nearly the same output, they have to be almost identical. Therefore, you will certainly compare the intermediate
outputs of the 🤗 Transformers version multiple times against the intermediate outputs of the original implementation of
<em>brand_new_bert</em> in which case an <strong>efficient</strong> debugging environment of the original repository is absolutely
important. Here is some advice to make your debugging environment as efficient as possible.`,Oo,Ye,td=`<li>Find the best way of debugging intermediate results. Is the original repository written in PyTorch? Then you should
probably take the time to write a longer script that decomposes the original model into smaller sub-components to
retrieve intermediate values. Is the original repository written in Tensorflow 1? Then you might have to rely on
TensorFlow print operations like <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a> to output
intermediate values. Is the original repository written in Jax? Then make sure that the model is <strong>not jitted</strong> when
running the forward pass, <em>e.g.</em> check-out <a href="https://github.com/google/jax/issues/196" rel="nofollow">this link</a>.</li> <li>Use the smallest pretrained checkpoint you can find. The smaller the checkpoint, the faster your debug cycle
becomes. It is not efficient if your pretrained model is so big that your forward pass takes more than 10 seconds.
In case only very large checkpoints are available, it might make more sense to create a dummy model in the new
environment with randomly initialized weights and save those weights for comparison with the 🤗 Transformers version
of your model</li> <li>Make sure you are using the easiest way of calling a forward pass in the original repository. Ideally, you want to
find the function in the original repository that <strong>only</strong> calls a single forward pass, <em>i.e.</em> that is often called
<code>predict</code>, <code>evaluate</code>, <code>forward</code> or <code>__call__</code>. You don’t want to debug a function that calls <code>forward</code>
multiple times, <em>e.g.</em> to generate text, like <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Try to separate the tokenization from the model’s <em>forward</em> pass. If the original repository shows examples where
you have to input a string, then try to find out where in the forward call the string input is changed to input ids
and start from this point. This might mean that you have to possibly write a small script yourself or change the
original code so that you can directly input the ids instead of an input string.</li> <li>Make sure that the model in your debugging setup is <strong>not</strong> in training mode, which often causes the model to yield
random outputs due to multiple dropout layers in the model. Make sure that the forward pass in your debugging
environment is <strong>deterministic</strong> so that the dropout layers are not used. Or use <em>transformers.utils.set_seed</em>
if the old and new implementations are in the same framework.</li>`,Ko,Se,nd="The following section gives you more specific details/tips on how you can do this for <em>brand_new_bert</em>.",ei,Xe,ti,qe,ld="Next, you can finally start adding new code to 🤗 Transformers. Go into the clone of your 🤗 Transformers’ fork:",ni,Oe,li,Ke,od=`In the special case that you are adding a model whose architecture exactly matches the model architecture of an
existing model you only have to add a conversion script as described in <a href="#write-a-conversion-script">this section</a>.
In this case, you can just re-use the whole model architecture of the already existing model.`,oi,et,id=`Otherwise, let’s start generating a new model. We recommend using the following script to add a model starting from
an existing model:`,ii,tt,si,nt,sd="You will be prompted with a questionnaire to fill in the basic information of your model.",ai,lt,ad="<strong>Open a Pull Request on the main huggingface/transformers repo</strong>",ri,ot,rd=`Before starting to adapt the automatically generated code, now is the time to open a “Work in progress (WIP)” pull
request, <em>e.g.</em> “[WIP] Add <em>brand_new_bert</em>”, in 🤗 Transformers so that you and the Hugging Face team can work
side-by-side on integrating the model into 🤗 Transformers.`,di,it,dd="You should do the following:",mi,M,st,xl,md="Create a branch with a descriptive name from your main branch",Na,at,Ba,rt,$l,pd="Commit the automatically generated code:",Pa,dt,za,mt,Ll,hd="Fetch and rebase to current main",Ra,pt,Ea,ht,Al,ud="Push the changes to your account using:",Ga,ut,Qa,Hl,fd=`<p>Once you are satisfied, go to the webpage of your fork on GitHub. Click on “Pull request”. Make sure to add the
GitHub handle of some members of the Hugging Face team as reviewers, so that the Hugging Face team gets notified for
future changes.</p>`,Da,Zl,cd="<p>Change the PR into a draft by clicking on “Convert to draft” on the right of the GitHub pull request web page.</p>",pi,ft,yd=`In the following, whenever you have made some progress, don’t forget to commit your work and push it to your account so
that it shows in the pull request. Additionally, you should make sure to update your work with the current main from
time to time by doing:`,hi,ct,ui,yt,wd=`In general, all questions you might have regarding the model or your implementation should be asked in your PR and
discussed/solved in the PR. This way, the Hugging Face team will always be notified when you are committing new code or
if you have a question. It is often very helpful to point the Hugging Face team to your added code so that the Hugging
Face team can efficiently understand your problem or question.`,fi,wt,Md=`To do so, you can go to the “Files changed” tab where you see all of your changes, go to a line regarding which you
want to ask a question, and click on the “+” symbol to add a comment. Whenever a question or problem has been solved,
you can click on the “Resolve” button of the created comment.`,ci,Mt,gd=`In the same way, the Hugging Face team will open comments when reviewing your code. We recommend asking most questions
on GitHub on your PR. For some very general questions that are not very useful for the public, feel free to ping the
Hugging Face team by Slack or email.`,yi,gt,Td="<strong>5. Adapt the generated models code for brand_new_bert</strong>",wi,Tt,bd=`At first, we will focus only on the model itself and not care about the tokenizer. All the relevant code should be
found in the generated files <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> and
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,Mi,bt,vd=`Now you can finally start coding :). The generated code in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> will either have the same architecture as BERT if
it’s an encoder-only model or BART if it’s an encoder-decoder model. At this point, you should remind yourself what
you’ve learned in the beginning about the theoretical aspects of the model: <em>How is the model different from BERT or
BART?</em>”. Implement those changes which often means changing the <em>self-attention</em> layer, the order of the normalization
layer, etc… Again, it is often useful to look at the similar architecture of already existing models in Transformers to
get a better feeling of how your model should be implemented.`,gi,vt,Jd=`<strong>Note</strong> that at this point, you don’t have to be very sure that your code is fully correct or clean. Rather, it is
advised to add a first <em>unclean</em>, copy-pasted version of the original code to
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> until you feel like all the necessary code is
added. From our experience, it is much more efficient to quickly add a first version of the required code and
improve/correct the code iteratively with the conversion script as described in the next section. The only thing that
has to work at this point is that you can instantiate the 🤗 Transformers implementation of <em>brand_new_bert</em>, <em>i.e.</em> the
following command should work:`,Ti,Jt,bi,Ct,Cd=`The above command will create a model according to the default parameters as defined in <code>BrandNewBertConfig()</code> with
random weights, thus making sure that the <code>init()</code> methods of all components works.`,vi,jt,jd=`Note that all random initialization should happen in the <code>_init_weights</code> method of your <code>BrandnewBertPreTrainedModel</code>
class. It should initialize all leaf modules depending on the variables of the config. Here is an example with the
BERT <code>_init_weights</code> method:`,Ji,kt,Ci,Ut,kd=`You can have some more custom schemes if you need a special initialization for some modules. For instance, in
<code>Wav2Vec2ForPreTraining</code>, the last two linear layers need to have the initialization of the regular PyTorch <code>nn.Linear</code>
but all the other ones should use an initialization as above. This is coded like this:`,ji,_t,ki,It,Ud=`The <code>_is_hf_initialized</code> flag is internally used to make sure we only initialize a submodule once. By setting it to
<code>True</code> for <code>module.project_q</code> and <code>module.project_hid</code>, we make sure the custom initialization we did is not overridden later on,
the <code>_init_weights</code> function won’t be applied to them.`,Ui,xt,_d="<strong>6. Write a conversion script</strong>",_i,$t,Id=`Next, you should write a conversion script that lets you convert the checkpoint you used to debug <em>brand_new_bert</em> in
the original repository to a checkpoint compatible with your just created 🤗 Transformers implementation of
<em>brand_new_bert</em>. It is not advised to write the conversion script from scratch, but rather to look through already
existing conversion scripts in 🤗 Transformers for one that has been used to convert a similar model that was written in
the same framework as <em>brand_new_bert</em>. Usually, it is enough to copy an already existing conversion script and
slightly adapt it for your use case. Don’t hesitate to ask the Hugging Face team to point you to a similar already
existing conversion script for your model.`,Ii,Lt,xd='<li>If you are porting a model from TensorFlow to PyTorch, a good starting point might be BERT’s conversion script <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">here</a></li> <li>If you are porting a model from PyTorch to PyTorch, a good starting point might be BART’s conversion script <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">here</a></li>',xi,At,$d=`In the following, we’ll quickly explain how PyTorch models store layer weights and define layer names. In PyTorch, the
name of a layer is defined by the name of the class attribute you give the layer. Let’s define a dummy model in
PyTorch, called <code>SimpleModel</code> as follows:`,$i,Ht,Li,Zt,Ld=`Now we can create an instance of this model definition which will fill all weights: <code>dense</code>, <code>intermediate</code>,
<code>layer_norm</code> with random weights. We can print the model to see its architecture`,Ai,Wt,Hi,Nt,Ad="This will print out the following:",Zi,Bt,Wi,Pt,Hd=`We can see that the layer names are defined by the name of the class attribute in PyTorch. You can print out the weight
values of a specific layer:`,Ni,zt,Bi,Rt,Zd="to see that the weights were randomly initialized",Pi,Et,zi,Gt,Wd=`In the conversion script, you should fill those randomly initialized weights with the exact weights of the
corresponding layer in the checkpoint. <em>E.g.</em>`,Ri,Qt,Ei,Dt,Nd=`While doing so, you must verify that each randomly initialized weight of your PyTorch model and its corresponding
pretrained checkpoint weight exactly match in both <strong>shape and name</strong>. To do so, it is <strong>necessary</strong> to add assert
statements for the shape and print out the names of the checkpoints weights. E.g. you should add statements like:`,Gi,Vt,Qi,Ft,Bd="Besides, you should also print out the names of both weights to make sure they match, <em>e.g.</em>",Di,Yt,Vi,St,Pd=`If either the shape or the name doesn’t match, you probably assigned the wrong checkpoint weight to a randomly
initialized layer of the 🤗 Transformers implementation.`,Fi,Xt,zd=`An incorrect shape is most likely due to an incorrect setting of the config parameters in <code>BrandNewBertConfig()</code> that
do not exactly match those that were used for the checkpoint you want to convert. However, it could also be that
PyTorch’s implementation of a layer requires the weight to be transposed beforehand.`,Yi,qt,Rd=`Finally, you should also check that <strong>all</strong> required weights are initialized and print out all checkpoint weights that
were not used for initialization to make sure the model is correctly converted. It is completely normal, that the
conversion trials fail with either a wrong shape statement or a wrong name assignment. This is most likely because either
you used incorrect parameters in <code>BrandNewBertConfig()</code>, have a wrong architecture in the 🤗 Transformers
implementation, you have a bug in the <code>init()</code> functions of one of the components of the 🤗 Transformers
implementation or you need to transpose one of the checkpoint weights.`,Si,Ot,Ed=`This step should be iterated with the previous step until all weights of the checkpoint are correctly loaded in the
Transformers model. Having correctly loaded the checkpoint into the 🤗 Transformers implementation, you can then save
the model under a folder of your choice <code>/path/to/converted/checkpoint/folder</code> that should then contain both a
<code>pytorch_model.bin</code> file and a <code>config.json</code> file:`,Xi,Kt,qi,en,Gd="<strong>7. Implement the forward pass</strong>",Oi,tn,Qd=`Having managed to correctly load the pretrained weights into the 🤗 Transformers implementation, you should now make
sure that the forward pass is correctly implemented. In <a href="#3-4-run-a-pretrained-checkpoint-using-the-original-repository">Get familiar with the original repository</a>, you have already created a script that runs a forward
pass of the model using the original repository. Now you should write an analogous script using the 🤗 Transformers
implementation instead of the original one. It should look as follows:`,Ki,nn,es,ln,Dd=`It is very likely that the 🤗 Transformers implementation and the original model implementation don’t give the exact
same output the very first time or that the forward pass throws an error. Don’t be disappointed - it’s expected! First,
you should make sure that the forward pass doesn’t throw any errors. It often happens that the wrong dimensions are
used leading to a <em>Dimensionality mismatch</em> error or that the wrong data type object is used, <em>e.g.</em> <code>torch.long</code>
instead of <code>torch.float32</code>. Don’t hesitate to ask the Hugging Face team for help, if you don’t manage to solve
certain errors.`,ts,on,Vd=`The final part to make sure the 🤗 Transformers implementation works correctly is to ensure that the outputs are
equivalent to a precision of <code>1e-3</code>. First, you should ensure that the output shapes are identical, <em>i.e.</em> <code>outputs.shape</code> should yield the same value for the script of the 🤗 Transformers implementation and the original
implementation. Next, you should make sure that the output values are identical as well. This one of the most difficult
parts of adding a new model. Common mistakes why the outputs are not identical are:`,ns,sn,Fd=`<li>Some layers were not added, <em>i.e.</em> an <em>activation</em> layer was not added, or the residual connection was forgotten</li> <li>The word embedding matrix was not tied</li> <li>The wrong positional embeddings are used because the original implementation uses on offset</li> <li>Dropout is applied during the forward pass. To fix this make sure <em>model.training is False</em> and that no dropout
layer is falsely activated during the forward pass, <em>i.e.</em> pass <em>self.training</em> to <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,ls,an,Yd=`The best way to fix the problem is usually to look at the forward pass of the original implementation and the 🤗
Transformers implementation side-by-side and check if there are any differences. Ideally, you should debug/print out
intermediate outputs of both implementations of the forward pass to find the exact position in the network where the 🤗
Transformers implementation shows a different output than the original implementation. First, make sure that the
hard-coded <code>input_ids</code> in both scripts are identical. Next, verify that the outputs of the first transformation of
the <code>input_ids</code> (usually the word embeddings) are identical. And then work your way up to the very last layer of the
network. At some point, you will notice a difference between the two implementations, which should point you to the bug
in the 🤗 Transformers implementation. From our experience, a simple and efficient way is to add many print statements
in both the original implementation and 🤗 Transformers implementation, at the same positions in the network
respectively, and to successively remove print statements showing the same values for intermediate presentations.`,os,rn,Sd=`When you’re confident that both implementations yield the same output, verify the outputs with
<code>torch.allclose(original_output, output, atol=1e-3)</code>, you’re done with the most difficult part! Congratulations - the
work left to be done should be a cakewalk 😊.`,is,dn,Xd="<strong>8. Adding all necessary model tests</strong>",ss,mn,qd=`At this point, you have successfully added a new model. However, it is very much possible that the model does not yet
fully comply with the required design. To make sure, the implementation is fully compatible with 🤗 Transformers, all
common tests should pass. The Cookiecutter should have automatically added a test file for your model, probably under
the same <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code>. Run this test file to verify that all common
tests pass:`,as,pn,rs,hn,Od="Having fixed all common tests, it is now crucial to ensure that all the nice work you have done is well tested, so that",ds,un,Kd="<li>a) The community can easily understand your work by looking at specific tests of <em>brand_new_bert</em></li> <li>b) Future changes to your model will not break any important feature of the model.</li>",ms,fn,em=`At first, integration tests should be added. Those integration tests essentially do the same as the debugging scripts
you used earlier to implement the model to 🤗 Transformers. A template of those model tests has already added by the
Cookiecutter, called <code>BrandNewBertModelIntegrationTests</code> and only has to be filled out by you. To ensure that those
tests are passing, run`,ps,cn,hs,U,us,yn,tm=`Second, all features that are special to <em>brand_new_bert</em> should be tested additionally in a separate test under
<code>BrandNewBertModelTester</code>/<code>BrandNewBertModelTest</code>. This part is often forgotten but is extremely useful in two
ways:`,fs,wn,nm=`<li>It helps to transfer the knowledge you have acquired during the model addition to the community by showing how the
special features of <em>brand_new_bert</em> should work.</li> <li>Future contributors can quickly test changes to the model by running those special tests.</li>`,cs,Mn,lm="<strong>9. Implement the tokenizer</strong>",ys,gn,om=`Next, we should add the tokenizer of <em>brand_new_bert</em>. Usually, the tokenizer is equivalent to or very similar to an
already existing tokenizer of 🤗 Transformers.`,ws,Tn,im=`It is very important to find/extract the original tokenizer file and to manage to load this file into the 🤗
Transformers’ implementation of the tokenizer.`,Ms,bn,sm=`To ensure that the tokenizer works correctly, it is recommended to first create a script in the original repository
that inputs a string and returns the <code>input_ids</code>. It could look similar to this (in pseudo-code):`,gs,vn,Ts,Jn,am=`You might have to take a deeper look again into the original repository to find the correct tokenizer function or you
might even have to do changes to your clone of the original repository to only output the <code>input_ids</code>. Having written
a functional tokenization script that uses the original repository, an analogous script for 🤗 Transformers should be
created. It should look similar to this:`,bs,Cn,vs,jn,rm="When both <code>input_ids</code> yield the same values, as a final step a tokenizer test file should also be added.",Js,kn,dm=`Analogous to the modeling test files of <em>brand_new_bert</em>, the tokenization test files of <em>brand_new_bert</em> should
contain a couple of hard-coded integration tests.`,Cs,Un,mm="<strong>10. Run End-to-end integration tests</strong>",js,_n,pm=`Having added the tokenizer, you should also add a couple of end-to-end integration tests using both the model and the
tokenizer to <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code> in 🤗 Transformers.
Such a test should show on a meaningful
text-to-text sample that the 🤗 Transformers implementation works as expected. A meaningful text-to-text sample can
include <em>e.g.</em> a source-to-target-translation pair, an article-to-summary pair, a question-to-answer pair, etc… If none
of the ported checkpoints has been fine-tuned on a downstream task it is enough to simply rely on the model tests. In a
final step to ensure that the model is fully functional, it is advised that you also run all tests on GPU. It can
happen that you forgot to add some <code>.to(self.device)</code> statements to internal tensors of the model, which in such a
test would show in an error. In case you have no access to a GPU, the Hugging Face team can take care of running those
tests for you.`,ks,In,hm="<strong>11. Add Docstring</strong>",Us,xn,um=`Now, all the necessary functionality for <em>brand_new_bert</em> is added - you’re almost done! The only thing left to add is
a nice docstring and a doc page. The Cookiecutter should have added a template file called
<code>docs/source/model_doc/brand_new_bert.md</code> that you should fill out. Users of your model will usually first look at
this page before using your model. Hence, the documentation must be understandable and concise. It is very useful for
the community to add some <em>Tips</em> to show how the model should be used. Don’t hesitate to ping the Hugging Face team
regarding the docstrings.`,_s,$n,fm=`Next, make sure that the docstring added to <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> is
correct and included all necessary inputs and outputs. We have a detailed guide about writing documentation and our docstring format <a href="writing-documentation">here</a>. It is always good to remind oneself that documentation should
be treated at least as carefully as the code in 🤗 Transformers since the documentation is usually the first contact
point of the community with the model.`,Is,Ln,cm="<strong>Code refactor</strong>",xs,An,ym=`Great, now you have added all the necessary code for <em>brand_new_bert</em>. At this point, you should correct some potential
incorrect code style by running:`,$s,Hn,Ls,Zn,wm="and verify that your coding style passes the quality check:",As,Wn,Hs,Nn,Mm=`There are a couple of other very strict design tests in 🤗 Transformers that might still be failing, which shows up in
the tests of your pull request. This is often because of some missing information in the docstring or some incorrect
naming. The Hugging Face team will surely help you if you’re stuck here.`,Zs,Bn,gm=`Lastly, it is always a good idea to refactor one’s code after having ensured that the code works correctly. With all
tests passing, now it’s a good time to go over the added code again and do some refactoring.`,Ws,Pn,Tm="You have now finished the coding part, congratulation! 🎉 You are Awesome! 😎",Ns,zn,bm="<strong>12. Upload the models to the model hub</strong>",Bs,Rn,vm=`In this final part, you should convert and upload all checkpoints to the model hub and add a model card for each
uploaded model checkpoint. You can get familiar with the hub functionalities by reading our <a href="model_sharing">Model sharing and uploading Page</a>. You should work alongside the Hugging Face team here to decide on a fitting name for each
checkpoint and to get the required access rights to be able to upload the model under the author’s organization of
<em>brand_new_bert</em>. The <code>push_to_hub</code> method, present in all models in <code>transformers</code>, is a quick and efficient way to push your checkpoint to the hub. A little snippet is pasted below:`,Ps,En,zs,Gn,Jm=`It is worth spending some time to create fitting model cards for each checkpoint. The model cards should highlight the
specific characteristics of this particular checkpoint, <em>e.g.</em> On which dataset was the checkpoint
pretrained/fine-tuned on? On what down-stream task should the model be used? And also include some code on how to
correctly use the model.`,Rs,Qn,Cm="<strong>13. (Optional) Add notebook</strong>",Es,Dn,jm=`It is very helpful to add a notebook that showcases in-detail how <em>brand_new_bert</em> can be used for inference and/or
fine-tuned on a downstream task. This is not mandatory to merge your PR, but very useful for the community.`,Gs,Vn,km="<strong>14. Submit your finished PR</strong>",Qs,Fn,Um=`You’re done programming now and can move to the last step, which is getting your PR merged into main. Usually, the
Hugging Face team should have helped you already at this point, but it is worth taking some time to give your finished
PR a nice description and eventually add comments to your code, if you want to point out certain design choices to your
reviewer.`,Ds,Yn,Vs,Sn,_m=`Now, it’s time to get some credit from the community for your work! Having completed a model addition is a major
contribution to Transformers and the whole NLP community. Your code and the ported pre-trained models will certainly be
used by hundreds and possibly even thousands of developers and researchers. You should be proud of your work and share
your achievements with the community.`,Fs,Xn,Im="<strong>You have made another model that is super easy to access for everyone in the community! 🤯</strong>",Ys,qn,Ss,On,xm=`We aim for <code>transformers</code> to have support for new model architectures and checkpoints as early as possible:
availability can range from day-0 (and hour-0) releases for some models, to a few days/weeks for others.`,Xs,Kn,$m=`The availability of this is usually up to the model contributors, as well as how excited the community is for the
architecture.`,qs,el,Lm="We can split the model architecture possibilities in four sections:",Os,tl,Am="<li>Day-0 integration</li> <li>Same-week integration</li> <li>Post-release integration</li> <li>Hub-first release</li>",Ks,nl,Hm=`Let’s dive into each of these and see how we (the transformers team) can help you contribute your architecture and get
your architecture to be very easily used by all members of the community.`,ea,ll,ta,ol,Zm=`For a day-0 integration to work, we’ll usually want to work hand-in-hand with you directly. In order to keep your
architecture private until your checkpoints and release are ready, we’ll work together in a private fork of
transformers.`,na,il,Wm=`If you plan on having a transformers-first release, this is a great option: we run CI ahead of time, ensure the
documentation is clear, and we aim to optimize your model as much as possible (providing quantization, optimizing it
with Flash-Attention/SDPA, optimizing the KV cache, etc).`,la,sl,Nm=`We can also lend you a hand in adding the model, reviewing it early, and help you make sure the <code>transformers</code>
API works as expected!`,oa,al,Bm=`If this is the path you wish to go with, we ask for you to reach out in advance, especially if the architecture is
particularly novel (at least a few days, but a few weeks will enable the absolute best integration). In order to reach
out, please contact <a href="mailto:transformers@huggingface.co">transformers@huggingface.co</a> 🤗.`,ia,rl,sa,dl,Pm=`A same-week integration usually happens when model authors do not reach out; but we see significant community
requests.`,aa,ml,zm=`In order to specify you’d like for us to integrate a specific model, we’ll redirect you to our
<a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=New+model&amp;projects=&amp;template=new-model-addition.yml" rel="nofollow">issue tracker</a>
where you can request a specific model.`,ra,pl,Rm="The more activity on the issue, the faster/more likely we are to integrate the model!",da,hl,ma,ul,Em=`A post-release integration usually happens when there has not been sufficient activity/requests to warrant a same-week
integration, or that we lack the sufficient bandwidth to integrate it.`,pa,fl,Gm=`We very gladly welcome community contributions in those instances; more than half of the library was contributed
by contributors external to Hugging Face. If this is something that is interesting to you, we recommend that you look
at our <a href="https://github.com/huggingface/transformers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+model%22" rel="nofollow">open issues tagged with “New model”</a>.`,ha,cl,Qm=`We recommend you try your hand at a heavily requested model as this will multiply the impact of your contribution.
We’ll be there to help you in case that’s your first contribution 🤗.`,ua,yl,fa,wl,Dm=`Finally, transformers has a “remote-code” possibility, in which contributions are not made within the toolkit, but on
the Hub. This can be particularly interesting for groups that are using <code>transformers</code> as a backbone for their project,
but don’t have the bandwidth to contribute the model to transformers directly.`,ca,Ml,Vm=`In case the model is very successful, then we’ll very likely end up integrating it in <code>transformers</code> at the end - as this
provides better documentation, CI, maintenance, and optimizations - but this remains a great way to make your model
accessible day-0 with minimal friction.`,ya,gl,Fm='This guide is a great starting point for a Hub-first release: <a href="./custom_models">Custom models</a>',wa,Tl,Ma,Wl,ga;return I=new g({props:{title:"How to add a model to 🤗 Transformers?",local:"how-to-add-a-model-to--transformers",headingTag:"h1"}}),W=new g({props:{title:"General overview of 🤗 Transformers",local:"general-overview-of--transformers",headingTag:"h2"}}),E=new g({props:{title:"Overview of models",local:"overview-of-models",headingTag:"h3"}}),V=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwbW9kZWwlMjBoYXMlMjBhY2Nlc3MlMjB0byUyMGl0cyUyMGNvbmZpZw==",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># model has access to its config</span>`,wrap:!1}}),Y=new g({props:{title:"Code style",local:"code-style",headingTag:"h3"}}),q=new g({props:{title:"Overview of tokenizers",local:"overview-of-tokenizers",headingTag:"h3"}}),K=new g({props:{title:"Step-by-step recipe to add a model to 🤗 Transformers",local:"step-by-step-recipe-to-add-a-model-to--transformers",headingTag:"h2"}}),re=new g({props:{title:"1. (Optional) Theoretical aspects of BrandNewBert",local:"1-optional-theoretical-aspects-of-brandnewbert",headingTag:"h3"}}),he=new g({props:{title:"2. Next prepare your environment",local:"2-next-prepare-your-environment",headingTag:"h3"}}),fe=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),ce=new y({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),ye=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnF1YWxpdHklNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[quality]&quot;</span>',wrap:!1}}),we=new y({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),ge=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),be=new g({props:{title:"3.-4. Run a pretrained checkpoint using the original repository",local:"3-4-run-a-pretrained-checkpoint-using-the-original-repository",headingTag:"h3"}}),Ae=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),Ve=new y({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),Xe=new g({props:{title:"5.-14. Port BrandNewBert to 🤗 Transformers",local:"5-14-port-brandnewbert-to--transformers",headingTag:"h3"}}),Oe=new y({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),tt=new y({props:{code:"dHJhbnNmb3JtZXJzLWNsaSUyMGFkZC1uZXctbW9kZWwtbGlrZQ==",highlighted:"transformers-cli add-new-model-like",wrap:!1}}),at=new y({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydA==",highlighted:"git checkout -b add_brand_new_bert",wrap:!1}}),dt=new y({props:{code:"Z2l0JTIwYWRkJTIwLiUwQWdpdCUyMGNvbW1pdA==",highlighted:`git add .
git commit`,wrap:!1}}),pt=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbg==",highlighted:`git fetch upstream
git rebase upstream/main`,wrap:!1}}),ut=new y({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),ct=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),Jt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),kt=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxpbmVhciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUuYmlhcyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5iaWFzLmRhdGEuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkVtYmVkZGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUucGFkZGluZ19pZHglMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGElNUJtb2R1bGUucGFkZGluZ19pZHglNUQuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxheWVyTm9ybSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEuZmlsbF8oMS4wKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Embedding):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.padding_idx <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.weight.data[module.padding_idx].zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.LayerNorm):
        module.bias.data.zero_()
        module.weight.data.fill_(<span class="hljs-number">1.0</span>)`,wrap:!1}}),_t=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMFdhdjJWZWMyRm9yUHJlVHJhaW5pbmcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLnJlc2V0X3BhcmFtZXRlcnMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5wcm9qZWN0X3EucmVzZXRfcGFyYW1ldGVycygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUucHJvamVjdF9xLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjBlbGlmJTIwaXNpbnN0YW5jZShtb2R1bGUlMkMlMjBubi5MaW5lYXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLndlaWdodC5kYXRhLm5vcm1hbF8obWVhbiUzRDAuMCUyQyUyMHN0ZCUzRHNlbGYuY29uZmlnLmluaXRpYWxpemVyX3JhbmdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbW9kdWxlLmJpYXMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, Wav2Vec2ForPreTraining):
        module.project_hid.reset_parameters()
        module.project_q.reset_parameters()
        module.project_hid._is_hf_initialized = <span class="hljs-literal">True</span>
        module.project_q._is_hf_initialized = <span class="hljs-literal">True</span>
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()`,wrap:!1}}),Ht=new y({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),Wt=new y({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),Bt=new y({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),zt=new y({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),Et=new y({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),Qt=new y({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Vt=new y({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),Yt=new y({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),Kt=new y({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),nn=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),pn=new y({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHk=",highlighted:"pytest tests/models/brand_new_bert/test_modeling_brand_new_bert.py",wrap:!1}}),cn=new y({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHklM0ElM0FCcmFuZE5ld0JlcnRNb2RlbEludGVncmF0aW9uVGVzdHM=",highlighted:"RUN_SLOW=1 pytest -sv tests/models/brand_new_bert/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),U=new tp({props:{$$slots:{default:[lp]},$$scope:{ctx:Nl}}}),vn=new y({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),Cn=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Hn=new y({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),Wn=new y({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),En=new y({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyYnJhbmRfbmV3X2JlcnQlMjIpJTBBJTIzJTIwVW5jb21tZW50JTIwdGhlJTIwZm9sbG93aW5nJTIwbGluZSUyMHRvJTIwcHVzaCUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24uJTBBJTIzJTIwYnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyJTNDb3JnYW5pemF0aW9uJTNFJTJGYnJhbmRfbmV3X2JlcnQlMjIp",highlighted:`brand_new_bert.push_to_hub(<span class="hljs-string">&quot;brand_new_bert&quot;</span>)
<span class="hljs-comment"># Uncomment the following line to push to an organization.</span>
<span class="hljs-comment"># brand_new_bert.push_to_hub(&quot;&lt;organization&gt;/brand_new_bert&quot;)</span>`,wrap:!1}}),Yn=new g({props:{title:"Share your work!!",local:"share-your-work",headingTag:"h3"}}),qn=new g({props:{title:"Model additions and their timeline: when is a model added to transformers?",local:"model-additions-and-their-timeline-when-is-a-model-added-to-transformers",headingTag:"h2"}}),ll=new g({props:{title:"Day-0 integration",local:"day-0-integration",headingTag:"h3"}}),rl=new g({props:{title:"Same-week integration",local:"same-week-integration",headingTag:"h3"}}),hl=new g({props:{title:"Post-release integration",local:"post-release-integration",headingTag:"h3"}}),yl=new g({props:{title:"Code-on-Hub release",local:"code-on-hub-release",headingTag:"h3"}}),Tl=new np({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/add_new_model.md"}}),{c(){w=s("meta"),_=o(),j=s("p"),bl=o(),d(I.$$.fragment),Bl=o(),x=s("p"),x.innerHTML=Fa,Pl=o(),$=s("p"),$.textContent=Ya,zl=o(),L=s("ul"),L.innerHTML=Sa,Rl=o(),A=s("p"),A.textContent=Xa,El=o(),H=s("p"),H.innerHTML=qa,Gl=o(),Z=s("p"),Z.textContent=Oa,Ql=o(),d(W.$$.fragment),Dl=o(),N=s("p"),N.textContent=Ka,Vl=o(),B=s("p"),B.innerHTML=er,Fl=o(),P=s("ul"),P.innerHTML=tr,Yl=o(),z=s("p"),z.innerHTML=nr,Sl=o(),R=s("p"),R.textContent=lr,Xl=o(),d(E.$$.fragment),ql=o(),G=s("p"),G.innerHTML=or,Ol=o(),Q=s("p"),Q.textContent=ir,Kl=o(),vl=s("img"),eo=o(),D=s("p"),D.innerHTML=ar,to=o(),d(V.$$.fragment),no=o(),F=s("p"),F.innerHTML=rr,lo=o(),d(Y.$$.fragment),oo=o(),S=s("p"),S.textContent=dr,io=o(),X=s("ol"),X.innerHTML=mr,so=o(),d(q.$$.fragment),ao=o(),O=s("p"),O.textContent=pr,ro=o(),d(K.$$.fragment),mo=o(),ee=s("p"),ee.textContent=hr,po=o(),te=s("ol"),te.innerHTML=ur,ho=o(),ne=s("p"),ne.textContent=fr,uo=o(),le=s("ul"),le.innerHTML=cr,fo=o(),oe=s("p"),oe.textContent=yr,co=o(),ie=s("p"),ie.textContent=wr,yo=o(),se=s("p"),se.innerHTML=Mr,wo=o(),ae=s("p"),ae.innerHTML=gr,Mo=o(),d(re.$$.fragment),go=o(),de=s("p"),de.innerHTML=Tr,To=o(),me=s("ul"),me.innerHTML=br,bo=o(),pe=s("p"),pe.textContent=vr,vo=o(),d(he.$$.fragment),Jo=o(),b=s("ol"),Jl=s("li"),Jl.innerHTML=Jr,ka=o(),ue=s("li"),Cl=s("p"),Cl.innerHTML=Cr,Ua=o(),d(fe.$$.fragment),_a=o(),T=s("li"),jl=s("p"),jl.textContent=jr,Ia=o(),d(ce.$$.fragment),xa=o(),kl=s("p"),kl.textContent=kr,$a=o(),d(ye.$$.fragment),La=o(),Ul=s("p"),Ul.textContent=Ur,Aa=o(),d(we.$$.fragment),Ha=o(),_l=s("li"),_l.innerHTML=_r,Za=o(),Me=s("li"),Il=s("p"),Il.innerHTML=Ir,Wa=o(),d(ge.$$.fragment),Co=o(),Te=s("p"),Te.innerHTML=xr,jo=o(),d(be.$$.fragment),ko=o(),ve=s("p"),ve.innerHTML=$r,Uo=o(),Je=s("p"),Je.textContent=Lr,_o=o(),Ce=s("p"),Ce.innerHTML=Ar,Io=o(),je=s("ul"),je.innerHTML=Hr,xo=o(),ke=s("p"),ke.innerHTML=Zr,$o=o(),Ue=s("p"),Ue.textContent=Wr,Lo=o(),_e=s("p"),_e.textContent=Nr,Ao=o(),Ie=s("ul"),Ie.innerHTML=Br,Ho=o(),xe=s("p"),xe.textContent=Pr,Zo=o(),$e=s("p"),$e.innerHTML=zr,Wo=o(),Le=s("p"),Le.innerHTML=Rr,No=o(),d(Ae.$$.fragment),Bo=o(),He=s("p"),He.textContent=Er,Po=o(),Ze=s("ul"),Ze.innerHTML=Gr,zo=o(),We=s("p"),We.textContent=Qr,Ro=o(),Ne=s("p"),Ne.innerHTML=Dr,Eo=o(),Be=s("ul"),Be.innerHTML=Vr,Go=o(),Pe=s("p"),Pe.innerHTML=Fr,Qo=o(),ze=s("p"),ze.innerHTML=Yr,Do=o(),Re=s("p"),Re.textContent=Sr,Vo=o(),Ee=s("p"),Ee.textContent=Xr,Fo=o(),Ge=s("ol"),Ge.innerHTML=qr,Yo=o(),Qe=s("p"),Qe.innerHTML=Or,So=o(),De=s("p"),De.textContent=Kr,Xo=o(),d(Ve.$$.fragment),qo=o(),Fe=s("p"),Fe.innerHTML=ed,Oo=o(),Ye=s("ul"),Ye.innerHTML=td,Ko=o(),Se=s("p"),Se.innerHTML=nd,ei=o(),d(Xe.$$.fragment),ti=o(),qe=s("p"),qe.textContent=ld,ni=o(),d(Oe.$$.fragment),li=o(),Ke=s("p"),Ke.innerHTML=od,oi=o(),et=s("p"),et.textContent=id,ii=o(),d(tt.$$.fragment),si=o(),nt=s("p"),nt.textContent=sd,ai=o(),lt=s("p"),lt.innerHTML=ad,ri=o(),ot=s("p"),ot.innerHTML=rd,di=o(),it=s("p"),it.textContent=dd,mi=o(),M=s("ol"),st=s("li"),xl=s("p"),xl.textContent=md,Na=o(),d(at.$$.fragment),Ba=o(),rt=s("li"),$l=s("p"),$l.textContent=pd,Pa=o(),d(dt.$$.fragment),za=o(),mt=s("li"),Ll=s("p"),Ll.textContent=hd,Ra=o(),d(pt.$$.fragment),Ea=o(),ht=s("li"),Al=s("p"),Al.textContent=ud,Ga=o(),d(ut.$$.fragment),Qa=o(),Hl=s("li"),Hl.innerHTML=fd,Da=o(),Zl=s("li"),Zl.innerHTML=cd,pi=o(),ft=s("p"),ft.textContent=yd,hi=o(),d(ct.$$.fragment),ui=o(),yt=s("p"),yt.textContent=wd,fi=o(),wt=s("p"),wt.textContent=Md,ci=o(),Mt=s("p"),Mt.textContent=gd,yi=o(),gt=s("p"),gt.innerHTML=Td,wi=o(),Tt=s("p"),Tt.innerHTML=bd,Mi=o(),bt=s("p"),bt.innerHTML=vd,gi=o(),vt=s("p"),vt.innerHTML=Jd,Ti=o(),d(Jt.$$.fragment),bi=o(),Ct=s("p"),Ct.innerHTML=Cd,vi=o(),jt=s("p"),jt.innerHTML=jd,Ji=o(),d(kt.$$.fragment),Ci=o(),Ut=s("p"),Ut.innerHTML=kd,ji=o(),d(_t.$$.fragment),ki=o(),It=s("p"),It.innerHTML=Ud,Ui=o(),xt=s("p"),xt.innerHTML=_d,_i=o(),$t=s("p"),$t.innerHTML=Id,Ii=o(),Lt=s("ul"),Lt.innerHTML=xd,xi=o(),At=s("p"),At.innerHTML=$d,$i=o(),d(Ht.$$.fragment),Li=o(),Zt=s("p"),Zt.innerHTML=Ld,Ai=o(),d(Wt.$$.fragment),Hi=o(),Nt=s("p"),Nt.textContent=Ad,Zi=o(),d(Bt.$$.fragment),Wi=o(),Pt=s("p"),Pt.textContent=Hd,Ni=o(),d(zt.$$.fragment),Bi=o(),Rt=s("p"),Rt.textContent=Zd,Pi=o(),d(Et.$$.fragment),zi=o(),Gt=s("p"),Gt.innerHTML=Wd,Ri=o(),d(Qt.$$.fragment),Ei=o(),Dt=s("p"),Dt.innerHTML=Nd,Gi=o(),d(Vt.$$.fragment),Qi=o(),Ft=s("p"),Ft.innerHTML=Bd,Di=o(),d(Yt.$$.fragment),Vi=o(),St=s("p"),St.textContent=Pd,Fi=o(),Xt=s("p"),Xt.innerHTML=zd,Yi=o(),qt=s("p"),qt.innerHTML=Rd,Si=o(),Ot=s("p"),Ot.innerHTML=Ed,Xi=o(),d(Kt.$$.fragment),qi=o(),en=s("p"),en.innerHTML=Gd,Oi=o(),tn=s("p"),tn.innerHTML=Qd,Ki=o(),d(nn.$$.fragment),es=o(),ln=s("p"),ln.innerHTML=Dd,ts=o(),on=s("p"),on.innerHTML=Vd,ns=o(),sn=s("ul"),sn.innerHTML=Fd,ls=o(),an=s("p"),an.innerHTML=Yd,os=o(),rn=s("p"),rn.innerHTML=Sd,is=o(),dn=s("p"),dn.innerHTML=Xd,ss=o(),mn=s("p"),mn.innerHTML=qd,as=o(),d(pn.$$.fragment),rs=o(),hn=s("p"),hn.textContent=Od,ds=o(),un=s("ul"),un.innerHTML=Kd,ms=o(),fn=s("p"),fn.innerHTML=em,ps=o(),d(cn.$$.fragment),hs=o(),d(U.$$.fragment),us=o(),yn=s("p"),yn.innerHTML=tm,fs=o(),wn=s("ul"),wn.innerHTML=nm,cs=o(),Mn=s("p"),Mn.innerHTML=lm,ys=o(),gn=s("p"),gn.innerHTML=om,ws=o(),Tn=s("p"),Tn.textContent=im,Ms=o(),bn=s("p"),bn.innerHTML=sm,gs=o(),d(vn.$$.fragment),Ts=o(),Jn=s("p"),Jn.innerHTML=am,bs=o(),d(Cn.$$.fragment),vs=o(),jn=s("p"),jn.innerHTML=rm,Js=o(),kn=s("p"),kn.innerHTML=dm,Cs=o(),Un=s("p"),Un.innerHTML=mm,js=o(),_n=s("p"),_n.innerHTML=pm,ks=o(),In=s("p"),In.innerHTML=hm,Us=o(),xn=s("p"),xn.innerHTML=um,_s=o(),$n=s("p"),$n.innerHTML=fm,Is=o(),Ln=s("p"),Ln.innerHTML=cm,xs=o(),An=s("p"),An.innerHTML=ym,$s=o(),d(Hn.$$.fragment),Ls=o(),Zn=s("p"),Zn.textContent=wm,As=o(),d(Wn.$$.fragment),Hs=o(),Nn=s("p"),Nn.textContent=Mm,Zs=o(),Bn=s("p"),Bn.textContent=gm,Ws=o(),Pn=s("p"),Pn.textContent=Tm,Ns=o(),zn=s("p"),zn.innerHTML=bm,Bs=o(),Rn=s("p"),Rn.innerHTML=vm,Ps=o(),d(En.$$.fragment),zs=o(),Gn=s("p"),Gn.innerHTML=Jm,Rs=o(),Qn=s("p"),Qn.innerHTML=Cm,Es=o(),Dn=s("p"),Dn.innerHTML=jm,Gs=o(),Vn=s("p"),Vn.innerHTML=km,Qs=o(),Fn=s("p"),Fn.textContent=Um,Ds=o(),d(Yn.$$.fragment),Vs=o(),Sn=s("p"),Sn.textContent=_m,Fs=o(),Xn=s("p"),Xn.innerHTML=Im,Ys=o(),d(qn.$$.fragment),Ss=o(),On=s("p"),On.innerHTML=xm,Xs=o(),Kn=s("p"),Kn.textContent=$m,qs=o(),el=s("p"),el.textContent=Lm,Os=o(),tl=s("ul"),tl.innerHTML=Am,Ks=o(),nl=s("p"),nl.textContent=Hm,ea=o(),d(ll.$$.fragment),ta=o(),ol=s("p"),ol.textContent=Zm,na=o(),il=s("p"),il.textContent=Wm,la=o(),sl=s("p"),sl.innerHTML=Nm,oa=o(),al=s("p"),al.innerHTML=Bm,ia=o(),d(rl.$$.fragment),sa=o(),dl=s("p"),dl.textContent=Pm,aa=o(),ml=s("p"),ml.innerHTML=zm,ra=o(),pl=s("p"),pl.textContent=Rm,da=o(),d(hl.$$.fragment),ma=o(),ul=s("p"),ul.textContent=Em,pa=o(),fl=s("p"),fl.innerHTML=Gm,ha=o(),cl=s("p"),cl.textContent=Qm,ua=o(),d(yl.$$.fragment),fa=o(),wl=s("p"),wl.innerHTML=Dm,ca=o(),Ml=s("p"),Ml.innerHTML=Vm,ya=o(),gl=s("p"),gl.innerHTML=Fm,wa=o(),d(Tl.$$.fragment),Ma=o(),Wl=s("p"),this.h()},l(e){const t=ep("svelte-u9bgzb",document.head);w=a(t,"META",{name:!0,content:!0}),t.forEach(n),_=i(e),j=a(e,"P",{}),k(j).forEach(n),bl=i(e),m(I.$$.fragment,e),Bl=i(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-wxtsp1"&&(x.innerHTML=Fa),Pl=i(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1k9yxd1"&&($.textContent=Ya),zl=i(e),L=a(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-167a1ja"&&(L.innerHTML=Sa),Rl=i(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1wxv5qq"&&(A.textContent=Xa),El=i(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-77fy0j"&&(H.innerHTML=qa),Gl=i(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ug8854"&&(Z.textContent=Oa),Ql=i(e),m(W.$$.fragment,e),Dl=i(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-rkgkw1"&&(N.textContent=Ka),Vl=i(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-hekrk0"&&(B.innerHTML=er),Fl=i(e),P=a(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-9txdfw"&&(P.innerHTML=tr),Yl=i(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-77738k"&&(z.innerHTML=nr),Sl=i(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1z0o4ph"&&(R.textContent=lr),Xl=i(e),m(E.$$.fragment,e),ql=i(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-k29h5h"&&(G.innerHTML=or),Ol=i(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1bv64m8"&&(Q.textContent=ir),Kl=i(e),vl=a(e,"IMG",{src:!0}),eo=i(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1j7ilc9"&&(D.innerHTML=ar),to=i(e),m(V.$$.fragment,e),no=i(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-33bpss"&&(F.innerHTML=rr),lo=i(e),m(Y.$$.fragment,e),oo=i(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-105bqi8"&&(S.textContent=dr),io=i(e),X=a(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-3selcg"&&(X.innerHTML=mr),so=i(e),m(q.$$.fragment,e),ao=i(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-10n9flr"&&(O.textContent=pr),ro=i(e),m(K.$$.fragment,e),mo=i(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-u747sz"&&(ee.textContent=hr),po=i(e),te=a(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-b7gw6m"&&(te.innerHTML=ur),ho=i(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-lru7u6"&&(ne.textContent=fr),uo=i(e),le=a(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-otnau5"&&(le.innerHTML=cr),fo=i(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-sv8a89"&&(oe.textContent=yr),co=i(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ydy9mz"&&(ie.textContent=wr),yo=i(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-w74yfn"&&(se.innerHTML=Mr),wo=i(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1pmt80l"&&(ae.innerHTML=gr),Mo=i(e),m(re.$$.fragment,e),go=i(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-10phlbf"&&(de.innerHTML=Tr),To=i(e),me=a(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-1b4oxlm"&&(me.innerHTML=br),bo=i(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-g50mc6"&&(pe.textContent=vr),vo=i(e),m(he.$$.fragment,e),Jo=i(e),b=a(e,"OL",{});var v=k(b);Jl=a(v,"LI",{"data-svelte-h":!0}),r(Jl)!=="svelte-4g2dtl"&&(Jl.innerHTML=Jr),ka=i(v),ue=a(v,"LI",{});var Ta=k(ue);Cl=a(Ta,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-lgncv4"&&(Cl.innerHTML=Cr),Ua=i(Ta),m(fe.$$.fragment,Ta),Ta.forEach(n),_a=i(v),T=a(v,"LI",{});var J=k(T);jl=a(J,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-lbvoi5"&&(jl.textContent=jr),Ia=i(J),m(ce.$$.fragment,J),xa=i(J),kl=a(J,"P",{"data-svelte-h":!0}),r(kl)!=="svelte-4wf1r3"&&(kl.textContent=kr),$a=i(J),m(ye.$$.fragment,J),La=i(J),Ul=a(J,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-182t6ba"&&(Ul.textContent=Ur),Aa=i(J),m(we.$$.fragment,J),J.forEach(n),Ha=i(v),_l=a(v,"LI",{"data-svelte-h":!0}),r(_l)!=="svelte-1t6q97z"&&(_l.innerHTML=_r),Za=i(v),Me=a(v,"LI",{});var ba=k(Me);Il=a(ba,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-hv4twz"&&(Il.innerHTML=Ir),Wa=i(ba),m(ge.$$.fragment,ba),ba.forEach(n),v.forEach(n),Co=i(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-63px9k"&&(Te.innerHTML=xr),jo=i(e),m(be.$$.fragment,e),ko=i(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-hj6dkp"&&(ve.innerHTML=$r),Uo=i(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1wodnvr"&&(Je.textContent=Lr),_o=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-172lkai"&&(Ce.innerHTML=Ar),Io=i(e),je=a(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-10bloo4"&&(je.innerHTML=Hr),xo=i(e),ke=a(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1jxuc4f"&&(ke.innerHTML=Zr),$o=i(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-197bmdq"&&(Ue.textContent=Wr),Lo=i(e),_e=a(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-9v9j15"&&(_e.textContent=Nr),Ao=i(e),Ie=a(e,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-1k92mpt"&&(Ie.innerHTML=Br),Ho=i(e),xe=a(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-xdlpes"&&(xe.textContent=Pr),Zo=i(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1u4zdsg"&&($e.innerHTML=zr),Wo=i(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1g4uiwx"&&(Le.innerHTML=Rr),No=i(e),m(Ae.$$.fragment,e),Bo=i(e),He=a(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-17f6vr7"&&(He.textContent=Er),Po=i(e),Ze=a(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1w5zp67"&&(Ze.innerHTML=Gr),zo=i(e),We=a(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-69ds49"&&(We.textContent=Qr),Ro=i(e),Ne=a(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-17olrqh"&&(Ne.innerHTML=Dr),Eo=i(e),Be=a(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-uaiiy7"&&(Be.innerHTML=Vr),Go=i(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-pv6v4"&&(Pe.innerHTML=Fr),Qo=i(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1ex3w25"&&(ze.innerHTML=Yr),Do=i(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1480vjb"&&(Re.textContent=Sr),Vo=i(e),Ee=a(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1sttzvl"&&(Ee.textContent=Xr),Fo=i(e),Ge=a(e,"OL",{"data-svelte-h":!0}),r(Ge)!=="svelte-1u0bkk8"&&(Ge.innerHTML=qr),Yo=i(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-xvgy42"&&(Qe.innerHTML=Or),So=i(e),De=a(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-a9oe4g"&&(De.textContent=Kr),Xo=i(e),m(Ve.$$.fragment,e),qo=i(e),Fe=a(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1d7jpm"&&(Fe.innerHTML=ed),Oo=i(e),Ye=a(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-1bsafyj"&&(Ye.innerHTML=td),Ko=i(e),Se=a(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1fog5tn"&&(Se.innerHTML=nd),ei=i(e),m(Xe.$$.fragment,e),ti=i(e),qe=a(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-hwuqxz"&&(qe.textContent=ld),ni=i(e),m(Oe.$$.fragment,e),li=i(e),Ke=a(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1492az0"&&(Ke.innerHTML=od),oi=i(e),et=a(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-5vgl1p"&&(et.textContent=id),ii=i(e),m(tt.$$.fragment,e),si=i(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-v5lffq"&&(nt.textContent=sd),ai=i(e),lt=a(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1e0s43k"&&(lt.innerHTML=ad),ri=i(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1aoj71c"&&(ot.innerHTML=rd),di=i(e),it=a(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-3h83p"&&(it.textContent=dd),mi=i(e),M=a(e,"OL",{});var C=k(M);st=a(C,"LI",{});var va=k(st);xl=a(va,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-1hwk139"&&(xl.textContent=md),Na=i(va),m(at.$$.fragment,va),va.forEach(n),Ba=i(C),rt=a(C,"LI",{});var Ja=k(rt);$l=a(Ja,"P",{"data-svelte-h":!0}),r($l)!=="svelte-gmko0l"&&($l.textContent=pd),Pa=i(Ja),m(dt.$$.fragment,Ja),Ja.forEach(n),za=i(C),mt=a(C,"LI",{});var Ca=k(mt);Ll=a(Ca,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-h4badi"&&(Ll.textContent=hd),Ra=i(Ca),m(pt.$$.fragment,Ca),Ca.forEach(n),Ea=i(C),ht=a(C,"LI",{});var ja=k(ht);Al=a(ja,"P",{"data-svelte-h":!0}),r(Al)!=="svelte-1adm7yl"&&(Al.textContent=ud),Ga=i(ja),m(ut.$$.fragment,ja),ja.forEach(n),Qa=i(C),Hl=a(C,"LI",{"data-svelte-h":!0}),r(Hl)!=="svelte-v52akd"&&(Hl.innerHTML=fd),Da=i(C),Zl=a(C,"LI",{"data-svelte-h":!0}),r(Zl)!=="svelte-1jfczy2"&&(Zl.innerHTML=cd),C.forEach(n),pi=i(e),ft=a(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-fby7tz"&&(ft.textContent=yd),hi=i(e),m(ct.$$.fragment,e),ui=i(e),yt=a(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-707ott"&&(yt.textContent=wd),fi=i(e),wt=a(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-10vuoyb"&&(wt.textContent=Md),ci=i(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1rsqt8e"&&(Mt.textContent=gd),yi=i(e),gt=a(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-e56uo0"&&(gt.innerHTML=Td),wi=i(e),Tt=a(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1pev0u3"&&(Tt.innerHTML=bd),Mi=i(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-o2c99d"&&(bt.innerHTML=vd),gi=i(e),vt=a(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-cf404e"&&(vt.innerHTML=Jd),Ti=i(e),m(Jt.$$.fragment,e),bi=i(e),Ct=a(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1dloo7i"&&(Ct.innerHTML=Cd),vi=i(e),jt=a(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-nsqyfa"&&(jt.innerHTML=jd),Ji=i(e),m(kt.$$.fragment,e),Ci=i(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-sj6wf0"&&(Ut.innerHTML=kd),ji=i(e),m(_t.$$.fragment,e),ki=i(e),It=a(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1pfm0sb"&&(It.innerHTML=Ud),Ui=i(e),xt=a(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-f68cwo"&&(xt.innerHTML=_d),_i=i(e),$t=a(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-vdut7s"&&($t.innerHTML=Id),Ii=i(e),Lt=a(e,"UL",{"data-svelte-h":!0}),r(Lt)!=="svelte-16vb6hw"&&(Lt.innerHTML=xd),xi=i(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-14nqqv0"&&(At.innerHTML=$d),$i=i(e),m(Ht.$$.fragment,e),Li=i(e),Zt=a(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-p81vjw"&&(Zt.innerHTML=Ld),Ai=i(e),m(Wt.$$.fragment,e),Hi=i(e),Nt=a(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-ilov09"&&(Nt.textContent=Ad),Zi=i(e),m(Bt.$$.fragment,e),Wi=i(e),Pt=a(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-13dugi2"&&(Pt.textContent=Hd),Ni=i(e),m(zt.$$.fragment,e),Bi=i(e),Rt=a(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1lx6n8g"&&(Rt.textContent=Zd),Pi=i(e),m(Et.$$.fragment,e),zi=i(e),Gt=a(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1t5qty0"&&(Gt.innerHTML=Wd),Ri=i(e),m(Qt.$$.fragment,e),Ei=i(e),Dt=a(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1b67ucv"&&(Dt.innerHTML=Nd),Gi=i(e),m(Vt.$$.fragment,e),Qi=i(e),Ft=a(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-10rxzj1"&&(Ft.innerHTML=Bd),Di=i(e),m(Yt.$$.fragment,e),Vi=i(e),St=a(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-tq4e7m"&&(St.textContent=Pd),Fi=i(e),Xt=a(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-nguxo0"&&(Xt.innerHTML=zd),Yi=i(e),qt=a(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-5g2dr4"&&(qt.innerHTML=Rd),Si=i(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-jkulr9"&&(Ot.innerHTML=Ed),Xi=i(e),m(Kt.$$.fragment,e),qi=i(e),en=a(e,"P",{"data-svelte-h":!0}),r(en)!=="svelte-8ivqw6"&&(en.innerHTML=Gd),Oi=i(e),tn=a(e,"P",{"data-svelte-h":!0}),r(tn)!=="svelte-1v8xetm"&&(tn.innerHTML=Qd),Ki=i(e),m(nn.$$.fragment,e),es=i(e),ln=a(e,"P",{"data-svelte-h":!0}),r(ln)!=="svelte-txar7q"&&(ln.innerHTML=Dd),ts=i(e),on=a(e,"P",{"data-svelte-h":!0}),r(on)!=="svelte-10rs2ro"&&(on.innerHTML=Vd),ns=i(e),sn=a(e,"UL",{"data-svelte-h":!0}),r(sn)!=="svelte-1r46n3h"&&(sn.innerHTML=Fd),ls=i(e),an=a(e,"P",{"data-svelte-h":!0}),r(an)!=="svelte-1i2mpdn"&&(an.innerHTML=Yd),os=i(e),rn=a(e,"P",{"data-svelte-h":!0}),r(rn)!=="svelte-16p1dlw"&&(rn.innerHTML=Sd),is=i(e),dn=a(e,"P",{"data-svelte-h":!0}),r(dn)!=="svelte-1q8o052"&&(dn.innerHTML=Xd),ss=i(e),mn=a(e,"P",{"data-svelte-h":!0}),r(mn)!=="svelte-13ruakv"&&(mn.innerHTML=qd),as=i(e),m(pn.$$.fragment,e),rs=i(e),hn=a(e,"P",{"data-svelte-h":!0}),r(hn)!=="svelte-1z4cf"&&(hn.textContent=Od),ds=i(e),un=a(e,"UL",{"data-svelte-h":!0}),r(un)!=="svelte-1msq586"&&(un.innerHTML=Kd),ms=i(e),fn=a(e,"P",{"data-svelte-h":!0}),r(fn)!=="svelte-2t6h0z"&&(fn.innerHTML=em),ps=i(e),m(cn.$$.fragment,e),hs=i(e),m(U.$$.fragment,e),us=i(e),yn=a(e,"P",{"data-svelte-h":!0}),r(yn)!=="svelte-63hgsc"&&(yn.innerHTML=tm),fs=i(e),wn=a(e,"UL",{"data-svelte-h":!0}),r(wn)!=="svelte-1192mxo"&&(wn.innerHTML=nm),cs=i(e),Mn=a(e,"P",{"data-svelte-h":!0}),r(Mn)!=="svelte-1l7w7z9"&&(Mn.innerHTML=lm),ys=i(e),gn=a(e,"P",{"data-svelte-h":!0}),r(gn)!=="svelte-17g0btz"&&(gn.innerHTML=om),ws=i(e),Tn=a(e,"P",{"data-svelte-h":!0}),r(Tn)!=="svelte-w3jgow"&&(Tn.textContent=im),Ms=i(e),bn=a(e,"P",{"data-svelte-h":!0}),r(bn)!=="svelte-3mgn5l"&&(bn.innerHTML=sm),gs=i(e),m(vn.$$.fragment,e),Ts=i(e),Jn=a(e,"P",{"data-svelte-h":!0}),r(Jn)!=="svelte-12b6z3d"&&(Jn.innerHTML=am),bs=i(e),m(Cn.$$.fragment,e),vs=i(e),jn=a(e,"P",{"data-svelte-h":!0}),r(jn)!=="svelte-12o38jn"&&(jn.innerHTML=rm),Js=i(e),kn=a(e,"P",{"data-svelte-h":!0}),r(kn)!=="svelte-m9dhdl"&&(kn.innerHTML=dm),Cs=i(e),Un=a(e,"P",{"data-svelte-h":!0}),r(Un)!=="svelte-1r4x1hz"&&(Un.innerHTML=mm),js=i(e),_n=a(e,"P",{"data-svelte-h":!0}),r(_n)!=="svelte-1a2qjdi"&&(_n.innerHTML=pm),ks=i(e),In=a(e,"P",{"data-svelte-h":!0}),r(In)!=="svelte-lu4l51"&&(In.innerHTML=hm),Us=i(e),xn=a(e,"P",{"data-svelte-h":!0}),r(xn)!=="svelte-ngbmem"&&(xn.innerHTML=um),_s=i(e),$n=a(e,"P",{"data-svelte-h":!0}),r($n)!=="svelte-oj7bsa"&&($n.innerHTML=fm),Is=i(e),Ln=a(e,"P",{"data-svelte-h":!0}),r(Ln)!=="svelte-1h13ics"&&(Ln.innerHTML=cm),xs=i(e),An=a(e,"P",{"data-svelte-h":!0}),r(An)!=="svelte-1o0dhcg"&&(An.innerHTML=ym),$s=i(e),m(Hn.$$.fragment,e),Ls=i(e),Zn=a(e,"P",{"data-svelte-h":!0}),r(Zn)!=="svelte-1hnvgw6"&&(Zn.textContent=wm),As=i(e),m(Wn.$$.fragment,e),Hs=i(e),Nn=a(e,"P",{"data-svelte-h":!0}),r(Nn)!=="svelte-158gt2o"&&(Nn.textContent=Mm),Zs=i(e),Bn=a(e,"P",{"data-svelte-h":!0}),r(Bn)!=="svelte-z20wkr"&&(Bn.textContent=gm),Ws=i(e),Pn=a(e,"P",{"data-svelte-h":!0}),r(Pn)!=="svelte-1uwhc8b"&&(Pn.textContent=Tm),Ns=i(e),zn=a(e,"P",{"data-svelte-h":!0}),r(zn)!=="svelte-cmu0wm"&&(zn.innerHTML=bm),Bs=i(e),Rn=a(e,"P",{"data-svelte-h":!0}),r(Rn)!=="svelte-11c1nk5"&&(Rn.innerHTML=vm),Ps=i(e),m(En.$$.fragment,e),zs=i(e),Gn=a(e,"P",{"data-svelte-h":!0}),r(Gn)!=="svelte-hwxs76"&&(Gn.innerHTML=Jm),Rs=i(e),Qn=a(e,"P",{"data-svelte-h":!0}),r(Qn)!=="svelte-1gie4tq"&&(Qn.innerHTML=Cm),Es=i(e),Dn=a(e,"P",{"data-svelte-h":!0}),r(Dn)!=="svelte-1so49zx"&&(Dn.innerHTML=jm),Gs=i(e),Vn=a(e,"P",{"data-svelte-h":!0}),r(Vn)!=="svelte-144ouhf"&&(Vn.innerHTML=km),Qs=i(e),Fn=a(e,"P",{"data-svelte-h":!0}),r(Fn)!=="svelte-jag54x"&&(Fn.textContent=Um),Ds=i(e),m(Yn.$$.fragment,e),Vs=i(e),Sn=a(e,"P",{"data-svelte-h":!0}),r(Sn)!=="svelte-d34izn"&&(Sn.textContent=_m),Fs=i(e),Xn=a(e,"P",{"data-svelte-h":!0}),r(Xn)!=="svelte-1f9gbqf"&&(Xn.innerHTML=Im),Ys=i(e),m(qn.$$.fragment,e),Ss=i(e),On=a(e,"P",{"data-svelte-h":!0}),r(On)!=="svelte-tflftr"&&(On.innerHTML=xm),Xs=i(e),Kn=a(e,"P",{"data-svelte-h":!0}),r(Kn)!=="svelte-1id01bn"&&(Kn.textContent=$m),qs=i(e),el=a(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-18wa7xb"&&(el.textContent=Lm),Os=i(e),tl=a(e,"UL",{"data-svelte-h":!0}),r(tl)!=="svelte-13d4n7l"&&(tl.innerHTML=Am),Ks=i(e),nl=a(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-1mavb8r"&&(nl.textContent=Hm),ea=i(e),m(ll.$$.fragment,e),ta=i(e),ol=a(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-l2ui8g"&&(ol.textContent=Zm),na=i(e),il=a(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-t89e2e"&&(il.textContent=Wm),la=i(e),sl=a(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1oo14hs"&&(sl.innerHTML=Nm),oa=i(e),al=a(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-12otybo"&&(al.innerHTML=Bm),ia=i(e),m(rl.$$.fragment,e),sa=i(e),dl=a(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-u2wuxh"&&(dl.textContent=Pm),aa=i(e),ml=a(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-1y4lrhl"&&(ml.innerHTML=zm),ra=i(e),pl=a(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1js20v3"&&(pl.textContent=Rm),da=i(e),m(hl.$$.fragment,e),ma=i(e),ul=a(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-23hlj0"&&(ul.textContent=Em),pa=i(e),fl=a(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-145g88h"&&(fl.innerHTML=Gm),ha=i(e),cl=a(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-1ytby5x"&&(cl.textContent=Qm),ua=i(e),m(yl.$$.fragment,e),fa=i(e),wl=a(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-iaja9p"&&(wl.innerHTML=Dm),ca=i(e),Ml=a(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-111tkdt"&&(Ml.innerHTML=Vm),ya=i(e),gl=a(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-18r5hss"&&(gl.innerHTML=Fm),wa=i(e),m(Tl.$$.fragment,e),Ma=i(e),Wl=a(e,"P",{}),k(Wl).forEach(n),this.h()},h(){Va(w,"name","hf:doc:metadata"),Va(w,"content",ip),Sm(vl.src,sr="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||Va(vl,"src",sr)},m(e,t){c(document.head,w),l(e,_,t),l(e,j,t),l(e,bl,t),p(I,e,t),l(e,Bl,t),l(e,x,t),l(e,Pl,t),l(e,$,t),l(e,zl,t),l(e,L,t),l(e,Rl,t),l(e,A,t),l(e,El,t),l(e,H,t),l(e,Gl,t),l(e,Z,t),l(e,Ql,t),p(W,e,t),l(e,Dl,t),l(e,N,t),l(e,Vl,t),l(e,B,t),l(e,Fl,t),l(e,P,t),l(e,Yl,t),l(e,z,t),l(e,Sl,t),l(e,R,t),l(e,Xl,t),p(E,e,t),l(e,ql,t),l(e,G,t),l(e,Ol,t),l(e,Q,t),l(e,Kl,t),l(e,vl,t),l(e,eo,t),l(e,D,t),l(e,to,t),p(V,e,t),l(e,no,t),l(e,F,t),l(e,lo,t),p(Y,e,t),l(e,oo,t),l(e,S,t),l(e,io,t),l(e,X,t),l(e,so,t),p(q,e,t),l(e,ao,t),l(e,O,t),l(e,ro,t),p(K,e,t),l(e,mo,t),l(e,ee,t),l(e,po,t),l(e,te,t),l(e,ho,t),l(e,ne,t),l(e,uo,t),l(e,le,t),l(e,fo,t),l(e,oe,t),l(e,co,t),l(e,ie,t),l(e,yo,t),l(e,se,t),l(e,wo,t),l(e,ae,t),l(e,Mo,t),p(re,e,t),l(e,go,t),l(e,de,t),l(e,To,t),l(e,me,t),l(e,bo,t),l(e,pe,t),l(e,vo,t),p(he,e,t),l(e,Jo,t),l(e,b,t),c(b,Jl),c(b,ka),c(b,ue),c(ue,Cl),c(ue,Ua),p(fe,ue,null),c(b,_a),c(b,T),c(T,jl),c(T,Ia),p(ce,T,null),c(T,xa),c(T,kl),c(T,$a),p(ye,T,null),c(T,La),c(T,Ul),c(T,Aa),p(we,T,null),c(b,Ha),c(b,_l),c(b,Za),c(b,Me),c(Me,Il),c(Me,Wa),p(ge,Me,null),l(e,Co,t),l(e,Te,t),l(e,jo,t),p(be,e,t),l(e,ko,t),l(e,ve,t),l(e,Uo,t),l(e,Je,t),l(e,_o,t),l(e,Ce,t),l(e,Io,t),l(e,je,t),l(e,xo,t),l(e,ke,t),l(e,$o,t),l(e,Ue,t),l(e,Lo,t),l(e,_e,t),l(e,Ao,t),l(e,Ie,t),l(e,Ho,t),l(e,xe,t),l(e,Zo,t),l(e,$e,t),l(e,Wo,t),l(e,Le,t),l(e,No,t),p(Ae,e,t),l(e,Bo,t),l(e,He,t),l(e,Po,t),l(e,Ze,t),l(e,zo,t),l(e,We,t),l(e,Ro,t),l(e,Ne,t),l(e,Eo,t),l(e,Be,t),l(e,Go,t),l(e,Pe,t),l(e,Qo,t),l(e,ze,t),l(e,Do,t),l(e,Re,t),l(e,Vo,t),l(e,Ee,t),l(e,Fo,t),l(e,Ge,t),l(e,Yo,t),l(e,Qe,t),l(e,So,t),l(e,De,t),l(e,Xo,t),p(Ve,e,t),l(e,qo,t),l(e,Fe,t),l(e,Oo,t),l(e,Ye,t),l(e,Ko,t),l(e,Se,t),l(e,ei,t),p(Xe,e,t),l(e,ti,t),l(e,qe,t),l(e,ni,t),p(Oe,e,t),l(e,li,t),l(e,Ke,t),l(e,oi,t),l(e,et,t),l(e,ii,t),p(tt,e,t),l(e,si,t),l(e,nt,t),l(e,ai,t),l(e,lt,t),l(e,ri,t),l(e,ot,t),l(e,di,t),l(e,it,t),l(e,mi,t),l(e,M,t),c(M,st),c(st,xl),c(st,Na),p(at,st,null),c(M,Ba),c(M,rt),c(rt,$l),c(rt,Pa),p(dt,rt,null),c(M,za),c(M,mt),c(mt,Ll),c(mt,Ra),p(pt,mt,null),c(M,Ea),c(M,ht),c(ht,Al),c(ht,Ga),p(ut,ht,null),c(M,Qa),c(M,Hl),c(M,Da),c(M,Zl),l(e,pi,t),l(e,ft,t),l(e,hi,t),p(ct,e,t),l(e,ui,t),l(e,yt,t),l(e,fi,t),l(e,wt,t),l(e,ci,t),l(e,Mt,t),l(e,yi,t),l(e,gt,t),l(e,wi,t),l(e,Tt,t),l(e,Mi,t),l(e,bt,t),l(e,gi,t),l(e,vt,t),l(e,Ti,t),p(Jt,e,t),l(e,bi,t),l(e,Ct,t),l(e,vi,t),l(e,jt,t),l(e,Ji,t),p(kt,e,t),l(e,Ci,t),l(e,Ut,t),l(e,ji,t),p(_t,e,t),l(e,ki,t),l(e,It,t),l(e,Ui,t),l(e,xt,t),l(e,_i,t),l(e,$t,t),l(e,Ii,t),l(e,Lt,t),l(e,xi,t),l(e,At,t),l(e,$i,t),p(Ht,e,t),l(e,Li,t),l(e,Zt,t),l(e,Ai,t),p(Wt,e,t),l(e,Hi,t),l(e,Nt,t),l(e,Zi,t),p(Bt,e,t),l(e,Wi,t),l(e,Pt,t),l(e,Ni,t),p(zt,e,t),l(e,Bi,t),l(e,Rt,t),l(e,Pi,t),p(Et,e,t),l(e,zi,t),l(e,Gt,t),l(e,Ri,t),p(Qt,e,t),l(e,Ei,t),l(e,Dt,t),l(e,Gi,t),p(Vt,e,t),l(e,Qi,t),l(e,Ft,t),l(e,Di,t),p(Yt,e,t),l(e,Vi,t),l(e,St,t),l(e,Fi,t),l(e,Xt,t),l(e,Yi,t),l(e,qt,t),l(e,Si,t),l(e,Ot,t),l(e,Xi,t),p(Kt,e,t),l(e,qi,t),l(e,en,t),l(e,Oi,t),l(e,tn,t),l(e,Ki,t),p(nn,e,t),l(e,es,t),l(e,ln,t),l(e,ts,t),l(e,on,t),l(e,ns,t),l(e,sn,t),l(e,ls,t),l(e,an,t),l(e,os,t),l(e,rn,t),l(e,is,t),l(e,dn,t),l(e,ss,t),l(e,mn,t),l(e,as,t),p(pn,e,t),l(e,rs,t),l(e,hn,t),l(e,ds,t),l(e,un,t),l(e,ms,t),l(e,fn,t),l(e,ps,t),p(cn,e,t),l(e,hs,t),p(U,e,t),l(e,us,t),l(e,yn,t),l(e,fs,t),l(e,wn,t),l(e,cs,t),l(e,Mn,t),l(e,ys,t),l(e,gn,t),l(e,ws,t),l(e,Tn,t),l(e,Ms,t),l(e,bn,t),l(e,gs,t),p(vn,e,t),l(e,Ts,t),l(e,Jn,t),l(e,bs,t),p(Cn,e,t),l(e,vs,t),l(e,jn,t),l(e,Js,t),l(e,kn,t),l(e,Cs,t),l(e,Un,t),l(e,js,t),l(e,_n,t),l(e,ks,t),l(e,In,t),l(e,Us,t),l(e,xn,t),l(e,_s,t),l(e,$n,t),l(e,Is,t),l(e,Ln,t),l(e,xs,t),l(e,An,t),l(e,$s,t),p(Hn,e,t),l(e,Ls,t),l(e,Zn,t),l(e,As,t),p(Wn,e,t),l(e,Hs,t),l(e,Nn,t),l(e,Zs,t),l(e,Bn,t),l(e,Ws,t),l(e,Pn,t),l(e,Ns,t),l(e,zn,t),l(e,Bs,t),l(e,Rn,t),l(e,Ps,t),p(En,e,t),l(e,zs,t),l(e,Gn,t),l(e,Rs,t),l(e,Qn,t),l(e,Es,t),l(e,Dn,t),l(e,Gs,t),l(e,Vn,t),l(e,Qs,t),l(e,Fn,t),l(e,Ds,t),p(Yn,e,t),l(e,Vs,t),l(e,Sn,t),l(e,Fs,t),l(e,Xn,t),l(e,Ys,t),p(qn,e,t),l(e,Ss,t),l(e,On,t),l(e,Xs,t),l(e,Kn,t),l(e,qs,t),l(e,el,t),l(e,Os,t),l(e,tl,t),l(e,Ks,t),l(e,nl,t),l(e,ea,t),p(ll,e,t),l(e,ta,t),l(e,ol,t),l(e,na,t),l(e,il,t),l(e,la,t),l(e,sl,t),l(e,oa,t),l(e,al,t),l(e,ia,t),p(rl,e,t),l(e,sa,t),l(e,dl,t),l(e,aa,t),l(e,ml,t),l(e,ra,t),l(e,pl,t),l(e,da,t),p(hl,e,t),l(e,ma,t),l(e,ul,t),l(e,pa,t),l(e,fl,t),l(e,ha,t),l(e,cl,t),l(e,ua,t),p(yl,e,t),l(e,fa,t),l(e,wl,t),l(e,ca,t),l(e,Ml,t),l(e,ya,t),l(e,gl,t),l(e,wa,t),p(Tl,e,t),l(e,Ma,t),l(e,Wl,t),ga=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),U.$set(v)},i(e){ga||(h(I.$$.fragment,e),h(W.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(Ae.$$.fragment,e),h(Ve.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ut.$$.fragment,e),h(ct.$$.fragment,e),h(Jt.$$.fragment,e),h(kt.$$.fragment,e),h(_t.$$.fragment,e),h(Ht.$$.fragment,e),h(Wt.$$.fragment,e),h(Bt.$$.fragment,e),h(zt.$$.fragment,e),h(Et.$$.fragment,e),h(Qt.$$.fragment,e),h(Vt.$$.fragment,e),h(Yt.$$.fragment,e),h(Kt.$$.fragment,e),h(nn.$$.fragment,e),h(pn.$$.fragment,e),h(cn.$$.fragment,e),h(U.$$.fragment,e),h(vn.$$.fragment,e),h(Cn.$$.fragment,e),h(Hn.$$.fragment,e),h(Wn.$$.fragment,e),h(En.$$.fragment,e),h(Yn.$$.fragment,e),h(qn.$$.fragment,e),h(ll.$$.fragment,e),h(rl.$$.fragment,e),h(hl.$$.fragment,e),h(yl.$$.fragment,e),h(Tl.$$.fragment,e),ga=!0)},o(e){u(I.$$.fragment,e),u(W.$$.fragment,e),u(E.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(Ae.$$.fragment,e),u(Ve.$$.fragment,e),u(Xe.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ut.$$.fragment,e),u(ct.$$.fragment,e),u(Jt.$$.fragment,e),u(kt.$$.fragment,e),u(_t.$$.fragment,e),u(Ht.$$.fragment,e),u(Wt.$$.fragment,e),u(Bt.$$.fragment,e),u(zt.$$.fragment,e),u(Et.$$.fragment,e),u(Qt.$$.fragment,e),u(Vt.$$.fragment,e),u(Yt.$$.fragment,e),u(Kt.$$.fragment,e),u(nn.$$.fragment,e),u(pn.$$.fragment,e),u(cn.$$.fragment,e),u(U.$$.fragment,e),u(vn.$$.fragment,e),u(Cn.$$.fragment,e),u(Hn.$$.fragment,e),u(Wn.$$.fragment,e),u(En.$$.fragment,e),u(Yn.$$.fragment,e),u(qn.$$.fragment,e),u(ll.$$.fragment,e),u(rl.$$.fragment,e),u(hl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),ga=!1},d(e){e&&(n(_),n(j),n(bl),n(Bl),n(x),n(Pl),n($),n(zl),n(L),n(Rl),n(A),n(El),n(H),n(Gl),n(Z),n(Ql),n(Dl),n(N),n(Vl),n(B),n(Fl),n(P),n(Yl),n(z),n(Sl),n(R),n(Xl),n(ql),n(G),n(Ol),n(Q),n(Kl),n(vl),n(eo),n(D),n(to),n(no),n(F),n(lo),n(oo),n(S),n(io),n(X),n(so),n(ao),n(O),n(ro),n(mo),n(ee),n(po),n(te),n(ho),n(ne),n(uo),n(le),n(fo),n(oe),n(co),n(ie),n(yo),n(se),n(wo),n(ae),n(Mo),n(go),n(de),n(To),n(me),n(bo),n(pe),n(vo),n(Jo),n(b),n(Co),n(Te),n(jo),n(ko),n(ve),n(Uo),n(Je),n(_o),n(Ce),n(Io),n(je),n(xo),n(ke),n($o),n(Ue),n(Lo),n(_e),n(Ao),n(Ie),n(Ho),n(xe),n(Zo),n($e),n(Wo),n(Le),n(No),n(Bo),n(He),n(Po),n(Ze),n(zo),n(We),n(Ro),n(Ne),n(Eo),n(Be),n(Go),n(Pe),n(Qo),n(ze),n(Do),n(Re),n(Vo),n(Ee),n(Fo),n(Ge),n(Yo),n(Qe),n(So),n(De),n(Xo),n(qo),n(Fe),n(Oo),n(Ye),n(Ko),n(Se),n(ei),n(ti),n(qe),n(ni),n(li),n(Ke),n(oi),n(et),n(ii),n(si),n(nt),n(ai),n(lt),n(ri),n(ot),n(di),n(it),n(mi),n(M),n(pi),n(ft),n(hi),n(ui),n(yt),n(fi),n(wt),n(ci),n(Mt),n(yi),n(gt),n(wi),n(Tt),n(Mi),n(bt),n(gi),n(vt),n(Ti),n(bi),n(Ct),n(vi),n(jt),n(Ji),n(Ci),n(Ut),n(ji),n(ki),n(It),n(Ui),n(xt),n(_i),n($t),n(Ii),n(Lt),n(xi),n(At),n($i),n(Li),n(Zt),n(Ai),n(Hi),n(Nt),n(Zi),n(Wi),n(Pt),n(Ni),n(Bi),n(Rt),n(Pi),n(zi),n(Gt),n(Ri),n(Ei),n(Dt),n(Gi),n(Qi),n(Ft),n(Di),n(Vi),n(St),n(Fi),n(Xt),n(Yi),n(qt),n(Si),n(Ot),n(Xi),n(qi),n(en),n(Oi),n(tn),n(Ki),n(es),n(ln),n(ts),n(on),n(ns),n(sn),n(ls),n(an),n(os),n(rn),n(is),n(dn),n(ss),n(mn),n(as),n(rs),n(hn),n(ds),n(un),n(ms),n(fn),n(ps),n(hs),n(us),n(yn),n(fs),n(wn),n(cs),n(Mn),n(ys),n(gn),n(ws),n(Tn),n(Ms),n(bn),n(gs),n(Ts),n(Jn),n(bs),n(vs),n(jn),n(Js),n(kn),n(Cs),n(Un),n(js),n(_n),n(ks),n(In),n(Us),n(xn),n(_s),n($n),n(Is),n(Ln),n(xs),n(An),n($s),n(Ls),n(Zn),n(As),n(Hs),n(Nn),n(Zs),n(Bn),n(Ws),n(Pn),n(Ns),n(zn),n(Bs),n(Rn),n(Ps),n(zs),n(Gn),n(Rs),n(Qn),n(Es),n(Dn),n(Gs),n(Vn),n(Qs),n(Fn),n(Ds),n(Vs),n(Sn),n(Fs),n(Xn),n(Ys),n(Ss),n(On),n(Xs),n(Kn),n(qs),n(el),n(Os),n(tl),n(Ks),n(nl),n(ea),n(ta),n(ol),n(na),n(il),n(la),n(sl),n(oa),n(al),n(ia),n(sa),n(dl),n(aa),n(ml),n(ra),n(pl),n(da),n(ma),n(ul),n(pa),n(fl),n(ha),n(cl),n(ua),n(fa),n(wl),n(ca),n(Ml),n(ya),n(gl),n(wa),n(Ma),n(Wl)),n(w),f(I,e),f(W,e),f(E,e),f(V,e),f(Y,e),f(q,e),f(K,e),f(re,e),f(he,e),f(fe),f(ce),f(ye),f(we),f(ge),f(be,e),f(Ae,e),f(Ve,e),f(Xe,e),f(Oe,e),f(tt,e),f(at),f(dt),f(pt),f(ut),f(ct,e),f(Jt,e),f(kt,e),f(_t,e),f(Ht,e),f(Wt,e),f(Bt,e),f(zt,e),f(Et,e),f(Qt,e),f(Vt,e),f(Yt,e),f(Kt,e),f(nn,e),f(pn,e),f(cn,e),f(U,e),f(vn,e),f(Cn,e),f(Hn,e),f(Wn,e),f(En,e),f(Yn,e),f(qn,e),f(ll,e),f(rl,e),f(hl,e),f(yl,e),f(Tl,e)}}}const ip='{"title":"How to add a model to 🤗 Transformers?","local":"how-to-add-a-model-to--transformers","sections":[{"title":"General overview of 🤗 Transformers","local":"general-overview-of--transformers","sections":[{"title":"Overview of models","local":"overview-of-models","sections":[],"depth":3},{"title":"Code style","local":"code-style","sections":[],"depth":3},{"title":"Overview of tokenizers","local":"overview-of-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Step-by-step recipe to add a model to 🤗 Transformers","local":"step-by-step-recipe-to-add-a-model-to--transformers","sections":[{"title":"1. (Optional) Theoretical aspects of BrandNewBert","local":"1-optional-theoretical-aspects-of-brandnewbert","sections":[],"depth":3},{"title":"2. Next prepare your environment","local":"2-next-prepare-your-environment","sections":[],"depth":3},{"title":"3.-4. Run a pretrained checkpoint using the original repository","local":"3-4-run-a-pretrained-checkpoint-using-the-original-repository","sections":[],"depth":3},{"title":"5.-14. Port BrandNewBert to 🤗 Transformers","local":"5-14-port-brandnewbert-to--transformers","sections":[],"depth":3},{"title":"Share your work!!","local":"share-your-work","sections":[],"depth":3}],"depth":2},{"title":"Model additions and their timeline: when is a model added to transformers?","local":"model-additions-and-their-timeline-when-is-a-model-added-to-transformers","sections":[{"title":"Day-0 integration","local":"day-0-integration","sections":[],"depth":3},{"title":"Same-week integration","local":"same-week-integration","sections":[],"depth":3},{"title":"Post-release integration","local":"post-release-integration","sections":[],"depth":3},{"title":"Code-on-Hub release","local":"code-on-hub-release","sections":[],"depth":3}],"depth":2}],"depth":1}';function sp(Nl){return Xm(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hp extends Om{constructor(w){super(),Km(this,w,sp,op,Ym,{})}}export{hp as component};
