import{s as Pt,n as Ot,o as te}from"../chunks/scheduler.25b97de1.js";import{S as ee,i as le,g as n,s as a,r as i,A as se,h as o,f as l,c as M,j as Kt,u as d,x as r,k as Dt,y as ae,a as s,v as y,d as m,t as p,w as J}from"../chunks/index.d9030fc9.js";import{C as H}from"../chunks/CodeBlock.e6cd0d95.js";import{H as $,E as Me}from"../chunks/EditOnGithub.91d95064.js";function ne(_t){let T,D,L,P,w,O,U,Wt='The <a href="https://github.com/neuralmagic/compressed-tensors" rel="nofollow"><code>compressed-tensors</code></a> library provides a versatile and efficient way to store and manage compressed model checkpoints. This library supports various quantization and sparsity schemes, making it a unified format for handling different model optimizations like GPTQ, AWQ, SmoothQuant, INT8, FP8, SparseGPT, and more.',tt,c,Ft="Some of the supported formats include:",et,u,Nt='<li><code>dense</code></li> <li><code>int-quantized</code>: INT8 quantized models<ul><li>sample <a href="https://huggingface.co/nm-testing/tinyllama-w8a8-compressed-hf-quantizer" rel="nofollow">model/config</a></li></ul></li> <li><code>float-quantized</code>: FP8 quantized models; currently support E4M3<ul><li>sample <a href="https://huggingface.co/nm-testing/Meta-Llama-3-8B-Instruct-fp8-hf_compat/tree/main" rel="nofollow">model/config</a></li></ul></li> <li><code>pack-quantized</code>: INT4 or INT8 weight-quantized models, packed into INT32. For INT4, the weights have an INT4 range but are stored as INT8 and   then packed into INT32.<ul><li>sample <a href="nm-testing/tinyllama-w4a16-compressed-hf-quantizer">model/config</a></li></ul></li>',lt,j,Xt=`Compressed models can be easily created using <a href="https://github.com/vllm-project/llm-compressor" rel="nofollow">llm-compressor</a>.
Alternatively models can be created indepedenty and serialized with a compressed tensors config.`,st,h,Et='To find existing models on the Hugging Face Model Hub, search for the <a href="https://huggingface.co/models?other=compressed-tensors" rel="nofollow"><code>compressed-tensors</code> tag</a>.',at,I,Mt,C,Gt='<li>Weight and activation precisions: FP8, INT4, INT8 (for Q/DQ arbitrary precision is allowed for INT)</li> <li>Quantization scales and zero-points strategies: <a href="https://github.com/neuralmagic/compressed-tensors/blob/83b2e7a969d70606421a76b9a3d112646077c8de/src/compressed_tensors/quantization/quant_args.py#L43-L52" rel="nofollow">tensor, channel, group, block, token</a></li> <li>Dynamic per-token activation quantization (or any static strategy)</li> <li>Sparsity can be</li> <li>Supports quantization of arbitrary modules, not just Linear modules</li> <li>Targeted support or ignoring of modules by name or class</li>',nt,b,ot,f,kt='It is recommended to install stable releases of compressed-tensors from <a href="https://pypi.org/project/compressed-tensors" rel="nofollow">PyPI</a>:',rt,A,it,g,Qt="Developers who want to experiment with the latest features can also install the package from source:",dt,B,yt,Z,mt,v,zt='Quantized models can be easily loaded for inference as shown below. Only models that have already been quantized can be loaded at the moment. To quantize a model into the compressed-tensors format see <a href="https://github.com/vllm-project/llm-compressor" rel="nofollow">llm-compressor</a>.',pt,_,Jt,W,Vt="We can see just above that the compressed-tensors FP8 checkpoint of Llama 3.1 8B is able to be loaded for inference using half of the memory of the unquantized reference checkpoint.",Tt,F,wt,N,Ut,X,St=`The above shows a quick example for running generation using a <code>compressed-tensors</code>
model. Currently, once loaded the model cannot be saved.`,ct,E,ut,G,Rt="In this example we will examine how the compressed-tensors model nm-testing/Meta-Llama-3.1-8B-Instruct-FP8-hf is defined through its configuration entry and see how this translates to the loaded model representation.",jt,k,qt='First, let us look at the <a href="https://huggingface.co/nm-testing/Meta-Llama-3.1-8B-Instruct-FP8-hf/blob/main/config.json" rel="nofollow"><code>quantization_config</code> of the model</a>. At a glance it looks overwhelming with the number of entries but this is because compressed-tensors is a format that allows for flexible expression both during and after model compression.',ht,Q,Yt="In practice for checkpoint loading and inference the configuration can be simplified to not include all the default or empty entries, so we will do that here to focus on what compression is actually represented.",It,z,Ct,V,xt="We can see from the above configuration that it is specifying one config group that includes weight and activation quantization to FP8 with a static per-tensor strategy. It is also worth noting that in the <code>ignore</code> list there is an entry to skip quantization of the <code>lm_head</code> module, so that module should be untouched in the checkpoint.",bt,S,Ht='To see the result of the configuration in practice, we can simply use the <a href="https://huggingface.co/nm-testing/Meta-Llama-3.1-8B-Instruct-FP8-hf?show_file_info=model.safetensors.index.json" rel="nofollow">safetensors viewer</a> on the model card to see the quantized weights, input_scale, and weight_scale for all of the Linear modules in the first model layer (and so on for the rest of the layers).',ft,R,$t="<thead><tr><th>Tensors</th> <th>Shape</th> <th>Precision</th></tr></thead> <tbody><tr><td>model.layers.0.input_layernorm.weight</td> <td>[4 096]</td> <td>BF16</td></tr> <tr><td>model.layers.0.mlp.down_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.mlp.down_proj.weight</td> <td>[4 096, 14 336]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.mlp.down_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.mlp.gate_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.mlp.gate_proj.weight</td> <td>[14 336, 4 096]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.mlp.gate_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.mlp.up_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.mlp.up_proj.weight</td> <td>[14 336, 4 096]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.mlp.up_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.post_attention_layernorm.weight</td> <td>[4 096]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.k_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.k_proj.weight</td> <td>[1 024, 4 096]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.self_attn.k_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.o_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.o_proj.weight</td> <td>[4 096, 4 096]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.self_attn.o_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.q_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.q_proj.weight</td> <td>[4 096, 4 096]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.self_attn.q_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.v_proj.input_scale</td> <td>[1]</td> <td>BF16</td></tr> <tr><td>model.layers.0.self_attn.v_proj.weight</td> <td>[1 024, 4 096]</td> <td>F8_E4M3</td></tr> <tr><td>model.layers.0.self_attn.v_proj.weight_scale</td> <td>[1]</td> <td>BF16</td></tr></tbody>",At,q,Lt="When we load the model with the compressed-tensors HFQuantizer integration, we can see that all of the Linear modules that are specified within the quantization configuration have been replaced by <code>CompressedLinear</code> modules that manage the compressed weights and forward pass for inference. Note that the <code>lm_head</code> mentioned before in the ignore list is still kept as an unquantized Linear module.",gt,Y,Bt,x,Zt,K,vt;return w=new $({props:{title:"Compressed Tensors",local:"compressed-tensors",headingTag:"h1"}}),I=new $({props:{title:"Features:",local:"features",headingTag:"h4"}}),b=new $({props:{title:"Installation",local:"installation",headingTag:"h2"}}),A=new H({props:{code:"cGlwJTIwaW5zdGFsbCUyMGNvbXByZXNzZWQtdGVuc29ycw==",highlighted:"pip install compressed-tensors",wrap:!1}}),B=new H({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZuZXVyYWxtYWdpYyUyRmNvbXByZXNzZWQtdGVuc29ycyUwQWNkJTIwY29tcHJlc3NlZC10ZW5zb3JzJTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/neuralmagic/compressed-tensors
<span class="hljs-built_in">cd</span> compressed-tensors
pip install -e .`,wrap:!1}}),Z=new $({props:{title:"Quickstart Model Load",local:"quickstart-model-load",headingTag:"h2"}}),_=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMG1vZGVsJTIwaW4lMjBjb21wcmVzc2VkLXRlbnNvcnMlMjBmb3JtYXQlMEFjdF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJubS10ZXN0aW5nJTJGTWV0YS1MbGFtYS0zLjEtOEItSW5zdHJ1Y3QtRlA4LWhmJTIyKSUwQSUwQSUyMyUyME1lYXN1cmUlMjBtZW1vcnklMjB1c2FnZSUwQW1lbV9wYXJhbXMlMjAlM0QlMjBzdW0oJTVCcGFyYW0ubmVsZW1lbnQoKSpwYXJhbS5lbGVtZW50X3NpemUoKSUyMGZvciUyMHBhcmFtJTIwaW4lMjBjdF9tb2RlbC5wYXJhbWV0ZXJzKCklNUQpJTBBcHJpbnQoZiUyMiU3Qm1lbSUyRjIqKjMwJTNBLjRmJTdEJTIwR0IlMjIpJTBBJTIzJTIwOC40NTc1JTIwR0I=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Load the model in compressed-tensors format</span>
ct_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;nm-testing/Meta-Llama-3.1-8B-Instruct-FP8-hf&quot;</span>)

<span class="hljs-comment"># Measure memory usage</span>
mem_params = <span class="hljs-built_in">sum</span>([param.nelement()*param.element_size() <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> ct_model.parameters()])
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{mem/<span class="hljs-number">2</span>**<span class="hljs-number">30</span>:<span class="hljs-number">.4</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># 8.4575 GB</span>`,wrap:!1}}),F=new $({props:{title:"Sample Use Cases - Load and run an FP8 model",local:"sample-use-cases---load-and-run-an-fp8-model",headingTag:"h2"}}),N=new H({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

prompt = [
    <span class="hljs-string">&quot;Hello, my name is&quot;</span>,
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    <span class="hljs-string">&quot;The future of AI is&quot;</span>
]

model_name = <span class="hljs-string">&quot;nm-testing/Meta-Llama-3-8B-Instruct-fp8-hf_compat&quot;</span>

quantized_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(model_name)

inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generated_ids = quantized_model.generate(**inputs, max_length=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">False</span>)
outputs = tokenizer.batch_decode(generated_ids)

<span class="hljs-built_in">print</span>(outputs)

<span class="hljs-string">&quot;&quot;&quot;
[&#x27;&lt;|begin_of_text|&gt;Hello, my name is [Name]. I am a [Your Profession/Student] and I am here to learn about the [Course/Program] at [University/Institution]. I am excited to be here and I am looking forward to&#x27;, &#x27;&lt;|begin_of_text|&gt;The capital of France is Paris, which is located in the north-central part of the country. Paris is the most populous city in France and is known for its stunning architecture, art museums, fashion, and romantic atmosphere. The city is home to&#x27;, &quot;&lt;|begin_of_text|&gt;The future of AI is here, and it&#x27;s already changing the way we live and work. From virtual assistants to self-driving cars, AI is transforming industries and revolutionizing the way we interact with technology. But what does the future of AI hold&quot;]
&quot;&quot;&quot;</span>
`,wrap:!1}}),E=new $({props:{title:"Deep dive into a compressed-tensors model checkpoint",local:"deep-dive-into-a-compressed-tensors-model-checkpoint",headingTag:"h2"}}),z=new H({props:{code:"JTIycXVhbnRpemF0aW9uX2NvbmZpZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMmNvbmZpZ19ncm91cHMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJncm91cF8wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRfYWN0aXZhdGlvbnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1fYml0cyUyMiUzQSUyMDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHJhdGVneSUyMiUzQSUyMCUyMnRlbnNvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJmbG9hdCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnRhcmdldHMlMjIlM0ElMjAlNUIlMjJMaW5lYXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWlnaHRzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtX2JpdHMlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RyYXRlZ3klMjIlM0ElMjAlMjJ0ZW5zb3IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZmxvYXQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJmb3JtYXQlMjIlM0ElMjAlMjJuYWl2ZS1xdWFudGl6ZWQlMjIlMkMlMEElMjAlMjAlMjJpZ25vcmUlMjIlM0ElMjAlNUIlMjJsbV9oZWFkJTIyJTVEJTJDJTBBJTIwJTIwJTIycXVhbnRfbWV0aG9kJTIyJTNBJTIwJTIyY29tcHJlc3NlZC10ZW5zb3JzJTIyJTJDJTBBJTIwJTIwJTIycXVhbnRpemF0aW9uX3N0YXR1cyUyMiUzQSUyMCUyMmZyb3plbiUyMiUwQSU3RCUyQw==",highlighted:`<span class="hljs-attr">&quot;quantization_config&quot;:</span> {
  <span class="hljs-attr">&quot;config_groups&quot;:</span> {
    <span class="hljs-attr">&quot;group_0&quot;:</span> {
      <span class="hljs-attr">&quot;input_activations&quot;:</span> {
        <span class="hljs-attr">&quot;num_bits&quot;:</span> <span class="hljs-number">8</span>,
        <span class="hljs-attr">&quot;strategy&quot;:</span> <span class="hljs-string">&quot;tensor&quot;</span>,
        <span class="hljs-attr">&quot;type&quot;:</span> <span class="hljs-string">&quot;float&quot;</span>
      },
      <span class="hljs-attr">&quot;targets&quot;:</span> [<span class="hljs-string">&quot;Linear&quot;</span>],
      <span class="hljs-attr">&quot;weights&quot;:</span> {
        <span class="hljs-attr">&quot;num_bits&quot;:</span> <span class="hljs-number">8</span>,
        <span class="hljs-attr">&quot;strategy&quot;:</span> <span class="hljs-string">&quot;tensor&quot;</span>,
        <span class="hljs-attr">&quot;type&quot;:</span> <span class="hljs-string">&quot;float&quot;</span>
      }
    }
  },
  <span class="hljs-attr">&quot;format&quot;:</span> <span class="hljs-string">&quot;naive-quantized&quot;</span>,
  <span class="hljs-attr">&quot;ignore&quot;:</span> [<span class="hljs-string">&quot;lm_head&quot;</span>],
  <span class="hljs-attr">&quot;quant_method&quot;:</span> <span class="hljs-string">&quot;compressed-tensors&quot;</span>,
  <span class="hljs-attr">&quot;quantization_status&quot;:</span> <span class="hljs-string">&quot;frozen&quot;</span>
}<span class="hljs-string">,</span>`,wrap:!1}}),Y=new H({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

ct_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;nm-testing/Meta-Llama-3.1-8B-Instruct-FP8-hf&quot;</span>)
<span class="hljs-built_in">print</span>(ct_model)
<span class="hljs-string">&quot;&quot;&quot;
LlamaForCausalLM(
  (model): LlamaModel(
    (embed_tokens): Embedding(128256, 4096)
    (layers): ModuleList(
      (0-31): 32 x LlamaDecoderLayer(
        (self_attn): LlamaSdpaAttention(
          (q_proj): CompressedLinear(
            in_features=4096, out_features=4096, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (k_proj): CompressedLinear(
            in_features=4096, out_features=1024, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (v_proj): CompressedLinear(
            in_features=4096, out_features=1024, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (o_proj): CompressedLinear(
            in_features=4096, out_features=4096, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (rotary_emb): LlamaRotaryEmbedding()
        )
        (mlp): LlamaMLP(
          (gate_proj): CompressedLinear(
            in_features=4096, out_features=14336, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (up_proj): CompressedLinear(
            in_features=4096, out_features=14336, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (down_proj): CompressedLinear(
            in_features=14336, out_features=4096, bias=False
            (input_observer): MovingAverageMinMaxObserver()
            (weight_observer): MovingAverageMinMaxObserver()
          )
          (act_fn): SiLU()
        )
        (input_layernorm): LlamaRMSNorm((4096,), eps=1e-05)
        (post_attention_layernorm): LlamaRMSNorm((4096,), eps=1e-05)
      )
    )
    (norm): LlamaRMSNorm((4096,), eps=1e-05)
    (rotary_emb): LlamaRotaryEmbedding()
  )
  (lm_head): Linear(in_features=4096, out_features=128256, bias=False)
)
&quot;&quot;&quot;</span>`,wrap:!1}}),x=new Me({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/compressed_tensors.md"}}),{c(){T=n("meta"),D=a(),L=n("p"),P=a(),i(w.$$.fragment),O=a(),U=n("p"),U.innerHTML=Wt,tt=a(),c=n("p"),c.textContent=Ft,et=a(),u=n("ol"),u.innerHTML=Nt,lt=a(),j=n("p"),j.innerHTML=Xt,st=a(),h=n("p"),h.innerHTML=Et,at=a(),i(I.$$.fragment),Mt=a(),C=n("ul"),C.innerHTML=Gt,nt=a(),i(b.$$.fragment),ot=a(),f=n("p"),f.innerHTML=kt,rt=a(),i(A.$$.fragment),it=a(),g=n("p"),g.textContent=Qt,dt=a(),i(B.$$.fragment),yt=a(),i(Z.$$.fragment),mt=a(),v=n("p"),v.innerHTML=zt,pt=a(),i(_.$$.fragment),Jt=a(),W=n("p"),W.textContent=Vt,Tt=a(),i(F.$$.fragment),wt=a(),i(N.$$.fragment),Ut=a(),X=n("p"),X.innerHTML=St,ct=a(),i(E.$$.fragment),ut=a(),G=n("p"),G.textContent=Rt,jt=a(),k=n("p"),k.innerHTML=qt,ht=a(),Q=n("p"),Q.textContent=Yt,It=a(),i(z.$$.fragment),Ct=a(),V=n("p"),V.innerHTML=xt,bt=a(),S=n("p"),S.innerHTML=Ht,ft=a(),R=n("table"),R.innerHTML=$t,At=a(),q=n("p"),q.innerHTML=Lt,gt=a(),i(Y.$$.fragment),Bt=a(),i(x.$$.fragment),Zt=a(),K=n("p"),this.h()},l(t){const e=se("svelte-u9bgzb",document.head);T=o(e,"META",{name:!0,content:!0}),e.forEach(l),D=M(t),L=o(t,"P",{}),Kt(L).forEach(l),P=M(t),d(w.$$.fragment,t),O=M(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-qu2azz"&&(U.innerHTML=Wt),tt=M(t),c=o(t,"P",{"data-svelte-h":!0}),r(c)!=="svelte-10asxkm"&&(c.textContent=Ft),et=M(t),u=o(t,"OL",{"data-svelte-h":!0}),r(u)!=="svelte-ldua5w"&&(u.innerHTML=Nt),lt=M(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1j8d0tb"&&(j.innerHTML=Xt),st=M(t),h=o(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1nrd39r"&&(h.innerHTML=Et),at=M(t),d(I.$$.fragment,t),Mt=M(t),C=o(t,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-1kzp1kb"&&(C.innerHTML=Gt),nt=M(t),d(b.$$.fragment,t),ot=M(t),f=o(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-bgk99h"&&(f.innerHTML=kt),rt=M(t),d(A.$$.fragment,t),it=M(t),g=o(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-oaj25y"&&(g.textContent=Qt),dt=M(t),d(B.$$.fragment,t),yt=M(t),d(Z.$$.fragment,t),mt=M(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-mmaog6"&&(v.innerHTML=zt),pt=M(t),d(_.$$.fragment,t),Jt=M(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vselvi"&&(W.textContent=Vt),Tt=M(t),d(F.$$.fragment,t),wt=M(t),d(N.$$.fragment,t),Ut=M(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-14cjyka"&&(X.innerHTML=St),ct=M(t),d(E.$$.fragment,t),ut=M(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-10qolpt"&&(G.textContent=Rt),jt=M(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1yyx6ne"&&(k.innerHTML=qt),ht=M(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1goyyy2"&&(Q.textContent=Yt),It=M(t),d(z.$$.fragment,t),Ct=M(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-7czuzd"&&(V.innerHTML=xt),bt=M(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-6j79nk"&&(S.innerHTML=Ht),ft=M(t),R=o(t,"TABLE",{"data-svelte-h":!0}),r(R)!=="svelte-1ol90rr"&&(R.innerHTML=$t),At=M(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1xwzei5"&&(q.innerHTML=Lt),gt=M(t),d(Y.$$.fragment,t),Bt=M(t),d(x.$$.fragment,t),Zt=M(t),K=o(t,"P",{}),Kt(K).forEach(l),this.h()},h(){Dt(T,"name","hf:doc:metadata"),Dt(T,"content",oe)},m(t,e){ae(document.head,T),s(t,D,e),s(t,L,e),s(t,P,e),y(w,t,e),s(t,O,e),s(t,U,e),s(t,tt,e),s(t,c,e),s(t,et,e),s(t,u,e),s(t,lt,e),s(t,j,e),s(t,st,e),s(t,h,e),s(t,at,e),y(I,t,e),s(t,Mt,e),s(t,C,e),s(t,nt,e),y(b,t,e),s(t,ot,e),s(t,f,e),s(t,rt,e),y(A,t,e),s(t,it,e),s(t,g,e),s(t,dt,e),y(B,t,e),s(t,yt,e),y(Z,t,e),s(t,mt,e),s(t,v,e),s(t,pt,e),y(_,t,e),s(t,Jt,e),s(t,W,e),s(t,Tt,e),y(F,t,e),s(t,wt,e),y(N,t,e),s(t,Ut,e),s(t,X,e),s(t,ct,e),y(E,t,e),s(t,ut,e),s(t,G,e),s(t,jt,e),s(t,k,e),s(t,ht,e),s(t,Q,e),s(t,It,e),y(z,t,e),s(t,Ct,e),s(t,V,e),s(t,bt,e),s(t,S,e),s(t,ft,e),s(t,R,e),s(t,At,e),s(t,q,e),s(t,gt,e),y(Y,t,e),s(t,Bt,e),y(x,t,e),s(t,Zt,e),s(t,K,e),vt=!0},p:Ot,i(t){vt||(m(w.$$.fragment,t),m(I.$$.fragment,t),m(b.$$.fragment,t),m(A.$$.fragment,t),m(B.$$.fragment,t),m(Z.$$.fragment,t),m(_.$$.fragment,t),m(F.$$.fragment,t),m(N.$$.fragment,t),m(E.$$.fragment,t),m(z.$$.fragment,t),m(Y.$$.fragment,t),m(x.$$.fragment,t),vt=!0)},o(t){p(w.$$.fragment,t),p(I.$$.fragment,t),p(b.$$.fragment,t),p(A.$$.fragment,t),p(B.$$.fragment,t),p(Z.$$.fragment,t),p(_.$$.fragment,t),p(F.$$.fragment,t),p(N.$$.fragment,t),p(E.$$.fragment,t),p(z.$$.fragment,t),p(Y.$$.fragment,t),p(x.$$.fragment,t),vt=!1},d(t){t&&(l(D),l(L),l(P),l(O),l(U),l(tt),l(c),l(et),l(u),l(lt),l(j),l(st),l(h),l(at),l(Mt),l(C),l(nt),l(ot),l(f),l(rt),l(it),l(g),l(dt),l(yt),l(mt),l(v),l(pt),l(Jt),l(W),l(Tt),l(wt),l(Ut),l(X),l(ct),l(ut),l(G),l(jt),l(k),l(ht),l(Q),l(It),l(Ct),l(V),l(bt),l(S),l(ft),l(R),l(At),l(q),l(gt),l(Bt),l(Zt),l(K)),l(T),J(w,t),J(I,t),J(b,t),J(A,t),J(B,t),J(Z,t),J(_,t),J(F,t),J(N,t),J(E,t),J(z,t),J(Y,t),J(x,t)}}}const oe='{"title":"Compressed Tensors","local":"compressed-tensors","sections":[{"title":"Features:","local":"features","sections":[],"depth":4},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Quickstart Model Load","local":"quickstart-model-load","sections":[],"depth":2},{"title":"Sample Use Cases - Load and run an FP8 model","local":"sample-use-cases---load-and-run-an-fp8-model","sections":[],"depth":2},{"title":"Deep dive into a compressed-tensors model checkpoint","local":"deep-dive-into-a-compressed-tensors-model-checkpoint","sections":[],"depth":2}],"depth":1}';function re(_t){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pe extends ee{constructor(T){super(),le(this,T,re,ne,Pt,{})}}export{pe as component};
