import{s as L,n as D,o as O}from"../chunks/scheduler.25b97de1.js";import{S as P,i as aa,g as y,s as e,r as T,A as sa,h as b,f as t,c as n,j as H,u as w,x as E,k as $,y as ta,a as l,v as j,d as U,t as f,w as W}from"../chunks/index.d9030fc9.js";import{C as q}from"../chunks/CodeBlock.e6cd0d95.js";import{H as K,E as la}from"../chunks/EditOnGithub.91d95064.js";function ea(N){let o,I,Z,X,i,k,p,Q='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch, it provides high performance dtypes, optimization techniques and kernels for inference and training, featuring composability with native PyTorch features like <code>torch.compile</code>, FSDP etc.. Some benchmark numbers can be found <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">here</a>.',g,m,x="Before you begin, make sure the following libraries are installed with their latest version:",F,r,R,c,B,d,G,M,S='torchao quantization is implemented with <a href="https://pytorch.org/docs/stable/notes/extending.html#subclassing-torch-tensor" rel="nofollow">tensor subclasses</a>, it only work with huggingface non-safetensor serialization and deserialization. It relies on <code>torch.load(..., weights_only=True)</code> to avoid arbitrary user code execution during load time and use <a href="https://pytorch.org/docs/stable/notes/serialization.html#torch.serialization.add_safe_globals" rel="nofollow">add_safe_globals</a> to allowlist some known user functions.',V,u,A="The reason why it does not support safe tensor serialization is that wrapper tensor subclass allows maximum flexibility so we want to make sure the effort of supporting new format of quantized Tensor is low, while safe tensor optimizes for maximum safety (no user code execution), it also means we have to make sure to manually support new quantization format.",z,h,C,J,Y,_,v;return i=new K({props:{title:"TorchAO",local:"torchao",headingTag:"h1"}}),r=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRvcmNoJTIwdG9yY2hhbw==",highlighted:"pip install --upgrade torch torchao",wrap:!1}}),c=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>
<span class="hljs-comment"># We support int4_weight_only, int8_weight_only and int8_dynamic_activation_int8_weight</span>
<span class="hljs-comment"># More examples and documentations for arguments can be found in https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">128</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config)

tokenizer = AutoTokenizer.from_pretrained(model_name)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># compile the quantized model to get speedup</span>
<span class="hljs-keyword">import</span> torchao
torchao.quantization.utils.recommended_inductor_config_setter()
quantized_model = torch.<span class="hljs-built_in">compile</span>(quantized_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)

output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># benchmark the performance</span>
<span class="hljs-keyword">import</span> torch.utils.benchmark <span class="hljs-keyword">as</span> benchmark

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">f, *args, **kwargs</span>):
    <span class="hljs-comment"># Manual warmup</span>
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        f(*args, **kwargs)
        
    t0 = benchmark.Timer(
        stmt=<span class="hljs-string">&quot;f(*args, **kwargs)&quot;</span>,
        <span class="hljs-built_in">globals</span>={<span class="hljs-string">&quot;args&quot;</span>: args, <span class="hljs-string">&quot;kwargs&quot;</span>: kwargs, <span class="hljs-string">&quot;f&quot;</span>: f},
        num_threads=torch.get_num_threads(),
    )
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{(t0.blocked_autorange().mean):<span class="hljs-number">.3</span>f}</span>&quot;</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;int4wo-128 model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16)
bf16_model = torch.<span class="hljs-built_in">compile</span>(bf16_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))
`,wrap:!1}}),d=new K({props:{title:"Serialization and Deserialization",local:"serialization-and-deserialization",headingTag:"h2"}}),h=new q({props:{code:"JTIzJTIwc2F2ZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwbG9jYWxseSUwQW91dHB1dF9kaXIlMjAlM0QlMjAlMjJsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQXF1YW50aXplZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQob3V0cHV0X2RpciUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlKSUwQSUwQSUyMyUyMHB1c2glMjB0byUyMGh1Z2dpbmdmYWNlJTIwaHViJTBBJTIzJTIwc2F2ZV90byUyMCUzRCUyMCUyMiU3QnVzZXJfaWQlN0QlMkZsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQSUyMyUyMHF1YW50aXplZF9tb2RlbC5wdXNoX3RvX2h1YihzYXZlX3RvJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2UpJTBBJTBBJTIzJTIwbG9hZCUyMHF1YW50aXplZCUyMG1vZGVsJTBBY2twdF9pZCUyMCUzRCUyMCUyMmxsYW1hMy04Yi1pbnQ0d28tMTI4JTIyJTIwJTIwJTIzJTIwb3IlMjBodWdnaW5nZmFjZSUyMGh1YiUyMG1vZGVsJTIwaWQlMEFsb2FkZWRfcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHRfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiklMEElMEElMEElMjMlMjBjb25maXJtJTIwdGhlJTIwc3BlZWR1cCUwQWxvYWRlZF9xdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKGxvYWRlZF9xdWFudGl6ZWRfbW9kZWwlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyKSUwQXByaW50KCUyMmxvYWRlZCUyMGludDR3by0xMjglMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihsb2FkZWRfcXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TKSk=",highlighted:`<span class="hljs-comment"># save quantized model locally</span>
output_dir = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>
quantized_model.save_pretrained(output_dir, safe_serialization=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># push to huggingface hub</span>
<span class="hljs-comment"># save_to = &quot;{user_id}/llama3-8b-int4wo-128&quot;</span>
<span class="hljs-comment"># quantized_model.push_to_hub(save_to, safe_serialization=False)</span>

<span class="hljs-comment"># load quantized model</span>
ckpt_id = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>  <span class="hljs-comment"># or huggingface hub model id</span>
loaded_quantized_model = AutoModelForCausalLM.from_pretrained(ckpt_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-comment"># confirm the speedup</span>
loaded_quantized_model = torch.<span class="hljs-built_in">compile</span>(loaded_quantized_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;loaded int4wo-128 model:&quot;</span>, benchmark_fn(loaded_quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))`,wrap:!1}}),J=new la({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){o=y("meta"),I=e(),Z=y("p"),X=e(),T(i.$$.fragment),k=e(),p=y("p"),p.innerHTML=Q,g=e(),m=y("p"),m.textContent=x,F=e(),T(r.$$.fragment),R=e(),T(c.$$.fragment),B=e(),T(d.$$.fragment),G=e(),M=y("p"),M.innerHTML=S,V=e(),u=y("p"),u.textContent=A,z=e(),T(h.$$.fragment),C=e(),T(J.$$.fragment),Y=e(),_=y("p"),this.h()},l(a){const s=sa("svelte-u9bgzb",document.head);o=b(s,"META",{name:!0,content:!0}),s.forEach(t),I=n(a),Z=b(a,"P",{}),H(Z).forEach(t),X=n(a),w(i.$$.fragment,a),k=n(a),p=b(a,"P",{"data-svelte-h":!0}),E(p)!=="svelte-1w5ww4g"&&(p.innerHTML=Q),g=n(a),m=b(a,"P",{"data-svelte-h":!0}),E(m)!=="svelte-1wrsrbm"&&(m.textContent=x),F=n(a),w(r.$$.fragment,a),R=n(a),w(c.$$.fragment,a),B=n(a),w(d.$$.fragment,a),G=n(a),M=b(a,"P",{"data-svelte-h":!0}),E(M)!=="svelte-14dwjgd"&&(M.innerHTML=S),V=n(a),u=b(a,"P",{"data-svelte-h":!0}),E(u)!=="svelte-10wmnl9"&&(u.textContent=A),z=n(a),w(h.$$.fragment,a),C=n(a),w(J.$$.fragment,a),Y=n(a),_=b(a,"P",{}),H(_).forEach(t),this.h()},h(){$(o,"name","hf:doc:metadata"),$(o,"content",na)},m(a,s){ta(document.head,o),l(a,I,s),l(a,Z,s),l(a,X,s),j(i,a,s),l(a,k,s),l(a,p,s),l(a,g,s),l(a,m,s),l(a,F,s),j(r,a,s),l(a,R,s),j(c,a,s),l(a,B,s),j(d,a,s),l(a,G,s),l(a,M,s),l(a,V,s),l(a,u,s),l(a,z,s),j(h,a,s),l(a,C,s),j(J,a,s),l(a,Y,s),l(a,_,s),v=!0},p:D,i(a){v||(U(i.$$.fragment,a),U(r.$$.fragment,a),U(c.$$.fragment,a),U(d.$$.fragment,a),U(h.$$.fragment,a),U(J.$$.fragment,a),v=!0)},o(a){f(i.$$.fragment,a),f(r.$$.fragment,a),f(c.$$.fragment,a),f(d.$$.fragment,a),f(h.$$.fragment,a),f(J.$$.fragment,a),v=!1},d(a){a&&(t(I),t(Z),t(X),t(k),t(p),t(g),t(m),t(F),t(R),t(B),t(G),t(M),t(V),t(u),t(z),t(C),t(Y),t(_)),t(o),W(i,a),W(r,a),W(c,a),W(d,a),W(h,a),W(J,a)}}}const na='{"title":"TorchAO","local":"torchao","sections":[{"title":"Serialization and Deserialization","local":"serialization-and-deserialization","sections":[],"depth":2}],"depth":1}';function oa(N){return O(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ca extends P{constructor(o){super(),aa(this,o,oa,ea,L,{})}}export{ca as component};
