import{s as ca,o as da,n as pa}from"../chunks/scheduler.182ea377.js";import{S as ha,i as ua,g as i,s,p as h,A as ma,h as r,f as l,c as n,j as w,q as u,m as o,k as p,v as c,a,r as m,d as f,t as M,u as y}from"../chunks/index.008d68e4.js";import{T as oa}from"../chunks/Tip.4f096367.js";import{I as Ae}from"../chunks/IconCopyLink.96bbb92b.js";import{C as U}from"../chunks/CodeBlock.5ed6eb7b.js";function fa(Ge){let d,g='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){d=i("p"),d.innerHTML=g},l(b){d=r(b,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1qbiqsn"&&(d.innerHTML=g)},m(b,_){a(b,d,_)},p:pa,d(b){b&&l(d)}}}function Ma(Ge){let d,g='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){d=i("p"),d.innerHTML=g},l(b){d=r(b,"P",{"data-svelte-h":!0}),o(d)!=="svelte-zx7n4c"&&(d.innerHTML=g)},m(b,_){a(b,d,_)},p:pa,d(b){b&&l(d)}}}function ya(Ge){let d,g,b,_,Qe,G,nl,Ne,hl="Latent Consistency Distillation",Oe,N,ul='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> are able to generate high-quality images in just a few steps, representing a big leap forward because many pipelines require at least 25+ steps. LCMs are produced by applying the latent consistency distillation method to any Stable Diffusion model. This method works by applying <em>one-stage guided distillation</em> to the latent space, and incorporating a <em>skipping-step</em> method to consistently skip timesteps to accelerate the distillation process (refer to section 4.1, 4.2, and 4.3 of the paper for more details).',et,V,ml='If you’re training on a GPU with limited vRAM, try enabling <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> to reduce memory-usage and speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> and <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes’</a> 8-bit optimizer.',tt,H,fl='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">train_lcm_distill_sd_wds.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',lt,L,Ml="Before running the script, make sure you install the library from source:",at,Y,st,E,yl="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",nt,B,it,$,rt,Q,bl="Initialize an 🤗 Accelerate environment (try enabling <code>torch.compile</code> to significantly speedup training):",ot,S,pt,F,wl="To setup a default 🤗 Accelerate environment without choosing any configurations:",ct,z,dt,q,Ul="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",ht,D,ut,P,_l='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',mt,J,x,Se,K,il,Ve,gl="Script parameters",ft,R,Mt,O,Jl='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L419" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',yt,ee,Tl="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",bt,te,wt,le,Cl='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so you’ll focus on the parameters that are relevant to latent consistency distillation in this guide.',Ut,ae,jl='<li><code>--pretrained_teacher_model</code>: the path to a pretrained latent diffusion model to use as the teacher model</li> <li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify an alternative VAE (like this <a href="(https://huggingface.co/madebyollin/sdxl-vae-fp16-fix)">VAE</a> by madebyollin which works in fp16)</li> <li><code>--w_min</code> and <code>--w_max</code>: the minimum and maximum guidance scale values for guidance scale sampling</li> <li><code>--num_ddim_timesteps</code>: the number of timesteps for DDIM sampling</li> <li><code>--loss_type</code>: the type of loss (L2 or Huber) to calculate for latent consistency distillation; Huber loss is generally preferred because it’s more robust to outliers</li> <li><code>--huber_c</code>: the Huber loss parameter</li>',_t,T,X,Fe,se,rl,He,vl="Training script",gt,ne,Zl='The training script starts by creating a dataset class - <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L141" rel="nofollow"><code>Text2ImageDataset</code></a> - for preprocessing the images and creating a training dataset.',Jt,ie,Tt,re,$l='For improved performance on reading and writing large datasets stored in the cloud, this script uses the <a href="https://github.com/webdataset/webdataset" rel="nofollow">WebDataset</a> format to create a preprocessing pipeline to apply transforms and create a dataset and dataloader for training. Images are processed and fed to the training loop without having to download the full dataset first.',Ct,oe,jt,pe,xl='In the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L768" rel="nofollow"><code>main()</code></a> function, all the necessary components like the noise scheduler, tokenizers, text encoders, and VAE are loaded. The teacher UNet is also loaded here and then you can create a student UNet from the teacher UNet. The student UNet is updated by the optimizer during training.',vt,ce,Zt,de,Rl='Now you can create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L979" rel="nofollow">optimizer</a> to update the UNet parameters:',$t,he,xt,ue,Xl='Create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L994" rel="nofollow">dataset</a>:',Rt,me,Xt,fe,kl='Next, you’re ready to setup the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1049" rel="nofollow">training loop</a> and implement the latent consistency distillation method (see Algorithm 1 in the paper for more details). This section of the script takes care of adding noise to the latents, sampling and creating a guidance scale embedding, and predicting the original image from the noise.',kt,Me,It,ye,Il='It gets the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1172" rel="nofollow">teacher model predictions</a> and the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1209" rel="nofollow">LCM predictions</a> next, calculates the loss, and then backpropagates it to the LCM.',Wt,be,At,we,Wl='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers tutorial</a> which breaks down the basic pattern of the denoising process.',Gt,C,k,ze,Ue,ol,Le,Al="Launch the script",Nt,_e,Gl="Now you’re ready to launch the training script and start distilling!",Vt,ge,Nl='For this guide, you’ll use the <code>--train_shards_path_or_url</code> to specify the path to the <a href="https://github.com/google-research-datasets/conceptual-12m" rel="nofollow">Conceptual Captions 12M</a> dataset stored on the Hub <a href="https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset" rel="nofollow">here</a>. Set the <code>MODEL_DIR</code> environment variable to the name of the teacher model and <code>OUTPUT_DIR</code> to where you want to save the model.',Ht,Je,Lt,Te,Vl="Once training is complete, you can use your new LCM for inference.",Yt,Ce,Et,j,I,qe,je,pl,Ye,Hl="LoRA",Bt,ve,Ll='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sd_wds.py" rel="nofollow">train_lcm_distill_lora_sd_wds.py</a> or <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sdxl_wds.py" rel="nofollow">train_lcm_distill_lora_sdxl.wds.py</a> script to train with LoRA.',Qt,Ze,Yl='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',St,v,W,De,$e,cl,Ee,El="Stable Diffusion XL",Ft,xe,Bl='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sdxl_wds.py" rel="nofollow">train_lcm_distill_sdxl_wds.py</a> script to train a SDXL model with LoRA.',zt,Re,Ql='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',qt,Z,A,Pe,Xe,dl,Be,Sl="Next steps",Dt,ke,Fl="Congratulations on distilling a LCM model! To learn more about LCM, the following may be helpful:",Pt,Ie,zl='<li>Learn how to use <a href="../using-diffusers/lcm">LCMs for inference</a> for text-to-image, image-to-image, and with LoRA checkpoints.</li> <li>Read the <a href="https://huggingface.co/blog/lcm_lora" rel="nofollow">SDXL in 4 steps with Latent Consistency LoRAs</a> blog post to learn more about SDXL LCM-LoRA’s for super fast inference, quality comparisons, benchmarks, and more.</li>',Kt;return G=new Ae({}),Y=new U({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`}}),B=new U({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnNpc3RlbmN5X2Rpc3RpbGxhdGlvbiUwQXBpcCUyMGluc3RhbGwlMjAtciUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/consistency_distillation
pip install -r requirements.txt`}}),$=new oa({props:{$$slots:{default:[fa]},$$scope:{ctx:Ge}}}),S=new U({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),z=new U({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default"}}),D=new U({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`}}),K=new Ae({}),R=new oa({props:{$$slots:{default:[Ma]},$$scope:{ctx:Ge}}}),te=new U({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2xjbV9kaXN0aWxsX3NkX3dkcy5weSUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMg==",highlighted:`accelerate launch train_lcm_distill_sd_wds.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`}}),se=new Ae({}),ie=new U({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnJlc2l6ZShpbWFnZSUyQyUyMHJlc29sdXRpb24lMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUxJTkVBUiklMEElMEElMjAlMjAlMjAlMjBjX3RvcCUyQyUyMGNfbGVmdCUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwdHJhbnNmb3Jtcy5SYW5kb21Dcm9wLmdldF9wYXJhbXMoaW1hZ2UlMkMlMjBvdXRwdXRfc2l6ZSUzRChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBURi5jcm9wKGltYWdlJTJDJTIwY190b3AlMkMlMjBjX2xlZnQlMkMlMjByZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnRvX3RlbnNvcihpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLm5vcm1hbGl6ZShpbWFnZSUyQyUyMCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">example</span>):
    image = example[<span class="hljs-string">&quot;image&quot;</span>]
    image = TF.resize(image, resolution, interpolation=transforms.InterpolationMode.BILINEAR)

    c_top, c_left, _, _ = transforms.RandomCrop.get_params(image, output_size=(resolution, resolution))
    image = TF.crop(image, c_top, c_left, resolution, resolution)
    image = TF.to_tensor(image)
    image = TF.normalize(image, [<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>])

    example[<span class="hljs-string">&quot;image&quot;</span>] = image
    <span class="hljs-keyword">return</span> example`}}),oe=new U({props:{code:"cHJvY2Vzc2luZ19waXBlbGluZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHdkcy5kZWNvZGUoJTIycGlsJTIyJTJDJTIwaGFuZGxlciUzRHdkcy5pZ25vcmVfYW5kX2NvbnRpbnVlKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5yZW5hbWUoaW1hZ2UlM0QlMjJqcGclM0JwbmclM0JqcGVnJTNCd2VicCUyMiUyQyUyMHRleHQlM0QlMjJ0ZXh0JTNCdHh0JTNCY2FwdGlvbiUyMiUyQyUyMGhhbmRsZXIlM0R3ZHMud2Fybl9hbmRfY29udGludWUpJTJDJTBBJTIwJTIwJTIwJTIwd2RzLm1hcChmaWx0ZXJfa2V5cyglN0IlMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIlN0QpKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5tYXAodHJhbnNmb3JtKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy50b190dXBsZSglMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIpJTJDJTBBJTVE",highlighted:`processing_pipeline = [
    wds.decode(<span class="hljs-string">&quot;pil&quot;</span>, handler=wds.ignore_and_continue),
    wds.rename(image=<span class="hljs-string">&quot;jpg;png;jpeg;webp&quot;</span>, text=<span class="hljs-string">&quot;text;txt;caption&quot;</span>, handler=wds.warn_and_continue),
    wds.<span class="hljs-built_in">map</span>(filter_keys({<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>})),
    wds.<span class="hljs-built_in">map</span>(transform),
    wds.to_tuple(<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>),
]`}}),ce=new U({props:{code:"dGVhY2hlcl91bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF90ZWFjaGVyX21vZGVsJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy50ZWFjaGVyX3JldmlzaW9uJTBBKSUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCgqKnRlYWNoZXJfdW5ldC5jb25maWcpJTBBdW5ldC5sb2FkX3N0YXRlX2RpY3QodGVhY2hlcl91bmV0LnN0YXRlX2RpY3QoKSUyQyUyMHN0cmljdCUzREZhbHNlKSUwQXVuZXQudHJhaW4oKQ==",highlighted:`teacher_unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_teacher_model, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.teacher_revision
)

unet = UNet2DConditionModel(**teacher_unet.config)
unet.load_state_dict(teacher_unet.state_dict(), strict=<span class="hljs-literal">False</span>)
unet.train()`}}),he=new U({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMHVuZXQucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`optimizer = optimizer_class(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`}}),me=new U({props:{code:"ZGF0YXNldCUyMCUzRCUyMFRleHQySW1hZ2VEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRGFyZ3MudHJhaW5fc2hhcmRzX3BhdGhfb3JfdXJsJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2V4YW1wbGVzJTNEYXJncy5tYXhfdHJhaW5fc2FtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9ncHVfYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbF9iYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTIwKiUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUyQyUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0RhcmdzLnJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlX2J1ZmZlcl9zaXplJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMHBpbl9tZW1vcnklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyc2lzdGVudF93b3JrZXJzJTNEVHJ1ZSUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwZGF0YXNldC50cmFpbl9kYXRhbG9hZGVy",highlighted:`dataset = Text2ImageDataset(
    train_shards_path_or_url=args.train_shards_path_or_url,
    num_train_examples=args.max_train_samples,
    per_gpu_batch_size=args.train_batch_size,
    global_batch_size=args.train_batch_size * accelerator.num_processes,
    num_workers=args.dataloader_num_workers,
    resolution=args.resolution,
    shuffle_buffer_size=<span class="hljs-number">1000</span>,
    pin_memory=<span class="hljs-literal">True</span>,
    persistent_workers=<span class="hljs-literal">True</span>,
)
train_dataloader = dataset.train_dataloader`}}),Me=new U({props:{code:"cHJlZF94XzAlMjAlM0QlMjBwcmVkaWN0ZWRfb3JpZ2luKCUwQSUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMkMlMEElMjAlMjAlMjAlMjBzdGFydF90aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBub2lzeV9tb2RlbF9pbnB1dCUyQyUwQSUyMCUyMCUyMCUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcucHJlZGljdGlvbl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYWxwaGFfc2NoZWR1bGUlMkMlMEElMjAlMjAlMjAlMjBzaWdtYV9zY2hlZHVsZSUyQyUwQSklMEElMEFtb2RlbF9wcmVkJTIwJTNEJTIwY19za2lwX3N0YXJ0JTIwKiUyMG5vaXN5X21vZGVsX2lucHV0JTIwJTJCJTIwY19vdXRfc3RhcnQlMjAqJTIwcHJlZF94XzA=",highlighted:`pred_x_0 = predicted_origin(
    noise_pred,
    start_timesteps,
    noisy_model_input,
    noise_scheduler.config.prediction_type,
    alpha_schedule,
    sigma_schedule,
)

model_pred = c_skip_start * noisy_model_input + c_out_start * pred_x_0`}}),be=new U({props:{code:"aWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmwyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMEYubXNlX2xvc3MobW9kZWxfcHJlZC5mbG9hdCgpJTJDJTIwdGFyZ2V0LmZsb2F0KCklMkMlMjByZWR1Y3Rpb24lM0QlMjJtZWFuJTIyKSUwQWVsaWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmh1YmVyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm1lYW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc3FydCgobW9kZWxfcHJlZC5mbG9hdCgpJTIwLSUyMHRhcmdldC5mbG9hdCgpKSUyMCoqJTIwMiUyMCUyQiUyMGFyZ3MuaHViZXJfYyoqMiklMjAtJTIwYXJncy5odWJlcl9jJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.loss_type == <span class="hljs-string">&quot;l2&quot;</span>:
    loss = F.mse_loss(model_pred.<span class="hljs-built_in">float</span>(), target.<span class="hljs-built_in">float</span>(), reduction=<span class="hljs-string">&quot;mean&quot;</span>)
<span class="hljs-keyword">elif</span> args.loss_type == <span class="hljs-string">&quot;huber&quot;</span>:
    loss = torch.mean(
        torch.sqrt((model_pred.<span class="hljs-built_in">float</span>() - target.<span class="hljs-built_in">float</span>()) ** <span class="hljs-number">2</span> + args.huber_c**<span class="hljs-number">2</span>) - args.huber_c
    )`}}),Ue=new Ae({}),Je=new U({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyRnRvJTJGc2F2ZWQlMkZtb2RlbCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0cmFpbl9sY21fZGlzdGlsbF9zZF93ZHMucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfdGVhY2hlcl9tb2RlbCUzRCUyNE1PREVMX0RJUiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRGZwMTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS02JTIwLS1sb3NzX3R5cGUlM0QlMjJodWJlciUyMiUyMC0tZW1hX2RlY2F5JTNEMC45NSUyMC0tYWRhbV93ZWlnaHRfZGVjYXklM0QwLjAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDEwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zYW1wbGVzJTNENDAwMDAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YWxvYWRlcl9udW1fd29ya2VycyUzRDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRCUyMnBpcGUlM0FjdXJsJTIwLUwlMjAtcyUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmxhaW9uJTJGY29uY2VwdHVhbC1jYXB0aW9ucy0xMm0td2ViZGF0YXNldCUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRiU3QjAwMDAwLi4wMTA5OSU3RC50YXIlM0Zkb3dubG9hZCUzRHRydWUlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXZhbGlkYXRpb25fc3RlcHMlM0QyMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNoZWNrcG9pbnRpbmdfc3RlcHMlM0QyMDAlMjAtLWNoZWNrcG9pbnRzX3RvdGFsX2xpbWl0JTNEMTAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11c2VfOGJpdF9hZGFtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXN1bWVfZnJvbV9jaGVja3BvaW50JTNEbGF0ZXN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBvcnRfdG8lM0R3YW5kYiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQ1MzY0NTYzNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/saved/model&quot;</span>

accelerate launch train_lcm_distill_sd_wds.py \\
    --pretrained_teacher_model=<span class="hljs-variable">$MODEL_DIR</span> \\
    --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
    --mixed_precision=fp16 \\
    --resolution=512 \\
    --learning_rate=1e-6 --loss_type=<span class="hljs-string">&quot;huber&quot;</span> --ema_decay=0.95 --adam_weight_decay=0.0 \\
    --max_train_steps=1000 \\
    --max_train_samples=4000000 \\
    --dataloader_num_workers=8 \\
    --train_shards_path_or_url=<span class="hljs-string">&quot;pipe:curl -L -s https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset/resolve/main/data/{00000..01099}.tar?download=true&quot;</span> \\
    --validation_steps=200 \\
    --checkpointing_steps=200 --checkpoints_total_limit=10 \\
    --train_batch_size=12 \\
    --gradient_checkpointing --enable_xformers_memory_efficient_attention \\
    --gradient_accumulation_steps=1 \\
    --use_8bit_adam \\
    --resume_from_checkpoint=latest \\
    --report_to=wandb \\
    --seed=453645634 \\
    --push_to_hub`}}),Ce=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci11c2VybmFtZSUyRnlvdXItbW9kZWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVuZXQlM0R1bmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnN1c2hpJTIwcm9sbHMlMjBpbiUyMHRoZSUyMGZvcm0lMjBvZiUyMHBhbmRhJTIwaGVhZHMlMkMlMjBzdXNoaSUyMHBsYXR0ZXIlMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel, DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;your-username/your-model&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;sushi rolls in the form of panda heads, sushi platter&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`}}),je=new Ae({}),$e=new Ae({}),Xe=new Ae({}),{c(){d=i("meta"),g=s(),b=i("h1"),_=i("a"),Qe=i("span"),h(G.$$.fragment),nl=s(),Ne=i("span"),Ne.textContent=hl,Oe=s(),N=i("p"),N.innerHTML=ul,et=s(),V=i("p"),V.innerHTML=ml,tt=s(),H=i("p"),H.innerHTML=fl,lt=s(),L=i("p"),L.textContent=Ml,at=s(),h(Y.$$.fragment),st=s(),E=i("p"),E.textContent=yl,nt=s(),h(B.$$.fragment),it=s(),h($.$$.fragment),rt=s(),Q=i("p"),Q.innerHTML=bl,ot=s(),h(S.$$.fragment),pt=s(),F=i("p"),F.textContent=wl,ct=s(),h(z.$$.fragment),dt=s(),q=i("p"),q.textContent=Ul,ht=s(),h(D.$$.fragment),ut=s(),P=i("p"),P.innerHTML=_l,mt=s(),J=i("h2"),x=i("a"),Se=i("span"),h(K.$$.fragment),il=s(),Ve=i("span"),Ve.textContent=gl,ft=s(),h(R.$$.fragment),Mt=s(),O=i("p"),O.innerHTML=Jl,yt=s(),ee=i("p"),ee.innerHTML=Tl,bt=s(),h(te.$$.fragment),wt=s(),le=i("p"),le.innerHTML=Cl,Ut=s(),ae=i("ul"),ae.innerHTML=jl,_t=s(),T=i("h2"),X=i("a"),Fe=i("span"),h(se.$$.fragment),rl=s(),He=i("span"),He.textContent=vl,gt=s(),ne=i("p"),ne.innerHTML=Zl,Jt=s(),h(ie.$$.fragment),Tt=s(),re=i("p"),re.innerHTML=$l,Ct=s(),h(oe.$$.fragment),jt=s(),pe=i("p"),pe.innerHTML=xl,vt=s(),h(ce.$$.fragment),Zt=s(),de=i("p"),de.innerHTML=Rl,$t=s(),h(he.$$.fragment),xt=s(),ue=i("p"),ue.innerHTML=Xl,Rt=s(),h(me.$$.fragment),Xt=s(),fe=i("p"),fe.innerHTML=kl,kt=s(),h(Me.$$.fragment),It=s(),ye=i("p"),ye.innerHTML=Il,Wt=s(),h(be.$$.fragment),At=s(),we=i("p"),we.innerHTML=Wl,Gt=s(),C=i("h2"),k=i("a"),ze=i("span"),h(Ue.$$.fragment),ol=s(),Le=i("span"),Le.textContent=Al,Nt=s(),_e=i("p"),_e.textContent=Gl,Vt=s(),ge=i("p"),ge.innerHTML=Nl,Ht=s(),h(Je.$$.fragment),Lt=s(),Te=i("p"),Te.textContent=Vl,Yt=s(),h(Ce.$$.fragment),Et=s(),j=i("h2"),I=i("a"),qe=i("span"),h(je.$$.fragment),pl=s(),Ye=i("span"),Ye.textContent=Hl,Bt=s(),ve=i("p"),ve.innerHTML=Ll,Qt=s(),Ze=i("p"),Ze.innerHTML=Yl,St=s(),v=i("h2"),W=i("a"),De=i("span"),h($e.$$.fragment),cl=s(),Ee=i("span"),Ee.textContent=El,Ft=s(),xe=i("p"),xe.innerHTML=Bl,zt=s(),Re=i("p"),Re.innerHTML=Ql,qt=s(),Z=i("h2"),A=i("a"),Pe=i("span"),h(Xe.$$.fragment),dl=s(),Be=i("span"),Be.textContent=Sl,Dt=s(),ke=i("p"),ke.textContent=Fl,Pt=s(),Ie=i("ul"),Ie.innerHTML=zl,this.h()},l(e){const t=ma("svelte-1phssyn",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(l),g=n(e),b=r(e,"H1",{class:!0});var We=w(b);_=r(We,"A",{id:!0,class:!0,href:!0});var Ke=w(_);Qe=r(Ke,"SPAN",{});var ql=w(Qe);u(G.$$.fragment,ql),ql.forEach(l),Ke.forEach(l),nl=n(We),Ne=r(We,"SPAN",{"data-svelte-h":!0}),o(Ne)!=="svelte-15b9pg9"&&(Ne.textContent=hl),We.forEach(l),Oe=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1oefohu"&&(N.innerHTML=ul),et=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-w1dbtu"&&(V.innerHTML=ml),tt=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1izwzxl"&&(H.innerHTML=fl),lt=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-l7dm2q"&&(L.textContent=Ml),at=n(e),u(Y.$$.fragment,e),st=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-z4z0b9"&&(E.textContent=yl),nt=n(e),u(B.$$.fragment,e),it=n(e),u($.$$.fragment,e),rt=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-h7f7kz"&&(Q.innerHTML=bl),ot=n(e),u(S.$$.fragment,e),pt=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-di6juu"&&(F.textContent=wl),ct=n(e),u(z.$$.fragment,e),dt=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-tsz4qp"&&(q.textContent=Ul),ht=n(e),u(D.$$.fragment,e),ut=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1fkfdql"&&(P.innerHTML=_l),mt=n(e),J=r(e,"H2",{class:!0});var Ot=w(J);x=r(Ot,"A",{id:!0,class:!0,href:!0});var Dl=w(x);Se=r(Dl,"SPAN",{});var Pl=w(Se);u(K.$$.fragment,Pl),Pl.forEach(l),Dl.forEach(l),il=n(Ot),Ve=r(Ot,"SPAN",{"data-svelte-h":!0}),o(Ve)!=="svelte-r00uw2"&&(Ve.textContent=gl),Ot.forEach(l),ft=n(e),u(R.$$.fragment,e),Mt=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-z8r4ny"&&(O.innerHTML=Jl),yt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1r0bv1x"&&(ee.innerHTML=Tl),bt=n(e),u(te.$$.fragment,e),wt=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-opb00x"&&(le.innerHTML=Cl),Ut=n(e),ae=r(e,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-q5d022"&&(ae.innerHTML=jl),_t=n(e),T=r(e,"H2",{class:!0});var el=w(T);X=r(el,"A",{id:!0,class:!0,href:!0});var Kl=w(X);Fe=r(Kl,"SPAN",{});var Ol=w(Fe);u(se.$$.fragment,Ol),Ol.forEach(l),Kl.forEach(l),rl=n(el),He=r(el,"SPAN",{"data-svelte-h":!0}),o(He)!=="svelte-339bde"&&(He.textContent=vl),el.forEach(l),gt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-xygc62"&&(ne.innerHTML=Zl),Jt=n(e),u(ie.$$.fragment,e),Tt=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1fe8qlp"&&(re.innerHTML=$l),Ct=n(e),u(oe.$$.fragment,e),jt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-184frii"&&(pe.innerHTML=xl),vt=n(e),u(ce.$$.fragment,e),Zt=n(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-he12t1"&&(de.innerHTML=Rl),$t=n(e),u(he.$$.fragment,e),xt=n(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1c3frfx"&&(ue.innerHTML=Xl),Rt=n(e),u(me.$$.fragment,e),Xt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-4kbgth"&&(fe.innerHTML=kl),kt=n(e),u(Me.$$.fragment,e),It=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1g18b9r"&&(ye.innerHTML=Il),Wt=n(e),u(be.$$.fragment,e),At=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1pefyrm"&&(we.innerHTML=Wl),Gt=n(e),C=r(e,"H2",{class:!0});var tl=w(C);k=r(tl,"A",{id:!0,class:!0,href:!0});var ea=w(k);ze=r(ea,"SPAN",{});var ta=w(ze);u(Ue.$$.fragment,ta),ta.forEach(l),ea.forEach(l),ol=n(tl),Le=r(tl,"SPAN",{"data-svelte-h":!0}),o(Le)!=="svelte-zp6p5k"&&(Le.textContent=Al),tl.forEach(l),Nt=n(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-5c8ldp"&&(_e.textContent=Gl),Vt=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-14rdptq"&&(ge.innerHTML=Nl),Ht=n(e),u(Je.$$.fragment,e),Lt=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-2n690z"&&(Te.textContent=Vl),Yt=n(e),u(Ce.$$.fragment,e),Et=n(e),j=r(e,"H2",{class:!0});var ll=w(j);I=r(ll,"A",{id:!0,class:!0,href:!0});var la=w(I);qe=r(la,"SPAN",{});var aa=w(qe);u(je.$$.fragment,aa),aa.forEach(l),la.forEach(l),pl=n(ll),Ye=r(ll,"SPAN",{"data-svelte-h":!0}),o(Ye)!=="svelte-erj1xh"&&(Ye.textContent=Hl),ll.forEach(l),Bt=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-21u499"&&(ve.innerHTML=Ll),Qt=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1sxi0tl"&&(Ze.innerHTML=Yl),St=n(e),v=r(e,"H2",{class:!0});var al=w(v);W=r(al,"A",{id:!0,class:!0,href:!0});var sa=w(W);De=r(sa,"SPAN",{});var na=w(De);u($e.$$.fragment,na),na.forEach(l),sa.forEach(l),cl=n(al),Ee=r(al,"SPAN",{"data-svelte-h":!0}),o(Ee)!=="svelte-1g3g87b"&&(Ee.textContent=El),al.forEach(l),Ft=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-swritx"&&(xe.innerHTML=Bl),zt=n(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-6dxtva"&&(Re.innerHTML=Ql),qt=n(e),Z=r(e,"H2",{class:!0});var sl=w(Z);A=r(sl,"A",{id:!0,class:!0,href:!0});var ia=w(A);Pe=r(ia,"SPAN",{});var ra=w(Pe);u(Xe.$$.fragment,ra),ra.forEach(l),ia.forEach(l),dl=n(sl),Be=r(sl,"SPAN",{"data-svelte-h":!0}),o(Be)!=="svelte-pr7lub"&&(Be.textContent=Sl),sl.forEach(l),Dt=n(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1bflftn"&&(ke.textContent=Fl),Pt=n(e),Ie=r(e,"UL",{"data-svelte-h":!0}),o(Ie)!=="svelte-e624yw"&&(Ie.innerHTML=zl),this.h()},h(){p(d,"name","hf:doc:metadata"),p(d,"content",JSON.stringify(ba)),p(_,"id","latent-consistency-distillation"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#latent-consistency-distillation"),p(b,"class","relative group"),p(x,"id","script-parameters"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#script-parameters"),p(J,"class","relative group"),p(X,"id","training-script"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#training-script"),p(T,"class","relative group"),p(k,"id","launch-the-script"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#launch-the-script"),p(C,"class","relative group"),p(I,"id","lora"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#lora"),p(j,"class","relative group"),p(W,"id","stable-diffusion-xl"),p(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(W,"href","#stable-diffusion-xl"),p(v,"class","relative group"),p(A,"id","next-steps"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#next-steps"),p(Z,"class","relative group")},m(e,t){c(document.head,d),a(e,g,t),a(e,b,t),c(b,_),c(_,Qe),m(G,Qe,null),c(b,nl),c(b,Ne),a(e,Oe,t),a(e,N,t),a(e,et,t),a(e,V,t),a(e,tt,t),a(e,H,t),a(e,lt,t),a(e,L,t),a(e,at,t),m(Y,e,t),a(e,st,t),a(e,E,t),a(e,nt,t),m(B,e,t),a(e,it,t),m($,e,t),a(e,rt,t),a(e,Q,t),a(e,ot,t),m(S,e,t),a(e,pt,t),a(e,F,t),a(e,ct,t),m(z,e,t),a(e,dt,t),a(e,q,t),a(e,ht,t),m(D,e,t),a(e,ut,t),a(e,P,t),a(e,mt,t),a(e,J,t),c(J,x),c(x,Se),m(K,Se,null),c(J,il),c(J,Ve),a(e,ft,t),m(R,e,t),a(e,Mt,t),a(e,O,t),a(e,yt,t),a(e,ee,t),a(e,bt,t),m(te,e,t),a(e,wt,t),a(e,le,t),a(e,Ut,t),a(e,ae,t),a(e,_t,t),a(e,T,t),c(T,X),c(X,Fe),m(se,Fe,null),c(T,rl),c(T,He),a(e,gt,t),a(e,ne,t),a(e,Jt,t),m(ie,e,t),a(e,Tt,t),a(e,re,t),a(e,Ct,t),m(oe,e,t),a(e,jt,t),a(e,pe,t),a(e,vt,t),m(ce,e,t),a(e,Zt,t),a(e,de,t),a(e,$t,t),m(he,e,t),a(e,xt,t),a(e,ue,t),a(e,Rt,t),m(me,e,t),a(e,Xt,t),a(e,fe,t),a(e,kt,t),m(Me,e,t),a(e,It,t),a(e,ye,t),a(e,Wt,t),m(be,e,t),a(e,At,t),a(e,we,t),a(e,Gt,t),a(e,C,t),c(C,k),c(k,ze),m(Ue,ze,null),c(C,ol),c(C,Le),a(e,Nt,t),a(e,_e,t),a(e,Vt,t),a(e,ge,t),a(e,Ht,t),m(Je,e,t),a(e,Lt,t),a(e,Te,t),a(e,Yt,t),m(Ce,e,t),a(e,Et,t),a(e,j,t),c(j,I),c(I,qe),m(je,qe,null),c(j,pl),c(j,Ye),a(e,Bt,t),a(e,ve,t),a(e,Qt,t),a(e,Ze,t),a(e,St,t),a(e,v,t),c(v,W),c(W,De),m($e,De,null),c(v,cl),c(v,Ee),a(e,Ft,t),a(e,xe,t),a(e,zt,t),a(e,Re,t),a(e,qt,t),a(e,Z,t),c(Z,A),c(A,Pe),m(Xe,Pe,null),c(Z,dl),c(Z,Be),a(e,Dt,t),a(e,ke,t),a(e,Pt,t),a(e,Ie,t),Kt=!0},p(e,[t]){const We={};t&2&&(We.$$scope={dirty:t,ctx:e}),$.$set(We);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),R.$set(Ke)},i(e){Kt||(f(G.$$.fragment,e),f(Y.$$.fragment,e),f(B.$$.fragment,e),f($.$$.fragment,e),f(S.$$.fragment,e),f(z.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(R.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),f(me.$$.fragment,e),f(Me.$$.fragment,e),f(be.$$.fragment,e),f(Ue.$$.fragment,e),f(Je.$$.fragment,e),f(Ce.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),f(Xe.$$.fragment,e),Kt=!0)},o(e){M(G.$$.fragment,e),M(Y.$$.fragment,e),M(B.$$.fragment,e),M($.$$.fragment,e),M(S.$$.fragment,e),M(z.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(R.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(he.$$.fragment,e),M(me.$$.fragment,e),M(Me.$$.fragment,e),M(be.$$.fragment,e),M(Ue.$$.fragment,e),M(Je.$$.fragment,e),M(Ce.$$.fragment,e),M(je.$$.fragment,e),M($e.$$.fragment,e),M(Xe.$$.fragment,e),Kt=!1},d(e){e&&(l(g),l(b),l(Oe),l(N),l(et),l(V),l(tt),l(H),l(lt),l(L),l(at),l(st),l(E),l(nt),l(it),l(rt),l(Q),l(ot),l(pt),l(F),l(ct),l(dt),l(q),l(ht),l(ut),l(P),l(mt),l(J),l(ft),l(Mt),l(O),l(yt),l(ee),l(bt),l(wt),l(le),l(Ut),l(ae),l(_t),l(T),l(gt),l(ne),l(Jt),l(Tt),l(re),l(Ct),l(jt),l(pe),l(vt),l(Zt),l(de),l($t),l(xt),l(ue),l(Rt),l(Xt),l(fe),l(kt),l(It),l(ye),l(Wt),l(At),l(we),l(Gt),l(C),l(Nt),l(_e),l(Vt),l(ge),l(Ht),l(Lt),l(Te),l(Yt),l(Et),l(j),l(Bt),l(ve),l(Qt),l(Ze),l(St),l(v),l(Ft),l(xe),l(zt),l(Re),l(qt),l(Z),l(Dt),l(ke),l(Pt),l(Ie)),l(d),y(G),y(Y,e),y(B,e),y($,e),y(S,e),y(z,e),y(D,e),y(K),y(R,e),y(te,e),y(se),y(ie,e),y(oe,e),y(ce,e),y(he,e),y(me,e),y(Me,e),y(be,e),y(Ue),y(Je,e),y(Ce,e),y(je),y($e),y(Xe)}}}const ba={local:"latent-consistency-distillation",sections:[{local:"script-parameters",title:"Script parameters"},{local:"training-script",title:"Training script"},{local:"launch-the-script",title:"Launch the script"},{local:"lora",title:"LoRA"},{local:"stable-diffusion-xl",title:"Stable Diffusion XL"},{local:"next-steps",title:"Next steps"}],title:"Latent Consistency Distillation"};function wa(Ge){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends ha{constructor(d){super(),ua(this,d,wa,ya,ca,{})}}export{Ca as component};
