import{s as Mt,f as pt,o as Jt,n as it}from"../chunks/scheduler.f6319a2a.js";import{S as yt,i as Tt,g as o,s as n,r as J,A as wt,h as i,f as t,c as a,j as at,u as y,x as M,k as bl,y as rt,a as s,v as T,d as w,t as r,w as c}from"../chunks/index.85aa684c.js";import{T as ot}from"../chunks/Tip.3d397a88.js";import{C as me}from"../chunks/CodeBlock.97b48fd2.js";import{D as ct}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as U,E as ut}from"../chunks/EditOnGithub.006048dd.js";function Ut(de){let p,I='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=o("p"),p.innerHTML=I},l(u){p=i(u,"P",{"data-svelte-h":!0}),M(p)!=="svelte-1p1d9vw"&&(p.innerHTML=I)},m(u,d){s(u,p,d)},p:it,d(u){u&&t(p)}}}function It(de){let p,I="The only way to run LLM-generated code securely is to isolate the execution from your local environment.";return{c(){p=o("p"),p.textContent=I},l(u){p=i(u,"P",{"data-svelte-h":!0}),M(p)!=="svelte-126gpxq"&&(p.textContent=I)},m(u,d){s(u,p,d)},p:it,d(u){u&&t(p)}}}function dt(de){let p,I,u,d,h,Ce,C,be,j,ge,b,fe,g,gl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',Be,f,fl="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",xe,B,Bl="Code is just a better way to express actions on a computer. It has better:",Ae,x,xl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",ve,A,Al='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Ze,je,vl,ke,v,Zl="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",Ee,Z,$e,k,kl="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",We,E,El=`This is inherently risky, LLM-generated code could be harmful to your environment.
One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.`,Ge,$,$l="So you need to be mindful of security.",_e,W,Wl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonInterpreter</code> from the ground up.`,Ne,G,Gl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",Ve,_,_l="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.<ul><li>Even so, because some innocuous packages like <code>re</code> can give access to potentially harmful packages as in <code>re.subprocess</code>, subpackages that match a list of dangerous patterns are not imported.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",Se,N,Nl="As a result, this interpreter is safer. We have used it on a diversity of use cases, without ever observing any damage to the environment.",Re,V,Vl="However, this solution is certainly not watertight, as no local python sandbox can really be: one could imagine occasions where LLMs fine-tuned for malignant actions could still hurt your environment.",Qe,S,Sl=`For instance, if you have allowed an innocuous package like <code>Pillow</code> to process images, the LLM could generate thousands of image saves to bloat your hard drive.
Other examples of attacks can be found <a href="https://gynvael.coldwind.pl/n/python_sandbox_escape" rel="nofollow">here</a>.`,He,R,Rl="Running these targeted malicious code snippet require a supply chain attack, meaning the LLM you use has been intoxicated.",Ye,Q,Ql="The likelihood of this happening is low when using well-known LLMs from trusted inference providers, but it is still non-zero.",Xe,m,ze,H,Hl="So if you want to exercise caution, you should use a remote execution sandbox.",Le,Y,Yl="Here are examples of how to do it.",qe,X,Fe,z,Xl="When working with AI agents that execute code, security is paramount. This guide describes how to set up and use secure sandboxes for your agent applications using either E2B cloud sandboxes or local Docker containers.",De,L,Pe,q,Ke,F,zl='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Oe,D,el,P,ll,K,Ll="We provide a simple way to use an E2B Sandbox: simply add <code>use_e2b_executor=True</code> to the agent initialization, like:",tl,O,sl,ee,ql="However, this does not work (yet) with more complicated multi-agent setups.",nl,le,al,te,Fl="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",ol,se,Dl="Here is how to do it:",il,ne,Ml,ae,pl,oe,Jl,ie,Pl='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',yl,Me,Tl,pe,wl,Je,Kl="Create a Dockerfile for your agent environment:",rl,ye,cl,Te,Ol="Create a sandbox manager to run code:",ul,we,Ul,re,Il,ce,et="These key practices apply to both E2B and Docker sandboxes:",dl,ue,lt="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",jl,Ue,tt="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",ml,Ie,hl,he,Cl;return h=new U({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),C=new ct({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),j=new ot({props:{warning:!1,$$slots:{default:[Ut]},$$scope:{ctx:de}}}),b=new U({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),Z=new U({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),m=new ot({props:{warning:!0,$$slots:{default:[It]},$$scope:{ctx:de}}}),X=new U({props:{title:"Sandbox setup for secure code execution",local:"sandbox-setup-for-secure-code-execution",headingTag:"h2"}}),L=new U({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),q=new U({props:{title:"Installation",local:"installation",headingTag:"h4"}}),D=new me({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),P=new U({props:{title:"Running your agent in E2B: mono agents",local:"running-your-agent-in-e2b-mono-agents",headingTag:"h4"}}),O=new me({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQobW9kZWwlM0RIZkFwaU1vZGVsKCklMkMlMjB0b29scyUzRCU1QiU1RCUyQyUyMHVzZV9lMmJfZXhlY3V0b3IlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjB5b3UlMjBnaXZlJTIwbWUlMjB0aGUlMjAxMDB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(model=HfApiModel(), tools=[], use_e2b_executor=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),le=new U({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),ne=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agents
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),ae=new U({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),oe=new U({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Me=new me({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),pe=new U({props:{title:"Setting up the docker sandbox",local:"setting-up-the-docker-sandbox",headingTag:"h4"}}),ye=new me({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),we=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agent
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),re=new U({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),Ie=new ut({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.mdx"}}),{c(){p=o("meta"),I=n(),u=o("p"),d=n(),J(h.$$.fragment),Ce=n(),J(C.$$.fragment),be=n(),J(j.$$.fragment),ge=n(),J(b.$$.fragment),fe=n(),g=o("p"),g.innerHTML=gl,Be=n(),f=o("p"),f.textContent=fl,xe=n(),B=o("p"),B.textContent=Bl,Ae=n(),x=o("ul"),x.innerHTML=xl,ve=n(),A=o("p"),A.innerHTML=Al,Ze=n(),je=o("img"),ke=n(),v=o("p"),v.textContent=Zl,Ee=n(),J(Z.$$.fragment),$e=n(),k=o("p"),k.innerHTML=kl,We=n(),E=o("p"),E.innerHTML=El,Ge=n(),$=o("p"),$.textContent=$l,_e=n(),W=o("p"),W.innerHTML=Wl,Ne=n(),G=o("p"),G.textContent=Gl,Ve=n(),_=o("ul"),_.innerHTML=_l,Se=n(),N=o("p"),N.textContent=Nl,Re=n(),V=o("p"),V.textContent=Vl,Qe=n(),S=o("p"),S.innerHTML=Sl,He=n(),R=o("p"),R.textContent=Rl,Ye=n(),Q=o("p"),Q.textContent=Ql,Xe=n(),J(m.$$.fragment),ze=n(),H=o("p"),H.textContent=Hl,Le=n(),Y=o("p"),Y.textContent=Yl,qe=n(),J(X.$$.fragment),Fe=n(),z=o("p"),z.textContent=Xl,De=n(),J(L.$$.fragment),Pe=n(),J(q.$$.fragment),Ke=n(),F=o("ol"),F.innerHTML=zl,Oe=n(),J(D.$$.fragment),el=n(),J(P.$$.fragment),ll=n(),K=o("p"),K.innerHTML=Ll,tl=n(),J(O.$$.fragment),sl=n(),ee=o("p"),ee.textContent=ql,nl=n(),J(le.$$.fragment),al=n(),te=o("p"),te.textContent=Fl,ol=n(),se=o("p"),se.textContent=Dl,il=n(),J(ne.$$.fragment),Ml=n(),J(ae.$$.fragment),pl=n(),J(oe.$$.fragment),Jl=n(),ie=o("ol"),ie.innerHTML=Pl,yl=n(),J(Me.$$.fragment),Tl=n(),J(pe.$$.fragment),wl=n(),Je=o("p"),Je.textContent=Kl,rl=n(),J(ye.$$.fragment),cl=n(),Te=o("p"),Te.textContent=Ol,ul=n(),J(we.$$.fragment),Ul=n(),J(re.$$.fragment),Il=n(),ce=o("p"),ce.textContent=et,dl=n(),ue=o("ul"),ue.innerHTML=lt,jl=n(),Ue=o("p"),Ue.textContent=tt,ml=n(),J(Ie.$$.fragment),hl=n(),he=o("p"),this.h()},l(e){const l=wt("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),I=a(e),u=i(e,"P",{}),at(u).forEach(t),d=a(e),y(h.$$.fragment,e),Ce=a(e),y(C.$$.fragment,e),be=a(e),y(j.$$.fragment,e),ge=a(e),y(b.$$.fragment,e),fe=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1nor5c0"&&(g.innerHTML=gl),Be=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1b2f48c"&&(f.textContent=fl),xe=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1jp5kiv"&&(B.textContent=Bl),Ae=a(e),x=i(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-a7ou7n"&&(x.innerHTML=xl),ve=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1ugtxvn"&&(A.innerHTML=Al),Ze=a(e),je=i(e,"IMG",{src:!0}),ke=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1lbgv3o"&&(v.textContent=Zl),Ee=a(e),y(Z.$$.fragment,e),$e=a(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-19p3p3d"&&(k.innerHTML=kl),We=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-102urw8"&&(E.innerHTML=El),Ge=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1aiwpgt"&&($.textContent=$l),_e=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-19wx21x"&&(W.innerHTML=Wl),Ne=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-180snho"&&(G.textContent=Gl),Ve=a(e),_=i(e,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-eu8x2q"&&(_.innerHTML=_l),Se=a(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-df6dcg"&&(N.textContent=Nl),Re=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1xn198z"&&(V.textContent=Vl),Qe=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-u02p3p"&&(S.innerHTML=Sl),He=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1u5rz9v"&&(R.textContent=Rl),Ye=a(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-31qg8m"&&(Q.textContent=Ql),Xe=a(e),y(m.$$.fragment,e),ze=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-pv9x3v"&&(H.textContent=Hl),Le=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-7irprr"&&(Y.textContent=Yl),qe=a(e),y(X.$$.fragment,e),Fe=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-6dqx27"&&(z.textContent=Xl),De=a(e),y(L.$$.fragment,e),Pe=a(e),y(q.$$.fragment,e),Ke=a(e),F=i(e,"OL",{"data-svelte-h":!0}),M(F)!=="svelte-uvtwg2"&&(F.innerHTML=zl),Oe=a(e),y(D.$$.fragment,e),el=a(e),y(P.$$.fragment,e),ll=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1pf0e54"&&(K.innerHTML=Ll),tl=a(e),y(O.$$.fragment,e),sl=a(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1hp6b3r"&&(ee.textContent=ql),nl=a(e),y(le.$$.fragment,e),al=a(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-geglm0"&&(te.textContent=Fl),ol=a(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1iycphr"&&(se.textContent=Dl),il=a(e),y(ne.$$.fragment,e),Ml=a(e),y(ae.$$.fragment,e),pl=a(e),y(oe.$$.fragment,e),Jl=a(e),ie=i(e,"OL",{"data-svelte-h":!0}),M(ie)!=="svelte-19h0avy"&&(ie.innerHTML=Pl),yl=a(e),y(Me.$$.fragment,e),Tl=a(e),y(pe.$$.fragment,e),wl=a(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1m1zn33"&&(Je.textContent=Kl),rl=a(e),y(ye.$$.fragment,e),cl=a(e),Te=i(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-8mtm8c"&&(Te.textContent=Ol),ul=a(e),y(we.$$.fragment,e),Ul=a(e),y(re.$$.fragment,e),Il=a(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-5fyo5r"&&(ce.textContent=et),dl=a(e),ue=i(e,"UL",{"data-svelte-h":!0}),M(ue)!=="svelte-162p62u"&&(ue.innerHTML=lt),jl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1hbg2e4"&&(Ue.textContent=tt),ml=a(e),y(Ie.$$.fragment,e),hl=a(e),he=i(e,"P",{}),at(he).forEach(t),this.h()},h(){bl(p,"name","hf:doc:metadata"),bl(p,"content",jt),pt(je.src,vl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||bl(je,"src",vl)},m(e,l){rt(document.head,p),s(e,I,l),s(e,u,l),s(e,d,l),T(h,e,l),s(e,Ce,l),T(C,e,l),s(e,be,l),T(j,e,l),s(e,ge,l),T(b,e,l),s(e,fe,l),s(e,g,l),s(e,Be,l),s(e,f,l),s(e,xe,l),s(e,B,l),s(e,Ae,l),s(e,x,l),s(e,ve,l),s(e,A,l),s(e,Ze,l),s(e,je,l),s(e,ke,l),s(e,v,l),s(e,Ee,l),T(Z,e,l),s(e,$e,l),s(e,k,l),s(e,We,l),s(e,E,l),s(e,Ge,l),s(e,$,l),s(e,_e,l),s(e,W,l),s(e,Ne,l),s(e,G,l),s(e,Ve,l),s(e,_,l),s(e,Se,l),s(e,N,l),s(e,Re,l),s(e,V,l),s(e,Qe,l),s(e,S,l),s(e,He,l),s(e,R,l),s(e,Ye,l),s(e,Q,l),s(e,Xe,l),T(m,e,l),s(e,ze,l),s(e,H,l),s(e,Le,l),s(e,Y,l),s(e,qe,l),T(X,e,l),s(e,Fe,l),s(e,z,l),s(e,De,l),T(L,e,l),s(e,Pe,l),T(q,e,l),s(e,Ke,l),s(e,F,l),s(e,Oe,l),T(D,e,l),s(e,el,l),T(P,e,l),s(e,ll,l),s(e,K,l),s(e,tl,l),T(O,e,l),s(e,sl,l),s(e,ee,l),s(e,nl,l),T(le,e,l),s(e,al,l),s(e,te,l),s(e,ol,l),s(e,se,l),s(e,il,l),T(ne,e,l),s(e,Ml,l),T(ae,e,l),s(e,pl,l),T(oe,e,l),s(e,Jl,l),s(e,ie,l),s(e,yl,l),T(Me,e,l),s(e,Tl,l),T(pe,e,l),s(e,wl,l),s(e,Je,l),s(e,rl,l),T(ye,e,l),s(e,cl,l),s(e,Te,l),s(e,ul,l),T(we,e,l),s(e,Ul,l),T(re,e,l),s(e,Il,l),s(e,ce,l),s(e,dl,l),s(e,ue,l),s(e,jl,l),s(e,Ue,l),s(e,ml,l),T(Ie,e,l),s(e,hl,l),s(e,he,l),Cl=!0},p(e,[l]){const st={};l&2&&(st.$$scope={dirty:l,ctx:e}),j.$set(st);const nt={};l&2&&(nt.$$scope={dirty:l,ctx:e}),m.$set(nt)},i(e){Cl||(w(h.$$.fragment,e),w(C.$$.fragment,e),w(j.$$.fragment,e),w(b.$$.fragment,e),w(Z.$$.fragment,e),w(m.$$.fragment,e),w(X.$$.fragment,e),w(L.$$.fragment,e),w(q.$$.fragment,e),w(D.$$.fragment,e),w(P.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(ne.$$.fragment,e),w(ae.$$.fragment,e),w(oe.$$.fragment,e),w(Me.$$.fragment,e),w(pe.$$.fragment,e),w(ye.$$.fragment,e),w(we.$$.fragment,e),w(re.$$.fragment,e),w(Ie.$$.fragment,e),Cl=!0)},o(e){r(h.$$.fragment,e),r(C.$$.fragment,e),r(j.$$.fragment,e),r(b.$$.fragment,e),r(Z.$$.fragment,e),r(m.$$.fragment,e),r(X.$$.fragment,e),r(L.$$.fragment,e),r(q.$$.fragment,e),r(D.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(le.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),r(oe.$$.fragment,e),r(Me.$$.fragment,e),r(pe.$$.fragment,e),r(ye.$$.fragment,e),r(we.$$.fragment,e),r(re.$$.fragment,e),r(Ie.$$.fragment,e),Cl=!1},d(e){e&&(t(I),t(u),t(d),t(Ce),t(be),t(ge),t(fe),t(g),t(Be),t(f),t(xe),t(B),t(Ae),t(x),t(ve),t(A),t(Ze),t(je),t(ke),t(v),t(Ee),t($e),t(k),t(We),t(E),t(Ge),t($),t(_e),t(W),t(Ne),t(G),t(Ve),t(_),t(Se),t(N),t(Re),t(V),t(Qe),t(S),t(He),t(R),t(Ye),t(Q),t(Xe),t(ze),t(H),t(Le),t(Y),t(qe),t(Fe),t(z),t(De),t(Pe),t(Ke),t(F),t(Oe),t(el),t(ll),t(K),t(tl),t(sl),t(ee),t(nl),t(al),t(te),t(ol),t(se),t(il),t(Ml),t(pl),t(Jl),t(ie),t(yl),t(Tl),t(wl),t(Je),t(rl),t(cl),t(Te),t(ul),t(Ul),t(Il),t(ce),t(dl),t(ue),t(jl),t(Ue),t(ml),t(hl),t(he)),t(p),c(h,e),c(C,e),c(j,e),c(b,e),c(Z,e),c(m,e),c(X,e),c(L,e),c(q,e),c(D,e),c(P,e),c(O,e),c(le,e),c(ne,e),c(ae,e),c(oe,e),c(Me,e),c(pe,e),c(ye,e),c(we,e),c(re,e),c(Ie,e)}}}const jt='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Sandbox setup for secure code execution","local":"sandbox-setup-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: mono agents","local":"running-your-agent-in-e2b-mono-agents","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Setting up the docker sandbox","local":"setting-up-the-docker-sandbox","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2}],"depth":1}';function mt(de){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends yt{constructor(p){super(),Tt(this,p,mt,dt,Mt,{})}}export{xt as component};
