import{s as nn,o as an,n as at}from"../chunks/scheduler.25b97de1.js";import{S as sn,i as rn,g as i,s as a,r as m,A as ln,h as r,f as o,c as s,j as N,u as p,x as c,k,y,a as n,v as h,d as g,t as u,w as f}from"../chunks/index.d9030fc9.js";import{T as vo}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C as Q}from"../chunks/CodeBlock.e6cd0d95.js";import{E as on}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as w,E as dn}from"../chunks/EditOnGithub.91d95064.js";function cn(C){let l,v="<li>Llava-Next uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){l=i("ul"),l.innerHTML=v},l(M){l=r(M,"UL",{"data-svelte-h":!0}),c(l)!=="svelte-17g7vjy"&&(l.innerHTML=v)},m(M,T){n(M,l,T)},p:at,d(M){M&&o(l)}}}function mn(C){let l,v='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',M,T,_='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){l=i("p"),l.innerHTML=v,M=a(),T=i("p"),T.innerHTML=_},l(d){l=r(d,"P",{"data-svelte-h":!0}),c(l)!=="svelte-nz63kd"&&(l.innerHTML=v),M=s(d),T=r(d,"P",{"data-svelte-h":!0}),c(T)!=="svelte-aze40l"&&(T.innerHTML=_)},m(d,b){n(d,l,b),n(d,M,b),n(d,T,b)},p:at,d(d){d&&(o(l),o(M),o(T))}}}function pn(C){let l,v="Example:",M,T,_;return T=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFOZXh0VmlkZW9Db25maWclMkMlMjBDTElQVmlzaW9uQ29uZmlnJTJDJTIwTGxhbWFDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUC12aXNpb24lMjBjb25maWclMEF2aXNpb25fY29uZmlnJTIwJTNEJTIwQ0xJUFZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYW1hJTIwY29uZmlnJTBBdGV4dF9jb25maWclMjAlM0QlMjBMbGFtYUNvbmZpZygpJTBBJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhTmV4dFZpZGVvQ29uZmlnKHZpc2lvbl9jb25maWclMkMlMjB0ZXh0X2NvbmZpZyklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration, LlavaNextVideoConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaNextVideoConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextVideoForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=i("p"),l.textContent=v,M=a(),m(T.$$.fragment)},l(d){l=r(d,"P",{"data-svelte-h":!0}),c(l)!=="svelte-11lpom8"&&(l.textContent=v),M=s(d),p(T.$$.fragment,d)},m(d,b){n(d,l,b),n(d,M,b),h(T,d,b),_=!0},p:at,i(d){_||(g(T.$$.fragment,d),_=!0)},o(d){u(T.$$.fragment,d),_=!1},d(d){d&&(o(l),o(M)),f(T,d)}}}function hn(C){let l,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=v},l(M){l=r(M,"P",{"data-svelte-h":!0}),c(l)!=="svelte-fincs2"&&(l.innerHTML=v)},m(M,T){n(M,l,T)},p:at,d(M){M&&o(l)}}}function gn(C){let l,v="Example:",M,T,_;return T=new Q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaNextVideoForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextVideoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video (model was trained with 32 frames per video, but this video is short)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs_video = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load an image to generate from an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER:&lt;image&gt;\\nWhat is shown in this image? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs_image = processor(text=prompt, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate from video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs_video, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:\\nWhy is this video funny? ASSISTANT: The humor in this video comes from the unexpected and endearing sight of a baby wearing glasses and (...)&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate from image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs_image, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER: \\nWhat&#x27;s the content of the image? ASSISTANT: The image shows a red stop sign on a pole, with a traditional Chinese archway (...)&quot;</span>`,wrap:!1}}),{c(){l=i("p"),l.textContent=v,M=a(),m(T.$$.fragment)},l(d){l=r(d,"P",{"data-svelte-h":!0}),c(l)!=="svelte-11lpom8"&&(l.textContent=v),M=s(d),p(T.$$.fragment,d)},m(d,b){n(d,l,b),n(d,M,b),h(T,d,b),_=!0},p:at,i(d){_||(g(T.$$.fragment,d),_=!0)},o(d){u(T.$$.fragment,d),_=!1},d(d){d&&(o(l),o(M)),f(T,d)}}}function un(C){let l,v,M,T,_,d,b,st,S,bo='The LLaVa-NeXT-Video model was proposed in <a href="https://llava-vl.github.io/blog/2024-04-30-llava-next-video/" rel="nofollow">LLaVA-NeXT: A Strong Zero-shot Video Understanding Model</a> by Yuanhan Zhang, Bo Li, Haotian Liu, Yong Jae Lee, Liangke Gui, Di Fu, Jiashi Feng, Ziwei Liu, Chunyuan Li. LLaVa-NeXT-Video improves upon <a href="llava_next">LLaVa-NeXT</a> by fine-tuning on a mix if video and image dataset thus increasing the model’s performance on videos.',it,P,Jo='<a href="llava_next">LLaVA-NeXT</a> surprisingly has strong performance in understanding video content in zero-shot fashion with the AnyRes technique that it uses. The AnyRes technique naturally represents a high-resolution image into multiple images. This technique is naturally generalizable to represent videos because videos can be considered as a set of frames (similar to a set of images in LLaVa-NeXT). The current version of LLaVA-NeXT makes use of AnyRes and trains with supervised fine-tuning (SFT) on top of LLaVA-Next on video data to achieves better video understanding capabilities.The model is a current SOTA among open-source models on <a href="https://arxiv.org/abs/2405.21075" rel="nofollow">VideoMME bench</a>.',rt,Y,wo="The introduction from the blog is the following:",lt,H,Uo="On January 30, 2024, we released LLaVA-NeXT, an open-source Large Multimodal Model (LMM) that has been trained exclusively on text-image data. With the proposed AnyRes technique, it boosts capabilities in reasoning, OCR, and world knowledge, demonstrating remarkable performance across a spectrum of image-based multimodal understanding tasks, and even exceeding Gemini-Pro on several image benchmarks, e.g. MMMU and MathVista.",dt,D,jo="**In today’s exploration, we delve into the performance of LLaVA-NeXT within the realm of video understanding tasks. We reveal that LLaVA-NeXT surprisingly has strong performance in understanding video content. The current version of LLaVA-NeXT for videos has several improvements:",ct,O,Io="<li>Zero-shot video representation capabilities with AnyRes: The AnyRes technique naturally represents a high-resolution image into multiple images that a pre-trained VIT is able to digest, and forms them into a concantenated sequence. This technique is naturally generalizable to represent videos (consisting of multiple frames), allowing the image-only-trained LLaVA-Next model to perform surprisingly well on video tasks. Notably, this is the first time that LMMs show strong zero-shot modality transfer ability.</li> <li>Inference with length generalization improves on longer videos. The linear scaling technique enables length generalization, allowing LLaVA-NeXT to effectively handle long-video beyond the limitation of the “max_token_length” of the LLM.</li> <li>Strong video understanding ability. (1) LLaVA-Next-Image, which combines the above two techniques, yields superior zero-shot performance than open-source LMMs tuned on videos. (2) LLaVA-Next-Video, further supervised fine-tuning (SFT) LLaVA-Next-Image on video data, achieves better video understanding capabilities compared to LLaVA-Next-Image. (3) LLaVA-Next-Video-DPO, which aligns the model response with AI feedback using direct preference optimization (DPO), showing significant performance boost.</li> <li>Efficient deployment and inference with SGLang. It allows 5x faster inference on video tasks, allowing more scalable serving such as million-level video re-captioning. See instructions in our repo.**</li>",mt,K,Co=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/LLaVA-VL/LLaVA-NeXT/tree/inference" rel="nofollow">here</a>.`,pt,ee,ht,te,xo="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",gt,B,ut,oe,Vo="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",ft,ne,yt,ae,Lo="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",Mt,se,No="<strong>Important:</strong>",Tt,ie,ko="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",_t,re,Zo='Here’s an example of how to structure your input. We will use <a href="https://huggingface.co/llava-hf/LLaVA-NeXT-Video-7B-hf" rel="nofollow">LLaVA-NeXT-Video-7B-hf</a> and a conversation history of videos and images.',vt,le,bt,de,zo="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",Jt,ce,wt,me,Ut,pe,Bo="The model can accept both images and videos as input. Here’s an example code for inference in half-precision (<code>torch.float16</code>):",jt,he,It,ge,Ct,ue,Go="The model can also generate from an interleaved image-video inputs. However note, that it was not trained in interleaved image-video setting which might affect the performance. Below is an example usage for mixed media input, add the following lines to the above code snippet:",xt,fe,Vt,ye,Lt,Me,Nt,Te,$o="The model can be loaded in lower bits, significantly reducing memory burden while maintaining the performance of the original model. This allows for efficient deployment on resource-constrained cases.",kt,_e,qo="First, make sure to install bitsandbytes by running <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",Zt,G,zt,ve,Wo='Then simply load the quantized model by adding <a href="../main_classes/quantization#transformers.BitsAndBytesConfig"><code>BitsAndBytesConfig</code></a> as shown below:',Bt,be,Gt,Je,$t,we,Ro='Additionally, we can greatly speed-up model inference by using <a href="../perf_train_gpu_one#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',qt,Ue,Fo="First, make sure to install the latest version of Flash Attention 2:",Wt,je,Rt,Ie,Ao='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',Ft,Ce,Xo="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",At,xe,Xt,Ve,Et,V,Le,oo,Qe,Eo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoForConditionalGeneration">LlavaNextVideoForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/LLaVA-NeXT-Video-7B-hf" rel="nofollow">llava-hf/LLaVA-NeXT-Video-7B-hf</a>
model.
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,no,$,Qt,Ne,St,J,ke,ao,Se,Qo=`Constructs a LLaVa-NeXT-Video processor which wraps a LLaVa-NeXT image processor, LLaVa-NeXT-Video video processor and
a LLaMa tokenizer into a single processor.`,so,Pe,So=`<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor">LlavaNextVideoProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoImageProcessor">LlavaNextVideoImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor.decode">decode()</a> for more information.`,io,q,Ze,ro,Ye,Po=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,lo,W,ze,co,He,Yo=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Pt,Be,Yt,U,Ge,mo,De,Ho='Constructs a LLaVa-NeXT-Video video processor. Based on <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> with incorporation of processing each video frame.',po,Oe,$e,ho,R,qe,go,Ke,Do=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,Ht,We,Dt,j,Re,uo,et,Oo=`The LLAVA-NeXT model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,fo,tt,Ko=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yo,x,Fe,Mo,ot,en='The <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoForConditionalGeneration">LlavaNextVideoForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',To,F,_o,A,Ot,Ae,Kt,nt,eo;return _=new w({props:{title:"LLaVa-NeXT-Video",local:"llava-next-video",headingTag:"h1"}}),b=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new w({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),B=new vo({props:{warning:!0,$$slots:{default:[cn]},$$scope:{ctx:C}}}),ne=new w({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),le=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoProcessor

processor = LlavaNextVideoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A chat between a curious human and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the human&#x27;s questions.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>},
            ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your visuals</span>
<span class="hljs-built_in">print</span>(text_prompt)`,wrap:!1}}),ce=new w({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),me=new w({props:{title:"Single Media Mode",local:"single-media-mode",headingTag:"h3"}}),he=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration, LlavaNextVideoProcessor

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaNextVideoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = LlavaNextVideoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>)

<span class="hljs-comment"># Load the video as an np.array, sampling uniformly 8 frames (can sample more for longer videos)</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)

conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: video_path},
            ],
    },
]

inputs = processor.apply_chat_template(conversation, num_frames=<span class="hljs-number">8</span>, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)`,wrap:!1}}),ge=new w({props:{title:"Mixed Media Mode",local:"mixed-media-mode",headingTag:"h3"}}),fe=new Q({props:{code:"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",highlighted:`
<span class="hljs-comment"># Generate from image and video mixed inputs</span>
conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;How many cats are there in the image?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            ],
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There are two cats&quot;</span>}],
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: video_path},
            ],
    },
]
inputs = processor.apply_chat_template(conversation, num_frames=<span class="hljs-number">8</span>, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
`,wrap:!1}}),ye=new w({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),Me=new w({props:{title:"Quantization using Bitsandbytes for memory efficiency",local:"quantization-using-bitsandbytes-for-memory-efficiency",headingTag:"h3"}}),G=new vo({props:{$$slots:{default:[mn]},$$scope:{ctx:C}}}),be=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFOZXh0VmlkZW9Qcm9jZXNzb3IlMEElMEElMjMlMjBzcGVjaWZ5JTIwaG93JTIwdG8lMjBxdWFudGl6ZSUyMHRoZSUyMG1vZGVsJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhdmFOZXh0VmlkZW9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGTExhVkEtTmVYVC1WaWRlby03Qi1oZiUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration, LlavaNextVideoProcessor

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = LlavaNextVideoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Je=new w({props:{title:"Flash-Attention 2 to speed-up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h3"}}),je=new Q({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),xe=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU5leHRWaWRlb0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybGxhdmEtaGYlMkZMTGFWQS1OZVhULVZpZGVvLTdCLWhmJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration

model = LlavaNextVideoForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, 
    torch_dtype=torch.float16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Ve=new w({props:{title:"LlavaNextVideoConfig",local:"transformers.LlavaNextVideoConfig",headingTag:"h2"}}),Le=new z({props:{name:"class transformers.LlavaNextVideoConfig",anchor:"transformers.LlavaNextVideoConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"multimodal_projector_bias",val:" = True"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"video_token_index",val:" = 32000"},{name:"spatial_pool_mode",val:" = 'average'"},{name:"spatial_pool_stride",val:" = 2"},{name:"image_seq_length",val:" = 576"},{name:"video_seq_length",val:" = 288"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaNextVideoConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaNextVideoConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaNextVideoConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaNextVideoConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"},{anchor:"transformers.LlavaNextVideoConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[[336, 672], [672, 336], [672, 672], [1008, 336], [336, 1008]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextVideoConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaNextVideoConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.LlavaNextVideoConfig.spatial_pool_mode",description:`<strong>spatial_pool_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;average&quot;</code>) &#x2014;
Pooling mode to use for videos. Can be &#x201C;average&#x201D;, &#x201C;max&#x201D; or &#x201C;conv&#x201D;.`,name:"spatial_pool_mode"},{anchor:"transformers.LlavaNextVideoConfig.spatial_pool_stride",description:`<strong>spatial_pool_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Stride used in the pooling layer for videos.`,name:"spatial_pool_stride"},{anchor:"transformers.LlavaNextVideoConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.LlavaNextVideoConfig.video_seq_length",description:`<strong>video_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 288) &#x2014;
Sequence length of one video embedding.`,name:"video_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/configuration_llava_next_video.py#L27"}}),$=new on({props:{anchor:"transformers.LlavaNextVideoConfig.example",$$slots:{default:[pn]},$$scope:{ctx:C}}}),Ne=new w({props:{title:"LlavaNextVideoProcessor",local:"transformers.LlavaNextVideoProcessor",headingTag:"h2"}}),ke=new z({props:{name:"class transformers.LlavaNextVideoProcessor",anchor:"transformers.LlavaNextVideoProcessor",parameters:[{name:"video_processor",val:" = None"},{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"video_token",val:" = '<video>'"},{name:"image_token",val:" = '<image>'"},{name:"num_additional_image_tokens",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoProcessor.video_processor",description:`<strong>video_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoImageProcessor">LlavaNextVideoImageProcessor</a>, <em>optional</em>) &#x2014;
The video processor is a required input.`,name:"video_processor"},{anchor:"transformers.LlavaNextVideoProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaNextVideoProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaNextVideoProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Jinja chat template that will be used in tokenizer&#x2019;s <code>apply_chat_template</code>`,name:"chat_template"},{anchor:"transformers.LlavaNextVideoProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaNextVideoProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.LlavaNextVideoProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaNextVideoProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/processing_llava_next_video.py#L46"}}),Ze=new z({props:{name:"batch_decode",anchor:"transformers.LlavaNextVideoProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/processing_llava_next_video.py#L265"}}),ze=new z({props:{name:"decode",anchor:"transformers.LlavaNextVideoProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/processing_llava_next_video.py#L273"}}),Be=new w({props:{title:"LlavaNextVideoImageProcessor",local:"transformers.LlavaNextVideoImageProcessor",headingTag:"h2"}}),Ge=new z({props:{name:"class transformers.LlavaNextVideoImageProcessor",anchor:"transformers.LlavaNextVideoImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextVideoImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextVideoImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processinf videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextVideoImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextVideoImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextVideoImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextVideoImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextVideoImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/image_processing_llava_next_video.py#L48"}}),$e=new z({props:{name:"preprocess",anchor:"transformers.LlavaNextVideoImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[typing.List[ForwardRef('PIL.Image.Image')], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), typing.List[ForwardRef('np.ndarray')], typing.List[ForwardRef('torch.Tensor')], typing.List[typing.List[ForwardRef('PIL.Image.Image')]], typing.List[typing.List[ForwardRef('np.ndarrray')]], typing.List[typing.List[ForwardRef('torch.Tensor')]]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>VideoInput</code>) &#x2014;
Videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the video.`,name:"do_resize"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the video after resizing. Shortest edge of the video is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the video. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the video.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the video.`,name:"do_rescale"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the video by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the video.`,name:"do_normalize"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Frame mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Frame standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the video to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/image_processing_llava_next_video.py#L279"}}),qe=new z({props:{name:"resize",anchor:"transformers.LlavaNextVideoImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/image_processing_llava_next_video.py#L129"}}),We=new w({props:{title:"LlavaNextVideoForConditionalGeneration",local:"transformers.LlavaNextVideoForConditionalGeneration",headingTag:"h2"}}),Re=new z({props:{name:"class transformers.LlavaNextVideoForConditionalGeneration",anchor:"transformers.LlavaNextVideoForConditionalGeneration",parameters:[{name:"config",val:": LlavaNextVideoConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoConfig">LlavaNextVideoConfig</a> or <code>LlavaNextVideoVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L397"}}),Fe=new z({props:{name:"forward",anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[typing.List[int], int, NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">LlavaNextVideoImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoImageProcessor">LlavaNextVideoImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.pixel_values_videos",description:"<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See </code>LlavaNextVideoVideoProcessor.<strong>call</strong><code>for details. [LlavaProcessor](/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor) uses</code>LlavaNextVideoVideoProcessor` for processing videos.",name:"pixel_values_videos"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next_video.modeling_llava_next_video.LlavaNextVideoCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoConfig"
>LlavaNextVideoConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next_video.modeling_llava_next_video.LlavaNextVideoCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new vo({props:{$$slots:{default:[hn]},$$scope:{ctx:C}}}),A=new on({props:{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.example",$$slots:{default:[gn]},$$scope:{ctx:C}}}),Ae=new dn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_next_video.md"}}),{c(){l=i("meta"),v=a(),M=i("p"),T=a(),m(_.$$.fragment),d=a(),m(b.$$.fragment),st=a(),S=i("p"),S.innerHTML=bo,it=a(),P=i("p"),P.innerHTML=Jo,rt=a(),Y=i("p"),Y.textContent=wo,lt=a(),H=i("p"),H.textContent=Uo,dt=a(),D=i("p"),D.textContent=jo,ct=a(),O=i("ul"),O.innerHTML=Io,mt=a(),K=i("p"),K.innerHTML=Co,pt=a(),m(ee.$$.fragment),ht=a(),te=i("ul"),te.innerHTML=xo,gt=a(),m(B.$$.fragment),ut=a(),oe=i("blockquote"),oe.innerHTML=Vo,ft=a(),m(ne.$$.fragment),yt=a(),ae=i("p"),ae.innerHTML=Lo,Mt=a(),se=i("p"),se.innerHTML=No,Tt=a(),ie=i("ul"),ie.innerHTML=ko,_t=a(),re=i("p"),re.innerHTML=Zo,vt=a(),m(le.$$.fragment),bt=a(),de=i("p"),de.innerHTML=zo,Jt=a(),m(ce.$$.fragment),wt=a(),m(me.$$.fragment),Ut=a(),pe=i("p"),pe.innerHTML=Bo,jt=a(),m(he.$$.fragment),It=a(),m(ge.$$.fragment),Ct=a(),ue=i("p"),ue.textContent=Go,xt=a(),m(fe.$$.fragment),Vt=a(),m(ye.$$.fragment),Lt=a(),m(Me.$$.fragment),Nt=a(),Te=i("p"),Te.textContent=$o,kt=a(),_e=i("p"),_e.innerHTML=qo,Zt=a(),m(G.$$.fragment),zt=a(),ve=i("p"),ve.innerHTML=Wo,Bt=a(),m(be.$$.fragment),Gt=a(),m(Je.$$.fragment),$t=a(),we=i("p"),we.innerHTML=Ro,qt=a(),Ue=i("p"),Ue.textContent=Fo,Wt=a(),m(je.$$.fragment),Rt=a(),Ie=i("p"),Ie.innerHTML=Ao,Ft=a(),Ce=i("p"),Ce.innerHTML=Xo,At=a(),m(xe.$$.fragment),Xt=a(),m(Ve.$$.fragment),Et=a(),V=i("div"),m(Le.$$.fragment),oo=a(),Qe=i("p"),Qe.innerHTML=Eo,no=a(),m($.$$.fragment),Qt=a(),m(Ne.$$.fragment),St=a(),J=i("div"),m(ke.$$.fragment),ao=a(),Se=i("p"),Se.textContent=Qo,so=a(),Pe=i("p"),Pe.innerHTML=So,io=a(),q=i("div"),m(Ze.$$.fragment),ro=a(),Ye=i("p"),Ye.innerHTML=Po,lo=a(),W=i("div"),m(ze.$$.fragment),co=a(),He=i("p"),He.innerHTML=Yo,Pt=a(),m(Be.$$.fragment),Yt=a(),U=i("div"),m(Ge.$$.fragment),mo=a(),De=i("p"),De.innerHTML=Ho,po=a(),Oe=i("div"),m($e.$$.fragment),ho=a(),R=i("div"),m(qe.$$.fragment),go=a(),Ke=i("p"),Ke.textContent=Do,Ht=a(),m(We.$$.fragment),Dt=a(),j=i("div"),m(Re.$$.fragment),uo=a(),et=i("p"),et.innerHTML=Oo,fo=a(),tt=i("p"),tt.innerHTML=Ko,yo=a(),x=i("div"),m(Fe.$$.fragment),Mo=a(),ot=i("p"),ot.innerHTML=en,To=a(),m(F.$$.fragment),_o=a(),m(A.$$.fragment),Ot=a(),m(Ae.$$.fragment),Kt=a(),nt=i("p"),this.h()},l(e){const t=ln("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(o),v=s(e),M=r(e,"P",{}),N(M).forEach(o),T=s(e),p(_.$$.fragment,e),d=s(e),p(b.$$.fragment,e),st=s(e),S=r(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-fz66h5"&&(S.innerHTML=bo),it=s(e),P=r(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-smxnwa"&&(P.innerHTML=Jo),rt=s(e),Y=r(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1fhv1nu"&&(Y.textContent=wo),lt=s(e),H=r(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1mxjeai"&&(H.textContent=Uo),dt=s(e),D=r(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1p13ikg"&&(D.textContent=jo),ct=s(e),O=r(e,"UL",{"data-svelte-h":!0}),c(O)!=="svelte-3x3bx4"&&(O.innerHTML=Io),mt=s(e),K=r(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1ddk3wd"&&(K.innerHTML=Co),pt=s(e),p(ee.$$.fragment,e),ht=s(e),te=r(e,"UL",{"data-svelte-h":!0}),c(te)!=="svelte-b32abk"&&(te.innerHTML=xo),gt=s(e),p(B.$$.fragment,e),ut=s(e),oe=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),c(oe)!=="svelte-nygwxc"&&(oe.innerHTML=Vo),ft=s(e),p(ne.$$.fragment,e),yt=s(e),ae=r(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-pavm2p"&&(ae.innerHTML=Lo),Mt=s(e),se=r(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1uqcr0x"&&(se.innerHTML=No),Tt=s(e),ie=r(e,"UL",{"data-svelte-h":!0}),c(ie)!=="svelte-imbcrg"&&(ie.innerHTML=ko),_t=s(e),re=r(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-itzdp2"&&(re.innerHTML=Zo),vt=s(e),p(le.$$.fragment,e),bt=s(e),de=r(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-hqx9qk"&&(de.innerHTML=zo),Jt=s(e),p(ce.$$.fragment,e),wt=s(e),p(me.$$.fragment,e),Ut=s(e),pe=r(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1pauxcy"&&(pe.innerHTML=Bo),jt=s(e),p(he.$$.fragment,e),It=s(e),p(ge.$$.fragment,e),Ct=s(e),ue=r(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1ngvr6w"&&(ue.textContent=Go),xt=s(e),p(fe.$$.fragment,e),Vt=s(e),p(ye.$$.fragment,e),Lt=s(e),p(Me.$$.fragment,e),Nt=s(e),Te=r(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-jd6m5t"&&(Te.textContent=$o),kt=s(e),_e=r(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1mhpfy6"&&(_e.innerHTML=qo),Zt=s(e),p(G.$$.fragment,e),zt=s(e),ve=r(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-18yylzu"&&(ve.innerHTML=Wo),Bt=s(e),p(be.$$.fragment,e),Gt=s(e),p(Je.$$.fragment,e),$t=s(e),we=r(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-m1vtfc"&&(we.innerHTML=Ro),qt=s(e),Ue=r(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-13kjllm"&&(Ue.textContent=Fo),Wt=s(e),p(je.$$.fragment,e),Rt=s(e),Ie=r(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-dzzatn"&&(Ie.innerHTML=Ao),Ft=s(e),Ce=r(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-z3ioid"&&(Ce.innerHTML=Xo),At=s(e),p(xe.$$.fragment,e),Xt=s(e),p(Ve.$$.fragment,e),Et=s(e),V=r(e,"DIV",{class:!0});var Z=N(V);p(Le.$$.fragment,Z),oo=s(Z),Qe=r(Z,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-1ln5y00"&&(Qe.innerHTML=Eo),no=s(Z),p($.$$.fragment,Z),Z.forEach(o),Qt=s(e),p(Ne.$$.fragment,e),St=s(e),J=r(e,"DIV",{class:!0});var I=N(J);p(ke.$$.fragment,I),ao=s(I),Se=r(I,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-ghr7nt"&&(Se.textContent=Qo),so=s(I),Pe=r(I,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-107phni"&&(Pe.innerHTML=So),io=s(I),q=r(I,"DIV",{class:!0});var Xe=N(q);p(Ze.$$.fragment,Xe),ro=s(Xe),Ye=r(Xe,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-1o9eza"&&(Ye.innerHTML=Po),Xe.forEach(o),lo=s(I),W=r(I,"DIV",{class:!0});var Ee=N(W);p(ze.$$.fragment,Ee),co=s(Ee),He=r(Ee,"P",{"data-svelte-h":!0}),c(He)!=="svelte-kk16qw"&&(He.innerHTML=Yo),Ee.forEach(o),I.forEach(o),Pt=s(e),p(Be.$$.fragment,e),Yt=s(e),U=r(e,"DIV",{class:!0});var L=N(U);p(Ge.$$.fragment,L),mo=s(L),De=r(L,"P",{"data-svelte-h":!0}),c(De)!=="svelte-1s9b4sb"&&(De.innerHTML=Ho),po=s(L),Oe=r(L,"DIV",{class:!0});var tn=N(Oe);p($e.$$.fragment,tn),tn.forEach(o),ho=s(L),R=r(L,"DIV",{class:!0});var to=N(R);p(qe.$$.fragment,to),go=s(to),Ke=r(to,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-1qmgo6y"&&(Ke.textContent=Do),to.forEach(o),L.forEach(o),Ht=s(e),p(We.$$.fragment,e),Dt=s(e),j=r(e,"DIV",{class:!0});var X=N(j);p(Re.$$.fragment,X),uo=s(X),et=r(X,"P",{"data-svelte-h":!0}),c(et)!=="svelte-1mgcqn3"&&(et.innerHTML=Oo),fo=s(X),tt=r(X,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-hswkmf"&&(tt.innerHTML=Ko),yo=s(X),x=r(X,"DIV",{class:!0});var E=N(x);p(Fe.$$.fragment,E),Mo=s(E),ot=r(E,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-fpouuf"&&(ot.innerHTML=en),To=s(E),p(F.$$.fragment,E),_o=s(E),p(A.$$.fragment,E),E.forEach(o),X.forEach(o),Ot=s(e),p(Ae.$$.fragment,e),Kt=s(e),nt=r(e,"P",{}),N(nt).forEach(o),this.h()},h(){k(l,"name","hf:doc:metadata"),k(l,"content",fn),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){y(document.head,l),n(e,v,t),n(e,M,t),n(e,T,t),h(_,e,t),n(e,d,t),h(b,e,t),n(e,st,t),n(e,S,t),n(e,it,t),n(e,P,t),n(e,rt,t),n(e,Y,t),n(e,lt,t),n(e,H,t),n(e,dt,t),n(e,D,t),n(e,ct,t),n(e,O,t),n(e,mt,t),n(e,K,t),n(e,pt,t),h(ee,e,t),n(e,ht,t),n(e,te,t),n(e,gt,t),h(B,e,t),n(e,ut,t),n(e,oe,t),n(e,ft,t),h(ne,e,t),n(e,yt,t),n(e,ae,t),n(e,Mt,t),n(e,se,t),n(e,Tt,t),n(e,ie,t),n(e,_t,t),n(e,re,t),n(e,vt,t),h(le,e,t),n(e,bt,t),n(e,de,t),n(e,Jt,t),h(ce,e,t),n(e,wt,t),h(me,e,t),n(e,Ut,t),n(e,pe,t),n(e,jt,t),h(he,e,t),n(e,It,t),h(ge,e,t),n(e,Ct,t),n(e,ue,t),n(e,xt,t),h(fe,e,t),n(e,Vt,t),h(ye,e,t),n(e,Lt,t),h(Me,e,t),n(e,Nt,t),n(e,Te,t),n(e,kt,t),n(e,_e,t),n(e,Zt,t),h(G,e,t),n(e,zt,t),n(e,ve,t),n(e,Bt,t),h(be,e,t),n(e,Gt,t),h(Je,e,t),n(e,$t,t),n(e,we,t),n(e,qt,t),n(e,Ue,t),n(e,Wt,t),h(je,e,t),n(e,Rt,t),n(e,Ie,t),n(e,Ft,t),n(e,Ce,t),n(e,At,t),h(xe,e,t),n(e,Xt,t),h(Ve,e,t),n(e,Et,t),n(e,V,t),h(Le,V,null),y(V,oo),y(V,Qe),y(V,no),h($,V,null),n(e,Qt,t),h(Ne,e,t),n(e,St,t),n(e,J,t),h(ke,J,null),y(J,ao),y(J,Se),y(J,so),y(J,Pe),y(J,io),y(J,q),h(Ze,q,null),y(q,ro),y(q,Ye),y(J,lo),y(J,W),h(ze,W,null),y(W,co),y(W,He),n(e,Pt,t),h(Be,e,t),n(e,Yt,t),n(e,U,t),h(Ge,U,null),y(U,mo),y(U,De),y(U,po),y(U,Oe),h($e,Oe,null),y(U,ho),y(U,R),h(qe,R,null),y(R,go),y(R,Ke),n(e,Ht,t),h(We,e,t),n(e,Dt,t),n(e,j,t),h(Re,j,null),y(j,uo),y(j,et),y(j,fo),y(j,tt),y(j,yo),y(j,x),h(Fe,x,null),y(x,Mo),y(x,ot),y(x,To),h(F,x,null),y(x,_o),h(A,x,null),n(e,Ot,t),h(Ae,e,t),n(e,Kt,t),n(e,nt,t),eo=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),B.$set(Z);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),G.$set(I);const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),$.$set(Xe);const Ee={};t&2&&(Ee.$$scope={dirty:t,ctx:e}),F.$set(Ee);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),A.$set(L)},i(e){eo||(g(_.$$.fragment,e),g(b.$$.fragment,e),g(ee.$$.fragment,e),g(B.$$.fragment,e),g(ne.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(G.$$.fragment,e),g(be.$$.fragment,e),g(Je.$$.fragment,e),g(je.$$.fragment,e),g(xe.$$.fragment,e),g(Ve.$$.fragment,e),g(Le.$$.fragment,e),g($.$$.fragment,e),g(Ne.$$.fragment,e),g(ke.$$.fragment,e),g(Ze.$$.fragment,e),g(ze.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g($e.$$.fragment,e),g(qe.$$.fragment,e),g(We.$$.fragment,e),g(Re.$$.fragment,e),g(Fe.$$.fragment,e),g(F.$$.fragment,e),g(A.$$.fragment,e),g(Ae.$$.fragment,e),eo=!0)},o(e){u(_.$$.fragment,e),u(b.$$.fragment,e),u(ee.$$.fragment,e),u(B.$$.fragment,e),u(ne.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(G.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u($.$$.fragment,e),u(Ne.$$.fragment,e),u(ke.$$.fragment,e),u(Ze.$$.fragment,e),u(ze.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u($e.$$.fragment,e),u(qe.$$.fragment,e),u(We.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(Ae.$$.fragment,e),eo=!1},d(e){e&&(o(v),o(M),o(T),o(d),o(st),o(S),o(it),o(P),o(rt),o(Y),o(lt),o(H),o(dt),o(D),o(ct),o(O),o(mt),o(K),o(pt),o(ht),o(te),o(gt),o(ut),o(oe),o(ft),o(yt),o(ae),o(Mt),o(se),o(Tt),o(ie),o(_t),o(re),o(vt),o(bt),o(de),o(Jt),o(wt),o(Ut),o(pe),o(jt),o(It),o(Ct),o(ue),o(xt),o(Vt),o(Lt),o(Nt),o(Te),o(kt),o(_e),o(Zt),o(zt),o(ve),o(Bt),o(Gt),o($t),o(we),o(qt),o(Ue),o(Wt),o(Rt),o(Ie),o(Ft),o(Ce),o(At),o(Xt),o(Et),o(V),o(Qt),o(St),o(J),o(Pt),o(Yt),o(U),o(Ht),o(Dt),o(j),o(Ot),o(Kt),o(nt)),o(l),f(_,e),f(b,e),f(ee,e),f(B,e),f(ne,e),f(le,e),f(ce,e),f(me,e),f(he,e),f(ge,e),f(fe,e),f(ye,e),f(Me,e),f(G,e),f(be,e),f(Je,e),f(je,e),f(xe,e),f(Ve,e),f(Le),f($),f(Ne,e),f(ke),f(Ze),f(ze),f(Be,e),f(Ge),f($e),f(qe),f(We,e),f(Re),f(Fe),f(F),f(A),f(Ae,e)}}}const fn='{"title":"LLaVa-NeXT-Video","local":"llava-next-video","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media Mode","local":"single-media-mode","sections":[],"depth":3},{"title":"Mixed Media Mode","local":"mixed-media-mode","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes for memory efficiency","local":"quantization-using-bitsandbytes-for-memory-efficiency","sections":[],"depth":3},{"title":"Flash-Attention 2 to speed-up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaNextVideoConfig","local":"transformers.LlavaNextVideoConfig","sections":[],"depth":2},{"title":"LlavaNextVideoProcessor","local":"transformers.LlavaNextVideoProcessor","sections":[],"depth":2},{"title":"LlavaNextVideoImageProcessor","local":"transformers.LlavaNextVideoImageProcessor","sections":[],"depth":2},{"title":"LlavaNextVideoForConditionalGeneration","local":"transformers.LlavaNextVideoForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function yn(C){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Un extends sn{constructor(l){super(),rn(this,l,yn,un,nn,{})}}export{Un as component};
