import{s as hn,o as Un,n as At}from"../chunks/scheduler.25b97de1.js";import{S as gn,i as wn,g as l,s as o,r as i,A as _n,h as r,f as n,c as a,j as V,u as d,x as U,k as N,y,a as s,v as c,d as p,t as m,w as M}from"../chunks/index.d9030fc9.js";import{T as Tn}from"../chunks/Tip.baa67368.js";import{D as Z}from"../chunks/Docstring.ffac8efa.js";import{C as G}from"../chunks/CodeBlock.e6cd0d95.js";import{E as yn}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as b,E as fn}from"../chunks/EditOnGithub.91d95064.js";function Jn(q){let u,_;return u=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFF3ZW4yXzVfVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBRd2VuMl81X1ZMQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFF3ZW4yXzVfVkwlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwUXdlbjJfNV9WTENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMFF3ZW4yLVZMLTdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBRd2VuMl81X1ZMRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Qwen2_5_VLForConditionalGeneration, Qwen2_5_VLConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Qwen2_5_VL style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Qwen2_5_VLConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Qwen2-VL-7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Qwen2_5_VLForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i(u.$$.fragment)},l(h){d(u.$$.fragment,h)},m(h,w){c(u,h,w),_=!0},p:At,i(h){_||(p(u.$$.fragment,h),_=!0)},o(h){m(u.$$.fragment,h),_=!1},d(h){M(u,h)}}}function Cn(q){let u,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){u=l("p"),u.innerHTML=_},l(h){u=r(h,"P",{"data-svelte-h":!0}),U(u)!=="svelte-fincs2"&&(u.innerHTML=_)},m(h,w){s(h,u,w)},p:At,d(h){h&&n(u)}}}function bn(q){let u,_="Example:",h,w,j;return w=new G({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFF3ZW4yXzVfVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFF3ZW4yXzVfVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LVZMLTdCLUluc3RydWN0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LVZMLTdCLUluc3RydWN0JTIyKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuaWxhbmtlbG1hbi5vcmclMkZzdG9wc2lnbnMlMkZhdXN0cmFsaWEuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0QlNUJ0ZXh0JTVEJTJDJTIwaW1hZ2VzJTNEJTVCaW1hZ2UlNUQlMkMlMjB2aXNpb25faW5mb3MlM0QlNUJ2aXNpb25faW5mb3MlNUQpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Qwen2_5_VLForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Qwen2_5_VLForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[text], images=[image], vision_infos=[vision_infos])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;The image shows a street scene with a red stop sign in the foreground. In the background, there is a large red gate with Chinese characters ...&quot;</span>`,wrap:!1}}),{c(){u=l("p"),u.textContent=_,h=o(),i(w.$$.fragment)},l(g){u=r(g,"P",{"data-svelte-h":!0}),U(u)!=="svelte-11lpom8"&&(u.textContent=_),h=a(g),d(w.$$.fragment,g)},m(g,v){s(g,u,v),s(g,h,v),c(w,g,v),j=!0},p:At,i(g){j||(p(w.$$.fragment,g),j=!0)},o(g){m(w.$$.fragment,g),j=!1},d(g){g&&(n(u),n(h)),M(w,g)}}}function jn(q){let u,_,h,w,j,g,v,Xe,L,St='The <a href="https://qwenlm.github.io/blog/qwen2_5-vl/" rel="nofollow">Qwen2.5-VL</a> model is an update to <a href="https://arxiv.org/abs/2409.12191" rel="nofollow">Qwen2-VL</a> from Qwen team, Alibaba Group.',Fe,A,Et="The abstract from this update is the following:",Le,S,Ht="<em>Qwen2.5-VL marks a major step forward from Qwen2-VL, built upon the latest Qwen2.5 LLM. We’ve accelerated training and testing through the strategic implementation of window attention within the ViT. The ViT architecture itself has been refined with SwiGLU and RMSNorm, aligning it more closely with the LLM’s structure. A key innovation is the expansion of native dynamic resolution to encompass the temporal dimension, in addition to spatial aspects. Furthermore, we’ve upgraded MRoPE, incorporating absolute time alignment on the time axis to allow the model to effectively capture temporal dynamics, regardless of frame rate, leading to superior video understanding.</em>",Ae,E,Se,H,Ee,Y,Yt="The model can accept both images and videos as input. Here’s an example code for inference.",He,D,Ye,P,De,O,Dt="The model can batch inputs composed of mixed samples of various types such as images, videos, and text. Here is an example.",Pe,K,Oe,ee,Ke,te,et,ne,Pt="The model supports a wide range of resolution inputs. By default, it uses the native resolution for input, but higher resolutions can enhance performance at the cost of more computation. Users can set the minimum and maximum number of pixels to achieve an optimal configuration for their needs.",tt,se,nt,oe,Ot="In case of limited GPU RAM, one can reduce the resolution as follows:",st,ae,ot,le,Kt="This ensures each image gets encoded using a number between 256-1024 tokens. The 28 comes from the fact that the model uses a patch size of 14 and a temporal patch size of 2 (14 x 2 = 28).",at,ie,lt,re,en="By default, images and video content are directly included in the conversation. When handling multiple images, it’s helpful to add labels to the images and videos for better reference. Users can control this behavior with the following settings:",it,de,rt,ce,dt,pe,tn="First, make sure to install the latest version of Flash Attention 2:",ct,me,pt,Me,nn='Also, you should have hardware that is compatible with FlashAttention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',mt,ue,sn="To load and run a model using FlashAttention-2, add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model:",Mt,ye,ut,he,yt,f,Ue,vt,Ne,on=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLModel">Qwen2_5_VLModel</a>. It is used to instantiate a
Qwen2-VL model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of
Qwen2-VL-7B-Instruct <a href="https://huggingface.co/Qwen/Qwen2-VL-7B-Instruct" rel="nofollow">Qwen/Qwen2-VL-7B-Instruct</a>.`,Qt,Be,an=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Vt,W,ht,ge,Ut,T,we,Nt,Ze,ln=`Constructs a Qwen2.5-VL processor which wraps a Qwen2.5-VL image processor and a Qwen2 tokenizer into a single processor.
<a href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLProcessor">Qwen2_5_VLProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLProcessor.decode">decode()</a> for more information.`,Bt,x,_e,Zt,Ge,rn=`This method forwards all its arguments to Qwen2TokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Gt,k,Te,qt,qe,dn=`This method forwards all its arguments to Qwen2TokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Wt,z,fe,xt,We,cn="Post-process the output of the model to decode the text.",gt,Je,wt,J,Ce,kt,xe,pn=`The bare Qwen2_5_VL Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zt,ke,mn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,ze,be,_t,je,Tt,B,Ie,$t,I,ve,Xt,Re,Mn='The <a href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLForConditionalGeneration">Qwen2_5_VLForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Ft,R,Lt,$,ft,Qe,Jt,$e,Ct;return j=new b({props:{title:"Qwen2.5-VL",local:"qwen25-vl",headingTag:"h1"}}),v=new b({props:{title:"Overview",local:"overview",headingTag:"h2"}}),E=new b({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),H=new b({props:{title:"Single Media inference",local:"single-media-inference",headingTag:"h3"}}),D=new G({props:{code:"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",highlighted:`
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Qwen2_5_VLForConditionalGeneration, AutoTokenizer, AutoProcessor

<span class="hljs-comment"># Load the model in half-precision on the available device(s)</span>
model = Qwen2_5_VLForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>)


conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>:<span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>:[
            {
                <span class="hljs-string">&quot;type&quot;</span>:<span class="hljs-string">&quot;image&quot;</span>,
                <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://qianwen-res.oss-cn-beijing.aliyuncs.com/Qwen-VL/assets/demo.jpeg&quot;</span>
            },
            {
                <span class="hljs-string">&quot;type&quot;</span>:<span class="hljs-string">&quot;text&quot;</span>,
                <span class="hljs-string">&quot;text&quot;</span>:<span class="hljs-string">&quot;Describe this image.&quot;</span>
            }
        ]
    }
]

inputs = processor.apply_chat_template(
    conversation,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device)


<span class="hljs-comment"># Inference: Generation of the output</span>
output_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
generated_ids = [output_ids[<span class="hljs-built_in">len</span>(input_ids):] <span class="hljs-keyword">for</span> input_ids, output_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output_ids)]
output_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output_text)

<span class="hljs-comment"># Video</span>
conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/video.mp4&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What happened in the video?&quot;</span>},
        ],
    }
]

inputs = processor.apply_chat_template(
    conversation,
    video_fps=<span class="hljs-number">1</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device)

<span class="hljs-comment"># Inference: Generation of the output</span>
output_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
generated_ids = [output_ids[<span class="hljs-built_in">len</span>(input_ids):] <span class="hljs-keyword">for</span> input_ids, output_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output_ids)]
output_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output_text)`,wrap:!1}}),P=new b({props:{title:"Batch Mixed Media Inference",local:"batch-mixed-media-inference",headingTag:"h3"}}),K=new G({props:{code:"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",highlighted:`<span class="hljs-comment"># Conversation for the first image</span>
conversation1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/image1.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>}
        ]
    }
]

<span class="hljs-comment"># Conversation with two images</span>
conversation2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/image2.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/image3.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is written in the pictures?&quot;</span>}
        ]
    }
]

<span class="hljs-comment"># Conversation with pure text</span>
conversation3 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;who are you?&quot;</span>
    }
]


<span class="hljs-comment"># Conversation with mixed midia</span>
conversation4 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/image3.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/image4.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/path/to/video.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What are the common elements in these medias?&quot;</span>},
        ],
    }
]

conversations = [conversation1, conversation2, conversation3, conversation4]
<span class="hljs-comment"># Preparation for batch inference</span>
ipnuts = processor.apply_chat_template(
    conversations,
    video_fps=<span class="hljs-number">1</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device)


<span class="hljs-comment"># Batch Inference</span>
output_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
generated_ids = [output_ids[<span class="hljs-built_in">len</span>(input_ids):] <span class="hljs-keyword">for</span> input_ids, output_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output_ids)]
output_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output_text)`,wrap:!1}}),ee=new b({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h3"}}),te=new b({props:{title:"Image Resolution trade-off",local:"image-resolution-trade-off",headingTag:"h4"}}),se=new G({props:{code:"bWluX3BpeGVscyUyMCUzRCUyMDIyNCoyMjQlMEFtYXhfcGl4ZWxzJTIwJTNEJTIwMjA0OCoyMDQ4JTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLjUtVkwtN0ItSW5zdHJ1Y3QlMjIlMkMlMjBtaW5fcGl4ZWxzJTNEbWluX3BpeGVscyUyQyUyMG1heF9waXhlbHMlM0RtYXhfcGl4ZWxzKQ==",highlighted:`min_pixels = <span class="hljs-number">224</span>*<span class="hljs-number">224</span>
max_pixels = <span class="hljs-number">2048</span>*<span class="hljs-number">2048</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>, min_pixels=min_pixels, max_pixels=max_pixels)`,wrap:!1}}),ae=new G({props:{code:"bWluX3BpeGVscyUyMCUzRCUyMDI1NioyOCoyOCUwQW1heF9waXhlbHMlMjAlM0QlMjAxMDI0KjI4KjI4JTIwJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLjUtVkwtN0ItSW5zdHJ1Y3QlMjIlMkMlMjBtaW5fcGl4ZWxzJTNEbWluX3BpeGVscyUyQyUyMG1heF9waXhlbHMlM0RtYXhfcGl4ZWxzKQ==",highlighted:`min_pixels = <span class="hljs-number">256</span>*<span class="hljs-number">28</span>*<span class="hljs-number">28</span>
max_pixels = <span class="hljs-number">1024</span>*<span class="hljs-number">28</span>*<span class="hljs-number">28</span> 
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>, min_pixels=min_pixels, max_pixels=max_pixels)`,wrap:!1}}),ie=new b({props:{title:"Multiple Image Inputs",local:"multiple-image-inputs",headingTag:"h4"}}),de=new G({props:{code:"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",highlighted:`conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing well, thank you for asking. How can I assist you today?&quot;</span>
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe these images and video?&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;These are from my vacation.&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d be happy to describe the images and video for you. Could you please provide more context about your vacation?&quot;</span>
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It was a trip to the mountains. Can you see the details in the images and video?&quot;</span>
    }
]

<span class="hljs-comment"># default:</span>
prompt_without_id = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Excepted output: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Hello, how are you?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;m doing well, thank you for asking. How can I assist you today?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nCan you describe these images and video?&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;&lt;|vision_start|&gt;&lt;|video_pad|&gt;&lt;|vision_end|&gt;These are from my vacation.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;d be happy to describe the images and video for you. Could you please provide more context about your vacation?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nIt was a trip to the mountains. Can you see the details in the images and video?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;</span>


<span class="hljs-comment"># add ids</span>
prompt_with_id = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>, add_vision_id=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Excepted output: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nPicture 1: &lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Hello, how are you?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;m doing well, thank you for asking. How can I assist you today?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nCan you describe these images and video?Picture 2: &lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Picture 3: &lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Video 1: &lt;|vision_start|&gt;&lt;|video_pad|&gt;&lt;|vision_end|&gt;These are from my vacation.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;d be happy to describe the images and video for you. Could you please provide more context about your vacation?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nIt was a trip to the mountains. Can you see the details in the images and video?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;</span>
`,wrap:!1}}),ce=new b({props:{title:"Flash-Attention 2 to speed up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h4"}}),me=new G({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),ye=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFF3ZW4yXzVfVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFF3ZW4yXzVfVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuMi41LVZMLTdCLUluc3RydWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMCUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Qwen2_5_VLForConditionalGeneration

model = Qwen2_5_VLForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-VL-7B-Instruct&quot;</span>, 
    torch_dtype=torch.bfloat16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),he=new b({props:{title:"Qwen2_5_VLConfig",local:"transformers.Qwen2_5_VLConfig",headingTag:"h2"}}),Ue=new Z({props:{name:"class transformers.Qwen2_5_VLConfig",anchor:"transformers.Qwen2_5_VLConfig",parameters:[{name:"vocab_size",val:" = 152064"},{name:"hidden_size",val:" = 8192"},{name:"intermediate_size",val:" = 29568"},{name:"num_hidden_layers",val:" = 80"},{name:"num_attention_heads",val:" = 64"},{name:"num_key_value_heads",val:" = 8"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 32768"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 1000000.0"},{name:"use_sliding_window",val:" = False"},{name:"sliding_window",val:" = 4096"},{name:"max_window_layers",val:" = 80"},{name:"attention_dropout",val:" = 0.0"},{name:"vision_config",val:" = None"},{name:"rope_scaling",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2_5_VLConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 152064) &#x2014;
Vocabulary size of the Qwen2_5_VL model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLModel">Qwen2_5_VLModel</a>`,name:"vocab_size"},{anchor:"transformers.Qwen2_5_VLConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Qwen2_5_VLConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 29568) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Qwen2_5_VLConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Qwen2_5_VLConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Qwen2_5_VLConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>32</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Qwen2_5_VLConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Qwen2_5_VLConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Qwen2_5_VLConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Qwen2_5_VLConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Qwen2_5_VLConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Qwen2_5_VLConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.Qwen2_5_VLConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 1000000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Qwen2_5_VLConfig.use_sliding_window",description:`<strong>use_sliding_window</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use sliding window attention.`,name:"use_sliding_window"},{anchor:"transformers.Qwen2_5_VLConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Sliding window attention (SWA) window size. If not specified, will default to <code>4096</code>.`,name:"sliding_window"},{anchor:"transformers.Qwen2_5_VLConfig.max_window_layers",description:`<strong>max_window_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
The number of layers that use SWA (Sliding Window Attention). The bottom layers use SWA while the top use full attention.`,name:"max_window_layers"},{anchor:"transformers.Qwen2_5_VLConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Qwen2_5_VLConfig.vision_config",description:`<strong>vision_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The config for the visual encoder initialization.`,name:"vision_config"},{anchor:"transformers.Qwen2_5_VLConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/configuration_qwen2_5_vl.py#L68"}}),W=new yn({props:{anchor:"transformers.Qwen2_5_VLConfig.example",$$slots:{default:[Jn]},$$scope:{ctx:q}}}),ge=new b({props:{title:"Qwen2_5_VLProcessor",local:"transformers.Qwen2_5_VLProcessor",headingTag:"h2"}}),we=new Z({props:{name:"class transformers.Qwen2_5_VLProcessor",anchor:"transformers.Qwen2_5_VLProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2_5_VLProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Qwen2_5_VLProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Qwen2_5_VLProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/processing_qwen2_5_vl.py#L48"}}),_e=new Z({props:{name:"batch_decode",anchor:"transformers.Qwen2_5_VLProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/processing_qwen2_5_vl.py#L181"}}),Te=new Z({props:{name:"decode",anchor:"transformers.Qwen2_5_VLProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/processing_qwen2_5_vl.py#L188"}}),fe=new Z({props:{name:"post_process_image_text_to_text",anchor:"transformers.Qwen2_5_VLProcessor.post_process_image_text_to_text",parameters:[{name:"generated_outputs",val:""},{name:"skip_special_tokens",val:" = True"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2_5_VLProcessor.post_process_image_text_to_text.generated_outputs",description:`<strong>generated_outputs</strong> (<code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
The output of the model <code>generate</code> function. The output is expected to be a tensor of shape <code>(batch_size, sequence_length)</code>
or <code>(sequence_length,)</code>.`,name:"generated_outputs"},{anchor:"transformers.Qwen2_5_VLProcessor.post_process_image_text_to_text.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to remove special tokens in the output. Argument passed to the tokenizer&#x2019;s <code>batch_decode</code> method.`,name:"skip_special_tokens"},{anchor:"transformers.Qwen2_5_VLProcessor.post_process_image_text_to_text.Clean_up_tokenization_spaces",description:`<strong>Clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the tokenization spaces. Argument passed to the tokenizer&#x2019;s <code>batch_decode</code> method.`,name:"Clean_up_tokenization_spaces"},{anchor:"transformers.Qwen2_5_VLProcessor.post_process_image_text_to_text.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional arguments to be passed to the tokenizer&#x2019;s <code>batch_decode method</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/processing_qwen2_5_vl.py#L195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Je=new b({props:{title:"Qwen2_5_VLModel",local:"transformers.Qwen2_5_VLModel",headingTag:"h2"}}),Ce=new Z({props:{name:"class transformers.Qwen2_5_VLModel",anchor:"transformers.Qwen2_5_VLModel",parameters:[{name:"config",val:": Qwen2_5_VLConfig"}],parametersDescription:[{anchor:"transformers.Qwen2_5_VLModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLConfig">Qwen2_5_VLConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/modeling_qwen2_5_vl.py#L1098"}}),be=new Z({props:{name:"forward",anchor:"transformers.Qwen2_5_VLModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/modeling_qwen2_5_vl.py#L1126"}}),je=new b({props:{title:"Qwen2_5_VLForConditionalGeneration",local:"transformers.Qwen2_5_VLForConditionalGeneration",headingTag:"h2"}}),Ie=new Z({props:{name:"class transformers.Qwen2_5_VLForConditionalGeneration",anchor:"transformers.Qwen2_5_VLForConditionalGeneration",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/modeling_qwen2_5_vl.py#L1511"}}),ve=new Z({props:{name:"forward",anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_values_videos",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_grid_thw",val:": typing.Optional[torch.LongTensor] = None"},{name:"video_grid_thw",val:": typing.Optional[torch.LongTensor] = None"},{name:"rope_deltas",val:": typing.Optional[torch.LongTensor] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"second_per_grid_ts",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.pixel_values",description:"<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(seq_length, num_channels * image_size * image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See </code>Qwen2_5_VLImageProcessor.<strong>call</strong><code>for details. [Qwen2_5_VLProcessor](/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLProcessor) uses</code>Qwen2_5_VLImageProcessor` for processing images.",name:"pixel_values"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.pixel_values_videos",description:"<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(seq_length, num_channels * temporal_size * image_size * image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See </code>Qwen2_5_VLImageProcessor.<strong>call</strong><code>for details. [Qwen2_5_VLProcessor](/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLProcessor) uses</code>Qwen2_5_VLImageProcessor` for processing videos.",name:"pixel_values_videos"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.image_grid_thw",description:`<strong>image_grid_thw</strong> (<code>torch.LongTensor</code> of shape <code>(num_images, 3)</code>, <em>optional</em>) &#x2014;
The temporal, height and width of feature shape of each image in LLM.`,name:"image_grid_thw"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.video_grid_thw",description:`<strong>video_grid_thw</strong> (<code>torch.LongTensor</code> of shape <code>(num_videos, 3)</code>, <em>optional</em>) &#x2014;
The temporal, height and width of feature shape of each video in LLM.`,name:"video_grid_thw"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.rope_deltas",description:`<strong>rope_deltas</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
The rope index difference between sequence length and multimodal rope.`,name:"rope_deltas"},{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/qwen2_5_vl/modeling_qwen2_5_vl.py#L1722",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.qwen2_5_vl.modeling_qwen2_5_vl.Qwen2_5_VLCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/qwen2_5_vl#transformers.Qwen2_5_VLConfig"
>Qwen2_5_VLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>rope_deltas</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) — The rope index difference between sequence length and multimodal rope.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.qwen2_5_vl.modeling_qwen2_5_vl.Qwen2_5_VLCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new Tn({props:{$$slots:{default:[Cn]},$$scope:{ctx:q}}}),$=new yn({props:{anchor:"transformers.Qwen2_5_VLForConditionalGeneration.forward.example",$$slots:{default:[bn]},$$scope:{ctx:q}}}),Qe=new fn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/qwen2_5_vl.md"}}),{c(){u=l("meta"),_=o(),h=l("p"),w=o(),i(j.$$.fragment),g=o(),i(v.$$.fragment),Xe=o(),L=l("p"),L.innerHTML=St,Fe=o(),A=l("p"),A.textContent=Et,Le=o(),S=l("p"),S.innerHTML=Ht,Ae=o(),i(E.$$.fragment),Se=o(),i(H.$$.fragment),Ee=o(),Y=l("p"),Y.textContent=Yt,He=o(),i(D.$$.fragment),Ye=o(),i(P.$$.fragment),De=o(),O=l("p"),O.textContent=Dt,Pe=o(),i(K.$$.fragment),Oe=o(),i(ee.$$.fragment),Ke=o(),i(te.$$.fragment),et=o(),ne=l("p"),ne.textContent=Pt,tt=o(),i(se.$$.fragment),nt=o(),oe=l("p"),oe.textContent=Ot,st=o(),i(ae.$$.fragment),ot=o(),le=l("p"),le.textContent=Kt,at=o(),i(ie.$$.fragment),lt=o(),re=l("p"),re.textContent=en,it=o(),i(de.$$.fragment),rt=o(),i(ce.$$.fragment),dt=o(),pe=l("p"),pe.textContent=tn,ct=o(),i(me.$$.fragment),pt=o(),Me=l("p"),Me.innerHTML=nn,mt=o(),ue=l("p"),ue.innerHTML=sn,Mt=o(),i(ye.$$.fragment),ut=o(),i(he.$$.fragment),yt=o(),f=l("div"),i(Ue.$$.fragment),vt=o(),Ne=l("p"),Ne.innerHTML=on,Qt=o(),Be=l("p"),Be.innerHTML=an,Vt=o(),i(W.$$.fragment),ht=o(),i(ge.$$.fragment),Ut=o(),T=l("div"),i(we.$$.fragment),Nt=o(),Ze=l("p"),Ze.innerHTML=ln,Bt=o(),x=l("div"),i(_e.$$.fragment),Zt=o(),Ge=l("p"),Ge.innerHTML=rn,Gt=o(),k=l("div"),i(Te.$$.fragment),qt=o(),qe=l("p"),qe.innerHTML=dn,Wt=o(),z=l("div"),i(fe.$$.fragment),xt=o(),We=l("p"),We.textContent=cn,gt=o(),i(Je.$$.fragment),wt=o(),J=l("div"),i(Ce.$$.fragment),kt=o(),xe=l("p"),xe.innerHTML=pn,zt=o(),ke=l("p"),ke.innerHTML=mn,Rt=o(),ze=l("div"),i(be.$$.fragment),_t=o(),i(je.$$.fragment),Tt=o(),B=l("div"),i(Ie.$$.fragment),$t=o(),I=l("div"),i(ve.$$.fragment),Xt=o(),Re=l("p"),Re.innerHTML=Mn,Ft=o(),i(R.$$.fragment),Lt=o(),i($.$$.fragment),ft=o(),i(Qe.$$.fragment),Jt=o(),$e=l("p"),this.h()},l(e){const t=_n("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(n),_=a(e),h=r(e,"P",{}),V(h).forEach(n),w=a(e),d(j.$$.fragment,e),g=a(e),d(v.$$.fragment,e),Xe=a(e),L=r(e,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1sqgfxe"&&(L.innerHTML=St),Fe=a(e),A=r(e,"P",{"data-svelte-h":!0}),U(A)!=="svelte-opi4ei"&&(A.textContent=Et),Le=a(e),S=r(e,"P",{"data-svelte-h":!0}),U(S)!=="svelte-dnm3jw"&&(S.innerHTML=Ht),Ae=a(e),d(E.$$.fragment,e),Se=a(e),d(H.$$.fragment,e),Ee=a(e),Y=r(e,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-1r0t8ni"&&(Y.textContent=Yt),He=a(e),d(D.$$.fragment,e),Ye=a(e),d(P.$$.fragment,e),De=a(e),O=r(e,"P",{"data-svelte-h":!0}),U(O)!=="svelte-9fk83r"&&(O.textContent=Dt),Pe=a(e),d(K.$$.fragment,e),Oe=a(e),d(ee.$$.fragment,e),Ke=a(e),d(te.$$.fragment,e),et=a(e),ne=r(e,"P",{"data-svelte-h":!0}),U(ne)!=="svelte-1rlewe6"&&(ne.textContent=Pt),tt=a(e),d(se.$$.fragment,e),nt=a(e),oe=r(e,"P",{"data-svelte-h":!0}),U(oe)!=="svelte-1h7uwi1"&&(oe.textContent=Ot),st=a(e),d(ae.$$.fragment,e),ot=a(e),le=r(e,"P",{"data-svelte-h":!0}),U(le)!=="svelte-7vf2io"&&(le.textContent=Kt),at=a(e),d(ie.$$.fragment,e),lt=a(e),re=r(e,"P",{"data-svelte-h":!0}),U(re)!=="svelte-12fryma"&&(re.textContent=en),it=a(e),d(de.$$.fragment,e),rt=a(e),d(ce.$$.fragment,e),dt=a(e),pe=r(e,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-13kjllm"&&(pe.textContent=tn),ct=a(e),d(me.$$.fragment,e),pt=a(e),Me=r(e,"P",{"data-svelte-h":!0}),U(Me)!=="svelte-1l8vrw1"&&(Me.innerHTML=nn),mt=a(e),ue=r(e,"P",{"data-svelte-h":!0}),U(ue)!=="svelte-1lmbzwv"&&(ue.innerHTML=sn),Mt=a(e),d(ye.$$.fragment,e),ut=a(e),d(he.$$.fragment,e),yt=a(e),f=r(e,"DIV",{class:!0});var Q=V(f);d(Ue.$$.fragment,Q),vt=a(Q),Ne=r(Q,"P",{"data-svelte-h":!0}),U(Ne)!=="svelte-1w0nr0c"&&(Ne.innerHTML=on),Qt=a(Q),Be=r(Q,"P",{"data-svelte-h":!0}),U(Be)!=="svelte-o55m63"&&(Be.innerHTML=an),Vt=a(Q),d(W.$$.fragment,Q),Q.forEach(n),ht=a(e),d(ge.$$.fragment,e),Ut=a(e),T=r(e,"DIV",{class:!0});var C=V(T);d(we.$$.fragment,C),Nt=a(C),Ze=r(C,"P",{"data-svelte-h":!0}),U(Ze)!=="svelte-7vosvd"&&(Ze.innerHTML=ln),Bt=a(C),x=r(C,"DIV",{class:!0});var Ve=V(x);d(_e.$$.fragment,Ve),Zt=a(Ve),Ge=r(Ve,"P",{"data-svelte-h":!0}),U(Ge)!=="svelte-1h49hic"&&(Ge.innerHTML=rn),Ve.forEach(n),Gt=a(C),k=r(C,"DIV",{class:!0});var bt=V(k);d(Te.$$.fragment,bt),qt=a(bt),qe=r(bt,"P",{"data-svelte-h":!0}),U(qe)!=="svelte-46ufki"&&(qe.innerHTML=dn),bt.forEach(n),Wt=a(C),z=r(C,"DIV",{class:!0});var jt=V(z);d(fe.$$.fragment,jt),xt=a(jt),We=r(jt,"P",{"data-svelte-h":!0}),U(We)!=="svelte-z5vbkk"&&(We.textContent=cn),jt.forEach(n),C.forEach(n),gt=a(e),d(Je.$$.fragment,e),wt=a(e),J=r(e,"DIV",{class:!0});var X=V(J);d(Ce.$$.fragment,X),kt=a(X),xe=r(X,"P",{"data-svelte-h":!0}),U(xe)!=="svelte-1u4auw4"&&(xe.innerHTML=pn),zt=a(X),ke=r(X,"P",{"data-svelte-h":!0}),U(ke)!=="svelte-hswkmf"&&(ke.innerHTML=mn),Rt=a(X),ze=r(X,"DIV",{class:!0});var un=V(ze);d(be.$$.fragment,un),un.forEach(n),X.forEach(n),_t=a(e),d(je.$$.fragment,e),Tt=a(e),B=r(e,"DIV",{class:!0});var It=V(B);d(Ie.$$.fragment,It),$t=a(It),I=r(It,"DIV",{class:!0});var F=V(I);d(ve.$$.fragment,F),Xt=a(F),Re=r(F,"P",{"data-svelte-h":!0}),U(Re)!=="svelte-1uxus5f"&&(Re.innerHTML=Mn),Ft=a(F),d(R.$$.fragment,F),Lt=a(F),d($.$$.fragment,F),F.forEach(n),It.forEach(n),ft=a(e),d(Qe.$$.fragment,e),Jt=a(e),$e=r(e,"P",{}),V($e).forEach(n),this.h()},h(){N(u,"name","hf:doc:metadata"),N(u,"content",In),N(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){y(document.head,u),s(e,_,t),s(e,h,t),s(e,w,t),c(j,e,t),s(e,g,t),c(v,e,t),s(e,Xe,t),s(e,L,t),s(e,Fe,t),s(e,A,t),s(e,Le,t),s(e,S,t),s(e,Ae,t),c(E,e,t),s(e,Se,t),c(H,e,t),s(e,Ee,t),s(e,Y,t),s(e,He,t),c(D,e,t),s(e,Ye,t),c(P,e,t),s(e,De,t),s(e,O,t),s(e,Pe,t),c(K,e,t),s(e,Oe,t),c(ee,e,t),s(e,Ke,t),c(te,e,t),s(e,et,t),s(e,ne,t),s(e,tt,t),c(se,e,t),s(e,nt,t),s(e,oe,t),s(e,st,t),c(ae,e,t),s(e,ot,t),s(e,le,t),s(e,at,t),c(ie,e,t),s(e,lt,t),s(e,re,t),s(e,it,t),c(de,e,t),s(e,rt,t),c(ce,e,t),s(e,dt,t),s(e,pe,t),s(e,ct,t),c(me,e,t),s(e,pt,t),s(e,Me,t),s(e,mt,t),s(e,ue,t),s(e,Mt,t),c(ye,e,t),s(e,ut,t),c(he,e,t),s(e,yt,t),s(e,f,t),c(Ue,f,null),y(f,vt),y(f,Ne),y(f,Qt),y(f,Be),y(f,Vt),c(W,f,null),s(e,ht,t),c(ge,e,t),s(e,Ut,t),s(e,T,t),c(we,T,null),y(T,Nt),y(T,Ze),y(T,Bt),y(T,x),c(_e,x,null),y(x,Zt),y(x,Ge),y(T,Gt),y(T,k),c(Te,k,null),y(k,qt),y(k,qe),y(T,Wt),y(T,z),c(fe,z,null),y(z,xt),y(z,We),s(e,gt,t),c(Je,e,t),s(e,wt,t),s(e,J,t),c(Ce,J,null),y(J,kt),y(J,xe),y(J,zt),y(J,ke),y(J,Rt),y(J,ze),c(be,ze,null),s(e,_t,t),c(je,e,t),s(e,Tt,t),s(e,B,t),c(Ie,B,null),y(B,$t),y(B,I),c(ve,I,null),y(I,Xt),y(I,Re),y(I,Ft),c(R,I,null),y(I,Lt),c($,I,null),s(e,ft,t),c(Qe,e,t),s(e,Jt,t),s(e,$e,t),Ct=!0},p(e,[t]){const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),W.$set(Q);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),R.$set(C);const Ve={};t&2&&(Ve.$$scope={dirty:t,ctx:e}),$.$set(Ve)},i(e){Ct||(p(j.$$.fragment,e),p(v.$$.fragment,e),p(E.$$.fragment,e),p(H.$$.fragment,e),p(D.$$.fragment,e),p(P.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(ae.$$.fragment,e),p(ie.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),p(ye.$$.fragment,e),p(he.$$.fragment,e),p(Ue.$$.fragment,e),p(W.$$.fragment,e),p(ge.$$.fragment,e),p(we.$$.fragment,e),p(_e.$$.fragment,e),p(Te.$$.fragment,e),p(fe.$$.fragment,e),p(Je.$$.fragment,e),p(Ce.$$.fragment,e),p(be.$$.fragment,e),p(je.$$.fragment,e),p(Ie.$$.fragment,e),p(ve.$$.fragment,e),p(R.$$.fragment,e),p($.$$.fragment,e),p(Qe.$$.fragment,e),Ct=!0)},o(e){m(j.$$.fragment,e),m(v.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(he.$$.fragment,e),m(Ue.$$.fragment,e),m(W.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),m(_e.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(Ce.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(ve.$$.fragment,e),m(R.$$.fragment,e),m($.$$.fragment,e),m(Qe.$$.fragment,e),Ct=!1},d(e){e&&(n(_),n(h),n(w),n(g),n(Xe),n(L),n(Fe),n(A),n(Le),n(S),n(Ae),n(Se),n(Ee),n(Y),n(He),n(Ye),n(De),n(O),n(Pe),n(Oe),n(Ke),n(et),n(ne),n(tt),n(nt),n(oe),n(st),n(ot),n(le),n(at),n(lt),n(re),n(it),n(rt),n(dt),n(pe),n(ct),n(pt),n(Me),n(mt),n(ue),n(Mt),n(ut),n(yt),n(f),n(ht),n(Ut),n(T),n(gt),n(wt),n(J),n(_t),n(Tt),n(B),n(ft),n(Jt),n($e)),n(u),M(j,e),M(v,e),M(E,e),M(H,e),M(D,e),M(P,e),M(K,e),M(ee,e),M(te,e),M(se,e),M(ae,e),M(ie,e),M(de,e),M(ce,e),M(me,e),M(ye,e),M(he,e),M(Ue),M(W),M(ge,e),M(we),M(_e),M(Te),M(fe),M(Je,e),M(Ce),M(be),M(je,e),M(Ie),M(ve),M(R),M($),M(Qe,e)}}}const In='{"title":"Qwen2.5-VL","local":"qwen25-vl","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media inference","local":"single-media-inference","sections":[],"depth":3},{"title":"Batch Mixed Media Inference","local":"batch-mixed-media-inference","sections":[],"depth":3},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"Image Resolution trade-off","local":"image-resolution-trade-off","sections":[],"depth":4},{"title":"Multiple Image Inputs","local":"multiple-image-inputs","sections":[],"depth":4},{"title":"Flash-Attention 2 to speed up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Qwen2_5_VLConfig","local":"transformers.Qwen2_5_VLConfig","sections":[],"depth":2},{"title":"Qwen2_5_VLProcessor","local":"transformers.Qwen2_5_VLProcessor","sections":[],"depth":2},{"title":"Qwen2_5_VLModel","local":"transformers.Qwen2_5_VLModel","sections":[],"depth":2},{"title":"Qwen2_5_VLForConditionalGeneration","local":"transformers.Qwen2_5_VLForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function vn(q){return Un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends gn{constructor(u){super(),wn(this,u,vn,jn,hn,{})}}export{Wn as component};
